/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.fi.ar.AbstractArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillPlanBaseInfo;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.PriceSourceEnum;
import com.kingdee.eas.fi.arap.util.ArApBaseCalculate;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.DataUtils;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ArApBillBaseInfo
extends AbstractArApBillBaseInfo
implements Serializable {
    private boolean isReqCalculate4Srv = true;
    private static final String LOCK_FIELD = "lockVerifyAmt";
    private static final String LOCKLOCAL_FIELD = "lockVerifyAmtLocal";
    private static final String UNLOCK_FIELD = "lockUnVerifyAmt";
    private static final String UNLOCKLOCAL_FIELD = "lockUnVerifyAmtLocal";

    public ArApBillBaseInfo() {
        this.setIsPriceWithoutTax(true);
        this.setPriceSource(PriceSourceEnum.PriceFromCoreBill);
    }

    protected ArApBillBaseInfo(String pkField) {
        super(pkField);
        this.setPriceSource(PriceSourceEnum.PriceFromCoreBill);
        this.setIsPriceWithoutTax(true);
    }

    public String getLogInfo() {
        String retValue = "";
        retValue = this.isIsInitializeBill() ? EASResource.getString((String)"com.kingdee.eas.fi.ar.ArAllResource", (String)"FieldInit") + this.getNumber() : this.getNumber();
        return retValue;
    }

    public boolean isReqCalculate4Srv() {
        return this.isReqCalculate4Srv;
    }

    public void setReqCalculate4Srv(boolean isReqCalculate4Srv) {
        this.isReqCalculate4Srv = isReqCalculate4Srv;
    }

    public static String[] getRedProp() {
        return new String[]{"amount", "amountLocal", "verifyAmount", "verifyAmountLocal", "unVerifyAmount", "unVerifyAmountLocal", "totalAmount", "totalTax", "totalConfimAmount", "totalConfimAmountLoc"};
    }

    public AbstractObjectCollection getEntries() {
        return (AbstractObjectCollection)this.get("entry");
    }

    public AbstractObjectCollection getPlans() {
        return null;
    }

    public IntEnum getBillTypeEnum() {
        return null;
    }

    public OrgUnitInfo getSaleOrPurOrgUnit() {
        return null;
    }

    public void sumEntry() {
        String[] entryFields = new String[]{"recievePayAmount", "recievePayAmountLocal", "amount", "taxAmount", "unVerifyAmount", "unVerifyAmountLocal", "verifyAmount", "verifyAmountLocal", LOCK_FIELD, LOCKLOCAL_FIELD, UNLOCK_FIELD, UNLOCKLOCAL_FIELD, "amountLocal", "taxAmountLocal"};
        String[] billFields = new String[]{"amount", "amountLocal", "totalAmount", "totalTax", "unVerifyAmount", "unVerifyAmountLocal", "verifyAmount", "verifyAmountLocal", LOCK_FIELD, LOCKLOCAL_FIELD, UNLOCK_FIELD, UNLOCKLOCAL_FIELD, "totalAmountLocal", "totalTaxLocal"};
        HashMap filedsSum = ArApBillHelper.getTotalValue(this.getEntries(), entryFields);
        for (int i = 0; i < entryFields.length; ++i) {
            this.setBigDecimal(billFields[i], (BigDecimal)filedsSum.get(entryFields[i]));
        }
        this.setTotalTaxAmount(this.getAmount());
    }

    public void verifyPlan() {
        this.sumEntry();
        Object[] plans = this.getPlans().toArray();
        Arrays.sort(plans);
        BigDecimal totalVerifyAmt = this.getVerifyAmount();
        BigDecimal totalVerifyAmtLoc = this.getVerifyAmountLocal();
        for (int i = 0; i < plans.length; ++i) {
            boolean isSameSymbol;
            ArApBillPlanBaseInfo planInfo = (ArApBillPlanBaseInfo)plans[i];
            BigDecimal planRecPayAmt = planInfo.getRecievePayAmount() == null ? DataUtils.ZERO : planInfo.getRecievePayAmount();
            BigDecimal planRecPayAmtLoc = planInfo.getRecievePayAmountLocal() == null ? DataUtils.ZERO : planInfo.getRecievePayAmountLocal();
            planInfo.setVerifyAmount(ArApBaseCalculate.ZERO);
            planInfo.setVerifyAmountLocal(ArApBaseCalculate.ZERO);
            boolean bl = isSameSymbol = totalVerifyAmt.multiply(planRecPayAmt).signum() > 0;
            if (isSameSymbol) {
                int flag = totalVerifyAmt.abs().compareTo(planRecPayAmt.abs());
                if (flag > 0) {
                    if (i == plans.length - 1) {
                        planInfo.setVerifyAmount(totalVerifyAmt);
                        planInfo.setVerifyAmountLocal(totalVerifyAmtLoc);
                        totalVerifyAmt = ArApBaseCalculate.ZERO;
                        totalVerifyAmtLoc = ArApBaseCalculate.ZERO;
                        planInfo.setUnVerifyAmount(planRecPayAmt.subtract(planInfo.getVerifyAmount()));
                        planInfo.setUnVerifyAmountLocal(planRecPayAmtLoc.subtract(planInfo.getVerifyAmountLocal()));
                        continue;
                    }
                    planInfo.setVerifyAmount(planRecPayAmt);
                    planInfo.setVerifyAmountLocal(planRecPayAmtLoc);
                    totalVerifyAmt = totalVerifyAmt.subtract(planRecPayAmt);
                    totalVerifyAmtLoc = totalVerifyAmtLoc.subtract(planRecPayAmtLoc);
                    planInfo.setUnVerifyAmount(planRecPayAmt.subtract(planInfo.getVerifyAmount()));
                    planInfo.setUnVerifyAmountLocal(planRecPayAmtLoc.subtract(planInfo.getVerifyAmountLocal()));
                    continue;
                }
                planInfo.setVerifyAmount(totalVerifyAmt);
                planInfo.setVerifyAmountLocal(totalVerifyAmtLoc);
                planInfo.setUnVerifyAmount(planRecPayAmt.subtract(planInfo.getVerifyAmount()));
                planInfo.setUnVerifyAmountLocal(planRecPayAmtLoc.subtract(planInfo.getVerifyAmountLocal()));
                totalVerifyAmt = ArApBaseCalculate.ZERO;
                totalVerifyAmtLoc = ArApBaseCalculate.ZERO;
                continue;
            }
            planInfo.setVerifyAmount(totalVerifyAmt);
            planInfo.setVerifyAmountLocal(totalVerifyAmtLoc);
            planInfo.setUnVerifyAmount(planRecPayAmt.subtract(planInfo.getVerifyAmount()));
            planInfo.setUnVerifyAmountLocal(planRecPayAmtLoc.subtract(planInfo.getVerifyAmountLocal()));
            totalVerifyAmt = ArApBaseCalculate.ZERO;
            totalVerifyAmtLoc = ArApBaseCalculate.ZERO;
        }
        this.lockPlans();
    }

    public void lockPlans() {
        this.sumEntry();
        Object[] plans = this.getPlans().toArray();
        Arrays.sort(plans);
        BigDecimal totalLockAmt = this.getBigDecimal(LOCK_FIELD);
        BigDecimal totalLockAmtLoc = this.getBigDecimal(LOCKLOCAL_FIELD);
        for (int i = 0; i < plans.length; ++i) {
            boolean isSameSymbol;
            ArApBillPlanBaseInfo planInfo = (ArApBillPlanBaseInfo)plans[i];
            BigDecimal planRecPayAmt = planInfo.getRecievePayAmount() == null ? DataUtils.ZERO : planInfo.getRecievePayAmount();
            BigDecimal planRecPayAmtLoc = planInfo.getRecievePayAmountLocal() == null ? DataUtils.ZERO : planInfo.getRecievePayAmountLocal();
            planInfo.setLockAmount(ArApBaseCalculate.ZERO);
            planInfo.setLockAmountLoc(ArApBaseCalculate.ZERO);
            boolean bl = isSameSymbol = totalLockAmt.multiply(planRecPayAmt).signum() > 0;
            if (isSameSymbol) {
                int flag = totalLockAmt.abs().compareTo(planRecPayAmt.abs());
                if (flag > 0) {
                    if (i == plans.length - 1) {
                        planInfo.setLockAmount(totalLockAmt);
                        planInfo.setLockAmountLoc(totalLockAmtLoc);
                        totalLockAmt = ArApBaseCalculate.ZERO;
                        totalLockAmtLoc = ArApBaseCalculate.ZERO;
                        planInfo.setUnLockAmount(planRecPayAmt.subtract(planInfo.getLockAmount()));
                        planInfo.setUnLockAmountLoc(planRecPayAmtLoc.subtract(planInfo.getLockAmountLoc()));
                        continue;
                    }
                    planInfo.setLockAmount(planRecPayAmt);
                    planInfo.setLockAmountLoc(planRecPayAmtLoc);
                    totalLockAmt = totalLockAmt.subtract(planRecPayAmt);
                    totalLockAmtLoc = totalLockAmtLoc.subtract(planRecPayAmtLoc);
                    planInfo.setUnLockAmount(planRecPayAmt.subtract(planInfo.getLockAmount()));
                    planInfo.setUnLockAmountLoc(planRecPayAmtLoc.subtract(planInfo.getLockAmountLoc()));
                    continue;
                }
                planInfo.setLockAmount(totalLockAmt);
                planInfo.setLockAmountLoc(totalLockAmtLoc);
                planInfo.setUnLockAmount(planRecPayAmt.subtract(planInfo.getLockAmount()));
                planInfo.setUnLockAmountLoc(planRecPayAmtLoc.subtract(planInfo.getLockAmountLoc()));
                totalLockAmt = ArApBaseCalculate.ZERO;
                totalLockAmtLoc = ArApBaseCalculate.ZERO;
                continue;
            }
            planInfo.setLockAmount(totalLockAmt);
            planInfo.setLockAmountLoc(totalLockAmtLoc);
            planInfo.setUnLockAmount(planRecPayAmt.subtract(planInfo.getLockAmount()));
            planInfo.setUnLockAmountLoc(planRecPayAmtLoc.subtract(planInfo.getLockAmountLoc()));
            totalLockAmt = ArApBaseCalculate.ZERO;
            totalLockAmtLoc = ArApBaseCalculate.ZERO;
        }
    }

    public void sortPlan() {
        Object[] plans = this.getPlans().toArray();
        Arrays.sort(plans);
        this.getPlans().clear();
        for (int i = 0; i < plans.length; ++i) {
            this.getPlans().addObject((IObjectValue)plans[i]);
        }
    }

    public List getEntryFieldValues(String field) {
        ArrayList<String> list = new ArrayList<String>();
        for (ArApBillEntryBaseInfo entryInfo : this.getEntries()) {
            if (entryInfo.get(field) == null) continue;
            list.add(entryInfo.get(field).toString());
        }
        return list;
    }

    public boolean isBotpBill() {
        if (this.isIsTransBill()) {
            return false;
        }
        return this.getSrcEntryType() != null;
    }

    public BOSObjectType getSrcEntryType() {
        if (this.getEntries() == null || this.getEntries().getObject(0) == null) {
            return null;
        }
        ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)this.getEntries().getObject(0);
        if (StringUtils.isEmpty((String)entryInfo.getSourceBillEntryId()) || "/g86mgEJEADgAAqxwKgS/LyRaT8=".equals(entryInfo.getSourceBillEntryId())) {
            return null;
        }
        return BOSUuid.read((String)entryInfo.getSourceBillEntryId()).getType();
    }

    private BOSObjectType getEntryType() {
        if (this.getEntries() == null || this.getEntries().getObject(0) == null) {
            return null;
        }
        ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)this.getEntries().getObject(0);
        return entryInfo.getBOSType();
    }

    public BigDecimal getUnLockAmt() {
        BigDecimal totalUnLockAmt = ArApBaseCalculate.ZERO;
        AbstractObjectCollection entryColl = this.getEntries();
        for (int i = 0; i < entryColl.size(); ++i) {
            ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)entryColl.getObject(i);
            if (entryInfo == null || entryInfo.getLockUnVerifyAmt() == null) continue;
            totalUnLockAmt = totalUnLockAmt.add(entryInfo.getLockUnVerifyAmt());
        }
        return totalUnLockAmt;
    }

    public BigDecimal getLockAmt() {
        BigDecimal totalLockAmt = ArApBaseCalculate.ZERO;
        AbstractObjectCollection entryColl = this.getEntries();
        for (int i = 0; i < entryColl.size(); ++i) {
            ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)entryColl.getObject(i);
            if (entryInfo == null || entryInfo.getLockVerifyAmt() == null) continue;
            totalLockAmt = totalLockAmt.add(entryInfo.getLockVerifyAmt());
        }
        return totalLockAmt;
    }

    public void marshal(Marshaller marshaller) throws IOException {
        super.marshal(marshaller);
        marshaller.writeBoolean(this.isReqCalculate4Srv);
    }

    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        super.unmarshal(unmarshaller);
        this.isReqCalculate4Srv = unmarshaller.readBoolean();
    }

    public DataBaseInfo getAccountCussent() {
        if (!BOSUuid.isValidLength((String)this.getAsstActID())) {
            return null;
        }
        Object objectValue = null;
        BOSUuid id = BOSUuid.read((String)this.getAsstActID());
        BOSObjectType bosType = id.getType();
        objectValue = bosType.toString().equals("BF0C040E") ? new CustomerInfo() : (bosType.toString().equals("37C67DFC") ? new SupplierInfo() : (bosType.toString().equals("80EF7DED") ? new PersonInfo() : new DataBaseDInfo()));
        objectValue.setId(id);
        objectValue.setName(this.getAsstActName(ArApConstants.L1), ArApConstants.L1);
        objectValue.setName(this.getAsstActName(ArApConstants.L2), ArApConstants.L2);
        objectValue.setName(this.getAsstActName(ArApConstants.L3), ArApConstants.L3);
        objectValue.setNumber(this.getAsstActNumber());
        return objectValue;
    }
}

