/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.basedata.assistant.CashDiscountCollection;
import com.kingdee.eas.basedata.assistant.CashDiscountEntryCollection;
import com.kingdee.eas.basedata.assistant.CashDiscountEntryFactory;
import com.kingdee.eas.basedata.assistant.CashDiscountEntryInfo;
import com.kingdee.eas.basedata.assistant.CashDiscountInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICashDiscountEntry;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.IOtherBill;
import com.kingdee.eas.fi.ar.IOtherBillDisposer;
import com.kingdee.eas.fi.ar.IVerificationBillentry;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillentryCollection;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.fi.ar.VerificationBillentryFactory;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.app.service.handler.ArApServiceHandler;
import com.kingdee.eas.fi.arap.util.ArApBaseCalculate;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApBillReverseHelper;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IReceivingDisposer;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import java.math.BigDecimal;
import java.util.Date;

public class OtherBillDisposer
implements IReceivingDisposer,
IOtherBillDisposer {
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    public BigDecimal getCashRebate(IObjectValue info, CashDiscountCollection cdColl, Date billDate, BigDecimal arAmount, String sourceBillId, String sourceBillEntryId) {
        CurrencyInfo currencyInfo;
        OtherBillInfo otherBillInfo = (OtherBillInfo)info;
        if (otherBillInfo == null || otherBillInfo.getCashDiscount() == null || billDate == null || arAmount == null || sourceBillId == null || sourceBillEntryId == null) {
            return null;
        }
        BigDecimal cashDiscount = new BigDecimal("0.00");
        try {
            BigDecimal amount = null;
            OtherBillentryCollection entryCol = otherBillInfo.getEntry();
            if (sourceBillEntryId != null && !"".equals(sourceBillEntryId) && entryCol.containsKey(BOSUuid.read((String)sourceBillEntryId))) {
                amount = entryCol.get(BOSUuid.read((String)sourceBillEntryId)).getRecievePayAmount();
            }
            if (amount == null || arAmount.compareTo(amount) < 0) {
                return null;
            }
            Date otherBillDate = otherBillInfo.getBillDate();
            int ages = ArApBillHelper.getDays(billDate, otherBillDate);
            CashDiscountInfo cashDiscountInfo = otherBillInfo.getCashDiscount();
            if (cashDiscountInfo == null) {
                return null;
            }
            if (cashDiscountInfo != null && cdColl.containsKey((Object)cashDiscountInfo.getId())) {
                cashDiscountInfo = cdColl.get((Object)cashDiscountInfo.getId());
            }
            CashDiscountEntryCollection cashDisEntryCol = cashDiscountInfo.getEntries();
            int size = cashDisEntryCol.size();
            for (int i = 0; i < size; ++i) {
                CashDiscountEntryInfo cashEntryInfo = cashDisEntryCol.get(i);
                if (ages >= cashEntryInfo.getDays()) continue;
                cashDiscount = cashEntryInfo.getDiscount();
                break;
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return null;
        }
        if (cashDiscount == null) {
            return null;
        }
        int precision = 2;
        if (otherBillInfo.getCurrency() != null && (currencyInfo = otherBillInfo.getCurrency()) != null) {
            precision = currencyInfo.getPrecision();
        }
        return arAmount.multiply(ArApBaseCalculate.calRate(cashDiscount, 2)).setScale(precision, 4);
    }

    public void dispose4Delete(Context ctx, ReceivingBillInfo recBillInfo) throws BOSException, EASBizException {
        if (!recBillInfo.isIsInitializeBill() && recBillInfo.isAssoGenByArBill() && !recBillInfo.isIsTransBill()) {
            ArApBillReverseHelper.reverseLockAmt(ctx, (RecPayBillInfo)recBillInfo, BOTBillOperStateEnum.DELETE);
        }
    }

    public void dispose4Audit(Context ctx, ReceivingBillInfo recBillInfo) throws BOSException, EASBizException {
        if (!recBillInfo.isIsInitializeBill() && recBillInfo.isAssoGenByArBill() && !recBillInfo.isIsTransBill() && recBillInfo.getBillStatus() == BillStatusEnum.SUBMIT) {
            ArApBillReverseHelper.reverseLockAmt(ctx, (RecPayBillInfo)recBillInfo, BOTBillOperStateEnum.AUDIT);
        }
    }

    public void dispose4AntiAudit(Context ctx, ReceivingBillInfo recBillInfo) throws BOSException, EASBizException {
    }

    public void dispose4Rec(Context ctx, ReceivingBillInfo recBillInfo) throws BOSException, EASBizException {
        ArApBillFacadeFactory.getLocalInstance((Context)ctx).autoVerify4RecPay2ArAp((CoreBillBaseInfo)recBillInfo);
    }

    public void dispose4CancelRec(Context ctx, ReceivingBillInfo recBillInfo) throws BOSException, EASBizException {
        IVerificationBillentry iVerifyEntryBill = VerificationBillentryFactory.getLocalInstance(ctx);
        if (BigDecimal.ZERO.compareTo(recBillInfo.getVerifiedAmt()) != 0) {
            throw new OtherBillBizException(OtherBillBizException.BILLVERIFIED);
        }
        if (recBillInfo.isAssoGen() && recBillInfo.getSourceBillId() != null && recBillInfo.isIsTransOtherBill()) {
            ArApServiceHandler arapServiceHandler = new ArApServiceHandler();
            arapServiceHandler.writeBackOrderBill(ctx, recBillInfo.getId().toString(), false, false);
            arapServiceHandler.reverseTransOtherBill(ctx, recBillInfo, false);
        }
    }

    public void dispose(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        DisposerActionEnum actionType = action.getActionType();
        if (DisposerActionEnum.REC.equals((Object)actionType)) {
            this.dispose4Rec(ctx, (ReceivingBillInfo)action.getDestBill());
        } else if (DisposerActionEnum.CANCEL_REC.equals((Object)actionType)) {
            this.dispose4CancelRec(ctx, (ReceivingBillInfo)action.getDestBill());
        } else if (DisposerActionEnum.ANTI_AUDIT.equals((Object)actionType)) {
            this.dispose4AntiAudit(ctx, (ReceivingBillInfo)action.getDestBill());
        } else if (DisposerActionEnum.DELETE.equals((Object)actionType)) {
            this.dispose4Delete(ctx, (ReceivingBillInfo)action.getDestBill());
        } else if (DisposerActionEnum.AUDIT.equals((Object)actionType)) {
            this.dispose4Audit(ctx, (ReceivingBillInfo)action.getDestBill());
        }
    }

    public BigDecimal getCashRebate(Date billDate, BigDecimal arAmount, String sourceBillId, String sourceBillEntryId) {
        if (billDate == null || arAmount == null || sourceBillId == null || sourceBillEntryId == null) {
            return null;
        }
        BigDecimal cashDiscount = new BigDecimal("0.00");
        try {
            IOtherBill iOtherBill = OtherBillFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(sourceBillId);
            OtherBillInfo otherBillInfo = iOtherBill.getOtherBillInfo((IObjectPK)pk);
            BigDecimal amount = null;
            OtherBillentryCollection entryCol = otherBillInfo.getEntry();
            for (int i = 0; i < entryCol.size(); ++i) {
                OtherBillentryInfo entryInfo = entryCol.get(i);
                if (!sourceBillEntryId.equals(entryInfo.getId().toString())) continue;
                amount = entryInfo.getRecievePayAmount();
                break;
            }
            if (amount == null || arAmount.compareTo(amount) < 0) {
                return null;
            }
            Date otherBillDate = otherBillInfo.getBillDate();
            int ages = ArApBillHelper.getDays(billDate, otherBillDate);
            CashDiscountInfo cashDiscountInfo = otherBillInfo.getCashDiscount();
            String oql = "where cashDiscount = '" + cashDiscountInfo.getId().toString() + "' order by days asc";
            ICashDiscountEntry iCashDisEntry = CashDiscountEntryFactory.getRemoteInstance();
            CashDiscountEntryCollection cashDisEntryCol = iCashDisEntry.getCashDiscountEntryCollection(oql);
            int size = cashDisEntryCol.size();
            for (int i = 0; i < size; ++i) {
                CashDiscountEntryInfo cashEntryInfo = cashDisEntryCol.get(i);
                if (ages >= cashEntryInfo.getDays()) continue;
                cashDiscount = cashEntryInfo.getDiscount();
                break;
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return null;
        }
        if (cashDiscount == null) {
            return null;
        }
        return arAmount.multiply(ArApBaseCalculate.calRate(cashDiscount, 2));
    }
}

