/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.IncomeConfimBillInfo;
import com.kingdee.eas.fi.ar.IncomeConfimEntryCollection;
import com.kingdee.eas.fi.ar.IncomeConfimEntryInfo;
import com.kingdee.eas.fi.arap.check.ICalculateCheck;
import com.kingdee.eas.fi.arap.check.ICheck;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractIncomeConfirmBillDataImportChecker
implements ICalculateCheck<IncomeConfimBillInfo> {
    protected final Context context;
    private final List<Integer> unPassSeqs = new ArrayList<Integer>();

    public AbstractIncomeConfirmBillDataImportChecker(Context context) {
        this.context = context;
    }

    @Override
    public ICheck prepareMessage(final String template, final Map context) {
        return new ICheck(){

            @Override
            public boolean isErrorType() {
                return false;
            }

            @Override
            public String getMsg() {
                return MessageFormat.format(template, context.get("billNumber"), StringUtils.arrayToString((Object[])AbstractIncomeConfirmBillDataImportChecker.this.unPassSeqs.toArray(), (String)","));
            }
        };
    }

    protected abstract void executeCalculate(IncomeConfimBillInfo var1) throws BOSException, EASBizException;

    @Override
    public final boolean check(IncomeConfimBillInfo billInfo) throws BOSException, EASBizException {
        return this.check(billInfo, (IncomeConfimBillInfo)billInfo.clone());
    }

    private boolean check(IncomeConfimBillInfo origin, IncomeConfimBillInfo copy) throws BOSException, EASBizException {
        this.unPassSeqs.clear();
        this.executeCalculate(copy);
        this.executeCheck(origin.getEntry(), copy.getEntry());
        return this.unPassSeqs.isEmpty();
    }

    private void executeCheck(IncomeConfimEntryCollection originCollection, IncomeConfimEntryCollection copyCollection) {
        for (int i = 0; i < originCollection.size(); ++i) {
            IncomeConfimEntryInfo origin = originCollection.get(i);
            IncomeConfimEntryInfo copy = copyCollection.get(i);
            this.processOriginEntry(origin);
            if (this.checkEntry(origin, copy)) continue;
            this.unPassSeqs.add(origin.getSeq());
        }
    }

    private void processOriginEntry(IncomeConfimEntryInfo origin) {
        origin.setRecievePayAmount(origin.getIncomeConfimAmount());
        origin.setRecievePayAmountLocal(origin.getIncomeConfimAmountLoc());
    }

    protected abstract boolean checkEntry(IncomeConfimEntryInfo var1, IncomeConfimEntryInfo var2);
}

