/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ar.AccountBadDebtException;
import com.kingdee.eas.fi.ar.AccountBadDebtInvEntryInfo;
import com.kingdee.eas.fi.ar.BadAccountFacadeFactory;
import com.kingdee.eas.fi.ar.InitSaleAndSaleInvoice;
import com.kingdee.eas.fi.ar.app.AbstractAccountBadDebtBDFacadeControllerBean;
import com.kingdee.eas.fi.ar.app.util.ArServerUtils;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.arap.app.util.TempTableUtil;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountBadDebtBDFacadeControllerBean
extends AbstractAccountBadDebtBDFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.AccountBadDebtBDFacadeControllerBean");
    private static final BigDecimal ZERO = BigDecimal.ZERO;

    @Override
    protected List _getAccountBadByInv(Context ctx, String sql) throws BOSException, EASBizException {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<AccountBadDebtInvEntryInfo> list = new ArrayList<AccountBadDebtInvEntryInfo>(100);
        InitSaleAndSaleInvoice billType = null;
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                AccountBadDebtInvEntryInfo info = new AccountBadDebtInvEntryInfo();
                billType = InitSaleAndSaleInvoice.getEnum("" + rs.getInt("BILLTYPEENUM"));
                info.setBillTypeEnum(billType);
                info.setInvoiceID(rs.getString("invoiceID"));
                info.setInvoceNumber(rs.getString("number"));
                info.setBilldate(rs.getDate("billDate"));
                info.setCustName(rs.getString("customerName"));
                info.setExchangeRate(rs.getBigDecimal("exchangeRate"));
                info.setCurrencyID(rs.getString("CURRENCYID"));
                info.setCurrencyName(rs.getString("CURRENCYNAME"));
                info.setCustID(rs.getString("COMPANYID"));
                info.setCustName(rs.getString("COMPANYNAME"));
                info.setInvEntryID(rs.getString("INVOICEENTRYID"));
                info.setInvEntrySeq(rs.getString("INVOICEENTRYSEQ"));
                info.setTotalAmounts(rs.getBigDecimal("TOTALAMOUNTS"));
                info.setNonVericateAmt(rs.getBigDecimal("NONVERIFICATEAMT"));
                list.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return list;
    }

    @Override
    protected BigDecimal _getARBalance(Context ctx, int startDays, int endDays, int billType, boolean isRelationGL, String customerID) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        HashMap paramMap = new HashMap();
        paramMap.put("AR_BadDebt_02", company.getId().toString());
        paramMap = ArApParamHelper.getParamHashMap(ctx, paramMap);
        int AR_BadDebt_02 = Integer.valueOf((String)paramMap.get("AR_BadDebt_02"));
        String dateField = AR_BadDebt_02 == 1 ? "otherBill.FBizDate" : "otherBillPlan.FRecievePayDate";
        PeriodInfo startPeriod = ArServerUtils.getArStartPeriod(ctx, company);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String startDate = dateFormat.format(startPeriod.getBeginDate());
        String jtDate = this.getCurentPeriodNextDay(ctx);
        BigDecimal arBalance = new BigDecimal("0.0");
        StringBuffer sql = new StringBuffer("");
        sql.append("SELECT sum(otherBillPlan.FRecievePayAmountLocal - otherBillPlan.FVerifyAmountLocal) as localNonReceived ");
        sql.append(" FROM T_AR_OtherBill otherBill,");
        sql.append(" T_AR_OtherBillPlan otherBillPlan ");
        sql.append(" WHERE otherBill.FID = otherBillPlan.FParentID ");
        sql.append(" AND otherBill.FBillStatus is not null ");
        sql.append(" AND otherBill.FBillStatus = 3 ");
        sql.append(" AND otherBill.FIsBizBill = 0 ");
        sql.append(" AND otherBill.FisNotJoinBadAccount = 0 ");
        if (isRelationGL) {
            sql.append(" AND (otherBill.FFiVouchered = 1 OR otherBill.FBillDate <{" + startDate + "})");
        }
        if (startDays == 0 && endDays == 0) {
            String unPeriodDay = AccountBadDebtBDFacadeControllerBean.getDateAfterDays(ctx, company, 0);
            sql.append(" AND " + dateField + " >= {" + unPeriodDay + "} ");
        } else if (startDays != 0 && endDays != 0) {
            String strStartDate = AccountBadDebtBDFacadeControllerBean.getDateAfterDays(ctx, company, -endDays + 1);
            String strEndDate = AccountBadDebtBDFacadeControllerBean.getDateAfterDays(ctx, company, -startDays + 2).trim();
            sql.append(" AND " + dateField + " >={" + strStartDate + "} AND " + dateField + " < {" + strEndDate + "} ");
        } else if (startDays != 0 && endDays == 0) {
            String strEndDate = AccountBadDebtBDFacadeControllerBean.getDateAfterDays(ctx, company, -startDays + 2);
            sql.append("  AND " + dateField + " < {" + strEndDate + "} ");
        }
        sql.append("  AND otherBill.FBillDate < {" + jtDate + "} ");
        String companyID = CommonServerUtils.getCurrentCompany(ctx).getId().toString();
        sql.append(" AND otherBill.FCompanyID = '" + companyID + "'");
        if (billType == 101) {
            sql.append(" AND otherBill.FBillType = " + billType);
        } else {
            sql.append(" AND otherBill.FBillType != 101");
        }
        if (!"".equals(customerID)) {
            sql.append(" AND otherBill.FAsstActID = '" + customerID + "'");
        }
        Connection con = null;
        Statement ps = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                arBalance = rs.getBigDecimal("localNonReceived");
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, ps, con);
        }
        return arBalance;
    }

    @Override
    protected BigDecimal _getOtherARBalance(Context ctx, int startDays, int endDays) throws BOSException, EASBizException {
        return null;
    }

    private static String getDateAfterDays(Context ctx, CompanyOrgUnitInfo company, int days) throws BOSException, EASBizException {
        String afterDate = null;
        int toDays = 0;
        PeriodInfo currPeriod = ArServerUtils.getArCurrentPeriod(ctx, company);
        GregorianCalendar nowCalendar = new GregorianCalendar();
        nowCalendar.setTime(currPeriod.getEndDate());
        toDays = nowCalendar.get(6);
        nowCalendar.set(6, toDays + days);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        afterDate = dateFormat.format(nowCalendar.getTime());
        return afterDate;
    }

    private static String getDateAfterDays(Context ctx, PeriodInfo currPeriod, int days) throws BOSException, EASBizException {
        if (currPeriod == null) {
            return null;
        }
        String afterDate = null;
        int toDays = 0;
        GregorianCalendar nowCalendar = new GregorianCalendar();
        nowCalendar.setTime(currPeriod.getEndDate());
        toDays = nowCalendar.get(6);
        nowCalendar.set(6, toDays + days);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        afterDate = dateFormat.format(nowCalendar.getTime());
        return afterDate;
    }

    public String getCurentPeriodNextDay(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currCompany = CommonServerUtils.getCurrentCompany(ctx);
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)currCompany);
        Date endDate = BaseDataUtil.upTimestamp(currPeriod.getEndDate());
        if (endDate == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(endDate);
    }

    @Override
    protected IRowSet _getCustomerAnalysis(Context ctx, String companyID, String arOtherParamID, String billDate, boolean isRelationGL) throws BOSException, EASBizException {
        String ALL_ITEM_ID = "00000000-0000-0000-0000-000000000000BC122A7F";
        boolean isAllItem = this.isAllItem(ctx, arOtherParamID);
        StringBuffer sql = new StringBuffer("");
        String language = ctx.getLocale().getLanguage();
        sql.append(" select distinct * from \r\n");
        sql.append(" (SELECT  DISTINCT \r\n");
        sql.append(" customer.FID as FCustomerID,\r\n");
        sql.append(" customer.FNumber as FCustomerNumber,\r\n");
        sql.append(" customer.FName_" + language + " as FCustomerName,\r\n");
        sql.append(" 0.0 AS FPrepareAmount,\r\n");
        sql.append(" 0.0 AS FPreReceiveAmount,\r\n");
        sql.append(" 0.0 AS FBadPrepareAmount,\r\n");
        sql.append(" 0.0 AS FPatch,\r\n");
        sql.append(" 0.0 AS FRush,\r\n");
        sql.append(" analysisParam.FAccountAge AS FAccountAge,\r\n");
        sql.append(" analysisParam.FAccountDays AS FAccountDays,\r\n");
        sql.append(" analysisParam.FStartDay AS FStartDay,\r\n");
        sql.append(" analysisParam.FAROtherParamID AS FAROtherParamID,\r\n");
        sql.append(" analysisParam.FEndDay AS FEndDay,\r\n");
        sql.append(" analysisParam.FARAccountJTRate AS FARAccountJTRate,\r\n");
        sql.append(" analysisParam.FCCSPGroupID AS FCCSPGroupID,\r\n");
        sql.append(" analysisParam.FCSSPGroupID AS FCSSPGroupID, \r\n");
        sql.append(" 0.0 AS FReceiveAmount,\r\n");
        sql.append(" analysisParam.FOtherArAccount AS FOtherArAccount,\r\n");
        sql.append(" 0.0 AS FOtherReceiveAmount \r\n");
        sql.append(" FROM T_AR_OtherBill bill \r\n");
        sql.append(" INNER JOIN T_BD_Customer customer \r\n");
        sql.append(" ON bill.FAsstActID = customer.FID \r\n");
        if (isAllItem) {
            sql.append(" INNER JOIN \r\n");
            sql.append(" (SELECT param.FCompanyID as FCompanyID, param.FAROtherParamID as FAROtherParamID, \r\n");
            sql.append(" param.FAccountAge as FAccountAge, param.FAccountDays as FAccountDays, \r\n");
            sql.append(" param.FStartDay as FStartDay, param.FEndDay as FEndDay, \r\n");
            sql.append(" param.FARAccountJTRate as FARAccountJTRate, param.FCCSPGroupID as FCCSPGroupID, \r\n");
            sql.append(" param.FCSSPGroupID as FCSSPGroupID, param.FOtherArAccount as FOtherArAccount, \r\n");
            sql.append(" param.FIsBill as FIsBill,bill.FID as FID \r\n");
            sql.append(" FROM T_AR_OtherBill bill, T_AR_AnalysisParams param WHERE param.FCSSPGroupID ='" + ALL_ITEM_ID + "') as analysisParam \r\n");
            sql.append(" ON bill.FID = analysisParam.FID \r\n");
        } else {
            sql.append(" INNER JOIN T_BD_CustomerGroupDetail  customerGroup \r\n");
            sql.append(" ON customer.fid = customerGroup.FCustomerID \r\n");
            sql.append(" INNER JOIN T_AR_AnalysisParams analysisParam  \r\n");
            sql.append(" ON customerGroup.FCustomerGroupStandardID = analysisParam.FCCSPGroupID \r\n");
            sql.append(" AND customerGroup.FCustomerGroupID = analysisParam.FCSSPGroupID \r\n");
        }
        CompanyOrgUnitInfo company = null;
        PeriodInfo startPeriod = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        sql.append(" WHERE analysisParam.FIsBill = 0 \r\n");
        sql.append(" AND bill.FUnVerifyAmount <> 0 \r\n");
        sql.append(" AND bill.FBillDate < {").append(billDate).append("}\r\n");
        sql.append(" AND bill.FCompanyID = '" + companyID + "'\r\n");
        sql.append(" AND analysisParam.FCompanyID = '" + companyID + "'\r\n");
        sql.append(" AND analysisParam.FAROtherParamID = '" + arOtherParamID + "'\r\n");
        sql.append(" AND bill.FBillStatus = ").append(3);
        sql.append(" AND bill.FIsBizBill = 0");
        if (isRelationGL) {
            company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)companyID));
            startPeriod = ArServerUtils.getArStartPeriod(ctx, company);
            String startDate = dateFormat.format(startPeriod.getBeginDate());
            sql.append(" AND (bill.FFiVouchered = 1 OR bill.FBillDate <{" + startDate + "})");
        }
        sql.append(" union all \r\n");
        sql.append(" SELECT  DISTINCT \r\n");
        sql.append(" customer.FID as FCustomerID,\r\n");
        sql.append(" customer.FNumber as FCustomerNumber,\r\n");
        sql.append(" customer.FName_").append(language).append(" as FCustomerName, \r\n");
        sql.append(" 0.0 AS FPrepareAmount,\r\n");
        sql.append(" 0.0 AS FPreReceiveAmount, \r\n");
        sql.append(" 0.0 AS FBadPrepareAmount,\r\n");
        sql.append(" 0.0 AS FPatch, 0.0 AS FRush, \r\n");
        sql.append(" analysisParam.FAccountAge AS FAccountAge, \r\n");
        sql.append(" analysisParam.FAccountDays AS FAccountDays,\r\n");
        sql.append(" analysisParam.FStartDay AS FStartDay,\r\n");
        sql.append(" analysisParam.FAROtherParamID AS FAROtherParamID, \r\n");
        sql.append(" analysisParam.FEndDay AS FEndDay,\r\n");
        sql.append(" analysisParam.FARAccountJTRate AS FARAccountJTRate, \r\n");
        sql.append(" analysisParam.FCCSPGroupID AS FCCSPGroupID, \r\n");
        sql.append(" analysisParam.FCSSPGroupID AS FCSSPGroupID, \r\n");
        sql.append(" 0.0 AS FReceiveAmount, \r\n");
        sql.append(" analysisParam.FOtherArAccount AS FOtherArAccount, \r\n");
        sql.append(" 0.0 AS FOtherReceiveAmount \r\n");
        sql.append(" FROM T_AR_AccountBadDebtCustPrepare AccountBadDebtCustPrepare \r\n");
        sql.append(" INNER JOIN T_BD_Customer customer  ON AccountBadDebtCustPrepare.FCustomerid = customer.FID \r\n");
        if (isAllItem) {
            sql.append(" INNER JOIN  ( \r\n");
            sql.append(" SELECT param.FCompanyID as FCompanyID, param.FAROtherParamID as FAROtherParamID, \r\n");
            sql.append(" param.FAccountAge as FAccountAge, param.FAccountDays as FAccountDays, \r\n");
            sql.append(" param.FStartDay as FStartDay, param.FEndDay as FEndDay, \r\n");
            sql.append(" param.FARAccountJTRate as FARAccountJTRate, param.FCCSPGroupID as FCCSPGroupID, \r\n");
            sql.append(" param.FCSSPGroupID as FCSSPGroupID, param.FOtherArAccount as FOtherArAccount, \r\n");
            sql.append(" param.FIsBill as FIsBill,AccountBadDebtCustPrepare.FCustomerID as FCustomerID \r\n");
            sql.append(" FROM T_AR_AccountBadDebtCustPrepare AccountBadDebtCustPrepare, T_AR_AnalysisParams param \r\n");
            sql.append(" WHERE param.FCSSPGroupID ='" + ALL_ITEM_ID + "') as analysisParam \r\n");
            sql.append(" ON AccountBadDebtCustPrepare.FCustomerID = analysisParam.FCustomerID \r\n");
        } else {
            sql.append(" INNER JOIN T_BD_CustomerGroupDetail  customerGroup \r\n");
            sql.append(" ON customer.fid = customerGroup.FCustomerID \r\n");
            sql.append(" INNER JOIN T_AR_AnalysisParams analysisParam  \r\n");
            sql.append(" ON customerGroup.FCustomerGroupStandardID = analysisParam.FCCSPGroupID \r\n");
            sql.append(" AND customerGroup.FCustomerGroupID = analysisParam.FCSSPGroupID \r\n");
        }
        sql.append(" WHERE analysisParam.FIsBill = 0 \r\n");
        sql.append(" AND AccountBadDebtCustPrepare.FCompanyID = '" + companyID + "'\r\n");
        sql.append(" AND analysisParam.FCompanyID = '" + companyID + "'\r\n");
        sql.append(" AND analysisParam.FAROtherParamID = '" + arOtherParamID + "'\r\n");
        sql.append(" AND AccountBadDebtCustPrepare.FLASTPREPAREAMOUNT > 0 \r\n");
        sql.append(" )\r\n AS Temp");
        sql.append(" ORDER BY FCustomerNumber,FStartDay,FCCSPGroupID");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private boolean isAllItem(Context ctx, String arOtherParamID) throws BOSException, EASBizException {
        String ALL_ITEM_ID = "00000000-0000-0000-0000-000000000000BC122A7F";
        StringBuffer sql = new StringBuffer("");
        sql.append("select distinct FCSSPGroupID from T_AR_AnalysisParams ");
        sql.append(" where FAROtherParamID ='" + arOtherParamID + "'");
        Connection con = null;
        Statement ps = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String FCSSPGroupID = rs.getString("FCSSPGroupID");
                if (!ALL_ITEM_ID.equals(FCSSPGroupID)) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, ps, con);
        }
        return false;
    }

    @Override
    protected BigDecimal _getBadAcctParepareAmount(Context ctx, String customerID, String currencyID) throws BOSException, EASBizException {
        BigDecimal parepareAmount = new BigDecimal("0.0");
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyID = company.getId().toString();
        StringBuffer sql = new StringBuffer("");
        sql.append(" SELECT  FLastPrepareAmount  FROM T_AR_AccountBadDebtCustPrepare ");
        sql.append(" WHERE FCompanyID = '" + companyID + "' ");
        sql.append(" AND FCustomerID = '" + customerID + "' ");
        sql.append(" AND FCurrencyID = '" + currencyID + "' ");
        Connection con = null;
        Statement ps = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                parepareAmount = rs.getBigDecimal("FLastPrepareAmount");
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, ps, con);
        }
        return parepareAmount;
    }

    @Override
    protected Map _getBadAcctParepareAmount(Context ctx, String[] customerID, String[] currencyID) throws BOSException {
        int i;
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        StringBuffer customerIDSt = new StringBuffer("");
        StringBuffer currencyIDSt = new StringBuffer("");
        for (i = 0; i < customerID.length; ++i) {
            String oneCustomerID = null;
            oneCustomerID = i == customerID.length - 1 ? "'" + customerID[i] + "'" : "'" + customerID[i] + "',";
            customerIDSt.append(oneCustomerID);
        }
        for (i = 0; i < currencyID.length; ++i) {
            String oneCurrencyID = null;
            oneCurrencyID = i == currencyID.length - 1 ? "'" + currencyID[i] + "'" : "'" + currencyID[i] + "',";
            currencyIDSt.append(oneCurrencyID);
        }
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyID = company.getId().toString();
        StringBuffer sql = new StringBuffer("");
        sql.append(" SELECT FCustomerID,FLastPrepareAmount  FROM T_AR_AccountBadDebtCustPrepare ");
        sql.append(" WHERE FCompanyID = '" + companyID + "' ");
        sql.append(" AND FCustomerID in (" + customerIDSt + ") ");
        sql.append(" AND FCurrencyID in (" + currencyIDSt + ") ");
        Connection con = null;
        Statement ps = null;
        IRowSet rs = null;
        try {
            BigDecimal parepareAmount = null;
            String customer = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                parepareAmount = rs.getBigDecimal("FLastPrepareAmount");
                parepareAmount = parepareAmount == null ? SysConstant.BIGZERO : parepareAmount;
                customer = rs.getString("FCustomerID");
                result.put(customer, parepareAmount);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, ps, con);
        return result;
    }

    @Override
    protected BigDecimal _getPreAmount(Context ctx, String customerID, String currencyID, String bizDate, boolean isNeedCheck, boolean isPrepareCurrency, boolean isSaleRec) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyID = company.getId().toString();
        return this.getPreAmount(ctx, customerID, currencyID, bizDate, isNeedCheck, isPrepareCurrency, isSaleRec, companyID);
    }

    protected Map<String, BigDecimal> getPreAmountNew(Context ctx, Set<String> customerIDSet, String currencyID, String bizDate, boolean isNeedCheck, boolean isPrepareCurrency, boolean isSaleRec, String companyID) throws BOSException, SQLAccessException {
        HashMap<String, BigDecimal> prePayAmtMap = new HashMap<String, BigDecimal>();
        String customerIDStr = ArServerUtils.transSet2SqlStr(customerIDSet);
        BigDecimal preAmount = new BigDecimal("0.0");
        String customerId = null;
        StringBuffer sql = new StringBuffer("");
        sql.append(" SELECT ").append("\r\n");
        sql.append(" bill.FPayerID as FcustomerID, ").append("\r\n");
        if (isPrepareCurrency) {
            sql.append(" sum(entry.FUnVcAmount) as FUnVcAmount ").append("\r\n");
        } else {
            sql.append(" sum(entry.FUnVcLocAmount) as FUnVcAmount ").append("\r\n");
        }
        sql.append(" FROM T_CAS_ReceivingBill bill \r\n");
        sql.append(" INNER JOIN T_CAS_ReceivingBillEntry AS entry ").append("\r\n");
        sql.append(" ON bill.FID = entry.FReceivingBillID ").append("\r\n");
        sql.append(" inner join T_CAS_ReceivingBillType rectype \r\n");
        sql.append(" on entry.FRecBillTypeID = rectype.fid ");
        sql.append(" WHERE bill.FSourceType = ").append(100).append("\r\n");
        if (isNeedCheck) {
            sql.append(" AND bill.FFivouchered = 1").append("\r\n");
        } else {
            sql.append(" AND bill.FBillStatus = ").append(14).append("\r\n");
        }
        if (isSaleRec) {
            sql.append(" AND rectype.FISSALEREC = 1 ");
        } else {
            sql.append(" AND rectype.FISPREREC = 1 ");
        }
        sql.append(" AND bill.FCompanyID = '" + companyID + "' ").append("\r\n");
        sql.append(" AND bill.FPayerID in (" + customerIDStr + ") ").append("\r\n");
        if (isPrepareCurrency) {
            sql.append(" AND bill.FCurrencyID = '" + currencyID + "' ").append("\r\n");
        }
        sql.append(" AND bill.FBizDate < {" + bizDate + "} ").append("\r\n");
        sql.append(" GROUP BY bill.FPayerID");
        Connection con = null;
        Statement ps = null;
        IRowSet rs = null;
        String key = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                preAmount = rs.getBigDecimal("FUnVcAmount");
                customerId = rs.getString("FcustomerID");
                key = new StringBuilder(50).append(customerId).append("_").append(companyID).toString();
                prePayAmtMap.put(key, preAmount);
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, ps, con);
        }
        return prePayAmtMap;
    }

    protected BigDecimal getPreAmount(Context ctx, String customerID, String currencyID, String bizDate, boolean isNeedCheck, boolean isPrepareCurrency, boolean isSaleRec, String companyID) throws BOSException, SQLAccessException {
        BigDecimal preAmount = new BigDecimal("0.0");
        StringBuffer sql = new StringBuffer("");
        sql.append(" SELECT ").append("\r\n");
        if (isPrepareCurrency) {
            sql.append(" sum(entry.FUnVcAmount) as FUnVcAmount ").append("\r\n");
        } else {
            sql.append(" sum(entry.FUnVcLocAmount) as FUnVcAmount ").append("\r\n");
        }
        sql.append(" FROM T_CAS_ReceivingBill bill \r\n");
        sql.append(" INNER JOIN T_CAS_ReceivingBillEntry AS entry ").append("\r\n");
        sql.append(" ON bill.FID = entry.FReceivingBillID ").append("\r\n");
        sql.append(" inner join T_CAS_ReceivingBillType rectype \r\n");
        sql.append(" on entry.FRecBillTypeID = rectype.fid ");
        sql.append(" WHERE bill.FSourceType = ").append(100).append("\r\n");
        if (isNeedCheck) {
            sql.append(" AND bill.FFivouchered = 1").append("\r\n");
        } else {
            sql.append(" AND bill.FBillStatus = ").append(14).append("\r\n");
        }
        if (isSaleRec) {
            sql.append(" AND rectype.FISSALEREC = 1 ");
        } else {
            sql.append(" AND rectype.FISPREREC = 1 ");
        }
        sql.append(" AND bill.FCompanyID = '" + companyID + "' ").append("\r\n");
        sql.append(" AND bill.FPayerID = '" + customerID + "' ").append("\r\n");
        if (isPrepareCurrency) {
            sql.append(" AND bill.FCurrencyID = '" + currencyID + "' ").append("\r\n");
        }
        sql.append(" AND bill.FBizDate < {" + bizDate + "} ").append("\r\n");
        Connection con = null;
        Statement ps = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                preAmount = rs.getBigDecimal("FUnVcAmount");
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, ps, con);
        }
        return preAmount;
    }

    @Override
    protected boolean _existCustomerPrepare(Context ctx, String customerID, String currencyID) throws BOSException, EASBizException {
        boolean exist = false;
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyID = company.getId().toString();
        Connection con = null;
        Statement ps = null;
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer("");
        sql.append(" SELECT  FID  FROM T_AR_AccountBadDebtCustPrepare ");
        sql.append(" WHERE FCompanyID = '" + companyID + "' ");
        sql.append(" AND FCustomerID = '" + customerID + "' ");
        sql.append(" AND FCurrencyID = '" + currencyID + "' ");
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                exist = true;
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, ps, con);
        }
        return exist;
    }

    @Override
    protected void _reversePrepareAmount(Context ctx, BigDecimal prepareAmount, String companyID, String customerID, String currencyID, boolean isAdd) throws BOSException, EASBizException {
        Connection con = null;
        PreparedStatement ps = null;
        StringBuffer sqlAdd = new StringBuffer("");
        sqlAdd.append(" update T_AR_AccountBadDebtCustPrepare set FTotalPrepareAmount = FLastPrepareAmount + ?,");
        sqlAdd.append(" FLastPrepareAmount = ? ");
        sqlAdd.append(" where FCompanyID = ? ");
        sqlAdd.append(" and FCustomerID = ? ");
        sqlAdd.append(" and FCurrencyID = ? ");
        StringBuffer sqlDelete = new StringBuffer("");
        sqlDelete.append(" update T_AR_AccountBadDebtCustPrepare set FLastPrepareAmount = FTotalPrepareAmount - ?,");
        sqlDelete.append(" FTotalPrepareAmount = FTotalPrepareAmount - ? ");
        sqlDelete.append(" where FCompanyID = ? ");
        sqlDelete.append(" and FCustomerID = ? ");
        sqlDelete.append(" and FCurrencyID = ?  ");
        try {
            con = this.getConnection(ctx);
            ps = isAdd ? con.prepareStatement(sqlAdd.toString()) : con.prepareStatement(sqlDelete.toString());
            ps.setBigDecimal(1, prepareAmount);
            ps.setBigDecimal(2, prepareAmount);
            ps.setString(3, companyID);
            ps.setString(4, customerID);
            ps.setString(5, currencyID);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    @Override
    protected BigDecimal _getARCustomerBalance(Context ctx, int startDays, int endDays, int billType, boolean isRelationGL, String customerID, String currencyID, boolean isPrepareCurrency) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        PeriodInfo startPeriod = ArServerUtils.getArStartPeriod(ctx, company);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String startDate = dateFormat.format(startPeriod.getBeginDate());
        String jtDate = this.getCurentPeriodNextDay(ctx);
        BigDecimal arBalance = new BigDecimal("0.0");
        StringBuffer sql = new StringBuffer("");
        sql.append("SELECT ").append("\r\n");
        if (isPrepareCurrency) {
            sql.append(" sum(otherBillPlan.FRecievePayAmount - otherBillPlan.FVerifyAmount) as nonReceived ").append("\r\n");
        } else {
            sql.append(" sum(otherBillPlan.FRecievePayAmountLocal - otherBillPlan.FVerifyAmountLocal) as nonReceived ").append("\r\n");
        }
        sql.append(" FROM T_AR_OtherBill otherBill,").append("\r\n");
        sql.append(" T_AR_OtherBillPlan otherBillPlan ").append("\r\n");
        sql.append(" WHERE otherBill.FID = otherBillPlan.FParentID ").append("\r\n");
        sql.append(" AND otherBill.FBillStatus is not null ").append("\r\n");
        sql.append(" AND otherBill.FBillStatus = 3 ").append("\r\n");
        sql.append(" AND otherBill.FIsBizBill = 0 ").append("\r\n");
        if (isRelationGL) {
            sql.append(" AND (otherBill.FFiVouchered = 1 OR otherBill.FBillDate <{" + startDate + "})").append("\r\n");
        }
        if (startDays == 0 && endDays == 0) {
            String unPeriodDay = AccountBadDebtBDFacadeControllerBean.getDateAfterDays(ctx, company, 0);
            sql.append(" AND otherBillPlan.FRecievePayDate >= {" + unPeriodDay + "} ").append("\r\n");
        } else if (startDays != 0 && endDays != 0) {
            String strStartDate = AccountBadDebtBDFacadeControllerBean.getDateAfterDays(ctx, company, -endDays);
            String strEndDate = AccountBadDebtBDFacadeControllerBean.getDateAfterDays(ctx, company, -startDays + 1).trim();
            sql.append(" AND otherBillPlan.FRecievePayDate >={" + strStartDate + "} AND otherBillPlan.FRecievePayDate < {" + strEndDate + "} ").append("\r\n");
        } else if (startDays != 0 && endDays == 0) {
            String strEndDate = AccountBadDebtBDFacadeControllerBean.getDateAfterDays(ctx, company, -startDays);
            sql.append("  AND otherBillPlan.FRecievePayDate < {" + strEndDate + "} ").append("\r\n");
        }
        sql.append("  AND otherBill.FBillDate < {" + jtDate + "} ").append("\r\n");
        String companyID = CommonServerUtils.getCurrentCompany(ctx).getId().toString();
        sql.append(" AND otherBill.FCompanyID = '" + companyID + "'").append("\r\n");
        if (billType == 101) {
            sql.append(" AND otherBill.FBillType = " + billType).append("\r\n");
        } else {
            sql.append(" AND otherBill.FBillType != 101").append("\r\n");
        }
        if (!"".equals(customerID)) {
            sql.append(" AND otherBill.FAsstActID = '" + customerID + "'").append("\r\n");
        }
        if (isPrepareCurrency) {
            sql.append(" AND otherBill.FCurrencyID = '" + currencyID + "'").append("\r\n");
        }
        Connection con = null;
        Statement ps = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                arBalance = rs.getBigDecimal("nonReceived");
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, ps, con);
        }
        return arBalance;
    }

    @Override
    protected boolean _isHasData(Context ctx, String arOtherParamID, int accuralType) throws BOSException, EASBizException {
        boolean hasData = false;
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        return this._isHasDataNew(ctx, arOtherParamID, accuralType, company.getId().toString());
    }

    @Override
    protected boolean _isHasDataNew(Context ctx, String arOtherParamID, int accuralType, String companyId) throws BOSException {
        boolean hasData = false;
        StringBuffer sql = new StringBuffer("");
        sql.append("select fid from ").append("T_AR_AccountBadDebt ");
        sql.append(" where FCompanyID ='").append(companyId).append("'");
        if (arOtherParamID != null) {
            sql.append(" and FAROtherParamID ='").append(arOtherParamID).append("'");
        }
        if (accuralType != 0) {
            sql.append(" and FAccountType =").append(Integer.valueOf(String.valueOf(accuralType)));
        }
        Connection con = null;
        Statement ps = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                hasData = true;
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, ps, con);
        }
        return hasData;
    }

    @Override
    protected IRowSet _getBillAnalysis(Context ctx, String filter, boolean isRelationGL) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        String language = ctx.getLocale().getLanguage();
        String jtDate = this.getCurentPeriodNextDay(ctx);
        sql.append("SELECT OTHERBILL.FID AS FID,\r\n");
        sql.append("OTHERBILL.FNumber AS FNumber,\r\n");
        sql.append("OTHERBILL.FBillStatus AS FBillStatus,\r\n");
        sql.append("OTHERBILL.FBillDate AS FBillDate,\r\n");
        sql.append("OTHERBILL.FBillType AS FSourceBillType,\r\n");
        sql.append("ASSTACTTYPE.FID AS FAsstActTypeID,\r\n");
        sql.append("ASSTACTTYPE.FName_").append(language).append(" AS FAsstActTypeName,\r\n");
        sql.append("OTHERBILL.FAsstActID AS FAsstActID,\r\n");
        sql.append("OTHERBILL.FAsstActNumber AS FAsstActNumber,\r\n");
        sql.append("OTHERBILL.FAsstActName_").append(language).append(" AS FAsstActName,\r\n");
        sql.append("CURRENCY.FID AS FCurrencyID,\r\n");
        sql.append("CURRENCY.FName_").append(language).append(" AS FCurrencyName,\r\n");
        sql.append("ADMINORGUNIT.FID AS FAdminOrgUnitID,\r\n");
        sql.append("ADMINORGUNIT.FName_").append(language).append(" AS FAdminOrgUnitName,\r\n");
        sql.append("SALEORG.FID AS FSaleOrgID,\r\n");
        sql.append("SALEORG.FName_").append(language).append(" AS FSaleOrgName,\r\n");
        sql.append("SALEORG.FNumber AS FSaleOrgNumber,\r\n");
        sql.append("PERSON.FID AS FPersonID,\r\n");
        sql.append("PERSON.FName_").append(language).append(" AS FPersonName,\r\n");
        sql.append("OTHERBILL.FAbstractName AS FAbstractName,\r\n");
        sql.append("OTHERBILL.FFiVouchered AS FFiVouchered,\r\n");
        sql.append("COMPANY.FID AS FCompanyID,\r\n");
        sql.append("COMPANY.FName_").append(language).append(" AS FCompanyName,\r\n");
        sql.append("ENTRY.FID AS FEntryID,\r\n");
        sql.append("ENTRY.FSeq AS Fseq,\r\n");
        sql.append("ENTRY.FRecievePayAmount AS FRecievePayAmount,\r\n");
        sql.append("ENTRY.FRecievePayAmountLocal AS FRecievePayAmountLocal,\r\n");
        sql.append("ENTRY.FVerifyAmount AS FVerifyAmount,\r\n");
        sql.append("ENTRY.FVerifyAmountLocal AS FVerifyAmountLocal,\r\n");
        sql.append("ENTRY.FUnVerifyAmount AS FUnVerifyAmount,\r\n");
        sql.append("ENTRY.FUnVerifyAmountLocal AS FUnVerifyAmountLocal,");
        sql.append("ENTRY.FLockUnVerifyAmt AS FLockUnVerifyAmt,\r\n");
        sql.append("ENTRY.FLockUnVerifyAmtLocal AS FLockUnVerifyAmtLocal,\r\n");
        sql.append("ENTRY.FPreparedBadAmount AS FPreparedBadAmount,\r\n");
        sql.append("ENTRY.FPreparedBadAmountLocal AS FPreparedBadAmountLocal \r\n");
        sql.append("FROM T_AR_OtherBill AS OTHERBILL \r\n");
        sql.append("RIGHT OUTER JOIN T_AR_OtherBillentry AS ENTRY \r\n");
        sql.append("ON OTHERBILL.FID = ENTRY.FParentID \r\n");
        sql.append("LEFT OUTER JOIN T_BD_Person AS PERSON \r\n");
        sql.append("ON OTHERBILL.FPersonId = PERSON.FID \r\n");
        sql.append("LEFT OUTER JOIN T_ORG_Admin AS ADMINORGUNIT \r\n");
        sql.append("ON OTHERBILL.FAdminOrgUnitID = ADMINORGUNIT.FID \r\n");
        sql.append("LEFT OUTER JOIN T_BD_Material AS Material \r\n");
        sql.append("ON ENTRY.FMaterialID = Material.FID \r\n");
        sql.append("LEFT OUTER JOIN T_BC_ExpenseType AS ExpenseType \r\n");
        sql.append("ON ENTRY.FExpenseItemID = ExpenseType.FID \r\n");
        sql.append("LEFT OUTER JOIN T_ORG_Sale AS SALEORG \r\n");
        sql.append("ON OTHERBILL.FSaleOrgID = SALEORG.FID \r\n");
        sql.append("INNER JOIN T_ORG_Company AS COMPANY \r\n");
        sql.append("ON OTHERBILL.FCompanyID = COMPANY.FID \r\n");
        sql.append("INNER JOIN T_BD_AsstActType AS ASSTACTTYPE \r\n");
        sql.append("ON OTHERBILL.FAsstActTypeID = ASSTACTTYPE.FID \r\n");
        sql.append("INNER JOIN T_BD_Currency AS CURRENCY \r\n");
        sql.append("ON OTHERBILL.FCurrencyID = CURRENCY.FID \r\n");
        sql.append(" AND OTHERBILL.FBillStatus = ").append(3);
        sql.append(" AND OTHERBILL.FIsBizBill = 0 ");
        sql.append(" AND OTHERBILL.FisNotJoinBadAccount = 0 ");
        if (isRelationGL) {
            CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
            PeriodInfo startPeriod = ArServerUtils.getArStartPeriod(ctx, company);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String startDate = dateFormat.format(startPeriod.getBeginDate());
            sql.append(" AND (otherBill.FFiVouchered = 1 OR otherBill.FBillDate <{" + startDate + "})");
        }
        sql.append(" AND OTHERBILL.FBillDate <{" + jtDate + "}");
        sql.append(filter);
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _reverseOtherBill(Context ctx, Map billPrepareMap, boolean isPrepareCurrency, String operator) throws BOSException, EASBizException {
        Iterator itr = billPrepareMap.keySet().iterator();
        Connection con = null;
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer("");
        sql.append("update T_AR_OtherBillEntry set ");
        if (isPrepareCurrency) {
            sql.append(" FPreparedBadAmount =  ? ");
        } else {
            sql.append(" FPreparedBadAmountLocal =  ? ");
        }
        sql.append(" WHERE FID = ?");
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sql.toString());
            boolean fMerge = false;
            String billID = null;
            while (itr.hasNext()) {
                billID = itr.next().toString();
                ps.setBigDecimal(1, new BigDecimal(billPrepareMap.get(billID).toString()));
                ps.setString(2, billID);
                fMerge = true;
                ps.addBatch();
            }
            if (fMerge) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    @Override
    protected IRowSet _getCustomerAnalysisDetail(Context ctx, String filter) throws BOSException, EASBizException {
        StringBuffer sql = this.getCustomerAnalysisDetailSql(ctx, filter);
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    @Override
    protected IRowSet _getBillAnalysisDetail(Context ctx, String filter) throws BOSException, EASBizException {
        StringBuffer sql = this.getBillAnalysisDetailSql(ctx, filter);
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private StringBuffer getBillAnalysisDetailSql(Context ctx, String filter) {
        StringBuffer sql = new StringBuffer("");
        String language = ctx.getLocale().getLanguage();
        String[] tempFilter = filter.split(";");
        String conditionFilter = tempFilter[0];
        String commonFilter = null;
        if (tempFilter.length > 1) {
            commonFilter = tempFilter[1];
        }
        sql.append("SELECT * FROM (");
        sql.append("SELECT distinct accountBadDebt.FID AS FID,\r\n");
        sql.append("company.FID AS FcompanyID,\r\n");
        sql.append("company.FName_").append(language).append(" AS FcompanyName,\r\n");
        sql.append("accountBadDebt.FNumber AS FNumber,\r\n");
        sql.append("accountBadDebt.FAccountYear AS FAccountYear,\r\n");
        sql.append("accountBadDebt.FAccountDate AS FAccountDate,\r\n");
        sql.append("accountBadDebt.FAccountType AS FAccountType,\r\n");
        sql.append("accountBadDebt.FAuditorID AS FAuditorID,\r\n");
        sql.append("accountBadDebt.FFivouchered AS FFivouchered,\r\n");
        sql.append("VOUCHERTYPE.FName_l2 AS FVoucherTypeName,\r\n");
        sql.append("VOUCHER.FNumber AS FVoucherNumber,\r\n");
        sql.append("entry.FBillID AS FBillID,\r\n");
        sql.append("entry.FBillNumber AS FBillNumber,\r\n");
        sql.append("entry.FBillStatus AS FBillStatus,\r\n");
        sql.append("entry.FBillDate AS FBillDate,\r\n");
        sql.append("entry.FSourceBillType AS FSourceBillType,\r\n");
        sql.append("entry.FAbstractName FAbstractName,\r\n");
        sql.append("asstActType.FID AS FAsstActTypeID,\r\n");
        sql.append("asstActType.FName_").append(language).append(" AS FAsstActType,\r\n");
        sql.append("entry.FAsstActName_").append(language).append(" AS FAsstActName,\r\n");
        sql.append("currency.FID AS FCurrencyID,\r\n");
        sql.append("currency.FName_").append(language).append(" AS FCurrencyName,\r\n");
        sql.append("entry.FExchangeRate FExchangeRate,\r\n");
        sql.append("adminOrgUnit.FID AS FAdminOrgUnitID,\r\n");
        sql.append("adminOrgUnit.FName_").append(language).append(" AS FAdminOrgUnit,\r\n");
        sql.append("saleOrg.FID AS FSaleOrgID,\r\n");
        sql.append("saleOrg.FName_").append(language).append(" AS FSaleOrg,\r\n");
        sql.append("person.FID AS FPersonID,\r\n");
        sql.append("person.FName_").append(language).append(" AS FPerson,\r\n");
        sql.append("entry.FEntryID AS FEntryID,\r\n");
        sql.append("entry.FEntrySeq AS FEntrySeq,\r\n");
        sql.append("entry.FRecievePayAmount AS FRecievePayAmount,\r\n");
        sql.append("entry.FRecievePayAmountLocal AS FRecievePayAmountLocal,\r\n");
        sql.append("entry.FVerifyAmount AS FVerifyAmount,\r\n");
        sql.append("entry.FVerifyAmountLocal AS FVerifyAmountLocal,\r\n");
        sql.append("entry.FUnVerifyAmount AS FUnVerifyAmount,\r\n");
        sql.append("entry.FUnVerifyAmountLocal AS FUnVerifyAmountLocal,\r\n");
        sql.append("entry.FLockUnVerifyAmt AS FLockUnVerifyAmt,\r\n");
        sql.append("entry.FLockUnVerifyAmtLocal AS FLockUnVerifyAmtLocal,\r\n");
        sql.append("entry.FPreparedBadAmount AS FPreparedBadAmount,\r\n");
        sql.append("entry.FPreparedBadAmountLocal AS FPreparedBadAmountLocal,\r\n");
        sql.append("entry.FPrepareRate AS FPrepareRate,\r\n");
        sql.append("entry.FPrepareAmount AS FPrepareAmount,\r\n");
        sql.append("entry.FPatch AS FPatch,\r\n");
        sql.append("entry.FRush AS  FRush \r\n");
        sql.append("FROM T_AR_accountBadDebt accountBadDebt  \r\n");
        sql.append("INNER JOIN T_AR_AccountBadDebtBillEntry entry \r\n");
        sql.append("ON accountBadDebt.FID = entry.FaccountBadDebtID \r\n");
        sql.append("INNER JOIN T_ORG_company company  \r\n");
        sql.append("ON accountBadDebt.FcompanyID = company.FID  \r\n");
        sql.append("INNER JOIN  T_BD_currency currency \r\n");
        sql.append(" ON entry.FcurrencyID = currency.FID \r\n");
        sql.append("INNER JOIN T_BD_AsstActType AS asstActType \r\n");
        sql.append("ON entry.FAsstActTypeID = asstActType.FID \r\n");
        sql.append("LEFT OUTER JOIN T_ORG_Admin AS adminOrgUnit \r\n");
        sql.append("ON entry.FAdminOrgUnitID = adminOrgUnit.FID \r\n");
        sql.append("LEFT OUTER JOIN T_ORG_Sale AS saleOrg \r\n");
        sql.append("ON entry.FSaleOrgUnitID = saleOrg.FID \r\n");
        sql.append("LEFT OUTER JOIN T_BD_Person AS person \r\n");
        sql.append("ON entry.FPersonId = person.FID \r\n");
        sql.append(" LEFT JOIN  T_BD_VoucherTypes VOUCHERTYPE ON \r\n");
        sql.append(" accountBadDebt.FVoucherTypeID = VOUCHERTYPE.FID \r\n");
        sql.append(" LEFT JOIN  T_GL_Voucher VOUCHER ON \r\n");
        sql.append(" accountBadDebt.FVoucherID = VOUCHER.FID \r\n");
        sql.append(" WHERE 1=1 \r\n");
        if (conditionFilter != null && !"".equals(conditionFilter)) {
            sql.append(" AND " + conditionFilter);
        }
        sql.append(") AS TEMP WHERE 1=1 \r\n");
        if (commonFilter != null && !"".equals(commonFilter)) {
            sql.append(" AND " + commonFilter);
        }
        sql.append(" ORDER BY FNumber,FBillNumber,FEntrySeq \r\n");
        return sql;
    }

    @Override
    protected Map _getCSSPGroup(Context ctx, String CSSPGroupStandardID, String cuFilter) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer("");
        String language = ctx.getLocale().getLanguage();
        sql.append("SELECT CSSPGroup.FID AS FCSSPGroupID,\r\n");
        sql.append("CSSPGroup.FName_" + language + " AS FCSSPGroupName \r\n");
        sql.append(" FROM T_BD_CSSPGroup CSSPGroup \r\n");
        sql.append(" INNER JOIN T_BD_CSSPGroupStandard CSSPGroupStandard \r\n");
        sql.append(" ON CSSPGroup.FCSSPGroupStandardID = CSSPGroupStandard.FID \r\n");
        sql.append(" INNER JOIN T_ORG_CtrlUnit CU \r\n");
        sql.append(" ON CSSPGroup.FControlUnitID = CU.FID \r\n");
        sql.append(" WHERE  1=1 \r\n");
        if (CSSPGroupStandardID != null && !"".equals(CSSPGroupStandardID)) {
            sql.append(" AND CSSPGroup.FCSSPGroupStandardID ='").append(CSSPGroupStandardID).append("'");
        }
        if (cuFilter != null && !"".equals(cuFilter)) {
            sql.append(" AND ").append(cuFilter);
        }
        sql.append(" ORDER BY CSSPGroup.FID ");
        Connection conn = null;
        Statement pstmt = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String CSSPGroupID = rs.getString("FCSSPGroupID");
                String CSSPGroupName = rs.getString("FCSSPGroupName");
                map.put(CSSPGroupID, CSSPGroupName);
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, pstmt, conn);
        }
        return map;
    }

    @Override
    protected IRowSet _existCustomerPrepareInit(Context ctx, String companyID, String currencyID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        sql.append(" SELECT distinct FCustomerID FROM T_AR_AccountBadDebtCustPrepare ");
        sql.append(" WHERE FCompanyID = '" + companyID + "' ");
        sql.append(" AND FCurrencyID = '" + currencyID + "' ");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    @Override
    protected IRowSet _getBadAcctParepareAmountNew(Context ctx, String companyID, String currencyID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        sql.append(" SELECT  FLastPrepareAmount as FParepareAmount,FCustomerID  FROM T_AR_AccountBadDebtCustPrepare ");
        sql.append(" WHERE FCompanyID = '" + companyID + "' ");
        sql.append(" AND FCurrencyID = '" + currencyID + "' ");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    @Override
    protected IRowSet _getPreAmountNew(Context ctx, int startDays, int endDays, String companyID, String currencyID, String bizDate, boolean isNeedCheck, boolean isPrepareCurrency, boolean isSaleRec, String customerID) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyID));
        StringBuffer sql = new StringBuffer("");
        sql.append(" SELECT ");
        if (isPrepareCurrency) {
            sql.append("sum(entry.FUnVcAmount) as FUnVcAmount, ").append("\r\n");
        } else {
            sql.append("sum(entry.FUnVcLocAmount) as FUnVcAmount, ").append("\r\n");
        }
        sql.append(" bill.FPayerID as FCustomerID FROM T_CAS_ReceivingBill bill \r\n");
        sql.append(" INNER JOIN T_CAS_ReceivingBillEntry AS entry ").append("\r\n");
        sql.append(" ON bill.FID = entry.FReceivingBillID ").append("\r\n");
        sql.append(" INNER JOIN T_CAS_ReceivingBillType AS billType ").append("\r\n");
        sql.append(" ON entry.FRecBillTypeID = billType.fid ").append("\r\n");
        sql.append(" WHERE bill.FSourceType = ").append(100).append("\r\n");
        if (isNeedCheck) {
            sql.append(" AND bill.FFivouchered = 1").append("\r\n");
        } else {
            sql.append(" AND bill.FBillStatus = ").append(14).append("\r\n");
        }
        if (isSaleRec) {
            sql.append(" AND (billType.fnumber = '").append(100).append("'\r\n");
            sql.append(" OR billType.fnumber = '").append(102).append("')").append("\r\n");
        } else {
            sql.append(" AND (billType.fnumber = '").append(101).append("'\r\n");
            sql.append(" OR billType.fnumber = '").append(103).append("')").append("\r\n");
        }
        sql.append(" AND bill.FCompanyID = '" + companyID + "' ").append("\r\n");
        if (isPrepareCurrency) {
            sql.append(" AND bill.FCurrencyID = '" + currencyID + "' ").append("\r\n");
        }
        if (startDays == 0 && endDays == 0) {
            String unPeriodDay = AccountBadDebtBDFacadeControllerBean.getDateAfterDays(ctx, company, 0);
            sql.append(" AND bill.FBizDate >= {" + unPeriodDay + "} ").append("\r\n");
        } else if (startDays != 0 && endDays != 0) {
            String strStartDate = AccountBadDebtBDFacadeControllerBean.getDateAfterDays(ctx, company, -endDays);
            String strEndDate = AccountBadDebtBDFacadeControllerBean.getDateAfterDays(ctx, company, -startDays + 1).trim();
            sql.append(" AND bill.FBizDate >={" + strStartDate + "} AND bill.FBizDate < {" + strEndDate + "} ").append("\r\n");
        } else if (startDays != 0 && endDays == 0) {
            String strEndDate = AccountBadDebtBDFacadeControllerBean.getDateAfterDays(ctx, company, -startDays);
            sql.append("  AND bill.FBizDate < {" + strEndDate + "} ").append("\r\n");
        }
        sql.append(" AND bill.FBizDate < {" + bizDate + "} ").append("\r\n");
        sql.append(" AND bill.FPayerID = '").append(customerID).append("' \r\n");
        sql.append(" group by bill.FPayerID, ");
        if (isPrepareCurrency) {
            sql.append(" entry.FUnVcAmount ").append("\r\n");
        } else {
            sql.append(" entry.FUnVcLocAmount ").append("\r\n");
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    protected Map<String, BigDecimal> getARCustomerBalanceBatch(Context ctx, int billType, boolean isRelationGL, String companyID, String currencyID, boolean isPrepareCurrency, Set<String> customerIDSet, String tempTable) throws BOSException, EASBizException {
        HashMap paramMap = new HashMap();
        paramMap.put("AR_BadDebt_02", companyID);
        paramMap = ArApParamHelper.getParamHashMap(ctx, paramMap);
        int AR_BadDebt_02 = Integer.valueOf((String)paramMap.get("AR_BadDebt_02"));
        HashMap<String, BigDecimal> ARCustomerBalanceCache = new HashMap<String, BigDecimal>();
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyID));
        String customerIDStr = ArServerUtils.transSet2SqlStr(customerIDSet);
        PeriodInfo startPeriod = ArServerUtils.getArStartPeriod(ctx, company);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String startDate = dateFormat.format(startPeriod.getBeginDate());
        String jtDate = this.getCurentPeriodNextDay(ctx, company);
        StringBuffer sql = new StringBuffer("");
        sql.append("SELECT ").append("\r\n");
        sql.append(" tempTbl.FStartDay AS startDay,").append("\r\n");
        if (isPrepareCurrency) {
            sql.append(" sum(otherBillPlan.FRecievePayAmount - otherBillPlan.FVerifyAmount) as FNonReceived ").append("\r\n");
        } else {
            sql.append(" sum(otherBillPlan.FRecievePayAmountLocal - otherBillPlan.FVerifyAmountLocal) as FNonReceived ").append("\r\n");
        }
        sql.append(" ,otherBill.FAsstActID as FCustomerID FROM T_AR_OtherBill otherBill,").append("\r\n");
        sql.append(" T_AR_OtherBillPlan otherBillPlan, ").append("\r\n");
        sql.append(" " + tempTable + " tempTbl");
        sql.append(" WHERE otherBill.FID = otherBillPlan.FParentID ").append("\r\n");
        sql.append(" AND otherBill.FCompanyID = tempTbl.fCompanyID ").append("\r\n");
        sql.append(" AND otherBill.FAsstActID = tempTbl.fCustomerID ").append("\r\n");
        sql.append(" AND otherBill.FBillStatus is not null ").append("\r\n");
        sql.append(" AND otherBill.FBillStatus = 3 ").append("\r\n");
        sql.append(" AND otherBill.FisNotJoinBadAccount = 0 ").append("\r\n");
        sql.append(" AND otherBill.FIsBizBill = 0 ").append("\r\n");
        if (isRelationGL) {
            sql.append(" AND (otherBill.FFiVouchered = 1 OR otherBill.FBillDate <{" + startDate + "})").append("\r\n");
        }
        sql.append(" AND otherBill.FAsstActID in (").append(customerIDStr).append(") \r\n");
        if (AR_BadDebt_02 == 1) {
            sql.append(" AND otherBill.FBizDate >= CASE WHEN tempTbl.FStartDate IS null THEN {1753-01-01} ELSE tempTbl.FStartDate END").append("\r\n");
            sql.append(" AND otherBill.FBizDate < CASE WHEN tempTbl.FEndDate IS null THEN {2222-02-22} ELSE tempTbl.FEndDate END").append("\r\n");
        } else {
            sql.append(" AND otherBillPlan.FRecievePayDate >= CASE WHEN tempTbl.FStartDate IS null THEN {1753-01-01} ELSE tempTbl.FStartDate END").append("\r\n");
            sql.append(" AND otherBillPlan.FRecievePayDate < CASE WHEN tempTbl.FEndDate IS null THEN {2222-02-22} ELSE tempTbl.FEndDate END").append("\r\n");
        }
        sql.append(" AND otherBill.FBillDate < {" + jtDate + "} ").append("\r\n");
        sql.append(" AND otherBill.FCompanyID = '" + companyID + "'").append("\r\n");
        if (billType == 101) {
            sql.append(" AND otherBill.FBillType = " + billType).append("\r\n");
        } else {
            sql.append(" AND otherBill.FBillType != 101").append("\r\n");
        }
        if (isPrepareCurrency) {
            sql.append(" AND otherBill.FCurrencyID = '" + currencyID + "'").append("\r\n");
        }
        sql.append(" group by otherBill.FAsstActID,tempTbl.FStartDay ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            String customerId = null;
            int startDay = 0;
            BigDecimal balance = BigDecimal.ZERO;
            String key = null;
            while (rs.next()) {
                customerId = rs.getString("FCustomerID");
                startDay = rs.getInt("startDay");
                balance = rs.getBigDecimal("FNonReceived");
                key = companyID + customerId + startDay;
                ARCustomerBalanceCache.put(key, balance);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ARCustomerBalanceCache;
    }

    @Override
    protected IRowSet _getARCustomerBalanceNew(Context ctx, int startDays, int endDays, int billType, boolean isRelationGL, String companyID, String currencyID, boolean isPrepareCurrency, String customerID) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyID));
        PeriodInfo startPeriod = ArServerUtils.getArStartPeriod(ctx, company);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String startDate = dateFormat.format(startPeriod.getBeginDate());
        String jtDate = this.getCurentPeriodNextDay(ctx, company);
        StringBuffer sql = new StringBuffer("");
        sql.append("SELECT ").append("\r\n");
        if (isPrepareCurrency) {
            sql.append(" sum(otherBillPlan.FRecievePayAmount - otherBillPlan.FVerifyAmount) as FNonReceived ").append("\r\n");
        } else {
            sql.append(" sum(otherBillPlan.FRecievePayAmountLocal - otherBillPlan.FVerifyAmountLocal) as FNonReceived ").append("\r\n");
        }
        sql.append(" ,otherBill.FAsstActID as FCustomerID FROM T_AR_OtherBill otherBill,").append("\r\n");
        sql.append(" T_AR_OtherBillPlan otherBillPlan ").append("\r\n");
        sql.append(" WHERE otherBill.FID = otherBillPlan.FParentID ").append("\r\n");
        sql.append(" AND otherBill.FBillStatus is not null ").append("\r\n");
        sql.append(" AND otherBill.FBillStatus = 3 ").append("\r\n");
        sql.append(" AND otherBill.FisNotJoinBadAccount = 0 ").append("\r\n");
        sql.append(" AND otherBill.FIsBizBill = 0 ").append("\r\n");
        if (isRelationGL) {
            sql.append(" AND (otherBill.FFiVouchered = 1 OR otherBill.FBillDate <{" + startDate + "})").append("\r\n");
        }
        sql.append(" AND otherBill.FAsstActID = '").append(customerID).append("' \r\n");
        if (startDays == 0 && endDays == 0) {
            String unPeriodDay = AccountBadDebtBDFacadeControllerBean.getDateAfterDays(ctx, company, 0);
            sql.append(" AND otherBillPlan.FRecievePayDate >= {" + unPeriodDay + "} ").append("\r\n");
        } else if (startDays != 0 && endDays != 0) {
            String strStartDate = AccountBadDebtBDFacadeControllerBean.getDateAfterDays(ctx, company, -endDays);
            String strEndDate = AccountBadDebtBDFacadeControllerBean.getDateAfterDays(ctx, company, -startDays + 1).trim();
            sql.append(" AND otherBillPlan.FRecievePayDate >={" + strStartDate + "} AND otherBillPlan.FRecievePayDate < {" + strEndDate + "} ").append("\r\n");
        } else if (startDays != 0 && endDays == 0) {
            String strEndDate = AccountBadDebtBDFacadeControllerBean.getDateAfterDays(ctx, company, -startDays + 1);
            sql.append("  AND otherBillPlan.FRecievePayDate < {" + strEndDate + "} ").append("\r\n");
        }
        sql.append("  AND otherBill.FBillDate < {" + jtDate + "} ").append("\r\n");
        sql.append(" AND otherBill.FCompanyID = '" + companyID + "'").append("\r\n");
        if (billType == 101) {
            sql.append(" AND otherBill.FBillType = " + billType).append("\r\n");
        } else {
            sql.append(" AND otherBill.FBillType != 101").append("\r\n");
        }
        if (isPrepareCurrency) {
            sql.append(" AND otherBill.FCurrencyID = '" + currencyID + "'").append("\r\n");
        }
        sql.append(" group by otherBill.FAsstActID ");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    @Override
    protected Map _checkCustomerIsInit(Context ctx, Set companyIdSet, String currencyID) throws BOSException, EASBizException {
        String tmpTable = TempTableUtil.createTempTable(ctx, this.badAccountCustomerTableDefine());
        this.insertDataToTempTable(ctx, companyIdSet, currencyID, tmpTable);
        this.updateStartAndEndDate(ctx, tmpTable);
        TempTablePool t = TempTablePool.getInstance((Context)ctx);
        try {
            t.createIndex(tmpTable, "FCustomerID", false, false);
            t.createIndex(tmpTable, "FCompanyID", false, false);
            t.createIndex(tmpTable, "FAROtherParamID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String companyIdStr = ArServerUtils.transSet2SqlStr(companyIdSet);
        StringBuilder checkSql = new StringBuilder(500);
        checkSql.append("SELECT badCustomer.FCustomerName as FCustomerName FROM ").append(tmpTable).append(" badCustomer");
        checkSql.append(" LEFT OUTER JOIN T_AR_AccountBadDebtCustPrepare");
        checkSql.append(" PREPARE ON PREPARE.FCUSTOMERID = badCustomer.FCustomerID");
        checkSql.append("  and PREPARE.FCOMPANYID  =  badCustomer.FCompanyID ");
        checkSql.append(" WHERE badCustomer.FCompanyID IN (" + companyIdStr + ")");
        checkSql.append(" AND PREPARE.FCUSTOMERID IS NULL");
        IRowSet resultSet = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        StringBuilder customerNameStr = new StringBuilder();
        HashSet<String> customerNameSet = new HashSet<String>();
        try {
            String customerName = null;
            int i = 0;
            while (resultSet.next()) {
                customerName = resultSet.getString("FCustomerName");
                if (customerNameSet.contains(customerName)) continue;
                if (i == 0) {
                    customerNameStr.append(customerName);
                } else {
                    customerNameStr.append(",").append(customerName);
                }
                customerNameSet.add(customerName);
                ++i;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (customerNameStr.length() > 0) {
            throw new AccountBadDebtException(AccountBadDebtException.BAD_ACCOUNT_NOT_INIT, new Object[]{customerNameStr.toString()});
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("tempTable", tmpTable);
        return result;
    }

    private void updateStartAndEndDate(Context ctx, String tempTable) throws BOSException, EASBizException {
        String customerId = null;
        String companyId = null;
        int startDay = 0;
        int endDay = 0;
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        PeriodInfo currPeriod = null;
        HashMap<String, PeriodInfo> currentPeriodCache = new HashMap<String, PeriodInfo>();
        StringBuilder selectSql = new StringBuilder(300);
        selectSql.append(" select FCustomerID,FCompanyID,FStartDay,FEndDay");
        selectSql.append(" from ").append(tempTable);
        selectSql.append(" order by  FCompanyID asc,FCustomerNumber asc,FStartDay desc");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        try {
            while (result.next()) {
                customerId = result.getString("FCustomerID");
                companyId = result.getString("FCompanyID");
                startDay = result.getInt("FStartDay");
                endDay = result.getInt("FEndDay");
                if (currentPeriodCache.get(companyId) != null) {
                    currPeriod = (PeriodInfo)currentPeriodCache.get(companyId);
                } else {
                    company.setId(BOSUuid.read((String)companyId));
                    currPeriod = ArServerUtils.getArCurrentPeriod(ctx, company);
                    currentPeriodCache.put(companyId, currPeriod);
                }
                String strStartDate = null;
                String strEndDate = null;
                if (startDay == 0 && endDay == 0) {
                    strStartDate = AccountBadDebtBDFacadeControllerBean.getDateAfterDays(ctx, currPeriod, 1);
                } else if (startDay != 0 && endDay != 0) {
                    strStartDate = AccountBadDebtBDFacadeControllerBean.getDateAfterDays(ctx, currPeriod, -endDay + 1);
                    strEndDate = AccountBadDebtBDFacadeControllerBean.getDateAfterDays(ctx, currPeriod, -startDay + 1 + 1).trim();
                } else if (startDay != 0 && endDay == 0) {
                    strEndDate = AccountBadDebtBDFacadeControllerBean.getDateAfterDays(ctx, currPeriod, -startDay + 1 + 1);
                }
                Object[] params = new Object[]{strStartDate, strEndDate, customerId, companyId, startDay, endDay};
                paramsList.add(params);
            }
            StringBuffer updateSql = new StringBuffer(300);
            updateSql.append(" UPDATE " + tempTable);
            updateSql.append(" SET FStartDate = to_date(?),FEndDate = to_date(?)");
            updateSql.append(" where FCustomerID = ?");
            updateSql.append("   and FCompanyID = ?");
            updateSql.append("   and FStartDay = ?");
            updateSql.append("   and FEndDay = ?");
            DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), paramsList);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String badAccountCustomerTableDefine() {
        StringBuffer sql = new StringBuffer();
        sql.append(" (FCustomerID varchar(44), ");
        sql.append(" FCustomerNumber varchar(80), ");
        sql.append(" FCustomerName nvarchar(255), ");
        sql.append(" FPrepareAmount decimal(28, 10), ");
        sql.append(" FPreReceiveAmount decimal(28, 10), ");
        sql.append(" FBadPrepareAmount decimal(28, 10), ");
        sql.append(" FPatch decimal(28, 10), ");
        sql.append(" FRush decimal(28, 10), ");
        sql.append(" FAccountAge nvarchar(80), ");
        sql.append(" FAccountDays int, ");
        sql.append(" FStartDay int, ");
        sql.append(" FAROtherParamID varchar(44), ");
        sql.append(" FEndDay int, ");
        sql.append(" FARAccountJTRate NUMERIC(28, 10), ");
        sql.append(" FCCSPGroupID varchar(44), ");
        sql.append(" FCSSPGroupID varchar(44), ");
        sql.append(" FReceiveAmount decimal(28, 10), ");
        sql.append(" FOtherArAccount NUMERIC(17, 4), ");
        sql.append(" FOtherReceiveAmount decimal(28, 10),");
        sql.append(" FSaleRecAmount decimal(28, 10),");
        sql.append(" FOtherSaleRecAmount decimal(28, 10),");
        sql.append(" FEstimateLossSum decimal(28, 10),");
        sql.append(" FPrepareJTAmount decimal(28, 10),");
        sql.append(" FCompanyName nvarchar(255),");
        sql.append(" FCompanyID varchar(44),");
        sql.append(" FStartDate DateTime,");
        sql.append(" FEndDate DateTime)");
        return sql.toString();
    }

    private void insertDataToTempTable(Context ctx, Set companyIdSet, String currencyID, String tempTbl) throws BOSException, EASBizException {
        StringBuilder insertSql = new StringBuilder(1000);
        insertSql.append("insert into ").append(tempTbl).append("(FCustomerID, FCustomerNumber, FCustomerName, FPrepareAmount, FPreReceiveAmount, ").append("FBadPrepareAmount, FPatch, FRush, FAccountAge, FAccountDays, FStartDay, FAROtherParamID, FEndDay, FARAccountJTRate, FCCSPGroupID, ").append("FCSSPGroupID, FReceiveAmount, FOtherArAccount, FOtherReceiveAmount, FSaleRecAmount, FOtherSaleRecAmount, FEstimateLossSum, ").append("FPrepareJTAmount, FCompanyName, FCompanyID) \r\n ");
        Map<String, String> badParamMap = this.getBadParamMap(ctx, companyIdSet);
        ArrayList<String> sqlList = new ArrayList<String>();
        String companyId = null;
        HashSet<String> notSetParamIdSet = new HashSet<String>();
        for (Object compObj : companyIdSet) {
            companyId = compObj.toString();
            String otherParamId = badParamMap.get(companyId);
            if (null == otherParamId) {
                notSetParamIdSet.add(companyId);
                continue;
            }
            String getDataSql = this.getBadAccoutCustomerDataSql(ctx, companyId, otherParamId);
            sqlList.add(insertSql + getDataSql);
        }
        if (notSetParamIdSet.size() > 0) {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", notSetParamIdSet, CompareType.INCLUDE));
            EntityViewInfo entityView = new EntityViewInfo();
            entityView.setFilter(filter);
            entityView.getSelector().add(new SelectorItemInfo("id"));
            entityView.getSelector().add(new SelectorItemInfo("name"));
            CompanyOrgUnitCollection comColl = iCompanyOrgUnit.getCompanyOrgUnitCollection(entityView);
            CompanyOrgUnitInfo company = null;
            if (null != comColl && comColl.size() > 0) {
                int size = comColl.size();
                StringBuilder companyName = new StringBuilder();
                for (int i = 0; i < size; ++i) {
                    company = comColl.get(i);
                    if (i == 0) {
                        companyName.append(company.getName());
                        continue;
                    }
                    companyName.append(",").append(company.getName());
                }
                throw new AccountBadDebtException(AccountBadDebtException.PARAM_NOT_SET, new Object[]{companyName.toString()});
            }
        }
        String[] sql = new String[sqlList.size()];
        sqlList.toArray(sql);
        DBUtil.execute((Context)ctx, (String[])sql);
    }

    private String getBadAccoutCustomerDataSql(Context ctx, String companyID, String arOtherParamID) throws BOSException, EASBizException {
        ISystemStatusCtrol systemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        boolean isRelationGL = systemStatusCtrol.isRelatedAccount(companyID, SystemEnum.ACCOUNTSRECEIVABLE);
        PeriodInfo currentPeriod = systemStatusCtrol.getCacheCurrentPeriod(new Integer(SystemEnum.ACCOUNTSRECEIVABLE.getValue()).intValue(), companyID);
        if (null == currentPeriod) {
            SelectorItemCollection companySelector = new SelectorItemCollection();
            companySelector.add(new SelectorItemInfo("id"));
            companySelector.add(new SelectorItemInfo("name"));
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), companySelector);
            String companyName = company.getName();
            throw new AccountBadDebtException(AccountBadDebtException.COMPANY_PERIOD_NOT_SET, new Object[]{companyName});
        }
        String billDate = this.getJTStrDate(currentPeriod);
        String ALL_ITEM_ID = "00000000-0000-0000-0000-000000000000BC122A7F";
        boolean isAllItem = this.isAllItem(ctx, arOtherParamID);
        StringBuffer sql = new StringBuffer("");
        String language = ctx.getLocale().getLanguage();
        sql.append(" select distinct * from \r\n");
        sql.append(" (SELECT  DISTINCT \r\n");
        sql.append(" customer.FID as FCustomerID,\r\n");
        sql.append(" customer.FNumber as FCustomerNumber,\r\n");
        sql.append(" customer.FName_" + language + " as FCustomerName,\r\n");
        sql.append(" 0.0 AS FPrepareAmount,\r\n");
        sql.append(" 0.0 AS FPreReceiveAmount,\r\n");
        sql.append(" 0.0 AS FBadPrepareAmount,\r\n");
        sql.append(" 0.0 AS FPatch,\r\n");
        sql.append(" 0.0 AS FRush,\r\n");
        sql.append(" analysisParam.FAccountAge AS FAccountAge,\r\n");
        sql.append(" analysisParam.FAccountDays AS FAccountDays,\r\n");
        sql.append(" analysisParam.FStartDay AS FStartDay,\r\n");
        sql.append(" analysisParam.FAROtherParamID AS FAROtherParamID,\r\n");
        sql.append(" analysisParam.FEndDay AS FEndDay,\r\n");
        sql.append(" analysisParam.FARAccountJTRate AS FARAccountJTRate,\r\n");
        sql.append(" analysisParam.FCCSPGroupID AS FCCSPGroupID,\r\n");
        sql.append(" analysisParam.FCSSPGroupID AS FCSSPGroupID,\r\n");
        sql.append(" 0.0 AS FReceiveAmount,\r\n");
        sql.append(" analysisParam.FOtherArAccount AS FOtherArAccount,\r\n");
        sql.append(" 0.0 AS FOtherReceiveAmount,\r\n");
        sql.append(" 0.0 AS FSaleRecAmount,\r\n");
        sql.append(" 0.0 AS FOtherSaleRecAmount,\r\n");
        sql.append(" 0.0 AS FEstimateLossSum,\r\n");
        sql.append(" 0.0 AS FPrepareJTAmount,\r\n");
        sql.append(" company.FName_" + language + " as FCompanyName,\r\n");
        sql.append(" analysisParam.FCompanyID AS FCompanyID \r\n");
        sql.append(" FROM T_AR_OtherBill bill \r\n");
        sql.append(" INNER JOIN T_BD_Customer customer \r\n");
        sql.append(" ON bill.FAsstActID = customer.FID \r\n");
        if (isAllItem) {
            sql.append(" INNER JOIN \r\n");
            sql.append(" (SELECT param.FCompanyID as FCompanyID, param.FAROtherParamID as FAROtherParamID, \r\n");
            sql.append(" param.FAccountAge as FAccountAge, param.FAccountDays as FAccountDays, \r\n");
            sql.append(" param.FStartDay as FStartDay, param.FEndDay as FEndDay, \r\n");
            sql.append(" param.FARAccountJTRate as FARAccountJTRate, param.FCCSPGroupID as FCCSPGroupID, \r\n");
            sql.append(" param.FCSSPGroupID as FCSSPGroupID, param.FOtherArAccount as FOtherArAccount, \r\n");
            sql.append(" param.FIsBill as FIsBill,bill.FID as FID \r\n");
            sql.append(" FROM T_AR_OtherBill bill, T_AR_AnalysisParams param WHERE param.FCSSPGroupID ='" + ALL_ITEM_ID + "') as analysisParam \r\n");
            sql.append(" ON bill.FID = analysisParam.FID \r\n");
        } else {
            sql.append(" INNER JOIN T_BD_CustomerGroupDetail  customerGroup \r\n");
            sql.append(" ON customer.fid = customerGroup.FCustomerID \r\n");
            sql.append(" INNER JOIN T_AR_AnalysisParams analysisParam  \r\n");
            sql.append(" ON customerGroup.FCustomerGroupStandardID = analysisParam.FCCSPGroupID \r\n");
            sql.append(" AND customerGroup.FCustomerGroupID = analysisParam.FCSSPGroupID \r\n");
        }
        sql.append(" INNER JOIN T_ORG_BaseUnit company \r\n");
        sql.append(" ON analysisParam.FCompanyID = company.FID \r\n");
        CompanyOrgUnitInfo company = null;
        PeriodInfo startPeriod = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        sql.append(" WHERE analysisParam.FIsBill = 0 \r\n");
        sql.append(" AND bill.FUnVerifyAmount <> 0 \r\n");
        sql.append(" AND bill.FisNotJoinBadAccount = 0 \r\n");
        sql.append(" AND bill.FBillDate < {").append(billDate).append("}\r\n");
        sql.append(" AND bill.FCompanyID = '" + companyID + "'\r\n");
        sql.append(" AND analysisParam.FCompanyID = '" + companyID + "'\r\n");
        sql.append(" AND analysisParam.FAROtherParamID = '" + arOtherParamID + "'\r\n");
        sql.append(" AND bill.FBillStatus = ").append(3);
        sql.append(" AND bill.FIsBizBill = 0");
        if (isRelationGL) {
            company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)companyID));
            startPeriod = ArServerUtils.getArStartPeriod(ctx, company);
            String startDate = dateFormat.format(startPeriod.getBeginDate());
            sql.append(" AND (bill.FFiVouchered = 1 OR bill.FBillDate <{" + startDate + "})");
        }
        sql.append(" union all \r\n");
        sql.append(" SELECT  DISTINCT \r\n");
        sql.append(" customer.FID as FCustomerID,\r\n");
        sql.append(" customer.FNumber as FCustomerNumber,\r\n");
        sql.append(" customer.FName_").append(language).append(" as FCustomerName, \r\n");
        sql.append(" 0.0 AS FPrepareAmount,\r\n");
        sql.append(" 0.0 AS FPreReceiveAmount, \r\n");
        sql.append(" 0.0 AS FBadPrepareAmount,\r\n");
        sql.append(" 0.0 AS FPatch, 0.0 AS FRush, \r\n");
        sql.append(" analysisParam.FAccountAge AS FAccountAge, \r\n");
        sql.append(" analysisParam.FAccountDays AS FAccountDays,\r\n");
        sql.append(" analysisParam.FStartDay AS FStartDay,\r\n");
        sql.append(" analysisParam.FAROtherParamID AS FAROtherParamID, \r\n");
        sql.append(" analysisParam.FEndDay AS FEndDay,\r\n");
        sql.append(" analysisParam.FARAccountJTRate AS FARAccountJTRate, \r\n");
        sql.append(" analysisParam.FCCSPGroupID AS FCCSPGroupID, \r\n");
        sql.append(" analysisParam.FCSSPGroupID AS FCSSPGroupID, \r\n");
        sql.append(" 0.0 AS FReceiveAmount, \r\n");
        sql.append(" analysisParam.FOtherArAccount AS FOtherArAccount, \r\n");
        sql.append(" 0.0 AS FOtherReceiveAmount,\r\n");
        sql.append(" 0.0 AS FSaleRecAmount,\r\n");
        sql.append(" 0.0 AS FOtherSaleRecAmount,\r\n");
        sql.append(" 0.0 AS FEstimateLossSum,\r\n");
        sql.append(" 0.0 AS FPrepareJTAmount,\r\n");
        sql.append(" company.FName_" + language + " as FCompanyName,\r\n");
        sql.append(" analysisParam.FCompanyID AS FCompanyID \r\n");
        sql.append(" FROM T_AR_AccountBadDebtCustPrepare AccountBadDebtCustPrepare \r\n");
        sql.append(" INNER JOIN T_BD_Customer customer  ON AccountBadDebtCustPrepare.FCustomerid = customer.FID \r\n");
        if (isAllItem) {
            sql.append(" INNER JOIN  ( \r\n");
            sql.append(" SELECT param.FCompanyID as FCompanyID, param.FAROtherParamID as FAROtherParamID, \r\n");
            sql.append(" param.FAccountAge as FAccountAge, param.FAccountDays as FAccountDays, \r\n");
            sql.append(" param.FStartDay as FStartDay, param.FEndDay as FEndDay, \r\n");
            sql.append(" param.FARAccountJTRate as FARAccountJTRate, param.FCCSPGroupID as FCCSPGroupID, \r\n");
            sql.append(" param.FCSSPGroupID as FCSSPGroupID, param.FOtherArAccount as FOtherArAccount, \r\n");
            sql.append(" param.FIsBill as FIsBill,AccountBadDebtCustPrepare.FCustomerID as FCustomerID \r\n");
            sql.append(" FROM T_AR_AccountBadDebtCustPrepare AccountBadDebtCustPrepare, T_AR_AnalysisParams param \r\n");
            sql.append(" WHERE param.FCSSPGroupID ='" + ALL_ITEM_ID + "') as analysisParam \r\n");
            sql.append(" ON AccountBadDebtCustPrepare.FCustomerID = analysisParam.FCustomerID \r\n");
        } else {
            sql.append(" INNER JOIN T_BD_CustomerGroupDetail  customerGroup \r\n");
            sql.append(" ON customer.fid = customerGroup.FCustomerID \r\n");
            sql.append(" INNER JOIN T_AR_AnalysisParams analysisParam  \r\n");
            sql.append(" ON customerGroup.FCustomerGroupStandardID = analysisParam.FCCSPGroupID \r\n");
            sql.append(" AND customerGroup.FCustomerGroupID = analysisParam.FCSSPGroupID \r\n");
        }
        sql.append(" INNER JOIN T_ORG_BaseUnit company \r\n");
        sql.append(" ON analysisParam.FCompanyID = company.FID \r\n");
        sql.append(" WHERE analysisParam.FIsBill = 0 \r\n");
        sql.append(" AND AccountBadDebtCustPrepare.FCompanyID = '" + companyID + "'\r\n");
        sql.append(" AND analysisParam.FCompanyID = '" + companyID + "'\r\n");
        sql.append(" AND analysisParam.FAROtherParamID = '" + arOtherParamID + "'\r\n");
        sql.append(" AND AccountBadDebtCustPrepare.FLASTPREPAREAMOUNT > 0 \r\n");
        sql.append(" )\r\n AS Temp");
        sql.append(" ORDER BY FCompanyID,FCustomerNumber,FStartDay,FCSSPGroupID");
        return sql.toString();
    }

    private Map<String, String> getBadParamMap(Context ctx, Set companyIdSet) throws BOSException, EASBizException {
        HashMap<String, String> badParamMap = new HashMap<String, String>();
        if (companyIdSet.isEmpty()) {
            return badParamMap;
        }
        String lang = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuilder idStr = new StringBuilder(100);
        int i = 0;
        for (Object idObj : companyIdSet) {
            if (0 == i) {
                idStr.append("'").append(idObj).append("'");
            } else {
                idStr.append(",").append("'").append(idObj).append("'");
            }
            ++i;
        }
        StringBuilder checkSql = new StringBuilder(1000);
        checkSql.append("SELECT param.fid FParamId ");
        checkSql.append(" ,item.fvalue").append("_").append(lang).append(" as fvalue");
        checkSql.append(" ,item.forgunitid FcompanyId");
        checkSql.append(" FROM t_bas_param param");
        checkSql.append(" LEFT JOIN t_bas_paramitem item ON param.fid = item.fkeyid");
        checkSql.append(" WHERE param.fsubsysid = 'com.kingdee.eas.fi.ar.ar'");
        checkSql.append(" AND param.fnumber = 'arap001'");
        checkSql.append(" AND item.forgunitid IN (" + idStr.toString() + ")");
        IRowSet checkResult = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        HashSet<String> valueSet = new HashSet<String>();
        try {
            String value = null;
            while (checkResult.next()) {
                value = checkResult.getString("fvalue");
                if (StringUtils.isEmpty((String)value)) continue;
                valueSet.add(value);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (valueSet.size() > 1) {
            throw new AccountBadDebtException(AccountBadDebtException.DIFF_BAD_PARAM);
        }
        StringBuilder selectSql = new StringBuilder(1000);
        selectSql.append("SELECT param.fid FParamId ");
        selectSql.append(" ,param.fnumber FNumber");
        selectSql.append(" ,item.fid FParamItemId");
        selectSql.append(" ,item.fvalue").append("_").append(lang).append(" as fvalue");
        selectSql.append(" ,item.forgunitid FcompanyId");
        selectSql.append(" FROM t_bas_param param");
        selectSql.append(" LEFT JOIN t_bas_paramitem item ON param.fid = item.fkeyid");
        selectSql.append(" WHERE param.fsubsysid = 'com.kingdee.eas.fi.ar.ar'");
        selectSql.append(" AND param.fnumber = 'arap003'");
        selectSql.append(" AND item.forgunitid IN (" + idStr.toString() + ")");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        valueSet.clear();
        try {
            String companyId = null;
            String otherParamId = null;
            String value = null;
            while (result.next()) {
                companyId = result.getString("FcompanyId");
                otherParamId = result.getString("FParamItemId");
                value = result.getString("fvalue");
                badParamMap.put(companyId, otherParamId);
                if (StringUtils.isEmpty((String)value)) continue;
                valueSet.add(value);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (valueSet.size() > 1) {
            throw new AccountBadDebtException(AccountBadDebtException.DIFF_BAD_PARAM);
        }
        return badParamMap;
    }

    private String getJTStrDate(PeriodInfo currPeriod) {
        java.util.Date date = this.upDate(this.getJTDate(currPeriod));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(date);
    }

    private java.util.Date getJTDate(PeriodInfo currPeriod) {
        java.util.Date currDate = null;
        if (currPeriod != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(currPeriod.getEndDate());
            currDate = new java.util.Date(calendar.getTime().getTime());
        }
        return currDate;
    }

    public java.util.Date upDate(java.util.Date oldDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(oldDate);
        calendar.add(5, 1);
        java.util.Date dateUp = new java.util.Date(calendar.getTime().getTime());
        return dateUp;
    }

    @Override
    protected Map _calculateBadAccountAmount(Context ctx, Set companyIdSet, String currencyID, String tempTbl) throws BOSException, EASBizException {
        int precision = 0;
        CurrencyInfo currenyInfo = this.getCurrency(currencyID, ctx);
        precision = currenyInfo.getPrecision();
        if (precision == 0) {
            precision = 2;
        }
        boolean isPrepareCurrency = !BadAccountFacadeFactory.getLocalInstance(ctx).isDisplayLocalCurrency();
        HashMap<String, Boolean> isRelateGLCache = new HashMap<String, Boolean>();
        HashMap<String, String> jtStrDateCache = new HashMap<String, String>();
        Map<String, String> companyCurrencyMap = this.getCompanyCurrencyMap(ctx, companyIdSet);
        Map<String, BigDecimal> badAcctPrepAmtMap = this.getBadAcctPrepAmt(ctx, companyIdSet, currencyID, isPrepareCurrency, companyCurrencyMap);
        Map<String, BigDecimal> prePayAmtMap = this.getPrePayAmtMap(ctx, companyIdSet, currencyID, tempTbl, false, isPrepareCurrency, isRelateGLCache, jtStrDateCache);
        Map<String, BigDecimal> recPayAmtMap = this.getPrePayAmtMap(ctx, companyIdSet, currencyID, tempTbl, true, isPrepareCurrency, isRelateGLCache, jtStrDateCache);
        this.calcRacPayBalance(ctx, currencyID, tempTbl, recPayAmtMap, isRelateGLCache, isPrepareCurrency);
        StringBuilder updateBuilder = new StringBuilder(300);
        updateBuilder.append("UPDATE ").append(tempTbl);
        updateBuilder.append(" SET FEstimateLossSum =");
        updateBuilder.append(" \t   (case when FSaleRecAmount > FReceiveAmount then 0");
        updateBuilder.append("     else round((FReceiveAmount - FSaleRecAmount) * (FARAccountJTRate/100), ").append(precision).append(") end");
        updateBuilder.append(" + case when FOtherSaleRecAmount > FOtherReceiveAmount then 0");
        updateBuilder.append("     else round((FOtherReceiveAmount - FOtherSaleRecAmount) * (FOtherArAccount/100), ").append(precision).append(") end )");
        DbUtil.execute((Context)ctx, (String)updateBuilder.toString());
        Map<String, BigDecimal> estimateLossSumMap = this.getEstimateLossSum(ctx, tempTbl);
        this.calculatePatchOrRush(ctx, tempTbl, badAcctPrepAmtMap, prePayAmtMap, estimateLossSumMap);
        HashMap<String, IRowSet> resultMap = new HashMap<String, IRowSet>();
        String resultSql = "select * from " + tempTbl + " order by fcompanyid, fcustomerid , fstartday ";
        IRowSet resultSet = DbUtil.executeQuery((Context)ctx, (String)resultSql);
        resultMap.put("resultSet", resultSet);
        return resultMap;
    }

    private Map<String, BigDecimal> getBadAcctPrepAmt(Context ctx, Set companyIdSet, String currencyID, boolean isPrepareCurrency, Map<String, String> companyCurrencyMap) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> badAcctPrepAmtMap = new HashMap<String, BigDecimal>();
        StringBuilder badPrepAmtSql = new StringBuilder(300);
        for (Object companyIdStr : companyIdSet) {
            if (!isPrepareCurrency && null != companyCurrencyMap.get(companyIdStr.toString())) {
                currencyID = companyCurrencyMap.get(companyIdStr.toString());
            }
            badPrepAmtSql.append(" SELECT  FLastPrepareAmount as FParepareAmount,FCustomerID  FROM T_AR_AccountBadDebtCustPrepare ");
            badPrepAmtSql.append(" WHERE FCompanyID = '" + companyIdStr + "'");
            badPrepAmtSql.append(" AND FCurrencyID = '" + currencyID + "' ");
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)badPrepAmtSql.toString());
            try {
                String customerID = null;
                BigDecimal parepareAmount = null;
                String key = null;
                while (result.next()) {
                    customerID = result.getString("FCustomerID");
                    parepareAmount = result.getBigDecimal("FParepareAmount");
                    key = new StringBuilder(50).append(customerID).append("_").append(companyIdStr).toString();
                    badAcctPrepAmtMap.put(key, parepareAmount);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            badPrepAmtSql.setLength(0);
        }
        return badAcctPrepAmtMap;
    }

    private Map<String, BigDecimal> getPrePayAmtMap(Context ctx, Set companyIdSet, String currencyID, String tempTbl, boolean isSaleRec, boolean isPrepareCurrency, Map<String, Boolean> isRelateGLCache, Map<String, String> jtStrDateCache) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> prePayAmtMap = new HashMap<String, BigDecimal>();
        Map<String, BigDecimal> tempPrePayAmtMap = null;
        StringBuilder selectSql = new StringBuilder(300);
        selectSql.append(" select distinct FCustomerID, FCompanyID");
        selectSql.append(" from ").append(tempTbl);
        selectSql.append(" order by FCompanyID");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        try {
            String customerID = null;
            String companyId = null;
            String oldCompanyId = null;
            HashSet<String> customerIdSet = new HashSet<String>();
            HashMap<String, HashSet<String>> companyCustomerIdMap = new HashMap<String, HashSet<String>>();
            String bizDate = null;
            boolean isNeedCheck = false;
            boolean arIsRltdAccunt = false;
            boolean glIsStart = false;
            BigDecimal prePayAmt = ZERO;
            ISystemStatusCtrol systemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
            while (result.next()) {
                customerID = result.getString("FCustomerID");
                companyId = result.getString("FCompanyID");
                if (companyCustomerIdMap.get(companyId) == null) {
                    customerIdSet = new HashSet();
                    customerIdSet.add(customerID);
                    companyCustomerIdMap.put(companyId, customerIdSet);
                    continue;
                }
                ((Set)companyCustomerIdMap.get(companyId)).add(customerID);
            }
            result.beforeFirst();
            while (result.next()) {
                customerID = result.getString("FCustomerID");
                companyId = result.getString("FCompanyID");
                if (!companyId.equals(oldCompanyId)) {
                    customerIdSet = (Set)companyCustomerIdMap.get(companyId);
                    if (null != isRelateGLCache.get(companyId)) {
                        isNeedCheck = isRelateGLCache.get(companyId);
                    } else {
                        arIsRltdAccunt = systemStatusCtrol.isRelatedAccount(companyId, SystemEnum.ACCOUNTSRECEIVABLE);
                        glIsStart = systemStatusCtrol.isStart(SystemEnum.GENERALLEDGER.getValue(), companyId);
                        isNeedCheck = arIsRltdAccunt && glIsStart;
                        isRelateGLCache.put(companyId, isNeedCheck);
                    }
                    if (null != jtStrDateCache.get(companyId)) {
                        bizDate = jtStrDateCache.get(companyId);
                    } else {
                        PeriodInfo currentPeriod = systemStatusCtrol.getCacheCurrentPeriod(SystemEnum.ACCOUNTSRECEIVABLE.getValue(), companyId);
                        bizDate = this.getJTStrDate(currentPeriod);
                        jtStrDateCache.put(companyId, bizDate);
                    }
                    tempPrePayAmtMap = this.getPreAmountNew(ctx, customerIdSet, currencyID, bizDate, isNeedCheck, isPrepareCurrency, isSaleRec, companyId);
                    prePayAmtMap.putAll(tempPrePayAmtMap);
                }
                oldCompanyId = companyId;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return prePayAmtMap;
    }

    private void calcRacPayBalance(Context ctx, String currencyID, String tempTbl, Map<String, BigDecimal> recPayAmtMap, Map<String, Boolean> isRelateGLCache, boolean isPrepareCurrency) throws BOSException, EASBizException {
        ISystemStatusCtrol systemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        StringBuilder selectSql = new StringBuilder(300);
        selectSql.append(" select FCustomerID,FCompanyID,FStartDay,FEndDay,FARAccountJTRate,FOtherArAccount");
        selectSql.append(" from ").append(tempTbl);
        selectSql.append(" order by  FCompanyID asc,FCustomerNumber asc,FStartDay desc");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        try {
            String customerID = null;
            String companyID2 = null;
            int startDay = 0;
            int endDay = 0;
            BigDecimal receiveBalance = null;
            BigDecimal saleRecAmount = ZERO;
            BigDecimal otherReceiveBalance = null;
            BigDecimal otherSaleRecAmount = ZERO;
            BigDecimal totalSaleRecAmount = ZERO;
            boolean isRelationGL = false;
            boolean arIsRltdAccunt = false;
            boolean glIsStart = false;
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            String key = null;
            StringBuilder updateSql = new StringBuilder(500);
            updateSql.append("update ").append(tempTbl);
            updateSql.append(" set FReceiveAmount").append(" = ?,");
            updateSql.append(" FSaleRecAmount").append(" = ?, ");
            updateSql.append(" FOtherReceiveAmount").append(" = ?, ");
            updateSql.append(" FOtherSaleRecAmount").append(" = ?");
            updateSql.append(" where FCustomerID = ?");
            updateSql.append("   and FCompanyID = ?");
            updateSql.append("   and FStartDay = ?");
            updateSql.append("   and FEndDay = ?");
            String oldCustomerID = null;
            String oldCompanyID = null;
            int oldStartDay = 0;
            int oldEndDay = 0;
            ArrayList<Object[]> lastUpdateParamsList = new ArrayList<Object[]>();
            StringBuilder lastUpdateSql = new StringBuilder(500);
            lastUpdateSql.append("update ").append(tempTbl);
            lastUpdateSql.append(" set FOtherSaleRecAmount").append(" = FOtherSaleRecAmount + ?");
            lastUpdateSql.append(" where FCustomerID = ?");
            lastUpdateSql.append("   and FCompanyID = ?");
            lastUpdateSql.append("   and FStartDay = ?");
            lastUpdateSql.append("   and FEndDay = ?");
            HashMap companyIdCustomerIdsMap = new HashMap();
            HashMap<String, BigDecimal> receiveBalanceCache = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> otherReceiveBalanceCache = new HashMap<String, BigDecimal>();
            while (result.next()) {
                customerID = result.getString("FCustomerID");
                companyID2 = result.getString("FCompanyID");
                if (companyIdCustomerIdsMap.get(companyID2) != null) {
                    ((Set)companyIdCustomerIdsMap.get(companyID2)).add(customerID);
                    continue;
                }
                HashSet<String> customerIdSet = new HashSet<String>();
                customerIdSet.add(customerID);
                companyIdCustomerIdsMap.put(companyID2, customerIdSet);
            }
            for (String companyID2 : companyIdCustomerIdsMap.keySet()) {
                HashSet<String> customerIdSet = new HashSet();
                customerIdSet = (Set)companyIdCustomerIdsMap.get(companyID2);
                if (null != isRelateGLCache.get(companyID2)) {
                    isRelationGL = isRelateGLCache.get(companyID2);
                } else {
                    arIsRltdAccunt = systemStatusCtrol.isRelatedAccount(companyID2, SystemEnum.ACCOUNTSRECEIVABLE);
                    glIsStart = systemStatusCtrol.isStart(SystemEnum.GENERALLEDGER.getValue(), companyID2);
                    isRelationGL = arIsRltdAccunt && glIsStart;
                    isRelateGLCache.put(companyID2, isRelationGL);
                }
                Map<String, BigDecimal> receiveBalanceMap = this.getARCustomerBalanceBatch(ctx, 102, isRelationGL, companyID2, currencyID, isPrepareCurrency, customerIdSet, tempTbl);
                receiveBalanceCache.putAll(receiveBalanceMap);
                Map<String, BigDecimal> otherReceiveBalanceMap = this.getARCustomerBalanceBatch(ctx, 101, isRelationGL, companyID2, currencyID, isPrepareCurrency, customerIdSet, tempTbl);
                otherReceiveBalanceCache.putAll(otherReceiveBalanceMap);
            }
            String balanceKey = null;
            result.beforeFirst();
            while (result.next()) {
                Object[] params = new Object[8];
                customerID = result.getString("FCustomerID");
                companyID2 = result.getString("FCompanyID");
                startDay = result.getInt("FStartDay");
                endDay = result.getInt("FEndDay");
                balanceKey = companyID2 + customerID + startDay;
                receiveBalance = ZERO;
                receiveBalance = receiveBalanceCache.get(balanceKey) == null ? ZERO : (BigDecimal)receiveBalanceCache.get(balanceKey);
                key = new StringBuilder(50).append(customerID).append("_").append(companyID2).toString();
                totalSaleRecAmount = ZERO;
                if (null != recPayAmtMap.get(key)) {
                    totalSaleRecAmount = recPayAmtMap.get(key);
                }
                saleRecAmount = totalSaleRecAmount.compareTo(ZERO) > 0 ? (totalSaleRecAmount.compareTo(receiveBalance) >= 0 ? receiveBalance : totalSaleRecAmount) : ZERO;
                totalSaleRecAmount = totalSaleRecAmount.subtract(saleRecAmount);
                otherReceiveBalance = ZERO;
                BigDecimal bigDecimal = otherReceiveBalance = otherReceiveBalanceCache.get(balanceKey) == null ? ZERO : (BigDecimal)otherReceiveBalanceCache.get(balanceKey);
                otherSaleRecAmount = totalSaleRecAmount.compareTo(ZERO) > 0 ? (totalSaleRecAmount.compareTo(otherReceiveBalance) >= 0 ? otherReceiveBalance : totalSaleRecAmount) : ZERO;
                totalSaleRecAmount = totalSaleRecAmount.subtract(otherSaleRecAmount);
                recPayAmtMap.put(key, totalSaleRecAmount);
                params[0] = receiveBalance;
                params[1] = saleRecAmount;
                params[2] = otherReceiveBalance;
                params[3] = otherSaleRecAmount;
                params[4] = customerID;
                params[5] = companyID2;
                params[6] = startDay;
                params[7] = endDay;
                paramsList.add(params);
                if (null != oldCustomerID && !customerID.equals(oldCustomerID)) {
                    Object[] lastUpdateParams = this.getlastUpdateParams(oldCustomerID, oldCompanyID, recPayAmtMap, oldStartDay, oldEndDay);
                    key = new StringBuilder(50).append(oldCustomerID).append("_").append(oldCompanyID).toString();
                    if (null != lastUpdateParams) {
                        lastUpdateParamsList.add(lastUpdateParams);
                    }
                }
                oldCustomerID = customerID;
                oldCompanyID = companyID2;
                oldStartDay = startDay;
                oldEndDay = endDay;
            }
            Object[] lastUpdateParams = this.getlastUpdateParams(oldCustomerID, oldCompanyID, recPayAmtMap, oldStartDay, oldEndDay);
            if (null != lastUpdateParams) {
                lastUpdateParamsList.add(lastUpdateParams);
            }
            DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), paramsList);
            if (lastUpdateParamsList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)lastUpdateSql.toString(), lastUpdateParamsList);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Object[] getlastUpdateParams(String oldCustomerID, String oldCompanyID, Map<String, BigDecimal> recPayAmtMap, int oldStartDay, int oldEndDay) {
        Object[] lastUpdateParams = null;
        BigDecimal totalSaleRecAmount = BigDecimal.ZERO;
        String key = new StringBuilder(50).append(oldCustomerID).append("_").append(oldCompanyID).toString();
        if (null != recPayAmtMap.get(key)) {
            totalSaleRecAmount = recPayAmtMap.get(key);
        }
        if (totalSaleRecAmount.compareTo(ZERO) > 0) {
            lastUpdateParams = new Object[]{totalSaleRecAmount, oldCustomerID, oldCompanyID, oldStartDay, oldEndDay};
        }
        return lastUpdateParams;
    }

    private Map<String, BigDecimal> getEstimateLossSum(Context ctx, String tempTbl) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> estimateLossSumMap = new HashMap<String, BigDecimal>();
        StringBuilder selectSql = new StringBuilder(300);
        selectSql.append("select sum(FEstimateLossSum) as  FEstimateLossSum, max(FCustomerID) as FCustomerID, max(FCompanyID) as FCompanyID");
        selectSql.append(" from ").append(tempTbl).append(" group by FCustomerID, FCompanyID");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        try {
            String customerID = null;
            String companyId = null;
            BigDecimal estimateLossSum = null;
            String key = null;
            while (result.next()) {
                customerID = result.getString("FCustomerID");
                companyId = result.getString("FCompanyID");
                estimateLossSum = result.getBigDecimal("FEstimateLossSum");
                key = new StringBuilder(50).append(customerID).append("_").append(companyId).toString();
                estimateLossSumMap.put(key, estimateLossSum);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return estimateLossSumMap;
    }

    private void calculatePatchOrRush(Context ctx, String tempTbl, Map<String, BigDecimal> badAcctPrepAmtMap, Map<String, BigDecimal> prePayAmtMap, Map<String, BigDecimal> estimateLossSumMap) throws BOSException, EASBizException {
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update ").append(tempTbl);
        updateSql.append(" set  FPreReceiveAmount = ?,");
        updateSql.append("  FBadPrepareAmount = ?,");
        updateSql.append("  FPrepareJTAmount = ?,");
        updateSql.append("  FPatch = ?,");
        updateSql.append("  FRush = ?");
        updateSql.append(" where FCustomerID = ?");
        updateSql.append("   and FCompanyID = ?");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        String key = null;
        BigDecimal badAcctPrepAmt = ZERO;
        BigDecimal prePayAmt = ZERO;
        BigDecimal estimateLossSum = ZERO;
        BigDecimal actReceiveBalance = ZERO;
        BigDecimal difference = ZERO;
        BigDecimal patch = ZERO;
        BigDecimal rush = ZERO;
        String customerId = null;
        String companyId = null;
        HashMap<String, Boolean> AR_BadDebt_01Map = new HashMap<String, Boolean>();
        for (Map.Entry<String, BigDecimal> entry : badAcctPrepAmtMap.entrySet()) {
            Boolean AR_BadDebt_01;
            key = entry.getKey();
            customerId = key.split("_")[0];
            companyId = key.split("_")[1];
            if (AR_BadDebt_01Map.get(companyId) == null) {
                AR_BadDebt_01 = Boolean.parseBoolean(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(companyId), "AR_BadDebt_01"));
                AR_BadDebt_01Map.put(companyId, AR_BadDebt_01);
            } else {
                AR_BadDebt_01 = (Boolean)AR_BadDebt_01Map.get(companyId);
            }
            badAcctPrepAmt = entry.getValue();
            if (AR_BadDebt_01.booleanValue()) {
                prePayAmt = null == prePayAmtMap.get(key) ? ZERO : prePayAmtMap.get(key);
            }
            if ((actReceiveBalance = (estimateLossSum = null == estimateLossSumMap.get(key) ? ZERO : estimateLossSumMap.get(key)).subtract(prePayAmt)).compareTo(ZERO) < 0) {
                actReceiveBalance = ZERO;
            }
            if ((difference = actReceiveBalance.subtract(badAcctPrepAmt)).compareTo(ZERO) > 0) {
                patch = difference.abs();
                rush = ZERO;
            } else {
                patch = ZERO;
                rush = difference.abs();
            }
            Object[] params = new Object[]{prePayAmt, badAcctPrepAmt, estimateLossSum, patch, rush, customerId, companyId};
            paramsList.add(params);
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), paramsList);
    }

    private CurrencyInfo getCurrency(String ID, Context ctx) throws BOSException, EASBizException {
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(ID);
        CurrencyInfo info = iCurrency.getCurrencyInfo((IObjectPK)pk);
        return info;
    }

    @Override
    protected Map _getBadAcctParepareAmount(Context ctx, String[] customerID, String[] currencyID, Set companyIdset) throws BOSException, EASBizException {
        int i;
        HashMap result = new HashMap();
        StringBuffer customerIDSt = new StringBuffer("");
        StringBuffer currencyIDSt = new StringBuffer("");
        for (i = 0; i < customerID.length; ++i) {
            String oneCustomerID = null;
            oneCustomerID = i == customerID.length - 1 ? "'" + customerID[i] + "'" : "'" + customerID[i] + "',";
            customerIDSt.append(oneCustomerID);
        }
        for (i = 0; i < currencyID.length; ++i) {
            String oneCurrencyID = null;
            oneCurrencyID = i == currencyID.length - 1 ? "'" + currencyID[i] + "'" : "'" + currencyID[i] + "',";
            currencyIDSt.append(oneCurrencyID);
        }
        String companyID = null;
        String customer = null;
        String key = null;
        String name = "";
        ArrayList<Object> values = null;
        String language = ctx.getLocale().getLanguage();
        StringBuffer sqlBuf = new StringBuffer(200);
        StringBuffer buf = new StringBuffer(100);
        for (Object comObj : companyIdset) {
            companyID = comObj.toString();
            sqlBuf.append(" SELECT TAC.FCustomerID, TBC.FNAME_").append(language).append(" FCustomerName, TAC.FCompanyID ,TOC.FNAME_").append(language).append(" FCompanyName, TAC.FLastPrepareAmount ").append(" FROM T_AR_AccountBadDebtCustPrepare TAC ").append(" INNER JOIN T_ORG_COMPANY TOC ON TAC.FCOMPANYID = TOC.FID ").append(" INNER JOIN T_BD_CUSTOMER TBC ON TAC.FCUSTOMERID = TBC.FID ").append(" WHERE TAC.FCompanyID = '" + companyID + "' ").append(" AND TAC.FCustomerID in (" + customerIDSt + ") ").append(" AND TAC.FCurrencyID in (" + currencyIDSt + ") ");
            try {
                BigDecimal parepareAmount = null;
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
                while (rs.next()) {
                    parepareAmount = rs.getBigDecimal("FLastPrepareAmount");
                    parepareAmount = parepareAmount == null ? SysConstant.BIGZERO : parepareAmount;
                    customer = rs.getString("FCustomerID");
                    key = buf.append(companyID).append("_").append(customer).toString();
                    buf.setLength(0);
                    name = buf.append(rs.getString("FCompanyName")).append("_").append(rs.getString("FCustomerName")).toString();
                    buf.setLength(0);
                    values = new ArrayList<Object>(2);
                    values.add(parepareAmount);
                    values.add(name);
                    result.put(key, values);
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
            sqlBuf.setLength(0);
        }
        return result;
    }

    public String getCurentPeriodNextDay(Context ctx, CompanyOrgUnitInfo currCompany) throws BOSException, EASBizException {
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)currCompany);
        Date endDate = BaseDataUtil.upTimestamp(currPeriod.getEndDate());
        if (endDate == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(endDate);
    }

    protected Map<String, String> getCompanyCurrencyMap(Context ctx, Set companyIdSet) throws BOSException {
        HashMap<String, String> conpanyCurrencyMap = new HashMap<String, String>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)companyIdSet, CompareType.INCLUDE));
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.setFilter(filter);
        entityView.getSelector().add(new SelectorItemInfo("id"));
        entityView.getSelector().add(new SelectorItemInfo("baseCurrency.id"));
        CompanyOrgUnitCollection comColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(entityView);
        CompanyOrgUnitInfo company = null;
        String baseCurrencyId = null;
        if (null != comColl && comColl.size() > 0) {
            int size = comColl.size();
            for (int i = 0; i < size; ++i) {
                company = comColl.get(i);
                if (null != company.getBaseCurrency().getId()) {
                    baseCurrencyId = company.getBaseCurrency().getId().toString();
                }
                conpanyCurrencyMap.put(company.getId().toString(), baseCurrencyId);
            }
        }
        return conpanyCurrencyMap;
    }

    private StringBuffer getCustomerAnalysisDetailSql(Context ctx, String filter) {
        StringBuffer sql = new StringBuffer("");
        String language = ctx.getLocale().getLanguage();
        String[] tempFilter = filter.split(";");
        String conditionFilter = tempFilter[0];
        String commonFilter = null;
        if (tempFilter.length > 1) {
            commonFilter = tempFilter[1];
        }
        sql.append("SELECT * FROM (");
        sql.append("SELECT accountBadDebt.FID AS FID,\r\n");
        sql.append("company.FID AS FcompanyID,\r\n");
        sql.append("company.FName_").append(language).append(" AS FcompanyName,\r\n");
        sql.append("accountBadDebt.FNumber AS FNumber,\r\n");
        sql.append("accountBadDebt.FAccountYear AS FAccountYear,\r\n");
        sql.append("accountBadDebt.FAccountDate AS FAccountDate,\r\n");
        sql.append("accountBadDebt.FAccountType AS FAccountType,\r\n");
        sql.append("accountBadDebt.FAuditorID AS FAuditorID,\r\n");
        sql.append("accountBadDebt.FFivouchered AS FFivouchered,\r\n");
        sql.append("VOUCHERTYPE.FName_l2 AS FVoucherTypeName,\r\n");
        sql.append("VOUCHER.FNumber AS FVoucherNumber,\r\n");
        sql.append("currency.FID AS FCurrencyID,\r\n");
        sql.append("currency.FName_").append(language).append(" AS FCurrencyName,\r\n");
        sql.append("customer.FID as FCustomerID,\r\n");
        sql.append("customer.FNumber as FCustomerNumber,\r\n");
        sql.append("customer.FName_").append(language).append(" as FCustomerName,\r\n");
        sql.append("entrys.FID as FEntryID,\r\n");
        sql.append("entry.FCCSPGroupID as FCCSPGroupID,\r\n");
        sql.append("entry.FCSSPGroupID as FCSSPGroupID,\r\n");
        sql.append("entry.FPrepareAmount AS FPrepareAmount,\r\n");
        sql.append("entry.FPreReceiveAmount AS FPreReceiveAmount,\r\n");
        sql.append("entry.FBadPrepareAmount AS FBadPrepareAmount,\r\n");
        sql.append("entry.FPatch AS FPatch,\r\n");
        sql.append("entry.FRush AS FRush,\r\n");
        sql.append("entry.FAccountAge AS FAccountAge,\r\n");
        sql.append("entry.FAccountDays AS FAccountDays,\r\n");
        sql.append("entry.FStartDay AS FStartDay,\r\n");
        sql.append("entry.FEndDay AS FEndDay,\r\n");
        sql.append("entry.FReceiveBalance AS FReceiveBalance,\r\n");
        sql.append("entry.FAccrualRate AS FAccrualRate,\r\n");
        sql.append("entry.FOtherReceiveRate AS FOtherReceiveRate,\r\n");
        sql.append("entry.FOtherReceiveBalance AS FOtherReceiveBalance,\r\n");
        sql.append("entry.FExchangeRate AS FExchangeRate,\r\n");
        sql.append("entry.FSaleRecAmount AS FSaleRecAmount,\r\n");
        sql.append("entry.FOtherSaleRecAmount AS FOtherSaleRecAmount,\r\n");
        sql.append("entry.FEstimateLossSum AS FEstimateLossSum \r\n");
        sql.append(" FROM T_AR_accountBadDebt accountBadDebt \r\n");
        sql.append(" INNER JOIN T_AR_AccountBadDebtCustEntry entry \r\n");
        sql.append(" ON accountBadDebt.FID = entry.FaccountBadDebtID \r\n");
        sql.append(" INNER JOIN T_AR_AccountBadDebtCustEntrys entrys \r\n");
        sql.append(" ON accountBadDebt.FID = entrys.FAccountBadDebtID and entry.fcustomerid = entrys.fcustomerid\r\n");
        sql.append(" INNER JOIN T_BD_Customer customer \r\n");
        sql.append(" ON entry.FCustomerID = customer.FID \r\n");
        sql.append(" INNER JOIN T_ORG_company company \r\n");
        sql.append(" ON accountBadDebt.FcompanyID = company.FID \r\n");
        sql.append(" INNER JOIN  T_BD_currency currency ON \r\n");
        sql.append(" accountBadDebt.FcurrencyID = currency.FID \r\n");
        sql.append(" LEFT JOIN  T_BD_VoucherTypes VOUCHERTYPE ON \r\n");
        sql.append(" accountBadDebt.FVoucherTypeID = VOUCHERTYPE.FID \r\n");
        sql.append(" LEFT JOIN  T_GL_Voucher VOUCHER ON \r\n");
        sql.append(" accountBadDebt.FVoucherID = VOUCHER.FID \r\n");
        sql.append(" WHERE 1=1 \r\n");
        if (conditionFilter != null && !"".equals(conditionFilter)) {
            sql.append(" AND " + conditionFilter);
        }
        sql.append(") AS TEMP WHERE 1=1 \r\n");
        if (commonFilter != null && !"".equals(commonFilter)) {
            sql.append(" AND " + commonFilter);
        }
        sql.append(" ORDER BY FAccountDate desc,FcompanyName,FNumber, FCustomerNumber, FStartDay ");
        return sql;
    }

    private StringBuffer getCustomerAnalysisDetailSqlForReport(Context ctx, String filter) {
        StringBuffer sql = new StringBuffer("");
        String language = ctx.getLocale().getLanguage();
        String[] tempFilter = filter.split(";");
        String conditionFilter = tempFilter[0];
        String commonFilter = null;
        if (tempFilter.length > 1) {
            commonFilter = tempFilter[1];
        }
        sql.append("SELECT * FROM (");
        sql.append("SELECT accountBadDebt.FID AS id,\r\n");
        sql.append("company.FID AS companyID,\r\n");
        sql.append("company.FName_").append(language).append(" AS companyName,\r\n");
        sql.append("accountBadDebt.FNumber AS number,\r\n");
        sql.append("accountBadDebt.FAccountYear AS accountYear,\r\n");
        sql.append("accountBadDebt.FAccountDate AS accountDate,\r\n");
        sql.append("accountBadDebt.FAccountType AS accountTypeDes,\r\n");
        sql.append("case when accountBadDebt.FAuditorID is null then '" + this.getStrResource(ctx, "submited") + "' else '" + this.getStrResource(ctx, "audited") + "' end AS billStatusDes,\r\n");
        sql.append("case when accountBadDebt.FFivouchered = 1 then '" + this.getStrResource(ctx, "vouchered") + "' else '" + this.getStrResource(ctx, "unvouchered") + "' end AS fivouchered,\r\n");
        sql.append("VOUCHERTYPE.FName_l2 AS voucherType,\r\n");
        sql.append("VOUCHER.FNumber AS voucherNumber,\r\n");
        sql.append("currency.FID AS currencyID,\r\n");
        sql.append("currency.FName_").append(language).append(" AS currencyName,\r\n");
        sql.append("customer.FID as customerID,\r\n");
        sql.append("customer.FNumber as customerNumber,\r\n");
        sql.append("customer.FName_").append(language).append(" as customerName,\r\n");
        sql.append("entry.FCCSPGroupID as FCCSPGroupID,\r\n");
        sql.append("entry.FCSSPGroupID as FCSSPGroupID,\r\n");
        sql.append("entry.FPrepareAmount AS prepareAmount,\r\n");
        sql.append("entry.FPreReceiveAmount AS preReceiveAmount,\r\n");
        sql.append("entry.FBadPrepareAmount AS badPrepareAmount,\r\n");
        sql.append("entry.FPatch AS patch,\r\n");
        sql.append("entry.FRush AS rush,\r\n");
        sql.append("entry.FAccountAge AS accountAge,\r\n");
        sql.append("entry.FAccountDays AS accountDays,\r\n");
        sql.append("entry.FStartDay AS FStartDay,\r\n");
        sql.append("entry.FEndDay AS FEndDay,\r\n");
        sql.append("entry.FReceiveBalance AS receiveBalanceAmount,\r\n");
        sql.append("entry.FAccrualRate AS accrualRate,\r\n");
        sql.append("entry.FOtherReceiveRate AS otherReceiveRate,\r\n");
        sql.append("entry.FOtherReceiveBalance AS otherReceiveBalanceAmount,\r\n");
        sql.append("entry.FExchangeRate AS exchangeRate,\r\n");
        sql.append("entry.FSaleRecAmount AS saleRecAmount,\r\n");
        sql.append("entry.FOtherSaleRecAmount AS otherSaleRecAmount,\r\n");
        sql.append("entry.FEstimateLossSum AS estimateLossSum \r\n");
        sql.append(" FROM T_AR_accountBadDebt accountBadDebt \r\n");
        sql.append(" INNER JOIN T_AR_AccountBadDebtCustEntry entry \r\n");
        sql.append(" ON accountBadDebt.FID = entry.FaccountBadDebtID \r\n");
        sql.append(" INNER JOIN T_BD_Customer customer \r\n");
        sql.append(" ON entry.FCustomerID = customer.FID \r\n");
        sql.append(" INNER JOIN T_ORG_company company \r\n");
        sql.append(" ON accountBadDebt.FcompanyID = company.FID \r\n");
        sql.append(" INNER JOIN  T_BD_currency currency ON \r\n");
        sql.append(" accountBadDebt.FcurrencyID = currency.FID \r\n");
        sql.append(" LEFT JOIN  T_BD_VoucherTypes VOUCHERTYPE ON \r\n");
        sql.append(" accountBadDebt.FVoucherTypeID = VOUCHERTYPE.FID \r\n");
        sql.append(" LEFT JOIN  T_GL_Voucher VOUCHER ON \r\n");
        sql.append(" accountBadDebt.FVoucherID = VOUCHER.FID \r\n");
        sql.append(" WHERE 1=1 \r\n");
        if (conditionFilter != null && !"".equals(conditionFilter)) {
            sql.append(" AND " + conditionFilter);
        }
        sql.append(") AS TEMP WHERE 1=1 \r\n");
        if (commonFilter != null && !"".equals(commonFilter)) {
            sql.append(" AND " + commonFilter);
        }
        sql.append(" ORDER BY accountDate desc,companyName,number, customerNumber, FStartDay ");
        return sql;
    }

    private String getStrResource(Context ctx, String resKey) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey, (Locale)ctx.getLocale());
    }

    @Override
    protected IRowSet _getCustomerAnalysisDetail4WEB(Context ctx, Map params) throws BOSException, EASBizException {
        String filter = (String)params.get("filter");
        Boolean isReport = params.get("isReport") == null ? false : (Boolean)params.get("isReport");
        StringBuffer sql = isReport != false ? this.getCustomerAnalysisDetailSqlForReport(ctx, filter) : this.getCustomerAnalysisDetailSql(ctx, filter);
        int startIndex = Integer.parseInt((String)params.get("startIndex"));
        int endIndex = Integer.parseInt((String)params.get("endIndex"));
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (int)(startIndex - 1), (int)(endIndex - (startIndex - 1)));
    }

    @Override
    protected IRowSet _getBillAnalysisDetail4WEB(Context ctx, Map params) throws BOSException, EASBizException {
        String filter = (String)params.get("filter");
        StringBuffer sql = this.getBillAnalysisDetailSql(ctx, filter);
        int startIndex = Integer.parseInt((String)params.get("startIndex"));
        int endIndex = Integer.parseInt((String)params.get("endIndex"));
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (int)(startIndex - 1), (int)(endIndex - (startIndex - 1)));
    }
}

