/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.AccountBadDebtBDFacadeFactory;
import com.kingdee.eas.fi.ar.AccountBadDebtBillAnalysisEntryCollection;
import com.kingdee.eas.fi.ar.AccountBadDebtBillAnalysisEntryInfo;
import com.kingdee.eas.fi.ar.AccountBadDebtCustEntryCollection;
import com.kingdee.eas.fi.ar.AccountBadDebtCustEntryInfo;
import com.kingdee.eas.fi.ar.AccountBadDebtException;
import com.kingdee.eas.fi.ar.AccountBadDebtFactory;
import com.kingdee.eas.fi.ar.AccountBadDebtInfo;
import com.kingdee.eas.fi.ar.IAccountBadDebt;
import com.kingdee.eas.fi.ar.IAccountBadDebtBDFacade;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.app.AbstractAccountBadDebtControllerBean;
import com.kingdee.eas.fi.ar.app.util.ArServerUtils;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;

public class AccountBadDebtControllerBean
extends AbstractAccountBadDebtControllerBean {
    public final String BOS_TYPE_VOUCHER = "2652E01E";
    public final String BOS_TYPE_ACCOUNTBADDEBT = "4696890F";

    protected boolean _checkLineExist(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return false;
    }

    protected SystemEnum _getOwnedSys(Context ctx) throws BOSException, EASBizException {
        return null;
    }

    private String getStrResource(Context ctx, String resKey) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey, (Locale)ctx.getLocale());
    }

    private String getStrResource(Context ctx, String resKey, Object[] params) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey, (Locale)ctx.getLocale(), (Object[])params);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super._checkNumberDup(ctx, null, model);
        return super._submit(ctx, model);
    }

    @Override
    protected IObjectValue _genVoucher(Context ctx, String billID) throws BOSException, EASBizException {
        StringBuffer errorMsg = new StringBuffer();
        CoreBillBaseCollection coreTransCollection = new CoreBillBaseCollection();
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        AccountBadDebtInfo model = (AccountBadDebtInfo)this.getValue(ctx, (IObjectPK)pk, sic);
        try {
            this.verifyBeforeGenVoucher(ctx, model);
            coreTransCollection.add((CoreBillBaseInfo)model);
            String methodName = this.getStrResource(ctx, "voucher_log");
            String instanceDeatil = model.getNumber();
            IObjectPK logObjectPK = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)model.getBOSType(), (IObjectPK)pk, (String)instanceDeatil, (String)"fi_ar_badacct_voucher");
            IObjectPK botMappingPK = ArApBillHelper.getBotpMappingPKByRuleFilter(ctx, "4696890F", new String[]{pk.toString()}, new String[]{"entrys"}, new ArrayList(), this.getSelectors(), model.getCU().getId().toString());
            DAPTransformResult result = super.generateVoucher(ctx, coreTransCollection, botMappingPK);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logObjectPK);
            return result.getVoucherCollection().getObject(0);
        }
        catch (EASBizException e) {
            String billNumber = model != null ? model.getNumber() : "";
            String companName = model != null ? model.getCompany().getName() : "";
            errorMsg.append(this.getStrResource(ctx, "batchOperationError", new Object[]{companName, billNumber, e.getMessage()}));
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg});
        }
        catch (BOSException e1) {
            throw e1;
        }
    }

    @Override
    protected IObjectValue _webGenVoucher(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
        return this._genVoucher(ctx, billId.toString());
    }

    private Date getCurrDate() {
        GregorianCalendar calendar = new GregorianCalendar();
        Date currDate = new Date(calendar.getTimeInMillis());
        return currDate;
    }

    private void auditAccountBadDebt(Context ctx, AccountBadDebtInfo acctBadDebtInfo) throws BOSException, EASBizException {
        this.verifyBeforeAudit(ctx, acctBadDebtInfo);
        Date currentDate = this.getCurrDate();
        UserInfo currentUser = CommonServerUtils.getCurrentUser(ctx);
        acctBadDebtInfo.setAuditDate(currentDate);
        acctBadDebtInfo.setAuditor(currentUser);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(acctBadDebtInfo.getId().toString()), (CoreBaseInfo)acctBadDebtInfo);
    }

    protected IObjectCollection _audit(Context ctx, IObjectCollection billCollection) throws BOSException, EASBizException {
        AccountBadDebtInfo acctInfo = null;
        int size = billCollection.size();
        for (int i = 0; i < size; ++i) {
            acctInfo = (AccountBadDebtInfo)billCollection.getObject(i);
            this.auditAccountBadDebt(ctx, acctInfo);
        }
        return billCollection;
    }

    protected IObjectValue _audit(Context ctx, IObjectValue billValue) throws BOSException, EASBizException {
        Date currentDate = this.getCurrDate();
        UserInfo currentUser = CommonServerUtils.getCurrentUser(ctx);
        AccountBadDebtInfo acctBadDebtInfo = (AccountBadDebtInfo)billValue;
        this.verifyBeforeAudit(ctx, acctBadDebtInfo);
        acctBadDebtInfo.setAuditDate(currentDate);
        acctBadDebtInfo.setAuditor(currentUser);
        ObjectUuidPK pkBadAcct = new ObjectUuidPK(acctBadDebtInfo.getId().toString());
        this.update(ctx, (IObjectPK)pkBadAcct, (CoreBaseInfo)acctBadDebtInfo);
        return acctBadDebtInfo;
    }

    private void verifyBeforeAudit(Context ctx, AccountBadDebtInfo acctBadDebtInfo) throws OtherBillBizException {
        if (acctBadDebtInfo.getAuditDate() != null && acctBadDebtInfo.getAuditor() != null) {
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{this.getStrResource(ctx, "accural_audited")});
        }
    }

    private void verifyBeforeGenVoucher(Context ctx, AccountBadDebtInfo acctBadDebtInfo) throws EASBizException, BOSException {
        if (!this.isNeedChecked(ctx, acctBadDebtInfo)) {
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{this.getStrResource(ctx, "gl_not_relation_or_start")});
        }
        if (acctBadDebtInfo.getAuditDate() == null || acctBadDebtInfo.getAuditor() == null) {
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{this.getStrResource(ctx, "bill_not_audit")});
        }
        if (acctBadDebtInfo.isFiVouchered()) {
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{this.getStrResource(ctx, "already_vouchered")});
        }
    }

    private boolean isNeedChecked(Context ctx, AccountBadDebtInfo acctBadDebtInfo) throws EASBizException, BOSException {
        String conpanyId = acctBadDebtInfo.getCompany().getId().toString();
        ISystemStatusCtrol systemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        boolean arIsRltdAccunt = systemStatusCtrol.isRelatedAccount(conpanyId, SystemEnum.ACCOUNTSRECEIVABLE);
        boolean glIsStart = systemStatusCtrol.isStart(SystemEnum.GENERALLEDGER.getValue(), conpanyId);
        return arIsRltdAccunt && glIsStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectValue _audit(Context ctx, String billID) throws BOSException, EASBizException {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isLocked = false;
        try {
            Date currentDate = this.getCurrDate();
            UserInfo currentUser = CommonServerUtils.getCurrentUser(ctx);
            ObjectUuidPK pk = new ObjectUuidPK(billID);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("company.*"));
            sic.add(new SelectorItemInfo("entrys.*"));
            sic.add(new SelectorItemInfo("saleIncomeEntry.*"));
            sic.add(new SelectorItemInfo("analysisEntry.*"));
            sic.add(new SelectorItemInfo("custAnalysisEntry.*"));
            sic.add(new SelectorItemInfo("custAnalysisEntrys.*"));
            sic.add(new SelectorItemInfo("billAnalysisEntry.*"));
            sic.add(new SelectorItemInfo("invEntry.*"));
            AccountBadDebtInfo acctBadDebtInfo = this.getAccountBadDebtInfo(ctx, (IObjectPK)pk, sic);
            StringBuffer errorMsg = new StringBuffer();
            try {
                isLocked = iMutex.requestObjIDForUpdate(billID);
                if (!isLocked) {
                    throw new com.kingdee.eas.fi.ap.OtherBillBizException(com.kingdee.eas.fi.ap.OtherBillBizException.BILL_LOCKED);
                }
                this.verifyBeforeAudit(ctx, acctBadDebtInfo);
                String methodName = this.getStrResource(ctx, "audit_log");
                String instanceDeatil = acctBadDebtInfo.getNumber();
                IObjectPK logObjectPK = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)acctBadDebtInfo.getBOSType(), (IObjectPK)pk, (String)instanceDeatil, (String)"fi_ar_badacct_audit");
                acctBadDebtInfo.setAuditDate(currentDate);
                acctBadDebtInfo.setAuditor(currentUser);
                this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)acctBadDebtInfo);
                if (acctBadDebtInfo.getAccountType().getValue() == 6 || acctBadDebtInfo.getAccountType().getValue() == 7) {
                    this.reverseBillPrepareAmount(ctx, acctBadDebtInfo, "+");
                } else if (acctBadDebtInfo.getAccountType().getValue() == 5) {
                    this.reverseCustPrepareAmount(ctx, acctBadDebtInfo, true);
                }
                LogUtil.afterLog((Context)ctx, (IObjectPK)logObjectPK);
            }
            catch (EASBizException e) {
                String billNumber = acctBadDebtInfo != null ? acctBadDebtInfo.getNumber() : "";
                String companName = acctBadDebtInfo != null ? acctBadDebtInfo.getCompany().getName() : "";
                errorMsg.append(this.getStrResource(ctx, "batchOperationError", new Object[]{companName, billNumber, e.getMessage()}));
                throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg});
            }
            catch (BOSException e1) {
                throw e1;
            }
            AccountBadDebtInfo accountBadDebtInfo = acctBadDebtInfo;
            return accountBadDebtInfo;
        }
        finally {
            if (isLocked) {
                iMutex.releaseObjIDForUpdate(billID);
            }
        }
    }

    private void reverseCustPrepareAmount(Context ctx, AccountBadDebtInfo info, boolean isAdd) throws EASBizException, BOSException {
        IAccountBadDebtBDFacade iAccountBadDebtBDFacade = AccountBadDebtBDFacadeFactory.getLocalInstance(ctx);
        String currencyID = info.getCurrency().getId().toString();
        String companyID = info.getCompany().getId().toString();
        AccountBadDebtCustEntryCollection custCollection = info.getCustAnalysisEntrys();
        int size = custCollection.size();
        for (int i = 0; i < size; ++i) {
            AccountBadDebtCustEntryInfo custInfo = custCollection.get(i);
            String customerID = custInfo.getCustomer().getId().toString();
            BigDecimal preAmount = custInfo.getPreReceiveAmount();
            preAmount = preAmount == null ? new BigDecimal("0.0") : preAmount;
            BigDecimal prepareAmount = custInfo.getPrepareAmount();
            BigDecimal balance = (prepareAmount = prepareAmount == null ? new BigDecimal("0.0") : prepareAmount).subtract(preAmount);
            if (balance.compareTo(new BigDecimal("0.0")) < 0) {
                balance = new BigDecimal("0.0000");
            }
            iAccountBadDebtBDFacade.reversePrepareAmount(balance, companyID, customerID, currencyID, isAdd);
        }
    }

    private boolean isDisplayLocalCurrency(Context ctx) throws BOSException, EASBizException {
        String value = ParamManager.getSpecialParamValue((Context)ctx, (String)"DISPLAY_LOCAL_CURRENCY").trim();
        return "true".equalsIgnoreCase(value);
    }

    private void reverseBillPrepareAmount(Context ctx, AccountBadDebtInfo info, String operator) throws BOSException, EASBizException {
        boolean isPrepareCurrency = !this.isDisplayLocalCurrency(ctx);
        IAccountBadDebtBDFacade iAccountBadDebtBDFacade = AccountBadDebtBDFacadeFactory.getLocalInstance(ctx);
        boolean isBackBill = false;
        if (info.getAccountType().getValue() == 7) {
            isBackBill = true;
        }
        AccountBadDebtBillAnalysisEntryCollection billCollection = info.getBillAnalysisEntry();
        HashMap<String, BigDecimal> billPrepareMap = new HashMap<String, BigDecimal>();
        int size = billCollection.size();
        for (int i = 0; i < size; ++i) {
            AccountBadDebtBillAnalysisEntryInfo billEntryInfo = billCollection.get(i);
            String billEntryID = billEntryInfo.getEntryID();
            BigDecimal prepareAmount = new BigDecimal("0.0");
            if (!isBackBill) {
                prepareAmount = billEntryInfo.getPrepareAmount();
            }
            if ("-".equals(operator)) {
                if (!isBackBill) {
                    BigDecimal addPrepareAmt = null == billEntryInfo.getPatch() ? new BigDecimal("0.0") : billEntryInfo.getPatch();
                    BigDecimal subPrepareAmt = null == billEntryInfo.getRush() ? new BigDecimal("0.0") : billEntryInfo.getRush();
                    prepareAmount = prepareAmount.subtract(addPrepareAmt).add(subPrepareAmt);
                } else {
                    prepareAmount = billEntryInfo.getPrepareAmount();
                }
            }
            billPrepareMap.put(billEntryID, prepareAmount);
        }
        iAccountBadDebtBDFacade.reverseOtherBill(billPrepareMap, isPrepareCurrency, operator);
    }

    @Override
    protected boolean _checkSettleAccounts(Context ctx, String billID) throws BOSException, EASBizException {
        String companyID = CommonServerUtils.getCurrentCompany(ctx).getId().toString();
        return this._checkSettleAccounts(ctx, billID, companyID);
    }

    @Override
    protected boolean _checkSettleAccounts(Context ctx, String badAccountDebtId, String currentComanyId) throws BOSException, EASBizException {
        boolean settleAccounts = false;
        if (StringUtils.isEmpty((String)badAccountDebtId) || StringUtils.isEmpty((String)currentComanyId)) {
            return settleAccounts;
        }
        StringBuffer sql = new StringBuffer(300);
        sql.append("SELECT *  FROM T_BOT_Relation relation,T_GL_Voucher voucher ").append(" WHERE relation.FDestObjectID = voucher.FID ").append(" AND  voucher.FBizStatus < ").append(5).append(" AND  voucher.FBizStatus != ").append(2).append(" AND relation.FDestEntityID = '").append("2652E01E").append("' AND FSrcEntityID = '").append("4696890F").append("' ").append(" AND relation.FSrcObjectID = ? ").append(" AND voucher.FCompanyID = ?");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, badAccountDebtId);
            ps.setString(2, currentComanyId);
            rs = ps.executeQuery();
            if (rs.next()) {
                settleAccounts = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return settleAccounts;
    }

    @Override
    protected boolean _isRelationGL(Context ctx, String companyID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        CompanyOrgUnitInfo currentCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk);
        return ArServerUtils.arIsRelatedAccount(ctx, currentCompany);
    }

    @Override
    protected void _remove(Context ctx, String billID) throws BOSException, EASBizException {
        IAccountBadDebt iAccountBadDebt = AccountBadDebtFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        iAccountBadDebt.delete((IObjectPK)pk);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo botRelation = (BOTRelationInfo)bOTRelationInfo;
        AccountBadDebtInfo billInfo = this.getAccountBadDebtInfo(ctx, srcBillPK);
        if ("2652E01E".equals(botRelation.getDestEntityID())) {
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                billInfo.setFiVouchered(false);
                billInfo.setVoucher(null);
                billInfo.setVoucherType(null);
            } else {
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(botRelation.getDestObjectID()));
                billInfo.setVoucher(voucherInfo);
                billInfo.setFiVouchered(true);
                billInfo.setVoucherType(voucherInfo.getVoucherType());
            }
        }
        super._reverseSave(ctx, srcBillPK, (IObjectValue)billInfo, bOTBillOperStateEnum, bOTRelationInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _unAudit(Context ctx, String id) throws BOSException, EASBizException {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isLocked = false;
        try {
            StringBuilder errorMsg = new StringBuilder();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("company.*"));
            sic.add(new SelectorItemInfo("entrys.*"));
            sic.add(new SelectorItemInfo("saleIncomeEntry.*"));
            sic.add(new SelectorItemInfo("analysisEntry.*"));
            sic.add(new SelectorItemInfo("custAnalysisEntry.*"));
            sic.add(new SelectorItemInfo("custAnalysisEntrys.*"));
            sic.add(new SelectorItemInfo("billAnalysisEntry.*"));
            sic.add(new SelectorItemInfo("invEntry.*"));
            ObjectUuidPK pk = new ObjectUuidPK(id);
            AccountBadDebtInfo acctBadDebtInfo = this.getAccountBadDebtInfo(ctx, (IObjectPK)pk, sic);
            try {
                isLocked = iMutex.requestObjIDForUpdate(id);
                if (!isLocked) {
                    throw new com.kingdee.eas.fi.ap.OtherBillBizException(com.kingdee.eas.fi.ap.OtherBillBizException.BILL_LOCKED);
                }
                this.verifyBeforeUnAudit(ctx, acctBadDebtInfo);
                String methodName = this.getStrResource(ctx, "unaudit_log");
                String instanceDeatil = acctBadDebtInfo.getNumber();
                IObjectPK logObjectPK = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)acctBadDebtInfo.getBOSType(), (IObjectPK)pk, (String)instanceDeatil, (String)"fi_ar_badacct_unaudit");
                acctBadDebtInfo.setAuditDate(null);
                acctBadDebtInfo.setAuditor(null);
                this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)acctBadDebtInfo);
                if (acctBadDebtInfo.getAccountType().getValue() == 6 || acctBadDebtInfo.getAccountType().getValue() == 7) {
                    this.reverseBillPrepareAmount(ctx, acctBadDebtInfo, "-");
                } else if (acctBadDebtInfo.getAccountType().getValue() == 5) {
                    this.reverseCustPrepareAmount(ctx, acctBadDebtInfo, false);
                }
                LogUtil.afterLog((Context)ctx, (IObjectPK)logObjectPK);
            }
            catch (EASBizException e) {
                String billNumber = acctBadDebtInfo != null ? acctBadDebtInfo.getNumber() : "";
                String companName = acctBadDebtInfo != null ? acctBadDebtInfo.getCompany().getName() : "";
                errorMsg.append(this.getStrResource(ctx, "batchOperationError", new Object[]{companName, billNumber, e.getMessage()}));
                throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg});
            }
            catch (BOSException e1) {
                throw e1;
            }
        }
        finally {
            if (isLocked) {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
    }

    private void verifyBeforeUnAudit(Context ctx, AccountBadDebtInfo acctBadDebtInfo) throws BOSException, EASBizException {
        AccountBadDebtBillAnalysisEntryCollection entrys = acctBadDebtInfo.getBillAnalysisEntry();
        if (0 != entrys.size()) {
            HashSet<String> billNumbers = new HashSet<String>();
            for (int i = 0; i < entrys.size(); ++i) {
                billNumbers.add(entrys.get(i).getBillNumber());
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("accountBadDebt.FCompanyId", (Object)acctBadDebtInfo.getCompany().getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("entry.FBillNumber", billNumbers, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("accountBadDebt.FCreateTime", (Object)acctBadDebtInfo.getCreateTime(), CompareType.GREATER));
            IRowSet rowSet = AccountBadDebtBDFacadeFactory.getLocalInstance(ctx).getBillAnalysisDetail(filter.toString());
            System.out.println(rowSet.size());
            if (0 != rowSet.size()) {
                throw new AccountBadDebtException(AccountBadDebtException.DATE_IS_NOT_LAST);
            }
        }
        if (acctBadDebtInfo.getAuditDate() == null && acctBadDebtInfo.getAuditor() == null) {
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{this.getStrResource(ctx, "accural_unaudited")});
        }
        if (acctBadDebtInfo.isFiVouchered()) {
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{this.getStrResource(ctx, "voucher_unaudit")});
        }
        PeriodInfo currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, acctBadDebtInfo.getCompany());
        if (acctBadDebtInfo.getAccountDate().before(currentPeriod.getBeginDate())) {
            throw new AccountBadDebtException(AccountBadDebtException.DATE_NOT_IN_CURRENT);
        }
        if (acctBadDebtInfo.getAccountType().getValue() != 6) {
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)("SELECT TOP 1 FAccountDate, FCreateTime FROM T_AR_AccountBadDebt WHERE FCompanyID = '" + acctBadDebtInfo.getCompany().getId().toString() + "' ORDER BY FAccountDate DESC, FCreateTime DESC"));
            try {
                Date lastDate = null;
                Timestamp lastTs = null;
                if (rs.next()) {
                    lastDate = rs.getDate("FAccountDate");
                    lastTs = rs.getTimestamp("FCreateTime");
                }
                if (acctBadDebtInfo.getAccountDate().compareTo(lastDate) != 0 || acctBadDebtInfo.getCreateTime().compareTo(lastTs) != 0) {
                    throw new AccountBadDebtException(AccountBadDebtException.DATE_IS_NOT_LAST);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("companyID"));
        sic.add(new SelectorItemInfo("companyName"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("accountYear"));
        sic.add(new SelectorItemInfo("accountDate"));
        sic.add(new SelectorItemInfo("accountType"));
        sic.add(new SelectorItemInfo("prepareAmount"));
        sic.add(new SelectorItemInfo("thisPrepareAmount"));
        sic.add(new SelectorItemInfo("patch"));
        sic.add(new SelectorItemInfo("rush"));
        sic.add(new SelectorItemInfo("currencyName"));
        sic.add(new SelectorItemInfo("accountName"));
        sic.add(new SelectorItemInfo("direction"));
        sic.add(new SelectorItemInfo("balance"));
        sic.add(new SelectorItemInfo("accountPercent"));
        sic.add(new SelectorItemInfo("accountBalance"));
        sic.add(new SelectorItemInfo("seq"));
        sic.add(new SelectorItemInfo("accountAge"));
        sic.add(new SelectorItemInfo("accrualRate"));
        sic.add(new SelectorItemInfo("receiveBalance"));
        sic.add(new SelectorItemInfo("otherReceiveRate"));
        sic.add(new SelectorItemInfo("otherReceiveBalance"));
        sic.add(new SelectorItemInfo("estimateLossSum"));
        sic.add(new SelectorItemInfo("saleAccountName"));
        sic.add(new SelectorItemInfo("accuralRate"));
        sic.add(new SelectorItemInfo("saleTotalAmounts"));
        sic.add(new SelectorItemInfo("accuralAmounts"));
        sic.add(new SelectorItemInfo("voucherTypeName"));
        sic.add(new SelectorItemInfo("voucherNumber"));
        return sic;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        AccountBadDebtInfo acctBadDebtInfo = this.getAccountBadDebtInfo(ctx, pk, sic);
        StringBuffer errorMsg = new StringBuffer();
        try {
            IObjectPK logObjectPK = this.beginLog(ctx, pk, "delete_log", "fi_ar_badacct_delete");
            this.verifyBeforeDelete(ctx, acctBadDebtInfo);
            super._delete(ctx, pk);
            this.afterLog(ctx, logObjectPK);
        }
        catch (EASBizException e) {
            String billNumber = acctBadDebtInfo != null ? acctBadDebtInfo.getNumber() : "";
            String companName = acctBadDebtInfo != null ? acctBadDebtInfo.getCompany().getName() : "";
            errorMsg.append(this.getStrResource(ctx, "batchOperationError", new Object[]{companName, billNumber, e.getMessage()}));
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg});
        }
        catch (BOSException e1) {
            throw e1;
        }
    }

    private void verifyBeforeDelete(Context ctx, AccountBadDebtInfo acctBadDebtInfo) throws OtherBillBizException {
        if (acctBadDebtInfo.isFiVouchered()) {
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{this.getStrResource(ctx, "accural_voucher_for_delete")});
        }
        if (acctBadDebtInfo.getAuditor() != null || acctBadDebtInfo.getAuditDate() != null) {
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{this.getStrResource(ctx, "accural_audited_for_delete")});
        }
    }

    @Override
    protected IObjectValue _webAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return this._audit(ctx, pk.toString());
    }

    @Override
    protected void _webUnAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._unAudit(ctx, pk.toString());
    }

    protected boolean _deleteVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        boolean deleteSuccess = true;
        StringBuffer errorMsg = new StringBuffer();
        IObjectPK logObjectPK = this.beginLog(ctx, sourceBillPk, "delvoucher_log", "fi_ar_badacct_delete");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        AccountBadDebtInfo model = (AccountBadDebtInfo)this.getValue(ctx, sourceBillPk, sic);
        try {
            this.verifyBeforeDelVoucher(ctx, model);
            deleteSuccess = super._deleteVoucher(ctx, sourceBillPk);
        }
        catch (EASBizException e) {
            String billNumber = model != null ? model.getNumber() : "";
            String companName = model != null ? model.getCompany().getName() : "";
            errorMsg.append(this.getStrResource(ctx, "batchOperationError", new Object[]{companName, billNumber, e.getMessage()}));
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg});
        }
        catch (BOSException e1) {
            throw e1;
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logObjectPK);
        return deleteSuccess;
    }

    private void verifyBeforeDelVoucher(Context ctx, AccountBadDebtInfo acctBadDebtInfo) throws EASBizException, BOSException {
        if (!this.isNeedChecked(ctx, acctBadDebtInfo)) {
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{this.getStrResource(ctx, "gl_not_relation_or_start")});
        }
        if (!acctBadDebtInfo.isFiVouchered()) {
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{this.getStrResource(ctx, "no_gen_voucher")});
        }
    }

    private IObjectPK beginLog(Context ctx, IObjectPK pk, String method, String methodDes) throws BOSException, EASBizException {
        IAccountBadDebt iAccountBadDebt = AccountBadDebtFactory.getLocalInstance(ctx);
        AccountBadDebtInfo accountBadDebtInfo = iAccountBadDebt.getAccountBadDebtInfo(pk);
        String methodName = this.getStrResource(ctx, method);
        String instanceDeatil = accountBadDebtInfo.getNumber();
        ObjectUuidPK iObjectPK = new ObjectUuidPK(accountBadDebtInfo.getId().toString());
        return LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)accountBadDebtInfo.getBOSType(), (IObjectPK)iObjectPK, (String)instanceDeatil, (String)methodDes);
    }

    private void afterLog(Context ctx, IObjectPK pk) {
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
    }

    protected String _getAssignUipk4Entity(Context ctx, IObjectPK id, IObjectValue model, String viewType) throws BOSException, EASBizException {
        if ("list".equalsIgnoreCase(viewType)) {
            return "com.kingdee.eas.fi.ar.BadAccountList";
        }
        return null;
    }
}

