/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.app.AbstractAccountBadDebtCustPrepareControllerBean;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountBadDebtCustPrepareControllerBean
extends AbstractAccountBadDebtCustPrepareControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.AccountBadDebtCustPrepareControllerBean");

    @Override
    protected IRowSet _getCustomerPrepareAmount(Context ctx, Set companyIDSet, String currencyID, String numberFrom, String numberTo, int maxReturnRowCount, String prepareAmountFlag, String searchItemFilter, boolean needCal) throws BOSException, EASBizException {
        logger.info((Object)"-------------------------query AccountBadDebtCustPrepare bean start--------------------------------------");
        boolean isPrepareCurrency = currencyID != null;
        int index = 0;
        String language = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer("");
        Iterator it = companyIDSet.iterator();
        sql.append(" select distinct ");
        if (maxReturnRowCount > 0) {
            sql.append(" top ").append(maxReturnRowCount);
        }
        sql.append(" * from (\r\n");
        ISystemStatusCtrol systemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        while (it.hasNext()) {
            String companyIDStr = it.next().toString();
            String billDate = "";
            if (needCal) {
                PeriodInfo currentPeriod = systemStatusCtrol.getCacheCurrentPeriod(new Integer(SystemEnum.ACCOUNTSRECEIVABLE.getValue()).intValue(), companyIDStr);
                billDate = this.getJTStrDate(currentPeriod);
            }
            if (!"2".equals(prepareAmountFlag)) {
                sql.append(this.getHasSetCustomerPrepareAmount(language, isPrepareCurrency, companyIDStr, currencyID, numberFrom, numberTo, searchItemFilter, needCal, billDate));
            }
            if ("0".equals(prepareAmountFlag)) {
                sql.append(" UNION ALL \r\n");
            }
            if (!"1".equals(prepareAmountFlag)) {
                sql.append(this.getNotSetCustomerPrepareAmount(language, isPrepareCurrency, companyIDStr, currencyID, numberFrom, numberTo, searchItemFilter, needCal, billDate));
            }
            if (++index == companyIDSet.size()) continue;
            sql.append(" UNION ALL \r\n");
        }
        sql.append(" ) as b order by FCompanyNumber,FNumber\r\n");
        logger.info((Object)("\u5ba2\u6237\u521d\u59cb\u4f59\u989dSQL:" + sql.toString()));
        logger.info((Object)"-------------------------query AccountBadDebtCustPrepare bean end--------------------------------------");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    @Override
    protected IRowSet _getCustomerPrepareAmount(Context ctx, Set companyIDSet, String currencyID, String numberFrom, String numberTo, String prepareAmountFlag, boolean needCal) throws BOSException, EASBizException {
        return this._getCustomerPrepareAmount(ctx, companyIDSet, currencyID, numberFrom, numberTo, -1, prepareAmountFlag, needCal);
    }

    @Override
    protected IRowSet _getCustomerPrepareAmount(Context ctx, Set companyIDSet, String currencyID, String numberFrom, String numberTo, int maxReturnRowCount, String prepareAmountFlag, boolean needCal) throws BOSException, EASBizException {
        return this._getCustomerPrepareAmount(ctx, companyIDSet, currencyID, numberFrom, numberTo, -1, prepareAmountFlag, null, needCal);
    }

    private String getHasSetCustomerPrepareAmount(String language, boolean isPrepareCurrency, String companyIDStr, String currencyID, String numberFrom, String numberTo, String searchItemFilter, boolean needCal, String billDate) {
        StringBuffer sql = new StringBuffer("");
        sql.append(" SELECT distinct ").append("\r\n");
        sql.append(" CUSTOMERPREPARE.FID AS FID,\r\n");
        sql.append(" CUSTOMER.FNumber AS FNumber,\r\n");
        sql.append(" CUSTOMER.FName_" + language + " AS FName,\r\n");
        sql.append(" CUSTOMERPREPARE.FPrepareAmount AS FPrepareAmount,\r\n");
        sql.append(" CUSTOMERPREPARE.FTotalPrepareAmount AS FTotalPrepareAmount,\r\n");
        sql.append(" CUSTOMERPREPARE.FLastPrepareAmount AS FLastPrepareAmount,\r\n");
        sql.append(" CUSTOMERPREPARE.FCurrencyID AS FCurrencyID,\r\n");
        sql.append(" CUSTOMER.FID AS FCustomerID,\r\n");
        sql.append(" CUSTOMERPREPARE.FCompanyID AS FCompanyID, \r\n");
        sql.append(" COMPANYORG.FNumber AS FCompanyNumber, \r\n");
        sql.append(" COMPANYORG.FName_" + language + " AS FCompanyName \r\n");
        sql.append(" FROM T_BD_Customer AS CUSTOMER \r\n");
        sql.append(" INNER JOIN T_AR_AccountBadDebtCustPrepare AS CUSTOMERPREPARE \r\n");
        sql.append(" ON CUSTOMER.FID = CUSTOMERPREPARE.FCustomerID \r\n");
        sql.append(" INNER JOIN T_ORG_Company AS COMPANYORG \r\n");
        sql.append(" ON CUSTOMERPREPARE.FCompanyID = COMPANYORG.FID \r\n");
        sql.append(" INNER JOIN T_BD_CURRENCY AS BASECURRENCY \r\n");
        sql.append(" ON COMPANYORG.FBaseCurrencyID = BASECURRENCY.FID \r\n");
        if (needCal) {
            sql.append(" INNER JOIN T_AR_OTHERBILL AS BILL \r\n");
            sql.append(" ON bill.FAsstActID = customer.FID \r\n");
        }
        sql.append(" WHERE CUSTOMERPREPARE.FCompanyID = '" + companyIDStr + "' \r\n");
        if (isPrepareCurrency) {
            sql.append(" AND CUSTOMERPREPARE.FCurrencyID = '" + currencyID + "' \r\n");
        } else {
            sql.append(" AND CUSTOMERPREPARE.FCurrencyID = BASECURRENCY.FID \r\n");
        }
        if (numberFrom != null && !"".equals(numberFrom)) {
            sql.append(" AND CUSTOMER.FNumber >='" + numberFrom + "' \r\n");
        }
        if (numberTo != null && !"".equals(numberTo)) {
            sql.append(" AND CUSTOMER.FNumber <='" + numberTo + "' \r\n");
        }
        if (!StringUtils.isEmpty((String)searchItemFilter)) {
            sql.append(" AND " + searchItemFilter + " \r\n");
        }
        if (needCal) {
            sql.append(" AND BILL.FUnVerifyAmount > 0 \r\n");
            sql.append(" AND BILL.FBillDate < {").append(billDate).append("}\r\n");
            sql.append(" AND BILL.FCompanyID = '" + companyIDStr + "'\r\n");
            sql.append(" AND BILL.FBillStatus = ").append(3);
        }
        logger.info((Object)("\u5df2\u7ef4\u62a4\u5ba2\u6237\u521d\u59cb\u4f59\u989dSQl:" + sql.toString()));
        return sql.toString();
    }

    private String getNotSetCustomerPrepareAmount(String language, boolean isPrepareCurrency, String companyIDStr, String currencyID, String numberFrom, String numberTo, String searchItemFilter, boolean needCal, String billDate) {
        StringBuffer sql = new StringBuffer("");
        sql.append(" SELECT ");
        sql.append(" NULL AS FID,\r\n");
        sql.append(" CUSTOMER.FNumber AS FNumber,\r\n");
        sql.append(" CUSTOMER.FName_" + language + " AS FName,\r\n");
        sql.append(" 0.0 AS FPrepareAmount,\r\n");
        sql.append(" 0.0 AS FTotalPrepareAmount,\r\n");
        sql.append(" 0.0 AS FLastPrepareAmount,\r\n");
        sql.append(" NULL FCurrencyID,\r\n");
        sql.append(" CUSTOMER.FID AS FCustomerID,\r\n");
        sql.append(" COMPANYORG.FID AS FCompanyID, \r\n");
        sql.append(" COMPANYORG.FNumber AS FCompanyNumber, \r\n");
        sql.append(" COMPANYORG.FName_" + language + " AS FCompanyName \r\n");
        sql.append(" FROM T_BD_Customer AS CUSTOMER \r\n");
        sql.append(" LEFT OUTER JOIN T_BD_CustomerCompanyInfo AS CUSTOMERCOMPANY \r\n");
        sql.append(" ON CUSTOMER.FID = CUSTOMERCOMPANY.FCustomerID \r\n");
        sql.append(" INNER JOIN T_ORG_Company AS COMPANYORG \r\n");
        sql.append(" ON CUSTOMERCOMPANY.FComOrgID = COMPANYORG.FID \r\n");
        if (needCal) {
            sql.append(" INNER JOIN T_AR_OTHERBILL AS BILL \r\n");
            sql.append(" ON BILL.FAsstActID = customer.FID \r\n");
        }
        sql.append(" WHERE CUSTOMER.FID not in (SELECT FCustomerID \r\n");
        sql.append(" from T_AR_AccountBadDebtCustPrepare AS DEBTCUSTPREPARE \r\n");
        sql.append(" INNER JOIN T_ORG_Company AS COMPANYORG \r\n");
        sql.append(" ON DEBTCUSTPREPARE.FCompanyID = COMPANYORG.FID \r\n");
        sql.append(" INNER JOIN T_BD_CURRENCY AS BASECURRENCY \r\n");
        sql.append(" ON COMPANYORG.FBaseCurrencyID = BASECURRENCY.FID \r\n");
        sql.append(" where DEBTCUSTPREPARE.FCompanyID = '" + companyIDStr + "'\r\n");
        if (isPrepareCurrency) {
            sql.append(" AND DEBTCUSTPREPARE.FCurrencyID = '" + currencyID + "'\r\n");
        } else {
            sql.append(" AND DEBTCUSTPREPARE.FCurrencyID = BASECURRENCY.FID \r\n");
        }
        if (numberFrom != null && !"".equals(numberFrom)) {
            sql.append(" AND CUSTOMER.FNumber >= '" + numberFrom + "' \r\n");
        }
        if (numberTo != null && !"".equals(numberTo)) {
            sql.append(" AND CUSTOMER.FNumber <= '" + numberTo + "'\r\n");
        }
        sql.append(" ) AND COMPANYORG.FID = '" + companyIDStr + "' \r\n");
        if (numberFrom != null && !"".equals(numberFrom)) {
            sql.append(" AND CUSTOMER.FNumber >= '" + numberFrom + "' \r\n");
        }
        if (numberTo != null && !"".equals(numberTo)) {
            sql.append(" AND CUSTOMER.FNumber <= '" + numberTo + "'\r\n");
        }
        if (!StringUtils.isEmpty((String)searchItemFilter)) {
            sql.append(" AND " + searchItemFilter + " \r\n");
        }
        if (needCal) {
            sql.append(" AND BILL.FUnVerifyAmount > 0 \r\n");
            sql.append(" AND BILL.FBillDate < {").append(billDate).append("}\r\n");
            sql.append(" AND BILL.FCompanyID = '" + companyIDStr + "'\r\n");
            sql.append(" AND BILL.FBillStatus = ").append(3);
        }
        logger.info((Object)("\u672a\u7ef4\u62a4\u5ba2\u6237\u521d\u59cb\u4f59\u989dSQl:" + sql.toString()));
        return sql.toString();
    }

    @Override
    protected boolean _exist(Context ctx, String companyID, String customerID, String currencyID) throws BOSException {
        boolean value = false;
        StringBuffer sql = new StringBuffer("");
        sql.append("select debt.fid \r\n");
        sql.append("from T_AR_AccountBadDebt debt inner join \r\n");
        sql.append("T_AR_AccountBadDebtCustEntry debtEntry \r\n");
        sql.append("on debt.fid = debtEntry.FAccountBadDebtID \r\n");
        sql.append("where debt.fcompanyid = '" + companyID + "' \r\n");
        if (customerID != null && !"".equals(customerID)) {
            sql.append("and debtEntry.FCustomerID = '" + customerID + "' \r\n");
        }
        if (currencyID != null && !"".equals(currencyID)) {
            sql.append("and debtEntry.FCurrencyID = '" + currencyID + "' \r\n");
        }
        Connection con = null;
        Statement ps = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                value = true;
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, ps, con);
        }
        return value;
    }

    @Override
    protected Map _existPrepareData(Context ctx, Map comCusCurMap) throws BOSException {
        HashMap<String, Boolean> valueMap = new HashMap<String, Boolean>();
        Iterator iterator = comCusCurMap.keySet().iterator();
        String key = null;
        List comCusCurList = null;
        HashSet<String> companyIDSet = new HashSet<String>();
        HashSet<String> customerIDSet = new HashSet<String>();
        HashSet<String> currencyIDSet = new HashSet<String>();
        while (iterator.hasNext()) {
            key = iterator.next().toString();
            comCusCurList = (List)comCusCurMap.get(key);
            if (comCusCurList.get(0) != null) {
                companyIDSet.add(comCusCurList.get(0).toString());
            }
            if (comCusCurList.get(1) != null) {
                customerIDSet.add(comCusCurList.get(1).toString());
            }
            if (comCusCurList.get(2) == null) continue;
            currencyIDSet.add(comCusCurList.get(2).toString());
        }
        String companyIDs = ArApBillUtil.convertSetToString(companyIDSet);
        String customerIDs = ArApBillUtil.convertSetToString(customerIDSet);
        String currencyIDs = ArApBillUtil.convertSetToString(currencyIDSet);
        StringBuffer sql = new StringBuffer("");
        sql.append("select debt.fcompanyid,debtEntry.FCustomerID,debtEntry.FCurrencyID \r\n");
        sql.append("from T_AR_AccountBadDebt debt inner join \r\n");
        sql.append("T_AR_AccountBadDebtCustEntry debtEntry \r\n");
        sql.append("on debt.fid = debtEntry.FAccountBadDebtID \r\n");
        if (companyIDs != null && companyIDs.length() > 0) {
            sql.append("where debt.fcompanyid in " + companyIDs + " \r\n");
        }
        String tempTable = null;
        if (customerIDs != null && customerIDs.length() > 0) {
            tempTable = "customerIDTable";
            StringBuffer createTableSQL = new StringBuffer();
            createTableSQL.append(" create table ").append(tempTable).append(" (FID  varchar(44) not null)");
            tempTable = KsqlUtil.createTempTable((Context)ctx, (String)createTableSQL.toString());
            Connection conn = null;
            DBUtil.createTempTableIndex((Context)ctx, (String)tempTable, (String)"FID", (boolean)false);
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                Iterator custIterator = customerIDSet.iterator();
                StringBuffer insertTableSQL = new StringBuffer();
                ArrayList<String> batchSql = new ArrayList<String>();
                while (custIterator.hasNext()) {
                    insertTableSQL.setLength(0);
                    insertTableSQL.append(" insert into ").append(tempTable).append(" values ('").append(custIterator.next().toString()).append("')");
                    batchSql.add(insertTableSQL.toString());
                }
                DBUtil.execute((Context)ctx, (String[])batchSql.toArray(new String[batchSql.size()]));
                DBUtil.AnalyseTable((Context)ctx, (Connection)conn, (String)tempTable);
            }
            catch (SQLException sqlEx) {
                throw new BOSException((Throwable)sqlEx);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
            sql.append("and exists (select 1 from " + tempTable + ") \r\n");
        }
        if (currencyIDs != null && currencyIDs.length() > 0) {
            sql.append("and debtEntry.FCurrencyID in " + currencyIDs + " \r\n");
        }
        sql.append(" group by debt.fcompanyid,debtEntry.FCustomerID,debtEntry.FCurrencyID ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            String companyID = null;
            String customerID = null;
            String currencyID = null;
            String keyStr1 = null;
            String keyStr2 = null;
            block9: while (rowSet.next()) {
                companyID = rowSet.getString(1) == null ? "" : rowSet.getString(1);
                customerID = rowSet.getString(2) == null ? "" : rowSet.getString(2);
                currencyID = rowSet.getString(3) == null ? "" : rowSet.getString(3);
                keyStr1 = companyID + customerID + currencyID;
                iterator = comCusCurMap.keySet().iterator();
                while (iterator.hasNext()) {
                    key = iterator.next().toString();
                    comCusCurList = (List)comCusCurMap.get(key);
                    companyID = comCusCurList.get(0) == null ? "" : comCusCurList.get(0).toString();
                    customerID = comCusCurList.get(1) == null ? "" : comCusCurList.get(1).toString();
                    String string = currencyID = comCusCurList.get(2) == null ? "" : comCusCurList.get(2).toString();
                    keyStr2 = companyID + customerID + currencyID;
                    if (!keyStr2.equals(keyStr1)) continue;
                    valueMap.put(keyStr2, true);
                    comCusCurMap.remove(key);
                    continue block9;
                }
            }
        }
        catch (SQLException e) {
            logger.info((Object)sql.toString(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (tempTable != null) {
            KsqlUtil.releaseTempTable((Context)ctx, (String)tempTable);
        }
        return valueMap;
    }

    private String getJTStrDate(PeriodInfo currPeriod) {
        Date date = this.upDate(this.getJTDate(currPeriod));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(date);
    }

    private Date getJTDate(PeriodInfo currPeriod) {
        Date currDate = null;
        if (currPeriod != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(currPeriod.getEndDate());
            currDate = new Date(calendar.getTime().getTime());
        }
        return currDate;
    }

    public Date upDate(Date oldDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(oldDate);
        calendar.add(5, 1);
        Date dateUp = new Date(calendar.getTime().getTime());
        return dateUp;
    }
}

