/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.AccountBadDebtCustPrepareFactory;
import com.kingdee.eas.fi.ar.AccountBadDebtCustPrepareInfo;
import com.kingdee.eas.fi.ar.IAccountBadDebtCustPrepare;
import com.kingdee.eas.fi.ar.ImportException;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.arap.app.ARAPImportHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AccountBadDebtCustPrepareImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)AccountBadDebtCustPrepareImport.class.getName());
    private CurrencyInfo baseCurrency = null;
    private CompanyOrgUnitInfo currentCompany = null;
    private IAccountBadDebtCustPrepare iAccountBadDebtCustPrepare = null;
    private String errorParamMsg = "";
    private String companyName = "";
    private String customerName = "";
    private Map companyCache = new HashMap();
    private Map convertRateCache = new HashMap();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return AccountBadDebtCustPrepareFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            this.iAccountBadDebtCustPrepare = AccountBadDebtCustPrepareFactory.getLocalInstance(ctx);
            AccountBadDebtCustPrepareInfo info = this.generateAccountBadDebtCustPrepareInfo(ctx, hsData);
            return info;
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
            throw new TaskExternalException(e.getMessage());
        }
    }

    private AccountBadDebtCustPrepareInfo generateAccountBadDebtCustPrepareInfo(Context ctx, Hashtable tableData) throws TaskExternalException, BOSException, EASBizException {
        this.errorParamMsg = "";
        this.companyName = "";
        this.customerName = "";
        AccountBadDebtCustPrepareInfo info = null;
        Hashtable hsData = tableData;
        this.currentCompany = this.getCompanyInfo(ctx, hsData, "FCompany_number");
        this.checkOrgPermission(ctx);
        this.companyName = this.currentCompany.getName(ctx.getLocale());
        String companyId = this.currentCompany.getId().toString();
        this.baseCurrency = this.currentCompany.getBaseCurrency();
        String baseCurrencyId = this.baseCurrency.getId().toString();
        CustomerInfo customerInfo = this.getCustomerInfo(ctx, hsData, "FCustomer_number", companyId);
        this.customerName = customerInfo.getName();
        this.errorParamMsg = this.companyName + "," + this.customerName;
        String customerId = customerInfo.getId().toString();
        BigDecimal prepareAmount = this.getPrepareAmount(ctx, hsData, "FPrepareAmount");
        if (this.baseCurrency == null) {
            throw new ImportException(ImportException.CANNOTGETLOCALCURRENCY);
        }
        Timestamp now = new Timestamp(new Date().getTime());
        info = this.getBadDebtCustPrepareInfo(ctx, companyId, baseCurrencyId, customerId);
        if (this.isSltImportUpdate()) {
            if (info == null) {
                info = new AccountBadDebtCustPrepareInfo();
                info.setCompany(this.currentCompany);
                info.setCustomer(customerInfo);
                info.setCustomerNumber(customerInfo.getNumber().toString());
                info.setCurrency(this.baseCurrency);
                info.setPrepareAmount(prepareAmount);
                info.setLastPrepareAmount(prepareAmount);
                info.setTotalPrepareAmount(BigDecimal.ZERO);
                info.setExchangeRate(this.getConvertRate(ctx));
                info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                info.setCreateTime(now);
            }
            if (this.existPrepareData(companyId, customerId, baseCurrencyId)) {
                throw new TaskExternalException(this.getResourceStr(ctx, "EXIST_BADDATA_UPDATE_ERROR", new Object[]{this.errorParamMsg}));
            }
            info.setPrepareAmount(prepareAmount);
            info.setLastPrepareAmount(prepareAmount);
            info.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            info.setLastUpdateTime(now);
        } else {
            if (info != null) {
                throw new TaskExternalException(this.getResourceStr(ctx, "CUSTAMOUNT_EDIT_ADD_ERROR", new Object[]{this.errorParamMsg}));
            }
            info = new AccountBadDebtCustPrepareInfo();
            info.setCompany(this.currentCompany);
            info.setCustomer(customerInfo);
            info.setCustomerNumber(customerInfo.getNumber().toString());
            info.setCurrency(this.baseCurrency);
            info.setPrepareAmount(prepareAmount);
            info.setLastPrepareAmount(prepareAmount);
            info.setTotalPrepareAmount(BigDecimal.ZERO);
            info.setExchangeRate(this.getConvertRate(ctx));
            info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            info.setCreateTime(now);
        }
        return info;
    }

    private void checkOrgPermission(Context ctx) throws TaskExternalException {
        OrgType orgType = OrgType.Company;
        String permItemName = null;
        permItemName = "fi_ar_customer_balance_edit";
        try {
            IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
            ObjectUuidPK cuId = new ObjectUuidPK(this.currentCompany.getCU().getId().toString());
            FullOrgUnitCollection orgCol = permission.getAuthorizedOrgOfCU((IObjectPK)cuId, ctx.getCaller(), OrgType.Company, (IObjectPK)treePK, permItemName);
            boolean isHasPerm = false;
            for (int i = 0; i < orgCol.size(); ++i) {
                FullOrgUnitInfo orgInfo = orgCol.get(i);
                if (!orgInfo.getId().toString().equals(this.currentCompany.getId().toString())) continue;
                isHasPerm = true;
            }
            if (!isHasPerm) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARImportData", (String)"MULTIORGIMPORT", (Locale)ctx.getLocale(), (Object[])new Object[]{this.currentCompany.getNumber()}));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo.getId() != null) {
                this.iAccountBadDebtCustPrepare.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            } else {
                this.iAccountBadDebtCustPrepare.addnew(coreBaseInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private CustomerInfo getCustomerInfo(Context ctx, Hashtable hsData, String field, String companyID) throws TaskExternalException, BOSException {
        String customerNumber = ARAPImportHelper.getDataString(hsData, field);
        CustomerInfo customerInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("customer.*"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("customer.number", (Object)customerNumber, CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(sic);
        CustomerCompanyInfoCollection coll = CustomerCompanyInfoFactory.getLocalInstance((Context)ctx).getCustomerCompanyInfoCollection(view);
        if (coll != null && coll.size() > 0) {
            CustomerCompanyInfoInfo customerCompanyInfoInfo = coll.get(0);
            if (customerCompanyInfoInfo != null) {
                customerInfo = customerCompanyInfoInfo.getCustomer();
            }
            if (!customerInfo.getUsedStatus().equals((Object)UsedStatusEnum.APPROVED)) {
                throw new TaskExternalException(this.getResourceStr(ctx, "CUSTAMOUNT_NOTAUDIT_IMPORT_ERROR", new Object[]{this.errorParamMsg, this.customerName}));
            }
        } else {
            throw new TaskExternalException(this.getResourceStr(ctx, "CUSTAMOUNT_NOTINCLUDE_COMPANY_IMPORT_ERROR", new Object[]{this.errorParamMsg, this.customerName, this.companyName}));
        }
        return customerInfo;
    }

    private BigDecimal getPrepareAmount(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        BigDecimal prepareAmount = ARAPImportHelper.getDataDeciaml(ctx, hsData, field);
        if (prepareAmount.compareTo(BigDecimal.ZERO) < 0) {
            throw new TaskExternalException(this.getResourceStr(ctx, "BADAMOUNT_LESS_ZERO_IMPORT_ERROR", new Object[]{this.errorParamMsg}));
        }
        return prepareAmount;
    }

    private AccountBadDebtCustPrepareInfo getBadDebtCustPrepareInfo(Context ctx, String companyId, String currencyId, String customerId) throws BOSException {
        AccountBadDebtCustPrepareInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)customerId, CompareType.EQUALS));
        view.setFilter(filter);
        CoreBaseCollection coll = AccountBadDebtCustPrepareFactory.getLocalInstance(ctx).getCollection(view);
        if (coll != null && coll.size() > 0) {
            info = (AccountBadDebtCustPrepareInfo)coll.get(0);
        }
        return info;
    }

    private boolean existPrepareData(String companyid, String customerid, String currencyid) throws BOSException {
        HashMap comCusCurMap = new HashMap();
        ArrayList<String> comCusCurList = new ArrayList<String>();
        comCusCurList.add(companyid);
        comCusCurList.add(customerid);
        comCusCurList.add(currencyid);
        String key = companyid + customerid + currencyid;
        comCusCurMap.put(key, comCusCurList);
        Map valueMap = this.iAccountBadDebtCustPrepare.existPrepareData(comCusCurMap);
        return valueMap.keySet().contains(key);
    }

    private BigDecimal getConvertRate(Context ctx) throws EASBizException, BOSException {
        String key = this.currentCompany.getId().toString() + this.baseCurrency.getId().toString();
        if (this.convertRateCache.get(key) != null) {
            return (BigDecimal)this.convertRateCache.get(key);
        }
        BigDecimal convertRate = null;
        ExchangeRateInfo rateInfo = BaseDataUtil.getExchangeRate(ctx, this.currentCompany, this.baseCurrency, new Date());
        convertRate = rateInfo != null ? rateInfo.getConvertRate() : new BigDecimal("1.00");
        this.convertRateCache.put(key, convertRate);
        return convertRate;
    }

    private CompanyOrgUnitInfo getCompanyInfo(Context ctx, Hashtable hsData, String field) throws TaskExternalException, BOSException {
        String companyNumber = ARAPImportHelper.getDataString(hsData, field);
        CompanyOrgUnitInfo info = null;
        if (this.companyCache.get(companyNumber) != null) {
            return (CompanyOrgUnitInfo)this.companyCache.get(companyNumber);
        }
        info = ARAPImportHelper.getCompany(ctx, hsData, "FCompany_number");
        this.companyCache.put(companyNumber, info);
        return info;
    }

    private String getResourceStr(Context ctx, String resName, Object[] params) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARImportData", (String)resName, (Locale)ctx.getLocale(), (Object[])params);
    }

    private String getResourceStr(Context ctx, String resName) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARImportData", (String)resName, (Locale)ctx.getLocale());
    }
}

