/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.EJBAccessFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.app.AbstractArApBgCommonFacadeControllerBean;
import com.kingdee.eas.fi.ar.app.util.ArApBudgetCallerUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ArApBgCommonFacadeControllerBean
extends AbstractArApBgCommonFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.ArApBgCommonFacadeControllerBean");
    private final String AR_BOSTYPE = "FC910EF3";
    private final String AP_BOSTYPE = "48DA3A71";
    private final String PAY_REQ_BOSTYPE = "D001019A";
    private final String REC_BILL_BOSTYPE = "FA44FD5B";
    private final String PAY_BILL_BOSTYPE = "40284E81";

    @Override
    protected int _requestBudget(Context ctx, BOSUuid billId, IObjectValue billInfo) throws BOSException, EASBizException {
        this.checkHasParam(ctx, billId);
        int resultCode = ArApBudgetCallerUtil.requestBudget(ctx, billId);
        return resultCode;
    }

    @Override
    protected int _returnBudget(Context ctx, BOSUuid billId, IObjectValue billInfo) throws BOSException, EASBizException {
        this.checkHasParam(ctx, billId);
        int resultCode = ArApBudgetCallerUtil.returnBudget(ctx, billId);
        return resultCode;
    }

    protected void checkHasParam(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (null == billId) {
            return;
        }
        BOSObjectType type = BOSUuid.read((String)billId.toString()).getType();
        String companyId = null;
        EntityObjectInfo eoi = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(type);
        String tableName = eoi.getTable().getName();
        StringBuilder selectSQL = new StringBuilder(100);
        selectSQL.append(" SELECT FCOMPANYID as CID FROM ");
        selectSQL.append(tableName);
        selectSQL.append("  where FID = '" + billId + "'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSQL.toString());
        try {
            if (rowSet.next()) {
                companyId = rowSet.getString("CID");
            }
        }
        catch (SQLException e) {
            throw new BOSException("Get Param :", (Throwable)e);
        }
        if (null == companyId) {
            return;
        }
        HashMap<String, String> hashKey = new HashMap<String, String>();
        String paramKey = null;
        String billName = null;
        if ("FC910EF3".equals(type.toString())) {
            paramKey = "ARBILL_BUDGET_NODE";
            billName = ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"AROtherBill", (Locale)ctx.getLocale());
        } else if ("48DA3A71".equals(type.toString())) {
            paramKey = "AP_BUDGET_NODE";
            billName = ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"APOtherBill", (Locale)ctx.getLocale());
        } else if ("D001019A".equals(type.toString())) {
            paramKey = "AP_BG_01";
            billName = ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"PAY_REQ_BILL", (Locale)ctx.getLocale());
        } else if ("FA44FD5B".equals(type.toString())) {
            paramKey = "CS042";
            billName = ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"ReciveBill", (Locale)ctx.getLocale());
        } else if ("40284E81".equals(type.toString())) {
            paramKey = "CS043";
            billName = ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"PaymentBill", (Locale)ctx.getLocale());
        }
        hashKey.put(paramKey, companyId);
        HashMap paramMap = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hashKey);
        Object paramObj = paramMap.get(paramKey);
        if (null == paramObj) {
            return;
        }
        String paramVal = paramObj.toString();
        boolean isBgParamUsable = false;
        if ("FC910EF3".equals(type.toString()) || "48DA3A71".equals(type.toString())) {
            if ("1".equals(paramVal) || "2".equals(paramVal)) {
                isBgParamUsable = true;
            }
        } else if ("D001019A".equals(type.toString())) {
            if ("0".equals(paramVal) || "1".equals(paramVal)) {
                isBgParamUsable = true;
            }
        } else if (("FA44FD5B".equals(type.toString()) || "40284E81".equals(type.toString())) && !"0".equals(paramVal)) {
            isBgParamUsable = true;
        }
        if (isBgParamUsable) {
            throw new OtherBillBizException(OtherBillBizException.BG_PARAM_USEABLE, new Object[]{billName});
        }
    }
}

