/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.ar.SummaryRptQueryParam;
import com.kingdee.eas.fi.ar.app.ArApReportHelper;
import com.kingdee.eas.fi.ar.app.RptAp2PrerecTransSql;
import com.kingdee.eas.fi.ar.app.RptApApVPay_PaySql;
import com.kingdee.eas.fi.ar.app.RptApArVAp_ApSql;
import com.kingdee.eas.fi.ar.app.RptApBillSql;
import com.kingdee.eas.fi.ar.app.RptApPrePayVPreRec_PayVRecSql;
import com.kingdee.eas.fi.ar.app.RptApPreRecVPrePay_RecVPaySql;
import com.kingdee.eas.fi.ar.app.RptApTransSql;
import com.kingdee.eas.fi.ar.app.RptApVPay_ApVArSql;
import com.kingdee.eas.fi.ar.app.RptAr2PrepayTransSql;
import com.kingdee.eas.fi.ar.app.RptArBillSql;
import com.kingdee.eas.fi.ar.app.RptArPrePayVPreRec_PayVRecSql;
import com.kingdee.eas.fi.ar.app.RptArPreRecVPrePay_RecVPaySql;
import com.kingdee.eas.fi.ar.app.RptArTransSql;
import com.kingdee.eas.fi.ar.app.RptArVRecBadVRec_RecSql;
import com.kingdee.eas.fi.ar.app.RptArVRec_ArVApSql;
import com.kingdee.eas.fi.ar.app.RptAr_ApVArSql;
import com.kingdee.eas.fi.ar.app.RptBadAcctSql;
import com.kingdee.eas.fi.ar.app.RptBadRecASql;
import com.kingdee.eas.fi.ar.app.RptBadRec_BadSql;
import com.kingdee.eas.fi.ar.app.RptPay2ArTransSql;
import com.kingdee.eas.fi.ar.app.RptPayBillSql;
import com.kingdee.eas.fi.ar.app.RptPayTransSql;
import com.kingdee.eas.fi.ar.app.RptRec2ApTransSql;
import com.kingdee.eas.fi.ar.app.RptRecBillSql;
import com.kingdee.eas.fi.ar.app.RptRecTransSql;
import com.kingdee.eas.fi.arap.app.util.TempTableUtil;
import com.kingdee.eas.fi.arap.util.CollectionUtil;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class ArApBiSumRptHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.ArApBiSumRptHelper");
    public static final String CRTL = " \r\n ";

    private ArApBiSumRptHelper() {
    }

    public static SchemaSource readySchemaSource(Context ctx, RptParams params, Class caller) throws BOSException, EASBizException {
        SummaryRptQueryParam qryParam = (SummaryRptQueryParam)((Object)params.getObject("qryParam"));
        ArApBiSumRptHelper.checkParamValid(qryParam);
        if (!qryParam.isMultiCompanys()) {
            qryParam.setCompanyId(qryParam.getCompanyIds().get(0).toString());
        }
        PeriodCollection periods = null;
        if (qryParam.isByPeriod()) {
            String companyId = qryParam.getCompanyId();
            periods = ArApReportHelper.getPeriodCollection(ctx, (java.util.Date)qryParam.getBeginDate(), (java.util.Date)qryParam.getEndDate(), companyId);
            if (periods == null || periods.size() == 0) {
                throw new ArApCommonException(ArApCommonException.DATERANGE_INVALID);
            }
        }
        SchemaSource ss = new SchemaSource();
        ss.setCaller(caller);
        ss.setFilename("RptSummary.xml");
        ArApBiSumRptHelper.initDimensions(ctx, qryParam, periods, ss);
        String compsBalTbl = ArApBiSumRptHelper.getCompanysBalTable(ctx, qryParam, periods);
        ss.setProperty("releaseTempTable", (Object)compsBalTbl);
        ss.setDataItem("Fact", "select * from " + compsBalTbl + " where FIsFinal = 1", null);
        ArApBiSumRptHelper.setRptHeadTitle(ctx, ss, qryParam.isArRpt());
        int currPrecision = 4;
        if (!qryParam.isAllCurrency()) {
            currPrecision = qryParam.getCurrencyInfo().getPrecision();
        }
        StringBuffer amtFormat = new StringBuffer();
        amtFormat.append("#,##0.");
        for (int i = 0; i < currPrecision; ++i) {
            amtFormat.append("0");
        }
        ss.setMdx(ArApBiSumRptHelper.getMdx(ctx, qryParam));
        ss.setMacroValue("amtFormatStr", amtFormat.toString());
        return ss;
    }

    public static void checkParamValid(SummaryRptQueryParam param) throws EASBizException {
        boolean fCompIdsNull;
        if (param == null) {
            throw new ArApCommonException(ArApCommonException.RPT_PARAM_NULL);
        }
        ArrayList<String> ids = param.getCompanyIds();
        boolean bl = fCompIdsNull = ids == null || ids.size() == 0;
        if (fCompIdsNull && StringUtils.isEmpty((String)param.getCompanyId())) {
            throw new ArApCommonException(ArApCommonException.COMPANY_NULL);
        }
        if (StringUtils.isEmpty((String)param.getCussTypeId())) {
            throw new ArApCommonException(ArApCommonException.NOTSETASSTTYPE);
        }
        if (param.getBeginDate() == null || param.getEndDate() == null || param.getBeginDate().after(param.getEndDate())) {
            throw new ArApCommonException(ArApCommonException.DATERANGE_INVALID);
        }
        if (fCompIdsNull) {
            ids = new ArrayList<String>();
            ids.add(param.getCompanyId());
            param.setCompanyIds(ids);
        }
    }

    public static void initDimensions(Context ctx, SummaryRptQueryParam param, PeriodCollection periods, SchemaSource ss) throws BOSException, EASBizException {
        ArApBiSumRptHelper.initCompanyDimension(ctx, param, ss);
        String nameFld = ArApReportHelper.getNameFld(ctx);
        StringBuffer sql = new StringBuffer();
        sql.delete(0, sql.length());
        sql.append("select fid, ").append(nameFld);
        sql.append(" fname, fnumber from t_bd_currency ");
        sql.append(" where ");
        SqlParams currParam = new SqlParams();
        if (param.isAllCurrency()) {
            sql.append(" FId != ? and FId != ? ");
            currParam.addString(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString());
            currParam.addString(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString());
        } else {
            sql.append(" FId = ?");
            currParam.addString(param.getCurrencyId());
        }
        ss.setDataItem("Currency", sql.toString(), currParam);
        sql.delete(0, sql.length());
        sql.append("select FId, ").append(nameFld);
        sql.append(" FName, FNumber from t_bd_AsstActType where fid = ? ");
        SqlParams sqlParam = new SqlParams();
        sqlParam.addString(param.getCussTypeId());
        ss.setDataItem("CussType", sql.toString(), sqlParam);
        ArApBiSumRptHelper.initCussAcctDimension(ctx, param, ss);
        if (param.isByPeriod()) {
            ArrayList<BOSUuid> ids = new ArrayList<BOSUuid>();
            int n = periods.size();
            for (int i = 0; i < n; ++i) {
                ids.add(periods.get(i).getId());
            }
            sql.delete(0, sql.length());
            sql.append("select FId, to_char(FPeriodyear) || '-' ||");
            sql.append("to_char(FPeriodNumber) FName");
            sql.append(", FPeriodyear* 100 + FPeriodNumber FOrder");
            sql.append(" from t_bd_period where fId in (");
            sql.append(CollectionUtil.toSqlString(ids)).append(")");
            ss.setDataItem("Period", sql.toString(), null);
        } else {
            Date beginDate = param.getBeginDate();
            Date endDate = param.getEndDate();
            SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
            String rangeDesc = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"dateRangeDesc", (Locale)ctx.getLocale());
            rangeDesc = MessageFormat.format(rangeDesc, dtFormat.format(beginDate), dtFormat.format(endDate));
            sql.delete(0, sql.length());
            sql.append("select '1111' FId, '").append(rangeDesc);
            sql.append("' FName, 1 FOrder \r\n ");
            ss.setDataItem("Period", sql.toString(), null);
        }
    }

    private static void initCompanyDimension(Context ctx, SummaryRptQueryParam param, SchemaSource ss) throws BOSException, EASBizException {
        String nameFld = ArApReportHelper.getNameFld(ctx);
        List companyIds = param.getCompanyIds();
        boolean fComps = companyIds.size() > 1;
        StringBuffer sql = new StringBuffer();
        String compTblDefine = " (FId varchar(44), FNumber nvarchar(80), FName nvarchar(200), FParentid varchar(44)) ";
        String compTbl = TempTableUtil.createTempTable(ctx, compTblDefine);
        TempTablePool t = TempTablePool.getInstance((Context)ctx);
        try {
            t.createIndex(compTbl, "FId", false, false);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (fComps) {
            Connection con = null;
            Statement stmt = null;
            try {
                con = EJBFactory.getConnection((Context)ctx);
                stmt = con.createStatement();
                sql.append("insert into ").append(compTbl);
                sql.append(" (FId, FNumber, FName, FParentId) ");
                sql.append("\r\n select fid, fnumber, ").append(nameFld);
                sql.append(" fname, fparentid from ");
                sql.append(" t_org_company where fid in (");
                sql.append(CollectionUtil.ids2SqlString(companyIds));
                sql.append(") ");
                logger.debug((Object)("insert comp table \r\n " + sql));
                stmt.execute(sql.toString());
                try {
                    t.analyzeTable(con, compTbl);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
                param.setCompanyTempTable(compTbl);
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"exception, preprare compids ", (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt, (Connection)con);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)con);
        }
        if (fComps) {
            sql.delete(0, sql.length());
            sql.append("select FId, FName, FNumber, FParentId from ");
            sql.append(compTbl);
            ss.setDataItem("Company", sql.toString(), null);
        } else {
            sql.append("select FId, ").append(nameFld);
            sql.append(" FName, FNumber, FParentId from ");
            sql.append(" t_org_company where fid = ? ");
            SqlParams sqlParam = new SqlParams();
            sqlParam.addString(companyIds.get(0).toString());
            ss.setDataItem("Company", sql.toString(), sqlParam);
        }
    }

    private static void initCussAcctDimension(Context ctx, SummaryRptQueryParam param, SchemaSource ss) throws BOSException, EASBizException {
        String cussAcctTbl = ArApReportHelper.getCussAcctTempTbl(ctx, param, param.getCompanyIds());
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FId, FNumber || N' ' || ");
        sql.append("case when FName is null then N' ' else FName end as FName");
        sql.append(", FNumber from ").append(cussAcctTbl);
        ss.setDataItem("CussAcct", sql.toString(), null);
    }

    public static RptTableHeader getRptTableHeader(Context ctx, SummaryRptQueryParam param) {
        Locale locale = ctx.getLocale();
        String res = "com.kingdee.eas.fi.arap.ArApRptResource";
        String[] fields = null;
        int amtStartIndex = 0;
        if (!param.isBaseCurrency()) {
            fields = !"base".equals(param.getCurrencyId()) ? new String[]{"FRowId", "FCurrencyId", "FCurrency", "FPeriodId", "FPeriod", "FAsstActTypeId", "FAsstActType", "FAsstActId", "FCussAcct", "FCompanyId", "FCompany", "FPeriodStartBal", "FPeriodDebit", "FPeriodCredit", "FYearDebit", "FYearCredit", "FPeriodBal"} : new String[]{"FRowId", "FBaseCurrencyId", "FBaseCurrency", "FPeriodId", "FPeriod", "FAsstActTypeId", "FAsstActType", "FAsstActId", "FCussAcct", "FCompanyId", "FCompany", "FBeginBalanceLocal", "FDebitLocal", "FCreditLocal", "FYearDebitLocal", "FYearCreditLocal", "FPeriodBalLocal"};
            amtStartIndex = 11;
        } else {
            fields = new String[]{"FRowId", "FCurrencyId", "FCurrency", "FBaseCurrencyId", "FBaseCurrency", "FPeriodId", "FPeriod", "FAsstActTypeId", "FAsstActType", "FAsstActId", "FCussAcct", "FCompanyId", "FCompany", "FPeriodStartBal", "FBeginBalanceLocal", "FPeriodDebit", "FDebitLocal", "FPeriodCredit", "FCreditLocal", "FYearDebit", "FYearDebitLocal", "FYearCredit", "FYearCreditLocal", "FPeriodBal", "FPeriodBalLocal"};
            amtStartIndex = 13;
        }
        String[] fieldResMapping = param.isArRpt() ? (!param.isBaseCurrency() ? (!"base".equals(param.getCurrencyId()) ? new String[]{"", "", "Currency", "", "Period", "", "CussType", "", "CussAcct", "", "Company", "PeriodStartBalance", "PeriodArDebit", "PeriodArCredit", "YearArDebit", "YearArCredit", "PeriodBalance"} : new String[]{"", "", "BaseCurrency", "", "Period", "", "CussType", "", "CussAcct", "", "Company", "BasePeriodStartBalance", "BasePeriodArDebit", "BasePeriodArCredit", "BaseYearArDebit", "BaseYearArCredit", "BasePeriodBalance"}) : new String[]{"", "", "Currency", "", "BaseCurrency", "", "Period", "", "CussType", "", "CussAcct", "", "Company", "PeriodStartBalance", "BasePeriodStartBalance", "PeriodArDebit", "BasePeriodArDebit", "PeriodArCredit", "BasePeriodArCredit", "YearArDebit", "BaseYearArDebit", "YearArCredit", "BaseYearArCredit", "PeriodBalance", "BasePeriodBalance"}) : (!param.isBaseCurrency() ? (!"base".equals(param.getCurrencyId()) ? new String[]{"", "", "Currency", "", "Period", "", "CussType", "", "CussAcct", "", "Company", "PeriodStartBalance", "PeriodApDebit", "PeriodApCredit", "YearApDebit", "YearApCredit", "PeriodBalance"} : new String[]{"", "", "BaseCurrency", "", "Period", "", "CussType", "", "CussAcct", "", "Company", "BasePeriodStartBalance", "BasePeriodApDebit", "BasePeriodApCredit", "BaseYearApDebit", "BaseYearApCredit", "BasePeriodBalance"}) : new String[]{"", "", "Currency", "", "BaseCurrency", "", "Period", "", "CussType", "", "CussAcct", "", "Company", "PeriodStartBalance", "BasePeriodStartBalance", "PeriodApDebit", "BasePeriodApDebit", "PeriodApCredit", "BasePeriodApCredit", "YearApDebit", "BaseYearApDebit", "YearApCredit", "BaseYearApCredit", "PeriodBalance", "BasePeriodBalance"});
        Object[][] labels = new String[1][fields.length];
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        int size = fields.length;
        for (int i = 0; i < size; ++i) {
            col = new RptTableColumn(fields[i]);
            if (i >= amtStartIndex) {
                col.setAligment(2);
                if (!param.isByPeriod() && ("FYearDebit".equals(fields[i]) || "FYearDebitLocal".equals(fields[i]) || "FYearCreditLocal".equals(fields[i]) || "FYearCredit".equals(fields[i]))) {
                    col.setHided(true);
                    col.setWidth(0);
                } else {
                    col.setWidth(120);
                }
            } else if (!param.isMultiCompanys() && "FCompany".equals(fields[i]) || fields[i].endsWith("Id")) {
                col.setHided(true);
                col.setWidth(0);
            }
            labels[0][i] = ResourceBase.getString((String)res, (String)fieldResMapping[i], (Locale)locale);
            header.addColumn(col);
        }
        header.setLabels(labels);
        return header;
    }

    public static void setRptHeadTitle(Context ctx, SchemaSource ss, boolean fAr) {
        Locale locale = ctx.getLocale();
        String res = "com.kingdee.eas.fi.arap.ArApRptResource";
        ss.setMacroValue("companyCaption", ResourceBase.getString((String)res, (String)"Company", (Locale)locale));
        ss.setMacroValue("cussTypeCaption", ResourceBase.getString((String)res, (String)"CussType", (Locale)locale));
        ss.setMacroValue("cussAcctCaption", ResourceBase.getString((String)res, (String)"CussAcct", (Locale)locale));
        ss.setMacroValue("currencyCaption", ResourceBase.getString((String)res, (String)"Currency", (Locale)locale));
        ss.setMacroValue("periodCaption", ResourceBase.getString((String)res, (String)"Period", (Locale)locale));
        ss.setMacroValue("amountCaption", ResourceBase.getString((String)res, (String)"Amt", (Locale)locale));
        ss.setMacroValue("beginPeriodBalanceCaption", ResourceBase.getString((String)res, (String)"PeriodStartBalance", (Locale)locale));
        ss.setMacroValue("currentPeriodDebit", ResourceBase.getString((String)res, (String)(fAr ? "PeriodArDebit" : "PeriodApDebit"), (Locale)locale));
        ss.setMacroValue("currentPeriodCredit", ResourceBase.getString((String)res, (String)(fAr ? "PeriodArCredit" : "PeriodApCredit"), (Locale)locale));
        ss.setMacroValue("currentYearDebit", ResourceBase.getString((String)res, (String)(fAr ? "YearArDebit" : "YearApDebit"), (Locale)locale));
        ss.setMacroValue("currentYearCredit", ResourceBase.getString((String)res, (String)(fAr ? "YearArCredit" : "YearApCredit"), (Locale)locale));
        ss.setMacroValue("endPeriodBalance", ResourceBase.getString((String)res, (String)"PeriodBalance", (Locale)locale));
    }

    public static String getCompanysBalTable(Context ctx, SummaryRptQueryParam qryParam, PeriodCollection periods) throws BOSException, EASBizException {
        ResultSet rs;
        Statement stmt2;
        Statement stmt;
        Connection con;
        String tempTbl;
        block23: {
            String tblStruct = ArApBiSumRptHelper.tempBalTblStruct(qryParam);
            tempTbl = TempTableUtil.createTempTable(ctx, tblStruct);
            List ids = qryParam.getCompanyIds();
            Date qryBeginDate = qryParam.getBeginDate();
            Date qryEndDate = qryParam.getEndDate();
            PeriodInfo qryStartPeriod = qryParam.isByPeriod() ? periods.get(0) : PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)qryBeginDate, (IObjectPK)new ObjectUuidPK(qryParam.getCompanyId()));
            String qryStartPeriodId = qryStartPeriod.getId().toString();
            con = null;
            stmt = null;
            stmt2 = null;
            rs = null;
            String compPeriodSql = ArApBiSumRptHelper.getCompanyPeriodSql(ids, qryParam.isArRpt());
            StringBuffer sql = new StringBuffer();
            try {
                String delSql;
                con = EJBFactory.getConnection((Context)ctx);
                qryParam.setTempTable(tempTbl);
                if ("base".equals(qryParam.getCurrencyId())) {
                    sql.append("insert into ").append(tempTbl);
                    sql.append(" (FCompanyId, FPeriodId,");
                    sql.append(" FBaseCurrencyId, FAsstActId,");
                    sql.append("FAsstActTypeID, FIsFinal,");
                    sql.append(" FBeginBalanceLocal,");
                    sql.append(" FYearDebitLocal,");
                    sql.append(" FYearCreditLocal,");
                    sql.append(" FDebitLocal,");
                    sql.append(" FCreditLocal,");
                    sql.append(" FPeriodBalLocal) \r\n ");
                } else if (!"base".equals(qryParam.getCurrencyId()) && !qryParam.isBaseCurrency()) {
                    sql.append("insert into ").append(tempTbl);
                    sql.append(" (FCompanyId, FPeriodId,");
                    sql.append(" FCurrencyId, FAsstActId,");
                    sql.append("FAsstActTypeID, FIsFinal,");
                    sql.append(" FPeriodStartBal,");
                    sql.append(" FYearDebit,");
                    sql.append(" FYearCredit,");
                    sql.append(" FPeriodDebit,");
                    sql.append(" FPeriodCredit,");
                    sql.append(" FPeriodBal) \r\n ");
                } else if (!"base".equals(qryParam.getCurrencyId()) && qryParam.isBaseCurrency()) {
                    sql.append("insert into ").append(tempTbl);
                    sql.append(" (FCompanyId, FPeriodId,");
                    sql.append(" FCurrencyId, FBaseCurrencyID, FAsstActId,");
                    sql.append("FAsstActTypeID, FIsFinal,");
                    sql.append(" FPeriodStartBal,");
                    sql.append(" FBeginBalanceLocal,");
                    sql.append(" FYearDebit,");
                    sql.append(" FYearDebitLocal,");
                    sql.append(" FYearCredit,");
                    sql.append(" FYearCreditLocal,");
                    sql.append(" FPeriodDebit,");
                    sql.append(" FDebitLocal,");
                    sql.append(" FPeriodCredit,");
                    sql.append(" FCreditLocal,");
                    sql.append(" FPeriodBal, \r\n ");
                    sql.append(" FPeriodBalLocal) \r\n ");
                }
                stmt = con.createStatement();
                stmt2 = con.createStatement();
                logger.debug((Object)("companys currPeriod sql \r\n" + compPeriodSql));
                rs = stmt.executeQuery(compPeriodSql);
                Date endDate = qryParam.getEndDate();
                if (!qryParam.isByPeriod()) {
                    Date endNxtDate = new Date(endDate.getTime() + 86400000L);
                    qryParam.setEndDate(endNxtDate);
                }
                while (rs.next()) {
                    String compId = rs.getString(1);
                    String curPeriodId = rs.getString(2);
                    Date currPeriodBeginDate = rs.getDate(3);
                    Date startPeriodBeginDate = rs.getDate(5);
                    if (startPeriodBeginDate.after(qryEndDate)) continue;
                    String dataStartPeriodId = null;
                    Date dataStartBeginDate = null;
                    if (qryBeginDate.before(currPeriodBeginDate)) {
                        dataStartPeriodId = qryStartPeriodId;
                        dataStartBeginDate = new Date(qryStartPeriod.getBeginDate().getTime());
                    } else {
                        dataStartPeriodId = curPeriodId;
                        dataStartBeginDate = currPeriodBeginDate;
                    }
                    qryParam.setNotInit(false);
                    String startSql = sql.toString() + ArApBiSumRptHelper.getStartDataSql(ctx, qryParam, compId, dataStartPeriodId, qryStartPeriodId, dataStartBeginDate);
                    logger.debug((Object)("startPeriod data sql: \r\n " + startSql));
                    stmt2.execute(startSql);
                    qryParam.setNotInit(true);
                    ArApBiSumRptHelper.computeBizData(ctx, qryParam, compId, curPeriodId, currPeriodBeginDate, periods, qryStartPeriod, stmt2, sql);
                }
                try {
                    TempTablePool.getInstance((Context)ctx).analyzeTable(con, tempTbl);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                String sumSql = sql + ArApBiSumRptHelper.sumDataSql(tempTbl, qryParam);
                logger.debug((Object)("sum sql: \r\n " + sumSql));
                stmt2.execute(sumSql);
                if ("base".equals(qryParam.getCurrencyId())) {
                    if (qryParam.isBalZero()) {
                        delSql = "delete " + tempTbl + " where FPeriodBalLocal = 0 and FIsFinal = 1";
                        logger.debug((Object)("delBal sql: \r\n" + delSql));
                        stmt2.execute(delSql);
                    }
                    if (qryParam.isBizZero()) {
                        delSql = "delete " + tempTbl + " where (FDebitLocal = 0 and FCreditLocal = 0) and FIsFinal = 1";
                        logger.debug((Object)("delBiz sql: \r\n" + delSql));
                        stmt2.execute(delSql);
                    }
                    break block23;
                }
                if (!"base".equals(qryParam.getCurrencyId()) && !qryParam.isBaseCurrency()) {
                    if (qryParam.isBalZero()) {
                        delSql = "delete " + tempTbl + " where FPeriodBal = 0 and FIsFinal = 1";
                        logger.debug((Object)("delBal sql: \r\n" + delSql));
                        stmt2.execute(delSql);
                    }
                    if (qryParam.isBizZero()) {
                        delSql = "delete " + tempTbl + " where (FPeriodDebit = 0 and FPeriodCredit = 0) and FIsFinal = 1";
                        logger.debug((Object)("delBiz sql: \r\n" + delSql));
                        stmt2.execute(delSql);
                    }
                    break block23;
                }
                if ("base".equals(qryParam.getCurrencyId()) || !qryParam.isBaseCurrency()) break block23;
                if (qryParam.isBalZero()) {
                    delSql = "delete " + tempTbl + " where FPeriodBal = 0 and FPeriodBalLocal = 0 and FIsFinal = 1";
                    logger.debug((Object)("delBal sql: \r\n" + delSql));
                    stmt2.execute(delSql);
                }
                if (qryParam.isBizZero()) {
                    delSql = "delete " + tempTbl + " where (FPeriodDebit = 0 and FPeriodCredit = 0 and FDebitLocal = 0 and FCreditLocal = 0) and FIsFinal = 1";
                    logger.debug((Object)("delBiz sql: \r\n" + delSql));
                    stmt2.execute(delSql);
                }
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"exception while query companys summ Rpt", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt2);
                    SQLUtils.cleanup(rs, stmt, (Connection)con);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)stmt2);
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return tempTbl;
    }

    private static void computeBizData(Context ctx, SummaryRptQueryParam qryParam, String companyId, String currPeriodId, Date currPeriodBeginDate, PeriodCollection periods, PeriodInfo qryStartPeriod, Statement stmt2, StringBuffer sqlPrefix) throws SQLException, BOSException {
        Date qryBeginDate = qryParam.getBeginDate();
        Date qryEndDate = qryParam.getEndDate();
        qryParam.setCompanyId(companyId);
        if (qryParam.isByPeriod()) {
            int n = periods.size();
            PeriodInfo prePeriodInfo = qryStartPeriod;
            String prePeriodId = periods.get(0).getId().toString();
            Date firstPeriodEndDate = new Date(prePeriodInfo.getEndDate().getTime() + 86400000L);
            qryParam.setEndDate(firstPeriodEndDate);
            String firstPeriodSql = null;
            if (!qryStartPeriod.getBeginDate().before(currPeriodBeginDate)) {
                firstPeriodSql = sqlPrefix.toString() + ArApBiSumRptHelper.dateRangeBizDataSql(ctx, qryParam, prePeriodId);
                logger.debug((Object)("summRpt firstPeriodDataSql: \r\n " + firstPeriodSql));
                stmt2.execute(firstPeriodSql);
                if (qryParam.getString("releaseTempTable") != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(qryParam.getString("releaseTempTable"));
                    qryParam.remove("releaseTempTable");
                }
            }
            boolean fYearDiff = false;
            for (int i = 1; i < n; ++i) {
                PeriodInfo periodInfo = periods.get(i);
                String periodId = periodInfo.getId().toString();
                qryParam.setBeginDate(periodInfo.getBeginDate());
                qryParam.setEndDate(new Date(periodInfo.getEndDate().getTime() + 86400000L));
                fYearDiff = prePeriodInfo.getPeriodYear() != periodInfo.getPeriodYear();
                String pSql = null;
                pSql = !periodInfo.getBeginDate().before(currPeriodBeginDate) ? sqlPrefix.toString() + ArApBiSumRptHelper.periodBizDataSql(ctx, qryParam, prePeriodId, periodId, fYearDiff) : sqlPrefix.toString() + ArApBiSumRptHelper.periodBalDataSql(qryParam, companyId, periodId);
                logger.debug((Object)("summRpt bizDataSql: \r\n " + pSql));
                stmt2.execute(pSql);
                if (qryParam.getString("releaseTempTable") != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(qryParam.getString("releaseTempTable"));
                    qryParam.remove("releaseTempTable");
                }
                prePeriodId = periodId;
                prePeriodInfo = periodInfo;
            }
        } else {
            String byDateSql = sqlPrefix.toString() + ArApBiSumRptHelper.dateRangeBizDataSql(ctx, qryParam, null);
            logger.debug((Object)("summRpt bizDataSql: \r\n " + byDateSql));
            stmt2.execute(byDateSql);
            if (qryParam.getString("releaseTempTable") != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(qryParam.getString("releaseTempTable"));
                qryParam.remove("releaseTempTable");
            }
        }
        qryParam.setBeginDate(qryBeginDate);
        qryParam.setEndDate(qryEndDate);
    }

    private static StringBuilder getZeroRowDataSql(SummaryRptQueryParam param, String companyId, String dataPeriodId) {
        StringBuilder sql = new StringBuilder(300);
        sql.append(" select '").append(companyId);
        sql.append("' FCompanyId, '").append(dataPeriodId);
        if ("base".equals(param.getCurrencyId())) {
            sql.append("' FPeriodId, t3.FBaseCurrencyID,");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append("' FPeriodId, t2.FId FCurrencyId,");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append("' FPeriodId, t2.FId FCurrencyId, t3.FBaseCurrencyID,");
        }
        sql.append(" t1.FId FAsstActId, '").append(param.getCussTypeId());
        sql.append("' FAsstActTypeId, 0 FIsFinal,\r\n");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" 0 FBeginBalanceLocal, 0 FYearDebitLocal, 0 FYearCreditLocal,");
            sql.append(" 0 FDebitLocal , 0 FCreditLocal , 0 FPeriodBalLocal");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" 0 FPeriodStartBal, 0 FYearDebit, 0 FYearCredit,");
            sql.append(" 0 FPeriodDebit , 0 FPeriodCredit , 0 FPeriodBal");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" 0 FPeriodStartBal, 0 FBeginBalanceLocal, 0 FYearDebit,     0 FYearDebitLocal, 0 FYearCredit, 0 FYearCreditLocal,");
            sql.append(" 0 FPeriodDebit,    0 FDebitLocal,        0 FPeriodCredit , 0 FCreditLocal,    0 FPeriodBal,  0 FPeriodBalLocal");
        }
        sql.append("\r\n from ").append(param.getCussAcctTempTable());
        sql.append(" t1 ,t_bd_currency t2, T_ORG_Company t3 where ");
        if (param.isAllCurrency()) {
            sql.append(" t2.Fid != '");
            sql.append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
            sql.append("' and t2.FId != '");
            sql.append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
            sql.append("' ");
        } else {
            sql.append(" t2.Fid = '").append(param.getCurrencyId()).append("' ");
        }
        sql.append(" and t3.FID='" + companyId + "'");
        return sql;
    }

    private static StringBuilder periodBalDataSql(SummaryRptQueryParam param, String companyId, String periodId) {
        StringBuilder sql = new StringBuilder(600);
        String dataPeriodId = param.isByPeriod() ? periodId : "1111";
        sql.append((CharSequence)ArApBiSumRptHelper.getZeroRowDataSql(param, companyId, dataPeriodId));
        sql.append(CRTL).append(" union all ").append(CRTL);
        boolean isBaseCurrency = "base".equals(param.getCurrencyId());
        boolean isShowBase = param.isBaseCurrency();
        sql.append(" select t1.FCompanyId, ");
        sql.append("'").append(dataPeriodId).append("'");
        sql.append(" FPeriodId, ").append(!isBaseCurrency || isShowBase ? " t1.FCurrencyId, " : "").append(CRTL);
        sql.append(isBaseCurrency || isShowBase ? " company.FBaseCurrencyID," : "");
        sql.append(" t1.FAsstActId, t1.FAsstActTypeId, 0 FIsFinal, ").append(CRTL);
        if (isBaseCurrency) {
            sql.append(" sum(t1.FBeginBalanceLocal) FBeginBalanceLocal, ");
            sql.append(" sum(t1.FYearDebitLocal) FYearDebitLocal ,");
            sql.append(" sum(t1.FYearCreditLocal) FYearCreditLocal ,").append(CRTL);
            sql.append(" sum(t1.FDebitLocal) FDebitLocal ,");
            sql.append(" sum(t1.FCreditLocal) FCreditLocal ,");
            sql.append(" sum(t1.FBeginBalanceLocal) + sum(t1.FDebitLocal) - sum(t1.FCreditLocal) FPeriodBalLocal ").append(CRTL);
        } else if (isShowBase) {
            sql.append(" sum(t1.FBeginBalanceFor) FPeriodStartBal, ");
            sql.append(" sum(t1.FBeginBalanceLocal) FBeginBalanceLocal, ");
            sql.append(" sum(t1.FYearDebitFor) FYearDebit ,");
            sql.append(" sum(t1.FYearDebitLocal) FYearDebitLocal ,");
            sql.append(" sum(t1.FYearCreditFor) FYearCredit ,");
            sql.append(" sum(t1.FYearCreditLocal) FYearCreditLocal ,").append(CRTL);
            sql.append(" sum(t1.FDebitFor) FPeriodDebit ,");
            sql.append(" sum(t1.FDebitLocal) FDebitLocal ,");
            sql.append(" sum(t1.FCreditFor) FPeriodCredit ,");
            sql.append(" sum(t1.FCreditLocal) FCreditLocal ,");
            sql.append(" sum(t1.FBeginBalanceFor) + sum(t1.FDebitFor) - sum(t1.FCreditFor) FPeriodBal, ");
            sql.append(" sum(t1.FBeginBalanceLocal) + sum(t1.FDebitLocal) - sum(t1.FCreditLocal) FPeriodBalLocal ").append(CRTL);
        } else {
            sql.append(" sum(t1.FBeginBalanceFor) FPeriodStartBal, ");
            sql.append(" sum(t1.FYearDebitFor) FYearDebit ,");
            sql.append(" sum(t1.FYearCreditFor) FYearCredit ,").append(CRTL);
            sql.append(" sum(t1.FDebitFor) FPeriodDebit ,");
            sql.append(" sum(t1.FCreditFor) FPeriodCredit ,");
            sql.append(" sum(t1.FBeginBalanceFor) + sum(t1.FDebitFor) - sum(t1.FCreditFor) FPeriodBal ").append(CRTL);
        }
        sql.append(" from ").append(param.isArRpt() ? "t_ar_ArBalance" : "t_ap_ApBalance").append(" t1").append(CRTL);
        if (isBaseCurrency || isShowBase) {
            sql.append(" INNER JOIN T_ORG_COMPANY COMPANY ON COMPANY.FID = T1.FCOMPANYID").append(CRTL);
        }
        sql.append(" WHERE 1=1 ");
        if (!param.isAllCurrency()) {
            sql.append(CRTL).append(" and t1.FCurrencyId = '");
            sql.append(param.getCurrencyId()).append("' ");
        }
        if (!StringUtils.isEmpty((String)param.getCussTypeId())) {
            sql.append(CRTL).append(" and t1.FAsstActTypeId = '");
            sql.append(param.getCussTypeId()).append("' ");
        }
        sql.append(CRTL).append(" and t1.FAsstActId in (select fid from ");
        sql.append(param.getCussAcctTempTable()).append(") ");
        sql.append(CRTL).append(" and t1.FCompanyId = '").append(companyId).append("' ");
        sql.append(" and t1.FPeriodId = '").append(periodId).append("'").append(CRTL);
        sql.append(" and t1.FBalType IN (");
        if (param.isBizeCheckBox()) {
            if (param.getBizeIndex() == 0) {
                sql.append(101 + (param.isArRpt() ? ",104" : "") + (param.isIncludeBizBill() ? ", 102" : "") + "," + 103);
            } else {
                sql.append(103);
            }
        } else {
            sql.append(101 + (param.isArRpt() ? ",104" : ""));
            sql.append(param.isIncludeBizBill() ? ", 102" : "");
        }
        sql.append(")").append(CRTL).append(" group by t1.FCompanyId, ");
        sql.append(param.isByPeriod() ? " t1.FPeriodId, " : "");
        sql.append(!isBaseCurrency || isShowBase ? " t1.FCurrencyId, " : "").append(CRTL);
        sql.append(isBaseCurrency || isShowBase ? " company.FBaseCurrencyID," : "");
        sql.append("  t1.FAsstActId, t1.FAsstActTypeId ");
        return sql;
    }

    public static String tempSumBalTblStruct() {
        StringBuffer tblStruct = new StringBuffer();
        tblStruct.append("(FCompanyId varchar(44), FParentCompanyId varchar(44), FCompLongNumber nvarchar(80),");
        tblStruct.append(" FCompany nvarchar(255), FIsCompLeaf int, FComplevel int,");
        tblStruct.append(" FPeriodId varchar(44), FPeriodYear int, FPeriodNumber int,");
        tblStruct.append(" FCurrencyId varchar(44), FCurrNum varchar(80), FCurrency nvarchar(80), FCurrPrecision int,");
        tblStruct.append(" FAsstActTypeId varchar(44), FAsstActType nvarchar(80),");
        tblStruct.append(" FAsstActId varchar(44), FAsstActNumber nvarchar(100), FCussAcct nvarchar(255),");
        tblStruct.append(" FPeriodStartBal NUMERIC(17,4) NOT NULL DEFAULT 0,");
        tblStruct.append(" FYearDebit NUMERIC(17,4) NOT NULL DEFAULT 0,");
        tblStruct.append(" FYearCredit NUMERIC(17,4) NOT NULL DEFAULT 0,");
        tblStruct.append(" FPeriodDebit NUMERIC(17,4) NOT NULL DEFAULT 0,");
        tblStruct.append(" FPeriodCredit NUMERIC(17,4) NOT NULL DEFAULT 0,");
        tblStruct.append(" FPeriodBal NUMERIC(17,4) NOT NULL DEFAULT 0,");
        tblStruct.append(" FIsSum int default 0)");
        return tblStruct.toString();
    }

    public static String tempSumBalTblStruct(SummaryRptQueryParam qryParam) {
        StringBuffer tblStruct = new StringBuffer();
        if ("base".equals(qryParam.getCurrencyId())) {
            tblStruct.append("(FRowId varchar(44), FCompanyId varchar(44), FParentCompanyId varchar(44), FCompLongNumber nvarchar(80),");
            tblStruct.append(" FCompany nvarchar(255), FIsCompLeaf int, FComplevel int,");
            tblStruct.append(" FPeriodId varchar(44), FPeriodYear int, FPeriodNumber int,");
            tblStruct.append(" FBaseCurrencyId varchar(44), FBaseCurrNum varchar(80), FBaseCurrency nvarchar(80), FBaseCurrPrecision int,");
            tblStruct.append(" FAsstActTypeId varchar(44), FAsstActType nvarchar(80),");
            tblStruct.append(" FAsstActId varchar(44), FAsstActNumber nvarchar(100), FCussAcct nvarchar(255),");
            tblStruct.append(" FBeginBalanceLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FYearDebitLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FYearCreditLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FDebitLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FCreditLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FPeriodBalLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FIsSum int default 0)");
        } else if (!"base".equals(qryParam.getCurrencyId()) && !qryParam.isBaseCurrency()) {
            tblStruct.append("(FRowId varchar(44), FCompanyId varchar(44), FParentCompanyId varchar(44), FCompLongNumber nvarchar(80),");
            tblStruct.append(" FCompany nvarchar(255), FIsCompLeaf int, FComplevel int,");
            tblStruct.append(" FPeriodId varchar(44), FPeriodYear int, FPeriodNumber int,");
            tblStruct.append(" FCurrencyId varchar(44), FCurrNum varchar(80), FCurrency nvarchar(80), FCurrPrecision int,");
            tblStruct.append(" FAsstActTypeId varchar(44), FAsstActType nvarchar(80),");
            tblStruct.append(" FAsstActId varchar(44), FAsstActNumber nvarchar(100), FCussAcct nvarchar(255),");
            tblStruct.append(" FPeriodStartBal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FYearDebit NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FYearCredit NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FPeriodDebit NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FPeriodCredit NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FPeriodBal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FIsSum int default 0)");
        } else if (!"base".equals(qryParam.getCurrencyId()) && qryParam.isBaseCurrency()) {
            tblStruct.append("(FRowId varchar(44), FCompanyId varchar(44), FParentCompanyId varchar(44), FCompLongNumber nvarchar(80),");
            tblStruct.append(" FCompany nvarchar(255), FIsCompLeaf int, FComplevel int,");
            tblStruct.append(" FPeriodId varchar(44), FPeriodYear int, FPeriodNumber int,");
            tblStruct.append(" FCurrencyId varchar(44), FCurrNum varchar(80), FCurrency nvarchar(80), FCurrPrecision int,");
            tblStruct.append(" FBaseCurrencyID varchar(44), FBaseCurrNum varchar(80), FBaseCurrency nvarchar(80), FBaseCurrPrecision int,");
            tblStruct.append(" FAsstActTypeId varchar(44), FAsstActType nvarchar(80),");
            tblStruct.append(" FAsstActId varchar(44), FAsstActNumber nvarchar(100), FCussAcct nvarchar(255),");
            tblStruct.append(" FPeriodStartBal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FBeginBalanceLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FYearDebit NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FYearDebitLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FYearCredit NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FYearCreditLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FPeriodDebit NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FDebitLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FPeriodCredit NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FCreditLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FPeriodBal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FPeriodBalLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FIsSum int default 0)");
        }
        return tblStruct.toString();
    }

    public static String sumDataSql(String tempTbl, SummaryRptQueryParam param) {
        StringBuffer sql = new StringBuffer();
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" select FCompanyId, ");
            sql.append(" FPeriodId, FBaseCurrencyId,");
            sql.append(" FAsstActId, FAsstActTypeId, 1 FIsFinal, \r\n");
            sql.append(" sum(FBeginBalanceLocal) FBeginBalanceLocal, ");
            sql.append(" sum(FYearDebitLocal) FYearDebitLocal ,");
            sql.append(" sum(FYearCreditLocal) FYearCreditLocal ,");
            sql.append(" sum(FDebitLocal) FDebitLocal ,");
            sql.append(" sum(FCreditLocal) FCreditLocal ,");
            sql.append(" sum(FPeriodBalLocal) FPeriodBalLocal ");
            sql.append("\r\n from ").append(tempTbl);
            sql.append(" where FIsFinal = 0");
            sql.append("\r\n group by FCompanyId, FPeriodId, FBaseCurrencyId, ");
            sql.append("FAsstActId, FAsstActTypeId");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" select FCompanyId, ");
            sql.append(" FPeriodId, FCurrencyId,");
            sql.append(" FAsstActId, FAsstActTypeId, 1 FIsFinal, \r\n");
            sql.append(" sum(FPeriodStartBal) FPeriodStartBal, ");
            sql.append(" sum(FYearDebit) FYearDebit ,");
            sql.append(" sum(FYearCredit) FYearCredit ,");
            sql.append(" sum(FPeriodDebit) FPeriodDebit ,");
            sql.append(" sum(FPeriodCredit) FPeriodCredit ,");
            sql.append(" sum(FPeriodBal) FPeriodBal ");
            sql.append("\r\n from ").append(tempTbl);
            sql.append(" where FIsFinal = 0");
            sql.append("\r\n group by FCompanyId, FPeriodId, FCurrencyId, ");
            sql.append("FAsstActId, FAsstActTypeId");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" select FCompanyId, ");
            sql.append(" FPeriodId, FCurrencyId, FBaseCurrencyID,");
            sql.append(" FAsstActId, FAsstActTypeId, 1 FIsFinal, \r\n");
            sql.append(" sum(FPeriodStartBal) FPeriodStartBal, ");
            sql.append(" sum(FBeginBalanceLocal) FBeginBalanceLocal, ");
            sql.append(" sum(FYearDebit) FYearDebit ,");
            sql.append(" sum(FYearDebitLocal) FYearDebitLocal ,");
            sql.append(" sum(FYearCredit) FYearCredit ,");
            sql.append(" sum(FYearCreditLocal) FYearCreditLocal ,");
            sql.append(" sum(FPeriodDebit) FPeriodDebit ,");
            sql.append(" sum(FDebitLocal) FDebitLocal ,");
            sql.append(" sum(FPeriodCredit) FPeriodCredit ,");
            sql.append(" sum(FCreditLocal) FCreditLocal ,");
            sql.append(" sum(FPeriodBal) FPeriodBal, ");
            sql.append(" sum(FPeriodBalLocal) FPeriodBalLocal ");
            sql.append("\r\n from ").append(tempTbl);
            sql.append(" where FIsFinal = 0");
            sql.append("\r\n group by FCompanyId, FPeriodId, FCurrencyId, FBaseCurrencyID, ");
            sql.append("FAsstActId, FAsstActTypeId");
        }
        return sql.toString();
    }

    public static String tempBalTblStruct(SummaryRptQueryParam qryParam) {
        StringBuffer tblStruct = new StringBuffer();
        if ("base".equals(qryParam.getCurrencyId())) {
            tblStruct.append("(FCompanyId varchar(44), FPeriodId varchar(44),");
            tblStruct.append(" FBaseCurrencyId varchar(44), FAsstActId varchar(44),");
            tblStruct.append(" FAsstActTypeId varchar(44), FIsFinal int DEFAULT 0,");
            tblStruct.append(" FBeginBalanceLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FYearDebitLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FYearCreditLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FDebitLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FCreditLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FPeriodBalLocal NUMERIC(17,4) NOT NULL DEFAULT 0)");
        } else if (!"base".equals(qryParam.getCurrencyId()) && !qryParam.isBaseCurrency()) {
            tblStruct.append("(FCompanyId varchar(44), FPeriodId varchar(44),");
            tblStruct.append(" FCurrencyId varchar(44), FAsstActId varchar(44),");
            tblStruct.append(" FAsstActTypeId varchar(44), FIsFinal int DEFAULT 0,");
            tblStruct.append(" FPeriodStartBal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FYearDebit NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FYearCredit NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FPeriodDebit NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FPeriodCredit NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FPeriodBal NUMERIC(17,4) NOT NULL DEFAULT 0)");
        } else if (!"base".equals(qryParam.getCurrencyId()) && qryParam.isBaseCurrency()) {
            tblStruct.append("(FCompanyId varchar(44), FPeriodId varchar(44),");
            tblStruct.append(" FCurrencyId varchar(44), FBaseCurrencyID varchar(44), FAsstActId varchar(44),");
            tblStruct.append(" FAsstActTypeId varchar(44), FIsFinal int DEFAULT 0,");
            tblStruct.append(" FPeriodStartBal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FBeginBalanceLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FYearDebit NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FYearDebitLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FYearCredit NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FYearCreditLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FPeriodDebit NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FDebitLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FPeriodCredit NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FCreditLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FPeriodBal NUMERIC(17,4) NOT NULL DEFAULT 0,");
            tblStruct.append(" FPeriodBalLocal NUMERIC(17,4) NOT NULL DEFAULT 0)");
        }
        return tblStruct.toString();
    }

    public static String tempBalTblStruct() {
        StringBuffer tblStruct = new StringBuffer();
        tblStruct.append("(FCompanyId varchar(44), FPeriodId varchar(44),");
        tblStruct.append(" FCurrencyId varchar(44), FBaseCurrencyID varchar(44), FAsstActId varchar(44),");
        tblStruct.append(" FAsstActTypeId varchar(44), FIsFinal int DEFAULT 0,");
        tblStruct.append(" FPeriodStartBal NUMERIC(17,4) NOT NULL DEFAULT 0,");
        tblStruct.append(" FBeginBalanceLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
        tblStruct.append(" FYearDebit NUMERIC(17,4) NOT NULL DEFAULT 0,");
        tblStruct.append(" FYearDebitLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
        tblStruct.append(" FYearCredit NUMERIC(17,4) NOT NULL DEFAULT 0,");
        tblStruct.append(" FYearCreditLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
        tblStruct.append(" FPeriodDebit NUMERIC(17,4) NOT NULL DEFAULT 0,");
        tblStruct.append(" FDebitLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
        tblStruct.append(" FPeriodCredit NUMERIC(17,4) NOT NULL DEFAULT 0,");
        tblStruct.append(" FCreditLocal NUMERIC(17,4) NOT NULL DEFAULT 0,");
        tblStruct.append(" FPeriodBal NUMERIC(17,4) NOT NULL DEFAULT 0,");
        tblStruct.append(" FPeriodBalLocal NUMERIC(17,4) NOT NULL DEFAULT 0)");
        return tblStruct.toString();
    }

    public static String sumDataSql(String tempTbl) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FCompanyId, ");
        sql.append(" FPeriodId, FCurrencyId,");
        sql.append(" FAsstActId, FAsstActTypeId, 1 FIsFinal, \r\n");
        sql.append(" sum(FPeriodStartBal) FPeriodStartBal, ");
        sql.append(" sum(FYearDebit) FYearDebit ,");
        sql.append(" sum(FYearCredit) FYearCredit ,");
        sql.append(" sum(FPeriodDebit) FPeriodDebit ,");
        sql.append(" sum(FPeriodCredit) FPeriodCredit ,");
        sql.append(" sum(FPeriodBal) FPeriodBal ");
        sql.append("\r\n from ").append(tempTbl);
        sql.append(" where FIsFinal = 0");
        sql.append("\r\n group by FCompanyId, FPeriodId, FCurrencyId, ");
        sql.append("FAsstActId, FAsstActTypeId");
        return sql.toString();
    }

    public static String getCompanyPeriodSql(Collection companyIds, boolean fAR) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.FCompanyId, t1.FCurrentPeriodId,");
        sql.append(" t4.FBeginDate FCurrPrdBeginDate, ");
        sql.append(" t1.FStartPeriodId, t5.FBeginDate FStartPrdBeginDate");
        sql.append("\r\n from T_BD_SystemStatusCtrol t1");
        sql.append("\r\n left join T_BD_SystemStatus t2 on");
        sql.append(" t1.FSystemStatusId = t2.FId\r\n left join t_org_company");
        sql.append(" t3 on t1.FCompanyId = t3.FId\r\n left join ");
        sql.append(" t_bd_period t4 on t1.FCurrentPeriodId = t4.FId ");
        sql.append("\r\n left join t_bd_period t5 on t5.FId = ");
        sql.append(" t1.FStartPeriodId ");
        sql.append("\r\n where t3.FId in (");
        sql.append(CollectionUtil.ids2SqlString(companyIds));
        sql.append(")\r\n and t2.FName = ");
        sql.append(fAR ? 12 : 13);
        sql.append(" and t3.FIsBizUnit = 1");
        sql.append(" and t1.FCurrentPeriodId is not null ");
        return sql.toString();
    }

    public static String getStartDataSql(Context ctx, SummaryRptQueryParam param, String companyId, String dataStartPeriodId, String qryStartPeriodId, Date dataStartBeginDate) throws BOSException, EASBizException, SQLException {
        StringBuffer sql = new StringBuffer();
        String dataPeriodId = param.isByPeriod() ? qryStartPeriodId : "1111";
        sql.append((CharSequence)ArApBiSumRptHelper.getZeroRowDataSql(param, companyId, dataPeriodId));
        sql.append(" \r\n union all \r\n");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" select t1.FCompanyId, '").append(dataPeriodId);
            sql.append("' FPeriodId, t2.FBaseCurrencyId,");
            sql.append(" t1.FAsstActId, t1.FAsstActTypeId, 0 FIsFinal, ");
            sql.append("\r\n sum(t1.FBeginBalanceLocal) FBeginBalanceLocal, ");
            if (param.isByPeriod()) {
                sql.append(" sum(t1.FYearDebitLocal) FYearDebitLocal,");
                sql.append(" sum(t1.FYearCreditLocal) FYearCreditLocal,");
                sql.append("\r\n sum(t1.FDebitLocal) FDebitLocal ,");
                sql.append(" sum(t1.FCreditLocal) FCreditLocal ,");
                sql.append(" sum(t1.FBeginBalanceLocal) + sum(t1.FDebitLocal) - ");
                sql.append(" sum(t1.FCreditLocal)  FPeriodBalLocal \r\n from ");
            } else {
                sql.append(" 0 FYearDebitLocal,");
                sql.append(" 0 FYearCreditLocal,");
                sql.append("\r\n 0 FDebitLocal , 0 FCreditLocal ,");
                sql.append(" sum(t1.FBeginBalanceLocal)  FBeginBalanceLocal \r\n from ");
            }
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" select t1.FCompanyId, '").append(dataPeriodId);
            sql.append("' FPeriodId, t1.FCurrencyId,");
            sql.append(" t1.FAsstActId, t1.FAsstActTypeId, 0 FIsFinal, ");
            sql.append("\r\n sum(t1.FBeginBalanceFor) FPeriodStartBal, ");
            if (param.isByPeriod()) {
                sql.append(" sum(t1.FYearDebitFor) FYearDebit,");
                sql.append(" sum(t1.FYearCreditFor) FYearCredit,");
                sql.append("\r\n sum(t1.FDebitFor) FPeriodDebit ,");
                sql.append(" sum(t1.FCreditFor) FPeriodCredit ,");
                sql.append(" sum(t1.FBeginBalanceFor) + sum(t1.FDebitFor) - ");
                sql.append(" sum(t1.FCreditFor)  FPeriodBal \r\n from ");
            } else {
                sql.append(" 0 FYearDebit,");
                sql.append(" 0 FYearCredit,");
                sql.append("\r\n 0 FPeriodDebit , 0 FPeriodCredit ,");
                sql.append(" sum(t1.FBeginBalanceFor)  FPeriodBal \r\n from ");
            }
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" select t1.FCompanyId, '").append(dataPeriodId);
            sql.append("' FPeriodId, t1.FCurrencyId, t2.FBaseCurrencyID,");
            sql.append(" t1.FAsstActId, t1.FAsstActTypeId, 0 FIsFinal, ");
            sql.append("\r\n sum(t1.FBeginBalanceFor) FPeriodStartBal, sum(t1.FBeginBalanceLocal) FBeginBalanceLocal,");
            if (param.isByPeriod()) {
                sql.append(" sum(t1.FYearDebitFor) FYearDebit, sum(t1.FYearDebitLocal) FYearDebitLocal,");
                sql.append(" sum(t1.FYearCreditFor) FYearCredit, sum(t1.FYearCreditLocal) FYearCreditLocal,");
                sql.append("\r\n sum(t1.FDebitFor) FPeriodDebit , sum(t1.FDebitLocal) FDebitLocal,");
                sql.append(" sum(t1.FCreditFor) FPeriodCredit , sum(t1.FCreditLocal) FCreditLocal,");
                sql.append(" sum(t1.FBeginBalanceFor) + sum(t1.FDebitFor) - ");
                sql.append(" sum(t1.FCreditFor)  FPeriodBal,");
                sql.append(" sum(t1.FBeginBalanceLocal) + sum(t1.FDebitLocal) - ");
                sql.append(" sum(t1.FCreditLocal)  FPeriodBalLocal \r\n from ");
            } else {
                sql.append(" 0 FYearDebit, 0 FYearDebitLocal,");
                sql.append(" 0 FYearCredit,0 FYearCreditLocal,");
                sql.append("\r\n 0 FPeriodDebit, 0 FDebitLocal, 0 FPeriodCredit, 0 FCreditLocal,");
                sql.append(" sum(t1.FBeginBalanceFor)  FPeriodBal,");
                sql.append(" sum(t1.FBeginBalanceLocal)  FPeriodBalLocal \r\n from ");
            }
        }
        sql.append(param.isArRpt() ? "t_ar_ArBalance" : "t_ap_ApBalance");
        sql.append(" t1, T_ORG_Company t2\r\n where 1=1 ");
        sql.append(" and t2.FID='" + companyId + "'");
        if (!param.isAllCurrency()) {
            sql.append("\r\n and t1.FCurrencyId = '");
            sql.append(param.getCurrencyId()).append("' ");
        }
        if (!StringUtils.isEmpty((String)param.getCussTypeId())) {
            sql.append("\r\n and t1.FAsstActTypeId = '");
            sql.append(param.getCussTypeId()).append("' ");
        }
        sql.append("\r\n and t1.FAsstActId in (select fid from ");
        sql.append(param.getCussAcctTempTable()).append(") ");
        sql.append("\r\n and t1.FCompanyId = '");
        sql.append(companyId);
        sql.append("' and t1.FPeriodId = '");
        sql.append(dataStartPeriodId).append("' \r\n");
        sql.append(" and t1.FBalType IN (");
        if (param.isBizeCheckBox()) {
            if (param.getBizeIndex() == 0) {
                sql.append(101 + (param.isArRpt() ? ",104" : "") + ", 102" + "," + 103);
            } else {
                sql.append(103);
            }
        } else {
            sql.append(101 + (param.isArRpt() ? ",104" : "") + ", " + 102);
        }
        sql.append(") and t1.FBalType IN (");
        if (param.isIncludeBizBill()) {
            if (param.getIncludeBizIndex() == 0) {
                sql.append(101 + (param.isArRpt() ? ",104" : "") + ", 102" + "," + 103);
            } else {
                sql.append(102);
            }
        } else {
            sql.append(101 + (param.isArRpt() ? ",104" : "") + ", " + 103);
        }
        if ("base".equals(param.getCurrencyId())) {
            sql.append(")\r\n group by t1.FCompanyId, ");
            sql.append(param.isByPeriod() ? "FPeriodId, " : "");
            sql.append("t2.FBaseCurrencyId, t1.FAsstActId, t1.FAsstActTypeId ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(")\r\n group by t1.FCompanyId, ");
            sql.append(param.isByPeriod() ? "FPeriodId, " : "");
            sql.append("t1.FCurrencyId, t1.FAsstActId, t1.FAsstActTypeId ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(")\r\n group by t1.FCompanyId, ");
            sql.append(param.isByPeriod() ? "FPeriodId, " : "");
            sql.append("t1.FCurrencyId, t2.FBaseCurrencyID, t1.FAsstActId, t1.FAsstActTypeId ");
        }
        Date qryBeginDate = param.getBeginDate();
        Date qryEndDate = param.getEndDate();
        if (qryBeginDate.after(dataStartBeginDate)) {
            param.setBeginDate(dataStartBeginDate);
            param.setEndDate(qryBeginDate);
            sql.append("\r\n  union all \r\n");
            sql.append(ArApBiSumRptHelper.currPeriodToQueryStartDataSql(ctx, param, companyId, qryStartPeriodId));
            param.setBeginDate(qryBeginDate);
            param.setEndDate(qryEndDate);
        }
        return sql.toString();
    }

    public static StringBuffer periodBizDataSql(Context ctx, SummaryRptQueryParam param, String prePeriodId, String periodId, boolean fYearDiff) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" select FCompanyId, '").append(periodId);
            sql.append("' FPeriodId, FBaseCurrencyId, ");
            sql.append(" FAsstActId, FAsstActTypeId, 0 FIsFinal, ");
            sql.append(" sum(FBeginBalanceLocal) FBeginBalanceLocal, ");
            sql.append(fYearDiff ? "0" : "sum(FYearDebitLocal)");
            sql.append(" FYearDebitLocal ,");
            sql.append(fYearDiff ? "0" : "sum(FYearCreditLocal)");
            sql.append(" FYearCreditLocal,");
            sql.append(" 0 FDebitLocal, 0 FCreditLocal,");
            sql.append(" sum(FPeriodBalLocal) FPeriodBalLocal ");
            sql.append("\r\n from ").append(param.getTempTable());
            sql.append(" where 1=1 and FPeriodId = '");
            sql.append(prePeriodId).append("' \r\n");
            sql.append(" and FCompanyId='");
            sql.append(param.getCompanyId()).append("' \r\n");
            sql.append("group by FCompanyId, FBaseCurrencyId, ");
            sql.append("FAsstActId, FAsstActTypeId ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" select FCompanyId, '").append(periodId);
            sql.append("' FPeriodId, FCurrencyId, ");
            sql.append(" FAsstActId, FAsstActTypeId, 0 FIsFinal, ");
            sql.append(" sum(FPeriodBal) FPeriodStartBal, ");
            sql.append(fYearDiff ? "0" : "sum(FYearDebit)");
            sql.append(" FYearDebit ,");
            sql.append(fYearDiff ? "0" : "sum(FYearCredit)");
            sql.append(" FYearCredit,");
            sql.append(" 0 FPeriodDebit, 0 FPeriodCredit,");
            sql.append(" sum(FPeriodBal) FPeriodBal ");
            sql.append("\r\n from ").append(param.getTempTable());
            sql.append(" where 1=1 and FPeriodId = '");
            sql.append(prePeriodId).append("' \r\n");
            sql.append(" and FCompanyId='");
            sql.append(param.getCompanyId()).append("' \r\n");
            sql.append("group by FCompanyId, FCurrencyId, ");
            sql.append("FAsstActId, FAsstActTypeId ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" select FCompanyId, '").append(periodId);
            sql.append("' FPeriodId, FCurrencyId, FBaseCurrencyID,");
            sql.append(" FAsstActId, FAsstActTypeId, 0 FIsFinal, ");
            sql.append(" sum(FPeriodBal) FPeriodStartBal, ");
            sql.append(" sum(FBeginBalanceLocal) FBeginBalanceLocal, ");
            sql.append(fYearDiff ? "0" : "sum(FYearDebit)");
            sql.append(" FYearDebit ,");
            sql.append(fYearDiff ? "0" : "sum(FYearDebitLocal)");
            sql.append(" FYearDebitLocal ,");
            sql.append(fYearDiff ? "0" : "sum(FYearCredit)");
            sql.append(" FYearCredit,");
            sql.append(fYearDiff ? "0" : "sum(FYearCreditLocal)");
            sql.append(" FYearCreditLocal ,");
            sql.append(" 0 FPeriodDebit, 0 FDebitLocal, 0 FPeriodCredit, 0 FCreditLocal,");
            sql.append(" sum(FPeriodBal) FPeriodBal, ");
            sql.append(" sum(FPeriodBalLocal) FPeriodBalLocal ");
            sql.append("\r\n from ").append(param.getTempTable());
            sql.append(" where 1=1 and FPeriodId = '");
            sql.append(prePeriodId).append("' \r\n");
            sql.append(" and FCompanyId='");
            sql.append(param.getCompanyId()).append("' \r\n");
            sql.append("group by FCompanyId, FCurrencyId, FBaseCurrencyID, ");
            sql.append("FAsstActId, FAsstActTypeId ");
        }
        sql.append("\r\n union all \r\n");
        sql.append(ArApBiSumRptHelper.dateRangeBizDataSql(ctx, param, periodId));
        return sql;
    }

    private static StringBuffer currPeriodToQueryStartDataSql(Context ctx, SummaryRptQueryParam param, String companyId, String periodId) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" select tBiz.FCompanyId, ");
            if (param.isByPeriod()) {
                sql.append(" '").append(periodId).append("' ");
            } else {
                sql.append(" '1111' ");
            }
            sql.append(" FPeriodId, tBiz.FBaseCurrencyId,");
            sql.append(" tBiz.FAsstActId, tBiz.FAsstActTypeId, 0 FIsFinal, ");
            sql.append("sum(tBiz.FDebitAmtLocal - tBiz.FCreditAmtLocal) FBeginBalanceLocal, ");
            sql.append(" sum(tBiz.FDebitAmtLocal) FDebitAmtLocal ,");
            sql.append(" sum(tBiz.FCreditAmtLocal) FYearCreditLocal ,");
            sql.append(" 0 FDebitLocal ,");
            sql.append(" 0 FCreditLocal ,");
            sql.append(" sum(tBiz.FDebitAmtLocal - tBiz.FCreditAmtLocal)  FPeriodBalLocal ");
            sql.append(" \r\n  from \r\n   ");
            param.setCompanyId(companyId);
            sql.append(ArApBiSumRptHelper.viewDataSql(ctx, param));
            sql.append("\r\n tBiz ");
            sql.append("\r\n group by FCompanyId, ");
            sql.append("FBaseCurrencyId");
            sql.append(", FAsstActId, FAsstActTypeId ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" select tBiz.FCompanyId, ");
            if (param.isByPeriod()) {
                sql.append(" '").append(periodId).append("' ");
            } else {
                sql.append(" '1111' ");
            }
            sql.append(" FPeriodId, tBiz.FCurrencyId,");
            sql.append(" tBiz.FAsstActId, tBiz.FAsstActTypeId, 0 FIsFinal, ");
            sql.append("sum(tBiz.FDebitAmt - tBiz.FCreditAmt) FPeriodStartBal, ");
            sql.append(" sum(tBiz.FDebitAmt) FYearDebit ,");
            sql.append(" sum(tBiz.FCreditAmt) FYearCredit ,");
            sql.append(" 0 FPeriodDebit ,");
            sql.append(" 0 FPeriodCredit ,");
            sql.append(" sum(tBiz.FDebitAmt - tBiz.FCreditAmt)  FPeriodBal ");
            sql.append(" \r\n  from \r\n   ");
            param.setCompanyId(companyId);
            sql.append(ArApBiSumRptHelper.viewDataSql(ctx, param));
            sql.append("\r\n tBiz ");
            sql.append("\r\n group by FCompanyId, ");
            sql.append("FCurrencyId");
            sql.append(", FAsstActId, FAsstActTypeId ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" select tBiz.FCompanyId, ");
            if (param.isByPeriod()) {
                sql.append(" '").append(periodId).append("' ");
            } else {
                sql.append(" '1111' ");
            }
            sql.append(" FPeriodId, tBiz.FCurrencyId, tBiz.FBaseCurrencyId,");
            sql.append(" tBiz.FAsstActId, tBiz.FAsstActTypeId, 0 FIsFinal, ");
            sql.append("sum(tBiz.FDebitAmt - tBiz.FCreditAmt) FPeriodStartBal, ");
            sql.append("sum(tBiz.FDebitAmtLocal - tBiz.FCreditAmtLocal) FBeginBalanceLocal, ");
            sql.append(" sum(tBiz.FDebitAmt) FYearDebit ,");
            sql.append(" sum(tBiz.FDebitAmtLocal) FYearDebitLocal ,");
            sql.append(" sum(tBiz.FCreditAmt) FYearCredit ,");
            sql.append(" sum(tBiz.FCreditAmtLocal) FYearCreditLocal ,");
            sql.append(" 0 FPeriodDebit ,");
            sql.append(" 0 FDebitLocal ,");
            sql.append(" 0 FPeriodCredit ,");
            sql.append(" 0 FCreditLocal ,");
            sql.append(" sum(tBiz.FDebitAmt - tBiz.FCreditAmt)  FPeriodBal, ");
            sql.append(" sum(tBiz.FDebitAmtLocal - tBiz.FCreditAmtLocal)  FPeriodBalLocal ");
            sql.append(" \r\n  from \r\n   ");
            param.setCompanyId(companyId);
            sql.append(ArApBiSumRptHelper.viewDataSql(ctx, param));
            sql.append("\r\n tBiz ");
            sql.append("\r\n group by FCompanyId, ");
            sql.append("FCurrencyId, FBaseCurrencyId");
            sql.append(", FAsstActId, FAsstActTypeId ");
        }
        return sql;
    }

    public static StringBuffer dateRangeBizDataSql(Context ctx, SummaryRptQueryParam param, String periodId) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        String tempTable = ArApBiSumRptHelper.viewDataSql(ctx, param);
        param.setString("releaseTempTable", tempTable);
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" select tBiz.FCompanyId, ");
            if (param.isByPeriod()) {
                sql.append(" '").append(periodId).append("' ");
            } else {
                sql.append(" '1111' ");
            }
            sql.append(" FPeriodId, tBiz.FBaseCurrencyId,");
            sql.append(" tBiz.FAsstActId, tBiz.FAsstActTypeId, ");
            sql.append(" 0 FIsFinal, 0 FBeginBalanceLocal, ");
            sql.append(" sum(tBiz.FDebitAmtLocal) FYearDebitLocal ,");
            sql.append(" sum(tBiz.FCreditAmtLocal) FYearCreditLocal ,");
            sql.append(" sum(tBiz.FDebitAmtLocal) FDebitLocal ,");
            sql.append(" sum(tBiz.FCreditAmtLocal) FCreditLocal ,");
            sql.append(" sum(tBiz.FDebitAmtLocal - tBiz.FCreditAmtLocal) FPeriodBalLocal ");
            sql.append(" \r\n  from \r\n   ");
            sql.append(tempTable);
            sql.append("\r\n    tBiz ");
            sql.append(" where FCompanyId = '").append(param.getCompanyId()).append("'");
            sql.append("\r\n group by FCompanyId, ");
            sql.append("FBaseCurrencyId");
            sql.append(", FAsstActId, FAsstActTypeId ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" select tBiz.FCompanyId, ");
            if (param.isByPeriod()) {
                sql.append(" '").append(periodId).append("' ");
            } else {
                sql.append(" '1111' ");
            }
            sql.append(" FPeriodId, tBiz.FCurrencyId,");
            sql.append(" tBiz.FAsstActId, tBiz.FAsstActTypeId, ");
            sql.append(" 0 FIsFinal, 0 FPeriodStartBal, ");
            sql.append(" sum(tBiz.FDebitAmt) FYearDebit ,");
            sql.append(" sum(tBiz.FCreditAmt) FYearCredit ,");
            sql.append(" sum(tBiz.FDebitAmt) FPeriodDebit ,");
            sql.append(" sum(tBiz.FCreditAmt) FPeriodCredit ,");
            sql.append(" sum(tBiz.FDebitAmt - tBiz.FCreditAmt) FPeriodBal ");
            sql.append(" \r\n  from \r\n   ");
            sql.append(tempTable);
            sql.append("\r\n    tBiz ");
            sql.append(" where FCompanyId = '").append(param.getCompanyId()).append("'");
            sql.append("\r\n group by FCompanyId, ");
            sql.append("FCurrencyId");
            sql.append(", FAsstActId, FAsstActTypeId ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" select tBiz.FCompanyId, ");
            if (param.isByPeriod()) {
                sql.append(" '").append(periodId).append("' ");
            } else {
                sql.append(" '1111' ");
            }
            sql.append(" FPeriodId, tBiz.FCurrencyId,");
            sql.append(" tBiz.FBaseCurrencyID,");
            sql.append(" tBiz.FAsstActId, tBiz.FAsstActTypeId, ");
            sql.append(" 0 FIsFinal, 0 FPeriodStartBal, 0 FBeginBalanceLocal,");
            sql.append(" sum(tBiz.FDebitAmt) FYearDebit , sum(tBiz.FDebitAmtLocal) FYearDebitLocal,");
            sql.append(" sum(tBiz.FCreditAmt) FYearCredit , sum(tBiz.FCreditAmtLocal) FYearCreditLocal,");
            sql.append(" sum(tBiz.FDebitAmt) FPeriodDebit , sum(tBiz.FDebitAmtLocal) FDebitLocal,");
            sql.append(" sum(tBiz.FCreditAmt) FPeriodCredit , sum(tBiz.FCreditAmtLocal) FCreditLocal,");
            sql.append(" sum(tBiz.FDebitAmt - tBiz.FCreditAmt) FPeriodBal, sum(tBiz.FDebitAmtLocal - tBiz.FCreditAmtLocal) FPeriodBalLocal ");
            sql.append(" \r\n  from \r\n   ");
            sql.append(tempTable);
            sql.append("\r\n    tBiz ");
            sql.append(" where FCompanyId = '").append(param.getCompanyId()).append("'");
            sql.append("\r\n group by FCompanyId, ");
            sql.append("FCurrencyId, FBaseCurrencyID");
            sql.append(", FAsstActId, FAsstActTypeId ");
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String viewDataSql(Context ctx, SummaryRptQueryParam param) throws SQLException, BOSException {
        String tempTbl = "";
        Connection con = null;
        Statement stmt = null;
        try {
            StringBuffer tblStruct = new StringBuffer();
            tblStruct.append("(FCompanyId varchar(44), ");
            if ("base".equals(param.getCurrencyId())) {
                tblStruct.append(" FBaseCurrencyId varchar(44), FAsstActId varchar(44),");
                tblStruct.append(" FAsstActTypeID varchar(44),");
                tblStruct.append(" FDebitAmtLocal NUMERIC(19,4)  DEFAULT 0,");
                tblStruct.append(" FCreditAmtLocal NUMERIC(19,4) DEFAULT 0)");
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                tblStruct.append(" FCurrencyId varchar(44), FAsstActId varchar(44),");
                tblStruct.append(" FAsstActTypeID varchar(44),");
                tblStruct.append(" FDebitAmt NUMERIC(19,4)  DEFAULT 0,");
                tblStruct.append(" FCreditAmt NUMERIC(19,4) DEFAULT 0)");
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                tblStruct.append(" FCurrencyId varchar(44), FBaseCurrencyID varchar(44), FAsstActId varchar(44),");
                tblStruct.append(" FAsstActTypeID varchar(44),");
                tblStruct.append(" FDebitAmt NUMERIC(19,4)  DEFAULT 0,");
                tblStruct.append(" FCreditAmt NUMERIC(19,4) DEFAULT 0,");
                tblStruct.append(" FDebitAmtLocal NUMERIC(19,4)  DEFAULT 0,");
                tblStruct.append(" FCreditAmtLocal NUMERIC(19,4) DEFAULT 0)");
            }
            tempTbl = TempTableUtil.createTempTable(ctx, tblStruct.toString());
            con = EJBFactory.getConnection((Context)ctx);
            stmt = con.createStatement();
            StringBuffer sql = new StringBuffer();
            sql.append("insert into ").append(tempTbl);
            if ("base".equals(param.getCurrencyId())) {
                sql.append("(FCompanyId, FBaseCurrencyID, FAsstActTypeID, FAsstActId, FDebitAmtLocal, FCreditAmtLocal) ");
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                sql.append("(FCompanyId, FCurrencyId, FAsstActTypeID, FAsstActId, FDebitAmt, FCreditAmt) ");
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                sql.append("(FCompanyId, FCurrencyId, FBaseCurrencyID, FAsstActTypeID, FAsstActId, FDebitAmt, FCreditAmt, FDebitAmtLocal, FCreditAmtLocal) ");
            }
            if (param.isArRpt()) {
                stmt.execute(sql + new RptArBillSql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptRecBillSql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptBadAcctSql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptBadRecASql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptBadRec_BadSql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptArVRec_ArVApSql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptArVRecBadVRec_RecSql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptArPreRecVPrePay_RecVPaySql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptAr_ApVArSql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptArPrePayVPreRec_PayVRecSql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptArTransSql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptRecTransSql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptAr2PrepayTransSql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptRec2ApTransSql().getCompanysSummQuerySql(param));
            } else {
                stmt.execute(sql + new RptApBillSql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptPayBillSql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptApVPay_ApVArSql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptApApVPay_PaySql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptApPrePayVPreRec_PayVRecSql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptApArVAp_ApSql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptApPreRecVPrePay_RecVPaySql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptApTransSql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptPayTransSql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptAp2PrerecTransSql().getCompanysSummQuerySql(param));
                stmt.execute(sql + new RptPay2ArTransSql().getCompanysSummQuerySql(param));
            }
            try {
                TempTablePool.getInstance((Context)ctx).analyzeTable(con, tempTbl);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(stmt, con);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
        return tempTbl.toString();
    }

    public static String getMdx(Context ctx, SummaryRptQueryParam param) {
        boolean fComps = param.getCompanyIds().size() > 1;
        boolean fAllCurr = param.isAllCurrency();
        String sumLbl = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport.Lbl_Sum", (Locale)ctx.getLocale());
        StringBuffer mdx = new StringBuffer();
        mdx.append(" with ");
        mdx.append(" member [CussAcct].[").append(sumLbl);
        mdx.append("] as 'sum([CussAcct].members)' \r\n");
        mdx.append(" member [Company].[").append(sumLbl);
        mdx.append("] as 'sum([Company].levels(0).members)' \r\n");
        mdx.append(" select [Measures].members on columns, \r\n");
        mdx.append("non empty (");
        mdx.append(fAllCurr ? " [Currency].members*" : "");
        mdx.append(" [Period].members*[CussType].members");
        if (fComps) {
            mdx.append("*union([CussAcct].members");
            mdx.append("*[Company].levels(0).members");
            mdx.append(", [CussAcct].[").append(sumLbl);
            mdx.append("]*[Company].[").append(sumLbl).append("])");
        } else {
            mdx.append("*{[CussAcct].members, [CussAcct].[");
            mdx.append(sumLbl).append("]}");
        }
        mdx.append(") on rows");
        mdx.append("\r\n from bizAmt");
        logger.debug((Object)("arap sumRpt mdx: \r\n " + mdx));
        return mdx.toString();
    }

    public static StringBuffer getFetchDataSql(Context ctx, SummaryRptQueryParam param, List idList) throws BOSException {
        StringBuffer sql = new StringBuffer(100);
        sql.append("select * from ").append(param.getTempTable());
        sql.append(" where 1 = 1");
        if (null != idList && idList.size() > 0) {
            sql.append("\r\n and FRowId in (");
            for (int i = 0; i < idList.size(); ++i) {
                sql.append("'").append(idList.get(i)).append("'");
                if (i == idList.size() - 1) continue;
                sql.append(",");
            }
            sql.append(") ");
        }
        if (param.isMultiCompanys()) {
            Set CompanyNumSet = ArApReportHelper.getCompanyNums(ctx, param.getTempTable());
            if (CompanyNumSet.size() > 0) {
                sql.append("\r\n and FCompLongNumber in (");
                Iterator it = CompanyNumSet.iterator();
                String CompanyNum = null;
                int i = 0;
                while (it.hasNext()) {
                    CompanyNum = (String)it.next();
                    if (i > 0) {
                        sql.append(" , ");
                    }
                    sql.append(" '").append(CompanyNum).append("' ");
                    ++i;
                }
                sql.append(" ) ");
            }
            sql.append(" or FCompLongNumber is null");
        }
        if ("base".equals(param.getCurrencyId())) {
            sql.append(ArApBiSumRptHelper.getSumRptOrderSql(true));
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(ArApBiSumRptHelper.getSumRptOrderSql());
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(ArApBiSumRptHelper.getSumRptOrderSql(false));
        }
        return sql;
    }

    public static String getSumRptOrderSql(boolean isAllBase) {
        if (isAllBase) {
            return " order by FBaseCurrNum, FPeriodYear, FPeriodNumber, FIsSum, FAsstActType, FAsstActNumber, FCompLongNumber";
        }
        return " order by FCurrNum, FBaseCurrNum, FPeriodYear, FPeriodNumber, FIsSum, FAsstActType, FAsstActNumber, FCompLongNumber";
    }

    public static String getSumRptOrderSql() {
        return " order by FCurrNum, FPeriodYear, FPeriodNumber, FIsSum, FAsstActType, FAsstActNumber, FCompLongNumber";
    }
}

