/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.app.AbstractArApSwapFacadeControllerBean;
import com.kingdee.eas.fi.ar.app.util.ArApSwapBadDebtUtils;
import com.kingdee.eas.fi.ar.app.util.ArApSwapBaseUtils;
import com.kingdee.eas.fi.ar.app.util.ArApSwapBillDataUtils;
import com.kingdee.eas.fi.ar.app.util.ArApSwapCheckUtils;
import com.kingdee.eas.fi.ar.app.util.ArApSwapInitialUtils;
import com.kingdee.eas.fi.ar.app.util.ArApSwapTempTableHelper;
import com.kingdee.eas.fi.ar.app.util.ArApSwapUtils;
import com.kingdee.eas.fi.ar.app.util.ArApSwapVerUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArApSwapFacadeControllerBean
extends AbstractArApSwapFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.ArApSwapFacadeControllerBean");
    Date curEndDate = new Date();
    StringBuffer currencyIDBuf = new StringBuffer();

    @Override
    protected Map _getParams(Context ctx, List paramNumberList) throws BOSException, EASBizException {
        HashMap paramMap = new HashMap();
        Iterator iterator = paramNumberList.iterator();
        IParamControl iParam = ParamControlFactory.getLocalInstance((Context)ctx);
        String companyId = null;
        companyId = ContextUtil.getCurrentFIUnit((Context)ctx) != null ? ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() : this.getNextCompanyId(ctx);
        String[] paramNumbers = null;
        int size = paramNumberList.size();
        if (paramNumberList != null && size > 0) {
            paramNumbers = new String[size];
            for (int i = 0; i < size; ++i) {
                paramNumbers[i] = (String)paramNumberList.get(i);
            }
            paramMap = iParam.getParamHashMap(paramNumbers, companyId);
        }
        return paramMap;
    }

    public String getNextCompanyId(Context ctx) throws BOSException, EASBizException {
        IOrgUnitCommon iCom = OrgUnitCommonFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo comInfo = iCom.getRootCompany();
        if (comInfo != null) {
            return comInfo.getId().toString();
        }
        return null;
    }

    @Override
    protected IRowSet _getExchangeRateData(Context ctx, Map params) throws BOSException {
        IRowSet rowSet = null;
        try {
            String companyIDs = UIRuleUtil.getString(params.get("companyIDs"));
            String baseCurrencyId = UIRuleUtil.getString(params.get("baseCurrencyId"));
            Date periodBeginDate = UIRuleUtil.getDateValue(params.get("periodBeginDate"));
            Date periodEndDate = UIRuleUtil.getDateValue(params.get("periodEndDate"));
            if (!"".equals(companyIDs) && !"".equals(baseCurrencyId)) {
                StringBuffer strBuf = new StringBuffer();
                strBuf.append("SELECT ").append("\r\n");
                strBuf.append("sourceCurrency.FID AS sourceCurrencyID,").append("\r\n");
                strBuf.append("sourceCurrency.FNumber AS sourceCurrencyNo,").append("\r\n");
                strBuf.append("sourceCurrency.FName_l2 AS sourceCurrencyName,").append("\r\n");
                strBuf.append("targetCurrency.FName_L2 targetCurrencyName,").append("\r\n");
                strBuf.append("exchangeRate.FConvertRate AS convertRate,").append("\r\n");
                strBuf.append("exchangeRate.FConvertRate AS swapRate").append("\r\n");
                strBuf.append("FROM T_BD_Currency sourceCurrency").append("\r\n");
                strBuf.append("LEFT JOIN T_BD_exchangeAux exchangeAux ON exchangeAux.FsourceCurrencyID = sourceCurrency.FID").append("\r\n");
                strBuf.append("LEFT JOIN T_BD_Currency targetCurrency ON exchangeAux.FTargetCurrencyID = targetCurrency.FID").append("\r\n");
                strBuf.append("LEFT JOIN T_BD_exchangeRate exchangeRate ON exchangeRate.FexchangeAuxID = exchangeAux.FID").append("\r\n");
                strBuf.append("LEFT JOIN T_BD_exchangeTable exchangeTable ON exchangeTable.FID = exchangeAux.FexchangeTableId").append("\r\n");
                strBuf.append("WHERE 1=1").append("\r\n");
                strBuf.append("AND exchangeRate.FAvailTime<={d '" + periodEndDate + "'}").append("\r\n");
                strBuf.append("AND sourceCurrency.FID <> '" + baseCurrencyId + "'").append("\r\n");
                strBuf.append("AND (exchangeTable.FIsMulExchange = 1 OR (exchangeTable.FIsMulExchange <> 1) AND exchangeRate.FQuoteprice = 1)").append("\r\n");
                strBuf.append("ORDER BY exchangeRate.FAvailTime DESC").append("\r\n");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)strBuf.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowSet;
    }

    @Override
    protected String _checkBill(Context ctx, Map params) throws BOSException {
        boolean isRec = UIRuleUtil.getBooleanValue(params.get("isRec"));
        PeriodInfo periodInfo = (PeriodInfo)params.get("period");
        int periodNumber = periodInfo.getPeriodNumber();
        String preSwapNumber = periodInfo.getPeriodYear() + "" + periodNumber;
        this.curEndDate = periodInfo.getEndDate();
        String companyIDs = UIRuleUtil.getString(params.get("companyIDs"));
        Object[][] currencyGroup = (Object[][])params.get("currencyGroup");
        for (int i = 0; i < currencyGroup.length; ++i) {
            String currencyID = UIRuleUtil.getString((Object)currencyGroup[i][0]);
            if ("".equals(currencyID)) continue;
            this.currencyIDBuf.append("'" + currencyID + "',");
        }
        if (this.currencyIDBuf.length() > 0) {
            this.currencyIDBuf.deleteCharAt(this.currencyIDBuf.length() - 1);
        }
        StringBuffer messageVer = new StringBuffer();
        StringBuffer messageTrans = new StringBuffer();
        StringBuffer messageBadDebt = new StringBuffer();
        try {
            ArApSwapCheckUtils.checkVerificationBill(ctx, messageVer, companyIDs, this.curEndDate, isRec);
            ArApSwapCheckUtils.checkTransBill(ctx, messageTrans, this.currencyIDBuf, companyIDs, this.curEndDate, isRec);
            ArApSwapCheckUtils.checkBadDebt(ctx, messageBadDebt, companyIDs, this.curEndDate, isRec);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        String messageStr = messageVer.toString() + messageTrans.toString() + messageBadDebt.toString();
        return messageStr;
    }

    protected static String getResourceString(Context ctx, String key) {
        return EASResource.getString((String)"com.kingdee.eas.framework.report.CommRptResource", (String)key, (Locale)ctx.getOriginLocale());
    }

    @Override
    protected void _swapRate(Context ctx, Map params) throws BOSException, EASBizException {
        this.swapData(ctx, params);
    }

    private void swapData(Context ctx, Map params) throws BOSException, EASBizException {
        try {
            boolean isRec = UIRuleUtil.getBooleanValue(params.get("isRec"));
            PeriodInfo periodInfo = (PeriodInfo)params.get("period");
            String periodID = UIRuleUtil.getString((Object)periodInfo.getId());
            String preSwapNumber = "SW" + (isRec ? "AR" : "AP") + periodInfo.getNumber() + "";
            this.curEndDate = periodInfo.getEndDate();
            Object[][] currencyGroup = (Object[][])params.get("currencyGroup");
            for (int i = 0; i < currencyGroup.length; ++i) {
                String currencyID = UIRuleUtil.getString((Object)currencyGroup[i][0]);
                if ("".equals(currencyID)) continue;
                this.currencyIDBuf.append("'" + currencyID + "',");
            }
            if (this.currencyIDBuf.length() > 0) {
                this.currencyIDBuf.deleteCharAt(this.currencyIDBuf.length() - 1);
                String companyIDs = UIRuleUtil.getString(params.get("companyIDs"));
                String temp_SwapBill = ArApSwapTempTableHelper.getTempSwapBill(ctx);
                String temp_SwapBillEntry = ArApSwapTempTableHelper.getTempSwapBillEntry(ctx);
                String temp_VerTable = ArApSwapTempTableHelper.getVerTempTable(ctx);
                String temp_TranTable = ArApSwapTempTableHelper.getTranTempTable(ctx);
                ArApSwapInitialUtils.insertIntoTempTable(ctx, temp_SwapBill, temp_SwapBillEntry, currencyGroup, this.currencyIDBuf, this.curEndDate, periodID, companyIDs, isRec);
                ArApSwapVerUtils.initialVerData(ctx, this.currencyIDBuf, currencyGroup, temp_SwapBill, temp_SwapBillEntry, temp_VerTable, companyIDs, this.curEndDate, periodID, isRec);
                ArApSwapBadDebtUtils.initialBadDebtData(ctx, this.currencyIDBuf, currencyGroup, temp_SwapBill, temp_SwapBillEntry, companyIDs, this.curEndDate, periodID, isRec);
                ArApSwapBaseUtils.setConnection(ctx, temp_SwapBill, temp_SwapBillEntry, isRec);
                ArApSwapBaseUtils.setBillType(ctx, temp_SwapBill, isRec);
                ArApSwapVerUtils.updateVerificationData(ctx, temp_VerTable, this.curEndDate, isRec);
                ArApSwapUtils.swapBeforeEndDate(ctx, temp_SwapBill, temp_SwapBillEntry, temp_VerTable, temp_TranTable, this.curEndDate, isRec);
                ArApSwapUtils.updateProxyBill(ctx, temp_SwapBill, temp_SwapBillEntry, isRec);
                ArApSwapBillDataUtils.insertDataTable(ctx, temp_SwapBill, temp_SwapBillEntry, preSwapNumber, isRec);
                ArApSwapBillDataUtils.removeZeroData(ctx, isRec);
                ArApSwapBaseUtils.swapVourcher(ctx, temp_SwapBill, temp_SwapBillEntry, isRec);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

