/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.AccountAgeQueryParam;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.ar.app.ArApAgingRptSqlHelper;
import com.kingdee.eas.fi.ar.app.ArApReportHelper;
import com.kingdee.eas.fi.arap.app.util.TempTableUtil;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArApVirtualAgingRptHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.ArApVirtualAgingRptHelper");
    public static final String CRTL = " \r\n ";
    public static final String UN_DUE_COL_PREFIX = "ful_";
    public static final String OVER_DUE_COL_PREFIX = "fol_";
    private static Map<String, String> colKeyMap = new HashMap<String, String>(24);

    public static AccountAgeQueryParam getAgingParam(RptParams params) throws EASBizException {
        AccountAgeQueryParam param = (AccountAgeQueryParam)((Object)params.getObject("qryParam"));
        AccountAgeQueryParam timingParam = (AccountAgeQueryParam)((Object)params.getObject("qryParam-timeSetting"));
        ArApVirtualAgingRptHelper.checkParamValid(param);
        param.setUndueList(timingParam.getUndueList());
        param.setOverdueList(timingParam.getOverdueList());
        ArApVirtualAgingRptHelper.setDateList(param);
        return param;
    }

    private static void checkParamValid(AccountAgeQueryParam param) throws EASBizException {
        boolean fCompIdsNull;
        if (param == null) {
            throw new ArApCommonException(ArApCommonException.RPT_PARAM_NULL);
        }
        ArrayList<String> ids = param.getCompanyIds();
        boolean bl = fCompIdsNull = ids == null || ids.size() == 0;
        if (fCompIdsNull && StringUtils.isEmpty((String)param.getCompanyId())) {
            throw new ArApCommonException(ArApCommonException.COMPANY_NULL);
        }
        if (StringUtils.isEmpty((String)param.getCussTypeId())) {
            throw new ArApCommonException(ArApCommonException.NOTSETASSTTYPE);
        }
        if (param.getBeginDate() == null || param.getEndDate() == null || param.getBeginDate().after(param.getEndDate())) {
            throw new ArApCommonException(ArApCommonException.DATERANGE_INVALID);
        }
        if (fCompIdsNull) {
            ids = new ArrayList<String>();
            ids.add(param.getCompanyId());
            param.setCompanyIds(ids);
        }
    }

    private static void setDateList(AccountAgeQueryParam param) {
        List overdues;
        List undues = param.getUndueList();
        Date agingDate = param.getAgingCompareDate();
        Date date = null;
        Integer oInt = null;
        if (undues != null && undues.size() > 0) {
            ArrayList<Date> undueDates = new ArrayList<Date>();
            int n = undues.size();
            for (int i = 0; i < n; ++i) {
                oInt = Double.valueOf(String.valueOf(undues.get(i))).intValue();
                date = new Date(agingDate.getTime() + (long)oInt.intValue() * 86400000L);
                undueDates.add(date);
            }
            param.setUndueDateList(undueDates);
        }
        if ((overdues = param.getOverdueList()) != null && overdues.size() > 0) {
            ArrayList<Date> overdueDates = new ArrayList<Date>();
            int n = overdues.size();
            for (int i = 0; i < n; ++i) {
                oInt = Double.valueOf(String.valueOf(overdues.get(i))).intValue();
                date = new Date(agingDate.getTime() - (long)oInt.intValue() * 86400000L);
                overdueDates.add(date);
            }
            param.setOverdueDateList(overdueDates);
        }
    }

    public static RptTableHeader getRptTableHeader(AccountAgeQueryParam param, Locale locale) {
        List overdues;
        List undues;
        int i;
        RptTableHeader header = new RptTableHeader();
        List<String> rptFlds = param.getReportFields();
        int cols = rptFlds.size();
        int amtStartIndex = param.getAmtColStartIndex();
        Object[][] lables = new String[2][cols];
        String res = "com.kingdee.eas.fi.arap.ArApRptResource";
        String fld = null;
        String lable = null;
        int n = amtStartIndex = param.hasLocAmt() ? amtStartIndex : amtStartIndex + 1;
        for (i = 0; i < amtStartIndex; ++i) {
            fld = rptFlds.get(i);
            lables[0][i] = ArApVirtualAgingRptHelper.getColTitle(param, res, fld, locale);
        }
        if (param.hasLocAmt()) {
            lable = ArApVirtualAgingRptHelper.getColTitle(param, res, "balance", locale);
            lables[0][i++] = lable;
            lables[0][i++] = lable;
        }
        if ((undues = param.getUndueList()) != null && !undues.isEmpty()) {
            lable = ResourceBase.getString((String)res, (String)"Aging_Undue", (Locale)locale);
            int undueEnd = i + undues.size() - 1;
            if (param.hasLocAmt()) {
                undueEnd = i + undues.size() * 2 - 1;
            }
            while (i < cols && i <= undueEnd) {
                lables[0][i] = lable;
                ++i;
            }
        }
        if ((overdues = param.getOverdueList()) != null && !overdues.isEmpty()) {
            lable = ResourceBase.getString((String)res, (String)"Aging_Overdue", (Locale)locale);
            int overdueEnd = i + overdues.size() - 1;
            if (param.hasLocAmt()) {
                overdueEnd = i + overdues.size() * 2 - 1;
            }
            while (i < cols && i <= overdueEnd) {
                lables[0][i] = lable;
                ++i;
            }
        }
        String key = "dueamt";
        if (param.isBaseCurrency()) {
            key = key + "_bsc";
        }
        lable = ArApVirtualAgingRptHelper.getColTitle(param, res, key, locale);
        if (param.hasLocAmt()) {
            lables[0][i++] = lable;
        }
        lables[0][i] = lable;
        RptTableColumn col = null;
        for (int j = 0; j < cols; ++j) {
            fld = rptFlds.get(j).toLowerCase(Locale.ENGLISH);
            lables[1][j] = ArApVirtualAgingRptHelper.getColTitle(param, res, fld, locale);
            col = new RptTableColumn(fld);
            if (param.isAmtCol(fld)) {
                col.setWidth(120);
                col.setAligment(2);
            } else if (fld.endsWith("billdate")) {
                col.setFormatPattern(ArApBillUtil.getDateFormatString());
            } else if (fld.endsWith("id") || fld.endsWith("precision")) {
                col.setHided(true);
                col.setWidth(0);
            }
            header.addColumn(col);
        }
        header.setLabels(lables, true);
        return header;
    }

    private static String getUnOrOverDueColTitle(String res, String lowerCol, Locale locale, String prefix) {
        int lastIndex;
        if (StringUtils.isEmpty((String)res) || StringUtils.isEmpty((String)lowerCol) || StringUtils.isEmpty((String)prefix)) {
            return null;
        }
        String realKey = null;
        int firstIndex = lowerCol.indexOf("_");
        boolean hashLocAmt = firstIndex != (lastIndex = lowerCol.lastIndexOf("_"));
        String[] args = (hashLocAmt ? lowerCol.substring(firstIndex + 1, lastIndex) : lowerCol.substring(firstIndex + 1)).split("t");
        if (lowerCol.startsWith(prefix + "t")) {
            if (lowerCol.startsWith(UN_DUE_COL_PREFIX)) {
                realKey = "Aging_UndueMore";
            }
            if (lowerCol.startsWith(OVER_DUE_COL_PREFIX)) {
                realKey = "Aging_OverdueMore";
            }
            args = new String[]{args[1]};
        } else {
            if (lowerCol.startsWith(UN_DUE_COL_PREFIX)) {
                realKey = "Aging_UndueRange";
            }
            if (lowerCol.startsWith(OVER_DUE_COL_PREFIX)) {
                realKey = "Aging_OverdueRange";
            }
        }
        if (lowerCol.endsWith("bsc")) {
            realKey = realKey + "local";
        }
        String title = ResourceBase.getString((String)res, (String)realKey, (Locale)locale);
        return MessageFormat.format(title, args);
    }

    public static String getColTitle(AccountAgeQueryParam param, String res, String col, Locale locale) {
        String lowerCol = col.toLowerCase(Locale.ENGLISH);
        if (lowerCol.startsWith(UN_DUE_COL_PREFIX)) {
            return ArApVirtualAgingRptHelper.getUnOrOverDueColTitle(res, lowerCol, locale, UN_DUE_COL_PREFIX);
        }
        if (lowerCol.startsWith(OVER_DUE_COL_PREFIX)) {
            return ArApVirtualAgingRptHelper.getUnOrOverDueColTitle(res, lowerCol, locale, OVER_DUE_COL_PREFIX);
        }
        if (lowerCol.endsWith("OLC".toLowerCase(locale))) {
            return ResourceBase.getString((String)res, (String)"oldCurrency", (Locale)locale);
        }
        String oldKey = lowerCol;
        if (lowerCol.endsWith("bsc") || lowerCol.endsWith("basecurrency")) {
            if (!param.isBaseCurrency() || lowerCol.endsWith("basecurrency")) {
                return ResourceBase.getString((String)res, (String)"BaseCurrency", (Locale)locale);
            }
            lowerCol = lowerCol.split("_")[0];
        }
        Iterator<String> it = colKeyMap.keySet().iterator();
        String realKey = null;
        while (it.hasNext()) {
            String skey = it.next();
            if (!lowerCol.endsWith(skey)) continue;
            realKey = colKeyMap.get(skey);
            break;
        }
        if (!StringUtils.isEmpty(realKey)) {
            String result = ResourceBase.getString((String)res, realKey, (Locale)locale);
            if (param.isBaseCurrency() && oldKey.endsWith("bsc")) {
                result = result + ResourceBase.getString((String)res, (String)"BaseCurrency", (Locale)locale);
            }
            return result;
        }
        return null;
    }

    public static void fetchAgingRpt(Context ctx, AccountAgeQueryParam param) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)param.getCussAcctTempTable())) {
            String cussAcctTbl = ArApReportHelper.getCussAcctTempTbl(ctx, param, param.getCompanyIds());
            param.setCussAcctTempTable(cussAcctTbl);
        }
        CompanyOrgUnitCollection virComps = param.isQueryComps() ? ArApVirtualAgingRptHelper.getVirtualCompanys(ctx, param) : null;
        List<String> entityCompIds = ArApVirtualAgingRptHelper.getEntityCompanysIds(param, virComps);
        String billsTbl = TempTableUtil.createTempTable(ctx, ArApVirtualAgingRptHelper.agedBillsTableDefine(param));
        String factTbl = TempTableUtil.createTempTable(ctx, ArApVirtualAgingRptHelper.agedRptTableDefine(param));
        TempTablePool t = TempTablePool.getInstance((Context)ctx);
        String tempTbl = null;
        String verifyAmtTbl = null;
        if (param.isEndDateBal()) {
            tempTbl = TempTableUtil.createTempTable(ctx, ArApVirtualAgingRptHelper.verifyAmtTableDefine(param));
            verifyAmtTbl = TempTableUtil.createTempTable(ctx, ArApVirtualAgingRptHelper.verifyAmtTableDefine(param));
        }
        Connection con = null;
        Statement stmt = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            stmt = con.createStatement();
            Date agingNxtDay = new Date(param.getAgingCompareDate().getTime() + 86400000L);
            SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
            String sAgingNxtDay = dtFormat.format(agingNxtDay);
            String sql = null;
            if (param.isEndDateBal()) {
                List<String> sqlList = ArApAgingRptSqlHelper.getVerifiedAfterEndDateSql(ctx, param, tempTbl, entityCompIds, sAgingNxtDay);
                for (int i = 0; i < sqlList.size(); ++i) {
                    stmt.addBatch(sqlList.get(i));
                }
                stmt.executeBatch();
                stmt.clearBatch();
                try {
                    t.createIndex(tempTbl, "FBillId,FEntryId", false, false);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                sql = "INSERT INTO " + verifyAmtTbl + " SELECT FBillID, FEntryID, SUM(FVerifiedAmt), FType ";
                sql = sql + ", SUM(FVerifiedAmtLoc) FVerifiedAmtLoc ";
                sql = sql + " \r\n FROM " + tempTbl + " GROUP BY FBillID, FEntryID, FType";
                stmt.execute(sql);
                try {
                    t.createIndex(verifyAmtTbl, "FBillId,FEntryId", false, false);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            sql = ArApAgingRptSqlHelper.getBillsSql(ctx, param, billsTbl, verifyAmtTbl, entityCompIds);
            logger.debug((Object)("agingRpt bills Data \r\n" + sql));
            stmt.execute(sql);
            try {
                t.createIndex(billsTbl, "FBillId,FEntryId", false, false);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (param.isEndDateBal()) {
                boolean isAgeByPlanDate = param.isAgeByPlanDate();
                if (isAgeByPlanDate) {
                    ArApVirtualAgingRptHelper.updateArapPlanVerifyAmt(ctx, param, billsTbl, verifyAmtTbl);
                } else {
                    sql = ArApAgingRptSqlHelper.updateOtherBillsVerifiedSql(ctx, param, billsTbl, verifyAmtTbl);
                    logger.debug((Object)("agingRpt billsVerification \r\n" + sql));
                    stmt.execute(sql);
                }
                sql = ArApAgingRptSqlHelper.updateRecPayBillsVerifiedSql(ctx, param, billsTbl, verifyAmtTbl);
                logger.debug((Object)("agingRpt billsVerification \r\n" + sql));
                stmt.execute(sql);
                sql = ArApAgingRptSqlHelper.updateReversedSql(ctx, billsTbl, verifyAmtTbl);
                logger.debug((Object)("agingRpt reversed\r\n" + sql));
                stmt.execute(sql);
            }
            if (param.getTempTable() != null) {
                t.releaseTable(param.getTempTable());
            }
            param.setTempTable(billsTbl);
            try {
                t.createIndex(billsTbl, "FCompanyId", false, false);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            sql = ArApAgingRptSqlHelper.updateBaseCurrencySql(ctx, param);
            logger.debug((Object)("agingRpt updateBaseCurrencySql: \r\n" + sql));
            stmt.execute(sql);
            param.setTempTable(factTbl);
            sql = ArApAgingRptSqlHelper.getAgingDataSql(ctx, param, billsTbl);
            logger.debug((Object)("aged rptSql \r\n" + sql));
            stmt.execute(sql);
            try {
                t.createIndex(factTbl, "FAsstActID", false, false);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (param.getGroupTypeIndex() == 0) {
                sql = ArApAgingRptSqlHelper.getAgingCurrencySumSql(ctx, param);
                logger.debug((Object)("agingRpt sumByCurrSql: \r\n" + sql));
                stmt.execute(sql.toString());
            } else if (param.getGroupTypeIndex() == 1 || param.getGroupTypeIndex() == 2) {
                sql = ArApAgingRptSqlHelper.getAgingComSumSql(ctx, param);
                logger.debug((Object)("agingRpt sumByComSql: \r\n" + sql));
                stmt.execute(sql.toString());
            }
            ArApVirtualAgingRptHelper.sumToVirtualCompanys(ctx, param, virComps, stmt);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"exception, AgingRpt", (Throwable)e);
                throw new BOSException("exception, AgingRpt", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)con);
                TempTableUtil.releasTempTable(ctx, billsTbl);
                TempTableUtil.releasTempTable(ctx, tempTbl);
                TempTableUtil.releasTempTable(ctx, verifyAmtTbl);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
        TempTableUtil.releasTempTable(ctx, billsTbl);
        TempTableUtil.releasTempTable(ctx, tempTbl);
        TempTableUtil.releasTempTable(ctx, verifyAmtTbl);
        if (param.isQueryComps()) {
            ArApReportHelper.updateWrongCompanyParentId(ctx, param, param.getCompanyIds(), virComps);
        }
    }

    private static void updateArapPlanVerifyAmt(Context ctx, AccountAgeQueryParam param, String ageBillTbl, String verifyAmtTbl) throws BOSException, EASBizException {
        try {
            StringBuilder getUnVerifyAmtSql = new StringBuilder(100);
            getUnVerifyAmtSql.append(" select FBillId, FVerifiedAmt, FVerifiedAmtLoc").append(CRTL).append(" FROM " + verifyAmtTbl + " as a ").append(" where FBillId in (select FBillId from " + ageBillTbl + ")");
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)getUnVerifyAmtSql.toString());
            HashMap<String, BigDecimal[]> verificationCache = new HashMap<String, BigDecimal[]>(null != rs ? rs.size() : 16);
            while (rs.next()) {
                verificationCache.put(rs.getString("FBillId"), new BigDecimal[]{rs.getBigDecimal("FVerifiedAmt"), rs.getBigDecimal("FVerifiedAmtLoc")});
            }
            if (verificationCache.size() == 0) {
                return;
            }
            StringBuilder getBillPlanSql = new StringBuilder(100);
            getBillPlanSql.append(" select FBillId, FPlanId, (FRecPayAmt - FUnVerifyAmt) as FVerifyAmt ").append(", (FRecPayAmtLoc - FUnVerifyAmtLoc) AS FVerifyAmtLoc").append(CRTL).append(" from " + ageBillTbl + " order by FRecPayDate asc ");
            rs = DBUtil.executeQuery((Context)ctx, (String)getBillPlanSql.toString());
            LinkedHashMap<String, BigDecimal[]> billCache = new LinkedHashMap<String, BigDecimal[]>(null != rs ? rs.size() : 16);
            while (rs.next()) {
                billCache.put(rs.getString("FBillId") + ":" + rs.getString("FPlanId"), new BigDecimal[]{rs.getBigDecimal("FVerifyAmt"), rs.getBigDecimal("FVerifyAmtLoc")});
            }
            StringBuilder completeBills = new StringBuilder(100);
            HashMap<String, Object> writeBill = new HashMap<String, Object>();
            ListIterator iterator = new ArrayList(billCache.entrySet()).listIterator(billCache.size());
            while (iterator.hasPrevious()) {
                Map.Entry entry = iterator.previous();
                String key = (String)entry.getKey();
                String billID = key.split(":")[0];
                String planID = key.split(":")[1];
                BigDecimal[] verificationAmt = (BigDecimal[])verificationCache.get(billID);
                if (verificationAmt == null || verificationAmt[0].compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal[] billAmt = (BigDecimal[])billCache.get(key);
                if (billAmt[0].multiply(verificationAmt[0]).compareTo(BigDecimal.ZERO) < 0 || billAmt[0].abs().compareTo(verificationAmt[0].abs()) <= 0) {
                    completeBills.append("'" + planID + "',");
                    verificationAmt[0] = verificationAmt[0].subtract(billAmt[0]);
                    verificationAmt[1] = verificationAmt[1].subtract(billAmt[1]);
                } else {
                    writeBill.put(planID, verificationAmt.clone());
                    verificationAmt[0] = BigDecimal.ZERO;
                    verificationAmt[1] = BigDecimal.ZERO;
                }
                verificationCache.put(billID, verificationAmt);
            }
            StringBuilder writeBackSql = new StringBuilder(100);
            if (completeBills.length() > 0) {
                completeBills.delete(completeBills.length() - 1, completeBills.length());
                writeBackSql.append(" update " + ageBillTbl + " set FUnVerifyAmt = FRecPayAmt ");
                writeBackSql.append(", FUnVerifyAmtLoc = FRecPayAmtLoc ").append(CRTL).append("where FPlanId in (").append((CharSequence)completeBills).append(")");
                DBUtil.execute((Context)ctx, (String)writeBackSql.toString());
            }
            if (writeBill.size() > 0) {
                String[] writeBillSql = new String[writeBill.size()];
                int i = 0;
                for (String writeKey : writeBill.keySet()) {
                    BigDecimal[] verifyAmtArr = (BigDecimal[])writeBill.get(writeKey);
                    writeBillSql[i] = " update " + ageBillTbl + " set FUnVerifyAmt = FUnVerifyAmt +" + verifyAmtArr[0];
                    int n = i;
                    writeBillSql[n] = writeBillSql[n] + " , FUnVerifyAmtLoc = FUnVerifyAmtLoc + " + verifyAmtArr[1];
                    int n2 = i++;
                    writeBillSql[n2] = writeBillSql[n2] + " where FPlanId = '" + writeKey + "'";
                }
                DBUtil.execute(ctx, writeBillSql);
            }
        }
        catch (Exception e) {
            logger.error((Object)"exception, AgingRpt", (Throwable)e);
            throw new BOSException("exception, AgingRpt", (Throwable)e);
        }
    }

    private static void sumToVirtualCompanys(Context ctx, AccountAgeQueryParam param, CompanyOrgUnitCollection virComps, Statement stmt) throws BOSException, EASBizException, SQLException {
        if (!param.isQueryComps() || virComps == null || virComps.size() == 0) {
            return;
        }
        int n = virComps.size();
        for (int i = 0; i < n; ++i) {
            CompanyOrgUnitInfo compInfo = virComps.get(i);
            String sql = ArApAgingRptSqlHelper.getVirtualCompanySql(ctx, compInfo, param);
            logger.debug((Object)("agingRpt sumVirCompsSql:\r\n" + sql));
            stmt.execute(sql);
        }
    }

    private static CompanyOrgUnitCollection getVirtualCompanys(Context ctx, AccountAgeQueryParam param) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().add("id");
        view.getSelector().add("name");
        view.getSelector().add("level");
        view.getSelector().add("parent.id");
        view.getSelector().add("longNumber");
        List ids = param.getCompanyIds();
        HashSet idSet = new HashSet();
        idSet.addAll(ids);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(0)));
        SorterItemInfo sorter = new SorterItemInfo("longNumber");
        sorter.setSortType(SortType.DESCEND);
        view.getSorter().add(sorter);
        ICompanyOrgUnit iComp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        return iComp.getCompanyOrgUnitCollection(view);
    }

    private static List<String> getEntityCompanysIds(AccountAgeQueryParam param, CompanyOrgUnitCollection virComps) {
        if (!param.isQueryComps() || virComps == null || virComps.size() == 0) {
            return param.getCompanyIds();
        }
        ArrayList<String> ids = new ArrayList<String>(param.getCompanyIds());
        String id = null;
        int n = virComps.size();
        for (int i = 0; i < n; ++i) {
            id = virComps.get(i).getId().toString();
            ids.remove(id);
        }
        return ids;
    }

    private static String agedBillsTableDefine(AccountAgeQueryParam param) {
        boolean fByBill;
        StringBuilder tbl = new StringBuilder(300);
        tbl.append(" (FCompanyId varchar(44), FAdminOrgId varchar(44),FAsstActID varchar(44),");
        tbl.append(" FAsstActTypeID varchar(44), FCurrencyId varchar(44),").append(CRTL);
        tbl.append(" FCompany nvarchar(255), ");
        tbl.append(" FParentCompanyId varchar(44), ");
        tbl.append(" FCompLongNumber nvarchar(80), ");
        tbl.append(" FIsCompLeaf int, FComplevel int, ").append(CRTL);
        tbl.append(" FAdminOrgNumber nvarchar(100),FAdminOrgName nvarchar(255),");
        tbl.append(" FAsstActNumber nvarchar(80),");
        tbl.append(" FCussAcct nvarchar(255), FAsstActType nvarchar(80),");
        tbl.append(" FCurrPrecision int,");
        tbl.append(" FCurrNum varchar(80), FCurrency nvarchar(80),").append(CRTL);
        tbl.append(" FBaseCurrencyId varchar(44),");
        tbl.append(" FBaseCurrPrecision int,");
        tbl.append(" FBaseCurrNum varchar(80), FBaseCurrency nvarchar(80), ").append(CRTL);
        tbl.append(" FBillDate dateTime, FRecPayDate dateTime, FBizDate dateTime,");
        tbl.append(" FRecPayAmt decimal(28, 10) NOT NULL DEFAULT 0,");
        tbl.append(" FUnVerifyAmt decimal(28, 10) NOT NULL DEFAULT 0,");
        tbl.append(" FBillId varchar(44),FEntryId varchar(44), FIsReversed int default 0,");
        tbl.append(" FIsTransBill int default 0");
        boolean isAgeByRecPayDate = param.isAgeByPlanDate();
        tbl.append(isAgeByRecPayDate ? ", FPlanId varchar(44)" : "");
        boolean bl = fByBill = param.getAnalyseObjIndex() == 1;
        if (fByBill) {
            tbl.append(" , FBillType nvarchar(200), FBillNum nvarchar(200),");
            tbl.append(" FDescription nvarchar(512)");
        }
        tbl.append(" , FRecPayAmtLoc decimal(28, 10) NOT NULL DEFAULT 0,");
        tbl.append(" FUnVerifyAmtLoc decimal(28, 10) NOT NULL DEFAULT 0");
        tbl.append(")");
        return tbl.toString();
    }

    private static String agedRptTableDefine(AccountAgeQueryParam param) {
        int amtFldIndex;
        boolean fByBill;
        StringBuilder tbl = new StringBuilder(300);
        tbl.append(" (FId varchar(44),FAdminOrgId varchar(44),FAsstActID varchar(44),");
        tbl.append(" FAsstActTypeID varchar(44),").append(CRTL);
        tbl.append(" FCompanyId varchar(44),");
        tbl.append(" FParentCompanyId varchar(44),");
        tbl.append(" FCompany nvarchar(255),");
        tbl.append(" FCompLongNumber nvarchar(80),");
        tbl.append(" FIsCompLeaf int, FComplevel int,").append(CRTL);
        tbl.append(" FAdminOrgNumber nvarchar(100),FAdminOrgName nvarchar(255),");
        tbl.append(" FAsstActNumber nvarchar(100),");
        tbl.append(" FCussAcct nvarchar(255), FAsstActType nvarchar(80),").append(CRTL);
        if (!param.isBaseCurrency()) {
            tbl.append(" FCurrencyId varchar(44), FCurrPrecision int,").append(CRTL);
            tbl.append(" FCurrNum varchar(80), FCurrency nvarchar(80),").append(CRTL);
        }
        tbl.append(" FIsSum int default 0");
        boolean bl = fByBill = param.getAnalyseObjIndex() == 1;
        if (fByBill) {
            tbl.append(", FBillDate dateTime, FBillType nvarchar(200), ");
            tbl.append("FBillNum nvarchar(200), ");
            tbl.append("FDescription nvarchar(512), FBillId varchar(44)");
            boolean isAgeByPlanDate = param.isAgeByPlanDate();
            if (isAgeByPlanDate) {
                tbl.append(", FPlanId varchar(44)");
            }
        }
        boolean hasLocAmt = param.hasLocAmt();
        if (param.isBaseCurrency() || hasLocAmt) {
            tbl.append(", FBaseCurrencyId varchar(44),").append(CRTL);
            tbl.append(" FBaseCurrPrecision int,").append(CRTL);
            tbl.append(" FBaseCurrNum varchar(80), FBaseCurrency nvarchar(80) ").append(CRTL);
        }
        List<String> lstFlds = param.getReportFields();
        int fldSize = lstFlds.size();
        for (int i = amtFldIndex = param.getAmtColStartIndex(); i < fldSize; ++i) {
            tbl.append(", ").append(lstFlds.get(i));
            tbl.append(" decimal(28, 10) NOT NULL DEFAULT 0");
        }
        tbl.append(")");
        return tbl.toString();
    }

    private static String verifyAmtTableDefine(AccountAgeQueryParam param) {
        StringBuffer tbl = new StringBuffer(200);
        tbl.append(" (FBillId varchar(44), FEntryId varchar(44), FVerifiedAmt decimal(28, 10), FType int");
        tbl.append(", FVerifiedAmtLoc decimal(28, 10)");
        tbl.append(")");
        return tbl.toString();
    }

    static {
        colKeyMap.put("company", "Company");
        colKeyMap.put("adminorgnumber", "AdminOrgNumber");
        colKeyMap.put("adminorgname", "AdminOrgName");
        colKeyMap.put("cussacct", "AsstActName");
        colKeyMap.put("asstactnumber", "AsstActNumber");
        colKeyMap.put("currency", "Currency");
        colKeyMap.put("basecurrency", "BaseCurrency");
        colKeyMap.put("billdate", "Aging_BillDate");
        colKeyMap.put("billtype", "Aging_BillType");
        colKeyMap.put("billnum", "Aging_BillNumber");
        colKeyMap.put("description", "Aging_Remark");
        colKeyMap.put("balance", "Aging_Balance");
        colKeyMap.put("dueamt", "Aging_DueAmt");
    }
}

