/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.app.AbstractArBalanceControllerBean;
import com.kingdee.eas.fi.ar.app.util.ArServerUtils;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceCalculatorFactory;
import com.kingdee.eas.scm.framework.balance.app.engine.IBalanceCalculator;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ArBalanceControllerBean
extends AbstractArBalanceControllerBean {
    private static final long serialVersionUID = 1L;

    @Override
    protected BigDecimal _getArEndBalance(Context ctx, int balanceType, String companyID, String astActTypeID, String astActID, String currencyID, String currentPeriodID) throws BOSException {
        Connection cn = null;
        PreparedStatement psStmt = null;
        ResultSet rs = null;
        String sql = "select Fendbalancefor from T_AR_ArBalance  where FcompanyID = ? and FcurrencyID =  ? and FBalType =  ? and FAsstActTypeID = ? and FAsstActID = ? and FPeriodID = ?";
        BigDecimal arEndBalance = new BigDecimal(0);
        try {
            cn = this.getConnection(ctx);
            psStmt = cn.prepareStatement(sql);
            psStmt.setString(1, companyID);
            psStmt.setString(2, currencyID);
            psStmt.setInt(3, balanceType);
            psStmt.setString(4, astActTypeID);
            psStmt.setString(5, astActID);
            psStmt.setString(6, currentPeriodID);
            rs = psStmt.executeQuery();
            if (rs.next()) {
                arEndBalance = rs.getBigDecimal("Fendbalancefor");
            }
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, psStmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)psStmt, (Connection)cn);
        return arEndBalance;
    }

    @Override
    protected void _initialEnd(Context ctx, boolean initFlag) throws BOSException, EASBizException {
        IBalanceCalculator arCalulator = BalanceCalculatorFactory.getInitCalculator((Context)ctx, (IObjectPK)new ObjectUuidPK("rZr83XuPQXGYgUePQ5LecSPUYjI="));
        CompanyOrgUnitInfo currentCompany = CommonServerUtils.getCurrentCompany(ctx);
        PeriodInfo currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, currentCompany);
        OperationTypeEnum OPType = initFlag ? OperationTypeEnum.Positive : OperationTypeEnum.Reverse;
        arCalulator.calculate(currentCompany.getId().toString(), currentPeriod, OPType, false);
    }
}

