/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.IIncomeConfimBill;
import com.kingdee.eas.fi.ar.IncomeConfimBillCollection;
import com.kingdee.eas.fi.ar.IncomeConfimBillFactory;
import com.kingdee.eas.fi.ar.IncomeConfimBillInfo;
import com.kingdee.eas.fi.ar.IncomeConfimBillTypeEnum;
import com.kingdee.eas.fi.ar.IncomeConfimEntryCollection;
import com.kingdee.eas.fi.ar.IncomeConfimEntryInfo;
import com.kingdee.eas.fi.ar.app.ICBDataImportBackwardCalulateChecker;
import com.kingdee.eas.fi.ar.app.ICBIncomeForwardCalculateChecker;
import com.kingdee.eas.fi.arap.app.ARAPImportHelper;
import com.kingdee.eas.fi.arap.app.OtherBillDataImport;
import com.kingdee.eas.fi.arap.check.impl.CalculateCheckComposer;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArIncomeConfirmBillDataImport
extends OtherBillDataImport {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.ArIncomeConfirmBillDataImport");
    private final String[] AR_DECIMAL_FIELDS = new String[]{"FExchangeRate"};
    private final String[] AR_DECIMAL_OBJS = new String[]{"exchangeRate"};
    private final Map<String, String> entryDecimalFieldMap = new HashMap<String, String>();

    public ArIncomeConfirmBillDataImport() {
        this.entryDecimalFieldMap.put("FEntry_quantity", "quantity");
        this.entryDecimalFieldMap.put("FEntry_assistQty", "assistQty");
        this.entryDecimalFieldMap.put("FEntry_price", "price");
        this.entryDecimalFieldMap.put("FEntry_taxPrice", "taxPrice");
        this.entryDecimalFieldMap.put("FEntry_taxRate", "taxRate");
        this.entryDecimalFieldMap.put("FEntry_taxAmount", "taxAmount");
        this.entryDecimalFieldMap.put("FEntry_taxAmountLocal", "taxAmountLocal");
        this.entryDecimalFieldMap.put("FEntry_discountType", "discountType");
        this.entryDecimalFieldMap.put("FEntry_discountRate", "discountRate");
        this.entryDecimalFieldMap.put("FEntry_discountAmount", "discountAmount");
        this.entryDecimalFieldMap.put("FEntry_discountAmountLocal", "discountAmountLocal");
        this.entryDecimalFieldMap.put("FEntry_amount", "amount");
        this.entryDecimalFieldMap.put("FEntry_amountLocal", "amountLocal");
        this.entryDecimalFieldMap.put("FEntry_confimAmount", "incomeConfimAmount");
        this.entryDecimalFieldMap.put("FEntry_confimAmountLoc", "incomeConfimAmountLoc");
    }

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return IncomeConfimBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Hashtable data = ARAPImportHelper.reverseTableValue(hsData);
        IncomeConfimBillInfo head = this.generateBillInfo(ctx, data);
        head.put("entries", (Object)head.getEntry());
        return head;
    }

    private IncomeConfimBillInfo generateBillInfo(Context ctx, Hashtable tableData) throws TaskExternalException {
        IncomeConfimBillInfo head = null;
        StringBuffer entryErrorMsg = new StringBuffer();
        try {
            String errorMsg = "";
            IncomeConfimEntryInfo entry = null;
            boolean isUpdateImport = false;
            boolean isExistedBill = false;
            HashMap<Integer, IncomeConfimEntryInfo> entryMap = new HashMap<Integer, IncomeConfimEntryInfo>();
            Enumeration dataEnumeration = tableData.keys();
            IIncomeConfimBill confirmBill = IncomeConfimBillFactory.getLocalInstance(ctx);
            String number = null;
            while (dataEnumeration.hasMoreElements()) {
                Object key = dataEnumeration.nextElement();
                Hashtable hsData = (Hashtable)tableData.get(key);
                this.initDatas(ctx, hsData, true);
                number = ARAPImportHelper.getDataString(hsData, "FNumber");
                this.curKey = this.currentCompany.getNumber() + number;
                if (StringUtils.isEmpty((String)number)) {
                    throw new TaskExternalException(ArIncomeConfirmBillDataImport.getString("NumberNoFound", ctx));
                }
                if (!this.infoMap.containsKey(this.curKey)) {
                    IncomeConfimBillCollection otherColl;
                    this.infoMap.clear();
                    if (this.isSltImportUpdate()) {
                        IncomeConfimBillCollection collection = confirmBill.getIncomeConfimBillCollection("where number = '" + number + "' and company.number = '" + this.currentCompany.getNumber().toString() + "'");
                        if (collection != null && collection.size() > 0) {
                            head = collection.get(0);
                            if (!BillStatusEnum.SAVE.equals((Object)head.getBillStatus())) {
                                throw new TaskExternalException(ArIncomeConfirmBillDataImport.getString("BillStatusSave", ctx));
                            }
                            isExistedBill = true;
                        }
                        if (head != null) {
                            if (head.getEntry() != null && head.getEntry().size() > 0 && head.getEntry().get(0).getSourceBillId() != null) {
                                errorMsg = ArIncomeConfirmBillDataImport.getString("CANNOT_OVER_IMPORT", ctx) + ArIncomeConfirmBillDataImport.getString("AR_ImportARBill", ctx);
                                throw new TaskExternalException(errorMsg);
                            }
                            for (int i = 0; i < head.getEntry().size(); ++i) {
                                entry = head.getEntry().get(i);
                                entryMap.put(entry.getSeq(), entry);
                            }
                        }
                    } else if (!this.isSltImportUpdate() && !this.isImportDataByRule && (otherColl = confirmBill.getIncomeConfimBillCollection("where number = '" + number + "' and company.number = '" + this.currentCompany.getNumber() + "'")) != null && otherColl.size() > 0) {
                        throw new TaskExternalException(ArIncomeConfirmBillDataImport.getString("FBillNumber_IsExist", ctx));
                    }
                    if (null == head) {
                        head = new IncomeConfimBillInfo();
                        head.setNumber(number);
                    }
                    head.setCompany(this.currentCompany);
                    this.parseHead(hsData, ctx, head);
                    this.infoMap.put(this.curKey, head);
                } else {
                    isUpdateImport = true;
                    head = (IncomeConfimBillInfo)this.infoMap.get(this.curKey);
                }
                try {
                    this.parseEntry(ctx, hsData, head, entryMap);
                }
                catch (Exception e) {
                    String seq = ARAPImportHelper.getDataString(hsData, "FSeq");
                    entryErrorMsg.append(ARAPImportHelper.getTempleFieldName(hsData, "FSeq") + " " + seq + ":" + e.getMessage()).append("\r\n");
                    continue;
                }
                if (this.isImportDataByRule && !isUpdateImport && !isExistedBill) {
                    try {
                        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                        String cid = this.currentCompany.getId().toString();
                        if (!iCodingRuleManager.isExist((IObjectValue)head, cid)) {
                            throw new TaskExternalException(ArIncomeConfirmBillDataImport.getString("CodingRule_Error", ctx));
                        }
                        head.setNumber(iCodingRuleManager.getNumber((IObjectValue)head, cid, ""));
                    }
                    catch (Exception e) {
                        throw new TaskExternalException(ArIncomeConfirmBillDataImport.getString("CodingRule_Error", ctx));
                    }
                }
                if (null == head.getNumber() || head.getNumber().length() <= 80) continue;
                throw new TaskExternalException(ArIncomeConfirmBillDataImport.getString("BILL_NUMBER_TOO_LONG", ctx));
            }
            if (entryErrorMsg.length() > 0) {
                throw new TaskExternalException(entryErrorMsg.toString());
            }
            this.setBillAmtFromEntry(head);
            this.checkCalculate(ctx, head, number);
            return head;
        }
        catch (Exception e) {
            logger.info((Object)e);
            throw new TaskExternalException(e.getMessage());
        }
    }

    protected void checkCalculate(Context ctx, IncomeConfimBillInfo billInfo, String billNumber) throws TaskExternalException, BOSException, EASBizException {
        String messageFormat = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARImportData", (String)"AR_CalculateAmount_Fali", (Locale)ctx.getLocale());
        ICBIncomeForwardCalculateChecker forwardCheck = new ICBIncomeForwardCalculateChecker(ctx);
        ICBDataImportBackwardCalulateChecker backwardCheck = new ICBDataImportBackwardCalulateChecker(ctx);
        CalculateCheckComposer<IncomeConfimBillInfo> composer = new CalculateCheckComposer<IncomeConfimBillInfo>(Arrays.asList(forwardCheck, backwardCheck));
        if (!composer.check(billInfo)) {
            throw new TaskExternalException(composer.prepareMessage(messageFormat, Collections.singletonMap("billNumber", billNumber)).getMsg());
        }
    }

    protected void setBillAmtFromEntry(IncomeConfimBillInfo billInfo) {
        IncomeConfimEntryCollection entryCollection = billInfo.getEntry();
        BigDecimal tempConfirmAmount = BigDecimal.ZERO;
        BigDecimal tempConfirmAmountLocal = BigDecimal.ZERO;
        BigDecimal tempTotalAmount = BigDecimal.ZERO;
        BigDecimal tempTotalTax = BigDecimal.ZERO;
        BigDecimal tempTotalAmountLocal = BigDecimal.ZERO;
        BigDecimal tempTotalTaxLocal = BigDecimal.ZERO;
        Iterator itrEntry = entryCollection.iterator();
        while (itrEntry.hasNext()) {
            IncomeConfimEntryInfo entryTmp = (IncomeConfimEntryInfo)itrEntry.next();
            tempConfirmAmount = tempConfirmAmount.add(entryTmp.getIncomeConfimAmount());
            tempConfirmAmountLocal = tempConfirmAmountLocal.add(entryTmp.getIncomeConfimAmountLoc());
            tempTotalAmount = tempTotalAmount.add(entryTmp.getAmount());
            tempTotalAmountLocal = tempTotalAmountLocal.add(entryTmp.getAmountLocal());
            tempTotalTax = tempTotalTax.add(entryTmp.getTaxAmount());
            tempTotalTaxLocal = tempTotalTaxLocal.add(entryTmp.getTaxAmountLocal());
        }
        billInfo.setTotalConfimAmount(tempConfirmAmount);
        billInfo.setTotalConfimAmountLoc(tempConfirmAmountLocal);
        billInfo.setTotalAmount(tempTotalAmount);
        billInfo.setTotalAmountLocal(tempTotalAmountLocal);
        billInfo.setTotalTax(tempTotalTax);
        billInfo.setTotalTaxLocal(tempTotalTaxLocal);
    }

    private void parseHead(Hashtable hsData, Context ctx, IncomeConfimBillInfo billInfo) throws TaskExternalException {
        try {
            for (int i = 0; i < this.DATE_FIELDS.length; ++i) {
                Date date = ARAPImportHelper.getDataDate(ctx, hsData, this.DATE_FIELDS[i]);
                if (date == null) {
                    String errorMsg = MessageFormat.format(ARAPImportHelper.getString("DATE_CONVERT_ERROR_MSG", ctx), ARAPImportHelper.getTempleFieldName(hsData, this.DATE_FIELDS[i]));
                    throw new TaskExternalException(errorMsg);
                }
                billInfo.setDate(this.DATE_OBJS[i], date);
            }
            this.isInitBill = billInfo.getBillDate().before(this.startPeriod.getBeginDate());
            this.checkOrgPermission(ctx, true, this.isInitBill);
            this.isFinish = billInfo.getBillDate().before(this.currentPeriod.getBeginDate());
            if (this.isInitBill && this.arIsStart) {
                String errorMsg = MessageFormat.format(ArIncomeConfirmBillDataImport.getString("Cannot_InitBill_Wrong", ctx), this.defaultSysEnum.getAlias());
                throw new TaskExternalException(errorMsg);
            }
            if (!this.isInitBill && this.isFinish) {
                String errorMsg = MessageFormat.format(ArIncomeConfirmBillDataImport.getString("Cannot_FinistBill_Wrong", ctx), this.defaultSysEnum.getAlias());
                throw new TaskExternalException(errorMsg);
            }
            billInfo.setIsInitializeBill(this.isInitBill);
            BigDecimal decVal = null;
            CurrencyInfo currency = this.getCurrencyByCache(ctx, hsData, "FCurrency_number");
            int exgRatescale = 4;
            if (currency != null) {
                exgRatescale = currency.getPrecision();
            }
            ExchangeRateInfo exgRateInfo = null;
            if (this.currentCompany != null && currency != null) {
                exgRateInfo = this.getExchangeRateInfoByCache(ctx, this.currentCompany, currency);
            }
            if (exgRateInfo != null) {
                exgRatescale = exgRateInfo.getPrecision();
                if (exgRateInfo.getExchangeAux() != null) {
                    exgRatescale = exgRateInfo.getExchangeAux().getPrecision();
                }
            }
            for (int i = 0; i < this.AR_DECIMAL_FIELDS.length; ++i) {
                decVal = ARAPImportHelper.getDataDeciaml(ctx, hsData, this.AR_DECIMAL_FIELDS[i]);
                decVal = decVal.setScale(exgRatescale, 4);
                billInfo.setBigDecimal(this.AR_DECIMAL_OBJS[i], decVal);
                if (decVal != null && decVal.compareTo(ARAPImportHelper.ZERO) != 0) continue;
                ARAPImportHelper.throwFieldNullMsg(ctx, hsData, this.AR_DECIMAL_FIELDS[i]);
            }
            BigDecimal exchangeRate = billInfo.getExchangeRate();
            if (currency.getId().toString().equals(this.currentCompany.getBaseCurrency().getId().toString())) {
                exchangeRate = BigDecimal.ONE;
            }
            exchangeRate = exchangeRate.compareTo(ARAPImportHelper.ZERO) == 0 ? ARAPImportHelper.ONE : exchangeRate;
            billInfo.setExchangeRate(exchangeRate);
            billInfo.setLastExhangeRate(billInfo.getExchangeRate());
            int TEXT_MAX_LENGTH = 255;
            for (int i = 0; i < this.STRING_FIELDS.length; ++i) {
                String str = ARAPImportHelper.getDataString(hsData, this.STRING_FIELDS[i]);
                str = str == null ? "" : str;
                str = str.length() > TEXT_MAX_LENGTH ? str.substring(0, TEXT_MAX_LENGTH) : str;
                billInfo.setString(this.STRING_OBJS[i], str);
            }
            billInfo.setBillStatus(BillStatusEnum.SAVE);
            billInfo.setSourceBillType(VerificateBillTypeEnum.OTHER);
            billInfo.setBillType(ARAPImportHelper.getIncomeConfirmBillType(hsData, "FBillType"));
            boolean isInTax = true;
            boolean isPriceWiTax = true;
            billInfo.setIsInTax(isInTax);
            billInfo.setIsPriceWithoutTax(isPriceWiTax);
            PaymentTypeInfo paymentType = this.getPaymentTypeInfoByCache(ctx, hsData, "FPaymentType_number", true);
            billInfo.setPaymentType(paymentType);
            billInfo.setCurrency(this.getCurrencyByCache(ctx, hsData, "FCurrency_number"));
            billInfo.setCU(this.currentCompany.getCU());
            billInfo.setCompany(this.currentCompany);
            billInfo.setAdminOrgUnit(this.getAdminOrgUnitInfoByCache(ctx, hsData, "FAdminOrgUnit_number"));
            billInfo.setPerson(this.getPersonInfoByCache(ctx, hsData, "FPerson_number"));
            billInfo.setSaleGroup(this.getSaleGroupInfoByCache(ctx, hsData, "FSaleGroup_number"));
            SaleOrgUnitInfo saleOrg = this.getSaleOrgInfoByCache(ctx, hsData, "FSaleOrg_number");
            if (saleOrg == null && !this.isInitBill && this.isConnSCM && billInfo.getBillType().getValue() != 303) {
                throw new TaskExternalException(ArIncomeConfirmBillDataImport.getString("ARInvoiceBill_Org_IsNull", ctx));
            }
            billInfo.setSaleOrg(saleOrg);
            AsstActTypeInfo asstActTypeInfo = this.getAsstActTypeInfoByCache(ctx, hsData, "FAsstActType_number");
            billInfo.setAsstActType(asstActTypeInfo);
            if (!this.checkAsstAccID(ctx, asstActTypeInfo, hsData, billInfo)) {
                throw new TaskExternalException(ArIncomeConfirmBillDataImport.getString("AsstActNumber_Wrong", ctx));
            }
            if (!this.isExistAsstActByCompanyByCache(ctx, this.currentCompany, billInfo.getAsstActType(), billInfo.getAsstActID()).booleanValue()) {
                throw new TaskExternalException(ARAPImportHelper.getString("AsstActNotBelongCompany", ctx));
            }
            if (!this.checkAsstActStatusByCache(ctx, billInfo.getAsstActType(), billInfo.getAsstActID()).booleanValue()) {
                throw new TaskExternalException(ARAPImportHelper.getString("AsstActNotApproved", ctx));
            }
            billInfo.setCashDiscount(this.getCashDiscountInfoByCache(ctx, hsData, "FCashDiscount_number"));
            billInfo.setIsImportBill(true);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    @Override
    protected void checkOrgPermission(Context ctx, boolean isAR, boolean isInit) throws TaskExternalException {
        OrgType orgType = OrgType.Company;
        String permItemName = null;
        permItemName = isInit ? "fi_ar_IncomeConfirmBill_import" : "fi_ar_IncomeConfirmBill_import";
        try {
            FullOrgUnitCollection orgCol;
            ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
            ObjectUuidPK cuId = new ObjectUuidPK(this.currentCompany.getCU().getId().toString());
            String key = permItemName + treePK.toString() + cuId.toString();
            if (this.checkOrgPermissionCache.get(key) != null) {
                orgCol = (FullOrgUnitCollection)this.checkOrgPermissionCache.get(key);
            } else {
                IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
                orgCol = permission.getAuthorizedOrgOfCU((IObjectPK)cuId, ctx.getCaller(), OrgType.Company, (IObjectPK)treePK, permItemName);
                this.checkOrgPermissionCache.put(key, orgCol);
            }
            boolean isHasPerm = false;
            for (int i = 0; i < orgCol.size(); ++i) {
                FullOrgUnitInfo orgInfo = orgCol.get(i);
                if (!orgInfo.getId().toString().equals(this.currentCompany.getId().toString())) continue;
                isHasPerm = true;
            }
            if (!isHasPerm) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARImportData", (String)"MULTIORGIMPORT", (Locale)ctx.getLocale(), (Object[])new Object[]{this.currentCompany.getNumber()}));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(ArApBillUtil.printExceptionMsg(e));
        }
    }

    private CoreBaseInfo parseEntry(Context ctx, Hashtable hsData, IncomeConfimBillInfo billInfo, Map<Integer, IncomeConfimEntryInfo> entryMap) throws TaskExternalException {
        IncomeConfimEntryInfo entryInfo = null;
        try {
            String[] notNullAmountFields = new String[]{"FEntry_amount", "FEntry_amountLocal", "FEntry_confimAmount", "FEntry_confimAmountLoc"};
            this.checkFieldisNull(ctx, hsData, notNullAmountFields);
            String data = ARAPImportHelper.getDataString(hsData, "FSeq");
            if (data != null) {
                int seq = Integer.parseInt(data);
                if (this.isSltImportUpdate() && entryMap.get(seq) != null) {
                    entryInfo = entryMap.get(seq);
                }
                if (entryInfo == null) {
                    entryInfo = new IncomeConfimEntryInfo();
                    entryInfo.setHead(billInfo);
                    entryInfo.setSeq(seq);
                    billInfo.getEntry().add(entryInfo);
                    entryMap.put(seq, entryInfo);
                }
            } else {
                throw new TaskExternalException(ArIncomeConfirmBillDataImport.getString("EntrySeq_NoFound", ctx));
            }
            entryInfo.setCompany(String.valueOf(billInfo.getCompany().getId()));
            entryInfo.setBillDate(billInfo.getBillDate());
            this.createEntryInfo(ctx, billInfo, entryInfo, hsData);
        }
        catch (NumberFormatException e) {
            String msg = ArIncomeConfirmBillDataImport.getString("NumberField_Wrong", ctx);
            msg = MessageFormat.format(msg, "FSeq_E");
            throw new TaskExternalException(msg, (Throwable)e);
        }
        return entryInfo;
    }

    private void createEntryInfo(Context ctx, IncomeConfimBillInfo billInfo, IncomeConfimEntryInfo entryInfo, Hashtable hsData) throws TaskExternalException {
        try {
            AccountViewInfo account = null;
            String str = null;
            CurrencyInfo currency = this.getCurrencyByCache(ctx, hsData, "FCurrency_number");
            int scale = 4;
            if (currency != null) {
                scale = currency.getPrecision();
            }
            int scaleLocal = this.baseCurrency != null ? this.baseCurrency.getPrecision() : scale;
            for (Map.Entry<String, String> next : this.entryDecimalFieldMap.entrySet()) {
                String excelField = next.getKey();
                String entityField = next.getValue();
                BigDecimal decVal = ARAPImportHelper.getDataDeciaml(ctx, hsData, excelField);
                if (null == decVal) {
                    entryInfo.setBigDecimal(entityField, ARAPImportHelper.ZERO);
                    continue;
                }
                if (excelField.toLowerCase().contains("Local".toLowerCase()) || excelField.toLowerCase().contains("Loc".toLowerCase())) {
                    decVal = decVal.setScale(scaleLocal, 4);
                } else if (excelField.toLowerCase().contains("Amount".toLowerCase())) {
                    decVal = decVal.setScale(scale, 4);
                }
                if (!this.checkIsPositiveRate(entityField, decVal.toString())) {
                    String msg = ArIncomeConfirmBillDataImport.getString("NumberField_Wrong", ctx);
                    msg = MessageFormat.format(msg, excelField);
                    throw new TaskExternalException(msg);
                }
                entryInfo.setBigDecimal(entityField, decVal);
            }
            for (int i = 0; i < this.ENTRY_STRING_FIELDS.length; ++i) {
                str = ARAPImportHelper.getDataString(hsData, this.ENTRY_STRING_FIELDS[i]);
                entryInfo.setString(this.ENTRY_STRING_OBJS[i], str);
            }
            entryInfo.setCoreBillEntrySeq(ARAPImportHelper.getCoreBillSeq(ctx, hsData, "FEntry_coreBillEntrySeq"));
            if (StringUtils.isEmpty((String)entryInfo.getCoreBillNumber()) ^ 0 == entryInfo.getCoreBillEntrySeq()) {
                throw new TaskExternalException(ARAPImportHelper.getString("COREBILL_NUM_OR_SEQ_NOT_NULL", ctx));
            }
            IncomeConfimBillTypeEnum billType = billInfo.getBillType();
            MeasureUnitInfo unit = this.getMeasureUnitInfoByCache(ctx, hsData, "FEntry$measureUnit_number");
            entryInfo.setMeasureUnit(unit);
            MultiMeasureUnitInfo multiUnifInfo = null;
            if (billType.getValue() == 301) {
                MaterialInfo material = this.getMaterialInfoByCache(ctx, hsData, "FEntry$material_number");
                if (material == null) {
                    ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, "FEntry$material_number");
                }
                if (unit == null) {
                    ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, "FEntry$measureUnit_number");
                }
                int assistQtyPrecision = 4;
                int qtyPrecision = 4;
                int pricePrcision = material.getPricePrecision();
                multiUnifInfo = this.getMultiMeasureUnitByCache(ctx, unit, material);
                if (multiUnifInfo != null) {
                    qtyPrecision = multiUnifInfo.getQtyPrecision();
                }
                entryInfo.setQuantity(entryInfo.getQuantity().setScale(qtyPrecision, 4));
                entryInfo.setPrice(entryInfo.getPrice().setScale(pricePrcision, 4));
                entryInfo.setTaxPrice(entryInfo.getTaxPrice().setScale(pricePrcision, 4));
                entryInfo.setMaterial(material);
                entryInfo.setMaterialName(material.getName());
                entryInfo.setBaseUnit(material.getBaseUnit());
                entryInfo.setAssistUnit(material.getAssistUnit());
                entryInfo.setMaterialModel(material.getModel());
                if (material.getAssistAttr() != null) {
                    AsstAttrValueInfo asstAttrValueInfo = this.getAsstAttrValueInfoByCache(ctx, hsData, "FEntry$assistProperty_number", material.getAssistAttr());
                    entryInfo.setAssistProperty(asstAttrValueInfo);
                }
                entryInfo.setBaseQty(this.getBaseUnitQty(ctx, unit, material, entryInfo.getQuantity()));
                if (entryInfo.getAssistUnit() != null) {
                    multiUnifInfo = this.getMultiMeasureUnitByCache(ctx, entryInfo.getAssistUnit(), material);
                    if (multiUnifInfo != null) {
                        assistQtyPrecision = multiUnifInfo.getQtyPrecision();
                    }
                    entryInfo.setAssistQty(entryInfo.getAssistQty().setScale(assistQtyPrecision, 4));
                } else {
                    entryInfo.setAssistQty(BigDecimal.ZERO);
                }
            } else {
                int qtyPrecision = 9;
                int pricePrcision = 7;
                ExpenseTypeInfo expenseItem = this.getExpenseItemInfoByCache(ctx, hsData, "FEntry$expenseItem_number");
                if (expenseItem == null) {
                    ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, "FEntry$expenseItem_number");
                }
                entryInfo.setExpenseItem(expenseItem);
                entryInfo.setBaseUnit(unit);
                entryInfo.setQuantity(entryInfo.getQuantity().setScale(qtyPrecision, 4));
                entryInfo.setPrice(entryInfo.getPrice().setScale(pricePrcision, 4));
                entryInfo.setTaxPrice(entryInfo.getTaxPrice().setScale(pricePrcision, 4));
                entryInfo.setBaseQty(entryInfo.getQuantity());
                entryInfo.setAssistQty(BigDecimal.ZERO);
            }
            entryInfo.setCoreBillType(this.getBillTypeByCache(ctx, hsData, "FEntry$coreBillType_number"));
            account = this.getAccountViewInfoByCache(ctx, hsData, "FEntry$account_number", this.currentCompany.getId().toString(), currency.getId().toString());
            if (this.isInitBill && account == null) {
                throw new TaskExternalException(ArIncomeConfirmBillDataImport.getString("AR_Account_Is_Null", ctx));
            }
            entryInfo.setAccount(account);
            this.checkIsContrastAccountByCache(ctx, billInfo.getCompany(), entryInfo.getAccount(), true);
            entryInfo.setOppAccount(this.getAccountViewInfoByCache(ctx, hsData, "FEntry$oppAccount_number", this.currentCompany.getId().toString(), currency.getId().toString()));
            entryInfo.setDiscountType(ARAPImportHelper.getDiscountTypeInfo(ctx, hsData, "FEntry_discountType"));
            if (DiscountModeEnum.NULL.equals((Object)entryInfo.getDiscountType())) {
                entryInfo.setDiscountRate(ARAPImportHelper.ZERO);
                entryInfo.setDiscountAmount(ARAPImportHelper.ZERO);
                entryInfo.setDiscountAmountLocal(ARAPImportHelper.ZERO);
            }
            if (entryInfo.getQuantity().compareTo(ARAPImportHelper.ZERO) == 0 && billInfo.getBillType().getValue() == 302) {
                entryInfo.setQuantity(BigDecimal.ONE);
            }
            entryInfo.setLockVerifyAmt(BigDecimal.ZERO);
            entryInfo.setLockVerifyAmtLocal(BigDecimal.ZERO);
            entryInfo.setLockUnVerifyAmt(entryInfo.getIncomeConfimAmount());
            entryInfo.setLockUnVerifyAmtLocal(entryInfo.getIncomeConfimAmountLoc());
            entryInfo.setLockQty(BigDecimal.ZERO);
            entryInfo.setUnLockQty(entryInfo.getQuantity());
            entryInfo.setLockBaseQty(BigDecimal.ZERO);
            entryInfo.setUnLockBaseQty(entryInfo.getBaseQty());
            if (billInfo.isIsInitializeBill()) {
                entryInfo.setHisUnVerifyAmount(entryInfo.getUnVerifyAmount());
                entryInfo.setHisUnVerifyAmountLocal(entryInfo.getUnVerifyAmountLocal());
            }
            entryInfo.setUnwriteOffBaseQty(entryInfo.getBaseQty());
            entryInfo.setLocalUnwriteOffAmount(entryInfo.getIncomeConfimAmountLoc());
            CustomerInfo customer = new CustomerInfo();
            if (CustomerInfo.getBosType().equals(BOSUuid.read((String)billInfo.getAsstActID()).getType().toString())) {
                customer.setId(BOSUuid.read((String)billInfo.getAsstActID()));
                entryInfo.setOrderCustomer(customer);
                entryInfo.setOrdCustName(billInfo.getAsstActName());
                entryInfo.setOrdCustNumber(billInfo.getAsstActNumber());
                entryInfo.setServiceCustomer(customer);
                entryInfo.setSerCustName(billInfo.getAsstActName());
                entryInfo.setSerCustNumber(billInfo.getAsstActNumber());
                entryInfo.setRecAsstActType(billInfo.getAsstActType());
                entryInfo.setRecAsstActID(billInfo.getAsstActID());
                entryInfo.setRecAsstActName(billInfo.getAsstActName());
                entryInfo.setRecAsstActNumber(billInfo.getAsstActNumber());
            }
            boolean isRedBill = entryInfo.isRed();
            ArApBillHelper.handleRedBill((IObjectValue)entryInfo, isRedBill);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public static String getString(String resName, Context ctx) {
        return ArIncomeConfirmBillDataImport.getString("AR", resName, ctx);
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            IncomeConfimBillInfo billInfo = (IncomeConfimBillInfo)coreBaseInfo;
            billInfo.getEntry().sort("seq");
            billInfo.setReqCalculate4Srv(false);
            IObjectPK pk = this.getController(ctx).save((CoreBaseInfo)billInfo);
            if (billInfo.getId() != null) {
                billInfo.setId(BOSUuid.read((String)pk.toString()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.ar.app.IncomeConfirmBillQuery";
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FCompany_number", rs.getString("company.number"));
            this.putTable(result, "FBillDate", rs.getString("billDate"));
            this.putTable(result, "FBillType", rs.getString("billType"));
            this.putTable(result, "FPaymentType_number", rs.getString("paymentType.number"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FAsstActType_number", rs.getString("asstActType.number"));
            this.putTable(result, "FAsstActNumber", rs.getString("asstActNumber"));
            this.putTable(result, "FAdminOrgUnit_number", rs.getString("adminOrgUnit.number"));
            this.putTable(result, "FSaleOrg_number", rs.getString("saleOrg.number"));
            this.putTable(result, "FSaleGroup_number", rs.getString("saleGroup.number"));
            this.putTable(result, "FPerson_number", rs.getString("person.number"));
            this.putTable(result, "FCurrency_number", rs.getString("currency.number"));
            this.putTable(result, "FExchangeRate", rs.getBigDecimal("exchangeRate"));
            this.putTable(result, "FAbstractName", rs.getString("abstractName"));
            this.putTable(result, "FCashDiscount_number", rs.getString("cashDiscount.number"));
            this.putTable(result, "FSeq", rs.getString("entry.seq"));
            this.putTable(result, "FEntry$material_number", rs.getString("material.number"));
            this.putTable(result, "FEntry$assistProperty_number", rs.getString("assistProperty.number"));
            this.putTable(result, "FEntry$expenseItem_number", rs.getString("expenseItem.number"));
            this.putTable(result, "FEntry$measureUnit_number", rs.getString("measureUnit.number"));
            this.putTable(result, "FEntry_quantity", rs.getBigDecimal("entry.quantity"));
            this.putTable(result, "FEntry$assistUnit_number", rs.getString("assistUnit.number"));
            this.putTable(result, "FEntry_assistQty", rs.getBigDecimal("entry.assistQty"));
            this.putTable(result, "FEntry_taxRate", rs.getBigDecimal("entry.taxRate"));
            this.putTable(result, "FEntry_price", rs.getBigDecimal("entry.price"));
            this.putTable(result, "FEntry_taxPrice", rs.getBigDecimal("entry.taxPrice"));
            this.putTable(result, "FEntry_discountType", rs.getString("entry.discountType"));
            this.putTable(result, "FEntry_discountRate", rs.getBigDecimal("entry.discountRate"));
            this.putTable(result, "FEntry_discountAmount", rs.getBigDecimal("entry.discountAmount"));
            this.putTable(result, "FEntry_discountAmountLocal", rs.getBigDecimal("entry.discountAmountLocal"));
            this.putTable(result, "FEntry_realPrice", rs.getBigDecimal("entry.realPrice"));
            this.putTable(result, "FEntry_actualPrice", rs.getBigDecimal("entry.actualPrice"));
            this.putTable(result, "FEntry_amount", rs.getBigDecimal("entry.amount"));
            this.putTable(result, "FEntry_amountLocal", rs.getBigDecimal("entry.amountLocal"));
            this.putTable(result, "FEntry_taxAmount", rs.getBigDecimal("entry.taxAmount"));
            this.putTable(result, "FEntry_taxAmountLocal", rs.getBigDecimal("entry.taxAmountLocal"));
            this.putTable(result, "FEntry$oppAccount_number", rs.getString("oppAccount.number"));
            this.putTable(result, "FEntry$account_number", rs.getString("account.number"));
            this.putTable(result, "FEntry_confimAmount", rs.getString("entry.incomeConfimAmount"));
            this.putTable(result, "FEntry_confimAmountLoc", rs.getString("entry.incomeConfimAmountLoc"));
            this.putTable(result, "FEntry$coreBillType_number", rs.getString("coreBillType.number"));
            this.putTable(result, "FEntry_coreBillNumber", rs.getString("entry.coreBillNumber"));
            this.putTable(result, "FEntry_coreBillEntrySeq", rs.getString("entry.coreBillEntrySeq"));
            this.putTable(result, "FEntry_remark", rs.getString("entry.remark"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

