/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArPrintBillEntryCollection;
import com.kingdee.eas.fi.ar.ArPrintBillEntryInfo;
import com.kingdee.eas.fi.ar.ArPrintBillInfo;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.fi.ar.app.AbstractArPrintBillControllerBean;
import com.kingdee.eas.fi.gl.AcctCussentFactory;
import com.kingdee.eas.fi.gl.AcctCussentInfo;
import com.kingdee.eas.fi.gl.IAcctCussent;
import com.kingdee.eas.fi.gl.IVoucherAssistRecord;
import com.kingdee.eas.fi.gl.VoucherAssistRecordFactory;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class ArPrintBillControllerBean
extends AbstractArPrintBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.ArPrintBillControllerBean");

    @Override
    protected void _importOtherBill(Context ctx, String batchSql) throws BOSException {
        if (batchSql.length() > 0) {
            try {
                int begin = 0;
                int end = batchSql.indexOf(";");
                while (true) {
                    String token = null;
                    token = end == -1 ? batchSql.substring(begin) : batchSql.substring(begin, end);
                    if (token.trim().length() > 0) {
                        DbUtil.execute((Context)ctx, (String)token);
                    }
                    if (end != -1) {
                        begin = end + 1;
                        end = batchSql.indexOf(";", begin);
                        continue;
                    }
                    break;
                }
            }
            catch (BOSException ex) {
                throw new BOSException((Throwable)ex);
            }
        }
    }

    protected void _createArAp(Context ctx, String billID) throws BOSException {
    }

    private boolean isAddView(Context ctx, ICodingRuleManager iCodingRuleManager, ArPrintBillInfo arPrintBillInfo) throws CodingRuleException, EASBizException, BOSException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = arPrintBillInfo.getCompany();
        String strCompanyID = aCompanyOrgUnitInfo.getId().toString();
        return iCodingRuleManager.isAddView((IObjectValue)arPrintBillInfo, strCompanyID);
    }

    private boolean isRuleAutoNumber(Context ctx, ICodingRuleManager iCodingRuleManager, ArPrintBillInfo arPrintBillInfo) throws EASBizException, BOSException {
        String sCompanyId = arPrintBillInfo.getCompany().getId().toString();
        return iCodingRuleManager.isExist((IObjectValue)arPrintBillInfo, sCompanyId);
    }

    private void checkNumber(Context ctx, ICodingRuleManager iCodingRuleManager, ArPrintBillInfo arPrintBillInfo) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)arPrintBillInfo.getNumber())) {
            if (this.isRuleAutoNumber(ctx, iCodingRuleManager, arPrintBillInfo)) {
                this.getNewNumber(ctx, iCodingRuleManager, (IObjectValue)arPrintBillInfo);
            } else {
                throw new OtherBillBizException(OtherBillBizException.NUMBER_NOTSET);
            }
        }
    }

    protected IObjectValue getNewNumber(Context ctx, ICodingRuleManager iCodingRuleManager, IObjectValue model) throws BOSException, EASBizException {
        String number = "";
        ArPrintBillInfo arPrintBillInfo = (ArPrintBillInfo)model;
        String sCompanyId = arPrintBillInfo.getCompany().getId().toString();
        number = iCodingRuleManager.getNumber((IObjectValue)arPrintBillInfo, sCompanyId);
        arPrintBillInfo.setNumber(number);
        ObjectUuidPK pk = new ObjectUuidPK(arPrintBillInfo.getId());
        if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)arPrintBillInfo)) {
            return this.getNewNumber(ctx, iCodingRuleManager, (IObjectValue)arPrintBillInfo);
        }
        return arPrintBillInfo;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ArPrintBillInfo otherBillInfo = (ArPrintBillInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)otherBillInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (otherBillInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)otherBillInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (otherBillInfo.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)otherBillInfo.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return super._exists(ctx, filter);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ArPrintBillInfo arPrintBillInfo = (ArPrintBillInfo)model;
        model.put("status", (Object)Integer.valueOf("0"));
        ICodingRuleManager iCoding = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (StringUtils.isEmpty((String)arPrintBillInfo.getNumber())) {
            if (arPrintBillInfo.getCompany() == null) {
                throw new OtherBillBizException(OtherBillBizException.COMPANY_NOTSET);
            }
            if (this.isAddView(ctx, iCoding, arPrintBillInfo)) {
                arPrintBillInfo = (ArPrintBillInfo)this.getNewNumber(ctx, iCoding, (IObjectValue)arPrintBillInfo);
            }
        }
        return super._save(ctx, (IObjectValue)arPrintBillInfo);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ArPrintBillInfo arPrintBillInfo = (ArPrintBillInfo)model;
        boolean isAddNew = true;
        if (arPrintBillInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(arPrintBillInfo.getId()))) {
            isAddNew = false;
        }
        arPrintBillInfo.setStatus(DeletedStatusEnum.NORMAL);
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (arPrintBillInfo.getCU() == null) {
            arPrintBillInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        this.checkNumber(ctx, iCodingRuleManager, arPrintBillInfo);
        super._checkNumberDup(ctx, null, (IObjectValue)arPrintBillInfo);
        this.reverseSrcBill(ctx, arPrintBillInfo, false);
        return super._submit(ctx, (IObjectValue)arPrintBillInfo);
    }

    private void reverseSrcBill(Context ctx, ArPrintBillInfo arprintBillInfo, boolean isRevoke) throws BOSException, EASBizException {
        IAcctCussent iAcctCussent = AcctCussentFactory.getLocalInstance((Context)ctx);
        ArPrintBillEntryCollection entryCol = arprintBillInfo.getEntries();
        ArPrintBillEntryInfo entryInfo = null;
        for (int i = 0; i < entryCol.size(); ++i) {
            entryInfo = entryCol.get(i);
            String srcBillEntryId = entryInfo.getSourceBillEntryId();
            BOSObjectType srcBillBOSType = BOSUuid.read((String)srcBillEntryId).getType();
            String sql = "";
            Object[] param = new String[3];
            param[2] = srcBillEntryId;
            if (new AcctCussentInfo().getBOSType().equals((Object)srcBillBOSType)) {
                String oql = "select vchAssistRecord.* where id= '" + srcBillEntryId + "'";
                AcctCussentInfo acctAcussentInfo = (AcctCussentInfo)iAcctCussent.getBillBaseInfo(oql);
                IVoucherAssistRecord iVoucherAssist = VoucherAssistRecordFactory.getLocalInstance((Context)ctx);
                VoucherAssistRecordInfo vchAssistRecord = acctAcussentInfo.getVchAssistRecord();
                ObjectUuidPK vchPk = new ObjectUuidPK(vchAssistRecord.getId());
                if (isRevoke) {
                    acctAcussentInfo.setArPrintBillID(null);
                    param[0] = "";
                    param[1] = "";
                    vchAssistRecord.setInvoiceNumber(null);
                } else {
                    acctAcussentInfo.setArPrintBillID(arprintBillInfo.getId().toString());
                    param[0] = arprintBillInfo.getId().toString();
                    param[1] = entryInfo.getId().toString();
                    StringBuffer osql = new StringBuffer();
                    osql.append("select  * from T_GL_AssistCustomizedType \r\ninner join  T_GL_AssistCustomizedProperty   on  T_GL_AssistCustomizedProperty.FCustomizedTypeID = T_GL_AssistCustomizedType.fid \r\ninner join t_gl_acctcussent on t_gl_acctcussent.FAccountID = T_GL_AssistCustomizedProperty.FAccountID\r\n where t_gl_acctcussent.fid = '").append(acctAcussentInfo.getId().toString()).append("'").append(" and FMappingFieldName = 'FInvoiceNumber'");
                    IRowSet set = DbUtil.executeQuery((Context)ctx, (String)osql.toString());
                    try {
                        if (set != null && set.next()) {
                            vchAssistRecord.setInvoiceNumber(arprintBillInfo.getNumber());
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                iVoucherAssist.update((IObjectPK)vchPk, (CoreBaseInfo)vchAssistRecord);
                sql = "update t_gl_acctcussent set farprintbillid=?,farprintbillentryid=? where fid=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
                continue;
            }
            if (!new OtherBillentryInfo().getBOSType().equals((Object)srcBillBOSType)) continue;
            if (isRevoke) {
                param[0] = null;
                param[1] = null;
                sql = "update t_ar_otherbillentry set farprintbillid=null,farprintbillentryid=null where fid='" + param[2] + "'";
            } else {
                param[0] = arprintBillInfo.getId().toString();
                param[1] = entryInfo.getId().toString();
                sql = "update t_ar_otherbillentry set farprintbillid='" + param[0] + "',farprintbillentryid='" + param[1] + "' where fid='" + param[2] + "'";
            }
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    @Override
    protected void _revoke(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ArPrintBillInfo arPrintBillInfo = this.getArPrintBillInfo(ctx, pk);
        arPrintBillInfo.setStatus(DeletedStatusEnum.DELETED);
        this.reverseSrcBill(ctx, arPrintBillInfo, true);
        this._update(ctx, pk, (IObjectValue)arPrintBillInfo);
    }
}

