/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.IBillImageFacade;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ap.VerificationEnum;
import com.kingdee.eas.fi.ap.app.util.ApServerUtils;
import com.kingdee.eas.fi.ar.BadAcctTakeBackFacadeFactory;
import com.kingdee.eas.fi.ar.IVerificationBill;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.VerificationBillCollection;
import com.kingdee.eas.fi.ar.VerificationBillFactory;
import com.kingdee.eas.fi.ar.VerificationBillInfo;
import com.kingdee.eas.fi.ar.VerificationBillentryCollection;
import com.kingdee.eas.fi.ar.VerificationBillentryInfo;
import com.kingdee.eas.fi.ar.app.AbstractArVerificationFacadeControllerBean;
import com.kingdee.eas.fi.ar.app.TempVerificationEntryInfo;
import com.kingdee.eas.fi.ar.app.TempVerificationInfo;
import com.kingdee.eas.fi.ar.app.util.ArServerUtils;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.arap.ARAPCommonServerFacadeFactory;
import com.kingdee.eas.fi.arap.ARAPVerifynException;
import com.kingdee.eas.fi.arap.IVerificationBillBase;
import com.kingdee.eas.fi.arap.VerificationBillBaseEntryInfo;
import com.kingdee.eas.fi.arap.VerificationBillBaseInfo;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApParamsUtil;
import com.kingdee.eas.fi.arap.util.Helper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class ArVerificationFacadeControllerBean
extends AbstractArVerificationFacadeControllerBean {
    private static final long serialVersionUID = 7612795378420028905L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.ArVerificationFacadeControllerBean");
    private final BigDecimal ZERO = new BigDecimal("0");
    private static final int DEFAULT_QUERY_COUNT = 0;
    private static final String AR = "AR";
    private static final String AP = "AP";
    private static final String PAYMENT = "PAYMENT";
    private static final String RECEIVE = "RECEIVE";
    private static final String VERI_BY_CORE = "VERI_BY_CORE";
    private static final String REC_AR_AGENT = "104";
    private static final String REC_AR_REFUNDMENT_AGENT = "105";
    private static final String PAY_AP_AGENT = "205";
    private static final String PAY_AP_REFUNDMENT_AGENT = "206";
    private List requestLockIDList = new ArrayList();
    private List lockedIDList = new ArrayList();
    private IMutexServiceControl iMutexServiceControl = null;
    private boolean isMsDB;
    private static final int VERIFI_ALL = 1;
    private static final int VERIFI_ONLY_SALE = 2;
    private static final int VERIFI_ONLY_PREREC = 3;
    private static final int VERIFI_ONLY_PUR = 2;
    private static final int VERIFI_ONLY_PREPUR = 3;
    ArApBillHelper helper = new ArApBillHelper();
    String posKey = "positive";
    String negKey = "negetive";
    String billAmtFlag = "billAmtFlag";
    String pureBillFlag = "pureBillFlag";
    String pureKey = "pureKey";
    String mixKey = "mixKey";

    @Override
    protected Map _getArBill(Context ctx, HashMap filter) throws BOSException, EASBizException {
        String lang = ctx.getLocale().getLanguage();
        boolean isBill = (Boolean)filter.get("isBill");
        String topSqlQuery = (String)filter.get("topSqlQuery");
        String bottomSqlQuery = (String)filter.get("bottomSqlQuery");
        String sqlQuery = null;
        if (topSqlQuery != null && topSqlQuery.length() > 0) {
            sqlQuery = topSqlQuery;
        } else if (bottomSqlQuery != null && bottomSqlQuery.length() > 0) {
            sqlQuery = bottomSqlQuery;
        }
        String pageRowCount = filter.get("pageRowCount") == null ? "1000" : filter.get("pageRowCount").toString();
        String startIndex = filter.get("startIndex") == null ? "0" : filter.get("startIndex").toString();
        String endIndex = filter.get("endIndex") == null ? pageRowCount : filter.get("endIndex").toString();
        StringBuffer sb = new StringBuffer("select TOP ");
        sb.append(endIndex);
        sb.append(" t1.fid as billid,");
        sb.append("t3.fid as company_id,");
        sb.append("t3.FName_").append(lang).append(" as company_name,");
        sb.append("8 as billtype,");
        sb.append("t1.FBillType as billsubtype,");
        sb.append("t1.fnumber as b_number,");
        sb.append("t1.FBillDate as billdate,");
        sb.append("t4.fid as acctCussType_id,");
        sb.append("t4.FName_").append(lang).append(" as acctCussType_name,");
        sb.append("t4.fnumber as acctCussType_number,");
        sb.append("t1.FAsstActID as acctCuss_id,");
        sb.append("t1.FAsstActName_").append(lang).append(" as acctCuss_name,");
        sb.append("t1.FcurrencyID as currency_id,");
        sb.append("t5.FName_").append(lang).append(" as currency_name,");
        sb.append("t5.fnumber as currency_number,");
        sb.append("t2.fid as entryid,");
        sb.append("t6.FID as accountid,");
        sb.append("t6.FNumber as accountnumber,");
        sb.append("t6.FName_").append(lang).append(" as accountname,");
        sb.append("t2.FOppAccountID as oppAccount,");
        sb.append("t1.FLastExhangeRate as exchangerate,");
        if (isBill) {
            sb.append("t1.FAmount as billamt,");
            sb.append("t1.FAmountLocal as billamtloc,");
        } else {
            sb.append("t2.FRecievePayAmount as billamt,");
            sb.append("t2.FRecievePayAmountLocal as billamtloc,");
        }
        sb.append("t2.FLockVerifyAmt as verificateamt,");
        sb.append("t2.FLockVerifyAmtLocal as verificateamtloc,");
        sb.append("t2.FLockUnVerifyAmt as unverificateamt,");
        sb.append("t2.FLockUnVerifyAmtLocal as unverificateamtloc,");
        sb.append("t1.FAbstractName as description ");
        sb.append(",t1.FAdminOrgUnitID as FAdminOrgUnitID ");
        sb.append(",t9.FName_").append(ctx.getLocale().getLanguage()).append(" as FAdminOrgUnitName ");
        sb.append(",t1.FPersonID as FPersonID ");
        sb.append(",t10.FName_").append(lang).append(" as FPerson ");
        sb.append(",t2.FCoreBillNumber as coreBillNumber ");
        sb.append(", t2.FCoreBillEntrySeq as coreBillEntrySeq ");
        sb.append(", t2.FContractNumber as contractNum ");
        sb.append(", t2.FContractEntrySeq as contractEntrySeq ");
        sb.append(",t7.FID as FMaterialID ");
        sb.append(",t7.FNumber as FMaterialNumber ");
        sb.append(",case isnull(t2.FMaterialID,'') when '' then t2.FMaterialName else ");
        sb.append(" t7.FName_").append(lang).append(" end as FMaterialName ");
        sb.append(",t8.FID as FExpenseItemID ");
        sb.append(",t8.FNumber as FExpenseItemNumber ");
        sb.append(",t8.FName_").append(lang).append(" as FExpenseItemName ");
        sb.append(",t11.FName_").append(lang).append(" as FVOUCHERTYPE ");
        sb.append(",t12.FNumber as FVOUCHERNUM ");
        sb.append(",PAYMENTTYPE.FID as PAYMENTTYPEID ");
        sb.append(",PAYMENTTYPE.FName_").append(lang).append(" as PAYMENTTYPE_name ");
        if (sqlQuery != null && sqlQuery.length() > 0) {
            String fromCont = "";
            fromCont = sqlQuery.indexOf("WHERE") != -1 ? sqlQuery.substring(sqlQuery.indexOf("FROM"), sqlQuery.indexOf("WHERE")) : (sqlQuery.indexOf("ORDER BY") != -1 ? sqlQuery.substring(sqlQuery.indexOf("FROM"), sqlQuery.indexOf("ORDER BY")) : sqlQuery.substring(sqlQuery.indexOf("FROM")));
            fromCont = fromCont.replaceAll("\"OTHERBILL\"", "t1");
            fromCont = fromCont.replaceAll("\"ENTRY\"", "t2");
            fromCont = fromCont.replaceAll("\"COMPANY\"", "t3");
            fromCont = fromCont.replaceAll("\"ASSTACTTYPE\"", "t4");
            fromCont = fromCont.replaceAll("\"CURRENCY\"", "t5");
            fromCont = fromCont.replaceAll("\"ACCOUNT\"", "t6");
            fromCont = fromCont.replaceAll("\"MATERIAL\"", "t7");
            fromCont = fromCont.replaceAll("\"EXPENSEITEM\"", "t8");
            fromCont = fromCont.replaceAll("\"ADMINORGUNIT\"", "t9");
            fromCont = fromCont.replaceAll("\"PERSON\"", "t10");
            fromCont = fromCont.replaceAll("\"VOUCHERTYPE\"", "t11");
            fromCont = fromCont.replaceAll("\"VOUCHER\"", "t12");
            fromCont = fromCont.replaceAll("\"PAYMENTTYPE\"", "PAYMENTTYPE");
            sb.append(fromCont);
        } else {
            sb.append(this.getArBillFieldsExtends(ctx));
            sb.append("FROM T_AR_OtherBill as t1 ");
            sb.append("inner join T_AR_OtherBillEntry as t2 on t1.fid = t2.fparentid ");
            sb.append("inner join t_org_company AS t3 on t1.FCompanyID = t3.FID ");
            sb.append("inner join T_BD_AsstActType as t4 on t1.FAsstActTypeID = t4.fid ");
            sb.append("inner join t_bd_currency AS t5 on t1.fcurrencyid = t5.FID ");
            sb.append("left join T_BD_AccountView t6 on t2.FAccountID = t6.fid ");
            sb.append("left join T_BD_Material t7 on t2.FMaterialID = t7.fid ");
            sb.append("left join T_BC_ExpenseType t8 on t2.FExpenseItemID = t8.fid ");
            sb.append("left join T_ORG_Admin t9 on t1.FAdminOrgUnitID = t9.fid ");
            sb.append("left join T_BD_Person t10 on t1.FPersonID = t10.fid ");
            sb.append("left join T_BD_VoucherTypes t11 on t1.FVoucherTypeID = t11.fid ");
            sb.append("left join T_GL_Voucher t12 on t1.FVoucherID = t12.fid ");
            sb.append("left join T_BD_PaymentType PAYMENTTYPE on t1.FPaymentTypeID = PAYMENTTYPE.fid ");
            sb.append(this.getArBillJoinTableExtends(ctx));
        }
        sb.append(" where (t2.FLockUnVerifyAmt <> 0) AND t1.FBillStatus = 3 AND ");
        sb.append(this._transferToARAPFilterStr(filter));
        sb.append(this.getArBillWhereExtends(ctx, filter));
        HashMap<String, String> result = new HashMap<String, String>();
        String sqlSum = sb.substring(sb.indexOf("FROM"));
        if (!filter.containsKey("sqlSum") || !sqlSum.equals(filter.get("sqlSum"))) {
            result.put("sqlSum", "SELECT SUM(t2.FLockUnVerifyAmt), SUM(t2.FLockUnVerifyAmtLocal) " + sqlSum);
        }
        sb.append(" order by billDate ASC, t1.Fnumber ASC");
        if (isBill && filter.containsKey("rowCount")) {
            startIndex = filter.get("rowCount").toString();
        }
        return this.getRowSet(ctx, Integer.valueOf(startIndex), Integer.valueOf(pageRowCount), isBill, sb.toString(), result);
    }

    public int getDefaultQueryCount() {
        return 0;
    }

    public String getApBillFieldsExtends() {
        return "";
    }

    public String getApBillFieldsExtends(Context ctx) {
        return "";
    }

    public String getApBillJoinTableExtends() {
        return "";
    }

    public String getApBillJoinTableExtends(Context ctx) {
        return "";
    }

    public String getApBillWhereExtends(HashMap filter) {
        return "";
    }

    public String getApBillWhereExtends(Context ctx, HashMap filter) {
        return "";
    }

    public String getArBillFieldsExtends() {
        return "";
    }

    public String getArBillFieldsExtends(Context ctx) {
        return "";
    }

    public String getArBillJoinTableExtends() {
        return "";
    }

    public String getArBillJoinTableExtends(Context ctx) {
        return "";
    }

    public String getArBillWhereExtends(HashMap filter) {
        return "";
    }

    public String getArBillWhereExtends(Context ctx, HashMap filter) {
        return "";
    }

    public String getReceiveBillFieldsExtends() {
        return "";
    }

    public String getReceiveBillFieldsExtends(Context ctx) {
        return "";
    }

    public String getReceiveBillJoinTableExtends() {
        return "";
    }

    public String getReceiveBillJoinTableExtends(Context ctx) {
        return "";
    }

    public String getReceiveBillWhereExtends(HashMap filter) {
        return "";
    }

    public String getReceiveBillWhereExtends(Context ctx, HashMap filter) {
        return "";
    }

    public String getPaymentBillFieldsExtends() {
        return "";
    }

    public String getPaymentBillFieldsExtends(Context ctx) {
        return "";
    }

    public String getPaymentBillJoinTableExtends() {
        return "";
    }

    public String getPaymentBillJoinTableExtends(Context ctx) {
        return "";
    }

    public String getPaymentBillWhereExtends(HashMap filter) {
        return "";
    }

    public String getPaymentBillWhereExtends(Context ctx, HashMap filter) {
        return "";
    }

    @Override
    protected Collection _autoVerify(Context ctx, VerificationEnum verifiType, HashMap topHmFilter, HashMap botHmFilter, Date veriDate) throws BOSException, EASBizException {
        ArrayList<IObjectPK> veriResult = new ArrayList<IObjectPK>();
        Connection conn = null;
        String topSys = null;
        String botSys = null;
        String topAsstActField = null;
        String botAsstActField = null;
        FilterInfo topFilter = null;
        FilterInfo botFilter = null;
        FilterInfo topFilterCopy = null;
        FilterInfo botFilterCopy = null;
        String topIDSql = null;
        String botIDSql = null;
        PreparedStatement preStmt = null;
        ResultSet rs = null;
        boolean needSameSide = false;
        boolean needBothSide = true;
        boolean needSameAmount = false;
        boolean rec2paySameSide = false;
        boolean isBillVeri = true;
        boolean isCash = true;
        HashMap signal = topHmFilter;
        this.iMutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        switch (verifiType.getValue()) {
            case 101: {
                topSys = AR;
                botSys = RECEIVE;
                topFilter = this._transferToARAPFilterInfo(topHmFilter);
                botFilter = this._transferToRecFilterInfo(botHmFilter);
                topIDSql = this._getAssActIDsSql_ARBill(topFilter);
                botIDSql = this._getAssActIDsSql_Rec(botFilter);
                topAsstActField = "t1.FAsstActID";
                botAsstActField = "t1.FPayerID";
                needSameSide = true;
                needSameAmount = true;
                break;
            }
            case 103: {
                topSys = AR;
                botSys = AP;
                topFilter = this._transferToARAPFilterInfo(topHmFilter);
                botFilter = this._transferToARAPFilterInfo(botHmFilter);
                topIDSql = this._getAssActIDsSql_ARBill(topFilter);
                botIDSql = this._getAssActIDsSql_APBill(botFilter);
                topAsstActField = "t1.FAsstActID";
                botAsstActField = "t1.FAsstActID";
                break;
            }
            case 211: {
                topSys = PAYMENT;
                botSys = RECEIVE;
                topFilter = this._transferToPayFilterInfo(topHmFilter);
                botFilter = this._transferToRecFilterInfo(botHmFilter);
                topIDSql = this._getAssActIDsSql_Pay(topFilter);
                botIDSql = this._getAssActIDsSql_Rec(botFilter);
                topAsstActField = "t1.FPayeeID";
                botAsstActField = "t1.FPayerID";
                rec2paySameSide = true;
                needBothSide = false;
                break;
            }
            case 113: {
                topSys = RECEIVE;
                botSys = PAYMENT;
                topFilter = this._transferToRecFilterInfo(topHmFilter);
                botFilter = this._transferToPayFilterInfo(botHmFilter);
                topIDSql = this._getAssActIDsSql_Rec(topFilter);
                botIDSql = this._getAssActIDsSql_Pay(botFilter);
                topAsstActField = "t1.FPayerID";
                botAsstActField = "t1.FPayeeID";
                rec2paySameSide = true;
                needBothSide = false;
                break;
            }
            case 201: {
                topSys = AP;
                botSys = PAYMENT;
                topFilter = this._transferToARAPFilterInfo(topHmFilter);
                botFilter = this._transferToPayFilterInfo(botHmFilter);
                topIDSql = this._getAssActIDsSql_APBill(topFilter);
                botIDSql = this._getAssActIDsSql_Pay(botFilter);
                topAsstActField = "t1.FAsstActID";
                botAsstActField = "t1.FPayeeID";
                needSameSide = true;
                needSameAmount = true;
                break;
            }
            case 203: {
                topSys = AP;
                botSys = AR;
                topFilter = this._transferToARAPFilterInfo(topHmFilter);
                botFilter = this._transferToARAPFilterInfo(botHmFilter);
                topIDSql = this._getAssActIDsSql_APBill(topFilter);
                botIDSql = this._getAssActIDsSql_ARBill(botFilter);
                topAsstActField = "t1.FAsstActID";
                botAsstActField = "t1.FAsstActID";
                break;
            }
            case 104: {
                topSys = RECEIVE;
                botSys = PAYMENT;
                topFilter = this._transferToRecFilterInfo(topHmFilter);
                botFilter = this._transferToPayFilterInfo(botHmFilter);
                topIDSql = this._getAssActIDsSql_Rec(topFilter);
                botIDSql = this._getAssActIDsSql_Pay(botFilter);
                topAsstActField = "t1.FPayerID";
                botAsstActField = "t1.FPayeeID";
                break;
            }
            case 204: {
                topSys = PAYMENT;
                botSys = RECEIVE;
                topFilter = this._transferToPayFilterInfo(topHmFilter);
                botFilter = this._transferToRecFilterInfo(botHmFilter);
                topIDSql = this._getAssActIDsSql_Pay(topFilter);
                botIDSql = this._getAssActIDsSql_Rec(botFilter);
                topAsstActField = "t1.FPayeeID";
                botAsstActField = "t1.FPayerID";
                break;
            }
            default: {
                return null;
            }
        }
        if (needSameSide && topHmFilter.get("SameSideVeri") != null) {
            needSameSide = (Boolean)topHmFilter.get("SameSideVeri");
        } else if (rec2paySameSide) {
            needSameSide = true;
        }
        if (needSameAmount && topHmFilter.get("SameAmountVeri") != null) {
            needSameAmount = (Boolean)topHmFilter.get("SameAmountVeri");
        }
        if (topHmFilter.get("paymenttypeid") != null) {
            isCash = topHmFilter.get("paymenttypeid").equals("cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5") || topHmFilter.get("paymenttypeid").equals("40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5");
        }
        if (topHmFilter.get("isBillVeri") != null) {
            isBillVeri = (Boolean)topHmFilter.get("isBillVeri");
        }
        logger.info((Object)("isBillVeri" + isBillVeri));
        if (topHmFilter.get("company") != null) {
            ICompanyOrgUnit iCompany;
            CompanyOrgUnitInfo company;
            CurrencyInfo baseCurrency;
            String companyID;
            String string = companyID = (String)topHmFilter.get("company") != null ? (String)topHmFilter.get("company") : null;
            if (companyID != null && (baseCurrency = (company = (iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx)).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID))).getBaseCurrency()) != null) {
                signal.put("baseCurrency", baseCurrency.getId().toString());
            }
        }
        CoreBaseCollection verificationBillColl = new CoreBaseCollection();
        CoreBaseCollection verifyBillColl = null;
        IVerificationBillBase ibill = null;
        ibill = verifiType.getValue() == 101 || verifiType.getValue() == 103 || verifiType.getValue() == 104 || verifiType.getValue() == 113 ? VerificationBillFactory.getLocalInstance(ctx) : com.kingdee.eas.fi.ap.VerificationBillFactory.getLocalInstance(ctx);
        try {
            int i;
            int length;
            conn = EJBFactory.getConnection((Context)ctx);
            if (isBillVeri || needSameSide) {
                verifyBillColl = this._autoVerifyInner(ctx, conn, verifiType, topFilter, botFilter, true, topSys, veriDate, signal);
                if (verifyBillColl != null && verifyBillColl.size() > 0) {
                    verificationBillColl.addCollection(verifyBillColl);
                }
                if (verificationBillColl != null && verificationBillColl.size() > 0) {
                    IObjectPK[] objectPK = ibill.submitBatchData(verificationBillColl);
                    int length2 = objectPK.length;
                    for (int i2 = 0; i2 < length2; ++i2) {
                        veriResult.add(objectPK[i2]);
                    }
                    verificationBillColl.clear();
                }
            }
            preStmt = conn.prepareStatement(topIDSql);
            rs = preStmt.executeQuery();
            ArrayList<String> topAsstActList = new ArrayList<String>();
            while (rs.next()) {
                if (needSameSide && !isCash) {
                    topFilterCopy = (FilterInfo)topFilter.clone();
                    topFilterCopy.getFilterItems().add(new FilterItemInfo(topAsstActField, (Object)rs.getString(1)));
                    topFilterCopy.setMaskString(topFilterCopy.getMaskString() + " AND #" + (topFilterCopy.getFilterItems().size() - 1));
                    verifyBillColl = this._autoVerifyOneSide(ctx, conn, verifiType, topFilterCopy, (FilterInfo)topFilterCopy.clone(), true, false, isBillVeri, topSys, veriDate, signal);
                    if (verifyBillColl != null && verifyBillColl.size() > 0) {
                        verificationBillColl.addCollection(verifyBillColl);
                    }
                }
                topAsstActList.add(rs.getString(1));
            }
            if (verificationBillColl != null && verificationBillColl.size() > 0) {
                IObjectPK[] objectPK = ibill.submitBatchData(verificationBillColl);
                length = objectPK.length;
                for (i = 0; i < length; ++i) {
                    veriResult.add(objectPK[i]);
                }
                verificationBillColl.clear();
            }
            preStmt = conn.prepareStatement(botIDSql);
            rs = preStmt.executeQuery();
            while (rs.next()) {
                if (!needSameSide || isCash) continue;
                botFilterCopy = (FilterInfo)botFilter.clone();
                botFilterCopy.getFilterItems().add(new FilterItemInfo(botAsstActField, (Object)rs.getString(1)));
                botFilterCopy.setMaskString(botFilterCopy.getMaskString() + " AND #" + (botFilterCopy.getFilterItems().size() - 1));
                verifyBillColl = this._autoVerifyOneSide(ctx, conn, verifiType, botFilterCopy, (FilterInfo)botFilterCopy.clone(), true, false, isBillVeri, botSys, veriDate, signal);
                if (verifyBillColl == null || verifyBillColl.size() <= 0) continue;
                verificationBillColl.addCollection(verifyBillColl);
            }
            if (verificationBillColl != null && verificationBillColl.size() > 0) {
                IObjectPK[] objectPK = ibill.submitBatchData(verificationBillColl);
                length = objectPK.length;
                for (i = 0; i < length; ++i) {
                    veriResult.add(objectPK[i]);
                }
                verificationBillColl.clear();
            }
            preStmt = conn.prepareStatement(botIDSql);
            rs = preStmt.executeQuery();
            while (rs.next()) {
                if (!needBothSide || !topAsstActList.contains(rs.getString(1))) continue;
                botFilterCopy = (FilterInfo)botFilter.clone();
                botFilterCopy.getFilterItems().add(new FilterItemInfo(botAsstActField, (Object)rs.getString(1)));
                botFilterCopy.setMaskString(botFilterCopy.getMaskString() + " AND #" + (botFilterCopy.getFilterItems().size() - 1));
                topFilterCopy = (FilterInfo)topFilter.clone();
                topFilterCopy.getFilterItems().add(new FilterItemInfo(topAsstActField, (Object)rs.getString(1)));
                topFilterCopy.setMaskString(topFilterCopy.getMaskString() + " AND #" + (topFilterCopy.getFilterItems().size() - 1));
                verifyBillColl = this._autoVerifyOneSide(ctx, conn, verifiType, topFilterCopy, botFilterCopy, false, needSameAmount, isBillVeri, null, veriDate, signal);
                if (verifyBillColl == null || verifyBillColl.size() <= 0) continue;
                verificationBillColl.addCollection(verifyBillColl);
            }
            if (verificationBillColl != null && verificationBillColl.size() > 0) {
                IObjectPK[] objectPK = ibill.submitBatchData(verificationBillColl);
                length = objectPK.length;
                for (i = 0; i < length; ++i) {
                    veriResult.add(objectPK[i]);
                }
                verificationBillColl.clear();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, preStmt, (Connection)conn);
                this.releaseLocks(this.lockedIDList);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)preStmt, (Connection)conn);
        this.releaseLocks(this.lockedIDList);
        return veriResult;
    }

    private CoreBaseCollection _autoVerifyInner(Context ctx, Connection conn, VerificationEnum veriType, FilterInfo topFilter, FilterInfo botFilter, boolean sameSide, String billType, Date veriDate, HashMap signal) throws BOSException, EASBizException, SQLException {
        String topUnVeriStr = null;
        String botUnVeriStr = null;
        VerificateBillTypeEnum topVeriBillType = null;
        VerificateBillTypeEnum botVeriBillType = null;
        CoreBaseCollection verifyBillColl = new CoreBaseCollection();
        sameSide = false;
        switch (veriType.getValue()) {
            case 101: {
                topUnVeriStr = "t2.FLockUnVerifyAmt";
                botUnVeriStr = "t2.FUnLockAmt";
                topVeriBillType = VerificateBillTypeEnum.OtherReceiveBill;
                botVeriBillType = VerificateBillTypeEnum.ReceiveBill;
                break;
            }
            case 103: {
                topUnVeriStr = "t2.FLockUnVerifyAmt";
                botUnVeriStr = "t2.FLockUnVerifyAmt";
                topVeriBillType = VerificateBillTypeEnum.OtherReceiveBill;
                botVeriBillType = VerificateBillTypeEnum.OtherPaymentBill;
                break;
            }
            case 113: {
                botUnVeriStr = "t2.FUnLockAmt";
                topUnVeriStr = "t2.FUnLockAmt";
                if (billType.endsWith(RECEIVE)) {
                    topVeriBillType = VerificateBillTypeEnum.ReceiveBill;
                    botVeriBillType = VerificateBillTypeEnum.PaymentBill;
                    break;
                }
                topVeriBillType = VerificateBillTypeEnum.PaymentBill;
                botVeriBillType = VerificateBillTypeEnum.ReceiveBill;
                break;
            }
            case 211: {
                botUnVeriStr = "t2.FUnLockAmt";
                topUnVeriStr = "t2.FUnLockAmt";
                if (billType.endsWith(RECEIVE)) {
                    topVeriBillType = VerificateBillTypeEnum.ReceiveBill;
                    botVeriBillType = VerificateBillTypeEnum.PaymentBill;
                    break;
                }
                topVeriBillType = VerificateBillTypeEnum.PaymentBill;
                botVeriBillType = VerificateBillTypeEnum.ReceiveBill;
                break;
            }
            case 201: {
                if (sameSide) {
                    if (billType.endsWith(AP)) {
                        topUnVeriStr = "t2.FLockUnVerifyAmt";
                        botUnVeriStr = "t2.FLockUnVerifyAmt";
                        botVeriBillType = topVeriBillType = VerificateBillTypeEnum.OtherPaymentBill;
                        break;
                    }
                    topUnVeriStr = "t2.FUnLockAmt";
                    botUnVeriStr = "t2.FUnLockAmt";
                    botVeriBillType = topVeriBillType = VerificateBillTypeEnum.PaymentBill;
                    break;
                }
                topUnVeriStr = "t2.FLockUnVerifyAmt";
                botUnVeriStr = "t2.FUnLockAmt";
                topVeriBillType = VerificateBillTypeEnum.OtherPaymentBill;
                botVeriBillType = VerificateBillTypeEnum.PaymentBill;
                break;
            }
            case 203: {
                topUnVeriStr = "t2.FLockUnVerifyAmt";
                botUnVeriStr = "t2.FLockUnVerifyAmt";
                topVeriBillType = VerificateBillTypeEnum.OtherPaymentBill;
                botVeriBillType = VerificateBillTypeEnum.OtherReceiveBill;
                break;
            }
            case 104: {
                topUnVeriStr = "t2.FUnLockAmt";
                botUnVeriStr = "t2.FUnLockAmt";
                topVeriBillType = VerificateBillTypeEnum.ReceiveBill;
                botVeriBillType = VerificateBillTypeEnum.PaymentBill;
                break;
            }
            case 204: {
                topUnVeriStr = "t2.FUnLockAmt";
                botUnVeriStr = "t2.FUnLockAmt";
                topVeriBillType = VerificateBillTypeEnum.PaymentBill;
                botVeriBillType = VerificateBillTypeEnum.ReceiveBill;
                break;
            }
            default: {
                return verifyBillColl;
            }
        }
        return this.buildInnerVeriBills(ctx, conn, veriType, topFilter, botFilter, sameSide, topVeriBillType, botVeriBillType, veriDate, signal);
    }

    private CoreBaseCollection buildInnerVeriBills(Context ctx, Connection conn, VerificationEnum veriType, FilterInfo topFilter, FilterInfo botFilter, boolean sameSide, VerificateBillTypeEnum topVeriBillType, VerificateBillTypeEnum botVeriBillType, Date veriDate, HashMap signal) throws BOSException, EASBizException, SQLException {
        IObjectCollection entrys;
        CoreBaseCollection verifyBillColl = new CoreBaseCollection();
        BigDecimal veriTopTotal = null;
        BigDecimal veriBotTotal = null;
        BigDecimal lessTotalVeri = null;
        veriTopTotal = this._getTotalVeri(conn, topFilter, 0, topVeriBillType);
        veriBotTotal = this._getTotalVeri(conn, botFilter, 0, botVeriBillType);
        lessTotalVeri = veriTopTotal.abs().compareTo(veriBotTotal.abs()) > 0 ? veriBotTotal.abs() : veriTopTotal.abs();
        VerificationBillBaseInfo veriBill = null;
        veriBill = veriType.getValue() == 101 || veriType.getValue() == 103 || veriType.getValue() == 104 || veriType.getValue() == 113 ? new VerificationBillInfo() : new com.kingdee.eas.fi.ap.VerificationBillInfo();
        CompanyOrgUnitInfo info = new CompanyOrgUnitInfo();
        String companyid = null;
        if (signal != null && signal.containsKey("company")) {
            companyid = (String)signal.get("company");
            info.setId(BOSUuid.read((String)companyid));
            if (signal.containsKey("baseCurrency")) {
                CurrencyInfo baseCurrencyInfo = new CurrencyInfo();
                baseCurrencyInfo.setId(BOSUuid.read((String)((String)signal.get("baseCurrency"))));
                info.setBaseCurrency(baseCurrencyInfo);
            }
        }
        veriBill.setCompany(info);
        this._createBillInnerVeriEntrys(ctx, conn, veriBill, topVeriBillType, topFilter, lessTotalVeri, signal);
        this._createBillInnerVeriEntrys(ctx, conn, veriBill, botVeriBillType, botFilter, lessTotalVeri, signal);
        boolean isGainLoss = false;
        String baseCurrencyID = null;
        if (signal != null && signal.containsKey("baseCurrency")) {
            baseCurrencyID = (String)signal.get("baseCurrency");
        } else {
            ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
            CurrencyInfo baseCurrency = company.getBaseCurrency();
            String string = baseCurrencyID = baseCurrency != null ? baseCurrency.getId().toString() : null;
        }
        if (!veriBill.isIsSameCurrency() || veriBill.isIsSameCurrency() && !veriBill.getMainCurrency().getId().toString().equalsIgnoreCase(baseCurrencyID)) {
            isGainLoss = true;
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = null;
        if (veriBill.get("entrys") instanceof IObjectCollection && (entrys = (IObjectCollection)veriBill.get("entrys")).size() != 0) {
            HashMap<BOSUuid, VerificationBillBaseInfo> veriMap = new HashMap<BOSUuid, VerificationBillBaseInfo>();
            VerificationBillBaseEntryInfo veriEntry = null;
            for (int i = 0; i < entrys.size(); ++i) {
                veriEntry = (VerificationBillBaseEntryInfo)entrys.getObject(i);
                if (veriMap.containsKey(veriEntry.getAcctCussID())) {
                    veriBill = (VerificationBillBaseInfo)veriMap.get(veriEntry.getAcctCussID());
                } else {
                    veriBill = veriType.getValue() == 101 || veriType.getValue() == 103 || veriType.getValue() == 104 || veriType.getValue() == 113 ? new VerificationBillInfo() : new com.kingdee.eas.fi.ap.VerificationBillInfo();
                    veriBill.setMainBillType(topVeriBillType);
                    veriBill.setSecondBillType(botVeriBillType);
                    veriBill.setCompany(info);
                    veriBill.setBizDate(new Date());
                    veriBill.setVerificationType(veriType);
                    veriBill.setIsSameCode(true);
                    veriBill.setIsSameCurrency(true);
                    veriBill.setMainAcctCussType(veriEntry.getAcctCussType());
                    veriBill.setMainAcctCussName(veriEntry.getAcctCussName());
                    veriBill.setMainAcctCussID(veriEntry.getAcctCussID());
                    veriBill.setMainCurrency(veriEntry.getCurrency());
                    veriBill.setSecondAcctCussType(veriEntry.getAcctCussType());
                    veriBill.setSecondAcctCussName(veriEntry.getAcctCussName());
                    veriBill.setSecondAcctCussID(veriEntry.getAcctCussID());
                    veriBill.setSecondCurrency(veriEntry.getCurrency());
                    veriMap.put(veriEntry.getAcctCussID(), veriBill);
                }
                ((IObjectCollection)veriBill.get("entrys")).addObject((IObjectValue)veriEntry);
            }
            Iterator it = veriMap.entrySet().iterator();
            while (it.hasNext()) {
                veriBill = (VerificationBillBaseInfo)it.next().getValue();
                if (((IObjectCollection)veriBill.get("entrys")).size() <= 1) continue;
                number = iCodingRuleManager.getNumber((IObjectValue)veriBill, companyid);
                veriBill.setNumber(number);
                this._setBillDate(ctx, veriBill, veriDate);
                this.checkRedBlueEntry(ctx, veriBill);
                this._setGainLoss(veriBill, isGainLoss);
                verifyBillColl.add((CoreBaseInfo)veriBill);
            }
        }
        return verifyBillColl;
    }

    private void _setGainLoss(VerificationBillBaseInfo veriBill, boolean isGainLoss) {
        if (veriBill == null) {
            return;
        }
        boolean isSameSide = false;
        IObjectCollection entrys = (IObjectCollection)veriBill.get("entrys");
        BigDecimal mainGainAndLoss = BaseDataUtil.ZERO;
        BigDecimal topAmtLoc = BaseDataUtil.ZERO;
        BigDecimal botAmtLoc = BaseDataUtil.ZERO;
        BigDecimal topAmt = BaseDataUtil.ZERO;
        BigDecimal botAmt = BaseDataUtil.ZERO;
        boolean isSameCurrency = true;
        int entrySize = entrys.size();
        VerificationBillBaseEntryInfo entry = null;
        VerificateBillTypeEnum topBillType = null;
        if (veriBill.getMainBillType().equals((Object)veriBill.getSecondBillType())) {
            isSameSide = true;
        }
        isSameCurrency = veriBill.isIsSameCurrency();
        switch (veriBill.getVerificationType().getValue()) {
            case 103: {
                topBillType = VerificateBillTypeEnum.OtherReceiveBill;
                break;
            }
            case 109: {
                topBillType = VerificateBillTypeEnum.OtherReceiveBill;
                break;
            }
            case 101: {
                topBillType = VerificateBillTypeEnum.OtherReceiveBill;
                break;
            }
            case 107: {
                topBillType = VerificateBillTypeEnum.OtherReceiveBill;
                break;
            }
            case 203: {
                topBillType = VerificateBillTypeEnum.OtherPaymentBill;
                break;
            }
            case 209: {
                topBillType = VerificateBillTypeEnum.OtherPaymentBill;
                break;
            }
            case 113: {
                topBillType = VerificateBillTypeEnum.ReceiveBill;
                break;
            }
            case 114: {
                topBillType = VerificateBillTypeEnum.ReceiveBill;
                break;
            }
            case 104: {
                topBillType = VerificateBillTypeEnum.ReceiveBill;
                break;
            }
            case 110: {
                topBillType = VerificateBillTypeEnum.ReceiveBill;
                break;
            }
            case 211: {
                topBillType = VerificateBillTypeEnum.PaymentBill;
                break;
            }
            case 212: {
                topBillType = VerificateBillTypeEnum.PaymentBill;
                break;
            }
            case 204: {
                topBillType = VerificateBillTypeEnum.PaymentBill;
                break;
            }
            case 210: {
                topBillType = VerificateBillTypeEnum.PaymentBill;
                break;
            }
            case 201: {
                topBillType = VerificateBillTypeEnum.OtherPaymentBill;
                break;
            }
            case 207: {
                topBillType = VerificateBillTypeEnum.OtherPaymentBill;
                break;
            }
            default: {
                return;
            }
        }
        BigDecimal thisVeriAmtLoc = null;
        for (int i = 0; i < entrySize; ++i) {
            entry = (VerificationBillBaseEntryInfo)entrys.getObject(i);
            thisVeriAmtLoc = entry.getThisVerificateAmtLoc();
            if (isSameSide && thisVeriAmtLoc.compareTo(BaseDataUtil.ZERO) > 0 || !isSameSide && entry.getBillType().getValue() == topBillType.getValue()) {
                topAmtLoc = topAmtLoc.add(thisVeriAmtLoc);
                topAmt = topAmt.add(entry.getThisVerificateAmt());
            } else {
                botAmtLoc = botAmtLoc.add(thisVeriAmtLoc);
            }
            if (isSameCurrency || entry.getBillType().getValue() == topBillType.getValue()) continue;
            botAmt = botAmt.add(entry.getThisVerificateAmt());
        }
        if (isSameSide) {
            mainGainAndLoss = botAmtLoc.add(topAmtLoc);
            botAmt = topAmt.negate();
        } else {
            mainGainAndLoss = botAmtLoc.subtract(topAmtLoc);
            if (isSameCurrency) {
                botAmt = topAmt;
            }
        }
        if (mainGainAndLoss.compareTo(BaseDataUtil.ZERO) != 0) {
            BigDecimal hasGainAndLoss = BaseDataUtil.ZERO;
            BigDecimal hasGainAndLossLoc = BaseDataUtil.ZERO;
            BigDecimal temp = null;
            for (int i = 0; i < entrySize; ++i) {
                BigDecimal thisGainAndLoss;
                entry = (VerificationBillBaseEntryInfo)entrys.getObject(i);
                thisVeriAmtLoc = entry.getThisVerificateAmtLoc();
                if ((!isSameSide || thisVeriAmtLoc.compareTo(BaseDataUtil.ZERO) <= 0) && (isSameSide || entry.getBillType().getValue() != topBillType.getValue())) continue;
                temp = entry.getThisVerificateAmt();
                if ((hasGainAndLoss = hasGainAndLoss.add(temp)).equals(topAmt)) {
                    thisGainAndLoss = mainGainAndLoss.subtract(hasGainAndLossLoc);
                } else if (topAmtLoc.compareTo(BaseDataUtil.ZERO) == 0) {
                    thisGainAndLoss = BaseDataUtil.ZERO;
                    hasGainAndLossLoc = BaseDataUtil.ZERO;
                } else {
                    thisGainAndLoss = thisVeriAmtLoc.multiply(mainGainAndLoss).divide(topAmtLoc, mainGainAndLoss.scale(), 4);
                    hasGainAndLossLoc = hasGainAndLossLoc.add(thisGainAndLoss);
                }
                if (!isGainLoss) continue;
                entry.setGainAndLoss(thisGainAndLoss);
            }
        }
        if (isGainLoss) {
            veriBill.setGainAndLoss(mainGainAndLoss);
        }
        veriBill.setMainThisVerificateAmt(topAmt);
        veriBill.setMainThisVerificateAmtLoc(topAmtLoc);
        veriBill.setSecondThisVerificateAmt(botAmt);
        veriBill.setSecondThisVerificateAmtLoc(botAmtLoc);
    }

    private void checkRedBlueEntry(Context ctx, VerificationBillBaseInfo billInfo) {
        if (billInfo != null) {
            IObjectCollection entry = (IObjectCollection)billInfo.get("entrys");
            boolean negFlag = false;
            boolean posFlag = false;
            int defaultBillType = 0;
            for (int index = 0; index < entry.size(); ++index) {
                if (index == 0 && this.getEntryInfo(entry, index) != null) {
                    defaultBillType = this.getEntryInfo(entry, index).getBillType().getValue();
                    continue;
                }
                if (defaultBillType == this.getEntryInfo(entry, index).getBillType().getValue()) continue;
                return;
            }
            for (int seq = 0; seq < entry.size(); ++seq) {
                if (BaseDataUtil.ZERO.compareTo(this.getVeriEntryAmt(entry, seq)) < 0) {
                    posFlag = true;
                }
                if (BaseDataUtil.ZERO.compareTo(this.getVeriEntryAmt(entry, seq)) <= 0) continue;
                negFlag = true;
            }
            if (negFlag && posFlag) {
                for (int j = 0; j < entry.size(); ++j) {
                    this.setEntryVeriType(entry, j, 1);
                }
            }
        }
    }

    private VerificationBillBaseEntryInfo getEntryInfo(IObjectCollection entry, int i) {
        if (entry != null && entry.getObject(i) instanceof VerificationBillBaseEntryInfo) {
            return (VerificationBillBaseEntryInfo)entry.getObject(i);
        }
        return null;
    }

    private BigDecimal getVeriEntryAmt(IObjectCollection entry, int i) {
        if (this.getEntryInfo(entry, i) != null) {
            return this.getEntryInfo(entry, i).getThisVerificateAmt();
        }
        return null;
    }

    private void setEntryVeriType(IObjectCollection entry, int i, int flag) {
        if (this.getEntryInfo(entry, i) != null) {
            this.getEntryInfo(entry, i).setVeriType(true);
        }
    }

    private void _setBillDate(Context ctx, VerificationBillBaseInfo veriBill, Date veriDate) throws BOSException {
        IObjectCollection entry = (IObjectCollection)veriBill.get("entrys");
        Date billDate = null;
        if (veriDate == null) {
            veriDate = new Date();
        }
        for (int i = 0; i < entry.size(); ++i) {
            billDate = ((VerificationBillBaseEntryInfo)entry.getObject(i)).getBillDate();
            if (veriDate != null && !veriDate.before(billDate)) continue;
            veriDate = billDate;
        }
        CompanyOrgUnitInfo curCompany = veriBill.getCompany();
        SystemStatusCtrolInfo sysStatusInfo = ArApBillHelper.getSysStatusCtrolInfo(ctx, curCompany, this.getSysEnum(veriBill.getVerificationType()));
        if (sysStatusInfo == null) {
            logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"151_VerificationBillBaseControllerBean", (Locale)ctx.getLocale()));
            return;
        }
        PeriodInfo curPeriod = sysStatusInfo.getCurrentPeriod();
        if (entry.size() > 0 && veriDate != null) {
            veriBill.setBizDate(ArApBillHelper.getVerifiedDate(veriDate, curPeriod));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _createBillInnerVeriEntrys(Context ctx, Connection conn, VerificationBillBaseInfo veriBill, VerificateBillTypeEnum veriEnum, FilterInfo filter, BigDecimal lessTotalVeri, HashMap signal) throws SQLException, EASBizException, BOSException {
        BigDecimal thisVeriAmt = null;
        boolean veriFinished = false;
        VerificationBillBaseEntryInfo veriEntry = null;
        Statement preStmt = null;
        IRowSet rsBot = null;
        String sql = null;
        VerificateBillTypeEnum subBillType = null;
        CurrencyInfo currency = veriBill.getCompany().getBaseCurrency();
        int locCurrPre = 2;
        if (currency != null && currency.getId() != null) {
            SelectorItemCollection selects = new SelectorItemCollection();
            selects.add(new SelectorItemInfo("precision"));
            currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId().toString()), selects);
            locCurrPre = currency.getPrecision();
        }
        IObjectCollection entrys = (IObjectCollection)veriBill.get("entrys");
        switch (veriEnum.getValue()) {
            case 8: {
                sql = this._getAutoVeriSql_AR(ctx, filter, 0);
                break;
            }
            case 6: {
                sql = this._getAutoVeriSql_Rec(ctx, filter, 0, signal);
                break;
            }
            case 9: {
                sql = this._getAutoVeriSql_AP(ctx, filter, 0);
                break;
            }
            case 4: {
                sql = this._getAutoVeriSql_Pay(ctx, filter, 0);
                break;
            }
            case 7: {
                sql = this._getAutoVeriSql_Rec(ctx, filter, 0, signal);
                break;
            }
            case 5: {
                sql = this._getAutoVeriSql_Pay(ctx, filter, 0);
                break;
            }
            default: {
                return;
            }
        }
        boolean isAR = veriBill instanceof VerificationBillInfo;
        try {
            rsBot = DbUtil.executeQuery((Context)ctx, (String)sql);
            HashMap billContrastAmtSum = new HashMap();
            HashMap billContratAmtLocSum = new HashMap();
            while (rsBot.next()) {
                String billid = rsBot.getString("billid");
                BigDecimal currentVerificateAmt = rsBot.getBigDecimal("unverificateamt");
                BigDecimal currentVerificateAmtLoc = rsBot.getBigDecimal("unverificateamtloc");
                this.constructBillFlagAmtHashMap(billContrastAmtSum, billid, currentVerificateAmt);
                this.constructBillFlagAmtHashMap(billContratAmtLocSum, billid, currentVerificateAmtLoc);
            }
            rsBot.beforeFirst();
            while (rsBot.next()) {
                veriEntry = isAR ? new VerificationBillentryInfo() : new com.kingdee.eas.fi.ap.VerificationBillentryInfo();
                thisVeriAmt = rsBot.getBigDecimal("unverificateamt");
                BigDecimal thisVeriAmtLoc = rsBot.getBigDecimal("unverificateamtloc");
                String billid = rsBot.getString("billid");
                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"83_ArVerificationFacadeControllerBean", (Locale)ctx.getLocale()) + rsBot.getString("billid")));
                BigDecimal resultVeriAmt = this.ZERO;
                BigDecimal resultVeriAmtLoc = this.ZERO;
                BigDecimal billPosAmt = this.getBillFlagAmt(billContrastAmtSum, billid, this.posKey);
                BigDecimal billNegAmt = this.getBillFlagAmt(billContrastAmtSum, billid, this.negKey);
                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"84_ArVerificationFacadeControllerBean", (Locale)ctx.getLocale()) + billPosAmt));
                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"85_ArVerificationFacadeControllerBean", (Locale)ctx.getLocale()) + billNegAmt));
                if (this.pureKey.equals(this.getBillPureFlag(billContrastAmtSum, billid))) continue;
                String billFlag = this.getBillFlag(billContrastAmtSum, billid);
                if (billPosAmt.abs().compareTo(this.ZERO) > 0 || billNegAmt.abs().compareTo(this.ZERO) > 0) {
                    if (this.posKey.equals(billFlag)) {
                        BigDecimal billNegAmtLoc = this.getBillFlagAmt(billContratAmtLocSum, billid, this.negKey);
                        if (thisVeriAmt.signum() > 0) {
                            if (billNegAmt.abs().compareTo(thisVeriAmt.abs()) > 0) {
                                resultVeriAmt = thisVeriAmt;
                                resultVeriAmtLoc = thisVeriAmtLoc;
                                this.setBillFlagAmt(billContrastAmtSum, billid, this.negKey, billNegAmt.add(thisVeriAmt));
                                this.setBillFlagAmt(billContratAmtLocSum, billid, this.negKey, billNegAmtLoc.add(thisVeriAmtLoc));
                                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"86_ArVerificationFacadeControllerBean", (Locale)ctx.getLocale()) + resultVeriAmt));
                            } else {
                                resultVeriAmt = billNegAmt.abs();
                                resultVeriAmtLoc = billNegAmtLoc.abs();
                                this.setBillFlagAmt(billContrastAmtSum, billid, this.negKey, this.ZERO);
                                this.setBillFlagAmt(billContratAmtLocSum, billid, this.negKey, this.ZERO);
                                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"87_ArVerificationFacadeControllerBean", (Locale)ctx.getLocale()) + resultVeriAmt));
                            }
                        } else {
                            resultVeriAmt = thisVeriAmt;
                            resultVeriAmtLoc = thisVeriAmtLoc;
                        }
                    } else {
                        BigDecimal billPosAmtLoc = this.getBillFlagAmt(billContratAmtLocSum, billid, this.posKey);
                        if (thisVeriAmt.signum() < 0) {
                            if (billPosAmt.abs().compareTo(thisVeriAmt.abs()) > 0) {
                                resultVeriAmt = thisVeriAmt;
                                resultVeriAmtLoc = thisVeriAmtLoc;
                                this.setBillFlagAmt(billContrastAmtSum, billid, this.posKey, billPosAmt.add(thisVeriAmt));
                                this.setBillFlagAmt(billContratAmtLocSum, billid, this.posKey, billPosAmtLoc.add(thisVeriAmtLoc));
                                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"88_ArVerificationFacadeControllerBean", (Locale)ctx.getLocale()) + resultVeriAmt));
                            } else {
                                resultVeriAmt = billPosAmt.negate();
                                resultVeriAmtLoc = billPosAmtLoc.negate();
                                this.setBillFlagAmt(billContrastAmtSum, billid, this.posKey, this.ZERO);
                                this.setBillFlagAmt(billContratAmtLocSum, billid, this.posKey, this.ZERO);
                                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"88_ArVerificationFacadeControllerBean", (Locale)ctx.getLocale()) + resultVeriAmt));
                            }
                        } else {
                            resultVeriAmt = thisVeriAmt;
                            resultVeriAmtLoc = thisVeriAmtLoc;
                        }
                    }
                } else {
                    veriFinished = true;
                }
                if (resultVeriAmt == null || resultVeriAmt.compareTo(this.ZERO) == 0) continue;
                veriEntry.setBillType(veriEnum);
                switch (veriEnum.getValue()) {
                    case 6: {
                        subBillType = Helper.getRecPayVeriBillTypeEnum(true, rsBot.getString("billsubtype"), thisVeriAmt);
                        break;
                    }
                    case 8: {
                        subBillType = Helper.changeBillType(true, rsBot.getInt("billsubtype"));
                        break;
                    }
                    case 7: {
                        subBillType = Helper.getRecPayVeriBillTypeEnum(true, rsBot.getString("billsubtype"), thisVeriAmt);
                        break;
                    }
                    case 4: {
                        subBillType = Helper.getRecPayVeriBillTypeEnum(false, rsBot.getString("billsubtype"), thisVeriAmt);
                        break;
                    }
                    case 9: {
                        subBillType = Helper.changeBillType(false, rsBot.getInt("billsubtype"));
                        break;
                    }
                    case 5: {
                        subBillType = Helper.getRecPayVeriBillTypeEnum(false, rsBot.getString("billsubtype"), thisVeriAmt);
                        break;
                    }
                    default: {
                        subBillType = null;
                    }
                }
                veriEntry.setBillSubType(subBillType);
                veriEntry.setCurrency(Helper.getCurrencyInfo_OnlyPK(rsBot.getString("currency_id")));
                veriEntry.setBillID(BOSUuid.read((String)rsBot.getString("billid")));
                veriEntry.setEntryID(BOSUuid.read((String)rsBot.getString("entryid")));
                veriEntry.setBillNumber(rsBot.getString("b_number"));
                veriEntry.setBillDate(rsBot.getDate("billdate"));
                veriEntry.setAcctCussType(Helper.getAcctCussTypeInfo_OnlyPK(rsBot.getString("acctCussType_id")));
                veriEntry.setAcctCussID(BOSUuid.read((String)rsBot.getString("acctCuss_id")));
                veriEntry.setAcctCussName(rsBot.getString("acctCuss_name"));
                veriEntry.setComment(rsBot.getString("description"));
                veriEntry.setAccount(Helper.getAccountViewInfo_OnlyPK(rsBot.getString("accountid")));
                veriEntry.setOppAccount(Helper.getAccountViewInfo_OnlyPK(rsBot.getString("oppAccount")));
                veriEntry.setAdminOrgUnit(Helper.getAdminOrgUnitInfo_OnlyPK(rsBot.getString("FAdminOrgUnitID")));
                veriEntry.setPerson(Helper.getPersonInfo_OnlyPK(rsBot.getString("FPersonID")));
                veriEntry.setThisVerificateAmt(resultVeriAmt);
                String materialID = rsBot.getString("FMaterialID");
                String materialName = rsBot.getString("FMaterialName");
                String expenseItemID = rsBot.getString("FExpenseItemID");
                if (materialID != null) {
                    veriEntry.setMaterialId(BOSUuid.read((String)materialID));
                    veriEntry.setMaterialName(rsBot.getString("FMaterialName"));
                    veriEntry.setMaterialNumber(rsBot.getString("FMaterialNumber"));
                } else if (expenseItemID != null) {
                    veriEntry.setMaterialId(BOSUuid.read((String)expenseItemID));
                    veriEntry.setMaterialName(rsBot.getString("FExpenseItemName"));
                    veriEntry.setMaterialNumber(rsBot.getString("FExpenseItemNumber"));
                } else if (materialID == null && materialName != null) {
                    veriEntry.setMaterialName(materialName);
                }
                if (veriEnum.getValue() != 8 && veriEnum.getValue() != 9 && rsBot.getString("FVeriRecPayTypeId") != null) {
                    veriEntry.setVeriRecPayTypeId(BOSUuid.read((String)rsBot.getString("FVeriRecPayTypeId")));
                    veriEntry.setVeriRecPayTypeNumber(rsBot.getString("FVeriRecPayTypeNumber"));
                    veriEntry.setVeriRecPayTypeName(rsBot.getString("FVeriRecPayTypeName"));
                }
                if (veriFinished) {
                    BigDecimal exchangeRate = rsBot.getBigDecimal("exchangerate");
                    veriEntry.setThisVerificateAmtLoc(resultVeriAmt.multiply(exchangeRate).setScale(locCurrPre, 4));
                    entrys.addObject((IObjectValue)veriEntry);
                    break;
                }
                veriEntry.setThisVerificateAmtLoc(resultVeriAmtLoc.setScale(locCurrPre, 4));
                entrys.addObject((IObjectValue)veriEntry);
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rsBot, preStmt);
        }
    }

    private void constructBillFlagAmtHashMap(HashMap billMap, String billid, BigDecimal currentAmt) {
        boolean signal;
        if (currentAmt == null) {
            currentAmt = this.ZERO;
        }
        boolean bl = signal = currentAmt.compareTo(this.ZERO) > 0;
        if (billMap.get(billid) == null) {
            HashMap<String, BigDecimal> entryFlagAmtFlag = new HashMap<String, BigDecimal>();
            entryFlagAmtFlag.put(signal ? this.posKey : this.negKey, currentAmt);
            billMap.put(billid, entryFlagAmtFlag);
            this.initPureBillFlag(billMap, billid, this.pureKey);
        } else {
            this.initBillSumAmtFlag(billMap, billid, signal ? this.posKey : this.negKey, currentAmt);
        }
    }

    private void initBillSumAmtFlag(HashMap billMap, String billid, String flag, BigDecimal currentAmt) {
        BigDecimal preAmt = this.ZERO;
        Object obj = ((HashMap)billMap.get(billid)).get(flag);
        if (obj instanceof BigDecimal) {
            preAmt = (BigDecimal)obj;
        }
        BigDecimal flagAmt = preAmt.add(currentAmt);
        ((HashMap)billMap.get(billid)).put(flag, flagAmt);
        String contrastFlag = this.posKey.equals(flag) ? this.negKey : this.posKey;
        BigDecimal contrastAmt = this.getBillFlagAmt(billMap, billid, contrastFlag);
        boolean amtSignal = flagAmt.abs().compareTo(contrastAmt.abs()) > 0;
        this.initAmtFlag(billMap, billid, amtSignal ? flag : contrastFlag);
        boolean pureFlag = contrastAmt.compareTo(this.ZERO) == 0;
        this.initPureBillFlag(billMap, billid, pureFlag ? this.pureKey : this.mixKey);
    }

    private void initAmtFlag(HashMap billMap, String billid, String resultFlag) {
        ((HashMap)billMap.get(billid)).put(this.billAmtFlag, resultFlag);
    }

    private void initPureBillFlag(HashMap billMap, String billid, String resultFlag) {
        ((HashMap)billMap.get(billid)).put(this.pureBillFlag, resultFlag);
    }

    private BigDecimal getBillFlagAmt(HashMap billMap, String billid, String flag) {
        Object obj;
        if (billMap.get(billid) instanceof HashMap && (obj = ((HashMap)billMap.get(billid)).get(flag)) instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        return this.ZERO;
    }

    private void setBillFlagAmt(HashMap billMap, String billid, String flag, BigDecimal amt) {
        if (billMap.get(billid) instanceof HashMap) {
            ((HashMap)billMap.get(billid)).put(flag, amt);
        }
    }

    private String getBillFlag(HashMap billMap, String billid) {
        Object obj;
        if (billMap.get(billid) instanceof HashMap && (obj = ((HashMap)billMap.get(billid)).get(this.billAmtFlag)) instanceof String) {
            return (String)obj;
        }
        return this.posKey;
    }

    private String getBillPureFlag(HashMap billMap, String billid) {
        Object obj;
        if (billMap.get(billid) instanceof HashMap && (obj = ((HashMap)billMap.get(billid)).get(this.pureBillFlag)) instanceof String) {
            return (String)obj;
        }
        return this.mixKey;
    }

    private void constructBillEntryAmt(HashMap billMap, String entryid, String columnName, BigDecimal currentAmt) {
        if (currentAmt == null) {
            currentAmt = this.ZERO;
        }
        if (billMap.get(entryid) == null) {
            HashMap<String, BigDecimal> entryAmt = new HashMap<String, BigDecimal>();
            entryAmt.put(columnName, currentAmt);
            billMap.put(entryid, entryAmt);
        }
    }

    private void setEntryBigDecimal(HashMap billMap, String entryid, String columnName, BigDecimal currentAmt) {
        BigDecimal preAmt = this.ZERO;
        Object obj = ((HashMap)billMap.get(entryid)).get(columnName);
        if (obj instanceof BigDecimal) {
            preAmt = (BigDecimal)obj;
        }
        ((HashMap)billMap.get(entryid)).put(columnName, preAmt);
    }

    private CoreBaseCollection _autoVerifyOneSide(Context ctx, Connection conn, VerificationEnum veriType, FilterInfo topFilter, FilterInfo botFilter, boolean sameSide, boolean sameAmount, boolean isBillVeri, String billType, Date veriDate, HashMap signal) throws BOSException, EASBizException, SQLException {
        String topUnVeriStr = null;
        String botUnVeriStr = null;
        VerificateBillTypeEnum topVeriBillType = null;
        VerificateBillTypeEnum botVeriBillType = null;
        CoreBaseCollection veriResult = new CoreBaseCollection();
        switch (veriType.getValue()) {
            case 101: {
                if (sameSide) {
                    if (billType.endsWith(AR)) {
                        topUnVeriStr = "t2.FLockUnVerifyAmt";
                        botUnVeriStr = "t2.FLockUnVerifyAmt";
                        botVeriBillType = topVeriBillType = VerificateBillTypeEnum.OtherReceiveBill;
                        break;
                    }
                    topUnVeriStr = "t2.FUnLockAmt";
                    botUnVeriStr = "t2.FUnLockAmt";
                    botVeriBillType = topVeriBillType = VerificateBillTypeEnum.ReceiveBill;
                    break;
                }
                topUnVeriStr = "t2.FLockUnVerifyAmt";
                botUnVeriStr = "t2.FUnLockAmt";
                topVeriBillType = VerificateBillTypeEnum.OtherReceiveBill;
                botVeriBillType = VerificateBillTypeEnum.ReceiveBill;
                break;
            }
            case 103: {
                topUnVeriStr = "t2.FLockUnVerifyAmt";
                botUnVeriStr = "t2.FLockUnVerifyAmt";
                topVeriBillType = VerificateBillTypeEnum.OtherReceiveBill;
                botVeriBillType = VerificateBillTypeEnum.OtherPaymentBill;
                break;
            }
            case 113: {
                botUnVeriStr = "t2.FUnLockAmt";
                topUnVeriStr = "t2.FUnLockAmt";
                if (billType.endsWith(RECEIVE)) {
                    botVeriBillType = topVeriBillType = VerificateBillTypeEnum.ReceiveBill;
                    break;
                }
                botVeriBillType = topVeriBillType = VerificateBillTypeEnum.PaymentBill;
                break;
            }
            case 211: {
                botUnVeriStr = "t2.FUnLockAmt";
                topUnVeriStr = "t2.FUnLockAmt";
                if (billType.endsWith(RECEIVE)) {
                    botVeriBillType = topVeriBillType = VerificateBillTypeEnum.ReceiveBill;
                    break;
                }
                botVeriBillType = topVeriBillType = VerificateBillTypeEnum.PaymentBill;
                break;
            }
            case 201: {
                if (sameSide) {
                    if (billType.endsWith(AP)) {
                        topUnVeriStr = "t2.FLockUnVerifyAmt";
                        botUnVeriStr = "t2.FLockUnVerifyAmt";
                        botVeriBillType = topVeriBillType = VerificateBillTypeEnum.OtherPaymentBill;
                        break;
                    }
                    topUnVeriStr = "t2.FUnLockAmt";
                    botUnVeriStr = "t2.FUnLockAmt";
                    botVeriBillType = topVeriBillType = VerificateBillTypeEnum.PaymentBill;
                    break;
                }
                topUnVeriStr = "t2.FLockUnVerifyAmt";
                botUnVeriStr = "t2.FUnLockAmt";
                topVeriBillType = VerificateBillTypeEnum.OtherPaymentBill;
                botVeriBillType = VerificateBillTypeEnum.PaymentBill;
                break;
            }
            case 203: {
                topUnVeriStr = "t2.FLockUnVerifyAmt";
                botUnVeriStr = "t2.FLockUnVerifyAmt";
                topVeriBillType = VerificateBillTypeEnum.OtherPaymentBill;
                botVeriBillType = VerificateBillTypeEnum.OtherReceiveBill;
                break;
            }
            case 104: {
                topUnVeriStr = "t2.FUnLockAmt";
                botUnVeriStr = "t2.FUnLockAmt";
                topVeriBillType = VerificateBillTypeEnum.ReceiveBill;
                botVeriBillType = VerificateBillTypeEnum.PaymentBill;
                break;
            }
            case 204: {
                topUnVeriStr = "t2.FUnLockAmt";
                botUnVeriStr = "t2.FUnLockAmt";
                topVeriBillType = VerificateBillTypeEnum.PaymentBill;
                botVeriBillType = VerificateBillTypeEnum.ReceiveBill;
                break;
            }
            default: {
                return veriResult;
            }
        }
        if (sameSide) {
            topFilter.getFilterItems().add(new FilterItemInfo(topUnVeriStr, (Object)this.ZERO, CompareType.LESS));
            botFilter.getFilterItems().add(new FilterItemInfo(botUnVeriStr, (Object)this.ZERO, CompareType.GREATER));
            topFilter.setMaskString(topFilter.getMaskString() + " AND #" + (topFilter.getFilterItems().size() - 1));
            botFilter.setMaskString(botFilter.getMaskString() + " AND #" + (botFilter.getFilterItems().size() - 1));
        } else {
            FilterInfo topFilterCopy = (FilterInfo)topFilter.clone();
            FilterInfo botFilterCopy = (FilterInfo)botFilter.clone();
            topFilterCopy.getFilterItems().add(new FilterItemInfo(topUnVeriStr, (Object)this.ZERO, CompareType.GREATER));
            botFilterCopy.getFilterItems().add(new FilterItemInfo(botUnVeriStr, (Object)this.ZERO, CompareType.GREATER));
            topFilterCopy.setMaskString(topFilterCopy.getMaskString() + " AND #" + (topFilterCopy.getFilterItems().size() - 1));
            botFilterCopy.setMaskString(botFilterCopy.getMaskString() + " AND #" + (botFilterCopy.getFilterItems().size() - 1));
            veriResult.addCollection(this.buildVeriBills(ctx, conn, veriType, topFilterCopy, botFilterCopy, sameSide, sameAmount, isBillVeri, topVeriBillType, botVeriBillType, veriDate, signal));
            topFilter.getFilterItems().add(new FilterItemInfo(topUnVeriStr, (Object)this.ZERO, CompareType.LESS));
            botFilter.getFilterItems().add(new FilterItemInfo(botUnVeriStr, (Object)this.ZERO, CompareType.LESS));
        }
        topFilter.setMaskString(topFilter.getMaskString() + " AND #" + (topFilter.getFilterItems().size() - 1));
        botFilter.setMaskString(botFilter.getMaskString() + " AND #" + (botFilter.getFilterItems().size() - 1));
        veriResult.addCollection(this.buildVeriBills(ctx, conn, veriType, topFilter, botFilter, sameSide, sameAmount, isBillVeri, topVeriBillType, botVeriBillType, veriDate, signal));
        return veriResult;
    }

    @Override
    protected Collection _autoVerifyByCoreNum(Context ctx, Collection pks, VerificationEnum veriType, boolean isFromMain) throws BOSException, EASBizException {
        ArrayList<BOSUuid> arrayList;
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement prmt = null;
        PreparedStatement prmtUpdate = null;
        PreparedStatement prmtEntry = null;
        PreparedStatement prmtEntryUpdateMain = null;
        Statement prmtEntryUpdateSec = null;
        ResultSet rs = null;
        StringBuffer ids = new StringBuffer();
        Iterator iter = pks.iterator();
        String coreBillNum = null;
        String coreBillEntrySeq = null;
        while (iter.hasNext()) {
            ids.append("'").append(iter.next()).append("',");
        }
        if (ids.length() <= 0) {
            return null;
        }
        ids.deleteCharAt(ids.length() - 1);
        CompanyOrgUnitInfo company = CommonServerUtils.getCurrentCompany(ctx);
        String comapnyID = company.getId().toString();
        this.iMutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (3 == KSqlUtil.getDbType((Connection)conn)) {
                this.isMsDB = true;
            }
            stmt = conn.createStatement();
            rs = stmt.executeQuery(this.getCoreNumBills(ids.toString(), veriType, isFromMain, comapnyID));
            ArrayList<PairForVeriByCoreNum> pairs = new ArrayList<PairForVeriByCoreNum>();
            PairForVeriByCoreNum tempVeriPair2 = null;
            String mainBillID = null;
            String mainEntryID = null;
            String mainBillSubType = null;
            String mainBizCode = null;
            String secBillID = null;
            String secEntryID = null;
            String secBillSubType = null;
            String secBizCode = null;
            String companyID = null;
            BigDecimal mainUnVeriAmt = null;
            BigDecimal secUnVeriAmt = null;
            BigDecimal mainRate = null;
            BigDecimal secRate = null;
            boolean isTransVeri = false;
            boolean isCash = false;
            int precision = 4;
            int pairListIndex = -1;
            ArrayList<String> otherLockedList = new ArrayList<String>();
            NeedVeriBillEntryInfo mainNeedVeriEntry = null;
            NeedVeriBillEntryInfo secNeedVeriEntry = null;
            HashMap<String, java.sql.Date> maxDateMap = new HashMap<String, java.sql.Date>();
            PeriodInfo curPeriod = null;
            boolean isDirectExchange = true;
            ExchangeRateInfo exgRateInfo = null;
            while (rs.next()) {
                coreBillNum = rs.getString(1);
                coreBillEntrySeq = rs.getString(2);
                if (rs.getDate(6).before(rs.getDate(17))) {
                    maxDateMap.put(rs.getString(1), rs.getDate(17));
                } else {
                    maxDateMap.put(rs.getString(1), rs.getDate(6));
                }
                if (rs.getString("mainPaymenttype").equals("cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5") || rs.getString("mainPaymenttype").equals("40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5")) {
                    isCash = true;
                }
                if (!rs.getString("mainPaymenttype").equals(rs.getString("secPaymenttype"))) break;
                if (companyID == null) {
                    companyID = rs.getString("companyID");
                    String queryPreSql = "select baseCurrency.precision,baseCurrency.id,baseExchangeTable.id where id='" + companyID + "'";
                    CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(queryPreSql);
                    precision = companyInfo.getBaseCurrency().getPrecision();
                    if (exgRateInfo == null) {
                        String currencyID = rs.getString("FcurrencyID");
                        if (companyInfo.getBaseCurrency() != null && !currencyID.equals(companyInfo.getBaseCurrency().getId().toString()) && companyInfo.getBaseExchangeTable() != null && (exgRateInfo = ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRate((IObjectPK)new ObjectUuidPK(companyInfo.getBaseExchangeTable().getId()), (IObjectPK)new ObjectUuidPK(currencyID), (IObjectPK)new ObjectUuidPK(companyInfo.getBaseCurrency().getId()), (Date)rs.getDate("secBizDate"))) != null) {
                            isDirectExchange = exgRateInfo.getExchangeAux() != null && ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)exgRateInfo.getExchangeAux().getConvertMode());
                        }
                    }
                    curPeriod = ArApBillHelper.getSysStatusCtrolInfo(ctx, companyInfo, this.getSysEnum(veriType)).getCurrentPeriod();
                }
                if (!this.requestLockIDList.contains(mainBillID = rs.getString("mainBillID"))) {
                    this.requestLockIDList.add(mainBillID);
                }
                mainEntryID = rs.getString("mainEntryID");
                mainBillSubType = rs.getString("mainBillSubType");
                mainBizCode = rs.getString("mainBizCode");
                mainUnVeriAmt = rs.getBigDecimal("mainUnVeriAmt");
                mainRate = rs.getBigDecimal("mainRate");
                secBillID = rs.getString("secBillID");
                if (!this.requestLockIDList.contains(secBillID)) {
                    this.requestLockIDList.add(secBillID);
                }
                secEntryID = rs.getString("secEntryID");
                secBillSubType = rs.getString("secBillSubType");
                secBizCode = rs.getString("secBizCode");
                secUnVeriAmt = rs.getBigDecimal("secUnVeriAmt");
                secRate = rs.getBigDecimal("secRate");
                tempVeriPair2 = new PairForVeriByCoreNum(coreBillNum, coreBillEntrySeq);
                pairListIndex = pairs.indexOf(tempVeriPair2);
                if (pairListIndex >= 0) {
                    tempVeriPair2 = (PairForVeriByCoreNum)pairs.get(pairListIndex);
                } else {
                    pairs.add(tempVeriPair2);
                }
                mainNeedVeriEntry = new NeedVeriBillEntryInfo(mainBillID, mainEntryID, mainBillSubType, mainBizCode, mainUnVeriAmt, mainRate);
                tempVeriPair2.addTopEntrys(mainNeedVeriEntry);
                secNeedVeriEntry = new NeedVeriBillEntryInfo(secBillID, secEntryID, secBillSubType, secBizCode, secUnVeriAmt, secRate);
                tempVeriPair2.addBotEntrys(secNeedVeriEntry);
            }
            if (this.requestLockIDList != null && this.requestLockIDList.size() > 0) {
                Map map = this.iMutexServiceControl.batchRequestObjIDForUpdate(this.requestLockIDList);
                int size = this.requestLockIDList.size();
                for (int i = 0; i < size; ++i) {
                    String id = (String)this.requestLockIDList.get(i);
                    if (((Boolean)map.get(id)).booleanValue()) {
                        this.lockedIDList.add(id);
                        continue;
                    }
                    if (pks.contains(id)) continue;
                    otherLockedList.add(id);
                }
                if (otherLockedList.size() > 0) {
                    this.releaseLocks(this.lockedIDList);
                    throw new ARAPVerifynException(ARAPVerifynException.BILL_LOCKED_NOT_VERI);
                }
            }
            ArrayList mainUnVeriList = null;
            ArrayList secUnVeriList = null;
            ArrayList<BOSUuid> veriBillIDs = new ArrayList<BOSUuid>();
            BigDecimal lessUnVeriAmt = null;
            BigDecimal zero = this.ZERO;
            VerificationBillBaseInfo veriBill = null;
            boolean isArVeriBill = true;
            VerificateBillTypeEnum mainType = null;
            VerificateBillTypeEnum secType = null;
            if (veriType.getValue() == 201) {
                veriBill = new com.kingdee.eas.fi.ap.VerificationBillInfo();
                isArVeriBill = false;
                mainType = VerificateBillTypeEnum.OtherPaymentBill;
                secType = VerificateBillTypeEnum.PaymentBill;
            } else {
                veriBill = new VerificationBillInfo();
                mainType = VerificateBillTypeEnum.OtherReceiveBill;
                secType = VerificateBillTypeEnum.ReceiveBill;
            }
            veriBill.setMainBillType(mainType);
            veriBill.setSecondBillType(secType);
            if (isTransVeri) {
                if (101 == veriType.getValue()) {
                    veriBill.setVerificationType(VerificationEnum.AR_Rec_AB);
                } else {
                    veriBill.setVerificationType(VerificationEnum.AP_Pay_AB);
                }
            } else {
                veriBill.setVerificationType(veriType);
            }
            veriBill.setCompany(Helper.getCompanyOrgUnitInfo_OnlyPK(companyID));
            veriBill.setIsCashSalePur(isCash);
            BOSUuid veriBillPK = null;
            if (pairs.size() > 0) {
                prmt = conn.prepareStatement(this.getInsertVeriBillSql(ctx, isArVeriBill));
                prmtUpdate = conn.prepareStatement(this.getUpdateVeriBillSql(ctx, isArVeriBill));
                prmtEntry = conn.prepareStatement(this.getInsertVeriEntrySql(isArVeriBill));
                prmtEntryUpdateMain = conn.prepareStatement(this.getUpdateVeriEntrySql(ctx, isArVeriBill, true));
                prmtEntryUpdateSec = conn.prepareStatement(this.getUpdateVeriEntrySql(ctx, isArVeriBill, false));
            }
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            String number = null;
            int k = 0;
            for (PairForVeriByCoreNum tempVeriPair2 : pairs) {
                mainUnVeriList = tempVeriPair2.getTopEntrys();
                secUnVeriList = tempVeriPair2.getBotEntrys();
                String coreNum = tempVeriPair2.getCoreNum();
                java.sql.Date maxDate = (java.sql.Date)maxDateMap.get(coreNum);
                maxDate = new java.sql.Date(ArApBillHelper.getVerifiedDate(maxDate, curPeriod).getTime());
                ++k;
                int secIndex = 0;
                int mainListSize = mainUnVeriList.size();
                for (int i = 0; i < mainListSize; ++i) {
                    mainNeedVeriEntry = (NeedVeriBillEntryInfo)mainUnVeriList.get(i);
                    mainUnVeriAmt = mainNeedVeriEntry.getUnVeriAmt();
                    int secListSize = secUnVeriList.size();
                    for (int j = secIndex; j < secListSize; ++j) {
                        secNeedVeriEntry = (NeedVeriBillEntryInfo)secUnVeriList.get(j);
                        secUnVeriAmt = secNeedVeriEntry.getUnVeriAmt();
                        if (secUnVeriAmt.compareTo(zero) == 0) continue;
                        if (secUnVeriAmt.signum() != mainUnVeriAmt.signum()) break;
                        BOSObjectType entryType = new VerificationBillentryInfo().getBOSType();
                        String mainID = BOSUuid.create((BOSObjectType)entryType).toString();
                        String secID = BOSUuid.create((BOSObjectType)entryType).toString();
                        lessUnVeriAmt = mainUnVeriAmt.abs().compareTo(secUnVeriAmt.abs()) > 0 ? secUnVeriAmt : mainUnVeriAmt;
                        veriBillPK = BOSUuid.create((BOSObjectType)veriBill.getBOSType());
                        veriBillIDs.add(veriBillPK);
                        veriBill.setId(veriBillPK);
                        number = iCodingRuleManager.getNumber((IObjectValue)veriBill, veriBill.getCompany().getId().toString(), "");
                        veriBill.setNumber(number);
                        this.addOneBillBatch(prmt, prmtUpdate, veriBill, precision, mainNeedVeriEntry, secNeedVeriEntry, maxDate, isDirectExchange);
                        this.addEntryBatch(prmtEntry, prmtEntryUpdateMain, (PreparedStatement)prmtEntryUpdateSec, precision, veriBill, mainNeedVeriEntry, secNeedVeriEntry, mainID, secID, isDirectExchange);
                        mainUnVeriAmt = mainUnVeriAmt.subtract(lessUnVeriAmt);
                        mainNeedVeriEntry.setUnVeriAmt(mainUnVeriAmt);
                        secUnVeriAmt = secUnVeriAmt.subtract(lessUnVeriAmt);
                        secNeedVeriEntry.setUnVeriAmt(secUnVeriAmt);
                        if (mainUnVeriAmt.compareTo(zero) == 0) {
                            secIndex = j;
                            break;
                        }
                        if (secUnVeriAmt.compareTo(zero) != 0) continue;
                        secIndex = j + 1;
                    }
                    if (i != mainListSize - 1) continue;
                    secIndex = 0;
                }
            }
            int billSize = veriBillIDs.size();
            if (pairs.size() > 0 && billSize > 0) {
                if (prmt != null) {
                    prmt.executeBatch();
                }
                if (prmtUpdate != null) {
                    prmtUpdate.executeBatch();
                }
                if (prmtEntry != null) {
                    prmtEntry.executeBatch();
                }
                if (prmtEntryUpdateMain != null) {
                    prmtEntryUpdateMain.executeBatch();
                }
                if (prmtEntryUpdateSec != null) {
                    prmtEntryUpdateSec.executeBatch();
                }
                stmt.executeUpdate(this.getUpdateSumVeriBillSql(ctx, veriBillIDs, true, isArVeriBill));
                stmt.executeUpdate(this.getUpdateSumVeriBillSql(ctx, veriBillIDs, false, isArVeriBill));
                IVerificationBill iveriBill = VerificationBillFactory.getLocalInstance(ctx);
                iveriBill.writeBackBills(veriBillIDs, isArVeriBill);
            }
            arrayList = veriBillIDs;
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                SQLUtils.cleanup(prmt);
                SQLUtils.cleanup(prmtUpdate);
                SQLUtils.cleanup(prmtEntry);
                SQLUtils.cleanup(prmtEntryUpdateMain);
                SQLUtils.cleanup(prmtEntryUpdateSec, (Connection)conn);
                this.releaseLocks(this.lockedIDList);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        SQLUtils.cleanup((Statement)prmt);
        SQLUtils.cleanup((Statement)prmtUpdate);
        SQLUtils.cleanup((Statement)prmtEntry);
        SQLUtils.cleanup((Statement)prmtEntryUpdateMain);
        SQLUtils.cleanup((Statement)prmtEntryUpdateSec, (Connection)conn);
        this.releaseLocks(this.lockedIDList);
        return arrayList;
    }

    private String getUpdateSumVeriBillSql(Context ctx, ArrayList veriBillIDs, boolean isMain, boolean isArVeriBill) {
        StringBuffer sb = new StringBuffer("");
        String ids = ArApBillHelper.ids2SqlString(veriBillIDs);
        sb.append("UPDATE ").append(isArVeriBill ? "t_ar_verificationbill" : "t_ap_verificationbill").append(" bill");
        if (isMain) {
            sb.append(" SET (FThisVerificateAmt_Main, FThisVerificateAmtLoc_Main, FGainAndLoss) = (");
        } else {
            sb.append(" SET (FThisVerificateAmt_Second, FThisVerificateAmtLoc_Second) = (");
        }
        sb.append("SELECT temp.FThisVerificateAmt, temp.FThisVerificateAmtLoc");
        if (isMain) {
            sb.append(", temp.FGainAndLoss");
        }
        sb.append(" FROM (SELECT SUM(entry.FThisVerificateAmt) AS FThisVerificateAmt, SUM(entry.FThisVerificateAmtLoc) AS FThisVerificateAmtLoc");
        if (isMain) {
            sb.append(", SUM(entry.FGainAndLoss) AS FGainAndLoss");
        }
        sb.append(", entry.FParentID AS FParentID FROM ").append(isArVeriBill ? "t_ar_verificationbillentry" : "t_ap_verificationbillentry");
        sb.append(" entry WHERE entry.FBillType = ");
        if (isMain) {
            sb.append(isArVeriBill ? 8 : 9);
        } else {
            sb.append(isArVeriBill ? 6 : 4);
        }
        sb.append(" AND entry.FParentID IN (").append(ids).append(") GROUP BY entry.FParentID");
        sb.append(") temp WHERE bill.FID = temp.FParentID) WHERE bill.FID IN (").append(ids).append(")");
        return sb.toString();
    }

    protected SystemEnum getSysEnum(VerificationEnum veriType) {
        if (veriType != null && veriType.getValue() > 200) {
            return SystemEnum.ACCOUNTSPAYABLE;
        }
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    public void releaseLocks(List lockList) {
        if (lockList != null && lockList.size() > 0) {
            this.iMutexServiceControl.batchReleaseObjIDForUpdate(lockList);
        }
        if (lockList != null) {
            lockList.clear();
        }
    }

    private String getCoreNumBills_old(String ids, VerificationEnum veriType, boolean mainBill, String companyID) {
        StringBuffer sql = new StringBuffer();
        String idWhere = null;
        sql.append("select ");
        sql.append("t2.fcorebillnumber as coreNum,t2.fcorebillentryseq as coreSeq,");
        sql.append("t4.fid as mainBillID,t3.fid as mainEntryID,t4.FBillType as mainBillSubType,");
        sql.append("t4.fbizdate as mainBizDate,t3.FLockUnVerifyAmt as mainUnVeriAmt,");
        if (veriType != null && 101 == veriType.getValue()) {
            sql.append("t4.fasstactid as mainAsstActID,t1.fpayerid as secAsstActID,");
        } else {
            sql.append("t4.fasstactid as mainAsstActID,t1.fpayeeid as secAsstActID,");
        }
        sql.append("t4.FLastExhangeRate as mainRate,t1.FCompanyID as companyID,");
        sql.append("t1.fid as secBillID,t2.fid as secEntryID,t7.Fnumber as secBillSubType,");
        sql.append("t1.fbizdate as secBizDate,t2.FUnLockAmt as secUnVeriAmt,t1.fexchangerate as secRate,");
        sql.append("baseData.FBizAnalysisCodeID as mainBizCode, baseData2.FBizAnalysisCodeID as secBizCode ");
        if (veriType != null && 101 == veriType.getValue()) {
            sql.append("from T_CAS_ReceivingBill as t1 ");
            sql.append("inner join T_CAS_ReceivingBillEntry as t2 on t1.fid = t2.FReceivingBillID ");
            sql.append("inner join T_AR_OtherbillEntry as t3 ");
            sql.append("on t2.fcorebillnumber = t3.fcorebillnumber and t2.fcorebillentryseq = t3.fcorebillentryseq ");
            sql.append("inner join T_AR_OtherBill as t4 on t4.fid = t3.fparentid and t1.fcompanyid = t4.fcompanyid ");
            sql.append("inner join t_cas_receivingbilltype as t7 on t1.FRecBillTypeID = t7.FID ");
            sql.append("left outer join (select fid,FBizAnalysisCodeID from t_bd_customer ");
            sql.append(" union all select fid,FBizAnalysisCodeID from t_bd_supplier) as baseData ");
            sql.append("on t1.FPayerid = baseData.fid ");
            sql.append("left outer join (select fid,FBizAnalysisCodeID from t_bd_customer ");
            sql.append("union all select fid,FBizAnalysisCodeID from t_bd_supplier ) as baseData2 ");
            sql.append("on t4.FAsstactid = baseData2.fid ");
            sql.append("where t7.FNumber<>'").append(REC_AR_AGENT).append("' AND t7.FNumber<>'").append(REC_AR_REFUNDMENT_AGENT).append("' ");
            sql.append("AND t1.FBillStatus = ").append(14);
        } else {
            sql.append("from T_CAS_PaymentBill as t1 ");
            sql.append("inner join T_CAS_PaymentBillEntry as t2 on t1.fid = t2.FPaymentBillID ");
            sql.append("inner join T_AP_OtherbillEntry as t3 ");
            sql.append("on t2.fcorebillnumber = t3.fcorebillnumber and t2.fcorebillentryseq = t3.fcorebillentryseq ");
            sql.append("inner join T_AP_OtherBill as t4 on t4.fid = t3.fparentid and t1.fcompanyid = t4.fcompanyid ");
            sql.append("inner join t_cas_Paymentbilltype as t7 on t1.FPayBillTypeID = t7.FID ");
            sql.append("left outer join (select fid,FBizAnalysisCodeID from t_bd_customer ");
            sql.append("union all select fid,FBizAnalysisCodeID from t_bd_supplier ) as baseData ");
            sql.append("on t1.FPayeeid = baseData.fid ");
            sql.append("left outer join (select fid,FBizAnalysisCodeID from t_bd_customer ");
            sql.append("union all select fid,FBizAnalysisCodeID from t_bd_supplier ) as baseData2 ");
            sql.append("on t4.FAsstactid = baseData2.fid ");
            sql.append("where t7.FNumber<>'").append(PAY_AP_AGENT).append("' AND t7.FNumber<>'").append(PAY_AP_REFUNDMENT_AGENT).append("' ");
            sql.append("AND t1.FBillStatus = ").append(15);
        }
        sql.append(" AND t1.FCompanyID = '").append(companyID).append("'");
        sql.append(" AND t2.fcorebillnumber is not null AND t2.FUnLockAmt <> 0 ");
        sql.append(" AND t4.FBillStatus = ").append(3);
        sql.append(" and t3.FLockUnVerifyAmt <> 0 and ");
        idWhere = mainBill ? "t4" : "t1";
        sql.append(idWhere).append(".fid in(").append(ids).append(")");
        sql.append("order by t2.fcorebillnumber,t2.fcorebillentryseq,t1.fbizdate ,t4.fbizdate ");
        return sql.toString();
    }

    private String getCoreNumBills(String ids, VerificationEnum veriType, boolean mainBill, String companyID) {
        StringBuffer sql = new StringBuffer();
        String idWhere = null;
        sql.append("select * from (");
        sql.append("select ");
        sql.append("t2.fcorebillnumber as coreNum,t2.fcorebillentryseq as coreSeq,");
        sql.append("t4.fid as mainBillID,t3.fid as mainEntryID,t4.FBillType as mainBillSubType,");
        sql.append("t4.fbizdate as mainBizDate,t3.FLockUnVerifyAmt as mainUnVeriAmt,");
        sql.append("t4.Fpaymenttypeid as mainPaymenttype,t1.Fpaymenttypeid as secPaymenttype,");
        if (veriType != null && 101 == veriType.getValue()) {
            sql.append("t4.fasstactid as mainAsstActID,t1.fpayerid as secAsstActID,");
        } else {
            sql.append("t4.fasstactid as mainAsstActID,t1.fpayeeid as secAsstActID,");
        }
        sql.append("t4.FLastExhangeRate as mainRate,t1.FCompanyID as companyID,");
        sql.append("t1.fid as secBillID,t2.fid as secEntryID, case when t7.fispreset = 0 then t11.fnumber else t7.fnumber end as secBillSubType,");
        sql.append("t1.fbizdate as secBizDate,t2.FUnLockAmt as secUnVeriAmt,t1.fexchangerate as secRate,");
        sql.append("baseData.FBizAnalysisCodeID as mainBizCode, baseData2.FBizAnalysisCodeID as secBizCode,t1.FcurrencyID  as FcurrencyID ");
        if (veriType != null && 101 == veriType.getValue()) {
            sql.append("from T_CAS_ReceivingBill as t1 ");
            sql.append("inner join T_CAS_ReceivingBillEntry as t2 on t1.fid = t2.FReceivingBillID ");
            sql.append("inner join T_AR_OtherbillEntry as t3 ");
            sql.append("on t2.fcorebillnumber = t3.fcorebillnumber and t2.fcorebillentryseq = t3.fcorebillentryseq ");
            sql.append("inner join T_AR_OtherBill as t4 on t4.fid = t3.fparentid and t1.fcompanyid = t4.fcompanyid ");
            sql.append("inner join t_cas_receivingbilltype as t7 on t1.FRecBillTypeID = t7.FID ");
            sql.append("left outer join  t_bd_customer baseData ");
            sql.append("on t1.FPayerid = baseData.fid ");
            sql.append("left outer join t_bd_customer baseData2 ");
            sql.append("on t4.FAsstactid = baseData2.fid ");
            sql.append("left join t_cas_receivingbilltype as t11 on t7.FPreSetBillTypeID = t11.FID ");
            sql.append("where t7.FNumber<>'").append(REC_AR_AGENT).append("' AND t7.FNumber<>'").append(REC_AR_REFUNDMENT_AGENT).append("' ");
            sql.append("AND t1.FBillStatus = ").append(14);
        } else {
            sql.append("from T_CAS_PaymentBill as t1 ");
            sql.append("inner join T_CAS_PaymentBillEntry as t2 on t1.fid = t2.FPaymentBillID ");
            sql.append("inner join T_AP_OtherbillEntry as t3 ");
            sql.append("on t2.fcorebillnumber = t3.fcorebillnumber and t2.fcorebillentryseq = t3.fcorebillentryseq ");
            sql.append("inner join T_AP_OtherBill as t4 on t4.fid = t3.fparentid and t1.fcompanyid = t4.fcompanyid ");
            sql.append("inner join t_cas_Paymentbilltype as t7 on t1.FPayBillTypeID = t7.FID ");
            sql.append("left outer join  t_bd_customer baseData ");
            sql.append("on t1.FPayeeid = baseData.fid ");
            sql.append("left outer join t_bd_customer baseData2 ");
            sql.append("on t4.FAsstactid = baseData2.fid ");
            sql.append("left join t_cas_paymentbilltype as t11 on t7.FPreSetBillTypeID = t11.FID ");
            sql.append("where t7.FNumber<>'").append(PAY_AP_AGENT).append("' AND t7.FNumber<>'").append(PAY_AP_REFUNDMENT_AGENT).append("' ");
            sql.append("AND t7.FNumber<>'").append(204).append("' ");
            sql.append("AND t1.FBillStatus = ").append(15);
        }
        sql.append(" AND t2.fcorebillnumber is not null AND t2.FUnLockAmt <> 0 ");
        sql.append(" AND t4.FBillStatus = ").append(3);
        sql.append(" AND t4.FIsBizBill = 0");
        sql.append(" and t3.FLockUnVerifyAmt <> 0 and ");
        idWhere = mainBill ? "t4" : "t1";
        sql.append(idWhere).append(".fid in(").append(ids).append(")");
        sql.append(" union all ").append("\r\n");
        sql.append("select ");
        sql.append("t2.fcorebillnumber as coreNum,t2.fcorebillentryseq as coreSeq,");
        sql.append("t4.fid as mainBillID,t3.fid as mainEntryID,t4.FBillType as mainBillSubType,");
        sql.append("t4.fbizdate as mainBizDate,t3.FLockUnVerifyAmt as mainUnVeriAmt,");
        sql.append("t4.Fpaymenttypeid as mainPaymenttype,t1.Fpaymenttypeid as secPaymenttype,");
        if (veriType != null && 101 == veriType.getValue()) {
            sql.append("t4.fasstactid as mainAsstActID,t1.fpayerid as secAsstActID,");
        } else {
            sql.append("t4.fasstactid as mainAsstActID,t1.fpayeeid as secAsstActID,");
        }
        sql.append("t4.FLastExhangeRate as mainRate,t1.FCompanyID as companyID,");
        sql.append("t1.fid as secBillID,t2.fid as secEntryID,t7.Fnumber as secBillSubType,");
        sql.append("t1.fbizdate as secBizDate,t2.FUnLockAmt as secUnVeriAmt,t1.fexchangerate as secRate,");
        sql.append("baseData.FBizAnalysisCodeID as mainBizCode, baseData2.FBizAnalysisCodeID as secBizCode,t1.FcurrencyID  as FcurrencyID ");
        if (veriType != null && 101 == veriType.getValue()) {
            sql.append("from T_CAS_ReceivingBill as t1 ");
            sql.append("inner join T_CAS_ReceivingBillEntry as t2 on t1.fid = t2.FReceivingBillID ");
            sql.append("inner join T_AR_OtherbillEntry as t3 ");
            sql.append("on t2.fcorebillnumber = t3.fcorebillnumber and t2.fcorebillentryseq = t3.fcorebillentryseq ");
            sql.append("inner join T_AR_OtherBill as t4 on t4.fid = t3.fparentid and t1.fcompanyid = t4.fcompanyid ");
            sql.append("inner join t_cas_receivingbilltype as t7 on t1.FRecBillTypeID = t7.FID ");
            sql.append("left outer join  t_bd_supplier baseData ");
            sql.append("on t1.FPayerid = baseData.fid ");
            sql.append("left outer join t_bd_supplier baseData2 ");
            sql.append("on t4.FAsstactid = baseData2.fid ");
            sql.append("where t7.FNumber<>'").append(REC_AR_AGENT).append("' AND t7.FNumber<>'").append(REC_AR_REFUNDMENT_AGENT).append("' ");
            sql.append("AND t1.FBillStatus = ").append(14);
        } else {
            sql.append("from T_CAS_PaymentBill as t1 ");
            sql.append("inner join T_CAS_PaymentBillEntry as t2 on t1.fid = t2.FPaymentBillID ");
            sql.append("inner join T_AP_OtherbillEntry as t3 ");
            sql.append("on t2.fcorebillnumber = t3.fcorebillnumber and t2.fcorebillentryseq = t3.fcorebillentryseq ");
            sql.append("inner join T_AP_OtherBill as t4 on t4.fid = t3.fparentid and t1.fcompanyid = t4.fcompanyid ");
            sql.append("inner join t_cas_Paymentbilltype as t7 on t1.FPayBillTypeID = t7.FID ");
            sql.append("left outer join  t_bd_supplier baseData ");
            sql.append("on t1.FPayeeid = baseData.fid ");
            sql.append("left outer join t_bd_supplier baseData2 ");
            sql.append("on t4.FAsstactid = baseData2.fid ");
            sql.append("where t7.FNumber<>'").append(PAY_AP_AGENT).append("' AND t7.FNumber<>'").append(PAY_AP_REFUNDMENT_AGENT).append("' ");
            sql.append("AND t7.FNumber<>'").append(204).append("' ");
            sql.append("AND t1.FBillStatus = ").append(15);
        }
        sql.append(" AND t2.fcorebillnumber is not null AND t2.FUnLockAmt <> 0 ");
        sql.append(" AND t4.FBillStatus = ").append(3);
        sql.append(" AND t4.FIsBizBill = 0");
        sql.append(" and t3.FLockUnVerifyAmt <> 0 and ");
        idWhere = mainBill ? "t4" : "t1";
        sql.append(idWhere).append(".fid in(").append(ids).append(")");
        sql.append(" ) bill  order by coreNum,coreSeq,secBizDate ,mainBizDate ");
        return sql.toString();
    }

    private CoreBaseCollection buildVeriBills(Context ctx, Connection conn, VerificationEnum veriType, FilterInfo topFilter, FilterInfo botFilter, boolean sameSide, boolean sameAmount, boolean isBillVeri, VerificateBillTypeEnum topVeriBillType, VerificateBillTypeEnum botVeriBillType, Date veriDate, HashMap signal) throws BOSException, EASBizException, SQLException {
        CoreBaseCollection veriResult = new CoreBaseCollection();
        BigDecimal veriTopTotal = null;
        BigDecimal veriBotTotal = null;
        BigDecimal lessTotalVeri = null;
        veriTopTotal = this._getTotalVeri(conn, topFilter, 0, topVeriBillType);
        if (veriTopTotal == null || veriTopTotal.compareTo(this.ZERO) == 0) {
            return veriResult;
        }
        veriBotTotal = this._getTotalVeri(conn, botFilter, 0, botVeriBillType);
        if (veriBotTotal == null || veriBotTotal.compareTo(this.ZERO) == 0) {
            return veriResult;
        }
        if (!sameSide && veriTopTotal.signum() * veriBotTotal.signum() < 0) {
            return veriResult;
        }
        lessTotalVeri = veriTopTotal.abs().compareTo(veriBotTotal.abs()) > 0 ? veriBotTotal.abs() : veriTopTotal.abs();
        VerificationBillBaseInfo veriBill = null;
        veriBill = veriType.getValue() == 101 || veriType.getValue() == 103 || veriType.getValue() == 104 || veriType.getValue() == 113 ? new VerificationBillInfo() : new com.kingdee.eas.fi.ap.VerificationBillInfo();
        veriBill.setMainBillType(topVeriBillType);
        veriBill.setSecondBillType(botVeriBillType);
        CompanyOrgUnitInfo info = new CompanyOrgUnitInfo();
        String companyid = null;
        if (signal != null && signal.containsKey("company")) {
            companyid = (String)signal.get("company");
            info.setId(BOSUuid.read((String)companyid));
            if (signal.containsKey("baseCurrency")) {
                CurrencyInfo baseCurrencyInfo = new CurrencyInfo();
                baseCurrencyInfo.setId(BOSUuid.read((String)((String)signal.get("baseCurrency"))));
                info.setBaseCurrency(baseCurrencyInfo);
            }
        }
        veriBill.setCompany(info);
        this._setBillPaymentType(veriBill, signal);
        veriBill.setBizDate(new Date());
        veriBill.setVerificationType(veriType);
        veriBill.setIsSameCode(true);
        veriBill.setIsSameCurrency(true);
        veriBill.setCreateTime(new Timestamp(new Date().getTime()));
        veriBill.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = iCodingRuleManager.getNumber((IObjectValue)veriBill, companyid);
        veriBill.setNumber(number);
        if (!sameAmount) {
            this._createVeriEntrys(ctx, conn, veriBill, topVeriBillType, topFilter, lessTotalVeri, signal);
            this._createVeriEntrys(ctx, conn, veriBill, botVeriBillType, botFilter, lessTotalVeri, signal);
        } else {
            this._createVeriEntrysOfSameAmount(ctx, conn, veriBill, isBillVeri, topVeriBillType, botVeriBillType, topFilter, botFilter, lessTotalVeri, signal);
        }
        if (veriType.getValue() == 101 || veriType.getValue() == 103 || veriType.getValue() == 104 || veriType.getValue() == 113 ? ((VerificationBillInfo)veriBill).getEntrys().size() == 0 : ((com.kingdee.eas.fi.ap.VerificationBillInfo)veriBill).getEntrys().size() == 0) {
            return veriResult;
        }
        this._setBillDate(ctx, veriBill, veriDate);
        this.checkRedBlueEntry(ctx, veriBill);
        boolean isGainLoss = false;
        String baseCurrencyID = null;
        if (signal != null && signal.containsKey("baseCurrency")) {
            baseCurrencyID = (String)signal.get("baseCurrency");
        } else {
            ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
            CurrencyInfo baseCurrency = company.getBaseCurrency();
            String string = baseCurrencyID = baseCurrency != null ? baseCurrency.getId().toString() : null;
        }
        if (!veriBill.isIsSameCurrency() || veriBill.isIsSameCurrency() && !veriBill.getMainCurrency().getId().toString().equalsIgnoreCase(baseCurrencyID)) {
            isGainLoss = true;
        }
        this._setGainLoss(veriBill, isGainLoss);
        veriResult.add((CoreBaseInfo)veriBill);
        return veriResult;
    }

    private void _setBillPaymentType(VerificationBillBaseInfo veriBill, HashMap signal) {
        if (signal != null && signal.containsKey("paymenttypeid")) {
            String PaymentType = (String)signal.get("paymenttypeid");
            if (PaymentType.equals("cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5") || PaymentType.toString().equals("40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5")) {
                veriBill.setIsCashSalePur(true);
            } else {
                veriBill.setIsCashSalePur(false);
            }
        } else {
            veriBill.setIsCashSalePur(false);
        }
    }

    private void _setBillDate(VerificationBillBaseInfo veriBill, Date veriDate) {
        IObjectCollection entry = (IObjectCollection)veriBill.get("entrys");
        Date billDate = null;
        if (veriDate == null) {
            veriDate = new Date();
        }
        for (int i = 0; i < entry.size(); ++i) {
            billDate = ((VerificationBillBaseEntryInfo)entry.getObject(i)).getBillDate();
            if (veriDate != null && !veriDate.before(billDate)) continue;
            veriDate = billDate;
        }
        veriBill.setBizDate(veriDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _createVeriEntrys(Context ctx, Connection conn, VerificationBillBaseInfo veriBill, VerificateBillTypeEnum veriEnum, FilterInfo filter, BigDecimal lessTotalVeri, HashMap signal) throws SQLException, EASBizException, BOSException {
        BigDecimal totalVeriAmt = this.ZERO;
        BigDecimal thisVeriAmt = null;
        boolean veriFinished = false;
        VerificationBillBaseEntryInfo veriEntry = null;
        PreparedStatement preStmt = null;
        ResultSet rsBot = null;
        String sql = null;
        VerificateBillTypeEnum subBillType = null;
        CurrencyInfo currency = veriBill.getCompany().getBaseCurrency();
        int locCurrPre = 2;
        if (currency != null && currency.getId() != null) {
            SelectorItemCollection selects = new SelectorItemCollection();
            selects.add(new SelectorItemInfo("precision"));
            currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId().toString()), selects);
            locCurrPre = currency.getPrecision();
        }
        IObjectCollection entrys = (IObjectCollection)veriBill.get("entrys");
        switch (veriEnum.getValue()) {
            case 8: {
                sql = this._getAutoVeriSql_AR(ctx, filter, 0);
                break;
            }
            case 6: {
                sql = this._getAutoVeriSql_Rec(ctx, filter, 0, signal);
                break;
            }
            case 9: {
                sql = this._getAutoVeriSql_AP(ctx, filter, 0);
                break;
            }
            case 4: {
                sql = this._getAutoVeriSql_Pay(ctx, filter, 0);
                break;
            }
            case 7: {
                sql = this._getAutoVeriSql_Rec(ctx, filter, 0, signal);
                break;
            }
            case 5: {
                sql = this._getAutoVeriSql_Pay(ctx, filter, 0);
                break;
            }
            default: {
                return;
            }
        }
        boolean isAR = veriBill instanceof VerificationBillInfo;
        try {
            preStmt = conn.prepareStatement(sql);
            rsBot = preStmt.executeQuery();
            while (rsBot.next()) {
                if (veriBill.getMainAcctCussType() == null) {
                    veriBill.setMainAcctCussType(Helper.getAcctCussTypeInfo_OnlyPK(rsBot.getString("acctCussType_id")));
                    veriBill.setMainAcctCussName(rsBot.getString("acctCuss_name"));
                    veriBill.setMainAcctCussID(BOSUuid.read((String)rsBot.getString("acctCuss_id")));
                    veriBill.setMainCurrency(Helper.getCurrencyInfo_OnlyPK(rsBot.getString("currency_id")));
                    veriBill.setSecondAcctCussType(Helper.getAcctCussTypeInfo_OnlyPK(rsBot.getString("acctCussType_id")));
                    veriBill.setSecondAcctCussName(rsBot.getString("acctCuss_name"));
                    veriBill.setSecondAcctCussID(BOSUuid.read((String)rsBot.getString("acctCuss_id")));
                    veriBill.setSecondCurrency(Helper.getCurrencyInfo_OnlyPK(rsBot.getString("currency_id")));
                }
                veriEntry = isAR ? new VerificationBillentryInfo() : new com.kingdee.eas.fi.ap.VerificationBillentryInfo();
                thisVeriAmt = rsBot.getBigDecimal("unverificateamt");
                if (totalVeriAmt.add(thisVeriAmt.abs()).compareTo(lessTotalVeri) > 0) {
                    if (thisVeriAmt.compareTo(this.ZERO) < 0) {
                        thisVeriAmt = totalVeriAmt.subtract(lessTotalVeri);
                        if (thisVeriAmt.compareTo(this.ZERO) == 0) {
                            veriFinished = true;
                            break;
                        }
                    } else {
                        thisVeriAmt = lessTotalVeri.subtract(totalVeriAmt);
                        if (thisVeriAmt.compareTo(this.ZERO) == 0) {
                            veriFinished = true;
                            break;
                        }
                    }
                    veriFinished = true;
                }
                totalVeriAmt = totalVeriAmt.add(thisVeriAmt.abs());
                veriEntry.setBillType(veriEnum);
                switch (veriEnum.getValue()) {
                    case 6: {
                        subBillType = Helper.getRecPayVeriBillTypeEnum(true, rsBot.getString("billsubtype"), thisVeriAmt);
                        break;
                    }
                    case 8: {
                        subBillType = Helper.changeBillType(true, rsBot.getInt("billsubtype"));
                        break;
                    }
                    case 7: {
                        subBillType = Helper.getRecPayVeriBillTypeEnum(true, rsBot.getString("billsubtype"), thisVeriAmt);
                        break;
                    }
                    case 4: {
                        subBillType = Helper.getRecPayVeriBillTypeEnum(false, rsBot.getString("billsubtype"), thisVeriAmt);
                        break;
                    }
                    case 9: {
                        subBillType = Helper.changeBillType(false, rsBot.getInt("billsubtype"));
                        break;
                    }
                    case 5: {
                        subBillType = Helper.getRecPayVeriBillTypeEnum(false, rsBot.getString("billsubtype"), thisVeriAmt);
                        break;
                    }
                    default: {
                        subBillType = null;
                    }
                }
                veriEntry.setBillSubType(subBillType);
                veriEntry.setCurrency(Helper.getCurrencyInfo_OnlyPK(rsBot.getString("currency_id")));
                veriEntry.setBillID(BOSUuid.read((String)rsBot.getString("billid")));
                logger.info((Object)("\u7ea2\u84dd\u81ea\u52a8\u7ed3\u7b97\u5355\u636eID:" + rsBot.getString("billid")));
                veriEntry.setEntryID(BOSUuid.read((String)rsBot.getString("entryid")));
                logger.info((Object)("\u7ea2\u84dd\u81ea\u52a8\u7ed3\u7b97\u5206\u5f55ID:" + rsBot.getString("entryid")));
                veriEntry.setBillNumber(rsBot.getString("b_number"));
                veriEntry.setBillDate(rsBot.getDate("billdate"));
                veriEntry.setAcctCussType(Helper.getAcctCussTypeInfo_OnlyPK(rsBot.getString("acctCussType_id")));
                veriEntry.setAcctCussID(BOSUuid.read((String)rsBot.getString("acctCuss_id")));
                veriEntry.setAcctCussName(rsBot.getString("acctCuss_name"));
                veriEntry.setComment(rsBot.getString("description"));
                veriEntry.setAccount(Helper.getAccountViewInfo_OnlyPK(rsBot.getString("accountid")));
                veriEntry.setOppAccount(Helper.getAccountViewInfo_OnlyPK(rsBot.getString("oppAccount")));
                veriEntry.setAdminOrgUnit(Helper.getAdminOrgUnitInfo_OnlyPK(rsBot.getString("FAdminOrgUnitID")));
                veriEntry.setPerson(Helper.getPersonInfo_OnlyPK(rsBot.getString("FPersonID")));
                veriEntry.setThisVerificateAmt(thisVeriAmt);
                String materialID = rsBot.getString("FMaterialID");
                String materialName = rsBot.getString("FMaterialName");
                String expenseItemID = rsBot.getString("FExpenseItemID");
                if (materialID != null) {
                    veriEntry.setMaterialId(BOSUuid.read((String)materialID));
                    veriEntry.setMaterialName(rsBot.getString("FMaterialName"));
                    veriEntry.setMaterialNumber(rsBot.getString("FMaterialNumber"));
                } else if (expenseItemID != null) {
                    veriEntry.setMaterialId(BOSUuid.read((String)expenseItemID));
                    veriEntry.setMaterialName(rsBot.getString("FExpenseItemName"));
                    veriEntry.setMaterialNumber(rsBot.getString("FExpenseItemNumber"));
                } else if (materialID == null && materialName != null) {
                    veriEntry.setMaterialName(materialName);
                }
                if (veriEnum.getValue() != 8 && veriEnum.getValue() != 9 && rsBot.getString("FVeriRecPayTypeId") != null) {
                    veriEntry.setVeriRecPayTypeId(BOSUuid.read((String)rsBot.getString("FVeriRecPayTypeId")));
                    veriEntry.setVeriRecPayTypeNumber(rsBot.getString("FVeriRecPayTypeNumber"));
                    veriEntry.setVeriRecPayTypeName(rsBot.getString("FVeriRecPayTypeName"));
                }
                if (veriFinished) {
                    BigDecimal exchangeRate = rsBot.getBigDecimal("exchangerate");
                    veriEntry.setThisVerificateAmtLoc(thisVeriAmt.multiply(exchangeRate).setScale(locCurrPre, 4));
                    logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"91_ArVerificationFacadeControllerBean", (Locale)ctx.getLocale()) + thisVeriAmt.multiply(exchangeRate).setScale(locCurrPre, 4)));
                    entrys.addObject((IObjectValue)veriEntry);
                    break;
                }
                veriEntry.setThisVerificateAmtLoc(rsBot.getBigDecimal("unverificateamtloc").setScale(locCurrPre, 4));
                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"91_ArVerificationFacadeControllerBean", (Locale)ctx.getLocale()) + rsBot.getBigDecimal("unverificateamtloc")));
                entrys.addObject((IObjectValue)veriEntry);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rsBot, (Statement)preStmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rsBot, (Statement)preStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _createVeriEntrysOfSameAmount(Context ctx, Connection conn, VerificationBillBaseInfo veriBill, boolean isBillVeri, VerificateBillTypeEnum topVeriEnum, VerificateBillTypeEnum botVeriEnum, FilterInfo topFilter, FilterInfo botFilter, BigDecimal lessTotalVeri, HashMap signal) throws SQLException, EASBizException, BOSException {
        ResultSet rsBot;
        ResultSet rsTop;
        PreparedStatement botPreStmt;
        PreparedStatement topPreStmt;
        block48: {
            HashMap<String, TempVerificationInfo> botBillMap;
            HashMap<String, TempVerificationInfo> topBillMap;
            ArrayList<TempVerificationEntryInfo> botList;
            ArrayList<TempVerificationEntryInfo> topList;
            int locCurrPre;
            boolean veriFinished;
            BigDecimal thisVeriAmt;
            BigDecimal totalVeriAmt;
            block47: {
                TempVerificationEntryInfo tempEntryInfo;
                TempVerificationInfo tempInfo;
                totalVeriAmt = this.ZERO;
                thisVeriAmt = null;
                veriFinished = false;
                topPreStmt = null;
                botPreStmt = null;
                PreparedStatement topUnVeriAmtPreStmt = null;
                PreparedStatement botUnVeriAmtPreStmt = null;
                rsTop = null;
                rsBot = null;
                ResultSet rsTopUnVeriAmt = null;
                ResultSet rsBotUnVeriAmt = null;
                String topSql = null;
                String botSql = null;
                String topUnverifyAmtSQL = null;
                String botUnverifyAmtSQL = null;
                CurrencyInfo currency = veriBill.getCompany().getBaseCurrency();
                locCurrPre = 2;
                if (currency != null && currency.getId() != null) {
                    SelectorItemCollection selects = new SelectorItemCollection();
                    selects.add(new SelectorItemInfo("precision"));
                    currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId().toString()), selects);
                    locCurrPre = currency.getPrecision();
                }
                switch (topVeriEnum.getValue()) {
                    case 8: {
                        if (isBillVeri) {
                            topUnverifyAmtSQL = this._getTopUnverifyAmtSQL_AR(ctx, topFilter, 0);
                        }
                        topSql = this._getAutoVeriSql_AR(ctx, topFilter, 0);
                        break;
                    }
                    case 9: {
                        if (isBillVeri) {
                            topUnverifyAmtSQL = this._getTopUnverifyAmtSQL_AP(ctx, topFilter, 0);
                        }
                        topSql = this._getAutoVeriSql_AP(ctx, topFilter, 0);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                switch (botVeriEnum.getValue()) {
                    case 6: {
                        if (isBillVeri) {
                            botUnverifyAmtSQL = this._getBotUnverifyAmtSQL_Rec(ctx, botFilter, 0);
                        }
                        botSql = this._getAutoVeriSql_Rec(ctx, botFilter, 0, signal);
                        break;
                    }
                    case 4: {
                        if (isBillVeri) {
                            botUnverifyAmtSQL = this._getBotUnverifyAmtSQL_Pay(ctx, botFilter, 0);
                        }
                        botSql = this._getAutoVeriSql_Pay(ctx, botFilter, 0);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                topPreStmt = conn.prepareStatement(topSql);
                botPreStmt = conn.prepareStatement(botSql);
                rsTop = topPreStmt.executeQuery();
                rsBot = botPreStmt.executeQuery();
                topList = new ArrayList<TempVerificationEntryInfo>();
                botList = new ArrayList<TempVerificationEntryInfo>();
                HashMap<String, BigDecimal> topUnVeriAmt_billID = new HashMap<String, BigDecimal>();
                HashMap<String, BigDecimal> botUnVeriAmt_billID = new HashMap<String, BigDecimal>();
                if (isBillVeri) {
                    BigDecimal allUnverificateamt;
                    String billID;
                    topUnVeriAmtPreStmt = conn.prepareStatement(topUnverifyAmtSQL);
                    botUnVeriAmtPreStmt = conn.prepareStatement(botUnverifyAmtSQL);
                    rsTopUnVeriAmt = topUnVeriAmtPreStmt.executeQuery();
                    rsBotUnVeriAmt = botUnVeriAmtPreStmt.executeQuery();
                    while (rsTopUnVeriAmt.next()) {
                        billID = rsTopUnVeriAmt.getString("billid");
                        allUnverificateamt = rsTopUnVeriAmt.getBigDecimal("allUnverificateamt");
                        if (topUnVeriAmt_billID.containsKey(billID)) continue;
                        topUnVeriAmt_billID.put(billID, allUnverificateamt);
                    }
                    while (rsBotUnVeriAmt.next()) {
                        billID = rsBotUnVeriAmt.getString("billid");
                        allUnverificateamt = rsBotUnVeriAmt.getBigDecimal("allUnverificateamt");
                        if (botUnVeriAmt_billID.containsKey(billID)) continue;
                        botUnVeriAmt_billID.put(billID, allUnverificateamt);
                    }
                }
                topBillMap = new HashMap<String, TempVerificationInfo>();
                botBillMap = new HashMap<String, TempVerificationInfo>();
                while (rsTop.next()) {
                    thisVeriAmt = isBillVeri ? (BigDecimal)topUnVeriAmt_billID.get(rsTop.getString("billid")) : rsTop.getBigDecimal("unverificateamt");
                    if (isBillVeri && !topUnVeriAmt_billID.containsKey(rsTop.getString("billid"))) continue;
                    if (thisVeriAmt.abs().compareTo(lessTotalVeri) > 0) {
                        if (!isBillVeri) continue;
                        topUnVeriAmt_billID.remove(rsTop.getString("billid"));
                        continue;
                    }
                    tempInfo = null;
                    if (isBillVeri) {
                        if (!topBillMap.containsKey(rsTop.getString("billid"))) {
                            tempInfo = new TempVerificationInfo();
                            tempInfo.setBillid(rsTop.getString("billid"));
                            tempInfo.setAllUnverificateamt((BigDecimal)topUnVeriAmt_billID.get(rsTop.getString("billid")));
                            topBillMap.put(rsTop.getString("billid"), tempInfo);
                        } else {
                            tempInfo = (TempVerificationInfo)topBillMap.get(rsTop.getString("billid"));
                        }
                    }
                    tempEntryInfo = new TempVerificationEntryInfo();
                    tempEntryInfo.setAcctCussType_id(rsTop.getString("acctCussType_id"));
                    tempEntryInfo.setAcctCuss_name(rsTop.getString("acctCuss_name"));
                    tempEntryInfo.setAcctCuss_id(rsTop.getString("acctCuss_id"));
                    tempEntryInfo.setCurrency_id(rsTop.getString("currency_id"));
                    tempEntryInfo.setUnverificateamt(rsTop.getBigDecimal("unverificateamt"));
                    tempEntryInfo.setBillsubtype(rsTop.getString("billsubtype"));
                    tempEntryInfo.setBillid(rsTop.getString("billid"));
                    tempEntryInfo.setEntryid(rsTop.getString("entryid"));
                    tempEntryInfo.setB_number(rsTop.getString("b_number"));
                    tempEntryInfo.setBilldate(rsTop.getDate("billdate"));
                    tempEntryInfo.setDescription(rsTop.getString("description"));
                    tempEntryInfo.setAccountid(rsTop.getString("accountid"));
                    tempEntryInfo.setOppAccount(rsTop.getString("oppAccount"));
                    tempEntryInfo.setFAdminOrgUnitID(rsTop.getString("FAdminOrgUnitID"));
                    tempEntryInfo.setFPersonID(rsTop.getString("FPersonID"));
                    tempEntryInfo.setFMaterialID(rsTop.getString("FMaterialID"));
                    tempEntryInfo.setFMaterialName(rsTop.getString("FMaterialName"));
                    tempEntryInfo.setFExpenseItemID(rsTop.getString("FExpenseItemID"));
                    tempEntryInfo.setFMaterialNumber(rsTop.getString("FMaterialNumber"));
                    tempEntryInfo.setFExpenseItemName(rsTop.getString("FExpenseItemName"));
                    tempEntryInfo.setFExpenseItemNumber(rsTop.getString("FExpenseItemNumber"));
                    tempEntryInfo.setExchangerate(rsTop.getBigDecimal("exchangerate"));
                    tempEntryInfo.setUnverificateamtloc(rsTop.getBigDecimal("unverificateamtloc"));
                    if (isBillVeri) {
                        tempInfo.getEntryInfoList().add(tempEntryInfo);
                        topBillMap.put(rsTop.getString("billid"), tempInfo);
                    }
                    topList.add(tempEntryInfo);
                }
                while (rsBot.next()) {
                    thisVeriAmt = isBillVeri ? (BigDecimal)botUnVeriAmt_billID.get(rsBot.getString("billid")) : rsBot.getBigDecimal("unverificateamt");
                    if (isBillVeri && botUnVeriAmt_billID.get(rsBot.getString("billid")) == null) continue;
                    if (thisVeriAmt.abs().compareTo(lessTotalVeri) > 0) {
                        if (!isBillVeri) continue;
                        botUnVeriAmt_billID.remove(rsBot.getString("billid"));
                        continue;
                    }
                    tempInfo = null;
                    if (isBillVeri) {
                        if (!botBillMap.containsKey(rsBot.getString("billid"))) {
                            tempInfo = new TempVerificationInfo();
                            tempInfo.setBillid(rsBot.getString("billid"));
                            tempInfo.setAllUnverificateamt((BigDecimal)botUnVeriAmt_billID.get(rsBot.getString("billid")));
                            botBillMap.put(rsBot.getString("billid"), tempInfo);
                        } else {
                            tempInfo = (TempVerificationInfo)botBillMap.get(rsBot.getString("billid"));
                        }
                    }
                    tempEntryInfo = new TempVerificationEntryInfo();
                    tempEntryInfo.setAcctCussType_id(rsBot.getString("acctCussType_id"));
                    tempEntryInfo.setAcctCuss_name(rsBot.getString("acctCuss_name"));
                    tempEntryInfo.setAcctCuss_id(rsBot.getString("acctCuss_id"));
                    tempEntryInfo.setCurrency_id(rsBot.getString("currency_id"));
                    tempEntryInfo.setUnverificateamt(rsBot.getBigDecimal("unverificateamt"));
                    tempEntryInfo.setBillsubtype(rsBot.getString("billsubtype"));
                    tempEntryInfo.setBillid(rsBot.getString("billid"));
                    tempEntryInfo.setEntryid(rsBot.getString("entryid"));
                    tempEntryInfo.setB_number(rsBot.getString("b_number"));
                    tempEntryInfo.setBilldate(rsBot.getDate("billdate"));
                    tempEntryInfo.setDescription(rsBot.getString("description"));
                    tempEntryInfo.setAccountid(rsBot.getString("accountid"));
                    tempEntryInfo.setOppAccount(rsBot.getString("oppAccount"));
                    tempEntryInfo.setFAdminOrgUnitID(rsBot.getString("FAdminOrgUnitID"));
                    tempEntryInfo.setFPersonID(rsBot.getString("FPersonID"));
                    tempEntryInfo.setFMaterialID(rsBot.getString("FMaterialID"));
                    tempEntryInfo.setFMaterialName(rsBot.getString("FMaterialName"));
                    tempEntryInfo.setFExpenseItemID(rsBot.getString("FExpenseItemID"));
                    tempEntryInfo.setFMaterialNumber(rsBot.getString("FMaterialNumber"));
                    tempEntryInfo.setFExpenseItemName(rsBot.getString("FExpenseItemName"));
                    tempEntryInfo.setFExpenseItemNumber(rsBot.getString("FExpenseItemNumber"));
                    tempEntryInfo.setFVeriRecPayTypeId(rsBot.getString("FVeriRecPayTypeId"));
                    tempEntryInfo.setFVeriRecPayTypeNumber(rsBot.getString("FVeriRecPayTypeNumber"));
                    tempEntryInfo.setFVeriRecPayTypeName(rsBot.getString("FVeriRecPayTypeName"));
                    tempEntryInfo.setExchangerate(rsBot.getBigDecimal("exchangerate"));
                    tempEntryInfo.setUnverificateamtloc(rsBot.getBigDecimal("unverificateamtloc"));
                    if (isBillVeri && tempInfo != null) {
                        tempInfo.getEntryInfoList().add(tempEntryInfo);
                        botBillMap.put(rsBot.getString("billid"), tempInfo);
                    }
                    botList.add(tempEntryInfo);
                }
                thisVeriAmt = null;
                int topSize = topList.size();
                int botSize = botList.size();
                if (topSize != 0 && botSize != 0) break block47;
                SQLUtils.cleanup((ResultSet)rsTop, (Statement)topPreStmt);
                SQLUtils.cleanup((ResultSet)rsBot, (Statement)botPreStmt);
                return;
            }
            try {
                if (!isBillVeri) {
                    Iterator itTop = topList.iterator();
                    block15: while (itTop.hasNext() && !veriFinished) {
                        TempVerificationEntryInfo tempTopInfo = (TempVerificationEntryInfo)itTop.next();
                        BigDecimal topUnverificateamt = tempTopInfo.getUnverificateamt();
                        Iterator itBot = botList.iterator();
                        while (itBot.hasNext()) {
                            TempVerificationEntryInfo tempBotInfo = (TempVerificationEntryInfo)itBot.next();
                            BigDecimal botUnverificateamt = tempBotInfo.getUnverificateamt();
                            if (topUnverificateamt.compareTo(botUnverificateamt) != 0) continue;
                            if (totalVeriAmt.add(topUnverificateamt.abs()).compareTo(lessTotalVeri) > 0) {
                                thisVeriAmt = thisVeriAmt != null && thisVeriAmt.compareTo(this.ZERO) < 0 ? totalVeriAmt.subtract(lessTotalVeri) : lessTotalVeri.subtract(totalVeriAmt);
                                veriFinished = true;
                            } else {
                                thisVeriAmt = topUnverificateamt;
                            }
                            totalVeriAmt = totalVeriAmt.add(thisVeriAmt.abs());
                            this.createVerificationBillEntry(ctx, veriBill, tempTopInfo, thisVeriAmt, topVeriEnum, veriFinished, locCurrPre);
                            this.createVerificationBillEntry(ctx, veriBill, tempBotInfo, thisVeriAmt, botVeriEnum, veriFinished, locCurrPre);
                            itBot.remove();
                            itTop.remove();
                            continue block15;
                        }
                    }
                    break block48;
                }
                Iterator iterTop = topBillMap.entrySet().iterator();
                block17: while (iterTop.hasNext() && !veriFinished) {
                    TempVerificationInfo tempTopInfo = (TempVerificationInfo)iterTop.next().getValue();
                    BigDecimal topAllUnverificateamt = tempTopInfo.getAllUnverificateamt();
                    Iterator iterBot = botBillMap.entrySet().iterator();
                    while (iterBot.hasNext()) {
                        TempVerificationInfo tempBotInfo = (TempVerificationInfo)iterBot.next().getValue();
                        BigDecimal botAllUnverificateamt = tempBotInfo.getAllUnverificateamt();
                        if (topAllUnverificateamt.compareTo(botAllUnverificateamt) != 0) continue;
                        if (totalVeriAmt.add(topAllUnverificateamt.abs()).compareTo(lessTotalVeri) > 0) {
                            thisVeriAmt = thisVeriAmt.compareTo(this.ZERO) < 0 ? totalVeriAmt.subtract(lessTotalVeri) : lessTotalVeri.subtract(totalVeriAmt);
                            veriFinished = true;
                            BigDecimal tempTopTotalVeriAmt = this.ZERO;
                            BigDecimal tempBotTotalVeriAmt = this.ZERO;
                            boolean isVeriFinished_top = false;
                            boolean isVeriFinished_bot = false;
                            Iterator iterTopEntry = tempTopInfo.getEntryInfoList().iterator();
                            while (iterTopEntry.hasNext() && !isVeriFinished_top) {
                                TempVerificationEntryInfo topInfo = (TempVerificationEntryInfo)iterTopEntry.next();
                                BigDecimal topVeriAmt = topInfo.getUnverificateamt();
                                if (tempTopTotalVeriAmt.add(topVeriAmt.abs()).compareTo(thisVeriAmt.abs()) > 0) {
                                    topVeriAmt = topVeriAmt.compareTo(this.ZERO) < 0 ? tempTopTotalVeriAmt.subtract(thisVeriAmt.abs()) : thisVeriAmt.abs().subtract(tempTopTotalVeriAmt);
                                    isVeriFinished_top = true;
                                }
                                tempTopTotalVeriAmt = tempTopTotalVeriAmt.add(topVeriAmt.abs());
                                this.createVerificationBillEntry(ctx, veriBill, topInfo, topVeriAmt, topVeriEnum, isVeriFinished_top, locCurrPre);
                                iterTopEntry.remove();
                            }
                            Iterator iterBotEntry = tempBotInfo.getEntryInfoList().iterator();
                            while (iterBotEntry.hasNext() && !isVeriFinished_bot) {
                                TempVerificationEntryInfo botInfo = (TempVerificationEntryInfo)iterBotEntry.next();
                                BigDecimal botVeriAmt = botInfo.getUnverificateamt();
                                if (tempBotTotalVeriAmt.add(botVeriAmt.abs()).compareTo(thisVeriAmt.abs()) > 0) {
                                    botVeriAmt = botVeriAmt.compareTo(this.ZERO) < 0 ? tempBotTotalVeriAmt.subtract(thisVeriAmt.abs()) : thisVeriAmt.abs().subtract(tempBotTotalVeriAmt);
                                    isVeriFinished_bot = true;
                                }
                                tempBotTotalVeriAmt = tempBotTotalVeriAmt.add(botVeriAmt.abs());
                                this.createVerificationBillEntry(ctx, veriBill, botInfo, botVeriAmt, botVeriEnum, isVeriFinished_bot, locCurrPre);
                                iterBotEntry.remove();
                            }
                        } else {
                            thisVeriAmt = topAllUnverificateamt;
                            Iterator iterTopEntry = tempTopInfo.getEntryInfoList().iterator();
                            while (iterTopEntry.hasNext()) {
                                TempVerificationEntryInfo topInfo = (TempVerificationEntryInfo)iterTopEntry.next();
                                this.createVerificationBillEntry(ctx, veriBill, topInfo, topInfo.getUnverificateamt(), topVeriEnum, veriFinished, locCurrPre);
                                iterTopEntry.remove();
                            }
                            Iterator iterBotEntry = tempBotInfo.getEntryInfoList().iterator();
                            while (iterBotEntry.hasNext()) {
                                TempVerificationEntryInfo botInfo = (TempVerificationEntryInfo)iterBotEntry.next();
                                this.createVerificationBillEntry(ctx, veriBill, botInfo, botInfo.getUnverificateamt(), botVeriEnum, veriFinished, locCurrPre);
                                iterBotEntry.remove();
                            }
                        }
                        if ((totalVeriAmt = totalVeriAmt.add(thisVeriAmt.abs())).compareTo(lessTotalVeri) == 0) {
                            veriFinished = true;
                        }
                        if (veriFinished) continue block17;
                        iterBot.remove();
                        continue block17;
                    }
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rsTop, (Statement)topPreStmt);
                SQLUtils.cleanup(rsBot, (Statement)botPreStmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rsTop, (Statement)topPreStmt);
        SQLUtils.cleanup((ResultSet)rsBot, (Statement)botPreStmt);
    }

    private void createVerificationBillEntry(Context ctx, VerificationBillBaseInfo veriBill, TempVerificationEntryInfo tempInfo, BigDecimal thisVeriAmt, VerificateBillTypeEnum veriEnum, boolean veriFinished, int locCurrPre) {
        VerificationBillBaseEntryInfo veriEntry = null;
        VerificateBillTypeEnum subBillType = null;
        IObjectCollection entrys = (IObjectCollection)veriBill.get("entrys");
        if (veriBill.getMainAcctCussType() == null) {
            veriBill.setMainAcctCussType(Helper.getAcctCussTypeInfo_OnlyPK(tempInfo.getAcctCussType_id()));
            veriBill.setMainAcctCussName(tempInfo.getAcctCuss_name());
            veriBill.setMainAcctCussID(BOSUuid.read((String)tempInfo.getAcctCuss_id()));
            veriBill.setMainCurrency(Helper.getCurrencyInfo_OnlyPK(tempInfo.getCurrency_id()));
            veriBill.setSecondAcctCussType(Helper.getAcctCussTypeInfo_OnlyPK(tempInfo.getAcctCussType_id()));
            veriBill.setSecondAcctCussName(tempInfo.getAcctCuss_name());
            veriBill.setSecondAcctCussID(BOSUuid.read((String)tempInfo.getAcctCuss_id()));
            veriBill.setSecondCurrency(Helper.getCurrencyInfo_OnlyPK(tempInfo.getCurrency_id()));
        }
        boolean isAR = veriBill instanceof VerificationBillInfo;
        veriEntry = isAR ? new VerificationBillentryInfo() : new com.kingdee.eas.fi.ap.VerificationBillentryInfo();
        veriEntry.setBillType(veriEnum);
        switch (veriEnum.getValue()) {
            case 6: {
                subBillType = Helper.getRecPayVeriBillTypeEnum(true, tempInfo.getBillsubtype(), thisVeriAmt);
                break;
            }
            case 8: {
                if (tempInfo.getBillsubtype() == null) break;
                subBillType = Helper.changeBillType(true, Integer.parseInt(tempInfo.getBillsubtype()));
                break;
            }
            case 4: {
                subBillType = Helper.getRecPayVeriBillTypeEnum(false, tempInfo.getBillsubtype(), thisVeriAmt);
                break;
            }
            case 9: {
                if (tempInfo.getBillsubtype() == null) break;
                subBillType = Helper.changeBillType(false, Integer.parseInt(tempInfo.getBillsubtype()));
                break;
            }
            default: {
                subBillType = null;
            }
        }
        veriEntry.setBillSubType(subBillType);
        veriEntry.setCurrency(Helper.getCurrencyInfo_OnlyPK(tempInfo.getCurrency_id()));
        veriEntry.setBillID(BOSUuid.read((String)tempInfo.getBillid()));
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"89_ArVerificationFacadeControllerBean", (Locale)ctx.getLocale()) + tempInfo.getBillid()));
        veriEntry.setEntryID(BOSUuid.read((String)tempInfo.getEntryid()));
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"90_ArVerificationFacadeControllerBean", (Locale)ctx.getLocale()) + tempInfo.getEntryid()));
        veriEntry.setBillNumber(tempInfo.getB_number());
        veriEntry.setBillDate(tempInfo.getBilldate());
        veriEntry.setAcctCussType(Helper.getAcctCussTypeInfo_OnlyPK(tempInfo.getAcctCussType_id()));
        veriEntry.setAcctCussID(BOSUuid.read((String)tempInfo.getAcctCuss_id()));
        veriEntry.setAcctCussName(tempInfo.getAcctCuss_name());
        veriEntry.setComment(tempInfo.getDescription());
        veriEntry.setAccount(Helper.getAccountViewInfo_OnlyPK(tempInfo.getAccountid()));
        veriEntry.setOppAccount(Helper.getAccountViewInfo_OnlyPK(tempInfo.getOppAccount()));
        veriEntry.setAdminOrgUnit(Helper.getAdminOrgUnitInfo_OnlyPK(tempInfo.getFAdminOrgUnitID()));
        veriEntry.setPerson(Helper.getPersonInfo_OnlyPK(tempInfo.getFPersonID()));
        veriEntry.setThisVerificateAmt(thisVeriAmt);
        String materialID = tempInfo.getFMaterialID();
        String materialName = tempInfo.getFMaterialName();
        String expenseItemID = tempInfo.getFExpenseItemID();
        if (materialID != null) {
            veriEntry.setMaterialId(BOSUuid.read((String)materialID));
            veriEntry.setMaterialName(materialName);
            veriEntry.setMaterialNumber(tempInfo.getFMaterialNumber());
        } else if (expenseItemID != null) {
            veriEntry.setMaterialId(BOSUuid.read((String)expenseItemID));
            veriEntry.setMaterialName(tempInfo.getFExpenseItemName());
            veriEntry.setMaterialNumber(tempInfo.getFExpenseItemNumber());
        } else if (materialID == null && materialName != null) {
            veriEntry.setMaterialName(materialName);
        }
        if (veriEnum.getValue() != 8 && veriEnum.getValue() != 9 && tempInfo.getFVeriRecPayTypeId() != null) {
            veriEntry.setVeriRecPayTypeId(BOSUuid.read((String)tempInfo.getFVeriRecPayTypeId()));
            veriEntry.setVeriRecPayTypeNumber(tempInfo.getFVeriRecPayTypeNumber());
            veriEntry.setVeriRecPayTypeName(tempInfo.getFVeriRecPayTypeName());
        }
        if (veriFinished) {
            BigDecimal exchangeRate = tempInfo.getExchangerate();
            veriEntry.setThisVerificateAmtLoc(thisVeriAmt.multiply(exchangeRate).setScale(locCurrPre, 4));
            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"91_ArVerificationFacadeControllerBean", (Locale)ctx.getLocale()) + thisVeriAmt.multiply(exchangeRate).setScale(locCurrPre, 4)));
            entrys.addObject((IObjectValue)veriEntry);
            return;
        }
        veriEntry.setThisVerificateAmtLoc(tempInfo.getUnverificateamtloc().setScale(locCurrPre, 4));
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"91_ArVerificationFacadeControllerBean", (Locale)ctx.getLocale()) + tempInfo.getUnverificateamtloc()));
        entrys.addObject((IObjectValue)veriEntry);
    }

    private String _getAutoVeriSql_Rec(Context ctx, FilterInfo filter, int topCount, HashMap signal) {
        StringBuffer sb = new StringBuffer();
        sb.append("select ");
        if (topCount != 0) {
            sb.append(" top ");
            sb.append(topCount);
        }
        sb.append("t1.fid as billid,");
        sb.append("t1.FCompanyID,");
        sb.append("case when t7.fispreset = 0 then t11.fnumber else t7.fnumber end as billsubtype, t1.fnumber as b_number,");
        sb.append("t1.fbizdate as billdate,");
        sb.append("t1.FPayerTypeID as acctCussType_id,");
        sb.append("t1.fpayerid as acctCuss_id,t1.fpayername as acctCuss_name,");
        sb.append("t1.fpayernumber as acctCuss_number,");
        sb.append("t1.FCurrencyID as currency_id, t4.FPrecision as FPrecision, ");
        sb.append("t2.fid as entryid,");
        sb.append("FPayeeAccountID as accountid,");
        sb.append("t1.FOppAccountID as oppAccount,t1.fexchangerate as exchangerate,");
        sb.append("t2.FAmount as billamt,t2.FLocalAmount as billamtloc,");
        sb.append("t2.FActualAmt as actualAmt,t2.FActualLocAmt as actualAmtLoc,");
        sb.append("t2.FRebate as rebateAmt,t2.FRebateLocAmt as rebateAmtLoc,");
        sb.append("t2.FLockAmt as verificateamt,t2.FLockLocAmt as verificateamtloc,");
        sb.append("t2.FUnLockAmt as unverificateamt,t2.FUnLockLocAmt as unverificateamtloc,");
        sb.append("t1.FDescription as description ,t1.FAdminOrgUnitID as FAdminOrgUnitID, t1.FPersonID as FPersonID ,");
        sb.append("t2.FCoreBillNumber as coreBillNumber , t2.FCoreBillEntrySeq as coreBillEntrySeq ");
        sb.append(",t2.FContractNumber as contractNum, t2.FContractEntrySeq as contractEntrySeq");
        sb.append(",null as FMaterialID ");
        sb.append(",null as FMaterialNumber ");
        sb.append(",null as FMaterialName ");
        sb.append(",null as FExpenseItemID ");
        sb.append(",null as FExpenseItemNumber ");
        sb.append(",null as FExpenseItemName ");
        sb.append(", t7.FID as FVeriRecPayTypeId ");
        sb.append(", t7.FNumber as FVeriRecPayTypeNumber ");
        sb.append(", t7.FName_").append(ctx.getLocale().getLanguage()).append(" as FVeriRecPayTypeName ");
        sb.append("from T_CAS_ReceivingBill as t1 ");
        sb.append("inner join T_CAS_ReceivingBillEntry as t2 on t1.fid = t2.FReceivingBillID ");
        sb.append("left join T_ORG_Company AS t3 on t1.FCompanyID = t3.FID ");
        sb.append("left join T_BD_Currency as t4 on t1.FCurrencyID = t4.FID ");
        sb.append("left join T_BD_AsstActType as t5 on t1.FPayerTypeID = t5.FID ");
        sb.append("left join T_BD_AccountView t6 on t1.FPayeeAccountID = t6.FID ");
        sb.append("left join t_cas_receivingbilltype as t7 on t2.FRecBillTypeID = t7.FID ");
        sb.append("left join T_ORG_Admin t8 on t1.FAdminOrgUnitID = t8.fid ");
        sb.append("left join T_BD_Person t10 on t1.FPersonID = t10.fid ");
        sb.append("left join T_BD_VoucherTypes t12 on t1.FVoucherTypeID = t12.fid ");
        sb.append("left join T_GL_Voucher t13 on t1.FVoucherID = t13.fid ");
        sb.append("left join t_cas_receivingbilltype as t11 on t7.FPreSetBillTypeID = t11.FID ");
        if (filter != null) {
            sb.append(" where ");
            sb.append(filter.toString());
        }
        sb.append(" order by billdate ASC, t1.Fnumber ASC, t2.fseq ASC");
        return sb.toString();
    }

    private String _getBotUnverifyAmtSQL_Rec(Context ctx, FilterInfo filter, int topCount) {
        StringBuffer sb = new StringBuffer();
        sb.append("select ");
        if (topCount != 0) {
            sb.append(" top ");
            sb.append(topCount);
        }
        sb.append("t1.fid as billid,sum(t2.FUnLockAmt) as allUnverificateamt ");
        sb.append("from T_CAS_ReceivingBill as t1 ");
        sb.append("inner join T_CAS_ReceivingBillEntry as t2 on t1.fid = t2.FReceivingBillID ");
        sb.append("left join t_cas_receivingbilltype as t7 on t2.FRecBillTypeID = t7.FID ");
        sb.append("left join T_ORG_Company AS t3 on t1.FCompanyID = t3.FID ");
        sb.append("left join T_BD_Currency as t4 on t1.FCurrencyID = t4.FID ");
        sb.append("left join T_BD_AsstActType as t5 on t1.FPayerTypeID = t5.FID ");
        sb.append("left join T_BD_AccountView t6 on t1.FPayeeAccountID = t6.FID ");
        sb.append("left join T_ORG_Admin t8 on t1.FAdminOrgUnitID = t8.fid ");
        sb.append("left join T_BD_Person t10 on t1.FPersonID = t10.fid ");
        sb.append("left join T_BD_VoucherTypes t12 on t1.FVoucherTypeID = t12.fid ");
        sb.append("left join T_GL_Voucher t13 on t1.FVoucherID = t13.fid ");
        sb.append("left join t_cas_receivingbilltype as t11 on t7.FPreSetBillTypeID = t11.FID ");
        if (filter != null) {
            sb.append(" where ");
            sb.append(filter.toString());
        }
        sb.append(" group by t1.fid");
        return sb.toString();
    }

    private String _getAutoVeriSql_Pay(Context ctx, FilterInfo filter, int topCount) {
        StringBuffer sb = new StringBuffer();
        sb.append("select ");
        if (topCount != 0) {
            sb.append(" top ");
            sb.append(topCount);
        }
        sb.append(" t1.fid as billid,");
        sb.append("t1.FCompanyID as company_id,");
        sb.append("4 as billtype, case when t7.fispreset = 0 then t11.fnumber else t7.fnumber end as billsubtype, t1.fnumber as b_number,t1.FBizDate as billdate,");
        sb.append("t1.FPayeeTypeID as acctCussType_id,");
        sb.append("t1.fpayeeid as acctCuss_id,t1.fpayeename as acctCuss_name,t1.fpayeenumber as acctCuss_number,");
        sb.append("t1.fcurrencyid as currency_id,t4.FPrecision as FPrecision,");
        sb.append("t2.fid as entryid,");
        sb.append("t1.FPayerAccountID as accountid,");
        sb.append("t1.FOppAccountID as oppAccount,t1.FLastExhangeRate as exchangerate,");
        sb.append("t2.FAmount as billamt,t2.FLocalAmount as billamtloc,");
        sb.append("t2.FActualAmt as actualAmt,t2.FActualLocAmt as actualAmtLoc,");
        sb.append("t2.FRebate as rebateAmt,t2.FRebateLocAmt as rebateAmtLoc,");
        sb.append("t2.FLockAmt as verificateamt,t2.FLockLocAmt as verificateamtloc,");
        sb.append("t2.FUnLockAmt as unverificateamt,t2.FUnLockLocAmt as unverificateamtloc,");
        sb.append("t1.FDescription as description ,t1.FAdminOrgUnitID as FAdminOrgUnitID, t1.FPersonID as FPersonID ,");
        sb.append("t2.FCoreBillNumber as coreBillNumber , t2.FCoreBillEntrySeq as coreBillEntrySeq ");
        sb.append(", t2.FContractNumber as contractNum, t2.FContractEntrySeq as contractEntrySeq ");
        sb.append(",null as FMaterialID ");
        sb.append(",null as FMaterialNumber ");
        sb.append(",null as FMaterialName ");
        sb.append(",null as FExpenseItemID ");
        sb.append(",null as FExpenseItemNumber ");
        sb.append(",null as FExpenseItemName ");
        sb.append(", t7.FID as FVeriRecPayTypeId ");
        sb.append(", t7.FNumber as FVeriRecPayTypeNumber ");
        sb.append(", t7.FName_").append(ctx.getLocale().getLanguage()).append(" as FVeriRecPayTypeName ");
        sb.append("from T_CAS_PaymentBill as t1 ");
        sb.append("inner join T_CAS_PaymentBillEntry as t2 on t1.fid = t2.FPaymentBillID ");
        sb.append("left join T_ORG_Company AS t3 on t1.FCompanyID = t3.FID ");
        sb.append("left join T_BD_Currency as t4 on t1.FCurrencyID = t4.FID ");
        sb.append("left join T_BD_AsstActType as t5 on t1.FPayeeTypeID = t5.FID ");
        sb.append("left join T_BD_AccountView t6 on t1.FPayerAccountID = t6.FID ");
        sb.append("left join t_cas_paymentbilltype as t7 on t1.FPayBillTypeID = t7.FID ");
        sb.append("left join T_ORG_Admin t8 on t1.FAdminOrgUnitID = t8.fid ");
        sb.append("left join T_BD_Person t10 on t1.FPersonID = t10.fid ");
        sb.append("left join T_BD_VoucherTypes t12 on t1.FVoucherTypeID = t12.fid ");
        sb.append("left join T_GL_Voucher t13 on t1.FVoucherID = t13.fid ");
        sb.append("left join t_cas_paymentbilltype as t11 on t7.FPreSetBillTypeID = t11.FID ");
        if (filter != null) {
            sb.append(" where ");
            sb.append(filter.toString());
        }
        sb.append(" order by billdate ASC, t1.Fnumber ASC, t2.fseq ASC");
        return sb.toString();
    }

    private String _getBotUnverifyAmtSQL_Pay(Context ctx, FilterInfo filter, int topCount) {
        StringBuffer sb = new StringBuffer();
        sb.append("select ");
        if (topCount != 0) {
            sb.append(" top ");
            sb.append(topCount);
        }
        sb.append(" t1.fid as billid,sum(t2.FUnLockAmt) as allUnverificateamt ");
        sb.append("from T_CAS_PaymentBill as t1 ");
        sb.append("inner join T_CAS_PaymentBillEntry as t2 on t1.fid = t2.FPaymentBillID ");
        sb.append("left join t_cas_paymentbilltype as t7 on t1.FPayBillTypeID = t7.FID ");
        sb.append("left join T_ORG_Company AS t3 on t1.FCompanyID = t3.FID ");
        sb.append("left join T_BD_Currency as t4 on t1.FCurrencyID = t4.FID ");
        sb.append("left join T_BD_AsstActType as t5 on t1.FPayeeTypeID = t5.FID ");
        sb.append("left join T_BD_AccountView t6 on t1.FPayerAccountID = t6.FID ");
        sb.append("left join T_ORG_Admin t8 on t1.FAdminOrgUnitID = t8.fid ");
        sb.append("left join T_BD_Person t10 on t1.FPersonID = t10.fid ");
        sb.append("left join T_BD_VoucherTypes t12 on t1.FVoucherTypeID = t12.fid ");
        sb.append("left join T_GL_Voucher t13 on t1.FVoucherID = t13.fid ");
        sb.append("left join t_cas_paymentbilltype as t11 on t7.FPreSetBillTypeID = t11.FID ");
        if (filter != null) {
            sb.append(" where ");
            sb.append(filter.toString());
        }
        sb.append(" group by t1.fid");
        return sb.toString();
    }

    private String _getAutoVeriSql_AP(Context ctx, FilterInfo filter, int topCount) {
        String lang = ctx.getLocale().getLanguage();
        StringBuffer sb = new StringBuffer();
        sb.append(" select ");
        if (topCount != 0) {
            sb.append(" top ");
            sb.append(topCount);
        }
        sb.append(" t1.fid as billid,");
        sb.append(" t1.FCompanyID as company_id,");
        sb.append(" 9 as billtype,t1.FBillType as billsubtype,t1.fnumber as b_number,t1.FBillDate as billdate,");
        sb.append(" t1.FAsstActTypeID as acctCussType_id,");
        sb.append(" t1.FAsstActID as acctCuss_id, t1.FAsstactnumber  as acctCuss_number, t1.FAsstactName_");
        sb.append(ctx.getLocale().getLanguage());
        sb.append(" as acctCuss_name,");
        sb.append(" t1.FcurrencyID as currency_id,t5.FPrecision as FPrecision,");
        sb.append(" t2.fid as entryid,");
        sb.append(" t2.FAccountID as accountid,");
        sb.append(" t2.FOppAccountID as oppAccount,t1.FLastExhangeRate as exchangerate,");
        sb.append(" t2.FRecievePayAmount as billamt,t2.FRecievePayAmountLocal as billamtloc,");
        sb.append(" t2.FLockVerifyAmt as verificateamt,t2.FLockVerifyAmtLocal as verificateamtloc,");
        sb.append(" t2.FLockUnVerifyAmt as unverificateamt,t2.FLockUnVerifyAmtLocal as unverificateamtloc,");
        sb.append(" t1.FAbstractName as description ,t1.FAdminOrgUnitID as FAdminOrgUnitID, t1.FPersonID as FPersonID ,");
        sb.append(" t2.FCoreBillNumber as coreBillNumber , t2.FCoreBillEntrySeq as coreBillEntrySeq ");
        sb.append(", t2.FContractNumber as contractNum, t2.FContractEntrySeq as contractEntrySeq ");
        sb.append(",t7.FID as FMaterialID ");
        sb.append(",t7.FNumber as FMaterialNumber ");
        sb.append(",case isnull(t2.FMaterialID,'') when '' then t2.FMaterialName else ");
        sb.append(" t7.FName_").append(lang).append(" end as FMaterialName ");
        sb.append(",t8.FID as FExpenseItemID ");
        sb.append(",t8.FNumber as FExpenseItemNumber ");
        sb.append(",t8.FName_").append(lang).append(" as FExpenseItemName ");
        sb.append(" from T_AP_OtherBill as t1 ");
        sb.append(" inner join T_AP_OtherBillEntry AS t2 on t1.fid = t2.FParentID ");
        sb.append("inner join t_org_company AS t3 on t1.FCompanyID = t3.FID ");
        sb.append("inner join T_BD_AsstActType as t4 on t1.FAsstActTypeID = t4.fid ");
        sb.append("inner join t_bd_currency AS t5 on t1.fcurrencyid = t5.FID ");
        sb.append("left join T_BD_AccountView t6 on t2.FAccountID = t6.fid ");
        sb.append("left join T_BD_Material t7 on t2.FMaterialID = t7.fid ");
        sb.append("left join T_BC_ExpenseType t8 on t2.FExpenseItemID = t8.fid ");
        sb.append("left join T_ORG_Admin t9 on t1.FAdminOrgUnitID = t9.fid ");
        sb.append("left join T_BD_Person t10 on t1.FPersonID = t10.fid ");
        sb.append("left join T_BD_VoucherTypes t11 on t1.FVoucherTypeID = t11.fid ");
        sb.append("left join T_GL_Voucher t12 on t1.FVoucherID = t12.fid ");
        if (filter != null) {
            sb.append(" where ");
            sb.append(filter.toString());
        }
        sb.append(" order by billdate ASC, t1.Fnumber ASC, t2.fseq ASC ");
        return sb.toString();
    }

    private String _getTopUnverifyAmtSQL_AP(Context ctx, FilterInfo filter, int topCount) {
        StringBuffer sb = new StringBuffer();
        sb.append(" select ");
        if (topCount != 0) {
            sb.append(" top ");
            sb.append(topCount);
        }
        sb.append(" t1.fid as billid,sum(t2.FLockUnVerifyAmt) as allUnverificateamt ");
        sb.append(" from T_AP_OtherBill as t1 ");
        sb.append(" inner join T_AP_OtherBillEntry AS t2 on t1.fid = t2.FParentID ");
        sb.append("inner join t_org_company AS t3 on t1.FCompanyID = t3.FID ");
        sb.append("inner join T_BD_AsstActType as t4 on t1.FAsstActTypeID = t4.fid ");
        sb.append("inner join t_bd_currency AS t5 on t1.fcurrencyid = t5.FID ");
        sb.append("left join T_BD_AccountView t6 on t2.FAccountID = t6.fid ");
        sb.append("left join T_BD_Material t7 on t2.FMaterialID = t7.fid ");
        sb.append("left join T_BC_ExpenseType t8 on t2.FExpenseItemID = t8.fid ");
        sb.append("left join T_ORG_Admin t9 on t1.FAdminOrgUnitID = t9.fid ");
        sb.append("left join T_BD_Person t10 on t1.FPersonID = t10.fid ");
        sb.append("left join T_BD_VoucherTypes t11 on t1.FVoucherTypeID = t11.fid ");
        sb.append("left join T_GL_Voucher t12 on t1.FVoucherID = t12.fid ");
        if (filter != null) {
            sb.append(" where ");
            sb.append(filter.toString());
        }
        sb.append(" group by t1.fid");
        return sb.toString();
    }

    private String _getAutoVeriSql_AR(Context ctx, FilterInfo filter, int topCount) {
        String lang = ctx.getLocale().getLanguage();
        StringBuffer sb = new StringBuffer();
        sb.append("select ");
        if (topCount != 0) {
            sb.append(" top ");
            sb.append(topCount);
        }
        sb.append(" t1.fid as billid,");
        sb.append("t1.FCompanyID as company_id,");
        sb.append("8 as billtype,");
        sb.append("t1.FBillType as billsubtype,");
        sb.append("t1.fnumber as b_number,");
        sb.append("t1.FBillDate as billdate,");
        sb.append("t1.FAsstActTypeID as acctCussType_id,FAsstactNumber as acctCuss_number, FAsstactName_");
        sb.append(ctx.getLocale().getLanguage());
        sb.append(" as acctCuss_name,");
        sb.append("t1.FAsstActID as acctCuss_id,");
        sb.append("t1.FcurrencyID as currency_id,t5.FPrecision as FPrecision,");
        sb.append("t2.fid as entryid,");
        sb.append("t2.FAccountID as accountid,");
        sb.append("t2.FOppAccountID as oppAccount,t1.FExchangeRate as exchangerate,");
        sb.append("t2.FRecievePayAmount as billamt,t2.FRecievePayAmountLocal as billamtloc,");
        sb.append("t2.FLockVerifyAmt as verificateamt,t2.FLockVerifyAmtLocal as verificateamtloc,");
        sb.append("t2.FLockUnVerifyAmt as unverificateamt,t2.FLockUnVerifyAmtLocal as unverificateamtloc,");
        sb.append("t1.FAbstractName as description ,t1.FAdminOrgUnitID as FAdminOrgUnitID, ");
        sb.append("t1.FPersonID as FPersonID ,");
        sb.append("t2.FCoreBillNumber as coreBillNumber , t2.FCoreBillEntrySeq as coreBillEntrySeq ");
        sb.append(", t2.FContractNumber as contractNum, t2.FContractEntrySeq as contractEntrySeq ");
        sb.append(",t7.FID as FMaterialID ");
        sb.append(",t7.FNumber as FMaterialNumber ");
        sb.append(",case isnull(t2.FMaterialID,'') when '' then t2.FMaterialName else ");
        sb.append(" t7.FName_").append(lang).append(" end as FMaterialName ");
        sb.append(",t8.FID as FExpenseItemID ");
        sb.append(",t8.FNumber as FExpenseItemNumber ");
        sb.append(",t8.FName_").append(lang).append(" as FExpenseItemName ");
        sb.append("from T_AR_OtherBill as t1 inner join T_AR_OtherBillEntry as t2 on t1.fid = t2.fparentid ");
        sb.append("inner join t_org_company AS t3 on t1.FCompanyID = t3.FID ");
        sb.append("inner join T_BD_AsstActType as t4 on t1.FAsstActTypeID = t4.fid ");
        sb.append("inner join t_bd_currency AS t5 on t1.fcurrencyid = t5.FID ");
        sb.append("left join T_BD_AccountView t6 on t2.FAccountID = t6.fid ");
        sb.append("left join T_BD_Material t7 on t2.FMaterialID = t7.fid ");
        sb.append("left join T_BC_ExpenseType t8 on t2.FExpenseItemID = t8.fid ");
        sb.append("left join T_ORG_Admin t9 on t1.FAdminOrgUnitID = t9.fid ");
        sb.append("left join T_BD_Person t10 on t1.FPersonID = t10.fid ");
        sb.append("left join T_BD_VoucherTypes t11 on t1.FVoucherTypeID = t11.fid ");
        sb.append("left join T_GL_Voucher t12 on t1.FVoucherID = t12.fid ");
        if (filter != null) {
            sb.append(" where ");
            sb.append(filter.toString());
        }
        sb.append(" order by billdate ASC, t1.Fnumber ASC, t2.fseq ASC");
        return sb.toString();
    }

    private String _getTopUnverifyAmtSQL_AR(Context ctx, FilterInfo filter, int topCount) {
        StringBuffer sb = new StringBuffer();
        sb.append("select ");
        if (topCount != 0) {
            sb.append(" top ");
            sb.append(topCount);
        }
        sb.append(" t1.fid as billid,sum(t2.FLockUnVerifyAmt) as allUnverificateamt ");
        sb.append("from T_AR_OtherBill as t1 inner join T_AR_OtherBillEntry as t2 on t1.fid = t2.fparentid ");
        sb.append("inner join t_org_company AS t3 on t1.FCompanyID = t3.FID ");
        sb.append("inner join T_BD_AsstActType as t4 on t1.FAsstActTypeID = t4.fid ");
        sb.append("inner join t_bd_currency AS t5 on t1.fcurrencyid = t5.FID ");
        sb.append("left join T_BD_AccountView t6 on t2.FAccountID = t6.fid ");
        sb.append("left join T_BD_Material t7 on t2.FMaterialID = t7.fid ");
        sb.append("left join T_BC_ExpenseType t8 on t2.FExpenseItemID = t8.fid ");
        sb.append("left join T_ORG_Admin t9 on t1.FAdminOrgUnitID = t9.fid ");
        sb.append("left join T_BD_Person t10 on t1.FPersonID = t10.fid ");
        sb.append("left join T_BD_VoucherTypes t11 on t1.FVoucherTypeID = t11.fid ");
        sb.append("left join T_GL_Voucher t12 on t1.FVoucherID = t12.fid ");
        if (filter != null) {
            sb.append(" where ");
            sb.append(filter.toString());
        }
        sb.append(" group by t1.fid");
        return sb.toString();
    }

    private String _getTotalSql_ARBill(FilterInfo filter, int count, boolean isSumTotal) {
        StringBuffer sb = new StringBuffer();
        if (isSumTotal) {
            sb.append("select ");
            sb.append(" sum(A.AFLockUnVerifyAmt), sum(A.AFLockUnVerifyAmtLocal), max(A.billdate) from (");
        }
        sb.append("select ");
        if (count > 0) {
            sb.append(" top ");
            sb.append(count);
            sb.append(" ");
        }
        sb.append(" t1.FID as ID,t2.FLockUnVerifyAmt as AFLockUnVerifyAmt, t2.FLockUnVerifyAmtLocal as AFLockUnVerifyAmtLocal, t1.FBillDate billdate ");
        sb.append("from T_AR_OtherBill as t1  ");
        sb.append("inner join T_AR_OtherBillEntry as t2 on t1.fid = t2.FParentID  ");
        sb.append("inner join t_org_company AS t3 on t1.FCompanyID = t3.FID ");
        sb.append("inner join T_BD_AsstActType as t4 on t1.FAsstActTypeID = t4.fid ");
        sb.append("inner join t_bd_currency AS t5 on t1.fcurrencyid = t5.FID ");
        sb.append("left join T_BD_AccountView t6 on t2.FAccountID = t6.fid ");
        sb.append("left join T_BD_Material t7 on t2.FMaterialID = t7.fid ");
        sb.append("left join T_BC_ExpenseType t8 on t2.FExpenseItemID = t8.fid ");
        sb.append("left join T_ORG_Admin t9 on t1.FAdminOrgUnitID = t9.fid ");
        sb.append("left join T_BD_Person t10 on t1.FPersonID = t10.fid ");
        sb.append("left join T_BD_VoucherTypes t11 on t1.FVoucherTypeID = t11.fid ");
        sb.append("left join T_GL_Voucher t12 on t1.FVoucherID = t12.fid ");
        if (filter != null && filter.getFilterItems().size() > 0) {
            sb.append(" where ");
            sb.append(filter.toString());
        }
        sb.append(" order by t1.FBillDate ASC");
        if (isSumTotal) {
            sb.append(" ) AS A");
        }
        return sb.toString();
    }

    private String _getTotalSql_APBill(FilterInfo filter, int count, boolean isSumTotal) {
        StringBuffer sb = new StringBuffer();
        if (isSumTotal) {
            sb.append("select ");
            sb.append(" sum(A.AFLockUnVerifyAmt), sum(A.AFLockUnVerifyAmtLocal),max(A.billdate) from(");
        }
        sb.append("select ");
        if (count > 0) {
            sb.append(" top ");
            sb.append(count);
            sb.append(" ");
        }
        sb.append(" t1.FID as ID, t2.FLockUnVerifyAmt as AFLockUnVerifyAmt, t2.FLockUnVerifyAmtLocal as AFLockUnVerifyAmtLocal,t1.FBillDate billdate ");
        sb.append("from T_AP_OtherBill as t1  ");
        sb.append("inner join T_AP_OtherBillEntry as t2 on t1.fid = t2.FParentID  ");
        sb.append("inner join t_org_company AS t3 on t1.FCompanyID = t3.FID ");
        sb.append("inner join T_BD_AsstActType as t4 on t1.FAsstActTypeID = t4.fid ");
        sb.append("inner join t_bd_currency AS t5 on t1.fcurrencyid = t5.FID ");
        sb.append("left join T_BD_AccountView t6 on t2.FAccountID = t6.fid ");
        sb.append("left join T_BD_Material t7 on t2.FMaterialID = t7.fid ");
        sb.append("left join T_BC_ExpenseType t8 on t2.FExpenseItemID = t8.fid ");
        sb.append("left join T_ORG_Admin t9 on t1.FAdminOrgUnitID = t9.fid ");
        sb.append("left join T_BD_Person t10 on t1.FPersonID = t10.fid ");
        sb.append("left join T_BD_VoucherTypes t11 on t1.FVoucherTypeID = t11.fid ");
        sb.append("left join T_GL_Voucher t12 on t1.FVoucherID = t12.fid ");
        if (filter != null && filter.getFilterItems().size() > 0) {
            sb.append(" where ");
            sb.append(filter.toString());
        }
        sb.append(" order by t1.FBillDate ASC");
        if (isSumTotal) {
            sb.append(" ) AS A");
        }
        return sb.toString();
    }

    private String _getAssActIDsSql_ARBill(FilterInfo filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select distinct ");
        sb.append(" t1.FAsstActID ");
        sb.append("from T_AR_OtherBill as t1  ");
        sb.append("inner join T_AR_OtherBillEntry as t2 on t1.fid = t2.FParentID  ");
        sb.append("inner join t_org_company AS t3 on t1.FCompanyID = t3.FID ");
        sb.append("inner join T_BD_AsstActType as t4 on t1.FAsstActTypeID = t4.fid ");
        sb.append("inner join t_bd_currency AS t5 on t1.fcurrencyid = t5.FID ");
        sb.append("left join T_BD_AccountView t6 on t2.FAccountID = t6.fid ");
        sb.append("left join T_BD_Material t7 on t2.FMaterialID = t7.fid ");
        sb.append("left join T_BC_ExpenseType t8 on t2.FExpenseItemID = t8.fid ");
        sb.append("left join T_ORG_Admin t9 on t1.FAdminOrgUnitID = t9.fid ");
        sb.append("left join T_BD_Person t10 on t1.FPersonID = t10.fid ");
        sb.append("left join T_BD_VoucherTypes t11 on t1.FVoucherTypeID = t11.fid ");
        sb.append("left join T_GL_Voucher t12 on t1.FVoucherID = t12.fid ");
        if (filter != null && filter.getFilterItems().size() > 0) {
            sb.append(" where ");
            sb.append(filter.toString());
        }
        return sb.toString();
    }

    private String _getAssActIDsSql_APBill(FilterInfo filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select distinct ");
        sb.append(" t1.FAsstActID ");
        sb.append("from T_AP_OtherBill as t1  ");
        sb.append("inner join T_AP_OtherBillEntry as t2 on t1.fid = t2.FParentID  ");
        sb.append("inner join t_org_company AS t3 on t1.FCompanyID = t3.FID ");
        sb.append("inner join T_BD_AsstActType as t4 on t1.FAsstActTypeID = t4.fid ");
        sb.append("inner join t_bd_currency AS t5 on t1.fcurrencyid = t5.FID ");
        sb.append("left join T_BD_AccountView t6 on t2.FAccountID = t6.fid ");
        sb.append("left join T_BD_Material t7 on t2.FMaterialID = t7.fid ");
        sb.append("left join T_BC_ExpenseType t8 on t2.FExpenseItemID = t8.fid ");
        sb.append("left join T_ORG_Admin t9 on t1.FAdminOrgUnitID = t9.fid ");
        sb.append("left join T_BD_Person t10 on t1.FPersonID = t10.fid ");
        sb.append("left join T_BD_VoucherTypes t11 on t1.FVoucherTypeID = t11.fid ");
        sb.append("left join T_GL_Voucher t12 on t1.FVoucherID = t12.fid ");
        if (filter != null && filter.getFilterItems().size() > 0) {
            sb.append(" where ");
            sb.append(filter.toString());
        }
        return sb.toString();
    }

    private String _getAssActIDsSql_Rec(FilterInfo filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select distinct ");
        sb.append(" t1.FPayerID ");
        sb.append("from T_CAS_ReceivingBill as t1  ");
        sb.append("inner join T_CAS_ReceivingBillEntry as t2 on t1.fid = t2.FReceivingBillID ");
        sb.append("left join T_ORG_Company AS t3 on t1.FCompanyID = t3.FID ");
        sb.append("left join T_BD_Currency as t4 on t1.FCurrencyID = t4.FID ");
        sb.append("left join T_BD_AsstActType as t5 on t1.FPayerTypeID = t5.FID ");
        sb.append("left join T_BD_AccountView t6 on t1.FPayeeAccountID = t6.FID ");
        sb.append("left join t_cas_receivingbilltype as t7 on t2.FRecBillTypeID = t7.FID ");
        sb.append("left join T_ORG_Admin t8 on t1.FAdminOrgUnitID = t8.fid ");
        sb.append("left join T_BD_Person t10 on t1.FPersonID = t10.fid ");
        sb.append("left join T_BD_VoucherTypes t12 on t1.FVoucherTypeID = t12.fid ");
        sb.append("left join T_GL_Voucher t13 on t1.FVoucherID = t13.fid ");
        sb.append("left join t_cas_receivingbilltype as t11 on t7.FPreSetBillTypeID = t11.FID ");
        if (filter != null && filter.getFilterItems().size() > 0) {
            sb.append(" where ");
            sb.append(filter.toString());
        }
        return sb.toString();
    }

    private String _getAssActIDsSql_Pay(FilterInfo filter) {
        StringBuffer sb = new StringBuffer();
        sb.append("select distinct ");
        sb.append(" t1.FPayeeID ");
        sb.append("from T_CAS_PaymentBill as t1  ");
        sb.append("inner join T_CAS_PaymentBillEntry as t2 on t1.fid = t2.FPaymentBillID  ");
        sb.append("left join T_ORG_Company AS t3 on t1.FCompanyID = t3.FID ");
        sb.append("left join T_BD_Currency as t4 on t1.FCurrencyID = t4.FID ");
        sb.append("left join T_BD_AsstActType as t5 on t1.FPayeeTypeID = t5.FID ");
        sb.append("left join T_BD_AccountView t6 on t1.FPayerAccountID = t6.FID ");
        sb.append("left join t_cas_paymentbilltype as t7 on t1.FPayBillTypeID = t7.FID ");
        sb.append("left join T_ORG_Admin t8 on t1.FAdminOrgUnitID = t8.fid ");
        sb.append("left join T_BD_Person t10 on t1.FPersonID = t10.fid ");
        sb.append("left join T_BD_VoucherTypes t12 on t1.FVoucherTypeID = t12.fid ");
        sb.append("left join T_GL_Voucher t13 on t1.FVoucherID = t13.fid ");
        sb.append("left join t_cas_paymentbilltype as t11 on t7.FPreSetBillTypeID = t11.FID ");
        if (filter != null && filter.getFilterItems().size() > 0) {
            sb.append(" where ");
            sb.append(filter.toString());
        }
        return sb.toString();
    }

    private String _getTotalSql_Rec(FilterInfo filter, int count, boolean isSumTotal, VerificateBillTypeEnum veriType) {
        StringBuffer sql = new StringBuffer();
        if (isSumTotal) {
            sql.append("select ");
            sql.append("sum(A.AFUnLockAmt), sum(A.AFUnLockLocAmt), max(A.billdate) from (");
        }
        sql.append("select ");
        if (count > 0) {
            sql.append(" top ");
            sql.append(count);
            sql.append(" ");
        }
        sql.append("t1.FID as ID,t2.FUnLockAmt as AFUnLockAmt, t2.FUnLockLocAmt as AFUnLockLocAmt, t1.FBizDate billdate");
        sql.append(" from T_CAS_ReceivingBill as t1 ");
        sql.append("inner join T_CAS_ReceivingBillEntry as t2 on t1.fid = t2.FReceivingBillID ");
        sql.append("left join T_ORG_Company AS t3 on t1.FCompanyID = t3.FID ");
        sql.append("left join T_BD_Currency as t4 on t1.FCurrencyID = t4.FID ");
        sql.append("left join T_BD_AsstActType as t5 on t1.FPayerTypeID = t5.FID ");
        sql.append("left join T_BD_AccountView t6 on t1.FPayeeAccountID = t6.FID ");
        sql.append("left join t_cas_receivingbilltype as t7 on t2.FRecBillTypeID = t7.FID ");
        sql.append("left join T_ORG_Admin t8 on t1.FAdminOrgUnitID = t8.fid ");
        sql.append("left join T_BD_Person t10 on t1.FPersonID = t10.fid ");
        sql.append("left join T_BD_VoucherTypes t12 on t1.FVoucherTypeID = t12.fid ");
        sql.append("left join T_GL_Voucher t13 on t1.FVoucherID = t13.fid ");
        sql.append("left join t_cas_receivingbilltype as t11 on t7.FPreSetBillTypeID = t11.FID ");
        if (filter != null && filter.getFilterItems().size() > 0) {
            if (veriType.getValue() == 101) {
                sql.append(" where t7.fnumber not in ('104','105') and ");
            } else {
                sql.append(" where ");
            }
            sql.append(filter.toString());
        }
        sql.append(" order by t1.FBizDate ASC");
        if (isSumTotal) {
            sql.append(" ) AS A");
        }
        return sql.toString();
    }

    private String _getTotalSql_Pay(FilterInfo filter, int count, boolean isSumTotal) {
        StringBuffer sql = new StringBuffer();
        if (isSumTotal) {
            sql.append("select ");
            sql.append("sum(A.AFUnLockAmt), sum(A.AFUnLockLocAmt),max(A.billDate) from(");
        }
        sql.append("select ");
        if (count > 0) {
            sql.append(" top ");
            sql.append(count);
            sql.append(" ");
        }
        sql.append("t1.FID as ID,t2.FUnLockAmt as AFUnLockAmt, t2.FUnLockLocAmt as AFUnLockLocAmt, t1.FBizDate billdate ");
        sql.append(" from T_CAS_PaymentBill as t1 ");
        sql.append("inner join T_CAS_PaymentBillEntry as t2 on t1.fid = t2.FPaymentBillID ");
        sql.append("left join T_ORG_Company AS t3 on t1.FCompanyID = t3.FID ");
        sql.append("left join T_BD_Currency as t4 on t1.FCurrencyID = t4.FID ");
        sql.append("left join T_BD_AsstActType as t5 on t1.FPayeeTypeID = t5.FID ");
        sql.append("left join T_BD_AccountView t6 on t1.FPayerAccountID = t6.FID ");
        sql.append("left join t_cas_paymentbilltype as t7 on t1.FPayBillTypeID = t7.FID ");
        sql.append("left join T_ORG_Admin t8 on t1.FAdminOrgUnitID = t8.fid ");
        sql.append("left join T_BD_Person t10 on t1.FPersonID = t10.fid ");
        sql.append("left join T_BD_VoucherTypes t12 on t1.FVoucherTypeID = t12.fid ");
        sql.append("left join T_GL_Voucher t13 on t1.FVoucherID = t13.fid ");
        sql.append("left join t_cas_paymentbilltype as t11 on t7.FPreSetBillTypeID = t11.FID ");
        if (filter != null && filter.getFilterItems().size() > 0) {
            sql.append("where ");
            sql.append(filter.toString());
        }
        sql.append(" order by t1.FBizDate ASC");
        if (isSumTotal) {
            sql.append(" ) AS A");
        }
        return sql.toString();
    }

    @Override
    protected Map _getReceive(Context ctx, HashMap filter) throws BOSException, EASBizException {
        String lang = ctx.getLocale().getLanguage();
        boolean isBill = (Boolean)filter.get("isBill");
        String topSqlQuery = (String)filter.get("topSqlQuery");
        String bottomSqlQuery = (String)filter.get("bottomSqlQuery");
        String sqlQuery = null;
        if (topSqlQuery != null && topSqlQuery.length() > 0) {
            sqlQuery = topSqlQuery;
        } else if (bottomSqlQuery != null && bottomSqlQuery.length() > 0) {
            sqlQuery = bottomSqlQuery;
        }
        String pageRowCount = filter.get("pageRowCount") == null ? "1000" : filter.get("pageRowCount").toString();
        String startIndex = filter.get("startIndex") == null ? "0" : filter.get("startIndex").toString();
        String endIndex = filter.get("endIndex") == null ? pageRowCount : filter.get("endIndex").toString();
        StringBuffer sb = new StringBuffer("select top ");
        sb.append(endIndex);
        sb.append(" t1.fid as billid,");
        sb.append("t3.fid as company_id,");
        sb.append("t3.fname_").append(lang).append(" as company_name,");
        sb.append("6 as billtype,");
        sb.append(" case when t7.fispreset = 0 then t11.fnumber else t7.fnumber end as billsubtype,");
        sb.append("t1.fnumber as b_number,");
        sb.append("t1.fbizdate as billdate,");
        sb.append("t1.FPayerTypeID as acctCussType_id,");
        sb.append("t5.fname_").append(lang).append(" as acctCussType_name,");
        sb.append("t5.fnumber as acctCussType_number,");
        sb.append("t1.fpayerid as acctCuss_id,");
        sb.append("t1.fpayername as acctCuss_name,");
        sb.append("t1.fpayernumber as acctCuss_number,");
        sb.append("t1.fcurrencyid as currency_id,");
        sb.append("t4.fname_").append(lang).append(" as currency_name,");
        sb.append("t4.fnumber as currency_number,");
        sb.append("t2.fid as entryid,");
        sb.append("t6.FID as accountid,");
        sb.append("t6.FID as accountnumber,");
        sb.append("t6.FName_").append(lang).append(" as accountname,");
        sb.append("t1.FOppAccountID as oppAccount,");
        sb.append("t1.FLastExhangeRate as exchangerate,");
        if (isBill) {
            sb.append("t1.FAmount as billamt,");
            sb.append("t1.FLocalAmount as billamtloc,");
        } else {
            sb.append("t2.FAmount as billamt,");
            sb.append("t2.FLocalAmount as billamtloc,");
        }
        if (isBill) {
            sb.append("t1.FActRecAmt as actualAmt,");
            sb.append("t1.FActRecLocAmt as actualAmtLoc,");
        } else {
            sb.append("t2.FActualAmt as actualAmt,");
            sb.append("t2.FActualLocAmt as actualAmtLoc,");
        }
        sb.append("t2.FRebate as rebateAmt,");
        sb.append("t2.FRebateLocAmt as rebateAmtLoc,");
        sb.append("t2.FLockAmt as verificateamt,");
        sb.append("t2.FLockLocAmt as verificateamtloc,");
        sb.append("t2.FUnLockAmt as unverificateamt,");
        sb.append("t2.FUnLockLocAmt as unverificateamtloc,");
        sb.append("t2.FRemark as remark ,");
        sb.append("t2.FSeq as seq ,");
        sb.append("t1.FDescription as description ,");
        sb.append("t7.FisPreSet as isPreSet ,");
        sb.append("t7.FName_").append(ctx.getLocale().getLanguage()).append(" as recType ");
        sb.append(",t1.FAdminOrgUnitID as FAdminOrgUnitID ");
        sb.append(",t8.FName_").append(ctx.getLocale().getLanguage()).append(" as FAdminOrgUnitName ");
        sb.append(",t1.FPersonID as FPersonID ");
        sb.append(",t10.FName_").append(lang).append(" as FPerson ");
        sb.append(",t2.FCoreBillNumber as coreBillNumber ");
        sb.append(", t2.FCoreBillEntrySeq as coreBillEntrySeq ");
        sb.append(", t2.FContractNumber as contractNum ");
        sb.append(", t2.FContractEntrySeq as contractEntrySeq ");
        sb.append(", t7.FID as FVeriRecPayTypeId ");
        sb.append(", t7.FNumber as FVeriRecPayTypeNumber ");
        sb.append(", t7.FName_").append(lang).append(" as FVeriRecPayTypeName ");
        sb.append(",t12.FName_").append(lang).append(" as FVOUCHERTYPE ");
        sb.append(",t13.FNumber as FVOUCHERNUM ");
        sb.append(",PAYMENTTYPE.FID as PAYMENTTYPEID ");
        sb.append(",PAYMENTTYPE.FName_").append(lang).append(" as PAYMENTTYPE_name ");
        if (sqlQuery != null && sqlQuery.length() > 0) {
            String fromCont = "";
            fromCont = sqlQuery.indexOf("WHERE") != -1 ? sqlQuery.substring(sqlQuery.indexOf("FROM"), sqlQuery.indexOf("WHERE")) : (sqlQuery.indexOf("ORDER BY") != -1 ? sqlQuery.substring(sqlQuery.indexOf("FROM"), sqlQuery.indexOf("ORDER BY")) : sqlQuery.substring(sqlQuery.indexOf("FROM")));
            fromCont = fromCont.replaceAll("\"RECEIVINGBILL\"", "t1");
            fromCont = fromCont.replaceAll("\"ENTRIES\"", "t2");
            fromCont = fromCont.replaceAll("\"COMPANY\"", "t3");
            fromCont = fromCont.replaceAll("\"CURRENCY\"", "t4");
            fromCont = fromCont.replaceAll("\"PAYERTYPE\"", "t5");
            fromCont = fromCont.replaceAll("\"PAYEEACCOUNT\"", "t6");
            fromCont = fromCont.replaceAll("\"ENTRYRECBILLTYPE\"", "t7");
            fromCont = fromCont.replaceAll("\"ADMINORGUNIT\"", "t8");
            fromCont = fromCont.replaceAll("\"PERSON\"", "t10");
            fromCont = fromCont.replaceAll("\"VOUCHERTYPE\"", "t12");
            fromCont = fromCont.replaceAll("\"VOUCHER\"", "t13");
            fromCont = fromCont.replaceAll("\"PAYMENTTYPE\"", "PAYMENTTYPE");
            sb.append(fromCont);
        } else {
            sb.append(this.getReceiveBillFieldsExtends(ctx));
            sb.append("FROM T_CAS_ReceivingBill as t1 ");
            sb.append("inner join T_CAS_ReceivingBillEntry as t2 on t1.fid = t2.FReceivingBillID ");
            sb.append("left join T_ORG_Company AS t3 on t1.FCompanyID = t3.FID ");
            sb.append("left join T_BD_Currency as t4 on t1.FCurrencyID = t4.FID ");
            sb.append("left join T_BD_AsstActType as t5 on t1.FPayerTypeID = t5.FID ");
            sb.append("left join T_BD_AccountView t6 on t1.FPayeeAccountID = t6.FID ");
            sb.append("left join t_cas_receivingbilltype as t7 on t2.FRecBillTypeID = t7.FID ");
            sb.append("left join T_ORG_Admin t8 on t1.FAdminOrgUnitID = t8.fid ");
            sb.append("left join T_BD_Person t10 on t1.FPersonID = t10.fid ");
            sb.append("left join T_BD_VoucherTypes t12 on t1.FVoucherTypeID = t12.fid ");
            sb.append("left join T_GL_Voucher t13 on t1.FVoucherID = t13.fid ");
            sb.append("left join T_BD_PaymentType PAYMENTTYPE on t1.FPaymentTypeID = PAYMENTTYPE.fid ");
            sb.append(this.getReceiveBillJoinTableExtends(ctx));
        }
        sb.append(" left join t_cas_receivingbilltype as t11 on t7.FPreSetBillTypeID = t11.FID ");
        sb.append(" where (t1.FBillStatus = 14 OR t1.FBillStatus = 16 ) AND (t1.FSourceType = 100 OR t1.FSourceType = 101) AND  ");
        sb.append(this.getReceiveBillWhereExtends(ctx, filter));
        sb.append(this._transferToRecFilterInfo(filter).toString());
        HashMap<String, String> result = new HashMap<String, String>();
        String sqlSum = sb.substring(sb.indexOf("FROM"));
        if (!filter.containsKey("sqlSum") || !sqlSum.equals(filter.get("sqlSum"))) {
            result.put("sqlSum", "SELECT SUM(t2.FUnLockAmt), SUM(t2.FUnLockLocAmt) " + sqlSum);
        }
        sb.append(" order by billdate ASC, t1.Fnumber ASC");
        if (isBill && filter.containsKey("rowCount")) {
            startIndex = filter.get("rowCount").toString();
        }
        return this.getRowSet(ctx, Integer.valueOf(startIndex), Integer.valueOf(pageRowCount), isBill, sb.toString(), result);
    }

    @Override
    protected Map _getPayment(Context ctx, HashMap filter) throws BOSException, EASBizException {
        String lang = ctx.getLocale().getLanguage();
        boolean isBill = (Boolean)filter.get("isBill");
        int billType = 4;
        String topSqlQuery = (String)filter.get("topSqlQuery");
        String bottomSqlQuery = (String)filter.get("bottomSqlQuery");
        String sqlQuery = null;
        if (topSqlQuery != null && topSqlQuery.length() > 0) {
            sqlQuery = topSqlQuery;
        } else if (bottomSqlQuery != null && bottomSqlQuery.length() > 0) {
            sqlQuery = bottomSqlQuery;
        }
        String pageRowCount = filter.get("pageRowCount") == null ? "1000" : filter.get("pageRowCount").toString();
        String startIndex = filter.get("startIndex") == null ? "0" : filter.get("startIndex").toString();
        String endIndex = filter.get("endIndex") == null ? pageRowCount : filter.get("endIndex").toString();
        StringBuffer sb = new StringBuffer("select top ");
        sb.append(endIndex);
        sb.append(" t1.fid as billid,");
        sb.append("t3.fid as company_id,");
        sb.append("t3.fname_").append(lang).append(" as company_name,");
        sb.append(billType).append(" as billtype,");
        sb.append(" case when t7.fispreset = 0 then t11.fnumber else t7.fnumber end as billsubtype,");
        sb.append("t1.fnumber as b_number,");
        sb.append("t1.FBizDate as billdate,");
        sb.append("t1.FPayeeTypeID as acctCussType_id,");
        sb.append("t5.fname_").append(lang).append(" as acctCussType_name,");
        sb.append("t5.fnumber as acctCussType_number,");
        sb.append("t1.fpayeeid as acctCuss_id,");
        sb.append("t1.fpayeename as acctCuss_name,");
        sb.append("t1.fpayeenumber as acctCuss_number,");
        sb.append("t1.fcurrencyid as currency_id,");
        sb.append("t4.fname_").append(lang).append(" as currency_name,");
        sb.append("t4.fnumber as currency_number,");
        sb.append("t2.fid as entryid,");
        sb.append("t6.FID as accountid,");
        sb.append("t6.FNumber as accountnumber,");
        sb.append("t6.FName_").append(lang).append(" as accountname,");
        sb.append("t1.FOppAccountID as oppAccount,");
        sb.append("t1.FLastExhangeRate as exchangerate,");
        if (isBill) {
            sb.append("t1.FAmount as billamt,");
            sb.append("t1.FLocalAmount as billamtloc,");
        } else {
            sb.append("t2.FAmount as billamt,");
            sb.append("t2.FLocalAmount as billamtloc,");
        }
        if (isBill) {
            sb.append("t1.FActualPayAmount as actualAmt,");
            sb.append("t1.FActPayLocAmt as actualAmtLoc,");
        } else {
            sb.append("t2.FActualAmt as actualAmt,");
            sb.append("t2.FActualLocAmt as actualAmtLoc,");
        }
        sb.append("t2.FRebate as rebateAmt,");
        sb.append("t2.FRebateLocAmt as rebateAmtLoc,");
        sb.append("t2.FLockAmt as verificateamt,");
        sb.append("t2.FLockLocAmt as verificateamtloc,");
        sb.append("t2.FUnLockAmt as unverificateamt,");
        sb.append("t2.FUnLockLocAmt as unverificateamtloc,");
        sb.append("t2.FRemark as remark ,");
        sb.append("t2.FSeq as seq ,");
        sb.append("t1.FDescription as description ");
        sb.append(", t7.FisPreSet as isPreSet ,");
        sb.append(" t7.FName_").append(ctx.getLocale().getLanguage()).append(" as payType ");
        sb.append(",t1.FAdminOrgUnitID as FAdminOrgUnitID ");
        sb.append(",t8.FName_").append(ctx.getLocale().getLanguage()).append(" as FAdminOrgUnitName ");
        sb.append(",t1.FPersonID as FPersonID ");
        sb.append(",t10.FName_").append(lang).append(" as FPerson ");
        sb.append(",t2.FCoreBillNumber as coreBillNumber ");
        sb.append(", t2.FCoreBillEntrySeq as coreBillEntrySeq ");
        sb.append(", t2.FContractNumber as contractNum ");
        sb.append(", t2.FContractEntrySeq as contractEntrySeq ");
        sb.append(", t7.FID as FVeriRecPayTypeId ");
        sb.append(", t7.FNumber as FVeriRecPayTypeNumber ");
        sb.append(", t7.FName_").append(ctx.getLocale().getLanguage()).append(" as FVeriRecPayTypeName ");
        sb.append(",t12.FName_").append(lang).append(" as FVOUCHERTYPE ");
        sb.append(",t13.FNumber as FVOUCHERNUM ");
        sb.append(",PAYMENTTYPE.FID as PAYMENTTYPEID ");
        sb.append(",PAYMENTTYPE.FName_").append(lang).append(" as PAYMENTTYPE_name ");
        if (sqlQuery != null && sqlQuery.length() > 0) {
            String fromCont = "";
            fromCont = sqlQuery.indexOf("WHERE") != -1 ? sqlQuery.substring(sqlQuery.indexOf("FROM"), sqlQuery.indexOf("WHERE")) : (sqlQuery.indexOf("ORDER BY") != -1 ? sqlQuery.substring(sqlQuery.indexOf("FROM"), sqlQuery.indexOf("ORDER BY")) : sqlQuery.substring(sqlQuery.indexOf("FROM")));
            fromCont = fromCont.replaceAll("\"PAYMENTBILL\"", "t1");
            fromCont = fromCont.replaceAll("\"ENTRIES\"", "t2");
            fromCont = fromCont.replaceAll("\"COMPANY\"", "t3");
            fromCont = fromCont.replaceAll("\"CURRENCY\"", "t4");
            fromCont = fromCont.replaceAll("\"PAYEETYPE\"", "t5");
            fromCont = fromCont.replaceAll("\"PAYERACCOUNT\"", "t6");
            fromCont = fromCont.replaceAll("\"PAYBILLTYPE\"", "t7");
            fromCont = fromCont.replaceAll("\"ADMINORGUNIT\"", "t8");
            fromCont = fromCont.replaceAll("\"PERSON\"", "t10");
            fromCont = fromCont.replaceAll("\"VOUCHERTYPE\"", "t12");
            fromCont = fromCont.replaceAll("\"VOUCHER\"", "t13");
            sb.append(fromCont);
        } else {
            sb.append(this.getPaymentBillFieldsExtends(ctx));
            sb.append("FROM T_CAS_PaymentBill as t1 ");
            sb.append("inner join T_CAS_PaymentBillEntry as t2 on t1.FID = t2.FPaymentBillID ");
            sb.append("left join T_ORG_Company AS t3 on t1.FCompanyID = t3.FID ");
            sb.append("left join T_BD_Currency as t4 on t1.FCurrencyID = t4.FID ");
            sb.append("left join T_BD_AsstActType as t5 on t1.FPayeeTypeID = t5.FID ");
            sb.append("left join T_BD_AccountView t6 on t1.FPayerAccountID = t6.FID ");
            sb.append("left join t_cas_paymentbilltype as t7 on t1.FPayBillTypeID = t7.FID ");
            sb.append("left join T_ORG_Admin t8 on t1.FAdminOrgUnitID = t8.fid ");
            sb.append("left join T_BD_Person t10 on t1.FPersonID = t10.fid ");
            sb.append("left join T_BD_VoucherTypes t12 on t1.FVoucherTypeID = t12.fid ");
            sb.append("left join T_GL_Voucher t13 on t1.FVoucherID = t13.fid ");
            sb.append("left join T_BD_PaymentType PAYMENTTYPE on t1.FPaymentTypeID = PAYMENTTYPE.fid ");
            sb.append(this.getPaymentBillJoinTableExtends(ctx));
        }
        sb.append("left join t_cas_paymentbilltype as t11 on t7.FPreSetBillTypeID = t11.FID ");
        sb.append(" WHERE (t1.FBillStatus = 15 OR t1.FBillStatus = 16 ) AND (t1.FSourceType = 100 OR t1.FSourceType = 101) AND  ");
        sb.append(this._transferToPayFilterInfo(filter).toString());
        sb.append(this.getPaymentBillWhereExtends(ctx, filter));
        HashMap<String, String> result = new HashMap<String, String>();
        String sqlSum = sb.substring(sb.indexOf("FROM"));
        if (!filter.containsKey("sqlSum") || !sqlSum.equals(filter.get("sqlSum"))) {
            result.put("sqlSum", "SELECT SUM(t2.FUnLockAmt), SUM(t2.FUnLockLocAmt) " + sqlSum);
        }
        sb.append(" order by billdate ASC, t1.Fnumber ASC");
        if (isBill && filter.containsKey("rowCount")) {
            startIndex = filter.get("rowCount").toString();
        }
        return this.getRowSet(ctx, Integer.valueOf(startIndex), Integer.valueOf(pageRowCount), isBill, sb.toString(), result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal _getTotalVeri(Connection conn, FilterInfo filter, int thisVeriCount, VerificateBillTypeEnum veriType) throws EASBizException, SQLException {
        ArrayList<String> otherLockedList;
        BigDecimal total;
        ResultSet rs;
        PreparedStatement preStmt;
        block16: {
            preStmt = null;
            rs = null;
            total = this.ZERO;
            BigDecimal aFLockUnVerifyAmt = this.ZERO;
            String sql = null;
            otherLockedList = new ArrayList<String>();
            switch (veriType.getValue()) {
                case 8: {
                    sql = this._getTotalSql_ARBill(filter, thisVeriCount, false);
                    break;
                }
                case 6: {
                    sql = this._getTotalSql_Rec(filter, thisVeriCount, false, veriType);
                    break;
                }
                case 9: {
                    sql = this._getTotalSql_APBill(filter, thisVeriCount, false);
                    break;
                }
                case 4: {
                    sql = this._getTotalSql_Pay(filter, thisVeriCount, false);
                    break;
                }
                case 5: {
                    sql = this._getTotalSql_Pay(filter, thisVeriCount, false);
                    break;
                }
                case 7: {
                    sql = this._getTotalSql_Rec(filter, thisVeriCount, false, veriType);
                    break;
                }
                default: {
                    return null;
                }
            }
            try {
                preStmt = conn.prepareStatement(sql);
                rs = preStmt.executeQuery();
                while (rs.next()) {
                    String ID = rs.getString("ID");
                    if (!this.requestLockIDList.contains(ID)) {
                        this.requestLockIDList.add(ID);
                    }
                    if ((aFLockUnVerifyAmt = rs.getBigDecimal(2)) == null) continue;
                    total = total.add(aFLockUnVerifyAmt);
                }
                if (this.requestLockIDList == null || this.requestLockIDList.size() <= 0) break block16;
                Map map = this.iMutexServiceControl.batchRequestObjIDForUpdate(this.requestLockIDList);
                int size = this.requestLockIDList.size();
                for (int i = 0; i < size; ++i) {
                    String id = (String)this.requestLockIDList.get(i);
                    if (((Boolean)map.get(id)).booleanValue()) {
                        this.lockedIDList.add(id);
                        continue;
                    }
                    otherLockedList.add(id);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)preStmt);
                if (otherLockedList.size() > 0) {
                    this.releaseLocks(this.lockedIDList);
                    throw new ARAPVerifynException(ARAPVerifynException.BILL_LOCKED_NOT_VERI);
                }
                otherLockedList.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)preStmt);
        if (otherLockedList.size() > 0) {
            this.releaseLocks(this.lockedIDList);
            throw new ARAPVerifynException(ARAPVerifynException.BILL_LOCKED_NOT_VERI);
        }
        otherLockedList.clear();
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal _getTotalVeri_old(Connection conn, FilterInfo filter, int thisVeriCount, VerificateBillTypeEnum veriType) throws SQLException {
        PreparedStatement preStmt = null;
        ResultSet rs = null;
        BigDecimal total = null;
        String sql = null;
        String sql1 = null;
        switch (veriType.getValue()) {
            case 8: {
                sql = this._getTotalSql_ARBill(filter, thisVeriCount, true);
                sql1 = this._getTotalSql_ARBill(filter, thisVeriCount, false);
                break;
            }
            case 6: {
                sql = this._getTotalSql_Rec(filter, thisVeriCount, true, veriType);
                sql1 = this._getTotalSql_Rec(filter, thisVeriCount, false, veriType);
                break;
            }
            case 9: {
                sql = this._getTotalSql_APBill(filter, thisVeriCount, true);
                sql1 = this._getTotalSql_APBill(filter, thisVeriCount, false);
                break;
            }
            case 4: {
                sql = this._getTotalSql_Pay(filter, thisVeriCount, true);
                sql1 = this._getTotalSql_Pay(filter, thisVeriCount, false);
                break;
            }
            case 5: {
                sql = this._getTotalSql_Pay(filter, thisVeriCount, true);
                sql1 = this._getTotalSql_Pay(filter, thisVeriCount, false);
                break;
            }
            case 7: {
                sql = this._getTotalSql_Rec(filter, thisVeriCount, true, veriType);
                sql1 = this._getTotalSql_Rec(filter, thisVeriCount, false, veriType);
                break;
            }
            default: {
                return null;
            }
        }
        try {
            preStmt = conn.prepareStatement(sql);
            rs = preStmt.executeQuery();
            if (rs.next()) {
                total = rs.getBigDecimal(1);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)preStmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)preStmt);
        return total;
    }

    private FilterInfo _transferToPayFilterInfo(HashMap filter) {
        boolean fMatchNumUseLike;
        FilterInfo filters = new FilterInfo();
        StringBuffer maskStr = new StringBuffer();
        int i = 0;
        filters.getFilterItems().add(new FilterItemInfo("t1.FBillStatus", (Object)Integer.valueOf(String.valueOf(15))));
        filters.getFilterItems().add(new FilterItemInfo("t1.FBillStatus", (Object)Integer.valueOf("16")));
        filters.getFilterItems().add(new FilterItemInfo("t1.FSourceType", (Object)Integer.valueOf(String.valueOf(100))));
        filters.getFilterItems().add(new FilterItemInfo("t1.FSourceType", (Object)Integer.valueOf(String.valueOf(101))));
        maskStr.append("(#0 OR #1) AND (#2 OR #3)");
        if (filter.get("paymenttype") == null || "all".equalsIgnoreCase(filter.get("paymenttype").toString())) {
            filters.getFilterItems().add(new FilterItemInfo("t7.FIsProxyPay", (Object)Boolean.FALSE, CompareType.EQUALS));
            filters.getFilterItems().add(new FilterItemInfo("t7.FIsProxyPay", (Object)Boolean.FALSE, CompareType.EQUALS));
            maskStr.append(" AND #4 AND #5 ");
            i = 6;
        } else if ("payment".equalsIgnoreCase(filter.get("paymenttype").toString())) {
            filters.getFilterItems().add(new FilterItemInfo("t7.FIsProxyPay", (Object)Boolean.TRUE));
            filters.getFilterItems().add(new FilterItemInfo("t7.FIsProxyPay", (Object)Boolean.TRUE));
            maskStr.append(" AND (#4 OR #5)");
            i = 6;
        } else if ("prepayment".equalsIgnoreCase(filter.get("paymenttype").toString())) {
            filters.getFilterItems().add(new FilterItemInfo("t7.FIsPrePay", (Object)Boolean.TRUE));
            filters.getFilterItems().add(new FilterItemInfo("t7.FIsPrePay", (Object)Boolean.TRUE));
            maskStr.append(" AND (#4 OR #5)");
            i = 6;
        }
        filters.getFilterItems().add(new FilterItemInfo("t2.FUnLockAmt", (Object)this.ZERO, CompareType.NOTEQUALS));
        maskStr.append(" AND #");
        maskStr.append(i++);
        filters.getFilterItems().add(new FilterItemInfo("t1.FCompanyID", filter.get("company")));
        maskStr.append(" AND #");
        maskStr.append(i++);
        if (filter.get("currency") != null) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FCurrencyID", filter.get("currency")));
        }
        if (filter.get("currencyto") != null) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FCurrencyID", filter.get("currencyto")));
        }
        maskStr.append(" AND #");
        maskStr.append(i++);
        if (filter.containsKey("assActType")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FPayeeTypeID", filter.get("assActType")));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("paymenttypeid")) {
            HashSet<String> numberSettemp = new HashSet<String>();
            if (filter.get("paymenttypeid").equals("cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5") || filter.get("paymenttypeid").equals("40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5")) {
                numberSettemp.add("cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5");
                numberSettemp.add("40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5");
                filters.getFilterItems().add(new FilterItemInfo("t1.Fpaymenttypeid", numberSettemp, CompareType.INCLUDE));
                maskStr.append(" AND #");
                maskStr.append(i++);
            } else {
                numberSettemp.add("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5");
                numberSettemp.add("2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5");
                filters.getFilterItems().add(new FilterItemInfo("t1.Fpaymenttypeid", numberSettemp, CompareType.INCLUDE));
                maskStr.append(" AND #");
                maskStr.append(i++);
            }
        }
        if (filter.containsKey("number")) {
            String[] number = filter.get("number").toString().split(";");
            HashSet<String> numberSet = new HashSet<String>();
            for (int j = 0; j < number.length; ++j) {
                numberSet.add(number[j]);
            }
            filters.getFilterItems().add(new FilterItemInfo("t1.FNumber", numberSet, CompareType.INCLUDE));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("assactFrom")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FPayeeNumber", filter.get("assactFrom"), CompareType.GREATER_EQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("assactTo")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FPayeeNumber", filter.get("assactTo"), CompareType.LESS_EQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("startdate")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FBizDate", filter.get("startdate"), CompareType.GREATER_EQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("enddate")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FBizDate", filter.get("enddate"), CompareType.LESS_EQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        boolean bl = fMatchNumUseLike = filter.containsKey("likeQuery") && Boolean.valueOf(filter.get("likeQuery").toString()) != false;
        if (filter.containsKey("coreNum")) {
            CompareType compareType = CompareType.EQUALS;
            String compareVal = filter.get("coreNum").toString();
            if (fMatchNumUseLike) {
                compareType = CompareType.LIKE;
                compareVal = "%" + compareVal + "%";
            }
            filters.getFilterItems().add(new FilterItemInfo("t2.FCoreBillNumber", (Object)compareVal, compareType));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("contractNum")) {
            String compareVal = filter.get("contractNum").toString();
            CompareType compareType = fMatchNumUseLike ? CompareType.LIKE : CompareType.EQUALS;
            compareVal = fMatchNumUseLike ? "%" + compareVal + "%" : compareVal;
            filters.getFilterItems().add(new FilterItemInfo("t2.FContractNumber", (Object)compareVal, compareType));
            maskStr.append(" AND #").append(i++);
        }
        if (filter.containsKey(VERI_BY_CORE)) {
            filters.getFilterItems().add(new FilterItemInfo("t2.FCoreBillNumber", null, CompareType.NOTEQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        filters.setMaskString(maskStr.toString());
        String topSqlQuery = (String)filter.get("topSqlQuery");
        String bottomSqlQuery = (String)filter.get("bottomSqlQuery");
        String sqlQuery = null;
        if (topSqlQuery != null && topSqlQuery.length() > 0) {
            sqlQuery = topSqlQuery;
        } else if (bottomSqlQuery != null && bottomSqlQuery.length() > 0) {
            sqlQuery = bottomSqlQuery;
        }
        FilterInfo whereFilter = null;
        try {
            if (sqlQuery != null && sqlQuery.length() > 0 && sqlQuery.indexOf("WHERE") != -1) {
                String whereCont = "";
                whereCont = sqlQuery.indexOf("ORDER BY") != -1 ? sqlQuery.substring(sqlQuery.indexOf("WHERE"), sqlQuery.indexOf("ORDER BY")) : sqlQuery.substring(sqlQuery.indexOf("WHERE"));
                whereCont = whereCont.substring(5);
                whereCont = whereCont.replaceAll("\"PAYMENTBILL\"", "t1");
                whereCont = whereCont.replaceAll("\"ENTRIES\"", "t2");
                whereCont = whereCont.replaceAll("\"COMPANY\"", "t3");
                whereCont = whereCont.replaceAll("\"CURRENCY\"", "t4");
                whereCont = whereCont.replaceAll("\"PAYEETYPE\"", "t5");
                whereCont = whereCont.replaceAll("\"PAYERACCOUNT\"", "t6");
                whereCont = whereCont.replaceAll("\"PAYBILLTYPE\"", "t7");
                whereCont = whereCont.replaceAll("\"ADMINORGUNIT\"", "t8");
                whereCont = whereCont.replaceAll("\"PERSON\"", "t10");
                whereCont = whereCont.replaceAll("\"VOUCHERTYPE\"", "t12");
                whereCont = whereCont.replaceAll("\"VOUCHER\"", "t13");
                whereFilter = new FilterInfo(whereCont);
            }
            filters.mergeFilter(whereFilter, "AND");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return filters;
    }

    private FilterInfo _transferToRecFilterInfo(HashMap filter) {
        boolean fMatchNumUseLike;
        FilterInfo filters = new FilterInfo();
        StringBuffer maskStr = new StringBuffer();
        int i = 0;
        filters.getFilterItems().add(new FilterItemInfo("t1.FBillStatus", (Object)Integer.valueOf(String.valueOf(14))));
        filters.getFilterItems().add(new FilterItemInfo("t1.FBillStatus", (Object)Integer.valueOf("16")));
        maskStr.append("(#0 OR #1)");
        filters.getFilterItems().add(new FilterItemInfo("t1.FSourceType", (Object)Integer.valueOf(String.valueOf(100))));
        filters.getFilterItems().add(new FilterItemInfo("t1.FSourceType", (Object)Integer.valueOf(String.valueOf(101))));
        maskStr.append(" AND (#2 OR #3)");
        if (filter.get("receivetype") == null || "all".equalsIgnoreCase(filter.get("receivetype").toString())) {
            filters.getFilterItems().add(new FilterItemInfo("t7.FIsProxyRec", (Object)Boolean.FALSE, CompareType.EQUALS));
            filters.getFilterItems().add(new FilterItemInfo("t7.FIsProxyRec", (Object)Boolean.FALSE, CompareType.EQUALS));
            maskStr.append(" AND #4 AND #5 ");
            i = 6;
        } else if ("receive".equalsIgnoreCase(filter.get("receivetype").toString())) {
            i = 6;
            filters.getFilterItems().add(new FilterItemInfo("t7.FIsProxyRec", (Object)Boolean.TRUE));
            filters.getFilterItems().add(new FilterItemInfo("t7.FIsProxyRec", (Object)Boolean.TRUE));
            maskStr.append(" AND (#4 OR #5)");
        } else if ("prereceive".equalsIgnoreCase(filter.get("receivetype").toString())) {
            i = 6;
            filters.getFilterItems().add(new FilterItemInfo("t7.FIsPreRec", (Object)Boolean.TRUE));
            filters.getFilterItems().add(new FilterItemInfo("t7.FIsPreRec", (Object)Boolean.TRUE));
            maskStr.append(" AND (#4 OR #5)");
        } else if ("ar2Rec".equalsIgnoreCase(filter.get("receivetype").toString())) {
            i = 9;
            filters.getFilterItems().add(new FilterItemInfo("t7.FIsSaleRec", (Object)Boolean.TRUE));
            filters.getFilterItems().add(new FilterItemInfo("t7.FIsSaleRec", (Object)Boolean.TRUE));
            filters.getFilterItems().add(new FilterItemInfo("t7.FIsPreRec", (Object)Boolean.TRUE));
            filters.getFilterItems().add(new FilterItemInfo("t7.FIsPreRec", (Object)Boolean.TRUE));
            filters.getFilterItems().add(new FilterItemInfo("t7.FIsPreRec", (Object)Boolean.TRUE));
            maskStr.append(" AND (#4 OR #5 OR #6 OR #7 OR #8)");
        }
        filters.getFilterItems().add(new FilterItemInfo("t2.FUnLockAmt", (Object)this.ZERO, CompareType.NOTEQUALS));
        maskStr.append(" AND #");
        maskStr.append(i++);
        filters.getFilterItems().add(new FilterItemInfo("t1.FCompanyID", filter.get("company")));
        maskStr.append(" AND #");
        maskStr.append(i++);
        if (filter.get("currency") != null) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FCurrencyID", filter.get("currency")));
        }
        if (filter.get("currencyto") != null) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FCurrencyID", filter.get("currencyto")));
        }
        maskStr.append(" AND #");
        maskStr.append(i++);
        if (filter.containsKey("assActType")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FPayerTypeID", filter.get("assActType")));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("paymenttypeid")) {
            HashSet<String> numberSettemp = new HashSet<String>();
            if (filter.get("paymenttypeid").equals("cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5") || filter.get("paymenttypeid").equals("40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5")) {
                numberSettemp.add("cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5");
                numberSettemp.add("40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5");
                filters.getFilterItems().add(new FilterItemInfo("t1.Fpaymenttypeid", numberSettemp, CompareType.INCLUDE));
                maskStr.append(" AND #");
                maskStr.append(i++);
            } else {
                numberSettemp.add("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5");
                numberSettemp.add("2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5");
                filters.getFilterItems().add(new FilterItemInfo("t1.Fpaymenttypeid", numberSettemp, CompareType.INCLUDE));
                maskStr.append(" AND #");
                maskStr.append(i++);
            }
        }
        if (filter.containsKey("number")) {
            String[] number = filter.get("number").toString().split(";");
            HashSet<String> numberSet = new HashSet<String>();
            for (int j = 0; j < number.length; ++j) {
                numberSet.add(number[j]);
            }
            filters.getFilterItems().add(new FilterItemInfo("t1.FNumber", numberSet, CompareType.INCLUDE));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("assactFrom")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FPayerNumber", filter.get("assactFrom"), CompareType.GREATER_EQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("assactTo")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FPayerNumber", filter.get("assactTo"), CompareType.LESS_EQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("startdate")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FBizDate", filter.get("startdate"), CompareType.GREATER_EQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("enddate")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FBizDate", filter.get("enddate"), CompareType.LESS_EQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        boolean bl = fMatchNumUseLike = filter.containsKey("likeQuery") && Boolean.valueOf(filter.get("likeQuery").toString()) != false;
        if (filter.containsKey("coreNum")) {
            CompareType compareType = CompareType.EQUALS;
            String compareVal = filter.get("coreNum").toString();
            if (fMatchNumUseLike) {
                compareType = CompareType.LIKE;
                compareVal = "%" + compareVal + "%";
            }
            filters.getFilterItems().add(new FilterItemInfo("t2.FCoreBillNumber", (Object)compareVal, compareType));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("contractNum")) {
            String compareVal = filter.get("contractNum").toString();
            CompareType compareType = fMatchNumUseLike ? CompareType.LIKE : CompareType.EQUALS;
            compareVal = fMatchNumUseLike ? "%" + compareVal + "%" : compareVal;
            filters.getFilterItems().add(new FilterItemInfo("t2.FContractNumber", (Object)compareVal, compareType));
            maskStr.append(" AND #").append(i++);
        }
        if (filter.containsKey(VERI_BY_CORE)) {
            filters.getFilterItems().add(new FilterItemInfo("t2.FCoreBillNumber", null, CompareType.NOTEQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.get("headOnly") instanceof Boolean && filter.get("mixEntryVerify") instanceof Integer) {
            Integer mixEntryVerify = (Integer)filter.get("mixEntryVerify");
            Integer mixEntryVerify2 = Integer.valueOf("0");
            if (filter.get("mixEntryVerify2") instanceof Integer) {
                mixEntryVerify2 = (Integer)filter.get("mixEntryVerify2");
            }
            filters.getFilterItems().add(new FilterItemInfo("t1.FMixEntryVerify", (Object)mixEntryVerify, CompareType.EQUALS));
            filters.getFilterItems().add(new FilterItemInfo("t1.FMixEntryVerify", (Object)mixEntryVerify2, CompareType.EQUALS));
            filters.getFilterItems().add(new FilterItemInfo("t1.FMixEntryVerify", (Object)Integer.valueOf("0"), CompareType.EQUALS));
            maskStr.append(" AND (#").append(i++).append(" OR #").append(i++).append(" OR #").append(i++).append(")");
        }
        filters.setMaskString(maskStr.toString());
        String topSqlQuery = (String)filter.get("topSqlQuery");
        String bottomSqlQuery = (String)filter.get("bottomSqlQuery");
        String sqlQuery = null;
        if (topSqlQuery != null && topSqlQuery.length() > 0) {
            sqlQuery = topSqlQuery;
        } else if (bottomSqlQuery != null && bottomSqlQuery.length() > 0) {
            sqlQuery = bottomSqlQuery;
        }
        FilterInfo whereFilter = null;
        try {
            if (sqlQuery != null && sqlQuery.length() > 0 && sqlQuery.indexOf("WHERE") != -1) {
                String whereCont = "";
                whereCont = sqlQuery.indexOf("ORDER BY") != -1 ? sqlQuery.substring(sqlQuery.indexOf("WHERE"), sqlQuery.indexOf("ORDER BY")) : sqlQuery.substring(sqlQuery.indexOf("WHERE"));
                whereCont = whereCont.substring(5);
                whereCont = whereCont.replaceAll("\"RECEIVINGBILL\"", "t1");
                whereCont = whereCont.replaceAll("\"ENTRIES\"", "t2");
                whereCont = whereCont.replaceAll("\"COMPANY\"", "t3");
                whereCont = whereCont.replaceAll("\"CURRENCY\"", "t4");
                whereCont = whereCont.replaceAll("\"PAYERTYPE\"", "t5");
                whereCont = whereCont.replaceAll("\"PAYEEACCOUNT\"", "t6");
                whereCont = whereCont.replaceAll("\"ENTRYRECBILLTYPE\"", "t7");
                whereCont = whereCont.replaceAll("\"ADMINORGUNIT\"", "t8");
                whereCont = whereCont.replaceAll("\"PERSON\"", "t10");
                whereCont = whereCont.replaceAll("\"VOUCHERTYPE\"", "t12");
                whereCont = whereCont.replaceAll("\"VOUCHER\"", "t13");
                whereFilter = new FilterInfo(whereCont);
            }
            filters.mergeFilter(whereFilter, "AND");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return filters;
    }

    @Override
    protected Map _getApBill(Context ctx, HashMap filter) throws BOSException, EASBizException {
        String lang = ctx.getLocale().getLanguage();
        boolean isBill = filter.get("isBill") == null ? false : (Boolean)filter.get("isBill");
        String topSqlQuery = (String)filter.get("topSqlQuery");
        String bottomSqlQuery = (String)filter.get("bottomSqlQuery");
        String sqlQuery = null;
        if (topSqlQuery != null && topSqlQuery.length() > 0) {
            sqlQuery = topSqlQuery;
        } else if (bottomSqlQuery != null && bottomSqlQuery.length() > 0) {
            sqlQuery = bottomSqlQuery;
        }
        String pageRowCount = filter.get("pageRowCount") == null ? "1000" : filter.get("pageRowCount").toString();
        String startIndex = filter.get("startIndex") == null ? "0" : filter.get("startIndex").toString();
        String endIndex = filter.get("endIndex") == null ? pageRowCount : filter.get("endIndex").toString();
        StringBuffer sb = new StringBuffer("select top ");
        sb.append(endIndex);
        sb.append(" t1.fid as billid,");
        sb.append("t3.fid as company_id,");
        sb.append("t3.FName_").append(lang).append(" as company_name,");
        sb.append("9 as billtype,");
        sb.append("t1.FBillType as billsubtype,");
        sb.append("t1.fnumber as b_number,");
        sb.append("t1.FBillDate as billdate,");
        sb.append("t4.fid as acctCussType_id,");
        sb.append("t4.FName_").append(lang).append(" as acctCussType_name,");
        sb.append("t4.fnumber as acctCussType_number,");
        sb.append("t1.FAsstActID as acctCuss_id,");
        sb.append("t1.FAsstActName_").append(lang).append(" as acctCuss_name,");
        sb.append("t1.FcurrencyID as currency_id,");
        sb.append("t5.FName_").append(lang).append(" as currency_name,");
        sb.append("t5.fnumber as currency_number,");
        sb.append("t2.fid as entryid,");
        sb.append("t6.FID as accountid,");
        sb.append("t6.FNumber as accountnumber,");
        sb.append("t6.FName_").append(lang).append(" as accountname,");
        sb.append("t2.FOppAccountID as oppAccount,");
        sb.append("t1.FExchangeRate as exchangerate,");
        if (isBill) {
            sb.append("t1.FAmount as billamt,");
            sb.append("t1.FAmountLocal as billamtloc,");
        } else {
            sb.append("t2.FRecievePayAmount as billamt,");
            sb.append("t2.FRecievePayAmountLocal as billamtloc,");
        }
        sb.append("t2.FLockVerifyAmt as verificateamt,");
        sb.append("t2.FLockVerifyAmtLocal as verificateamtloc,");
        sb.append("t2.FLockUnVerifyAmt as unverificateamt,");
        sb.append("t2.FLockUnVerifyAmtLocal as unverificateamtloc,");
        sb.append("t1.FAbstractName as description ");
        sb.append(",t1.FAdminOrgUnitID as FAdminOrgUnitID ");
        sb.append(",t9.FName_").append(ctx.getLocale().getLanguage()).append(" as FAdminOrgUnitName ");
        sb.append(",t1.FPersonID as FPersonID ");
        sb.append(",t10.FName_").append(lang).append(" as FPerson ");
        sb.append(",t2.FCoreBillNumber as coreBillNumber ");
        sb.append(", t2.FCoreBillEntrySeq as coreBillEntrySeq ");
        sb.append(", t2.FContractNumber as contractNum ");
        sb.append(", t2.FContractEntrySeq as contractEntrySeq ");
        sb.append(",t7.FID as FMaterialID ");
        sb.append(",t7.FNumber as FMaterialNumber ");
        sb.append(",case isnull(t2.FMaterialID,'') when '' then t2.FMaterialName else ");
        sb.append(" t7.FName_").append(lang).append(" end as FMaterialName ");
        sb.append(",t8.FID as FExpenseItemID ");
        sb.append(",t8.FNumber as FExpenseItemNumber ");
        sb.append(",t8.FName_").append(lang).append(" as FExpenseItemName ");
        sb.append(",t11.FName_").append(lang).append(" as FVOUCHERTYPE ");
        sb.append(",t12.FNumber as FVOUCHERNUM ");
        sb.append(",PAYMENTTYPE.FID as PAYMENTTYPEID ");
        sb.append(",PAYMENTTYPE.FName_").append(lang).append(" as PAYMENTTYPE_name ");
        if (sqlQuery != null && sqlQuery.length() > 0) {
            String fromCont = "";
            fromCont = sqlQuery.indexOf("WHERE") != -1 ? sqlQuery.substring(sqlQuery.indexOf("FROM"), sqlQuery.indexOf("WHERE")) : (sqlQuery.indexOf("ORDER BY") != -1 ? sqlQuery.substring(sqlQuery.indexOf("FROM"), sqlQuery.indexOf("ORDER BY")) : sqlQuery.substring(sqlQuery.indexOf("FROM")));
            fromCont = fromCont.replaceAll("\"OTHERBILL\"", "t1");
            fromCont = fromCont.replaceAll("\"ENTRY\"", "t2");
            fromCont = fromCont.replaceAll("\"COMPANY\"", "t3");
            fromCont = fromCont.replaceAll("\"ASSTACTTYPE\"", "t4");
            fromCont = fromCont.replaceAll("\"CURRENCY\"", "t5");
            fromCont = fromCont.replaceAll("\"ACCOUNT\"", "t6");
            fromCont = fromCont.replaceAll("\"MATERIAL\"", "t7");
            fromCont = fromCont.replaceAll("\"EXPENSEITEM\"", "t8");
            fromCont = fromCont.replaceAll("\"ADMINORGUNIT\"", "t9");
            fromCont = fromCont.replaceAll("\"PERSON\"", "t10");
            fromCont = fromCont.replaceAll("\"VOUCHERTYPE\"", "t11");
            fromCont = fromCont.replaceAll("\"VOUCHER\"", "t12");
            fromCont = fromCont.replaceAll("\"PAYMENTTYPE\"", "PAYMENTTYPE");
            sb.append(fromCont);
        } else {
            sb.append(this.getApBillFieldsExtends(ctx));
            sb.append("FROM T_AP_OtherBill as t1 ");
            sb.append("inner join T_AP_OtherBillEntry AS t2 on t1.fid = t2.FParentID ");
            sb.append("inner join t_org_company AS t3 on t1.FCompanyID = t3.FID ");
            sb.append("inner join T_BD_AsstActType as t4 on t1.FAsstActTypeID = t4.fid ");
            sb.append("inner join t_bd_currency AS t5 on t1.fcurrencyid = t5.FID ");
            sb.append("left join T_BD_AccountView t6 on t2.FAccountID = t6.fid ");
            sb.append("left join T_BD_Material t7 on t2.FMaterialID = t7.fid ");
            sb.append("left join T_BC_ExpenseType t8 on t2.FExpenseItemID = t8.fid ");
            sb.append("left join T_ORG_Admin t9 on t1.FAdminOrgUnitID = t9.fid ");
            sb.append("left join T_BD_Person t10 on t1.FPersonID = t10.fid ");
            sb.append("left join T_BD_VoucherTypes t11 on t1.FVoucherTypeID = t11.fid ");
            sb.append("left join T_GL_Voucher t12 on t1.FVoucherID = t12.fid ");
            sb.append("left join T_BD_PaymentType PAYMENTTYPE on t1.FPaymentTypeID = PAYMENTTYPE.fid ");
            sb.append(this.getApBillJoinTableExtends(ctx));
        }
        sb.append(" where (t2.FLockUnVerifyAmt <> 0) AND t1.FBillStatus = 3 AND ");
        sb.append(this._transferToARAPFilterStr(filter));
        sb.append(this.getApBillWhereExtends(ctx, filter));
        HashMap<String, String> result = new HashMap<String, String>();
        String sqlSum = sb.substring(sb.indexOf("FROM"));
        if (!filter.containsKey("sqlSum") || !sqlSum.equals(filter.get("sqlSum"))) {
            result.put("sqlSum", "SELECT SUM(t2.FLockUnVerifyAmt), SUM(t2.FLockUnVerifyAmtLocal) " + sqlSum);
        }
        sb.append(" order by billdate ASC, t1.Fnumber ASC");
        if (isBill && filter.containsKey("rowCount")) {
            startIndex = filter.get("rowCount").toString();
        }
        return this.getRowSet(ctx, Integer.valueOf(startIndex), Integer.valueOf(pageRowCount), isBill, sb.toString(), result);
    }

    private String _transferToARAPFilterStr(HashMap filter) {
        return this._transferToARAPFilterInfo(filter).toString();
    }

    private FilterInfo _transferToARAPFilterInfo(HashMap filter) {
        boolean fMatchNumUseLike;
        FilterInfo filters = new FilterInfo();
        int i = 0;
        StringBuffer maskStr = new StringBuffer();
        filters.getFilterItems().add(new FilterItemInfo("t2.FLockUnVerifyAmt", (Object)this.ZERO, CompareType.NOTEQUALS));
        filters.getFilterItems().add(new FilterItemInfo("t1.FBillStatus", (Object)Integer.valueOf(String.valueOf(3))));
        filters.getFilterItems().add(new FilterItemInfo("t1.FCompanyID", filter.get("company")));
        filters.getFilterItems().add(new FilterItemInfo("t1.FIsBizBill", (Object)Integer.valueOf("0")));
        maskStr.append("#0 AND #1 AND #2 AND #3");
        i = 4;
        if (filter.get("currency") != null) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FCurrencyID", filter.get("currency")));
        }
        if (filter.get("currencyto") != null) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FCurrencyID", filter.get("currencyto")));
        }
        maskStr.append(" AND #");
        maskStr.append(i++);
        if (filter.containsKey("paymenttypeid")) {
            HashSet<String> numberSettemp = new HashSet<String>();
            if (filter.get("paymenttypeid").equals("cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5") || filter.get("paymenttypeid").equals("40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5")) {
                numberSettemp.add("cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5");
                numberSettemp.add("40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5");
                filters.getFilterItems().add(new FilterItemInfo("t1.Fpaymenttypeid", numberSettemp, CompareType.INCLUDE));
                maskStr.append(" AND #");
                maskStr.append(i++);
            } else {
                numberSettemp.add("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5");
                numberSettemp.add("2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5");
                filters.getFilterItems().add(new FilterItemInfo("t1.Fpaymenttypeid", numberSettemp, CompareType.INCLUDE));
                maskStr.append(" AND #");
                maskStr.append(i++);
            }
        }
        if (filter.containsKey("assActType")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FAsstActTypeID", filter.get("assActType")));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("number")) {
            String[] number = filter.get("number").toString().split(";");
            HashSet<String> numberSet = new HashSet<String>();
            for (int j = 0; j < number.length; ++j) {
                numberSet.add(number[j]);
            }
            filters.getFilterItems().add(new FilterItemInfo("t1.FNumber", numberSet, CompareType.INCLUDE));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("assactFrom")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FAsstActNumber", filter.get("assactFrom"), CompareType.GREATER_EQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("assactTo")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FAsstActNumber", filter.get("assactTo"), CompareType.LESS_EQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("startdate")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FBillDate", filter.get("startdate"), CompareType.GREATER_EQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("enddate")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FBillDate", filter.get("enddate"), CompareType.LESS_EQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        boolean bl = fMatchNumUseLike = filter.containsKey("likeQuery") && Boolean.valueOf(filter.get("likeQuery").toString()) != false;
        if (filter.containsKey("coreNum")) {
            CompareType compareType = CompareType.EQUALS;
            String compareVal = filter.get("coreNum").toString();
            if (fMatchNumUseLike) {
                compareType = CompareType.LIKE;
                compareVal = "%" + compareVal + "%";
            }
            filters.getFilterItems().add(new FilterItemInfo("t2.FCoreBillNumber", (Object)compareVal, compareType));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("contractNum")) {
            String compareVal = filter.get("contractNum").toString();
            CompareType compareType = fMatchNumUseLike ? CompareType.LIKE : CompareType.EQUALS;
            compareVal = fMatchNumUseLike ? "%" + compareVal + "%" : compareVal;
            filters.getFilterItems().add(new FilterItemInfo("t2.FContractNumber", (Object)compareVal, compareType));
            maskStr.append(" AND #").append(i++);
        }
        if (filter.containsKey(VERI_BY_CORE)) {
            filters.getFilterItems().add(new FilterItemInfo("t2.FCoreBillNumber", null, CompareType.NOTEQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("isInitializeBill") && filter.containsKey("billDate")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FIsInitializeBill", (Object)Boolean.TRUE, CompareType.EQUALS));
            maskStr.append(" AND (#");
            maskStr.append(i++);
            filters.getFilterItems().add(new FilterItemInfo("t1.FBillDate", filter.get("billDate"), CompareType.GREATER_EQUALS));
            maskStr.append(" OR #");
            maskStr.append(i++).append(")");
        }
        filters.setMaskString(maskStr.toString());
        String topSqlQuery = (String)filter.get("topSqlQuery");
        String bottomSqlQuery = (String)filter.get("bottomSqlQuery");
        String sqlQuery = null;
        if (topSqlQuery != null && topSqlQuery.length() > 0) {
            sqlQuery = topSqlQuery;
        } else if (bottomSqlQuery != null && bottomSqlQuery.length() > 0) {
            sqlQuery = bottomSqlQuery;
        }
        FilterInfo whereFilter = null;
        try {
            if (sqlQuery != null && sqlQuery.length() > 0 && sqlQuery.indexOf("WHERE") != -1) {
                String whereCont = "";
                whereCont = sqlQuery.indexOf("ORDER BY") != -1 ? sqlQuery.substring(sqlQuery.indexOf("WHERE"), sqlQuery.indexOf("ORDER BY")) : sqlQuery.substring(sqlQuery.indexOf("WHERE"));
                whereCont = whereCont.substring(5);
                whereCont = whereCont.replaceAll("\"OTHERBILL\"", "t1");
                whereCont = whereCont.replaceAll("\"ENTRY\"", "t2");
                whereCont = whereCont.replaceAll("\"COMPANY\"", "t3");
                whereCont = whereCont.replaceAll("\"ASSTACTTYPE\"", "t4");
                whereCont = whereCont.replaceAll("\"CURRENCY\"", "t5");
                whereCont = whereCont.replaceAll("\"ACCOUNT\"", "t6");
                whereCont = whereCont.replaceAll("\"MATERIAL\"", "t7");
                whereCont = whereCont.replaceAll("\"EXPENSEITEM\"", "t8");
                whereCont = whereCont.replaceAll("\"ADMINORGUNIT\"", "t9");
                whereCont = whereCont.replaceAll("\"PERSON\"", "t10");
                whereCont = whereCont.replaceAll("\"VOUCHERTYPE\"", "t11");
                whereCont = whereCont.replaceAll("\"VOUCHER\"", "t12");
                whereFilter = new FilterInfo(whereCont);
            }
            filters.mergeFilter(whereFilter, "AND");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return filters;
    }

    @Override
    protected IObjectPK _verification(Context ctx, IObjectValue verificationBill) throws BOSException, EASBizException {
        String bosType;
        IObjectPK pk = VerificationBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)((VerificationBillInfo)verificationBill));
        IBillImageFacade image = BillImageFacadeFactory.getLocalInstance((Context)ctx);
        String imageNumber = image.getImageNumber(bosType = "3C41FD86", pk.toString());
        if (StringUtils.isEmpty((String)imageNumber)) {
            imageNumber = image.genImageNumber(bosType, pk.toString());
        }
        return pk;
    }

    @Override
    protected boolean _unVerification(Context ctx, String[] billIDs) throws BOSException, EASBizException {
        IObjectPK[] col;
        StringBuffer ids = new StringBuffer();
        Set idSet = new HashSet<String>();
        for (int i = 0; i < billIDs.length; ++i) {
            idSet.add(billIDs[i]);
            ids.append("'");
            ids.append(billIDs[i]);
            ids.append("',");
        }
        if (ids.length() > 0) {
            ids.deleteCharAt(ids.length() - 1);
        }
        if ((col = VerificationBillFactory.getLocalInstance(ctx).getPKList("select id, number where id in(" + ids + ") and fivouchered=1")) != null && col.length > 0) {
            throw new ARAPVerifynException(ARAPVerifynException.VERIBILL_HASVOUCHERED);
        }
        IVerificationBill iVerificationBill = VerificationBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        HashSet<Integer> typeSet = new HashSet<Integer>();
        typeSet.add(Integer.valueOf("111"));
        typeSet.add(Integer.valueOf("112"));
        filter.getFilterItems().add(new FilterItemInfo("verificationType", typeSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isReversed", (Object)false));
        filter.getFilterItems().add(new FilterItemInfo("isReverseBill", (Object)false));
        view.setFilter(filter);
        VerificationBillCollection badAcctBackColl = iVerificationBill.getVerificationBillCollection(view);
        ArrayList<String> badAcctBackIDList = new ArrayList<String>();
        String badAcctBackID = null;
        for (int i = 0; i < badAcctBackColl.size(); ++i) {
            badAcctBackID = badAcctBackColl.get(i).getId().toString();
            badAcctBackIDList.add(badAcctBackID);
            if (!idSet.contains(badAcctBackID)) continue;
            idSet.remove(badAcctBackID);
        }
        if (badAcctBackIDList.size() > 0) {
            BadAcctTakeBackFacadeFactory.getLocalInstance(ctx).UnVerification(badAcctBackIDList);
        }
        if ((idSet = this.checkHasReverse(ctx, idSet)).size() != billIDs.length) {
            Object[] arr = new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"verification_condition_notInclude", (Locale)ctx.getLocale())};
            throw new ARAPVerifynException(ARAPVerifynException.COMMON, arr);
        }
        if (idSet.size() > 0) {
            Object[] objs = idSet.toArray();
            ArrayList<String> al = new ArrayList<String>();
            for (int i = 0; i < objs.length; ++i) {
                if (al.contains(billIDs[i])) continue;
                al.add(billIDs[i]);
            }
            VerificationBillFactory.getLocalInstance(ctx).unVerify(al, true);
        }
        return true;
    }

    private Set checkHasReverse(Context ctx, Set idSet) throws BOSException {
        IVerificationBill iVerificationBill = VerificationBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isReversed", (Object)false));
        filter.getFilterItems().add(new FilterItemInfo("isReverseBill", (Object)false));
        view.setFilter(filter);
        VerificationBillCollection validCol = iVerificationBill.getVerificationBillCollection(view);
        idSet = new HashSet<String>(validCol.size());
        int len = validCol.size();
        for (int i = 0; i < len; ++i) {
            idSet.add(validCol.get(i).getId().toString());
        }
        return idSet;
    }

    @Override
    protected IObjectValue _getAsstActType(Context ctx, String flag) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer("select fid as asst_id,");
        sb.append("fname_").append(ctx.getLocale().getLanguage()).append(" as asst_name,");
        sb.append("fnumber as asst_number,");
        sb.append("fdefaultqueryname as query_name ");
        sb.append("from T_BD_AsstActType where fassthgattribute = ? ");
        ArrayList<String> vs = new ArrayList<String>();
        vs.add(flag);
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])vs.toArray());
        try {
            if (result.next()) {
                AsstActTypeInfo asstActTypeInfo = new AsstActTypeInfo();
                asstActTypeInfo.setId(BOSUuid.read((String)result.getString("asst_id")));
                asstActTypeInfo.setName(result.getString("asst_name"));
                asstActTypeInfo.setNumber(result.getString("asst_number"));
                asstActTypeInfo.setDefaultQueryName(result.getString("query_name"));
                return asstActTypeInfo;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected boolean _isVerified(Context ctx, String billId) throws BOSException, EASBizException {
        if (billId == null || billId.trim().length() == 0) {
            return false;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select fid from T_AR_VerificationBillEntry where FBillID = ? ");
        sb.append(" union all ");
        sb.append("select fid from T_AP_VerificationBillEntry where FBillID = ? ");
        ArrayList<String> vs = new ArrayList<String>();
        vs.add(billId);
        vs.add(billId);
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])vs.toArray());
        try {
            if (result.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return false;
    }

    @Override
    protected IObjectPK _saleVerification(Context ctx, IObjectValue verificationBill) throws BOSException, EASBizException {
        return this._verification(ctx, verificationBill);
    }

    @Override
    protected IObjectPK _ar2ApVerification(Context ctx, IObjectValue verificationBill) throws BOSException, EASBizException {
        return this._verification(ctx, verificationBill);
    }

    @Override
    protected IObjectPK _prepareAr2PrepareAp(Context ctx, IObjectValue verificationBill) throws BOSException, EASBizException {
        return this._verification(ctx, verificationBill);
    }

    @Override
    protected IObjectPK _receive2PayVerification(Context ctx, IObjectValue verificationBill) throws BOSException, EASBizException {
        return this._verification(ctx, verificationBill);
    }

    @Override
    protected int _getReturnFlagFromDB(Context ctx, String userId, boolean isAr) throws BOSException, EASBizException {
        int returnFlag = 0;
        String stAr = isAr ? AR : AP;
        StringBuffer sb = new StringBuffer("select FReturnFlag ");
        sb.append("from T_ARP_VerificationReturn  ");
        sb.append(" where FUserId = '").append(userId).append("' ");
        sb.append(" and FSystem = '").append(stAr).append("' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            if (rs.next()) {
                returnFlag = rs.getInt("FReturnFlag");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return returnFlag;
    }

    @Override
    protected boolean _setReturnFlagToDB(Context ctx, String userId, boolean isAr, int flag) throws BOSException, EASBizException {
        String stAr = isAr ? AR : AP;
        StringBuffer sb = new StringBuffer("select FReturnFlag ");
        sb.append("from T_ARP_VerificationReturn  ");
        sb.append(" where FUserId = '").append(userId).append("' ");
        sb.append(" and FSystem = '").append(stAr).append("' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            if (rs.next()) {
                sb = new StringBuffer("update T_ARP_VerificationReturn ");
                sb.append("set FReturnFlag = ").append(flag);
                sb.append(" where FUserId = '").append(userId).append("' ");
                sb.append(" and FSystem = '").append(stAr).append("' ");
                DbUtil.execute((Context)ctx, (String)sb.toString());
            } else {
                String insertSql = "INSERT INTO T_ARP_VerificationReturn(FUserId ,FSystem ,FReturnFlag) Values('" + userId + "','" + stAr + "'," + flag + ")";
                DbUtil.execute((Context)ctx, (String)insertSql);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return true;
    }

    @Override
    protected Vector _getEntryInfoFromID(Context ctx, String billID, String billType, BigDecimal thisBillVerificationAmt, BigDecimal thisBillVerificationAmtLoc) throws BOSException, EASBizException {
        String tableName = "";
        String tableEntryName = "";
        StringBuffer sb = new StringBuffer();
        String lang = ctx.getLocale().getLanguage();
        if (billType.equals("ArOtherBill") || billType.equals("ApOtherBill")) {
            tableName = billType.equals("ArOtherBill") ? "T_AR_OtherBill" : "T_AP_OtherBill";
            tableEntryName = billType.equals("ArOtherBill") ? "T_AR_OtherBillEntry" : "T_AP_OtherBillEntry";
            sb.append("select ");
            sb.append("t2.FId as entryid,");
            sb.append("t2.FSeq as seq,");
            sb.append("t2.FAccountID as accountid,");
            sb.append("t2.FLockUnVerifyAmt as thisVerificateamt,");
            sb.append("t2.FLockUnVerifyAmtLocal as thisVerificateamtloc,");
            sb.append("t1.FAbstractName as description ,");
            sb.append("case isnull(t2.FExpenseItemID,'11') ");
            sb.append("when '11' then t2.FMaterialID ");
            sb.append("else t2.FExpenseItemID end as materialID,");
            sb.append(" ");
            sb.append("case isnull(t2.FExpenseItemID,'11') ");
            sb.append("when '11' then t7.FNumber ");
            sb.append("else t8.FNumber end as materialNumber , ");
            sb.append("case isnull(t2.FExpenseItemID,'11') ");
            sb.append("when '11' then ").append(" t7.FName_").append(lang).append(" ");
            sb.append("else ").append(" t8.FName_").append(lang).append(" end as materialName ");
            sb.append("from ").append(tableName).append(" as t1 ");
            sb.append("inner join ").append(tableEntryName).append(" as t2 on t1.fid = t2.fparentid ");
            sb.append("left join T_BD_Material t7 on t2.FMaterialID = t7.fid ");
            sb.append("left join T_BC_ExpenseType t8 on t2.FExpenseItemID = t8.fid ");
            sb.append("where t1.FID = '").append(billID).append("' ");
            sb.append("and t2.FLockUnVerifyAmt <> 0 ");
            sb.append("order by t2.FSeq asc ");
        } else if (billType.equals("ReceivingBill") || billType.equals("PaymentBill")) {
            String accountFieldName = "";
            String parentFieldName = "";
            tableName = billType.equals("ReceivingBill") ? "T_CAS_ReceivingBill" : "T_CAS_PaymentBill";
            tableEntryName = billType.equals("ReceivingBill") ? "T_CAS_ReceivingBillEntry" : "T_CAS_PaymentBillEntry";
            accountFieldName = billType.equals("ReceivingBill") ? "FPayeeAccountID" : "FPayerAccountID";
            parentFieldName = billType.equals("ReceivingBill") ? "FReceivingBillID" : "FPaymentBillID";
            sb.append("select ");
            sb.append("t2.FId as entryid,");
            sb.append("t2.FSeq as seq,");
            sb.append("t1.").append(accountFieldName).append(" as accountid,");
            sb.append("t2.FUnLockAmt as thisVerificateamt,");
            sb.append("t2.FUnLockLocAmt as thisVerificateamtloc,");
            sb.append("t1.FDescription as description ,");
            sb.append("null as materialID ,");
            sb.append("null as materialNumber ,");
            sb.append("null as materialName ");
            sb.append("from ").append(tableName).append(" as t1 ");
            sb.append("inner join ").append(tableEntryName).append(" as t2 on t1.fid = t2.").append(parentFieldName).append(" ");
            sb.append("where t1.FID = '").append(billID).append("' ");
            sb.append("and t2.FUnLockAmt <> 0 ");
            sb.append("order by t2.FSeq asc ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        return this.allocateAmount(ctx, (RowSet)rs, billID, thisBillVerificationAmt, thisBillVerificationAmtLoc);
    }

    protected Vector allocateAmount(Context ctx, RowSet rs, String billID, BigDecimal thisBillVerificationAmt, BigDecimal thisBillVerificationAmtLoc) throws SQLDataException {
        HashMap<String, Object> hmResult = null;
        Vector vcResult = new Vector();
        BigDecimal checkAmt = thisBillVerificationAmt;
        BigDecimal checkAmtLoc = thisBillVerificationAmtLoc;
        boolean isContrastFirst = false;
        try {
            BigDecimal thisVerificateAmtLoc;
            BigDecimal thisVerificateAmt;
            HashMap resultMap = this.getResultHashMap(rs);
            rs.beforeFirst();
            BigDecimal entryContrastAmt = this.ZERO;
            BigDecimal entryContrastLocalAmt = this.ZERO;
            while (rs.next()) {
                HashMap rbResult = this.initRBResult(rs, billID);
                BigDecimal thisVerificateAmt2 = rs.getBigDecimal("thisVerificateamt");
                BigDecimal thisVerificateAmtLoc2 = rs.getBigDecimal("thisVerificateamtloc");
                this.setResultHashMap(resultMap, rs.getString("entryid"), "thisVerificateamt", thisVerificateAmt2);
                this.setResultHashMap(resultMap, rs.getString("entryid"), "thisVerificateamtloc", thisVerificateAmtLoc2);
                if (thisBillVerificationAmt.multiply(thisVerificateAmt2).signum() >= 0) continue;
                entryContrastAmt = entryContrastAmt.add(thisVerificateAmt2);
                entryContrastLocalAmt = entryContrastLocalAmt.add(thisVerificateAmtLoc2);
                rbResult.put("thisVerificateamt", thisVerificateAmt2);
                rbResult.put("thisVerificateamtloc", thisVerificateAmtLoc2);
                rbResult.put("materialID", rs.getString("materialID"));
                rbResult.put("materialNumber", rs.getString("materialNumber"));
                rbResult.put("materialName", rs.getString("materialName"));
                vcResult.add(rbResult);
            }
            if (entryContrastAmt.abs().compareTo(this.ZERO) > 0) {
                isContrastFirst = true;
            }
            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"92_ArVerificationFacadeControllerBean", (Locale)ctx.getLocale()) + entryContrastAmt.toString()));
            rs.beforeFirst();
            while (rs.next()) {
                thisVerificateAmt = rs.getBigDecimal("thisVerificateamt");
                thisVerificateAmtLoc = rs.getBigDecimal("thisVerificateamtloc");
                if (thisBillVerificationAmt.multiply(thisVerificateAmt).signum() <= 0 || entryContrastAmt.abs().compareTo(this.ZERO) <= 0 || entryContrastAmt.multiply(thisVerificateAmt).signum() >= 0) continue;
                HashMap rbResult = this.initRBResult(rs, billID);
                if (entryContrastAmt.abs().compareTo(thisVerificateAmt.abs()) > 0) {
                    rbResult.put("thisVerificateamt", thisVerificateAmt);
                    rbResult.put("thisVerificateamtloc", thisVerificateAmtLoc);
                    entryContrastAmt = thisVerificateAmt.add(entryContrastAmt);
                    entryContrastLocalAmt = thisVerificateAmtLoc.add(entryContrastLocalAmt);
                    this.setResultHashMap(resultMap, rs.getString("entryid"), "thisVerificateamt", this.ZERO);
                    this.setResultHashMap(resultMap, rs.getString("entryid"), "thisVerificateamtloc", this.ZERO);
                    logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"93_ArVerificationFacadeControllerBean", (Locale)ctx.getLocale()) + entryContrastAmt.toString()));
                } else {
                    if (thisVerificateAmt.signum() > 0) {
                        rbResult.put("thisVerificateamt", entryContrastAmt.abs());
                        rbResult.put("thisVerificateamtloc", entryContrastLocalAmt.abs());
                    } else {
                        rbResult.put("thisVerificateamt", entryContrastAmt.negate());
                        rbResult.put("thisVerificateamtloc", entryContrastLocalAmt.negate());
                    }
                    this.setResultHashMap(resultMap, rs.getString("entryid"), "thisVerificateamt", thisVerificateAmt.add(entryContrastAmt));
                    this.setResultHashMap(resultMap, rs.getString("entryid"), "thisVerificateamtloc", thisVerificateAmtLoc.add(entryContrastLocalAmt));
                    logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"93_ArVerificationFacadeControllerBean", (Locale)ctx.getLocale()) + entryContrastAmt.negate().toString()));
                    entryContrastAmt = this.ZERO;
                    entryContrastLocalAmt = this.ZERO;
                }
                rbResult.put("materialID", rs.getString("materialID"));
                rbResult.put("materialNumber", rs.getString("materialNumber"));
                rbResult.put("materialName", rs.getString("materialName"));
                vcResult.add(rbResult);
            }
            rs.beforeFirst();
            while (rs.next() && checkAmt.compareTo(this.ZERO) != 0) {
                hmResult = new HashMap<String, Object>();
                thisVerificateAmt = this.ZERO;
                thisVerificateAmtLoc = this.ZERO;
                if (!isContrastFirst) {
                    thisVerificateAmt = rs.getBigDecimal("thisVerificateamt");
                    thisVerificateAmtLoc = rs.getBigDecimal("thisVerificateamtloc");
                } else {
                    thisVerificateAmt = this.getResultHashMapAmt(resultMap, rs.getString("entryid"), "thisVerificateamt");
                    thisVerificateAmtLoc = this.getResultHashMapAmt(resultMap, rs.getString("entryid"), "thisVerificateamt");
                }
                hmResult.put("billID", billID);
                hmResult.put("entryid", rs.getString("entryid"));
                hmResult.put("accountid", rs.getString("accountid"));
                hmResult.put("description", rs.getString("description"));
                hmResult.put("materialID", rs.getString("materialID"));
                hmResult.put("materialNumber", rs.getString("materialNumber"));
                hmResult.put("materialName", rs.getString("materialName"));
                if (thisBillVerificationAmt.signum() > 0 && checkAmt.multiply(thisVerificateAmt).signum() > 0) {
                    if (checkAmt.compareTo(thisVerificateAmt) >= 0) {
                        hmResult.put("thisVerificateamt", thisVerificateAmt);
                        hmResult.put("thisVerificateamtloc", thisVerificateAmtLoc);
                        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"94_ArVerificationFacadeControllerBean", (Locale)ctx.getLocale()) + thisVerificateAmt.toString()));
                        vcResult.add(hmResult);
                        checkAmt = checkAmt.subtract(thisVerificateAmt);
                        checkAmtLoc = checkAmtLoc.subtract(thisVerificateAmtLoc);
                        continue;
                    }
                    hmResult.put("thisVerificateamt", checkAmt);
                    hmResult.put("thisVerificateamtloc", checkAmtLoc);
                    logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"95_ArVerificationFacadeControllerBean", (Locale)ctx.getLocale()) + checkAmt.toString()));
                    vcResult.add(hmResult);
                } else {
                    if (thisBillVerificationAmt.signum() >= 0 || checkAmt.multiply(thisVerificateAmt).signum() <= 0) continue;
                    if (thisVerificateAmt.subtract(checkAmt).signum() >= 0) {
                        hmResult.put("thisVerificateamt", thisVerificateAmt);
                        hmResult.put("thisVerificateamtloc", thisVerificateAmtLoc);
                        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"96_ArVerificationFacadeControllerBean", (Locale)ctx.getLocale()) + thisVerificateAmt.toString()));
                        vcResult.add(hmResult);
                        checkAmt = checkAmt.subtract(thisVerificateAmt);
                        checkAmtLoc = checkAmtLoc.subtract(thisVerificateAmtLoc);
                        continue;
                    }
                    hmResult.put("thisVerificateamt", checkAmt);
                    hmResult.put("thisVerificateamtloc", checkAmtLoc);
                    logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"95_ArVerificationFacadeControllerBean", (Locale)ctx.getLocale()) + checkAmt.toString()));
                    vcResult.add(hmResult);
                }
                break;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return vcResult;
    }

    private BigDecimal getResultHashMapAmt(HashMap resultMap, String entryid, String entryName) {
        Object obj;
        if (resultMap.get(entryid) instanceof HashMap && (obj = ((HashMap)resultMap.get(entryid)).get(entryName)) instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        return this.ZERO;
    }

    private void setResultHashMap(HashMap resultMap, String entryid, String entryName, BigDecimal amt) {
        if (resultMap.get(entryid) instanceof HashMap) {
            ((HashMap)resultMap.get(entryid)).put(entryName, amt);
        }
    }

    private HashMap getResultHashMap(RowSet rs) throws SQLException {
        HashMap resultMap = new HashMap();
        rs.beforeFirst();
        while (rs.next()) {
            HashMap<String, String> entryMap = new HashMap<String, String>();
            entryMap.put("entryid", rs.getString("entryid"));
            entryMap.put("seq", rs.getString("seq"));
            entryMap.put("accountid", rs.getString("accountid"));
            entryMap.put("thisVerificateamt", rs.getString("thisVerificateamt"));
            entryMap.put("thisVerificateamtloc", rs.getString("thisVerificateamtloc"));
            entryMap.put("description", rs.getString("description"));
            resultMap.put(rs.getString("entryid"), entryMap);
        }
        return resultMap;
    }

    private HashMap initRBResult(RowSet rs, String billID) throws SQLException {
        HashMap<String, String> rbResult = new HashMap<String, String>();
        rbResult.put("billID", billID);
        rbResult.put("entryid", rs.getString("entryid"));
        rbResult.put("accountid", rs.getString("accountid"));
        rbResult.put("description", rs.getString("description"));
        return rbResult;
    }

    private void addEntryBatch(PreparedStatement prmtEntry, PreparedStatement prmtMainUpdate, PreparedStatement prmtSecUpdate, int precision, VerificationBillBaseInfo veriBill, NeedVeriBillEntryInfo mainNeedVeriEntry, NeedVeriBillEntryInfo secNeedVeriEntry, String mainID, String secID, boolean isDirectExchange) throws SQLException {
        BigDecimal mainUnVeriAmt = mainNeedVeriEntry.getUnVeriAmt();
        BigDecimal secUnVeriAmt = secNeedVeriEntry.getUnVeriAmt();
        if (mainUnVeriAmt.abs().compareTo(secUnVeriAmt.abs()) > 0) {
            mainUnVeriAmt = secUnVeriAmt;
        } else {
            secUnVeriAmt = mainUnVeriAmt;
        }
        BigDecimal mainUnVeriAmtLoc = null;
        BigDecimal secUnVeriAmtLoc = null;
        if (isDirectExchange) {
            mainUnVeriAmtLoc = mainUnVeriAmt.multiply(mainNeedVeriEntry.getRate()).setScale(precision, 4);
            secUnVeriAmtLoc = secUnVeriAmt.multiply(secNeedVeriEntry.getRate()).setScale(precision, 4);
        } else {
            mainUnVeriAmtLoc = this.ZERO.compareTo(mainNeedVeriEntry.getRate()) != 0 ? mainUnVeriAmt.divide(mainNeedVeriEntry.getRate(), precision, 4) : mainUnVeriAmt.multiply(mainNeedVeriEntry.getRate()).setScale(precision, 4);
            secUnVeriAmtLoc = this.ZERO.compareTo(secNeedVeriEntry.getRate()) != 0 ? secUnVeriAmt.divide(secNeedVeriEntry.getRate(), precision, 4) : secUnVeriAmt.multiply(secNeedVeriEntry.getRate()).setScale(precision, 4);
        }
        prmtEntry.setString(1, mainID);
        prmtEntry.setString(2, veriBill.getId().toString());
        prmtEntry.setInt(3, veriBill.getMainBillType().getValue());
        prmtEntry.setInt(4, this.getVeriSubBillTypeEnum(veriBill.getMainBillType(), mainNeedVeriEntry.getBillSubType(), mainUnVeriAmt).getValue());
        prmtEntry.setBigDecimal(5, mainUnVeriAmt);
        prmtEntry.setBigDecimal(6, mainUnVeriAmtLoc);
        prmtEntry.setBigDecimal(7, secUnVeriAmtLoc.subtract(mainUnVeriAmtLoc));
        prmtEntry.addBatch();
        prmtEntry.setString(1, secID);
        prmtEntry.setString(2, veriBill.getId().toString());
        prmtEntry.setInt(3, veriBill.getSecondBillType().getValue());
        prmtEntry.setInt(4, this.getVeriSubBillTypeEnum(veriBill.getSecondBillType(), secNeedVeriEntry.getBillSubType(), secUnVeriAmt).getValue());
        prmtEntry.setBigDecimal(5, secUnVeriAmt);
        prmtEntry.setBigDecimal(6, secUnVeriAmtLoc);
        prmtEntry.setBigDecimal(7, BaseDataUtil.ZERO);
        prmtEntry.addBatch();
        prmtMainUpdate.setString(1, mainNeedVeriEntry.getBillEntryID());
        prmtMainUpdate.setString(2, mainID);
        if (!this.isMsDB) {
            prmtMainUpdate.setString(3, mainNeedVeriEntry.getBillEntryID());
        }
        prmtMainUpdate.addBatch();
        prmtSecUpdate.setString(1, secNeedVeriEntry.getBillEntryID());
        prmtSecUpdate.setString(2, secID);
        if (!this.isMsDB) {
            prmtSecUpdate.setString(3, secNeedVeriEntry.getBillEntryID());
        }
        prmtSecUpdate.addBatch();
    }

    private VerificateBillTypeEnum getVeriSubBillTypeEnum(VerificateBillTypeEnum veriEnum, String billSubType, BigDecimal veriAmt) {
        VerificateBillTypeEnum subBillType = null;
        switch (veriEnum.getValue()) {
            case 6: {
                subBillType = Helper.getRecPayVeriBillTypeEnum(true, billSubType, veriAmt);
                break;
            }
            case 8: {
                subBillType = Helper.changeBillType(true, Integer.parseInt(billSubType));
                break;
            }
            case 4: {
                subBillType = Helper.getRecPayVeriBillTypeEnum(false, billSubType, veriAmt);
                break;
            }
            case 9: {
                subBillType = Helper.changeBillType(false, Integer.parseInt(billSubType));
                break;
            }
            default: {
                subBillType = veriEnum;
            }
        }
        return subBillType;
    }

    private String getInsertVeriEntrySql(boolean isArVeriBill) {
        String entryTable = null;
        entryTable = isArVeriBill ? "t_ar_verificationbillentry" : "t_ap_verificationbillentry";
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(entryTable);
        sql.append("(FID,");
        sql.append("fparentid,");
        sql.append("FBillType,");
        sql.append("FBillSubType,");
        sql.append("FThisVerificateAmt,");
        sql.append("FThisVerificateAmtLoc,");
        sql.append("FGainAndLoss,");
        sql.append("FBILLID,");
        sql.append("FENTRYID,");
        sql.append("FACCTCUSSTYPEID,");
        sql.append("FACCTCUSSID");
        sql.append(")");
        sql.append("values");
        sql.append("(");
        sql.append("?,?,?,?,");
        sql.append("?,?,?");
        sql.append(",'1','1','1','1'");
        sql.append(")");
        return sql.toString();
    }

    private String getUpdateVeriEntrySql(Context ctx, boolean isArVeriBill, boolean isArAp, String id, String entryID) {
        StringBuffer sql = new StringBuffer();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String entryTable = null;
        String mainTable = null;
        if (isArVeriBill) {
            entryTable = "t_ar_verificationbillentry";
            mainTable = "t_ar_otherbill";
        } else {
            entryTable = "t_ap_verificationbillentry";
            mainTable = "t_ap_otherbill";
        }
        sql.append("update ").append(entryTable).append(" ");
        sql.append("set (");
        sql.append("FBillID,");
        sql.append("FEntryID,");
        sql.append("FBillDate,");
        sql.append("FBillNumber,");
        sql.append("FAcctCussID,");
        sql.append("FAcctCussName_").append(loc).append(",");
        sql.append("FComment,");
        sql.append("FMaterialID,");
        sql.append("FMaterialNumber,");
        sql.append("FMaterialName,");
        sql.append("FAcctCussTypeID,");
        sql.append("FCurrencyID,");
        sql.append("FAccountID,");
        sql.append("FAdminOrgUnitID,");
        sql.append("FPersonID,");
        sql.append("FOppAccountID)");
        sql.append("=");
        sql.append("(");
        sql.append("select ");
        if (isArAp) {
            sql.append("t1.fid as billid,");
            sql.append("t2.fid as entryid,");
            sql.append("t1.FBillDate as billdate,");
            sql.append("t1.fnumber as b_number,");
            sql.append("t1.FAsstActID as acctCuss_id,");
            sql.append("FAsstactName_").append(loc).append(" as acctCuss_name,");
            sql.append("t1.FAbstractName as commentl2,");
            sql.append("case isnull(t2.FExpenseItemID,'11') ");
            sql.append("when '11' then t2.FMaterialID ");
            sql.append("else t2.FExpenseItemID end as materExpID,");
            sql.append("");
            sql.append("case isnull(t2.FExpenseItemID,'11') ");
            sql.append("when '11' then t7.FNumber ");
            sql.append("else t8.FNumber end as materExpNum,");
            sql.append("");
            sql.append("case len(concat(isnull(t2.FExpenseItemID,'1111'),isnull(t2.FMaterialID,'22'))) ");
            sql.append(" when 32 then t7.FName_").append(loc).append(" ");
            sql.append(" when 48 then t7.FName_").append(loc).append(" ");
            sql.append(" when 30 then t8.FName_").append(loc).append(" ");
            sql.append(" when 46 then t8.FName_").append(loc).append(" ");
            sql.append(" when 6 then t2.FMaterialName ");
            sql.append(" end as materExpName,");
            sql.append("t1.FAsstActTypeID,");
            sql.append("t1.FcurrencyID,");
            sql.append("t2.FAccountID,");
            sql.append("t1.FAdminOrgUnitID as FAdminOrgUnitID,");
            sql.append("t1.FPersonID as FPersonID ,");
            sql.append("t2.FOppAccountID as oppAccount ");
            sql.append("from ").append(mainTable).append(" t1 ");
            sql.append("inner join ").append(mainTable).append("entry t2 on t1.fid = t2.fparentid ");
            sql.append("left join T_BD_Material t7 on t2.FMaterialID = t7.fid ");
            sql.append("left join T_BC_ExpenseType t8 on t2.FExpenseItemID = t8.fid ");
        } else {
            sql.append("t1.fid as billid,");
            sql.append("t2.fid as entryid,");
            sql.append("t1.FBizDate as billdate,");
            sql.append("t1.fnumber as b_number,");
            if (isArVeriBill) {
                sql.append("t1.fpayerid as acctCuss_id,");
                sql.append("t1.fpayername as acctCuss_name,\t");
                sql.append("t1.FDescription as comment_l2,");
                sql.append("null,null,null,");
                sql.append("t1.FPayerTypeID,");
                sql.append("t1.FcurrencyID,");
                sql.append("t1.FPayeeAccountID,");
                sql.append("t1.FAdminOrgUnitID as FAdminOrgUnitID,");
                sql.append("t1.FPersonID as FPersonID ,");
                sql.append("t1.FOppAccountID as oppAccount ");
                sql.append("from t_cas_receivingbill t1 ");
                sql.append("inner join t_cas_receivingbillentry t2 on t1.fid = t2.freceivingbillid ");
            } else {
                sql.append("t1.fpayeeid as acctCuss_id,");
                sql.append("t1.fpayeename as acctCuss_name,\t");
                sql.append("t1.FDescription as comment_l2,");
                sql.append("null,null,null,");
                sql.append("t1.FPayeeTypeID,");
                sql.append("t1.FcurrencyID,");
                sql.append("t1.FPayerAccountID,");
                sql.append("t1.FAdminOrgUnitID as FAdminOrgUnitID,");
                sql.append("t1.FPersonID as FPersonID ,");
                sql.append("t1.FOppAccountID as oppAccount ");
                sql.append("from t_cas_paymentbill t1 ");
                sql.append("inner join t_cas_paymentbillentry t2 on t1.fid = t2.fpaymentbillid ");
            }
        }
        sql.append("where t2.fid = ?");
        sql.append(") where ").append(entryTable).append(".fid = ?");
        return sql.toString();
    }

    private String getUpdateVeriEntrySql(Context ctx, boolean isArVeriBill, boolean isArAp) {
        StringBuffer sql = new StringBuffer();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String entryTable = null;
        String mainTable = null;
        if (isArVeriBill) {
            entryTable = "t_ar_verificationbillentry";
            mainTable = "t_ar_otherbill";
        } else {
            entryTable = "t_ap_verificationbillentry";
            mainTable = "t_ap_otherbill";
        }
        sql.append("update ").append(entryTable).append(" ");
        sql.append("set (");
        sql.append("FBillID,");
        sql.append("FEntryID,");
        sql.append("FBillDate,");
        sql.append("FBillNumber,");
        sql.append("FAcctCussID,");
        sql.append("FAcctCussName_").append(loc).append(",");
        sql.append("FComment,");
        sql.append("FMaterialID,");
        sql.append("FMaterialNumber,");
        sql.append("FMaterialName,");
        sql.append("FVeriRecPayTypeId,");
        sql.append("FVeriRecPayTypeNumber,");
        sql.append("FVeriRecPayTypeName,");
        sql.append("FAcctCussTypeID,");
        sql.append("FCurrencyID,");
        sql.append("FAccountID,");
        sql.append("FAdminOrgUnitID,");
        sql.append("FPersonID,");
        sql.append("FOppAccountID)");
        sql.append("=");
        sql.append("(");
        sql.append("select ");
        if (isArAp) {
            sql.append("t1.fid as billid,");
            sql.append("t2.fid as entryid,");
            sql.append("t1.FBillDate as billdate,");
            sql.append("t1.fnumber as b_number,");
            sql.append("t1.FAsstActID as acctCuss_id,");
            sql.append("FAsstactName_").append(loc).append(" as acctCuss_name,");
            sql.append("t1.FAbstractName as commentl2,");
            sql.append("case isnull(t2.FExpenseItemID,'11') ");
            sql.append("when '11' then t2.FMaterialID ");
            sql.append("else t2.FExpenseItemID end as materExpID,");
            sql.append("");
            sql.append("case isnull(t2.FExpenseItemID,'11') ");
            sql.append("when '11' then t7.FNumber ");
            sql.append("else t8.FNumber end as materExpNum,");
            sql.append("");
            sql.append("case isnull(t2.FExpenseItemID,'11') ");
            sql.append("when '11' then t7.FName_").append(loc).append(" ");
            sql.append("else t8.FName_").append(loc).append(" ");
            sql.append(" end as materExpName,");
            sql.append("null,null,null,");
            sql.append("t1.FAsstActTypeID,");
            sql.append("t1.FcurrencyID,");
            sql.append("t2.FAccountID,");
            sql.append("t1.FAdminOrgUnitID as FAdminOrgUnitID,");
            sql.append("t1.FPersonID as FPersonID ,");
            sql.append("t2.FOppAccountID as oppAccount ");
            sql.append("from ").append(mainTable).append(" t1 ");
            sql.append("inner join ").append(mainTable).append("entry t2 on t1.fid = t2.fparentid ");
            sql.append("left join T_BD_Material t7 on t2.FMaterialID = t7.fid ");
            sql.append("left join T_BC_ExpenseType t8 on t2.FExpenseItemID = t8.fid ");
        } else {
            sql.append("t1.fid as billid,");
            sql.append("t2.fid as entryid,");
            sql.append("t1.FBizDate as billdate,");
            sql.append("t1.fnumber as b_number,");
            if (isArVeriBill) {
                sql.append("t1.fpayerid as acctCuss_id,");
                sql.append("t1.fpayername as acctCuss_name,\t");
                sql.append("t1.FDescription as comment_l2,");
                sql.append("null,null,null,");
                sql.append(" t7.FID as FVeriRecPayTypeId ");
                sql.append(", t7.FNumber as FVeriRecPayTypeNumber ");
                sql.append(", t7.FName_").append(ctx.getLocale().getLanguage()).append(" as FVeriRecPayTypeName ,");
                sql.append("t1.FPayerTypeID,");
                sql.append("t1.FcurrencyID,");
                sql.append("t1.FPayeeAccountID,");
                sql.append("t1.FAdminOrgUnitID as FAdminOrgUnitID,");
                sql.append("t1.FPersonID as FPersonID ,");
                sql.append("t1.FOppAccountID as oppAccount ");
                sql.append("from t_cas_receivingbill t1 ");
                sql.append("inner join t_cas_receivingbillentry t2 on t1.fid = t2.freceivingbillid ");
                sql.append("left join t_cas_receivingbilltype as t7 on t2.FRecBillTypeID = t7.FID ");
            } else {
                sql.append("t1.fpayeeid as acctCuss_id,");
                sql.append("t1.fpayeename as acctCuss_name,\t");
                sql.append("t1.FDescription as comment_l2,");
                sql.append("null,null,null,");
                sql.append(" t7.FID as FVeriRecPayTypeId ");
                sql.append(", t7.FNumber as FVeriRecPayTypeNumber ");
                sql.append(", t7.FName_").append(ctx.getLocale().getLanguage()).append(" as FVeriRecPayTypeName ,");
                sql.append("t1.FPayeeTypeID,");
                sql.append("t1.FcurrencyID,");
                sql.append("t1.FPayerAccountID,");
                sql.append("t1.FAdminOrgUnitID as FAdminOrgUnitID,");
                sql.append("t1.FPersonID as FPersonID ,");
                sql.append("t1.FOppAccountID as oppAccount ");
                sql.append("from t_cas_paymentbill t1 ");
                sql.append("inner join t_cas_paymentbillentry t2 on t1.fid = t2.fpaymentbillid ");
                sql.append("left join t_cas_paymentbilltype as t7 on t1.FPayBillTypeID = t7.FID ");
            }
        }
        sql.append("where t2.fid = ?");
        sql.append(") where ").append(entryTable).append(".fid = ?");
        return sql.toString();
    }

    private void addOneBillBatch(PreparedStatement prmt, PreparedStatement prmtUpdate, VerificationBillBaseInfo veriBill, int precision, NeedVeriBillEntryInfo mainNeedVeriEntry, NeedVeriBillEntryInfo secNeedVeriEntry, java.sql.Date maxDate, boolean isDirectExchange) throws SQLDataException, SQLException {
        boolean isSameCode = false;
        VerificationEnum billVeriType = veriBill.getVerificationType();
        if (mainNeedVeriEntry.getBizCode() == null && secNeedVeriEntry.getBizCode() == null || mainNeedVeriEntry.getBizCode() != null && mainNeedVeriEntry.getBizCode().equals(secNeedVeriEntry.getBizCode())) {
            isSameCode = true;
        }
        prmt.setString(1, veriBill.getId().toString());
        prmt.setInt(2, veriBill.getMainBillType().getValue());
        prmt.setInt(3, veriBill.getSecondBillType().getValue());
        prmt.setBoolean(4, isSameCode);
        prmt.setInt(5, billVeriType.getValue());
        prmt.setDate(6, maxDate);
        prmt.setString(7, veriBill.getNumber());
        prmt.addBatch();
        prmtUpdate.setString(1, mainNeedVeriEntry.getBillID());
        prmtUpdate.setString(2, secNeedVeriEntry.getBillID());
        prmtUpdate.setString(3, veriBill.getId().toString());
        if (!this.isMsDB) {
            prmtUpdate.setString(4, mainNeedVeriEntry.getBillID());
            prmtUpdate.setString(5, secNeedVeriEntry.getBillID());
        }
        prmtUpdate.addBatch();
    }

    private String getInsertVeriBillSql(Context ctx, boolean isArVeriBill) {
        StringBuffer insertHeadSql = new StringBuffer();
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        CtrlUnitInfo cUnit = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String billTable = null;
        billTable = isArVeriBill ? "t_ar_verificationbill" : "t_ap_verificationbill";
        insertHeadSql.append("insert into ").append(billTable).append(" ");
        insertHeadSql.append("(fid,FBillType_Main,FBillType_Second, ");
        insertHeadSql.append("FIsSameCurrency,FIsSameCode,FVerificationType, ");
        insertHeadSql.append("FACCTCUSSTYPEID_MAIN,FACCTCUSSID_MAIN,FACCTCUSSNAME_MAIN,FCURRENCYID_MAIN, ");
        insertHeadSql.append("FAcctCussTypeID_Second,FACCTCUSSID_Second,FACCTCUSSNAME_Second,FCURRENCYID_Second, ");
        insertHeadSql.append("FCreatorID,FCreateTime,FBizDate,FControlUnitID,fnumber");
        insertHeadSql.append(")values ");
        insertHeadSql.append("(?,?,?,1,?,?,");
        insertHeadSql.append("'1','1','1','1',");
        insertHeadSql.append("'1','1','1','1',");
        insertHeadSql.append("'").append(user.getId().toString()).append("',");
        insertHeadSql.append("now(),?,");
        insertHeadSql.append("'").append(cUnit.getId()).append("',?");
        insertHeadSql.append(")");
        return insertHeadSql.toString();
    }

    private String getUpdateVeriBillSql(Context ctx, boolean isArVeriBill) {
        String billTable = null;
        billTable = isArVeriBill ? "t_ar_verificationbill" : "t_ap_verificationbill";
        String lang = ctx.getLocale().getLanguage();
        StringBuffer updateBillSql = new StringBuffer();
        updateBillSql.append("update ").append(billTable).append(" ");
        updateBillSql.append("set (fcompanyid,");
        updateBillSql.append("FAcctCussTypeID_Main,FAcctCussName_Main,FAcctCussID_Main, ");
        updateBillSql.append("FCurrencyID_Main,FAcctCussTypeID_Second,FAcctCussName_Second, ");
        updateBillSql.append("FAcctCussID_Second,FCurrencyID_Second) ");
        updateBillSql.append("= ");
        updateBillSql.append("(SELECT arbill.fcompanyid,");
        updateBillSql.append("arbill.fasstacttypeid AS fmainassttype, ");
        updateBillSql.append("arbill.fasstactname_").append(lang).append("  AS fmainasstactname, ");
        updateBillSql.append("arbill.fasstactid AS fmainasstact, ");
        updateBillSql.append("arbill.fcurrencyid, ");
        if (isArVeriBill) {
            updateBillSql.append("recbill.fpayertypeid AS fsecassttype, ");
            updateBillSql.append("recbill.fpayername AS fsecasstactname, ");
            updateBillSql.append("recbill.fpayerid AS fsecasstact, ");
            updateBillSql.append("arbill.fcurrencyid ");
            updateBillSql.append("FROM t_ar_otherbill arbill, ");
            updateBillSql.append("t_cas_receivingbill recbill ");
        } else {
            updateBillSql.append("recbill.fpayeetypeid,");
            updateBillSql.append("recbill.fpayeename,");
            updateBillSql.append("recbill.fpayeeid,");
            updateBillSql.append("arbill.fcurrencyid ");
            updateBillSql.append("FROM t_ap_otherbill arbill, ");
            updateBillSql.append("t_cas_paymentbill recbill ");
        }
        updateBillSql.append("where arBill.fid =? and recBill.fid = ? ");
        updateBillSql.append(") where ").append(billTable).append(".fid = ?");
        return updateBillSql.toString();
    }

    @Override
    protected void _isDataChanged(Context ctx, int billType, Map unverificateamtMap) throws BOSException, EASBizException {
        String unVerifyAmtField = null;
        String relationField = null;
        String tableName = null;
        String mainTableName = null;
        String bill = (String)unverificateamtMap.get("Bill");
        unverificateamtMap.remove("Bill");
        StringBuffer idCondition = new StringBuffer("");
        Iterator itrKey = unverificateamtMap.keySet().iterator();
        while (itrKey.hasNext()) {
            idCondition.append("'").append(itrKey.next().toString()).append("',");
        }
        if (idCondition.length() > 0) {
            idCondition.deleteCharAt(idCondition.length() - 1);
        }
        if (billType == 8) {
            mainTableName = "t_ar_otherbill";
            tableName = "t_ar_otherbillentry";
            relationField = "fparentid";
            unVerifyAmtField = "flockUnverifyAmt";
        } else if (billType == 9) {
            mainTableName = "t_ap_otherbill";
            tableName = "t_ap_otherbillentry";
            relationField = "fparentid";
            unVerifyAmtField = "flockUnverifyAmt";
        } else if (billType == 6) {
            mainTableName = "T_CAS_ReceivingBill";
            tableName = "T_CAS_ReceivingBillEntry";
            relationField = "FReceivingBillID";
            unVerifyAmtField = "FunLockAmt";
        } else if (billType == 4) {
            mainTableName = "T_CAS_PaymentBill";
            tableName = "T_CAS_PaymentBillEntry";
            relationField = "FPaymentBillID";
            unVerifyAmtField = "FunLockAmt";
        }
        StringBuffer sql = new StringBuffer("");
        if (idCondition.toString() == null || idCondition.toString().equals("")) {
            return;
        }
        if (bill != null && !"".equals(bill)) {
            if (bill.equalsIgnoreCase("allBill")) {
                sql.append("select main.fid as id,sum(entry.").append(unVerifyAmtField).append(") as unverificateamt from ").append(tableName);
                sql.append(" as entry inner join ").append(mainTableName).append(" as main on (entry.").append(relationField).append("=main.fid ) ");
                sql.append(" where main.fid in (").append(idCondition.toString()).append(")  group by main.fid");
            } else {
                sql.append("select fid as id,").append(unVerifyAmtField).append(" as unverificateamt from ").append(tableName);
                sql.append(" where fid in (").append(idCondition.toString()).append(")");
            }
        } else {
            sql.append("select fid as id,").append(unVerifyAmtField).append(" as unverificateamt from ").append(tableName);
            sql.append(" where fid in (").append(idCondition.toString()).append(")");
        }
        BigDecimal clientUnVerificateAmt = null;
        BigDecimal unVerificateAmt = null;
        String id = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                unVerificateAmt = rs.getBigDecimal("unverificateamt");
                unVerificateAmt = unVerificateAmt == null ? SysConstant.BIGZERO : unVerificateAmt;
                id = rs.getString("id");
                clientUnVerificateAmt = (BigDecimal)unverificateamtMap.get(id);
                if ((clientUnVerificateAmt = clientUnVerificateAmt == null ? SysConstant.BIGZERO : clientUnVerificateAmt).compareTo(unVerificateAmt) == 0) continue;
                throw new ARAPVerifynException(ARAPVerifynException.DATABASE_DATA_CHANGE);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected void _isGenVoucher(Context ctx, boolean isAr, List idList) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        HashSet idSet = new HashSet();
        boolean isCheckGainAndLoss = ARAPCommonServerFacadeFactory.getLocalInstance((Context)ctx).isCheckGainAndLoss();
        if (isAr) {
            boolean isRecBillCreateVoucher = ArServerUtils.isRecBillCreateVoucher(ctx, company.getId().toString());
            boolean isPreRecAcct = ArServerUtils.isPreRecAcct(ctx, company.getId().toString());
            for (int i = 0; i < idList.size(); ++i) {
                idSet.add(idList.get(i));
            }
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("number"));
            view.getSelector().add(new SelectorItemInfo("company"));
            view.getSelector().add(new SelectorItemInfo("isCashSalePur"));
            view.getSelector().add(new SelectorItemInfo("verificationType"));
            view.getSelector().add(new SelectorItemInfo("entrys.gainAndLoss"));
            view.getSelector().add(new SelectorItemInfo("entrys.billSubType"));
            view.getSelector().add(new SelectorItemInfo("entrys.veriType"));
            view.getSelector().add(new SelectorItemInfo("entrys.gainAndLoss"));
            view.getSelector().add(new SelectorItemInfo("entrys.billID"));
            view.getSelector().add(new SelectorItemInfo("fiVouchered"));
            view.getSelector().add(new SelectorItemInfo("isSameCurrency"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            VerificationBillCollection billColl = VerificationBillFactory.getLocalInstance(ctx).getVerificationBillCollection(view);
            VerificationBillentryCollection entryColl = null;
            for (int i = 0; i < billColl.size(); ++i) {
                boolean isCheck = true;
                if (billColl.get(i).isFiVouchered()) {
                    throw new OtherBillBizException(OtherBillBizException.VOUCHERED);
                }
                entryColl = billColl.get(i).getEntrys();
                boolean isIsSameCurrency = billColl.get(i).isIsSameCurrency();
                if (!isIsSameCurrency) continue;
                boolean hasGainAndLoss = false;
                for (int j = 0; j < entryColl.size(); ++j) {
                    if (entryColl.get(j).getGainAndLoss() != null && entryColl.get(j).getGainAndLoss().compareTo(this.ZERO) == 0) continue;
                    hasGainAndLoss = true;
                    break;
                }
                if (hasGainAndLoss && isCheckGainAndLoss) {
                    isCheck = false;
                }
                if (!isCheck) continue;
                this.checkArVeriGenVoucher(ctx, billColl.get(i), isRecBillCreateVoucher, isPreRecAcct, hasGainAndLoss);
            }
        } else {
            boolean isPayBillCreateVoucher = ApServerUtils.isPayBillCreateVoucher(ctx, company.getId().toString());
            boolean isPrePayAcct = ApServerUtils.isPrePayAcct(ctx, company.getId().toString());
            for (int i = 0; i < idList.size(); ++i) {
                idSet.add(idList.get(i));
            }
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("number"));
            view.getSelector().add(new SelectorItemInfo("company"));
            view.getSelector().add(new SelectorItemInfo("isCashSalePur"));
            view.getSelector().add(new SelectorItemInfo("verificationType"));
            view.getSelector().add(new SelectorItemInfo("entrys.gainAndLoss"));
            view.getSelector().add(new SelectorItemInfo("entrys.billSubType"));
            view.getSelector().add(new SelectorItemInfo("entrys.veriType"));
            view.getSelector().add(new SelectorItemInfo("entrys.gainAndLoss"));
            view.getSelector().add(new SelectorItemInfo("entrys.billID"));
            view.getSelector().add(new SelectorItemInfo("fiVouchered"));
            view.getSelector().add(new SelectorItemInfo("isSameCurrency"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            com.kingdee.eas.fi.ap.VerificationBillCollection billColl = com.kingdee.eas.fi.ap.VerificationBillFactory.getLocalInstance(ctx).getVerificationBillCollection(view);
            com.kingdee.eas.fi.ap.VerificationBillentryCollection entryColl = null;
            for (int i = 0; i < billColl.size(); ++i) {
                boolean isCheck = true;
                if (billColl.get(i).isFiVouchered()) {
                    throw new OtherBillBizException(OtherBillBizException.VOUCHERED);
                }
                entryColl = billColl.get(i).getEntrys();
                boolean isIsSameCurrency = billColl.get(i).isIsSameCurrency();
                if (!isIsSameCurrency) continue;
                boolean hasGainAndLoss = false;
                for (int j = 0; j < entryColl.size(); ++j) {
                    if (entryColl.get(j).getGainAndLoss() != null && entryColl.get(j).getGainAndLoss().compareTo(this.ZERO) == 0) continue;
                    hasGainAndLoss = true;
                    break;
                }
                if (hasGainAndLoss && isCheckGainAndLoss) {
                    isCheck = false;
                }
                if (!isCheck) continue;
                this.checkApVeriGenVoucher(ctx, billColl.get(i), isPayBillCreateVoucher, isPrePayAcct, hasGainAndLoss);
            }
        }
    }

    public void checkArVeriGenVoucher(Context ctx, VerificationBillInfo info, boolean isRecBillCreateVoucher, boolean isPreRecAcct, boolean hasGainAndLoss) throws BOSException, EASBizException {
        Boolean verifyCanVoucher;
        int billType = 0;
        boolean isSaleRec = false;
        boolean isPreRec = false;
        boolean isPosNegPreRec = false;
        boolean isArOtherbill = false;
        boolean iscashbillCreatVoucher = false;
        CompanyOrgUnitInfo company = info.getCompany();
        iscashbillCreatVoucher = ArServerUtils.iscashbillCreatVoucher(ctx, company.getId().toString());
        if (info.isIsCashSalePur() && !iscashbillCreatVoucher) {
            return;
        }
        VerificationBillentryCollection entryCollection = info.getEntrys();
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            VerificationBillentryInfo entryInfo = entryCollection.get(i);
            int billSubType = entryInfo.getBillSubType().getValue();
            if (!isSaleRec && billSubType != 101 && billSubType != 103 && billSubType >= 100) {
                isSaleRec = true;
            }
            if (!(isPreRec || billSubType != 101 && billSubType != 103)) {
                isPreRec = true;
            }
            if (!entryInfo.isVeriType()) continue;
            isPosNegPreRec = true;
            if (billSubType != 2 && billSubType != 8 && billSubType != 11 && billSubType != 17 && billSubType != 115) continue;
            isArOtherbill = true;
        }
        if (isSaleRec && isPreRec) {
            billType = 1;
        } else if (isSaleRec && !isPreRec) {
            billType = 2;
        } else if (!isSaleRec && isPreRec) {
            billType = 3;
        }
        boolean isOneSideVerifyCanVoucher = false;
        if (isPosNegPreRec && (verifyCanVoucher = ArApParamsUtil.getBooleanBackgroundParam(ctx, "ARAP_VERIFY_CAN_VOUCHER")).booleanValue() && !hasGainAndLoss && !info.isIsCashSalePur()) {
            if (isArOtherbill) {
                HashSet<String> billIdSet = new HashSet<String>();
                for (int i = 0; i < entryCollection.size(); ++i) {
                    billIdSet.add(entryCollection.get(i).getBillID().toString());
                }
                if (billIdSet.size() > 0) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("isBizBill", (Object)true, CompareType.EQUALS));
                    if (OtherBillFactory.getLocalInstance(ctx).exists(filter)) {
                        throw new ARAPVerifynException(ARAPVerifynException.BIZBILL_REVERSE_VERIFY_CANNOT_VOUCHER);
                    }
                }
            }
            isOneSideVerifyCanVoucher = true;
        }
        if (isPosNegPreRec && !isOneSideVerifyCanVoucher) {
            if (isArOtherbill) {
                throw new ARAPVerifynException(ARAPVerifynException.ARBILL_ONESIDE_VERI);
            }
            if (isRecBillCreateVoucher && !isArOtherbill) {
                throw new ARAPVerifynException(ARAPVerifynException.VERI_NOT_REC_VOUCHER);
            }
            if (VerificationEnum.Rec_Pay.equals((Object)info.getVerificationType())) {
                throw new ARAPVerifynException(ARAPVerifynException.REC_PAY_ONESIDE_VERI);
            }
        }
        if (info.getVerificationType().getValue() != 101) {
            return;
        }
        if (isOneSideVerifyCanVoucher) {
            return;
        }
        Object[] params = new Object[]{info.getNumber()};
        if (isRecBillCreateVoucher && !isPreRecAcct) {
            if (billType >= 1) {
                throw new ARAPVerifynException(ARAPVerifynException.REC_NOT_PRE_REC, params);
            }
        } else if (isRecBillCreateVoucher && isPreRecAcct) {
            if (billType == 2) {
                throw new ARAPVerifynException(ARAPVerifynException.REC_PRE_REC, params);
            }
        } else if (!isRecBillCreateVoucher && !isPreRecAcct && billType == 3) {
            throw new ARAPVerifynException(ARAPVerifynException.VERI_NOT_PRE_REC, params);
        }
        if (isRecBillCreateVoucher || isPreRecAcct) {
            // empty if block
        }
    }

    public void checkApVeriGenVoucher(Context ctx, com.kingdee.eas.fi.ap.VerificationBillInfo info, boolean isPayBillCreateVoucher, boolean isPrePayAcct, Boolean hasGainAndLoss) throws BOSException, EASBizException {
        Boolean verifyCanVoucher;
        int billType = 0;
        boolean isPurPay = false;
        boolean isPrePay = false;
        boolean isPosNegPrePay = false;
        boolean isApOtherbill = false;
        boolean iscashbillCreatVoucher = false;
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        iscashbillCreatVoucher = ApServerUtils.iscashbillCreatVoucher(ctx, company.getId().toString());
        com.kingdee.eas.fi.ap.VerificationBillentryCollection entryCollection = info.getEntrys();
        if (info.isIsCashSalePur() && !iscashbillCreatVoucher) {
            return;
        }
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            com.kingdee.eas.fi.ap.VerificationBillentryInfo entryInfo = entryCollection.get(i);
            int billSubType = entryInfo.getBillSubType().getValue();
            if (!isPurPay && billSubType != 202 && billSubType != 204 && billSubType != 213 && billSubType >= 201) {
                isPurPay = true;
            }
            if (!(isPrePay || billSubType != 202 && billSubType != 204)) {
                isPrePay = true;
            }
            if (!entryInfo.isVeriType()) continue;
            isPosNegPrePay = true;
            if (billSubType != 0 && billSubType != 9 && billSubType != 10 && billSubType != 17 && billSubType != 213) continue;
            isApOtherbill = true;
        }
        if (isPurPay && isPrePay) {
            billType = 1;
        } else if (isPurPay && !isPrePay) {
            billType = 2;
        } else if (!isPurPay && isPrePay) {
            billType = 3;
        }
        boolean isOneSideVerifyCanVoucher = false;
        if (isPosNegPrePay && (verifyCanVoucher = ArApParamsUtil.getBooleanBackgroundParam(ctx, "ARAP_VERIFY_CAN_VOUCHER")).booleanValue() && !hasGainAndLoss.booleanValue() && !info.isIsCashSalePur()) {
            if (isApOtherbill) {
                HashSet<String> billIdSet = new HashSet<String>();
                for (int i = 0; i < entryCollection.size(); ++i) {
                    billIdSet.add(entryCollection.get(i).getBillID().toString());
                }
                if (billIdSet.size() > 0) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("isBizBill", (Object)true, CompareType.EQUALS));
                    if (com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx).exists(filter)) {
                        throw new ARAPVerifynException(ARAPVerifynException.BIZBILL_REVERSE_VERIFY_CANNOT_VOUCHER);
                    }
                }
            }
            isOneSideVerifyCanVoucher = true;
        }
        if (isPosNegPrePay && !isOneSideVerifyCanVoucher) {
            if (isApOtherbill) {
                throw new ARAPVerifynException(ARAPVerifynException.APBILL_ONESIDE_VERI);
            }
            if (isPayBillCreateVoucher && !isApOtherbill) {
                throw new ARAPVerifynException(ARAPVerifynException.VERI_NOT_PAY_VOUCHER);
            }
            if (VerificationEnum.Pay_Rec.equals((Object)info.getVerificationType())) {
                throw new ARAPVerifynException(ARAPVerifynException.PAY_REC_ONESIDE_VERI);
            }
        }
        if (info.getVerificationType().getValue() != 201) {
            return;
        }
        if (isOneSideVerifyCanVoucher) {
            return;
        }
        Object[] params = new Object[]{info.getNumber()};
        if (isPayBillCreateVoucher && !isPrePayAcct) {
            if (billType >= 1) {
                throw new ARAPVerifynException(ARAPVerifynException.PAY_NOT_PRE_PAY, params);
            }
        } else if (isPayBillCreateVoucher && isPrePayAcct) {
            if (billType == 2) {
                throw new ARAPVerifynException(ARAPVerifynException.PAY_PRE_PAY, params);
            }
        } else if (!isPayBillCreateVoucher && !isPrePayAcct && billType == 3) {
            throw new ARAPVerifynException(ARAPVerifynException.VERI_NOT_PRE_PAY, params);
        }
        if (isPayBillCreateVoucher || isPrePayAcct) {
            // empty if block
        }
    }

    public Map getRowSet(Context ctx, int startIndex, int pageRowCount, boolean isBill, String sql, Map result) throws BOSException {
        try {
            JdbcRowSet rowSet = null;
            if (isBill) {
                int topCount = startIndex + pageRowCount * 2;
                sql = sql.substring(sql.indexOf("t1.fid"));
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT TOP " + topCount + " " + sql));
                HashSet<String> idSet = new HashSet<String>();
                int rowCount = 0;
                if (startIndex > 0) {
                    rs.absolute(startIndex);
                }
                while (rs.next()) {
                    idSet.add(rs.getString("billid"));
                    ++rowCount;
                    if (idSet.size() > pageRowCount) {
                        rs.beforeFirst();
                        rowSet = new JdbcRowSet();
                        rowSet.populate((ResultSet)rs, startIndex, rowCount - 1, true);
                        break;
                    }
                    if (!rs.isLast()) continue;
                    if (topCount == startIndex + rowCount) {
                        rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT TOP " + (topCount += pageRowCount * 2) + " " + sql));
                        rs.absolute(startIndex + rowCount);
                        if (!rs.isLast()) continue;
                        rs.beforeFirst();
                        rowSet = new JdbcRowSet();
                        rowSet.populate((ResultSet)rs, startIndex, rowCount, true);
                        continue;
                    }
                    rs.beforeFirst();
                    rowSet = new JdbcRowSet();
                    rowSet.populate((ResultSet)rs, startIndex, rowCount, true);
                }
                result.put("rowCount", String.valueOf(startIndex + rowCount - 1));
            } else {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                rowSet = new JdbcRowSet();
                rowSet.populate((ResultSet)rs, startIndex, pageRowCount, true);
            }
            result.put("rowSet", rowSet);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected void _batchCheckDataChanged(Context ctx, Map billMap) throws BOSException, EASBizException {
        for (Object key : billMap.keySet()) {
            int billType = ((VerificateBillTypeEnum)key).getValue();
            Map verificationAmtMap = (Map)billMap.get(key);
            this.isDataChanged(ctx, billType, verificationAmtMap);
        }
    }

    @Override
    protected RowSet _getArVerificationBill(Context ctx, String billID) throws BOSException, EASBizException {
        String lang = ctx.getLocale().getLanguage();
        StringBuffer sb = new StringBuffer("select ");
        sb.append(" VERIFICATIONBILL.FID AS ID,");
        sb.append("COMPANY.FName_").append(lang).append(" AS COMPANY_NAME,");
        sb.append("VERIFICATIONBILL.FNumber AS NUMBER,");
        sb.append("VERIFICATIONBILL.FBizDate AS BIZDATE,");
        sb.append("ENTRYS.FBillDate AS ENTRYS_BILLDATE,");
        sb.append("ENTRYS.FBillNumber AS ENTRYS_BILLNUMBER,");
        sb.append("ENTRYS.FBillType AS ENTRYS_BILLTYPE,");
        sb.append("ENTRYS.FBillSubType AS ENTRYS_BILLSUBTYPE,");
        sb.append("ENTRYS.FVeriRecPayTypeName AS ENTRYS_VERIRECPAYTYPENAME,");
        sb.append("ENTRYS.FAcctCussName_").append(lang).append(" AS ENTRYS_ACCTCUSSNAME,");
        sb.append("ENTRYS.FComment AS ENTRYS_COMMENT,");
        sb.append("ADMINORGUNIT.FName_").append(lang).append(" AS ADMINORGUNIT_NAME,");
        sb.append("PERSON.FName_").append(lang).append(" AS PERSON_NAME,");
        sb.append("CURRENCY.FName_").append(lang).append(" AS CURRENCY_NAME,");
        sb.append("CURRENCY.FPrecision AS CURRENCY_PRECISION,");
        sb.append("ENTRYS.FMaterialNumber AS ENTRYS_MATERIALNUMBER,");
        sb.append("ENTRYS.FMaterialName AS ENTRYS_MATERIALNAME,");
        sb.append("ENTRYS.FThisVerificateAmt AS ENTRYS_THISVERIFICATEAMT,");
        sb.append("ENTRYS.FThisVerificateAmtLoc AS ENTRYS_THISVERIFICATEAMTLOC,");
        sb.append("ENTRYS.FGainAndLoss AS ENTRYS_GAINANDLOSS,");
        sb.append("CREATOR.FName_").append(lang).append(" AS CREATOR_NAME,");
        sb.append("VERIFICATIONBILL.FVerificationType AS VERIFICATIONTYPE,");
        sb.append("VERIFICATIONBILL.FISCASHSALEPUR AS ISCASHSALEPUR,");
        sb.append("VERIFICATIONBILL.FFiVouchered AS FIVOUCHERED,");
        sb.append("VOUCHERTYPE.FName_").append(lang).append(" AS VOUCHERTYPE_NAME,");
        sb.append("VOUCHER.FNumber AS VOUCHER_NUMBER,");
        sb.append("ENTRYS.FBillID AS ENTRYS_BILLID ");
        sb.append(" FROM T_AR_VerificationBill AS VERIFICATIONBILL ");
        sb.append(" INNER JOIN T_AR_VerificationBillentry AS ENTRYS ");
        sb.append(" ON ENTRYS.FParentID = VERIFICATIONBILL.FID ");
        sb.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANY ");
        sb.append(" ON VERIFICATIONBILL.FCompanyID = COMPANY.FID ");
        sb.append(" LEFT OUTER JOIN T_PM_User AS CREATOR");
        sb.append(" ON VERIFICATIONBILL.FCreatorID = CREATOR.FID ");
        sb.append(" LEFT OUTER JOIN T_GL_Voucher AS VOUCHER");
        sb.append(" ON VERIFICATIONBILL.FVoucherID = VOUCHER.FID ");
        sb.append(" LEFT OUTER JOIN T_BD_VoucherTypes AS VOUCHERTYPE ");
        sb.append(" ON VERIFICATIONBILL.FVoucherTypeID = VOUCHERTYPE.FID ");
        sb.append(" LEFT OUTER JOIN T_BD_Currency AS CURRENCY ");
        sb.append(" ON ENTRYS.FCurrencyID = CURRENCY.FID ");
        sb.append(" LEFT OUTER JOIN T_ORG_Admin AS ADMINORGUNIT ");
        sb.append(" ON ENTRYS.FAdminOrgUnitID = ADMINORGUNIT.FID ");
        sb.append(" LEFT OUTER JOIN T_BD_Person AS PERSON ");
        sb.append(" ON ENTRYS.FPersonID = PERSON.FID ");
        sb.append(" WHERE ENTRYS.FParentID in (" + billID + ")");
        sb.append(" ORDER BY NUMBER ASC ");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        return result;
    }

    @Override
    protected Map _getTotalVerifyAmount(Context ctx, HashMap filter) throws BOSException, EASBizException {
        String sqlSum;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String string = sqlSum = filter.containsKey("sqlSum") ? filter.get("sqlSum").toString() : null;
        if (sqlSum != null) {
            result.put("sqlSum", sqlSum);
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlSum);
                if (rs.next()) {
                    result.put("totalThisVerificateAmt", rs.getBigDecimal(1));
                    result.put("totalThisVerificateAmtLoc", rs.getBigDecimal(2));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return result;
    }

    private static class PairForVeriByCoreNum {
        private String coreNum;
        private String coreSeq;
        private ArrayList topEntrys;
        private ArrayList botEntrys;

        public PairForVeriByCoreNum(String coreNum, String coreSeq) {
            this.coreNum = coreNum;
            this.coreSeq = coreSeq;
            this.topEntrys = new ArrayList();
            this.botEntrys = new ArrayList();
        }

        public String getCoreNum() {
            return this.coreNum;
        }

        public String getCoreSeq() {
            return this.coreSeq;
        }

        public void addTopEntrys(NeedVeriBillEntryInfo entryInfo) {
            this.addEntrys(this.topEntrys, entryInfo);
        }

        public void addBotEntrys(NeedVeriBillEntryInfo entryInfo) {
            this.addEntrys(this.botEntrys, entryInfo);
        }

        private void addEntrys(ArrayList entrys, NeedVeriBillEntryInfo entryInfo) {
            if (!entrys.contains(entryInfo)) {
                entrys.add(entryInfo);
            }
        }

        public ArrayList getBotEntrys() {
            return this.botEntrys;
        }

        public ArrayList getTopEntrys() {
            return this.topEntrys;
        }

        public boolean equals(Object obj) {
            boolean retVal = false;
            if (obj instanceof PairForVeriByCoreNum) {
                PairForVeriByCoreNum temp = (PairForVeriByCoreNum)obj;
                if (temp.getCoreNum() != null) {
                    if (temp.getCoreNum().equals(this.getCoreNum())) {
                        if (temp.getCoreSeq() != null) {
                            if (temp.getCoreSeq().equals(this.getCoreSeq())) {
                                retVal = true;
                            }
                        } else if (this.getCoreNum() == null) {
                            retVal = true;
                        }
                    }
                } else if (this.getCoreNum() == null) {
                    if (temp.getCoreSeq() != null) {
                        if (temp.getCoreSeq().equals(this.getCoreSeq())) {
                            retVal = true;
                        }
                    } else if (this.getCoreNum() == null) {
                        retVal = true;
                    }
                }
            }
            return retVal;
        }

        public int hashCode() {
            int retVal = 0;
            if (this.getCoreNum() != null) {
                retVal += this.getCoreNum().hashCode();
            }
            if (this.getCoreSeq() != null) {
                retVal += this.getCoreSeq().hashCode();
            }
            return retVal += "PFVBC".hashCode() * 17;
        }
    }

    private static class NeedVeriBillEntryInfo {
        private String billID = null;
        private String billEntryID = null;
        private String billSubType = null;
        private String bizCode = null;
        private BigDecimal unVeriAmt = null;
        private BigDecimal rate = null;

        public NeedVeriBillEntryInfo(String billID, String entryID, String billSubType, String bizCode, BigDecimal unVeriAmt, BigDecimal rate) {
            this.billID = billID;
            this.billEntryID = entryID;
            this.billSubType = billSubType;
            this.bizCode = bizCode;
            this.unVeriAmt = unVeriAmt;
            this.rate = rate;
        }

        public String getBillID() {
            return this.billID;
        }

        public String getBillSubType() {
            return this.billSubType;
        }

        public String getBillEntryID() {
            return this.billEntryID;
        }

        public BigDecimal getUnVeriAmt() {
            return this.unVeriAmt;
        }

        public boolean equals(Object obj) {
            NeedVeriBillEntryInfo temp;
            boolean retVal = false;
            if (obj instanceof NeedVeriBillEntryInfo && (temp = (NeedVeriBillEntryInfo)obj).getBillEntryID().equals(this.getBillEntryID())) {
                retVal = true;
            }
            return retVal;
        }

        public int hashCode() {
            int retVal = 0;
            retVal += this.getBillEntryID().hashCode();
            return retVal += "NVBEI".hashCode() * 13;
        }

        public void setUnVeriAmt(BigDecimal unVeriAmt) {
            this.unVeriAmt = unVeriAmt;
        }

        public String getBizCode() {
            return this.bizCode;
        }

        public BigDecimal getRate() {
            return this.rate;
        }
    }
}

