/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.ar.SummaryRptQueryParam;
import com.kingdee.eas.fi.ar.app.AbstractArVirtualSumRptFacadeControllerBean;
import com.kingdee.eas.fi.ar.app.ArApBiSumRptHelper;
import com.kingdee.eas.fi.ar.app.ArApReportHelper;
import com.kingdee.eas.fi.arap.app.util.TempTableUtil;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.im.inv.invconfig.SQLDataAccessFacadeFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArVirtualSumRptFacadeControllerBean
extends AbstractArVirtualSumRptFacadeControllerBean {
    private static final long serialVersionUID = -1078316191611404822L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.ArVirtualSumRptFacadeControllerBean");

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        String tempTable = "";
        SummaryRptQueryParam qryParam = (SummaryRptQueryParam)((Object)params.getObject("qryParam"));
        ArApBiSumRptHelper.checkParamValid(qryParam);
        if (!qryParam.isMultiCompanys()) {
            qryParam.setCompanyId(qryParam.getCompanyIds().get(0).toString());
        }
        PeriodCollection periods = null;
        if (qryParam.isByPeriod()) {
            String companyId = qryParam.getCompanyId();
            periods = ArApReportHelper.getPeriodCollection(ctx, (Date)qryParam.getBeginDate(), (Date)qryParam.getEndDate(), companyId);
            if (periods == null || periods.size() == 0) {
                throw new ArApCommonException(ArApCommonException.DATERANGE_INVALID);
            }
        }
        RptTableHeader header = ArApBiSumRptHelper.getRptTableHeader(ctx, qryParam);
        String cussAcctTbl = ArApReportHelper.getCussAcctTempTbl(ctx, qryParam, qryParam.getCompanyIds());
        qryParam.setCussAcctTempTable(cussAcctTbl);
        String compsBalTbl = ArApBiSumRptHelper.getCompanysBalTable(ctx, qryParam, periods);
        String tempTbl = TempTableUtil.createTempTable(ctx, ArApBiSumRptHelper.tempSumBalTblStruct(qryParam));
        TempTablePool t = TempTablePool.getInstance((Context)ctx);
        try {
            t.createIndex(tempTbl, "FAsstActId", false, false);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (qryParam.getTempTable() != null) {
            t.releaseTable(qryParam.getTempTable());
        }
        qryParam.setTempTable(tempTbl);
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer("");
            if ("base".equals(qryParam.getCurrencyId())) {
                sql.append("INSERT INTO ").append(tempTbl);
                sql.append(" (FRowId, FCompanyId, FPeriodId, FBaseCurrencyId, FAsstActTypeID, FAsstActId,");
                sql.append(" FBeginBalanceLocal, FYearDebitLocal, FYearCreditLocal, FDebitLocal, FCreditLocal, FPeriodBalLocal)");
                sql.append(" SELECT newbosid('88888888'), FCompanyId, FPeriodId, FBaseCurrencyId, FAsstActTypeID, FAsstActId,");
                sql.append(" FBeginBalanceLocal, FYearDebitLocal, FYearCreditLocal, FDebitLocal, FCreditLocal, FPeriodBalLocal");
                sql.append(" FROM ").append(compsBalTbl).append(" WHERE FIsFinal = 1");
            } else if (!"base".equals(qryParam.getCurrencyId()) && !qryParam.isBaseCurrency()) {
                sql.append("INSERT INTO ").append(tempTbl);
                sql.append(" (FRowId, FCompanyId, FPeriodId, FCurrencyId, FAsstActTypeID, FAsstActId,");
                sql.append(" FPeriodStartBal, FYearDebit, FYearCredit, FPeriodDebit, FPeriodCredit, FPeriodBal)");
                sql.append(" SELECT newbosid('88888888'), FCompanyId, FPeriodId, FCurrencyId, FAsstActTypeID, FAsstActId,");
                sql.append(" FPeriodStartBal, FYearDebit, FYearCredit, FPeriodDebit, FPeriodCredit, FPeriodBal");
                sql.append(" FROM ").append(compsBalTbl).append(" WHERE FIsFinal = 1");
            } else if (!"base".equals(qryParam.getCurrencyId()) && qryParam.isBaseCurrency()) {
                sql.append("INSERT INTO ").append(tempTbl);
                sql.append(" (FRowId, FCompanyId, FPeriodId, FCurrencyId, FBaseCurrencyID, FAsstActTypeID, FAsstActId,");
                sql.append(" FPeriodStartBal, FBeginBalanceLocal, FYearDebit, FYearDebitLocal, FYearCredit, FYearCreditLocal, FPeriodDebit, FDebitLocal, FPeriodCredit, FCreditLocal, FPeriodBal, FPeriodBalLocal)");
                sql.append(" SELECT newbosid('88888888'), FCompanyId, FPeriodId, FCurrencyId, FBaseCurrencyID, FAsstActTypeID, FAsstActId,");
                sql.append(" FPeriodStartBal, FBeginBalanceLocal, FYearDebit, FYearDebitLocal, FYearCredit, FYearCreditLocal, FPeriodDebit, FDebitLocal, FPeriodCredit, FCreditLocal, FPeriodBal, FPeriodBalLocal");
                sql.append(" FROM ").append(compsBalTbl).append(" WHERE FIsFinal = 1");
            }
            stmt = conn.createStatement();
            stmt.executeUpdate(sql.toString());
            try {
                t.analyzeTable(conn, tempTbl);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            String nameFld = ArApReportHelper.getNameFld(ctx);
            sql.setLength(0);
            if ("base".equals(qryParam.getCurrencyId())) {
                sql.append("UPDATE ").append(tempTbl).append(" bal ");
                sql.append(" SET (FCompany, FParentCompanyId, FCompLongNumber, FIsCompLeaf, FComplevel,");
                if (qryParam.isByPeriod()) {
                    sql.append(" FPeriodYear, FPeriodNumber,");
                }
                sql.append(" FBaseCurrNum, FBaseCurrency, FBaseCurrPrecision,");
                sql.append(" FAsstActType) = (");
                sql.append("SELECT t2.").append(nameFld).append(", t2.FParentId, t2.FLongNumber, t2.FIsLeaf, t2.FLevel,");
                if (qryParam.isByPeriod()) {
                    sql.append(" t3.FPeriodYear, t3.FPeriodNumber,");
                }
                sql.append(" t4.FNumber, t4.").append(nameFld).append(", t4.FPrecision,");
                sql.append(" t5.").append(nameFld);
                sql.append(" FROM T_ORG_COMPANY t2,");
                if (qryParam.isByPeriod()) {
                    sql.append(" T_BD_PERIOD t3,");
                }
                sql.append(" T_BD_CURRENCY t4, T_BD_ASSTACTTYPE t5");
                sql.append(" WHERE bal.FCompanyId = t2.FID");
                if (qryParam.isByPeriod()) {
                    sql.append(" AND bal.FPeriodID = t3.FID");
                }
                sql.append(" AND bal.FBaseCurrencyID = t4.FID AND bal.FAsstActTypeID = t5.FID)");
            } else if (!"base".equals(qryParam.getCurrencyId()) && !qryParam.isBaseCurrency()) {
                sql.append("UPDATE ").append(tempTbl).append(" bal ");
                sql.append(" SET (FCompany, FParentCompanyId, FCompLongNumber, FIsCompLeaf, FComplevel,");
                if (qryParam.isByPeriod()) {
                    sql.append(" FPeriodYear, FPeriodNumber,");
                }
                sql.append(" FCurrNum, FCurrency, FCurrPrecision,");
                sql.append(" FAsstActType) = (");
                sql.append("SELECT t2.").append(nameFld).append(", t2.FParentId, t2.FLongNumber, t2.FIsLeaf, t2.FLevel,");
                if (qryParam.isByPeriod()) {
                    sql.append(" t3.FPeriodYear, t3.FPeriodNumber,");
                }
                sql.append(" t4.FNumber, t4.").append(nameFld).append(", t4.FPrecision,");
                sql.append(" t5.").append(nameFld);
                sql.append(" FROM T_ORG_COMPANY t2,");
                if (qryParam.isByPeriod()) {
                    sql.append(" T_BD_PERIOD t3,");
                }
                sql.append(" T_BD_CURRENCY t4, T_BD_ASSTACTTYPE t5");
                sql.append(" WHERE bal.FCompanyId = t2.FID");
                if (qryParam.isByPeriod()) {
                    sql.append(" AND bal.FPeriodID = t3.FID");
                }
                sql.append(" AND bal.FCurrencyID = t4.FID AND bal.FAsstActTypeID = t5.FID)");
            } else if (!"base".equals(qryParam.getCurrencyId()) && qryParam.isBaseCurrency()) {
                sql.append("UPDATE ").append(tempTbl).append(" bal ");
                sql.append(" SET (FCompany, FParentCompanyId, FCompLongNumber, FIsCompLeaf, FComplevel,");
                if (qryParam.isByPeriod()) {
                    sql.append(" FPeriodYear, FPeriodNumber,");
                }
                sql.append(" FCurrNum, FCurrency, FCurrPrecision,");
                sql.append(" FBaseCurrNum, FBaseCurrency, FBaseCurrPrecision,");
                sql.append(" FAsstActType) = (");
                sql.append("SELECT t2.").append(nameFld).append(", t2.FParentId, t2.FLongNumber, t2.FIsLeaf, t2.FLevel,");
                if (qryParam.isByPeriod()) {
                    sql.append(" t3.FPeriodYear, t3.FPeriodNumber,");
                }
                sql.append(" t4.FNumber, t4.").append(nameFld).append(", t4.FPrecision,");
                sql.append(" t6.FNumber, t6.").append(nameFld).append(", t6.FPrecision,");
                sql.append(" t5.").append(nameFld);
                sql.append(" FROM T_ORG_COMPANY t2,");
                if (qryParam.isByPeriod()) {
                    sql.append(" T_BD_PERIOD t3,");
                }
                sql.append(" T_BD_CURRENCY t4, T_BD_ASSTACTTYPE t5, T_BD_CURRENCY t6");
                sql.append(" WHERE bal.FCompanyId = t2.FID");
                if (qryParam.isByPeriod()) {
                    sql.append(" AND bal.FPeriodID = t3.FID");
                }
                sql.append(" AND bal.FCurrencyID = t4.FID AND bal.FAsstActTypeID = t5.FID AND bal.FBaseCurrencyID=t6.FID)");
            }
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            tempTable = this.getCussAcctTempTable(ctx, qryParam);
            try {
                t.analyzeTable(conn, tempTable);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (!StringUtils.isEmpty((String)tempTable)) {
                sql.append("UPDATE ").append(tempTbl).append(" bal ");
                sql.append(" SET (FAsstActNumber, FCussAcct) = (");
                sql.append("SELECT FNumber, FName FROM ").append(tempTable).append(" cussact");
                sql.append(" WHERE bal.FAsstActID = cussact.FID)");
                stmt.executeUpdate(sql.toString());
            }
            stmt.executeUpdate(ArVirtualSumRptFacadeControllerBean.getCurrencySumSql(ctx, qryParam));
            if (qryParam.isMultiCompanys()) {
                CompanyOrgUnitCollection virComps = ArVirtualSumRptFacadeControllerBean.getVirtualCompanys(ctx, qryParam);
                ArVirtualSumRptFacadeControllerBean.sumToVirtualCompanys(ctx, qryParam, ArVirtualSumRptFacadeControllerBean.getVirtualCompanys(ctx, qryParam), stmt);
                ArApReportHelper.updateWrongCompanyParentId(ctx, qryParam, qryParam.getCompanyIds(), virComps);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                TempTableUtil.releasTempTable(ctx, compsBalTbl);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        TempTableUtil.releasTempTable(ctx, compsBalTbl);
        RptParams result = new RptParams();
        result.setString("tempTable", tempTbl);
        result.setObject("header", (Object)header);
        return result;
    }

    private static String getCurrencySumSql(Context ctx, SummaryRptQueryParam param) {
        String factTbl = param.getTempTable();
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(factTbl);
        if ("base".equals(param.getCurrencyId())) {
            sql.append("\r\n (FBaseCurrencyId, FBaseCurrPrecision, FBaseCurrNum, ");
            sql.append("FBaseCurrency, FPeriodYear, FPeriodNumber, FAsstActType, FCussAcct, FIsSum, ");
            sql.append("FBeginBalanceLocal, FYearDebitLocal, FYearCreditLocal, FDebitLocal, FCreditLocal, FPeriodBalLocal");
            String sumLbl = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport.Lbl_Sum", (Locale)ctx.getLocale());
            sql.append(")\r\n select FBaseCurrencyId, ");
            sql.append("FBaseCurrPrecision, FBaseCurrNum, FBaseCurrency, FPeriodYear, FPeriodNumber, FAsstActType, N'");
            sql.append(sumLbl).append("' FCussAcct, 1 FIsSum");
            sql.append(", SUM(FBeginBalanceLocal), SUM(FYearDebitLocal), SUM(FYearCreditLocal), SUM(FDebitLocal), SUM(FCreditLocal), SUM(FPeriodBalLocal)");
            sql.append("\r\n from ").append(factTbl);
            sql.append("\r\n group by FBaseCurrencyId, FBaseCurrPrecision,");
            sql.append(" FBaseCurrNum, FBaseCurrency, FPeriodYear, FPeriodNumber, FAsstActType");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append("\r\n (FCurrencyId, FCurrPrecision, FCurrNum, ");
            sql.append("FCurrency, FPeriodYear, FPeriodNumber, FAsstActType, FCussAcct, FIsSum, ");
            sql.append("FPeriodStartBal, FYearDebit, FYearCredit, FPeriodDebit, FPeriodCredit, FPeriodBal");
            String sumLbl = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport.Lbl_Sum", (Locale)ctx.getLocale());
            sql.append(")\r\n select FCurrencyId, ");
            sql.append("FCurrPrecision, FCurrNum, FCurrency, FPeriodYear, FPeriodNumber, FAsstActType, N'");
            sql.append(sumLbl).append("' FCussAcct, 1 FIsSum");
            sql.append(", SUM(FPeriodStartBal), SUM(FYearDebit), SUM(FYearCredit), SUM(FPeriodDebit), SUM(FPeriodCredit), SUM(FPeriodBal)");
            sql.append("\r\n from ").append(factTbl);
            sql.append("\r\n group by FCurrencyId, FCurrPrecision,");
            sql.append(" FCurrNum, FCurrency, FPeriodYear, FPeriodNumber, FAsstActType");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append("\r\n (FCurrencyId, FCurrPrecision, FCurrNum, ");
            sql.append("FCurrency, FBaseCurrencyId, FBaseCurrPrecision, FBaseCurrNum, FBaseCurrency, FPeriodYear, FPeriodNumber, FAsstActType, FCussAcct, FIsSum, ");
            sql.append("FPeriodStartBal, FBeginBalanceLocal, FYearDebit, FYearDebitLocal, FYearCredit, FYearCreditLocal, FPeriodDebit, FDebitLocal, FPeriodCredit, FCreditLocal, FPeriodBal, FPeriodBalLocal");
            String sumLbl = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport.Lbl_Sum", (Locale)ctx.getLocale());
            sql.append(")\r\n select FCurrencyId, ");
            sql.append("FCurrPrecision, FCurrNum, FCurrency, FBaseCurrencyId, FBaseCurrPrecision, FBaseCurrNum, FBaseCurrency, FPeriodYear, FPeriodNumber, FAsstActType, N'");
            sql.append(sumLbl).append("' FCussAcct, 1 FIsSum");
            sql.append(", SUM(FPeriodStartBal), SUM(FBeginBalanceLocal), SUM(FYearDebit), SUM(FYearDebitLocal), SUM(FYearCredit), SUM(FYearCreditLocal), SUM(FPeriodDebit), SUM(FDebitLocal), SUM(FPeriodCredit), SUM(FCreditLocal), SUM(FPeriodBal), SUM(FPeriodBalLocal)");
            sql.append("\r\n from ").append(factTbl);
            sql.append("\r\n group by FCurrencyId, FCurrPrecision,");
            sql.append(" FCurrNum, FCurrency, FBaseCurrencyId, FBaseCurrPrecision, FBaseCurrNum, FBaseCurrency, FPeriodYear, FPeriodNumber, FAsstActType");
        }
        return sql.toString();
    }

    private static void sumToVirtualCompanys(Context ctx, SummaryRptQueryParam param, CompanyOrgUnitCollection virComps, Statement stmt) throws SQLException {
        if (!param.isMultiCompanys() || virComps == null || virComps.size() == 0) {
            return;
        }
        int n = virComps.size();
        for (int i = 0; i < n; ++i) {
            CompanyOrgUnitInfo compInfo = virComps.get(i);
            String sql = ArVirtualSumRptFacadeControllerBean.getVirtualCompanySql(ctx, compInfo, param);
            stmt.execute(sql);
        }
    }

    private static String getVirtualCompanySql(Context ctx, CompanyOrgUnitInfo compInfo, SummaryRptQueryParam param) {
        String factTbl = param.getTempTable();
        StringBuffer sql = new StringBuffer("");
        if ("base".equals(param.getCurrencyId())) {
            sql.append("insert into ").append(factTbl);
            sql.append("\r\n (FBaseCurrencyId, FBaseCurrency, FBaseCurrPrecision, FBaseCurrNum, FPeriodID, FPeriodYear, FPeriodNumber, ");
            sql.append("FAsstActTypeID, FAsstActType, FAsstActID, FAsstActNumber, FCussAcct,");
            sql.append("FCompanyId, FParentCompanyId, ");
            sql.append("FCompany, FCompLongNumber, ");
            sql.append("FIsCompLeaf, FComplevel, ");
            sql.append("FBeginBalanceLocal, FYearDebitLocal, FYearCreditLocal, FDebitLocal, FCreditLocal, FPeriodBalLocal");
            sql.append(")\r\n select");
            sql.append(" FBaseCurrencyId, FBaseCurrency, FBaseCurrPrecision, FBaseCurrNum, FPeriodID, FPeriodYear, FPeriodNumber, ");
            sql.append("FAsstActTypeID, FAsstActType, FAsstActID, FAsstActNumber, FCussAcct, '");
            sql.append(compInfo.getId()).append("' FCompanyId, '");
            if (compInfo.getParent() != null) {
                sql.append(compInfo.getParent().getId());
            } else {
                sql.append("11111111111");
            }
            sql.append("' FParentCompanyId,N'");
            sql.append(compInfo.getName()).append("' FCompany, N'");
            sql.append(compInfo.getLongNumber()).append("' FCompLongNumber");
            sql.append(",\r\n 0 FIsCompLeaf, ").append(compInfo.getLevel());
            sql.append(" FCompLevel, ");
            sql.append("SUM(FBeginBalanceLocal), SUM(FYearDebitLocal), SUM(FYearCreditLocal), SUM(FDebitLocal), SUM(FCreditLocal), SUM(FPeriodBalLocal)");
            sql.append("\r\n from ").append(factTbl);
            sql.append("\r\n where CHARINDEX(N'");
            sql.append(compInfo.getLongNumber());
            sql.append("', FCompLongNumber) > 0 and FIsCompLeaf = 1 ");
            sql.append("\r\n group by");
            sql.append(" FBaseCurrencyId, FBaseCurrency, FBaseCurrPrecision, FBaseCurrNum, FPeriodID, FPeriodYear, FPeriodNumber, ");
            sql.append("FAsstActTypeID, FAsstActType, FAsstActID, FAsstActNumber, FCussAcct");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append("insert into ").append(factTbl);
            sql.append("\r\n (FCurrencyId, FCurrency, FCurrPrecision, FCurrNum, FPeriodID, FPeriodYear, FPeriodNumber, ");
            sql.append("FAsstActTypeID, FAsstActType, FAsstActID, FAsstActNumber, FCussAcct,");
            sql.append("FCompanyId, FParentCompanyId, ");
            sql.append("FCompany, FCompLongNumber, ");
            sql.append("FIsCompLeaf, FComplevel, ");
            sql.append("FPeriodStartBal, FYearDebit, FYearCredit, FPeriodDebit, FPeriodCredit, FPeriodBal");
            sql.append(")\r\n select");
            sql.append(" FCurrencyId, FCurrency, FCurrPrecision, FCurrNum, FPeriodID, FPeriodYear, FPeriodNumber, ");
            sql.append("FAsstActTypeID, FAsstActType, FAsstActID, FAsstActNumber, FCussAcct, '");
            sql.append(compInfo.getId()).append("' FCompanyId, '");
            if (compInfo.getParent() != null) {
                sql.append(compInfo.getParent().getId());
            } else {
                sql.append("11111111111");
            }
            sql.append("' FParentCompanyId,N'");
            sql.append(compInfo.getName()).append("' FCompany, N'");
            sql.append(compInfo.getLongNumber()).append("' FCompLongNumber");
            sql.append(",\r\n 0 FIsCompLeaf, ").append(compInfo.getLevel());
            sql.append(" FCompLevel, ");
            sql.append("SUM(FPeriodStartBal), SUM(FYearDebit), SUM(FYearCredit), SUM(FPeriodDebit), SUM(FPeriodCredit), SUM(FPeriodBal)");
            sql.append("\r\n from ").append(factTbl);
            sql.append("\r\n where CHARINDEX(N'");
            sql.append(compInfo.getLongNumber());
            sql.append("', FCompLongNumber) > 0 and FIsCompLeaf = 1 ");
            sql.append("\r\n group by");
            sql.append(" FCurrencyId, FCurrency, FCurrPrecision, FCurrNum, FPeriodID, FPeriodYear, FPeriodNumber, ");
            sql.append("FAsstActTypeID, FAsstActType, FAsstActID, FAsstActNumber, FCussAcct");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append("insert into ").append(factTbl);
            sql.append("\r\n (FCurrencyId, FCurrency, FCurrPrecision, FCurrNum, FBaseCurrencyId, FBaseCurrency, FBaseCurrPrecision, FBaseCurrNum, FPeriodID, FPeriodYear, FPeriodNumber, ");
            sql.append("FAsstActTypeID, FAsstActType, FAsstActID, FAsstActNumber, FCussAcct,");
            sql.append("FCompanyId, FParentCompanyId, ");
            sql.append("FCompany, FCompLongNumber, ");
            sql.append("FIsCompLeaf, FComplevel, ");
            sql.append("FPeriodStartBal, FBeginBalanceLocal, FYearDebit, FYearDebitLocal, FYearCredit, FYearCreditLocal, FPeriodDebit, FDebitLocal, FPeriodCredit, FCreditLocal, FPeriodBal, FPeriodBalLocal");
            sql.append(")\r\n select");
            sql.append(" FCurrencyId, FCurrency, FCurrPrecision, FCurrNum, FBaseCurrencyId, FBaseCurrency, FBaseCurrPrecision, FBaseCurrNum, FPeriodID, FPeriodYear, FPeriodNumber, ");
            sql.append("FAsstActTypeID, FAsstActType, FAsstActID, FAsstActNumber, FCussAcct, '");
            sql.append(compInfo.getId()).append("' FCompanyId, '");
            if (compInfo.getParent() != null) {
                sql.append(compInfo.getParent().getId());
            } else {
                sql.append("11111111111");
            }
            sql.append("' FParentCompanyId,N'");
            sql.append(compInfo.getName()).append("' FCompany, N'");
            sql.append(compInfo.getLongNumber()).append("' FCompLongNumber");
            sql.append(",\r\n 0 FIsCompLeaf, ").append(compInfo.getLevel());
            sql.append(" FCompLevel, ");
            sql.append("SUM(FPeriodStartBal), SUM(FBeginBalanceLocal), SUM(FYearDebit), SUM(FYearDebitLocal), SUM(FYearCredit), SUM(FYearCreditLocal), SUM(FPeriodDebit), SUM(FDebitLocal), SUM(FPeriodCredit), SUM(FCreditLocal), SUM(FPeriodBal),  SUM(FPeriodBalLocal)");
            sql.append("\r\n from ").append(factTbl);
            sql.append("\r\n where CHARINDEX(N'");
            sql.append(compInfo.getLongNumber());
            sql.append("', FCompLongNumber) > 0 and FIsCompLeaf = 1 ");
            sql.append("\r\n group by");
            sql.append(" FCurrencyId, FCurrency, FCurrPrecision, FCurrNum, FBaseCurrencyId, FBaseCurrency, FBaseCurrPrecision, FBaseCurrNum, FPeriodID, FPeriodYear, FPeriodNumber, ");
            sql.append("FAsstActTypeID, FAsstActType, FAsstActID, FAsstActNumber, FCussAcct");
        }
        return sql.toString();
    }

    private static CompanyOrgUnitCollection getVirtualCompanys(Context ctx, SummaryRptQueryParam param) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().add("id");
        view.getSelector().add("name");
        view.getSelector().add("level");
        view.getSelector().add("parent.id");
        view.getSelector().add("longNumber");
        List ids = param.getCompanyIds();
        HashSet idSet = new HashSet();
        idSet.addAll(ids);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)0));
        SorterItemInfo sorter = new SorterItemInfo("longNumber");
        sorter.setSortType(SortType.DESCEND);
        view.getSorter().add(sorter);
        ICompanyOrgUnit iComp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        return iComp.getCompanyOrgUnitCollection(view);
    }

    protected RptParams _findData(Context ctx, RptParams params, int start, int count, String tempTableName, Object treeTypeObject) throws BOSException, EASBizException {
        RptParams pp = new RptParams();
        SqlParams sqlParam = new SqlParams();
        sqlParam.addString(params.getString("FAsstActId"));
        sqlParam.addString(params.getString("FParentId"));
        String paramCurrency = params.getString("paramCurrency");
        String isBaseCurrency = params.getString("isBaseCurrency");
        if ("base".equals(paramCurrency)) {
            sqlParam.addString(params.getString("FBaseCurrencyId"));
        } else if (!"base".equals(paramCurrency) && "false".equalsIgnoreCase(isBaseCurrency)) {
            sqlParam.addString(params.getString("FCurrencyId"));
        } else if (!"base".equals(paramCurrency) && "true".equalsIgnoreCase(isBaseCurrency)) {
            sqlParam.addString(params.getString("FCurrencyId"));
            sqlParam.addString(params.getString("FBaseCurrencyId"));
        }
        sqlParam.addString(params.getString("FPeriodId"));
        StringBuffer sql = new StringBuffer("");
        sql.append("select * from ").append(tempTableName);
        if ("base".equals(paramCurrency)) {
            sql.append("\r\n where FAsstActId = ? and FParentCompanyId = ? AND FBaseCurrencyId = ? AND FPeriodId = ?");
        } else if (!"base".equals(paramCurrency) && "false".equalsIgnoreCase(isBaseCurrency)) {
            sql.append("\r\n where FAsstActId = ? and FParentCompanyId = ? AND FCurrencyId = ? AND FPeriodId = ?");
        } else if (!"base".equals(paramCurrency) && "true".equalsIgnoreCase(isBaseCurrency)) {
            sql.append("\r\n where FAsstActId = ? and FParentCompanyId = ? AND FCurrencyId = ? AND FBaseCurrencyId = ? AND FPeriodId = ?");
        }
        sql.append(ArApBiSumRptHelper.getSumRptOrderSql());
        RptRowSet rs = this.executeQuery(sql.toString(), sqlParam, start, count, ctx);
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        return this.fetchData(ctx, params, null, true, from, len);
    }

    private RptParams fetchData(Context ctx, RptParams params, List idList, boolean first, int from, int len) throws BOSException {
        RptRowSet rs;
        SummaryRptQueryParam param = (SummaryRptQueryParam)((Object)params.getObject("qryParam"));
        StringBuffer sql = null;
        try {
            sql = ArApBiSumRptHelper.getFetchDataSql(ctx, param, idList);
        }
        catch (Exception e) {
            logger.error((Object)("get agingRpt fectch data sql\r\n" + e));
        }
        RptParams pp = null;
        if (sql != null && sql.length() > 0) {
            rs = this.executeQuery(sql.toString(), null, from, len, ctx);
            pp = new RptParams();
            pp.setObject("rowset", (Object)rs);
        }
        if (params.getBoolean("fFirstLoad")) {
            rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT COUNT(0) " + sql.substring(sql.indexOf("from"), sql.indexOf("order by"))));
            try {
                if (rs.next() && pp != null) {
                    pp.setInt("totalRowCount", rs.getInt(1));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return pp;
    }

    private String getCussAcctTempTable(Context ctx, SummaryRptQueryParam qryParam) throws BOSException {
        String tmpCussAcctTbl = "";
        if (qryParam.getCussAcctTempTable() == null) {
            return tmpCussAcctTbl;
        }
        try {
            String tmpTblDefine = " (FId varchar(44), FNumber nvarchar(80), FName nvarchar(400)) ";
            tmpCussAcctTbl = TempTableUtil.createTempTable(ctx, tmpTblDefine);
            TempTablePool tmpTblPool = TempTablePool.getInstance((Context)ctx);
            tmpTblPool.createIndex(tmpCussAcctTbl, "FId", false, false);
            StringBuilder sql = new StringBuilder();
            sql.append("insert into ").append(tmpCussAcctTbl).append(" (FId,FNumber,FName) \r\n");
            sql.append(" SELECT FID,FNumber,FName FROM ").append(qryParam.getCussAcctTempTable()).append(" GROUP BY FID,FNumber, FName");
            DBUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            logger.info((Object)"createIndex error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return tmpCussAcctTbl;
    }

    @Override
    protected Map _report(Context ctx, RptParams params, List idList, int from, int rows) throws BOSException {
        SummaryRptQueryParam param = (SummaryRptQueryParam)((Object)params.getObject("qryParam"));
        IRowSet rowSet = null;
        HashMap<String, IRowSet> resultMap = new HashMap<String, IRowSet>();
        try {
            StringBuffer querySQL = ArApBiSumRptHelper.getFetchDataSql(ctx, param, idList);
            rowSet = rows > 0 ? SQLDataAccessFacadeFactory.getLocalInstance((Context)ctx).getRowSet(querySQL.toString(), from, rows) : DbUtil.executeQuery((Context)ctx, (String)querySQL.toString());
        }
        catch (Exception e) {
            logger.error((Object)("get agingRpt fectch data sql\r\n" + e));
            throw new BOSException((Throwable)e);
        }
        resultMap.put("rowSet", rowSet);
        return resultMap;
    }
}

