/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.ar.ArApReportData;
import com.kingdee.eas.fi.ar.ArrearageCompareQueryParam;
import com.kingdee.eas.fi.ar.ArrearageQueryParam;
import com.kingdee.eas.fi.ar.ArrearageStructQueryParam;
import com.kingdee.eas.fi.ar.ArrearageTrendQueryParam;
import com.kingdee.eas.fi.ar.IReportData;
import com.kingdee.eas.fi.ar.ReportInfo;
import com.kingdee.eas.fi.ar.app.AbstractArrearageFacadeControllerBean;
import com.kingdee.eas.fi.ar.app.ArApReportHelper;
import com.kingdee.eas.fi.ar.app.RptAr2PrepayTransSql;
import com.kingdee.eas.fi.ar.app.RptArBillSql;
import com.kingdee.eas.fi.ar.app.RptArPrePayVPreRec_PayVRecSql;
import com.kingdee.eas.fi.ar.app.RptArPreRecVPrePay_RecVPaySql;
import com.kingdee.eas.fi.ar.app.RptArTransSql;
import com.kingdee.eas.fi.ar.app.RptArVRecBadVRec_RecSql;
import com.kingdee.eas.fi.ar.app.RptArVRec_ArVApSql;
import com.kingdee.eas.fi.ar.app.RptAr_ApVArSql;
import com.kingdee.eas.fi.ar.app.RptBadAcctSql;
import com.kingdee.eas.fi.ar.app.RptBadRecASql;
import com.kingdee.eas.fi.ar.app.RptRecBillSql;
import com.kingdee.eas.fi.ar.app.RptRecTransSql;
import com.kingdee.eas.fi.arap.app.util.TempTableUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.ChartData;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ArrearageFacadeControllerBean
extends AbstractArrearageFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.ArrearageFacadeControllerBean");

    @Override
    protected IReportData _getReport(Context ctx, ArrearageQueryParam param) throws BOSException, EASBizException {
        this.checkValid(param);
        String tempTable = param.getTempTable();
        if (StringUtils.isEmpty((String)tempTable)) {
            this.prepareRpt(ctx, param);
        }
        IReportData rptData = this.getReportData(ctx, param);
        return rptData;
    }

    @Override
    protected List _getReportChart(Context ctx, ArrearageQueryParam param) throws BOSException, EASBizException {
        this.checkValid(param);
        String tempTable = param.getTempTable();
        if (StringUtils.isEmpty((String)tempTable)) {
            this.prepareRpt(ctx, param);
        }
        List charts = this.getChartData(ctx, param);
        return charts;
    }

    private void checkValid(ArrearageQueryParam param) throws EASBizException {
        if (param == null) {
            throw new ArApCommonException(ArApCommonException.RPT_PARAM_NULL);
        }
        if (StringUtils.isEmpty((String)param.getCompanyId())) {
            throw new ArApCommonException(ArApCommonException.COMPANY_NULL);
        }
        switch (param.analyseMethod()) {
            case 0: {
                this.checkValid((ArrearageCompareQueryParam)param);
                break;
            }
            case 1: {
                this.checkValid((ArrearageStructQueryParam)param);
                break;
            }
            case 2: {
                this.checkValid((ArrearageTrendQueryParam)param);
            }
        }
    }

    private void checkValid(ArrearageCompareQueryParam param) throws EASBizException {
        if (param.getBasePeriodYear() == -1 || param.getBasePeriodNum() == -1) {
            throw new ArApCommonException(ArApCommonException.CHECKBLANK);
        }
    }

    private void checkValid(ArrearageStructQueryParam param) throws EASBizException {
        if (param.getFromPeriodYear() == -1 || param.getFromPeriodNum() == -1 || param.getToPeriodYear() == -1 || param.getToPeriodNum() == -1) {
            throw new ArApCommonException(ArApCommonException.CHECKBLANK);
        }
    }

    private void checkValid(ArrearageTrendQueryParam param) throws EASBizException {
        if (param.getFromPeriodYear() == -1 || param.getFromPeriodNum() == -1 || param.getToPeriodYear() == -1 || param.getToPeriodNum() == -1) {
            throw new ArApCommonException(ArApCommonException.CHECKBLANK);
        }
    }

    private void prepareRpt(Context ctx, ArrearageQueryParam param) throws BOSException, EASBizException {
        param.setCussAcctTempTable(this.putCussAcctId2Table(ctx, param));
        String tmpTable = TempTableUtil.createTempTable(ctx, this.tempTableDefine(param));
        try {
            TempTablePool.getInstance((Context)ctx).createIndex(tmpTable, "FCurrency, FCussNum", false, false);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        param.setTempTable(tmpTable);
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (IObjectPK)new ObjectUuidPK(param.getCompanyId()));
        int method = param.analyseMethod();
        if (method == 0) {
            this.insertCompareData(ctx, (ArrearageCompareQueryParam)param, currPeriod);
        } else if (method == 1) {
            this.insertStructData(ctx, (ArrearageStructQueryParam)param, currPeriod);
        } else {
            this.insertTrendData(ctx, (ArrearageTrendQueryParam)param, currPeriod);
        }
    }

    private void insertCompareData(Context ctx, ArrearageCompareQueryParam param, PeriodInfo currPeriod) throws BOSException, EASBizException {
        String nameFld = ArApReportHelper.getNameFld(ctx);
        PeriodInfo basePeriod = null;
        basePeriod = param.getBasePeriodId() != null ? PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(param.getBasePeriodId())) : PeriodUtils.getPeriodInfo((Context)ctx, (int)param.getBasePeriodYear(), (int)param.getBasePeriodNum(), (IObjectPK)new ObjectUuidPK(param.getCompanyId()));
        StringBuffer sql = new StringBuffer();
        StringBuffer joinCls = new StringBuffer();
        joinCls.append(" left join t_bd_AsstActType t2 on t2.FId = ");
        joinCls.append("t1.FAsstActTypeId \r\n");
        joinCls.append(" left join ").append(param.getCussAcctTempTable());
        joinCls.append(" t3 on t3.FId = t1.FAsstActId left join");
        joinCls.append(" t_bd_currency t4 on t4.FId = t1.FCurrencyId ");
        List rptFlds = param.getReportFields();
        sql.append("insert into ").append(param.getTempTable()).append("\r\n");
        sql.append(" select FCurrency, FCurrNum, FCussType,");
        sql.append(" FCussNum, FCussName, 0 FIsSum,");
        sql.append(" sum(").append(rptFlds.get(4)).append(") ");
        sql.append(rptFlds.get(4)).append(", sum(").append(rptFlds.get(5));
        sql.append(") ").append(rptFlds.get(5)).append("\r\n from (\r\n");
        sql.append(this.compareSelectCls(nameFld, rptFlds, true));
        sql.append("\r\n from (");
        sql.append(this.periodSql(param, basePeriod, currPeriod));
        sql.append(") t1 ").append(joinCls);
        sql.append("\r\n union all \r\n");
        sql.append(this.compareSelectCls(nameFld, rptFlds, false));
        sql.append("\r\n from (");
        sql.append(this.unclosedPeriodSql(param, currPeriod, currPeriod));
        sql.append(") t1 ").append(joinCls);
        sql.append("\r\n ) tCp group by FCurrency, FCurrNum, FCussType, ");
        sql.append("FCussNum, FCussName");
        logger.debug((Object)("Arrearage compareSql:\r\n" + sql));
        DbUtil.execute((Context)ctx, (String)sql.toString());
        String sumLbl = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"totalSum", (Locale)ctx.getLocale());
        sql.delete(0, sql.length());
        sql.append("insert into ").append(param.getTempTable());
        sql.append("\r\n select FCurrency, FCurrNum, N'").append(sumLbl);
        sql.append("' FCussType, null FCussNum, null FCussName, 1 FIsSum,");
        sql.append(" sum(").append(rptFlds.get(4)).append(") ");
        sql.append(rptFlds.get(4)).append(", sum(").append(rptFlds.get(5));
        sql.append(") ").append(rptFlds.get(5));
        sql.append("\r\n from ").append(param.getTempTable());
        sql.append("\r\n group by FCurrency, FCurrNum");
        logger.debug((Object)("Arrearage trend SumSql 1:\r\n" + sql));
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertStructData(Context ctx, ArrearageStructQueryParam param, PeriodInfo currPeriod) throws BOSException, EASBizException {
        String nameFld = ArApReportHelper.getNameFld(ctx);
        PeriodCollection periodCols = ArApReportHelper.getPeriodCollection(ctx, param.getBeginDate(), param.getEndDate(), param.getCompanyId());
        if (periodCols == null || periodCols.size() == 0) {
            return;
        }
        String tempTable = param.getTempTable();
        String flds = " (FCurrency, FCurrNum, FCussType, FCussNum, FCussName, FBalance) \r\n";
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tempTable);
        sql.append(flds);
        int batchLevel = 2;
        int batchCt = 0;
        PeriodInfo period = null;
        int i = 0;
        int dataSize = periodCols.size();
        while (i < dataSize) {
            period = periodCols.get(i);
            if (batchCt == 2) {
                batchCt = 0;
                logger.debug((Object)("Arrearage struct Sql:\r\n" + sql));
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql.delete(0, sql.length());
                sql.append("insert into ").append(tempTable);
                sql.append("\r\n").append(flds);
            }
            sql.append(this.structPeriodSql(nameFld, param, period, currPeriod));
            if (dataSize <= 2 && i < dataSize - 1 || dataSize > 2 && batchCt < 1 && i < dataSize - 1) {
                sql.append("\r\n    union all \r\n");
            }
            ++i;
            ++batchCt;
        }
        if (batchCt > 0 && batchCt <= 2) {
            logger.debug((Object)("Arrearage struct Sql:\r\n" + sql));
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        this.sumStructData(ctx, tempTable);
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tempTable);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        this.calcAdjStructPercent(ctx, tempTable);
    }

    private StringBuffer structPeriodSql(String nameFld, ArrearageQueryParam param, PeriodInfo qryPeriod, PeriodInfo currPeriod) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select t4.").append(nameFld).append(" FCurrency,");
        sql.append(" t4.FNumber FCurrNum, ");
        sql.append(" t2.").append(nameFld).append(" FCussType,");
        sql.append(" t3.FNumber FCussNum, t3.").append(nameFld);
        sql.append(" FCussName, t1.FBalance FBalance");
        sql.append("\r\n from (");
        sql.append(this.periodSql(param, qryPeriod, currPeriod));
        sql.append("\r\n  ) t1 ");
        sql.append(" left join t_bd_AsstActType t2 on t2.FId = ");
        sql.append("t1.FAsstActTypeId \r\n");
        sql.append(" left join ").append(param.getCussAcctTempTable());
        sql.append(" t3 on t3.FId = t1.FAsstActId left join");
        sql.append(" t_bd_currency t4 on t4.FId = t1.FCurrencyId ");
        return sql;
    }

    private void sumStructData(Context ctx, String tmpTbl) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.delete(0, sql.length());
        sql.append("insert into ").append(tmpTbl);
        sql.append(" \r\n (FCurrency, FCurrNum, FCussType, FCussNum, FCussName");
        sql.append(", FBalance, FIsFinal) \r\n");
        sql.append(" select FCurrency, FCurrNum, FCussType, FCussNum, FCussName");
        sql.append(", sum(FBalance) FBalance, 1 FIsFinal from ");
        sql.append(tmpTbl).append("\r\n group by FCurrency");
        sql.append(", FCurrNum, FCussType, FCussNum, FCussName");
        logger.debug((Object)("Arrearage struct SumSql:\r\n" + sql));
        DbUtil.execute((Context)ctx, (String)sql.toString());
        String sumLbl = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"totalSum", (Locale)ctx.getLocale());
        sql.delete(0, sql.length());
        sql.append("insert into ").append(tmpTbl);
        sql.append(" (FCurrency, FCurrNum, FCussType, FBalance, FIsSum, ");
        sql.append("FIsFinal, FPercent) \r\n");
        sql.append(" select FCurrency, FCurrNum, N'").append(sumLbl);
        sql.append("' FCussType, sum(FBalance) FBalance, 1 FIsSum");
        sql.append(", 1 FIsFinal, 1 FPercent from ").append(tmpTbl);
        sql.append("\r\n where FIsFinal = 1 group by FCurrency, FCurrNum");
        logger.debug((Object)("Arrearage struct sumSql:\r\n" + sql));
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.delete(0, sql.length());
    }

    private void calcAdjStructPercent(Context ctx, String tmpTbl) throws BOSException {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        try {
            con = this.getConnection(ctx);
            stmt = con.createStatement();
            sql.append(" select FCurrency, FBalance from ").append(tmpTbl);
            sql.append(" where FIsFinal = 1 and FIsSum = 1");
            logger.debug((Object)("arrearage struct sumBal sql: \r\n" + sql));
            rs = stmt.executeQuery(sql.toString());
            this.setStructSum(rs, con, tmpTbl);
            sql.delete(0, sql.length());
            sql.append("select FBalance, FSum, FCurrency, FCussNum from ");
            sql.append(tmpTbl).append(" where FIsFinal = 1");
            sql.append(" and FIsSum = 0 order by FCurrency");
            logger.debug((Object)("arrearage struct sumPercent sql: \r\n" + sql));
            rs = stmt.executeQuery(sql.toString());
            this.calcStructPercent(rs, con, tmpTbl);
            sql.delete(0, sql.length());
            sql.append("select FCurrency, FCussNum, FPercent from ");
            sql.append(tmpTbl);
            sql.append(" where FIsFinal = 1 and FIsSum = 0 order by ");
            sql.append(" FCurrency, FBalance");
            logger.debug((Object)("arrearage struct adjust percent query: \r\n" + sql));
            rs = stmt.executeQuery(sql.toString());
            this.adjustStructPercent(rs, con, tmpTbl);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"update struct sum bal", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
    }

    private void setStructSum(ResultSet rs, Connection con, String tmpTbl) throws SQLException {
        StringBuffer uSql = new StringBuffer();
        uSql.append("update ").append(tmpTbl).append(" set FSum = ? ");
        uSql.append("where FIsFinal = 1 and FIsSum = 0 and FCurrency = ?");
        logger.debug((Object)("arrearage struct setSum sql: \r\n" + uSql));
        PreparedStatement pstmt = null;
        boolean fNeedUd = false;
        try {
            pstmt = con.prepareStatement(uSql.toString());
            while (rs.next()) {
                pstmt.setBigDecimal(1, rs.getBigDecimal(2));
                pstmt.setString(2, rs.getString(1));
                pstmt.addBatch();
                fNeedUd = true;
            }
            if (fNeedUd) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    private void calcStructPercent(ResultSet rs, Connection con, String tmpTbl) throws SQLException {
        StringBuffer uSql = new StringBuffer();
        uSql.append("update ").append(tmpTbl);
        uSql.append(" set FPercent = ? where FIsFinal = 1 and FIsSum = 0 ");
        uSql.append(" and FCurrency = ? and FCussNum = ?");
        logger.debug((Object)("arrearage struct setPercent sql: \r\n" + uSql));
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement(uSql.toString());
            BigDecimal amt = SysConstant.BIGZERO;
            BigDecimal sum = SysConstant.BIGZERO;
            boolean fNeedUd = false;
            while (rs.next()) {
                amt = rs.getBigDecimal(1);
                sum = rs.getBigDecimal(2);
                pstmt.setBigDecimal(1, this.calcPercent(sum, amt));
                pstmt.setString(2, rs.getString(3));
                pstmt.setString(3, rs.getString(4));
                pstmt.addBatch();
                fNeedUd = true;
            }
            if (fNeedUd) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    private BigDecimal calcPercent(BigDecimal sum, BigDecimal amt) {
        if (sum == null || amt == null || sum.signum() == 0 || amt.signum() == 0) {
            return SysConstant.BIGZERO;
        }
        return amt.divide(sum, 4, 4);
    }

    private void adjustStructPercent(ResultSet rs, Connection con, String tmpTbl) throws SQLException {
        int currDataCt = 0;
        String preCurr = null;
        String curr = null;
        String preNum = null;
        BigDecimal one = new BigDecimal("1");
        BigDecimal p = SysConstant.BIGZERO;
        BigDecimal prePcnt = SysConstant.BIGZERO;
        StringBuffer uSql = new StringBuffer();
        uSql.append("update ").append(tmpTbl).append(" set FPercent = ? ");
        uSql.append("where FIsFinal = 1 and FCurrency = ?");
        uSql.append(" and FCussNum = ?");
        logger.debug((Object)("arrearage struct adjust percent update: \r\n" + uSql));
        boolean fNeedUd = false;
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement(uSql.toString());
            while (rs.next()) {
                curr = rs.getString(1);
                if (preCurr != null && !preCurr.equals(curr)) {
                    if (currDataCt > 1) {
                        pstmt.setBigDecimal(1, one.subtract(p));
                        pstmt.setString(2, preCurr);
                        pstmt.setString(3, preNum);
                        pstmt.addBatch();
                        fNeedUd = true;
                    }
                    p = SysConstant.BIGZERO;
                    prePcnt = SysConstant.BIGZERO;
                    currDataCt = 0;
                } else {
                    p = prePcnt != null ? p.add(prePcnt) : p;
                }
                preCurr = curr;
                preNum = rs.getString(2);
                prePcnt = rs.getBigDecimal(3);
                ++currDataCt;
            }
            if (curr != null && preCurr != null && curr.equals(preCurr) && currDataCt > 1) {
                pstmt.setBigDecimal(1, one.subtract(p));
                pstmt.setString(2, curr);
                pstmt.setString(3, preNum);
                pstmt.addBatch();
                fNeedUd = true;
            }
            if (fNeedUd) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    private void insertTrendData(Context ctx, ArrearageTrendQueryParam param, PeriodInfo currPeriod) throws BOSException, EASBizException {
        String nameFld = ArApReportHelper.getNameFld(ctx);
        PeriodCollection periodCols = ArApReportHelper.getPeriodCollection(ctx, param.getBeginDate(), param.getEndDate(), param.getCompanyId());
        if (periodCols == null || periodCols.size() == 0) {
            return;
        }
        StringBuffer joinCls = new StringBuffer();
        joinCls.append(" left join t_bd_AsstActType t2 on t2.FId = ");
        joinCls.append("t1.FAsstActTypeId \r\n");
        joinCls.append(" left join ").append(param.getCussAcctTempTable());
        joinCls.append(" t3 on t3.FId = t1.FAsstActId left join");
        joinCls.append(" t_bd_currency t4 on t4.FId = t1.FCurrencyId ");
        int baseIndex = 4;
        List rptFlds = param.getReportFields();
        StringBuffer flds = new StringBuffer();
        flds.append(" (FCurrency, FCurrNum, FCussType, FCussNum, FCussName");
        int n = rptFlds.size();
        for (int i = 4; i < n; ++i) {
            flds.append(", ").append(rptFlds.get(i));
        }
        flds.append(") \r\n");
        String tempTable = param.getTempTable();
        int batchLevel = 2;
        int batchCt = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tempTable).append("\r\n");
        sql.append(flds);
        PeriodInfo period = null;
        int i = 0;
        int dataSize = periodCols.size();
        while (i < dataSize) {
            period = periodCols.get(i);
            if (batchCt == 2) {
                batchCt = 0;
                logger.debug((Object)("Arrearage trendSql:\r\n" + sql));
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql.delete(0, sql.length());
                sql.append("insert into ").append(tempTable);
                sql.append("\r\n").append(flds);
            }
            sql.append(this.trendSelectCls(nameFld, rptFlds, 4 + i));
            sql.append("\r\n  from (");
            sql.append(this.periodSql(param, period, currPeriod));
            sql.append("\r\n) t1 ").append(joinCls);
            if (dataSize <= 2 && i < dataSize - 1 || dataSize > 2 && batchCt < 1 && i < dataSize - 1) {
                sql.append("\r\n    union all \r\n");
            }
            ++i;
            ++batchCt;
        }
        if (batchCt > 0 && batchCt <= 2) {
            logger.debug((Object)("Arrearage trendSql:\r\n" + sql));
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        sql.delete(0, sql.length());
        sql.append("insert into ").append(tempTable);
        sql.append("\r\n select FCurrency, FCurrNum, FCussType,");
        sql.append(" FCussNum, FCussName, 0 FIsSum");
        int n2 = rptFlds.size();
        for (i = 4; i < n2; ++i) {
            sql.append(", sum(").append(rptFlds.get(i));
            sql.append(") ").append(rptFlds.get(i));
        }
        sql.append(", 1 FIsFinal from ").append(tempTable);
        sql.append("\r\n group by FCurrency, FCurrNum, FCussType, FCussNum, FCussName");
        logger.debug((Object)("Arrearage trend SumSql 0:\r\n" + sql));
        DbUtil.execute((Context)ctx, (String)sql.toString());
        String sumLbl = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"totalSum", (Locale)ctx.getLocale());
        sql.delete(0, sql.length());
        sql.append("insert into ").append(tempTable);
        sql.append("\r\n select FCurrency, FCurrNum, N'").append(sumLbl);
        sql.append("' FCussType, null FCussNum, null FCussName, 1 FIsSum");
        int n3 = rptFlds.size();
        for (int i2 = 4; i2 < n3; ++i2) {
            sql.append(", sum(").append(rptFlds.get(i2));
            sql.append(") ").append(rptFlds.get(i2));
        }
        sql.append(", 1 FIsFinal\r\n from ").append(tempTable);
        sql.append("\r\n where FIsFinal = 1");
        sql.append("\r\n group by FCurrency, FCurrNum");
        logger.debug((Object)("Arrearage trend SumSql 1:\r\n" + sql));
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private IReportData getReportData(Context ctx, ArrearageQueryParam param) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)param.getTempTable())) {
            return null;
        }
        ArApReportData rptData = null;
        int method = param.analyseMethod();
        String sql = this.queryRptSql(param, false);
        String countSql = "SELECT COUNT(0) " + sql.substring(sql.indexOf("from"), sql.indexOf("order by"));
        List rptFlds = param.getReportFields();
        int fldSize = rptFlds.size();
        if (method == 0) {
            fldSize -= 2;
        }
        int totalRowCount = param.getTotalRowCount();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.createStatement();
            if (totalRowCount == 0 && (rs = stmt.executeQuery(countSql)).next()) {
                totalRowCount = rs.getInt(1);
            }
            logger.debug((Object)("arrearage rpt fetch: \r\n" + sql));
            rs = stmt.executeQuery(sql);
            ArrayList<ReportInfo> dataLst = new ArrayList<ReportInfo>();
            String col = "";
            ReportInfo rptInfo = null;
            int startIndex = param.getStartIndex();
            int endIndex = param.getEndIndex();
            int row = 0;
            while (rs.next()) {
                if (!ArApReportHelper.isInRange(++row, startIndex, endIndex)) continue;
                rptInfo = new ReportInfo();
                for (int i = 0; i < fldSize; ++i) {
                    col = rptFlds.get(i).toString();
                    rptInfo.put(col, rs.getObject(col));
                }
                if (method == 0) {
                    this.computeCompareDiffPercent(rs, rptInfo);
                } else if (method == 1) {
                    this.processStructData(rs, rptInfo);
                }
                rptInfo.setIsSumLine(rs.getBoolean("FIsSum"));
                dataLst.add(rptInfo);
            }
            rptData = new ArApReportData(dataLst, totalRowCount);
            rptData.setTempTable(param.getTempTable());
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"exception", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return rptData;
    }

    private List getChartData(Context ctx, ArrearageQueryParam param) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)param.getTempTable())) {
            return null;
        }
        List charts = null;
        int method = param.analyseMethod();
        String sql = this.queryRptSql(param, true);
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.createStatement();
            logger.debug((Object)("arrearage rpt fetch: \r\n" + sql));
            rs = stmt.executeQuery(sql);
            charts = method == 0 ? this.compareChartData(ctx.getLocale(), rs) : (method == 1 ? this.structChartData(ctx.getLocale(), rs) : this.trendChartData(ctx.getLocale(), rs));
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"exception", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return charts;
    }

    private String queryRptSql(ArrearageQueryParam param, boolean fChart) {
        int method = param.analyseMethod();
        StringBuffer sql = new StringBuffer();
        if (fChart) {
            sql.append("select * from ");
        } else {
            sql.append("select top ").append(param.getEndIndex());
            sql.append(" * from ");
        }
        sql.append(param.getTempTable());
        if (method == 2) {
            sql.append(" where FIsFinal = 1 order by FCurrNum, ");
            sql.append("FIsSum, FCussType, FCussNum");
        } else if (method == 1) {
            sql.append(" where FIsFinal = 1 order by FCurrNum, ");
            sql.append("FIsSum, FCussType, FCussNum");
        } else {
            sql.append(" order by FCurrNum, FIsSum, FCussType, FCussNum");
        }
        return sql.toString();
    }

    private void computeCompareDiffPercent(ResultSet rs, ReportInfo rptInfo) throws SQLException {
        BigDecimal baseAmt = rs.getBigDecimal(7);
        BigDecimal currAmt = rs.getBigDecimal(8);
        BigDecimal diffAmt = currAmt.subtract(baseAmt);
        rptInfo.put("FDiffAmt", diffAmt);
        if (baseAmt.signum() == 0 || diffAmt.signum() == 0) {
            rptInfo.put("FDiffPercent", SysConstant.BIGZERO);
            return;
        }
        BigDecimal percent = diffAmt.divide(baseAmt, 4, 4);
        percent = percent.multiply(new BigDecimal("100")).setScale(2);
        rptInfo.put("FDiffPercent", percent);
    }

    private void processStructData(ResultSet rs, ReportInfo rptInfo) throws SQLException {
        BigDecimal percent = rs.getBigDecimal("FPercent");
        if (percent != null) {
            percent = percent.multiply(new BigDecimal("100")).setScale(2);
            rptInfo.put("FPercent", percent);
        }
    }

    private List compareChartData(Locale locale, ResultSet rs) throws BOSException, SQLException {
        return null;
    }

    private List structChartData(Locale locale, ResultSet rs) throws BOSException, SQLException {
        ArrayList<ChartData> charts = new ArrayList<ChartData>();
        String title = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"ArrearageStruct", (Locale)locale);
        String sPcnt = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"Percent", (Locale)locale);
        String sCussAcct = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"cussAcct", (Locale)locale);
        ArrayList<String> cussAccts = new ArrayList<String>();
        String cussAcct = null;
        ArrayList<BigDecimal> values = new ArrayList<BigDecimal>();
        while (rs.next()) {
            if (rs.getBoolean("FIsSum")) {
                ChartData chart = new ChartData();
                chart.setTitle(title + " " + rs.getString("FCurrency"));
                chart.setType(0);
                chart.setValueTitle(sPcnt);
                chart.setCategoryTitle(sCussAcct);
                String[] keys = new String[cussAccts.size()];
                chart.setGroupsKeys(cussAccts.toArray(keys));
                int n = values.size();
                double[] dPcnt = new double[n];
                for (int i = 0; i < n; ++i) {
                    dPcnt[i] = values.get(i) != null ? ((BigDecimal)values.get(i)).doubleValue() : 0.0;
                }
                double[][] dvls = new double[][]{dPcnt};
                chart.setValues((double[][])dvls);
                charts.add(chart);
                cussAccts.clear();
                values.clear();
                continue;
            }
            cussAcct = rs.getString("FCussName");
            cussAccts.add(cussAcct);
            BigDecimal p = rs.getBigDecimal("FPercent");
            values.add(p);
        }
        return charts;
    }

    private List trendChartData(Locale locale, ResultSet rs) throws BOSException, SQLException {
        return null;
    }

    private String periodSql(ArrearageQueryParam param, PeriodInfo qryPeriod, PeriodInfo currPeriod) {
        if (this.isClosed(qryPeriod, currPeriod)) {
            return this.closedPeriodSql(param, qryPeriod.getId());
        }
        return this.unclosedPeriodSql(param, qryPeriod, currPeriod);
    }

    private boolean isClosed(PeriodInfo period, PeriodInfo currPeriod) {
        return period.getEndDate().before(currPeriod.getBeginDate());
    }

    private String putCussAcctId2Table(Context ctx, ArrearageQueryParam param) throws BOSException, EASBizException {
        String cussAcctSql = ArApReportHelper.getCussObjsSql(ctx, param);
        if (StringUtils.isEmpty((String)cussAcctSql)) {
            return null;
        }
        String ln = ctx.getLocale().getLanguage();
        String cussIdsTblDefine = "( FId varchar(44), FName_" + ln + " nvarchar(400), FNumber nvarchar(80) )";
        String cussAcctIdsTable = TempTableUtil.createTempTable(ctx, cussIdsTblDefine);
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = this.getConnection(ctx);
            logger.debug((Object)(" cussTmpTable " + cussAcctIdsTable));
            String sql = "insert into " + cussAcctIdsTable + " \r\n " + cussAcctSql;
            pstmt = con.prepareStatement(sql);
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)con);
        return cussAcctIdsTable;
    }

    private String tempTableDefine(ArrearageQueryParam param) {
        int method = param.analyseMethod();
        String tblDefine = null;
        if (method == 0) {
            tblDefine = this.compareTblDefine((ArrearageCompareQueryParam)param);
        } else if (method == 1) {
            tblDefine = this.structTblDefine((ArrearageStructQueryParam)param);
        } else if (method == 2) {
            tblDefine = this.trendTblDefine((ArrearageTrendQueryParam)param);
        }
        return tblDefine;
    }

    private String compareTblDefine(ArrearageCompareQueryParam param) {
        StringBuffer sql = new StringBuffer();
        sql.append("( FCurrency nvarchar(100), ");
        sql.append(" FCurrNum varchar(80), ");
        sql.append(" FCussType nvarchar(100), ");
        sql.append(" FCussNum nvarchar(100), ");
        sql.append(" FCussName nvarchar(400), ");
        sql.append(" FIsSum int NOT NULL DEFAULT 0,");
        List rptFlds = param.getReportFields();
        sql.append(rptFlds.get(4));
        sql.append(" decimal(28, 10) NOT NULL DEFAULT 0, ");
        sql.append(rptFlds.get(5));
        sql.append(" decimal(28, 10) NOT NULL DEFAULT 0) ");
        return sql.toString();
    }

    private String structTblDefine(ArrearageStructQueryParam param) {
        StringBuffer sql = new StringBuffer();
        sql.append("( FCurrency nvarchar(100), ");
        sql.append(" FCurrNum varchar(80), ");
        sql.append(" FCussType nvarchar(100), ");
        sql.append(" FCussNum nvarchar(100), ");
        sql.append(" FCussName nvarchar(400), ");
        List rptFlds = param.getReportFields();
        sql.append(rptFlds.get(4));
        sql.append(" decimal(28, 10) NOT NULL DEFAULT 0, ");
        sql.append("FSum decimal(28, 10) NOT NULL DEFAULT 0, ");
        sql.append(" FIsSum int NOT NULL DEFAULT 0,");
        sql.append(" FIsFinal int NOT NULL DEFAULT 0,");
        sql.append(rptFlds.get(5));
        sql.append(" decimal(28, 10) NOT NULL DEFAULT 0)");
        return sql.toString();
    }

    private String trendTblDefine(ArrearageTrendQueryParam param) {
        StringBuffer sql = new StringBuffer();
        sql.append("( FCurrency nvarchar(100), ");
        sql.append(" FCurrNum varchar(80), ");
        sql.append(" FCussType nvarchar(100), ");
        sql.append(" FCussNum nvarchar(100), ");
        sql.append(" FCussName nvarchar(400), ");
        sql.append(" FIsSum int NOT NULL DEFAULT 0");
        List rptFlds = param.getReportFields();
        int n = rptFlds.size();
        for (int i = 4; i < n; ++i) {
            sql.append(", ").append(rptFlds.get(i));
            sql.append(" decimal(28, 10) NOT NULL DEFAULT 0");
        }
        sql.append(", FIsFinal int NOT NULL DEFAULT 0)");
        return sql.toString();
    }

    private String unclosedPeriodSql(ArrearageQueryParam param, PeriodInfo qryPeriod, PeriodInfo currPeriod) {
        StringBuffer sql = new StringBuffer();
        sql.append("select tUP.FAsstActTypeId, tUP.FAsstActId, ");
        sql.append("tUP.FCurrencyId, sum(tUP.FBalance) FBalance from ");
        sql.append("\r\n (select t1.FAsstActTypeId, t1.FAsstActId, ");
        sql.append("t1.FCurrencyId, t1.FBeginBalanceFor ");
        sql.append("FBalance from t_ar_ArBalance t1\r\n");
        sql.append(" where 1=1 ");
        sql.append(" and t1.FCompanyId = '").append(param.getCompanyId());
        sql.append("'\r\n and t1.FAsstActId in (select FId from ");
        sql.append(param.getCussAcctTempTable()).append(") \r\n");
        sql.append(" and t1.FPeriodId = '").append(currPeriod.getId());
        sql.append("' ");
        if (!param.isAllCurrency()) {
            sql.append(" and t1.FCurrencyId = '");
            sql.append(param.getCurrencyId()).append("' ");
        }
        sql.append(" and t1.FBalType IN (");
        if (param.isBizeCheckBox()) {
            if (param.getBizeIndex() == 0) {
                sql.append("101,104" + (param.isIncludeBizBill() ? ", 102" : "") + "," + 103);
            } else {
                sql.append(103);
            }
        } else {
            sql.append("101,104");
            sql.append(param.isIncludeBizBill() ? ", 102" : "");
        }
        sql.append(")\r\n union all \r\n");
        sql.append(this.arBizAmtSql(param, currPeriod.getBeginDate(), qryPeriod.getEndDate()));
        sql.append("\r\n ) tUP group by FAsstActTypeId, FAsstActId");
        sql.append(", FCurrencyId");
        return sql.toString();
    }

    private String arBizAmtSql(ArrearageQueryParam param, Date beginDate, Date endDate) {
        StringBuffer sql = new StringBuffer();
        sql.append(new RptRecBillSql().getArrearageBizAmtQuerySql(param, beginDate, endDate));
        sql.append("\r\n union all \r\n");
        sql.append(new RptArBillSql().getArrearageBizAmtQuerySql(param, beginDate, endDate));
        sql.append("\r\n union all \r\n");
        sql.append(new RptBadAcctSql().getArrearageBizAmtQuerySql(param, beginDate, endDate));
        sql.append("\r\n union all \r\n");
        sql.append(new RptBadRecASql().getArrearageBizAmtQuerySql(param, beginDate, endDate));
        sql.append("\r\n union all \r\n");
        sql.append(new RptArVRec_ArVApSql().getArrearageBizAmtQuerySql(param, beginDate, endDate));
        sql.append("\r\n union all \r\n");
        sql.append(new RptArVRecBadVRec_RecSql().getArrearageBizAmtQuerySql(param, beginDate, endDate));
        sql.append("\r\n union all \r\n");
        sql.append(new RptArPreRecVPrePay_RecVPaySql().getArrearageBizAmtQuerySql(param, beginDate, endDate));
        sql.append("\r\n union all \r\n");
        sql.append(new RptAr_ApVArSql().getArrearageBizAmtQuerySql(param, beginDate, endDate));
        sql.append("\r\n union all \r\n");
        sql.append(new RptArPrePayVPreRec_PayVRecSql().getArrearageBizAmtQuerySql(param, beginDate, endDate));
        sql.append("\r\n union all \r\n");
        sql.append(new RptArTransSql().getArrearageBizAmtQuerySql(param, beginDate, endDate));
        sql.append("\r\n union all \r\n");
        sql.append(new RptRecTransSql().getArrearageBizAmtQuerySql(param, beginDate, endDate));
        sql.append("\r\n union all \r\n");
        sql.append(new RptAr2PrepayTransSql().getArrearageBizAmtQuerySql(param, beginDate, endDate));
        return sql.toString();
    }

    private String closedPeriodSql(ArrearageQueryParam param, BOSUuid qryPeriodId) {
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.FAsstActTypeId, t1.FAsstActId, t1.FCurrencyId,");
        sql.append(" sum(t1.FEndBalanceFor) FBalance");
        sql.append(" from t_ar_ArBalance t1\r\n where 1=1 ");
        sql.append(" and t1.FCompanyId = '").append(param.getCompanyId());
        sql.append("' and t1.FAsstActId in (select FId from ");
        sql.append(param.getCussAcctTempTable()).append(") \r\n");
        sql.append(" and t1.FPeriodId = '").append(qryPeriodId);
        sql.append("' ");
        if (!param.isAllCurrency()) {
            sql.append(" and t1.FCurrencyId = '");
            sql.append(param.getCurrencyId()).append("' ");
        }
        sql.append(" and t1.FBalType IN (");
        if (param.isBizeCheckBox()) {
            if (param.getBizeIndex() == 0) {
                sql.append("101,104" + (param.isIncludeBizBill() ? ", 102" : "") + "," + 103);
            } else {
                sql.append(103);
            }
        } else {
            sql.append("101,104");
            sql.append(param.isIncludeBizBill() ? ", 102" : "");
        }
        sql.append(")\r\n group by FAsstActTypeId, FAsstActId, FCurrencyId");
        return sql.toString();
    }

    private String compareSelectCls(String nameFld, List rptFlds, boolean fBase) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select t4.").append(nameFld).append(" FCurrency,");
        sql.append(" t4.FNumber FCurrNum, ");
        sql.append(" t2.").append(nameFld).append(" FCussType,");
        sql.append(" t3.FNumber FCussNum, t3.").append(nameFld);
        sql.append(" FCussName, ");
        sql.append(fBase ? "t1.FBalance " : "0 ");
        sql.append(rptFlds.get(4));
        sql.append(", ").append(!fBase ? "t1.FBalance " : "0 ");
        sql.append(rptFlds.get(5));
        return sql.toString();
    }

    private String trendSelectCls(String nameFld, List rptFlds, int idx) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select t4.").append(nameFld).append(" FCurrency,");
        sql.append(" t4.FNumber FCurrNum, ");
        sql.append(" t2.").append(nameFld).append(" FCussType,");
        sql.append(" t3.FNumber FCussNum, t3.").append(nameFld);
        sql.append(" FCussName");
        int baseInd = 4;
        int n = rptFlds.size();
        for (int i = 4; i < n; ++i) {
            sql.append(i == idx ? ", t1.FBalance " : ", 0 ");
            sql.append(rptFlds.get(i));
        }
        return sql.toString();
    }
}

