/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ap.PrepareOptionMethodEnum;
import com.kingdee.eas.fi.ar.AccountBadDebtBDFacadeFactory;
import com.kingdee.eas.fi.ar.AccountBadDebtCollection;
import com.kingdee.eas.fi.ar.AccountBadDebtCustAnalysisEntryInfo;
import com.kingdee.eas.fi.ar.AccountBadDebtCustDetailFactory;
import com.kingdee.eas.fi.ar.AccountBadDebtCustDetailInfo;
import com.kingdee.eas.fi.ar.AccountBadDebtCustEntryInfo;
import com.kingdee.eas.fi.ar.AccountBadDebtException;
import com.kingdee.eas.fi.ar.AccountBadDebtFactory;
import com.kingdee.eas.fi.ar.AccountBadDebtInfo;
import com.kingdee.eas.fi.ar.BadAccountFacadeFactory;
import com.kingdee.eas.fi.ar.BadAccountParamEnum;
import com.kingdee.eas.fi.ar.IAccountBadDebt;
import com.kingdee.eas.fi.ar.IAccountBadDebtBDFacade;
import com.kingdee.eas.fi.ar.IAccountBadDebtCustDetail;
import com.kingdee.eas.fi.ar.IBadAccountFacade;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.ar.app.AbstractBadAccountDebtFacadeControllerBean;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.fi.arap.util.ArApStringUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BadAccountDebtFacadeControllerBean
extends AbstractBadAccountDebtFacadeControllerBean {
    private static final long serialVersionUID = 418060804470326630L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.BadAccountDebtFacadeControllerBean");
    public static final BigDecimal ZERO = new BigDecimal("0.0");
    public static final BigDecimal ONE = new BigDecimal("1.0");
    public static final String JAVA_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final long ONE_DAY_MILLISECONDS = 86400000L;
    private BigDecimal totalPrepareAmount = ZERO;
    private BigDecimal totalBadPrepareAmount = ZERO;
    private BigDecimal totalPatch = ZERO;
    private BigDecimal totalRush = ZERO;
    protected boolean isPrepareCurrency = false;
    protected transient ICurrency icurr = null;
    private transient IAccountView iAccountView = null;
    protected transient IExchangeRate iExchangeRate = null;
    private transient IAccountBadDebt accountBadDebt = null;
    private transient IBadAccountFacade iBadAccountFacade = null;
    private transient ICompanyOrgUnit iCompanyOrgUnit = null;
    private transient IAccountBadDebtBDFacade iAccountBadDebtBDFacade = null;
    private transient ISystemStatusCtrol systemStatusCtrol = null;
    protected transient ICodingRuleManager iCodingRuleManager = null;
    protected transient ICustomer iCustomer = null;
    protected transient IAccountBadDebtCustDetail iAccountBadDebtCustDetail = null;

    private IAccountBadDebtCustDetail getIAccountBadDebtCustDetail(Context ctx) throws BOSException {
        if (null == this.iAccountBadDebtCustDetail) {
            this.iAccountBadDebtCustDetail = AccountBadDebtCustDetailFactory.getLocalInstance(ctx);
        }
        return this.iAccountBadDebtCustDetail;
    }

    private ICustomer getICustomer(Context ctx) throws BOSException {
        if (null == this.iCustomer) {
            this.iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
        }
        return this.iCustomer;
    }

    private ICodingRuleManager getCodingRuleManager(Context ctx) throws BOSException {
        if (null == this.iCodingRuleManager) {
            this.iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        }
        return this.iCodingRuleManager;
    }

    private IExchangeRate getExchangeRate(Context ctx) throws BOSException {
        if (null == this.iExchangeRate) {
            this.iExchangeRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        }
        return this.iExchangeRate;
    }

    private IAccountBadDebtBDFacade getAccountBadDebtBDFacade(Context ctx) throws BOSException {
        if (null == this.iAccountBadDebtBDFacade) {
            this.iAccountBadDebtBDFacade = AccountBadDebtBDFacadeFactory.getLocalInstance(ctx);
        }
        return this.iAccountBadDebtBDFacade;
    }

    private IBadAccountFacade getBadAccountFacade(Context ctx) throws BOSException {
        if (null == this.iBadAccountFacade) {
            this.iBadAccountFacade = BadAccountFacadeFactory.getLocalInstance(ctx);
        }
        return this.iBadAccountFacade;
    }

    private IAccountView getAccountView(Context ctx) throws BOSException {
        if (null == this.iAccountView) {
            this.iAccountView = AccountViewFactory.getLocalInstance((Context)ctx);
        }
        return this.iAccountView;
    }

    private ISystemStatusCtrol getSystemStatusCtrol(Context ctx) throws BOSException {
        if (null == this.systemStatusCtrol) {
            this.systemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        }
        return this.systemStatusCtrol;
    }

    private IAccountBadDebt getAccountBadDebt(Context ctx) throws BOSException {
        if (null == this.accountBadDebt) {
            this.accountBadDebt = AccountBadDebtFactory.getLocalInstance(ctx);
        }
        return this.accountBadDebt;
    }

    private ICompanyOrgUnit getCompanyOrgUnit(Context ctx) throws BOSException {
        if (null == this.iCompanyOrgUnit) {
            this.iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        }
        return this.iCompanyOrgUnit;
    }

    private ICurrency getICurrency(Context ctx) throws BOSException {
        if (null == this.icurr) {
            this.icurr = CurrencyFactory.getLocalInstance((Context)ctx);
        }
        return this.icurr;
    }

    private void setPrepareCurrency(Context ctx) throws BOSException, EASBizException {
        this.isPrepareCurrency = !this.getBadAccountFacade(ctx).isDisplayLocalCurrency();
    }

    private void checkCustomerPrepareAmount(Context ctx, String currencyID, List rows) throws BOSException, EASBizException {
        String errMsg = "";
        String method = "checkCustomerPrepareAmount";
        if (StringUtils.isEmpty((String)currencyID)) {
            errMsg = BadAccountDebtFacadeControllerBean.getParamErrorMsg("checkCustomerPrepareAmount", "currencyID");
        }
        if (null == rows || rows.size() == 0) {
            errMsg = BadAccountDebtFacadeControllerBean.getParamErrorMsg("checkCustomerPrepareAmount", "currencyID");
        }
        if (!StringUtils.isEmpty((String)errMsg)) {
            throw new BOSException(errMsg);
        }
        int size = rows.size();
        ArrayList<String> customerIDList = new ArrayList<String>(size);
        HashSet<String> companyIdset = new HashSet<String>(size);
        for (int i = 0; i < size; ++i) {
            String customerID = null;
            Map map = (Map)rows.get(i);
            if (map.get("customerID") != null) {
                customerID = map.get("customerID").toString();
            }
            if (map.get("companyId") != null) {
                companyIdset.add(map.get("companyId").toString());
            }
            if (StringUtils.isEmpty((String)customerID) || customerIDList.contains(customerID)) continue;
            customerIDList.add(customerID);
        }
        String[] customerIDSt = new String[customerIDList.size()];
        customerIDList.toArray(customerIDSt);
        Map result = this.getAccountBadDebtBDFacade(ctx).getBadAcctParepareAmount(customerIDSt, new String[]{currencyID}, companyIdset);
        if (result != null && result.size() > 0) {
            String customerID = null;
            String companyID = null;
            String key = null;
            List values = null;
            for (int j = 0; j < size; ++j) {
                Map map = (Map)rows.get(j);
                BigDecimal badPrepareAmount = ZERO;
                if (map.get("badPrepareAmount") != null) {
                    badPrepareAmount = new BigDecimal(map.get("badPrepareAmount").toString());
                }
                if (map.get("customerID") != null) {
                    customerID = map.get("customerID").toString();
                }
                if (map.get("companyId") != null) {
                    companyID = map.get("companyId").toString();
                }
                List list = values = null == result.get(key = new StringBuffer(50).append(companyID).append("_").append(customerID).toString()) ? null : (List)result.get(key);
                if (null != values && values.size() == 2 && badPrepareAmount.compareTo(new BigDecimal(values.get(0).toString())) != 0) {
                    throw new BOSException("\uff08" + values.get(1).toString() + "\uff09" + BadAccountDebtFacadeControllerBean.getARResource("badprepareamount_not_equal"));
                }
                values = null;
            }
        }
    }

    public static String getARResource(String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)key, (Locale)ContextUtils.getOriginalLocaleFromEnv());
    }

    public static String getParamErrorMsg(String ... parameters) {
        String msgTmplate = BadAccountDebtFacadeControllerBean.getARResource("Parameter_Invalid");
        if (null != parameters && parameters.length > 0) {
            return MessageFormat.format(msgTmplate, parameters);
        }
        return msgTmplate;
    }

    private void resetAmount() {
        this.totalPrepareAmount = ZERO;
        this.totalBadPrepareAmount = ZERO;
        this.totalPatch = ZERO;
        this.totalRush = ZERO;
    }

    private void caculateCustomerAmount(String currentCompanyId, List rows) throws BOSException {
        String oldCustomerID = "";
        String customerID = "";
        String companyId = "";
        int size = rows.size();
        for (int i = 0; i < size; ++i) {
            Map map = (Map)rows.get(i);
            companyId = map.get("companyId").toString();
            if (!currentCompanyId.equals(companyId)) continue;
            customerID = map.get("customerID").toString();
            if (!oldCustomerID.equals(customerID)) {
                BigDecimal prepareJTAmount = ZERO;
                BigDecimal preReceiveAmount = ZERO;
                BigDecimal difference = ZERO;
                BigDecimal badPrepareAmount = ZERO;
                BigDecimal patch = ZERO;
                BigDecimal rush = ZERO;
                if (map.get("prepareJTAmount") != null) {
                    prepareJTAmount = new BigDecimal(map.get("prepareJTAmount").toString());
                }
                if (map.get("preReceiveAmount") != null) {
                    preReceiveAmount = new BigDecimal(map.get("preReceiveAmount").toString());
                }
                if (prepareJTAmount.compareTo(preReceiveAmount) > 0) {
                    difference = prepareJTAmount.subtract(preReceiveAmount);
                }
                if (map.get("badPrepareAmount") != null) {
                    badPrepareAmount = new BigDecimal(map.get("badPrepareAmount").toString());
                }
                this.totalPrepareAmount = this.totalPrepareAmount.add(difference);
                this.totalBadPrepareAmount = this.totalBadPrepareAmount.add(badPrepareAmount);
            }
            oldCustomerID = customerID;
        }
        if (this.totalPrepareAmount.compareTo(ZERO) < 0) {
            throw new BOSException(BadAccountDebtFacadeControllerBean.getARResource("accural_prepare_amount_should_big_zero"));
        }
        if (this.totalPrepareAmount.compareTo(this.totalBadPrepareAmount) >= 0) {
            this.totalPatch = this.totalPrepareAmount.subtract(this.totalBadPrepareAmount);
        } else {
            this.totalRush = this.totalBadPrepareAmount.subtract(this.totalPrepareAmount);
        }
    }

    public boolean isGLStart(Context ctx, String comanyId) throws BOSException {
        boolean isStart = false;
        SystemStatusCtrolInfo systmStsCtrlInf = this.getSysStatusCtrolInfo(ctx, comanyId, SystemEnum.GENERALLEDGER);
        if (systmStsCtrlInf != null) {
            isStart = systmStsCtrlInf.isIsStart();
        }
        return isStart;
    }

    public SystemStatusCtrolInfo getSysStatusCtrolInfo(Context ctx, String comanyId, SystemEnum system) throws BOSException {
        SystemStatusCtrolInfo systmStsCtrlInf = null;
        if (!StringUtils.isEmpty((String)comanyId) && null != system) {
            StringBuffer buf = new StringBuffer(150);
            buf.append("select *, currentPeriod.*, startPeriod.* where ").append("(company = '").append(comanyId).append("') and ").append("(systemStatus.name = ").append(system.getValue()).append(")");
            SystemStatusCtrolCollection systmStsCtrlCllctn = this.getSystemStatusCtrol(ctx).getSystemStatusCtrolCollection(buf.toString());
            int size = systmStsCtrlCllctn.size();
            if (size == 1) {
                systmStsCtrlInf = systmStsCtrlCllctn.get(0);
            } else {
                throw new IllegalArgumentException();
            }
        }
        return systmStsCtrlInf;
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    public Date upDate(Date oldDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(oldDate);
        calendar.add(5, 1);
        Date dateUp = new Date(calendar.getTime().getTime());
        return dateUp;
    }

    public void checkVoucheredOrSettleAccount(Context ctx, String accountType, String currencyID, PeriodInfo currPeriod, String companyId, boolean isRelationGL) throws EASBizException, BOSException {
        String errMsg = null;
        String methodName = "checkVoucheredOrSettleAccount";
        if (StringUtils.isEmpty((String)accountType)) {
            errMsg = BadAccountDebtFacadeControllerBean.getParamErrorMsg("checkVoucheredOrSettleAccount", "accountType");
        }
        if (StringUtils.isEmpty((String)currencyID)) {
            errMsg = BadAccountDebtFacadeControllerBean.getParamErrorMsg("checkVoucheredOrSettleAccount", "currencyID");
        }
        if (null == currPeriod) {
            errMsg = BadAccountDebtFacadeControllerBean.getParamErrorMsg("checkVoucheredOrSettleAccount", "currPeriod");
        }
        if (StringUtils.isEmpty((String)companyId)) {
            errMsg = BadAccountDebtFacadeControllerBean.getParamErrorMsg("checkVoucheredOrSettleAccount", "companyId");
        }
        if (!StringUtils.isEmpty(errMsg)) {
            throw new BOSException(errMsg);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountDate", (Object)currPeriod.getBeginDate(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("accountDate", (Object)this.upDate(currPeriod.getEndDate()), CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyId));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("auditor.id");
        sic.add("auditor.name");
        sic.add("auditDate");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.number");
        sic.add("billAnalysisEntry.*");
        sic.add("fiVouchered");
        view.setSelector(sic);
        AccountBadDebtCollection coll = this.getAccountBadDebt(ctx).getAccountBadDebtCollection(view);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            String saveCurrencyID;
            AccountBadDebtInfo info = coll.get(i);
            if (!String.valueOf(5).equals(accountType) || !currencyID.equals(saveCurrencyID = info.getCurrency().getId().toString())) continue;
            if (info.getAuditDate() == null || info.getAuditor() == null) {
                this.throwAccountBadDebtExceptionWithOrg(AccountBadDebtException.NO_AUDIT_WITH_ORG, info.getCompany());
            }
            if (!isRelationGL) continue;
            if (!info.isFiVouchered()) {
                this.throwAccountBadDebtExceptionWithOrg(AccountBadDebtException.NO_VOUCHER_WITH_ORG, info.getCompany());
            }
            if (!this.getAccountBadDebt(ctx).checkSettleAccounts(info.getId().toString(), companyId)) continue;
            this.throwAccountBadDebtExceptionWithOrg(AccountBadDebtException.NO_SETTLE_ACCOUNTS_WITH_ORG, info.getCompany());
        }
    }

    public ExchangeRateInfo getExchangeRateInfo(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCur, Date date) throws EASBizException, BOSException {
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK destCurrpk = null;
        if (companyOrgUnitInfo == null || sourceCur == null) {
            return null;
        }
        if (companyOrgUnitInfo.getBaseExchangeTable() == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(companyOrgUnitInfo.getBaseExchangeTable().getId());
        CurrencyInfo baseCur = companyOrgUnitInfo.getBaseCurrency();
        if (baseCur != null) {
            if (baseCur.getId().equals((Object)sourceCur.getId())) {
                return null;
            }
        } else {
            return null;
        }
        destCurrpk = new ObjectUuidPK(baseCur.getId());
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(sourceCur.getId());
        ExchangeRateInfo rateInfo = this.getExchangeRate(ctx).getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        return rateInfo;
    }

    private BigDecimal getDateExchangeRate(Context ctx, CompanyOrgUnitInfo company, CurrencyInfo sourceCur, Date date) throws EASBizException, BOSException {
        CurrencyInfo destCur;
        String method = "getDateExchangeRate";
        String errMsg = "";
        BigDecimal exchangeRate = ONE;
        if (!this.isPrepareCurrency) {
            return exchangeRate;
        }
        if (null == company) {
            errMsg = BadAccountDebtFacadeControllerBean.getParamErrorMsg("getDateExchangeRate", "company");
        }
        if (null == (destCur = company.getBaseCurrency())) {
            errMsg = BadAccountDebtFacadeControllerBean.getParamErrorMsg("getDateExchangeRate", "company.getBaseCurrency()");
        }
        if (null == sourceCur) {
            errMsg = BadAccountDebtFacadeControllerBean.getParamErrorMsg("getDateExchangeRate", "sourceCur");
        }
        if (null == company.getBaseExchangeTable()) {
            errMsg = BadAccountDebtFacadeControllerBean.getParamErrorMsg("getDateExchangeRate", "company.getBaseExchangeTable()");
        }
        if (!StringUtils.isEmpty((String)errMsg)) {
            throw new BOSException(errMsg);
        }
        if (destCur.getId().toString().equals(sourceCur.getId().toString())) {
            return exchangeRate;
        }
        ObjectUuidPK destCurrpk = new ObjectUuidPK(destCur.getId());
        ObjectUuidPK excTablepk = new ObjectUuidPK(company.getBaseExchangeTable().getId());
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(sourceCur.getId());
        ExchangeRateInfo rateInfo = this.getExchangeRate(ctx).getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        if (rateInfo != null) {
            exchangeRate = rateInfo.getConvertRate();
        }
        return exchangeRate;
    }

    private Date getJTDate(PeriodInfo currPeriod) {
        Date currDate = null;
        if (currPeriod != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(currPeriod.getEndDate());
            currDate = new Date(calendar.getTime().getTime());
        }
        return currDate;
    }

    private String getNumberFromCodeRule(Context ctx, BillBaseInfo billInfo) throws CodingRuleException, EASBizException, BOSException {
        String sysNumber = null;
        if (billInfo.getCompany() == null) {
            return null;
        }
        String companyID = billInfo.getCompany().getId().toString();
        sysNumber = this.getCodingRuleManager(ctx).getNumber((IObjectValue)billInfo, companyID);
        return sysNumber;
    }

    public static String formatSQLDate(Date date) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(JAVA_DATE_FORMAT);
        return sdf.format(date);
    }

    public static String getBadAccountDebtCustDetailSQL(String companyId, Date jtDate, String custIds, boolean isIncludeUndue, Date currPeriodEndDate, boolean isRelationGL, Date startPeriodBeginDate, boolean isBizDate) {
        StringBuffer buf = new StringBuffer(500).append("SELECT COMPANY.FID COMPANY_ID, ").append("COMPANY.FName_l2 COMPANY_NAME, ").append("COMPANY.FNumber COMPANY_NUMBER, ").append("OTHERBILL.FasstActID ASSTACT_ID, ").append("OTHERBILL.FasstActNumber  ASSTACT_NUMBER, ").append("OTHERBILL.FasstActName_l2  ASSTACT_NAME, ").append("OTHERBILL.FNumber  BILL_NUMBER, ");
        if (isBizDate) {
            buf.append("OTHERBILL.FBizDate RECIEVE_PAYDATE, ").append("OTHERBILL.FAmountLocal RECIEVE_PAYAMOUNT_LOCAL, ").append("OTHERBILL.FVerifyAmountLocal VERIFY_AMOUNT_LOCAL, ").append("OTHERBILL.FUnVerifyAmountLocal UNVERIFY_AMT_LOCAL, ");
        } else {
            buf.append("RECIEVEPLAN.FRecievePayDate RECIEVE_PAYDATE, ").append("RECIEVEPLAN.FRecievePayAmountLocal RECIEVE_PAYAMOUNT_LOCAL, ").append("RECIEVEPLAN.FVerifyAmountLocal VERIFY_AMOUNT_LOCAL, ").append("(RECIEVEPLAN.FRecievePayAmountLocal - RECIEVEPLAN.FVerifyAmountLocal) UNVERIFY_AMT_LOCAL, ");
        }
        buf.append("OTHERBILL.FID BILL_ID, ").append("OTHERBILL.FBillType BILL_TYPE ").append("FROM T_AR_OtherBill OTHERBILL ");
        if (!isBizDate) {
            buf.append("INNER JOIN T_AR_OtherBillPlan RECIEVEPLAN ON OTHERBILL.FID = RECIEVEPLAN.FParentID ");
        }
        buf.append("INNER JOIN T_ORG_Company COMPANY ON OTHERBILL.FCompanyID = COMPANY.FID ").append("WHERE COMPANY.FID = '").append(companyId).append("' ").append("AND OTHERBILL.FBILLDATE < to_date('").append(BadAccountDebtFacadeControllerBean.formatSQLDate(jtDate)).append("') ");
        String custIdsSQL = ArApStringUtil.convertIdsStr2SqlCondition(custIds);
        if (!StringUtils.isEmpty((String)custIdsSQL)) {
            buf.append("AND OTHERBILL.FasstActID IN (").append(custIdsSQL).append(") ");
        }
        if (!isIncludeUndue) {
            if (isBizDate) {
                buf.append("AND OTHERBILL.FBizDate <= to_date('").append(BadAccountDebtFacadeControllerBean.formatSQLDate(currPeriodEndDate)).append("') ");
            } else {
                buf.append("AND RECIEVEPLAN.FRecievePayDate <= to_date('").append(BadAccountDebtFacadeControllerBean.formatSQLDate(currPeriodEndDate)).append("') ");
            }
        }
        if (isRelationGL) {
            buf.append(" AND (OTHERBILL.ffivouchered = 1 OR  ").append(" OTHERBILL.fbilldate < to_date('").append(BadAccountDebtFacadeControllerBean.formatSQLDate(startPeriodBeginDate)).append("')) ");
        }
        buf.append(" AND OTHERBILL.fbillstatus = ").append(3).append(" ").append(" AND OTHERBILL.fisbizbill = 0 ").append(" AND OTHERBILL.FisNotJoinBadAccount = 0 ");
        if (isBizDate) {
            buf.append(" AND OTHERBILL.FUnVerifyAmountLocal <> 0");
        } else {
            buf.append(" AND RECIEVEPLAN.FRecievePayAmountLocal <> RECIEVEPLAN.FVerifyAmountLocal ");
        }
        buf.append("ORDER BY ASSTACT_NUMBER ASC, RECIEVE_PAYDATE DESC ");
        return buf.toString();
    }

    public static boolean hasMapValue(Map map, Object key) {
        return null != map && null != map.get(key);
    }

    protected void caculateCustomerJTRate(AccountBadDebtCustDetailInfo info, Date currPeriodEndDate, List custAgeMapList) {
        if (null == info || null == currPeriodEndDate || null == info.getRecieveData() || null == info.getBillType() || null == custAgeMapList || custAgeMapList.size() == 0) {
            return;
        }
        long days = (currPeriodEndDate.getTime() - info.getRecieveData().getTime()) / 86400000L + 1L;
        for (Map custAgeMap : custAgeMapList) {
            if (!BadAccountDebtFacadeControllerBean.hasMapValue(custAgeMap, "daysDesc") || !BadAccountDebtFacadeControllerBean.hasMapValue(custAgeMap, "startDays") || !BadAccountDebtFacadeControllerBean.hasMapValue(custAgeMap, "endDays") || !BadAccountDebtFacadeControllerBean.hasMapValue(custAgeMap, "jtRate") || !BadAccountDebtFacadeControllerBean.hasMapValue(custAgeMap, "otherJtRate")) continue;
            int startDays = Integer.valueOf(custAgeMap.get("startDays").toString());
            int endDays = Integer.valueOf(custAgeMap.get("endDays").toString());
            if (!(days <= 0L && startDays == 0 && endDays == 0 || days >= (long)startDays && days <= (long)endDays) && (startDays == 0 || days < (long)startDays || endDays != 0)) continue;
            info.setDays(custAgeMap.get("daysDesc").toString());
            if (OtherBillTypeEnum.OtherReceivable == info.getBillType()) {
                info.setJtRate(custAgeMap.get("otherJtRate").toString());
                break;
            }
            info.setJtRate(custAgeMap.get("jtRate").toString());
            break;
        }
    }

    protected List<AccountBadDebtCustDetailInfo> getAccountBadDebtCustDetailInfoList(Context ctx, String sql, String debtNumber, Date currPeriodEndDate, Map orgCustAgeMap) throws BOSException {
        IRowSet rowSet;
        ArrayList<AccountBadDebtCustDetailInfo> rows = new ArrayList<AccountBadDebtCustDetailInfo>(30);
        if (!StringUtils.isEmpty((String)sql) && null != (rowSet = DbUtil.executeQuery((Context)ctx, (String)sql)) && rowSet.size() > 0) {
            UserInfo currentUser = SysContext.getSysContext().getCurrentUserInfo();
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            CompanyOrgUnitInfo company = null;
            String key = null;
            try {
                while (rowSet.next()) {
                    AccountBadDebtCustDetailInfo info = new AccountBadDebtCustDetailInfo();
                    info.setLastUpdateUser(currentUser);
                    info.setLastUpdateTime(timestamp);
                    info.setCreator(currentUser);
                    info.setCreateTime(timestamp);
                    info.setNumber(debtNumber);
                    if (null == company) {
                        company = new CompanyOrgUnitInfo();
                        company.setId(BOSUuid.read((String)rowSet.getString("COMPANY_ID")));
                        company.setNumber(rowSet.getString("COMPANY_NUMBER"));
                        company.setName(rowSet.getString("COMPANY_NAME"));
                    }
                    info.setCompany(company);
                    String customerId = rowSet.getString("ASSTACT_ID");
                    CustomerInfo customerInfo = new CustomerInfo();
                    customerInfo.setId(BOSUuid.read((String)customerId));
                    customerInfo.setNumber(rowSet.getString("ASSTACT_NUMBER"));
                    customerInfo.setName(rowSet.getString("ASSTACT_NAME"));
                    info.setCustomer(customerInfo);
                    info.setBillType(OtherBillTypeEnum.getEnum((int)rowSet.getInt("BILL_TYPE")));
                    info.setRecieveData(rowSet.getTimestamp("RECIEVE_PAYDATE"));
                    key = BadAccountDebtFacadeControllerBean.genAccountAgeMapKey(company.getId().toString(), customerId);
                    if (BadAccountDebtFacadeControllerBean.hasMapValue(orgCustAgeMap, key)) {
                        this.caculateCustomerJTRate(info, currPeriodEndDate, (List)orgCustAgeMap.get(key));
                    }
                    info.setRecieveAmountLocal(new BigDecimal(rowSet.getDouble("RECIEVE_PAYAMOUNT_LOCAL")));
                    info.setVerifyAmountLocal(new BigDecimal(rowSet.getDouble("VERIFY_AMOUNT_LOCAL")));
                    info.setUnVerifyAmountLocal(new BigDecimal(rowSet.getDouble("UNVERIFY_AMT_LOCAL")));
                    info.setOtherbillNumber(rowSet.getString("BILL_NUMBER"));
                    rows.add(info);
                }
            }
            catch (SQLException e) {
                throw new BOSException("getAccountBadDebtCustDetailInfoList encounter error:" + e.getMessage());
            }
        }
        return rows;
    }

    public static boolean isMapEmpty(Map map) {
        return null == map || map.size() == 0;
    }

    @Override
    protected List _getBadAccountDebtCustDetail(Context ctx, Map idMap, Map isIncludeUndueMap, Map debtNumberMap, Map orgCustAccountAgeMap) throws BOSException, EASBizException {
        int unDueSize;
        ArrayList<AccountBadDebtCustDetailInfo> records = new ArrayList<AccountBadDebtCustDetailInfo>(150);
        if (BadAccountDebtFacadeControllerBean.isMapEmpty(idMap) || BadAccountDebtFacadeControllerBean.isMapEmpty(isIncludeUndueMap) || BadAccountDebtFacadeControllerBean.isMapEmpty(orgCustAccountAgeMap)) {
            return records;
        }
        int idSize = idMap.size();
        if (idSize != (unDueSize = isIncludeUndueMap.size())) {
            return records;
        }
        for (String companyId : idMap.keySet()) {
            String sql;
            List<AccountBadDebtCustDetailInfo> rows;
            boolean isBizDate;
            String customerIds = (String)idMap.get(companyId);
            if (StringUtils.isEmpty((String)customerIds) || StringUtils.isEmpty((String)companyId)) continue;
            HashMap paramMap = new HashMap();
            paramMap.put("AR_BadDebt_02", companyId);
            paramMap = ArApParamHelper.getParamHashMap(ctx, paramMap);
            int AR_BadDebt_02 = Integer.valueOf((String)paramMap.get("AR_BadDebt_02"));
            boolean bl = isBizDate = AR_BadDebt_02 == 1;
            if (!BOSUuid.isValid((String)customerIds, (boolean)false) || !BOSUuid.isValid((String)companyId, (boolean)false)) continue;
            PeriodInfo currentPeriod = this.getSystemStatusCtrol(ctx).getCacheCurrentPeriod(this.getSystemEnum().getValue(), companyId);
            PeriodInfo startPeriod = this.getSystemStatusCtrol(ctx).getStartPeriod(this.getSystemEnum().getValue(), companyId);
            boolean isRelationGL = this.isRelAccount(ctx, companyId, this.getSystemEnum()) && this.isGLStart(ctx, companyId);
            boolean isIncludeUndue = Boolean.valueOf(isIncludeUndueMap.get(companyId).toString());
            String debtNumber = null;
            if (!BadAccountDebtFacadeControllerBean.isMapEmpty(debtNumberMap) && BadAccountDebtFacadeControllerBean.hasMapValue(debtNumberMap, companyId)) {
                debtNumber = debtNumberMap.get(companyId).toString();
            }
            if (null == (rows = this.getAccountBadDebtCustDetailInfoList(ctx, sql = BadAccountDebtFacadeControllerBean.getBadAccountDebtCustDetailSQL(companyId, this.upDate(this.getJTDate(currentPeriod)), customerIds, isIncludeUndue, currentPeriod.getEndDate(), isRelationGL, startPeriod.getBeginDate(), isBizDate), debtNumber, currentPeriod.getEndDate(), orgCustAccountAgeMap)) || rows.size() <= 0) continue;
            records.addAll(rows);
        }
        return records;
    }

    public boolean isRelAccount(Context ctx, String comanyId, SystemEnum system) throws BOSException, EASBizException {
        return this.getSystemStatusCtrol(ctx).isRelatedAccount(comanyId, system);
    }

    private void saveAccountAnalysisBadDebtCustDetail(Context ctx, AccountBadDebtInfo editData, CurrencyInfo custCurrency, CompanyOrgUnitInfo company, BigDecimal exchangeRate, List rows) throws BOSException, EASBizException {
        String oldCustomerID = "";
        String customerID = null;
        BigDecimal prepareJTAmount = ZERO;
        BigDecimal preReceiveAmount = ZERO;
        BigDecimal badPrepareAmount = ZERO;
        BigDecimal patch = ZERO;
        BigDecimal rush = ZERO;
        String accountAge = null;
        String CSSPGroupID = null;
        String CCSPGroupID = null;
        String companyId = null;
        BigDecimal receiveBalance = ZERO;
        BigDecimal accrualRate = ZERO;
        BigDecimal otherReceiveBalance = ZERO;
        BigDecimal otherReceiveRate = ZERO;
        BigDecimal estimateLossSum = ZERO;
        int rowCount = rows.size();
        HashMap<String, CustomerInfo> cacheCustomer = new HashMap<String, CustomerInfo>();
        for (int i = 0; i < rowCount; ++i) {
            Map map = (Map)rows.get(i);
            companyId = map.get("companyId").toString();
            if (!companyId.equals(company.getId().toString())) continue;
            customerID = map.get("customerID").toString();
            CustomerInfo customerInfo = null;
            if (cacheCustomer.containsKey(customerID)) {
                customerInfo = (CustomerInfo)cacheCustomer.get(customerID);
            } else {
                customerInfo = this.getICustomer(ctx).getCustomerInfo((IObjectPK)new ObjectUuidPK(customerID));
                cacheCustomer.put(customerID, customerInfo);
            }
            CSSPGroupID = null == map.get("CSSPGroupID") ? null : map.get("CSSPGroupID").toString();
            CCSPGroupID = null == map.get("CCSPGroupID") ? null : map.get("CCSPGroupID").toString();
            int startDay = Integer.parseInt(map.get("startDay").toString());
            int endDay = Integer.parseInt(map.get("endDay").toString());
            int accountDays = Integer.parseInt(map.get("accountDays").toString());
            accountAge = map.get("accountAge").toString();
            prepareJTAmount = new BigDecimal(map.get("prepareJTAmount").toString());
            preReceiveAmount = new BigDecimal(map.get("preReceiveAmount").toString());
            badPrepareAmount = new BigDecimal(map.get("badPrepareAmount").toString());
            BigDecimal saleRecAmount = new BigDecimal(map.get("saleRecAmount").toString());
            BigDecimal otherSaleRecAmount = new BigDecimal(map.get("otherSaleRecAmount").toString());
            patch = new BigDecimal(map.get("custPatch").toString());
            rush = new BigDecimal(map.get("custRush").toString());
            if (patch.compareTo(ZERO) == 0 && rush.compareTo(ZERO) == 0) continue;
            otherReceiveBalance = new BigDecimal(map.get("otherReceiveBalance").toString());
            otherReceiveRate = new BigDecimal(map.get("otherReceiveRate").toString());
            receiveBalance = new BigDecimal(map.get("receiveBalance").toString());
            accrualRate = new BigDecimal(map.get("accrualRate").toString());
            estimateLossSum = new BigDecimal(map.get("estimateLossSum").toString());
            AccountBadDebtCustAnalysisEntryInfo info = new AccountBadDebtCustAnalysisEntryInfo();
            info.setSaleRecAmount(saleRecAmount);
            info.setOtherSaleRecAmount(otherSaleRecAmount);
            info.setCustomer(customerInfo);
            info.setCCSPGroupID(CCSPGroupID);
            info.setCSSPGroupID(CSSPGroupID);
            info.setStartDay(startDay);
            info.setEndDay(endDay);
            info.setAccountDays(accountDays);
            info.setAccountAge(accountAge);
            if (this.isPrepareCurrency) {
                info.setCurrency(custCurrency);
            } else {
                info.setCurrency(company.getBaseCurrency());
            }
            info.setExchangeRate(exchangeRate);
            info.setPrepareAmount(prepareJTAmount);
            info.setPreReceiveAmount(preReceiveAmount);
            info.setBadPrepareAmount(badPrepareAmount);
            info.setPatch(patch);
            info.setRush(rush);
            info.setOtherReceiveBalance(otherReceiveBalance);
            info.setOtherReceiveRate(otherReceiveRate);
            info.setReceiveBalance(receiveBalance);
            info.setAccrualRate(accrualRate);
            info.setEstimateLossSum(estimateLossSum);
            editData.getCustAnalysisEntry().add(info);
            if (!oldCustomerID.equals(customerID)) {
                AccountBadDebtCustEntryInfo custInfo = new AccountBadDebtCustEntryInfo();
                custInfo.setCustomer(customerInfo);
                if (this.isPrepareCurrency) {
                    custInfo.setCurrency(custCurrency);
                } else {
                    custInfo.setCurrency(company.getBaseCurrency());
                }
                custInfo.setExchangeRate(exchangeRate);
                custInfo.setPrepareAmount(prepareJTAmount);
                custInfo.setPreReceiveAmount(preReceiveAmount);
                custInfo.setBadPrepareAmount(badPrepareAmount);
                custInfo.setPatch(patch);
                custInfo.setRush(rush);
                editData.getCustAnalysisEntrys().add(custInfo);
            }
            oldCustomerID = customerID;
        }
    }

    public static String genAccountAgeMapKey(String companyId, String customerId) {
        return companyId + "_" + customerId;
    }

    protected void saveAccountBadDebtCustDetailInfo(Context ctx, List rows, Map<String, String> badDebtNumbers) throws BOSException, EASBizException {
        if (null == rows || rows.size() == 0 || null == badDebtNumbers || badDebtNumbers.size() == 0) {
            return;
        }
        int companyCount = badDebtNumbers.size();
        int size = rows.size();
        HashMap paramMap = new HashMap(5);
        HashMap<String, String> queryIds = new HashMap<String, String>(companyCount);
        HashMap idMap = new HashMap(companyCount);
        HashMap<String, Boolean> isIncludeUndueMap = new HashMap<String, Boolean>(companyCount);
        HashMap orgCustAccountAgeMap = new HashMap(60);
        for (int i = 0; i < size; ++i) {
            Map map = (Map)rows.get(i);
            String companyId = map.get("companyId").toString();
            if (!badDebtNumbers.containsKey(companyId)) continue;
            String customerId = map.get("customerID").toString();
            if (!idMap.containsKey(companyId)) {
                HashSet custIdSet = new HashSet(20);
                idMap.put(companyId, custIdSet);
            }
            ((Set)idMap.get(companyId)).add(customerId);
            int startDays = Integer.valueOf(map.get("startDay").toString());
            int endDays = Integer.valueOf(map.get("endDay").toString());
            if (!isIncludeUndueMap.containsKey(companyId)) {
                isIncludeUndueMap.put(companyId, false);
            }
            if (startDays == 0 && endDays == 0) {
                isIncludeUndueMap.put(companyId, true);
            }
            String daysDesc = map.get("accountAge").toString();
            BigDecimal jtRate = new BigDecimal(map.get("accrualRate").toString());
            BigDecimal otherJtRate = new BigDecimal(map.get("otherReceiveRate").toString());
            String key = BadAccountDebtFacadeControllerBean.genAccountAgeMapKey(companyId, customerId);
            if (!orgCustAccountAgeMap.containsKey(key)) {
                orgCustAccountAgeMap.put(key, new ArrayList(5));
            }
            HashMap<String, Object> accountAgeMap = new HashMap<String, Object>(6);
            accountAgeMap.put("customerId", customerId);
            accountAgeMap.put("daysDesc", daysDesc);
            accountAgeMap.put("startDays", startDays);
            accountAgeMap.put("endDays", endDays);
            accountAgeMap.put("jtRate", jtRate);
            accountAgeMap.put("otherJtRate", otherJtRate);
            ((List)orgCustAccountAgeMap.get(key)).add(accountAgeMap);
        }
        for (String companyId : idMap.keySet()) {
            Set custIdSet = (Set)idMap.get(companyId);
            queryIds.put(companyId, ArApStringUtil.convertSet2String(custIdSet));
        }
        List tableRowDataList = this.getBadAccountDebtCustDetail(ctx, queryIds, isIncludeUndueMap, badDebtNumbers, orgCustAccountAgeMap);
        CoreBaseCollection coll = new CoreBaseCollection();
        AccountBadDebtCustDetailInfo info = null;
        int count = tableRowDataList.size();
        for (int i = 0; i < count; ++i) {
            info = (AccountBadDebtCustDetailInfo)tableRowDataList.get(i);
            coll.add((CoreBaseInfo)info);
        }
        this.getIAccountBadDebtCustDetail(ctx).addnewBatchData(coll);
    }

    public static String getCompanyInfo(CompanyOrgUnitInfo company) {
        if (null == company) {
            return "";
        }
        return company.getName() + "\uff08" + Constant.NUMBER + "\uff1a" + company.getNumber() + "\uff09";
    }

    private void throwAccountBadDebtExceptionWithOrg(NumericExceptionSubItem item, CompanyOrgUnitInfo company) throws AccountBadDebtException {
        if (null == company || null == item) {
            throw new AccountBadDebtException(item);
        }
        throw new AccountBadDebtException(item, new Object[]{BadAccountDebtFacadeControllerBean.getCompanyInfo(company)});
    }

    private void throwAccountBadDebtException(String orgInfo, BadAccountParamEnum accountParam) throws AccountBadDebtException {
        String accountName = "";
        if (BadAccountParamEnum.ANALYSIS_CUSTOMER_PREPARE_ACCOUNT == accountParam) {
            accountName = Constant.PREPARE;
        }
        if (BadAccountParamEnum.ANALYSIS_CUSTOMER_LOSS_ACCOUNT == accountParam) {
            accountName = Constant.LOSS;
        }
        AccountBadDebtException abdExcp = new AccountBadDebtException(AccountBadDebtException.NOT_SET_ACCOUNT);
        if (!StringUtils.isEmpty((String)orgInfo) && !StringUtils.isEmpty((String)accountName)) {
            abdExcp = new AccountBadDebtException(AccountBadDebtException.NOT_SET_ACCOUNT, new Object[]{orgInfo, accountName});
        }
        logger.error((Object)abdExcp.getMessage());
        throw abdExcp;
    }

    private AccountViewInfo getAccount(Context ctx, Map params, BadAccountParamEnum accountParam, Map<String, AccountViewInfo> accountCache, CompanyOrgUnitInfo company) throws AccountBadDebtException {
        AccountViewInfo account = null;
        if (null == ctx || BadAccountDebtFacadeControllerBean.isMapEmpty(params) || null == accountParam || null == accountCache || null == company) {
            return account;
        }
        ParamItemInfo item = (ParamItemInfo)params.get(accountParam.getValue());
        String accountID = item.getValue();
        if (null != accountCache.get(accountID)) {
            account = accountCache.get(accountID);
        } else if (!StringUtils.isEmpty((String)accountID)) {
            String orgInfo = BadAccountDebtFacadeControllerBean.getCompanyInfo(company);
            try {
                account = this.getAccountView(ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountID));
            }
            catch (EASBizException ex) {
                this.throwAccountBadDebtException(orgInfo, accountParam);
            }
            catch (BOSException e) {
                this.throwAccountBadDebtException(orgInfo, accountParam);
            }
            if (null != account) {
                accountCache.put(accountID, account);
            }
        }
        return account;
    }

    @Override
    protected Map _submit(Context ctx, String accountType, String currencyID, List data) throws EASBizException {
        String method = "_submit";
        String errorMsg = "";
        HashMap<String, String> resultMap = new HashMap<String, String>(2);
        resultMap.put("status", Status.FAIL.name());
        if (StringUtils.isEmpty((String)accountType)) {
            errorMsg = BadAccountDebtFacadeControllerBean.getParamErrorMsg("_submit", "accountType");
        }
        if (null == data || data.size() == 0) {
            errorMsg = BadAccountDebtFacadeControllerBean.getParamErrorMsg("_submit", "data");
        }
        if (StringUtils.isEmpty((String)currencyID)) {
            errorMsg = BadAccountDebtFacadeControllerBean.getParamErrorMsg("_submit", "currencyID");
        }
        if (!StringUtils.isEmpty((String)errorMsg)) {
            resultMap.put("msg", errorMsg);
            return resultMap;
        }
        try {
            this.setPrepareCurrency(ctx);
            if (String.valueOf(5).equals(accountType)) {
                this.checkCustomerPrepareAmount(ctx, currencyID, data);
                CurrencyInfo currencyInfo = this.getICurrency(ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID));
                String oldCompanyId = "";
                String companyId = "";
                int size = data.size();
                AccountBadDebtInfo editData = null;
                HashSet<String> companyIdSet = new HashSet<String>();
                CoreBaseCollection badDebtColl = new CoreBaseCollection();
                HashMap<String, AccountViewInfo> accountCache = new HashMap<String, AccountViewInfo>();
                HashMap<String, String> badDebtNumbers = new HashMap<String, String>();
                HashSet<String> excludedIds = new HashSet<String>();
                for (int i = 0; i < size; ++i) {
                    Map map = (Map)data.get(i);
                    companyId = map.get("companyId").toString();
                    if (!oldCompanyId.equals(companyId)) {
                        ExchangeRateInfo rateInfo;
                        boolean isRushPathZero;
                        companyIdSet.add(companyId);
                        if (excludedIds.contains(companyId)) continue;
                        this.resetAmount();
                        this.caculateCustomerAmount(companyId, data);
                        boolean bl = isRushPathZero = this.totalRush.compareTo(ZERO) == 0 && this.totalPatch.compareTo(ZERO) == 0;
                        if (isRushPathZero) {
                            excludedIds.add(companyId);
                            continue;
                        }
                        PeriodInfo currentPeriod = this.getSystemStatusCtrol(ctx).getCacheCurrentPeriod(this.getSystemEnum().getValue(), companyId);
                        boolean isRelationGL = this.isRelAccount(ctx, companyId, this.getSystemEnum()) && this.isGLStart(ctx, companyId);
                        this.checkVoucheredOrSettleAccount(ctx, accountType, currencyID, currentPeriod, companyId, isRelationGL);
                        editData = new AccountBadDebtInfo();
                        CompanyOrgUnitInfo company = this.getCompanyOrgUnit(ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                        Date accountDate = this.getJTDate(currentPeriod);
                        if (this.isPrepareCurrency && null != company.getBaseCurrency() && !currencyID.equals(company.getBaseCurrency().getId().toString()) && null == (rateInfo = this.getExchangeRateInfo(ctx, company, currencyInfo, accountDate))) {
                            throw new BOSException(BadAccountDebtFacadeControllerBean.getCompanyInfo(company) + BadAccountDebtFacadeControllerBean.getARResource("lastday_exchangerate_not_exist"));
                        }
                        editData.setCompany(company);
                        editData.setCurrency(currencyInfo);
                        BigDecimal exchangeRate = this.getDateExchangeRate(ctx, company, currencyInfo, accountDate);
                        editData.setExchangeRate(exchangeRate);
                        editData.setAccountType(PrepareOptionMethodEnum.AnalyseCustMethod);
                        editData.setAccountDate(accountDate);
                        HashMap params = this.getBadAccountFacade(ctx).getParams(company);
                        AccountViewInfo account = this.getAccount(ctx, params, BadAccountParamEnum.ANALYSIS_CUSTOMER_PREPARE_ACCOUNT, accountCache, company);
                        AccountViewInfo badAccount = this.getAccount(ctx, params, BadAccountParamEnum.ANALYSIS_CUSTOMER_LOSS_ACCOUNT, accountCache, company);
                        ParamItemInfo paramItemInfo = (ParamItemInfo)params.get("arap003");
                        String arOtherParamID = paramItemInfo.getId().toString();
                        editData.setArOtherParam(arOtherParamID);
                        editData.setCU(company.getCU());
                        editData.setAccount(account);
                        editData.setBadAccount(badAccount);
                        editData.setAccountYear(accountDate.getYear() + 1900);
                        editData.setRush(this.totalRush);
                        editData.setPatch(this.totalPatch);
                        editData.setThisPrepareAmount(this.totalBadPrepareAmount);
                        editData.setPrepareAmount(this.totalPrepareAmount);
                        editData.setDescription(BadAccountDebtFacadeControllerBean.getARResource("badacct_prepare"));
                        String sysNumber = this.getNumberFromCodeRule(ctx, editData);
                        if (StringUtils.isEmpty((String)sysNumber)) {
                            throw new BOSException(BadAccountDebtFacadeControllerBean.getCompanyInfo(company) + BadAccountDebtFacadeControllerBean.getARResource("accural_bad_acct_number_null"));
                        }
                        editData.setNumber(sysNumber);
                        badDebtNumbers.put(companyId, sysNumber);
                        editData.setIsRelationGL(isRelationGL);
                        editData.setCreateTime(new Timestamp(new Date().getTime()));
                        editData.setCreator(SysContext.getSysContext().getCurrentUserInfo());
                        this.saveAccountAnalysisBadDebtCustDetail(ctx, editData, currencyInfo, company, exchangeRate, data);
                        badDebtColl.add((CoreBaseInfo)editData);
                    }
                    oldCompanyId = companyId;
                }
                if (excludedIds.size() > 0 && excludedIds.size() == companyIdSet.size()) {
                    throw new AccountBadDebtException(AccountBadDebtException.RUSH_PATCH_ZERO);
                }
                IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
                int badSize = badDebtColl.size();
                for (int i = 0; i < badSize; ++i) {
                    IObjectPK iObjectPK = iBTPManager.submitRelations((CoreBillBaseInfo)badDebtColl.get(i), null);
                }
                this.saveAccountBadDebtCustDetailInfo(ctx, data, badDebtNumbers);
            }
        }
        catch (BOSException e) {
            resultMap.put("msg", e.getMessage());
            return resultMap;
        }
        resultMap.put("status", Status.SUCCESS.name());
        resultMap.put("msg", "submit ok!");
        return resultMap;
    }

    public static class Constant {
        public static final String PREPARE = BadAccountDebtFacadeControllerBean.getARResource("PREPARE");
        public static final String LOSS = BadAccountDebtFacadeControllerBean.getARResource("LOSS");
        public static final String NUMBER = BadAccountDebtFacadeControllerBean.getARResource("NUMBER");
    }

    public static class QueryBadAccountDebtParamMap {
        public static final String QUERYIDS = "queryIds";
        public static final String ISINCLUDEUNDUE = "isIncludeUndue";
        public static final String BADDEBTNUMBERS = "badDebtNumbers";
        public static final String ORGCUSTACCOUNTAGE = "OrgCustAccountAge";

        public static class AccountAgeMap {
            public static final String CUSTOMERID = "customerId";
            public static final String DAYSDESC = "daysDesc";
            public static final String STARTDAYS = "startDays";
            public static final String ENDDAYS = "endDays";
            public static final String JTRATE = "jtRate";
            public static final String OTHERJTRATE = "otherJtRate";
        }
    }

    private static enum Status {
        SUCCESS,
        FAIL;

    }
}

