/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.basedata.master.account.AbstractAccountRefContrastProcess;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.BadAccountFacadeFactory;
import com.kingdee.eas.fi.ar.BadAccountParamEnum;
import com.kingdee.eas.fi.arap.util.ArApCommonUtil;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BadAccountRefContrastProcess
extends AbstractAccountRefContrastProcess {
    private static String[] badAcctParams = new String[]{BadAccountParamEnum.ANALYSIS_BILL_LOSS_ACCOUNT.getValue(), BadAccountParamEnum.ANALYSIS_BILL_PREPARE_ACCOUNT.getValue(), BadAccountParamEnum.ANALYSIS_CUSTOMER_LOSS_ACCOUNT.getValue(), BadAccountParamEnum.ANALYSIS_CUSTOMER_PREPARE_ACCOUNT.getValue(), BadAccountParamEnum.ANALYSIS_BILL_TOTAL_LOSS_ACCOUNT.getValue(), BadAccountParamEnum.ANALYSIS_BILL_TOTAL_PREPARE_ACCOUNT.getValue()};

    private Map getBadAcctParamItemMap(Context ctx, String companyID) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyID));
        HashMap allBadAcctParam = BadAccountFacadeFactory.getLocalInstance(ctx).getParams(company);
        HashMap<String, ParamItemInfo> params = new HashMap<String, ParamItemInfo>();
        for (int i = 0; i < badAcctParams.length; ++i) {
            if (allBadAcctParam.get(badAcctParams[i]) == null) continue;
            ParamItemInfo paramItem = (ParamItemInfo)allBadAcctParam.get(badAcctParams[i]);
            params.put(badAcctParams[i], paramItem);
        }
        return params;
    }

    private Map getBadAcctParamValueMap(Map paramItemMap) throws BOSException, EASBizException {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < badAcctParams.length; ++i) {
            if (paramItemMap.get(badAcctParams[i]) == null) continue;
            ParamItemInfo paramItem = (ParamItemInfo)paramItemMap.get(badAcctParams[i]);
            params.put(badAcctParams[i], paramItem.getValue());
        }
        return params;
    }

    private void updateParamItem(Context ctx, BOSUuid pk, ParamItemInfo model) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder(200);
        sql.append("update t_bas_paramItem set ");
        sql.append(" fvalue_L1").append(" = ?,");
        sql.append(" fvalue_L2").append(" = ?,");
        sql.append(" fvalue_L3").append(" = ?");
        sql.append(" where fid=?");
        Object[] params = new Object[]{model.getValue(), model.getValue(), model.getValue(), model.getId().toString()};
        DBUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    public boolean enable(Context ctx, String companyid, String id) throws BOSException, EASBizException {
        AccountRefContrastEntryInfo entryInfo;
        Map paramItemMap = this.getBadAcctParamItemMap(ctx, companyid);
        Map paramValueMap = this.getBadAcctParamValueMap(paramItemMap);
        if (paramValueMap.size() == 0) {
            return false;
        }
        AccountRefContrastEntryCollection refContrastEntryColl = AccountRefContrastEntryFactory.getLocalInstance((Context)ctx).getAccountRefContrastEntryCollection("where acctRefContrast.id = '" + id + "' and oldAcct.id in (" + ArApCommonUtil.transArr2SqlIdStr(paramValueMap.values()) + ")");
        HashMap<String, AccountRefContrastEntryInfo> accountProcessMap = new HashMap<String, AccountRefContrastEntryInfo>();
        for (int i = 0; i < refContrastEntryColl.size(); ++i) {
            entryInfo = refContrastEntryColl.get(i);
            accountProcessMap.put(entryInfo.getOldAcct().getId().toString(), entryInfo);
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("insert into T_AR_AccountProcessRecord ").append("(FID,FCompanyID,FAcctRefID,FParamNumber,FCreateTime,FOldAccountID,FNewAccountID) values ").append("(newbosid('88888888'),?,?,?,?,?,?)");
        for (Object key : paramValueMap.keySet()) {
            String oldAccountId;
            if (paramValueMap.get(key) == null || accountProcessMap.get(oldAccountId = paramValueMap.get(key).toString()) == null) continue;
            Object[] sqlParam = new Object[6];
            sqlParam[0] = companyid;
            sqlParam[1] = id;
            sqlParam[2] = key;
            sqlParam[3] = new Timestamp(System.currentTimeMillis());
            entryInfo = (AccountRefContrastEntryInfo)accountProcessMap.get(oldAccountId);
            sqlParam[4] = oldAccountId;
            sqlParam[5] = entryInfo.getNewAcct().getId().toString();
            paramList.add(sqlParam);
            ParamItemInfo paramItemInfo = (ParamItemInfo)paramItemMap.get(key);
            paramItemInfo.setValue(entryInfo.getNewAcct().getId().toString());
            this.updateParamItem(ctx, paramItemInfo.getId(), paramItemInfo);
        }
        DBUtil.executeBatch((Context)ctx, (String)insertSql.toString(), paramList);
        return false;
    }

    public boolean disEnable(Context ctx, String companyid, String id) throws BOSException, EASBizException {
        Map paramItemMap = this.getBadAcctParamItemMap(ctx, companyid);
        Map paramValueMap = this.getBadAcctParamValueMap(paramItemMap);
        StringBuilder sql = new StringBuilder();
        sql.append("select FParamNumber,FOldAccountID, FNewAccountID from T_AR_AccountProcessRecord where FAcctRefID = '").append(id).append("' and FCompanyID = '").append(companyid).append("'");
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String paramNumber = rs.getString("FParamNumber");
                String oldAcctID = rs.getString("FOldAccountID");
                String newAcctID = rs.getString("FNewAccountID");
                if (paramValueMap.get(paramNumber) == null || !newAcctID.equals(paramValueMap.get(paramNumber))) continue;
                ParamItemInfo paramItemInfo = (ParamItemInfo)paramItemMap.get(paramNumber);
                paramItemInfo.setValue(oldAcctID);
                this.updateParamItem(ctx, paramItemInfo.getId(), paramItemInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        sql.append("delete from T_AR_AccountProcessRecord where FAcctRefID = '").append(id).append("' and FCompanyID = '").append(companyid).append("'");
        DBUtil.execute((Context)ctx, (String)sql.toString());
        return false;
    }
}

