/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.BadAccountFacadeFactory;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.app.AbstractBadAcctReportFacadeControllerBean;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.LocaleUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BadAcctReportFacadeControllerBean
extends AbstractBadAcctReportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.BadAcctReportFacadeControllerBean");
    private static final String ArRpt_RESOURCE = "com.kingdee.eas.fi.ar.ArReport";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private String companyId = "1111";
    private String currencyId = "1111";
    private String asstActNumberFrom = null;
    private String asstActNumberTo = null;
    private Date billDateFrom = new Date();
    private Date billDateTo = new Date();
    private String sBillDateFrom = null;
    private String sBillDateTo = null;
    private String adminOrgUnitNumberFrom = null;
    private String adminOrgUnitNumberTo = null;
    private String rt = " \r\n";
    private CompanyOrgUnitInfo currentCompany;
    private boolean isPrepareCurrency = false;
    private int statisticObjectValue = 0;
    private String cuid = null;

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        RptParams pp = new RptParams();
        pp.setString("title", params.getString("init_title") + "BBB");
        return pp;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTable(params.getString("tempTable"), ctx);
        String tempTable = this.getTempTableName("badacct_report", ctx);
        this.currentCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        this.companyId = this.currentCompany.getId().toString();
        this.statisticObjectValue = Integer.parseInt(params.getObject("statisticObject").toString());
        this.currencyId = params.getObject("bizCurrency").toString();
        DataBaseInfo asstActInfoFrom = (DataBaseInfo)params.getObject("customerFrom");
        DataBaseInfo asstActInfoTo = (DataBaseInfo)params.getObject("customerTo");
        if (asstActInfoFrom != null) {
            this.asstActNumberFrom = asstActInfoFrom.getNumber();
        }
        if (asstActInfoTo != null) {
            this.asstActNumberTo = asstActInfoTo.getNumber();
        }
        AdminOrgUnitInfo adminOrgUnitInfoFrom = (AdminOrgUnitInfo)params.getObject("adminOrgUnitNumberFrom");
        AdminOrgUnitInfo adminOrgUnitInfoTo = (AdminOrgUnitInfo)params.getObject("adminOrgUnitNumberTo");
        if (adminOrgUnitInfoFrom != null) {
            this.adminOrgUnitNumberFrom = adminOrgUnitInfoFrom.getNumber();
        }
        if (adminOrgUnitInfoTo != null) {
            this.adminOrgUnitNumberTo = adminOrgUnitInfoTo.getNumber();
        }
        this.billDateFrom = (Date)params.getObject("billDateFrom");
        if (this.billDateFrom != null) {
            this.sBillDateFrom = sdf.format(this.billDateFrom);
        }
        this.billDateTo = (Date)params.getObject("billDateTo");
        if (this.billDateTo != null) {
            this.sBillDateTo = sdf.format(this.billDateTo);
        }
        this.isPrepareCurrency = (Boolean)params.getObject("isPrepareCurrency");
        this.isPrepareCurrency = !BadAccountFacadeFactory.getLocalInstance(ctx).isDisplayLocalCurrency();
        this.cuid = params.getObject("cuid").toString();
        this.executeCreateAsSelectInto(this.createTable(ctx, this.statisticObjectValue, tempTable), null, ctx);
        this.subTotalCurrency(ctx, tempTable, this.statisticObjectValue, this.isPrepareCurrency);
        RptTableHeader header = new RptTableHeader();
        this.setHeader(ctx, header, this.statisticObjectValue, this.isPrepareCurrency);
        String countSql = "select count(1) cc from " + tempTable;
        RptRowSet countRS = this.executeQuery(countSql, null, ctx);
        int count = 0;
        if (countRS.next()) {
            count = countRS.getInt(0);
        }
        params.setString("tempTable", tempTable);
        params.setObject("header", (Object)header);
        params.setInt("rowCount", count);
        return params;
    }

    private String createTable(Context ctx, int statisticObjectValue, String tempTable) throws BOSException, EASBizException {
        String table = null;
        StringBuffer sql = new StringBuffer();
        String asstActTypeID = this.getCustomerTypeID(ctx, this.cuid);
        if (2 == statisticObjectValue) {
            table = this.getSql(ctx, asstActTypeID);
            sql.append("SELECT FCurrencyID,FCurrency,isnull(FAdminOrgNumber,'') as FAdminOrgNumber,isnull(FAdminOrgUnit,'') as FAdminOrgUnit, ").append(this.rt);
            sql.append("sum(FPrepareAmount) AS FPrepareAmount, ").append(this.rt);
            sql.append("sum(FPrepareAmountLocal) AS FPrepareAmountLocal, ").append(this.rt);
            sql.append("sum(FBadAmount) AS FBadAmount, ").append(this.rt);
            sql.append("sum(FBadAmountLocal) AS FBadAmountLocal, ").append(this.rt);
            sql.append("sum(FTakeBackAmount) AS FTakeBackAmount, ").append(this.rt);
            sql.append("sum(FTakeBackAmountLocal) AS FTakeBackAmountLocal ").append(this.rt);
            sql.append(" INTO ").append(tempTable).append(this.rt);
            sql.append(" FROM (").append(table).append(" ) as bill ").append(this.rt);
            sql.append(" GROUP BY FCurrencyID,FCurrency,FAdminOrgNumber,FAdminOrgUnit ").append(this.rt);
        } else {
            table = this.getSql(ctx, asstActTypeID);
            sql.append("SELECT FCurrencyID,FCurrency,FAsstActNumber,FAsstActName, ").append(this.rt);
            sql.append("sum(FPrepareAmount) AS FPrepareAmount, ").append(this.rt);
            sql.append("sum(FPrepareAmountLocal) AS FPrepareAmountLocal, ").append(this.rt);
            sql.append("sum(FBadAmount) AS FBadAmount, ").append(this.rt);
            sql.append("sum(FBadAmountLocal) AS FBadAmountLocal, ").append(this.rt);
            sql.append("sum(FTakeBackAmount) AS FTakeBackAmount, ").append(this.rt);
            sql.append("sum(FTakeBackAmountLocal) AS FTakeBackAmountLocal ").append(this.rt);
            sql.append(" INTO ").append(tempTable).append(this.rt);
            sql.append(" FROM (").append(table).append(" ) as bill \r\n");
            sql.append(" GROUP BY FCurrencyID,FCurrency,FAsstActNumber,FAsstActName").append(this.rt);
        }
        return sql.toString();
    }

    private void setHeader(Context ctx, RptTableHeader header, int statisticObjectValue, boolean isPrepareCurrency) {
        RptTableColumn col = null;
        col = new RptTableColumn("currencyID");
        col.setWidth(120);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("currency");
        col.setWidth(120);
        header.addColumn(col);
        if (2 == statisticObjectValue) {
            col = new RptTableColumn("adminOrgUnitNumber");
            col.setWidth(150);
            header.addColumn(col);
            col = new RptTableColumn("adminOrgUnit");
            col.setWidth(200);
            header.addColumn(col);
        } else {
            col = new RptTableColumn("asstActNumber");
            col.setWidth(150);
            header.addColumn(col);
            col = new RptTableColumn("asstActName");
            col.setWidth(200);
            header.addColumn(col);
        }
        if (isPrepareCurrency) {
            col = new RptTableColumn("prepareAmount");
            col.setWidth(150);
            col.setAligment(2);
            header.addColumn(col);
            col = new RptTableColumn("badAmount");
            col.setWidth(150);
            col.setAligment(2);
            header.addColumn(col);
            col = new RptTableColumn("takeBackAmount");
            col.setWidth(150);
            col.setAligment(2);
            header.addColumn(col);
        } else {
            col = new RptTableColumn("prepareAmountLocal");
            col.setWidth(150);
            col.setAligment(2);
            header.addColumn(col);
            col = new RptTableColumn("badAmountLocal");
            col.setWidth(150);
            col.setAligment(2);
            header.addColumn(col);
            col = new RptTableColumn("takeBackAmountLocal");
            col.setWidth(150);
            col.setAligment(2);
            header.addColumn(col);
        }
        Locale local = ctx.getLocale();
        String currencyID = "currencyID";
        String currency = ResourceBase.getString((String)ArRpt_RESOURCE, (String)"badacct_report_title_currency", (Locale)local);
        String objectNumber = null;
        String objectName = null;
        if (2 == statisticObjectValue) {
            objectNumber = ResourceBase.getString((String)ArRpt_RESOURCE, (String)"badacct_report_title_adminOrgUnitNumber", (Locale)local);
            objectName = ResourceBase.getString((String)ArRpt_RESOURCE, (String)"badacct_report_title_adminOrgUnit", (Locale)local);
        } else {
            objectNumber = ResourceBase.getString((String)ArRpt_RESOURCE, (String)"badacct_report_title_asstActNumber", (Locale)local);
            objectName = ResourceBase.getString((String)ArRpt_RESOURCE, (String)"badacct_report_title_asstActName", (Locale)local);
        }
        String preparedAmount = null;
        String badAmount = null;
        String takeBackAmount = null;
        if (isPrepareCurrency) {
            preparedAmount = ResourceBase.getString((String)ArRpt_RESOURCE, (String)"badacct_report_title_preparedAmount", (Locale)local);
            badAmount = ResourceBase.getString((String)ArRpt_RESOURCE, (String)"badacct_report_title_badAmount", (Locale)local);
            takeBackAmount = ResourceBase.getString((String)ArRpt_RESOURCE, (String)"badacct_report_title_takeBackAmount", (Locale)local);
        } else {
            preparedAmount = ResourceBase.getString((String)ArRpt_RESOURCE, (String)"badacct_report_title_preparedAmount_local", (Locale)local);
            badAmount = ResourceBase.getString((String)ArRpt_RESOURCE, (String)"badacct_report_title_badAmount_local", (Locale)local);
            takeBackAmount = ResourceBase.getString((String)ArRpt_RESOURCE, (String)"badacct_report_title_takeBackAmount_local", (Locale)local);
        }
        header.setLabels((Object[][])new String[][]{{currencyID, currency, objectNumber, objectName, preparedAmount, badAmount, takeBackAmount}});
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        this.statisticObjectValue = Integer.parseInt(params.getObject("statisticObject").toString());
        StringBuffer sql = new StringBuffer("");
        sql.append(" select ");
        if (2 == this.statisticObjectValue) {
            sql.append("FCurrencyID,FCurrency,FAdminOrgNumber,FAdminOrgUnit, ");
            if (this.isPrepareCurrency) {
                sql.append(" FPrepareAmount,FBadAmount,FTakeBackAmount FROM (");
            } else {
                sql.append(" FPrepareAmountLocal,FBadAmountLocal,FTakeBackAmountLocal FROM (");
            }
            sql.append(" select * from (").append(this.rt);
            sql.append(" select * from (").append(this.rt);
            sql.append("SELECT  1 as id, FCurrencyID,FCurrency,FAdminOrgNumber,FAdminOrgUnit, ").append(this.rt);
        } else {
            sql.append("FCurrencyID,FCurrency,FAsstActNumber,FAsstActName, ");
            if (this.isPrepareCurrency) {
                sql.append(" FPrepareAmount,FBadAmount,FTakeBackAmount FROM (");
            } else {
                sql.append(" FPrepareAmountLocal,FBadAmountLocal,FTakeBackAmountLocal FROM (");
            }
            sql.append(" select * from (").append(this.rt);
            sql.append(" select * from (").append(this.rt);
            sql.append("SELECT 1 as id, FCurrencyID,FCurrency,FAsstActNumber,FAsstActName, ").append(this.rt);
        }
        boolean bl = this.isPrepareCurrency = !BadAccountFacadeFactory.getLocalInstance(ctx).isDisplayLocalCurrency();
        if (this.isPrepareCurrency) {
            sql.append(" FPrepareAmount,FBadAmount,FTakeBackAmount FROM ");
        } else {
            sql.append(" FPrepareAmountLocal,FBadAmountLocal,FTakeBackAmountLocal FROM ");
        }
        sql.append(tempTable).append(this.rt);
        if (2 == this.statisticObjectValue) {
            sql.append(" WHERE FAdminOrgNumber IS NOT NULL AND FAdminOrgNumber <> 'zzzzzzzzzzzzzzzzzzzz'");
            sql.append(" )  t1 ");
            sql.append(" UNION ").append(this.rt);
            sql.append(" select * from (").append(this.rt);
            sql.append("SELECT  2 as id, FCurrencyID,FCurrency,FAdminOrgNumber,FAdminOrgUnit, ").append(this.rt);
            if (this.isPrepareCurrency) {
                sql.append(" FPrepareAmount,FBadAmount,FTakeBackAmount FROM ");
            } else {
                sql.append(" FPrepareAmountLocal,FBadAmountLocal,FTakeBackAmountLocal FROM ");
            }
            sql.append(tempTable).append(this.rt);
            sql.append(" WHERE FAdminOrgNumber IS NOT NULL AND FAdminOrgNumber = 'zzzzzzzzzzzzzzzzzzzz' )  t2");
        } else {
            sql.append(" WHERE FAsstActNumber IS NOT NULL AND FAsstActNumber <> 'zzzzzzzzzzzzzzzzzzzz'");
            sql.append(" )  t1 ");
            sql.append(" UNION ").append(this.rt);
            sql.append(" select * from (").append(this.rt);
            sql.append("SELECT  2 as id, FCurrencyID,FCurrency,FAsstActNumber,FAsstActName, ").append(this.rt);
            if (this.isPrepareCurrency) {
                sql.append(" FPrepareAmount,FBadAmount,FTakeBackAmount FROM ");
            } else {
                sql.append(" FPrepareAmountLocal,FBadAmountLocal,FTakeBackAmountLocal FROM ");
            }
            sql.append(tempTable).append(this.rt);
            sql.append("WHERE FAsstActNumber IS NOT NULL AND FAsstActNumber = 'zzzzzzzzzzzzzzzzzzzz')  t2");
        }
        sql.append(")t ");
        sql.append(") t4 order by id,FCurrency,");
        if (2 == this.statisticObjectValue) {
            sql.append("FAdminOrgNumber");
        } else {
            sql.append("FAsstActNumber");
        }
        sql.append(this.rt);
        RptRowSet rs = this.executeQuery(sql.toString(), null, from, len, ctx);
        params.setObject("rowset", (Object)rs);
        return params;
    }

    private void subTotalCurrency(Context ctx, String tempTable, int statisticObjectValue, boolean isPrepareCurrency) throws BOSException {
        StringBuffer sql = new StringBuffer("");
        sql.append(" INSERT INTO  ").append(tempTable).append(this.rt);
        if (2 == statisticObjectValue) {
            sql.append(" SELECT FCurrencyID,FCurrency,FAdminOrgNumber,FAdminOrgUnit,").append(this.rt);
        } else {
            sql.append(" SELECT FCurrencyID,FCurrency,FAsstActNumber,FAsstActName,").append(this.rt);
        }
        sql.append(" SUM(FPrepareAmount) AS FPrepareAmount,").append(this.rt);
        sql.append(" SUM(FPrepareAmountLocal) AS FPrepareAmountLocal,").append(this.rt);
        sql.append(" SUM(FBadAmount) AS FBadAmount,").append(this.rt);
        sql.append(" SUM(FBadAmountLocal) AS FBadAmountLocal,").append(this.rt);
        sql.append(" SUM(FTakeBackAmount) AS FTakeBackAmount, ").append(this.rt);
        sql.append(" SUM(FTakeBackAmountLocal) AS FTakeBackAmountLocal ").append(this.rt);
        String sortNumber = "zzzzzzzzzzzzzzzzzzzz";
        if (2 == statisticObjectValue) {
            sql.append(" FROM (SELECT FCurrencyID,FCurrency, '" + sortNumber + "' as FAdminOrgNumber,").append(this.rt);
            sql.append(" '" + sortNumber + "' as FAdminOrgUnit,").append(this.rt);
        } else {
            sql.append(" FROM (SELECT FCurrencyID,FCurrency, '" + sortNumber + "' as FAsstActNumber,").append(this.rt);
            sql.append(" '" + sortNumber + "' as FAsstActName,").append(this.rt);
        }
        sql.append(" FPrepareAmount,FBadAmount,FTakeBackAmount,").append(this.rt);
        sql.append(" FPrepareAmountLocal,FBadAmountLocal,FTakeBackAmountLocal FROM ").append(tempTable).append(") AS bill ").append(this.rt);
        if (2 == statisticObjectValue) {
            sql.append(" GROUP BY FCurrencyID,FCurrency,FAdminOrgNumber,FAdminOrgUnit ").append(this.rt);
        } else {
            sql.append(" GROUP BY FCurrencyID,FCurrency,FAsstActNumber,FAsstActName ").append(this.rt);
        }
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static CurrencyInfo getIntegrateLocalCurrency(Context ctx) throws BOSException {
        ICurrency iCurr = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection currCollection = iCurr.getCurrencyCollection("select * where isoCode = 'GLC'");
        return currCollection.get(0);
    }

    private String getSql(Context ctx, String asstActTypeID) throws BOSException, EASBizException {
        PeriodInfo periodInfo;
        String lang = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        this.currentCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        this.isPrepareCurrency = !BadAccountFacadeFactory.getLocalInstance(ctx).isDisplayLocalCurrency();
        CurrencyInfo integrateCurrency = BadAcctReportFacadeControllerBean.getIntegrateLocalCurrency(ctx);
        StringBuffer sql = new StringBuffer("");
        sql.append("SELECT FCurrencyID,").append(this.rt);
        sql.append("FCurrency,").append(this.rt);
        sql.append("ISNULL(FAdminOrgUnitID,' ') as FAdminOrgUnitID,").append(this.rt);
        sql.append("ISNULL(FAdminOrgNumber,' ') as FAdminOrgNumber,").append(this.rt);
        sql.append("ISNULL(FAdminOrgUnit,' ') as FAdminOrgUnit,").append(this.rt);
        sql.append("FCompanyID,").append(this.rt);
        sql.append("FBillDate,").append(this.rt);
        sql.append("ISNULL(FAsstActTypeID,' ') as FAsstActTypeID,").append(this.rt);
        sql.append("ISNULL(FAsstActID,' ') as FAsstActID,").append(this.rt);
        sql.append("ISNULL(FAsstActNumber,' ') as FAsstActNumber,").append(this.rt);
        sql.append("ISNULL(FAsstActName,' ') as FAsstActName,").append(this.rt);
        sql.append("FPrepareAmount,").append(this.rt);
        sql.append("FPrepareAmountLocal,").append(this.rt);
        sql.append("FBadAmount,").append(this.rt);
        sql.append("FbadAmountLocal,").append(this.rt);
        sql.append("FTakeBackAmount,").append(this.rt);
        sql.append("FTakeBackAmountLocal from (").append(this.rt);
        sql.append("SELECT  ").append(this.rt);
        if (this.isPrepareCurrency) {
            sql.append(" debt.FCurrencyID AS FCurrencyID,").append(this.rt);
            sql.append("currency.FName_").append(lang).append(" AS FCurrency,").append(this.rt);
        } else {
            sql.append("'").append(integrateCurrency.getId().toString()).append("'").append(" as FCurrencyID, ").append(this.rt);
            sql.append("'").append(integrateCurrency.getName().toString()).append("'").append(" as FCurrency, ").append(this.rt);
        }
        sql.append("ISNULL(debtEntry.FAdminOrgUnitID,'') AS FAdminOrgUnitID,").append(this.rt);
        sql.append("ISNULL(adminOrg.FNumber,'') AS FAdminOrgNumber,").append(this.rt);
        sql.append("ISNULL(adminOrg.FName_").append(lang).append(",'') AS FAdminOrgUnit,").append(this.rt);
        sql.append("debt.FCompanyID AS FCompanyID,").append(this.rt);
        sql.append("debt.FAccountDate AS FBillDate,").append(this.rt);
        sql.append("debtEntry.FAsstActTypeID AS FAsstActTypeID,").append(this.rt);
        sql.append("debtEntry.FAsstActID AS FAsstActID,").append(this.rt);
        sql.append("customer.FNumber AS FAsstActNumber,").append(this.rt);
        sql.append("debtEntry.FAsstActName_").append(lang).append(" AS FAsstActName,").append(this.rt);
        sql.append("(debtEntry.FPatch - debtEntry.FRush) AS FPrepareAmount,").append(this.rt);
        sql.append("((debtEntry.FPatch - debtEntry.FRush) * debtEntry.FExchangeRate) AS FPrepareAmountLocal,").append(this.rt);
        sql.append("0.0 AS FBadAmount,").append(this.rt);
        sql.append("0.0 AS FbadAmountLocal,").append(this.rt);
        sql.append("0.0 AS FTakeBackAmount,").append(this.rt);
        sql.append("0.0 AS FTakeBackAmountLocal ").append(this.rt);
        sql.append("FROM T_AR_AccountBadDebt debt ").append(this.rt);
        sql.append("INNER JOIN T_AR_AccountBadDebtBillEntry debtEntry ").append(this.rt);
        sql.append("ON debt.FID = debtEntry.FAccountBadDebtID ").append(this.rt);
        if (this.isPrepareCurrency) {
            sql.append("INNER JOIN T_BD_Currency currency ").append(this.rt);
            sql.append("ON debt.FCurrencyID = currency.FID ").append(this.rt);
        }
        sql.append("LEFT OUTER JOIN T_ORG_Admin adminOrg  ").append(this.rt);
        sql.append("ON debtEntry.FAdminOrgUnitID = adminOrg.FID ").append(this.rt);
        sql.append("INNER JOIN T_BD_Customer customer ").append(this.rt);
        sql.append("ON debtEntry.FAsstActID = customer.FID ").append(this.rt);
        sql.append(" WHERE debt.FCompanyID = '").append(this.companyId).append("'").append(this.rt);
        if (this.isPrepareCurrency && this.currencyId != null && !"".equals(this.currencyId)) {
            sql.append(" AND debt.FCurrencyID = '").append(this.currencyId).append("'").append(this.rt);
        }
        if (this.asstActNumberFrom != null && !"".equals(this.asstActNumberFrom)) {
            sql.append(" AND customer.FNumber >= '").append(this.asstActNumberFrom).append("'").append(this.rt);
        }
        if (this.asstActNumberTo != null && !"".equals(this.asstActNumberTo)) {
            sql.append(" AND customer.FNumber <= '").append(this.asstActNumberTo).append("'").append(this.rt);
        }
        if (this.adminOrgUnitNumberFrom != null && !"".equals(this.adminOrgUnitNumberFrom)) {
            sql.append(" AND adminOrg.FNumber >= '").append(this.adminOrgUnitNumberFrom).append("'").append(this.rt);
        }
        if (this.adminOrgUnitNumberTo != null && !"".equals(this.adminOrgUnitNumberTo)) {
            sql.append(" AND adminOrg.FNumber <= '").append(this.adminOrgUnitNumberTo).append("'").append(this.rt);
        }
        if (this.sBillDateFrom != null && !"".equals(this.sBillDateFrom)) {
            sql.append(" AND debt.FAccountDate >= {").append(this.sBillDateFrom).append("}").append(this.rt);
        }
        if (this.sBillDateTo != null && !"".equals(this.sBillDateTo)) {
            sql.append(" AND debt.FAccountDate <= {").append(this.sBillDateTo).append("}").append(this.rt);
        }
        if (1 == this.statisticObjectValue && asstActTypeID != null && !"".equals(asstActTypeID)) {
            sql.append(" AND debtEntry.FAsstActTypeID = '").append(asstActTypeID).append("'").append(this.rt);
        }
        sql.append(" AND debt.FAuditDate IS NOT NULL ").append(this.rt);
        sql.append(" UNION ALL ").append(this.rt);
        sql.append("SELECT ").append(this.rt);
        if (this.isPrepareCurrency) {
            sql.append(" badAcct.FCurrencyID AS FCurrencyID,").append(this.rt);
            sql.append("currency.FName_").append(lang).append(" AS FCurrency,").append(this.rt);
        } else {
            sql.append("'").append(integrateCurrency.getId().toString()).append("'").append(" as FCurrencyID, ").append(this.rt);
            sql.append("'").append(integrateCurrency.getName().toString()).append("'").append(" as FCurrency, ").append(this.rt);
        }
        sql.append("isnull(badAcct.FAdminOrgUnitID,'') AS FAdminOrgUnitID,").append(this.rt);
        sql.append("isnull(adminOrg.FNumber,'') AS FAdminOrgNumber,").append(this.rt);
        sql.append("isnull(adminOrg.FName_").append(lang).append(",'') AS FAdminOrgUnit,").append(this.rt);
        sql.append("badAcct.FCompanyID AS FCompanyID,").append(this.rt);
        sql.append("badAcct.FBadAcctDate AS FBillDate,").append(this.rt);
        sql.append("badAcct.FCussentTypeID AS FAsstActTypeID,").append(this.rt);
        sql.append("badAcct.FAcctCussentID AS FAsstActID,").append(this.rt);
        sql.append("customer.FNumber AS FAsstActNumber,").append(this.rt);
        sql.append("badAcct.FAcctCussentName_").append(lang).append(" AS FAsstActName, ").append(this.rt);
        sql.append("0.0 AS FPrepareAmount, ").append(this.rt);
        sql.append("0.0 AS FPrepareAmountLocal, ").append(this.rt);
        sql.append("badAcct.FBadAmounts AS FBadAmount, ").append(this.rt);
        sql.append("badAcct.FBadAmountsLocal AS FbadAmountLocal, ").append(this.rt);
        sql.append("0.0 AS FTakeBackAmount, ").append(this.rt);
        sql.append("0.0 AS FTakeBackAmountLocal ").append(this.rt);
        sql.append("FROM T_AR_BadAcct badAcct ").append(this.rt);
        if (this.isPrepareCurrency) {
            sql.append("INNER JOIN T_BD_Currency currency ").append(this.rt);
            sql.append("ON badAcct.FCurrencyID = currency.FID ").append(this.rt);
        }
        sql.append("LEFT OUTER JOIN T_ORG_Admin adminOrg ").append(this.rt);
        sql.append("ON badAcct.FAdminOrgUnitID = adminOrg.FID ").append(this.rt);
        sql.append("INNER JOIN T_BD_Customer customer ").append(this.rt);
        sql.append("ON badAcct.FAcctCussentID = customer.FID ").append(this.rt);
        sql.append(" WHERE badAcct.FCompanyID = '").append(this.companyId).append("'").append(this.rt);
        if (this.isPrepareCurrency && this.currencyId != null && !"".equals(this.currencyId)) {
            sql.append(" AND badAcct.FCurrencyID = '").append(this.currencyId).append("'").append(this.rt);
        }
        if (this.asstActNumberFrom != null && !"".equals(this.asstActNumberFrom)) {
            sql.append(" AND customer.FNumber >= '").append(this.asstActNumberFrom).append("'").append(this.rt);
        }
        if (this.asstActNumberTo != null && !"".equals(this.asstActNumberTo)) {
            sql.append(" AND customer.FNumber <= '").append(this.asstActNumberTo).append("'").append(this.rt);
        }
        if (this.adminOrgUnitNumberFrom != null && !"".equals(this.adminOrgUnitNumberFrom)) {
            sql.append(" AND adminOrg.FNumber >= '").append(this.adminOrgUnitNumberFrom).append("'").append(this.rt);
        }
        if (this.adminOrgUnitNumberTo != null && !"".equals(this.adminOrgUnitNumberTo)) {
            sql.append(" AND adminOrg.FNumber <= '").append(this.adminOrgUnitNumberTo).append("'").append(this.rt);
        }
        if (this.sBillDateFrom != null && !"".equals(this.sBillDateFrom)) {
            sql.append(" AND badAcct.FBadAcctDate >= {").append(this.sBillDateFrom).append("}").append(this.rt);
        }
        if (this.sBillDateTo != null && !"".equals(this.sBillDateTo)) {
            sql.append(" AND badAcct.FBadAcctDate <= {").append(this.sBillDateTo).append("}").append(this.rt);
        }
        if (1 == this.statisticObjectValue && asstActTypeID != null && !"".equals(asstActTypeID)) {
            sql.append(" AND badAcct.FCussentTypeID = '").append(asstActTypeID).append("'").append(this.rt);
        }
        sql.append(" AND badAcct.FAuditDate IS NOT NULL ").append(this.rt);
        sql.append(" UNION ALL ").append(this.rt);
        sql.append("SELECT  ").append(this.rt);
        if (this.isPrepareCurrency) {
            sql.append(" billEntry.FCurrencyID AS FCurrencyID,").append(this.rt);
            sql.append("currency.FName_").append(lang).append(" AS FCurrency,").append(this.rt);
        } else {
            sql.append("'").append(integrateCurrency.getId().toString()).append("'").append(" as FCurrencyID, ").append(this.rt);
            sql.append("'").append(integrateCurrency.getName().toString()).append("'").append(" as FCurrency, ").append(this.rt);
        }
        sql.append("isnull(billEntry.FAdminOrgUnitID,'') AS FAdminOrgUnitID,").append(this.rt);
        sql.append("isnull(adminOrg.FNumber,'') AS FAdminOrgNumber,").append(this.rt);
        sql.append("isnull(adminOrg.FName_").append(lang).append(",'') AS FAdminOrgUnit,").append(this.rt);
        sql.append("bill.FCompanyID AS FCompanyID,").append(this.rt);
        sql.append("bill.FBizDate AS FBillDate,").append(this.rt);
        sql.append("billEntry.FAcctCussTypeID AS FAsstActTypeID,").append(this.rt);
        sql.append("billEntry.FAcctCussID AS FAsstActID,").append(this.rt);
        sql.append("customer.FNumber AS FAsstActNumber,").append(this.rt);
        sql.append("billEntry.FAcctCussName_").append(lang).append(" AS FAsstActName,").append(this.rt);
        sql.append("0.0 AS FPrepareAmount, ").append(this.rt);
        sql.append("0.0 AS FPrepareAmountLocal, ").append(this.rt);
        sql.append("0.0 AS FBadAmount,").append(this.rt);
        sql.append("0.0 AS FbadAmountLocal, ").append(this.rt);
        sql.append("billEntry.FThisVerificateAmt AS FTakeBackAmount, ").append(this.rt);
        sql.append("billEntry.FThisVerificateAmtLoc AS FTakeBackAmountLocal ").append(this.rt);
        sql.append("FROM T_AR_VerificationBill bill ").append(this.rt);
        sql.append("INNER JOIN  T_AR_VerificationBillEntry billEntry ").append(this.rt);
        sql.append("ON bill.FID = billEntry.FParentID ").append(this.rt);
        if (this.isPrepareCurrency) {
            sql.append("INNER JOIN T_BD_Currency currency ").append(this.rt);
            sql.append("ON billEntry.FCurrencyID = currency.FID ").append(this.rt);
        }
        sql.append("LEFT OUTER JOIN T_ORG_Admin adminOrg ").append(this.rt);
        sql.append("ON billEntry.FAdminOrgUnitID = adminOrg.FID ").append(this.rt);
        sql.append("INNER JOIN T_BD_Customer customer ").append(this.rt);
        sql.append("ON billEntry.FAcctCussID = customer.FID ").append(this.rt);
        sql.append("WHERE (billEntry.FBillType = ").append(15).append(" \r\n");
        sql.append("OR billEntry.FBillType = ").append(16).append(")").append("\r\n");
        sql.append(" AND bill.FCompanyID = '").append(this.companyId).append("'").append(this.rt);
        if (this.isPrepareCurrency && this.currencyId != null && !"".equals(this.currencyId)) {
            sql.append(" AND billEntry.FCurrencyID = '").append(this.currencyId).append("'").append(this.rt);
        }
        if (this.asstActNumberFrom != null && !"".equals(this.asstActNumberFrom)) {
            sql.append(" AND customer.FNumber >= '").append(this.asstActNumberFrom).append("'").append(this.rt);
        }
        if (this.asstActNumberTo != null && !"".equals(this.asstActNumberTo)) {
            sql.append(" AND customer.FNumber <= '").append(this.asstActNumberTo).append("'").append(this.rt);
        }
        if (this.adminOrgUnitNumberFrom != null && !"".equals(this.adminOrgUnitNumberFrom)) {
            sql.append(" AND adminOrg.FNumber >= '").append(this.adminOrgUnitNumberFrom).append("'").append(this.rt);
        }
        if (this.adminOrgUnitNumberTo != null && !"".equals(this.adminOrgUnitNumberTo)) {
            sql.append(" AND adminOrg.FNumber <= '").append(this.adminOrgUnitNumberTo).append("'").append(this.rt);
        }
        if (this.sBillDateFrom != null && !"".equals(this.sBillDateFrom)) {
            sql.append(" AND bill.FBizDate >= {").append(this.sBillDateFrom).append("}").append(this.rt);
        }
        if (this.sBillDateTo != null && !"".equals(this.sBillDateTo)) {
            sql.append(" AND bill.FBizDate <= {").append(this.sBillDateTo).append("}").append(this.rt);
        }
        if (1 == this.statisticObjectValue && asstActTypeID != null && !"".equals(asstActTypeID)) {
            sql.append(" AND billEntry.FAcctCussTypeID = '").append(asstActTypeID).append("'");
        }
        if (1 == this.statisticObjectValue) {
            sql.append(" UNION ALL ").append(this.rt);
            sql.append("SELECT ").append(this.rt);
            if (this.isPrepareCurrency) {
                sql.append(" debt.FCurrencyID AS FCurrencyID,").append(this.rt);
                sql.append("currency.FName_").append(lang).append(" AS FCurrency,").append(this.rt);
            } else {
                sql.append("'").append(integrateCurrency.getId().toString()).append("'").append(" as FCurrencyID, ").append(this.rt);
                sql.append("'").append(integrateCurrency.getName().toString()).append("'").append(" as FCurrency, ").append(this.rt);
            }
            sql.append("NULL AS FAdminOrgUnitID,").append(this.rt);
            sql.append("NULL AS FAdminOrgNumber,").append(this.rt);
            sql.append("NULL AS FAdminOrgUnit,").append(this.rt);
            sql.append("debt.FCompanyID AS FCompanyID,").append(this.rt);
            sql.append("debt.FAccountDate AS FBillDate,").append(this.rt);
            sql.append("NULL AS FAsstActTypeID,").append(this.rt);
            sql.append("customer.FID AS FAsstActID,").append(this.rt);
            sql.append("customer.FNumber AS FAsstActNumber,").append(this.rt);
            sql.append("customer.FName_").append(lang).append(" AS FAsstActName, ").append(this.rt);
            sql.append("(debtEntry.FPatch - debtEntry.FRush) AS FPrepareAmount,").append(this.rt);
            sql.append("((debtEntry.FPatch - debtEntry.FRush) * debtEntry.FExchangeRate) AS FPrepareAmountLocal,").append(this.rt);
            sql.append("0.0 AS FBadAmount,").append(this.rt);
            sql.append("0.0 AS FbadAmountLocal,").append(this.rt);
            sql.append("0.0 AS FTakeBackAmount,").append(this.rt);
            sql.append("0.0 AS FTakeBackAmountLocal ").append(this.rt);
            sql.append("FROM T_AR_AccountBadDebt debt ").append(this.rt);
            sql.append("INNER JOIN T_AR_AccountBadDebtCustEntrys debtEntry ").append(this.rt);
            sql.append("ON debt.FID = debtEntry.FAccountBadDebtID ").append(this.rt);
            if (this.isPrepareCurrency) {
                sql.append("INNER JOIN T_BD_Currency currency ").append(this.rt);
                sql.append("ON debt.FCurrencyID = currency.FID ").append(this.rt);
            }
            sql.append("INNER JOIN T_BD_Customer customer ").append(this.rt);
            sql.append("ON debtEntry.FCustomerID = customer.FID ").append(this.rt);
            sql.append(" WHERE debt.FCompanyID = '").append(this.companyId).append("'").append(this.rt);
            if (this.isPrepareCurrency && this.currencyId != null && !"".equals(this.currencyId)) {
                sql.append(" AND debt.FCurrencyID = '").append(this.currencyId).append("'").append(this.rt);
            }
            if (this.asstActNumberFrom != null && !"".equals(this.asstActNumberFrom)) {
                sql.append(" AND customer.FNumber >= '").append(this.asstActNumberFrom).append("'").append(this.rt);
            }
            if (this.asstActNumberTo != null && !"".equals(this.asstActNumberTo)) {
                sql.append(" AND customer.FNumber <= '").append(this.asstActNumberTo).append("'").append(this.rt);
            }
            if (this.sBillDateFrom != null && !"".equals(this.sBillDateFrom)) {
                sql.append(" AND debt.FAccountDate >= {").append(this.sBillDateFrom).append("}").append(this.rt);
            }
            if (this.sBillDateTo != null && !"".equals(this.sBillDateTo)) {
                sql.append(" AND debt.FAccountDate <= {").append(this.sBillDateTo).append("}").append(this.rt);
            }
            sql.append(" AND debt.FAuditDate IS NOT NULL ").append(this.rt);
        }
        sql.append(" UNION ALL ").append(this.rt);
        sql.append("SELECT ").append(this.rt);
        if (this.isPrepareCurrency) {
            sql.append(" badAcct.FCurrencyID AS FCurrencyID,").append(this.rt);
            sql.append("currency.FName_").append(lang).append(" AS FCurrency,").append(this.rt);
        } else {
            sql.append("'").append(integrateCurrency.getId().toString()).append("'").append(" as FCurrencyID, ").append(this.rt);
            sql.append("'").append(integrateCurrency.getName().toString()).append("'").append(" as FCurrency, ").append(this.rt);
        }
        sql.append("isnull(initBadAcct.FAdminOrgUnitID,'') AS FAdminOrgUnitID,").append(this.rt);
        sql.append("isnull(adminOrg.FNumber,'') AS FAdminOrgNumber,").append(this.rt);
        sql.append("isnull(adminOrg.FName_").append(lang).append(",'') AS FAdminOrgUnit,").append(this.rt);
        sql.append("initBadAcct.FCompanyID AS FCompanyID,").append(this.rt);
        sql.append("initBadAcct.FBadAccountDate AS FBillDate,").append(this.rt);
        sql.append("initBadAcct.FAsstActTypeID AS FAsstActTypeID,").append(this.rt);
        sql.append("initBadAcct.FAcctCussentID AS FAsstActID,").append(this.rt);
        sql.append("customer.FNumber AS FAsstActNumber,").append(this.rt);
        sql.append("initBadAcct.FAcctCussentName_").append(lang).append(" AS FAsstActName, ").append(this.rt);
        sql.append("0.0 AS FPrepareAmount, ").append(this.rt);
        sql.append("0.0 AS FPrepareAmountLocal, ").append(this.rt);
        sql.append("initBadAcct.FAmounts AS FBadAmount, ").append(this.rt);
        sql.append("initBadAcct.FAmountsLocal AS FbadAmountLocal, ").append(this.rt);
        sql.append("0.0 AS FTakeBackAmount, ").append(this.rt);
        sql.append("0.0 AS FTakeBackAmountLocal ").append(this.rt);
        sql.append(" FROM  T_AR_InitBadAccount initBadAcct  ").append(this.rt);
        if (this.isPrepareCurrency) {
            sql.append("INNER JOIN T_BD_Currency currency ").append(this.rt);
            sql.append("ON initBadAcct.FCurrencyID = currency.FID ").append(this.rt);
        }
        sql.append(" LEFT OUTER JOIN T_ORG_Admin adminOrg ").append(this.rt);
        sql.append(" ON initBadAcct.FAdminOrgUnitID = adminOrg.FID ").append(this.rt);
        sql.append(" INNER JOIN T_BD_Customer customer ").append(this.rt);
        sql.append(" ON initBadAcct.FAcctCussentID = customer.FID ").append(this.rt);
        sql.append(" WHERE initBadAcct.FCompanyID = '").append(this.companyId).append("'").append(this.rt);
        if (this.isPrepareCurrency && this.currencyId != null && !"".equals(this.currencyId)) {
            sql.append(" AND initBadAcct.FCurrencyID = '").append(this.currencyId).append("'").append(this.rt);
        }
        if (this.asstActNumberFrom != null && !"".equals(this.asstActNumberFrom)) {
            sql.append(" AND customer.FNumber >= '").append(this.asstActNumberFrom).append("'").append(this.rt);
        }
        if (this.asstActNumberTo != null && !"".equals(this.asstActNumberTo)) {
            sql.append(" AND customer.FNumber <= '").append(this.asstActNumberTo).append("'").append(this.rt);
        }
        if (this.adminOrgUnitNumberFrom != null && !"".equals(this.adminOrgUnitNumberFrom)) {
            sql.append(" AND adminOrg.FNumber >= '").append(this.adminOrgUnitNumberFrom).append("'").append(this.rt);
        }
        if (this.adminOrgUnitNumberTo != null && !"".equals(this.adminOrgUnitNumberTo)) {
            sql.append(" AND adminOrg.FNumber <= '").append(this.adminOrgUnitNumberTo).append("'").append(this.rt);
        }
        if (this.sBillDateFrom != null && !"".equals(this.sBillDateFrom)) {
            sql.append(" AND initBadAcct.FBadAccountDate  >= {").append(this.sBillDateFrom).append("}").append(this.rt);
        }
        if (this.sBillDateTo != null && !"".equals(this.sBillDateTo)) {
            sql.append(" AND initBadAcct.FBadAccountDate  <= {").append(this.sBillDateTo).append("}").append(this.rt);
        }
        if (1 == this.statisticObjectValue && asstActTypeID != null && !"".equals(asstActTypeID)) {
            sql.append(" AND initBadAcct.FAsstActTypeID = '").append(asstActTypeID).append("'").append(this.rt);
        }
        if ((periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (IObjectPK)new ObjectUuidPK(this.companyId))) == null) {
            throw new OtherBillBizException(OtherBillBizException.BIZDATENOTMATCHERPERIOD);
        }
        sql.append(" AND initBadAcct.FBadAccountDate < to_date('").append(periodInfo.getBeginDate()).append("')").append(this.rt);
        sql.append(" ) as bill ");
        return sql.toString();
    }

    private String getCustomerTypeID(Context ctx, String cuid) throws BOSException {
        String AsstActTypeID = null;
        IAsstActType iAsstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo HGAttributeFilter = new FilterItemInfo("asstHGAttribute", (Object)"customer", CompareType.EQUALS);
        filterInfo.getFilterItems().add(HGAttributeFilter);
        filterInfo.setMaskString("(#0)");
        view.setFilter(filterInfo);
        AsstActTypeCollection asstActTypeColl = iAsstActType.getAsstActTypeCollection(view);
        if (asstActTypeColl != null && asstActTypeColl.size() > 0) {
            AsstActTypeID = asstActTypeColl.get(0).getId().toString();
        }
        return AsstActTypeID;
    }
}

