/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ap.app.util.ApServerUtils;
import com.kingdee.eas.fi.ar.AccountSettleBillTypeEnum;
import com.kingdee.eas.fi.ar.ArApReportData;
import com.kingdee.eas.fi.ar.ContrastAccountViewCollection;
import com.kingdee.eas.fi.ar.ContrastAccountViewFactory;
import com.kingdee.eas.fi.ar.ContrastGLCheckParam;
import com.kingdee.eas.fi.ar.ContrastGLException;
import com.kingdee.eas.fi.ar.ContrastGLFacade;
import com.kingdee.eas.fi.ar.ContrastGLQueryParam;
import com.kingdee.eas.fi.ar.IReportData;
import com.kingdee.eas.fi.ar.ReportInfo;
import com.kingdee.eas.fi.ar.app.AbstractContrastGLFacadeControllerBean;
import com.kingdee.eas.fi.ar.app.ArApReportHelper;
import com.kingdee.eas.fi.ar.app.ContrastGLHelper;
import com.kingdee.eas.fi.ar.app.util.ArServerUtils;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.arap.ARAPCommonServerFacadeFactory;
import com.kingdee.eas.fi.arap.AmountDirectionEnum;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.BosTypeEnum;
import com.kingdee.eas.fi.arap.ContrastGLDiffTypeEnum;
import com.kingdee.eas.fi.arap.ContrastGLRptDetailQueryParam;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.util.TempTableUtil;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.fi.arap.util.ArApParams;
import com.kingdee.eas.fi.arap.util.ArApStringUtil;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.im.inv.invconfig.SQLDataAccessFacadeFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class ContrastGLFacadeControllerBean
extends AbstractContrastGLFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.ContrastGLFacadeControllerBean");
    public static final String NEW_LINE = " \r\n ";
    private final String CONTRAST_GROUP_BY_CUSS_COLUMNS = " FCussTypeID, FCussType, FCussAcct, FCussNum, FCussName";
    private final String CONTRAST_TMP_TABLE_CUSS_COLUMNS = " FCussTypeID, FCussType, FCussAcct, FCussNum, FCussName,  \r\n ";
    public static final String TEMP_INSERT_SQL = "insertSQL";
    public static int cpus = Runtime.getRuntime().availableProcessors();
    private final String DEFAULT_EMPTY_VOUCHER_ID = "'~~~~~~~~~~~~~~~~~~~~~~~~~~~~'";
    private final String GL = "GL";
    private final String GL_PREFIX = "GL.";
    private final String ARAP = "ARAP";
    private final String ARAP_PREFIX = "ARAP.";

    @Override
    protected IReportData _checkAPGL(Context ctx, ContrastGLCheckParam checkParam) throws BOSException, EASBizException {
        IReportData rptData = this.checkArApGLWithLogging(ctx, checkParam, false);
        return rptData;
    }

    private void checkParam(ContrastGLCheckParam param) throws EASBizException {
        if (param == null) {
            throw new NullPointerException("param is null");
        }
        if (StringUtils.isEmpty((String)param.getCompanyId())) {
            throw new ContrastGLException(ContrastGLException.COMPANY_NULL);
        }
        if (param.isCheckVoucherRelatedBill() && (param.getAccountIds() == null || param.getAccountIds().size() == 0)) {
            throw new ContrastGLException(ContrastGLException.ACCOUNT_NULL);
        }
    }

    private IReportData checkArApGLWithLogging(Context ctx, ContrastGLCheckParam checkParam, boolean fAR) throws BOSException, EASBizException {
        this.processContext(ctx);
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(checkParam.getCompanyId()));
        String manipulateObject = this.getDisplayManipulateObject(companyOrgUnitInfo);
        String logItem = fAR ? "fi_ar_PeriodCheck" : "fi_ap_PeriodCheck";
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new ContrastGLFacade().getType(), null, (String)manipulateObject, (String)logItem);
        this.checkParam(checkParam);
        IReportData iReportData = this.checkArApGL(ctx, checkParam, fAR);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return iReportData;
    }

    private IReportData checkArApGL(Context ctx, ContrastGLCheckParam checkParam, boolean fAR) throws BOSException, EASBizException {
        IReportData rptData;
        boolean fCheckAudited = checkParam.isCheckBillAudited();
        boolean fCheckVouchered = checkParam.isCheckBillVouchered();
        boolean fCheckVoucherBill = checkParam.isCheckVoucherRelatedBill();
        boolean fCheckVoucherPeriod = checkParam.isCheckVoucherPeriod();
        if (!(fCheckAudited || fCheckVouchered || fCheckVoucherBill || fCheckVoucherPeriod || checkParam.ischkCashVerifiBill())) {
            return null;
        }
        String companyId = checkParam.getCompanyId();
        List accountIds = checkParam.getAccountIds();
        HashMap paramKeyMap = new HashMap();
        if (fAR) {
            paramKeyMap.put("AR_RECVOUCHER_BILLTYPE", companyId);
            paramKeyMap.put("AR_IS_PRE_REC_ACCT", companyId);
            paramKeyMap.put("AR_IS_BIZ_VOUCHER", companyId);
            paramKeyMap.put("AR_RECVOUCHER_BILLTYPE_CASH", companyId);
        } else {
            paramKeyMap.put("AP_PAYVOUCHER_BILLTYPE", companyId);
            paramKeyMap.put("AP_IS_PRE_PAY_ACCT", companyId);
            paramKeyMap.put("AP_CONTRAST_ESTIMATE_GL", companyId);
            paramKeyMap.put("AP_PAYVOUCHER_BILLTYPE_CASH", companyId);
        }
        paramKeyMap = ArApParamHelper.getParamHashMap(ctx, paramKeyMap);
        boolean fRecPay2Vou = paramKeyMap.containsKey(fAR ? "AR_RECVOUCHER_BILLTYPE" : "AP_PAYVOUCHER_BILLTYPE") && "1".equals(paramKeyMap.get(fAR ? "AR_RECVOUCHER_BILLTYPE" : "AP_PAYVOUCHER_BILLTYPE"));
        boolean fPreAcctVou = "true".equals(paramKeyMap.get(fAR ? "AR_IS_PRE_REC_ACCT" : "AP_IS_PRE_PAY_ACCT")) || "1".equals(paramKeyMap.get(fAR ? "AR_IS_PRE_REC_ACCT" : "AP_IS_PRE_PAY_ACCT"));
        boolean isBizBillVoucher = "true".equals(paramKeyMap.get(fAR ? "AR_IS_BIZ_VOUCHER" : "AP_CONTRAST_ESTIMATE_GL")) || "1".equals(paramKeyMap.get(fAR ? "AR_IS_BIZ_VOUCHER" : "AP_CONTRAST_ESTIMATE_GL"));
        boolean isCashVoucher = paramKeyMap.containsKey(fAR ? "AR_RECVOUCHER_BILLTYPE_CASH" : "AP_PAYVOUCHER_BILLTYPE_CASH") && "1".equals(paramKeyMap.get(fAR ? "AR_RECVOUCHER_BILLTYPE_CASH" : "AP_PAYVOUCHER_BILLTYPE_CASH"));
        boolean isCheckGainAndLoss = ARAPCommonServerFacadeFactory.getLocalInstance((Context)ctx).isCheckGainAndLoss();
        ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
        SystemEnum sysEnum = fAR ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)sysEnum, (IObjectPK)companyPK);
        java.sql.Date beginDate = new java.sql.Date(currentPeriod.getBeginDate().getTime());
        java.sql.Date endDate = new java.sql.Date(currentPeriod.getEndDate().getTime());
        endDate.setTime(endDate.getTime() + 86400000L);
        StringBuffer sql = new StringBuffer(200);
        sql.append("select * from (\r\n");
        if (fCheckAudited || fCheckVouchered) {
            String endDateStr;
            String biginDateStr;
            SimpleDateFormat sdf;
            StringBuffer whereSql = new StringBuffer();
            whereSql.append("\r\n where FCompanyID='").append(companyId);
            whereSql.append("'\r\n and FISCASH=0");
            whereSql.append("\r\n and (FBillDate >= {").append(beginDate);
            whereSql.append("} and FBillDate < {").append(endDate).append("})");
            if (fCheckAudited && fCheckVouchered) {
                whereSql.append("\r\n and (FIsAudited = 0 \r\n");
                whereSql.append(" or (FIsAudited = 1 and FFiVouchered = 0 ");
                if (!isBizBillVoucher) {
                    whereSql.append(" AND FIsBizBill = 0 ");
                }
                whereSql.append(this.recVouTypeWhere(ctx, companyId, fAR, fRecPay2Vou, fPreAcctVou));
                sdf = new SimpleDateFormat("yyyy-MM-dd");
                biginDateStr = sdf.format(beginDate);
                endDateStr = sdf.format(endDate);
                if (!fAR && CalculateUtil.getDischargeType((Context)ctx, (String)companyId) != 0) {
                    whereSql.append(" AND FID not in (");
                    whereSql.append(CommonServerUtils.getSpecialNotVoucherApBillSql(companyId, biginDateStr, endDateStr));
                    whereSql.append(")");
                }
                whereSql.append("))");
            } else if (fCheckAudited) {
                whereSql.append("\r\n and FIsAudited = 0 ");
            } else if (fCheckVouchered) {
                whereSql.append("\r\n and (FFiVouchered= 0 and FIsAudited = 1 ");
                if (!isBizBillVoucher) {
                    whereSql.append(" AND FIsBizBill = 0 ");
                }
                whereSql.append(")").append(this.recVouTypeWhere(ctx, companyId, fAR, fRecPay2Vou, fPreAcctVou));
                sdf = new SimpleDateFormat("yyyy-MM-dd");
                biginDateStr = sdf.format(beginDate);
                endDateStr = sdf.format(endDate);
                if (!fAR && CalculateUtil.getDischargeType((Context)ctx, (String)companyId) != 0) {
                    whereSql.append(" AND FID not in (");
                    whereSql.append(CommonServerUtils.getSpecialNotVoucherApBillSql(companyId, biginDateStr, endDateStr));
                    whereSql.append(")");
                }
            }
            sql.append(" select distinct FId, FBillTypeDes, FNumber, FFiVouchered, FIsCash, FIsUnver,");
            sql.append(" FIsAudited from ");
            sql.append(fAR ? " V_AR_CheckAuditedOrVouchered " : " V_AP_CheckAuditedOrVouchered ");
            sql.append(whereSql);
        }
        if (checkParam.isCheckVoucherRelatedBill()) {
            StringBuffer vouSql = this.vouRelatedBillSql(fAR, companyId, accountIds, beginDate, endDate);
            sql.append(fCheckAudited || fCheckVouchered ? "\r\n union all \r\n" : "").append(vouSql);
        }
        if (checkParam.ischkCashVerifiBill()) {
            StringBuffer cashSql = this.checkCashBillSql(fAR, companyId, accountIds, beginDate, endDate);
            sql.append(fCheckAudited || fCheckVouchered || checkParam.isCheckVoucherRelatedBill() ? "\r\n union all \r\n" : "").append(cashSql);
        }
        if (fCheckAudited || fCheckVouchered) {
            StringBuffer cashVouSql = this.checkCashVou(fAR, companyId, accountIds, beginDate, endDate, isCashVoucher, fCheckAudited, fCheckVouchered);
            sql.append(fCheckAudited || fCheckVouchered || checkParam.isCheckVoucherRelatedBill() || checkParam.ischkCashVerifiBill() ? "\r\n union all \r\n" : "").append(cashVouSql);
        }
        sql.append("\r\n) t_arap_chkRpt  order by FIsAudited, FFiVouchered, FNumber ");
        StringBuffer periodSql = null;
        IRowSet vouPeriodSql = null;
        if (fCheckVoucherPeriod) {
            periodSql = fAR ? this.arvouPeriodSql(fAR, companyId, accountIds, beginDate, endDate) : this.apvouPeriodSql(fAR, companyId, accountIds, beginDate, endDate);
        }
        logger.debug((Object)("contrastGL check sql:\r\n" + sql));
        IRowSet rs = null;
        if (fCheckAudited || fCheckVouchered || fCheckVoucherBill || checkParam.ischkCashVerifiBill()) {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        if (periodSql != null) {
            vouPeriodSql = DbUtil.executeQuery((Context)ctx, (String)periodSql.toString());
        }
        try {
            rptData = this.getCheckRpt(ctx, rs, fAR, vouPeriodSql, checkParam.getCompanyId(), fRecPay2Vou, fPreAcctVou, isCheckGainAndLoss);
        }
        catch (SQLException e) {
            logger.error((Object)"arapCheck:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return rptData;
    }

    private StringBuffer checkCashVou(boolean far, String companyId, List accountIds, java.sql.Date beginDate, java.sql.Date endDate, boolean isCashVoucher, boolean fCheckAudited, boolean fCheckVouchered) {
        StringBuffer cashvouSql = new StringBuffer();
        cashvouSql.append(" select distinct FId, FBillTypeDes, FNumber, FFiVouchered, FIsCash, FIsUnver,");
        cashvouSql.append(" FIsAudited from ");
        cashvouSql.append(far ? " V_AR_CheckAuditedOrVouchered " : " V_AP_CheckAuditedOrVouchered ");
        cashvouSql.append("\r\n where FCompanyID='").append(companyId);
        cashvouSql.append("'\r\n and FISCASH=1");
        cashvouSql.append("\r\n and (FBillDate >= {").append(beginDate);
        cashvouSql.append("} and FBillDate < {").append(endDate).append("})");
        StringBuffer billType = new StringBuffer("");
        if (isCashVoucher) {
            billType.append("\r\n and (FBILLTYPEDES='otherbill'");
            billType.append(far ? "or FBILLTYPEDES='receivingbill')" : "or FBILLTYPEDES='paymentBill')");
        } else {
            billType.append("\r\n and FBILLTYPEDES='verifyBill'");
        }
        if (fCheckAudited && fCheckVouchered) {
            cashvouSql.append("\r\n and (FIsAudited = 0 \r\n");
            cashvouSql.append(" or (FIsAudited = 1 and FFiVouchered = 0 ");
            cashvouSql.append(billType).append(")) ");
        } else if (fCheckAudited) {
            cashvouSql.append("\r\n and FIsAudited = 0 ");
        } else if (fCheckVouchered) {
            cashvouSql.append("\r\n and (FFiVouchered= 0 and FIsAudited = 1 ");
            cashvouSql.append(billType).append(") ");
        }
        return cashvouSql;
    }

    private StringBuffer checkCashBillSql(boolean far, String companyId, List accountIds, java.sql.Date beginDate, java.sql.Date endDate) {
        StringBuffer cashSql = new StringBuffer();
        cashSql.append(" select t1.FId, ");
        cashSql.append(far ? " 'receivingbill' FBillTypeDes," : " 'paymentBill' FBillTypeDes,");
        cashSql.append(" t1.FNumber, 1 FFiVouchered, 1 FIsCash, 1 FIsUnver, 1 FIsAudited");
        cashSql.append("\r\n from (select distinct t1.FId, t1.FNumber \r\n from");
        cashSql.append(far ? " T_CAS_RECEIVINGBILL t1" : " T_CAS_PAYMENTBILL t1");
        cashSql.append("\r\n  where t1.FCompanyId = '");
        cashSql.append(companyId);
        cashSql.append("'\r\n  and t1.FunVerifiedAmt !=0");
        cashSql.append("\r\n  and t1.fpaymenttypeid =");
        cashSql.append(far ? "'cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5'" : "'40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5'");
        cashSql.append("\r\n AND FBillStatus > 12");
        cashSql.append("\r\n  and (FBizDate >= {").append(beginDate);
        cashSql.append("} and FBizDate < {").append(endDate);
        cashSql.append("}) T1)");
        cashSql.append("\r\n union all \r\n");
        cashSql.append(" select t1.FId, 'otherbill' FBillTypeDes,");
        cashSql.append(" t1.FNumber, 1 FFiVouchered, 1 FIsCash, 1 FISUNVER, 1 FIsAudited");
        cashSql.append("\r\n from (select distinct t1.FId, t1.FNumber \r\n from");
        cashSql.append(far ? " T_AR_OTHERBILL t1" : " T_AP_OTHERBILL t1");
        cashSql.append("\r\n  where t1.FCompanyId = '");
        cashSql.append(companyId);
        cashSql.append("'\r\n  and t1.FunVerifyAmount !=0");
        cashSql.append("\r\n  and t1.fpaymenttypeid =");
        cashSql.append(far ? "'cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5'" : "'40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5'");
        cashSql.append("\r\n AND FBillStatus = 3");
        cashSql.append("\r\n  and (FBillDate >= {").append(beginDate);
        cashSql.append("} and FBillDate < {").append(endDate);
        cashSql.append("}) T1)");
        return cashSql;
    }

    private StringBuffer apvouPeriodSql(boolean fAR, String companyId, List accountIds, java.sql.Date beginDate, java.sql.Date endDate) {
        StringBuffer periodSql = new StringBuffer(2500);
        periodSql.append("select distinct a_viwe.FId FId, a_viwe.FBillTypeDes FBillTypeDes, a_viwe.FNumber FNumber, a_viwe.FFiVouchered FFiVouchered, a_viwe.FIsAudited FIsAudited,c_voucher.fnumber Fvouchernumber ");
        periodSql.append("from( ");
        periodSql.append("SELECT fid,'otherbill' fbilltypedes,fnumber,fcompanyid,fbilldate,");
        periodSql.append("CASE fbillstatus WHEN 3 THEN 1 ELSE 0 END fisaudited,");
        periodSql.append("ISNULL(FFiVouchered,0)  as ffivouchered ");
        periodSql.append("FROM   t_ap_otherbill UNION ALL ");
        periodSql.append("SELECT bill.fid as fid, 'paymentBill' fbilltypedes,bill.fnumber as fnumber,bill.fcompanyid as fcompanyid,bill.fbizdate as fbilldate,");
        periodSql.append("CASE bill.fbillstatus WHEN 10 THEN 0 WHEN 11 THEN 0 WHEN 12 THEN 0 ELSE 1 END fisaudited,");
        periodSql.append("CASE bill.FIsNeedVoucher when 1 then ISNULL(bill.FFiVouchered,0) else 1 end as ffivouchered ");
        periodSql.append("FROM   t_cas_paymentbill bill ");
        periodSql.append(" INNER JOIN T_CAS_PaymentBillType BILLTYPE ON bill.FPayBillTypeID = billType.FID");
        periodSql.append(" WHERE BILLTYPE.FSOURCESYSTYPE = '101'");
        periodSql.append(" UNION ALL ");
        periodSql.append("SELECT bill.fid as fid,'verifyBill' fbilltypedes,bill.fnumber as fnumber,bill.fcompanyid as fcompanyid,bill.fbizdate as fbilldate,1 fisaudited,");
        periodSql.append("CASE Isnull(bill.ffivouchered,0) WHEN 1 THEN 1 ELSE 0 END ffivouchered ");
        periodSql.append("FROM   t_ap_verificationbill bill UNION ALL ");
        periodSql.append("SELECT fid,'proxybill' fbilltypedes,fnumber,fcompanyorgunitid fcompanyid,fbilldate fbilldate,");
        periodSql.append("CASE fcheckedstatus WHEN 1 THEN 0 ELSE 1 END fisaudited,");
        periodSql.append("CASE FIsNeedVoucher when 1 then ISNULL(FFiVouchered,0) else 1 end as ffivouchered ");
        periodSql.append("FROM   t_arp_proxybill bill UNION ALL ");
        periodSql.append("SELECT fid,'exgRateBill' fbilltypedes,fnumber,fcompanyid,FExgRateDate fbilldate,");
        periodSql.append("CASE fbillstatus WHEN 3 THEN 1 ELSE 0 END fisaudited,");
        periodSql.append("CASE Isnull(ffivouchered,0) WHEN 1 THEN 1 ELSE 0 END ffivouchered ");
        periodSql.append("FROM   T_AP_ApExgRateBill ");
        periodSql.append(") as a_viwe ");
        periodSql.append("left join t_bot_relation b_bot on a_viwe.fid = b_bot.fsrcobjectid ");
        periodSql.append("left join t_gl_voucher c_voucher on b_bot.fdestobjectid = c_voucher.fid ");
        periodSql.append("where a_viwe.FCompanyID='");
        periodSql.append(companyId);
        periodSql.append("'\r\n and (a_viwe.FBillDate >= {").append(beginDate);
        periodSql.append("} and a_viwe.FBillDate < {").append(endDate);
        periodSql.append("}) and (a_viwe.FIsAudited = 1 and a_viwe.FFiVouchered = 1)");
        periodSql.append("and (c_voucher.FBookedDate >= {").append(endDate);
        periodSql.append("} or ");
        periodSql.append("c_voucher.FBookedDate < { ").append(beginDate).append(" } )");
        return periodSql;
    }

    private StringBuffer arvouPeriodSql(boolean fAR, String companyId, List accountIds, java.sql.Date beginDate, java.sql.Date endDate) {
        StringBuffer periodSql = new StringBuffer(2500);
        periodSql.append("select distinct a_viwe.FId FId, a_viwe.FBillTypeDes FBillTypeDes, a_viwe.FNumber FNumber, a_viwe.FFiVouchered FFiVouchered, a_viwe.FIsAudited FIsAudited,c_voucher.fnumber Fvouchernumber ");
        periodSql.append("from( ");
        periodSql.append("SELECT fid,'otherbill' fbilltypedes,fnumber,fcompanyid,fbilldate,");
        periodSql.append("CASE fbillstatus WHEN 3 THEN 1 ELSE 0 END fisaudited,");
        periodSql.append("ISNULL(FFiVouchered,0)  as ffivouchered ");
        periodSql.append("FROM   t_ar_otherbill UNION ALL ");
        periodSql.append("SELECT fid,'incomeConfirm' fbilltypedes,fnumber,fcompanyid,fbilldate,");
        periodSql.append("CASE fbillstatus WHEN 3 THEN 1 ELSE 0 END fisaudited,");
        periodSql.append("CASE Isnull(ffivouchered,0) WHEN 1 THEN 1 ELSE 0 END as ffivouchered ");
        periodSql.append("FROM   T_AR_IncomeConfimBill UNION ALL ");
        periodSql.append("SELECT distinct bill.fid as fid,'receivingbill' fbilltypedes,bill.fnumber as fnumber,bill.fcompanyid as fcompanyid,bill.fbizdate as  fbilldate,");
        periodSql.append("CASE CASE WHEN (bill.FPayerTypeID is null or ltrim(rtrim(bill.FPayerTypeID)) = '' or bill.FPayerID is null or ltrim(rtrim(bill.FPayerID)) = '') THEN 10 ELSE bill.fbillstatus END ");
        periodSql.append("WHEN 10 THEN 0 WHEN 11 THEN 0 WHEN 12 THEN 0 ELSE 1 END fisaudited,");
        periodSql.append("CASE bill.FIsNeedVoucher when 1 then ISNULL(bill.FFiVouchered,0) else 1 end as ffivouchered ");
        periodSql.append("FROM   t_cas_receivingbill bill UNION ALL ");
        periodSql.append("SELECT fid,'badacct' fbilltypedes,fnumber,fcompanyid,fbadacctdate fbilldate,");
        periodSql.append("CASE Isnull(Year(fauditdate),0) WHEN 0 THEN 0 ELSE 1 END fisaudited,");
        periodSql.append("CASE Isnull(ffivouchered,0) WHEN 1 THEN 1 ELSE 0 END ffivouchered ");
        periodSql.append("FROM   t_ar_badacct UNION ALL ");
        periodSql.append("SELECT fid,'badacctaccurral' fbilltypedes,fnumber,fcompanyid,faccountdate fbilldate,");
        periodSql.append("CASE Isnull(Year(fauditdate),0)WHEN 0 THEN 0 ELSE 1 END fisaudited,");
        periodSql.append("CASE Isnull(ffivouchered,0) WHEN 1 THEN 1 ELSE 0 END ffivouchered ");
        periodSql.append("FROM   t_ar_accountbaddebt UNION ALL ");
        periodSql.append("SELECT bill.fid as fid,'verifyBill' fbilltypedes,bill.fnumber as fnumber,bill.fcompanyid as fcompanyid,bill.fbizdate as fbilldate,1 fisaudited,");
        periodSql.append("CASE Isnull(bill.ffivouchered,0)WHEN 1 THEN 1 ELSE 0 END ffivouchered ");
        periodSql.append("FROM   t_ar_verificationbill bill UNION ALL ");
        periodSql.append("SELECT fid,'proxybill' fbilltypedes,fnumber,fcompanyorgunitid fcompanyid,fbilldate fbilldate,");
        periodSql.append("CASE fcheckedstatus WHEN 1 THEN 0 ELSE 1 END fisaudited,");
        periodSql.append("CASE FIsNeedVoucher when 1 then ISNULL(FFiVouchered,0) else 1 end as ffivouchered ");
        periodSql.append("FROM   t_arp_proxybill bill UNION ALL ");
        periodSql.append("SELECT fid,'exgRateBill' fbilltypedes,fnumber,fcompanyid,FExgRateDate fbilldate,");
        periodSql.append("CASE fbillstatus WHEN 3 THEN 1 ELSE 0 END fisaudited,");
        periodSql.append("CASE Isnull(ffivouchered,0)WHEN 1 THEN 1 ELSE 0 END ffivouchered ");
        periodSql.append("FROM   T_AR_ArExgRateBill ");
        periodSql.append(") as a_viwe ");
        periodSql.append("left join t_bot_relation b_bot on a_viwe.fid = b_bot.fsrcobjectid ");
        periodSql.append("left join t_gl_voucher c_voucher on b_bot.fdestobjectid = c_voucher.fid ");
        periodSql.append("where a_viwe.FCompanyID='");
        periodSql.append(companyId);
        periodSql.append("'\r\n and (a_viwe.FBillDate >= {").append(beginDate);
        periodSql.append("} and a_viwe.FBillDate < {").append(endDate);
        periodSql.append("}) and (a_viwe.FIsAudited = 1 and a_viwe.FFiVouchered = 1)");
        periodSql.append("and (c_voucher.FBookedDate >= {").append(endDate);
        periodSql.append("} or ");
        periodSql.append("c_voucher.FBookedDate < { ").append(beginDate).append(" } )");
        return periodSql;
    }

    private StringBuffer vouRelatedBillSql(boolean fAR, String companyId, List accountIds, java.sql.Date beginDate, java.sql.Date endDate) {
        StringBuffer vouSql = new StringBuffer();
        vouSql.append(" select t1.FId, 'voucherNoBill' FBillTypeDes,");
        vouSql.append(" t1.FNumber, 1 FFiVouchered, 0 FIsCash, 0 FISUNVER, 1 FIsAudited");
        vouSql.append("\r\n from (select distinct t1.FId, t1.FNumber");
        vouSql.append("\r\n  from t_gl_voucher t1 left join");
        vouSql.append(" t_gl_voucherEntry t2 on t1.FId = t2.FBillId ");
        vouSql.append("\r\n  where t1.FCompanyId = '");
        vouSql.append(companyId);
        vouSql.append("'\r\n  and (FBizDate >= {").append(beginDate);
        vouSql.append("} and FBizDate < {").append(endDate);
        vouSql.append("}) ");
        if (accountIds != null && accountIds.size() > 0) {
            StringBuffer acctIds = new StringBuffer();
            int n = accountIds.size();
            for (int i = 0; i < n; ++i) {
                acctIds.append("'").append(accountIds.get(i));
                acctIds.append(i < n - 1 ? "', " : "'");
            }
            vouSql.append("\r\n  and t2.FAccountId in (").append(acctIds);
            vouSql.append(")");
        }
        vouSql.append(") t1  \r\n where ");
        vouSql.append("not exists (select 1 from t_bot_relation ");
        vouSql.append("where FDestObjectId = t1.fid and FDestEntityID = '");
        vouSql.append(ContrastGLHelper.VOU_TYPE);
        vouSql.append("' )");
        return vouSql;
    }

    private StringBuffer recVouTypeWhere(Context ctx, String companyId, boolean fAR, boolean fRecPay2Vou, boolean fPreAcctVou) throws BOSException, EASBizException {
        StringBuffer whereSql = new StringBuffer();
        if (fRecPay2Vou && !fPreAcctVou) {
            whereSql.append("\r\n and (FVeriType != -100");
            whereSql.append(" and FVeriType != -200 )");
        } else if (fRecPay2Vou && fPreAcctVou) {
            whereSql.append("\r\n and ((FBillType = -1 and FVeriType = -1)");
            whereSql.append(" or FVeriType = 1 ");
            whereSql.append(" or FVeriType = -200)");
        } else if (!fRecPay2Vou && !fPreAcctVou) {
            whereSql.append("\r\n and ((FBillType = -1 and FVeriType = -1)");
            whereSql.append(" or (FVeriType = 1 and (FBillType != ");
            whereSql.append(fAR ? 100 : 201);
            whereSql.append(" and FBillType != ");
            whereSql.append(fAR ? 102 : 203);
            whereSql.append(")) or FVeriType = -100)");
        } else if (!fRecPay2Vou && fPreAcctVou) {
            whereSql.append("\r\n and ((FBillType = -1 and FVeriType = -1)");
            whereSql.append(" or (FVeriType = 1 and (FBillType != ");
            whereSql.append(fAR ? 100 : 201);
            whereSql.append(" AND FBillType != ");
            whereSql.append(fAR ? 102 : 203);
            whereSql.append(")) or (FVeriType = -100 or FVeriType = -200))");
        }
        return whereSql;
    }

    private IReportData getCheckRpt(Context ctx, IRowSet rs, boolean fAR, IRowSet rsvouperiod, String companyId, boolean fRecPay2Vou, boolean fPreAcctVou, boolean isCheckGainAndLoss) throws BOSException, EASBizException, SQLException {
        CoreBaseCollection coll;
        Iterator it;
        Locale locale = ctx.getLocale();
        String rsltAudit = "";
        String res = "com.kingdee.eas.fi.ar.ArReport";
        String auditLbl = ResourceBase.getString((String)res, (String)"AuditCheck", (Locale)locale);
        String voucherPeriod = ResourceBase.getString((String)res, (String)"VourcherPeriodCheck", (Locale)locale);
        String voucheredLbl = ResourceBase.getString((String)res, (String)"VoucheredCheck", (Locale)locale);
        String voucherBillLbl = ResourceBase.getString((String)res, (String)"VoucherBillCheck", (Locale)locale);
        String typeLbl = ResourceBase.getString((String)res, (String)"WarningInfo", (Locale)locale);
        String rsltAuditLbl = ResourceBase.getString((String)res, (String)"CheckRslt_Audit", (Locale)locale);
        String rsltAuditLblRec = ResourceBase.getString((String)res, (String)"CheckRslt_Audit_Rec", (Locale)locale);
        String rsltAuditLblPay = ResourceBase.getString((String)res, (String)"CheckRslt_Audit_Pay", (Locale)locale);
        String cashLbl = ResourceBase.getString((String)res, (String)"BillSettlementCheck", (Locale)locale);
        String cashedLbl = ResourceBase.getString((String)res, (String)"CashRecOrCashPayNotSet", (Locale)locale);
        String rsltVoucheredLbl = ResourceBase.getString((String)res, (String)"CheckRslt_Vouchered", (Locale)locale);
        String rsltVoucherLbl = ResourceBase.getString((String)res, (String)"CheckRslt_VoucherBill", (Locale)locale);
        String rsltVouPeriod = ResourceBase.getString((String)res, (String)"CheckRslt_VoucherPeriod", (Locale)locale);
        String swapBillNotVourcherLbl = ResourceBase.getString((String)res, (String)"swapBill_Not_Vourcher", (Locale)locale);
        String checkRsltSwapRateLbl = ResourceBase.getString((String)res, (String)"CheckRslt_SwapRate", (Locale)locale);
        List arBillTypes = AccountSettleBillTypeEnum.getEnumList();
        List apBillTypes = com.kingdee.eas.fi.ap.AccountSettleBillTypeEnum.getEnumList();
        ArApReportData rptData = null;
        ArrayList<ReportInfo> lstData = new ArrayList<ReportInfo>();
        ReportInfo rptInfo = null;
        String billNum = null;
        String billType = null;
        String result = null;
        HashSet<String> veriBillSet = new HashSet<String>();
        if (rs != null) {
            while (rs.next()) {
                rptInfo = new ReportInfo();
                billNum = rs.getString("FNumber");
                billType = rs.getString("FBillTypeDes");
                String billID = rs.getString("FID");
                if ("verifyBill".equalsIgnoreCase(billType)) {
                    veriBillSet.add(billID);
                }
                String IsAudited = rs.getString("FIsAudited");
                rptInfo.put("billNum", billNum);
                rptInfo.put("billType", billType);
                rptInfo.put("billID", billID);
                rptInfo.put("IsAudited", IsAudited);
                rsltAudit = billType.equalsIgnoreCase("receivingbill") ? rsltAuditLblRec : (billType.equalsIgnoreCase("paymentBill") ? rsltAuditLblPay : rsltAuditLbl);
                if (billType.equals("voucherNoBill")) {
                    billType = "";
                } else {
                    Iterator it2;
                    Iterator iterator = it2 = fAR ? arBillTypes.iterator() : apBillTypes.iterator();
                    while (it2.hasNext()) {
                        StringEnum typeEnum = (StringEnum)it2.next();
                        if (!typeEnum.getValue().equalsIgnoreCase(billType)) continue;
                        billType = typeEnum.getAlias(locale);
                        break;
                    }
                }
                rptInfo.put("ErrorType", typeLbl);
                if (!rs.getBoolean("FIsAudited")) {
                    rptInfo.put("Item", auditLbl);
                    result = MessageFormat.format(rsltAudit, billType, billNum);
                } else if (rs.getBoolean("FIsCASH") && rs.getBoolean("FIsUnver")) {
                    if (rs.getBoolean("FFiVouchered")) {
                        rptInfo.put("Item", cashLbl);
                        result = MessageFormat.format(cashedLbl, billType, billNum);
                    } else {
                        rptInfo.put("Item", voucheredLbl);
                        result = MessageFormat.format(rsltVoucheredLbl, billType, billNum);
                    }
                } else if (!rs.getBoolean("FFiVouchered")) {
                    rptInfo.put("Item", voucheredLbl);
                    result = MessageFormat.format(rsltVoucheredLbl, billType, billNum);
                } else {
                    rptInfo.put("Item", voucherBillLbl);
                    result = MessageFormat.format(rsltVoucherLbl, billNum);
                }
                rptInfo.put("Result", result);
                lstData.add(rptInfo);
            }
        }
        if (rsvouperiod != null) {
            while (rsvouperiod.next()) {
                rptInfo = new ReportInfo();
                billNum = rsvouperiod.getString("FNumber");
                billType = rsvouperiod.getString("FBillTypeDes");
                String IsAudited = rsvouperiod.getString("FIsAudited");
                if (billType.equals("voucherNoBill")) {
                    billType = "";
                } else {
                    Iterator iterator = it = fAR ? arBillTypes.iterator() : apBillTypes.iterator();
                    while (it.hasNext()) {
                        StringEnum typeEnum = (StringEnum)it.next();
                        if (!typeEnum.getValue().equalsIgnoreCase(billType)) continue;
                        billType = typeEnum.getAlias(locale);
                        break;
                    }
                }
                String vouchernumber = rsvouperiod.getString("Fvouchernumber");
                rptInfo.put("ErrorType", typeLbl);
                rptInfo.put("Item", voucherPeriod);
                rptInfo.put("billType", billType);
                rptInfo.put("IsAudited", IsAudited);
                result = MessageFormat.format(rsltVouPeriod, billType, billNum, vouchernumber);
                rptInfo.put("Result", result);
                lstData.add(rptInfo);
            }
        }
        if (!isCheckGainAndLoss && (coll = CommonServerUtils.getGainAndLossVeriBill(ctx, fAR, fRecPay2Vou, fPreAcctVou, companyId, veriBillSet)).size() > 0) {
            it = lstData.iterator();
            while (it.hasNext()) {
                rptInfo = (ReportInfo)it.next();
                if (StringUtils.isEmpty((String)rptInfo.getString("billID")) || !coll.containsKey((Object)BOSUuid.read((String)rptInfo.getString("billID")))) continue;
                it.remove();
            }
        }
        rptData = new ArApReportData(lstData);
        return rptData;
    }

    @Override
    protected IReportData _checkARGL(Context ctx, ContrastGLCheckParam checkParam) throws BOSException, EASBizException {
        IReportData rptData = this.checkArApGLWithLogging(ctx, checkParam, true);
        return rptData;
    }

    @Override
    protected IReportData _apContrastGL(Context ctx, ContrastGLQueryParam param) throws BOSException, EASBizException {
        this.processContext(ctx);
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(param.getCompanyId()));
        String manipulateObject = this.getDisplayManipulateObject(companyInfo);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new ContrastGLFacade().getType(), null, (String)manipulateObject, (String)"fi_ap_Ap2GL");
        IReportData result = this.arapContrastGL(ctx, param, false);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return result;
    }

    @Override
    protected IReportData _arContrastGL(Context ctx, ContrastGLQueryParam param) throws BOSException, EASBizException {
        this.processContext(ctx);
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(param.getCompanyId()));
        String manipulateObject = this.getDisplayManipulateObject(companyInfo);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new ContrastGLFacade().getType(), null, (String)manipulateObject, (String)"fi_ar_Ar2GL");
        IReportData result = this.arapContrastGL(ctx, param, true);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return result;
    }

    private String getDisplayManipulateObject(CompanyOrgUnitInfo companyInfo) {
        String displayManipulateObjectName = "";
        if (null != companyInfo) {
            displayManipulateObjectName = companyInfo.getNumber() + " " + companyInfo.getName();
        }
        return displayManipulateObjectName;
    }

    private void processContext(Context ctx) {
        if (null == ctx.getClientHostName()) {
            ctx.put((Object)"ClientName", (Object)ctx.getClientHostIP());
        }
    }

    private IReportData arapContrastGL(Context ctx, ContrastGLQueryParam param, boolean fAR) throws BOSException, EASBizException {
        this.checkContrastParam(ctx, param, fAR);
        this._convertContrastAccount(ctx, param, fAR);
        String tempTable = param.getTempTable();
        if (StringUtils.isEmpty((String)tempTable)) {
            param.setTempTable(TempTableUtil.createTempTable(ctx, CommonServerUtils.defineContrastTempTbl(true)));
            param.setBoolean("isGUI", true);
            this.prepareContrastData(ctx, param, fAR);
        }
        return this.getContrastRptData(ctx, param, fAR);
    }

    private void checkContrastParam(Context ctx, ContrastGLQueryParam param, boolean fAR) throws BOSException, EASBizException {
        if (param == null) {
            throw new NullPointerException("param is null");
        }
        if (StringUtils.isEmpty((String)param.getCompanyId())) {
            throw new ContrastGLException(ContrastGLException.COMPANY_NULL);
        }
        if (param.getAcctFormula() == null || param.getAcctFormula().size() == 0) {
            throw new ContrastGLException(ContrastGLException.ACCOUNT_NULL);
        }
        if (param.getPeriodYear() == -1 && param.getPeriodNum() == -1) {
            throw new ContrastGLException(ContrastGLException.PERIOD_NULL);
        }
        if (StringUtils.isEmpty((String)param.getCurrencyId())) {
            throw new ContrastGLException(ContrastGLException.CURRENCY_NULL);
        }
        SystemEnum sysEnum = fAR ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo.setId(BOSUuid.read((String)param.getCompanyId()));
        boolean fRelateGL = SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)sysEnum, (CompanyOrgUnitInfo)companyInfo);
        if (!fRelateGL) {
            throw new ContrastGLException(ContrastGLException.NOT_CONN_GL);
        }
    }

    protected void checkContrastAccount(Context ctx, ContrastGLQueryParam param) throws BOSException {
        String companyId = param.getCompanyId();
        String operateFlag = "+-";
        List accountList = param.getAcctFormula();
        ArrayList<String> operateList = new ArrayList<String>();
        StringBuilder accountIdStr = new StringBuilder();
        for (Object account : accountList) {
            if (operateFlag.contains(account.toString())) {
                operateList.add(account.toString());
                continue;
            }
            accountIdStr.append("'").append(account).append("'").append(",");
        }
        String accIdStr = accountIdStr.toString().substring(0, accountIdStr.length() - 1);
        StringBuilder checkSql = new StringBuilder();
        checkSql.append("select FID from T_BD_AccountView where FID in (");
        checkSql.append(accIdStr);
        checkSql.append(") and FCOMPANYID = '").append(companyId).append("'");
        IRowSet checkRowSet = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        try {
            if (!checkRowSet.next()) {
                accountList.clear();
                StringBuilder selSql = new StringBuilder();
                selSql.append("SELECT FID FROM T_BD_AccountView ");
                selSql.append(" where FNUMBER in ( ");
                selSql.append("    SELECT FNUMBER FROM T_BD_AccountView where fid in (");
                selSql.append(accIdStr);
                selSql.append("    )) and ");
                selSql.append(" FCOMPANYID = '").append(companyId).append("'");
                IRowSet selRowSet = DbUtil.executeQuery((Context)ctx, (String)selSql.toString());
                Iterator operateIte = operateList.iterator();
                while (selRowSet.next()) {
                    String accountId = selRowSet.getString("FID");
                    accountList.add(accountId);
                    if (!operateIte.hasNext()) continue;
                    accountList.add(operateIte.next());
                }
                param.setAcctFormula(accountList);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("sql is:" + checkSql));
            throw new BOSException("Sql execute exception : " + checkSql, (Throwable)e);
        }
    }

    @Override
    protected void _prepareContrastData(Context ctx, ContrastGLQueryParam param, boolean fAR) throws BOSException, EASBizException {
        ContrastGLQueryParam.initDBParam(ctx, param, fAR);
        String arapAcctBalTbl = this.getArApAcctBalTable(ctx, param, fAR);
        if (param.isHasUnRegVoucher()) {
            GlUtils.updateBalance((Context)ctx);
        }
        boolean needAccount = !param.isBySum() && !param.isByBillSum();
        StringBuilder sql = new StringBuilder(200);
        sql.append("insert into ").append(param.getTempTable());
        sql.append(" (FCurrencyID, FCurrency,  ");
        sql.append(param.getAllAmountLocal() == 1 || param.getAllAmountLocal() == 2 ? "FCurrencyLocal," : " ");
        sql.append(needAccount ? " FAccount, FAccountID, " : "");
        sql.append(" FCussTypeID, FCussType, FCussAcct, FCussNum, FCussName,  \r\n ");
        sql.append(" FArStartAmt, FArDebitAmt, FArCreditAmt, FArBalanceAmt, ");
        sql.append(" FGLStartAmt, FGLDebitAmt, FGLCreditAmt, FGLBalanceAmt) ").append(NEW_LINE);
        StringBuilder arapSql = new StringBuilder(200);
        arapSql.append((CharSequence)sql);
        StringBuffer arapSqlInsert = ContrastGLHelper.getArApDataSql(ctx, param, arapAcctBalTbl, fAR);
        if (arapSqlInsert != null && arapSqlInsert.length() > 0) {
            arapSql.append(arapSqlInsert);
        } else {
            arapSql.setLength(0);
        }
        StringBuilder glSql = new StringBuilder(200);
        glSql.append((CharSequence)sql);
        glSql.append(ContrastGLHelper.getGLDataSql(ctx, param, fAR));
        StringBuilder updateSQL = new StringBuilder(100);
        updateSQL.append("update ").append(param.getTempTable());
        updateSQL.append(" set FStartDiffAmt = FArStartAmt - FGLStartAmt,").append(NEW_LINE);
        updateSQL.append("FDebitDiffAmt = FArDebitAmt - FGLDebitAmt, ").append(NEW_LINE);
        updateSQL.append("FCreditDiffAmt = FArCreditAmt - FGLCreditAmt,").append(NEW_LINE);
        updateSQL.append("FBalanceDiffAmt = FArBalanceAmt - FGLBalanceAmt ");
        boolean isGUI = param.getBoolean("isGUI");
        StringBuilder inserSQL = new StringBuilder(300);
        inserSQL.append("insert into ").append(param.getTempTable());
        inserSQL.append(" (").append(needAccount ? "FAccount, FAccountID, " : "");
        inserSQL.append(" FCurrencyID, FCurrency, ").append(" FCussTypeID, FCussType, FCussAcct, FCussNum, FCussName,  \r\n ");
        inserSQL.append(" FArStartAmt, FGLStartAmt, FStartDiffAmt, ").append(NEW_LINE);
        inserSQL.append(" FArDebitAmt, FGLDebitAmt, FDebitDiffAmt, ").append(NEW_LINE);
        inserSQL.append(" FArCreditAmt, FGLCreditAmt, FCreditDiffAmt, ").append(NEW_LINE);
        inserSQL.append(" FArBalanceAmt, FGLBalanceAmt, FBalanceDiffAmt, ");
        inserSQL.append(" FIsSum) ").append(NEW_LINE);
        inserSQL.append(" select ");
        inserSQL.append(needAccount ? "FAccount, FAccountID, " : "");
        inserSQL.append(" FCurrencyID, FCurrency, ").append(" FCussTypeID, FCussType, FCussAcct, FCussNum, FCussName,  \r\n ");
        inserSQL.append(" sum(FArStartAmt) FArStartAmt, sum(FGLStartAmt) FGLStartAmt, sum(FStartDiffAmt) FStartDiffAmt, ").append(NEW_LINE);
        inserSQL.append(" sum(FArDebitAmt) FArDebitAmt, sum(FGLDebitAmt) FGLDebitAmt, sum(FDebitDiffAmt) FDebitDiffAmt, ").append(NEW_LINE);
        inserSQL.append(" sum(FArCreditAmt) FArCreditAmt, sum(FGLCreditAmt) FGLCreditAmt,sum(FCreditDiffAmt) FCreditDiffAmt, ").append(NEW_LINE);
        inserSQL.append("sum(FArBalanceAmt) FArBalanceAmt, sum(FGLBalanceAmt) FGLBalanceAmt, sum(FBalanceDiffAmt) FBalanceDiffAmt, 1 as FIsSum ");
        inserSQL.append(NEW_LINE).append(" from ").append(param.getTempTable());
        if (param.isHasItem() && param.getCussTypeId() != null && !param.getCussTypeId().equals("all")) {
            inserSQL.append(" where FCussTypeID = '");
            inserSQL.append(param.getCussTypeId().toString());
            inserSQL.append("' ");
        }
        inserSQL.append(" group by ");
        inserSQL.append(" FCurrencyID, FCurrency, ");
        inserSQL.append(needAccount ? "FAccount, FAccountID, " : "");
        inserSQL.append(" FCussTypeID, FCussType, FCussAcct, FCussNum, FCussName");
        StringBuilder deleteSQL = new StringBuilder(100);
        deleteSQL.append(" delete from ").append(param.getTempTable());
        deleteSQL.append(" where FArStartAmt = 0 and FGLStartAmt =0 and  FStartDiffAmt = 0");
        deleteSQL.append(" and FArDebitAmt = 0 and FGLDebitAmt = 0 and  FDebitDiffAmt = 0");
        deleteSQL.append(" and FArCreditAmt = 0 and FGLCreditAmt = 0 and  FCreditDiffAmt = 0");
        deleteSQL.append(" and FArBalanceAmt = 0 and FGLBalanceAmt = 0 and  FBalanceDiffAmt = 0");
        StringBuilder isDiffSQL = new StringBuilder(100);
        if (!isGUI) {
            isDiffSQL.append("update ").append(param.getTempTable()).append(NEW_LINE);
            isDiffSQL.append("set fisDiff = 1 ").append(NEW_LINE);
            isDiffSQL.append("where (");
            isDiffSQL.append(ArApServerUtils.getContrastBalanceSql(param.getContrastCondition(), false));
            isDiffSQL.append(") and FIsSum = 1 ");
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        if (arapSql.length() > 0) {
            sqlList.add(arapSql.toString());
        }
        logger.debug((Object)(" sql: \r\n" + arapSql));
        sqlList.add(glSql.toString());
        logger.debug((Object)(" sql: \r\n" + glSql));
        sqlList.add(updateSQL.toString());
        logger.debug((Object)(" updateContrastGl sql: \r\n" + updateSQL));
        sqlList.add(inserSQL.toString());
        logger.debug((Object)(" updateContrastGl2 sql: \r\n" + inserSQL));
        sqlList.add(deleteSQL.toString());
        logger.debug((Object)(" sql: \r\n" + deleteSQL.toString()));
        if (!isGUI) {
            sqlList.add(isDiffSQL.toString());
            logger.debug((Object)(" sql: \r\n" + isDiffSQL.toString()));
        }
        if (isGUI) {
            StringBuilder sumSql = new StringBuilder(200);
            sumSql.append("INSERT INTO ").append(param.getTempTable());
            sumSql.append(" (FCurrencyID, FCurrency, FArStartAmt, FGLStartAmt, FStartDiffAmt, ").append(NEW_LINE);
            sumSql.append(" FArDebitAmt, FGLDebitAmt, FDebitDiffAmt, ").append(NEW_LINE);
            sumSql.append(" FArCreditAmt, FGLCreditAmt, FCreditDiffAmt, ").append(NEW_LINE);
            sumSql.append(" FArBalanceAmt, FGLBalanceAmt, FBalanceDiffAmt, ").append(NEW_LINE);
            sumSql.append(" FIsSum) ").append(NEW_LINE);
            sumSql.append(" SELECT FCurrencyID, FCurrency, SUM(FArStartAmt), SUM(FGLStartAmt), SUM(FStartDiffAmt), ").append(NEW_LINE);
            sumSql.append(" SUM(FArDebitAmt), SUM(FGLDebitAmt), SUM(FDebitDiffAmt), ").append(NEW_LINE);
            sumSql.append(" SUM(FArCreditAmt), SUM(FGLCreditAmt), SUM(FCreditDiffAmt), ").append(NEW_LINE);
            sumSql.append(" SUM(FArBalanceAmt), SUM(FGLBalanceAmt), SUM(FBalanceDiffAmt), %s").append(NEW_LINE);
            sumSql.append(" FROM ").append(param.getTempTable()).append(" WHERE FIsSum = 1 %s GROUP BY FCurrencyID, FCurrency");
            sqlList.add(String.format(sumSql.toString(), "2", "and (" + ArApServerUtils.getContrastBalanceSql(param.getContrastCondition(), false) + ")"));
            sqlList.add(String.format(sumSql.toString(), "3", ""));
        }
        DBUtil.execBatchSql((Context)ctx, sqlList, (boolean)true);
    }

    private String getArApAcctBalTable(Context ctx, ContrastGLQueryParam param, boolean fAR) throws BOSException, EASBizException {
        ObjectUuidPK companyPK = new ObjectUuidPK(param.getCompanyId());
        PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)param.getPeriodYear(), (int)param.getPeriodNum(), (IObjectPK)companyPK);
        PeriodInfo glCurrentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)companyPK);
        PeriodInfo arapCurrentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)(fAR ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE), (IObjectPK)companyPK);
        if (glCurrentPeriod == null || arapCurrentPeriod == null) {
            logger.error((Object)("gl/arap current period is null, gl: " + glCurrentPeriod + ", arap:" + arapCurrentPeriod));
            throw new ContrastGLException(ContrastGLException.PERIOD_NULL);
        }
        if (ArApReportHelper.isAfter(glCurrentPeriod, periodInfo) || ArApReportHelper.isAfter(arapCurrentPeriod, periodInfo)) {
            throw new ContrastGLException(ContrastGLException.PERIOD_AFTERCURRENT);
        }
        param.setPeriodId(periodInfo.getId().toString());
        boolean fNeedCalc = ArApReportHelper.isSameorAfter(periodInfo, arapCurrentPeriod);
        String acctBalTable = null;
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = iCompany.getCompanyOrgUnitInfo((IObjectPK)companyPK);
        acctBalTable = param.isContrastByBillAccount() ? CommonServerUtils.computeBillAccountBalance(ctx, periodInfo, companyInfo, param, fAR) : (param.isByBillSum() ? this.computeBillBalance(ctx, periodInfo, companyInfo, param, fAR) : (fNeedCalc ? this.computeAcctBalance(ctx, periodInfo, companyInfo, param, fAR) : (fAR ? "t_ar_ArBalanceCollate" : "t_ap_ApBalanceCollate")));
        return acctBalTable;
    }

    private String computeBillBalance(Context ctx, PeriodInfo period, CompanyOrgUnitInfo companyInfo, ContrastGLQueryParam param, boolean fAR) throws BOSException, EASBizException {
        String companyId = companyInfo.getId().toString();
        String periodID = period.getId().toString();
        String tempTableStruct = this.tempAcctBalTblStruct();
        String tempBillBalTable = TempTableUtil.createTempTable(ctx, tempTableStruct);
        String resultBillBalTable = TempTableUtil.createTempTable(ctx, tempTableStruct);
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            StringBuffer sql;
            con = this.getConnection(ctx);
            stmt = con.createStatement();
            if (fAR || param.isQueryAll()) {
                sql = this.insertPeriodBillBalSql(true, companyId, tempBillBalTable, periodID, param);
                stmt.execute(sql.toString());
            }
            if (!fAR || param.isQueryAll()) {
                sql = this.insertPeriodBillBalSql(false, companyId, tempBillBalTable, periodID, param);
                stmt.execute(sql.toString());
            }
            CommonServerUtils.computeBillBalance(ctx, fAR, period, companyInfo, tempBillBalTable, resultBillBalTable, param);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)" computePeriodAcctBal exception,", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
        return resultBillBalTable;
    }

    private String computeAcctBalance(Context ctx, PeriodInfo period, CompanyOrgUnitInfo companyInfo, ContrastGLQueryParam params, boolean fAR) throws BOSException, EASBizException {
        String companyId = companyInfo.getId().toString();
        String periodID = period.getId().toString();
        String tempAcctBalTable = TempTableUtil.createTempTable(ctx, this.tempAcctBalTblStruct());
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.createStatement();
            StringBuffer sql = this.insertPeriodAcctBalSql(fAR, companyId, tempAcctBalTable, periodID);
            logger.debug((Object)(" periodStartAmt sql: \r\n" + sql));
            stmt.execute(sql.toString());
            CommonServerUtils.computeAcctBalance(ctx, fAR, period, companyInfo, (ArApParams)params, tempAcctBalTable);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)" computePeriodAcctBal exception,", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
        return tempAcctBalTable;
    }

    private StringBuffer insertPeriodBillBalSql(boolean fAR, String companyId, String tempAcctBalTable, String periodID, ContrastGLQueryParam param) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tempAcctBalTable);
        sql.append("(FBalType, FCompanyID, FPeriodID, FCurrencyID, FBeginBalanceFor,");
        sql.append("FDebitFor, FCreditFor, FYearDebitFor, FYearCreditFor,");
        sql.append("FEndBalanceFor, FBeginBalanceLocal, FDebitLocal,");
        sql.append("FCreditLocal, FYearDebitLocal, FYearCreditLocal,");
        sql.append("FEndBalanceLocal, FID, FAsstActTypeID, FAsstActID,");
        sql.append("FAdminOrgUnitID, FPersonID)");
        sql.append("\r\n select ").append(3).append(", FCompanyID, FPeriodID, FCurrencyID,");
        sql.append(fAR ? "" : " -1 * ").append("FBeginBalanceFor,");
        sql.append("0, 0, FYearDebitFor - FDebitFor, FYearCreditFor - FCreditFor,");
        sql.append("0,");
        sql.append(fAR ? "" : " -1 * ").append("FBeginBalanceLocal,");
        sql.append("0, 0,");
        sql.append("FYearDebitLocal - FDebitLocal, FYearCreditLocal - FCreditLocal,");
        sql.append("0, FID, FAsstActTypeID, FAsstActID,");
        sql.append("FAdminOrgUnitID, FPersonID\r\n from ");
        sql.append(fAR ? "t_ar_ArBalance" : "t_ap_ApBalance");
        sql.append(" where FCompanyId = '").append(companyId);
        sql.append("' and FPeriodId = '").append(periodID).append("' ");
        sql.append(" AND FBalType IN (").append(101);
        sql.append((fAR ? ", 104" : "") + (param.isIncludeBizBill() ? ", 102" : "") + (param.isCash() ? ", 103" : "")).append(")");
        return sql;
    }

    private StringBuffer insertPeriodAcctBalSql(boolean fAR, String companyId, String tempAcctBalTable, String periodID) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tempAcctBalTable);
        sql.append("(FBalType, FCompanyID, FPeriodID, FCurrencyID, FBeginBalanceFor,");
        sql.append("FDebitFor, FCreditFor, FYearDebitFor, FYearCreditFor,");
        sql.append("FEndBalanceFor, FBeginBalanceLocal, FDebitLocal,");
        sql.append("FCreditLocal, FYearDebitLocal, FYearCreditLocal,");
        sql.append("FEndBalanceLocal, FID, FAsstActTypeID, FAsstActID,");
        sql.append("FAccount ,FAdminOrgUnitID, FPersonID)");
        sql.append("\r\n select FBalType, FCompanyID, FPeriodID, FCurrencyID, FBeginBalanceFor,");
        sql.append("FDebitFor, FCreditFor, FYearDebitFor, FYearCreditFor,");
        sql.append("FEndBalanceFor, FBeginBalanceLocal, FDebitLocal,");
        sql.append("FCreditLocal, FYearDebitLocal, FYearCreditLocal,");
        sql.append("FEndBalanceLocal, FID, FAsstActTypeID, FAsstActID,");
        sql.append("FAccount ,FAdminOrgUnitID, FPersonID\r\n from ");
        sql.append(fAR ? "t_ar_ArBalanceCollate" : "t_ap_ApBalanceCollate");
        sql.append(" where FCompanyId = '").append(companyId);
        sql.append("' and FPeriodId = '").append(periodID).append("' ");
        return sql;
    }

    private String tempAcctBalTblStruct() throws BOSException, EASBizException {
        StringBuffer struct = new StringBuffer();
        struct.append("( FBalType INT, FCompanyID VARCHAR(44) ");
        struct.append(", FPeriodID VARCHAR(44)  ,FCurrencyID");
        struct.append(" VARCHAR(44)  ,FBeginBalanceFor NUMERIC(19,4)");
        struct.append(" DEFAULT 0 NOT NULL ,FDebitFor NUMERIC(19,4) DEFAULT ");
        struct.append("0 NOT NULL, FCreditFor NUMERIC(19,4) DEFAULT 0 NOT");
        struct.append(" NULL, FYearDebitFor NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        struct.append(" FYearCreditFor NUMERIC(19,4) DEFAULT 0 NOT NULL, ");
        struct.append("FEndBalanceFor NUMERIC(19,4) DEFAULT 0 NOT NULL , ");
        struct.append("FBeginBalanceLocal NUMERIC(19,4) DEFAULT 0 NOT NULL,");
        struct.append(" FDebitLocal NUMERIC(19,4) DEFAULT 0 NOT NULL, ");
        struct.append("FCreditLocal NUMERIC(19,4) DEFAULT 0 NOT NULL, ");
        struct.append("FYearDebitLocal NUMERIC(19,4) DEFAULT 0 NOT NULL, ");
        struct.append("FYearCreditLocal NUMERIC(19,4) DEFAULT 0 NOT NULL, ");
        struct.append("FEndBalanceLocal NUMERIC(19,4) DEFAULT 0 NOT NULL, ");
        struct.append("FID VARCHAR(44), FAsstActTypeID VARCHAR(44)");
        struct.append("  ,FAsstActID VARCHAR(44)  ,FAccount ");
        struct.append("VARCHAR(44)  ,FAdminOrgUnitID VARCHAR(44),");
        struct.append(" FPersonID VARCHAR(44));");
        return struct.toString();
    }

    private IReportData getContrastRptData(Context ctx, ContrastGLQueryParam param, Boolean isAr) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)param.getTempTable())) {
            return null;
        }
        boolean needAccount = !param.isBySum() && !param.isByBillSum();
        StringBuilder sql = new StringBuilder(200);
        sql.append("select TOP ").append(param.getEndIndex());
        sql.append(needAccount ? " FAccount, FAccountID, " : " ");
        sql.append("FCurrencyID, ");
        if (param.getAllAmountLocal() == 0) {
            sql.append("FCurrency, ");
        } else if (param.getAllAmountLocal() == 1) {
            sql.append("FCurrencyLocal, ");
        } else if (param.getAllAmountLocal() == 2) {
            sql.append("FCurrency, FCurrencyLocal,");
        }
        sql.append(" FCussTypeID, FCussType, FCussAcct, FCussNum, FCussName,  \r\n ");
        if (param.getAllAmountLocal() == 1) {
            sql.append(" FGLStartAmtLocal, FGLDebitAmtLocal, ");
            sql.append(" FGLCreditAmtLocal, FGLBalanceAmtLocal,").append(NEW_LINE);
            sql.append(" FArStartAmtLocal, FArDebitAmtLocal, ");
            sql.append(" FStartDiffAmtLocal, FDebitDiffAmtLocal, ").append(NEW_LINE);
            sql.append(" FCreditDiffAmtLocal, FBalanceDiffAmtLocal, ");
            sql.append(" FArCreditAmtLocal, FArBalanceAmtLocal, FIsSum ");
        } else if (param.isAmountLocal()) {
            sql.append(" FGLStartAmt, FGLStartAmtLocal, FGLDebitAmt, FGLDebitAmtLocal, ").append(NEW_LINE);
            sql.append(" FGLCreditAmt, FGLCreditAmtLocal, FGLBalanceAmt, FGLBalanceAmtLocal, ").append(NEW_LINE);
            sql.append(" FArStartAmt, FArStartAmtLocal, FArDebitAmt, FArDebitAmtLocal, ").append(NEW_LINE);
            sql.append(" FStartDiffAmt, FStartDiffAmtLocal, FDebitDiffAmt, FDebitDiffAmtLocal, ").append(NEW_LINE);
            sql.append(" FCreditDiffAmt, FCreditDiffAmtLocal, FBalanceDiffAmt, FBalanceDiffAmtLocal, ").append(NEW_LINE);
            sql.append(" FArCreditAmt, FArCreditAmtLocal, FArBalanceAmt, FArBalanceAmtLocal, FIsSum ");
        } else {
            sql.append(" FGLStartAmt, FGLDebitAmt, ");
            sql.append(" FGLCreditAmt, FGLBalanceAmt, ").append(NEW_LINE);
            sql.append(" FArStartAmt, FArDebitAmt, ");
            sql.append(" FStartDiffAmt, FDebitDiffAmt, ").append(NEW_LINE);
            sql.append(" FCreditDiffAmt, FBalanceDiffAmt, ");
            sql.append(" FArCreditAmt, FArBalanceAmt, FIsSum ");
        }
        sql.append(NEW_LINE).append(" from ").append(param.getTempTable()).append(NEW_LINE);
        sql.append(" where ( FIsSum = 1");
        if (param.isOnlyUnBalance()) {
            sql.append(" and ( ");
            sql.append(ArApServerUtils.getContrastBalanceSql(param.getContrastCondition(ctx, param.getCompanyId(), isAr), param.isAmountLocal()));
            sql.append(" ) ").append(NEW_LINE);
        }
        sql.append(" ) or FIsSum =").append(param.isOnlyUnBalance() ? "2" : "3").append(NEW_LINE);
        sql.append(" order by ").append(param.getAllAmountLocal() == 1 ? "FCurrencyLocal" : "FCurrency");
        sql.append(", FIsSum, FCussType, FCussNum ");
        sql.append(needAccount ? ", FAccount " : " ");
        logger.debug((Object)("query sql: \r\n" + sql));
        ArApReportData rptData = null;
        IRowSet rs = null;
        int totalRowCount = param.getTotalRowCount();
        try {
            if (totalRowCount == 0 && (rs = DBUtil.executeQuery((Context)ctx, (String)("SELECT COUNT(1) AS CNT " + sql.substring(sql.indexOf("from"), sql.indexOf("order"))))).next()) {
                totalRowCount = rs.getInt(1);
            }
            rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
            ArrayList<ReportInfo> dataLst = new ArrayList<ReportInfo>();
            int row = 0;
            while (rs.next()) {
                if (!ArApReportHelper.isInRange(++row, param.getStartIndex(), param.getEndIndex())) continue;
                dataLst.add(this.rs2RptInfo(ctx, (ResultSet)rs, param));
            }
            rptData = new ArApReportData(dataLst, totalRowCount);
            rptData.setTempTable(param.getTempTable());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return rptData;
    }

    private ReportInfo rs2RptInfo(Context ctx, ResultSet rs, ContrastGLQueryParam param) throws SQLException {
        BigDecimal arAmt = null;
        BigDecimal arAmtLocal = null;
        BigDecimal glAmt = null;
        BigDecimal glAmtLocal = null;
        BigDecimal diff = null;
        BigDecimal diffLocal = null;
        ReportInfo rptInfo = new ReportInfo();
        rptInfo.put("FPeriod", param.getPeriodYear() + "-" + param.getPeriodNum());
        rptInfo.put("FCurrencyID", rs.getString("FCurrencyID"));
        if (param.getAllAmountLocal() == 0) {
            rptInfo.put("FCurrency", rs.getString("FCurrency"));
        } else if (param.getAllAmountLocal() == 1) {
            rptInfo.put("FCurrencyLocal", rs.getString("FCurrencyLocal"));
        } else if (param.getAllAmountLocal() == 2) {
            rptInfo.put("FCurrency", rs.getString("FCurrency"));
            rptInfo.put("FCurrencyLocal", rs.getString("FCurrencyLocal"));
        }
        if (!param.isBySum() && !param.isByBillSum()) {
            rptInfo.put("FAccount", rs.getString("FAccount"));
            rptInfo.put("FAccountID", rs.getString("FAccountID"));
        }
        rptInfo.put("FCussTypeID", rs.getString("FCussTypeID"));
        rptInfo.put("FCussTypeName", rs.getString("FCussType"));
        rptInfo.put("FCussAcct", rs.getString("FCussAcct"));
        rptInfo.put("FCussName", rs.getString("FCussName"));
        rptInfo.put("FCussNum", rs.getString("FCussNum"));
        if (rs.getInt("FIsSum") > 1) {
            rptInfo.setIsTotalLine(true);
            rptInfo.put("FCussName", ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"abstractName2", (Locale)ctx.getLocale()));
        }
        if (param.getAllAmountLocal() == 0 || param.getAllAmountLocal() == 2) {
            arAmt = this.getAmt(rs, "FArStartAmt");
            glAmt = this.getAmt(rs, "FGLStartAmt");
            diff = this.getAmt(rs, "FStartDiffAmt");
            rptInfo.put("FArStartAmt", arAmt);
            rptInfo.put("FGLStartAmt", glAmt);
            rptInfo.put("FStartDiffAmt", diff);
            arAmt = this.getAmt(rs, "FArDebitAmt");
            glAmt = this.getAmt(rs, "FGLDebitAmt");
            diff = this.getAmt(rs, "FDebitDiffAmt");
            rptInfo.put("FArDebitAmt", arAmt);
            rptInfo.put("FGLDebitAmt", glAmt);
            rptInfo.put("FDebitDiffAmt", diff);
            arAmt = this.getAmt(rs, "FArCreditAmt");
            glAmt = this.getAmt(rs, "FGLCreditAmt");
            diff = this.getAmt(rs, "FCreditDiffAmt");
            rptInfo.put("FArCreditAmt", arAmt);
            rptInfo.put("FGLCreditAmt", glAmt);
            rptInfo.put("FCreditDiffAmt", diff);
            arAmt = this.getAmt(rs, "FArBalanceAmt");
            glAmt = this.getAmt(rs, "FGLBalanceAmt");
            diff = this.getAmt(rs, "FBalanceDiffAmt");
            rptInfo.put("FArBalanceAmt", arAmt);
            rptInfo.put("FGLBalanceAmt", glAmt);
            rptInfo.put("FBalanceDiffAmt", diff);
        }
        if (param.getAllAmountLocal() == 1 || param.getAllAmountLocal() == 2) {
            arAmtLocal = this.getAmt(rs, "FArStartAmtLocal");
            glAmtLocal = this.getAmt(rs, "FGLStartAmtLocal");
            diffLocal = this.getAmt(rs, "FStartDiffAmtLocal");
            rptInfo.put("FArStartAmtLocal", arAmtLocal);
            rptInfo.put("FGLStartAmtLocal", glAmtLocal);
            rptInfo.put("FStartDiffAmtLocal", diffLocal);
            arAmtLocal = this.getAmt(rs, "FArDebitAmtLocal");
            glAmtLocal = this.getAmt(rs, "FGLDebitAmtLocal");
            diffLocal = this.getAmt(rs, "FDebitDiffAmtLocal");
            rptInfo.put("FArDebitAmtLocal", arAmtLocal);
            rptInfo.put("FGLDebitAmtLocal", glAmtLocal);
            rptInfo.put("FDebitDiffAmtLocal", diffLocal);
            arAmtLocal = this.getAmt(rs, "FArCreditAmtLocal");
            glAmtLocal = this.getAmt(rs, "FGLCreditAmtLocal");
            diffLocal = this.getAmt(rs, "FCreditDiffAmtLocal");
            rptInfo.put("FArCreditAmtLocal", arAmtLocal);
            rptInfo.put("FGLCreditAmtLocal", glAmtLocal);
            rptInfo.put("FCreditDiffAmtLocal", diffLocal);
            arAmtLocal = this.getAmt(rs, "FArBalanceAmtLocal");
            glAmtLocal = this.getAmt(rs, "FGLBalanceAmtLocal");
            diffLocal = this.getAmt(rs, "FBalanceDiffAmtLocal");
            rptInfo.put("FArBalanceAmtLocal", arAmtLocal);
            rptInfo.put("FGLBalanceAmtLocal", glAmtLocal);
            rptInfo.put("FBalanceDiffAmtLocal", diffLocal);
        }
        rptInfo.put("FIsSum", rs.getInt("FIsSum"));
        return rptInfo;
    }

    private BigDecimal getAmt(ResultSet rs, String fld) throws SQLException {
        return rs.getBigDecimal(fld) == null ? SysConstant.BIGZERO : rs.getBigDecimal(fld);
    }

    @Override
    protected IObjectCollection _getAsstActType(Context ctx, BOSUuid companyId, List accountIds) throws BOSException {
        if (accountIds == null || accountIds.size() == 0) {
            return null;
        }
        StringBuffer ids = new StringBuffer(150);
        int n = accountIds.size();
        for (int i = 0; i < n; ++i) {
            ids.append("'").append(accountIds.get(i)).append("'");
            ids.append(i + 1 < n ? "," : "");
        }
        StringBuffer sql = new StringBuffer(300);
        sql.append("select distinct tas.* from T_AR_ContrastAccountView tcav").append(NEW_LINE);
        sql.append("inner join T_BD_AsstActType tas on tcav.FAsstActTypeID = tas.FID").append(NEW_LINE);
        sql.append("where tcav.FAccountID in (").append(ids).append(")").append(NEW_LINE);
        sql.append("and tcav.FCompanyID=?");
        AsstActTypeCollection asstActTypes = null;
        IRowSet rs = KsqlUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId.toString()});
        try {
            if (rs != null && rs.size() > 0) {
                asstActTypes = new AsstActTypeCollection();
                while (rs.next()) {
                    AsstActTypeInfo asstActTypeInfo = new AsstActTypeInfo();
                    asstActTypeInfo.put("id", (Object)rs.getString("FId"));
                    asstActTypeInfo.setName(rs.getString("FName_" + ctx.getLocale().getLanguage()));
                    asstActTypeInfo.setNumber(rs.getString("FNumber"));
                    asstActTypeInfo.setRealtionDataObject(rs.getString("FRealtionDataObject"));
                    asstActTypeInfo.setDefaultQueryName(rs.getString("FDefaultQueryName"));
                    asstActTypeInfo.setMappingFieldName(rs.getString("FMappingFieldName"));
                    asstActTypes.add(asstActTypeInfo);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return asstActTypes;
    }

    private String toNextPeriodTmpTblDef() {
        StringBuffer sql = new StringBuffer();
        sql.append(" (FBillId varchar(44), ");
        sql.append(" FBillType varchar(80))");
        return sql.toString();
    }

    @Override
    protected boolean _toNextPeriod(Context ctx, Map billinfo, boolean isAr, CompanyOrgUnitInfo companyOrgUnitInfo) throws BOSException {
        boolean bl;
        StringBuilder sqlstr;
        Statement statement;
        Connection con;
        String tempTable;
        block26: {
            if (null == billinfo || billinfo.size() == 0) {
                return false;
            }
            tempTable = TempTableUtil.createTempTable(ctx, this.toNextPeriodTmpTblDef());
            TempTablePool t = TempTablePool.getInstance((Context)ctx);
            try {
                t.createIndex(tempTable, "FBillType, FBillId", true, false);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            Iterator iterator = billinfo.keySet().iterator();
            ArrayList<String> insertSqlList = new ArrayList<String>(billinfo.size());
            while (iterator.hasNext()) {
                String fid = ((String)iterator.next()).toString();
                StringBuilder insertSql = new StringBuilder(300);
                insertSql.append("Insert into ");
                insertSql.append(tempTable);
                insertSql.append(" (FBillId, FBillType)");
                insertSql.append(" values");
                insertSql.append(" ('");
                insertSql.append(fid);
                insertSql.append("','");
                insertSql.append(billinfo.get(fid).toString());
                insertSql.append("')");
                insertSqlList.add(insertSql.toString());
            }
            DBUtil.execBatchSql((Context)ctx, insertSqlList, (boolean)true);
            ArrayList<String> list = new ArrayList<String>();
            PeriodInfo periodInfo = null;
            PeriodInfo nextperiodInfo = null;
            boolean billDateSyncToBizDate = false;
            try {
                periodInfo = isAr ? ArServerUtils.getArCurrentPeriod(ctx, companyOrgUnitInfo) : ApServerUtils.getApCurrentPeriod(ctx, companyOrgUnitInfo);
                if (billinfo.containsValue("otherbill")) {
                    String billClass = isAr ? "com.kingdee.eas.fi.ar.client.OtherBillEditUI" : "com.kingdee.eas.fi.ap.client.OtherBillEditUI";
                    billDateSyncToBizDate = CommonServerUtils.getOptionConfig4User(ctx, billClass, ArApConstants.BILL_DATE_SYNC_TO_BIZ_DATE);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            if (periodInfo == null) {
                return false;
            }
            try {
                nextperiodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)periodInfo);
            }
            catch (EASBizException e) {
                logger.debug((Object)e);
            }
            catch (BOSException e) {
                logger.debug((Object)e);
            }
            if (nextperiodInfo != null) {
                nextperiodInfo = this._getNextPeriod(ctx, nextperiodInfo);
            }
            if (nextperiodInfo == null) {
                return false;
            }
            int year = nextperiodInfo.getPeriodYear();
            int month = nextperiodInfo.getPeriodNumber();
            Date date = nextperiodInfo.getBeginDate();
            java.sql.Date sqldate = new java.sql.Date(date.getTime());
            if (isAr) {
                StringBuffer incomeConfimSql = new StringBuffer();
                incomeConfimSql.append("update T_AR_IncomeConfimBill set");
                incomeConfimSql.append(" fyear=" + year + ",");
                incomeConfimSql.append(" fperiod=" + month + ",");
                incomeConfimSql.append(" fbilldate=to_date('" + sqldate + "') ");
                incomeConfimSql.append(" where fid in (");
                incomeConfimSql.append(" select FBillId from " + tempTable);
                incomeConfimSql.append(" where FBillType = 'incomeConfirm' )");
                incomeConfimSql.append(" and fbillstatus < ").append(3);
                list.add(incomeConfimSql.toString());
                StringBuffer incomeConfimEntrySql = new StringBuffer();
                incomeConfimEntrySql.append(" update T_AR_IncomeConfimEntry as billentry set");
                incomeConfimEntrySql.append(" fbilldate = to_date('" + sqldate + "')");
                incomeConfimEntrySql.append(" where exists (");
                incomeConfimEntrySql.append("    select FID from T_AR_IncomeConfimBill bill");
                incomeConfimEntrySql.append("    where bill.fbillstatus < ").append(3);
                incomeConfimEntrySql.append("    and bill.fid=billentry.fparentid)");
                incomeConfimEntrySql.append(" and billentry.fparentid in (");
                incomeConfimEntrySql.append(" select FBillId from " + tempTable);
                incomeConfimEntrySql.append(" where FBillType = 'incomeConfirm' )");
                list.add(incomeConfimEntrySql.toString());
            }
            if (billinfo.containsValue("otherbill")) {
                StringBuilder othersql = new StringBuilder(300);
                String otherbillTbl = isAr ? "T_AR_OtherBill" : "T_AP_OtherBill";
                othersql.append("update " + otherbillTbl + " set");
                othersql.append(" fyear=" + year + ",");
                othersql.append(" fperiod=" + month + ",");
                othersql.append(" fbilldate=to_date('" + sqldate + "') ");
                if (billDateSyncToBizDate) {
                    othersql.append(", fbizdate = to_date('" + sqldate + "') ").append(NEW_LINE);
                }
                othersql.append(" where fid in (");
                othersql.append(" select FBillId from " + tempTable);
                othersql.append(" where FBillType = 'otherbill' )");
                othersql.append(" and fbillstatus < ").append(3);
                list.add(othersql.toString());
                StringBuilder otherentrysql = new StringBuilder(500);
                String otherbillEntryTbl = isAr ? "T_AR_OtherBillEntry" : "T_AP_OtherBillEntry";
                otherentrysql.append(" update " + otherbillEntryTbl + " as billentry set");
                otherentrysql.append(" fbilldate = to_date('" + sqldate + "')");
                otherentrysql.append(" where exists (");
                otherentrysql.append("    select FID from");
                otherentrysql.append("    " + otherbillTbl + " bill ");
                otherentrysql.append("    where bill.fbillstatus < ").append(3);
                otherentrysql.append("    and bill.fid=billentry.fparentid)");
                otherentrysql.append(" and billentry.fparentid in (");
                otherentrysql.append(" select FBillId from " + tempTable);
                otherentrysql.append(" where FBillType = 'otherbill' )");
                list.add(otherentrysql.toString());
            }
            if (billinfo.containsValue("proxybill")) {
                String proxyBillTbl = isAr ? "T_ARP_ProxyBill" : "T_ARP_ProxyBill";
                StringBuilder porxysql = new StringBuilder(300);
                porxysql.append("update " + proxyBillTbl + " set");
                porxysql.append(" fbilldate=to_date('" + sqldate + "')");
                porxysql.append(" where fid in (");
                porxysql.append(" select FBillId from " + tempTable);
                porxysql.append(" where FBillType = 'proxybill' )");
                porxysql.append(" and fbillstatus < ").append(3);
                list.add(porxysql.toString());
            }
            if (billinfo.containsValue("receivingbill") || billinfo.containsValue("paymentBill")) {
                StringBuilder recesql = new StringBuilder(300);
                String recPayBillTbl = isAr ? "T_CAS_ReceivingBill" : "T_CAS_PaymentBill";
                recesql.append("update " + recPayBillTbl + " set");
                recesql.append(" fbizdate=to_date('" + sqldate + "')");
                recesql.append(" where fid in (");
                recesql.append(" select FBillId from " + tempTable);
                recesql.append(" where FBillType = '");
                recesql.append(isAr ? "receivingbill" : "paymentBill");
                recesql.append("')");
                recesql.append(" and fbillstatus <= ").append(12);
                list.add(recesql.toString());
            }
            con = null;
            statement = null;
            sqlstr = new StringBuilder(1000);
            con = EJBFactory.getConnection((Context)ctx);
            statement = con.createStatement();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    statement.addBatch((String)list.get(i));
                    sqlstr.append((String)list.get(i)).append("\t\n");
                }
            }
            int[] i = statement.executeBatch();
            statement.clearBatch();
            int count = 0;
            for (int j = 0; j < i.length; ++j) {
                count += i[j];
            }
            if (count != 0) break block26;
            bl = false;
            SQLUtils.cleanup((Statement)statement, (Connection)con);
            TempTableUtil.releasTempTable(ctx, tempTable);
            return bl;
        }
        try {
            bl = true;
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sqlstr, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                TempTableUtil.releasTempTable(ctx, tempTable);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        TempTableUtil.releasTempTable(ctx, tempTable);
        return bl;
    }

    @Override
    protected boolean _toNextPeriod4Web(Context ctx, Map billInfo, boolean isAR, CompanyOrgUnitInfo company, String tempTable, PeriodInfo clientCurrentPeriod) throws BOSException {
        boolean result = false;
        try {
            result = this.toNextPeriod1(ctx, billInfo, isAR, company, clientCurrentPeriod);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (result) {
            DbUtil.execute((Context)ctx, (String)("delete from " + tempTable + " where billid in (" + ArApStringUtil.convertIdsStr2SqlCondition(ArApStringUtil.convertSet2String(billInfo.keySet())) + ")"));
        }
        return result;
    }

    private PeriodInfo _getNextPeriod(Context ctx, PeriodInfo curperiod) {
        if (curperiod.isIsAdjustPeriod()) {
            try {
                curperiod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)curperiod);
            }
            catch (EASBizException e) {
                logger.debug((Object)e);
            }
            catch (BOSException e) {
                logger.debug((Object)e);
            }
        }
        if (curperiod.isIsAdjustPeriod()) {
            this._getNextPeriod(ctx, curperiod);
        }
        return curperiod;
    }

    @Override
    protected Map _contrastGL4closeAccount(Context ctx, ContrastGLQueryParam param, boolean isAr) throws BOSException, EASBizException {
        IReportData contrastResult = null;
        HashMap<String, Object> result = new HashMap<String, Object>();
        contrastResult = isAr ? this._arContrastGL(ctx, param) : this._apContrastGL(ctx, param);
        if (contrastResult != null && contrastResult.getTotalRowCount() > 0) {
            result.put("contrastResult", "0");
        } else {
            result.put("contrastResult", "1");
        }
        result.put("param", (Object)param);
        return result;
    }

    public Map<String, String> initTempTable(Context ctx) throws BOSException, EASBizException {
        StringBuilder buf = new StringBuilder(150).append(" CREATE TABLE TEMP_TABLE(").append(NEW_LINE).append(" ID VARCHAR(44),").append(NEW_LINE).append(" COMPANYID VARCHAR(44),").append(NEW_LINE).append(" BILLID VARCHAR(44),").append(NEW_LINE).append(" BILLNUM VARCHAR(80),").append(NEW_LINE).append(" BILLTYPE VARCHAR(20),").append(NEW_LINE).append(" ERRORTYPE NVARCHAR(20),").append(NEW_LINE).append(" ISAUDITED INT,").append(NEW_LINE).append(" ITEM NVARCHAR(60),").append(NEW_LINE).append(" RESULT NVARCHAR(150)").append(NEW_LINE).append(" )");
        String tempTable = SQLDataAccessFacadeFactory.getLocalInstance((Context)ctx).createTempTable(buf.toString(), null, null, null);
        buf.setLength(0);
        buf.append("INSERT INTO ").append(tempTable).append(NEW_LINE).append(" (ID, COMPANYID, BILLID, BILLNUM, BILLTYPE, ERRORTYPE, ISAUDITED, ITEM, RESULT)").append(NEW_LINE).append(" VALUES (NEWBOSID('88888888'), ?, ?, ?, ?, ?, ?, ?, ?)");
        HashMap<String, String> tempMap = new HashMap<String, String>(2);
        tempMap.put("tempTable", tempTable);
        tempMap.put(TEMP_INSERT_SQL, buf.toString());
        return tempMap;
    }

    public void createIndex(Context ctx, String tempTable) throws BOSException, EASBizException {
        StringBuilder buf = new StringBuilder(50).append("CREATE INDEX IDX").append(tempTable.substring(3, tempTable.length())).append(" ON ").append(tempTable).append(" (COMPANYID) ");
        DbUtil.execute((Context)ctx, (String)buf.toString());
    }

    public void batchInsert(Context ctx, String companyId, String batch_sql, IReportData rptData) throws BOSException {
        int size = rptData.size();
        if (StringUtils.isEmpty((String)companyId) || StringUtils.isEmpty((String)batch_sql) || size == 0) {
            return;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(size);
        Object[] params = null;
        IObjectValue info = null;
        for (int i = 0; i < size; ++i) {
            info = rptData.getReportRowInfo(i);
            params = new Object[]{companyId, info.getString("billid"), info.getString("billnum"), info.getString("billtype"), info.getString("errortype"), info.getInt("isaudited"), info.getString("item"), info.getString("result")};
            paramsList.add(params);
        }
        DbUtil.executeBatch((Context)ctx, (String)batch_sql, paramsList);
    }

    @Override
    protected Map _batchCheckArApGL(Context ctx, Map soluMap, boolean isAr) throws BOSException, EASBizException {
        HashMap<String, Object> batchResultMap = new HashMap<String, Object>();
        if (null != soluMap && !soluMap.isEmpty()) {
            Map<String, String> tempMap = this.initTempTable(ctx);
            String tempTable = tempMap.get("tempTable");
            this.createIndex(ctx, tempTable);
            batchResultMap.put("tempTable", tempTable);
            HashMap<String, Integer> resultMap = new HashMap<String, Integer>(soluMap.size());
            batchResultMap.put("resultMap", resultMap);
            Iterator it = soluMap.keySet().iterator();
            String companyId = null;
            ContrastGLCheckParam param = null;
            String batch_sql = tempMap.get(TEMP_INSERT_SQL);
            if (soluMap.size() == 1) {
                companyId = (String)it.next();
                param = (ContrastGLCheckParam)soluMap.get(companyId);
                IReportData rptData = this.checkArApGLWithLogging(ctx, param, isAr);
                resultMap.put(companyId, rptData.size());
                this.batchInsert(ctx, companyId, batch_sql, rptData);
            } else {
                ExecutorService es = Executors.newFixedThreadPool(2 * cpus);
                ArrayList<Future<IReportData>> jobResults = new ArrayList<Future<IReportData>>(soluMap.size());
                while (it.hasNext()) {
                    companyId = (String)it.next();
                    param = (ContrastGLCheckParam)soluMap.get(companyId);
                    Future<IReportData> feture = es.submit(new checkJob(ctx, isAr, companyId, this, param));
                    jobResults.add(feture);
                }
                try {
                    for (int i = 0; i < jobResults.size(); ++i) {
                        IReportData rptData;
                        try {
                            rptData = (IReportData)((Future)jobResults.get(i)).get();
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), e.getCause());
                            throw new BOSException((Throwable)e);
                        }
                        companyId = (String)rptData.getAssistData().get("companyId");
                        resultMap.put(companyId, rptData.size());
                        this.batchInsert(ctx, companyId, batch_sql, rptData);
                    }
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
                finally {
                    es.shutdown();
                }
            }
        }
        return batchResultMap;
    }

    @Override
    protected Map _getCheckDetail(Context ctx, int page, int rows, String companyId, String tempTable, String sortItems) throws BOSException, EASBizException {
        HashMap resultMap = new HashMap();
        if (StringUtils.isEmpty((String)tempTable)) {
            return resultMap;
        }
        StringBuilder buf = new StringBuilder(100).append("SELECT ID, COMPANYID, BILLID, BILLNUM, BILLTYPE, ERRORTYPE, ISAUDITED, ITEM, RESULT,").append("FNAME_").append(ctx.getLocale()).append(" as COMPANYNAME").append("\r\n").append(" FROM ").append(tempTable).append(" TEMP left join T_ORG_COMPANY TOC ON TEMP.COMPANYID = TOC.FID ").append("\r\n");
        if (!StringUtils.isEmpty((String)companyId)) {
            buf.append(" WHERE COMPANYID = '").append(companyId).append("'").append("\r\n");
        }
        buf.append(" ORDER BY ");
        if (!StringUtils.isEmpty((String)sortItems)) {
            buf.append(sortItems).append(", ");
        }
        String[] defaultSortField = new String[]{"COMPANYID", "billNum"};
        for (int i = 0; i < defaultSortField.length; ++i) {
            String fieldName = defaultSortField[i];
            if (null != sortItems && sortItems.indexOf(fieldName) != -1) continue;
            buf.append(fieldName).append(" DESC");
            if (i == defaultSortField.length - 1) continue;
            buf.append(", ");
        }
        int start = rows * (page - 1);
        IRowSet rs = null;
        rs = rows > 0 ? DbUtil.executeQuery((Context)ctx, (String)buf.toString(), (int)start, (int)rows) : DbUtil.executeQuery((Context)ctx, (String)buf.toString());
        LinkedList datas = new LinkedList();
        try {
            HashMap<String, Object> rowMap = null;
            while (rs.next()) {
                rowMap = new HashMap<String, Object>();
                rowMap.put("id", rs.getString("ID"));
                rowMap.put("companyId", rs.getString("COMPANYID"));
                rowMap.put("companyName", rs.getString("COMPANYNAME"));
                rowMap.put("billID", rs.getString("BILLID"));
                rowMap.put("billNum", rs.getString("BILLNUM"));
                rowMap.put("billType", rs.getString("BILLTYPE"));
                rowMap.put("errorType", rs.getString("ERRORTYPE"));
                rowMap.put("isAudited", rs.getInt("ISAUDITED"));
                rowMap.put("item", rs.getString("ITEM"));
                rowMap.put("result", rs.getString("RESULT"));
                datas.add(rowMap);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), e.getCause());
            throw new BOSException((Throwable)e);
        }
        resultMap.put("rowSet", datas);
        return resultMap;
    }

    @Override
    protected Set _getOppositeAccountIdSet(Context ctx, Set accountIdSet, int periodYear, int periodNumber, boolean isAr) throws BOSException, EASBizException {
        int size;
        HashSet<String> oppositeAccountIdSet = null;
        if (null == accountIdSet || accountIdSet.size() == 0) {
            return oppositeAccountIdSet;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)periodYear, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)periodNumber, CompareType.EQUALS));
        int reverseSystem = isAr ? 2 : 1;
        filter.getFilterItems().add(new FilterItemInfo("system", (Object)reverseSystem, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("account.id");
        view.setSelector(sic);
        ContrastAccountViewCollection coll = ContrastAccountViewFactory.getLocalInstance((Context)ctx).getContrastAccountViewCollection(view);
        int n = size = null != coll ? coll.size() : 0;
        if (size > 0) {
            oppositeAccountIdSet = new HashSet<String>(size);
            for (int i = 0; i < size; ++i) {
                oppositeAccountIdSet.add(coll.get(i).getAccount().getId().toString());
            }
        }
        return oppositeAccountIdSet;
    }

    private void checkContrastDetailParam(Context ctx, ContrastGLRptDetailQueryParam param) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)param.getPeriodId()) && param.getPeriodYear() == -1 && param.getPeriodNum() == -1) {
            throw new ContrastGLException(ContrastGLException.PERIOD_NULL);
        }
        if (StringUtils.isEmpty((String)param.getAccountId())) {
            throw new ContrastGLException(ContrastGLException.ACCOUNT_NULL);
        }
        if (StringUtils.isEmpty((String)param.getCurrencyId())) {
            throw new ContrastGLException(ContrastGLException.CURRENCY_NULL);
        }
    }

    public static String createTempTable(TempTablePool pool, String tableDefine) throws BOSException {
        String tableName = null;
        try {
            if (null != pool) {
                tableName = pool.createTempTable("CREATE TABLE TEMP_KSQL_1 " + tableDefine);
            }
        }
        catch (Exception e) {
            throw new BOSException("create tempTable error", (Throwable)e);
        }
        return tableName;
    }

    private String createDetailTempTable(Context ctx, ContrastGLRptDetailQueryParam param, TempTablePool pool) throws BOSException, EASBizException {
        StringBuilder buf = new StringBuilder(150).append(" ( ").append("FID").append(" VARCHAR(44),").append(NEW_LINE).append("FsceneNumber").append(" VARCHAR(50),").append(NEW_LINE).append("FBillID").append(" VARCHAR(44),").append(NEW_LINE).append("FBillBostype").append(" VARCHAR(44),").append(NEW_LINE).append("FBillNumber").append(" VARCHAR(80),").append(NEW_LINE).append("FVoucher").append(" NVARCHAR(180),").append(NEW_LINE).append("FBillDate").append(" DATETIME,").append(NEW_LINE).append("FBillAmount").append(" DECIMAL(28, 10) NOT NULL DEFAULT 0,").append(NEW_LINE).append("FVoucherID").append(" VARCHAR(44) NOT NULL DEFAULT ").append("'~~~~~~~~~~~~~~~~~~~~~~~~~~~~'").append(",").append(NEW_LINE).append("FVoucherPeriod").append(" NVARCHAR(20),").append(NEW_LINE).append("FVoucherNumber").append(" NVARCHAR(180),").append(NEW_LINE).append("FVoucherAmount").append(" DECIMAL(28, 10) NOT NULL DEFAULT 0, ").append(NEW_LINE).append("FDiffAmount").append(" DECIMAL(28, 10) NOT NULL DEFAULT 0, ").append(NEW_LINE).append("FDiffType").append(" INT, ").append(NEW_LINE).append("FIsSum").append(" INT NOT NULL DEFAULT 0 ").append(NEW_LINE).append(" )");
        return ContrastGLFacadeControllerBean.createTempTable(pool, buf.toString());
    }

    public AsstActTypeInfo getAsstActType(Context ctx, String cussTypeId) throws BOSException, EASBizException {
        AsstActTypeInfo asstActType = null;
        if (StringUtils.isEmpty((String)cussTypeId)) {
            return asstActType;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("realtionDataObject");
        sic.add("mappingFieldName");
        asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(cussTypeId), sic);
        return asstActType;
    }

    private String createVoucherTempTable(Context ctx, ContrastGLRptDetailQueryParam param, TempTablePool pool) throws BOSException, EASBizException {
        StringBuilder buf = new StringBuilder(150).append(" ( ").append("FVoucherID").append(" VARCHAR(44),").append(NEW_LINE).append("FVoucherPeriod").append(" NVARCHAR(20),").append(NEW_LINE).append("FVoucherNumber").append(" NVARCHAR(180),").append(NEW_LINE).append("FVoucherAmount").append(" DECIMAL(28, 10) NOT NULL DEFAULT 0 ").append(NEW_LINE).append(" )");
        return ContrastGLFacadeControllerBean.createTempTable(pool, buf.toString());
    }

    private String prepareVoucherData(Context ctx, ContrastGLRptDetailQueryParam param, TempTablePool pool) throws BOSException, EASBizException {
        String voucherTable = this.createVoucherTempTable(ctx, param, pool);
        try {
            pool.createIndex(voucherTable, "FVoucherID", true, false);
        }
        catch (Exception e) {
            throw new BOSException("create index for table [" + voucherTable + "] error.");
        }
        String cussTypeId = param.getCussTypeId();
        AsstActTypeInfo asstActType = null;
        if (!StringUtils.isEmpty((String)cussTypeId) && !"null".equalsIgnoreCase(cussTypeId)) {
            asstActType = this.getAsstActType(ctx, cussTypeId);
        }
        Boolean hasACussAcct = null != asstActType && !StringUtils.isEmpty((String)param.getCussAcctId()) && !"null".equalsIgnoreCase(param.getCussAcctId());
        StringBuilder buf = new StringBuilder(500).append("INSERT INTO ").append(voucherTable).append("(").append(NEW_LINE).append("FVoucherID").append(",").append(NEW_LINE).append("FVoucherPeriod").append(", ").append(NEW_LINE).append("FVoucherNumber").append(", ").append(NEW_LINE).append("FVoucherAmount").append(NEW_LINE).append(")").append(NEW_LINE).append(" SELECT ").append("FVoucherID").append(", ").append("FVoucherPeriod").append(", ").append("FVoucherNumber").append(", SUM(FGlAomount) AS ").append("FVoucherAmount").append(NEW_LINE);
        buf.append(" FROM (").append(" SELECT TGV.FID AS ").append("FVoucherID").append(", ").append(NEW_LINE).append(" TO_CHAR(TBP.FPERIODYEAR)||'\u5e74'||TO_CHAR(TBP.FPERIODNUMBER)||'\u671f' AS ").append("FVoucherPeriod").append(", ").append(NEW_LINE).append(" '['|| TBVT.FNAME_").append(ctx.getLocale().getLanguage()).append("||']'||TGV.FNUMBER AS ").append("FVoucherNumber").append(", ").append(NEW_LINE);
        if (hasACussAcct.booleanValue()) {
            buf.append(" TGVAR.FORIGINALAMOUNT AS FGlAomount").append(NEW_LINE);
        } else {
            buf.append(" TGVE.FORIGINALAMOUNT AS FGlAomount").append(NEW_LINE);
        }
        buf.append("FROM T_GL_VOUCHERENTRY TGVE ").append(NEW_LINE).append("INNER JOIN T_GL_VOUCHER TGV ON TGVE.FBILLID = TGV.FID ").append(NEW_LINE).append("INNER JOIN T_BD_PERIOD TBP ON TBP.FID = TGVE.FPERIODID ").append(NEW_LINE).append("INNER JOIN T_BD_VOUCHERTYPES TBVT ON TBVT.FID = TGV.FVOUCHERTYPEID ").append(NEW_LINE);
        if (hasACussAcct.booleanValue()) {
            buf.append("LEFT JOIN T_GL_VOUCHERASSISTRECORD TGVAR ON TGVAR.FENTRYID = TGVE.FID ").append(NEW_LINE).append("LEFT JOIN T_BD_ASSISTANTHG TBAH ON TBAH.FID = TGVAR.FASSGRPID ");
        }
        buf.append("WHERE TGVE.FPERIODID = '").append(param.getPeriodId()).append("'").append(NEW_LINE).append("AND TGVE.FCOMPANYID = '").append(param.getCompanyId()).append("'").append(NEW_LINE).append("AND TGVE.FACCOUNTID = '").append(param.getAccountId()).append("'").append(NEW_LINE).append("AND TGVE.FCURRENCYID = '").append(param.getCurrencyId()).append("'").append(NEW_LINE);
        if (hasACussAcct.booleanValue()) {
            buf.append(" AND TBAH.").append(asstActType.getMappingFieldName()).append(" = '").append(param.getCussAcctId()).append("'").append(NEW_LINE);
        }
        buf.append("AND TGVE.FEntryDC = ").append(param.getAmtDirection().getValue()).append(NEW_LINE).append("AND TGV.FBIZSTATUS ");
        if (param.isHasUnRegVoucher()) {
            buf.append(" IN (").append(1).append(",").append(3).append(",").append(5).append(")");
        } else {
            buf.append(" = ").append(5);
        }
        buf.append(" ) TMP ").append(NEW_LINE).append("GROUP BY ").append("FVoucherID").append(", ").append("FVoucherPeriod").append(", ").append("FVoucherNumber");
        DbUtil.execute((Context)ctx, (String)buf.toString());
        return voucherTable;
    }

    private String getJoinSQL(Context ctx, ContrastGLRptDetailQueryParam param, String voucherTable, boolean hasArAp, boolean hasGL) {
        String arapDetailTable;
        StringBuilder buf = new StringBuilder(500).append("SELECT NEWBOSID('88888888') AS FID").append(",").append(NEW_LINE);
        if (hasArAp) {
            buf.append(" TO_CHAR(").append("ARAP.").append("FsceneNumber").append("),").append(NEW_LINE).append(" TO_CHAR(").append("ARAP.").append("FBillID").append("),").append(NEW_LINE).append(" TO_CHAR(").append("ARAP.").append("FBillNumber").append("),").append(NEW_LINE).append(" REPLACE('['|| TBVT.FNAME_").append(ctx.getLocale().getLanguage()).append("||']'||TGV.FNUMBER, '[]', '') AS ").append("FVoucher").append(",").append(NEW_LINE).append("ARAP.").append("FBillDate").append(",").append(NEW_LINE).append("ARAP.").append(AmountDirectionEnum.DR.equals((Object)param.getAmtDirection()) ? "FDRAMOUNT" : "FCRAMOUNT").append(" AS ").append("FBillAmount").append(",").append(NEW_LINE).append("TO_CHAR(").append("ARAP.").append("FVoucherID").append("),").append(NEW_LINE);
        } else {
            buf.append(" TO_CHAR('') AS ").append("FsceneNumber").append(",").append(NEW_LINE).append(" TO_CHAR('') AS ").append("FBillID").append(",").append(NEW_LINE).append(" TO_CHAR('') AS ").append("FBillNumber").append(",").append(NEW_LINE).append(" REPLACE('', '', '') AS ").append("FVoucher").append(",").append(NEW_LINE).append(" NULL AS").append("FBillDate").append(",").append(NEW_LINE).append(" 0 AS ").append("FBillAmount").append(",").append(NEW_LINE).append("TO_CHAR(").append("GL.").append("FVoucherID").append("),").append(NEW_LINE);
        }
        if (hasGL) {
            buf.append("TO_CHAR(").append("GL.").append("FVoucherPeriod").append("),").append(NEW_LINE).append("TO_CHAR(").append("GL.").append("FVoucherNumber").append("),").append(NEW_LINE).append("GL.").append("FVoucherAmount").append(NEW_LINE);
        } else {
            buf.append(" TO_CHAR('') AS ").append("FVoucherPeriod").append(",").append(NEW_LINE).append(" TO_CHAR('') AS ").append("FVoucherNumber").append(",").append(NEW_LINE).append(" 0 AS ").append("FVoucherAmount").append(NEW_LINE);
        }
        String string = arapDetailTable = param.isArRpt() ? "T_AR_ArContrastByBillAccount" : "T_AP_ApContrastByBillAccount";
        if (hasArAp) {
            String joinType = hasGL ? " INNER JOIN " : " LEFT JOIN ";
            buf.append("FROM ").append(arapDetailTable).append(" AS ").append("ARAP").append(NEW_LINE).append(joinType).append(" T_GL_VOUCHER TGV ON ").append("ARAP.").append("FVoucherID").append(" = TGV.FID ").append(NEW_LINE).append(joinType).append(" T_BD_VOUCHERTYPES TBVT ON TBVT.FID = TGV.FVOUCHERTYPEID ").append(NEW_LINE).append(joinType).append(voucherTable).append(" AS ").append("GL").append(NEW_LINE).append(" ON ").append("GL.").append("FVoucherID").append(" = ").append("ARAP.").append("FVoucherID").append(NEW_LINE).append(" WHERE ").append("ARAP.").append("FPERIODID = '").append(param.getPeriodId()).append("'").append(NEW_LINE).append(" AND ").append("ARAP.").append("FCOMPANYID = '").append(param.getCompanyId()).append("'").append(NEW_LINE).append(" AND ").append("ARAP.").append("FACCOUNT = '").append(param.getAccountId()).append("'").append(NEW_LINE).append(" AND ").append("ARAP.").append("FCURRENCYID = '").append(param.getCurrencyId()).append("'").append(NEW_LINE).append(" AND ").append(AmountDirectionEnum.DR.equals((Object)param.getAmtDirection()) ? "FDRAMOUNT" : "FCRAMOUNT").append(" != 0 ").append(NEW_LINE).append(" AND ").append("ARAP.").append("FCREATORID = '").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("'").append(NEW_LINE);
            if (!StringUtils.isEmpty((String)param.getCussAcctId()) && !"null".equalsIgnoreCase(param.getCussAcctId())) {
                buf.append(" AND ").append("ARAP.").append("FASSTACTID = '").append(param.getCussAcctId()).append("'").append(NEW_LINE);
            }
            if (!hasGL) {
                buf.append(" AND ").append("GL.").append("FVoucherID").append(" IS NULL").append(NEW_LINE);
            }
        } else if (hasGL) {
            buf.append("FROM ").append(voucherTable).append(" AS ").append("GL").append(NEW_LINE).append(" LEFT JOIN ").append(arapDetailTable).append(" AS ").append("ARAP").append(NEW_LINE).append(" ON ").append("GL.").append("FVoucherID").append(" = ").append("ARAP.").append("FVoucherID").append(NEW_LINE).append(" AND ").append("ARAP.").append("FPERIODID = '").append(param.getPeriodId()).append("'").append(NEW_LINE).append(" AND ").append("ARAP.").append("FCOMPANYID = '").append(param.getCompanyId()).append("'").append(NEW_LINE).append(" AND ").append("ARAP.").append("FACCOUNT = '").append(param.getAccountId()).append("'").append(NEW_LINE).append(" AND ").append("ARAP.").append("FCURRENCYID = '").append(param.getCurrencyId()).append("'").append(NEW_LINE).append(" AND ").append("ARAP.").append("FCREATORID = '").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("'").append(NEW_LINE);
            if (!StringUtils.isEmpty((String)param.getCussAcctId()) && !"null".equalsIgnoreCase(param.getCussAcctId())) {
                buf.append(" AND ").append("ARAP.").append("FASSTACTID = '").append(param.getCussAcctId()).append("'").append(NEW_LINE);
            }
            buf.append(" WHERE ").append("GL.").append("FVoucherID").append(" NOT IN ( SELECT ").append("FVoucherID").append(" FROM ").append(param.getTempTable()).append(")").append(NEW_LINE);
        }
        return buf.toString();
    }

    private void updateDiffInfo(Context ctx, ContrastGLRptDetailQueryParam param) throws BOSException, EASBizException {
        StringBuilder basicBuf = new StringBuilder(500);
        basicBuf.append(" UPDATE ").append(param.getTempTable()).append(" AS TMP ").append(NEW_LINE).append(" SET (").append("FDiffAmount").append(", ").append("FDiffType").append(" ) ").append(NEW_LINE).append(" = ( SELECT T.FARAPAMT - T.FGLAMT AS ").append("FDiffAmount").append(", ").append(NEW_LINE).append(" CASE WHEN T.FARAPAMT = 0 AND ABS(T.FGLAMT) > 0 THEN ").append("4").append(NEW_LINE).append(" WHEN ABS(T.FARAPAMT) > 0 AND T.FGLAMT = 0 THEN ").append("3").append(NEW_LINE).append(" WHEN ABS(T.FARAPAMT) > 0 AND ABS(T.FGLAMT) > 0 AND T.FARAPAMT != T.FGLAMT THEN ").append("2").append(NEW_LINE).append(" ELSE ").append("1").append(" END AS ").append("FDiffType").append(NEW_LINE).append(" %s").append(NEW_LINE).append(" ) ");
        StringBuilder buf = new StringBuilder(300).append(" FROM ( SELECT T1.").append("FVoucherID").append("             , SUM(T1.").append("FBillAmount").append(") AS FARAPAMT ").append("             , AVG(T1.").append("FVoucherAmount").append(") AS FGLAMT").append(NEW_LINE).append("         FROM ").append(param.getTempTable()).append(" AS T1 ").append(NEW_LINE).append("        WHERE T1.").append("FVoucherID").append(" != 'z'").append(NEW_LINE).append("        GROUP BY T1.").append("FVoucherID").append(NEW_LINE).append("      ) T").append(NEW_LINE).append(" WHERE T.").append("FVoucherID").append("  = ").append(" TMP.").append("FVoucherID");
        DbUtil.execute((Context)ctx, (String)String.format(basicBuf.toString(), buf.toString()));
        this.updateBillBosTypeForNoVoucher(ctx, param.getTempTable());
        buf.setLength(0);
        buf.append(" FROM ( SELECT T1.").append("FID").append(",T2.FARAPAMT AS FARAPAMT").append(", 0 AS FGLAMT").append(NEW_LINE).append("         FROM ").append(param.getTempTable()).append(" AS T1 ").append(NEW_LINE).append("             INNER JOIN (SELECT ").append("FBillBostype").append(" , SUM(").append("FBillAmount").append(" ) AS FARAPAMT ").append(NEW_LINE).append("                  FROM ").append(param.getTempTable()).append(NEW_LINE).append("                  WHERE ").append("FVoucherID").append(" = 'z'").append(" GROUP BY ").append("FBillBostype").append(" ) AS T2 ").append(NEW_LINE).append("         ON T1.").append("FBillBostype").append(" = ").append(" T2.").append("FBillBostype").append(NEW_LINE).append("        WHERE T1.").append("FVoucherID").append(" = 'z'").append(NEW_LINE).append("      ) T").append(NEW_LINE).append(" WHERE T.").append("FID").append("  = ").append(" TMP.").append("FID");
        DbUtil.execute((Context)ctx, (String)String.format(basicBuf.toString(), buf.toString()));
        basicBuf.setLength(0);
        basicBuf.append(" UPDATE ").append(param.getTempTable()).append(" AS TMP ").append(NEW_LINE).append(" SET ").append("FDiffType").append(" = ").append("5").append(NEW_LINE).append(" WHERE ").append("FDiffType").append(" = ").append("4").append(NEW_LINE).append(" AND EXISTS (SELECT 1 FROM T_BOT_RELATION AS TBR WHERE TBR.FDESTOBJECTID = TMP.").append("FVoucherID").append(")");
        DbUtil.execute((Context)ctx, (String)basicBuf.toString());
        basicBuf.setLength(0);
        basicBuf.append(" UPDATE ").append(param.getTempTable()).append(" AS TMP ").append(NEW_LINE).append(" SET ").append("FDiffType").append(" = ").append("5").append(NEW_LINE).append(" WHERE ").append("FDiffType").append(" = ").append("3").append(NEW_LINE).append(" AND TMP.").append("FVoucherID").append(" != 'z'").append(" AND TMP.").append("FVoucherID").append(" IS NOT NULL");
        DbUtil.execute((Context)ctx, (String)basicBuf.toString());
    }

    private void updateBillBosTypeForNoVoucher(Context ctx, String tempTable) throws BOSException {
        StringBuilder buf = new StringBuilder(100);
        buf.append(" SELECT T1.").append("FBillID").append(" FROM ").append(tempTable).append(" AS T1 ").append(NEW_LINE).append(" WHERE T1.").append("FVoucherID").append(" = 'z'").append(NEW_LINE);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        try {
            while (rs.next()) {
                String id = rs.getString(1);
                if (!BOSUuid.isValid((String)id, (boolean)true)) continue;
                String bosType = BOSUuid.read((String)id).getType().toString();
                Object[] params = new Object[]{bosType, id};
                paramsList.add(params);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        buf.setLength(0);
        buf.append(" UPDATE ").append(tempTable).append(" SET ").append("FBillBostype").append(" = ? ").append(" WHERE ").append("FBillID").append(" = ?");
        DbUtil.executeBatch((Context)ctx, (String)buf.toString(), paramsList);
    }

    private void sumByVoucher(Context ctx, ContrastGLRptDetailQueryParam param) throws BOSException, EASBizException {
        StringBuilder buf = new StringBuilder(500).append("INSERT INTO ").append(param.getTempTable()).append("(").append(NEW_LINE).append("FID").append(",").append(NEW_LINE).append("FBillAmount").append(",").append(NEW_LINE).append("FVoucherAmount").append(",").append(NEW_LINE).append("FDiffAmount").append(",").append(NEW_LINE).append("FIsSum").append(NEW_LINE).append(")").append(NEW_LINE).append(" SELECT NEWBOSID('88888888') AS FID").append(",").append(NEW_LINE).append(" SUM(T.ARAPAMT)").append(",").append(NEW_LINE).append(" SUM(T.GLAMT)").append(",").append(NEW_LINE).append("SUM(T.DIFFAMT)").append(",").append(NEW_LINE).append("FIsSum").append(NEW_LINE).append(" FROM (").append(NEW_LINE).append(" SELECT SUM(").append("FBillAmount").append(") AS ARAPAMT,").append(NEW_LINE).append("        AVG(").append("FVoucherAmount").append(") AS GLAMT,").append(NEW_LINE).append("        AVG(").append("FDiffAmount").append(") AS DIFFAMT,").append(NEW_LINE).append("        1 AS ").append("FIsSum").append(NEW_LINE).append("   FROM ").append(param.getTempTable()).append(NEW_LINE).append("   WHERE ").append("FVoucherID").append(" != 'z'").append(NEW_LINE).append("  GROUP BY ").append("FVoucherID").append(NEW_LINE).append("  UNION ALL ").append(NEW_LINE).append(" SELECT SUM( ").append("FBillAmount").append(") AS ARAPAMT,").append(NEW_LINE).append("         SUM( ").append("FVoucherAmount").append(") AS GLAMT,").append(NEW_LINE).append("         SUM( ").append("FBillAmount").append(") AS DIFFAMT,").append(NEW_LINE).append("        1 AS ").append("FIsSum").append(NEW_LINE).append("  FROM ").append(param.getTempTable()).append(NEW_LINE).append("  WHERE ").append("FVoucherID").append(" = 'z'").append(NEW_LINE).append(") AS T ").append(NEW_LINE).append(" GROUP BY T.").append("FIsSum");
        DbUtil.execute((Context)ctx, (String)buf.toString());
    }

    private void prepareContrastGLRptDetail(Context ctx, ContrastGLRptDetailQueryParam param, TempTablePool pool) throws BOSException, EASBizException {
        String voucherTable = this.prepareVoucherData(ctx, param, pool);
        ArrayList<String> otherTempTables = new ArrayList<String>(2);
        otherTempTables.add(voucherTable);
        param.setOtherTempTables(otherTempTables);
        StringBuilder buf_basic = new StringBuilder(300).append("INSERT INTO ").append(param.getTempTable()).append("(").append(NEW_LINE).append("FID").append(",").append(NEW_LINE).append("FsceneNumber").append(",").append(NEW_LINE).append("FBillID").append(",").append(NEW_LINE).append("FBillNumber").append(",").append(NEW_LINE).append("FVoucher").append(",").append(NEW_LINE).append("FBillDate").append(",").append(NEW_LINE).append("FBillAmount").append(",").append(NEW_LINE).append("FVoucherID").append(",").append(NEW_LINE).append("FVoucherPeriod").append(",").append(NEW_LINE).append("FVoucherNumber").append(",").append(NEW_LINE).append("FVoucherAmount").append(NEW_LINE).append(")").append(NEW_LINE);
        StringBuilder buf = new StringBuilder(1500).append((CharSequence)buf_basic).append(this.getJoinSQL(ctx, param, voucherTable, true, true)).append(" UNION ALL ").append(NEW_LINE).append(this.getJoinSQL(ctx, param, voucherTable, true, false));
        DbUtil.execute((Context)ctx, (String)buf.toString());
        buf.setLength(0);
        buf.append((CharSequence)buf_basic).append(this.getJoinSQL(ctx, param, voucherTable, false, true));
        DbUtil.execute((Context)ctx, (String)buf.toString());
        buf = null;
        this.updateDiffInfo(ctx, param);
        this.sumByVoucher(ctx, param);
    }

    protected String getSortItems(ContrastGLRptDetailQueryParam param) {
        StringBuilder buf = new StringBuilder(100);
        buf.append("FVoucherID").append(", ").append("FIsSum");
        if (!StringUtils.isEmpty((String)param.getSortItems()) && param.getSortItems().indexOf("FBillType") < 0) {
            buf.append(", ").append(param.getSortItems());
        }
        if (buf.indexOf("FBillNumber") < 0) {
            buf.append(", ").append("FBillNumber");
        }
        return buf.toString();
    }

    protected String getBillTypeFromBillIdExt(String billId) {
        return "";
    }

    private String getBillTypeFromBillId(String billId) {
        String billType = "";
        String bosType = "";
        BosTypeEnum bosTypeEnum = null;
        try {
            bosType = BOSUuid.read((String)billId).getType().toString();
            bosTypeEnum = BosTypeEnum.getEnum(bosType);
        }
        catch (Exception ex) {
            logger.error((Object)(" get bostype for billId [" + billId + "] error."));
        }
        if (null == bosTypeEnum) {
            billType = this.getBillTypeFromBillIdExt(billId);
            if (StringUtils.isEmpty((String)billType) && !StringUtils.isEmpty((String)bosType)) {
                billType = bosType;
            }
        } else {
            billType = bosTypeEnum.getAlias();
        }
        return billType;
    }

    protected IReportData getContrastGLRptDetailData(Context ctx, ContrastGLRptDetailQueryParam param) throws BOSException, EASBizException {
        StringBuilder buf = new StringBuilder(200).append("SELECT ").append("FID").append(",").append(NEW_LINE).append("FsceneNumber").append(",").append(NEW_LINE).append("FBillID").append(",").append(NEW_LINE).append("FBillNumber").append(",").append(NEW_LINE).append("FVoucher").append(",").append(NEW_LINE).append("FBillDate").append(",").append(NEW_LINE).append("FBillAmount").append(",").append(NEW_LINE).append("FVoucherID").append(",").append(NEW_LINE).append("FVoucherPeriod").append(",").append(NEW_LINE).append("FVoucherNumber").append(",").append(NEW_LINE).append("FVoucherAmount").append(", ").append(NEW_LINE).append("FDiffAmount").append(", ").append(NEW_LINE).append("FDiffType").append(", ").append(NEW_LINE).append("FIsSum").append(NEW_LINE).append(" FROM ").append(param.getTempTable()).append(NEW_LINE);
        if (ContrastGLDiffTypeEnum.ALL != param.getDiffType()) {
            buf.append(" WHERE ").append("FDiffType").append(" = ").append(param.getDiffType().getValue()).append(NEW_LINE);
        }
        buf.append(" ORDER BY ").append(this.getSortItems(param));
        int start = param.getStartIndex() - 1;
        int rows = param.getEndIndex() - start;
        IRowSet rs = null;
        ArApReportData rptData = null;
        int totalRowCount = param.getTotalRowCount();
        try {
            if (totalRowCount == 0 && (rs = DBUtil.executeQuery((Context)ctx, (String)("SELECT COUNT(FID) " + buf.substring(buf.indexOf("FROM"), buf.indexOf("ORDER"))))).next()) {
                totalRowCount = rs.getInt(1);
            }
            rs = rows > 0 ? DbUtil.executeQuery((Context)ctx, (String)buf.toString(), (int)start, (int)rows) : DbUtil.executeQuery((Context)ctx, (String)buf.toString());
            ArrayList<ReportInfo> dataLst = new ArrayList<ReportInfo>(rows > 0 ? rows : 60);
            ReportInfo rptInfo = null;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
            java.sql.Date billDate = null;
            String billDateStr = null;
            String diffTypeDesc = "";
            ContrastGLDiffTypeEnum diffTypeEnum = null;
            int isSumLine = 0;
            while (rs.next()) {
                rptInfo = new ReportInfo();
                rptInfo.put("FID", rs.getString("FID"));
                String billId = rs.getString("FBillID");
                rptInfo.put("FBillType", this.getBillTypeFromBillId(billId));
                rptInfo.put("FsceneNumber", rs.getString("FsceneNumber"));
                rptInfo.put("FBillID", billId);
                rptInfo.put("FBillNumber", rs.getString("FBillNumber"));
                rptInfo.put("FVoucher", rs.getString("FVoucher"));
                billDate = rs.getDate("FBillDate");
                billDateStr = null != billDate ? sdf.format(billDate) : null;
                rptInfo.put("FBillDate", billDateStr);
                rptInfo.put("FBillAmount", rs.getBigDecimal("FBillAmount"));
                rptInfo.put("FVoucherID", rs.getString("FVoucherID"));
                rptInfo.put("FVoucherPeriod", rs.getString("FVoucherPeriod"));
                rptInfo.put("FVoucherNumber", rs.getString("FVoucherNumber"));
                rptInfo.put("FVoucherAmount", rs.getBigDecimal("FVoucherAmount"));
                rptInfo.put("FDiffAmount", rs.getBigDecimal("FDiffAmount"));
                diffTypeDesc = rs.getString("FDiffType");
                if (param.isGUI()) {
                    diffTypeEnum = ContrastGLDiffTypeEnum.getEnum(diffTypeDesc);
                    diffTypeDesc = null == diffTypeEnum ? "" : diffTypeEnum.getAlias();
                }
                rptInfo.put("FDiffType", diffTypeDesc);
                isSumLine = rs.getInt("FIsSum");
                rptInfo.put("FIsSum", isSumLine);
                if (isSumLine == 1) {
                    rptInfo.setIsTotalLine(true);
                }
                dataLst.add(rptInfo);
            }
            rptData = new ArApReportData(dataLst, totalRowCount);
            rptData.setTempTable(param.getTempTable());
            rptData.setOtherTempTables(param.getOtherTempTables());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return rptData;
    }

    @Override
    protected IReportData _contrastGLRptDetailQuery(Context ctx, ContrastGLRptDetailQueryParam param) throws BOSException, EASBizException {
        if (param == null) {
            throw new BOSException("param is null");
        }
        String tempTable = param.getTempTable();
        if (StringUtils.isEmpty((String)tempTable)) {
            this.checkContrastDetailParam(ctx, param);
            if (StringUtils.isEmpty((String)param.getPeriodId())) {
                ObjectUuidPK companyPK = new ObjectUuidPK(param.getCompanyId());
                PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)param.getPeriodYear(), (int)param.getPeriodNum(), (IObjectPK)companyPK);
                param.setPeriodId(periodInfo.getId().toString());
            }
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            tempTable = this.createDetailTempTable(ctx, param, pool);
            try {
                pool.createIndex(tempTable, "FID", true, false);
                pool.createIndex(tempTable, "FVoucherID", false, false);
                pool.createIndex(tempTable, "FDiffType", false, false);
            }
            catch (Exception e) {
                throw new BOSException("create index for table [" + tempTable + "] error.");
            }
            param.setTempTable(tempTable);
            this.prepareContrastGLRptDetail(ctx, param, pool);
        }
        return this.getContrastGLRptDetailData(ctx, param);
    }

    @Override
    protected ContrastGLQueryParam _convertContrastAccount(Context ctx, ContrastGLQueryParam param, boolean isAr) throws BOSException, EASBizException {
        String companyId = param.getCompanyId();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)));
        int system = isAr ? 1 : 2;
        int periodYear = param.getPeriodYear();
        int periodNum = param.getPeriodNum();
        String acctTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)companyId, (String)company.getAccountTable().getId().toString(), (int)periodYear, (int)periodNum);
        AccountViewCollection accountViewColl = (AccountViewCollection)ContrastAccountViewFactory.getLocalInstance((Context)ctx).getContrastAccount(system, company, acctTableId, periodYear, periodNum, true);
        HashMap<String, AccountViewInfo> idAccountViewMap = new HashMap<String, AccountViewInfo>(accountViewColl.size());
        HashMap<String, AccountViewInfo> numberAccountViewMap = new HashMap<String, AccountViewInfo>(accountViewColl.size());
        for (int i = 0; i < accountViewColl.size(); ++i) {
            AccountViewInfo accountViewInfo = accountViewColl.get(i);
            idAccountViewMap.put(accountViewInfo.getId().toString(), accountViewInfo);
            numberAccountViewMap.put(accountViewInfo.getNumber(), accountViewInfo);
        }
        String operateFlag = "+-";
        List accountList = param.getAcctFormula();
        List accountNameList = param.getAcctNameFormula();
        for (int i = 0; i < accountList.size(); ++i) {
            String accountNumber;
            String accountId = accountList.get(i).toString();
            if (operateFlag.contains(accountId.toString()) || idAccountViewMap.containsKey(accountId) || !numberAccountViewMap.containsKey(accountNumber = accountNameList.get(i).toString().split(";")[1])) continue;
            AccountViewInfo accountViewInfo = (AccountViewInfo)numberAccountViewMap.get(accountNumber);
            accountList.set(i, accountViewInfo.getId().toString());
            String nameStr = accountViewInfo.getName() + ";" + accountViewInfo.getNumber();
            if (accountViewInfo.getCAA() != null) {
                nameStr = nameStr + ";" + accountViewInfo.getCAA().getString("id");
            }
            accountNameList.set(i, nameStr);
        }
        return param;
    }

    @Override
    protected boolean _toNextPeriod1(Context ctx, Map billInfo, boolean isAR, CompanyOrgUnitInfo company, PeriodInfo clientCurrentPeriod) throws BOSException, EASBizException {
        PeriodInfo currentPeriod = isAR ? ArServerUtils.getArCurrentPeriod(ctx, company) : ApServerUtils.getApCurrentPeriod(ctx, company);
        if (currentPeriod == null) {
            return false;
        }
        if (clientCurrentPeriod != null && !currentPeriod.getId().equals((Object)clientCurrentPeriod.getId())) {
            throw new ContrastGLException(ContrastGLException.SERVER_PERIOD_CHANGED_RETRY);
        }
        return this.toNextPeriod(ctx, billInfo, isAR, company);
    }

    public static class checkJob
    implements Callable<IReportData> {
        private Context ctx;
        private boolean isAr;
        private String companyId;
        private ContrastGLFacadeControllerBean contrastGL;
        private ContrastGLCheckParam checkParam;

        public checkJob(Context ctx, boolean isAr, String companyId, ContrastGLFacadeControllerBean contrastGL, ContrastGLCheckParam checkParam) {
            this.ctx = ctx;
            this.isAr = isAr;
            this.companyId = companyId;
            this.contrastGL = contrastGL;
            this.checkParam = checkParam;
        }

        @Override
        public IReportData call() throws Exception {
            IReportData rptData = this.contrastGL.checkArApGLWithLogging(this.ctx, this.checkParam, this.isAr);
            HashMap<String, String> extMap = new HashMap<String, String>(1);
            extMap.put("companyId", this.companyId);
            rptData.setAssistData(extMap);
            return rptData;
        }
    }
}

