/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.ap.app.util.ApServerUtils;
import com.kingdee.eas.fi.ar.ARAPEnum;
import com.kingdee.eas.fi.ar.ContrastGroupInnerFacadeFactory;
import com.kingdee.eas.fi.ar.ItemRptQueryParam;
import com.kingdee.eas.fi.ar.app.AbstractContrastGroupInnerFacadeControllerBean;
import com.kingdee.eas.fi.ar.app.util.ArServerUtils;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.framework.balance.BalanceModelFactory;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.app.engine.ArApBalanceCalculator;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceCalculatorFactory;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceEnginUtil;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ContrastGroupInnerFacadeControllerBean
extends AbstractContrastGroupInnerFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static final BigDecimal ZERO = new BigDecimal("0.0");
    private static final String ArRpt_RESOURCE = "com.kingdee.eas.fi.ar.ArReport";
    private String rt = " \r\n";
    private boolean isSingle = false;
    private transient CompanyOrgUnitInfo selectedMComps = null;
    private transient Object[] selectedSComps = null;
    private CompanyOrgUnitInfo mCompany = null;
    private CompanyOrgUnitInfo sCompany = null;
    private ARAPEnum mContrastDirection = null;
    private ARAPEnum sContrastDirection = null;
    private PeriodInfo mPeriod = null;
    private PeriodInfo sPeriod = null;
    private AsstActTypeInfo mAsstActType = null;
    private AsstActTypeInfo sAsstActType = null;
    private List mAsstActList = null;
    private List sAsstActList = null;
    private CurrencyInfo mCurrency = null;
    private CurrencyInfo sCurrency = null;
    private ItemRptQueryParam mItemRptParam = new ItemRptQueryParam();
    private ItemRptQueryParam sItemRptParam = new ItemRptQueryParam();
    private static final String ARSYSTEM = "AR";
    private Map currentPeriodMap = new HashMap();
    private Map startPeriodMap = new HashMap();
    private boolean isIncludeBizBill = false;
    private boolean isBalanceZeroNotShow = false;
    private boolean isAmtZeroNotShow = false;

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        RptParams pp = new RptParams();
        pp.setString("title", params.getString("init_title") + "BBB");
        return pp;
    }

    private CompanyOrgUnitInfo getCompany(RptParams params, String column) {
        return (CompanyOrgUnitInfo)params.getObject(column);
    }

    private void doParam(Context ctx, boolean isSingle, RptParams params) throws BOSException, EASBizException {
        Object sCurrencyObj;
        if (isSingle) {
            if (this.getCompany(params, "mCompany") != null) {
                this.mCompany = this.getCompany(params, "mCompany");
            }
            if (this.getCompany(params, "sCompany") != null) {
                this.sCompany = this.getCompany(params, "sCompany");
            }
        } else {
            this.selectedMComps = (CompanyOrgUnitInfo)params.getObject("selectedMComps");
            this.selectedSComps = (Object[])params.getObject("selectedSComps");
            if (this.selectedMComps != null) {
                this.mCompany = this.selectedMComps;
            }
            if (this.selectedSComps != null && this.selectedSComps.length > 0) {
                this.sCompany = this.getCompany(ctx, this.selectedSComps[0]);
            }
        }
        this.mContrastDirection = (ARAPEnum)((Object)params.getObject("mContrastDirection"));
        this.sContrastDirection = (ARAPEnum)((Object)params.getObject("sContrastDirection"));
        this.isIncludeBizBill = (Boolean)params.getObject("isIncludeBizBill");
        this.isAmtZeroNotShow = (Boolean)params.getObject("isAmtZeroNotShow");
        this.isBalanceZeroNotShow = (Boolean)params.getObject("isBalanceZeroNotShow");
        int mYear = 0;
        int sYear = 0;
        int mPeriodNumber = 0;
        int sPeriodNumber = 0;
        mYear = (Integer)params.getObject("mYear");
        sYear = (Integer)params.getObject("sYear");
        mPeriodNumber = (Integer)params.getObject("mPeriodNumber");
        sPeriodNumber = (Integer)params.getObject("sPeriodNumber");
        this.mPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (int)mYear, (int)mPeriodNumber, (CompanyOrgUnitInfo)this.mCompany);
        this.mItemRptParam.setBeginDate(this.mPeriod.getBeginDate());
        this.mItemRptParam.setEndDate((java.util.Date)this.mPeriod.getEndDate());
        this.sPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (int)sYear, (int)sPeriodNumber, (CompanyOrgUnitInfo)this.sCompany);
        this.sItemRptParam.setBeginDate(this.sPeriod.getBeginDate());
        this.sItemRptParam.setEndDate((java.util.Date)this.sPeriod.getEndDate());
        String hgattribute = "";
        if (isSingle) {
            Object mAsstActTypeObj = params.getObject("mAsstActTypeInfo");
            if (mAsstActTypeObj != null) {
                this.mAsstActType = (AsstActTypeInfo)mAsstActTypeObj;
            }
        } else {
            hgattribute = this.mContrastDirection.getValue() == ARSYSTEM ? "customer" : "provider";
            this.mAsstActType = BaseDataUtil.getAsstActType(ctx, this.mCompany.getId().toString(), hgattribute);
        }
        this.mItemRptParam.setCussAcctTypeInfo(this.mAsstActType);
        this.mItemRptParam.setCussTable(this.mAsstActType.getRealtionDataObject());
        this.mItemRptParam.setCussTypeId(this.mAsstActType.getId().toString());
        if (isSingle) {
            Object sAsstActTypeObj = params.getObject("sAsstActTypeInfo");
            if (sAsstActTypeObj != null) {
                this.sAsstActType = (AsstActTypeInfo)sAsstActTypeObj;
            }
        } else {
            hgattribute = this.sContrastDirection.getValue() == ARSYSTEM ? "customer" : "provider";
            this.sAsstActType = BaseDataUtil.getAsstActType(ctx, this.sCompany.getId().toString(), hgattribute);
        }
        this.sItemRptParam.setCussAcctTypeInfo(this.sAsstActType);
        this.sItemRptParam.setCussTable(this.sAsstActType.getRealtionDataObject());
        this.sItemRptParam.setCussTypeId(this.sAsstActType.getId().toString());
        if (isSingle) {
            Object asstActSObj;
            Object asstActMObj = params.getObject("asstActMList");
            if (asstActMObj != null) {
                this.mAsstActList = (List)asstActMObj;
                this.mItemRptParam.setCussAcctFromIds(this.mAsstActList);
            }
            if ((asstActSObj = params.getObject("asstActSList")) != null) {
                this.sAsstActList = (List)asstActSObj;
                this.sItemRptParam.setCussAcctFromIds(this.sAsstActList);
            }
        } else {
            String mCompanyID = this.mCompany.getId().toString();
            boolean isMReceive = this.mContrastDirection.getValue() == ARSYSTEM;
            this.sAsstActList = new ArrayList();
            this.mAsstActList = new ArrayList();
            for (Object obj : this.selectedSComps) {
                CoreBaseInfo orgInfo;
                String sCompanyID;
                if (!(obj instanceof CoreBaseInfo) || mCompanyID.equalsIgnoreCase(sCompanyID = (orgInfo = (CoreBaseInfo)obj).getId().toString())) continue;
                if (isMReceive) {
                    if (this.isInnerCustomer(ctx, mCompanyID, sCompanyID)) {
                        this.mAsstActList.add(this.getInnerCustomerID(ctx, sCompanyID));
                    }
                    if (!this.isInnerSupplier(ctx, sCompanyID, mCompanyID)) continue;
                    this.sAsstActList.add(this.getInnerSupplierID(ctx, mCompanyID));
                    continue;
                }
                if (this.isInnerSupplier(ctx, mCompanyID, sCompanyID)) {
                    this.mAsstActList.add(this.getInnerSupplierID(ctx, sCompanyID));
                }
                if (!this.isInnerCustomer(ctx, sCompanyID, mCompanyID)) continue;
                this.sAsstActList.add(this.getInnerCustomerID(ctx, mCompanyID));
            }
            this.mItemRptParam.setCussAcctFromIds(this.mAsstActList);
            this.sItemRptParam.setCussAcctFromIds(this.sAsstActList);
        }
        Object mCurrencyObj = params.getObject("mCurrency");
        if (mCurrencyObj != null) {
            this.mCurrency = (CurrencyInfo)mCurrencyObj;
            this.mItemRptParam.setCurrencyId(this.mCurrency.getId().toString());
            this.mItemRptParam.setCurrencyInfo(this.getCurrency(ctx, this.mCurrency.getId().toString()));
        }
        if ((sCurrencyObj = params.getObject("sCurrency")) != null) {
            this.sCurrency = (CurrencyInfo)sCurrencyObj;
            this.sItemRptParam.setCurrencyId(this.sCurrency.getId().toString());
            this.sItemRptParam.setCurrencyInfo(this.getCurrency(ctx, this.sCurrency.getId().toString()));
        }
        this.mItemRptParam.setByPeriod(true);
        this.mItemRptParam.setIsBizZero(false);
        this.mItemRptParam.setIsBalZero(false);
        this.mItemRptParam.setIsArRpt(this.mContrastDirection.getValue() == ARSYSTEM);
        this.mItemRptParam.setLinkSum(true);
        this.mItemRptParam.setStartPeriodYear(mYear);
        this.mItemRptParam.setStartPeriodNum(mPeriodNumber);
        this.mItemRptParam.setEndPeriodYear(mYear);
        this.mItemRptParam.setEndPeriodNum(mPeriodNumber);
        this.sItemRptParam.setByPeriod(true);
        this.sItemRptParam.setIsBizZero(false);
        this.sItemRptParam.setIsBalZero(false);
        this.sItemRptParam.setIsArRpt(this.sContrastDirection.getValue() == ARSYSTEM);
        this.sItemRptParam.setLinkSum(true);
        this.sItemRptParam.setStartPeriodYear(sYear);
        this.sItemRptParam.setStartPeriodNum(sPeriodNumber);
        this.sItemRptParam.setEndPeriodYear(sYear);
        this.sItemRptParam.setEndPeriodNum(sPeriodNumber);
    }

    private void calculate(Context ctx, String balanceTempTable, String tempTable) throws BOSException, EASBizException {
        if ((this.mAsstActList.size() > 0 || this.mAsstActList.size() > 0) && (this.selectedMComps != null && this.selectedSComps != null || this.mCompany != null && this.sCompany != null)) {
            this.computeBalance(ctx, this.isSingle, balanceTempTable, this.selectedMComps, this.selectedSComps, this.mCompany, this.sCompany, this.mContrastDirection, this.sContrastDirection, this.mPeriod, this.sPeriod, this.mAsstActType, this.sAsstActType, this.mAsstActList, this.sAsstActList, this.mCurrency, this.sCurrency);
        }
        if (this.isSingle) {
            this.caculateSContrastData(ctx, tempTable, balanceTempTable, this.mCurrency, this.mContrastDirection, this.sContrastDirection, this.mCompany, this.sCompany, this.mPeriod, this.sPeriod);
        } else {
            int slength = this.selectedSComps.length;
            for (int j = 0; j < slength; ++j) {
                CompanyOrgUnitInfo sCompany1 = this.getCompany(ctx, this.selectedSComps[j]);
                if (this.selectedMComps.getId().toString().equals(sCompany1.getId().toString())) continue;
                this.caculateContrastData(ctx, tempTable, balanceTempTable, this.mCurrency, this.mContrastDirection, this.sContrastDirection, this.selectedMComps, sCompany1, this.mPeriod, this.sPeriod);
            }
            this.caculateMContrastData(ctx, tempTable, balanceTempTable, this.mCurrency, this.mContrastDirection, this.selectedMComps, this.mPeriod);
            this.deleteContrastData(ctx, tempTable, balanceTempTable);
        }
    }

    protected void deleteContrastData(Context ctx, String tempTable, String balanceTempTable) throws BOSException {
        StringBuffer deleteSql = new StringBuffer(50);
        if (this.isAmtZeroNotShow) {
            deleteSql.append("delete from " + tempTable + " where mdebit = 0 and sdebit = 0 and mcredit = 0 and scredit = 0");
            DbUtil.execute((Context)ctx, (String)deleteSql.toString());
            deleteSql.setLength(0);
        }
        if (this.isBalanceZeroNotShow) {
            deleteSql.append("delete from " + tempTable + " where mendbalance = 0 and sendbalance = 0");
            DbUtil.execute((Context)ctx, (String)deleteSql.toString());
            deleteSql.setLength(0);
        }
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable"), ctx);
        String tempTable = this.getTempTableName("contrastGroupInner_report", ctx);
        this.isSingle = (Boolean)params.getObject("isSingle");
        String logMsg = null;
        logMsg = this.isSingle ? this.getResource("contrastgroup_single", ctx) : this.getResource("contrastgroup", ctx);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)logMsg, (BOSObjectType)ContrastGroupInnerFacadeFactory.getLocalInstance(ctx).getType(), null, (String)logMsg);
        this.doParam(ctx, this.isSingle, params);
        this.createTable(ctx, tempTable);
        String balanceTempTable = this.getTempTable(ctx);
        this.calculate(ctx, balanceTempTable, tempTable);
        RptTableHeader header = new RptTableHeader();
        this.setHeader(ctx, header);
        String countSql = "select count(1) cc from " + tempTable;
        RptRowSet countRS = this.executeQuery(countSql, null, ctx);
        int count = 0;
        if (countRS.next()) {
            count = countRS.getInt(0);
        }
        params.setString("tempTable", tempTable);
        params.setObject("header", (Object)header);
        params.setObject("currency", (Object)this.getCurrency(ctx, this.mCurrency.getId().toString()));
        params.setObject("sItemRptParam", (Object)this.sItemRptParam);
        params.setObject("mItemRptParam", (Object)this.mItemRptParam);
        params.setObject("mContrastDirection", (Object)this.mContrastDirection);
        params.setObject("sContrastDirection", (Object)this.sContrastDirection);
        params.setInt("rowCount", count);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return params;
    }

    private void setHeader(Context ctx, RptTableHeader header) {
        this.addColumn(header, "currency", 50, 0);
        this.addColumn(header, "mcompanyid", 0, 0);
        this.addColumn(header, "mcompany", 100, 0);
        this.addColumn(header, "scompanyid", 0, 0);
        this.addColumn(header, "scompany", 100, 0);
        this.addColumn(header, "mdirection", 60, 0);
        this.addColumn(header, "sdirection", 60, 0);
        this.addColumn(header, "mperiod", 60, 0);
        this.addColumn(header, "speriod", 60, 0);
        this.addColumn(header, "mbeginbalance", 70, 2);
        this.addColumn(header, "sbeginbalance", 70, 2);
        this.addColumn(header, "beginbalance", 70, 2);
        this.addColumn(header, "mdebit", 70, 2);
        this.addColumn(header, "sdebit", 70, 2);
        this.addColumn(header, "debitbalance", 70, 2);
        this.addColumn(header, "mcredit", 70, 2);
        this.addColumn(header, "scredit", 70, 2);
        this.addColumn(header, "creditbalance", 70, 2);
        this.addColumn(header, "mendbalance", 70, 2);
        this.addColumn(header, "sendbalance", 70, 2);
        this.addColumn(header, "endbalance", 70, 2);
        Locale local = ctx.getLocale();
        String currency = this.getHeaderResource("currency", local);
        String contrastCompany = this.getHeaderResource("contrastCompany", local);
        String contrastDirection = this.getHeaderResource("contrastDirection", local);
        String contrastPeriod = this.getHeaderResource("contrastPeriod", local);
        String beginBalance = this.getHeaderResource("beginBalance", local);
        String debit = this.getHeaderResource("debit", local);
        String credit = this.getHeaderResource("credit", local);
        String endBalance = this.getHeaderResource("endBalance", local);
        String mainContrast = this.getHeaderResource("mainContrast", local);
        String secondContrast = this.getHeaderResource("secondContrast", local);
        String balance = this.getHeaderResource("balance", local);
        header.setLabels((Object[][])new String[][]{{currency, contrastCompany, contrastCompany, contrastCompany, contrastCompany, contrastDirection, contrastDirection, contrastPeriod, contrastPeriod, beginBalance, beginBalance, beginBalance, debit, debit, debit, credit, credit, credit, endBalance, endBalance, endBalance}, {currency, "mcompanyid", mainContrast, "scompanyid", secondContrast, mainContrast, secondContrast, mainContrast, secondContrast, mainContrast, secondContrast, balance, mainContrast, secondContrast, balance, mainContrast, secondContrast, balance, mainContrast, secondContrast, balance}}, true);
    }

    private String getHeaderResource(String column, Locale local) {
        return ResourceBase.getString((String)ArRpt_RESOURCE, (String)column, (Locale)local);
    }

    private String getResource(String column, Context ctx) {
        Locale local = ctx.getLocale();
        return ResourceBase.getString((String)ArRpt_RESOURCE, (String)column, (Locale)local);
    }

    private void addColumn(RptTableHeader header, String column, int width, int align) {
        RptTableColumn col = new RptTableColumn(column);
        col.setWidth(width);
        if (width == 0) {
            col.setHided(true);
        }
        col.setAligment(align);
        header.addColumn(col);
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        StringBuffer sql = new StringBuffer("");
        sql.append(" select * from ").append(tempTable).append(this.rt);
        RptRowSet rs = this.executeQuery(sql.toString(), null, from, len, ctx);
        params.setObject("rowset", (Object)rs);
        return params;
    }

    private void caculateSContrastData(Context ctx, String tempTable, String balanceTempTable, CurrencyInfo currency, ARAPEnum mContrastDirection1, ARAPEnum sContrastDirection1, CompanyOrgUnitInfo mCompany1, CompanyOrgUnitInfo sCompany1, PeriodInfo mPeriod1, PeriodInfo sPeriod1) throws BOSException, EASBizException {
        BigDecimal mBeginBalance = new BigDecimal("0.0");
        BigDecimal mDebit = new BigDecimal("0.0");
        BigDecimal mCredit = new BigDecimal("0.0");
        BigDecimal mEndBalance = new BigDecimal("0.0");
        BigDecimal sBeginBalance = new BigDecimal("0.0");
        BigDecimal sDebit = new BigDecimal("0.0");
        BigDecimal sCredit = new BigDecimal("0.0");
        BigDecimal sEndBalance = new BigDecimal("0.0");
        StringBuffer mbuffer = new StringBuffer("");
        mbuffer.append("select sum(fbeginbalancefor) as fbeginbalancefor,sum(fdebitfor) as fdebitfor,sum(fcreditfor) as fcreditfor,sum(fendbalancefor) as fendbalancefor,FAsstActID from ").append(balanceTempTable).append(" where fcompanyid ='").append(mCompany1.getId().toString()).append("'");
        mbuffer.append(" and fcurrencyid='").append(currency.getId().toString()).append("'");
        if (mPeriod1 != null) {
            mbuffer.append(" and fperiodid='").append(mPeriod1.getId().toString()).append("'");
        }
        if (this.mAsstActType != null) {
            mbuffer.append(" and FAsstActTypeID='").append(this.mAsstActType.getId().toString()).append("'").append("\r\n");
        }
        if (this.mAsstActList != null && this.mAsstActList.size() > 0) {
            StringBuffer asstActFilter = new StringBuffer(" and (");
            int size = this.mAsstActList.size();
            for (int i = 0; i < size; ++i) {
                String asstActID = (String)this.mAsstActList.get(i);
                if (i == 0) {
                    asstActFilter.append("FAsstActID ='").append(asstActID).append("'");
                    continue;
                }
                asstActFilter.append(" or FAsstActID ='").append(asstActID).append("'");
            }
            asstActFilter.append(")").append("\r\n");
            mbuffer.append(asstActFilter);
        }
        if (!this.isIncludeBizBill) {
            mbuffer.append(" and fbaltype != ").append(102);
        }
        mbuffer.append(" group by FAsstActID ");
        IRowSet mRowSet = DbUtil.executeQuery((Context)ctx, (String)mbuffer.toString());
        StringBuffer sbuffer = new StringBuffer("");
        sbuffer.append("select  sum(fbeginbalancefor) as fbeginbalancefor,sum(fdebitfor) as fdebitfor,sum(fcreditfor) as fcreditfor,sum(fendbalancefor) as fendbalancefor  from ").append(balanceTempTable).append(" where fcompanyid ='").append(sCompany1.getId().toString()).append("'");
        sbuffer.append(" and fcurrencyid='").append(currency.getId().toString()).append("'");
        if (sPeriod1 != null) {
            sbuffer.append(" and fperiodid='").append(sPeriod1.getId().toString()).append("'");
        }
        if (this.sAsstActType != null) {
            sbuffer.append(" and FAsstActTypeID='").append(this.sAsstActType.getId().toString()).append("'").append("\r\n");
        }
        if (this.sAsstActList != null && this.sAsstActList.size() > 0) {
            StringBuffer asstActFilter = new StringBuffer(" and (");
            int size = this.sAsstActList.size();
            for (int i = 0; i < size; ++i) {
                String asstActID = (String)this.sAsstActList.get(i);
                if (i == 0) {
                    asstActFilter.append("FAsstActID ='").append(asstActID).append("'");
                    continue;
                }
                asstActFilter.append(" or FAsstActID ='").append(asstActID).append("'");
            }
            asstActFilter.append(")").append("\r\n");
            sbuffer.append(asstActFilter);
        }
        if (!this.isIncludeBizBill) {
            sbuffer.append(" and fbaltype != ").append(102);
        }
        IRowSet sRowSet = DbUtil.executeQuery((Context)ctx, (String)sbuffer.toString());
        StringBuffer insertSQL = new StringBuffer("");
        insertSQL.append(" insert into ").append(tempTable);
        insertSQL.append("(currency,mcompanyid,mcompany,scompanyid,scompany,mdirection,sdirection,mperiod,speriod,");
        insertSQL.append(" mbeginbalance,sbeginbalance,beginbalance,mdebit,sdebit,debitbalance,");
        insertSQL.append(" mcredit,scredit,creditbalance,mendbalance,sendbalance,endbalance)");
        insertSQL.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            if (mRowSet.next()) {
                mBeginBalance = mRowSet.getBigDecimal("fbeginbalancefor");
                mDebit = mRowSet.getBigDecimal("fdebitfor");
                mCredit = mRowSet.getBigDecimal("fcreditfor");
                mEndBalance = mRowSet.getBigDecimal("fendbalancefor");
            }
            if (mBeginBalance == null) {
                mBeginBalance = ZERO;
            }
            if (mDebit == null) {
                mDebit = ZERO;
            }
            if (mCredit == null) {
                mCredit = ZERO;
            }
            if (mEndBalance == null) {
                mEndBalance = ZERO;
            }
            if (sRowSet.next()) {
                sBeginBalance = sRowSet.getBigDecimal("fbeginbalancefor");
                sDebit = sRowSet.getBigDecimal("fdebitfor");
                sCredit = sRowSet.getBigDecimal("fcreditfor");
                sEndBalance = sRowSet.getBigDecimal("fendbalancefor");
            }
            if (sBeginBalance == null) {
                sBeginBalance = ZERO;
            }
            if (sDebit == null) {
                sDebit = ZERO;
            }
            if (sCredit == null) {
                sCredit = ZERO;
            }
            if (sEndBalance == null) {
                sEndBalance = ZERO;
            }
            Object[] paramValue = new Object[21];
            paramValue[0] = currency.getName();
            paramValue[1] = mCompany1.getId().toString();
            paramValue[2] = mCompany1.getName();
            paramValue[3] = sCompany1.getId().toString();
            paramValue[4] = sCompany1.getName();
            paramValue[5] = mContrastDirection1.getAlias(ctx.getLocale());
            paramValue[6] = sContrastDirection1.getAlias(ctx.getLocale());
            if (mPeriod1 != null) {
                paramValue[7] = mPeriod1.getPeriodYear() + "-" + mPeriod1.getPeriodNumber();
            }
            if (sPeriod1 != null) {
                paramValue[8] = sPeriod1.getPeriodYear() + "-" + sPeriod1.getPeriodNumber();
            }
            paramValue[9] = mBeginBalance;
            paramValue[10] = sBeginBalance;
            paramValue[11] = mBeginBalance.subtract(sBeginBalance);
            paramValue[12] = mDebit;
            paramValue[13] = sDebit;
            paramValue[14] = mDebit.subtract(sDebit);
            paramValue[15] = mCredit;
            paramValue[16] = sCredit;
            paramValue[17] = mCredit.subtract(sCredit);
            paramValue[18] = mEndBalance;
            paramValue[19] = sEndBalance;
            paramValue[20] = mEndBalance.subtract(sEndBalance);
            ArrayList<Object[]> paramValueList = new ArrayList<Object[]>();
            paramValueList.add(paramValue);
            if (paramValueList.size() > 0) {
                DBUtil.executeBatch((Context)ctx, (String)insertSQL.toString(), paramValueList);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)sRowSet);
        }
    }

    private void caculateContrastData(Context ctx, String tempTable, String balanceTempTable, CurrencyInfo currency, ARAPEnum mContrastDirection1, ARAPEnum sContrastDirection1, CompanyOrgUnitInfo mCompany1, CompanyOrgUnitInfo sCompany1, PeriodInfo mPeriod1, PeriodInfo sPeriod1) throws BOSException, EASBizException {
        BigDecimal mBeginBalance = new BigDecimal("0.0");
        BigDecimal mDebit = new BigDecimal("0.0");
        BigDecimal mCredit = new BigDecimal("0.0");
        BigDecimal mEndBalance = new BigDecimal("0.0");
        BigDecimal sBeginBalance = new BigDecimal("0.0");
        BigDecimal sDebit = new BigDecimal("0.0");
        BigDecimal sCredit = new BigDecimal("0.0");
        BigDecimal sEndBalance = new BigDecimal("0.0");
        StringBuffer sbuffer = new StringBuffer("");
        sbuffer.append("select  sum(fbeginbalancefor) as fbeginbalancefor,sum(fdebitfor) as fdebitfor,sum(fcreditfor) as fcreditfor,sum(fendbalancefor) as fendbalancefor  from ").append(balanceTempTable).append(" where fcompanyid ='").append(sCompany1.getId().toString()).append("'");
        sbuffer.append(" and fcurrencyid='").append(currency.getId().toString()).append("'");
        if (sPeriod1 != null) {
            sbuffer.append(" and fperiodid='").append(sPeriod1.getId().toString()).append("'");
        }
        if (this.sAsstActType != null) {
            sbuffer.append(" and FAsstActTypeID='").append(this.sAsstActType.getId().toString()).append("'").append("\r\n");
        }
        if (this.sAsstActList != null && this.sAsstActList.size() > 0) {
            StringBuffer asstActFilter = new StringBuffer(" and (");
            int size = this.sAsstActList.size();
            for (int i = 0; i < size; ++i) {
                String asstActID = (String)this.sAsstActList.get(i);
                if (i == 0) {
                    asstActFilter.append("FAsstActID ='").append(asstActID).append("'");
                    continue;
                }
                asstActFilter.append(" or FAsstActID ='").append(asstActID).append("'");
            }
            asstActFilter.append(")").append("\r\n");
            sbuffer.append(asstActFilter);
        }
        if (!this.isIncludeBizBill) {
            sbuffer.append(" and fbaltype != ").append(102);
        }
        IRowSet sRowSet = DbUtil.executeQuery((Context)ctx, (String)sbuffer.toString());
        StringBuffer insertSQL = new StringBuffer("");
        insertSQL.append(" insert into ").append(tempTable);
        insertSQL.append("(currency,mcompanyid,mcompany,scompanyid,scompany,mdirection,sdirection,mperiod,speriod,");
        insertSQL.append(" mbeginbalance,sbeginbalance,beginbalance,mdebit,sdebit,debitbalance,");
        insertSQL.append(" mcredit,scredit,creditbalance,mendbalance,sendbalance,endbalance)");
        insertSQL.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            if (mBeginBalance == null) {
                mBeginBalance = ZERO;
            }
            if (mDebit == null) {
                mDebit = ZERO;
            }
            if (mCredit == null) {
                mCredit = ZERO;
            }
            if (mEndBalance == null) {
                mEndBalance = ZERO;
            }
            if (sRowSet.next()) {
                sBeginBalance = sRowSet.getBigDecimal("fbeginbalancefor");
                sDebit = sRowSet.getBigDecimal("fdebitfor");
                sCredit = sRowSet.getBigDecimal("fcreditfor");
                sEndBalance = sRowSet.getBigDecimal("fendbalancefor");
            }
            if (sBeginBalance == null) {
                sBeginBalance = ZERO;
            }
            if (sDebit == null) {
                sDebit = ZERO;
            }
            if (sCredit == null) {
                sCredit = ZERO;
            }
            if (sEndBalance == null) {
                sEndBalance = ZERO;
            }
            Object[] paramValue = new Object[21];
            paramValue[0] = currency.getName();
            paramValue[1] = mCompany1.getId().toString();
            paramValue[2] = mCompany1.getName();
            paramValue[3] = sCompany1.getId().toString();
            paramValue[4] = sCompany1.getName();
            paramValue[5] = mContrastDirection1.getAlias(ctx.getLocale());
            paramValue[6] = sContrastDirection1.getAlias(ctx.getLocale());
            paramValue[7] = mPeriod1.getPeriodYear() + "-" + mPeriod1.getPeriodNumber();
            if (sPeriod1 != null) {
                paramValue[8] = sPeriod1.getPeriodYear() + "-" + sPeriod1.getPeriodNumber();
            }
            paramValue[9] = mBeginBalance;
            paramValue[10] = sBeginBalance;
            paramValue[11] = mBeginBalance.subtract(sBeginBalance);
            paramValue[12] = mDebit;
            paramValue[13] = sDebit;
            paramValue[14] = mDebit.subtract(sDebit);
            paramValue[15] = mCredit;
            paramValue[16] = sCredit;
            paramValue[17] = mCredit.subtract(sCredit);
            paramValue[18] = mEndBalance;
            paramValue[19] = sEndBalance;
            paramValue[20] = mEndBalance.subtract(sEndBalance);
            ArrayList<Object[]> paramValueList = new ArrayList<Object[]>();
            paramValueList.add(paramValue);
            if (paramValueList.size() > 0) {
                DBUtil.executeBatch((Context)ctx, (String)insertSQL.toString(), paramValueList);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)sRowSet);
        }
    }

    private void caculateMContrastData(Context ctx, String tempTable, String balanceTempTable, CurrencyInfo currency, ARAPEnum mContrastDirection1, CompanyOrgUnitInfo mCompany1, PeriodInfo mPeriod1) throws BOSException, EASBizException {
        BigDecimal mBeginBalance = ZERO;
        BigDecimal mDebit = ZERO;
        BigDecimal mCredit = ZERO;
        BigDecimal mEndBalance = ZERO;
        String mcompanyid = "";
        String asstactid = "";
        String scompanyid = "";
        StringBuffer mbuffer = new StringBuffer("");
        mbuffer.append("select sum(fbeginbalancefor) as fbeginbalancefor,sum(fdebitfor) as fdebitfor,sum(fcreditfor) as fcreditfor,sum(fendbalancefor) as fendbalancefor,FAsstActID,FCompanyID from ").append(balanceTempTable).append(" where fcompanyid ='").append(mCompany1.getId().toString()).append("'");
        mbuffer.append(" and fcurrencyid='").append(currency.getId().toString()).append("'");
        if (mPeriod1 != null) {
            mbuffer.append(" and fperiodid='").append(mPeriod1.getId().toString()).append("'");
        }
        if (this.mAsstActType != null) {
            mbuffer.append(" and FAsstActTypeID='").append(this.mAsstActType.getId().toString()).append("'").append("\r\n");
        }
        if (this.mAsstActList != null && this.mAsstActList.size() > 0) {
            StringBuffer asstActFilter = new StringBuffer(" and (");
            int size = this.mAsstActList.size();
            for (int i = 0; i < size; ++i) {
                String asstActID = (String)this.mAsstActList.get(i);
                if (i == 0) {
                    asstActFilter.append("FAsstActID ='").append(asstActID).append("'");
                    continue;
                }
                asstActFilter.append(" or FAsstActID ='").append(asstActID).append("'");
            }
            asstActFilter.append(")").append("\r\n");
            mbuffer.append(asstActFilter);
        }
        if (!this.isIncludeBizBill) {
            mbuffer.append(" and fbaltype != ").append(102);
        }
        mbuffer.append(" group by FAsstActID,FCompanyID ");
        IRowSet mRowSet = DbUtil.executeQuery((Context)ctx, (String)mbuffer.toString());
        StringBuffer updateSQL = new StringBuffer("update ").append(tempTable);
        updateSQL.append(" set mbeginbalance = ?,mdebit = ?,mcredit = ?,mendbalance = ? ");
        updateSQL.append(" where mcompanyid = ? and scompanyid = ? ");
        try {
            ArrayList<Object[]> paramValueList = new ArrayList<Object[]>();
            while (mRowSet.next()) {
                mBeginBalance = mRowSet.getBigDecimal("fbeginbalancefor");
                mDebit = mRowSet.getBigDecimal("fdebitfor");
                mCredit = mRowSet.getBigDecimal("fcreditfor");
                mEndBalance = mRowSet.getBigDecimal("fendbalancefor");
                mcompanyid = mRowSet.getString("fcompanyid");
                asstactid = mRowSet.getString("fasstactid");
                scompanyid = this.getCompanyIDFromCustomerID(ctx, asstactid);
                if (scompanyid == null || "".equalsIgnoreCase(scompanyid)) {
                    scompanyid = this.getCompanyIDFromSupplierID(ctx, asstactid);
                }
                if (scompanyid == null) {
                    scompanyid = "";
                }
                Object[] paramValue = new Object[]{mBeginBalance, mDebit, mCredit, mEndBalance, mcompanyid, scompanyid};
                paramValueList.add(paramValue);
            }
            if (paramValueList.size() > 0) {
                DBUtil.executeBatch((Context)ctx, (String)updateSQL.toString(), paramValueList);
            }
            StringBuffer updateSQL1 = new StringBuffer("update ").append(tempTable);
            updateSQL1.append(" set beginbalance = mbeginbalance - sbeginbalance  ");
            updateSQL1.append(" ,debitbalance = mdebit - sdebit ");
            updateSQL1.append(" ,creditbalance= mcredit- scredit ");
            updateSQL1.append(" ,endbalance = mendbalance - sendbalance  ");
            DBUtil.execute((Context)ctx, (String)updateSQL1.toString());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)mRowSet);
        }
    }

    private void computeBalance(Context ctx, boolean isSingle, String tempTable, CompanyOrgUnitInfo selectedMComps1, Object[] selectedSComps1, CompanyOrgUnitInfo mCompany1, CompanyOrgUnitInfo sCompany1, ARAPEnum mContrastDirection1, ARAPEnum sContrastDirection1, PeriodInfo mPeriod1, PeriodInfo sPeriod1, AsstActTypeInfo mAsstActType1, AsstActTypeInfo sAsstActType1, List mAsstActList1, List sAsstActList1, CurrencyInfo mCurrency1, CurrencyInfo sCurrency1) throws BOSException, EASBizException {
        boolean isAr = true;
        if (isSingle) {
            isAr = mContrastDirection1.getValue() == ARSYSTEM;
            this.computeSingleBalance(ctx, isAr, tempTable, mContrastDirection1, mCompany1, mPeriod1, mAsstActType1, mAsstActList1, mCurrency1);
            isAr = sContrastDirection1.getValue() == ARSYSTEM;
            this.computeSingleBalance(ctx, isAr, tempTable, sContrastDirection1, sCompany1, sPeriod1, sAsstActType1, sAsstActList1, sCurrency1);
        } else {
            isAr = mContrastDirection1.getValue() == ARSYSTEM;
            this.computeSingleBalance(ctx, isAr, tempTable, mContrastDirection1, selectedMComps1, mPeriod1, mAsstActType1, mAsstActList1, mCurrency1);
            isAr = sContrastDirection1.getValue() == ARSYSTEM;
            int length = selectedSComps1.length;
            for (int i = 0; i < length; ++i) {
                CompanyOrgUnitInfo company = this.getCompany(ctx, selectedSComps1[i]);
                if (company.getId().toString().equalsIgnoreCase(selectedMComps1.getId().toString())) continue;
                this.computeSingleBalance(ctx, isAr, tempTable, sContrastDirection1, company, sPeriod1, sAsstActType1, sAsstActList1, sCurrency1);
            }
        }
    }

    private void computeSingleBalance(Context ctx, boolean isAr, String balanceTempTable, ARAPEnum contrastDirection, CompanyOrgUnitInfo company, PeriodInfo period, AsstActTypeInfo asstActType, List asstActList, CurrencyInfo currency) throws BOSException, EASBizException {
        PeriodInfo currentPeriod = null;
        String balanceTable = null;
        if (contrastDirection.getValue() == ARSYSTEM) {
            String key = ARSYSTEM + company.getId().toString();
            if (this.currentPeriodMap.get(key) != null) {
                currentPeriod = (PeriodInfo)this.currentPeriodMap.get(key);
            } else {
                currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, company);
                this.currentPeriodMap.put(key, currentPeriod);
            }
            balanceTable = "t_ar_arbalance";
            isAr = true;
        } else {
            String key = "AP" + company.getId().toString();
            if (this.currentPeriodMap.get(key) != null) {
                currentPeriod = (PeriodInfo)this.currentPeriodMap.get(key);
            } else {
                currentPeriod = ApServerUtils.getApCurrentPeriod(ctx, company);
                this.currentPeriodMap.put(key, currentPeriod);
            }
            balanceTable = "t_ap_apbalance";
            isAr = false;
        }
        if (currentPeriod == null) {
            return;
        }
        if (CommonServerUtils.periodCompare(ctx, currentPeriod, period) >= 1) {
            this.copyDataFromBalanceTable(ctx, isAr, balanceTempTable, balanceTable, company.getId().toString(), period.getId().toString(), currency.getId().toString(), asstActType, asstActList);
        } else if (isAr) {
            this.computeArDailyBalance(ctx, company, period, balanceTempTable, false, currency.getId().toString(), asstActType, asstActList);
        } else {
            this.computeApDailyBalance(ctx, company, period, balanceTempTable, false, currency.getId().toString(), asstActType, asstActList);
        }
    }

    private void copyDataFromBalanceTable(Context ctx, boolean isAR, String destTable, String sourceTable, String companyID, String periodID, String currencyID, AsstActTypeInfo asstActType, List asstActList) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        sql.append("insert into ").append(destTable).append(" (fbaltype,fcompanyid,fperiodid,fcurrencyid,fbeginbalancefor,").append("\r\n").append("fdebitfor,fcreditfor,fyeardebitfor,fyearcreditfor,fendbalancefor,fbeginbalancelocal,").append("\r\n").append("fdebitlocal,fcreditlocal,fyeardebitlocal,fyearcreditlocal,fendbalancelocal,fid,").append("\r\n").append("fasstacttypeid,fasstactid,fadminorgunitid,fpersonid) ").append("\r\n").append(" select fbaltype,fcompanyid,fperiodid,fcurrencyid,fbeginbalancefor,fdebitfor,fcreditfor,").append("\r\n").append("fyeardebitfor,fyearcreditfor,fendbalancefor,fbeginbalancelocal,fdebitlocal,fcreditlocal,").append("\r\n").append("fyeardebitlocal,fyearcreditlocal,fendbalancelocal,fid,fasstacttypeid,fasstactid,").append("\r\n").append("fadminorgunitid,fpersonid from  ").append(sourceTable).append(" where fcompanyid='").append(companyID).append("'").append("\r\n").append(" and fperiodid='").append(periodID).append("'").append("\r\n").append(" and fcurrencyid='").append(currencyID).append("'").append("\r\n");
        if (asstActType != null) {
            sql.append(" and fasstacttypeid='").append(asstActType.getId().toString()).append("'").append(this.rt);
        }
        if (asstActList.size() > 0) {
            sql.append(" and fasstactid  in (").append(this.convertListToString(asstActList)).append(")").append(this.rt);
        }
        if (!this.isIncludeBizBill) {
            sql.append(" and fbaltype != ").append(102);
        }
        DBUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String convertListToString(List list) {
        int size = list.size();
        if (size == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer("");
        for (int i = 0; i < size; ++i) {
            String id = list.get(i).toString();
            buffer.append("'").append(id).append("',");
        }
        String value = buffer.toString();
        int len = buffer.toString().length();
        if (len > 0) {
            value = value.substring(0, len - 1);
        }
        return value;
    }

    private void getBeginBalance(Context ctx, boolean isAR, String tableName, PeriodInfo period, CompanyOrgUnitInfo company, String currencyID) throws BOSException, EASBizException {
        String balanceTable = null;
        balanceTable = isAR ? "T_AR_ArBalance" : "T_AP_ApBalance";
        StringBuffer sql = new StringBuffer("");
        sql.append(" insert into ").append(tableName).append("(fid,fbaltype,fcompanyid,fperiodid,fcurrencyid,fasstacttypeid,").append(this.rt);
        sql.append("fasstactid,fadminorgunitid,fpersonid,fbeginbalancefor,fbeginbalancelocal)").append(this.rt);
        sql.append(" select fid,fbaltype,fcompanyid,fperiodid,fcurrencyid,fasstacttypeid,").append(this.rt);
        sql.append(" fasstactid,fadminorgunitid,fpersonid,fbeginbalancefor,fbeginbalancelocal from ").append(balanceTable).append(this.rt);
        sql.append("  where fcompanyid ='").append(company.getId().toString()).append("'").append(this.rt);
        sql.append("  and fcurrencyid ='").append(currencyID).append("'").append(this.rt);
        sql.append("  and fperiodid ='").append(period.getId().toString()).append("'").append(this.rt);
        if (!this.isIncludeBizBill) {
            sql.append(" and fbaltype != ").append(102);
        }
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public void computeArDailyBalance(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, String tableName, boolean isCloseAccount, String currencyID, AsstActTypeInfo asstActType, List asstActList) throws BOSException, EASBizException {
        PeriodInfo currentPeriod = null;
        String key = ARSYSTEM + company.getId().toString();
        if (this.currentPeriodMap.get(key) != null) {
            currentPeriod = (PeriodInfo)this.currentPeriodMap.get(key);
        } else {
            currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, company);
            this.currentPeriodMap.put(key, currentPeriod);
        }
        if (period == null || currentPeriod == null) {
            return;
        }
        String asstActTypeID = "";
        if (asstActType != null) {
            asstActTypeID = asstActType.getId().toString();
        }
        if (CommonServerUtils.periodCompare(ctx, currentPeriod, period) >= 1) {
            return;
        }
        PeriodInfo startPeriod = null;
        if (this.startPeriodMap.get(key) == null) {
            startPeriod = ArServerUtils.getArStartPeriod(ctx, company);
            this.startPeriodMap.put(key, startPeriod);
        }
        this.getBeginBalance(ctx, true, tableName, currentPeriod, company, currencyID);
        if (CommonServerUtils.periodCompare(ctx, currentPeriod, period) == 0) {
            PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)period);
            this.arSettleAccount(ctx, company, currentPeriod, nextPeriod, period, tableName, currencyID, asstActTypeID, asstActList);
        } else {
            PeriodInfo nextPeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)period);
            while (CommonServerUtils.periodCompare(ctx, currentPeriod, period) < 1) {
                this.arSettleAccount(ctx, company, currentPeriod, nextPeriod, period, tableName, currencyID, asstActTypeID, asstActList);
                currentPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriod);
                if ((nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)currentPeriod)) != null) continue;
                break;
            }
        }
    }

    public void computeApDailyBalance(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, String tableName, boolean isCloseAccount, String currencyID, AsstActTypeInfo asstActType, List asstActList) throws BOSException, EASBizException {
        PeriodInfo currentPeriod = null;
        String key = "AP" + company.getId().toString();
        if (this.currentPeriodMap.get(key) != null) {
            currentPeriod = (PeriodInfo)this.currentPeriodMap.get(key);
        } else {
            currentPeriod = ApServerUtils.getApCurrentPeriod(ctx, company);
            this.currentPeriodMap.put(key, currentPeriod);
        }
        if (period == null || currentPeriod == null) {
            return;
        }
        String asstActTypeID = "";
        if (asstActType != null) {
            asstActTypeID = asstActType.getId().toString();
        }
        if (CommonServerUtils.periodCompare(ctx, currentPeriod, period) >= 1) {
            return;
        }
        PeriodInfo startPeriod = null;
        if (this.startPeriodMap.get(key) == null) {
            startPeriod = ApServerUtils.getApStartPeriod(ctx, company);
            this.startPeriodMap.put(key, startPeriod);
        }
        this.getBeginBalance(ctx, false, tableName, currentPeriod, company, currencyID);
        if (CommonServerUtils.periodCompare(ctx, currentPeriod, period) == 0) {
            PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)period);
            this.apSettleAccount(ctx, company, currentPeriod, nextPeriod, period, tableName, currencyID, asstActTypeID, asstActList);
        } else {
            PeriodInfo nextPeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)period);
            while (CommonServerUtils.periodCompare(ctx, currentPeriod, period) < 1) {
                this.apSettleAccount(ctx, company, currentPeriod, nextPeriod, period, tableName, currencyID, asstActTypeID, asstActList);
                currentPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriod);
                if ((nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)currentPeriod)) != null) continue;
                break;
            }
        }
    }

    private void arSettleAccount(Context ctx, CompanyOrgUnitInfo company, PeriodInfo currentPeriod, PeriodInfo nextPeriod, PeriodInfo period, String tableName, String currencyID, String asstActTypeID, List asstActList) throws BOSException, EASBizException {
        java.util.Date beginDate = currentPeriod.getBeginDate();
        Date endDate = null;
        endDate = CommonServerUtils.periodCompare(ctx, currentPeriod, period) == 0 ? BaseDataUtil.upTimestamp(currentPeriod.getEndDate()) : BaseDataUtil.upTimestamp(nextPeriod.getEndDate());
        ArApBalanceCalculator calculator = BalanceCalculatorFactory.getArApBalanceCalculator((Context)ctx, (IObjectPK)new ObjectUuidPK("rZr83XuPQXGYgUePQ5LecSPUYjI="));
        calculator.calculate(tableName, company.getId().toString(), currentPeriod, currencyID, asstActTypeID, asstActList, beginDate, (java.util.Date)endDate);
        CommonServerUtils.caculateCurrentPeriodBalance(ctx, company, currentPeriod, tableName);
        if (CommonServerUtils.periodCompare(ctx, currentPeriod, period) == 0) {
            CommonServerUtils.transferBalance(ctx, "SYSTEM_AR", "DAILY_NORMAL", tableName, company.getId().toString(), currentPeriod, nextPeriod);
        } else {
            CommonServerUtils.transferBalance(ctx, "SYSTEM_AR", "DAILY_NORMAL", tableName, company.getId().toString(), currentPeriod, period);
        }
    }

    private void apSettleAccount(Context ctx, CompanyOrgUnitInfo company, PeriodInfo currentPeriod, PeriodInfo nextPeriod, PeriodInfo period, String tableName, String currencyID, String asstActTypeID, List asstActList) throws BOSException, EASBizException {
        java.util.Date beginDate = currentPeriod.getBeginDate();
        Date endDate = null;
        endDate = CommonServerUtils.periodCompare(ctx, currentPeriod, period) == 0 ? BaseDataUtil.upTimestamp(currentPeriod.getEndDate()) : BaseDataUtil.upTimestamp(nextPeriod.getEndDate());
        ArApBalanceCalculator calculator = BalanceCalculatorFactory.getArApBalanceCalculator((Context)ctx, (IObjectPK)new ObjectUuidPK("ffjhq9qjQDajSUiiCFG1NCPUYjI="));
        calculator.calculate(tableName, company.getId().toString(), currentPeriod, currencyID, asstActTypeID, asstActList, beginDate, (java.util.Date)endDate);
        CommonServerUtils.caculateCurrentPeriodBalance(ctx, company, currentPeriod, tableName);
        if (CommonServerUtils.periodCompare(ctx, currentPeriod, period) == 0) {
            CommonServerUtils.transferBalance(ctx, "SYSTEM_AP", "DAILY_NORMAL", tableName, company.getId().toString(), currentPeriod, nextPeriod);
        } else {
            CommonServerUtils.transferBalance(ctx, "SYSTEM_AP", "DAILY_NORMAL", tableName, company.getId().toString(), currentPeriod, period);
        }
    }

    public static String convertDateToString(java.util.Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(date);
    }

    private String getTempTable(Context ctx) throws BOSException, EASBizException {
        ObjectUuidPK balanceModelId = new ObjectUuidPK("rZr83XuPQXGYgUePQ5LecSPUYjI=");
        BalanceModelInfo balanceModelInfo = BalanceModelFactory.getLocalInstance((Context)ctx).getBalanceModelInfo((IObjectPK)balanceModelId, BalanceEnginUtil.getBalanceModelSelector());
        String createSQL = BalanceEnginUtil.getCreateTempTableSQL((Context)ctx, (BalanceModelInfo)balanceModelInfo);
        return KsqlUtil.createTempTable((Context)ctx, (String)createSQL.toString());
    }

    private String createTable(Context ctx, String tempTable) throws BOSException, EASBizException {
        StringBuffer tbl = new StringBuffer();
        tbl.append(" create table ").append(tempTable);
        tbl.append("(currency VARCHAR(80) NOT NULL,").append("\r\n");
        tbl.append("mcompanyid VARCHAR(44) NOT NULL,").append("\r\n");
        tbl.append("mcompany VARCHAR(100) NOT NULL,").append("\r\n");
        tbl.append("scompanyid VARCHAR(100) NOT NULL,").append("\r\n");
        tbl.append("scompany VARCHAR(100) NOT NULL,").append("\r\n");
        tbl.append("mdirection VARCHAR(10) NOT NULL,").append("\r\n");
        tbl.append("sdirection VARCHAR(10) NOT NULL,").append("\r\n");
        tbl.append("mperiod\tVARCHAR(20) NOT NULL,").append("\r\n");
        tbl.append("speriod\tVARCHAR(20) NOT NULL,").append("\r\n");
        tbl.append("mbeginbalance NUMERIC(19,4) DEFAULT 0,").append("\r\n");
        tbl.append("sbeginbalance NUMERIC(19,4) DEFAULT 0,").append("\r\n");
        tbl.append("beginbalance NUMERIC(19,4) DEFAULT 0,").append("\r\n");
        tbl.append("mdebit NUMERIC(19,4) DEFAULT 0,").append("\r\n");
        tbl.append("sdebit NUMERIC(19,4) DEFAULT 0,").append("\r\n");
        tbl.append("debitbalance NUMERIC(19,4) DEFAULT 0,").append("\r\n");
        tbl.append("mcredit\tNUMERIC(19,4) DEFAULT 0,").append("\r\n");
        tbl.append("scredit\tNUMERIC(19,4) DEFAULT 0,").append("\r\n");
        tbl.append("creditbalance NUMERIC(19,4) DEFAULT 0,").append("\r\n");
        tbl.append("mendbalance NUMERIC(19,4) DEFAULT 0,").append("\r\n");
        tbl.append("sendbalance NUMERIC(19,4) DEFAULT 0,").append("\r\n");
        tbl.append("endbalance NUMERIC(19,4) DEFAULT 0)").append("\r\n");
        TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTable(tbl.toString());
        return tbl.toString();
    }

    private CompanyOrgUnitInfo getCompany(Context ctx, Object obj) throws BOSException, EASBizException {
        if (obj == null) {
            return null;
        }
        CompanyOrgUnitInfo company = null;
        if (obj instanceof CoreBaseInfo) {
            CoreBaseInfo orgInfo = (CoreBaseInfo)obj;
            ObjectUuidPK pk = new ObjectUuidPK(orgInfo.getId().toString());
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk);
        }
        return company;
    }

    @Override
    protected boolean _checkSamePeriodType(Context ctx, List idList, boolean isARDirection) throws BOSException, EASBizException {
        boolean isSame = true;
        String companyID = null;
        CompanyOrgUnitInfo oldCompany = null;
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            companyID = (String)idList.get(i);
            ObjectUuidPK pk = new ObjectUuidPK(companyID);
            CompanyOrgUnitInfo company = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)pk);
            if (!company.isIsBizUnit()) continue;
            if (oldCompany != null && company != null && !company.getAccountPeriodType().getId().toString().equalsIgnoreCase(oldCompany.getAccountPeriodType().getId().toString())) {
                isSame = false;
                break;
            }
            oldCompany = company;
        }
        return isSame;
    }

    private boolean isInnerCustomer(Context ctx, String mainCompanyID, String sencondCompanyID) throws BOSException, EASBizException {
        ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
        return iCustomer.isExistCustomerByInter(sencondCompanyID, mainCompanyID);
    }

    private boolean isInnerSupplier(Context ctx, String mainCompanyID, String sencondCompanyID) throws BOSException, EASBizException {
        ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
        return iSupplier.isExistSupplierByInter(sencondCompanyID, mainCompanyID);
    }

    private String getInnerCustomerID(Context ctx, String innerCompanyID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        sql.append("select fid from t_bd_customer where FInternalCompanyID='").append(innerCompanyID).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String innerCustomerID = null;
        try {
            if (rs.next()) {
                innerCustomerID = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return innerCustomerID;
    }

    private String getCompanyIDFromCustomerID(Context ctx, String customerID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        sql.append("select FInternalCompanyID from t_bd_customer where fid='").append(customerID).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String companyID = null;
        try {
            if (rs.next()) {
                companyID = rs.getString("FInternalCompanyID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return companyID;
    }

    private String getInnerSupplierID(Context ctx, String innerCompanyID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        sql.append("select fid from t_bd_Supplier where FInternalCompanyID='").append(innerCompanyID).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String innerCustomerID = null;
        try {
            if (rs.next()) {
                innerCustomerID = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return innerCustomerID;
    }

    private String getCompanyIDFromSupplierID(Context ctx, String supplierID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        sql.append("select FInternalCompanyID from t_bd_Supplier where fid='").append(supplierID).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String companyID = null;
        try {
            if (rs.next()) {
                companyID = rs.getString("FInternalCompanyID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return companyID;
    }

    private CurrencyInfo getCurrency(Context ctx, String id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        return CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)pk);
    }
}

