/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.InitBadAccountInfo;
import com.kingdee.eas.fi.ar.app.AbstractInitBadAccountFacadeControllerBean;
import com.kingdee.eas.fi.ar.app.web.InitBadAccountService;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.BaseServiceFacadeFactory;
import com.kingdee.eas.fi.arap.IBaseServiceFacade;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class InitBadAccountFacadeControllerBean
extends AbstractInitBadAccountFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.InitBadAccountFacadeControllerBean");

    @Override
    protected CoreBillBaseInfo _createBill(Context ctx, String mainOrgId, Map initBadAccountInformation) throws BOSException, EASBizException {
        InitBadAccountService iService = new InitBadAccountService(ctx);
        CoreBillBaseInfo billInfo = iService.createBill(mainOrgId, initBadAccountInformation);
        return billInfo;
    }

    @Override
    protected Map _getUICache(Context ctx, String companyId, Map initBadAccountInformation) throws BOSException {
        HashMap<String, Object> cache = new HashMap<String, Object>();
        try {
            cache.put("perm_orgs", this.getPermOrgs());
            if (companyId != null) {
                CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)));
                cache.put("saleOrg2CompanyFilter", this.getOrgFilterByCompany(companyId, 2));
                cache.put("asstActTypeFilter", this.getAsstActTypeFilter(companyInfo));
                cache.put("startPeriodEndDate", this.getStartPeriodEndDate(ctx, companyInfo));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new BOSException(e.getCause());
        }
        return cache;
    }

    private String getStartPeriodEndDate(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        Timestamp time = null;
        PeriodInfo tartPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)company);
        if (tartPeriod != null) {
            time = tartPeriod.getEndDate();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        return sdf.format(time);
    }

    private String getAsstActTypeFilter(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        if (company != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sysEnum", SystemEnum.ACCOUNTSRECEIVABLE);
            map.put("isSCM", new Boolean(false));
            map.put("bosType", new InitBadAccountInfo().getBOSType());
            ArApSysParamInfo result = ArApBillFacadeFactory.getRemoteInstance().getSysParams(company, map);
            AsstActTypeCollection col = result.getAsstActTypeColl();
            HashSet<String> set = new HashSet<String>();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                set.add(col.get(i).getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        }
        return filter.toString();
    }

    protected String getOrgFilterByCompany(String companyid, int orgType) throws EASBizException, BOSException {
        OrgUnitInfo info = null;
        FilterInfo filter = new FilterInfo();
        if (!StringUtils.isEmpty((String)companyid)) {
            IOrgUnitRelation iUtilRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection toUnit = iUtilRel.getFromUnit(companyid, 1, orgType);
            HashSet<String> set = new HashSet<String>();
            int size = toUnit.size();
            for (int i = 0; i < size; ++i) {
                info = toUnit.get(i);
                set.add(info.getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        }
        return filter.toString();
    }

    protected OrgUnitInfo[] getPermOrgs() throws BOSException, EASBizException {
        IBaseServiceFacade ibsf = BaseServiceFacadeFactory.getRemoteInstance();
        OrgUnitInfo[] orgs = ibsf.getAuthorizedBizOrgUnits(this.getOrgType(), this.getPermissionItem());
        return orgs;
    }

    public int getOrgType() {
        return 1;
    }

    public String getPermissionItem() {
        return "fi_ar_InitBadAcct_Add";
    }
}

