/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.app.AbstractOtherBillCommonFacadeControllerBean;
import com.kingdee.eas.fi.ar.app.util.ArServerUtils;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.ar.app.util.SQLUtil;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OtherBillCommonFacadeControllerBean
extends AbstractOtherBillCommonFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.OtherBillCommonFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _getCost(Context ctx, ArrayList idList) throws BOSException, EASBizException {
        String saleTempTableName;
        block7: {
            PeriodInfo currentPeriod;
            CompanyOrgUnitInfo company = CommonServerUtils.getCurrentCompany(ctx);
            Date arStartDate = null;
            Date arEndDate = null;
            if (company != null && company.getId() != null && (currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, company)) != null) {
                arStartDate = currentPeriod.getBeginDate();
                arEndDate = currentPeriod.getEndDate();
            }
            if (null == arStartDate || null == arEndDate) {
                throw new OtherBillBizException(OtherBillBizException.GET_BILL_PERIOD_ERR);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String beginTimeStr = sdf.format(arStartDate);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(arEndDate);
            calendar.add(5, 1);
            arEndDate = calendar.getTime();
            String endDateStr = sdf.format(arEndDate);
            String arTempTableName = null;
            saleTempTableName = null;
            try {
                arTempTableName = this.createArTmpTable(ctx, company, beginTimeStr, endDateStr);
                saleTempTableName = this.createSaleIssueTmpTable(ctx, arTempTableName);
                this.updateNormalData(ctx, arTempTableName, saleTempTableName);
                this.updateSpecialData(ctx, arTempTableName, saleTempTableName);
                if (null == arTempTableName) break block7;
            }
            catch (Throwable throwable) {
                if (null != arTempTableName) {
                    SQLUtil.releasTempTable(ctx, arTempTableName);
                }
                if (null != saleTempTableName) {
                    SQLUtil.releasTempTable(ctx, saleTempTableName);
                }
                throw throwable;
            }
            SQLUtil.releasTempTable(ctx, arTempTableName);
        }
        if (null != saleTempTableName) {
            SQLUtil.releasTempTable(ctx, saleTempTableName);
        }
        return null;
    }

    protected void updateSpecialData(Context ctx, String arTempTableName, String saleTempTableName) throws BOSException {
        StringBuilder updateSpecialBuilder = new StringBuilder();
        updateSpecialBuilder.append(" UPDATE");
        updateSpecialBuilder.append("         T_AR_OTHERBILLENTRY");
        updateSpecialBuilder.append(" SET");
        updateSpecialBuilder.append("         (");
        updateSpecialBuilder.append("                 CFFunitactualcost,");
        updateSpecialBuilder.append("                 CFFactualcost");
        updateSpecialBuilder.append("         )");
        updateSpecialBuilder.append("         =");
        updateSpecialBuilder.append("         (");
        updateSpecialBuilder.append("                 SELECT");
        updateSpecialBuilder.append("                         FUNITACTURALCOST,");
        updateSpecialBuilder.append("                         FUNITACTURALCOST * T_AR_OTHERBILLENTRY.FQUANTITY");
        updateSpecialBuilder.append("                 FROM");
        updateSpecialBuilder.append("                         " + saleTempTableName + " as saleEntry");
        updateSpecialBuilder.append("                 WHERE");
        updateSpecialBuilder.append("                         saleEntry.FID = T_AR_OTHERBILLENTRY.FSOURCEBILLENTRYID )");
        updateSpecialBuilder.append(" WHERE");
        updateSpecialBuilder.append("         T_AR_OTHERBILLENTRY.FID IN(SELECT arEntry.FID");
        updateSpecialBuilder.append(" FROM");
        updateSpecialBuilder.append("         " + arTempTableName + " arEntry");
        updateSpecialBuilder.append(" INNER JOIN");
        updateSpecialBuilder.append("         " + saleTempTableName + " saleEntry");
        updateSpecialBuilder.append(" ON");
        updateSpecialBuilder.append("         arEntry.FSOURCEBILLENTRYID = saleEntry.FID");
        updateSpecialBuilder.append(" WHERE");
        updateSpecialBuilder.append("         arEntry.FQTY <> saleEntry.FQTY )");
        DbUtil.execute((Context)ctx, (String)updateSpecialBuilder.toString());
    }

    protected void updateNormalData(Context ctx, String arTempTableName, String saleTempTableName) throws BOSException {
        StringBuilder updateNormalBuilder = new StringBuilder();
        updateNormalBuilder.append(" UPDATE");
        updateNormalBuilder.append("         T_AR_OTHERBILLENTRY");
        updateNormalBuilder.append(" SET");
        updateNormalBuilder.append("         (");
        updateNormalBuilder.append("                 CFFunitactualcost,");
        updateNormalBuilder.append("                 CFFactualcost");
        updateNormalBuilder.append("         )");
        updateNormalBuilder.append("         =");
        updateNormalBuilder.append("         (");
        updateNormalBuilder.append("                 SELECT");
        updateNormalBuilder.append("                         FUNITACTURALCOST,");
        updateNormalBuilder.append("                         FACTURALCOST");
        updateNormalBuilder.append("                 FROM");
        updateNormalBuilder.append("                         " + saleTempTableName + " as saleTemp");
        updateNormalBuilder.append("                 WHERE");
        updateNormalBuilder.append("                         saleTemp.FID = T_AR_OTHERBILLENTRY.FSOURCEBILLENTRYID )");
        updateNormalBuilder.append(" WHERE");
        updateNormalBuilder.append("         T_AR_OTHERBILLENTRY.FID IN(SELECT FID");
        updateNormalBuilder.append(" FROM");
        updateNormalBuilder.append("         " + arTempTableName + ")");
        DbUtil.execute((Context)ctx, (String)updateNormalBuilder.toString());
    }

    protected String createSaleIssueTmpTable(Context ctx, String arTempTableName) throws BOSException {
        String saleIssueTempTableDef = "(FID varchar(80), FQTY decimal(28, 10),FActuralCost decimal(28, 10), FUnitActuralCost decimal(28, 10))";
        String saleTempTableName = SQLUtil.createTempTable(ctx, saleIssueTempTableDef);
        StringBuilder saleCreateBuilder = new StringBuilder();
        saleCreateBuilder.append(" INSERT into " + saleTempTableName + "(FID, FQTY, FActuralCost, FUnitActuralCost)");
        saleCreateBuilder.append(" SELECT");
        saleCreateBuilder.append("         FID         ,");
        saleCreateBuilder.append("         FQTY        ,");
        saleCreateBuilder.append("         FACTUALCOST ,");
        saleCreateBuilder.append("         FUNITACTUALCOST");
        saleCreateBuilder.append(" FROM");
        saleCreateBuilder.append("         T_IM_SALEISSUEENTRY");
        saleCreateBuilder.append(" WHERE");
        saleCreateBuilder.append("         FID IN (SELECT FSOURCEBILLENTRYID FROM " + arTempTableName + ")");
        DbUtil.execute((Context)ctx, (String)saleCreateBuilder.toString());
        return saleTempTableName;
    }

    protected String createArTmpTable(Context ctx, CompanyOrgUnitInfo company, String beginTimeStr, String endDateStr) throws BOSException {
        String arTempTableDef = "(FID varchar(80), FSOURCEBILLENTRYID varchar(80), FQTY decimal(28, 10))";
        String arTempTableName = SQLUtil.createTempTable(ctx, arTempTableDef);
        StringBuilder createBuilder = new StringBuilder();
        createBuilder.append(" INSERT into " + arTempTableName + "(FID, FSOURCEBILLENTRYID, FQTY)");
        createBuilder.append(" SELECT");
        createBuilder.append("         entry.FID                AS FID               ,");
        createBuilder.append("         entry.FSOURCEBILLENTRYID AS FSourceBillEntryID,");
        createBuilder.append("         entry.FQUANTITY          AS FQty");
        createBuilder.append(" FROM");
        createBuilder.append("         T_AR_OTHERBILL bill");
        createBuilder.append(" INNER JOIN");
        createBuilder.append("         T_AR_OTHERBILLENTRY entry");
        createBuilder.append(" ON");
        createBuilder.append("         bill.FID = entry.FPARENTID");
        createBuilder.append(" WHERE");
        createBuilder.append("         bill.FBILLSTATUS  = 3");
        createBuilder.append(" AND     bill.FCOMPANYID   = '" + company.getId() + "'");
        createBuilder.append(" AND     bill.FFIVOUCHERED = 0");
        createBuilder.append(" AND     bill.FBILLDATE   >= '" + beginTimeStr + "'");
        createBuilder.append(" AND     bill.FBILLDATE    < '" + endDateStr + "'");
        createBuilder.append(" AND     entry.FSOURCEBILLENTRYID is not null");
        DbUtil.execute((Context)ctx, (String)createBuilder.toString());
        return arTempTableName;
    }

    @Override
    protected void _checkBeforeAdjustDiff(Context ctx, ArrayList idList) throws BOSException, EASBizException {
        String idStr = SQLUtil.transArr2SqlIdStr(idList);
        try {
            String exceptNumStr = this.checkBillStatus(ctx, idStr);
            if (!StringUtils.isEmpty((String)exceptNumStr)) {
                String errMsg = ArApServerUtils.getStrResource(ctx.getLocale(), "UNAUDIT_BILL_CANNOT_ADJUST", new Object[]{exceptNumStr});
                throw new OtherBillBizException(OtherBillBizException.ERROR, new Object[]{errMsg});
            }
            int asstsctCount = this.checkAsstactUnique(ctx, idStr);
            if (asstsctCount > 1) {
                String errMsg = ArApServerUtils.getStrResource(ctx.getLocale(), "CUSTOMER_NOT_UNIQUE", null);
                throw new OtherBillBizException(OtherBillBizException.ERROR, new Object[]{errMsg});
            }
            exceptNumStr = this.checkHasNextBill(ctx, idStr);
            if (!StringUtils.isEmpty((String)exceptNumStr)) {
                String errMsg = ArApServerUtils.getStrResource(ctx.getLocale(), "HAS_TRANCE_BILL_CANNOT_ADJUST", new Object[]{exceptNumStr});
                throw new OtherBillBizException(OtherBillBizException.ERROR, new Object[]{errMsg});
            }
        }
        catch (SQLException e) {
            new BOSException("OtherBillCommonFacadeControllerBean.checkBeforeAdjustDiff.sqlError", (Throwable)e);
        }
    }

    protected String checkHasVerified(Context ctx, String idStr) throws BOSException, SQLException {
        StringBuilder checkBuilder = new StringBuilder(300);
        checkBuilder.append(" SELECT");
        checkBuilder.append("         bill.FNUMBER as num");
        checkBuilder.append(" FROM");
        checkBuilder.append("         T_AR_OTHERBILL bill");
        checkBuilder.append(" INNER JOIN");
        checkBuilder.append("         T_AR_VERIFICATIONBILLENTRY verify");
        checkBuilder.append(" ON");
        checkBuilder.append("         bill.FID = verify.FBILLID");
        checkBuilder.append(" WHERE");
        checkBuilder.append("         bill.FID IN (" + idStr + ")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)checkBuilder.toString());
        StringBuilder exceptNum = new StringBuilder();
        while (rowSet.next()) {
            exceptNum.append(rowSet.getString("num")).append(",");
        }
        String exceptNumStr = null;
        if (exceptNum.length() > 0) {
            exceptNumStr = exceptNum.substring(0, exceptNum.length() - 1);
        }
        return exceptNumStr;
    }

    protected String checkHasNextBill(Context ctx, String idStr) throws BOSException, SQLException {
        StringBuilder checkBuilder = new StringBuilder(300);
        checkBuilder.append(" SELECT DISTINCT");
        checkBuilder.append("         bill.FNUMBER AS num");
        checkBuilder.append(" FROM");
        checkBuilder.append("         T_AR_OTHERBILL bill");
        checkBuilder.append(" INNER JOIN");
        checkBuilder.append("         T_BOT_RELATION rel");
        checkBuilder.append(" ON");
        checkBuilder.append("         bill.FID = rel.FSRCOBJECTID");
        checkBuilder.append(" WHERE");
        checkBuilder.append("      bill.FID IN (" + idStr + ")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)checkBuilder.toString());
        StringBuilder exceptNum = new StringBuilder();
        while (rowSet.next()) {
            exceptNum.append(rowSet.getString("num")).append(",");
        }
        String exceptNumStr = null;
        if (exceptNum.length() > 0) {
            exceptNumStr = exceptNum.substring(0, exceptNum.length() - 1);
        }
        return exceptNumStr;
    }

    protected int checkAsstactUnique(Context ctx, String idStr) throws BOSException, SQLException {
        StringBuilder checkBuilder = new StringBuilder(300);
        checkBuilder.append(" SELECT");
        checkBuilder.append("         COUNT(DISTINCT FASSTACTID) as asstactCount");
        checkBuilder.append(" FROM");
        checkBuilder.append("         T_AR_OTHERBILL");
        checkBuilder.append(" WHERE");
        checkBuilder.append("         FID IN (" + idStr + ")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)checkBuilder.toString());
        int asstsctCount = 0;
        if (rowSet.next()) {
            asstsctCount = rowSet.getInt("asstactCount");
        }
        return asstsctCount;
    }

    protected String checkBillStatus(Context ctx, String idStr) throws BOSException, SQLException {
        StringBuilder checkBuilder = new StringBuilder(300);
        checkBuilder.append(" SELECT");
        checkBuilder.append("         bill.FNUMBER as num");
        checkBuilder.append(" FROM");
        checkBuilder.append("         T_AR_OTHERBILL bill");
        checkBuilder.append(" WHERE");
        checkBuilder.append("         bill.FBILLSTATUS <> 3");
        checkBuilder.append(" AND     bill.FID IN (" + idStr + ")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)checkBuilder.toString());
        StringBuilder exceptNum = new StringBuilder();
        while (rowSet.next()) {
            exceptNum.append(rowSet.getString("num")).append(",");
        }
        String exceptNumStr = null;
        if (exceptNum.length() > 0) {
            exceptNumStr = exceptNum.substring(0, exceptNum.length() - 1);
        }
        return exceptNumStr;
    }

    @Override
    protected void _execute(Context ctx, String sql, Object[] params) throws BOSException {
        if (params == null) {
            DbUtil.execute((Context)ctx, (String)sql);
        } else {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
    }

    @Override
    protected IRowSet _executeQuery(Context ctx, String sql, Object[] params) throws BOSException {
        if (params == null) {
            return DbUtil.executeQuery((Context)ctx, (String)sql);
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected int[] _executeBatch(Context ctx, String sql, List paramList) throws BOSException, EASBizException {
        return DbUtil.executeBatchAndReturn((Context)ctx, (String)sql, (List)paramList);
    }
}

