/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeSysEnum;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ap.VerificationEnum;
import com.kingdee.eas.fi.ar.AccountAgeQueryParam;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.ar.ArApQueryParam;
import com.kingdee.eas.fi.ar.ArApReportData;
import com.kingdee.eas.fi.ar.ArApReportTreeData;
import com.kingdee.eas.fi.ar.CAStmtQueryParam;
import com.kingdee.eas.fi.ar.IReportData;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.ar.ItemRptQueryParam;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.ar.ReportInfo;
import com.kingdee.eas.fi.ar.app.AbstractReportFacadeControllerBean;
import com.kingdee.eas.fi.ar.app.ArApReportHelper;
import com.kingdee.eas.fi.ar.app.CaStmtItemSqlBuilder;
import com.kingdee.eas.fi.ar.app.ItemRptSqlBuilder;
import com.kingdee.eas.fi.ar.app.RptAp2PrerecTransSql;
import com.kingdee.eas.fi.ar.app.RptApApVPay_PaySql;
import com.kingdee.eas.fi.ar.app.RptApArVAp_ApSql;
import com.kingdee.eas.fi.ar.app.RptApBillSql;
import com.kingdee.eas.fi.ar.app.RptApPrePayVPreRec_PayVRecSql;
import com.kingdee.eas.fi.ar.app.RptApPreRecVPrePay_RecVPaySql;
import com.kingdee.eas.fi.ar.app.RptApSwap_ArApSql;
import com.kingdee.eas.fi.ar.app.RptApTransSql;
import com.kingdee.eas.fi.ar.app.RptApVPay_ApVArSql;
import com.kingdee.eas.fi.ar.app.RptAr2PrepayTransSql;
import com.kingdee.eas.fi.ar.app.RptArBillSql;
import com.kingdee.eas.fi.ar.app.RptArPrePayVPreRec_PayVRecSql;
import com.kingdee.eas.fi.ar.app.RptArPreRecVPrePay_RecVPaySql;
import com.kingdee.eas.fi.ar.app.RptArSwap_ArApSql;
import com.kingdee.eas.fi.ar.app.RptArTransSql;
import com.kingdee.eas.fi.ar.app.RptArVRecBadVRec_RecSql;
import com.kingdee.eas.fi.ar.app.RptArVRec_ArVApSql;
import com.kingdee.eas.fi.ar.app.RptAr_ApVArSql;
import com.kingdee.eas.fi.ar.app.RptBadAcctSql;
import com.kingdee.eas.fi.ar.app.RptBadRecASql;
import com.kingdee.eas.fi.ar.app.RptBadRec_BadSql;
import com.kingdee.eas.fi.ar.app.RptPay2ArTransSql;
import com.kingdee.eas.fi.ar.app.RptPayBillSql;
import com.kingdee.eas.fi.ar.app.RptPaySwap_ArApSql;
import com.kingdee.eas.fi.ar.app.RptPayTransSql;
import com.kingdee.eas.fi.ar.app.RptRec2ApTransSql;
import com.kingdee.eas.fi.ar.app.RptRecBillSql;
import com.kingdee.eas.fi.ar.app.RptRecSwap_ArApSql;
import com.kingdee.eas.fi.ar.app.RptRecTransSql;
import com.kingdee.eas.fi.arap.app.util.TempTableUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReportFacadeControllerBean
extends AbstractReportFacadeControllerBean {
    private static final long serialVersionUID = -7515739093867504283L;
    private static final int FIRST_PERIOD = 1;
    public static final String FIELD_IS_SUM = "FIsSum";
    public static final String CTRL = " \r\n ";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.ReportFacadeControllerBean");

    @Override
    protected IReportData _getARAgesReport(Context ctx, IReportQueryParam filterParam) throws BOSException, EASBizException {
        return this.getArApAgesReport(ctx, (AccountAgeQueryParam)filterParam, true);
    }

    private IReportData getArApAgesReport(Context ctx, AccountAgeQueryParam param, boolean fAR) throws BOSException, EASBizException {
        this.checkValid(param);
        param.setIsArRpt(fAR);
        long start = System.currentTimeMillis();
        String tempTable = param.getTempTable();
        if (StringUtils.isEmpty((String)tempTable)) {
            this.prepareAgesRpt(ctx, param, fAR);
        }
        IReportData rptData = this.getAgesData(ctx, param);
        long end = System.currentTimeMillis();
        logger.debug((Object)(" tmpTable cost: " + (end - start)));
        return rptData;
    }

    private void setAsstAcctRangeId(Context ctx, ArApQueryParam param) throws BOSException, EASBizException {
        String cussAcctSql = ArApReportHelper.getCussObjsSql(ctx, param);
        param.setCussAcctTempTable(this.putIds2Table(ctx, cussAcctSql, "cussAcctIds", false));
    }

    private void prepareAgesRpt(Context ctx, AccountAgeQueryParam param, boolean fAR) throws BOSException, EASBizException {
        this.setAsstAcctRangeId(ctx, param);
        boolean fByBill = param.getAnalyseObjIndex() == 1;
        boolean isAgeByPlanDate = param.isAgeByPlanDate();
        String tempTable = TempTableUtil.createTempTable(ctx, this.agedRptTempTable(param));
        String agedBillTable = TempTableUtil.createTempTable(ctx, this.agedBillsTableDefine(fByBill, isAgeByPlanDate));
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection(ctx);
            param.setTempTable(tempTable);
            String sql = ArApReportHelper.getAgedBillDataSql(ctx, param, agedBillTable, fAR);
            logger.debug((Object)("Aged bill Data \r\n" + sql));
            stmt = con.createStatement();
            stmt.execute(sql);
            sql = ArApReportHelper.getAgeRptSql(ctx, param, agedBillTable);
            logger.debug((Object)("aged rpt sql \r\n" + sql));
            stmt.execute(sql);
            sql = ArApReportHelper.getAgedBillSumSql(ctx, param);
            logger.debug((Object)("aged sum sql\r\n" + sql));
            stmt.execute(sql);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"exception while preparing agesRpt ", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
    }

    private IReportData getAgesData(Context ctx, AccountAgeQueryParam param) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)param.getTempTable())) {
            return null;
        }
        ArApReportData rptData = null;
        Connection con = null;
        Statement pstmt = null;
        IRowSet rs = null;
        boolean fArRpt = param.isArRpt();
        boolean fByBill = param.getAnalyseObjIndex() == 1;
        Locale locale = ctx.getLocale();
        StringBuffer qSql = new StringBuffer();
        qSql.append("select top ").append(param.getEndIndex());
        qSql.append(" * from ").append(param.getTempTable()).append(" t1 ");
        String qryCussAcctId = param.getCussAcctId();
        if (!StringUtils.isEmpty((String)qryCussAcctId)) {
            qSql.append(" where FCussAcctId = '").append(qryCussAcctId).append("' ");
        }
        if (fByBill) {
            qSql.append(" order by FCussNum, FCurrency, FDataType, FBillDate, FBillType, FBillNum");
        } else {
            qSql.append(" order by FCussNum, FCurrency, FDataType");
        }
        try {
            logger.debug((Object)("ageRpt qrySql\r\n" + qSql));
            rs = DbUtil.executeQuery((Context)ctx, (String)qSql.toString());
            int start = param.getStartIndex();
            int end = param.getEndIndex();
            int row = 0;
            List<String> rptFlds = param.getReportFields();
            ArrayList<ReportInfo> dataLst = new ArrayList<ReportInfo>();
            ReportInfo rptInfo = null;
            while (rs.next()) {
                if (ArApReportHelper.isInRange(++row, start, end)) {
                    rptInfo = new ReportInfo();
                    String col = "";
                    int n = rptFlds.size();
                    for (int i = 0; i < n; ++i) {
                        col = rptFlds.get(i).toString();
                        if (col.equals("FBillType")) {
                            int type = rs.getInt("FBillType");
                            if (type < 0) continue;
                            String typeVal = this.getBillType(type, fArRpt ? 3 : 4, locale);
                            rptInfo.put(col, typeVal);
                            continue;
                        }
                        rptInfo.put(col, rs.getObject(col));
                    }
                    int rowType = rs.getInt("FDataType");
                    rptInfo.setIsTotalLine(rowType != 0);
                    dataLst.add(rptInfo);
                    continue;
                }
                if (row <= end) continue;
            }
            rptData = new ArApReportData(dataLst);
            rptData.setTempTable(param.getTempTable());
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"getAgeReport sql execution error. ", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, pstmt, con);
        return rptData;
    }

    private void insertCAStmtData(Context ctx, CAStmtQueryParam param) throws BOSException, EASBizException {
        PeriodInfo countStartApPeriod;
        PeriodInfo countStartArPeriod = ArApReportHelper.getPeriodStartToCount(ctx, param, true);
        String sql = CaStmtItemSqlBuilder.getCAStmtSql(ctx, param, countStartArPeriod, countStartApPeriod = ArApReportHelper.getPeriodStartToCount(ctx, param, false));
        if (StringUtils.isEmpty((String)sql)) {
            return;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            logger.debug((Object)("castmt sql\r\n" + sql));
            con = this.getConnection(ctx);
            pstmt = con.prepareStatement(sql);
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"insertCAStmtData sql execution error. ", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)con);
    }

    private IReportData getCAStmtData(Context ctx, CAStmtQueryParam param) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)param.getTempTable())) {
            return null;
        }
        ArApReportData rptData = null;
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String startCol = "FStartBalanceAmt";
        String balanceCol = "FBalanceAmt";
        String startColLocal = "FStartBalanceAmtLocal";
        String balanceColLocal = "FBalanceAmtLocal";
        int totalRowCount = param.getTotalRowCount();
        try {
            String sql = this.castmtFinalSql(param);
            String countSql = "SELECT COUNT(0) " + sql.substring(sql.indexOf("from"), sql.indexOf("order by"));
            logger.debug((Object)("caStmt qrySql\r\n" + sql));
            con = this.getConnection(ctx);
            if (totalRowCount == 0 && (rs = (pstmt = con.prepareStatement(countSql)).executeQuery()).next()) {
                totalRowCount = rs.getInt(1);
            }
            pstmt = con.prepareStatement(sql);
            rs = pstmt.executeQuery();
            int start = param.getStartIndex();
            int end = param.getEndIndex();
            List rptFlds = param.getReportFields();
            ArrayList<ReportInfo> dataLst = new ArrayList<ReportInfo>();
            String col = "";
            BigDecimal balance = SysConstant.BIGZERO;
            BigDecimal balanceLocal = SysConstant.BIGZERO;
            ReportInfo rptInfo = null;
            int row = 0;
            while (rs.next()) {
                if (ArApReportHelper.isInRange(++row, start, end)) {
                    rptInfo = new ReportInfo();
                    int n = rptFlds.size();
                    for (int i = 0; i < n; ++i) {
                        col = rptFlds.get(i).toString();
                        rptInfo.put(col, rs.getObject(col));
                    }
                    BigDecimal bigDecimal = balance = rs.getBigDecimal(startCol) != null ? rs.getBigDecimal(startCol) : SysConstant.BIGZERO;
                    if (rs.getBigDecimal("FDebitAmt") != null) {
                        balance = balance.add(rs.getBigDecimal("FDebitAmt"));
                    }
                    if (rs.getBigDecimal("FCreditAmt") != null) {
                        balance = balance.subtract(rs.getBigDecimal("FCreditAmt"));
                    }
                    rptInfo.put(balanceCol, balance);
                    BigDecimal bigDecimal2 = balanceLocal = rs.getBigDecimal(startColLocal) != null ? rs.getBigDecimal(startColLocal) : SysConstant.BIGZERO;
                    if (rs.getBigDecimal("FDebitAmtLocal") != null) {
                        balanceLocal = balanceLocal.add(rs.getBigDecimal("FDebitAmtLocal"));
                    }
                    if (rs.getBigDecimal("FCreditAmtLocal") != null) {
                        balanceLocal = balanceLocal.subtract(rs.getBigDecimal("FCreditAmtLocal"));
                    }
                    rptInfo.put(balanceColLocal, balanceLocal);
                    if (rs.getInt(FIELD_IS_SUM) != 0) {
                        rptInfo.setIsSumLine(true);
                    }
                    dataLst.add(rptInfo);
                    continue;
                }
                if (row <= end) continue;
            }
            rptData = new ArApReportData(dataLst, totalRowCount);
            rptData.setTempTable(param.getTempTable());
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"getCAStmtData execute sql exception. ", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return rptData;
    }

    private String castmtFinalSql(CAStmtQueryParam param) {
        List rptFlds = param.getReportFields();
        int fldSize = rptFlds.size();
        StringBuffer dataSql = new StringBuffer();
        dataSql.append("select top ").append(param.getEndIndex()).append(" ");
        for (int i = 0; i < fldSize; ++i) {
            dataSql.append(rptFlds.get(i));
            dataSql.append(i < fldSize - 1 ? ", " : "");
        }
        dataSql.append(", ").append(FIELD_IS_SUM).append(" ");
        dataSql.append("\r\n from ").append(param.getTempTable());
        dataSql.append(" t1\r\n left join t_bd_currency t2 ");
        dataSql.append("on t2.FId = t1.FCurrencyId\r\n where FIsFinal = 1");
        dataSql.append(" order by t2.FNumber,");
        if (param.isOrderbyBizNum() && param.isCustSupplAcctCuss()) {
            dataSql.append("FBizAnalysisCode,");
        }
        dataSql.append("FCussType, FCussNum, ").append(FIELD_IS_SUM);
        return dataSql.toString();
    }

    private String getBillType(int iType, int iMainType, Locale locale) {
        String billType = "";
        if (iMainType == 4 && OtherBillType.getEnum((int)iType) != null) {
            billType = OtherBillType.getEnum((int)iType).getAlias(locale);
        } else if (iMainType == 3 && OtherBillTypeEnum.getEnum((int)iType) != null) {
            billType = OtherBillTypeEnum.getEnum((int)iType).getAlias(locale);
        } else if (iMainType == 0) {
            billType = iType == 15 ? VerificateBillTypeEnum.BadAcct.getAlias(locale) : (VerificationEnum.getEnum((int)iType) != null ? VerificationEnum.getEnum((int)iType).getAlias(locale) : " ");
        }
        return billType;
    }

    private void checkValid(ArApQueryParam param) throws BOSException, EASBizException {
        if (param == null) {
            throw new ArApCommonException(ArApCommonException.RPT_PARAM_NULL);
        }
        if (StringUtils.isEmpty((String)param.getCompanyId())) {
            throw new ArApCommonException(ArApCommonException.COMPANY_NULL);
        }
        if (param.getCussAcctTypeInfo() == null) {
            throw new ArApCommonException(ArApCommonException.NOTSETASSTTYPE);
        }
    }

    private String agedBillsTableDefine(boolean fByBill, boolean isAgeByPlanDate) {
        StringBuffer tbl = new StringBuffer(200);
        tbl.append(" ( FCussType nvarchar(100), FCussAcctId varchar(44), ");
        tbl.append(" FCussNum nvarchar(100), FCussName nvarchar(400), ");
        tbl.append("FCurrency nvarchar(100), FBillDate dateTime, FRecPayDate");
        tbl.append(" dateTime, FUnVerifyAmt decimal(28, 10) NOT NULL DEFAULT 0");
        if (fByBill) {
            tbl.append(", FBillType int, FBillNum nvarchar(200),");
            tbl.append(" FBillId varchar(44), FDescription nvarchar(255)");
        }
        tbl.append(")");
        return tbl.toString();
    }

    private String agedRptTempTable(AccountAgeQueryParam param) {
        boolean fByBill = param.getAnalyseObjIndex() == 1;
        StringBuffer tbl = new StringBuffer(200);
        tbl.append(" (FCussAcctId varchar(44), ");
        List<String> lstFlds = param.getReportFields();
        int amtFldIndex = param.getAmtColStartIndex();
        tbl.append((Object)lstFlds.get(0)).append(" nvarchar(200), ");
        tbl.append((Object)lstFlds.get(1)).append(" nvarchar(200), ");
        tbl.append((Object)lstFlds.get(2)).append(" nvarchar(200)");
        if (fByBill) {
            tbl.append(",");
            tbl.append((Object)lstFlds.get(3)).append(" dateTime, ");
            tbl.append((Object)lstFlds.get(4)).append(" int default -1, ");
            tbl.append((Object)lstFlds.get(5)).append(" nvarchar(255), ");
            tbl.append((Object)lstFlds.get(6)).append(" nvarchar(255), ");
            tbl.append((Object)lstFlds.get(7)).append(" varchar(44)");
        }
        int fldSize = lstFlds.size();
        for (int i = amtFldIndex; i < fldSize; ++i) {
            tbl.append(", ").append((Object)lstFlds.get(i));
            tbl.append(" decimal(28, 10) NOT NULL DEFAULT 0");
        }
        tbl.append(", FDataType int NOT NULL DEFAULT 0)");
        return tbl.toString();
    }

    @Override
    protected IReportData _getAPAgesReport(Context ctx, IReportQueryParam filterParam) throws BOSException, EASBizException {
        return this.getArApAgesReport(ctx, (AccountAgeQueryParam)filterParam, false);
    }

    @Override
    protected IReportData _getAPCAStmtItemReport(Context ctx, IReportQueryParam filterParam) throws BOSException, EASBizException {
        CAStmtQueryParam param = (CAStmtQueryParam)filterParam;
        this.checkCAStmtItemParam(param);
        param.setIsArRpt(false);
        return this.getCAStmtItemRpt(ctx, param);
    }

    @Override
    protected IReportData _getARCAStmtItemReport(Context ctx, IReportQueryParam filterParam) throws BOSException, EASBizException {
        CAStmtQueryParam param = (CAStmtQueryParam)filterParam;
        this.checkCAStmtItemParam(param);
        param.setIsArRpt(true);
        return this.getCAStmtItemRpt(ctx, param);
    }

    @Override
    protected ArApReportTreeData _getARCAStmtItemRptTreeData(Context ctx, IReportQueryParam filterParam) throws BOSException, EASBizException {
        CAStmtQueryParam param = (CAStmtQueryParam)filterParam;
        this.checkCAStmtItemParam(param);
        param.setIsArRpt(true);
        return this.getCAStmtItemRptTreeData(ctx, param);
    }

    @Override
    protected ArApReportTreeData _getAPCAStmtItemRptTreeData(Context ctx, IReportQueryParam filterParam) throws BOSException, EASBizException {
        CAStmtQueryParam param = (CAStmtQueryParam)filterParam;
        this.checkCAStmtItemParam(param);
        param.setIsArRpt(false);
        return this.getCAStmtItemRptTreeData(ctx, param);
    }

    private ArApReportTreeData getCAStmtItemRptTreeData(Context ctx, CAStmtQueryParam param) throws BOSException, EASBizException {
        this.fetchCAStmtItemRpt(ctx, param);
        String tempTable = param.getTempTable();
        String companyid = param.getCompanyId();
        if (!StringUtils.isEmpty((String)tempTable)) {
            StringBuffer getCurrencyLocalSql = new StringBuffer(200);
            getCurrencyLocalSql.append(" SELECT FID currencyLocalID,FNAME_L2 currencyLocalName FROM T_BD_Currency WHERE FID=( ");
            getCurrencyLocalSql.append(" SELECT FBaseCurrencyID FROM T_ORG_Company WHERE FID='" + companyid + "' ");
            getCurrencyLocalSql.append(" ) ");
            IRowSet currencyLocalRs = DbUtil.executeQuery((Context)ctx, (String)getCurrencyLocalSql.toString());
            try {
                while (currencyLocalRs.next()) {
                    String currencyLocalID = currencyLocalRs.getString("currencyLocalID");
                    String currencyLocalName = currencyLocalRs.getString("currencyLocalName");
                    String updateCurrencyLocalSql = " UPDATE " + tempTable + " SET FCurrencyLocalId='" + currencyLocalID + "',FCurrencyLocal='" + currencyLocalName + "' ";
                    DbUtil.execute((Context)ctx, (String)updateCurrencyLocalSql);
                }
            }
            catch (SQLException e1) {
                throw new BOSException((Throwable)e1);
            }
        }
        StringBuffer sql = new StringBuffer(200);
        sql.append("select TOP ").append(param.getTreeFetchRowCount()).append(" t1.fid id, ");
        if (param.isCustSupplAcctCuss()) {
            sql.append(" t1.FGroupName");
        } else {
            sql.append(" t1.FName_");
            sql.append(ctx.getLocale().getLanguage());
        }
        sql.append(" name \r\n from ");
        sql.append(param.getCussAcctTempTable());
        sql.append(" t1 ");
        sql.append(" where 1=1 ");
        sql.append(" AND EXISTS (SELECT 1 FROM ").append(param.getTempTable());
        sql.append(" t2 WHERE t1.FID = t2.FCussAcctId)");
        sql.append(" order by ");
        if (param.isOrderbyBizNum()) {
            sql.append("t1.FBizAnalysisCode,");
        }
        sql.append("t1.fnumber");
        logger.debug((Object)("treeData sql: \r\n" + sql));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        JdbcRowSet result = null;
        if (param.isDoExpand()) {
            int rowCount = 0;
            try {
                while (rs.next()) {
                    ++rowCount;
                }
                if (rowCount > param.getTreeFetchRowCount() - param.getTreeFetchSize()) {
                    result = new JdbcRowSet();
                    rs.beforeFirst();
                    result.populate((ResultSet)rs, param.getTreeFetchRowCount() - param.getTreeFetchSize(), param.getTreeFetchSize(), true);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        ArApReportTreeData treeData = new ArApReportTreeData();
        treeData.setTempTable(param.getTempTable());
        treeData.setAssistTempTable(param.getCussAcctTempTable());
        treeData.setRowSet((IRowSet)(param.isDoExpand() ? result : rs));
        return treeData;
    }

    private void fetchCAStmtItemRpt(Context ctx, CAStmtQueryParam param) throws BOSException, EASBizException {
        String tempTable = param.getTempTable();
        if (!StringUtils.isEmpty((String)tempTable)) {
            return;
        }
        SystemEnum sysEnum = param.isArRpt() ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)sysEnum, (IObjectPK)new ObjectUuidPK(param.getCompanyId()));
        if (startPeriod == null) {
            throw new ArApCommonException(param.isArRpt() ? ArApCommonException.AR_STARTPERIOD_NULL : ArApCommonException.AP_STARTPERIOD_NULL);
        }
        if (param.getBeginDate().before(startPeriod.getBeginDate())) {
            param.setBeginDate(new java.sql.Date(startPeriod.getBeginDate().getTime()));
        }
        java.sql.Date endDate = param.getEndDate();
        endDate.setTime(endDate.getTime() + 86400000L);
        param.setEndDate(endDate);
        this.prepareCAStmtItemRpt(ctx, param);
    }

    private IReportData getCAStmtItemRpt(Context ctx, CAStmtQueryParam param) throws BOSException, EASBizException {
        this.fetchCAStmtItemRpt(ctx, param);
        IReportData rptData = this.getCAStmtItemData(ctx, param);
        return rptData;
    }

    private void checkCAStmtItemParam(CAStmtQueryParam param) throws BOSException, EASBizException {
        this.checkValid(param);
        if (param.getBeginDate() == null || param.getEndDate() == null || param.getBeginDate().after(param.getEndDate())) {
            throw new ArApCommonException(ArApCommonException.DATERANGE_INVALID);
        }
    }

    private void putCustSupIdByBizCode2Table(Context ctx, CAStmtQueryParam param) throws BOSException, EASBizException {
        StringBuffer bizCodeIds;
        ArrayList<String> bizCodeSet;
        ResultSet sqlRs;
        PreparedStatement pstmt;
        Connection con;
        TempTablePool t;
        String flds;
        String cussAcctIdsTable;
        block12: {
            String cussTable;
            block11: {
                boolean fCusSupp = param.isCustSupplAcctCuss();
                cussTable = param.getCussTable().toLowerCase();
                String nameFld = ArApReportHelper.getNameFld(ctx);
                cussAcctIdsTable = null;
                String cussIdsTblDefine = null;
                flds = null;
                String valFlds = null;
                cussIdsTblDefine = "( FId varchar(44), FBizAnalysisCode nvarchar(80) , " + nameFld + " nvarchar(400), FNumber nvarchar(80), FIsByBizCode int default 0, FGroupName nvarchar(400))";
                flds = " t1.FId, t1." + nameFld + ", t1.FNumber ";
                valFlds = " (FId, " + nameFld + ", FNumber) ";
                String cussSql = null;
                cussSql = ArApReportHelper.getCussObjsSql(ctx, param);
                cussAcctIdsTable = TempTableUtil.createTempTable(ctx, cussIdsTblDefine);
                t = TempTablePool.getInstance((Context)ctx);
                try {
                    t.createIndex(cussAcctIdsTable, "FId", false, false);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
                con = null;
                pstmt = null;
                sqlRs = null;
                con = this.getConnection(ctx);
                String insSql = "insert into " + cussAcctIdsTable + valFlds + " \r\n" + cussSql;
                logger.debug((Object)("query cussAcctId, insSql \r\n" + insSql));
                pstmt = con.prepareStatement(insSql);
                pstmt.execute();
                param.setCussAcctTempTable(cussAcctIdsTable);
                if (fCusSupp) break block11;
                SQLUtils.cleanup(sqlRs, (Statement)pstmt, (Connection)con);
                return;
            }
            StringBuffer hasBizCodeSql = new StringBuffer();
            hasBizCodeSql.append("select distinct FBizAnalysisCodeId\r\n from ");
            hasBizCodeSql.append(cussTable);
            hasBizCodeSql.append(" t1 inner join ").append(cussAcctIdsTable);
            hasBizCodeSql.append(" t2 on t1.fid = t2.fid\r\n where ");
            hasBizCodeSql.append(" t1.FBizAnalysisCodeId is not null ");
            logger.debug((Object)("query cussAcctId, queryBizCodeSql \r\n" + hasBizCodeSql));
            pstmt = con.prepareStatement(hasBizCodeSql.toString());
            sqlRs = pstmt.executeQuery();
            bizCodeSet = new ArrayList<String>();
            bizCodeIds = new StringBuffer();
            while (sqlRs.next()) {
                bizCodeIds.append("'").append(sqlRs.getString(1));
                bizCodeIds.append("',");
                bizCodeSet.add(sqlRs.getString(1));
            }
            if (bizCodeIds.length() <= 0) break block12;
            bizCodeIds.deleteCharAt(bizCodeIds.length() - 1);
        }
        SQLUtils.cleanup((ResultSet)sqlRs, (Statement)pstmt, (Connection)con);
        return;
        try {
            IAsstActType iAsstType = AsstActTypeFactory.getLocalInstance((Context)ctx);
            AsstActTypeSysEnum cussEnum = param.isCustomerAcctCuss() ? AsstActTypeSysEnum.PROVIDER : AsstActTypeSysEnum.CUSTOMER;
            AsstActTypeInfo otherTypeInfo = iAsstType.getAsstActType(cussEnum);
            param.setOtherTypeId(otherTypeInfo.getString("id"));
            String sql = this.getInsertSql_SameBizCode(ctx, param, bizCodeIds.toString(), flds);
            logger.debug((Object)("cussAcctSql:\r\n" + sql));
            DbUtil.execute((Context)ctx, (String)sql.toString());
            try {
                t.analyzeTable(con, cussAcctIdsTable);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            this.updateBizCodeNumber(con, cussAcctIdsTable, bizCodeSet);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"query the cussAcctids", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sqlRs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)sqlRs, (Statement)pstmt, (Connection)con);
    }

    private String getInsertSql_SameBizCode(Context ctx, CAStmtQueryParam param, String bizCodeIds, String flds) throws BOSException, EASBizException {
        FilterInfo cuFilter;
        String cussTable = param.getCussTable().toLowerCase();
        boolean fCustomer = param.isCustomerAcctCuss();
        ObjectUuidPK cuPK = new ObjectUuidPK(param.getCuId());
        String cuSql = null;
        if (fCustomer) {
            ISupplier iSupp = SupplierFactory.getLocalInstance((Context)ctx);
            cuFilter = iSupp.getDatabaseDFilter((IObjectPK)cuPK, "t1.FId", "t1.FAdminCUId");
            cuSql = cuFilter.toString();
        } else {
            ICustomer iCust = CustomerFactory.getLocalInstance((Context)ctx);
            cuFilter = iCust.getDatabaseDFilter((IObjectPK)cuPK, "t1.FId", "t1.FAdminCUId");
            cuSql = cuFilter.toString();
        }
        String valFlds = " (FId, FName_" + ctx.getLocale().getLanguage() + ", FNumber, FIsByBizCode) ";
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(param.getCussAcctTempTable());
        sql.append(valFlds);
        sql.append("\r\n select distinct ").append(flds);
        sql.append(", 1 FIsByBizCode\r\n from ").append(cussTable);
        sql.append(" t1 where t1.FBizAnalysisCodeId in (");
        sql.append(bizCodeIds).append(") and");
        sql.append(" t1.FId not in (select Fid from ");
        sql.append(param.getCussAcctTempTable()).append(" )");
        sql.append("\r\n union all \r\n");
        String otherTbl = fCustomer ? "t_bd_supplier" : "t_bd_customer";
        sql.append(" select ").append(flds);
        sql.append(", 1 FIsByBizCode\r\n from ").append(otherTbl);
        sql.append(" t1 where t1.FBizAnalysisCodeId in (");
        sql.append(bizCodeIds).append(") and ").append(cuSql);
        return sql.toString();
    }

    private void updateBizCodeNumber(Connection con, String cussAcctIdsTable, List bizCodeSet) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(cussAcctIdsTable);
        sql.append("\r\n set FBizAnalysisCode = (select FNumber");
        sql.append(" from t_bd_bizAnaylysisCode where FId");
        sql.append(" = ?)\r\n where FId in (select FId from");
        sql.append(" t_bd_customer where FBizAnalysisCodeId = ?");
        sql.append(" union all\r\n   select Fid from t_bd_supplier");
        sql.append(" where FBizAnalysisCodeId = ?)");
        PreparedStatement pstmt = null;
        try {
            logger.debug((Object)("cussAcctSql updateBizCodeSql: \r\n" + sql));
            pstmt = con.prepareStatement(sql.toString());
            int n = bizCodeSet.size();
            for (int i = 0; i < n; ++i) {
                String bizCodeId = (String)bizCodeSet.get(i);
                pstmt.setString(1, bizCodeId);
                pstmt.setString(2, bizCodeId);
                pstmt.setString(3, bizCodeId);
                pstmt.execute();
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    private IReportData getCAStmtItemData(Context ctx, CAStmtQueryParam param) throws BOSException, EASBizException {
        String tempTable = param.getTempTable();
        boolean fCustSupp = param.isCustSupplAcctCuss();
        boolean isRoot = param.getCussAcctId() == null;
        String cussAcctTempTable = param.getCussAcctTempTable();
        if (StringUtils.isEmpty((String)tempTable) || fCustSupp && StringUtils.isEmpty((String)cussAcctTempTable)) {
            logger.error((Object)"the temp tbl or the cussAcct temp tbl is null!!!");
            return null;
        }
        ArApReportData rptData = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select top ").append(param.getEndIndex());
        sql.append(" t1.*, t2.FNumber AS FCussNum,");
        if (fCustSupp) {
            sql.append(" t2.FGroupName");
        } else {
            sql.append(" t2.FName_");
            sql.append(ctx.getLocale());
        }
        sql.append("  AS FCussName \r\n from ").append(tempTable).append(" t1 ");
        sql.append(" inner join ").append(param.getCussAcctTempTable()).append(" t2 ");
        sql.append(" on t1.FCussAcctId = t2.fid ");
        if (!isRoot) {
            sql.append(" where t1.FCussAcctId = ? ");
            if (fCustSupp) {
                sql.append("\r\n or t1.FBizAnalysisCode = (select ");
                sql.append(" FBizAnalysisCode from ");
                sql.append(cussAcctTempTable);
                sql.append("\r\n  where FId = ? )");
            }
        } else {
            sql.append(" where t1.FCussAcctId is not null ");
        }
        sql.append("\r\n order by FCurrency, FNumber, t2.fid, FDatatype, FBillDate, ");
        sql.append("FBillNum, FBillType");
        logger.debug((Object)("get itemRptData \r\n" + sql + "\r\n cussAcctId: " + param.getCussAcctId()));
        String countSql = "SELECT COUNT(0) " + sql.substring(sql.indexOf("from"), sql.indexOf("order by"));
        Connection cn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String balanceCol = "FBalanceAmt";
        String balanceLocalCol = "FBalanceAmtLocal";
        int totalRowCount = param.getTotalRowCount();
        try {
            cn = this.getConnection(ctx);
            if (totalRowCount == 0) {
                pstmt = cn.prepareStatement(countSql);
                if (!isRoot) {
                    pstmt.setString(1, param.getCussAcctId());
                    if (fCustSupp) {
                        pstmt.setString(2, param.getCussAcctId());
                    }
                }
                if ((rs = pstmt.executeQuery()).next()) {
                    totalRowCount = rs.getInt(1);
                }
            }
            pstmt = cn.prepareStatement(sql.toString());
            if (!isRoot) {
                pstmt.setString(1, param.getCussAcctId());
                if (fCustSupp) {
                    pstmt.setString(2, param.getCussAcctId());
                }
            }
            rs = pstmt.executeQuery();
            int start = param.getStartIndex();
            int end = param.getEndIndex();
            int iType = 0;
            int iMainType = 0;
            String billType = "";
            String col = "";
            List rptFlds = param.getReportFields();
            ArrayList<ReportInfo> dataLst = new ArrayList<ReportInfo>();
            ReportInfo rptInfo = null;
            BigDecimal balance = SysConstant.BIGZERO;
            BigDecimal balanceLocal = SysConstant.BIGZERO;
            int dataType = -1;
            int row = 0;
            Timestamp timestamp = null;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            while (rs.next()) {
                ++row;
                dataType = rs.getInt("FDataType");
                if (dataType == 0) {
                    balance = rs.getBigDecimal("FBalanceAmt");
                    balanceLocal = rs.getBigDecimal("FBalanceAmtLocal");
                } else if (dataType == 1) {
                    BigDecimal amt = rs.getBigDecimal("FDebitAmt");
                    BigDecimal amtLocal = rs.getBigDecimal("FDebitAmtLocal");
                    if (amt != null) {
                        balance = balance.add(amt);
                    }
                    if ((amt = rs.getBigDecimal("FCreditAmt")) != null) {
                        balance = balance.subtract(amt);
                    }
                    if (amtLocal != null) {
                        balanceLocal = balanceLocal.add(amtLocal);
                    }
                    if ((amtLocal = rs.getBigDecimal("FCreditAmtLocal")) != null) {
                        balanceLocal = balanceLocal.subtract(amtLocal);
                    }
                }
                if (ArApReportHelper.isInRange(row, start, end)) {
                    rptInfo = new ReportInfo();
                    int n = rptFlds.size();
                    for (int i = 0; i < n; ++i) {
                        col = rptFlds.get(i).toString();
                        if (col.equalsIgnoreCase("FBillType")) {
                            if (dataType != 1) continue;
                            iType = rs.getInt(col);
                            iMainType = rs.getInt("FMainBillType");
                            billType = iMainType == 1 || iMainType == 2 || iMainType == 9 ? rs.getString("FRecPayType") : this.getBillType(iType, iMainType, ctx.getLocale());
                            rptInfo.put(col, billType);
                            continue;
                        }
                        if (col.equalsIgnoreCase("FBillDate")) {
                            timestamp = (Timestamp)rs.getObject(col);
                            if (timestamp == null) continue;
                            rptInfo.put(col, sdf.format(timestamp));
                            continue;
                        }
                        rptInfo.put(col, rs.getObject(col));
                    }
                    if (dataType == 2) {
                        rptInfo.setIsTotalLine(true);
                        rptInfo.put(balanceCol, null);
                        rptInfo.put(balanceLocalCol, null);
                    } else {
                        rptInfo.put(balanceCol, balance);
                        rptInfo.put(balanceLocalCol, balanceLocal);
                    }
                    dataLst.add(rptInfo);
                    continue;
                }
                if (row <= end) continue;
            }
            rptData = new ArApReportData(dataLst, totalRowCount);
            rptData.setTempTable(param.getTempTable());
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("cussAcctTbl", cussAcctTempTable);
            rptData.setAssistData(dataMap);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"getCAStmtItemData execute sql exception. ", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        return rptData;
    }

    private void addCAItemTotalLine(Context ctx, CAStmtQueryParam param) throws BOSException, EASBizException {
        String res = "com.kingdee.eas.fi.ar.ArReport";
        String endLbl = ResourceBase.getString((String)res, (String)"Lbl_CAItemTotal", (Locale)ctx.getLocale());
        String tempTable = param.getTempTable();
        boolean fCustSupp = param.isCustSupplAcctCuss();
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tempTable);
        sql.append("\r\n (FDescription, FCussAcctId,");
        sql.append(" FCurrencyId, FCurrency, FDebitAmt,FDebitAmtLocal, FCreditAmt,FCreditAmtLocal,");
        sql.append(" FBalanceAmt,FBalanceAmtLocal, FIsFinal, FDataType)\r\n select N'");
        sql.append(endLbl).append("' FDescription, FCussAcctId");
        sql.append(", FCurrencyId,FCurrency, sum(FDebitAmt) FDebitAmt,sum(FDebitAmtLocal) FDebitAmtLocal, ");
        sql.append(" sum(FCreditAmt) FCreditAmt,sum(FCreditAmtLocal) FCreditAmtLocal, ");
        sql.append(" sum(FBalanceAmt)+sum(FDebitAmt)-sum(FCreditAmt) FBalanceAmt,");
        sql.append(" sum(FBalanceAmtLocal)+sum(FDebitAmtLocal)-sum(FCreditAmtLocal) FBalanceAmtLocal,");
        sql.append(" 1 FIsFinal, 2 FDataType\r\n from ");
        sql.append(tempTable).append(" where FIsUseBizCode = 0");
        sql.append(" and FDataType <= 1\r\n");
        sql.append(" group by  FCussAcctId, FCurrencyId, FCurrency");
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection(ctx);
            logger.debug((Object)("caitem sum: \r\n" + sql));
            stmt = con.createStatement();
            stmt.execute(sql.toString());
            if (fCustSupp) {
                sql.delete(0, sql.length());
                sql.append("insert into ").append(tempTable);
                sql.append(" (FDescription, FBizAnalysisCode, ");
                sql.append(" FCurrencyId, FCurrency, FDebitAmt,FDebitAmtLocal, FCreditAmt,FCreditAmtLocal,");
                sql.append(" FBalanceAmt,FBalanceAmtLocal, FIsFinal, FDataType)\r\n select N'");
                sql.append(endLbl).append("' FDescription,  ");
                sql.append(" FBizAnalysisCode, FCurrencyId, FCurrency, ");
                sql.append(" sum(FDebitAmt) FDebitAmt,sum(FDebitAmtLocal) FDebitAmtLocal, ");
                sql.append(" sum(FCreditAmt) FCreditAmt,sum(FCreditAmtLocal) FCreditAmtLocal, ");
                sql.append(" sum(FBalanceAmt)+sum(FDebitAmt)-sum(FCreditAmt) FBalanceAmt,");
                sql.append(" sum(FBalanceAmtLocal)+sum(FDebitAmtLocal)-sum(FCreditAmtLocal) FBalanceAmtLocal,");
                sql.append(" 1 FIsFinal, 2 FDataType\r\n from ");
                sql.append(tempTable);
                sql.append("\r\n where FIsUseBizCode = 1 and FDataType <= 1");
                sql.append("\r\n group by FBizAnalysisCode,");
                sql.append(" FCurrencyId, FCurrency");
                logger.debug((Object)("caItem BizCode CustSupp sum\r\n" + sql));
                stmt.execute(sql.toString());
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"addCAItemTotalLine execute sql exception. ", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
    }

    private void addCAItemTotalLineCopy(Context ctx, CAStmtQueryParam param) throws BOSException, EASBizException {
        String res = "com.kingdee.eas.fi.ar.ArReport";
        String endLbl = ResourceBase.getString((String)res, (String)"Lbl_CAItemTotal", (Locale)ctx.getLocale());
        String tempTable = param.getTempTable();
        boolean fCustSupp = param.isCustSupplAcctCuss();
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tempTable);
        sql.append("\r\n (FDescription, FCussAcctId,");
        sql.append(" FCurrencyId, FCurrency, FDebitAmt,FDebitAmtLocal, FCreditAmt,FCreditAmtLocal,");
        sql.append(" FBalanceAmt,FBalanceAmtLocal, FIsFinal, FDataType)\r\n select N'");
        sql.append(endLbl).append("' FDescription, FCussAcctId");
        sql.append(", FCurrencyId, FCurrency, sum(FDebitAmt) FDebitAmt,sum(FDebitAmtLocal) FDebitAmtLocal, ");
        sql.append(" sum(FCreditAmt) FCreditAmt,sum(FCreditAmtLocal) FCreditAmtLocal, ");
        sql.append(" sum(FBalanceAmt)+sum(FDebitAmt)-sum(FCreditAmt) FBalanceAmt,");
        sql.append(" sum(FBalanceAmtLocal)+sum(FDebitAmtLocal)-sum(FCreditAmtLocal) FBalanceAmtLocal,");
        sql.append(" 1 FIsFinal, 2 FDataType\r\n from ");
        sql.append(tempTable).append(" where FIsUseBizCode = 0");
        sql.append(" and FDataType <= 1\r\n");
        sql.append(" group by  FCussAcctId, FCurrencyId, FCurrency");
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection(ctx);
            logger.debug((Object)("caitem sum: \r\n" + sql));
            stmt = con.createStatement();
            stmt.execute(sql.toString());
            if (fCustSupp) {
                sql.delete(0, sql.length());
                sql.append("insert into ").append(tempTable);
                sql.append(" (FDescription, FBizAnalysisCode, ");
                sql.append(" FCurrencyId, FCurrency, FDebitAmt,FDebitAmtLocal, FCreditAmt,FCreditAmtLocal,");
                sql.append(" FBalanceAmt,FBalanceAmtLocal, FIsFinal, FDataType)\r\n select N'");
                sql.append(endLbl).append("' FDescription,  ");
                sql.append(" FBizAnalysisCode, FCurrencyId, FCurrency, ");
                sql.append(" sum(FDebitAmt) FDebitAmt,sum(FDebitAmtLocal) FDebitAmtLocal, ");
                sql.append(" sum(FCreditAmt) FCreditAmt,sum(FCreditAmtLocal) FCreditAmtLocal, ");
                sql.append(" sum(FBalanceAmt)+sum(FDebitAmt)-sum(FCreditAmt) FBalanceAmt,");
                sql.append(" sum(FBalanceAmtLocal)+sum(FDebitAmtLocal)-sum(FCreditAmtLocal) FBalanceAmtLocal,");
                sql.append(" 1 FIsFinal, 2 FDataType\r\n from ");
                sql.append(tempTable);
                sql.append("\r\n where FIsUseBizCode = 1 and FDataType <= 1");
                sql.append("\r\n group by FBizAnalysisCode, FCurrencyId, FCurrency");
                logger.debug((Object)("caItem BizCode CustSupp sum\r\n" + sql));
                stmt.execute(sql.toString());
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"addCAItemTotalLine execute sql exception. ", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
    }

    private void prepareCAStmtItemRpt(Context ctx, CAStmtQueryParam param) throws BOSException, EASBizException {
        this.putCustSupIdByBizCode2Table(ctx, param);
        String fromNum = param.getAdminOrgFromNum();
        String toNum = param.getAdminOrgToNum();
        if (!StringUtils.isEmpty((String)fromNum) || !StringUtils.isEmpty((String)toNum)) {
            String adminOrgIds = this.getQueryRangeAdminOrgs(ctx, true, fromNum, toNum, param.getCuId());
            if (StringUtils.isEmpty((String)adminOrgIds)) {
                return;
            }
            param.setAdminOrgIds(adminOrgIds);
        }
        Connection con = null;
        Statement stmt = null;
        String tmpTable = TempTableUtil.createTempTable(ctx, this.caItemTempTableDefine());
        TempTablePool t = TempTablePool.getInstance((Context)ctx);
        try {
            t.createIndex(tmpTable, "FCussAcctId, FCurrencyId", false, false);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        try {
            t.createIndex(tmpTable, "FBizAnalysisCode", false, false);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        try {
            con = this.getConnection(ctx);
            param.setTempTable(tmpTable);
            this.insertCAItemStartData(ctx, param);
            stmt = con.createStatement();
            stmt.execute(CaStmtItemSqlBuilder.getRemitCAItemDataSql(ctx, param, true));
            stmt.execute(CaStmtItemSqlBuilder.getRemitCAItemDataSql(ctx, param, false));
            if (param.isCustSupplAcctCuss()) {
                String sql = "update " + tmpTable + " set FIsUseBizCode = 1 where FBizAnalysisCode is not null";
                logger.debug((Object)("set CaItemRpt FIsUseBizCode\r\n" + sql));
                stmt.execute(sql);
                sql = "delete " + tmpTable + " where FIsFinal = 0 and FBizAnalysisCode is not null";
                logger.debug((Object)("del  sql\r\n" + sql));
                stmt.execute(sql);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"arApCAStmtItemData execute sql exception. ", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
        this.addCAItemTotalLineCopy(ctx, param);
        this.addFCussAcctIdToData(ctx, param);
        this.addFGroupNameToData(ctx, param);
        this.removeCastmtBizBalZeroData(ctx, param);
    }

    private void addFGroupNameToData(Context ctx, CAStmtQueryParam param) throws BOSException, EASBizException {
        boolean fCustSupp = param.isCustSupplAcctCuss();
        if (!fCustSupp) {
            return;
        }
        Connection con = null;
        PreparedStatement query_pstmt = null;
        PreparedStatement update_pstmt1 = null;
        PreparedStatement update_pstmt2 = null;
        ResultSet rs = null;
        try {
            StringBuilder updateSql;
            con = this.getConnection(ctx);
            String cussAcctTempTable = param.getCussAcctTempTable();
            StringBuilder querySql = new StringBuilder();
            querySql.append("select FBizAnalysisCode, FId, ");
            querySql.append(" FName_").append(ctx.getLocale()).append(" Fname");
            querySql.append(" from ");
            querySql.append(cussAcctTempTable);
            querySql.append(" order by FId");
            query_pstmt = con.prepareStatement(querySql.toString());
            rs = query_pstmt.executeQuery();
            HashMap<String, String> bizAnalysisCodeGroupMap = new HashMap<String, String>();
            HashMap<String, String> normalGroupMap = new HashMap<String, String>();
            while (rs.next()) {
                String bizAnalysisCode = rs.getString("FBizAnalysisCode");
                if (StringUtils.isEmpty((String)bizAnalysisCode)) {
                    normalGroupMap.put(rs.getString("FId"), rs.getString("FName"));
                    continue;
                }
                if (null == bizAnalysisCodeGroupMap.get(bizAnalysisCode)) {
                    bizAnalysisCodeGroupMap.put(bizAnalysisCode, rs.getString("FName"));
                    continue;
                }
                String newStr = (String)bizAnalysisCodeGroupMap.get(bizAnalysisCode) + "_" + rs.getString("FName");
                bizAnalysisCodeGroupMap.put(bizAnalysisCode, newStr);
            }
            if (!bizAnalysisCodeGroupMap.isEmpty()) {
                updateSql = new StringBuilder();
                updateSql.append("update ").append(cussAcctTempTable);
                updateSql.append(" set FGroupName = ?");
                updateSql.append(" where FBizAnalysisCode = ?");
                update_pstmt1 = con.prepareStatement(updateSql.toString());
                for (Map.Entry entry : bizAnalysisCodeGroupMap.entrySet()) {
                    update_pstmt1.setString(1, (String)entry.getValue());
                    update_pstmt1.setString(2, (String)entry.getKey());
                    update_pstmt1.addBatch();
                }
                update_pstmt1.executeBatch();
            }
            if (!normalGroupMap.isEmpty()) {
                updateSql = new StringBuilder();
                updateSql.append("update ").append(cussAcctTempTable);
                updateSql.append(" set FGroupName = ?");
                updateSql.append(" where FId = ?");
                update_pstmt2 = con.prepareStatement(updateSql.toString());
                for (Map.Entry entry : normalGroupMap.entrySet()) {
                    update_pstmt2.setString(1, (String)entry.getValue());
                    update_pstmt2.setString(2, (String)entry.getKey());
                    update_pstmt2.addBatch();
                }
                update_pstmt2.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"addFCussAcctIdToData execute sql exception. ", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, query_pstmt, (Connection)con);
                SQLUtils.cleanup(update_pstmt1);
                SQLUtils.cleanup(update_pstmt2);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)query_pstmt, (Connection)con);
        SQLUtils.cleanup(update_pstmt1);
        SQLUtils.cleanup(update_pstmt2);
    }

    private void addFCussAcctIdToData(Context ctx, CAStmtQueryParam param) throws BOSException, EASBizException {
        String tempTable = param.getTempTable();
        boolean fCustSupp = param.isCustSupplAcctCuss();
        if (!fCustSupp) {
            return;
        }
        Connection con = null;
        PreparedStatement query_pstmt = null;
        PreparedStatement update_pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            String cussAcctTempTable = param.getCussAcctTempTable();
            StringBuilder querySql = new StringBuilder();
            querySql.append("select FBizAnalysisCode, FId from ").append(cussAcctTempTable);
            querySql.append(" where FBizAnalysisCode is not null");
            querySql.append(" order by FId");
            query_pstmt = con.prepareStatement(querySql.toString());
            rs = query_pstmt.executeQuery();
            HashMap<String, String> groupMap = new HashMap<String, String>();
            while (rs.next()) {
                if (null != groupMap.get(rs.getString("FBizAnalysisCode"))) continue;
                groupMap.put(rs.getString("FBizAnalysisCode"), rs.getString("FId"));
            }
            if (!groupMap.isEmpty()) {
                StringBuilder updateSql = new StringBuilder();
                updateSql.append("update ").append(tempTable);
                updateSql.append(" set FCussAcctId = ?");
                updateSql.append(" where FBizAnalysisCode = ?");
                update_pstmt = con.prepareStatement(updateSql.toString());
                for (Map.Entry entry : groupMap.entrySet()) {
                    update_pstmt.setString(1, (String)entry.getValue());
                    update_pstmt.setString(2, (String)entry.getKey());
                    update_pstmt.addBatch();
                }
                update_pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"addFCussAcctIdToData execute sql exception. ", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, query_pstmt, (Connection)con);
                SQLUtils.cleanup(update_pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)query_pstmt, (Connection)con);
        SQLUtils.cleanup(update_pstmt);
    }

    private void insertCAItemStartData(Context ctx, CAStmtQueryParam param) throws BOSException, EASBizException, SQLException {
        String nameFld = ArApReportHelper.getNameFld(ctx);
        PeriodInfo startArCountPeriod = ArApReportHelper.getPeriodStartToCount(ctx, param, true);
        PeriodInfo startApCountPeriod = ArApReportHelper.getPeriodStartToCount(ctx, param, false);
        Connection con = null;
        Statement stmt = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.createStatement();
            String initSql = this.caItemStartInsertSql(ctx, param);
            logger.debug((Object)("caItem insertStart sql: \r\n" + initSql));
            stmt.execute(initSql);
            StringBuffer sql = new StringBuffer();
            if (param.getAllAmtLoc() == 1) {
                sql.append("select tSum.FCussAcctId, N'' FCurrencyId, N'' FCurrency,");
            } else {
                sql.append("select tSum.FCussAcctId, t2.FId FCurrencyId, t2.");
                sql.append(nameFld).append(" FCurrency, ");
            }
            sql.append("sum(tSum.FAmt) FBalanceAmt,sum(tSum.FAmtLocal) FBalanceAmtLocal\r\n from (\r\n");
            sql.append(CaStmtItemSqlBuilder.getCAItemStartSql(param, startArCountPeriod, startApCountPeriod));
            sql.append("\r\n) tSum left join t_bd_Currency t2 on ");
            sql.append("tSum.FCurrencyId = t2.FId \r\n");
            if (param.getAllAmtLoc() == 1) {
                sql.append(" group by tSum.FCussAcctId ");
            } else {
                sql.append(" group by tSum.FCussAcctId, ");
                sql.append("t2.FId, t2.").append(nameFld);
            }
            logger.debug((Object)("caItem start balance sql:\r\n" + sql));
            rs = stmt.executeQuery(sql.toString());
            StringBuffer uSql = new StringBuffer();
            uSql.append("update ").append(param.getTempTable());
            uSql.append(" set FBalanceAmt = ?,FBalanceAmtLocal = ? where FCurrency = ? ");
            uSql.append(" and FCurrencyId = ? and FCussAcctId = ?");
            pstmt = con.prepareStatement(uSql.toString());
            boolean fBatch = false;
            while (rs.next()) {
                pstmt.setBigDecimal(1, rs.getBigDecimal(4));
                pstmt.setBigDecimal(2, rs.getBigDecimal(5));
                pstmt.setString(3, rs.getString(3));
                pstmt.setString(4, rs.getString(2));
                pstmt.setString(5, rs.getString(1));
                pstmt.addBatch();
                fBatch = true;
            }
            if (fBatch) {
                pstmt.executeBatch();
            }
            if (param.isCustSupplAcctCuss()) {
                sql.delete(0, sql.length());
                sql.append(" insert into ").append(param.getTempTable());
                sql.append("\r\n (FBizAnalysisCode, FCurrencyId,");
                sql.append("FCurrency, FBillDate, FDescription, ");
                sql.append("FBalanceAmt,FBalanceAmtLocal, FIsFinal, FDataType)\r\n select ");
                if (param.getAllAmtLoc() == 1) {
                    sql.append("FBizAnalysisCode,N'', ");
                    sql.append(" N'', FBillDate, FDescription, ");
                } else {
                    sql.append("FBizAnalysisCode,FCurrencyId, ");
                    sql.append(" FCurrency, FBillDate, FDescription, ");
                }
                sql.append(" sum(FBalanceAmt) FBalanceAmt,sum(FBalanceAmtLocal) FBalanceAmtLocal,");
                sql.append(" 1 FIsFinal, 0 FDataType ");
                sql.append("\r\n from ").append(param.getTempTable());
                sql.append("\r\n where FBizAnalysisCode is not null ");
                sql.append(" and FDataType = 0\r\n group by");
                if (param.getAllAmtLoc() == 1) {
                    sql.append(" FBizAnalysisCode, ");
                } else {
                    sql.append(" FBizAnalysisCode, FCurrencyId, FCurrency,");
                }
                sql.append(" FBillDate, FDescription");
                logger.debug((Object)("sum the init data with bizCode\r\n" + sql));
                stmt.execute(sql.toString());
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"insertCAItemStartBalance execute sql exception. ", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
    }

    private String caItemStartInsertSql(Context ctx, CAStmtQueryParam param) {
        String res = "com.kingdee.eas.fi.ar.ArReport";
        String startLbl = ResourceBase.getString((String)res, (String)"Lbl_CAItemStart", (Locale)ctx.getLocale());
        String nameFld = ArApReportHelper.getNameFld(ctx);
        boolean fCusSupp = param.isCustSupplAcctCuss();
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer sql = new StringBuffer(100);
        sql.append("insert into ").append(param.getTempTable());
        sql.append("\r\n (").append(fCusSupp ? "FBizAnalysisCode," : "");
        sql.append("FCussAcctId, FCurrencyId, FCurrency, FBillDate, ");
        sql.append("FDescription, FIsFinal, FDataType)\r\n select ");
        sql.append(fCusSupp ? "t3.FBizAnalysisCode," : "");
        sql.append(" t3.FId as FCussAcctId, t2.FId FCurrencyId, t2.");
        sql.append(nameFld).append(" FCurrency, {");
        sql.append(dtFormat.format(param.getBeginDate()));
        sql.append("} FBillDate, N'").append(startLbl);
        sql.append("' FDescription, 0 FIsFinal, 0 FDataType ");
        sql.append("\r\n from t_bd_currency as");
        sql.append(" t2\r\n cross join ").append(param.getCussAcctTempTable());
        sql.append(" as t3\r\n where 1= 1 ");
        if (param.isAllCurrency()) {
            sql.append(" and (t2.FId != '");
            sql.append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
            sql.append("' and t2.FId != '");
            sql.append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
            sql.append("') ");
        } else {
            sql.append(" and t2.FId = '");
            sql.append(param.getCurrencyId()).append("' ");
        }
        return sql.toString();
    }

    private void removeCastmtBizBalZeroData(Context ctx, CAStmtQueryParam param) throws BOSException {
        if (!param.isBizZero() && !param.isBalZero()) {
            return;
        }
        Connection cn = null;
        PreparedStatement pstmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        int allAmt = param.getAllAmtLoc();
        String tempTable = param.getTempTable();
        boolean fItemRpt = param.isItemRpt();
        boolean fCustSupp = param.isCustSupplAcctCuss();
        StringBuffer delSql = new StringBuffer();
        if (fItemRpt) {
            delSql.append("delete from ").append(tempTable);
            if (allAmt == 1) {
                delSql.append(" where FCurrencyLocal = ? and (");
            } else {
                delSql.append(" where FCurrencyId = ? and (");
            }
            delSql.append(" FCussAcctId = ? ");
            if (fCustSupp) {
                delSql.append(" or FBizAnalysisCode = ?");
            }
            delSql.append(" )");
        } else {
            delSql.append("delete from ").append(tempTable);
            if (allAmt == 1) {
                delSql.append(" where FCurrencyLocal = ? and FCussNum = ? ");
            } else {
                delSql.append(" where FCurrency = ? and FCussNum = ? ");
            }
            delSql.append(" and FIsFinal = 1");
        }
        String sql = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.createStatement();
            boolean fBatch = false;
            if (param.isBizZero()) {
                logger.debug((Object)("del the bizAmt zero: \r\n" + delSql));
                pstmt = cn.prepareStatement(delSql.toString());
                sql = allAmt == 1 ? (fItemRpt ? "select distinct FCurrencyLocal, FCussAcctId " + (fCustSupp ? ", FBizAnalysisCode from " : " from ") + tempTable + "\r\n where FDebitAmt = 0  and FCreditAmt = 0 and FDataType = 2" : "select distinct FCurrencyLocal, FCussNum from " + tempTable + "\r\n where FDebitAmt = 0  and FCreditAmt = 0 and FIsFinal = 1") : (fItemRpt ? "select distinct FCurrencyId, FCussAcctId " + (fCustSupp ? ", FBizAnalysisCode from " : " from ") + tempTable + "\r\n where FDebitAmt = 0  and FCreditAmt = 0 and FDataType = 2" : "select distinct FCurrency, FCussNum from " + tempTable + "\r\n where FDebitAmt = 0  and FCreditAmt = 0 and FIsFinal = 1");
                logger.debug((Object)("select the bizAmt zero: \r\n" + sql));
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    pstmt.setString(1, rs.getString(1));
                    pstmt.setString(2, rs.getString(2));
                    if (fItemRpt && fCustSupp) {
                        pstmt.setString(3, rs.getString(3));
                    }
                    pstmt.addBatch();
                    fBatch = true;
                }
                if (fBatch) {
                    pstmt.executeBatch();
                }
            }
            if (param.isBalZero()) {
                fBatch = false;
                logger.debug((Object)("del the bal zero sql: \r\n" + delSql));
                pstmt = cn.prepareStatement(delSql.toString());
                sql = allAmt == 1 ? (fItemRpt ? "select distinct FCurrencyLocal, FCussAcctId" + (fCustSupp ? ", FBizAnalysisCode from " : " from ") + tempTable + "\r\n where FDataType = 2 and FBalanceAmt = 0" : "select distinct FCurrencyLocal, FCussNum from " + tempTable + " where (FStartBalanceAmt + FDebitAmt -FCreditAmt) = 0 and FIsFinal =1") : (fItemRpt ? "select distinct FCurrencyId, FCussAcctId" + (fCustSupp ? ", FBizAnalysisCode from " : " from ") + tempTable + "\r\n where FDataType = 2 and FBalanceAmt = 0" : "select distinct FCurrency, FCussNum from " + tempTable + " where (FStartBalanceAmt + FDebitAmt -FCreditAmt) = 0 and FIsFinal =1");
                logger.debug((Object)("select the bal zero: \r\n" + sql));
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    pstmt.setString(1, rs.getString(1));
                    pstmt.setString(2, rs.getString(2));
                    if (fItemRpt && fCustSupp) {
                        pstmt.setString(3, rs.getString(3));
                    }
                    pstmt.addBatch();
                    fBatch = true;
                }
                if (fBatch) {
                    pstmt.executeBatch();
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"error happened while del the useless data", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(pstmt);
            SQLUtils.cleanup(rs, (Statement)stmt, (Connection)cn);
        }
    }

    @Override
    protected IReportData _getARCAStmtReport(Context ctx, IReportQueryParam filterParam) throws BOSException, EASBizException {
        CAStmtQueryParam param = (CAStmtQueryParam)filterParam;
        this.checkValid(param);
        param.setIsArRpt(true);
        return this.getCAStmtRpt(ctx, filterParam);
    }

    private IReportData getCAStmtRpt(Context ctx, IReportQueryParam filterParam) throws BOSException, EASBizException {
        CAStmtQueryParam param = (CAStmtQueryParam)filterParam;
        if (param.getBeginDate() == null || param.getEndDate() == null || param.getBeginDate().after(param.getEndDate())) {
            throw new ArApCommonException(ArApCommonException.DATERANGE_INVALID);
        }
        SystemEnum sysEnum = param.isArRpt() ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)sysEnum, (IObjectPK)new ObjectUuidPK(param.getCompanyId()));
        if (startPeriod == null) {
            throw new ArApCommonException(param.isArRpt() ? ArApCommonException.AR_STARTPERIOD_NULL : ArApCommonException.AP_STARTPERIOD_NULL);
        }
        if (param.getBeginDate().before(startPeriod.getBeginDate())) {
            throw new ArApCommonException(ArApCommonException.DATE_NOT_IN_PERIOD);
        }
        String tempTable = param.getTempTable();
        if (StringUtils.isEmpty((String)tempTable)) {
            java.sql.Date endDate = param.getEndDate();
            endDate.setTime(endDate.getTime() + 86400000L);
            param.setEndDate(endDate);
            this.prepareCAStmtRpt(ctx, param);
        }
        IReportData rptData = this.getCAStmtData(ctx, param);
        return rptData;
    }

    private void prepareCAStmtRpt(Context ctx, CAStmtQueryParam param) throws BOSException, EASBizException {
        this.putCustSupIdByBizCode2Table(ctx, param);
        boolean fCusSupp = param.isCustSupplAcctCuss();
        String tmpTable = TempTableUtil.createTempTable(ctx, this.caStmtTempTableDefine(fCusSupp));
        param.setTempTable(tmpTable);
        String fromNum = param.getAdminOrgFromNum();
        String toNum = param.getAdminOrgToNum();
        if (!StringUtils.isEmpty((String)fromNum) || !StringUtils.isEmpty((String)toNum)) {
            String adminOrgIds = this.getQueryRangeAdminOrgs(ctx, true, fromNum, toNum, param.getCuId());
            if (StringUtils.isEmpty((String)adminOrgIds)) {
                return;
            }
            param.setAdminOrgIds(adminOrgIds);
        }
        this.addCaStmtStartData(ctx, param);
        this.insertCAStmtData(ctx, param);
        if (fCusSupp) {
            AsstActTypeInfo qryCussType = param.getCussAcctTypeInfo();
            this.mergeDataWithSameBizCode(ctx, tmpTable, qryCussType, false);
        }
        String currencyLocal = this.selectCurrencyLocal(ctx, param);
        this.sumCAStmtRptData(ctx, tmpTable, fCusSupp, currencyLocal, param);
        this.removeCastmtBizBalZeroData(ctx, param);
        this.sumCAStmtRptDataByCurrency(ctx, tmpTable, currencyLocal);
    }

    private String selectCurrencyLocal(Context ctx, CAStmtQueryParam param) throws BOSException {
        String com = param.getCompanyId();
        String name = "";
        if (com != null && !"".equalsIgnoreCase(com)) {
            String sql = "select T_BD_Currency.Fname_l2 name from T_ORG_Company T_ORG_Company LEFT JOIN T_BD_Currency T_BD_Currency  ON T_ORG_Company.FBaseCurrencyID=T_BD_Currency.FID where T_ORG_Company.FID='" + com + "'";
            Connection con = null;
            Statement stmt = null;
            ResultSet rs = null;
            con = this.getConnection(ctx);
            try {
                stmt = con.createStatement();
                rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    name = rs.getString("name");
                }
            }
            catch (SQLException e) {
                logger.error((Object)"prepare ar/ap contrast gl rpt ", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Statement)stmt, (Connection)con);
            }
        }
        return name;
    }

    private void mergeDataWithSameBizCode(Context ctx, String tmpTable, AsstActTypeInfo qryCussType, boolean fItemRpt) throws BOSException, EASBizException {
        BOSUuid qryCussTypeId = qryCussType.getId();
        StringBuilder sql = new StringBuilder(200);
        Connection con = null;
        Statement qryStmt = null;
        Statement pstmt = null;
        IRowSet rs = null;
        try {
            con = this.getConnection(ctx);
            sql.append(" select distinct FCussNum, FCussName,");
            sql.append(" FCussAcctId, FBizAnalysisCode from ");
            sql.append(tmpTable).append("\r\n where FCussTypeId = '");
            sql.append(qryCussTypeId).append("' and FBizAnalysisCode is not null");
            sql.append("\r\n order by FBizAnalysisCode asc, FCussNum desc ");
            logger.debug((Object)("mergeData sameBizCode, selectAsstAcct, bizCode Sql: \r\n" + sql));
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            sql.delete(0, sql.length());
            sql.append("update ").append(tmpTable);
            sql.append(" set FCussNum = ?, FCussName = ?, ");
            sql.append("FCussAcctId = ? where FCussTypeId != ? and ");
            sql.append(" FBizAnalysisCode = ?");
            logger.debug((Object)("mergeData sameBizCode sql: \r\n" + sql));
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            Object[] params = null;
            while (rs.next()) {
                logger.debug((Object)("mergeData sameBizCode sqlParam: \r\n" + rs.getString(1) + ", " + rs.getString(2) + ", " + rs.getString(3) + ", " + rs.getString(4)));
                params = new Object[]{rs.getString(1), rs.getString(2), rs.getString(3), qryCussTypeId.toString(), rs.getString(4)};
                paramsList.add(params);
            }
            DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
            sql.delete(0, sql.length());
            sql.append("update ").append(tmpTable).append(" set");
            sql.append(" FCussType = ?, FCussTypeId = ?");
            sql.append(" where FCussTypeId != ?");
            logger.debug((Object)("mergeData sameBizCode, setCussType Id Sql&Param: \r\n" + sql + "\r\n" + qryCussType.getName() + ", " + qryCussTypeId));
            params = new Object[]{qryCussType.getName(), qryCussTypeId.toString(), qryCussTypeId.toString()};
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"mergeDataWithSameBizCodeException ", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup(rs, qryStmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup(pstmt);
        SQLUtils.cleanup((ResultSet)rs, qryStmt, (Connection)con);
    }

    private void sumCAStmtRptData(Context ctx, String tmpTable, boolean fCusSupp, String currencyLocal, CAStmtQueryParam param) throws BOSException {
        int allamt = param.getAllAmtLoc();
        StringBuilder sql = new StringBuilder(500);
        sql.append(" insert into ").append(tmpTable);
        sql.append("(").append(fCusSupp ? "FBizAnalysisCode," : "");
        sql.append(" FCussTypeId, FCussType, FCussNum, FCussName,");
        sql.append(" FCussAcctId, FCurrency, FCurrencyLocal, FCurrencyId,");
        sql.append(" FStartBalanceAmt, FStartBalanceAmtLocal, FDebitAmt, FDebitAmtLocal, FCreditAmt, FCreditAmtLocal,");
        sql.append(" FBalanceAmt, FBalanceAmtLocal, FIsFinal) \r\nselect ");
        sql.append(fCusSupp ? "FBizAnalysisCode," : "");
        sql.append("FCussTypeId, FCussType, FCussNum, FCussName,");
        if (allamt == 1) {
            sql.append(" FCussAcctId, N'' FCurrency, '" + currencyLocal + "' FCurrencyLocal, N'' FCurrencyId,\r\n");
        } else {
            sql.append(" FCussAcctId, FCurrency, '" + currencyLocal + "' FCurrencyLocal, FCurrencyId,\r\n");
        }
        sql.append(" sum(FStartBalanceAmt) FStartBalanceAmt, sum(FStartBalanceAmtLocal) FStartBalanceAmtLocal,");
        sql.append(" sum(FDebitAmt) FDebitAmt, sum(FDebitAmtLocal) FDebitAmtLocal, ");
        sql.append(" sum(FCreditAmt) FCreditAmt, sum(FCreditAmtLocal) FCreditAmtLocal, ");
        sql.append(" sum(FBalanceAmt) FBalanceAmt, sum(FBalanceAmtLocal) FBalanceAmtLocal, 1 FIsFinal\r\n from ");
        sql.append(tmpTable).append("\r\n group by ");
        sql.append(fCusSupp ? "FBizAnalysisCode," : "");
        sql.append(" FCussTypeId, FCussType,");
        if (allamt == 1) {
            sql.append(" FCussNum,FCussName, FCussAcctId");
        } else {
            sql.append(" FCussNum,FCussName, FCussAcctId,");
            sql.append(" FCurrency, FCurrencyId ");
        }
        logger.debug((Object)("final sql: \r\n" + sql));
        DbUtil.execute((Context)ctx, (String)sql.toString());
        if (!fCusSupp) {
            return;
        }
        sql.delete(0, sql.length());
        sql.append(" update ").append(tmpTable).append(" as t1");
        sql.append("\r\n set (FStartBalanceAmt, FStartBalanceAmtLocal, FDebitAmt, FDebitAmtLocal, ");
        sql.append("FCreditAmt, FCreditAmtLocal, FBalanceAmt, FBalanceAmtLocal) = (  \r\n");
        sql.append("   select distinct t3.FStartBalanceAmt, t3.FStartBalanceAmtLocal, t3.FDebitAmt, t3.FDebitAmtLocal, ");
        sql.append("t3.FCreditAmt, t3.FCreditAmtLocal, t3.FBalanceAmt, t3.FBalanceAmtLocal \r\n");
        sql.append("   from ").append(tmpTable).append(" as t2,\r\n");
        if (allamt == 1) {
            sql.append("    (select FBizAnalysisCode, FCurrencyLocal, ");
        } else {
            sql.append("    (select FBizAnalysisCode, FCurrencyId, ");
        }
        sql.append("sum(FStartBalanceAmt) FStartBalanceAmt, sum(FStartBalanceAmtLocal) FStartBalanceAmtLocal, ");
        sql.append("sum(FDebitAmt) FDebitAmt, sum(FDebitAmtLocal) FDebitAmtLocal, ");
        sql.append("sum(FCreditAmt) FCreditAmt, sum(FCreditAmtLocal) FCreditAmtLocal, sum(FBalanceAmt) FBalanceAmt, sum(FBalanceAmtLocal) FBalanceAmtLocal");
        sql.append("\r\n    from ").append(tmpTable).append(" as t2\r\n");
        sql.append("     where t2.FIsFinal = 1 and t2.FBizAnalysisCode is ");
        if (allamt == 1) {
            sql.append("not null\r\n    group by FBizAnalysisCode, FCurrencyLocal");
        } else {
            sql.append("not null\r\n    group by FBizAnalysisCode, FCurrencyId");
        }
        sql.append("    ) as t3 where t2.FBizAnalysisCode = ");
        if (allamt == 1) {
            sql.append(" t3.FBizAnalysisCode and t2.FCurrencyLocal = t3.FCurrencyLocal");
        } else {
            sql.append(" t3.FBizAnalysisCode and t2.FCurrencyId = t3.FCurrencyId");
        }
        sql.append(" and t2.FIsFinal = 1 ");
        sql.append(" and t1.FBizAnalysisCode = t2.FBizAnalysisCode ");
        if (allamt == 1) {
            sql.append(" and t1.FCurrencyLocal = t2.FCurrencyLocal ");
        } else {
            sql.append(" and t1.FCurrencyId = t2.FCurrencyId ");
        }
        sql.append(")\r\n where t1.FIsFinal = 1 ");
        logger.debug((Object)("merge bizCode Amt sql: \r\n" + sql));
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void sumCAStmtRptDataByCurrency(Context ctx, String tmpTable, String currencyLocal) throws BOSException {
        String sumLbl = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport.Lbl_Sum", (Locale)ctx.getLocale());
        StringBuilder sql = new StringBuilder(300).append(" insert into ").append(tmpTable).append("( FCussNum, FCurrency, FCurrencyLocal, FCurrencyId, FStartBalanceAmt, FStartBalanceAmtLocal, ").append(CTRL).append("FDebitAmt, FDebitAmtLocal, FCreditAmt, FCreditAmtLocal, FBalanceAmt, FBalanceAmtLocal, FIsFinal, ").append(FIELD_IS_SUM).append(")").append(CTRL).append("select '").append(sumLbl).append("' FCussNum, FCurrency, '" + currencyLocal + "' FCurrencyLocal,  FCurrencyId,").append(" sum(FStartBalanceAmt) FStartBalanceAmt, sum(FStartBalanceAmtLocal) FStartBalanceAmtLocal,").append(" sum(FDebitAmt) FDebitAmt, sum(FDebitAmtLocal) FDebitAmtLocal, ").append(" sum(FCreditAmt) FCreditAmt, sum(FCreditAmtLocal) FCreditAmtLocal, ").append(" sum(FBalanceAmt) FBalanceAmt, sum(FBalanceAmtLocal) FBalanceAmtLocal, 1 FIsFinal, 1 ").append(FIELD_IS_SUM).append(CTRL).append(" from ").append(tmpTable).append(CTRL).append(" where FIsFinal = 1 ").append(" group by FCurrency, FCurrencyId ");
        logger.debug((Object)("sumCAStmtRptDataByCurrency sql: \r\n" + sql));
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void addCaStmtStartData(Context ctx, CAStmtQueryParam param) throws BOSException {
        String nameFld = ArApReportHelper.getNameFld(ctx);
        String tmpAcctTbl = param.getCussAcctTempTable();
        boolean fCusSupp = param.isCustSupplAcctCuss();
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(param.getTempTable());
        sql.append("(").append(fCusSupp ? "FBizAnalysisCode," : "");
        sql.append("FCussTypeId, FCussType, FCussNum, FCussName,");
        sql.append(" FCussAcctId, FCurrency, FCurrencyId) \r\n select ");
        sql.append(fCusSupp ? "t1.FBizAnalysisCode," : "");
        sql.append(" t2.FId FCussTypeId, t2.").append(nameFld);
        sql.append(" FCussType, t1.FNumber FCussNum,\r\n t1.");
        sql.append(nameFld).append(" FCussName, t1.FId FCussAcctId, t3.");
        sql.append(nameFld).append(" FCurrency, t3.FId FCurrencyId\r\n from ");
        sql.append(tmpAcctTbl).append(" t1, t_bd_AsstActType t2,");
        sql.append(" t_bd_currency t3\r\n where t2.FId = '");
        sql.append(param.getCussTypeId()).append("' ");
        sql.append("and t1.FIsByBizCode = 0 ");
        if (param.isAllCurrency()) {
            sql.append(" and (t3.FId != '");
            sql.append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
            sql.append("' and t3.FId != '");
            sql.append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
            sql.append("') ");
        } else {
            sql.append(" and  t3.FId = '").append(param.getCurrencyId());
            sql.append("' ");
        }
        logger.debug((Object)("castmt init BizCurrency sql: \r\n" + sql));
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String caStmtTempTableDefine(boolean fCusSupp) {
        StringBuilder sql = new StringBuilder(200);
        sql.append(" (");
        if (fCusSupp) {
            sql.append("FBizAnalysisCode nvarchar(80), ");
        }
        sql.append(" FCussTypeId varchar(44), ");
        sql.append(" FCussType nvarchar(200), ");
        sql.append(" FCussNum nvarchar(100), ");
        sql.append(" FCussName nvarchar(400), ");
        sql.append(" FCussAcctId varchar(44), ");
        sql.append(" FCurrency nvarchar(200), ");
        sql.append(" FCurrencyLocal nvarchar(200), ");
        sql.append(" FCurrencyId varchar(44), ");
        sql.append(" FStartBalanceAmt decimal(28, 10) NOT NULL DEFAULT 0, ");
        sql.append(" FStartBalanceAmtLocal decimal(28, 10) NOT NULL DEFAULT 0, ");
        sql.append(" FDebitAmt  decimal(28, 10) NOT NULL DEFAULT 0, ");
        sql.append(" FDebitAmtLocal  decimal(28, 10) NOT NULL DEFAULT 0, ");
        sql.append(" FCreditAmt  decimal(28, 10) NOT NULL DEFAULT 0, ");
        sql.append(" FCreditAmtLocal  decimal(28, 10) NOT NULL DEFAULT 0, ");
        sql.append(" FBalanceAmt decimal(28, 10) NOT NULL DEFAULT 0,");
        sql.append(" FBalanceAmtLocal decimal(28, 10) NOT NULL DEFAULT 0,");
        sql.append(" FIsFinal int NOT NULL DEFAULT 0,").append(" ").append(FIELD_IS_SUM).append(" int default 0").append(" ) ");
        return sql.toString();
    }

    private String caItemTempTableDefine() {
        StringBuffer sql = new StringBuffer();
        sql.append(" (FBillId varchar(44), ");
        sql.append("FBizAnalysisCode nvarchar(80), ");
        sql.append(" FIsUseBizCode int default 0, ");
        sql.append(" FCussAcctId varchar(44), ");
        sql.append(" FCurrencyId varchar(44), ");
        sql.append(" FCurrencyLocalId varchar(44), ");
        sql.append(" FCurrency nvarchar(100), ");
        sql.append(" FCurrencyLocal nvarchar(100), ");
        sql.append(" FBillDate dateTime, ");
        sql.append(" FBillType int DEFAULT -1, ");
        sql.append(" FRecPayType nvarchar(100), ");
        sql.append(" FBillNum nvarchar(100), ");
        sql.append(" FVoucherType nvarchar(100), ");
        sql.append(" FVoucherNum nvarchar(100), ");
        sql.append(" FDescription nvarchar(255), ");
        sql.append(" FDebitAmt decimal(28, 10) NOT NULL DEFAULT 0, ");
        sql.append(" FDebitAmtLocal decimal(28, 10) NOT NULL DEFAULT 0, ");
        sql.append(" FCreditAmt decimal(28, 10) NOT NULL DEFAULT 0, ");
        sql.append(" FCreditAmtLocal decimal(28, 10) NOT NULL DEFAULT 0, ");
        sql.append(" FBalanceAmt decimal(28, 10) NOT NULL DEFAULT 0, ");
        sql.append(" FBalanceAmtLocal decimal(28, 10) NOT NULL DEFAULT 0, ");
        sql.append(" FMainBillType int NOT NULL DEFAULT -1, ");
        sql.append(" FIsFinal int default 1, ");
        sql.append(" FDataType int)");
        return sql.toString();
    }

    @Override
    protected IReportData _getAPCAStmtReport(Context ctx, IReportQueryParam filterParam) throws BOSException, EASBizException {
        CAStmtQueryParam param = (CAStmtQueryParam)filterParam;
        this.checkValid(param);
        param.setIsArRpt(false);
        return this.getCAStmtRpt(ctx, filterParam);
    }

    private String getQueryRangeAdminOrgs(Context ctx, boolean fAllCuAdmin, String fromNum, String toNum, String cuId) throws BOSException, EASBizException {
        MetaDataPK cussQryPK = MetaDataPK.create((String)"com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)cussQryPK);
        exec.setObjectView(this.getAdminRangeView(fAllCuAdmin, fromNum, toNum, cuId));
        boolean fBlank = StringUtils.isEmpty((String)fromNum) && StringUtils.isEmpty((String)toNum) || StringUtils.isEmpty((String)fromNum);
        String tbl = this.putIds2Table(ctx, exec.getSQL(), "adminOrgRange", fBlank);
        return " select fid from " + tbl;
    }

    private EntityViewInfo getAdminRangeView(boolean fAllCuAdmin, String fromNum, String toNum, String cuId) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().add("id");
        view.getSelector().add("name");
        view.getSelector().add("number");
        if (!StringUtils.isEmpty((String)fromNum)) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)fromNum, CompareType.GREATER_EQUALS));
        }
        if (!StringUtils.isEmpty((String)toNum)) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)toNum, CompareType.LESS_EQUALS));
        }
        if (!fAllCuAdmin) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuId));
        }
        return view;
    }

    @Override
    protected IReportData _getARItemReport(Context ctx, IReportQueryParam filterParam) throws BOSException, EASBizException {
        ItemRptQueryParam param = (ItemRptQueryParam)filterParam;
        this.checkItemRptParam(param);
        param.setIsArRpt(true);
        return this.getArApItemRpt(ctx, param);
    }

    @Override
    protected IReportData _getAPItemReport(Context ctx, IReportQueryParam filterParam) throws BOSException, EASBizException {
        ItemRptQueryParam param = (ItemRptQueryParam)filterParam;
        this.checkItemRptParam(param);
        param.setIsArRpt(false);
        return this.getArApItemRpt(ctx, param);
    }

    @Override
    protected ArApReportTreeData _getARItemRptTreeData(Context ctx, IReportQueryParam filterParam) throws BOSException, EASBizException {
        ItemRptQueryParam param = (ItemRptQueryParam)filterParam;
        this.checkItemRptParam(param);
        param.setIsArRpt(true);
        return this.getArApItemRptTreeData(ctx, param);
    }

    @Override
    protected ArApReportTreeData _getAPItemRptTreeData(Context ctx, IReportQueryParam filterParam) throws BOSException, EASBizException {
        ItemRptQueryParam param = (ItemRptQueryParam)filterParam;
        this.checkItemRptParam(param);
        param.setIsArRpt(false);
        return this.getArApItemRptTreeData(ctx, param);
    }

    private ArApReportTreeData getArApItemRptTreeData(Context ctx, ItemRptQueryParam param) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)param.getTempTable())) {
            this.prepareArApItemRpt(ctx, param);
        }
        String treeDataTbl = null;
        boolean fSumByCussAcct = param.isSumByCussAcct();
        if (fSumByCussAcct) {
            treeDataTbl = param.getCussAcctTempTable();
        } else if (param.isSumByDept()) {
            treeDataTbl = param.getAdminOrgTempTable();
        } else if (param.isSumByPerson()) {
            treeDataTbl = param.getPersonTempTable();
        }
        StringBuffer sql = new StringBuffer("");
        String nameFld = ArApReportHelper.getNameFld(ctx);
        sql.append("select TOP ").append(param.getTreeFetchRowCount()).append(" t1.fid id,");
        if (fSumByCussAcct) {
            sql.append(" t1.").append(nameFld).append(" name ");
        } else {
            sql.append(" case when t1.");
            sql.append(nameFld).append(" is null then N'");
            sql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport.Lbl_blank", (Locale)ctx.getLocale()));
            sql.append("' else t1.");
            sql.append(nameFld).append(" end name ");
        }
        sql.append("\r\n from ");
        sql.append(treeDataTbl);
        sql.append(" t1\r\n ");
        sql.append(" WHERE EXISTS (SELECT 1 FROM ").append(param.getTempTable());
        sql.append(" t2 WHERE t1.FID = t2.");
        if (fSumByCussAcct) {
            sql.append("FCussAcctId");
        } else if (param.isSumByDept()) {
            sql.append("FAdminOrgId");
        } else if (param.isSumByPerson()) {
            sql.append("FPersonId");
        }
        sql.append(")");
        sql.append("\r\n order by t1.FNumber ");
        logger.debug((Object)("treeData sql: \r\n" + sql));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        IRowSet result = null;
        if (param.isDoExpand()) {
            int rowCount = 0;
            try {
                while (rs.next()) {
                    ++rowCount;
                }
                if (rowCount > param.getTreeFetchRowCount() - param.getTreeFetchSize()) {
                    result = new JdbcRowSet();
                    rs.beforeFirst();
                    result.populate((ResultSet)rs, param.getTreeFetchRowCount() - param.getTreeFetchSize(), param.getTreeFetchSize(), true);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        ArApReportTreeData treeData = new ArApReportTreeData();
        treeData.setTempTable(param.getTempTable());
        treeData.setAssistTempTable(treeDataTbl);
        treeData.setRowSet(param.isDoExpand() ? result : rs);
        return treeData;
    }

    private IReportData getArApItemRpt(Context ctx, ItemRptQueryParam param) throws BOSException, EASBizException {
        String tempTable = param.getTempTable();
        if (StringUtils.isEmpty((String)tempTable)) {
            this.prepareArApItemRpt(ctx, param);
        }
        IReportData rptData = this.getArApItemData(ctx, param);
        return rptData;
    }

    private void checkItemRptParam(ItemRptQueryParam param) throws BOSException, EASBizException {
        this.checkValid((ArApQueryParam)param);
        if (param.getBeginDate() == null || param.getEndDate() == null || param.getBeginDate().after(param.getEndDate())) {
            logger.error((Object)"the date range has not specified or invalid.");
            throw new ArApCommonException(ArApCommonException.DATERANGE_INVALID);
        }
    }

    private void prepareArApItemRpt(Context ctx, ItemRptQueryParam param) throws BOSException, EASBizException {
        this.setAsstAcctRangeId(ctx, (ArApQueryParam)param);
        if (StringUtils.isEmpty((String)param.getCussAcctTempTable())) {
            logger.warn((Object)"not cussAccts");
            return;
        }
        this.setAdminOrgIds2Tbl(ctx, param);
        if (StringUtils.isEmpty((String)param.getAdminOrgTempTable())) {
            logger.warn((Object)"not adminOrgs");
            return;
        }
        this.setPersonIds2Tbl(ctx, param);
        if (StringUtils.isEmpty((String)param.getPersonTempTable())) {
            logger.warn((Object)"not persons");
            return;
        }
        String tempTable = TempTableUtil.createTempTable(ctx, this.itemRptTempTableDefine(param));
        param.setTempTable(tempTable);
        TempTablePool t = TempTablePool.getInstance((Context)ctx);
        try {
            t.createIndex(tempTable, "Fid", true, false);
            if ("base".equals(param.getCurrencyId())) {
                if (param.isSumByCussAcct()) {
                    t.createIndex(tempTable, "FCussAcctId, FPeriodId, FBaseCurrency", false, false);
                } else if (param.isSumByDept()) {
                    t.createIndex(tempTable, "FAdminOrgId, FPeriodId, FBaseCurrency", false, false);
                } else if (param.isSumByPerson()) {
                    t.createIndex(tempTable, "FPersonId, FPeriodId, FBaseCurrency", false, false);
                }
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                if (param.isSumByCussAcct()) {
                    t.createIndex(tempTable, "FCussAcctId, FPeriodId, FCurrency", false, false);
                } else if (param.isSumByDept()) {
                    t.createIndex(tempTable, "FAdminOrgId, FPeriodId, FCurrency", false, false);
                } else if (param.isSumByPerson()) {
                    t.createIndex(tempTable, "FPersonId, FPeriodId, FCurrency", false, false);
                }
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                if (param.isSumByCussAcct()) {
                    t.createIndex(tempTable, "FCussAcctId, FPeriodId, FCurrency, FBaseCurrency", false, false);
                } else if (param.isSumByDept()) {
                    t.createIndex(tempTable, "FAdminOrgId, FPeriodId, FCurrency, FBaseCurrency", false, false);
                } else if (param.isSumByPerson()) {
                    t.createIndex(tempTable, "FPersonId, FPeriodId, FCurrency, FBaseCurrency", false, false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        this.insertItemRptData(ctx, param);
    }

    private void setAdminOrgIds2Tbl(Context ctx, ItemRptQueryParam param) throws BOSException, EASBizException {
        String fromNum = param.getAdminOrgFromNum();
        String toNum = param.getAdminOrgToNum();
        MetaDataPK cussQryPK = MetaDataPK.create((String)"com.kingdee.eas.fi.arap.app.AdminOrgUnitQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)cussQryPK);
        boolean fAllCuAdmin = param.isLinkSum() || param.isAllCuAdminPerson();
        exec.setObjectView(this.getAdminRangeView(fAllCuAdmin, fromNum, toNum, param.getCuId()));
        String sql = exec.getSQL();
        param.setAdminOrgTempTable(this.putIds2Table(ctx, sql, "adminOrgRange", param.isIncludeNullAdmin()));
    }

    private void setPersonIds2Tbl(Context ctx, ItemRptQueryParam param) throws BOSException, EASBizException {
        String fromNum = param.getPersonFromNum();
        String toNum = param.getPersonToNum();
        MetaDataPK cussQryPK = MetaDataPK.create((String)"com.kingdee.eas.basedata.person.app.PersonQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)cussQryPK);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (!StringUtils.isEmpty((String)fromNum)) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)fromNum, CompareType.GREATER_EQUALS));
        }
        if (!StringUtils.isEmpty((String)toNum)) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)toNum, CompareType.LESS_EQUALS));
        }
        if (!param.isLinkSum() && !param.isAllCuAdminPerson()) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)param.getCuId()));
        }
        view.getSelector().add("id");
        view.getSelector().add("name");
        view.getSelector().add("number");
        exec.setObjectView(view);
        StringBuffer sql = new StringBuffer("");
        sql.append(" SELECT distinct PERSON.FID ID, PERSON.FName_").append(ctx.getLocale()).append(" NAME, PERSON.FNumber NUMBER");
        sql.append(" FROM T_BD_Person PERSON");
        sql.append(" WHERE 1 = 1");
        if (!StringUtils.isEmpty((String)fromNum)) {
            sql.append(" and fnumber >= '");
            sql.append(fromNum);
            sql.append("'");
        }
        if (!StringUtils.isEmpty((String)toNum)) {
            sql.append(" and fnumber <= '");
            sql.append(toNum);
            sql.append("'");
        }
        if (!param.isLinkSum() && !param.isAllCuAdminPerson()) {
            sql.append(" and fcontrolunitid = '");
            sql.append(param.getCuId());
            sql.append("'");
        }
        param.setPersonTempTable(this.putIds2Table(ctx, sql.toString(), "personRange", param.isIncludeNullPerson()));
    }

    /*
     * Exception decompiling
     */
    private String putIds2Table(Context ctx, String sql, String tblDesc, boolean fBlankLine) throws BOSException, EASBizException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void insertItemRptData(Context ctx, ItemRptQueryParam param) throws BOSException, EASBizException {
        String oql = "select id, accountPeriodType.id where id = '" + param.getCompanyId() + "'";
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo(oql);
        this.insertItemRptStartBalBills(ctx, param, companyInfo);
        this.calBalance(ctx, param);
        this.removeItemBizBalZeroData(ctx, param);
    }

    private void insertItemRptStartBalBills(Context ctx, ItemRptQueryParam param, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        PeriodInfo qryStartPeriod;
        SystemEnum sysEnum = param.isArRpt() ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)sysEnum, (CompanyOrgUnitInfo)companyInfo);
        if (startPeriod == null) {
            throw new ArApCommonException(param.isArRpt() ? ArApCommonException.AR_STARTPERIOD_NULL : ArApCommonException.AP_STARTPERIOD_NULL);
        }
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)sysEnum, (CompanyOrgUnitInfo)companyInfo);
        if (param.getBeginDate().before(startPeriod.getBeginDate())) {
            param.setBeginDate(startPeriod.getBeginDate());
        }
        if ((qryStartPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)param.getBeginDate(), (CompanyOrgUnitInfo)companyInfo)) == null) {
            throw new ArApCommonException(ArApCommonException.DATE_NOT_IN_PERIOD);
        }
        Connection con = null;
        Statement stmt = null;
        Statement pstmt = null;
        Statement pstmtFldNull = null;
        ResultSet rs = null;
        String tempTable = param.getTempTable();
        try {
            String tempTable_calcu;
            con = this.getConnection(ctx);
            stmt = con.createStatement();
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String orgId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            HashMap nationMap = NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(userId, orgId, ctx.getLocale().toString());
            DateFormat format = (DateFormat)nationMap.get("dateFormat");
            stmt.execute(ItemRptSqlBuilder.blankStartSql(ctx, param, qryStartPeriod, true, format));
            param.setPeriodId(qryStartPeriod.getId().toString());
            TempTablePool t = TempTablePool.getInstance((Context)ctx);
            try {
                t.analyzeTable(con, param.getTempTable());
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
            String temp = ItemRptSqlBuilder.getItemStartSql(ctx, param, currPeriod);
            String fields = "FCussAcctId";
            if (param.isSumByDept()) {
                fields = "FAdminOrgId";
            } else if (param.isSumByPerson()) {
                fields = "FPersonId";
            }
            if ("base".equals(param.getCurrencyId())) {
                tempTable_calcu = TempTableUtil.createTempTable(ctx, "(fbalanceLocal decimal(28, 10) NOT NULL DEFAULT 0, FId varchar(44) NOT NULL)");
                StringBuffer uSql_calcu = new StringBuffer();
                uSql_calcu.append("insert into " + tempTable_calcu);
                uSql_calcu.append("\r\n (fbalanceLocal,FId)");
                uSql_calcu.append("\r\n select bal.FBalanceLocal,T1.FId ");
                uSql_calcu.append(" from ( ");
                uSql_calcu.append(temp);
                uSql_calcu.append(" ) bal ");
                uSql_calcu.append(" inner join " + tempTable + " as T1 ");
                uSql_calcu.append(" on (T1.FBaseCurrency = bal.FBaseCurrency ");
                uSql_calcu.append(" and ((");
                uSql_calcu.append(" bal.").append(fields).append(" = 'z' ");
                uSql_calcu.append(" and (T1.").append(fields).append(" is null ");
                uSql_calcu.append(" or T1.").append(fields).append(" = '')) ");
                uSql_calcu.append(" or ");
                uSql_calcu.append(" (bal.").append(fields).append(" is not null ");
                uSql_calcu.append(" and bal.").append(fields).append(" = T1.").append(fields);
                uSql_calcu.append(" )");
                uSql_calcu.append(" ))");
                uSql_calcu.append(" where T1.FPeriodId = '").append(qryStartPeriod.getId().toString()).append("'");
                uSql_calcu.append(" and bal.FBalanceLocal <>0");
                DbUtil.execute((Context)ctx, (String)uSql_calcu.toString());
                StringBuffer uSql = new StringBuffer();
                uSql.append(" update " + tempTable + " as T ");
                uSql.append(" set (FBalanceLocal,FId) = (");
                uSql.append("select fbalanceLocal,fid from " + tempTable_calcu + " as t1 ");
                uSql.append("\r\n where T.fid = t1.fid");
                uSql.append(" )");
                DbUtil.execute((Context)ctx, (String)uSql.toString());
                TempTableUtil.releasTempTable(ctx, tempTable_calcu);
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                tempTable_calcu = TempTableUtil.createTempTable(ctx, "(fbalance decimal(28, 10) NOT NULL DEFAULT 0, FId varchar(44) NOT NULL)");
                StringBuffer uSql_calcu = new StringBuffer();
                uSql_calcu.append("insert into " + tempTable_calcu);
                uSql_calcu.append("\r\n (fbalance,FId)");
                uSql_calcu.append("\r\n select bal.FBalance,T1.FId ");
                uSql_calcu.append(" from ( ");
                uSql_calcu.append(temp);
                uSql_calcu.append(" ) bal ");
                uSql_calcu.append(" inner join " + tempTable + " as T1 ");
                uSql_calcu.append(" on (T1.FCurrency = bal.FCurrency ");
                uSql_calcu.append(" and ((");
                uSql_calcu.append(" bal.").append(fields).append(" = 'z' ");
                uSql_calcu.append(" and (T1.").append(fields).append(" is null ");
                uSql_calcu.append(" or T1.").append(fields).append(" = '')) ");
                uSql_calcu.append(" or ");
                uSql_calcu.append(" (bal.").append(fields).append(" is not null ");
                uSql_calcu.append(" and bal.").append(fields).append(" = T1.").append(fields);
                uSql_calcu.append(" )");
                uSql_calcu.append(" ))");
                uSql_calcu.append(" where T1.FPeriodId = '").append(qryStartPeriod.getId().toString()).append("'");
                uSql_calcu.append(" and bal.FBalance <>0");
                DbUtil.execute((Context)ctx, (String)uSql_calcu.toString());
                StringBuffer uSql = new StringBuffer();
                uSql.append(" update " + tempTable + " as T ");
                uSql.append(" set (FBalance,FId) = (");
                uSql.append("select fbalance,fid from " + tempTable_calcu + " as t1 ");
                uSql.append("\r\n where T.fid = t1.fid");
                uSql.append(" )");
                DbUtil.execute((Context)ctx, (String)uSql.toString());
                TempTableUtil.releasTempTable(ctx, tempTable_calcu);
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                tempTable_calcu = TempTableUtil.createTempTable(ctx, "(fbalance decimal(28, 10) NOT NULL DEFAULT 0, fbalanceLocal decimal(28, 10) NOT NULL DEFAULT 0, FId varchar(44) NOT NULL)");
                StringBuffer uSql_calcu = new StringBuffer();
                uSql_calcu.append("insert into " + tempTable_calcu);
                uSql_calcu.append("\r\n (fbalance,fbalanceLocal,FId)");
                uSql_calcu.append("\r\n select bal.FBalance,bal.FBalanceLocal,T1.FId ");
                uSql_calcu.append(" from ( ");
                uSql_calcu.append(temp);
                uSql_calcu.append(" ) bal ");
                uSql_calcu.append(" inner join " + tempTable + " as T1 ");
                uSql_calcu.append(" on (T1.FCurrency = bal.FCurrency and T1.FBaseCurrency = bal.FBaseCurrency");
                uSql_calcu.append(" and ((");
                uSql_calcu.append(" bal.").append(fields).append(" = 'z' ");
                uSql_calcu.append(" and (T1.").append(fields).append(" is null ");
                uSql_calcu.append(" or T1.").append(fields).append(" = '')) ");
                uSql_calcu.append(" or ");
                uSql_calcu.append(" (bal.").append(fields).append(" is not null ");
                uSql_calcu.append(" and bal.").append(fields).append(" = T1.").append(fields);
                uSql_calcu.append(" )");
                uSql_calcu.append(" ))");
                uSql_calcu.append(" where T1.FPeriodId = '").append(qryStartPeriod.getId().toString()).append("'");
                uSql_calcu.append(" and bal.FBalance <>0");
                DbUtil.execute((Context)ctx, (String)uSql_calcu.toString());
                StringBuffer uSql = new StringBuffer();
                uSql.append(" update " + tempTable + " as T ");
                uSql.append(" set (FBalance,FBalanceLocal,FId) = (");
                uSql.append("select fbalance,FBalanceLocal,fid from " + tempTable_calcu + " as t1 ");
                uSql.append("\r\n where T.fid = t1.fid");
                uSql.append(" )");
                DbUtil.execute((Context)ctx, (String)uSql.toString());
                TempTableUtil.releasTempTable(ctx, tempTable_calcu);
            }
            this.insertItemRptBills(ctx, param, companyInfo, qryStartPeriod, currPeriod, startPeriod, stmt, format);
            try {
                t.analyzeTable(con, param.getTempTable());
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"can not execute correctly ", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(pstmt);
            SQLUtils.cleanup(pstmtFldNull);
            SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertItemRptBills(Context ctx, ItemRptQueryParam param, CompanyOrgUnitInfo companyInfo, PeriodInfo qryStartPeriod, PeriodInfo currPeriod, PeriodInfo startPeriod, Statement stmt, DateFormat format) throws BOSException, EASBizException, SQLException {
        int n;
        PeriodInfo periodInfo;
        ArrayList<String> sqlList = new ArrayList<String>();
        PeriodCollection periods = null;
        if (param.isByPeriod()) {
            if (!param.getBeginDate().before(currPeriod.getBeginDate())) {
                ItemRptQueryParam tempParam = null;
                if (param.getStartPeriodNum() != 1) {
                    try {
                        tempParam = (ItemRptQueryParam)param.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        e.printStackTrace();
                    }
                    tempParam.setStartPeriodNum(1);
                    tempParam.setEndPeriodNum(param.getStartPeriodNum() - 1);
                    ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
                    PeriodInfo startPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)tempParam.getStartPeriodYear(), (int)1, (IObjectPK)companyPK);
                    PeriodInfo endPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)tempParam.getStartPeriodYear(), (int)(param.getStartPeriodNum() - 1), (IObjectPK)companyPK);
                    tempParam.setBeginDate(startPeriodInfo.getBeginDate());
                    tempParam.setEndDate((Date)endPeriodInfo.getEndDate());
                    tempParam.setPeriodId(endPeriodInfo.getId().toString());
                    tempParam.setAdminOrgTempTable(param.getAdminOrgTempTable());
                    tempParam.setPersonTempTable(param.getPersonTempTable());
                    this.getStartamtByPeriod(ctx, tempParam, currPeriod, startPeriod, ctx.getLocale());
                }
            }
            if ((periods = ArApReportHelper.getPeriodCollection(ctx, (Date)param.getBeginDate(), (Date)param.getEndDate(), companyInfo)) != null && periods.size() > 0) {
                java.sql.Date qryBeginDate = param.getBeginDate();
                java.sql.Date qryEndDate = param.getEndDate();
                periodInfo = null;
                String prePeriodId = null;
                n = periods.size();
                for (int i = 0; i < n; ++i) {
                    periodInfo = periods.get(i);
                    if (i > 0) {
                        param.setBeginDate(periodInfo.getBeginDate());
                    }
                    param.setEndDate(new java.sql.Date(periodInfo.getEndDate().getTime() + 86400000L));
                    String periodId = periodInfo.getId().toString();
                    param.setPeriodId(periodId);
                    if (!periodInfo.getId().equals((Object)qryStartPeriod.getId())) {
                        stmt.execute(ItemRptSqlBuilder.blankStartSql(ctx, param, periodInfo, false, format));
                        stmt.executeUpdate(ItemRptSqlBuilder.updatePeriodStartBalSql(param, prePeriodId));
                    }
                    Locale locale = ctx.getLocale();
                    String tempTable = param.getTempTable();
                    StringBuffer sql = new StringBuffer();
                    sql.append("insert into ").append(tempTable);
                    if ("base".equals(param.getCurrencyId())) {
                        sql.append("\r\n (FBillId, FBaseCurrNum, FBaseCurrency, FCussType, FCussNum,");
                    } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                        sql.append("\r\n (FBillId, FCurrNum, FCurrency, FCussType, FCussNum,");
                    } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                        sql.append("\r\n (FBillId, FCurrNum, FCurrency, FBaseCurrNum, FBaseCurrency, FCussType, FCussNum,");
                    }
                    sql.append(" FCussName, FCussAcctId,\r\n");
                    sql.append(" FAdminOrg, FAdminOrgNum, FAdminOrgId,");
                    sql.append(" FPerson, FPersonNum, FPersonId,\r\n");
                    sql.append(" FBillDate, FBillType, FRecPayType, FBillNum,");
                    sql.append(" FVoucherType, FVoucherNum, FDescription,\r\n");
                    sql.append(" FContractNumber,");
                    if (param.isShowMaterialItem()) {
                        sql.append(" FEntrySeq, FEntryId, FMaterialId, FExpenseItemId, FQuantity, ");
                    }
                    if ("base".equals(param.getCurrencyId())) {
                        sql.append(" FDebitAmtLocal, FCreditAmtLocal, FBalanceLocal, FPeriodId,\r\n");
                    } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                        sql.append(" FDebitAmt, FCreditAmt, FBalance, FPeriodId,\r\n");
                    } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                        sql.append(" FDebitAmt, FCreditAmt, FDebitAmtLocal, FCreditAmtLocal, FBalance, FBalanceLocal, FPeriodId,\r\n");
                    }
                    sql.append(" FPeriodYear, FPeriodNumber, ");
                    sql.append("FMainBillType, FDataType, Fid) \r\n");
                    if (param.isArRpt()) {
                        sqlList.add(sql + new RptArBillSql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptRecBillSql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptBadAcctSql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptBadRecASql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptBadRec_BadSql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptArVRec_ArVApSql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptArVRecBadVRec_RecSql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptArPreRecVPrePay_RecVPaySql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptAr_ApVArSql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptArPrePayVPreRec_PayVRecSql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptArTransSql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptRecTransSql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptAr2PrepayTransSql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptRec2ApTransSql().getItemQuerySql(param, locale));
                        if ("base".equals(param.getCurrencyId()) || !"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                            sqlList.add(sql + new RptArSwap_ArApSql().getSwapQuerySql(param, locale));
                            sqlList.add(sql + new RptRecSwap_ArApSql().getSwapQuerySql(param, locale));
                        }
                    } else {
                        sqlList.add(sql + new RptApBillSql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptPayBillSql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptApVPay_ApVArSql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptApApVPay_PaySql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptApPrePayVPreRec_PayVRecSql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptApArVAp_ApSql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptApPreRecVPrePay_RecVPaySql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptApTransSql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptPayTransSql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptAp2PrerecTransSql().getItemQuerySql(param, locale));
                        sqlList.add(sql + new RptPay2ArTransSql().getItemQuerySql(param, locale));
                        if ("base".equals(param.getCurrencyId()) || !"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                            sqlList.add(sql + new RptApSwap_ArApSql().getSwapQuerySql(param, locale));
                            sqlList.add(sql + new RptPaySwap_ArApSql().getSwapQuerySql(param, locale));
                        }
                    }
                    prePeriodId = periodId;
                }
                param.setBeginDate(qryBeginDate);
                param.setEndDate(qryEndDate);
            }
        } else {
            param.setEndDate(new java.sql.Date(param.getEndDate().getTime() + 86400000L));
            Locale locale = ctx.getLocale();
            String tempTable = param.getTempTable();
            StringBuffer sql = new StringBuffer();
            sql.append("insert into ").append(tempTable);
            if ("base".equals(param.getCurrencyId())) {
                sql.append("\r\n (FBillId, FBaseCurrNum, FBaseCurrency, FCussType, FCussNum,");
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                sql.append("\r\n (FBillId, FCurrNum, FCurrency, FCussType, FCussNum,");
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                sql.append("\r\n (FBillId, FCurrNum, FCurrency, FBaseCurrNum, FBaseCurrency, FCussType, FCussNum,");
            }
            sql.append(" FCussName, FCussAcctId,\r\n");
            sql.append(" FAdminOrg, FAdminOrgNum, FAdminOrgId,");
            sql.append(" FPerson, FPersonNum, FPersonId,\r\n");
            sql.append(" FBillDate, FBillType, FRecPayType, FBillNum,");
            sql.append(" FVoucherType, FVoucherNum, FDescription,\r\n");
            sql.append(" FContractNumber,");
            if (param.isShowMaterialItem()) {
                sql.append(" FEntrySeq, FEntryId, FMaterialId, FExpenseItemId, FQuantity, ");
            }
            if ("base".equals(param.getCurrencyId())) {
                sql.append(" FDebitAmtLocal, FCreditAmtLocal, FBalanceLocal, FPeriodId,\r\n");
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                sql.append(" FDebitAmt, FCreditAmt, FBalance, FPeriodId,\r\n");
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                sql.append(" FDebitAmt, FCreditAmt, FDebitAmtLocal, FCreditAmtLocal, FBalance, FBalanceLocal, FPeriodId,\r\n");
            }
            sql.append(" FPeriodYear, FPeriodNumber, ");
            sql.append("FMainBillType, FDataType,Fid) \r\n");
            if (param.isArRpt()) {
                sqlList.add(sql + new RptRecBillSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptArBillSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptBadAcctSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptBadRecASql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptBadRec_BadSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptArVRec_ArVApSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptArVRecBadVRec_RecSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptArPreRecVPrePay_RecVPaySql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptAr_ApVArSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptArPrePayVPreRec_PayVRecSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptArTransSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptRecTransSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptAr2PrepayTransSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptRec2ApTransSql().getItemQuerySql(param, locale));
                if ("base".equals(param.getCurrencyId()) || !"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                    sqlList.add(sql + new RptArSwap_ArApSql().getSwapQuerySql(param, locale));
                    sqlList.add(sql + new RptRecSwap_ArApSql().getSwapQuerySql(param, locale));
                }
            } else {
                sqlList.add(sql + new RptApBillSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptPayBillSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptApVPay_ApVArSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptApApVPay_PaySql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptApPrePayVPreRec_PayVRecSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptApArVAp_ApSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptApPreRecVPrePay_RecVPaySql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptApTransSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptPayTransSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptAp2PrerecTransSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptPay2ArTransSql().getItemQuerySql(param, locale));
                if ("base".equals(param.getCurrencyId()) || !"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                    sqlList.add(sql + new RptApSwap_ArApSql().getSwapQuerySql(param, locale));
                    sqlList.add(sql + new RptPaySwap_ArApSql().getSwapQuerySql(param, locale));
                }
            }
        }
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            DBUtil.execBatchSql((Connection)con, sqlList, (boolean)true);
            if (param.isShowMaterialItem()) {
                String matTbl = TempTableUtil.createTempTable(ctx, "(FEntryId varchar(44), FMaterialName nvarchar(255), FSpecName nvarchar(255), FMeasureUnitName nvarchar(100), FQtyPrecision int DEFAULT 2)");
                TempTablePool t = TempTablePool.getInstance((Context)ctx);
                try {
                    t.createIndex(matTbl, "FEntryId", false, false);
                    t.analyzeTable(con, param.getTempTable());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
                ArrayList<String> sqlList2 = new ArrayList<String>();
                String tbl = param.getTempTable();
                sqlList2.add(ItemRptSqlBuilder.updateVerifBillEntryMaterialSql(ctx, tbl, matTbl, true));
                sqlList2.add(ItemRptSqlBuilder.updateVerifBillEntryExpenseSql(ctx, tbl, true));
                sqlList2.add(ItemRptSqlBuilder.updateItemRptBillRowTypeSql(ctx, tbl, true));
                sqlList2.add(ItemRptSqlBuilder.updateVerifBillEntryMaterialSql(ctx, tbl, matTbl, false));
                sqlList2.add(ItemRptSqlBuilder.updateVerifBillEntryExpenseSql(ctx, tbl, false));
                sqlList2.add(ItemRptSqlBuilder.updateItemRptBillRowTypeSql(ctx, tbl, false));
                DBUtil.execBatchSql((Connection)con, sqlList2, (boolean)true);
            }
            stmt.execute(ItemRptSqlBuilder.getItemPeriodSumSql(ctx, param));
            if (periods != null && periods.size() > 0 && param.isByPeriod()) {
                ArrayList<String> sqlList3 = new ArrayList<String>();
                periodInfo = null;
                if (param.getBeginDate().before(currPeriod.getBeginDate())) {
                    periodInfo = periods.get(0);
                    String sql = ItemRptSqlBuilder.getItemOneYearSumSql(ctx, periodInfo, param, true);
                    DBUtil.execute((Connection)con, (String)sql);
                    n = periods.size();
                    for (int i = 1; i < n; ++i) {
                        periodInfo = periods.get(i);
                        if (1 == periodInfo.getPeriodNumber()) {
                            sqlList3.add(ItemRptSqlBuilder.getItemYearSumSqlForFirstPeriod(ctx, periodInfo, param));
                            continue;
                        }
                        sqlList3.add(ItemRptSqlBuilder.getItemYearSumSql(ctx, periods.get(i - 1), periodInfo, param));
                    }
                    DBUtil.execBatchSql((Connection)con, sqlList3, (boolean)true);
                } else {
                    int n2 = periods.size();
                    for (int i = 0; i < n2; ++i) {
                        periodInfo = periods.get(i);
                        sqlList3.add(ItemRptSqlBuilder.getItemYearSumSql(ctx, periodInfo, param));
                    }
                    DBUtil.execBatchSql((Connection)con, sqlList3, (boolean)true);
                }
                StringBuffer sql = new StringBuffer();
                sql.append("delete ").append(param.getTempTable());
                sql.append(" where FDescription = 'tempSum'");
                stmt.execute(sql.toString());
            }
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private void calBalance(Context ctx, ItemRptQueryParam param) throws BOSException {
        String sql = ItemRptSqlBuilder.getRptDataSql(ctx, param, false, null);
        if (StringUtils.isEmpty((String)sql)) {
            return;
        }
        Connection cn = null;
        PreparedStatement pstmt = null;
        PreparedStatement balPstmt = null;
        ResultSet rs = null;
        String balanceCol = "FBalance";
        if ("base".equals(param.getCurrencyId())) {
            balanceCol = "FBalanceLocal";
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            balanceCol = "FBalance";
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            balanceCol = "FBalance";
        }
        try {
            cn = this.getConnection(ctx);
            pstmt = cn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            BigDecimal balance = SysConstant.BIGZERO;
            String currency = null;
            String asstActId = null;
            String balTag = null;
            String preBalTag = null;
            HashMap<String, BigDecimal> balMap = new HashMap<String, BigDecimal>();
            int dataType = -1;
            String updateBalSql = "UPDATE " + param.getTempTable() + " SET " + balanceCol + " = ? WHERE FID = ?";
            balPstmt = cn.prepareStatement(updateBalSql);
            String fid = null;
            int count = 0;
            while (rs.next()) {
                fid = rs.getString("fid");
                dataType = rs.getInt("FDataType");
                if ("base".equals(param.getCurrencyId())) {
                    currency = rs.getString("FBaseCurrNum");
                } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                    currency = rs.getString("FCurrNum");
                } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                    currency = rs.getString("FCurrNum");
                }
                asstActId = rs.getString("FCussAcctId");
                balTag = asstActId + "-" + currency;
                if (dataType == 0) {
                    balance = rs.getBigDecimal(balanceCol);
                    balance = balance == null ? SysConstant.BIGZERO : balance;
                } else if (dataType == 1) {
                    if (preBalTag != null && !balTag.equals(preBalTag)) {
                        balance = (BigDecimal)balMap.get(balTag);
                        balance = balance == null ? SysConstant.BIGZERO : balance;
                    }
                } else if (dataType == 2) {
                    BigDecimal amt = BigDecimal.ZERO;
                    if ("base".equals(param.getCurrencyId())) {
                        amt = rs.getBigDecimal("FDebitAmtLocal");
                    } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                        amt = rs.getBigDecimal("FDebitAmt");
                    } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                        amt = rs.getBigDecimal("FDebitAmt");
                    }
                    BigDecimal bigDecimal = balance = balance == null ? SysConstant.BIGZERO : balance;
                    if (amt != null) {
                        balance = balance.add(amt);
                    }
                    if ("base".equals(param.getCurrencyId())) {
                        amt = rs.getBigDecimal("FCreditAmtLocal");
                    } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                        amt = rs.getBigDecimal("FCreditAmt");
                    } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                        amt = rs.getBigDecimal("FCreditAmt");
                    }
                    if (amt != null) {
                        balance = balance.subtract(amt);
                    }
                }
                balMap.put(balTag, balance);
                if (dataType <= 2) {
                    balPstmt.setBigDecimal(1, balance);
                    balPstmt.setString(2, fid);
                    balPstmt.addBatch();
                    if (++count > 0 && count % 3000 == 0) {
                        balPstmt.executeBatch();
                        count = 0;
                        balPstmt.clearBatch();
                    }
                }
                if (null != preBalTag && !balTag.equals(preBalTag)) {
                    balMap.remove(preBalTag);
                }
                preBalTag = asstActId + "-" + currency;
            }
            if (count > 0) {
                balPstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(balPstmt);
                SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)balPstmt);
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
    }

    private void getStartamtByPeriod(Context ctx, ItemRptQueryParam param, PeriodInfo currPeriod, PeriodInfo startPeriod, Locale locale) throws BOSException, EASBizException {
        if (!param.getBeginDate().before(currPeriod.getBeginDate())) {
            param.setEndDate(new java.sql.Date(param.getEndDate().getTime() + 86400000L));
            StringBuffer sql = new StringBuffer();
            sql.append(" insert into ").append(param.getTempTable());
            if ("base".equals(param.getCurrencyId())) {
                sql.append(" (FBaseCurrNum, FBaseCurrency, FCussType, ");
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                sql.append(" (FCurrNum, FCurrency, FCussType, ");
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                sql.append(" (FCurrNum, FCurrency, FBaseCurrNum, FBaseCurrency, FCussType, ");
            }
            boolean fSumByCussAcct = param.isSumByCussAcct();
            if (fSumByCussAcct) {
                sql.append("FCussNum, FCussName, FCussAcctId, ");
            }
            if (param.isSumByDept()) {
                sql.append(" FAdminOrg, FAdminOrgNum, FAdminOrgId, ");
            } else if (param.isSumByPerson()) {
                sql.append(" FPerson, FPersonNum, FPersonId, ");
            }
            sql.append(" FDescription, FPeriodId, ");
            sql.append("FPeriodYear, FPeriodNumber, ");
            if ("base".equals(param.getCurrencyId())) {
                sql.append(" FDebitAmtLocal, FCreditAmtLocal, FDataType, Fid) \r\n ");
                sql.append(" select t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                sql.append(" FDebitAmt, FCreditAmt, FDataType, Fid) \r\n ");
                sql.append(" select t1.FCurrNum, t1.FCurrency, t1.FCussType, ");
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                sql.append(" FDebitAmt, FCreditAmt, FDebitAmtLocal, FCreditAmtLocal, FDataType, Fid) \r\n ");
                sql.append(" select t1.FCurrNum, t1.FCurrency, t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
            }
            if (fSumByCussAcct) {
                sql.append("t1.FCussNum, t1.FCussName, t1.FCussAcctId, ");
            }
            if (param.isSumByDept()) {
                sql.append(" t1.FAdminOrg, t1.FAdminOrgNum, t1.FAdminOrgId, ");
            } else if (param.isSumByPerson()) {
                sql.append(" t1.FPerson, t1.FPersonNum, t1.FPersonId, ");
            }
            sql.append("'tempSum' FDescription, FPeriodId, ");
            sql.append(param.getStartPeriodYear()).append(",");
            sql.append(param.getEndPeriodNum()).append(",");
            if ("base".equals(param.getCurrencyId())) {
                sql.append(" sum(t1.FDebitAmtLocal) FDebitAmtLocal, ");
                sql.append(" sum(t1.FCreditAmtLocal) FCreditAmtLocal, ").append(5);
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                sql.append(" sum(t1.FDebitAmt) FDebitAmt, ");
                sql.append(" sum(t1.FCreditAmt) FCreditAmt, ").append(5);
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                sql.append(" sum(t1.FDebitAmt) FDebitAmt, ");
                sql.append(" sum(t1.FCreditAmt) FCreditAmt, ");
                sql.append(" sum(t1.FDebitAmtLocal) FDebitAmtLocal, ");
                sql.append(" sum(t1.FCreditAmtLocal) FCreditAmtLocal, ").append(5);
            }
            sql.append(" FDataType, newbosid('ARAPItem') from (");
            if (param.isArRpt()) {
                sql.append(new RptRecBillSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptArBillSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptBadAcctSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptBadRecASql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptBadRec_BadSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptArVRec_ArVApSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptArVRecBadVRec_RecSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptArPreRecVPrePay_RecVPaySql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptAr_ApVArSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptArPrePayVPreRec_PayVRecSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptArTransSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptRecTransSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptAr2PrepayTransSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptRec2ApTransSql().getItemQuerySql(param, locale));
                if ("base".equals(param.getCurrencyId()) || !"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                    sql.append("\r\n union all \r\n");
                    sql.append(new RptArSwap_ArApSql().getSwapQuerySql(param, locale));
                    sql.append("\r\n union all \r\n");
                    sql.append(new RptRecSwap_ArApSql().getSwapQuerySql(param, locale));
                }
            } else {
                sql.append(new RptApBillSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptPayBillSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptApVPay_ApVArSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptApApVPay_PaySql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptApPrePayVPreRec_PayVRecSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptApArVAp_ApSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptApPreRecVPrePay_RecVPaySql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptApTransSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptPayTransSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptAp2PrerecTransSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptPay2ArTransSql().getItemQuerySql(param, locale));
                if ("base".equals(param.getCurrencyId()) || !"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                    sql.append("\r\n union all \r\n");
                    sql.append(new RptApSwap_ArApSql().getSwapQuerySql(param, locale));
                    sql.append("\r\n union all \r\n");
                    sql.append(new RptPaySwap_ArApSql().getSwapQuerySql(param, locale));
                }
            }
            sql.append(" ) t1 \r\n left join t_bd_period t2 on t1.FPeriodId = t2.FId ");
            sql.append(" \r\n where t1.FDataType = ").append(2);
            sql.append(" or t1.FDataType = ").append(0);
            sql.append(" or t1.FDataType = ").append(1);
            if ("base".equals(param.getCurrencyId())) {
                sql.append("\r\n group by t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                sql.append("\r\n group by t1.FCurrNum, t1.FCurrency, t1.FCussType, ");
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                sql.append("\r\n group by t1.FCurrNum, t1.FCurrency, t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
            }
            if (param.isSumByDept()) {
                sql.append(" t1.FAdminOrg, t1.FAdminOrgNum, t1.FAdminOrgId, ");
            } else if (param.isSumByPerson()) {
                sql.append(" t1.FPerson, t1.FPersonNum, t1.FPersonId, ");
            }
            if (fSumByCussAcct) {
                sql.append(" t1.FCussNum, t1.FCussName, t1.FCussAcctId, ");
            }
            sql.append(" t1.FPeriodId, t2.FPeriodYear, t2.FPeriodNumber");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        } else if (param.getEndDate().after(currPeriod.getBeginDate())) {
            String sql1 = ItemRptSqlBuilder.getItemOneYearSumSql(ctx, currPeriod, param, false);
            DBUtil.execute((Context)ctx, (String)sql1);
            param.setBeginDate(currPeriod.getBeginDate());
            param.setEndDate(new java.sql.Date(param.getEndDate().getTime() + 86400000L));
            StringBuffer sql = new StringBuffer();
            sql.append(" insert into ").append(param.getTempTable());
            if ("base".equals(param.getCurrencyId())) {
                sql.append(" (FBaseCurrNum, FBaseCurrency, FCussType, ");
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                sql.append(" (FCurrNum, FCurrency, FCussType, ");
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                sql.append(" (FCurrNum, FCurrency, FBaseCurrNum, FBaseCurrency, FCussType, ");
            }
            boolean fSumByCussAcct = param.isSumByCussAcct();
            if (fSumByCussAcct) {
                sql.append("FCussNum, FCussName, FCussAcctId, ");
            }
            if (param.isSumByDept()) {
                sql.append(" FAdminOrg, FAdminOrgNum, FAdminOrgId, ");
            } else if (param.isSumByPerson()) {
                sql.append(" FPerson, FPersonNum, FPersonId, ");
            }
            sql.append(" FDescription, FPeriodId, ");
            sql.append("FPeriodYear, FPeriodNumber, ");
            if ("base".equals(param.getCurrencyId())) {
                sql.append(" FDebitAmtLocal, FCreditAmtLocal, FDataType, Fid) \r\n ");
                sql.append(" select t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                sql.append(" FDebitAmt, FCreditAmt, FDataType, Fid) \r\n ");
                sql.append(" select t1.FCurrNum, t1.FCurrency, t1.FCussType, ");
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                sql.append(" FDebitAmt, FCreditAmt, FDebitAmtLocal, FCreditAmtLocal, FDataType, Fid) \r\n ");
                sql.append(" select t1.FCurrNum, t1.FCurrency, t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
            }
            if (fSumByCussAcct) {
                sql.append("t1.FCussNum, t1.FCussName, t1.FCussAcctId, ");
            }
            if (param.isSumByDept()) {
                sql.append(" t1.FAdminOrg, t1.FAdminOrgNum, t1.FAdminOrgId, ");
            } else if (param.isSumByPerson()) {
                sql.append(" t1.FPerson, t1.FPersonNum, t1.FPersonId, ");
            }
            sql.append("'tempSum' FDescription, FPeriodId, ");
            sql.append(param.getStartPeriodYear()).append(",");
            sql.append(param.getEndPeriodNum()).append(",");
            if ("base".equals(param.getCurrencyId())) {
                sql.append(" sum(t1.FDebitAmtLocal) FDebitAmtLocal, ");
                sql.append(" sum(t1.FCreditAmtLocal) FCreditAmtLocal, ").append(5);
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                sql.append(" sum(t1.FDebitAmt) FDebitAmt, ");
                sql.append(" sum(t1.FCreditAmt) FCreditAmt, ").append(5);
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                sql.append(" sum(t1.FDebitAmt) FDebitAmt, ");
                sql.append(" sum(t1.FCreditAmt) FCreditAmt, ");
                sql.append(" sum(t1.FDebitAmtLocal) FDebitAmtLocal, ");
                sql.append(" sum(t1.FCreditAmtLocal) FCreditAmtLocal, ").append(5);
            }
            sql.append(" FDataType, newbosid('ARAPItem') FBosID from (");
            if (param.isArRpt()) {
                sql.append(new RptRecBillSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptArBillSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptBadAcctSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptBadRecASql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptBadRec_BadSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptArVRec_ArVApSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptArVRecBadVRec_RecSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptArPreRecVPrePay_RecVPaySql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptAr_ApVArSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptArPrePayVPreRec_PayVRecSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptArTransSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptRecTransSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptAr2PrepayTransSql().getItemQuerySql(param, locale));
                if ("base".equals(param.getCurrencyId()) || !"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                    sql.append("\r\n union all \r\n");
                    sql.append(new RptArSwap_ArApSql().getSwapQuerySql(param, locale));
                    sql.append("\r\n union all \r\n");
                    sql.append(new RptRecSwap_ArApSql().getSwapQuerySql(param, locale));
                }
            } else {
                sql.append(new RptApBillSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptPayBillSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptApVPay_ApVArSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptApApVPay_PaySql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptApPrePayVPreRec_PayVRecSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptApArVAp_ApSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptApPreRecVPrePay_RecVPaySql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptApTransSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptPayTransSql().getItemQuerySql(param, locale));
                sql.append("\r\n union all \r\n");
                sql.append(new RptAp2PrerecTransSql().getItemQuerySql(param, locale));
                if ("base".equals(param.getCurrencyId()) || !"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                    sql.append("\r\n union all \r\n");
                    sql.append(new RptApSwap_ArApSql().getSwapQuerySql(param, locale));
                    sql.append("\r\n union all \r\n");
                    sql.append(new RptPaySwap_ArApSql().getSwapQuerySql(param, locale));
                }
            }
            sql.append(" ) t1 \r\n left join t_bd_period t2 on t1.FPeriodId = t2.FId ");
            sql.append(" \r\n where t1.FDataType = ").append(2);
            sql.append(" or t1.FDataType = ").append(0);
            sql.append(" or t1.FDataType = ").append(1);
            if ("base".equals(param.getCurrencyId())) {
                sql.append("\r\n group by t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                sql.append("\r\n group by t1.FCurrNum, t1.FCurrency, t1.FCussType, ");
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                sql.append("\r\n group by t1.FCurrNum, t1.FCurrency, t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
            }
            if (param.isSumByDept()) {
                sql.append(" t1.FAdminOrg, t1.FAdminOrgNum, t1.FAdminOrgId, ");
            } else if (param.isSumByPerson()) {
                sql.append(" t1.FPerson, t1.FPersonNum, t1.FPersonId, ");
            }
            if (fSumByCussAcct) {
                sql.append(" t1.FCussNum, t1.FCussName, t1.FCussAcctId, ");
            }
            sql.append(" t1.FPeriodId, t2.FPeriodYear, t2.FPeriodNumber");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        } else if (param.getEndDate().before(currPeriod.getBeginDate())) {
            if (param.getEndDate().before(startPeriod.getBeginDate())) {
                String sql2 = ItemRptSqlBuilder.getItemOneYearSumSql(ctx, startPeriod, param, false);
                DBUtil.execute((Context)ctx, (String)sql2);
            } else {
                PeriodInfo endPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)param.getStartPeriodYear(), (int)param.getEndPeriodNum(), (IObjectPK)new ObjectUuidPK(param.getCompanyId()));
                String sql2 = ItemRptSqlBuilder.getItemOneYearSumSql(ctx, endPeriodInfo, param, false);
                DBUtil.execute((Context)ctx, (String)sql2);
            }
        }
    }

    private void removeItemBizBalZeroData(Context ctx, ItemRptQueryParam param) throws BOSException, EASBizException {
        PreparedStatement pstmtFldNull;
        PreparedStatement pstmt;
        ResultSet rs;
        Statement stmt;
        Connection con;
        block34: {
            if (!param.isBalZero() && !param.isBizZero()) {
                return;
            }
            String tempTable = param.getTempTable();
            String field = "";
            if (param.isSumByCussAcct()) {
                field = "FCussAcctId";
            } else if (param.isSumByDept()) {
                field = "FAdminOrgId";
            } else if (param.isSumByPerson()) {
                field = "FPersonId";
            }
            con = null;
            stmt = null;
            rs = null;
            pstmt = null;
            pstmtFldNull = null;
            try {
                con = this.getConnection(ctx);
                stmt = con.createStatement();
                String dSql = "";
                String dFldNullSql = "";
                if ("base".equals(param.getCurrencyId())) {
                    dSql = "delete " + tempTable + " where FBaseCurrency = ? and FPeriodId  = ? and " + field + " = ? ";
                    dFldNullSql = "delete " + tempTable + " where FBaseCurrency = ? and FPeriodId  = ? and " + field + " is null and FDataType <= " + 6;
                    pstmt = con.prepareStatement(dSql);
                    pstmtFldNull = con.prepareStatement(dFldNullSql);
                } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                    dSql = "delete " + tempTable + " where FCurrency = ? and FPeriodId  = ? and " + field + " = ? ";
                    dFldNullSql = "delete " + tempTable + " where FCurrency = ? and FPeriodId  = ? and " + field + " is null and FDataType <= " + 6;
                    pstmt = con.prepareStatement(dSql);
                    pstmtFldNull = con.prepareStatement(dFldNullSql);
                } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                    dSql = "delete " + tempTable + " where FCurrency = ? and FBaseCurrency = ? and FPeriodId  = ? and " + field + " = ? ";
                    dFldNullSql = "delete " + tempTable + " where FCurrency = ? and FPeriodId  = ? and " + field + " is null and FDataType <= " + 6;
                    pstmt = con.prepareStatement(dSql);
                    pstmtFldNull = con.prepareStatement(dFldNullSql);
                }
                StringBuffer sql = new StringBuffer();
                if (param.isBizZero()) {
                    if ("base".equals(param.getCurrencyId())) {
                        sql.append("select t1.FBaseCurrency, t1.FPeriodId, t1.");
                        sql.append(field).append(" from ");
                        sql.append(tempTable).append(" t1 \r\n where ");
                        sql.append(" t1.FDebitAmtLocal = 0 and t1.FCreditAmtLocal = 0");
                        sql.append(" and t1.FDataType = ");
                        sql.append(5);
                    } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                        sql.append("select t1.FCurrency, t1.FPeriodId, t1.");
                        sql.append(field).append(" from ");
                        sql.append(tempTable).append(" t1 \r\n where ");
                        sql.append(" t1.FDebitAmt = 0 and t1.FCreditAmt = 0");
                        sql.append(" and t1.FDataType = ");
                        sql.append(5);
                    } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                        sql.append("select t1.FCurrency, t1.FBaseCurrency, t1.FPeriodId, t1.");
                        sql.append(field).append(" from ");
                        sql.append(tempTable).append(" t1 \r\n where ");
                        sql.append(" t1.FDebitAmt = 0 and t1.FCreditAmt = 0");
                        sql.append(" and t1.FDebitAmtLocal = 0 and t1.FCreditAmtLocal = 0");
                        sql.append(" and t1.FDataType = ");
                        sql.append(5);
                    }
                    logger.debug((Object)("delBizSql :\r\n" + sql));
                    logger.debug((Object)("delBizBalSql: \r\n" + dSql));
                    logger.debug((Object)("delBizFldNullSql :\r\n" + dFldNullSql));
                    rs = stmt.executeQuery(sql.toString());
                    this.removeItemAllCurrBizBal(pstmt, pstmtFldNull, rs, param);
                }
                if (param.isBalZero()) {
                    if ("base".equals(param.getCurrencyId())) {
                        sql.delete(0, sql.length());
                        sql.append("select t1.FBaseCurrency, t1.FPeriodId, t1.");
                        sql.append(field).append(" from ");
                        sql.append(tempTable);
                        sql.append(" t1 \r\n left join ");
                        sql.append(tempTable);
                        sql.append(" t2 \r\n on ");
                        sql.append(" t1.FPeriodId = t2.FPeriodId \r\n ");
                        sql.append("where (t1.FBalanceLocal + ");
                        sql.append(" t2.FDebitAmtLocal -  t2.FCreditAmtLocal ) = 0  ");
                        sql.append("\r\n and (t1.FDataType = ");
                        sql.append(0);
                        sql.append(" or t1.FDataType = ");
                        sql.append(1);
                        sql.append(") and t2.FDataType = ");
                        sql.append(5);
                        sql.append(" and t1.FBaseCurrency = t2.FBaseCurrency ");
                        sql.append("\r\n and (t1.").append(field).append(" = ");
                        sql.append(" t2.").append(field).append(" or (t1.");
                        sql.append(field).append(" is null and t2.");
                        sql.append(field).append(" is null))");
                    } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                        sql.delete(0, sql.length());
                        sql.append("select t1.FCurrency, t1.FPeriodId, t1.");
                        sql.append(field).append(" from ");
                        sql.append(tempTable);
                        sql.append(" t1 \r\n left join ");
                        sql.append(tempTable);
                        sql.append(" t2 \r\n on ");
                        sql.append(" t1.FPeriodId = t2.FPeriodId \r\n ");
                        sql.append("where (t1.FBalance + ");
                        sql.append(" t2.FDebitAmt -  t2.FCreditAmt ) = 0  ");
                        sql.append("\r\n and (t1.FDataType = ");
                        sql.append(0);
                        sql.append(" or t1.FDataType = ");
                        sql.append(1);
                        sql.append(") and t2.FDataType = ");
                        sql.append(5);
                        sql.append(" and t1.FCurrency = t2.FCurrency ");
                        sql.append("\r\n and (t1.").append(field).append(" = ");
                        sql.append(" t2.").append(field).append(" or (t1.");
                        sql.append(field).append(" is null and t2.");
                        sql.append(field).append(" is null))");
                    } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                        sql.delete(0, sql.length());
                        sql.append("select t1.FCurrency, t1.FBaseCurrency, t1.FPeriodId, t1.");
                        sql.append(field).append(" from ");
                        sql.append(tempTable);
                        sql.append(" t1 \r\n left join ");
                        sql.append(tempTable);
                        sql.append(" t2 \r\n on ");
                        sql.append(" t1.FPeriodId = t2.FPeriodId \r\n ");
                        sql.append("where (t1.FBalance + ");
                        sql.append(" t2.FDebitAmt -  t2.FCreditAmt ) = 0  ");
                        sql.append("and (t1.FBalanceLocal + ");
                        sql.append(" t2.FDebitAmtLocal -  t2.FCreditAmtLocal ) = 0  ");
                        sql.append("\r\n and (t1.FDataType = ");
                        sql.append(0);
                        sql.append(" or t1.FDataType = ");
                        sql.append(1);
                        sql.append(") and t2.FDataType = ");
                        sql.append(5);
                        sql.append(" and t1.FCurrency = t2.FCurrency ");
                        sql.append(" and t1.FBaseCurrency = t2.FBaseCurrency ");
                        sql.append("\r\n and (t1.").append(field).append(" = ");
                        sql.append(" t2.").append(field).append(" or (t1.");
                        sql.append(field).append(" is null and t2.");
                        sql.append(field).append(" is null))");
                    }
                    logger.debug((Object)("delBalSql  :\r\n" + sql));
                    logger.debug((Object)("delBizBalSql: \r\n" + dSql));
                    logger.debug((Object)("delBizFldNullSql :\r\n" + dFldNullSql));
                    rs = stmt.executeQuery(sql.toString());
                    this.removeItemAllCurrBizBal(pstmt, pstmtFldNull, rs, param);
                }
                if (!param.isAllCurrency()) break block34;
                if (param.isBizZero()) {
                    stmt.execute(ItemRptSqlBuilder.delAllCurrencyBizZeroSql(tempTable, param));
                }
                if (param.isBalZero()) {
                    if ("base".equals(param.getCurrencyId())) {
                        sql.delete(0, sql.length());
                        sql.append("delete ").append(tempTable);
                        sql.append(" where FDataType = ");
                        sql.append(7);
                        sql.append("\r\n and FBaseCurrency in (select FBaseCurrency from ");
                        sql.append("\r\n (select FBaseCurrency, count(1) FCount from ");
                        sql.append(tempTable).append(" group by FBaseCurrency ) t2 ");
                        sql.append("\r\n where t2.FCount = 1)");
                    } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                        sql.delete(0, sql.length());
                        sql.append("delete ").append(tempTable);
                        sql.append(" where FDataType = ");
                        sql.append(7);
                        sql.append("\r\n and FCurrency in (select FCurrency from ");
                        sql.append("\r\n (select FCurrency, count(1) FCount from ");
                        sql.append(tempTable).append(" group by FCurrency ) t2 ");
                        sql.append("\r\n where t2.FCount = 1)");
                    } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                        sql.delete(0, sql.length());
                        sql.append("delete ").append(tempTable);
                        sql.append(" where FDataType = ");
                        sql.append(7);
                        sql.append("\r\n and FCurrency in (select FCurrency from ");
                        sql.append("\r\n (select FCurrency, count(1) FCount from ");
                        sql.append(tempTable).append(" group by FCurrency ) t2 ");
                        sql.append("\r\n where t2.FCount = 1)");
                    }
                    logger.debug((Object)("itemRpt AllCurrency delBalZero Sql: \r\n" + sql));
                    stmt.execute(sql.toString());
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"can not execute correctly ", (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt);
                    SQLUtils.cleanup(pstmtFldNull);
                    SQLUtils.cleanup(rs, pstmt, (Connection)con);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup(pstmtFldNull);
        SQLUtils.cleanup(rs, pstmt, (Connection)con);
    }

    private void removeItemAllCurrBizBal(PreparedStatement pstmt, PreparedStatement pstmtFldNull, ResultSet rs) throws SQLException {
        boolean fUpdate = false;
        boolean fFldNullDel = false;
        while (rs.next()) {
            if (rs.getString(3) == null) {
                pstmtFldNull.setString(1, rs.getString(1));
                pstmtFldNull.setString(2, rs.getString(2));
                pstmtFldNull.addBatch();
                fFldNullDel = true;
            } else {
                pstmt.setString(1, rs.getString(1));
                pstmt.setString(2, rs.getString(2));
                pstmt.setString(3, rs.getString(3));
                pstmt.addBatch();
            }
            fUpdate = true;
        }
        if (fUpdate) {
            pstmt.executeBatch();
            if (fFldNullDel) {
                pstmtFldNull.executeBatch();
            }
        }
    }

    private void removeItemAllCurrBizBal(PreparedStatement pstmt, PreparedStatement pstmtFldNull, ResultSet rs, ItemRptQueryParam param) throws SQLException {
        boolean fUpdate = false;
        boolean fFldNullDel = false;
        while (rs.next()) {
            if ("base".equals(param.getCurrencyId())) {
                if (rs.getString(3) == null) {
                    pstmtFldNull.setString(1, rs.getString(1));
                    pstmtFldNull.setString(2, rs.getString(2));
                    pstmtFldNull.addBatch();
                    fFldNullDel = true;
                } else {
                    pstmt.setString(1, rs.getString(1));
                    pstmt.setString(2, rs.getString(2));
                    pstmt.setString(3, rs.getString(3));
                    pstmt.addBatch();
                }
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                if (rs.getString(3) == null) {
                    pstmtFldNull.setString(1, rs.getString(1));
                    pstmtFldNull.setString(2, rs.getString(2));
                    pstmtFldNull.addBatch();
                    fFldNullDel = true;
                } else {
                    pstmt.setString(1, rs.getString(1));
                    pstmt.setString(2, rs.getString(2));
                    pstmt.setString(3, rs.getString(3));
                    pstmt.addBatch();
                }
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                if (rs.getString(4) == null) {
                    pstmtFldNull.setString(1, rs.getString(1));
                    pstmtFldNull.setString(2, rs.getString(2));
                    pstmtFldNull.setString(3, rs.getString(3));
                    pstmtFldNull.addBatch();
                    fFldNullDel = true;
                } else {
                    pstmt.setString(1, rs.getString(1));
                    pstmt.setString(2, rs.getString(2));
                    pstmt.setString(3, rs.getString(3));
                    pstmt.setString(4, rs.getString(4));
                    pstmt.addBatch();
                }
            }
            fUpdate = true;
        }
        if (fUpdate) {
            pstmt.executeBatch();
            if (fFldNullDel) {
                pstmtFldNull.executeBatch();
            }
        }
    }

    private IReportData getArApItemData(Context ctx, ItemRptQueryParam param) throws BOSException, EASBizException {
        String sql = ItemRptSqlBuilder.getRptDataSql(ctx, param, true, null);
        if (StringUtils.isEmpty((String)sql)) {
            return null;
        }
        String countSql = "SELECT COUNT(0) " + sql.substring(sql.indexOf("from"), sql.indexOf("order by"));
        ArApReportData rptData = null;
        Connection cn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String balanceCol = "";
        String balanceColLocal = "";
        if ("base".equals(param.getCurrencyId())) {
            balanceColLocal = "FBalanceLocal";
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            balanceCol = "FBalance";
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            balanceCol = "FBalance";
            balanceColLocal = "FBalanceLocal";
        }
        int totalRowCount = param.getTotalRowCount();
        try {
            cn = this.getConnection(ctx);
            if (totalRowCount == 0 && (rs = (pstmt = cn.prepareStatement(countSql)).executeQuery()).next()) {
                totalRowCount = rs.getInt(1);
            }
            pstmt = cn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            int start = param.getStartIndex();
            int end = param.getEndIndex();
            int iType = 0;
            int iMainType = 0;
            String billType = "";
            String col = "";
            List rptFlds = param.getReportFields();
            ArrayList<ReportInfo> dataLst = new ArrayList<ReportInfo>();
            ReportInfo rptInfo = null;
            BigDecimal balance = SysConstant.BIGZERO;
            BigDecimal balanceLocal = SysConstant.BIGZERO;
            String currency = null;
            String asstActId = null;
            String balTag = null;
            String preBalTag = null;
            String baseCurrency = null;
            String balTagLocal = null;
            String preBalTagLocal = null;
            HashMap<String, BigDecimal> balMap = new HashMap<String, BigDecimal>();
            int dataType = -1;
            int row = 0;
            Timestamp timestamp = null;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            while (rs.next()) {
                if (++row == 10) {
                    boolean bl = true;
                }
                dataType = rs.getInt("FDataType");
                if ("base".equals(param.getCurrencyId())) {
                    baseCurrency = rs.getString("FBaseCurrNum");
                } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                    currency = rs.getString("FCurrNum");
                } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                    currency = rs.getString("FCurrNum");
                    baseCurrency = rs.getString("FBaseCurrNum");
                }
                asstActId = rs.getString("FCussAcctId");
                if ("base".equals(param.getCurrencyId())) {
                    balTagLocal = asstActId + "-" + currency + "-Local";
                } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                    balTag = asstActId + "-" + currency;
                } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                    balTag = asstActId + "-" + currency;
                    balTagLocal = asstActId + "-" + currency + "-Local";
                }
                if (dataType == 0) {
                    if ("base".equals(param.getCurrencyId())) {
                        balanceLocal = rs.getBigDecimal(balanceColLocal);
                        balanceLocal = balanceLocal == null ? SysConstant.BIGZERO : balanceLocal;
                    } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                        balance = rs.getBigDecimal(balanceCol);
                        balance = balance == null ? SysConstant.BIGZERO : balance;
                    } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                        balance = rs.getBigDecimal(balanceCol);
                        balance = balance == null ? SysConstant.BIGZERO : balance;
                        balanceLocal = rs.getBigDecimal(balanceColLocal);
                        balanceLocal = balanceLocal == null ? SysConstant.BIGZERO : balanceLocal;
                    }
                } else if (dataType == 1) {
                    if (preBalTag != null && !preBalTag.equals(balTag)) {
                        if ("base".equals(param.getCurrencyId())) {
                            balanceLocal = (BigDecimal)balMap.get(balTagLocal);
                            balanceLocal = balanceLocal == null ? SysConstant.BIGZERO : balanceLocal;
                        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                            balance = (BigDecimal)balMap.get(balTag);
                            balance = balance == null ? SysConstant.BIGZERO : balance;
                        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                            balance = (BigDecimal)balMap.get(balTag);
                            balance = balance == null ? SysConstant.BIGZERO : balance;
                            balanceLocal = (BigDecimal)balMap.get(balTagLocal);
                            balanceLocal = balanceLocal == null ? SysConstant.BIGZERO : balanceLocal;
                        }
                    }
                } else if (dataType == 2) {
                    if ("base".equals(param.getCurrencyId())) {
                        BigDecimal amtLocal = rs.getBigDecimal("FDebitAmtLocal");
                        if (amtLocal != null) {
                            balanceLocal = balanceLocal.add(amtLocal);
                        }
                        if ((amtLocal = rs.getBigDecimal("FCreditAmtLocal")) != null) {
                            balanceLocal = balanceLocal.subtract(amtLocal);
                        }
                    } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                        BigDecimal amt = rs.getBigDecimal("FDebitAmt");
                        if (amt != null) {
                            balance = balance.add(amt);
                        }
                        if ((amt = rs.getBigDecimal("FCreditAmt")) != null) {
                            balance = balance.subtract(amt);
                        }
                    } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                        BigDecimal amtLocal;
                        BigDecimal amt = rs.getBigDecimal("FDebitAmt");
                        if (amt != null) {
                            balance = balance.add(amt);
                        }
                        if ((amt = rs.getBigDecimal("FCreditAmt")) != null) {
                            balance = balance.subtract(amt);
                        }
                        if ((amtLocal = rs.getBigDecimal("FDebitAmtLocal")) != null) {
                            balanceLocal = balanceLocal.add(amtLocal);
                        }
                        if ((amtLocal = rs.getBigDecimal("FCreditAmtLocal")) != null) {
                            balanceLocal = balanceLocal.subtract(amtLocal);
                        }
                    }
                }
                if ("base".equals(param.getCurrencyId())) {
                    balMap.put(balTagLocal, balanceLocal);
                } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                    balMap.put(balTag, balance);
                } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                    balMap.put(balTag, balance);
                    balMap.put(balTagLocal, balanceLocal);
                }
                dataType = rs.getInt("FDataType");
                if ("base".equals(param.getCurrencyId())) {
                    balanceLocal = rs.getBigDecimal(balanceColLocal);
                } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                    balance = rs.getBigDecimal(balanceCol);
                } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                    balance = rs.getBigDecimal(balanceCol);
                }
                if (ArApReportHelper.isInRange(row, start, end)) {
                    rptInfo = new ReportInfo();
                    int n = rptFlds.size();
                    for (int i = 0; i < n; ++i) {
                        col = rptFlds.get(i).toString();
                        if (col.equalsIgnoreCase("FBillType")) {
                            if (dataType != 2) continue;
                            iType = rs.getInt(col);
                            iMainType = rs.getInt("FMainBillType");
                            billType = iMainType == 1 || iMainType == 2 ? rs.getString("FRecPayType") : this.getBillType(iType, iMainType, ctx.getLocale());
                            if (iType == 222) {
                                billType = EASResource.getString((String)"com.kingdee.eas.fi.ar.ArAllResource", (String)"TransfExchangeRecord");
                            }
                            rptInfo.put(col, billType);
                            continue;
                        }
                        if (col.equalsIgnoreCase("FBillDate")) {
                            timestamp = (Timestamp)rs.getObject(col);
                            if (timestamp == null) continue;
                            rptInfo.put(col, sdf.format(timestamp));
                            continue;
                        }
                        rptInfo.put(col, rs.getObject(col));
                    }
                    if (dataType > 2) {
                        rptInfo.setIsSumLine(dataType == 5);
                        rptInfo.setIsTotalLine(dataType == 7 || dataType == 6);
                        if ("base".equals(param.getCurrencyId())) {
                            rptInfo.put(balanceColLocal, null);
                        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                            rptInfo.put(balanceCol, null);
                        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                            rptInfo.put(balanceCol, null);
                            rptInfo.put(balanceColLocal, null);
                        }
                    } else if ("base".equals(param.getCurrencyId())) {
                        rptInfo.put(balanceColLocal, balanceLocal);
                    } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                        rptInfo.put(balanceCol, balance);
                    } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                        rptInfo.put(balanceCol, balance);
                        rptInfo.put(balanceColLocal, balanceLocal);
                    }
                    dataLst.add(rptInfo);
                } else if (row > end) break;
                if ("base".equals(param.getCurrencyId())) {
                    preBalTagLocal = asstActId + "-" + baseCurrency + "-Local";
                    continue;
                }
                if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                    preBalTag = asstActId + "-" + currency;
                    continue;
                }
                if ("base".equals(param.getCurrencyId()) || !param.isBaseCurrency()) continue;
                preBalTag = asstActId + "-" + currency;
                preBalTagLocal = asstActId + "-" + baseCurrency + "-Local";
            }
            rptData = new ArApReportData(dataLst, totalRowCount);
            rptData.setTempTable(param.getTempTable());
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"getItemRptData execute sql exception. ", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        return rptData;
    }

    protected String itemRptTempTableDefine() {
        StringBuffer sql = new StringBuffer();
        sql.append(" (FBillId varchar(44), ");
        sql.append(" FCurrNum varchar(80), ");
        sql.append(" FCurrency nvarchar(200), ");
        sql.append(" FCussType nvarchar(100), ");
        sql.append(" FCussNum nvarchar(100), ");
        sql.append(" FCussName nvarchar(400), ");
        sql.append(" FCussAcctId varchar(44), ");
        sql.append(" FAdminOrg nvarchar(200), ");
        sql.append(" FAdminOrgId varchar(44), ");
        sql.append(" FAdminOrgNum nvarchar(100), ");
        sql.append(" FPerson nvarchar(200), ");
        sql.append(" FPersonId varchar(44), ");
        sql.append(" FPersonNum nvarchar(100), ");
        sql.append(" FBillDate dateTime, ");
        sql.append(" FBillType int DEFAULT -1, ");
        sql.append(" FRecPayType nvarchar(100), ");
        sql.append(" FBillNum nvarchar(100), ");
        sql.append(" FVoucherType nvarchar(100), ");
        sql.append(" FVoucherNum nvarchar(100), ");
        sql.append(" FDescription nvarchar(255), ");
        sql.append(" FEntrySeq int, ");
        sql.append(" FEntryId varchar(44), ");
        sql.append(" FMaterialId varchar(44), ");
        sql.append(" FExpenseItemID varchar(44), ");
        sql.append(" FMaterialName nvarchar(255), ");
        sql.append(" FSpecName nvarchar(255), ");
        sql.append(" FMeasureUnitName nvarchar(100), ");
        sql.append(" FQtyPrecision int DEFAULT 2, ");
        sql.append(" FQuantity decimal(28, 16) , ");
        sql.append(" FDebitAmt decimal(28, 10) NOT NULL DEFAULT 0, ");
        sql.append(" FCreditAmt decimal(28, 10) NOT NULL DEFAULT 0, ");
        sql.append(" FBalance decimal(28, 10) NOT NULL DEFAULT 0, ");
        sql.append(" FPeriodId varchar(44), ");
        sql.append(" FPeriodYear int, ");
        sql.append(" FPeriodNumber int, ");
        sql.append(" FMainBillType int NOT NULL DEFAULT -1, ");
        sql.append(" FCurrSumOrder int NOT NULL DEFAULT 0, ");
        sql.append(" FDataType int NOT NULL DEFAULT -1,");
        sql.append(" FContractNumber nvarchar(80) ,");
        sql.append(" FId varchar(44) NOT NULL");
        sql.append(")");
        return sql.toString();
    }

    protected String itemRptTempTableDefine(ItemRptQueryParam param) {
        StringBuffer sql = new StringBuffer();
        sql.append(" (FBillId varchar(44), ");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" FBaseCurrNum varchar(80), ");
            sql.append(" FBaseCurrency nvarchar(200), ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" FCurrNum varchar(80), ");
            sql.append(" FCurrency nvarchar(200), ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" FCurrNum varchar(80), ");
            sql.append(" FCurrency nvarchar(200), ");
            sql.append(" FBaseCurrNum varchar(80), ");
            sql.append(" FBaseCurrency nvarchar(200), ");
        }
        sql.append(" FCussType nvarchar(100), ");
        sql.append(" FCussNum nvarchar(100), ");
        sql.append(" FCussName nvarchar(400), ");
        sql.append(" FCussAcctId varchar(44), ");
        sql.append(" FAdminOrg nvarchar(200), ");
        sql.append(" FAdminOrgId varchar(44), ");
        sql.append(" FAdminOrgNum nvarchar(100), ");
        sql.append(" FPerson nvarchar(200), ");
        sql.append(" FPersonId varchar(44), ");
        sql.append(" FPersonNum nvarchar(100), ");
        sql.append(" FBillDate dateTime, ");
        sql.append(" FBillType int DEFAULT -1, ");
        sql.append(" FRecPayType nvarchar(100), ");
        sql.append(" FBillNum nvarchar(100), ");
        sql.append(" FVoucherType nvarchar(100), ");
        sql.append(" FVoucherNum nvarchar(100), ");
        sql.append(" FDescription nvarchar(255), ");
        sql.append(" FEntrySeq int, ");
        sql.append(" FEntryId varchar(44), ");
        sql.append(" FMaterialId varchar(44), ");
        sql.append(" FExpenseItemID varchar(44), ");
        sql.append(" FMaterialName nvarchar(255), ");
        sql.append(" FSpecName nvarchar(255), ");
        sql.append(" FMeasureUnitName nvarchar(100), ");
        sql.append(" FQtyPrecision int DEFAULT 2, ");
        sql.append(" FQuantity decimal(28, 16) , ");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" FDebitAmtLocal decimal(28, 10) NOT NULL DEFAULT 0, ");
            sql.append(" FCreditAmtLocal decimal(28, 10) NOT NULL DEFAULT 0, ");
            sql.append(" FBalanceLocal decimal(28, 10) NOT NULL DEFAULT 0, ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" FDebitAmt decimal(28, 10) NOT NULL DEFAULT 0, ");
            sql.append(" FCreditAmt decimal(28, 10) NOT NULL DEFAULT 0, ");
            sql.append(" FBalance decimal(28, 10) NOT NULL DEFAULT 0, ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" FDebitAmt decimal(28, 10) NOT NULL DEFAULT 0, ");
            sql.append(" FDebitAmtLocal decimal(28, 10) NOT NULL DEFAULT 0, ");
            sql.append(" FCreditAmt decimal(28, 10) NOT NULL DEFAULT 0, ");
            sql.append(" FCreditAmtLocal decimal(28, 10) NOT NULL DEFAULT 0, ");
            sql.append(" FBalance decimal(28, 10) NOT NULL DEFAULT 0, ");
            sql.append(" FBalanceLocal decimal(28, 10) NOT NULL DEFAULT 0, ");
        }
        sql.append(" FPeriodId varchar(44), ");
        sql.append(" FPeriodYear int, ");
        sql.append(" FPeriodNumber int, ");
        sql.append(" FMainBillType int NOT NULL DEFAULT -1, ");
        sql.append(" FCurrSumOrder int NOT NULL DEFAULT 0, ");
        sql.append(" FDataType int NOT NULL DEFAULT -1,");
        sql.append(" FContractNumber nvarchar(80) ,");
        sql.append(" FId varchar(44) NOT NULL");
        sql.append(")");
        return sql.toString();
    }

    @Override
    protected void _releaseTempTable(Context ctx, String tempTable) throws BOSException {
        try {
            TempTableUtil.releasTempTable(ctx, tempTable);
        }
        catch (Exception e) {
            logger.error((Object)("cannot release tmpTable: " + tempTable), (Throwable)e);
        }
    }
}

