/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.eas.fi.ar.ArApQueryParam;
import com.kingdee.eas.fi.ar.ArrearageQueryParam;
import com.kingdee.eas.fi.ar.ItemRptQueryParam;
import com.kingdee.eas.fi.ar.SummaryRptQueryParam;
import com.kingdee.eas.fi.ar.app.ISummItemRptSql;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public abstract class RptSqlTemplate
implements ISummItemRptSql {
    protected static final String AR_RES = "com.kingdee.eas.fi.ar.ArReport";
    protected static final String AP_RES = "com.kingdee.eas.fi.ap.ApReport";

    public abstract String tableName();

    public abstract String fldAsstActId();

    public abstract String fldCussTypeId();

    public abstract String fldBillType();

    public abstract String fldDate();

    public abstract String fldCurrency();

    public abstract String amtClause(boolean var1, boolean var2);

    public abstract String specifiedWhere(ArApQueryParam var1);

    public abstract String summAmtClause(boolean var1);

    public boolean isBill() {
        return false;
    }

    public int mainBillType() {
        return 0;
    }

    public abstract String fldAmt(boolean var1, boolean var2);

    public abstract String balAmtClause();

    public String fldAdmin() {
        return "FAdminOrgUnitId";
    }

    public String fldPerson() {
        return "FPersonID";
    }

    public String fldDescription() {
        return "t1.FAbstractName";
    }

    public String verifiedTypeFld() {
        return "";
    }

    public String verifyEntryJoinClause() {
        return "";
    }

    public String swapEntryJoinClause() {
        return "";
    }

    public String recPayTypeJoinClause() {
        return "";
    }

    public String fldRecPayType(String nameFld) {
        return "null";
    }

    public String fldVouNumber() {
        return " voucher.FNumber ";
    }

    public String vouNumJoinClause() {
        return "";
    }

    public String materialClause() {
        return " entry.FSeq FEntrySeq, entry.FId FEntryId, entry.FMaterialId, entry.FExpenseItemId, entry.FQuantity, ";
    }

    public String entryMaterialJoinClause() {
        return "  inner join " + this.tableName() + "Entry as entry on t1.FId = entry.FParentId ";
    }

    public String contractClause() {
        return " null FContractNumber, ";
    }

    public String contractEntryClause() {
        return " null FContractNumber, ";
    }

    public String entryContractJoinClause() {
        return " ";
    }

    public String setExcludeBizBill() {
        return "";
    }

    @Override
    public String getItemQuerySql(ItemRptQueryParam param, Locale locale) {
        boolean fSpAdminOrg = !StringUtils.isEmpty((String)param.getAdminOrgTempTable()) || !StringUtils.isEmpty((String)param.getPersonTempTable());
        String nameFld = "FName_" + locale.getLanguage();
        StringBuffer sql = new StringBuffer();
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" select t1.FID FBillId, baseCurrency.FNumber FBaseCurrNum ,");
            sql.append(" baseCurrency.").append(nameFld);
            sql.append(" FBaseCurrency, t3.").append(nameFld);
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" select t1.FID FBillId, t2.FNumber FCurrNum ,");
            sql.append(" t2.").append(nameFld);
            sql.append(" FCurrency, t3.").append(nameFld);
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" select t1.FID FBillId, t2.FNumber FCurrNum ,");
            sql.append(" t2.").append(nameFld);
            sql.append(" FCurrency, baseCurrency.FNumber FBaseCurrNum , baseCurrency.").append(nameFld);
            sql.append(" FBaseCurrency, t3.").append(nameFld);
        }
        sql.append(" FCussType,  ");
        sql.append(" t4.FNumber FCussNum, t4.").append(nameFld);
        sql.append(" FCussName, t4.FId FCussAcctId,");
        sql.append(" T5.").append(nameFld).append(" FAdminOrg,");
        sql.append(" T5.FNumber FAdminOrgNum, ");
        sql.append(this.isBill() ? "t1." : "entry.");
        sql.append(this.fldAdmin()).append(" FAdminOrgId, ");
        sql.append(" T6.").append(nameFld).append(" FPerson,");
        sql.append(" T6.FNumber FPersonNum, ");
        sql.append(this.isBill() ? "t1." : "entry.");
        sql.append(this.fldPerson()).append(" FPersonId, ");
        sql.append(" t1.").append(this.fldDate());
        sql.append(" FBillDate,  ").append(this.fldBillType());
        sql.append(" FBillType, ").append(this.fldRecPayType(nameFld));
        sql.append(" FRecPayType, t1.FNumber FBillNum, ");
        sql.append(" vType.").append(nameFld).append(" FVoucherType,");
        sql.append(" N'' || ").append(this.fldVouNumber()).append(" FVoucherNum, ");
        sql.append(this.isBill() ? this.fldDescription() : " N'' ");
        sql.append(" FDescription,  ");
        boolean fShowMaterialItem = param.isShowMaterialItem();
        if (fShowMaterialItem) {
            sql.append(this.contractEntryClause());
        } else {
            sql.append(this.contractClause());
        }
        if (fShowMaterialItem) {
            sql.append(this.materialClause());
        }
        sql.append(this.amtClause(fSpAdminOrg, fShowMaterialItem, param));
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" 0 FBalanceAmtLocal,  '").append(param.getPeriodId());
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" 0 FBalanceAmt,  '").append(param.getPeriodId());
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" 0 FBalanceAmt, 0 FBalanceAmtLocal, '").append(param.getPeriodId());
        }
        sql.append("' FPeriodId, t7.FPeriodYear, t7.FPeriodNumber, ");
        sql.append(this.mainBillType());
        sql.append(" FMainBillType, ").append(2);
        sql.append(" FDataType,newbosid('ARAPItem') FBosID");
        sql.append(" from ").append(this.tableName()).append(" AS t1");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" INNER JOIN T_ORG_Company company ON company.FID=t1.FCompanyId").append("\r\n");
            sql.append(" INNER JOIN T_BD_Currency baseCurrency ON baseCurrency.FID=company.FBaseCurrencyID");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append("  inner join T_BD_Currency AS t2 ON t1.");
            sql.append(this.fldCurrency()).append(" = t2.FID ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append("  inner join T_BD_Currency AS t2 ON t1.");
            sql.append(this.fldCurrency()).append(" = t2.FID ");
            sql.append(" INNER JOIN T_ORG_Company company ON company.FID=t1.FCompanyId").append("\r\n");
            sql.append(" INNER JOIN T_BD_Currency baseCurrency ON baseCurrency.FID=company.FBaseCurrencyID");
        }
        sql.append("  inner join t_bd_asstActType t3 on t1.");
        sql.append(this.fldCussTypeId()).append(" = t3.FID ");
        sql.append("  inner join ").append(param.getCussAcctTempTable());
        sql.append(" t4 on t1.").append(this.fldAsstActId()).append(" = t4.FID ");
        sql.append("  left join T_GL_Voucher voucher on ");
        sql.append(" t1.FVoucherId = voucher.FId");
        sql.append("  left join T_BD_VoucherTypes vType on ");
        sql.append(" voucher.FVoucherTypeID = vType.FId");
        sql.append(fSpAdminOrg ? this.verifyEntryJoinClause() : "");
        this.joinClause(param, sql);
        sql.append("  inner join t_bd_period t7 on ");
        sql.append(" t7.FId = '").append(param.getPeriodId()).append("' ");
        sql.append(this.recPayTypeJoinClause());
        sql.append(this.vouNumJoinClause());
        if (fShowMaterialItem) {
            sql.append(this.entryMaterialJoinClause());
        }
        sql.append("  where 1= 1");
        this.whereClause(param, sql);
        if (fSpAdminOrg && !this.isBill() && !fShowMaterialItem) {
            if ("base".equals(param.getCurrencyId())) {
                sql.append("  group by t1.FId, baseCurrency.FNumber");
                sql.append(", baseCurrency.").append(nameFld);
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                sql.append("  group by t1.FId, t2.FNumber");
                sql.append(", t2.").append(nameFld);
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                sql.append("  group by t1.FId, t2.FNumber");
                sql.append(", t2.").append(nameFld);
                sql.append(", baseCurrency.FNumber, baseCurrency.").append(nameFld);
            }
            sql.append(", t3.").append(nameFld);
            sql.append(", t4.").append(nameFld);
            sql.append(", t4.FNumber, t4.FId, t5.").append(nameFld);
            sql.append(",  t5.FNumber");
            sql.append(", vType.").append(nameFld);
            sql.append(", ").append(this.fldVouNumber());
            sql.append(", entry.").append(this.fldAdmin());
            sql.append(", t6.").append(nameFld);
            sql.append(", t6.FNumber,  ");
            sql.append("entry.").append(this.fldPerson());
            sql.append(", t1.").append(this.fldDate());
            sql.append(", t1.FVerificationType, t1.FNumber");
            sql.append(", t7.FPeriodYear, t7.FPeriodNumber");
            sql.append(fShowMaterialItem ? ", entry.FId, entry.FMaterialId" : "");
        }
        return sql.toString();
    }

    private void joinClause(ItemRptQueryParam param, StringBuffer sql) {
        sql.append(" INNER JOIN ");
        sql.append(param.getAdminOrgTempTable());
        sql.append(" T5 ON ");
        sql.append(" ( ");
        sql.append(this.isBill() ? "t1." : "entry.");
        sql.append(this.fldAdmin());
        sql.append(" = T5.fid");
        if (param.isIncludeNullAdmin()) {
            sql.append(" OR (");
            sql.append(this.isBill() ? "t1." : "entry.");
            sql.append(this.fldAdmin());
            sql.append(" IS NULL ");
            sql.append(" AND T5.fid IS NULL");
            sql.append(" )");
        }
        sql.append(" ) ");
        sql.append(" INNER JOIN ");
        sql.append(param.getPersonTempTable());
        sql.append(" T6 ON ");
        sql.append(" ( ");
        sql.append(this.isBill() ? "t1." : "entry.");
        sql.append(this.fldPerson());
        sql.append(" = T6.fid");
        if (param.isIncludeNullPerson()) {
            sql.append(" OR (");
            sql.append(this.isBill() ? "t1." : "entry.");
            sql.append(this.fldPerson());
            sql.append(" IS NULL ");
            sql.append(" AND T6.fid IS NULL");
            sql.append(" )");
        }
        sql.append(" ) ");
    }

    private void whereClause(ItemRptQueryParam param, StringBuffer sql) {
        if (!param.isAllCurrency()) {
            sql.append(" and t1.").append(this.fldCurrency()).append(" = '");
            sql.append(param.getCurrencyId()).append("' ");
        }
        sql.append(this.specifiedWhere((ArApQueryParam)param));
        if (!param.isIncludeBizBill()) {
            sql.append(this.setExcludeBizBill());
        }
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
        sql.append("  and t1.").append(this.fldCussTypeId());
        sql.append(" = '").append(param.getCussTypeId());
        sql.append("' and t1.FCOMPANYID = '");
        sql.append(param.getCompanyId()).append("' ");
        sql.append("  and t1.").append(this.fldDate());
        sql.append(" >= {");
        sql.append(dtFormat.format(param.getBeginDate()));
        sql.append("}  and t1.").append(this.fldDate());
        sql.append(" < {");
        sql.append(dtFormat.format(param.getEndDate()));
        sql.append("} ");
    }

    public String adminOrgWhere(String adminOrgIds) {
        if (!StringUtils.isEmpty((String)adminOrgIds)) {
            return " and entry.FAdminOrgUnitId in (" + adminOrgIds + ")  ";
        }
        return "";
    }

    public String personWhere(String personIds) {
        if (!StringUtils.isEmpty((String)personIds)) {
            return " and entry.FPersonId in (" + personIds + ")  ";
        }
        return "";
    }

    @Override
    public String getSummQuerySql(ItemRptQueryParam param, Locale locale) {
        String nameFld = "FName_" + locale.getLanguage();
        boolean fSpAdminOrg = !StringUtils.isEmpty((String)param.getAdminOrgTempTable()) || !StringUtils.isEmpty((String)param.getPersonTempTable());
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.FCompanyId FCompanyId");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(", company.FBaseCurrencyID");
            sql.append(", t1.").append(this.fldCussTypeId()).append(" FAsstActTypeID");
            sql.append(", t1.").append(this.fldAsstActId()).append(" FAsstActId");
            sql.append(",  t5.").append(nameFld).append(" FAdminOrg ");
            sql.append(", t5.FId FAdminOrgId ");
            sql.append(", t6.").append(nameFld).append(" FPerson ");
            sql.append(", t6.FId FPersonId ");
            sql.append(",  ").append(this.summAmtClause(fSpAdminOrg, param));
            sql.append("  from ");
            sql.append(this.tableName()).append(" AS t1");
            sql.append(fSpAdminOrg ? this.verifyEntryJoinClause() : "");
            sql.append(" INNER JOIN T_ORG_Company company ON company.FID=t1.FCompanyId").append("\r\n");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(", t1.").append(this.fldCurrency()).append(" FCurrencyId");
            sql.append(", t1.").append(this.fldCussTypeId()).append(" FAsstActTypeID");
            sql.append(", t1.").append(this.fldAsstActId()).append(" FAsstActId");
            sql.append(",  t5.").append(nameFld).append(" FAdminOrg ");
            sql.append(", t5.FId FAdminOrgId ");
            sql.append(", t6.").append(nameFld).append(" FPerson ");
            sql.append(", t6.FId FPersonId ");
            sql.append(",  ").append(this.summAmtClause(fSpAdminOrg, param));
            sql.append("  from ");
            sql.append(this.tableName()).append(" AS t1");
            sql.append(fSpAdminOrg ? this.verifyEntryJoinClause() : "");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(", t1.").append(this.fldCurrency()).append(" FCurrencyId");
            sql.append(", company.FBaseCurrencyID");
            sql.append(", t1.").append(this.fldCussTypeId()).append(" FAsstActTypeID");
            sql.append(", t1.").append(this.fldAsstActId()).append(" FAsstActId");
            sql.append(",  t5.").append(nameFld).append(" FAdminOrg ");
            sql.append(", t5.FId FAdminOrgId ");
            sql.append(", t6.").append(nameFld).append(" FPerson ");
            sql.append(", t6.FId FPersonId ");
            sql.append(",  ").append(this.summAmtClause(fSpAdminOrg, param));
            sql.append("  from ");
            sql.append(this.tableName()).append(" AS t1");
            sql.append(fSpAdminOrg ? this.verifyEntryJoinClause() : "");
            sql.append(" INNER JOIN T_ORG_Company company ON company.FID=t1.FCompanyId").append("\r\n");
        }
        sql.append("  inner join ").append(param.getCussAcctTempTable());
        sql.append(" tt on t1.").append(this.fldAsstActId()).append(" = tt.FId ");
        if (param.isIncludeNullAdmin()) {
            sql.append("  left join t_org_admin ");
        } else {
            sql.append("  inner join ");
            sql.append(param.getAdminOrgTempTable());
        }
        sql.append(" t5 on ").append(this.isBill() ? "t1." : "entry.");
        sql.append(this.fldAdmin()).append(" = t5.FID ");
        if (param.isIncludeNullPerson()) {
            sql.append("  left join t_bd_person ");
        } else {
            sql.append("  inner join ");
            sql.append(param.getPersonTempTable());
        }
        sql.append(" t6 on ").append(this.isBill() ? "t1." : "entry.");
        sql.append(this.fldPerson()).append(" = t6.FID ");
        sql.append("  where 1= 1");
        sql.append(" and t1.").append(this.fldAsstActId());
        sql.append(" in (select FId from ");
        sql.append(param.getCussAcctTempTable()).append(")  ");
        this.whereClause(param, sql);
        if (fSpAdminOrg && !this.isBill()) {
            sql.append("  group by t1.FCompanyId, t1.");
            sql.append(this.fldAsstActId());
            if ("base".equals(param.getCurrencyId())) {
                sql.append(", company.FBaseCurrencyID");
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                sql.append(", t1.").append(this.fldCurrency());
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                sql.append(", t1.").append(this.fldCurrency());
                sql.append(", company.FBaseCurrencyID");
            }
            sql.append(", t1.").append(this.fldDate());
            sql.append(", t1.").append(this.fldCussTypeId());
            sql.append(", t5.").append(nameFld);
            sql.append(", t5.FId, t6.").append(nameFld);
            sql.append(", t6.FId ");
        }
        return sql.toString();
    }

    public abstract String summAmtClause(boolean var1, SummaryRptQueryParam var2);

    public abstract String summAmtClause(boolean var1, ItemRptQueryParam var2);

    public abstract String amtClause(boolean var1, boolean var2, ItemRptQueryParam var3);

    @Override
    public String getCompanysSummQuerySql(SummaryRptQueryParam param) {
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.FCompanyId FCompanyId");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(", company.").append("FBaseCurrencyID").append("\r\n");
            sql.append(", t1.").append(this.fldCussTypeId()).append(" FAsstActTypeID");
            sql.append(",  t1.").append(this.fldAsstActId()).append(" FAsstActId");
            sql.append(", ").append(this.summAmtClause(false, param));
            sql.append("  from ");
            sql.append(this.tableName()).append(" AS t1");
            sql.append(" INNER JOIN T_ORG_Company company ON company.FID=t1.FCompanyId").append("\r\n");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(", t1.").append(this.fldCurrency()).append(" FCurrencyId");
            sql.append(", t1.").append(this.fldCussTypeId()).append(" FAsstActTypeID");
            sql.append(",  t1.").append(this.fldAsstActId()).append(" FAsstActId");
            sql.append(", ").append(this.summAmtClause(false, param));
            sql.append("  from ");
            sql.append(this.tableName()).append(" AS t1");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(", t1.").append(this.fldCurrency()).append(" FCurrencyId");
            sql.append(", company.").append("FBaseCurrencyID").append("\r\n");
            sql.append(", t1.").append(this.fldCussTypeId()).append(" FAsstActTypeID");
            sql.append(",  t1.").append(this.fldAsstActId()).append(" FAsstActId");
            sql.append(", ").append(this.summAmtClause(false, param));
            sql.append("  from ");
            sql.append(this.tableName()).append(" AS t1");
            sql.append(" INNER JOIN T_ORG_Company company ON company.FID=t1.FCompanyId").append("\r\n");
        }
        sql.append("  where 1= 1 ");
        sql.append(this.specifiedWhere(param));
        sql.append(" and t1.").append(this.fldAsstActId());
        sql.append(" in (select FId from ");
        sql.append(param.getCussAcctTempTable()).append(") ");
        if (!param.isAllCurrency()) {
            sql.append("  and t1.").append(this.fldCurrency()).append(" = '");
            sql.append(param.getCurrencyId()).append("' ");
        }
        sql.append("  and t1.").append(this.fldCussTypeId()).append(" = '");
        sql.append(param.getCussTypeId()).append("' ");
        sql.append(" and t1.FCompanyId = '");
        sql.append(param.getCompanyId());
        sql.append("' ");
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
        sql.append("  and t1.").append(this.fldDate()).append(" >= {");
        sql.append(dtFormat.format(param.getBeginDate()));
        sql.append("} and t1.").append(this.fldDate()).append(" < {");
        sql.append(dtFormat.format(param.getEndDate()));
        sql.append("} ");
        return sql.toString();
    }

    @Override
    public String getArrearageBizAmtQuerySql(ArrearageQueryParam param, Date beginDate, Date endDate) {
        Date endNxtDate = new Date(endDate.getTime() + 86400000L);
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append(this.fldCussTypeId());
        sql.append(" FAsstActTypeId, ");
        sql.append(this.fldAsstActId()).append(" FAsstActId, ");
        sql.append(this.fldCurrency()).append(" FCurrencyId, ");
        sql.append(this.balAmtClause()).append(" FBalance  from ");
        sql.append(this.tableName()).append(" t1   inner join ");
        sql.append(param.getCussAcctTempTable());
        sql.append(" tAsstAct on t1.").append(this.fldAsstActId());
        sql.append(" = tAsstAct.Fid  where 1 =1 ").append(this.specifiedWhere(param));
        if (!param.isIncludeBizBill()) {
            sql.append(this.setExcludeBizBill());
        }
        sql.append(" and t1.FCompanyId = '").append(param.getCompanyId());
        sql.append("'  and ").append(this.fldDate()).append(" >= {");
        sql.append(dtFormat.format(beginDate));
        sql.append("} and ").append(this.fldDate()).append(" < {");
        sql.append(dtFormat.format(endNxtDate));
        sql.append("} ");
        if (!param.isAllCurrency()) {
            sql.append("  and ").append(this.fldCurrency()).append(" = '");
            sql.append(param.getCurrencyId()).append("' ");
        }
        return sql.toString();
    }
}

