/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.netctrl.app.MutexService;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.VerificationEnum;
import com.kingdee.eas.fi.ar.IVerificationBill;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.VerificationBillCollection;
import com.kingdee.eas.fi.ar.VerificationBillFactory;
import com.kingdee.eas.fi.ar.VerificationBillInfo;
import com.kingdee.eas.fi.ar.VerificationBillentryCollection;
import com.kingdee.eas.fi.ar.VerificationBillentryInfo;
import com.kingdee.eas.fi.ar.app.AbstractVerificationBillControllerBean;
import com.kingdee.eas.fi.ar.app.util.ArServerUtils;
import com.kingdee.eas.fi.arap.ARAPVerifynException;
import com.kingdee.eas.fi.arap.VerificationBillBaseInfo;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApParamsUtil;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class VerificationBillControllerBean
extends AbstractVerificationBillControllerBean {
    private static Logger logger = Logger.getLogger(VerificationBillControllerBean.class);

    @Override
    protected boolean _isVouchered(Context ctx, String billID) throws BOSException, EASBizException {
        String sql = "select ffivouchered from T_AR_VerificationBill where fid = ? ";
        ArrayList<String> vs = new ArrayList<String>();
        vs.add(billID);
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])vs.toArray());
        try {
            if (result.next()) {
                return result.getBoolean("ffivouchered");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return false;
    }

    @Override
    protected RowSet _getBillIDs(Context ctx, String[] billIDs) throws BOSException {
        if (billIDs != null && billIDs.length > 0) {
            StringBuffer sql = new StringBuffer("select t2.fbillid as billid,t1.FCompanyID FCompanyID,t1.FCreatorID FCreatorID,t1.FID FID ");
            sql.append("from T_AR_VerificationBill t1");
            sql.append("\tinner join T_AR_VerificationBillEntry t2 on t1.fid = t2.fparentid where ");
            for (int i = 0; i < billIDs.length; ++i) {
                if (i == 0) {
                    sql.append("t1.fid = '").append(billIDs[i]).append("' ");
                    continue;
                }
                sql.append("or t1.fid = '").append(billIDs[i]).append("' ");
            }
            return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        return null;
    }

    @Override
    protected boolean _isLocked(Context ctx, String billID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("select t2.fbillid as billid ");
        sql.append("from T_AR_VerificationBill t1");
        sql.append("\tinner join T_AR_VerificationBillEntry t2 on t1.fid = t2.fparentid ");
        sql.append("where t1.fid = ? ");
        ArrayList<String> vs = new ArrayList<String>();
        vs.add(billID);
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])vs.toArray());
        try {
            MutexService mutex = MutexService.getInstance();
            while (result.next()) {
                String srcBillID = result.getString("billid");
                if (mutex.requestObjIDForUpdate(ctx, srcBillID)) {
                    mutex.releaseObjIDForUpdate(ctx, srcBillID);
                    continue;
                }
                return true;
            }
        }
        catch (SQLException ex) {
            throw new SQLDataException(ex);
        }
        return false;
    }

    @Override
    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo botRelation = (BOTRelationInfo)bOTRelationInfo;
        VerificationBillInfo billInfo = null;
        if ("2652E01E".equals(botRelation.getDestEntityID())) {
            billInfo = this.getVerificationBillInfo(ctx, srcBillPK);
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                billInfo.setFiVouchered(false);
                billInfo.setVoucher(null);
                billInfo.setVoucherType(null);
            } else {
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(botRelation.getDestObjectID()));
                billInfo.setVoucher(voucherInfo);
                billInfo.setFiVouchered(true);
                billInfo.setVoucherNumber(voucherInfo.getNumber());
                billInfo.setVoucherType(voucherInfo.getVoucherType());
            }
        }
        super._reverseSave(ctx, srcBillPK, (IObjectValue)billInfo, bOTBillOperStateEnum, bOTRelationInfo);
    }

    @Override
    protected void _unVerify(Context ctx, Collection billIDs, boolean checkBizBill) throws BOSException, EASBizException {
        super._unVerify(ctx, billIDs, checkBizBill);
    }

    @Override
    protected void _unVeriCheck(Context ctx, String ids, Collection billIDs, List lockObjs, boolean checkBizBill) throws BOSException, EASBizException {
        IObjectPK[] col = this.getPKList(ctx, "select id, number where id in(" + ids + ") and fivouchered=1");
        if (col != null && col.length > 0) {
            throw new ARAPVerifynException(ARAPVerifynException.VERIBILL_HASVOUCHERED);
        }
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        RowSet rs = this.getBillIDs(ctx, billIDs.toArray(new String[0]));
        UserInfo defaultUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        boolean dataMutex = false;
        VerificationBillCollection billColl = new VerificationBillCollection();
        try {
            ArrayList<String> requestLockIDList = new ArrayList<String>();
            ArrayList<String> otherLockedList = new ArrayList<String>();
            while (rs.next()) {
                String billID = rs.getString("billid");
                if (!requestLockIDList.contains(billID)) {
                    requestLockIDList.add(billID);
                }
                VerificationBillInfo info = new VerificationBillInfo();
                CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
                companyInfo.setId(BOSUuid.read((String)rs.getString("FCompanyID")));
                info.setCompany(companyInfo);
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                if (rs.getString("FCreatorID") != null) {
                    UserInfo userInfo = new UserInfo();
                    userInfo.setId(BOSUuid.read((String)rs.getString("FCreatorID")));
                    info.setCreator(userInfo);
                }
                billColl.add(info);
            }
            if (requestLockIDList != null && requestLockIDList.size() > 0) {
                Map map = mutex.batchRequestObjIDForUpdate(requestLockIDList);
                String id = null;
                int size = requestLockIDList.size();
                for (int i = 0; i < size; ++i) {
                    id = (String)requestLockIDList.get(i);
                    if (((Boolean)map.get(id)).booleanValue()) {
                        lockObjs.add(id);
                        continue;
                    }
                    otherLockedList.add(id);
                }
                if (otherLockedList.size() > 0) {
                    mutex.batchReleaseObjIDForUpdate(lockObjs);
                    throw new ARAPVerifynException(ARAPVerifynException.VERIBILL_MUTEXTERROR);
                }
            }
            if (checkBizBill && (rs = DBUtil.executeQuery((Context)ctx, (String)("SELECT TOP 1 1 FROM T_AR_OTHERBILL F  WHERE  EXISTS (SELECT 1 FROM T_AR_VERIFICATIONBILLENTRY C WHERE C.FPARENTID IN (" + ArApBillHelper.ids2SqlString(billIDs) + ") AND C.FBILLID=F.FID) AND F.FISBIZBILL = 1"))).next()) {
                throw new ARAPVerifynException(ARAPVerifynException.BIZVERIBILLCANNOTUNVERI);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        VerificationBillInfo info = null;
        UserInfo userInfo = null;
        String value = null;
        int size = billColl.size();
        for (int i = 0; i < size; ++i) {
            info = billColl.get(i);
            if (!paramMap.containsKey(info.getCompany().getId().toString())) {
                value = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"AR_036");
                paramMap.put(info.getCompany().getId().toString(), value);
            } else {
                value = paramMap.get(info.getCompany().getId().toString()).toString();
            }
            if (value == null || !"true".equalsIgnoreCase(value) && !"1".equalsIgnoreCase(value) || (userInfo = ContextUtil.getCurrentUserInfo((Context)ctx)) == null || info.getCreator() == null || userInfo.getId().toString().equals(info.getCreator().getId().toString())) continue;
            throw new ARAPVerifynException(ARAPVerifynException.ARAPBILL_IS_SAMEVERIFY_PERSON);
        }
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectPK[] sourceBillPkList, IObjectPK botMappingPK, SelectorItemCollection botpSelectors) throws BOSException, EASBizException {
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < sourceBillPkList.length; ++i) {
            ids.append("'");
            ids.append(sourceBillPkList[i].toString());
            ids.append("',");
        }
        if (ids.length() > 0) {
            ids.deleteCharAt(ids.length() - 1);
        }
        DAPTransformResult dapTransformResult = null;
        if (this._isNeedCheckVoucherCondition()) {
            this._voucherCheck(ctx, sourceBillPkList);
        }
        IObjectPK logPk = this.writeVoucherLog(ctx, ids.toString(), true);
        dapTransformResult = super._generateVoucher(ctx, sourceBillPkList, botMappingPK, botpSelectors);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        return dapTransformResult;
    }

    protected void _voucherCheck(Context ctx, IObjectPK[] sourceBillPkList) throws EASBizException, BOSException {
        StringBuffer ids = new StringBuffer();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < sourceBillPkList.length; ++i) {
            idSet.add(sourceBillPkList[i].toString());
        }
        ids.append(ArApBillHelper.ids2SqlString(idSet));
        StringBuffer sql = new StringBuffer();
        IRowSet set = null;
        try {
            String id = null;
            if (ids.length() > 0) {
                sql.append("select distinct bill.fid from t_ar_verificationBill bill \n");
                sql.append(" inner join t_ar_verificationBillEntry entry on bill.fid=entry.fparentid \n");
                sql.append("where (entry.FGainAndLoss <> 0 or bill.fIsSameCurrency = 0) and  bill.fid in (");
                sql.append(ids.toString()).append(")");
                set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (set.next()) {
                    id = set.getString(1);
                    idSet.remove(id);
                }
                ids.setLength(0);
                ids.append(ArApBillHelper.ids2SqlString(idSet));
            }
            if (ids.length() > 0) {
                Boolean verifyCanVoucher = ArApParamsUtil.getBooleanBackgroundParam(ctx, "ARAP_VERIFY_CAN_VOUCHER");
                if (verifyCanVoucher.booleanValue()) {
                    sql.setLength(0);
                    sql.append("select distinct bill.fid from t_ar_verificationBill bill \n");
                    sql.append(" inner join t_ar_verificationBillEntry entry on bill.fid=entry.fparentid \n");
                    sql.append(" left join T_ar_otherBill otherBill on entry.fbillID = otherBill.fid \n");
                    sql.append(" where entry.FveriType = 1 and  bill.fid in (").append(ids.toString()).append(" )\n");
                    sql.append(" and bill.fisCashSalePur = 0 \n");
                    sql.append(" and ( otherBill.fisBizbill is null or otherBill.fisBizbill = 0 )\n");
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    while (rowSet.next()) {
                        id = rowSet.getString(1);
                        idSet.remove(id);
                    }
                }
                ids.setLength(0);
                ids.append(ArApBillHelper.ids2SqlString(idSet));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (ids.length() > 0) {
            VerificationBillCollection col = null;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            ev.setFilter(filter);
            ev.getSelector().add("id");
            ev.getSelector().add("entrys.billSubType");
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("verificationType", (Object)new Integer(101)));
            filter.getFilterItems().add(new FilterItemInfo("mainBillType", (Object)new Integer(8)));
            filter.getFilterItems().add(new FilterItemInfo("secondBillType", (Object)new Integer(8)));
            col = this.getVerificationBillCollection(ctx, ev);
            if (col.size() > 0) {
                throw new ARAPVerifynException(ARAPVerifynException.ARBILL_ONESIDE_VERI);
            }
            filter.getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("verificationType", (Object)new Integer(101)));
            filter.getFilterItems().add(new FilterItemInfo("mainBillType", (Object)new Integer(6)));
            filter.getFilterItems().add(new FilterItemInfo("secondBillType", (Object)new Integer(6)));
            col = this.getVerificationBillCollection(ctx, ev);
            VerificationBillentryCollection element = null;
            VerificationBillentryInfo entry = null;
            boolean isPreRec = false;
            boolean isRedPreRec = false;
            boolean noOtherRec = true;
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                element = ((VerificationBillInfo)iter.next()).getEntrys();
                Iterator iterator = element.iterator();
                while (iterator.hasNext()) {
                    entry = (VerificationBillentryInfo)iterator.next();
                    if (entry.getBillSubType().getValue() == 101) {
                        isPreRec = true;
                        continue;
                    }
                    if (entry.getBillSubType().getValue() == 103) {
                        isRedPreRec = true;
                        continue;
                    }
                    noOtherRec = false;
                    break;
                }
                if (isPreRec && isRedPreRec && noOtherRec) {
                    throw new ARAPVerifynException(ARAPVerifynException.RECBILL_ONESIDE_VERI);
                }
                isPreRec = false;
                isRedPreRec = false;
                noOtherRec = true;
            }
            String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            boolean isRec = ArServerUtils.isRecBillCreateVoucher(ctx, companyID);
            boolean isPreRecAcct = ArServerUtils.isPreRecAcct(ctx, companyID);
            boolean isCash = ArServerUtils.iscashbillCreatVoucher(ctx, companyID);
            if (isCash) {
                set = null;
                int size = 0;
                sql.setLength(0);
                sql.append("select count(distinct bill.fid) from t_ar_verificationBill bill \n");
                sql.append("where bill.fid in (");
                sql.append(ids.toString());
                sql.append(") and \n");
                sql.append(" bill.FISCASHSALEPUR =1 \n");
                set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                try {
                    if (set.next()) {
                        size = set.getInt(1);
                    }
                }
                catch (SQLException e) {
                    logger.info((Object)e);
                }
                if (size > 0) {
                    throw new OtherBillBizException(OtherBillBizException.CASH_RE_FORBIDENN_BILL);
                }
            } else {
                sql.setLength(0);
                sql.append("select bill.fid fid from t_ar_verificationBill bill \n");
                sql.append("where bill.fid in (");
                sql.append(ids.toString());
                sql.append(") and \n");
                sql.append(" bill.FISCASHSALEPUR =1 \n");
                set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                try {
                    while (set.next()) {
                        if (set.getString(1) == null || set.getString(1).toString().equals("")) continue;
                        idSet.remove(set.getString(1));
                    }
                }
                catch (SQLException e) {
                    logger.info((Object)e);
                }
            }
            if (isRec) {
                ids.setLength(0);
                for (int j = 0; j < idSet.size(); ++j) {
                    ids.append("'").append((String)idSet.toArray()[j]).append("'");
                    if (j >= idSet.size() - 1) continue;
                    ids.append(",");
                }
                if (ids.length() > 0) {
                    ArrayList<Integer> params = new ArrayList<Integer>();
                    sql.setLength(0);
                    set = null;
                    int size = 0;
                    sql.append("select count(distinct bill.fid) from t_ar_verificationBill bill \n");
                    sql.append(" inner join t_ar_verificationBillEntry entry on bill.fid=entry.fparentid \n");
                    sql.append("where bill.FISCASHSALEPUR =0 and bill.fid in (");
                    sql.append(ids.toString());
                    sql.append(") and \n");
                    try {
                        if (isPreRecAcct) {
                            sql.append("((FverificationType=? and (entry.fbillSubType=? or entry.fbillSubType=?)) or fverificationType<>?)");
                            params.add(new Integer(101));
                            params.add(new Integer(101));
                            params.add(new Integer(103));
                            params.add(new Integer(101));
                            set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
                            if (set.next()) {
                                size = set.getInt(1);
                            }
                            if (size < idSet.size()) {
                                throw new ARAPVerifynException(ARAPVerifynException.PARAM_ISRECT_PRERECACCTT);
                            }
                        } else {
                            sql.append(" FverificationType=? and entry.fbillSubType=?");
                            params.add(new Integer(101));
                            params.add(new Integer(100));
                            set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
                            if (set.next()) {
                                size = set.getInt(1);
                            }
                            if (size > 0) {
                                throw new ARAPVerifynException(ARAPVerifynException.PARAM_ISRECT_PRERECACCTF);
                            }
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    protected SystemEnum getSysEnum() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    @Override
    protected Collection _submitBills(Context ctx, List verificaionBillPairs, List arOtherBillPairs, List receivingBillPairs) throws BOSException {
        ArrayList<String> collection = new ArrayList<String>();
        int length = verificaionBillPairs.size();
        for (int i = 0; i < length; ++i) {
            List verificaionBills = (List)verificaionBillPairs.get(i);
            int subLength = verificaionBills.size();
            for (int j = 0; j < subLength; ++j) {
                try {
                    collection.add(VerificationBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)((VerificationBillInfo)verificaionBills.get(j))).toString());
                    continue;
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                    continue;
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            }
        }
        return collection;
    }

    protected IObjectValue getBizObject(Context ctx, String id) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IObjectValue objVal = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(pk.getObjectType(), (IObjectPK)pk, sic);
        return objVal;
    }

    private void setVerificationBillInfo(Context ctx, VerificationBillInfo verificaionBill, String topAssActID, String botAssActID) throws BOSException {
        IObjectValue objValue = this.getBizObject(ctx, topAssActID);
        String mainAssActID = objValue.getString("id");
        String mainAcctCussName = objValue.getString("name");
        objValue = this.getBizObject(ctx, botAssActID);
        String secondAssActID = objValue.getString("id");
        String secondAcctCussName = objValue.getString("name");
        verificaionBill.put("mainAcctCussID", BOSUuid.read((String)mainAssActID));
        verificaionBill.put("mainAcctCussName", mainAcctCussName);
        verificaionBill.put("secondAcctCussID", BOSUuid.read((String)secondAssActID));
        verificaionBill.put("secondAcctCussName", secondAcctCussName);
        boolean isSameCode = this.isSameBizCode(ctx, topAssActID, botAssActID);
        VerificationEnum veriType = VerificationEnum.AR_Rec;
        if (!isSameCode) {
            veriType = VerificationEnum.AR_Rec_AB;
        }
        verificaionBill.setVerificationType(veriType);
        verificaionBill.setIsSameCode(isSameCode);
    }

    private boolean isSameBizCode(Context ctx, String topAssactID, String botAssactID) throws BOSException {
        boolean isSameCode = false;
        if (topAssactID != null && botAssactID != null) {
            if (!botAssactID.equals(topAssactID)) {
                String bizCode = "bizAnalysisCode";
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo(bizCode));
                ObjectUuidPK pk = new ObjectUuidPK(topAssactID);
                IObjectValue val1 = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(pk.getObjectType(), (IObjectPK)pk, selectors);
                pk = new ObjectUuidPK(botAssactID);
                IObjectValue val2 = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(pk.getObjectType(), (IObjectPK)pk, selectors);
                if (val1 != null && val2 != null && val1.get(bizCode) != null && val1.get(bizCode).equals(val2.get(bizCode))) {
                    isSameCode = true;
                }
            } else {
                isSameCode = true;
            }
        }
        return isSameCode;
    }

    protected boolean _isNeedCheckVoucherCondition() {
        return true;
    }

    @Override
    protected void _reverse(Context ctx, String[] idArr, Date verifyDate) throws BOSException, EASBizException {
        this.entryTab = "T_AR_VerificationBillentry";
        IVerificationBill rmi = VerificationBillFactory.getLocalInstance(ctx);
        this.reverse(ctx, rmi, idArr, verifyDate);
    }

    @Override
    protected void _unReverse(Context ctx, String[] idArr) throws BOSException, EASBizException {
        this.entryTab = "T_AR_VerificationBillentry";
        IVerificationBill rmi = VerificationBillFactory.getLocalInstance(ctx);
        this.unReverse(ctx, rmi, idArr);
    }

    @Override
    protected AbstractObjectCollection getVerificationEntrys(VerificationBillBaseInfo redInfo) {
        return ((VerificationBillInfo)redInfo).getEntrys();
    }

    @Override
    protected void dispose(Context ctx, String veriBillIdsSqlStr, boolean veriOrUnVeri) throws BOSException, EASBizException {
    }

    @Override
    protected boolean isAR() {
        return true;
    }
}

