/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ar.AbstractArApBillBaseInfo;
import com.kingdee.eas.fi.arap.app.service.handler.ArApServiceHandler;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.util.RecPayServiceUtil;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasForArApException;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.ReceivingBillDataProcess;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeCollection;
import com.kingdee.eas.fi.cas.ReceivingBillTypeFactory;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.service.RecSaveService;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;

public class ArRecSaveService
extends RecSaveService {
    private ArApServiceHandler apapServiceHandler = new ArApServiceHandler();

    public void initService(Context ctx, IObjectValue value) throws EASBizException, BOSException {
        super.initService(ctx, value);
    }

    public void beforeSave() throws EASBizException, BOSException {
        int size;
        int i;
        PeriodInfo period;
        super.beforeSave();
        if (this.info.getSourceSysType() == null) {
            this.info.setSourceSysType(SourceTypeEnum.AR);
        }
        if (this.info.getSourceType() == null) {
            this.info.setSourceType(this.info.getSourceSysType());
        }
        if (this.info.getBizDate() == null) {
            this.info.setBizDate(new Date());
        }
        if ((period = this.serviceHandler.checkSystemIfStart(this.ctx, SystemEnum.ACCOUNTSRECEIVABLE, this.info.getCompany())) == null) {
            throw new RecPayException(RecPayException.AR_SYSTEM_NO_PERIOD);
        }
        ReceivingBillEntryCollection entrys = this.info.getEntries();
        if (entrys != null) {
            for (i = entrys.size() - 1; i >= 0; --i) {
                BigDecimal amount = entrys.get(i).getAmount();
                if (amount != null && amount.compareTo(BigDecimal.ZERO) != 0) continue;
                entrys.remove(entrys.get(i));
            }
        }
        if (this.info.getEntries() == null || this.info.getEntries().size() == 0) {
            this.apapServiceHandler.throwSaveExcetion(this.ctx, "noEntryNoSave");
        }
        if (this.info.isIsImport() && this.info.isIsInitializeBill()) {
            size = this.info.getEntries().size();
            for (i = 0; i < size; ++i) {
                this.info.getEntries().get(i).setRecBillType(this.info.getRecBillType());
            }
        }
        this.arapHelper.verifyAccountView(this.ctx, this.info.getPayeeAccount(), this.info.getCurrency(), this.info.getCompany());
        if (this.info.getId() != null && !this.isAddNew) {
            if (this.info.getBillStatus().getValue() == 11) {
                throw new CasForArApException(CasForArApException.SUBMMITED_CANNNOTSAVE);
            }
            if (this.info.getBillStatus().getValue() >= 12) {
                throw new CasForArApException(CasForArApException.BILLISAUDITED);
            }
        }
        if (this.info.getRecBillType() != null) {
            size = this.info.getEntries().size();
            for (i = 0; i < size; ++i) {
                if (this.info.getEntries().get(i).getRecBillType() != null && !this.info.isIsInitializeBill()) continue;
                this.info.getEntries().get(i).setRecBillType(this.info.getRecBillType());
            }
        }
        if (this.info.getCU() == null && this.info.getCompany().getCU() != null) {
            if (null != this.info.getCompany().getCU().getNumber() && null != this.info.getCompany().getCU().getName() && null != this.info.getCompany().getCU().getCode()) {
                this.info.setCU(this.info.getCompany().getCU());
            } else {
                String CUID = this.info.getCompany().getCU().getId().toString();
                CtrlUnitInfo CU = CtrlUnitFactory.getLocalInstance((Context)this.ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(CUID));
                this.info.setCU(CU);
            }
        }
        this.checkBizData();
        if (this.info.isIsTransBill()) {
            StringBuffer sb = new StringBuffer("");
            if (this.info.isIsTransOtherBill()) {
                AbstractArApBillBaseInfo sourceBillInfo = null;
                if (this.info.getSourceBillId() == null) {
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"srcBillIDIsNull", (Locale)this.ctx.getLocale())).append(";\n");
                } else if (new OtherBillInfo().getBOSType().equals((Object)BOSUuid.read((String)this.info.getSourceBillId()).getType())) {
                    sourceBillInfo = OtherBillFactory.getLocalInstance(this.ctx).getOtherBillInfo("SELECT adminOrgUnit, person WHERE id = '" + this.info.getSourceBillId() + "'");
                }
                if (sourceBillInfo != null && sourceBillInfo.getAdminOrgUnit() != null && this.info.getAdminOrgUnitId_SourceBill() == null) {
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"srcOUIDIsNull", (Locale)this.ctx.getLocale())).append(";\n");
                }
                if (sourceBillInfo != null && sourceBillInfo.getPerson() != null && this.info.getPersonID_SourceBill() == null) {
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"srcPersonIDIsNull", (Locale)this.ctx.getLocale())).append(";\n");
                }
                if (this.info.getAsstActTypeID_SourceBill() == null) {
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"srcAsstActTypeIDIsNull", (Locale)this.ctx.getLocale())).append(";\n");
                }
                if (this.info.getAsstActID_SourceBill() == null) {
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"srcAcctCussentIDIsNull", (Locale)this.ctx.getLocale())).append(";\n");
                }
                if (this.info.getBillDate_SourceBill() == null) {
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"srcBillDateIsNull", (Locale)this.ctx.getLocale())).append(";\n");
                }
                if (sb.length() > 0) {
                    throw new CasForArApException(CasForArApException.TRANSFAILED, new Object[]{sb.toString()});
                }
            } else {
                ReceivingBillInfo sourceBillInfo = null;
                if (this.info.getSourceBillId() == null) {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"srcBillIDIsNull", (Locale)this.ctx.getOriginLocale())).append(";\n");
                } else {
                    sourceBillInfo = ReceivingBillFactory.getLocalInstance((Context)this.ctx).getReceivingBillInfo("SELECT adminOrgUnit, person WHERE id = '" + this.info.getSourceBillId() + "'");
                }
                if (sourceBillInfo != null && sourceBillInfo.getAdminOrgUnit() != null && this.info.getAdminOrgUnitId_SourceBill() == null) {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"srcOUIDIsNull", (Locale)this.ctx.getOriginLocale())).append(";\n");
                }
                if (sourceBillInfo != null && sourceBillInfo.getPerson() != null && this.info.getPersonID_SourceBill() == null) {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"srcPersonIDIsNull", (Locale)this.ctx.getOriginLocale())).append(";\n");
                }
                if (this.info.getAsstActTypeID_SourceBill() == null) {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"srcAsstActTypeIDIsNull", (Locale)this.ctx.getOriginLocale())).append(";\n");
                }
                if (sourceBillInfo != null && sourceBillInfo.getPayerID() != null && this.info.getAsstActID_SourceBill() == null) {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"srcAcctCussentIDIsNull", (Locale)this.ctx.getOriginLocale())).append(";\n");
                }
                if (this.info.getBillDate_SourceBill() == null) {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"srcBillDateIsNull", (Locale)this.ctx.getOriginLocale())).append(";\n");
                }
                if (sb.length() > 0) {
                    throw new CasForArApException(CasForArApException.TRANSFAILED, new Object[]{sb.toString()});
                }
            }
        }
        BigDecimal verifyAmont = null;
        BigDecimal recAmont = null;
        int size2 = this.info.getEntries().size();
        for (int i2 = 0; i2 < size2; ++i2) {
            verifyAmont = this.info.getEntries().get(i2).getAmountVc() == null ? SysConstant.BIGZERO : this.info.getEntries().get(i2).getAmountVc();
            BigDecimal bigDecimal = recAmont = this.info.getEntries().get(i2).getAmount() == null ? SysConstant.BIGZERO : this.info.getEntries().get(i2).getAmount();
            if (SysConstant.BIGZERO.compareTo(verifyAmont) == 0 || recAmont.abs().compareTo(verifyAmont.abs()) > 0) continue;
            throw new CasForArApException(CasForArApException.VERIFYAMT_NO_MORETHAN_RECPAYAMOUNT);
        }
        this.apapServiceHandler.checkNumber(this.ctx, (RecPayBillInfo)this.info);
        if (this.info.getBillStatus() == null || this.info.getBillStatus() != BillStatusEnum.SAVE) {
            this.info.setBillStatus(BillStatusEnum.SAVE);
        }
        boolean isHasValue = false;
        String tableName = "T_CAS_ReceivingBillEntry";
        HashSet<String> idSet = new HashSet<String>();
        int size3 = this.info.getEntries().size();
        for (int i3 = 0; i3 < size3; ++i3) {
            if (this.info.getEntries().get(i3) == null || this.info.getEntries().get(i3).getId() == null) continue;
            idSet.add(this.info.getEntries().get(i3).getId().toString());
        }
        if (SCMServerUtils.isExistsBizFlowField((Context)this.ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)this.ctx, (String)tableName, idSet)) {
            isHasValue = true;
        }
        RecPayServiceUtil.reverseRecAmountFields(this.ctx, this.info, BatchActionEnum.SAVE, isHasValue);
        RecPayServiceUtil.reverseRecPayLockAmt(this.ctx, (RecPayBillInfo)this.info, true);
        this.serviceHandler.checkIsInQueue(this.ctx, this.info);
        ReceivingBillDataProcess.setAmountProp((Context)this.ctx, (ReceivingBillInfo)this.info);
        if (this.info.getRecBillType() != null) {
            HashSet<String> recTypeIDSet = new HashSet<String>();
            int size4 = this.info.getEntries().size();
            for (int i4 = 0; i4 < size4; ++i4) {
                if (this.info.getEntries().get(i4).getRecBillType() == null) continue;
                recTypeIDSet.add(String.valueOf(this.info.getEntries().get(i4).getRecBillType().getId()));
            }
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("number"));
            view.getSelector().add(new SelectorItemInfo("isPreSet"));
            view.getSelector().add(new SelectorItemInfo("preSetBillType.id"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", recTypeIDSet, CompareType.INCLUDE));
            view.setFilter(filter);
            ReceivingBillTypeCollection recTypeColl = ReceivingBillTypeFactory.getLocalInstance((Context)this.ctx).getReceivingBillTypeCollection(view);
            ReceivingBillEntryInfo entryInfo = null;
            int size5 = this.info.getEntries().size();
            for (int i5 = 0; i5 < size5; ++i5) {
                Integer recBillType;
                entryInfo = this.info.getEntries().get(i5);
                if (entryInfo.getRecBillType() == null || (!this.arapHelper.checkIsDefaultBlueBillType(recBillType = this.arapHelper.transRecBillType(this.ctx, recTypeColl, entryInfo.getRecBillType())) || entryInfo.getAmount().signum() != -1) && (!this.arapHelper.checkIsDefaultRedBillType(recBillType) || entryInfo.getAmount().signum() != 1)) continue;
                throw new ArApRecPayException(ArApRecPayException.REC_ENTRYTYPEAMTNOTMATCH);
            }
        }
        ArApBillUtil.setDefaultValueZero(this.ctx, (BillBaseInfo)this.info);
    }

    public void afterSave(IObjectPK pk) throws EASBizException, BOSException {
        super.afterSave(pk);
        BOSUuid billId = this.info.getId();
        ReceivingBillEntryCollection entryColl = this.info.getEntries();
        HashSet<String> srcIdSet = new HashSet<String>();
        for (int i = 0; i < entryColl.size(); ++i) {
            String srcBillId = entryColl.get(i).getString("sourceBillId");
            if (StringUtils.isEmpty((String)srcBillId)) continue;
            srcIdSet.add(srcBillId);
        }
        String relation = this.info.getExtendedProperty("rebuildBOTRelation");
        try {
            if (this.info != null && billId != null && !srcIdSet.isEmpty() && !Boolean.parseBoolean(relation)) {
                ArApServerUtils.createBotpRelation(this.ctx, srcIdSet, billId.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void checkBizData() throws EASBizException, BOSException {
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)this.info.getCompany());
        if (currentPeriod != null && this.info.getBizDate() != null && currentPeriod.getBeginDate().compareTo(this.info.getBizDate()) > 0 && !this.info.isIsInitializeBill()) {
            throw new RecPayException(RecPayException.BILLDATEMUSTGREATTHANBEGINDATE);
        }
    }
}

