/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ar.AbstractArApBillBaseInfo;
import com.kingdee.eas.fi.arap.app.service.handler.ArApServiceHandler;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.util.RecPayServiceUtil;
import com.kingdee.eas.fi.arap.util.ArApBillReverseHelper;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasForArApException;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IReceivingDisposer;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.ReceivingBillDataProcess;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeCollection;
import com.kingdee.eas.fi.cas.ReceivingBillTypeFactory;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.service.RecSubmitService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.framework.bizflow.util.BizBillValueChangeUtil;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;

public class ArRecSubmitService
extends RecSubmitService {
    private ArApServiceHandler apapServiceHandler = new ArApServiceHandler();
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    protected ServiceHandler getServiceHandler() {
        return this.apapServiceHandler;
    }

    public void initService(Context ctx, ReceivingBillInfo info) throws EASBizException, BOSException {
        super.initService(ctx, (IObjectValue)info);
        String number = info.getString("number");
        if (number != null && number.length() > 0) {
            this.apapServiceHandler.checkNumberDup(ctx, (IObjectValue)info);
        }
    }

    public void beforeSubmit() throws EASBizException, BOSException {
        PeriodInfo period;
        if (this.info.isIsInitializeBill()) {
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentUser();
            IPermission iPermission = PermissionFactory.getLocalInstance((Context)this.ctx);
            iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectPK)new ObjectUuidPK(this.info.getCompany().getId()), "fi_ar_InitReceivingbill_batchSubmit");
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
        boolean isSubmit = false;
        if (this.info.getBillStatus() == BillStatusEnum.SUBMIT) {
            isSubmit = true;
        }
        super.beforeSubmit();
        if (this.info.getSourceSysType() == null) {
            this.info.setSourceSysType(SourceTypeEnum.AR);
        }
        if (this.info.getSourceType() == null) {
            this.info.setSourceType(this.info.getSourceSysType());
        }
        if (this.info.getEntries() == null || this.info.getEntries().size() == 0) {
            this.apapServiceHandler.throwSubmitExcetion(this.ctx, "Condition_HeadEntries");
        }
        if ((period = this.checkSystemIfStart(this.ctx, SystemEnum.ACCOUNTSRECEIVABLE, this.info.getCompany())) == null) {
            throw new RecPayException(RecPayException.AR_SYSTEM_NO_PERIOD);
        }
        this.arapHelper.verifyAccountView(this.ctx, this.info.getPayeeAccount(), this.info.getCurrency(), this.info.getCompany());
        if (this.info.isIsInitializeBill() && this.info.isAssoGen() && RecPayHelper.SRC_AR_BOSTYPE.equals((Object)this.getSrcBillBOSType(this.info))) {
            throw new ArApRecPayException(ArApRecPayException.BLANK, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"204_ApPaySubmitService", (Locale)this.ctx.getLocale())});
        }
        if (this.info.getEntries() != null && this.info.getEntries().get(0) != null && this.info.getEntries().get(0).getContractNum() != null) {
            this.info.setContractNum(this.info.getEntries().get(0).getContractNum());
        }
        if (this.info.getRecBillType() != null) {
            int size = this.info.getEntries().size();
            for (int i = 0; i < size; ++i) {
                if (this.info.getEntries().get(i).getRecBillType() != null && !this.info.isIsInitializeBill()) continue;
                this.info.getEntries().get(i).setRecBillType(this.info.getRecBillType());
            }
        }
        String tableName = "T_CAS_ReceivingBillEntry";
        boolean isHasBizFlow = false;
        HashSet<String> sourceIDSet = new HashSet<String>();
        HashSet<String> idSet = new HashSet<String>();
        int size = this.info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            String sourceBillID = this.info.getEntries().get(i).getSourceBillId();
            BOSUuid entryID = this.info.getEntries().get(i).getId();
            if (entryID != null) {
                idSet.add(entryID.toString());
            }
            if (StringUtil.isEmpty((String)sourceBillID)) continue;
            sourceIDSet.add(sourceBillID);
        }
        if (ArApRecPayServerHelper.isExistsBizFlowField((Context)this.ctx, (String)tableName) && ArApRecPayServerHelper.isHasBizFlowValue((Context)this.ctx, (String)tableName, idSet)) {
            isHasBizFlow = true;
        }
        RecPayServiceUtil.reverseRecAmountFields(this.ctx, this.info, BatchActionEnum.SUBMIT, isHasBizFlow);
        RecPayServiceUtil.reverseRecPayLockAmt(this.ctx, (RecPayBillInfo)this.info, true);
        this.serviceHandler.checkIsInQueue(this.ctx, this.info);
        String companyId = this.info.getCompany().getId().toString();
        ArApServerUtils.commonBugdetCheck(this.ctx, companyId, (IObjectValue)this.info);
        if (SourceTypeEnum.AR.equals((Object)this.info.getSourceType())) {
            if (this.isAddNew) {
                if (this.info.getSourceSysType() == null) {
                    this.info.setSourceSysType(SourceTypeEnum.AR);
                }
                if (this.info.isIsImport() && this.info.isIsInitializeBill()) {
                    int size2 = this.info.getEntries().size();
                    for (int i = 0; i < size2; ++i) {
                        this.info.getEntries().get(i).setRecBillType(this.info.getRecBillType());
                    }
                }
            }
            if (this.info.getBizDate() == null) {
                this.info.setBizDate(new Date());
            }
            if (this.info.getCU() == null && this.info.getCompany().getCU() != null) {
                this.info.setCU(this.info.getCompany().getCU());
            }
            this.apapServiceHandler.checkNumber(this.ctx, (RecPayBillInfo)this.info);
            this.checkRecInfo(this.ctx, this.info);
            if (!this.isAddNew && this.info.getBillStatus().getValue() >= 12) {
                throw new CasForArApException(CasForArApException.BILLISAUDITED);
            }
            if (this.info.isIsTransBill()) {
                ObjectUuidPK sourceBillPK = new ObjectUuidPK(this.info.getSourceBillId());
                if (!this.info.isIsTransOtherBill()) {
                    this.apapServiceHandler.reverseTransBill(this.ctx, (IObjectPK)sourceBillPK, this.info, true);
                }
                if (this.info.isIsTransOtherBill()) {
                    this.apapServiceHandler.reverseTransOtherBill(this.ctx, this.info, true);
                }
                UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentUser();
                this.info.setBillStatus(BillStatusEnum.RECED);
                this.info.setAuditDate(new Date());
                this.info.setRecDate(new Date());
                this.info.setAuditor(userInfo);
                this.info.setCashier(userInfo);
            }
            ReceivingBillDataProcess.setAmountProp((Context)this.ctx, (ReceivingBillInfo)this.info);
            if (ZERO.compareTo(this.info.getAmount()) == 0) {
                throw new ArApRecPayException(ArApRecPayException.REC_AMTNOTZERO);
            }
            if (this.info.getRecBillType() != null) {
                HashSet<String> recTypeIDSet = new HashSet<String>();
                recTypeIDSet.add(String.valueOf(this.info.getRecBillType().getId()));
                int size3 = this.info.getEntries().size();
                for (int i = 0; i < size3; ++i) {
                    if (this.info.getEntries().get(i).getRecBillType() == null) continue;
                    recTypeIDSet.add(String.valueOf(this.info.getEntries().get(i).getRecBillType().getId()));
                }
                EntityViewInfo view = new EntityViewInfo();
                view.getSelector().add(new SelectorItemInfo("number"));
                view.getSelector().add(new SelectorItemInfo("isPreSet"));
                view.getSelector().add(new SelectorItemInfo("preSetBillType.id"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", recTypeIDSet, CompareType.INCLUDE));
                view.setFilter(filter);
                ReceivingBillTypeCollection recTypeColl = ReceivingBillTypeFactory.getLocalInstance((Context)this.ctx).getReceivingBillTypeCollection(view);
                Integer recType = null;
                recType = this.arapHelper.transRecBillType(this.ctx, recTypeColl, this.info.getRecBillType());
                boolean blueFlag = this.arapHelper.checkIsDefaultBlueBillType(recType);
                boolean redFlag = this.arapHelper.checkIsDefaultRedBillType(recType);
                int sign = this.info.getAmount().signum();
                if (blueFlag && sign == -1 || redFlag && sign == 1) {
                    throw new ArApRecPayException(ArApRecPayException.REC_TYPEAMTNOTMATCH);
                }
                Integer recBillType = null;
                int size4 = this.info.getEntries().size();
                for (int i = 0; i < size4; ++i) {
                    ReceivingBillEntryInfo entryInfo = this.info.getEntries().get(i);
                    if (entryInfo.getRecBillType() == null || (!this.arapHelper.checkIsDefaultBlueBillType(recBillType = this.arapHelper.transRecBillType(this.ctx, recTypeColl, entryInfo.getRecBillType())) || entryInfo.getAmount().signum() != -1) && (!this.arapHelper.checkIsDefaultRedBillType(recBillType) || entryInfo.getAmount().signum() != 1)) continue;
                    throw new ArApRecPayException(ArApRecPayException.REC_ENTRYTYPEAMTNOTMATCH);
                }
            }
            for (int i = 0; i < this.info.getEntries().size(); ++i) {
                if (this.info.getEntries().get(i).getId() != null) continue;
                this.info.getEntries().get(i).setId(BOSUuid.create((BOSObjectType)this.info.getEntries().get(i).getBOSType()));
            }
            ReceivingBillInfo oldModel = null;
            if (sourceIDSet.size() > 0) {
                if (this.info.get("id") != null) {
                    String id = this.info.get("id").toString();
                    try {
                        oldModel = (ReceivingBillInfo)ReceivingBillFactory.getLocalInstance((Context)this.ctx).getValue((IObjectPK)new ObjectUuidPK(id));
                    }
                    catch (Exception e) {
                        oldModel = null;
                    }
                }
                if (isHasBizFlow) {
                    if (oldModel != null && oldModel.getBillStatus().getValue() == 11) {
                        try {
                            BizBillValueChangeUtil.handleBillSubmit((Context)this.ctx, oldModel, (IObjectValue)this.info);
                        }
                        catch (Exception e) {
                            throw new BOSException((Throwable)e);
                        }
                    }
                    ArApRecPayServerHelper.doWriteBack((Context)this.ctx, (IObjectValue)this.info, (BatchActionEnum)BatchActionEnum.SUBMIT);
                    if (oldModel != null && oldModel.getBillStatus().getValue() == 11) {
                        try {
                            BizBillValueChangeUtil.resetBillChange((Context)this.ctx, (IObjectValue)this.info);
                        }
                        catch (Exception e) {
                            throw new BOSException((Throwable)e);
                        }
                    }
                    ArApBillReverseHelper.reversePlanAmount(this.ctx, true, sourceIDSet);
                }
            }
        }
        if (isSubmit && this.info.isIsInitializeBill() && !this.isHasValue && !this.isAddNew) {
            this.writeBackInitBill(true);
        }
        ArApBillUtil.checkAmtAndAmtLocalPrecision(this.ctx, (BillBaseInfo)this.info, this.info.getCurrency());
        ArApBillUtil.setDefaultValueZero(this.ctx, (BillBaseInfo)this.info);
    }

    public void afterSubmit(IObjectPK pk) throws EASBizException, BOSException {
        super.afterSubmit(pk);
        ArApRecPayServerHelper.injectBizFlow((Context)this.ctx, (IObjectValue)this.info, (BatchActionEnum)BatchActionEnum.SUBMIT);
        if (this.info.isIsTransOtherBill() && SourceTypeEnum.AR.equals((Object)this.info.getSourceType())) {
            this.apapServiceHandler.writeBackOrderBill(this.ctx, this.info.getId().toString(), true, false);
        }
        if (this.info.isIsInitializeBill() && !this.isHasValue) {
            this.writeBackInitBill(false);
        }
        BOSUuid billId = this.info.getId();
        ReceivingBillEntryCollection entryColl = this.info.getEntries();
        HashSet<String> srcIdSet = new HashSet<String>();
        for (int i = 0; i < entryColl.size(); ++i) {
            String srcBillId = entryColl.get(i).getString("sourceBillId");
            if (StringUtil.isEmpty((String)srcBillId)) continue;
            srcIdSet.add(srcBillId);
        }
        String relation = this.info.getExtendedProperty("rebuildBOTRelation");
        try {
            if (!(this.info == null || billId == null || srcIdSet.isEmpty() || relation != null && Boolean.valueOf(relation).booleanValue())) {
                ArApServerUtils.createBotpRelation(this.ctx, srcIdSet, billId.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private BOSObjectType getSrcBillBOSType(ReceivingBillInfo info) throws RecPayException {
        if (info == null || info.getEntries() == null || info.getEntries().size() < 1) {
            throw new RecPayException(RecPayException.BILLENTRY_ISNULL);
        }
        String srcBillID = null;
        int i = 0;
        int size = info.getEntries().size();
        if (i < size) {
            if (info.getEntries().get(i).getSourceBillId() == null) {
                return null;
            }
            srcBillID = info.getEntries().get(i).getSourceBillId();
        }
        BOSObjectType srcBOSType = BOSUuid.getBOSObjectType(srcBillID, (boolean)true);
        return srcBOSType;
    }

    private PeriodInfo checkSystemIfStart(Context ctx, SystemEnum sourceType, CompanyOrgUnitInfo companyInfo) {
        PeriodInfo period = null;
        try {
            period = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)sourceType, (CompanyOrgUnitInfo)companyInfo);
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        return period;
    }

    private void checkRecInfo(Context ctx, ReceivingBillInfo info) throws EASBizException, BOSException {
        String resourcePath = "com.kingdee.eas.fi.ar.ARRecPayResource";
        String message = ResourceBase.getString((String)resourcePath, (String)"recBillTypeIsNull", (Locale)ctx.getLocale());
        if (info.getRecBillType() == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{message});
        }
        if (info.getSourceType() != null && !info.getSourceType().equals((Object)info.getRecBillType().getSourceSysType())) {
            throw new RecPayException(RecPayException.RECBILLTYPENOTMATCHSYSTYPE);
        }
        this.checkBizDate();
        if (info.isIsTransBill()) {
            AbstractArApBillBaseInfo sourceBillInfo;
            StringBuffer sb = new StringBuffer("");
            if (info.isIsTransOtherBill()) {
                sourceBillInfo = null;
                if (info.getSourceBillId() == null) {
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"srcBillIDIsNull", (Locale)ctx.getLocale())).append(";\n");
                } else if (new OtherBillInfo().getBOSType().equals((Object)BOSUuid.read((String)info.getSourceBillId()).getType())) {
                    sourceBillInfo = OtherBillFactory.getLocalInstance(ctx).getOtherBillInfo("SELECT adminOrgUnit, person WHERE id = '" + info.getSourceBillId() + "'");
                }
                if (sourceBillInfo != null && sourceBillInfo.getAdminOrgUnit() != null && info.getAdminOrgUnitId_SourceBill() == null) {
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"srcOUIDIsNull", (Locale)ctx.getLocale())).append(";\n");
                }
                if (sourceBillInfo != null && sourceBillInfo.getPerson() != null && info.getPersonID_SourceBill() == null) {
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"srcPersonIDIsNull", (Locale)ctx.getLocale())).append(";\n");
                }
                if (info.getAsstActTypeID_SourceBill() == null) {
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"srcAsstActTypeIDIsNull", (Locale)ctx.getLocale())).append(";\n");
                }
                if (info.getAsstActID_SourceBill() == null) {
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"srcAcctCussentIDIsNull", (Locale)ctx.getLocale())).append(";\n");
                }
                if (info.getBillDate_SourceBill() == null) {
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"srcBillDateIsNull", (Locale)ctx.getLocale())).append(";\n");
                }
                if (sb.length() > 0) {
                    throw new CasForArApException(CasForArApException.TRANSFAILED, new Object[]{sb.toString()});
                }
            } else {
                sourceBillInfo = null;
                if (info.getSourceBillId() == null) {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"srcBillIDIsNull", (Locale)ctx.getOriginLocale())).append(";\n");
                } else {
                    sourceBillInfo = ReceivingBillFactory.getLocalInstance((Context)ctx).getReceivingBillInfo("SELECT adminOrgUnit, person WHERE id = '" + info.getSourceBillId() + "'");
                }
                if (sourceBillInfo != null && sourceBillInfo.getAdminOrgUnit() != null && info.getAdminOrgUnitId_SourceBill() == null) {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"srcOUIDIsNull", (Locale)ctx.getOriginLocale())).append(";\n");
                }
                if (sourceBillInfo != null && sourceBillInfo.getPerson() != null && info.getPersonID_SourceBill() == null) {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"srcPersonIDIsNull", (Locale)ctx.getOriginLocale())).append(";\n");
                }
                if (info.getAsstActTypeID_SourceBill() == null) {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"srcAsstActTypeIDIsNull", (Locale)ctx.getOriginLocale())).append(";\n");
                }
                if (sourceBillInfo != null && sourceBillInfo.getPayerID() != null && info.getAsstActID_SourceBill() == null) {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"srcAcctCussentIDIsNull", (Locale)ctx.getOriginLocale())).append(";\n");
                }
                if (info.getBillDate_SourceBill() == null) {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"srcBillDateIsNull", (Locale)ctx.getOriginLocale())).append(";\n");
                }
                if (sb.length() > 0) {
                    throw new CasForArApException(CasForArApException.TRANSFAILED, new Object[]{sb.toString()});
                }
            }
        }
        BigDecimal verifyAmont = null;
        BigDecimal recAmont = null;
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            verifyAmont = info.getEntries().get(i).getAmountVc() == null ? SysConstant.BIGZERO : info.getEntries().get(i).getAmountVc();
            BigDecimal bigDecimal = recAmont = info.getEntries().get(i).getAmount() == null ? SysConstant.BIGZERO : info.getEntries().get(i).getAmount();
            if (SysConstant.BIGZERO.compareTo(verifyAmont) == 0 || recAmont.abs().compareTo(verifyAmont.abs()) > 0) continue;
            throw new CasForArApException(CasForArApException.VERIFYAMT_NO_MORETHAN_RECPAYAMOUNT);
        }
    }

    private Integer transRecBillType(Context ctx, ReceivingBillTypeCollection recTypeColl, ReceivingBillTypeInfo recTypeInfo) throws EASBizException, BOSException {
        Integer recType = null;
        if (!(recTypeInfo = recTypeColl.get((Object)recTypeInfo.getId())).isIsPreSet() && recTypeInfo.getPreSetBillType() != null) {
            String typeid = recTypeInfo.getPreSetBillType().getId().toString();
            if ("DAWSqQEREADgAAGVwKgSfCqo2zU=".equals(typeid)) {
                recType = new Integer(100);
            } else if ("DAWSqQEREADgAAILwKgSfCqo2zU=".equals(typeid)) {
                recType = new Integer(101);
            } else if ("DAWSqQEREADgAAInwKgSfCqo2zU=".equals(typeid)) {
                recType = new Integer(102);
            } else if ("DAWSqQEREADgAAIswKgSfCqo2zU=".equals(typeid)) {
                recType = new Integer(103);
            } else if ("DAWSqQEREADgAAIOwKgSfCqo2zU=".equals(typeid)) {
                recType = new Integer(104);
            } else if ("DAWSqQEREADgAAIvwKgSfCqo2zU=".equals(typeid)) {
                recType = new Integer(105);
            }
        } else {
            recType = new Integer(recTypeInfo.getNumber());
        }
        return recType;
    }

    private void writeBackInitBill(boolean isSubmited) throws BOSException {
        try {
            if (this.info != null && this.info.isIsInitializeBill()) {
                String disposerName = "com.kingdee.eas.scm.sd.sale.SaleOrderDisposer";
                IReceivingDisposer disposer = (IReceivingDisposer)Class.forName(disposerName).newInstance();
                BillDisposerAction disposerAction = new BillDisposerAction();
                disposerAction.setDestBill((CoreBaseInfo)this.info);
                if (isSubmited) {
                    disposerAction.setActionType(DisposerActionEnum.CANCEL_REC);
                } else {
                    disposerAction.setActionType(DisposerActionEnum.REC);
                }
                disposer.dispose(this.ctx, disposerAction);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void checkBizDate() throws EASBizException, BOSException {
        PeriodInfo currentPeriod = CasForArApUtil.getCurrentPeriod((Context)this.ctx, (CompanyOrgUnitInfo)this.info.getCompany());
        if (currentPeriod != null && this.info.getBizDate() != null && currentPeriod.getBeginDate().compareTo(this.info.getBizDate()) > 0 && !this.info.isIsInitializeBill()) {
            throw new RecPayException(RecPayException.BILLDATEMUSTGREATTHANBEGINDATE);
        }
    }
}

