/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.IIncomeConfimBill;
import com.kingdee.eas.fi.ar.IncomeConfimBillFactory;
import com.kingdee.eas.fi.ar.IncomeConfimBillInfo;
import com.kingdee.eas.fi.ar.IncomeConfimEntryInfo;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.app.util.ArServerUtils;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class IncomeConfirmBillReverseService {
    private final Context ctx;
    private final IncomeConfimBillInfo origin;
    private final IncomeConfimBillInfo clone;
    private Date bizDate;
    private Date billDate;
    private final IIncomeConfimBill incomeConfimBill;

    public IncomeConfirmBillReverseService(Context ctx, IncomeConfimBillInfo origin, Date bizDate, Date billDate) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.origin = origin;
        this.clone = (IncomeConfimBillInfo)origin.clone();
        this.incomeConfimBill = IncomeConfimBillFactory.getLocalInstance(ctx);
        this.initDate(origin, bizDate, billDate);
        this.initDestBill();
        this.initOriginBill();
    }

    public IObjectPK doReverse() throws BOSException, EASBizException {
        this.incomeConfimBill.pureUpdate(this.origin);
        IObjectPK destPk = this.incomeConfimBill.reverseBillAudit(this.clone);
        this.bindingBotpRelation(destPk);
        return destPk;
    }

    private void bindingBotpRelation(IObjectPK pk) throws BOSException {
        String bosType = this.clone.getBOSType().toString();
        BOTRelationInfo info = new BOTRelationInfo();
        info.setSrcObjectID(this.origin.getId().toString());
        info.setDestEntityID(bosType);
        info.setSrcEntityID(bosType);
        info.setDestObjectID(pk.toString());
        info.setOperatorID("unknown");
        info.setType(0);
        BOTRelationFactory.getLocalInstance((Context)this.ctx).addnew(info);
    }

    private void initDate(IncomeConfimBillInfo origin, Date bizDate, Date billDate) throws BOSException, EASBizException {
        Date currentPeriod_beginDate;
        Date tempBizDate = origin.getBizDate();
        Date tempBillDate = origin.getBillDate();
        if (bizDate != null) {
            tempBizDate = bizDate;
        }
        if (billDate != null) {
            tempBillDate = billDate;
        }
        Date now = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(now);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        PeriodInfo currentPeriod = ArServerUtils.getArCurrentPeriod(this.ctx, origin.getCompany());
        Date date = currentPeriod_beginDate = currentPeriod == null ? now : currentPeriod.getBeginDate();
        if (tempBillDate.before(currentPeriod_beginDate)) {
            tempBillDate = currentPeriod_beginDate;
        }
        this.bizDate = tempBizDate;
        this.billDate = tempBillDate;
    }

    private void initDestBill() throws BOSException, EASBizException {
        String sourceBillId = this.clone.getId().toString();
        this.clone.setId(null);
        this.clone.setBillStatus(BillStatusEnum.SAVE);
        this.clone.setIsReverseBill(true);
        this.clone.setIsTransBill(false);
        this.clone.setIsReversed(false);
        this.clone.setIsImportBill(false);
        this.clone.setIsInitializeBill(false);
        this.clone.setIsNeedVoucher(true);
        this.clone.setIsCoopBuild(false);
        this.clone.setRedBlueType(!this.origin.isRedBlueType());
        this.clone.setSourceBillId(this.origin.getId().toString());
        this.clone.setSourceBillType(this.origin.getSourceBillType());
        this.clone.setVoucher(null);
        this.clone.setVoucherNumber(null);
        this.clone.setVoucherType(null);
        this.clone.setFiVouchered(false);
        this.clone.setIsAppointVoucher(false);
        boolean isAutoNumber = this.isAutoNumber(this.ctx, this.origin, this.origin.getCompany().getId().toString());
        this.clone.setNumber(isAutoNumber ? null : this.origin.getNumber() + "-Rever");
        this.clone.setAbstractName(ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"ReverseBill", (Locale)this.ctx.getLocale()) + " - " + this.origin.getNumber());
        this.clone.setBillDate(this.billDate);
        this.clone.setBizDate(this.bizDate);
        UserInfo currentUser = CommonServerUtils.getCurrentUser(this.ctx);
        Date now = new Date(System.currentTimeMillis());
        this.clone.setCreator(currentUser);
        this.clone.setCreateTime(new Timestamp(now.getTime()));
        this.clone.setLastUpdateUser(currentUser);
        this.clone.setLastUpdateTime(new Timestamp(now.getTime()));
        this.clone.setAccountant(null);
        this.clone.setReqCalculate4Srv(false);
        String[] negativeFields = new String[]{"totalConfimAmount", "totalConfimAmountLoc", "totalAmount", "totalAmountLocal", "totalTaxAmount", "totalTaxAmountLocal", "totalTax", "totalTaxLocal"};
        this.setValueNegative((IObjectValue)this.clone, negativeFields);
        String[] negativeEntryFields = new String[]{"quantity", "assistQty", "baseQty", "unwriteOffBaseQty", "incomeConfimAmount", "incomeConfimAmountLoc", "amount", "amountLocal", "taxAmount", "taxAmountLocal", "discountAmount", "discountAmountLocal", "localUnwriteOffAmount"};
        for (Object obj : this.clone.getEntry().toArray()) {
            IncomeConfimEntryInfo entry = (IncomeConfimEntryInfo)obj;
            String sourceBillEntryId = entry.getId().toString();
            entry.setId(null);
            entry.setHead(null);
            entry.setSourceBillId(sourceBillId);
            entry.setSourceBillEntryId(sourceBillEntryId);
            this.setValueNegative((IObjectValue)entry, negativeEntryFields);
            entry.setLockVerifyAmt(entry.getIncomeConfimAmount());
            entry.setLockVerifyAmtLocal(entry.getIncomeConfimAmountLoc());
            entry.setLockUnVerifyAmt(BigDecimal.ZERO);
            entry.setLockUnVerifyAmtLocal(BigDecimal.ZERO);
            entry.setLocalWrittenOffAmount(entry.getLocalUnwriteOffAmount());
            entry.setLocalUnwriteOffAmount(BigDecimal.ZERO);
            entry.setWittenOffBaseQty(entry.getUnwriteOffBaseQty());
            entry.setUnwriteOffBaseQty(BigDecimal.ZERO);
            entry.setLockQty(entry.getQuantity());
            entry.setUnLockQty(BigDecimal.ZERO);
            entry.setLockBaseQty(entry.getBaseQty());
            entry.setUnLockBaseQty(BigDecimal.ZERO);
        }
    }

    private void initOriginBill() {
        this.origin.setIsReversed(true);
        for (Object obj : this.origin.getEntry().toArray()) {
            IncomeConfimEntryInfo entry = (IncomeConfimEntryInfo)obj;
            entry.setLockUnVerifyAmt(BigDecimal.ZERO);
            entry.setLockUnVerifyAmtLocal(BigDecimal.ZERO);
            entry.setLockVerifyAmt(entry.getIncomeConfimAmount());
            entry.setLockVerifyAmtLocal(entry.getIncomeConfimAmountLoc());
            entry.setLocalWrittenOffAmount(entry.getLocalUnwriteOffAmount());
            entry.setLocalUnwriteOffAmount(BigDecimal.ZERO);
            entry.setWittenOffBaseQty(entry.getUnwriteOffBaseQty());
            entry.setUnwriteOffBaseQty(BigDecimal.ZERO);
            entry.setLockQty(entry.getQuantity());
            entry.setUnLockQty(BigDecimal.ZERO);
            entry.setLockBaseQty(entry.getBaseQty());
            entry.setUnLockBaseQty(BigDecimal.ZERO);
        }
    }

    private boolean isAutoNumber(Context ctx, BillBaseInfo info, String sCompanyID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)sCompanyID)) {
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = null;
            if (info.getCompany() == null) {
                throw new OtherBillBizException(OtherBillBizException.COMPANY_NOTSET);
            }
            aCompanyOrgUnitInfo = info.getCompany();
            sCompanyID = aCompanyOrgUnitInfo.getId().toString();
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        return iCodingRuleManager.isExist((IObjectValue)info, sCompanyID);
    }

    private void setValueNegative(IObjectValue info, String[] fields) {
        for (String field : fields) {
            if (!info.containsKey(field)) continue;
            BigDecimal value = info.getBigDecimal(field);
            value = value == null ? BigDecimal.ZERO : value;
            info.setBigDecimal(field, value.negate());
        }
    }
}

