/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.spi.SPInfo;
import com.kingdee.bos.spi.SPManager;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.dap.DAPVoucherTypeEnum;
import com.kingdee.eas.base.dap.IDAPTransformerWrapper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.SwapRateBillFactory;
import com.kingdee.eas.fi.ar.app.util.ArApSwapSQLHelper;
import com.kingdee.eas.fi.arap.SwapRateBillBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ArApSwapBaseUtils {
    public static final int LEN = 10000;

    public static void setBillType(Context ctx, String temp_SwapBill, boolean isRec) throws BOSException, SQLException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("FID,").append("\r\n");
        strBuf.append("FBillType,").append("\r\n");
        strBuf.append("FRecPayBillTypeID,").append("\r\n");
        strBuf.append("FBillClass").append("\r\n");
        strBuf.append("FROM " + temp_SwapBill).append("\r\n");
        RptRowSet rs = null;
        int start = 0;
        int len = 10000;
        int count = 0;
        while ((rs = ArApSwapSQLHelper.executeQuery(ctx, strBuf.toString(), null, start, len)).getRowCount() != 0) {
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            while (rs.next()) {
                IRowSet billTypeRs;
                int tempBillType = rs.getInt("FBillType");
                String id = rs.getString("FID");
                String recPayBillTypeID = rs.getString("FRecPayBillTypeID");
                String billClass = rs.getString("FBillClass");
                Integer billType = null;
                StringBuffer sqlBuf = new StringBuffer();
                if ("ar".equals(billClass) || "ap".equals(billClass)) {
                    if (tempBillType == 101) {
                        billType = 8;
                    } else if (tempBillType == 102) {
                        billType = 2;
                    } else if (tempBillType == 103) {
                        billType = 11;
                    } else if (tempBillType == 104) {
                        billType = 115;
                    } else if (tempBillType == 201) {
                        billType = 9;
                    } else if (tempBillType == 202) {
                        billType = 0;
                    } else if (tempBillType == 203) {
                        billType = 10;
                    } else if (tempBillType == 204) {
                        billType = 213;
                    }
                } else if ("rec".equals(billClass)) {
                    sqlBuf.append("SELECT ").append("\r\n");
                    sqlBuf.append("FNumber").append("\r\n");
                    sqlBuf.append("FROM T_CAS_ReceivingBillType").append("\r\n");
                    sqlBuf.append("WHERE 1=1").append("\r\n");
                    sqlBuf.append("AND FID='" + recPayBillTypeID + "'").append("\r\n");
                    billTypeRs = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
                    if (billTypeRs.next()) {
                        billType = billTypeRs.getInt("FNumber");
                    }
                } else if ("pay".equals(billClass)) {
                    sqlBuf.append("SELECT ").append("\r\n");
                    sqlBuf.append("FNumber").append("\r\n");
                    sqlBuf.append("FROM T_CAS_PaymentBillType").append("\r\n");
                    sqlBuf.append("WHERE 1=1").append("\r\n");
                    sqlBuf.append("AND FID='" + recPayBillTypeID + "'").append("\r\n");
                    billTypeRs = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
                    if (billTypeRs.next()) {
                        billType = billTypeRs.getInt("FNumber");
                    }
                }
                paramsList.add(new Object[]{billType, id});
            }
            ArApSwapBaseUtils.updateRecPayBillType(ctx, temp_SwapBill, paramsList);
            start = ++count * len + 1;
        }
    }

    private static void updateRecPayBillType(Context ctx, String temp_SwapBill, List paramsList) throws BOSException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("UPDATE ").append("\r\n");
        strBuf.append(temp_SwapBill).append("\r\n");
        strBuf.append("SET").append("\r\n");
        strBuf.append("FBillType=?").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND FID=?").append("\r\n");
        DbUtil.executeBatch((Context)ctx, (String)strBuf.toString(), (List)paramsList);
    }

    public static void setConnection(Context ctx, String temp_SwapBill, String temp_SwapBillEntry, boolean isRec) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("FID,").append("\r\n");
        strBuf.append("FBillID").append("\r\n");
        strBuf.append("FROM " + temp_SwapBill).append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        RptRowSet rs = null;
        int start = 0;
        int len = 10000;
        int count = 0;
        try {
            while ((rs = ArApSwapSQLHelper.executeQuery(ctx, strBuf.toString(), null, start, len)).getRowCount() != 0) {
                StringBuffer sqlStr = new StringBuffer();
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                while (rs.next()) {
                    String id = rs.getString("FID");
                    String billID = rs.getString("FBillID");
                    paramsList.add(new Object[]{id, billID});
                }
                sqlStr.append("UPDATE").append("\r\n");
                sqlStr.append(temp_SwapBillEntry).append("\r\n");
                sqlStr.append("SET").append("\r\n");
                sqlStr.append("FParentID=?").append("\r\n");
                sqlStr.append("WHERE 1=1").append("\r\n");
                sqlStr.append("AND FBillID=?").append("\r\n");
                sqlStr.append("AND FParentID IS NULL").append("\r\n");
                DbUtil.executeBatch((Context)ctx, (String)sqlStr.toString(), paramsList);
                start = ++count * len + 1;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void updateLastExchangeRate(Context ctx, String temp_SwapBill, Object[][] currencyGroup) throws BOSException {
        StringBuffer strBuf = new StringBuffer();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (int i = 0; i < currencyGroup.length; ++i) {
            String currencyID = UIRuleUtil.getString((Object)currencyGroup[i][0]);
            BigDecimal swapExchangeRate = UIRuleUtil.getBigDecimal((Object)currencyGroup[i][1]);
            if ("".equals(currencyID)) continue;
            paramsList.add(new Object[]{swapExchangeRate, currencyID});
        }
        if (paramsList != null && paramsList.size() > 0) {
            strBuf.append("UPDATE").append("\r\n");
            strBuf.append(temp_SwapBill).append("\r\n");
            strBuf.append("SET").append("\r\n");
            strBuf.append("FSwapRateAfter=?").append("\r\n");
            strBuf.append("WHERE 1=1").append("\r\n");
            strBuf.append("AND FCurrencyID=?").append("\r\n");
            strBuf.append("AND FSwapRateAfter = 0;").append("\r\n");
            DbUtil.executeBatch((Context)ctx, (String)strBuf.toString(), paramsList);
        }
    }

    public static void insertOriginalData(Context ctx, StringBuffer strBuf, String tempTable, Date curEndDate, boolean isBill, boolean isRec) throws BOSException {
        RptRowSet rs = null;
        int start = 0;
        int len = 10000;
        int count = 0;
        while ((rs = ArApSwapSQLHelper.executeQuery(ctx, strBuf.toString(), null, start, len)).getRowCount() != 0) {
            StringBuffer sqlStr = new StringBuffer();
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            while (rs.next()) {
                String billID;
                if (isBill) {
                    String swapRateBillID = "";
                    swapRateBillID = isRec ? UIRuleUtil.getString((Object)BOSUuid.create((String)"810ABE7E")) : UIRuleUtil.getString((Object)BOSUuid.create((String)"F7E6FA40"));
                    billID = rs.getString("billID");
                    String billClass = rs.getString("billClass");
                    String companyID = rs.getString("companyID");
                    String periodID = rs.getString("periodID");
                    String asstActTypeID = rs.getString("asstActTypeID");
                    String asstActID = rs.getString("asstActID");
                    String asstActNumber = rs.getString("asstActNumber");
                    String asstActName = rs.getString("asstActName");
                    String adminOrgUnitID = rs.getString("adminOrgUnitID");
                    String personID = rs.getString("personID");
                    String billNumber = rs.getString("billNumber");
                    Timestamp billDate = (Timestamp)rs.getObject("billDate");
                    Integer billType = UIRuleUtil.getInt((Object)rs.getObject("billType"));
                    String recPayBillType = rs.getString("recPayBillType");
                    String currencyID = rs.getString("currencyID");
                    String paymentTypeID = rs.getString("paymentTypeID");
                    Integer isBizBill = UIRuleUtil.getInt((Object)rs.getObject("isBizBill"));
                    int direction = UIRuleUtil.getInt((Object)rs.getObject("direction"));
                    BigDecimal swapRateBefore = rs.getBigDecimal("swapRateBefore");
                    BigDecimal totalUnVerifyAmount = rs.getBigDecimal("totalUnVerifyAmount");
                    BigDecimal totalUnVerifyAmountLocal = rs.getBigDecimal("totalUnVerifyAmountLocal");
                    String creatorID = UIRuleUtil.getString((Object)ctx.getCaller());
                    Calendar cal = Calendar.getInstance();
                    Timestamp createTime = new Timestamp(cal.getTimeInMillis());
                    String controlUnitID = rs.getString("controlUnitID");
                    paramsList.add(new Object[]{swapRateBillID, billID, billClass, companyID, periodID, asstActTypeID, asstActID, asstActNumber, asstActName, adminOrgUnitID, personID, curEndDate, billNumber, billDate, billType, recPayBillType, currencyID, paymentTypeID, isBizBill, direction, swapRateBefore, BigDecimal.ZERO, totalUnVerifyAmount, totalUnVerifyAmountLocal, creatorID, createTime, null, null, null, null, controlUnitID});
                    continue;
                }
                String swapRateBillEntryID = "";
                swapRateBillEntryID = isRec ? UIRuleUtil.getString((Object)BOSUuid.create((String)"A8FEB894")) : UIRuleUtil.getString((Object)BOSUuid.create((String)"149B8612"));
                billID = rs.getString("billID");
                String entryID = rs.getString("entryID");
                String billClass = rs.getString("billClass");
                String accountID = rs.getString("accountID");
                BigDecimal verifyAmount = UIRuleUtil.getBigDecimal((Object)rs.getObject("verifyAmount"));
                BigDecimal verifyAmountLocal = UIRuleUtil.getBigDecimal((Object)rs.getObject("verifyAmountLocal"));
                BigDecimal amount = rs.getBigDecimal("amount");
                BigDecimal amountLocal = rs.getBigDecimal("amountLocal");
                int convertMode = UIRuleUtil.getIntValue((Object)rs.getObject("convertMode"));
                paramsList.add(new Object[]{null, swapRateBillEntryID, billID, entryID, billClass, accountID, verifyAmount, verifyAmountLocal, amount, amountLocal, BigDecimal.ZERO, BigDecimal.ZERO, convertMode});
            }
            sqlStr.append("INSERT INTO").append("\r\n");
            sqlStr.append(tempTable).append("\r\n");
            sqlStr.append("VALUES(").append("\r\n");
            if (isBill) {
                sqlStr.append("?,?,?,?,?,").append("\r\n");
                sqlStr.append("?,?,?,?,?,").append("\r\n");
                sqlStr.append("?,?,?,?,?,").append("\r\n");
                sqlStr.append("?,?,?,?,?,").append("\r\n");
                sqlStr.append("?,?,?,?,?,").append("\r\n");
                sqlStr.append("?,?,CONVERT(DATETIME,?),?,CONVERT(DATETIME,?),?").append("\r\n");
            } else {
                sqlStr.append("?,?,?,?,?,?,").append("\r\n");
                sqlStr.append("?,?,?,?,?,?,?").append("\r\n");
            }
            sqlStr.append(")").append("\r\n");
            DbUtil.executeBatch((Context)ctx, (String)sqlStr.toString(), paramsList);
            start = ++count * len + 1;
        }
    }

    public static void setOriginalDataHead(Context ctx, String periodID, String temp_SwapBill, String temp_SwapBillEntry, Date curEndDate, boolean isRec, boolean isAddNew) throws BOSException {
        StringBuffer strBuf = new StringBuffer();
        if (isRec) {
            strBuf.append("--\u5e94\u6536\u5355").append("\r\n");
            strBuf.append("SELECT ").append("\r\n");
            strBuf.append("FID billID,--\u5e94\u6536\u5355ID").append("\r\n");
            strBuf.append("'ar' billClass,--\u5355\u636e\u79cd\u7c7b").append("\r\n");
            strBuf.append("FCompanyID companyID,--\u516c\u53f8ID").append("\r\n");
            strBuf.append("'" + periodID + "' periodID,--\u671f\u95f4ID").append("\r\n");
            strBuf.append("FAsstActTypeID asstActTypeID,--\u5f80\u6765\u7c7b\u578bID").append("\r\n");
            strBuf.append("FAsstActID asstActID,--\u5f80\u6765\u6237ID").append("\r\n");
            strBuf.append("FAsstActNumber asstActNumber,--\u5f80\u6765\u6237\u7f16\u7801").append("\r\n");
            strBuf.append("FAsstActName_L2 AsstActName,--\u5f80\u6765\u6237\u540d\u79f0").append("\r\n");
            strBuf.append("FAdminOrgUnitID adminOrgUnitID,--\u90e8\u95e8ID").append("\r\n");
            strBuf.append("FPersonId personID,--\u4e1a\u52a1\u5458ID").append("\r\n");
            strBuf.append("FNumber billNumber,--\u5355\u636e\u7f16\u7801").append("\r\n");
            strBuf.append("FBillDate billDate,--\u5355\u636e\u65e5\u671f").append("\r\n");
            strBuf.append("FBillType billType,--\u5e94\u6536\u5e94\u4ed8\u5355\u636e\u7c7b\u578b").append("\r\n");
            strBuf.append("NULL recPayBillType,--\u6536\u4ed8\u6b3e\u5355\u636e\u7c7b\u578b").append("\r\n");
            strBuf.append("FCurrencyID currencyID,--\u5e01\u522bID").append("\r\n");
            strBuf.append("FPaymentTypeID paymentTypeID,--\u4ed8\u6b3e\u65b9\u5f0f\uff08\u662f\u5426\u73b0\u8d4a\u73b0\u8d2d\uff09").append("\r\n");
            strBuf.append("FIsBizBill isBizBill,--\u662f\u5426\u4e1a\u52a1\u5e94\u6536\u5e94\u4ed8\u5355\u636e").append("\r\n");
            strBuf.append("'0' direction,--\u65b9\u5411").append("\r\n");
            strBuf.append("FLastExhangeRate swapRateBefore,--\u8c03\u6c47\u524d\u6c47\u7387").append("\r\n");
            strBuf.append("FUnVerifyAmount totalUnVerifyAmount,--\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1").append("\r\n");
            strBuf.append("FUnVerifyAmountLocal totalUnVerifyAmountLocal,--\u672a\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01\u5408\u8ba1").append("\r\n");
            strBuf.append("FControlUnitID controlUnitID--\u63a7\u5236\u5355\u5143").append("\r\n");
            strBuf.append("FROM T_AR_OtherBill").append("\r\n");
            strBuf.append("WHERE 1=1");
            if (isAddNew) {
                strBuf.append("AND FID IN (SELECT FBillID FROM " + temp_SwapBillEntry + ")").append("\r\n");
                strBuf.append("AND FID NOT IN (SELECT FBillID FROM " + temp_SwapBill + ")").append("\r\n");
            } else {
                strBuf.append("AND FID IN (SELECT FBillID FROM " + temp_SwapBillEntry + ")").append("\r\n");
            }
            strBuf.append("UNION ALL").append("\r\n");
            strBuf.append("--\u6536\u6b3e\u5355").append("\r\n");
            strBuf.append("SELECT ").append("\r\n");
            strBuf.append("FID billID,--\u6536\u6b3e\u5355ID").append("\r\n");
            strBuf.append("'rec' billClass,--\u5355\u636e\u79cd\u7c7b").append("\r\n");
            strBuf.append("FCompanyID companyID,--\u516c\u53f8ID").append("\r\n");
            strBuf.append("'" + periodID + "' periodID,--\u671f\u95f4ID").append("\r\n");
            strBuf.append("FPayerTypeID asstActTypeID,--\u5f80\u6765\u7c7b\u578bID").append("\r\n");
            strBuf.append("FPayerID asstActID,--\u5f80\u6765\u6237ID").append("\r\n");
            strBuf.append("FPayerNumber asstActNumber,--\u5f80\u6765\u6237\u7f16\u7801").append("\r\n");
            strBuf.append("FPayerName asstActName,--\u5f80\u6765\u6237\u540d\u79f0").append("\r\n");
            strBuf.append("FAdminOrgUnitId adminOrgUnitID,--\u90e8\u95e8ID").append("\r\n");
            strBuf.append("FPersonId personID,--\u4e1a\u52a1\u5458ID").append("\r\n");
            strBuf.append("FNumber billNumber,--\u5355\u636e\u7f16\u7801").append("\r\n");
            strBuf.append("FBizDate billDate,--\u5355\u636e\u65e5\u671f").append("\r\n");
            strBuf.append("NULL billType,--\u5e94\u6536\u5e94\u4ed8\u5355\u636e\u7c7b\u578b").append("\r\n");
            strBuf.append("FRecBillTypeID recPayBillType,--\u6536\u4ed8\u6b3e\u5355\u636e\u7c7b\u578b").append("\r\n");
            strBuf.append("FCurrencyID currencyID,--\u5e01\u522bID").append("\r\n");
            strBuf.append("FPaymentTypeID paymentTypeID,--\u4ed8\u6b3e\u65b9\u5f0f\uff08\u662f\u5426\u73b0\u8d4a\u73b0\u8d2d\uff09").append("\r\n");
            strBuf.append("NULL isBizBill,--\u662f\u5426\u4e1a\u52a1\u5e94\u6536\u5e94\u4ed8\u5355\u636e").append("\r\n");
            strBuf.append("'1' direction,--\u65b9\u5411").append("\r\n");
            strBuf.append("FLastExhangeRate swapRateBefore,--\u8c03\u6c47\u524d\u6c47\u7387").append("\r\n");
            strBuf.append("FUnVerifiedAmt totalUnVerifyAmount,--\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1").append("\r\n");
            strBuf.append("FUnVerifiedAmtLoc totalUnVerifyAmountLocal,--\u672a\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01\u5408\u8ba1").append("\r\n");
            strBuf.append("FControlUnitID controlUnitID--\u63a7\u5236\u5355\u5143").append("\r\n");
            strBuf.append("FROM T_CAS_ReceivingBill").append("\r\n");
            strBuf.append("WHERE 1=1").append("\r\n");
            if (isAddNew) {
                strBuf.append("AND FID IN (SELECT FBillID FROM " + temp_SwapBillEntry + ")").append("\r\n");
                strBuf.append("AND FID NOT IN (SELECT FBillID FROM " + temp_SwapBill + ")").append("\r\n");
            } else {
                strBuf.append("AND FID IN (SELECT FBillID FROM " + temp_SwapBillEntry + ")").append("\r\n");
            }
        } else {
            strBuf.append("--\u5e94\u4ed8\u5355").append("\r\n");
            strBuf.append("SELECT ").append("\r\n");
            strBuf.append("FID billID,--\u5e94\u4ed8\u5355ID").append("\r\n");
            strBuf.append("'ap' billClass,--\u5355\u636e\u79cd\u7c7b").append("\r\n");
            strBuf.append("FCompanyID companyID,--\u516c\u53f8ID").append("\r\n");
            strBuf.append("'" + periodID + "' periodID,--\u671f\u95f4ID").append("\r\n");
            strBuf.append("FAsstActTypeID asstActTypeID,--\u5f80\u6765\u7c7b\u578bID").append("\r\n");
            strBuf.append("FAsstActID asstActID,--\u5f80\u6765\u6237ID").append("\r\n");
            strBuf.append("FAsstActNumber asstActNumber,--\u5f80\u6765\u6237\u7f16\u7801").append("\r\n");
            strBuf.append("FAsstActName_L2 AsstActName,--\u5f80\u6765\u6237\u540d\u79f0").append("\r\n");
            strBuf.append("FAdminOrgUnitID adminOrgUnitID,--\u90e8\u95e8ID").append("\r\n");
            strBuf.append("FPersonId personID,--\u4e1a\u52a1\u5458ID").append("\r\n");
            strBuf.append("FNumber billNumber,--\u5355\u636e\u7f16\u7801").append("\r\n");
            strBuf.append("FBillDate billDate,--\u5355\u636e\u65e5\u671f").append("\r\n");
            strBuf.append("FBillType billType,--\u5e94\u6536\u5e94\u4ed8\u5355\u636e\u7c7b\u578b").append("\r\n");
            strBuf.append("NULL recPayBillType,--\u6536\u4ed8\u6b3e\u5355\u636e\u7c7b\u578b").append("\r\n");
            strBuf.append("FCurrencyID currencyID,--\u5e01\u522bID").append("\r\n");
            strBuf.append("FPaymentTypeID paymentTypeID,--\u4ed8\u6b3e\u65b9\u5f0f\uff08\u662f\u5426\u73b0\u8d4a\u73b0\u8d2d\uff09").append("\r\n");
            strBuf.append("FIsBizBill isBizBill,--\u662f\u5426\u4e1a\u52a1\u5e94\u6536\u5e94\u4ed8\u5355\u636e").append("\r\n");
            strBuf.append("'1' direction,--\u65b9\u5411").append("\r\n");
            strBuf.append("FLastExhangeRate swapRateBefore,--\u8c03\u6c47\u524d\u6c47\u7387").append("\r\n");
            strBuf.append("FUnVerifyAmount totalUnVerifyAmount,--\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1").append("\r\n");
            strBuf.append("FUnVerifyAmountLocal totalUnVerifyAmountLocal,--\u672a\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01\u5408\u8ba1").append("\r\n");
            strBuf.append("FControlUnitID controlUnitID--\u63a7\u5236\u5355\u5143").append("\r\n");
            strBuf.append("FROM T_AP_OtherBill").append("\r\n");
            strBuf.append("WHERE 1=1");
            if (isAddNew) {
                strBuf.append("AND FID IN (SELECT FBillID FROM " + temp_SwapBillEntry + ")");
                strBuf.append("AND FID NOT IN (SELECT FBillID FROM " + temp_SwapBill + ")");
            } else {
                strBuf.append("AND FID in (SELECT FBillID FROM " + temp_SwapBillEntry + ")");
            }
            strBuf.append("UNION ALL").append("\r\n");
            strBuf.append("--\u4ed8\u6b3e\u5355").append("\r\n");
            strBuf.append("SELECT ").append("\r\n");
            strBuf.append("FID billID,--\u4ed8\u6b3e\u5355ID").append("\r\n");
            strBuf.append("'pay' billClass,--\u5355\u636e\u79cd\u7c7b").append("\r\n");
            strBuf.append("FCompanyID companyID,--\u516c\u53f8ID").append("\r\n");
            strBuf.append("'" + periodID + "' periodID,--\u671f\u95f4ID").append("\r\n");
            strBuf.append("FPayeeTypeID asstActTypeID,--\u5f80\u6765\u7c7b\u578bID").append("\r\n");
            strBuf.append("FPayeeID asstActID,--\u5f80\u6765\u6237ID").append("\r\n");
            strBuf.append("FPayeeNumber asstActNumber,--\u5f80\u6765\u6237\u7f16\u7801").append("\r\n");
            strBuf.append("FPayeeName asstActName,--\u5f80\u6765\u6237\u540d\u79f0").append("\r\n");
            strBuf.append("FAdminOrgUnitId adminOrgUnitID,--\u90e8\u95e8ID").append("\r\n");
            strBuf.append("FPersonId personID,--\u4e1a\u52a1\u5458ID").append("\r\n");
            strBuf.append("FNumber billNumber,--\u5355\u636e\u7f16\u7801").append("\r\n");
            strBuf.append("FBizDate billDate,--\u5355\u636e\u65e5\u671f").append("\r\n");
            strBuf.append("NULL billType,--\u5e94\u6536\u5e94\u4ed8\u5355\u636e\u7c7b\u578b").append("\r\n");
            strBuf.append("FPayBillTypeID recPayBillType,--\u6536\u4ed8\u6b3e\u5355\u636e\u7c7b\u578b").append("\r\n");
            strBuf.append("FCurrencyID currencyID,--\u5e01\u522bID").append("\r\n");
            strBuf.append("FPaymentTypeID paymentTypeID,--\u4ed8\u6b3e\u65b9\u5f0f\uff08\u662f\u5426\u73b0\u8d4a\u73b0\u8d2d\uff09").append("\r\n");
            strBuf.append("NULL isBizBill,--\u662f\u5426\u4e1a\u52a1\u5e94\u6536\u5e94\u4ed8\u5355\u636e").append("\r\n");
            strBuf.append("'0' direction,--\u65b9\u5411").append("\r\n");
            strBuf.append("FLastExhangeRate swapRateBefore,--\u8c03\u6c47\u524d\u6c47\u7387").append("\r\n");
            strBuf.append("FUnVerifiedAmt totalUnVerifyAmount,--\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1").append("\r\n");
            strBuf.append("FUnVerifiedAmtLoc totalUnVerifyAmountLocal,--\u672a\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01\u5408\u8ba1").append("\r\n");
            strBuf.append("FControlUnitID controlUnitID--\u63a7\u5236\u5355\u5143").append("\r\n");
            strBuf.append("FROM T_CAS_PaymentBill").append("\r\n");
            strBuf.append("WHERE 1=1");
            if (isAddNew) {
                strBuf.append("AND FID IN ( SELECT FBillID FROM " + temp_SwapBillEntry + ")");
                strBuf.append("AND FID NOT IN ( SELECT FBillID FROM " + temp_SwapBill + ")");
            } else {
                strBuf.append("AND FID in ( SELECT FBillID FROM " + temp_SwapBillEntry + ")");
            }
        }
        ArApSwapBaseUtils.insertOriginalData(ctx, strBuf, temp_SwapBill, curEndDate, true, isRec);
        strBuf.setLength(0);
    }

    public static void swapVourcher(Context ctx, String temp_SwapBill, String temp_SwapBillEntry, boolean isRec) throws BOSException, EASBizException, SQLException {
        IDAPTransformerWrapper wrapper = ArApSwapBaseUtils.getDapWrapper(ctx);
        if (wrapper != null) {
            ObjectUuidPK loanPK;
            ObjectUuidPK lendPK = ArApSwapBaseUtils.getBotMappingPK(ctx, 0, isRec);
            if (lendPK != null) {
                wrapper.transform(ArApSwapBaseUtils.getInfoCollection(ctx, temp_SwapBill, temp_SwapBillEntry, isRec), DAPVoucherTypeEnum.FIVoucher, (IObjectPK)lendPK);
                ArApSwapBaseUtils.updateVoucherInfo(ctx, temp_SwapBill, 0, isRec);
            }
            if ((loanPK = ArApSwapBaseUtils.getBotMappingPK(ctx, 1, isRec)) != null) {
                wrapper.transform(ArApSwapBaseUtils.getInfoCollection(ctx, temp_SwapBill, temp_SwapBillEntry, isRec), DAPVoucherTypeEnum.FIVoucher, (IObjectPK)loanPK);
                ArApSwapBaseUtils.updateVoucherInfo(ctx, temp_SwapBill, 1, isRec);
            }
        }
    }

    protected static void updateVoucherInfo(Context ctx, String temp_SwapBill, int value, boolean isRec) throws BOSException {
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("SELECT glVoucher.FNumber, glVoucher.FVoucherTypeID, botRelation.FSrcObjectID FROM T_BOT_Relation botRelation").append("\r\n");
        sqlBuf.append("INNER JOIN T_GL_Voucher glVoucher ON glVoucher.FID = botRelation.FDestObjectID").append("\r\n");
        sqlBuf.append("WHERE 1=1").append("\r\n");
        sqlBuf.append("AND botRelation.FSrcObjectID IN (SELECT FID FROM " + temp_SwapBill + " WHERE 1=1 AND FDirection='" + value + "')").append("\r\n");
        RptRowSet rs = null;
        int start = 0;
        int len = 10000;
        int count = 0;
        while ((rs = ArApSwapSQLHelper.executeQuery(ctx, sqlBuf.toString(), null, start, len)).getRowCount() != 0) {
            StringBuffer sqlStr = new StringBuffer();
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            while (rs.next()) {
                String number = UIRuleUtil.getString((Object)rs.getObject("FNumber"));
                String voucherTypeID = UIRuleUtil.getString((Object)rs.getObject("FVoucherTypeID"));
                String srcObjectID = UIRuleUtil.getString((Object)rs.getObject("FSrcObjectID"));
                paramsList.add(new Object[]{voucherTypeID, number, srcObjectID});
            }
            if (paramsList != null && paramsList.size() > 0) {
                StringBuffer strBuf = new StringBuffer();
                strBuf.append("UPDATE").append("\r\n");
                strBuf.append("T_" + (isRec ? "AR" : "AP") + "_SwapRateBill").append("\r\n");
                strBuf.append("SET").append("\r\n");
                strBuf.append("FVoucherTypeID=?,").append("\r\n");
                strBuf.append("FVoucherNumber=?").append("\r\n");
                strBuf.append("WHERE 1=1").append("\r\n");
                strBuf.append("AND FID=?").append("\r\n");
                DbUtil.executeBatch((Context)ctx, (String)strBuf.toString(), paramsList);
            }
            start = ++count * len + 1;
        }
    }

    private static ObjectUuidPK getBotMappingPK(Context ctx, int value, boolean isRec) throws BOSException, SQLException {
        StringBuffer strBuf = new StringBuffer();
        String srcEntityName = "";
        String destEntityName = "";
        if (isRec) {
            srcEntityName = "810ABE7E";
            destEntityName = "2652E01E";
        } else {
            srcEntityName = "F7E6FA40";
            destEntityName = "2652E01E";
        }
        strBuf.append("SELECT bot.FID FROM T_BOT_Mapping bot").append("\r\n");
        strBuf.append("INNER JOIN T_BOT_ExtMapping ext ON ext.FID=bot.FExtMappingID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND bot.FSrcEntityName='" + srcEntityName + "'").append("\r\n");
        strBuf.append("AND bot.FDestEntityName='" + destEntityName + "'").append("\r\n");
        strBuf.append("AND ext.FFilter like '%" + value + "%'--0\u501f\uff1b1\u8d37").append("\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strBuf.toString());
        ObjectUuidPK pk = null;
        if (rs.next()) {
            String id = UIRuleUtil.getString((Object)rs.getObject("FID"));
            pk = new ObjectUuidPK(id);
        }
        return pk;
    }

    public static IDAPTransformerWrapper getDapWrapper(Context ctx) throws BOSException {
        IDAPTransformerWrapper wrapper = null;
        if (SPManager.isSPInstalled((String)"DAPServerProvider")) {
            SPInfo spInfo = SPManager.getInstance().getSeviceProvider("DAPServerProvider");
            try {
                Constructor constructor = spInfo.getProviderClass().getConstructor(Context.class);
                Object dapWrapper = constructor.newInstance(ctx);
                return (IDAPTransformerWrapper)dapWrapper;
            }
            catch (NoSuchMethodException e) {
                throw new BOSException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new BOSException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new BOSException((Throwable)e);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return wrapper;
    }

    private static CoreBillBaseCollection getInfoCollection(Context ctx, String temp_SwapBill, String temp_SwapBillEntry, boolean isRec) throws BOSException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("FID").append("\r\n");
        strBuf.append("FROM " + temp_SwapBill).append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND FBillClass='" + (isRec ? "ar" : "ap") + "'").append("\r\n");
        strBuf.append("AND FID IN (SELECT FParentID FROM " + temp_SwapBillEntry + " WHERE 1=1 AND FRateGainLoss IS NOT NULL OR FRateGainLoss<>0)").append("\r\n");
        RptRowSet rs = null;
        int start = 0;
        int len = 10000;
        int count = 0;
        CoreBillBaseCollection col = new CoreBillBaseCollection();
        while ((rs = ArApSwapSQLHelper.executeQuery(ctx, strBuf.toString(), null, start, len)).getRowCount() != 0) {
            while (rs.next()) {
                String idString = UIRuleUtil.getString((Object)rs.getObject("FID"));
                CoreBillBaseInfo info = (CoreBillBaseInfo)ArApSwapBaseUtils.getBizObject(ctx, idString, isRec);
                col.add(info);
            }
            start = ++count * len + 1;
        }
        return col;
    }

    private static IObjectValue getBizObject(Context ctx, String id, boolean isRec) {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        SwapRateBillBaseInfo objVal = null;
        try {
            objVal = isRec ? SwapRateBillFactory.getLocalInstance(ctx).getSwapRateBillInfo((IObjectPK)pk) : com.kingdee.eas.fi.ap.SwapRateBillFactory.getLocalInstance(ctx).getSwapRateBillInfo((IObjectPK)pk);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return objVal;
    }

    private static SelectorItemCollection getBOTPSelectors() {
        return ArApSwapBaseUtils.getSelectors();
    }

    private static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        return sic;
    }
}

