/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.app.util.ArApSwapSQLHelper;
import com.kingdee.eas.framework.report.util.RptRowSet;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;

public class ArApSwapCheckUtils {
    public static final int LEN = 10000;

    public static StringBuffer checkVerificationBill(Context ctx, StringBuffer messageBuf, String companyIDs, Date curEndDate, boolean isRec) throws BOSException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("verBill.FNumber").append("\r\n");
        strBuf.append("FROM T_" + (isRec ? "AR" : "AP") + "_OtherBill bill").append("\r\n");
        strBuf.append("INNER JOIN T_" + (isRec ? "AR" : "AP") + "_OtherBillEntry entry ON entry.FParentID=bill.FID").append("\r\n");
        strBuf.append("INNER JOIN T_" + (isRec ? "AR" : "AP") + "_VerificationBillentry verEntry ON verEntry.FBillID=bill.FID AND verEntry.FEntryID=entry.FID").append("\r\n");
        strBuf.append("INNER JOIN T_" + (isRec ? "AR" : "AP") + "_VerificationBill verBill ON verBill.FID=verEntry.FParentID").append("\r\n");
        strBuf.append("INNER JOIN T_ORG_Company company ON company.FID=verBill.FCompanyID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND verBill.FBizDate>{d '" + curEndDate + "'}").append("\r\n");
        strBuf.append("AND verEntry.FBillDate<={d '" + curEndDate + "'}").append("\r\n");
        strBuf.append("AND verBill.FFiVouchered=1").append("\r\n");
        strBuf.append("AND verBill.FCompanyID IN (" + companyIDs + ")").append("\r\n");
        strBuf.append("AND verEntry.FCurrencyID <> company.FBaseCurrencyID").append("\r\n");
        strBuf.append("UNION ALL ").append("\r\n");
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("verBill.FNumber").append("\r\n");
        strBuf.append("FROM T_CAS_" + (isRec ? "ReceivingBill" : "PaymentBill") + " bill").append("\r\n");
        strBuf.append("INNER JOIN T_CAS_" + (isRec ? "ReceivingBillEntry" : "PaymentBillEntry") + " entry ON entry." + (isRec ? "FReceivingBillID" : "FPaymentBillID") + "=bill.FID").append("\r\n");
        strBuf.append("INNER JOIN T_" + (isRec ? "AR" : "AP") + "_VerificationBillentry verEntry ON verEntry.FBillID=bill.FID AND verEntry.FEntryID=entry.FID").append("\r\n");
        strBuf.append("INNER JOIN T_" + (isRec ? "AR" : "AP") + "_VerificationBill verBill ON verBill.FID=verEntry.FParentID").append("\r\n");
        strBuf.append("INNER JOIN T_ORG_Company company ON company.FID=verBill.FCompanyID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND verBill.FBizDate>{d '" + curEndDate + "'}").append("\r\n");
        strBuf.append("AND verEntry.FBillDate<={d '" + curEndDate + "'}").append("\r\n");
        strBuf.append("AND verBill.FFiVouchered=1").append("\r\n");
        strBuf.append("AND verBill.FCompanyID IN (" + companyIDs + ")").append("\r\n");
        strBuf.append("AND verEntry.FCurrencyID <> company.FBaseCurrencyID").append("\r\n");
        ArApSwapCheckUtils.appendMessage(ctx, strBuf, messageBuf, 0, null, isRec);
        return messageBuf;
    }

    public static StringBuffer checkTransBill(Context ctx, StringBuffer messageBuf, StringBuffer currencyIDBuf, String companyIDs, Date curEndDate, boolean isRec) throws BOSException, EASBizException {
        ArApSwapCheckUtils.checkTranBill(ctx, messageBuf, currencyIDBuf, companyIDs, curEndDate, isRec);
        return messageBuf;
    }

    private static void tranBill(Context ctx, StringBuffer strBuf, StringBuffer currencyIDBuf, String companyIDs, Date curEndDate, boolean isNegative, String billType, boolean isRec) throws EASBizException, BOSException {
        String userNumber = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(ctx.getCaller().toString())).getNumber();
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("destData.FNumber--\u5355\u636e\u7f16\u7801").append("\r\n");
        String billTable = "";
        String billDate = "";
        String entryParentID = "";
        if (isRec) {
            if ("ar".equals(billType) || "pay".equals(billType)) {
                billTable = "T_AR_OtherBill";
                billDate = "FBillDate";
                entryParentID = "FParentID";
            } else if ("ap".equals(billType) || "rec".equals(billType)) {
                billTable = "T_CAS_ReceivingBill";
                billDate = "FBizDate";
                entryParentID = "FReceivingBillID";
            }
        } else if ("ap".equals(billType) || "rec".equals(billType)) {
            billTable = "T_AP_OtherBill";
            billDate = "FBillDate";
            entryParentID = "FParentID";
        } else if ("ar".equals(billType) || "pay".equals(billType)) {
            billTable = "T_CAS_PaymentBill";
            billDate = "FBizDate";
            entryParentID = "FPaymentBillID";
        }
        strBuf.append("FROM " + billTable + " bill").append("\r\n");
        strBuf.append("INNER JOIN T_BOT_Relation botRelation ON botRelation.FSrcObjectID=bill.FID AND FOperatorID='" + userNumber + "'").append("\r\n");
        strBuf.append("INNER JOIN (").append("\r\n");
        if ("ar".equals(billType)) {
            ArApSwapCheckUtils.transArOtherBillSQL(strBuf, currencyIDBuf, companyIDs, curEndDate, isNegative, isRec);
        } else if ("rec".equals(billType)) {
            ArApSwapCheckUtils.transRecSQL(strBuf, currencyIDBuf, companyIDs, curEndDate, isRec);
        } else if ("ap".equals(billType)) {
            ArApSwapCheckUtils.transApOtherBillSQL(strBuf, currencyIDBuf, companyIDs, curEndDate, isNegative, isRec);
        } else if ("pay".equals(billType)) {
            ArApSwapCheckUtils.transPaySQL(strBuf, currencyIDBuf, companyIDs, curEndDate, isRec);
        }
        strBuf.append(") destData ON destData.descBillId=botRelation.FDestObjectID --AND destData.sourceBillEntryId=billEntry.FID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND bill." + billDate + "<={d '" + curEndDate + "'}").append("\r\n");
    }

    private static void checkTranBill(Context ctx, StringBuffer messageBuf, StringBuffer currencyIDBuf, String companyIDs, Date curEndDate, boolean isRec) throws BOSException, EASBizException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.setLength(0);
        ArApSwapCheckUtils.tranBill(ctx, strBuf, currencyIDBuf, companyIDs, curEndDate, false, "ar", isRec);
        strBuf.append("UNION ALL").append("\r\n");
        ArApSwapCheckUtils.tranBill(ctx, strBuf, currencyIDBuf, companyIDs, curEndDate, true, "ar", isRec);
        ArApSwapCheckUtils.appendMessage(ctx, strBuf, messageBuf, 1, "ar", isRec);
        strBuf.setLength(0);
        ArApSwapCheckUtils.tranBill(ctx, strBuf, currencyIDBuf, companyIDs, curEndDate, false, "rec", isRec);
        strBuf.append("UNION ALL").append("\r\n");
        ArApSwapCheckUtils.tranBill(ctx, strBuf, currencyIDBuf, companyIDs, curEndDate, true, "rec", isRec);
        ArApSwapCheckUtils.appendMessage(ctx, strBuf, messageBuf, 1, "rec", isRec);
        strBuf.setLength(0);
        ArApSwapCheckUtils.tranBill(ctx, strBuf, currencyIDBuf, companyIDs, curEndDate, false, "ap", isRec);
        strBuf.append("UNION ALL").append("\r\n");
        ArApSwapCheckUtils.tranBill(ctx, strBuf, currencyIDBuf, companyIDs, curEndDate, true, "ap", isRec);
        ArApSwapCheckUtils.appendMessage(ctx, strBuf, messageBuf, 1, "ap", isRec);
        strBuf.setLength(0);
        ArApSwapCheckUtils.tranBill(ctx, strBuf, currencyIDBuf, companyIDs, curEndDate, false, "pay", isRec);
        strBuf.append("UNION ALL").append("\r\n");
        ArApSwapCheckUtils.tranBill(ctx, strBuf, currencyIDBuf, companyIDs, curEndDate, true, "pay", isRec);
        ArApSwapCheckUtils.appendMessage(ctx, strBuf, messageBuf, 1, "pay", isRec);
    }

    private static void transPaySQL(StringBuffer strBuf, StringBuffer currencyIDBuf, String companyIDs, Date curEndDate, boolean isRec) {
        strBuf.append("--\u4ed8\u6b3e\u5355").append("\r\n");
        strBuf.append("SELECT DISTINCT").append("\r\n");
        strBuf.append("casPayBill.FID descBillId,--\u5355\u636eid").append("\r\n");
        strBuf.append("casPayBill.FNumber--\u5355\u636e\u7f16\u7801").append("\r\n");
        strBuf.append("FROM T_CAS_PaymentBill casPayBill").append("\r\n");
        strBuf.append("INNER JOIN T_CAS_PaymentBillEntry casPayBillEntry ON casPayBillEntry.FPaymentBillID=casPayBill.FID").append("\r\n");
        strBuf.append("INNER JOIN T_ORG_Company company ON company.FID=casPayBill.FCompanyID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND casPayBill.FBillStatus IN ('12', '15')").append("\r\n");
        strBuf.append("AND casPayBill.FCurrencyID IN (" + currencyIDBuf + ")").append("\r\n");
        strBuf.append("AND casPayBill.FCompanyID IN (" + companyIDs + ")").append("\r\n");
        strBuf.append("AND casPayBill.FBizDate>{d '" + curEndDate + "'}").append("\r\n");
        strBuf.append("AND casPayBillEntry.FAmountVc=0").append("\r\n");
        strBuf.append("AND casPayBill.FCurrencyID <> company.FBaseCurrencyID").append("\r\n");
        if (isRec) {
            strBuf.append("AND casPayBill.FIsTransBill=0--\u662f\u5426\u8f6c\u9500\u5355\u636e").append("\r\n");
            strBuf.append("AND casPayBill.FIsTransOtherBill=1--\u662f\u5426\u8f6c\u9884\u6536\u8f6c\u9884\u4ed8").append("\r\n");
        } else {
            strBuf.append("AND casPayBill.FIsTransBill=1--\u662f\u5426\u8f6c\u9500\u5355\u636e").append("\r\n");
            strBuf.append("AND casPayBill.FIsTransOtherBill=0--\u662f\u5426\u8f6c\u9884\u6536\u8f6c\u9884\u4ed8").append("\r\n");
        }
        strBuf.append("AND casPayBill.FFiVouchered=1--\u662f\u5426\u5df2\u751f\u6210\u51ed\u8bc1").append("\r\n");
    }

    private static void transApOtherBillSQL(StringBuffer strBuf, StringBuffer currencyIDBuf, String companyIDs, Date curEndDate, boolean isNegative, boolean isRec) {
        strBuf.append("--\u5e94\u4ed8\u5355").append("\r\n");
        strBuf.append("SELECT DISTINCT").append("\r\n");
        strBuf.append("apOtherBill.FID descBillId,--\u5355\u636eid").append("\r\n");
        strBuf.append("apOtherBill.FNumber--\u5355\u636e\u7f16\u7801").append("\r\n");
        strBuf.append("FROM T_AP_OtherBill apOtherBill").append("\r\n");
        strBuf.append("INNER JOIN T_AP_OtherBillEntry apOtherBillEntry ON apOtherBillEntry.FParentID=apOtherBill.FID").append("\r\n");
        strBuf.append("INNER JOIN T_ORG_Company company ON company.FID=apOtherBill.FCompanyID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND apOtherBill.FBillStatus='3'").append("\r\n");
        strBuf.append("AND apOtherBill.FUnVerifyAmount<>0").append("\r\n");
        strBuf.append("AND apOtherBill.FCurrencyID IN (" + currencyIDBuf + ")").append("\r\n");
        strBuf.append("AND apOtherBill.FCompanyID IN (" + companyIDs + ")").append("\r\n");
        strBuf.append("AND apOtherBill.FBillDate>{d '" + curEndDate + "'}").append("\r\n");
        strBuf.append("AND apOtherBill.FCurrencyID <> company.FBaseCurrencyID").append("\r\n");
        if (isNegative) {
            strBuf.append("AND apOtherBill.FIsReverseBill=1--\u662f\u5426\u4e3a\u51b2\u9500\u5355\u636e").append("\r\n");
        } else {
            strBuf.append("AND apOtherBillEntry.FVerifyAmount=0").append("\r\n");
            if (isRec) {
                strBuf.append("AND apOtherBill.FIsTransBill=1--\u662f\u5426\u8f6c\u79fb\u751f\u6210\u5355\u636e").append("\r\n");
            } else {
                strBuf.append("AND apOtherBill.FIsTransBill=1--\u662f\u5426\u8f6c\u79fb\u751f\u6210\u5355\u636e").append("\r\n");
                strBuf.append("AND apOtherBill.FIsTransOtherBill=1--\u662f\u5426\u8f6c\u5e94\u6536\u5e94\u4ed8").append("\r\n");
            }
        }
        strBuf.append("AND apOtherBill.FFiVouchered=1--\u662f\u5426\u5df2\u751f\u6210\u51ed\u8bc1").append("\r\n");
    }

    private static void transRecSQL(StringBuffer strBuf, StringBuffer currencyIDBuf, String companyIDs, Date curEndDate, boolean isRec) {
        strBuf.append("--\u6536\u6b3e\u5355").append("\r\n");
        strBuf.append("SELECT DISTINCT").append("\r\n");
        strBuf.append("casRecBill.FID descBillId,--\u5355\u636eid").append("\r\n");
        strBuf.append("casRecBill.FNumber--\u5355\u636e\u7f16\u7801").append("\r\n");
        strBuf.append("FROM T_CAS_ReceivingBill casRecBill").append("\r\n");
        strBuf.append("INNER JOIN T_CAS_ReceivingBillEntry casRecBillEntry ON casRecBillEntry.FReceivingBillID=casRecBill.FID").append("\r\n");
        strBuf.append("INNER JOIN T_ORG_Company company ON company.FID=casRecBill.FCompanyID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND casRecBill.FBillStatus IN ('12', '14')").append("\r\n");
        strBuf.append("AND casRecBill.FCurrencyID IN (" + currencyIDBuf + ")").append("\r\n");
        strBuf.append("AND casRecBill.FCompanyID IN (" + companyIDs + ")").append("\r\n");
        strBuf.append("AND casRecBill.FBizDate>{d '" + curEndDate + "'}").append("\r\n");
        strBuf.append("AND casRecBillEntry.FAmountVc=0").append("\r\n");
        strBuf.append("AND casRecBill.FCurrencyID <> company.FBaseCurrencyID").append("\r\n");
        if (isRec) {
            strBuf.append("AND casRecBill.FIsTransBill=1--\u662f\u5426\u8f6c\u9500\u5355\u636e").append("\r\n");
            strBuf.append("AND casRecBill.FIsTransOtherBill=0--\u662f\u5426\u8f6c\u9884\u6536\u8f6c\u9884\u4ed8").append("\r\n");
        } else {
            strBuf.append("AND casRecBill.FIsTransBill=0--\u662f\u5426\u8f6c\u9500\u5355\u636e").append("\r\n");
            strBuf.append("AND casRecBill.FIsTransOtherBill=1--\u662f\u5426\u8f6c\u9884\u6536\u8f6c\u9884\u4ed8").append("\r\n");
        }
        strBuf.append("AND casRecBill.FFiVouchered=1--\u662f\u5426\u5df2\u751f\u6210\u51ed\u8bc1").append("\r\n");
    }

    private static void transArOtherBillSQL(StringBuffer strBuf, StringBuffer currencyIDBuf, String companyIDs, Date curEndDate, boolean isNegative, boolean isRec) {
        strBuf.append("--\u5e94\u6536\u5355").append("\r\n");
        strBuf.append("SELECT DISTINCT").append("\r\n");
        strBuf.append("arOtherBill.FID descBillId,--\u5355\u636eid").append("\r\n");
        strBuf.append("arOtherBill.FNumber--\u5355\u636e\u7f16\u7801").append("\r\n");
        strBuf.append("FROM T_AR_OtherBill arOtherBill").append("\r\n");
        strBuf.append("INNER JOIN T_AR_OtherBillEntry arOtherBillEntry ON arOtherBillEntry.FParentID=arOtherBill.FID").append("\r\n");
        strBuf.append("INNER JOIN T_ORG_Company company ON company.FID=arOtherBill.FCompanyID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND arOtherBill.FBillStatus='3'").append("\r\n");
        strBuf.append("AND arOtherBill.FCurrencyID IN (" + currencyIDBuf + ")").append("\r\n");
        strBuf.append("AND arOtherBill.FCompanyID IN (" + companyIDs + ")").append("\r\n");
        strBuf.append("AND arOtherBill.FBillDate>{d '" + curEndDate + "'}").append("\r\n");
        strBuf.append("AND arOtherBill.FCurrencyID <> company.FBaseCurrencyID").append("\r\n");
        if (isNegative) {
            strBuf.append("AND (arOtherBill.FIsReverseBill=1--\u662f\u5426\u4e3a\u51b2\u9500\u5355\u636e").append("\r\n");
            strBuf.append("OR arOtherBill.FIsAllowanceBill=1)--\u662f\u5426\u6298\u8ba9\u5355\u636e").append("\r\n");
        } else {
            strBuf.append("AND arOtherBillEntry.FVerifyAmount=0").append("\r\n");
            if (isRec) {
                strBuf.append("AND arOtherBill.FIsTransBill=1--\u662f\u5426\u8f6c\u79fb\u751f\u6210\u5355\u636e").append("\r\n");
            } else {
                strBuf.append("AND arOtherBill.FIsTransBill=1--\u662f\u5426\u8f6c\u79fb\u751f\u6210\u5355\u636e").append("\r\n");
                strBuf.append("AND arOtherBill.FIsTransOtherBill=1--\u662f\u5426\u8f6c\u5e94\u6536\u5e94\u4ed8").append("\r\n");
            }
        }
        strBuf.append("AND arOtherBill.FFiVouchered=1--\u662f\u5426\u5df2\u751f\u6210\u51ed\u8bc1").append("\r\n");
    }

    public static StringBuffer checkBadDebt(Context ctx, StringBuffer messageBuf, String companyIDs, Date curEndDate, boolean isRec) throws BOSException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("bill.FNumber").append("\r\n");
        strBuf.append("FROM T_" + (isRec ? "AR" : "AP") + "_OtherBill bill").append("\r\n");
        strBuf.append("INNER JOIN T_" + (isRec ? "AR" : "AP") + "_OtherBillEntry entry ON entry.FParentID=bill.FID").append("\r\n");
        strBuf.append("INNER JOIN T_AR_BadAcct badAcct ON badAcct.FBillID=bill.FID AND badAcct.FEntryID=entry.FID").append("\r\n");
        strBuf.append("INNER JOIN T_ORG_Company company ON company.FID=badAcct.FCompanyID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND badAcct.FBadAcctDate>{d '" + curEndDate + "'}").append("\r\n");
        strBuf.append("AND badAcct.FBillDate<={d '" + curEndDate + "'}").append("\r\n");
        strBuf.append("AND badAcct.FFiVouchered=1").append("\r\n");
        strBuf.append("AND badAcct.FCompanyID IN (" + companyIDs + ")").append("\r\n");
        strBuf.append("AND badAcct.FCurrencyID <> company.FBaseCurrencyID").append("\r\n");
        ArApSwapCheckUtils.appendMessage(ctx, strBuf, messageBuf, 2, null, isRec);
        return messageBuf;
    }

    private static void appendMessage(Context ctx, StringBuffer strBuf, StringBuffer messageBuf, int messageClass, String billType, boolean isRec) throws BOSException {
        RptRowSet rs = null;
        int start = 0;
        int len = 10000;
        int count = 0;
        StringBuffer buf = new StringBuffer();
        while ((rs = ArApSwapSQLHelper.executeQuery(ctx, strBuf.toString(), null, start, len)).getRowCount() != 0) {
            while (rs.next()) {
                String number = rs.getString("FNumber");
                buf.append(number + " , ");
            }
            start = ++count * len + 1;
        }
        if (buf.length() > 0) {
            if (messageClass == 0) {
                messageBuf.append(ArApSwapCheckUtils.getResourceStr(ctx, "settleRecordHaveCreat")).append("\r\n");
                messageBuf.append(ArApSwapCheckUtils.getResourceStr(ctx, "SettleRecordNumber")).append("\r\n");
            } else if (messageClass == 1) {
                String billClass = "";
                if ("ar".equals(billType)) {
                    billClass = ArApSwapCheckUtils.getResourceStr(ctx, "ArBill");
                } else if ("rec".equals(billType)) {
                    billClass = ArApSwapCheckUtils.getResourceStr(ctx, "PurrequestBill");
                } else if ("ap".equals(billType)) {
                    billClass = ArApSwapCheckUtils.getResourceStr(ctx, "ApBill");
                } else if ("pay".equals(billType)) {
                    billClass = ArApSwapCheckUtils.getResourceStr(ctx, "PaymentBill");
                }
                messageBuf.append(ArApSwapCheckUtils.getResourceStr(ctx, "TeanceHaveCreatVercoterCannotDiaoHui", new Object[]{billClass})).append("\r\n");
                messageBuf.append(ArApSwapCheckUtils.getResourceStr(ctx, "BillNumber")).append("\r\n");
            } else if (messageClass == 2) {
                messageBuf.append(ArApSwapCheckUtils.getResourceStr(ctx, "BadReccordHaveCreateCannotTiaohui")).append("\r\n");
                messageBuf.append(ArApSwapCheckUtils.getResourceStr(ctx, "ArBill")).append("\r\n");
            }
            buf.deleteCharAt(buf.length() - 2);
            messageBuf.append(buf).append("\r\n");
        }
    }

    private static String getResourceStr(Context ctx, String key) {
        String resClassName = "com.kingdee.eas.fi.ar.ArAllResource";
        return EASResource.getString((String)resClassName, (String)key, (Locale)ctx.getOriginLocale());
    }

    private static String getResourceStr(Context ctx, String key, Object[] params) {
        String str = ArApSwapCheckUtils.getResourceStr(ctx, key);
        MessageFormat mf = new MessageFormat(str);
        String result = mf.format(params);
        return result;
    }
}

