/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.app.util.ArApSwapBaseUtils;
import com.kingdee.eas.fi.ar.app.util.ArApSwapSQLHelper;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;

public class ArApSwapTranUtils {
    public static final int LEN = 10000;

    private static void transArOtherBillSQL(StringBuffer strBuf, String temp_SwapBill, String temp_SwapBillEntry, StringBuffer currencyIDBuf, String companyIDs, Date curEndDate, boolean isNegative, boolean isRec) {
        strBuf.append("--\u5e94\u6536\u5355").append("\r\n");
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("arOtherBill.FID descBillId,--\u5355\u636eid").append("\r\n");
        strBuf.append("arOtherBillEntry.FID descBillEntryId,--\u5355\u636e\u5206\u5f55id").append("\r\n");
        strBuf.append("arOtherBillEntry.FSourceBillId sourceBillId,--\u6e90\u5355id").append("\r\n");
        strBuf.append("arOtherBillEntry.FSourceBillEntryId sourceBillEntryId,--\u6e90\u5355\u636e\u5206\u5f55id").append("\r\n");
        strBuf.append("'ar' billClass,--\u5355\u636e\u7c7b\u578b").append("\r\n");
        strBuf.append("arOtherBill.FCurrencyID currencyID,--\u5e01\u522b").append("\r\n");
        strBuf.append("arOtherBillEntry.FRecievePayAmount amt,--\u91d1\u989d").append("\r\n");
        strBuf.append("arOtherBillEntry.FRecievePayAmountLocal amtLocal,--\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("arOtherBillEntry.FVerifyAmount verifyAmount,--\u5df2\u7ed3\u7b97\u91d1\u989d").append("\r\n");
        strBuf.append("arOtherBillEntry.FVerifyAmountLocal verifyAmountLocal,--\u5df2\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("(").append("\r\n");
        strBuf.append("SELECT TOP 1").append("\r\n");
        strBuf.append("exchangeAux.FConvertMode convertMode").append("\r\n");
        strBuf.append("FROM T_BD_exchangeRate AS exchangeRate").append("\r\n");
        strBuf.append("INNER JOIN T_BD_exchangeAux AS exchangeAux ON exchangeRate.FexchangeAuxID = exchangeAux.FID").append("\r\n");
        strBuf.append("INNER JOIN T_ORG_CtrlUnit AS CU ON exchangeRate.FControlUnitID = CU.FID").append("\r\n");
        strBuf.append("INNER JOIN T_BD_Currency AS sourceCurrency ON exchangeAux.FsourceCurrencyID = sourceCurrency.FID").append("\r\n");
        strBuf.append("INNER JOIN T_BD_exchangeTable AS exchangeTable ON exchangeAux.FexchangeTableId = exchangeTable.FID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND (exchangeTable.FIsMulExchange = 1 OR (exchangeTable.FIsMulExchange <> 1) AND exchangeRate.FQuoteprice = 1)").append("\r\n");
        strBuf.append("AND sourceCurrency.FID=arOtherBill.FCurrencyID").append("\r\n");
        strBuf.append("AND exchangeTable.FID=company.FBaseExgTableID").append("\r\n");
        strBuf.append("AND exchangeRate.FAvailTime <=arOtherBill.FBillDate").append("\r\n");
        strBuf.append("AND exchangeRate.FInvalidTime>=arOtherBill.FBillDate").append("\r\n");
        strBuf.append(") FConvertMode,--\u6298\u7b97\u65b9\u5f0f").append("\r\n");
        strBuf.append("arOtherBillEntry.FUnVerifyAmount unVerifyAmount,--\u672a\u7ed3\u7b97\u91d1\u989d").append("\r\n");
        strBuf.append("arOtherBillEntry.FUnVerifyAmountLocal unVerifyAmountLocal,--\u672a\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("arOtherBill.FIsTransBill isTransBill,--\u662f\u5426\u8f6c\u79fb\u751f\u6210\u5355\u636e").append("\r\n");
        strBuf.append("arOtherBill.FIsTransOtherBill isTransOtherBill,--\u662f\u5426\u8f6c\u5e94\u6536\u5e94\u4ed8").append("\r\n");
        strBuf.append("arOtherBill.FIsReverseBill isReverseBill,--\u662f\u5426\u4e3a\u51b2\u9500\u5355\u636e").append("\r\n");
        strBuf.append("arOtherBill.FIsAllowanceBill isAllowanceBill--\u662f\u5426\u6298\u8ba9\u5355\u636e").append("\r\n");
        strBuf.append("FROM T_AR_OtherBill arOtherBill").append("\r\n");
        strBuf.append("INNER JOIN T_AR_OtherBillEntry arOtherBillEntry ON arOtherBillEntry.FParentID=arOtherBill.FID").append("\r\n");
        strBuf.append("INNER JOIN T_ORG_Company company ON company.FID=arOtherBill.FCompanyID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND arOtherBill.FBillStatus='3'").append("\r\n");
        strBuf.append("AND arOtherBill.FCurrencyID IN (" + currencyIDBuf + ")").append("\r\n");
        strBuf.append("AND arOtherBill.FCompanyID IN (" + companyIDs + ")").append("\r\n");
        strBuf.append("AND arOtherBill.FBillDate>{d '" + curEndDate + "'}").append("\r\n");
        if (isNegative) {
            strBuf.append("AND (arOtherBill.FIsReverseBill=1--\u662f\u5426\u4e3a\u51b2\u9500\u5355\u636e").append("\r\n");
            strBuf.append("OR arOtherBill.FIsAllowanceBill=1)--\u662f\u5426\u6298\u8ba9\u5355\u636e").append("\r\n");
        } else {
            strBuf.append("AND arOtherBillEntry.FVerifyAmount=0").append("\r\n");
            if (isRec) {
                strBuf.append("AND arOtherBill.FIsTransBill=1--\u662f\u5426\u8f6c\u79fb\u751f\u6210\u5355\u636e").append("\r\n");
            } else {
                strBuf.append("AND arOtherBill.FIsTransBill=1--\u662f\u5426\u8f6c\u79fb\u751f\u6210\u5355\u636e").append("\r\n");
                strBuf.append("AND arOtherBill.FIsTransOtherBill=1--\u662f\u5426\u8f6c\u5e94\u6536\u5e94\u4ed8").append("\r\n");
            }
        }
        strBuf.append("AND arOtherBill.FFiVouchered=0--\u662f\u5426\u5df2\u751f\u6210\u51ed\u8bc1").append("\r\n");
    }

    private static void transRecSQL(StringBuffer strBuf, String temp_SwapBill, String temp_SwapBillEntry, StringBuffer currencyIDBuf, String companyIDs, Date curEndDate, boolean isRec) {
        strBuf.append("--\u6536\u6b3e\u5355").append("\r\n");
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("casRecBill.FID descBillId,--\u5355\u636eid").append("\r\n");
        strBuf.append("casRecBillEntry.FID descBillEntryId,--\u5355\u636e\u5206\u5f55id").append("\r\n");
        strBuf.append("casRecBillEntry.FSourceBillId sourceBillId,--\u6e90\u5355id").append("\r\n");
        strBuf.append("casRecBillEntry.FSourceBillEntryId sourceBillEntryId,--\u6e90\u5355\u636e\u5206\u5f55id").append("\r\n");
        strBuf.append("'rec' billClass,--\u5355\u636e\u7c7b\u578b").append("\r\n");
        strBuf.append("casRecBill.FCurrencyID currencyID,--\u5e01\u522b").append("\r\n");
        strBuf.append("casRecBillEntry.FActualAmt amt,--\u91d1\u989d").append("\r\n");
        strBuf.append("casRecBillEntry.FActualLocAmt amtLocal,--\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("casRecBillEntry.FAmountVc verifyAmount,--\u5df2\u7ed3\u7b97\u91d1\u989d").append("\r\n");
        strBuf.append("casRecBillEntry.FLocalAmount verifyAmountLocal,--\u5df2\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("(").append("\r\n");
        strBuf.append("SELECT TOP 1").append("\r\n");
        strBuf.append("exchangeAux.FConvertMode convertMode").append("\r\n");
        strBuf.append("FROM T_BD_exchangeRate AS exchangeRate").append("\r\n");
        strBuf.append("INNER JOIN T_BD_exchangeAux AS exchangeAux ON exchangeRate.FexchangeAuxID = exchangeAux.FID").append("\r\n");
        strBuf.append("INNER JOIN T_ORG_CtrlUnit AS CU ON exchangeRate.FControlUnitID = CU.FID").append("\r\n");
        strBuf.append("INNER JOIN T_BD_Currency AS sourceCurrency ON exchangeAux.FsourceCurrencyID = sourceCurrency.FID").append("\r\n");
        strBuf.append("INNER JOIN T_BD_exchangeTable AS exchangeTable ON exchangeAux.FexchangeTableId = exchangeTable.FID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND (exchangeTable.FIsMulExchange = 1 OR (exchangeTable.FIsMulExchange <> 1) AND exchangeRate.FQuoteprice = 1)").append("\r\n");
        strBuf.append("AND sourceCurrency.FID=casRecBill.FCurrencyID").append("\r\n");
        strBuf.append("AND exchangeTable.FID=company.FBaseExgTableID").append("\r\n");
        strBuf.append("AND exchangeRate.FAvailTime <=casRecBill.FBizDate").append("\r\n");
        strBuf.append("AND exchangeRate.FInvalidTime>=casRecBill.FBizDate").append("\r\n");
        strBuf.append(") FConvertMode,--\u6298\u7b97\u65b9\u5f0f").append("\r\n");
        strBuf.append("casRecBillEntry.FUnVcAmount unVerifyAmount,--\u672a\u7ed3\u7b97\u91d1\u989d").append("\r\n");
        strBuf.append("casRecBillEntry.FUnVcLocAmount unVerifyAmountLocal,--\u672a\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("casRecBill.FIsTransBill isTransBill,--\u662f\u5426\u8f6c\u9500\u5355\u636e").append("\r\n");
        strBuf.append("casRecBill.FIsTransOtherBill isTransOtherBill,--\u662f\u5426\u8f6c\u9884\u6536\u8f6c\u9884\u4ed8").append("\r\n");
        strBuf.append("NULL isReverseBill,--\u662f\u5426\u4e3a\u51b2\u9500\u5355\u636e").append("\r\n");
        strBuf.append("NULL isAllowanceBill--\u662f\u5426\u6298\u8ba9\u5355\u636e").append("\r\n");
        strBuf.append("FROM T_CAS_ReceivingBill casRecBill").append("\r\n");
        strBuf.append("INNER JOIN T_CAS_ReceivingBillEntry casRecBillEntry ON casRecBillEntry.FReceivingBillID=casRecBill.FID").append("\r\n");
        strBuf.append("INNER JOIN T_ORG_Company company ON company.FID=casRecBill.FCompanyID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND casRecBill.FBillStatus IN ('12', '14')").append("\r\n");
        strBuf.append("AND casRecBill.FCurrencyID IN (" + currencyIDBuf + ")").append("\r\n");
        strBuf.append("AND casRecBill.FCompanyID IN (" + companyIDs + ")").append("\r\n");
        strBuf.append("AND casRecBill.FBizDate>{d '" + curEndDate + "'}").append("\r\n");
        strBuf.append("AND casRecBillEntry.FAmountVc=0").append("\r\n");
        if (isRec) {
            strBuf.append("AND casRecBill.FIsTransBill=1--\u662f\u5426\u8f6c\u9500\u5355\u636e").append("\r\n");
            strBuf.append("AND casRecBill.FIsTransOtherBill=0--\u662f\u5426\u8f6c\u9884\u6536\u8f6c\u9884\u4ed8").append("\r\n");
        } else {
            strBuf.append("AND casRecBill.FIsTransBill=0--\u662f\u5426\u8f6c\u9500\u5355\u636e").append("\r\n");
            strBuf.append("AND casRecBill.FIsTransOtherBill=1--\u662f\u5426\u8f6c\u9884\u6536\u8f6c\u9884\u4ed8").append("\r\n");
        }
        strBuf.append("AND casRecBill.FFiVouchered=0--\u662f\u5426\u5df2\u751f\u6210\u51ed\u8bc1").append("\r\n");
    }

    private static void transApOtherBillSQL(StringBuffer strBuf, String temp_SwapBill, String temp_SwapBillEntry, StringBuffer currencyIDBuf, String companyIDs, Date curEndDate, boolean isNegative, boolean isRec) {
        strBuf.append("--\u5e94\u4ed8\u5355").append("\r\n");
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("apOtherBill.FID descBillId,--\u5355\u636eid").append("\r\n");
        strBuf.append("apOtherBillEntry.FID descBillEntryId,--\u5355\u636e\u5206\u5f55id").append("\r\n");
        strBuf.append("apOtherBillEntry.FSourceBillId sourceBillId,--\u6e90\u5355id").append("\r\n");
        strBuf.append("apOtherBillEntry.FSourceBillEntryId sourceBillEntryId,--\u6e90\u5355\u636e\u5206\u5f55id").append("\r\n");
        strBuf.append("'ap' billClass,--\u5355\u636e\u7c7b\u578b").append("\r\n");
        strBuf.append("apOtherBill.FCurrencyID currencyID,--\u5e01\u522b").append("\r\n");
        strBuf.append("apOtherBillEntry.FRecievePayAmount amt,--\u91d1\u989d").append("\r\n");
        strBuf.append("apOtherBillEntry.FRecievePayAmountLocal amtLocal,--\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("apOtherBillEntry.FVerifyAmount verifyAmount,--\u5df2\u7ed3\u7b97\u91d1\u989d").append("\r\n");
        strBuf.append("apOtherBillEntry.FVerifyAmountLocal verifyAmountLocal,--\u5df2\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("(").append("\r\n");
        strBuf.append("SELECT TOP 1").append("\r\n");
        strBuf.append("exchangeAux.FConvertMode convertMode").append("\r\n");
        strBuf.append("FROM T_BD_exchangeRate AS exchangeRate").append("\r\n");
        strBuf.append("INNER JOIN T_BD_exchangeAux AS exchangeAux ON exchangeRate.FexchangeAuxID = exchangeAux.FID").append("\r\n");
        strBuf.append("INNER JOIN T_ORG_CtrlUnit AS CU ON exchangeRate.FControlUnitID = CU.FID").append("\r\n");
        strBuf.append("INNER JOIN T_BD_Currency AS sourceCurrency ON exchangeAux.FsourceCurrencyID = sourceCurrency.FID").append("\r\n");
        strBuf.append("INNER JOIN T_BD_exchangeTable AS exchangeTable ON exchangeAux.FexchangeTableId = exchangeTable.FID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND (exchangeTable.FIsMulExchange = 1 OR (exchangeTable.FIsMulExchange <> 1) AND exchangeRate.FQuoteprice = 1)").append("\r\n");
        strBuf.append("AND sourceCurrency.FID=apOtherBill.FCurrencyID").append("\r\n");
        strBuf.append("AND exchangeTable.FID=company.FBaseExgTableID").append("\r\n");
        strBuf.append("AND exchangeRate.FAvailTime <=apOtherBill.FBillDate").append("\r\n");
        strBuf.append("AND exchangeRate.FInvalidTime>=apOtherBill.FBillDate").append("\r\n");
        strBuf.append(") FConvertMode,--\u6298\u7b97\u65b9\u5f0f").append("\r\n");
        strBuf.append("apOtherBillEntry.FUnVerifyAmount unVerifyAmount,--\u672a\u7ed3\u7b97\u91d1\u989d").append("\r\n");
        strBuf.append("apOtherBillEntry.FUnVerifyAmountLocal unVerifyAmountLocal,--\u672a\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("apOtherBill.FIsTransBill isTransBill,--\u662f\u5426\u8f6c\u79fb\u751f\u6210\u5355\u636e").append("\r\n");
        strBuf.append("apOtherBill.FIsTransOtherBill isTransOtherBill,--\u662f\u5426\u8f6c\u5e94\u6536\u5e94\u4ed8").append("\r\n");
        strBuf.append("apOtherBill.FIsReverseBill isReverseBill,--\u662f\u5426\u4e3a\u51b2\u9500\u5355\u636e").append("\r\n");
        strBuf.append("NULL isAllowanceBill--\u662f\u5426\u6298\u8ba9\u5355\u636e").append("\r\n");
        strBuf.append("FROM T_AP_OtherBill apOtherBill").append("\r\n");
        strBuf.append("INNER JOIN T_AP_OtherBillEntry apOtherBillEntry ON apOtherBillEntry.FParentID=apOtherBill.FID").append("\r\n");
        strBuf.append("INNER JOIN T_ORG_Company company ON company.FID=apOtherBill.FCompanyID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND apOtherBill.FBillStatus='3'").append("\r\n");
        strBuf.append("AND apOtherBill.FUnVerifyAmount<>0").append("\r\n");
        strBuf.append("AND apOtherBill.FCurrencyID IN (" + currencyIDBuf + ")").append("\r\n");
        strBuf.append("AND apOtherBill.FCompanyID IN (" + companyIDs + ")").append("\r\n");
        strBuf.append("AND apOtherBill.FBillDate>{d '" + curEndDate + "'}").append("\r\n");
        if (isNegative) {
            strBuf.append("AND apOtherBill.FIsReverseBill=1--\u662f\u5426\u4e3a\u51b2\u9500\u5355\u636e").append("\r\n");
        } else {
            strBuf.append("AND apOtherBillEntry.FVerifyAmount=0").append("\r\n");
            if (isRec) {
                strBuf.append("AND apOtherBill.FIsTransBill=1--\u662f\u5426\u8f6c\u79fb\u751f\u6210\u5355\u636e").append("\r\n");
            } else {
                strBuf.append("AND apOtherBill.FIsTransBill=1--\u662f\u5426\u8f6c\u79fb\u751f\u6210\u5355\u636e").append("\r\n");
                strBuf.append("AND apOtherBill.FIsTransOtherBill=1--\u662f\u5426\u8f6c\u5e94\u6536\u5e94\u4ed8").append("\r\n");
            }
        }
        strBuf.append("AND apOtherBill.FFiVouchered=0--\u662f\u5426\u5df2\u751f\u6210\u51ed\u8bc1").append("\r\n");
    }

    private static void transPaySQL(StringBuffer strBuf, String temp_SwapBill, String temp_SwapBillEntry, StringBuffer currencyIDBuf, String companyIDs, Date curEndDate, boolean isRec) {
        strBuf.append("--\u4ed8\u6b3e\u5355").append("\r\n");
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("casPayBill.FID descBillId,--\u5355\u636eid").append("\r\n");
        strBuf.append("casPayBillEntry.FID descBillEntryId,--\u5355\u636e\u5206\u5f55id").append("\r\n");
        strBuf.append("casPayBillEntry.FSourceBillId sourceBillId,--\u6e90\u5355id").append("\r\n");
        strBuf.append("casPayBillEntry.FSourceBillEntryId sourceBillEntryId,--\u6e90\u5355\u636e\u5206\u5f55id").append("\r\n");
        strBuf.append("'pay' billClass,--\u5355\u636e\u7c7b\u578b").append("\r\n");
        strBuf.append("casPayBill.FCurrencyID currencyID,--\u5e01\u522b").append("\r\n");
        strBuf.append("casPayBillEntry.FActualAmt amt,--\u91d1\u989d").append("\r\n");
        strBuf.append("casPayBillEntry.FActualLocAmt amtLocal,--\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("casPayBillEntry.FAmountVc verifyAmount,--\u5df2\u7ed3\u7b97\u91d1\u989d").append("\r\n");
        strBuf.append("casPayBillEntry.FLocalAmount verifyAmountLocal,--\u5df2\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("(").append("\r\n");
        strBuf.append("SELECT TOP 1").append("\r\n");
        strBuf.append("exchangeAux.FConvertMode convertMode").append("\r\n");
        strBuf.append("FROM T_BD_exchangeRate AS exchangeRate").append("\r\n");
        strBuf.append("INNER JOIN T_BD_exchangeAux AS exchangeAux ON exchangeRate.FexchangeAuxID = exchangeAux.FID").append("\r\n");
        strBuf.append("INNER JOIN T_ORG_CtrlUnit AS CU ON exchangeRate.FControlUnitID = CU.FID").append("\r\n");
        strBuf.append("INNER JOIN T_BD_Currency AS sourceCurrency ON exchangeAux.FsourceCurrencyID = sourceCurrency.FID").append("\r\n");
        strBuf.append("INNER JOIN T_BD_exchangeTable AS exchangeTable ON exchangeAux.FexchangeTableId = exchangeTable.FID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND (exchangeTable.FIsMulExchange = 1 OR (exchangeTable.FIsMulExchange <> 1) AND exchangeRate.FQuoteprice = 1)").append("\r\n");
        strBuf.append("AND sourceCurrency.FID=casPayBill.FCurrencyID").append("\r\n");
        strBuf.append("AND exchangeTable.FID=company.FBaseExgTableID").append("\r\n");
        strBuf.append("AND exchangeRate.FAvailTime <=casPayBill.FBizDate").append("\r\n");
        strBuf.append("AND exchangeRate.FInvalidTime>=casPayBill.FBizDate").append("\r\n");
        strBuf.append(") FConvertMode,--\u6298\u7b97\u65b9\u5f0f").append("\r\n");
        strBuf.append("casPayBillEntry.FUnVcAmount unVerifyAmount,--\u672a\u7ed3\u7b97\u91d1\u989d").append("\r\n");
        strBuf.append("casPayBillEntry.FUnVcLocAmount unVerifyAmountLocal,--\u672a\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("casPayBill.FIsTransBill isTransBill,--\u662f\u5426\u8f6c\u79fb\u751f\u6210\u5355\u636e").append("\r\n");
        strBuf.append("casPayBill.FIsTransOtherBill isTransOtherBill,--\u662f\u5426\u8f6c\u5e94\u6536\u5e94\u4ed8").append("\r\n");
        strBuf.append("NULL isReverseBill,--\u662f\u5426\u4e3a\u51b2\u9500\u5355\u636e").append("\r\n");
        strBuf.append("NULL isAllowanceBill--\u662f\u5426\u6298\u8ba9\u5355\u636e").append("\r\n");
        strBuf.append("FROM T_CAS_PaymentBill casPayBill").append("\r\n");
        strBuf.append("INNER JOIN T_CAS_PaymentBillEntry casPayBillEntry ON casPayBillEntry.FPaymentBillID=casPayBill.FID").append("\r\n");
        strBuf.append("INNER JOIN T_ORG_Company company ON company.FID=casPayBill.FCompanyID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND casPayBill.FBillStatus IN ('12', '15')").append("\r\n");
        strBuf.append("AND casPayBill.FCurrencyID IN (" + currencyIDBuf + ")").append("\r\n");
        strBuf.append("AND casPayBill.FCompanyID IN (" + companyIDs + ")").append("\r\n");
        strBuf.append("AND casPayBill.FBizDate>{d '" + curEndDate + "'}").append("\r\n");
        strBuf.append("AND casPayBillEntry.FAmountVc=0").append("\r\n");
        if (isRec) {
            strBuf.append("AND casPayBill.FIsTransBill=0--\u662f\u5426\u8f6c\u9500\u5355\u636e").append("\r\n");
            strBuf.append("AND casPayBill.FIsTransOtherBill=1--\u662f\u5426\u8f6c\u9884\u6536\u8f6c\u9884\u4ed8").append("\r\n");
        } else {
            strBuf.append("AND casPayBill.FIsTransBill=1--\u662f\u5426\u8f6c\u9500\u5355\u636e").append("\r\n");
            strBuf.append("AND casPayBill.FIsTransOtherBill=0--\u662f\u5426\u8f6c\u9884\u6536\u8f6c\u9884\u4ed8").append("\r\n");
        }
        strBuf.append("AND casPayBill.FFiVouchered=0--\u662f\u5426\u5df2\u751f\u6210\u51ed\u8bc1").append("\r\n");
    }

    private static void initialData(Context ctx, String temp_SwapBill, String temp_SwapBillEntry, String temp_TranTable, StringBuffer currencyIDBuf, String companyIDs, Date curEndDate, boolean isNegative, String billType, boolean isRec) throws BOSException, EASBizException {
        String userNumber = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(ctx.getCaller().toString())).getNumber();
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("destData.descBillId,--\u5355\u636eid").append("\r\n");
        strBuf.append("destData.descBillEntryId,--\u5355\u636e\u5206\u5f55id").append("\r\n");
        strBuf.append("bill.FID sourceBillId,--\u6e90\u5355id").append("\r\n");
        strBuf.append("billEntry.FID sourceBillEntryId,--\u6e90\u5355\u636e\u5206\u5f55id").append("\r\n");
        strBuf.append("destData.billClass,--\u5355\u636e\u7c7b\u578b").append("\r\n");
        strBuf.append("destData.currencyID,--\u5e01\u522b").append("\r\n");
        strBuf.append("destData.amt,--\u91d1\u989d").append("\r\n");
        strBuf.append("destData.amtLocal,--\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("destData.verifyAmount,--\u5df2\u7ed3\u7b97\u91d1\u989d").append("\r\n");
        strBuf.append("destData.verifyAmountLocal,--\u5df2\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("destData.FConvertMode,--\u6298\u7b97\u65b9\u5f0f").append("\r\n");
        strBuf.append("destData.unVerifyAmount,--\u672a\u7ed3\u7b97\u91d1\u989d").append("\r\n");
        strBuf.append("destData.unVerifyAmountLocal,--\u672a\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("destData.isTransBill,--\u662f\u5426\u8f6c\u79fb\u751f\u6210\u5355\u636e").append("\r\n");
        strBuf.append("destData.isTransOtherBill,--\u662f\u5426\u8f6c\u5e94\u6536\u5e94\u4ed8").append("\r\n");
        strBuf.append("destData.isReverseBill,--\u662f\u5426\u4e3a\u51b2\u9500\u5355\u636e").append("\r\n");
        strBuf.append("destData.isAllowanceBill--\u662f\u5426\u6298\u8ba9\u5355\u636e").append("\r\n");
        String billTable = "";
        String billDate = "";
        String entryParentID = "";
        if (isRec) {
            if ("ar".equals(billType) || "pay".equals(billType)) {
                billTable = "T_AR_OtherBill";
                billDate = "FBillDate";
                entryParentID = "FParentID";
            } else if ("ap".equals(billType) || "rec".equals(billType)) {
                billTable = "T_CAS_ReceivingBill";
                billDate = "FBizDate";
                entryParentID = "FReceivingBillID";
            }
        } else if ("ap".equals(billType) || "rec".equals(billType)) {
            billTable = "T_AP_OtherBill";
            billDate = "FBillDate";
            entryParentID = "FParentID";
        } else if ("ar".equals(billType) || "pay".equals(billType)) {
            billTable = "T_CAS_PaymentBill";
            billDate = "FBizDate";
            entryParentID = "FPaymentBillID";
        }
        strBuf.append("FROM " + billTable + " bill").append("\r\n");
        strBuf.append("INNER JOIN " + billTable + "Entry billEntry ON billEntry." + entryParentID + "=bill.FID").append("\r\n");
        strBuf.append("INNER JOIN T_BOT_Relation botRelation ON botRelation.FSrcObjectID=bill.FID --AND FOperatorID='" + userNumber + "'").append("\r\n");
        strBuf.append("INNER JOIN (").append("\r\n");
        if ("ar".equals(billType)) {
            ArApSwapTranUtils.transArOtherBillSQL(strBuf, temp_SwapBill, temp_SwapBillEntry, currencyIDBuf, companyIDs, curEndDate, isNegative, isRec);
        } else if ("rec".equals(billType)) {
            ArApSwapTranUtils.transRecSQL(strBuf, temp_SwapBill, temp_SwapBillEntry, currencyIDBuf, companyIDs, curEndDate, isRec);
        } else if ("ap".equals(billType)) {
            ArApSwapTranUtils.transApOtherBillSQL(strBuf, temp_SwapBill, temp_SwapBillEntry, currencyIDBuf, companyIDs, curEndDate, isNegative, isRec);
        } else if ("pay".equals(billType)) {
            ArApSwapTranUtils.transPaySQL(strBuf, temp_SwapBill, temp_SwapBillEntry, currencyIDBuf, companyIDs, curEndDate, isRec);
        }
        strBuf.append(") destData ON destData.descBillId=botRelation.FDestObjectID AND destData.sourceBillEntryId=billEntry.FID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND bill." + billDate + "<={d '" + curEndDate + "'}").append("\r\n");
        RptRowSet rs = null;
        int start = 0;
        int len = 10000;
        int count = 0;
        while ((rs = ArApSwapSQLHelper.executeQuery(ctx, strBuf.toString(), null, start, len)).getRowCount() != 0) {
            StringBuffer sqlStr = new StringBuffer();
            ArrayList<Object[]> paramsTranList = new ArrayList<Object[]>();
            while (rs.next()) {
                String descBillId = rs.getString("descBillId");
                String descBillEntryId = rs.getString("descBillEntryId");
                String sourceBillId = rs.getString("sourceBillId");
                String sourceBillEntryId = rs.getString("sourceBillEntryId");
                String billClass = rs.getString("billClass");
                String currencyID = rs.getString("currencyID");
                BigDecimal amt = UIRuleUtil.getBigDecimal((Object)rs.getObject("amt"));
                BigDecimal amtLocal = UIRuleUtil.getBigDecimal((Object)rs.getObject("amtLocal"));
                BigDecimal verifyAmount = UIRuleUtil.getBigDecimal((Object)rs.getObject("verifyAmount"));
                BigDecimal verifyAmountLocal = UIRuleUtil.getBigDecimal((Object)rs.getObject("verifyAmountLocal"));
                int convertMode = UIRuleUtil.getIntValue((Object)rs.getObject("FConvertMode"));
                BigDecimal unVerifyAmount = UIRuleUtil.getBigDecimal((Object)rs.getObject("unVerifyAmount"));
                BigDecimal unVerifyAmountLocal = UIRuleUtil.getBigDecimal((Object)rs.getObject("unVerifyAmountLocal"));
                Object isTransBill = rs.getObject("isTransBill");
                Object isTransOtherBill = rs.getObject("isTransOtherBill");
                Object isReverseBill = rs.getObject("isReverseBill");
                Object isAllowanceBill = rs.getObject("isAllowanceBill");
                paramsTranList.add(new Object[]{descBillId, descBillEntryId, sourceBillId, sourceBillEntryId, billClass, currencyID, amt, amtLocal, verifyAmount, verifyAmountLocal, null, convertMode, unVerifyAmount, unVerifyAmountLocal, null, null, isTransBill, isTransOtherBill, isReverseBill, isAllowanceBill});
            }
            if (paramsTranList != null && paramsTranList.size() > 0) {
                sqlStr.append("INSERT INTO").append("\r\n");
                sqlStr.append(temp_TranTable).append("\r\n");
                sqlStr.append("VALUES(").append("\r\n");
                sqlStr.append("?,?,?,?,?,").append("\r\n");
                sqlStr.append("?,?,?,?,?,").append("\r\n");
                sqlStr.append("?,?,?,?,?,").append("\r\n");
                sqlStr.append("?,?,?,?,?").append("\r\n");
                sqlStr.append(")").append("\r\n");
                DbUtil.executeBatch((Context)ctx, (String)sqlStr.toString(), paramsTranList);
            }
            start = ++count * len + 1;
        }
    }

    private static void initialTranTempTable(Context ctx, String temp_SwapBill, String temp_SwapBillEntry, String temp_TranTable, StringBuffer currencyIDBuf, String companyIDs, Date curEndDate, boolean isNegative, boolean isRec) throws BOSException, EASBizException {
        ArApSwapTranUtils.initialData(ctx, temp_SwapBill, temp_SwapBillEntry, temp_TranTable, currencyIDBuf, companyIDs, curEndDate, isNegative, "ar", isRec);
        ArApSwapTranUtils.initialData(ctx, temp_SwapBill, temp_SwapBillEntry, temp_TranTable, currencyIDBuf, companyIDs, curEndDate, isNegative, "rec", isRec);
        ArApSwapTranUtils.initialData(ctx, temp_SwapBill, temp_SwapBillEntry, temp_TranTable, currencyIDBuf, companyIDs, curEndDate, isNegative, "ap", isRec);
        ArApSwapTranUtils.initialData(ctx, temp_SwapBill, temp_SwapBillEntry, temp_TranTable, currencyIDBuf, companyIDs, curEndDate, isNegative, "pay", isRec);
    }

    private static void updateSourceBillClass(Context ctx, String temp_TranTable, boolean isRec) throws BOSException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("sourceBillClass,").append("\r\n");
        strBuf.append("descBillID,").append("\r\n");
        strBuf.append("descBillEntryID").append("\r\n");
        strBuf.append("FROM (").append("\r\n");
        if (isRec) {
            strBuf.append("SELECT ").append("\r\n");
            strBuf.append("'ar' sourceBillClass,").append("\r\n");
            strBuf.append("FDescBillID descBillID,").append("\r\n");
            strBuf.append("FDescBillEntryID descBillEntryID").append("\r\n");
            strBuf.append("FROM " + temp_TranTable).append("\r\n");
            strBuf.append("WHERE 1=1").append("\r\n");
            strBuf.append("AND (FIsTransBill=1 AND FIsTransOtherBill IS NULL AND FVerifyAmount=0)").append("\r\n");
            strBuf.append("OR FIsReverseBill=1").append("\r\n");
            strBuf.append("OR FIsAllowanceBill=1").append("\r\n");
            strBuf.append("OR (FIsTransBill=0 AND FIsTransOtherBill=1 AND FVerifyAmount=0)").append("\r\n");
            strBuf.append("UNION ALL").append("\r\n");
            strBuf.append("SELECT ").append("\r\n");
            strBuf.append("'rec' sourceBillClass,").append("\r\n");
            strBuf.append("FDescBillID descBillID,").append("\r\n");
            strBuf.append("FDescBillEntryID descBillEntryID").append("\r\n");
            strBuf.append("FROM " + temp_TranTable).append("\r\n");
            strBuf.append("WHERE 1=1").append("\r\n");
            strBuf.append("AND (FIsTransBill=1 AND FIsTransOtherBill=0 AND FVerifyAmount=0)").append("\r\n");
            strBuf.append("OR (FIsTransBill=1 AND FIsTransOtherBill=1 AND FVerifyAmount=0)").append("\r\n");
        } else {
            strBuf.append("SELECT ").append("\r\n");
            strBuf.append("'ap' sourceBillClass,").append("\r\n");
            strBuf.append("FDescBillID descBillID,").append("\r\n");
            strBuf.append("FDescBillEntryID descBillEntryID").append("\r\n");
            strBuf.append("FROM " + temp_TranTable).append("\r\n");
            strBuf.append("WHERE 1=1").append("\r\n");
            strBuf.append("AND (FIsTransBill=1 AND FIsTransOtherBill IS NULL AND FVerifyAmount=0)").append("\r\n");
            strBuf.append("OR FIsReverseBill=1").append("\r\n");
            strBuf.append("OR (FIsTransBill=0 AND FIsTransOtherBill=1 AND FVerifyAmount=0)").append("\r\n");
            strBuf.append("UNION ALL").append("\r\n");
            strBuf.append("SELECT ").append("\r\n");
            strBuf.append("'pay' sourceBillClass,").append("\r\n");
            strBuf.append("FDescBillID descBillID,").append("\r\n");
            strBuf.append("FDescBillEntryID descBillEntryID").append("\r\n");
            strBuf.append("FROM " + temp_TranTable).append("\r\n");
            strBuf.append("WHERE 1=1").append("\r\n");
            strBuf.append("AND (FIsTransBill=1 AND FIsTransOtherBill=0 AND FVerifyAmount=0)").append("\r\n");
            strBuf.append("AND (FIsTransBill=1 AND FIsTransOtherBill=1 AND FVerifyAmount=0)").append("\r\n");
        }
        strBuf.append(")").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        RptRowSet rs = null;
        int start = 0;
        int len = 10000;
        int count = 0;
        while ((rs = ArApSwapSQLHelper.executeQuery(ctx, strBuf.toString(), null, start, len)).getRowCount() != 0) {
            StringBuffer sqlStr = new StringBuffer();
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            while (rs.next()) {
                String sourceBillClass = rs.getString("sourceBillClass");
                String descBillID = rs.getString("descBillID");
                String descBillEntryID = rs.getString("descBillEntryID");
                paramsList.add(new Object[]{sourceBillClass, descBillID, descBillEntryID});
            }
            if (paramsList != null && paramsList.size() > 0) {
                sqlStr.append("UPDATE").append("\r\n");
                sqlStr.append(temp_TranTable).append("\r\n");
                sqlStr.append("SET").append("\r\n");
                sqlStr.append("FSourceBillClass=?").append("\r\n");
                sqlStr.append("WHERE 1=1").append("\r\n");
                sqlStr.append("AND FDescBillID=?").append("\r\n");
                sqlStr.append("AND FDescBillEntryID=?").append("\r\n");
                DbUtil.executeBatch((Context)ctx, (String)strBuf.toString(), paramsList);
            }
            start = ++count * len + 1;
        }
    }

    private static void updateLastExchangeRate(Context ctx, String temp_TranTable, Object[][] currencyGroup, Date curEndDate) throws BOSException, SQLException {
        StringBuffer strBuf = new StringBuffer();
        ArrayList<Object[]> paramsDTranList = new ArrayList<Object[]>();
        ArrayList<Object[]> paramsNDTranList = new ArrayList<Object[]>();
        for (int i = 0; i < currencyGroup.length; ++i) {
            String currencyID = UIRuleUtil.getString((Object)currencyGroup[i][0]);
            BigDecimal swapExchangeRate = UIRuleUtil.getBigDecimal((Object)currencyGroup[i][1]);
            strBuf.setLength(0);
            strBuf.append("SELECT TOP 1").append("\r\n");
            strBuf.append("FConvertMode").append("\r\n");
            strBuf.append("FROM " + temp_TranTable).append("\r\n");
            strBuf.append("WHERE 1=1").append("\r\n");
            strBuf.append("AND FCurrencyID = '" + currencyID + "'").append("\r\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strBuf.toString());
            if (!rs.next()) continue;
            int convertMode = UIRuleUtil.getIntValue((Object)rs.getObject("FConvertMode"));
            if (convertMode == 0) {
                if ("".equals(currencyID)) continue;
                paramsDTranList.add(new Object[]{swapExchangeRate, swapExchangeRate, swapExchangeRate, currencyID});
                continue;
            }
            if ("".equals(currencyID)) continue;
            paramsNDTranList.add(new Object[]{swapExchangeRate, swapExchangeRate, swapExchangeRate, currencyID});
        }
        if (paramsDTranList != null && paramsDTranList.size() > 0) {
            strBuf.setLength(0);
            strBuf.append("UPDATE").append("\r\n");
            strBuf.append(temp_TranTable).append("\r\n");
            strBuf.append("SET").append("\r\n");
            strBuf.append("FLastExchangeRate=?,").append("\r\n");
            strBuf.append("FSwapAmtVcLocal=FVerifyAmount*?,").append("\r\n");
            strBuf.append("FSwapAmtUnVcLocal=FUnVerifyAmount*?").append("\r\n");
            strBuf.append("WHERE 1=1").append("\r\n");
            strBuf.append("AND FCurrencyID=?").append("\r\n");
            DbUtil.executeBatch((Context)ctx, (String)strBuf.toString(), paramsDTranList);
        }
        if (paramsNDTranList != null && paramsNDTranList.size() > 0) {
            strBuf.setLength(0);
            strBuf.append("UPDATE").append("\r\n");
            strBuf.append(temp_TranTable).append("\r\n");
            strBuf.append("SET").append("\r\n");
            strBuf.append("FLastExchangeRate=?,").append("\r\n");
            strBuf.append("FSwapAmtVcLocal=FVerifyAmount/?,").append("\r\n");
            strBuf.append("FSwapAmtUnVcLocal=FUnVerifyAmount/?").append("\r\n");
            strBuf.append("WHERE 1=1").append("\r\n");
            strBuf.append("AND FCurrencyID=?").append("\r\n");
            DbUtil.executeBatch((Context)ctx, (String)strBuf.toString(), paramsNDTranList);
        }
    }

    private static void arSQL(Context ctx, StringBuffer strBuf, String temp_TranTable) {
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("arEntry.FParentID billID,--\u5e94\u6536\u5355ID").append("\r\n");
        strBuf.append("arEntry.FID entryID,--\u5e94\u6536\u5355\u5206\u5f55ID").append("\r\n");
        strBuf.append("'ar' billClass,--\u5355\u636e\u79cd\u7c7b").append("\r\n");
        strBuf.append("arEntry.FAccountID accountID,--\u4f1a\u8ba1\u79d1\u76ee").append("\r\n");
        strBuf.append("arEntry.FVerifyAmount verifyAmount,--\u5df2\u7ed3\u7b97\u91d1\u989d").append("\r\n");
        strBuf.append("arEntry.FVerifyAmountLocal verifyAmountLocal,--\u5df2\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("arEntry.FUnVerifyAmount amount,--\u91d1\u989d\u539f\u5e01(\u672a\u7ed3\u7b97\u91d1\u989d)").append("\r\n");
        strBuf.append("arEntry.FUnVerifyAmountLocal amountLocal,--\u91d1\u989d\u672c\u4f4d\u5e01(\u672a\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01)").append("\r\n");
        strBuf.append("tempTran.FConvertMode convertMode--\u6298\u7b97\u65b9\u5f0f").append("\r\n");
        strBuf.append("FROM T_AR_OtherBillEntry arEntry").append("\r\n");
        strBuf.append("INNER JOIN " + temp_TranTable + " tempTran ON tempTran.FSourceBillEntryId=arEntry.FID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
    }

    private static void recSQL(Context ctx, StringBuffer strBuf, String temp_TranTable) {
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("recEntry.FReceivingBillID billID,--\u6536\u6b3e\u5355ID").append("\r\n");
        strBuf.append("recEntry.FID entryID,--\u6536\u6b3e\u5355\u5206\u5f55ID").append("\r\n");
        strBuf.append("'rec' billClass,--\u5355\u636e\u79cd\u7c7b").append("\r\n");
        strBuf.append("recEntry.FOppAccountID accountID,--\u4f1a\u8ba1\u79d1\u76ee").append("\r\n");
        strBuf.append("recEntry.FAmountVc verifyAmount,--\u5df2\u7ed3\u7b97\u91d1\u989d").append("\r\n");
        strBuf.append("recEntry.FLocalAmtVc verifyAmountLocal,--\u5df2\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("recEntry.FUnVcAmount amount,--\u91d1\u989d\u539f\u5e01(\u672a\u7ed3\u7b97\u91d1\u989d)").append("\r\n");
        strBuf.append("recEntry.FUnVcLocAmount amountLocal,--\u91d1\u989d\u672c\u4f4d\u5e01(\u672a\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01)").append("\r\n");
        strBuf.append("tempTran.FConvertMode convertMode--\u6298\u7b97\u65b9\u5f0f").append("\r\n");
        strBuf.append("FROM T_CAS_ReceivingBillEntry recEntry").append("\r\n");
        strBuf.append("INNER JOIN " + temp_TranTable + " tempTran ON tempTran.FSourceBillEntryId=recEntry.FID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
    }

    private static void apSQL(Context ctx, StringBuffer strBuf, String temp_TranTable) {
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("apEntry.FParentID billID,--\u5e94\u6536\u5355ID").append("\r\n");
        strBuf.append("apEntry.FID entryID,--\u5e94\u6536\u5355\u5206\u5f55ID").append("\r\n");
        strBuf.append("'ap' billClass,--\u5355\u636e\u79cd\u7c7b").append("\r\n");
        strBuf.append("apEntry.FAccountID accountID,--\u4f1a\u8ba1\u79d1\u76ee").append("\r\n");
        strBuf.append("apEntry.FVerifyAmount verifyAmount,--\u5df2\u7ed3\u7b97\u91d1\u989d").append("\r\n");
        strBuf.append("apEntry.FVerifyAmountLocal verifyAmountLocal,--\u5df2\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("apEntry.FUnVerifyAmount amount,--\u91d1\u989d\u539f\u5e01(\u672a\u7ed3\u7b97\u91d1\u989d)").append("\r\n");
        strBuf.append("apEntry.FUnVerifyAmountLocal amountLocal,--\u91d1\u989d\u672c\u4f4d\u5e01(\u672a\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01)").append("\r\n");
        strBuf.append("tempTran.FConvertMode convertMode--\u6298\u7b97\u65b9\u5f0f").append("\r\n");
        strBuf.append("FROM T_AP_OtherBillEntry apEntry").append("\r\n");
        strBuf.append("INNER JOIN " + temp_TranTable + " tempTran ON tempTran.FSourceBillEntryId=apEntry.FID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
    }

    private static void paySQL(Context ctx, StringBuffer strBuf, String temp_TranTable) {
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("payEntry.FPaymentBillID billID,--\u6536\u6b3e\u5355ID").append("\r\n");
        strBuf.append("payEntry.FID entryID,--\u6536\u6b3e\u5355\u5206\u5f55ID").append("\r\n");
        strBuf.append("'pay' billClass,--\u5355\u636e\u79cd\u7c7b").append("\r\n");
        strBuf.append("payEntry.FOppAccountID accountID,--\u4f1a\u8ba1\u79d1\u76ee").append("\r\n");
        strBuf.append("payEntry.FAmountVc verifyAmount,--\u5df2\u7ed3\u7b97\u91d1\u989d").append("\r\n");
        strBuf.append("payEntry.FLocalAmtVc verifyAmountLocal,--\u5df2\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("payEntry.FUnVcAmount amount,--\u91d1\u989d\u539f\u5e01(\u672a\u7ed3\u7b97\u91d1\u989d)").append("\r\n");
        strBuf.append("payEntry.FUnVcLocAmount amountLocal,--\u91d1\u989d\u672c\u4f4d\u5e01(\u672a\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01)").append("\r\n");
        strBuf.append("tempTran.FConvertMode convertMode--\u6298\u7b97\u65b9\u5f0f").append("\r\n");
        strBuf.append("FROM T_CAS_PaymentBillEntry payEntry").append("\r\n");
        strBuf.append("INNER JOIN " + temp_TranTable + " tempTran ON tempTran.FSourceBillEntryId=payEntry.FID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
    }

    private static void setTempSwapBillEntry(Context ctx, String temp_TranTable, String temp_SwapBillEntry, Date curEndDate, boolean isRec) throws BOSException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("billID,").append("\r\n");
        strBuf.append("entryID,").append("\r\n");
        strBuf.append("billClass,").append("\r\n");
        strBuf.append("accountID,").append("\r\n");
        strBuf.append("verifyAmount,").append("\r\n");
        strBuf.append("verifyAmountLocal,").append("\r\n");
        strBuf.append("amount,").append("\r\n");
        strBuf.append("amountLocal,").append("\r\n");
        strBuf.append("convertMode").append("\r\n");
        strBuf.append("FROM (").append("\r\n");
        if (isRec) {
            ArApSwapTranUtils.arSQL(ctx, strBuf, temp_TranTable);
            strBuf.append("UNION ALL").append("\r\n");
            ArApSwapTranUtils.recSQL(ctx, strBuf, temp_TranTable);
        } else {
            ArApSwapTranUtils.apSQL(ctx, strBuf, temp_TranTable);
            strBuf.append("UNION ALL").append("\r\n");
            ArApSwapTranUtils.paySQL(ctx, strBuf, temp_TranTable);
        }
        strBuf.append(")").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND entryID NOT IN (SELECT FEntryID FROM " + temp_SwapBillEntry + ")").append("\r\n");
        ArApSwapBaseUtils.insertOriginalData(ctx, strBuf, temp_SwapBillEntry, curEndDate, false, isRec);
    }

    private static void updateAfterEndDate(Context ctx, String temp_SwapBill, String temp_SwapBillEntry, String temp_TranTable, boolean isNegative, boolean isRec) throws BOSException, SQLException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("tranTable.FSourceBillId billID,").append("\r\n");
        strBuf.append("tranTable.FSourceBillEntryId entryID,").append("\r\n");
        strBuf.append("swapBillEntry.FVerifyAmount+tranTable.FVerifyAmount-tranTable.FUnVerifyAmount verifyAmount,").append("\r\n");
        strBuf.append("swapBillEntry.FVerifyAmountLocal+tranTable.FVerifyAmountLocal-tranTable.FUnVerifyAmountLocal verifyAmountLocal,").append("\r\n");
        strBuf.append("swapBillEntry.FAmount-tranTable.FVerifyAmount+tranTable.FUnVerifyAmount unVerifyAmount,").append("\r\n");
        strBuf.append("swapBillEntry.FAmtLocalBefore-tranTable.FVerifyAmountLocal+tranTable.FUnVerifyAmountLocal unVerifyAmountLocal").append("\r\n");
        strBuf.append("FROM " + temp_SwapBill + " swapBill").append("\r\n");
        strBuf.append("INNER JOIN " + temp_SwapBillEntry + " swapBillEntry ON swapBillEntry.FBillID=swapBill.FBillID").append("\r\n");
        strBuf.append("INNER JOIN " + temp_TranTable + " tranTable ON tranTable.FSourceBillId=swapBillEntry.FBillID AND tranTable.FSourceBillEntryId=swapBillEntry.FEntryID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        RptRowSet rs = null;
        int start = 0;
        int len = 10000;
        int count = 0;
        while ((rs = ArApSwapSQLHelper.executeQuery(ctx, strBuf.toString(), null, start, len)).getRowCount() != 0) {
            StringBuffer sqlStr = new StringBuffer();
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            while (rs.next()) {
                String billID = rs.getString("billID");
                String entryID = rs.getString("entryID");
                BigDecimal verifyAmount = rs.getBigDecimal("verifyAmount");
                BigDecimal verifyAmountLocal = rs.getBigDecimal("verifyAmountLocal");
                BigDecimal unVerifyAmount = rs.getBigDecimal("unVerifyAmount");
                BigDecimal unVerifyAmountLocal = rs.getBigDecimal("unVerifyAmountLocal");
                paramsList.add(new Object[]{verifyAmount, verifyAmountLocal, unVerifyAmount, unVerifyAmountLocal, billID, entryID});
            }
            sqlStr.append("UPDATE").append("\r\n");
            sqlStr.append(temp_SwapBillEntry).append("\r\n");
            sqlStr.append("SET").append("\r\n");
            sqlStr.append("FVerifyAmount=?,").append("\r\n");
            sqlStr.append("FVerifyAmountLocal=?,").append("\r\n");
            sqlStr.append("FAmount=?,").append("\r\n");
            sqlStr.append("FAmtLocalBefore=?").append("\r\n");
            sqlStr.append("WHERE 1=1").append("\r\n");
            sqlStr.append("AND FBillID=?").append("\r\n");
            sqlStr.append("AND FEntryID=?").append("\r\n");
            DbUtil.executeBatch((Context)ctx, (String)sqlStr.toString(), paramsList);
            start = ++count * len + 1;
        }
    }

    private static void insertOutTranData(Context ctx, StringBuffer currencyIDBuf, Object[][] currencyGroup, Date curEndDate, String periodID, String temp_SwapBill, String temp_SwapBillEntry, String temp_TranTable, boolean isRec) throws BOSException {
        StringBuffer strBuf = new StringBuffer();
        ArApSwapTranUtils.setTempSwapBillEntry(ctx, temp_TranTable, temp_SwapBillEntry, curEndDate, isRec);
        ArApSwapBaseUtils.setOriginalDataHead(ctx, periodID, temp_SwapBill, temp_SwapBillEntry, curEndDate, isRec, true);
        ArApSwapBaseUtils.updateLastExchangeRate(ctx, temp_SwapBill, currencyGroup);
    }

    public static void initialTransData(Context ctx, String temp_SwapBill, String temp_SwapBillEntry, String temp_TranTable, Object[][] currencyGroup, StringBuffer currencyIDBuf, String companyIDs, Date curEndDate, String periodID, boolean isRec) throws BOSException, SQLException, EASBizException {
        StringBuffer strBuf = new StringBuffer();
        ArApSwapTranUtils.initialTranTempTable(ctx, temp_SwapBill, temp_SwapBillEntry, temp_TranTable, currencyIDBuf, companyIDs, curEndDate, false, isRec);
        ArApSwapTranUtils.initialTranTempTable(ctx, temp_SwapBill, temp_SwapBillEntry, temp_TranTable, currencyIDBuf, companyIDs, curEndDate, true, isRec);
        ArApSwapTranUtils.updateLastExchangeRate(ctx, temp_TranTable, currencyGroup, curEndDate);
        ArApSwapTranUtils.insertOutTranData(ctx, currencyIDBuf, currencyGroup, curEndDate, periodID, temp_SwapBill, temp_SwapBillEntry, temp_TranTable, isRec);
        ArApSwapTranUtils.updateAfterEndDate(ctx, temp_SwapBill, temp_SwapBillEntry, temp_TranTable, false, isRec);
    }

    public static void updateTranBill(Context ctx, String temp_TranTable, Date curEndDate, boolean isRec) throws BOSException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("FDescBillID descBillID,").append("\r\n");
        strBuf.append("FDescBillEntryID descBillEntryID,").append("\r\n");
        strBuf.append("FBillClass billClass,").append("\r\n");
        strBuf.append("FLastExchangeRate lastExchangeRate,").append("\r\n");
        strBuf.append("FSwapAmtVcLocal swapAmtVcLocal,").append("\r\n");
        strBuf.append("FSwapAmtUnVcLocal swapAmtUnVcLocal").append("\r\n");
        strBuf.append("FROM " + temp_TranTable).append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        RptRowSet rs = null;
        int start = 0;
        int len = 10000;
        int count = 0;
        while ((rs = ArApSwapSQLHelper.executeQuery(ctx, strBuf.toString(), null, start, len)).getRowCount() != 0) {
            StringBuffer sqlStr = new StringBuffer();
            ArrayList<Object[]> paramsArBList = new ArrayList<Object[]>();
            ArrayList<Object[]> paramsArEList = new ArrayList<Object[]>();
            ArrayList<Object[]> paramsRecBList = new ArrayList<Object[]>();
            ArrayList<Object[]> paramsRecEList = new ArrayList<Object[]>();
            ArrayList<Object[]> paramsApBList = new ArrayList<Object[]>();
            ArrayList<Object[]> paramsApEList = new ArrayList<Object[]>();
            ArrayList<Object[]> paramsPayBList = new ArrayList<Object[]>();
            ArrayList<Object[]> paramsPayEList = new ArrayList<Object[]>();
            while (rs.next()) {
                String descBillID = rs.getString("descBillID");
                String descBillEntryID = rs.getString("descBillEntryID");
                String billClass = rs.getString("billClass");
                BigDecimal lastExchangeRate = UIRuleUtil.getBigDecimal((Object)rs.getBigDecimal("lastExchangeRate"));
                BigDecimal swapAmtVcLocal = UIRuleUtil.getBigDecimal((Object)rs.getBigDecimal("swapAmtVcLocal"));
                BigDecimal swapAmtUnVcLocal = UIRuleUtil.getBigDecimal((Object)rs.getBigDecimal("swapAmtUnVcLocal"));
                if ("ar".equals(billClass)) {
                    paramsArBList.add(new Object[]{lastExchangeRate, descBillID});
                    paramsArEList.add(new Object[]{swapAmtVcLocal, swapAmtUnVcLocal, descBillEntryID});
                    continue;
                }
                if ("rec".equals(billClass)) {
                    paramsRecBList.add(new Object[]{lastExchangeRate, descBillID});
                    paramsRecEList.add(new Object[]{swapAmtVcLocal, swapAmtUnVcLocal, descBillEntryID});
                    continue;
                }
                if ("ap".equals(billClass)) {
                    paramsApBList.add(new Object[]{lastExchangeRate, descBillID});
                    paramsApEList.add(new Object[]{swapAmtVcLocal, swapAmtUnVcLocal, descBillEntryID});
                    continue;
                }
                if (!"pay".equals(billClass)) continue;
                paramsPayBList.add(new Object[]{lastExchangeRate, descBillID});
                paramsPayEList.add(new Object[]{swapAmtVcLocal, swapAmtUnVcLocal, descBillEntryID});
            }
            StringBuffer updateBuf = new StringBuffer();
            if (paramsArBList != null && paramsArBList.size() > 0) {
                updateBuf.setLength(0);
                updateBuf.append("UPDATE").append("\r\n");
                updateBuf.append("T_AR_OtherBill").append("\r\n");
                updateBuf.append("SET").append("\r\n");
                updateBuf.append("FLastExhangeRate=?").append("\r\n");
                updateBuf.append("WHERE 1=1").append("\r\n");
                updateBuf.append("AND FID=?").append("\r\n");
                DbUtil.executeBatch((Context)ctx, (String)updateBuf.toString(), paramsArBList);
            }
            if (paramsArEList != null && paramsArEList.size() > 0) {
                updateBuf.setLength(0);
                updateBuf.append("UPDATE").append("\r\n");
                updateBuf.append("T_AR_OtherBillentry").append("\r\n");
                updateBuf.append("SET").append("\r\n");
                updateBuf.append("FVerifyAmountLocal=?,").append("\r\n");
                updateBuf.append("FUnVerifyAmountLocal=?").append("\r\n");
                updateBuf.append("WHERE 1=1").append("\r\n");
                updateBuf.append("AND FID=?").append("\r\n");
                DbUtil.executeBatch((Context)ctx, (String)updateBuf.toString(), paramsArEList);
            }
            if (paramsRecBList != null && paramsRecBList.size() > 0) {
                updateBuf.setLength(0);
                updateBuf.append("UPDATE").append("\r\n");
                updateBuf.append("T_CAS_ReceivingBill").append("\r\n");
                updateBuf.append("SET").append("\r\n");
                updateBuf.append("FLastExhangeRate=?").append("\r\n");
                updateBuf.append("WHERE 1=1").append("\r\n");
                updateBuf.append("AND FID=?").append("\r\n");
                DbUtil.executeBatch((Context)ctx, (String)updateBuf.toString(), paramsRecBList);
            }
            if (paramsRecEList != null && paramsRecEList.size() > 0) {
                updateBuf.setLength(0);
                updateBuf.append("UPDATE").append("\r\n");
                updateBuf.append("T_CAS_ReceivingBillEntry").append("\r\n");
                updateBuf.append("SET").append("\r\n");
                updateBuf.append("FLocalAmtVc=?,").append("\r\n");
                updateBuf.append("FUnVcLocAmount=?").append("\r\n");
                updateBuf.append("WHERE 1=1").append("\r\n");
                updateBuf.append("AND FID=?").append("\r\n");
                DbUtil.executeBatch((Context)ctx, (String)updateBuf.toString(), paramsRecEList);
            }
            if (paramsApBList != null && paramsApBList.size() > 0) {
                updateBuf.setLength(0);
                updateBuf.append("UPDATE").append("\r\n");
                updateBuf.append("T_AP_OtherBill").append("\r\n");
                updateBuf.append("SET").append("\r\n");
                updateBuf.append("FLastExhangeRate=?").append("\r\n");
                updateBuf.append("WHERE 1=1").append("\r\n");
                updateBuf.append("AND FID=?").append("\r\n");
                DbUtil.executeBatch((Context)ctx, (String)updateBuf.toString(), paramsApBList);
            }
            if (paramsApEList != null && paramsApEList.size() > 0) {
                updateBuf.setLength(0);
                updateBuf.append("UPDATE").append("\r\n");
                updateBuf.append("T_AP_OtherBillentry").append("\r\n");
                updateBuf.append("SET").append("\r\n");
                updateBuf.append("FVerifyAmountLocal=?,").append("\r\n");
                updateBuf.append("FUnVerifyAmountLocal=?").append("\r\n");
                updateBuf.append("WHERE 1=1").append("\r\n");
                updateBuf.append("AND FID=?").append("\r\n");
                DbUtil.executeBatch((Context)ctx, (String)updateBuf.toString(), paramsApEList);
            }
            if (paramsPayBList != null && paramsPayBList.size() > 0) {
                updateBuf.setLength(0);
                updateBuf.append("UPDATE").append("\r\n");
                updateBuf.append("T_CAS_PaymentBill").append("\r\n");
                updateBuf.append("SET").append("\r\n");
                updateBuf.append("FLastExhangeRate=?").append("\r\n");
                updateBuf.append("WHERE 1=1").append("\r\n");
                updateBuf.append("AND FID=?").append("\r\n");
                DbUtil.executeBatch((Context)ctx, (String)updateBuf.toString(), paramsPayBList);
            }
            if (paramsPayEList != null && paramsPayEList.size() > 0) {
                updateBuf.setLength(0);
                updateBuf.append("UPDATE").append("\r\n");
                updateBuf.append("T_CAS_PaymentBillentry").append("\r\n");
                updateBuf.append("SET").append("\r\n");
                updateBuf.append("FLocalAmtVc=?,").append("\r\n");
                updateBuf.append("FUnVcLocAmount=?").append("\r\n");
                updateBuf.append("WHERE 1=1").append("\r\n");
                updateBuf.append("AND FID=?").append("\r\n");
                DbUtil.executeBatch((Context)ctx, (String)updateBuf.toString(), paramsPayEList);
            }
            start = ++count * len + 1;
        }
    }
}

