/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParam;
import com.kingdee.eas.base.param.ParamCollection;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamFactory;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.APParamEnum;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ap.app.util.ApServerUtils;
import com.kingdee.eas.fi.ar.ARParamEnum;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.ar.ContrastAccountViewFactory;
import com.kingdee.eas.fi.ar.ContrastAccountViewInfo;
import com.kingdee.eas.fi.ar.ContrastGLFacadeFactory;
import com.kingdee.eas.fi.ar.ContrastGLQueryParam;
import com.kingdee.eas.fi.ar.IContrastAccountView;
import com.kingdee.eas.fi.ar.VerificationBillFactory;
import com.kingdee.eas.fi.ar.app.util.ArApSQLHelper;
import com.kingdee.eas.fi.ar.app.util.ArServerUtils;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.util.CommonUtils;
import com.kingdee.eas.fi.arap.IVerificationBillBase;
import com.kingdee.eas.fi.arap.VerificationBillBaseEntryInfo;
import com.kingdee.eas.fi.arap.VerificationBillBaseInfo;
import com.kingdee.eas.fi.arap.app.balance.ArApBalanceCalculatorFactory;
import com.kingdee.eas.fi.arap.app.balance.ArApBillAccountBalanceCalculator;
import com.kingdee.eas.fi.arap.app.util.TempTableUtil;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.fi.arap.util.ArApParams;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.SMSDBillConfigCollection;
import com.kingdee.eas.scm.common.SMSDBillConfigFactory;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CommonServerUtils {
    public static final String SQL_SELECT = "SELECT ";
    public static final String SQL_AND = " AND ";
    public static final String SQL_FROM = "FROM ";
    public static final String SQL_WHERE = "WHERE ";
    public static final String SQL_INSERT = "INSERT INTO ";
    public static final String UPDATE = "UPDATE";
    public static final String DEBIT = "DEBIT";
    public static final String CREDIT = "CREDIT";
    public static final String DAILY_NORMAL = "DAILY_NORMAL";
    public static final String DAILY_INITIAL = "DAILY_INITIAL";
    public static final String ACCOUNT_NORMAL = "ACCOUNT_NORMAL";
    public static final String ACCOUNT_INITIAL = "ACCOUNT_INITIAL";
    public static final String BILL_ACCOUNT = "BILL_ACCOUNT";
    public static final String SYSTEM_AR = "SYSTEM_AR";
    public static final String SYSTEM_AP = "SYSTEM_AP";
    public static final String SUB_SYSTEM_AR = "com.kingdee.eas.fi.ar.ar";
    public static final String SUB_SYSTEM_AP = "com.kingdee.eas.fi.ar.ap.ap";
    public static final String TRUE_VAL = "1";
    public static final int AR_SYSTEM = 1;
    public static final int AP_SYSTEM = 2;
    public static final int DAP_BALANCE_BIZ_BILL = 5;
    public static final int AUDITED_BALANCE_BIZ_BILL = 4;
    private static Logger logger = Logger.getLogger(CommonServerUtils.class);
    public static final String RT = " \r\n ";
    public static final String LOGIC_LEFT_BRACKET = " ( ";
    public static final String LOGIC_RIGHT_BRACKET = " ) ";
    private static Map mainMap = new HashMap();
    private static Map secondMap = new HashMap();
    private static final String BALANCE_TABLE_COLUMNS = "FID, FBALTYPE, FCOMPANYID, FPERIODID, FCURRENCYID, FBEGINBALANCEFOR,  \r\n FDEBITFOR, FCREDITFOR, FYEARDEBITFOR, FYEARCREDITFOR,  \r\n FENDBALANCEFOR, FBEGINBALANCELOCAL, FDEBITLOCAL,  \r\n FCREDITLOCAL, FYEARDEBITLOCAL, FYEARCREDITLOCAL,  \r\n FENDBALANCELOCAL, FASSTACTTYPEID, FASSTACTID,  \r\n FACCOUNT, FADMINORGUNITID, FPERSONID ";

    public static String getLocaleField(Context ctx, String field) {
        String language = ctx.getLocale().getLanguage();
        return field + "_" + language;
    }

    public static CompanyOrgUnitInfo getCurrentCompany(Context ctx) throws BOSException {
        return (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
    }

    public static UserInfo getCurrentUser(Context ctx) throws BOSException {
        UserInfo crntUsr = (UserInfo)ctx.get((Object)"UserInfo");
        return crntUsr;
    }

    public static String toSQLCondition(String[] value) {
        if (value == null || value.length == 0) {
            throw new IllegalArgumentException();
        }
        int length = value.length;
        StringBuffer inSql = new StringBuffer();
        inSql.append("in (");
        for (int i = 0; i <= length - 1; ++i) {
            String item = value[i];
            inSql.append(i > 0 ? ", '" : "'");
            inSql.append(item).append("'");
        }
        inSql.append(")");
        return inSql.toString();
    }

    public static boolean isEmpty(Collection<?> collection) {
        return null == collection ? true : collection.isEmpty();
    }

    public static int initMapSize(int initialCapacity) {
        return Math.round((float)initialCapacity / 0.75f) + 1;
    }

    public static String generateMapKey(String companyId, SystemEnum systemEnum) {
        if (StringUtils.isEmpty((String)companyId) || null == systemEnum) {
            return null;
        }
        return companyId + "_" + systemEnum.getValue();
    }

    public static Set<Integer> convertToIntegerSet(String[] stringArr) {
        HashSet<Integer> resultSet = null;
        if (null != stringArr) {
            resultSet = new HashSet<Integer>(CommonServerUtils.initMapSize(stringArr.length));
            for (int i = 0; i < stringArr.length; ++i) {
                resultSet.add(Integer.valueOf(stringArr[i]));
            }
        }
        return resultSet;
    }

    public static Map<String, SystemStatusCtrolInfo> getSysStatusCtrolInfo(Context ctx, Set<String> companyIds, Set<Integer> systems) throws BOSException {
        int size;
        int system;
        String companyId;
        HashMap<String, SystemStatusCtrolInfo> resultMap = null;
        if (CommonServerUtils.isEmpty(companyIds) || CommonServerUtils.isEmpty(systems)) {
            return resultMap;
        }
        EntityViewInfo entityView = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("systemStatus.id");
        sic.add("systemStatus.name");
        sic.add("isStart");
        sic.add("startPeriod.*");
        sic.add("currentPeriod.*");
        sic.add("isRelatedAccount");
        sic.add("relatedPeriod.id");
        sic.add("isClosedAccount");
        sic.add("company.id");
        sic.add("acPeriod.id");
        sic.add("profitCenter.id");
        entityView.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        String string = companyId = companyIds.size() == 1 ? companyIds.iterator().next() : null;
        if (!StringUtils.isEmpty((String)companyId)) {
            fic.add(new FilterItemInfo("company", (Object)companyId));
        } else {
            fic.add(new FilterItemInfo("company", companyIds, CompareType.INCLUDE));
        }
        int n = system = systems.size() == 1 ? systems.iterator().next() : -1;
        if (system > 0) {
            fic.add(new FilterItemInfo("systemStatus.name", (Object)system));
        } else {
            fic.add(new FilterItemInfo("systemStatus.name", systems, CompareType.INCLUDE));
        }
        filter.setMaskString("#0 and #1");
        entityView.setFilter(filter);
        ISystemStatusCtrol iSystemStatusCtrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        SystemStatusCtrolCollection sysStsCtrlColl = iSystemStatusCtrol.getSystemStatusCtrolCollection(entityView);
        int n2 = size = null == sysStsCtrlColl ? 0 : sysStsCtrlColl.size();
        if (size > 0) {
            resultMap = new HashMap<String, SystemStatusCtrolInfo>(CommonServerUtils.initMapSize(size));
            SystemStatusCtrolInfo sysStsCtrl = null;
            String key = null;
            for (int i = 0; i < size; ++i) {
                sysStsCtrl = sysStsCtrlColl.get(i);
                key = CommonServerUtils.generateMapKey(sysStsCtrl.getCompany().getId().toString(), sysStsCtrl.getSystemStatus().getName());
                resultMap.put(key, sysStsCtrl);
            }
        }
        return resultMap;
    }

    public static SystemStatusCtrolInfo getSysStatusCtrolInfo(Context ctx, String companyId, SystemEnum system) throws BOSException, EASBizException {
        SystemStatusCtrolInfo sysStsCtrlInfo = null;
        if (StringUtils.isEmpty((String)companyId) || null == system) {
            return sysStsCtrlInfo;
        }
        HashSet<String> companyIds = new HashSet<String>(4);
        companyIds.add(companyId);
        HashSet<Integer> systems = new HashSet<Integer>(4);
        systems.add(system.getValue());
        Map<String, SystemStatusCtrolInfo> resultMap = CommonServerUtils.getSysStatusCtrolInfo(ctx, companyIds, systems);
        if (null != resultMap) {
            sysStsCtrlInfo = resultMap.get(CommonServerUtils.generateMapKey(companyId, system));
        }
        return sysStsCtrlInfo;
    }

    @Deprecated
    public static SystemStatusCtrolInfo getSysStatusCtrolInfo(Context ctx, Object cmpnyOrgUntInfObj, SystemEnum system) throws BOSException, EASBizException {
        if (!(cmpnyOrgUntInfObj instanceof CompanyOrgUnitInfo)) {
            throw new IllegalArgumentException();
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)cmpnyOrgUntInfObj;
        return CommonServerUtils.getSysStatusCtrolInfo(ctx, company.getId().toString(), system);
    }

    public static Map<SystemEnum, SystemStatusCtrolInfo> getSysStatusInfoMap(Context ctx, String companyId, List<SystemEnum> systemEnums) throws BOSException, EASBizException {
        HashMap<SystemEnum, SystemStatusCtrolInfo> resultMap = null;
        if (StringUtils.isEmpty((String)companyId) || CommonServerUtils.isEmpty(systemEnums)) {
            return resultMap;
        }
        HashSet<String> companyIds = new HashSet<String>(4);
        companyIds.add(companyId);
        HashSet<Integer> systems = new HashSet<Integer>(CommonServerUtils.initMapSize(systemEnums.size()));
        for (int i = 0; i < systemEnums.size(); ++i) {
            systems.add(systemEnums.get(i).getValue());
        }
        Map<String, SystemStatusCtrolInfo> map = CommonServerUtils.getSysStatusCtrolInfo(ctx, companyIds, systems);
        if (null != map) {
            resultMap = new HashMap<SystemEnum, SystemStatusCtrolInfo>(CommonServerUtils.initMapSize(map.size()));
            SystemEnum system = null;
            for (int i = 0; i < systemEnums.size(); ++i) {
                system = systemEnums.get(i);
                if (map.get(CommonServerUtils.generateMapKey(companyId, system)) == null) continue;
                resultMap.put(system, map.get(CommonServerUtils.generateMapKey(companyId, system)));
            }
        }
        return resultMap;
    }

    @Deprecated
    public static SystemStatusCtrolCollection getSysStatusCollection(Context ctx, Object companyInfo, String sysString) throws BOSException, EASBizException {
        if (!(companyInfo instanceof CompanyOrgUnitInfo) || StringUtils.isEmpty((String)sysString)) {
            throw new IllegalArgumentException();
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companyInfo;
        HashSet<String> companyIds = new HashSet<String>(4);
        String companyId = company.getId().toString();
        companyIds.add(companyId);
        String[] systemArr = sysString.split(",");
        Set<Integer> systems = CommonServerUtils.convertToIntegerSet(systemArr);
        Map<String, SystemStatusCtrolInfo> resultMap = CommonServerUtils.getSysStatusCtrolInfo(ctx, companyIds, systems);
        SystemStatusCtrolCollection sysStsCtrlColl = null;
        if (null != resultMap) {
            sysStsCtrlColl = new SystemStatusCtrolCollection();
            Iterator<String> it = resultMap.keySet().iterator();
            while (it.hasNext()) {
                sysStsCtrlColl.add(resultMap.get(it.next()));
            }
        }
        return sysStsCtrlColl;
    }

    public static SystemStatusCtrolInfo getGlStatusCtrolInfo(Context ctx, Object cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmSttsCtrlInf = CommonServerUtils.getSysStatusCtrolInfo(ctx, cmpnyOrgUntInfObj, SystemEnum.GENERALLEDGER);
        return systmSttsCtrlInf;
    }

    public static boolean glIsStart(Context ctx, Object cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmStsCtrlInf = CommonServerUtils.getGlStatusCtrolInfo(ctx, cmpnyOrgUntInfObj);
        if (systmStsCtrlInf != null) {
            return systmStsCtrlInf.isIsStart();
        }
        return false;
    }

    public static PeriodInfo getGlStartPeriod(Context ctx, Object cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmStsCtrlInf = CommonServerUtils.getGlStatusCtrolInfo(ctx, cmpnyOrgUntInfObj);
        if (systmStsCtrlInf != null) {
            return systmStsCtrlInf.getStartPeriod();
        }
        return null;
    }

    public static int periodCompare(Context ctx, String sourceperiodInfoId, String targetperiodInfoId) throws BOSException, EASBizException {
        if (sourceperiodInfoId == null || targetperiodInfoId == null) {
            throw new PeriodException(PeriodException.PKNOTNULL);
        }
        PeriodInfo sourceperiodInfo = null;
        PeriodInfo targetperiodInfo = null;
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        sourceperiodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(sourceperiodInfoId));
        targetperiodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(targetperiodInfoId));
        if (sourceperiodInfo.getPeriodYear() > targetperiodInfo.getPeriodYear()) {
            return 1;
        }
        if (sourceperiodInfo.getPeriodYear() == targetperiodInfo.getPeriodYear()) {
            if (sourceperiodInfo.getPeriodNumber() > targetperiodInfo.getPeriodNumber()) {
                return 1;
            }
            if (sourceperiodInfo.getPeriodNumber() == targetperiodInfo.getPeriodNumber()) {
                return 0;
            }
            return -1;
        }
        return -1;
    }

    public static int periodCompare(Context ctx, PeriodInfo sourceperiodInfo, PeriodInfo targetperiodInfo) throws BOSException, EASBizException {
        if (sourceperiodInfo == null || targetperiodInfo == null) {
            throw new PeriodException(PeriodException.PKNOTNULL);
        }
        if (sourceperiodInfo.getPeriodYear() > targetperiodInfo.getPeriodYear()) {
            return 1;
        }
        if (sourceperiodInfo.getPeriodYear() == targetperiodInfo.getPeriodYear()) {
            if (sourceperiodInfo.getPeriodNumber() > targetperiodInfo.getPeriodNumber()) {
                return 1;
            }
            if (sourceperiodInfo.getPeriodNumber() == targetperiodInfo.getPeriodNumber()) {
                return 0;
            }
            return -1;
        }
        return -1;
    }

    public static Connection getConnection(Context ctx) throws BOSException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static AsstActTypeInfo getClient(Context ctx) throws BOSException, EASBizException {
        IAsstActType asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
        StringBuffer buffer = new StringBuffer();
        buffer.append("where");
        buffer.append(" (asstHGAttribute='customer')");
        String oql = buffer.toString();
        AsstActTypeInfo astActTypInf = (AsstActTypeInfo)asstActType.getObjectBaseInfo(oql);
        return astActTypInf;
    }

    public static AsstActTypeInfo getClient(Context ctx, String type) throws BOSException, EASBizException {
        IAsstActType asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
        StringBuffer buffer = new StringBuffer();
        buffer.append("where");
        buffer.append(" (asstHGAttribute='" + type + "')");
        String oql = buffer.toString();
        AsstActTypeInfo astActTypInf = (AsstActTypeInfo)asstActType.getObjectBaseInfo(oql);
        return astActTypInf;
    }

    public static AsstActTypeInfo getSupplier(Context ctx) throws BOSException, EASBizException {
        IAsstActType asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
        StringBuffer buffer = new StringBuffer();
        buffer.append("where");
        buffer.append(" (asstHGAttribute='provider')");
        String oql = buffer.toString();
        AsstActTypeInfo astActTypInf = (AsstActTypeInfo)asstActType.getObjectBaseInfo(oql);
        return astActTypInf;
    }

    public static boolean transferArBalance(Context ctx, String type, PeriodInfo currentPeriod, PeriodInfo nextPeriod, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return CommonServerUtils.transferBalance(ctx, SYSTEM_AR, type, currentPeriod, nextPeriod, company);
    }

    public static boolean transferApBalance(Context ctx, String type, PeriodInfo currentPeriod, PeriodInfo nextPeriod, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return CommonServerUtils.transferBalance(ctx, SYSTEM_AP, type, currentPeriod, nextPeriod, company);
    }

    public static final String createTempTable(Context ctx, Connection con, String nameKey, String fieldsDefine) throws BOSException, EASBizException {
        return TempTableUtil.createTempTable(ctx, fieldsDefine);
    }

    public static String convertDateToString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(date);
    }

    public static String arapTempTableDefine(String type) {
        StringBuffer tbl = new StringBuffer(200);
        tbl.append(" ( FCompanyID varchar(44), FAsstActTypeID varchar(44), FAsstActID ").append(" varchar(44), FCurrencyID varchar(44), FPersonID varchar(44),FAdminOrgUnitID varchar(44),");
        if (ACCOUNT_NORMAL.equals(type)) {
            tbl.append(" FAccountID varchar(44),");
        }
        tbl.append("FReceiving decimal(28, 10) DEFAULT 0.0,").append(" FActual decimal(28, 10) DEFAULT 0.0, ").append(" FReceivingLocal decimal(28, 10) DEFAULT 0.0,").append(" FActualLocal decimal(28, 10) DEFAULT 0.0 )");
        return tbl.toString();
    }

    public static String[][] getarapTempTableDefine(String type) {
        String[][] fields = ACCOUNT_NORMAL.equals(type) ? new String[][]{{"FCompanyID", "VARCHAR(44)"}, {"FAsstActTypeID", "VARCHAR(44)"}, {"FAsstActID", "VARCHAR(44)"}, {"FCurrencyID", "VARCHAR(44)"}, {"FPersonID", "VARCHAR(44)"}, {"FAdminOrgUnitID", "VARCHAR(44)"}, {"FAccountID", "VARCHAR(44)"}, {"FReceiving", "decimal(28, 10) DEFAULT 0.0"}, {"FActual", "decimal(28, 10) DEFAULT 0.0"}, {"FReceivingLocal", "decimal(28, 10) DEFAULT 0.0"}, {"FActualLocal", "decimal(28, 10) DEFAULT 0.0"}} : new String[][]{{"FCompanyID", "VARCHAR(44)"}, {"FAsstActTypeID", "VARCHAR(44)"}, {"FAsstActID", "VARCHAR(44)"}, {"FCurrencyID", "VARCHAR(44)"}, {"FPersonID", "VARCHAR(44)"}, {"FAdminOrgUnitID", "VARCHAR(44)"}, {"FReceiving", "decimal(28, 10) DEFAULT 0.0"}, {"FActual", "decimal(28, 10) DEFAULT 0.0"}, {"FReceivingLocal", "decimal(28, 10) DEFAULT 0.0"}, {"FActualLocal", "decimal(28, 10) DEFAULT 0.0"}};
        return fields;
    }

    public static String tempTableDefine() {
        StringBuffer tempDefine = new StringBuffer(200);
        tempDefine.append(" (FDebitFor decimal(28, 10) DEFAULT 0.0,").append(" FYeardebitfor decimal(28, 10) DEFAULT 0.0, ").append(" FCreditFor decimal(28, 10) DEFAULT 0.0,").append(" FYearcreditfor decimal(28, 10) DEFAULT 0.0,").append(" FDebitLocal decimal(28, 10) DEFAULT 0.0,").append(" FYeardebitLocal decimal(28, 10) DEFAULT 0.0,").append(" FCreditLocal decimal(28, 10) DEFAULT 0.0,").append(" FYearcreditLocal decimal(28, 10) DEFAULT 0.0,").append(" FId varchar(44) NOT NULL)");
        return tempDefine.toString();
    }

    private static String insertTable(String type, String tableName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("insert into");
        buffer.append(" " + tableName);
        buffer.append(" (");
        buffer.append(" FBalType");
        buffer.append(",FPeriodID");
        buffer.append(",FID");
        buffer.append(",FCompanyID");
        buffer.append(",FAsstActTypeID");
        buffer.append(",FAsstActID");
        buffer.append(",FCurrencyID,FPersonID,FAdminOrgUnitID");
        buffer.append(",FBeginBalanceFor,FDebitFor,FCreditFor,FYearDebitFor, FYearCreditFor,FEndBalanceFor,FBeginBalanceLocal,FDebitLocal,FCreditLocal,FYearDebitLocal,FYearCreditLocal,FEndBalanceLocal ");
        if (type.equals(ACCOUNT_NORMAL)) {
            buffer.append(",FAccount");
        }
        buffer.append(" ) \r\n");
        return buffer.toString();
    }

    private static String insertTableSQL(String system, String type, int balType, String periodID, String tempTable, String tableName) {
        String newID = CommonUtils.getARAPBalanceID(system, type);
        StringBuffer insertTable = new StringBuffer("");
        insertTable.append(" select ").append(balType).append(" as FBalType").append(",'").append(periodID).append("' as FPeriodID").append(",").append(newID).append(" as FID").append(",tmpBalance.FCompanyID as FCompanyID ").append(",tmpBalance.FAsstActTypeID FAsstActTypeID ").append(",tmpBalance.FAsstActID as FAsstActID ").append(",tmpBalance.FCurrencyID as FCurrencyID").append(",tmpBalance.FPersonID as FPersonID,").append(" tmpBalance.FAdminOrgUnitID as FAdminOrgUnitID,").append(" 0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0 ");
        if (type.equals(ACCOUNT_NORMAL)) {
            insertTable.append(",tmpBalance.FAccountID as FAccount ");
        }
        insertTable.append(" from ").append(tempTable).append(" tmpBalance ").append(" left outer join ").append(tableName).append(" bal ").append(" on  bal.FAsstActTypeID = tmpBalance.FAsstActTypeID ").append(" and bal.FAsstActID = tmpBalance.FAsstActID ").append(" and bal.FCurrencyID = tmpBalance.FCurrencyID ").append(" and bal.FPersonID = tmpBalance.FPersonID ").append(" and bal.FAdminOrgUnitID = tmpBalance.FAdminOrgUnitID ").append(" and bal.FCompanyID = tmpBalance.FCompanyID ").append(" and bal.FBalType=").append(balType).append(" and bal.FPeriodID='").append(periodID).append("'");
        if (type.equals(ACCOUNT_NORMAL)) {
            insertTable.append(" and bal.FAccount = tmpBalance.FAccountID ");
        }
        insertTable.append(" where bal.FCompanyID is null ");
        return insertTable.toString();
    }

    private static String updateTableSQL(String type, String tempTable, String tableName, String periodID, String companyID) {
        StringBuffer updateBuffer = new StringBuffer("");
        updateBuffer.append(" update ").append(tableName).append(" as t1 ").append(" set (FDebitFor,FYeardebitfor,FCreditFor,FYearcreditfor,").append(" FDebitLocal,FYeardebitLocal,FCreditLocal,FYearcreditLocal)");
        updateBuffer.append(" = (select ").append(" FDebitFor,FYeardebitfor,FCreditFor,FYearcreditfor,").append(" FDebitLocal,FYeardebitLocal,FCreditLocal,FYearcreditLocal ");
        updateBuffer.append(" from ").append(tempTable).append(" as t2");
        updateBuffer.append(" where t1.FID=t2.FID ");
        updateBuffer.append("and t1.FID in (").append("select FID from ").append(tempTable).append(")) ");
        updateBuffer.append("where t1.FID in (select FID from ").append(tempTable).append(")");
        return updateBuffer.toString();
    }

    private static String insertTempSQL(String type, String tempTal, String tempTable, String tableName, String periodID, String companyID) throws BOSException {
        StringBuffer insertBuffer = new StringBuffer();
        insertBuffer.append("insert into " + tempTal).append("\r\n (FID,FDebitFor,FYeardebitfor,FCreditFor,FYearcreditfor,").append(" FDebitLocal,FYeardebitLocal,FCreditLocal,FYearcreditLocal)");
        insertBuffer.append("\r\n select t3.FID,\r\n").append(" t3.FDebitFor + tmpBalance.FReceiving,\r\n").append(" t3.FYeardebitfor + tmpBalance.FReceiving, \r\n").append(" t3.FCreditFor + tmpBalance.FActual, \r\n").append(" t3.FYearcreditfor +  tmpBalance.FActual, \r\n").append(" t3.FDebitLocal + tmpBalance.FReceivingLocal,\r\n").append(" t3.FYeardebitLocal + tmpBalance.FReceivingLocal, \r\n").append(" t3.FCreditLocal + tmpBalance.FActualLocal, \r\n").append(" t3.FYearcreditLocal +  tmpBalance.FActualLocal \r\n").append(" from ").append(tableName).append(" as t3  \r\n").append(" ,").append(tempTable).append(" as tmpBalance  \r\n").append(" where  t3.FAsstActTypeID = tmpBalance.FAsstActTypeID \r\n").append(" and t3.FAsstActID = tmpBalance.FAsstActID \r\n").append(" and t3.FCurrencyID = tmpBalance.FCurrencyID \r\n").append(" and t3.FCompanyID = tmpBalance.FCompanyID \r\n").append(" and t3.FPersonID = tmpBalance.FPersonID \r\n").append(" and t3.FAdminOrgUnitID = tmpBalance.FAdminOrgUnitID \r\n");
        if (type.equals(ACCOUNT_NORMAL)) {
            insertBuffer.append(" and t3.FAccount = tmpBalance.FAccountID \r\n");
        }
        insertBuffer.append(" and t3.FPeriodID = '").append(periodID).append("'\r\n").append(" and t3.FCompanyID = '").append(companyID).append("'\r\n");
        return insertBuffer.toString();
    }

    public static void caculateCurrentPeriodBalance(Context ctx, CompanyOrgUnitInfo company, String system, String type, PeriodInfo currentPeriod) throws BOSException, EASBizException {
        String tableName = CommonUtils.getARAPBalanceTable(system, type);
        CommonServerUtils.caculateCurrentPeriodBalance(ctx, company, currentPeriod, tableName);
    }

    public static void caculateCurrentPeriodBalance(Context ctx, CompanyOrgUnitInfo company, PeriodInfo currentPeriod, String tableName) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        StringBuilder updateSQL = new StringBuilder(100);
        updateSQL.append("update " + tableName + " set FEndBalanceFor = FBeginBalanceFor + FDebitFor - FCreditFor,").append(" FEndBalanceLocal = FBeginBalanceLocal + FDebitLocal - FCreditLocal ").append(" where fcompanyid=? and fperiodid=?");
        try {
            conn = CommonServerUtils.getConnection(ctx);
            pstmt = conn.prepareStatement(updateSQL.toString());
            pstmt.setString(1, company.getId().toString());
            pstmt.setString(2, currentPeriod.getId().toString());
            pstmt.execute();
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeNextPeriodBalance(Context ctx, CompanyOrgUnitInfo company, String system, PeriodInfo period) throws BOSException, EASBizException {
        String tableName = "";
        tableName = SYSTEM_AR.equalsIgnoreCase(system) ? "t_ar_arbalance" : "t_ap_apbalance";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = CommonServerUtils.getConnection(ctx);
            pstmt = conn.prepareStatement("update " + tableName + " set FEndBalanceFor = 0.00 where fcompanyid=? and fperiodid=?");
            pstmt.setString(1, company.getId().toString());
            pstmt.setString(2, period.getId().toString());
            pstmt.execute();
            pstmt.close();
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
        }
        finally {
            SQLUtils.cleanup(pstmt, (Connection)conn);
        }
    }

    public static void reComputeInitAccountBalance(Context ctx, String system) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CommonServerUtils.getCurrentCompany(ctx);
        CommonServerUtils.reComputeInitAccountBalance(ctx, system, company);
    }

    public static void reComputeInitAccountBalance(Context ctx, String system, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        if (company == null) {
            return;
        }
        String companyID = company.getId().toString();
        if (company.getCU() == null) {
            ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo tempComp = iCompany.getCompanyOrgUnitInfo("select CU.id where id = '" + companyID + "'");
            company.setCU(tempComp.getCU());
        }
        PeriodInfo startPeriod = null;
        boolean isAr = false;
        if (system.equalsIgnoreCase(SYSTEM_AR)) {
            isAr = true;
            startPeriod = ArServerUtils.getArStartPeriod(ctx, company);
        } else {
            startPeriod = ApServerUtils.getApStartPeriod(ctx, company);
        }
        if (startPeriod == null) {
            throw new ArApCommonException(ArApCommonException.STARTPERIOD_NULL);
        }
        boolean isContrastByBillAccount = ArApParamHelper.isContrastByBillAccount(ctx, companyID, startPeriod.getNumber(), isAr);
        String[] sqlArray = new String[3];
        String periodID = startPeriod.getId().toString();
        StringBuilder initDataSQL = new StringBuilder(500);
        initDataSQL.append(" INSERT INTO ");
        String tableType = isContrastByBillAccount ? BILL_ACCOUNT : ACCOUNT_NORMAL;
        String balanceTable = CommonUtils.getARAPBalanceTable(system, tableType);
        initDataSQL.append(balanceTable).append(RT);
        initDataSQL.append(" (FID,FBalType,FCompanyID,");
        initDataSQL.append(" FPeriodID,FCurrencyID,");
        initDataSQL.append(" FBeginBalanceFor,FDebitFor,");
        initDataSQL.append(" FCreditFor ,FYearDebitFor,");
        initDataSQL.append(" FYearCreditFor ,FEndBalanceFor,");
        initDataSQL.append(" FBeginBalanceLocal,FDebitLocal,");
        initDataSQL.append(" FCreditLocal,FYearDebitLocal,");
        initDataSQL.append(" FYearCreditLocal,FEndBalanceLocal,");
        initDataSQL.append(" FAsstActTypeID,FAsstActID,FAccount");
        initDataSQL.append(",FAdminOrgUnitID,FPersonID)").append(RT);
        initDataSQL.append(" SELECT ");
        initDataSQL.append(CommonUtils.getARAPBalanceID(system, tableType));
        initDataSQL.append(" AS FID, %s AS FBalType, initData.FCompanyID,");
        initDataSQL.append(" initData.FStartPeriodID,initData.FCurrencyID,");
        initDataSQL.append(" SUM(FInitPeriodAmt*FInitPeriodDirection) AS FBeginBalanceFor,");
        initDataSQL.append(" SUM(0) AS FDebitFor,SUM(0) AS FCreditFor,SUM(FYearTotalDebitAmt) as FYearDebitFor,");
        initDataSQL.append(" SUM(FYearTotalCreditAmt) as FYearCreditFor,");
        initDataSQL.append(" SUM(FInitPeriodAmt*FInitPeriodDirection) AS FEndBalanceFor,");
        initDataSQL.append(" SUM(FInitPeriodAmtLocal*FInitPeriodDirection) AS FBeginBalanceLocal,");
        initDataSQL.append(" SUM(0) AS FDebitLocal,SUM(0) AS FCreditLocal,");
        initDataSQL.append(" SUM(FYearTotalDebitAmtLocal) AS FYearDebitLocal,");
        initDataSQL.append(" SUM(FYearTotalCreditAmtLocal) AS FYearCreditLocal,");
        initDataSQL.append(" SUM(FInitPeriodAmtLocal*FInitPeriodDirection) AS FEndBalanceLocal,");
        initDataSQL.append(" initDataEntry.FAcctCussType AS FAsstActTypeID,");
        initDataSQL.append(" initDataEntry.FAcctCussID AS FAsstActID,");
        initDataSQL.append(" initDataEntry.FAccountID FAccount, ");
        initDataSQL.append(" ISNULL(initDataEntry.FAdminOrgUnitID,'z') AS FAdminOrgUnitID, ");
        initDataSQL.append(" ISNULL(initDataEntry.FPersonID,'z') AS FPersonID ");
        initDataSQL.append(" FROM ");
        if (system.equalsIgnoreCase(SYSTEM_AR)) {
            initDataSQL.append(" T_AR_InitDataInput ");
        } else {
            initDataSQL.append(" T_AP_InitDataInput ");
        }
        initDataSQL.append(" AS initData INNER JOIN ");
        if (system.equalsIgnoreCase(SYSTEM_AR)) {
            initDataSQL.append(" T_AR_InitDataInputEntry ");
        } else {
            initDataSQL.append(" T_AP_InitDataInputEntry ");
        }
        initDataSQL.append(" AS initDataEntry ");
        initDataSQL.append(" ON initData.FID = initDataEntry.FParentID ").append(RT);
        initDataSQL.append(" INNER JOIN V_AR_AccountViewUnion AS accountView ");
        initDataSQL.append(" ON initDataEntry.FAccountID = accountView.FAccountID ").append(RT);
        initDataSQL.append(" WHERE initData.FCompanyID = ").append("'").append(companyID).append("'");
        initDataSQL.append(" AND initData.FStartPeriodID = ").append("'").append(periodID).append("'").append(RT);
        if (system.equalsIgnoreCase(SYSTEM_AR)) {
            initDataSQL.append(" AND accountView.FSystem =").append(1);
        } else {
            initDataSQL.append(" AND accountView.FSystem =").append(2);
        }
        initDataSQL.append(" AND accountView.fperiodyear =").append(startPeriod.getPeriodYear());
        initDataSQL.append(" AND accountView.fperiodnumber =").append(startPeriod.getPeriodNumber()).append(RT);
        initDataSQL.append(" and (accountView.FCompanyID='").append(companyID).append("'");
        initDataSQL.append(" or accountView.FCompanyID='111')");
        initDataSQL.append(" and accountView.FControlUnitID='").append(company.getCU().getId().toString()).append("'");
        String currentAcctTableID = CommonServerUtils.getCurrentAcctTable(ctx, company, startPeriod);
        if (!StringUtils.isEmpty((String)currentAcctTableID)) {
            initDataSQL.append(" and accountView.FAccountTableID='").append(currentAcctTableID).append("'");
        }
        initDataSQL.append(" AND initDataEntry.FIsBizBill = %s").append(RT);
        initDataSQL.append(" GROUP BY initData.FCompanyID,initData.FStartPeriodID,initData.FCurrencyID, ");
        initDataSQL.append(" initDataEntry.FAcctCussType,initDataEntry.FAcctCussID,initDataEntry.FAccountID, ");
        initDataSQL.append(" initDataEntry.FAdminOrgUnitID,initDataEntry.FPersonID ");
        StringBuilder deleteSQL = new StringBuilder(100);
        deleteSQL.append("DELETE ").append(balanceTable);
        deleteSQL.append(" WHERE FCompanyID = ").append("'").append(companyID).append("'");
        deleteSQL.append(" AND FPeriodID = ").append("'").append(periodID).append("'");
        sqlArray[0] = deleteSQL.toString();
        String balType = isContrastByBillAccount ? "20" : String.valueOf(3);
        sqlArray[1] = String.format(initDataSQL.toString(), balType, "0");
        String bizBalType = isContrastByBillAccount ? "10" : String.valueOf(5);
        sqlArray[2] = String.format(initDataSQL.toString(), bizBalType, TRUE_VAL);
        KsqlUtil.execute((Context)ctx, (String[])sqlArray);
    }

    public static void reComputeArAccountBalance(Context ctx, PeriodInfo period) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CommonServerUtils.getCurrentCompany(ctx);
        String tableName = CommonUtils.getARAPBalanceTable(SYSTEM_AR, ACCOUNT_NORMAL);
        ArApParams params = new ArApParams();
        Boolean isDAPCheckAccount = params.getBooleanObject("isDAPCheckAccount");
        if (isDAPCheckAccount == null) {
            params.setObject("isDAPCheckAccount", (Object)new Boolean(ArApParamHelper.isDAPCheckAccount(ctx)));
        }
        CommonServerUtils.computeAcctBalance(ctx, true, period, company, params, tableName);
    }

    private static String getBizBillBalanceNoVoucherSQL(Context ctx, String companyID, PeriodInfo period, boolean fAR) throws BOSException, EASBizException {
        StringBuffer buffer = new StringBuffer("");
        buffer.append(" SELECT bill.fbilldate fbilldate,").append(RT);
        buffer.append(" bill.fcompanyid fcompanyid,").append(RT);
        buffer.append(" bill.fasstacttypeid fasstacttypeid,").append(RT);
        buffer.append(" bill.fasstactid fasstactid,").append(RT);
        buffer.append(" bill.fcurrencyid fcurrencyid,").append(RT);
        buffer.append(" CASE ISNULL(RTRIM(LTRIM(bill.FPersonID)),'z') WHEN 'z' THEN 'z' WHEN '' THEN 'z' ELSE FPersonID END AS FPersonID, ").append(RT);
        buffer.append(" CASE ISNULL(RTRIM(LTRIM(bill.fadminorgunitid)),'z') WHEN 'z' THEN 'z' WHEN '' THEN 'z' ELSE FAdminOrgUnitID END AS FAdminOrgUnitID, ").append(RT);
        buffer.append(" billentry.faccountid as faccountid,").append(RT);
        buffer.append(" accountview.fcompanyid as faccountcompanyid,").append(RT);
        buffer.append(" accountview.FControlUnitID as FControlUnitID,").append(RT);
        buffer.append(" accountview.FAccountTableID as FAccountTableID,").append(RT);
        if (fAR) {
            buffer.append(" billentry.FRecievePayAmount AS fdebitamount,").append(RT);
            buffer.append(" billentry.FRecievePayAmountLocal AS fdebitamountlocal,").append(RT);
            buffer.append(" 0 AS fcreditamount,").append(RT);
            buffer.append(" 0 AS fcreditdebitamountlocal").append(RT);
            buffer.append(" FROM t_ar_otherbill bill ").append(RT);
            buffer.append(" INNER JOIN t_ar_otherbillentry billentry ").append(RT);
        } else {
            buffer.append(" 0 AS fdebitamount,").append(RT);
            buffer.append(" 0 AS fdebitamountlocal,").append(RT);
            buffer.append(" billentry.FRecievePayAmount AS fcreditamount,").append(RT);
            buffer.append(" billentry.FRecievePayAmountLocal AS fcreditdebitamountlocal").append(RT);
            buffer.append(" FROM t_ap_otherbill bill ").append(RT);
            buffer.append(" INNER JOIN t_ap_otherbillentry billentry ").append(RT);
        }
        buffer.append(" ON bill.fid = billentry.fparentid ").append(RT);
        buffer.append(" INNER JOIN v_ar_accountviewunion accountview ").append(RT);
        buffer.append(" ON billentry.faccountid = accountview.faccountid ").append(RT);
        buffer.append(" WHERE bill.FIsNeedVoucher = 1 AND bill.FBillStatus = ").append(3).append(RT);
        buffer.append(" and bill.FSourceBillType != ").append(17).append(RT);
        buffer.append(" and accountview.FSystem = ").append(fAR ? TRUE_VAL : "2").append(RT);
        buffer.append(" and bill.FIsTransBill != 1 and bill.FIsAllowanceBill != 1 ").append(RT);
        buffer.append(" and bill.FIsAppointVoucher != 1 AND bill.FIsBizBill = 1").append(RT);
        buffer.append(" and accountview.fperiodyear = ").append(period.getPeriodYear()).append(RT);
        buffer.append(" and accountview.fperiodNumber = ").append(period.getPeriodNumber()).append(RT);
        return buffer.toString();
    }

    private static String getArBalanceNoVoucherSQL(Context ctx, String recEntryTempTable, String companyID, PeriodInfo period, boolean isRecPayBill, boolean cashflag) throws BOSException, EASBizException {
        StringBuffer buffer = new StringBuffer("");
        boolean isPreRecAcct = ArServerUtils.isPreRecAcct(ctx, companyID);
        buffer.append(" SELECT bill.fbilldate fbilldate,").append(RT);
        buffer.append(" bill.fcompanyid fcompanyid,").append(RT);
        buffer.append(" bill.fasstacttypeid fasstacttypeid,").append(RT);
        buffer.append(" bill.fasstactid fasstactid,").append(RT);
        buffer.append(" bill.fcurrencyid fcurrencyid,").append(RT);
        buffer.append(" CASE ISNULL(RTRIM(LTRIM(bill.FPersonID)),'z') WHEN 'z' THEN 'z' WHEN '' THEN 'z' ELSE FPersonID END AS FPersonID, ").append(RT);
        buffer.append(" CASE ISNULL(RTRIM(LTRIM(bill.fadminorgunitid)),'z') WHEN 'z' THEN 'z' WHEN '' THEN 'z' ELSE FAdminOrgUnitID END AS FAdminOrgUnitID, ").append(RT);
        buffer.append(" billentry.faccountid as faccountid,").append(RT);
        buffer.append(" accountview.fcompanyid as faccountcompanyid,").append(RT);
        buffer.append(" accountview.FControlUnitID as FControlUnitID,").append(RT);
        buffer.append(" accountview.FAccountTableID as FAccountTableID,").append(RT);
        buffer.append(" billentry.FRecievePayAmount AS fdebitamount,").append(RT);
        buffer.append(" billentry.FRecievePayAmountLocal AS fdebitamountlocal,").append(RT);
        buffer.append(" 0 AS fcreditamount,").append(RT);
        buffer.append(" 0 AS fcreditdebitamountlocal").append(RT);
        buffer.append(" FROM t_ar_otherbill bill ").append(RT);
        buffer.append(" INNER JOIN t_ar_otherbillentry billentry ").append(RT);
        buffer.append(" ON bill.fid = billentry.fparentid ").append(RT);
        buffer.append(" INNER JOIN v_ar_accountviewunion accountview ").append(RT);
        buffer.append(" ON billentry.faccountid = accountview.faccountid ").append(RT);
        buffer.append(" WHERE bill.FIsNeedVoucher = 1 AND bill.FBillStatus = ").append(3).append(RT);
        buffer.append(" and bill.FSourceBillType != ").append(17).append(RT);
        buffer.append(" and accountview.FSystem = 1 ").append(RT);
        buffer.append(" and bill.FIsTransBill != 1 ").append(RT);
        buffer.append(" and bill.FIsAppointVoucher != 1 AND bill.FIsBizBill = 0").append(RT);
        if (!cashflag) {
            buffer.append(" and bill.Fpaymenttypeid ='91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5'").append(RT);
        }
        buffer.append(" and accountview.fperiodyear = ").append(period.getPeriodYear()).append(RT);
        buffer.append(" and accountview.fperiodNumber = ").append(period.getPeriodNumber()).append(RT);
        buffer.append(" UNION ALL ").append(RT);
        buffer.append(" SELECT fbilldate,").append(RT);
        buffer.append(" fcompanyid,").append(RT);
        buffer.append(" fasstacttypeid,").append(RT);
        buffer.append(" fasstactid,").append(RT);
        buffer.append(" fcurrencyid,").append(RT);
        buffer.append(" FPersonID, ").append(RT);
        buffer.append(" fadminorgunitid, ").append(RT);
        buffer.append(" faccountid,").append(RT);
        buffer.append(" faccountcompanyid,").append(RT);
        buffer.append(" FControlUnitID,").append(RT);
        buffer.append(" FAccountTableID,").append(RT);
        buffer.append(" fdebitamount,").append(RT);
        buffer.append(" fdebitamountlocal,").append(RT);
        buffer.append(" fcreditamount,").append(RT);
        buffer.append(" fcreditdebitamountlocal from ").append(RT);
        buffer.append(" (SELECT ").append(RT);
        buffer.append(" case (case when rtrim(t11.fnumber) is null then billType.fnumber else t11.fnumber end) ").append(RT);
        buffer.append(" when '100' then 100").append(RT);
        buffer.append(" when '101' then 101").append(RT);
        buffer.append(" when '102' then 102").append(RT);
        buffer.append(" when '103' then 103").append(RT);
        buffer.append(" when '104' then 104").append(RT);
        buffer.append(" when '105' then 105").append(RT);
        buffer.append(" when '121' then 121").append(RT);
        buffer.append(" when '999' then 999").append(RT);
        buffer.append(" else 100 end fbilltype,").append(RT);
        buffer.append(" 1 as fveriType,").append(RT);
        buffer.append(" bill.fbizdate fbilldate,").append(RT);
        buffer.append(" bill.fcompanyid fcompanyid,").append(RT);
        buffer.append(" bill.FPaymentTypeID FPaymentTypeID,").append(RT);
        buffer.append(" bill.fpayertypeid fasstacttypeid,").append(RT);
        buffer.append(" bill.fpayerid fasstactid,").append(RT);
        buffer.append(" bill.fcurrencyid fcurrencyid,").append(RT);
        buffer.append(" CASE ISNULL(RTRIM(LTRIM(bill.FPersonID)),'z') WHEN 'z' THEN 'z' WHEN '' THEN 'z' ELSE FPersonID END AS FPersonID, ").append(RT);
        buffer.append(" CASE ISNULL(RTRIM(LTRIM(bill.fadminorgunitid)),'z') WHEN 'z' THEN 'z' WHEN '' THEN 'z' ELSE FAdminOrgUnitID END AS FAdminOrgUnitID, ").append(RT);
        buffer.append(" billentry.FAccountID as faccountid,").append(RT);
        buffer.append(" accountview.fcompanyid as faccountcompanyid,").append(RT);
        buffer.append(" accountview.FControlUnitID as FControlUnitID,").append(RT);
        buffer.append(" accountview.FAccountTableID as FAccountTableID,").append(RT);
        buffer.append(" case when billentry.famount < 0 and accountview.Fdatadirection = -1 then -1 * billentry.famount else 0 end AS fdebitamount,").append(RT);
        buffer.append(" case when billentry.famount < 0 and accountview.Fdatadirection = -1 then -1 * billentry.flocalamount else 0 end AS fdebitamountlocal,").append(RT);
        buffer.append(" case when billentry.famount < 0 and accountview.Fdatadirection = -1 then 0 else billentry.famount end AS fcreditamount,").append(RT);
        buffer.append(" case when billentry.famount < 0 and accountview.Fdatadirection = -1 then 0 else billentry.flocalamount end AS fcreditdebitamountlocal").append(RT);
        buffer.append(" FROM   t_cas_receivingbill bill").append(RT);
        buffer.append(" INNER JOIN ").append(recEntryTempTable).append(" billentry").append(RT);
        buffer.append(" ON bill.fid = billentry.freceivingbillid").append(RT);
        buffer.append(" INNER JOIN v_ar_accountviewunion accountview ").append(RT);
        buffer.append(" ON billentry.FAccountID = accountview.faccountid").append(RT);
        buffer.append(" inner join  T_CAS_ReceivingBillType  billType on billentry.FRecBillTypeID = billType.FID ");
        buffer.append(" left join t_cas_receivingbilltype as t11 on billType.FPreSetBillTypeID = t11.FID ");
        buffer.append(" WHERE  (bill.fsourcetype = ").append(100).append(" AND bill.FIsNeedVoucher = 1 ").append(RT);
        buffer.append(" AND bill.FBillStatus > ").append(12).append(")").append(RT);
        buffer.append(" and  accountview.FSystem = 1 ").append(RT);
        buffer.append(" and bill.FIsTransBill != 1 and bill.FIsTransOtherBill != 1 ").append(RT);
        buffer.append(" and bill.FIsAppointVoucher != 1 ").append(RT);
        buffer.append(" and accountview.fperiodyear = ").append(period.getPeriodYear()).append(RT);
        buffer.append(" and accountview.fperiodNumber = ").append(period.getPeriodNumber()).append(RT);
        buffer.append(" ) as bill1 where ").append(RT);
        buffer.append(" (FPaymentTypeID = '").append("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5").append("'");
        if (isRecPayBill && !isPreRecAcct) {
            buffer.append(" and FVeriType <> -100").append("\r\n");
            buffer.append(" and FVeriType <> -200)").append("\r\n");
        } else if (isRecPayBill && isPreRecAcct) {
            buffer.append(" and ((FBillType = -1").append("\r\n");
            buffer.append(" and FVeriType = -1)").append("\r\n");
            buffer.append(" OR FVeriType = 1 ").append("\r\n");
            buffer.append(" OR FVeriType = -200))").append("\r\n");
        } else if (!isRecPayBill && !isPreRecAcct) {
            buffer.append(" and ((FBillType = -1").append("\r\n");
            buffer.append(" and FVeriType = -1)").append("\r\n");
            buffer.append(" OR (FVeriType = 1").append("\r\n");
            buffer.append(" and (FBillType != ").append(Integer.valueOf(String.valueOf(100))).append("\r\n");
            buffer.append(" AND FBillType != ").append(Integer.valueOf(String.valueOf(102))).append("))\r\n");
            buffer.append(" OR FVeriType = -100))").append("\r\n");
        } else if (!isRecPayBill && isPreRecAcct) {
            buffer.append(" and ((FBillType = -1").append("\r\n");
            buffer.append(" and FVeriType = -1)").append("\r\n");
            buffer.append(" OR (FVeriType = 1").append("\r\n");
            buffer.append(" and (FBillType != ").append(Integer.valueOf(String.valueOf(100))).append("\r\n");
            buffer.append(" AND FBillType != ").append(Integer.valueOf(String.valueOf(102))).append("))\r\n");
            buffer.append(" OR (FVeriType = -100").append("\r\n");
            buffer.append(" OR FVeriType = -200)))").append("\r\n");
        }
        if (cashflag) {
            buffer.append(" OR ").append(RT);
            buffer.append(" (FPaymentTypeID = '").append("cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5").append("')").append(RT);
        }
        buffer.append(" UNION ALL ").append(RT);
        buffer.append(" SELECT bill.fbilldate fbilldate,").append(RT);
        buffer.append(" bill.FCompanyOrgUnitID fcompanyid,").append(RT);
        buffer.append(" bill.FRecAsstActTypeID fasstacttypeid,").append(RT);
        buffer.append(" TO_CHAR(bill.FRecAsstActId) as fasstactid,").append(RT);
        buffer.append(" bill.FRecCurrencyID fcurrencyid,").append(RT);
        buffer.append(" CASE ISNULL(RTRIM(LTRIM(bill.FBusinessorID)),'z') WHEN 'z' THEN 'z' WHEN '' THEN 'z' ELSE FBusinessorID END AS FPersonID, ").append(RT);
        buffer.append(" CASE ISNULL(RTRIM(LTRIM(bill.FAdminOrgUnitID)),'z') WHEN 'z' THEN 'z' WHEN '' THEN 'z' ELSE FAdminOrgUnitID END AS FAdminOrgUnitID, ").append(RT);
        buffer.append(" billentry.FRecAccountID as faccountid,").append(RT);
        buffer.append(" accountview.fcompanyid as faccountcompanyid,").append(RT);
        buffer.append(" accountview.FControlUnitID as FControlUnitID,").append(RT);
        buffer.append(" accountview.FAccountTableID as FAccountTableID,").append(RT);
        buffer.append(" billentry.FReceivableAmt AS fdebitamount,").append(RT);
        buffer.append(" billentry.FReceivableAmtLo AS fdebitamountlocal,").append(RT);
        buffer.append(" 0 AS fcreditamount,").append(RT);
        buffer.append(" 0 AS fcreditdebitamountlocal").append(RT);
        buffer.append(" FROM   T_ARP_ProxyBill bill ").append(RT);
        buffer.append(" INNER JOIN T_ARP_ProxyBillEntry billentry").append(RT);
        buffer.append(" ON bill.fid = billentry.FParentID").append(RT);
        buffer.append(" INNER JOIN v_ar_accountviewunion accountview ").append(RT);
        buffer.append(" ON billentry.FRecAccountID = accountview.faccountid").append(RT);
        buffer.append(" WHERE  bill.FCheckedStatus = ").append(2).append(" AND bill.ffivouchered = 0").append(RT);
        buffer.append(" and  accountview.FSystem = 1 ").append(RT);
        buffer.append(" and accountview.fperiodyear = ").append(period.getPeriodYear()).append(RT);
        buffer.append(" and accountview.fperiodNumber = ").append(period.getPeriodNumber()).append(RT);
        return buffer.toString();
    }

    private static String getApBalanceNoVoucherSQL(Context ctx, String companyID, PeriodInfo period, boolean isRecPayBill, boolean cashflag) throws EASBizException, BOSException {
        StringBuffer buffer = new StringBuffer("");
        boolean isPrePayAcct = ApServerUtils.isPrePayAcct(ctx, companyID);
        buffer.append(" SELECT bill.fbilldate fbilldate, ").append(RT);
        buffer.append(" bill.fcompanyid fcompanyid, ").append(RT);
        buffer.append(" bill.fasstacttypeid fasstacttypeid, ").append(RT);
        buffer.append(" bill.fasstactid fasstactid, ").append(RT);
        buffer.append(" bill.fcurrencyid fcurrencyid,").append(RT);
        buffer.append(" CASE ISNULL(RTRIM(LTRIM(bill.FPersonID)),'z') WHEN 'z' THEN 'z' WHEN '' THEN 'z' ELSE FPersonID END AS FPersonID, ").append(RT);
        buffer.append(" CASE ISNULL(RTRIM(LTRIM(bill.FAdminOrgUnitID)),'z') WHEN 'z' THEN 'z' WHEN '' THEN 'z' ELSE FAdminOrgUnitID END AS FAdminOrgUnitID, ").append(RT);
        buffer.append(" billentry.faccountid as faccountid, ").append(RT);
        buffer.append(" accountview.fcompanyid as faccountcompanyid, ").append(RT);
        buffer.append(" accountview.FControlUnitID as FControlUnitID, ").append(RT);
        buffer.append(" accountview.FAccountTableID as FAccountTableID, ").append(RT);
        buffer.append("  0 AS fdebitamount, ").append(RT);
        buffer.append("  0 AS fdebitamountlocal, ").append(RT);
        buffer.append(" billentry.FRecievePayAmount AS fcreditamount, ").append(RT);
        buffer.append(" billentry.FRecievePayAmountLocal AS fcreditdebitamountlocal  ").append(RT);
        buffer.append(" FROM   t_ap_otherbill bill ").append(RT);
        buffer.append(" INNER JOIN t_ap_otherbillentry billentry  ").append(RT);
        buffer.append(" ON bill.fid = billentry.fparentid ").append(RT);
        buffer.append(" INNER JOIN v_ar_accountviewunion accountview  ").append(RT);
        buffer.append(" ON billentry.faccountid = accountview.faccountid ").append(RT);
        buffer.append(" WHERE bill.FIsNeedVoucher = 1 AND bill.FBillStatus = ").append(3).append(RT);
        buffer.append(" and accountview.FSystem = 2 ").append(RT);
        buffer.append(" and bill.FIsTransBill != 1 ").append(RT);
        buffer.append(" and bill.FIsAppointVoucher != 1 AND bill.FIsBizBill = 0").append(RT);
        if (!cashflag) {
            buffer.append(" and bill.Fpaymenttypeid ='2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5'").append(RT);
        }
        buffer.append(" and bill.FSourceBillType != ").append(14).append(RT);
        buffer.append(" and accountview.fperiodyear = ").append(period.getPeriodYear()).append(RT);
        buffer.append(" and accountview.fperiodNumber = ").append(period.getPeriodNumber()).append(RT);
        buffer.append(" UNION ALL ").append(RT);
        buffer.append(" SELECT fbilldate, ").append(RT);
        buffer.append(" fcompanyid, ").append(RT);
        buffer.append(" fasstacttypeid, ").append(RT);
        buffer.append(" fasstactid, ").append(RT);
        buffer.append(" fcurrencyid, ").append(RT);
        buffer.append(" FPersonID, ").append(RT);
        buffer.append(" FAdminOrgUnitID, ").append(RT);
        buffer.append(" faccountid,  ").append(RT);
        buffer.append(" faccountcompanyid, ").append(RT);
        buffer.append(" FControlUnitID, ").append(RT);
        buffer.append(" FAccountTableID,  ").append(RT);
        buffer.append(" fdebitamount, ").append(RT);
        buffer.append(" fdebitamountlocal, ").append(RT);
        buffer.append(" fcreditamount, ").append(RT);
        buffer.append(" fcreditdebitamountlocal  from ").append(RT);
        buffer.append(" (SELECT  ").append(RT);
        buffer.append(" case (case when rtrim(t11.fnumber) is null then billType.fnumber else t11.fnumber end) ").append(RT);
        buffer.append(" when '201' then 201 ").append(RT);
        buffer.append(" when '202' then 202 ").append(RT);
        buffer.append(" when '203' then 203 ").append(RT);
        buffer.append(" when '204' then 204 ").append(RT);
        buffer.append(" when '205' then 205 ").append(RT);
        buffer.append(" when '206' then 206 ").append(RT);
        buffer.append(" when '210' then 210 ").append(RT);
        buffer.append(" when '211' then 211 ").append(RT);
        buffer.append(" when '221' then 221 ").append(RT);
        buffer.append(" when '999' then 999 ").append(RT);
        buffer.append(" else 201 end fbilltype, ").append(RT);
        buffer.append(" 1 as fveriType, ").append(RT);
        buffer.append(" bill.fbizdate fbilldate, ").append(RT);
        buffer.append(" bill.fcompanyid fcompanyid, ").append(RT);
        buffer.append(" bill.FPaymentTypeID FPaymentTypeID,").append(RT);
        buffer.append(" bill.fpayeetypeid fasstacttypeid, ").append(RT);
        buffer.append(" bill.fpayeeid fasstactid, ").append(RT);
        buffer.append(" bill.fcurrencyid fcurrencyid, ").append(RT);
        buffer.append(" CASE ISNULL(RTRIM(LTRIM(bill.FPersonID)),'z') WHEN 'z' THEN 'z' WHEN '' THEN 'z' ELSE FPersonID END AS FPersonID, ").append(RT);
        buffer.append(" CASE ISNULL(RTRIM(LTRIM(bill.FAdminOrgUnitID)),'z') WHEN 'z' THEN 'z' WHEN '' THEN 'z' ELSE FAdminOrgUnitID END AS FAdminOrgUnitID, ").append(RT);
        buffer.append(" bill.FOppAccountID as faccountid,  ").append(RT);
        buffer.append(" accountview.fcompanyid as faccountcompanyid, ").append(RT);
        buffer.append(" accountview.FControlUnitID as FControlUnitID, ").append(RT);
        buffer.append(" accountview.FAccountTableID as FAccountTableID,  ").append(RT);
        buffer.append(" case when bill.famount < 0 and accountview.Fdatadirection = -1 then 0 else bill.famount end AS fdebitamount,").append(RT);
        buffer.append(" case when bill.famount < 0 and accountview.Fdatadirection = -1 then 0 else bill.flocalamount end AS fdebitamountlocal,").append(RT);
        buffer.append(" case when bill.famount < 0 and accountview.Fdatadirection = -1 then -1 * bill.famount else 0 end AS fcreditamount,").append(RT);
        buffer.append(" case when bill.famount < 0 and accountview.Fdatadirection = -1 then -1 * bill.flocalamount else 0 end AS fcreditdebitamountlocal").append(RT);
        buffer.append(" FROM   t_cas_paymentbill bill ").append(RT);
        buffer.append(" INNER JOIN v_ar_accountviewunion accountview  ").append(RT);
        buffer.append(" ON bill.FOppAccountID = accountview.faccountid ").append(RT);
        buffer.append(" inner join T_CAS_PaymentBillType billType on bill.FPayBillTypeID = billType.FID  ").append(RT);
        buffer.append(" left join t_cas_paymentbilltype as t11 on billType.FPreSetBillTypeID = t11.FID ");
        buffer.append(" WHERE  (bill.fsourcetype = ").append(101).append(" AND bill.FIsNeedVoucher = 1  ").append(RT);
        buffer.append(" AND bill.FBillStatus > ").append(12).append(") ").append(RT);
        buffer.append(" and  accountview.FSystem = 2 ").append(RT);
        buffer.append(" and bill.FIsTransBill != 1 and bill.FIsTransOtherBill != 1 ").append(RT);
        buffer.append(" and bill.FIsAppointVoucher != 1 ").append(RT);
        buffer.append(" and accountview.fperiodyear = ").append(period.getPeriodYear()).append(RT);
        buffer.append(" and accountview.fperiodNumber = ").append(period.getPeriodNumber()).append(RT);
        buffer.append(" ) as bill1 where ").append(RT);
        buffer.append(" (FPaymentTypeID = '").append("2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5").append("'");
        if (isRecPayBill && !isPrePayAcct) {
            buffer.append(" and FVeriType <> -100").append("\r\n");
            buffer.append(" and FVeriType <> -200)").append("\r\n");
        } else if (isRecPayBill && isPrePayAcct) {
            buffer.append(" and ((FBillType = -1").append("\r\n");
            buffer.append(" and FVeriType = -1)").append("\r\n");
            buffer.append(" OR FVeriType = 1 ").append("\r\n");
            buffer.append(" OR FVeriType = -200))").append("\r\n");
        } else if (!isRecPayBill && !isPrePayAcct) {
            buffer.append(" and ((FBillType = -1").append("\r\n");
            buffer.append(" and FVeriType = -1)").append("\r\n");
            buffer.append(" OR (FVeriType = 1").append("\r\n");
            buffer.append(" and (FBillType != ").append(Integer.valueOf(String.valueOf(201))).append("\r\n");
            buffer.append(" AND FBillType != ").append(Integer.valueOf(String.valueOf(203))).append("))\r\n");
            buffer.append(" OR FVeriType = -100))").append("\r\n");
        } else if (!isRecPayBill && isPrePayAcct) {
            buffer.append(" and ((FBillType = -1").append("\r\n");
            buffer.append(" and FVeriType = -1)").append("\r\n");
            buffer.append(" OR (FVeriType = 1").append("\r\n");
            buffer.append(" and (FBillType != ").append(Integer.valueOf(String.valueOf(201))).append("\r\n");
            buffer.append(" AND FBillType != ").append(Integer.valueOf(String.valueOf(203))).append("))\r\n");
            buffer.append(" OR (FVeriType = -100").append("\r\n");
            buffer.append(" OR FVeriType = -200)))").append("\r\n");
        }
        if (cashflag) {
            buffer.append(" OR ").append(RT);
            buffer.append(" (FPaymentTypeID = '").append("40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5").append("')").append(RT);
        }
        buffer.append(" UNION ALL").append(RT);
        buffer.append(" SELECT bill.fbilldate fbilldate, ").append(RT);
        buffer.append(" bill.FCompanyOrgUnitID fcompanyid, ").append(RT);
        buffer.append(" billentry.FPayAsstActTypeID fasstacttypeid, ").append(RT);
        buffer.append(" billentry.FPayAsstActId as fasstactid, ").append(RT);
        buffer.append(" billentry.FPayCurrencyID fcurrencyid, ").append(RT);
        buffer.append(" CASE ISNULL(RTRIM(LTRIM(bill.FBusinessorID)),'z') WHEN 'z' THEN 'z' WHEN '' THEN 'z' ELSE FBusinessorID END AS FPersonID, ").append(RT);
        buffer.append(" CASE ISNULL(RTRIM(LTRIM(bill.FAdminOrgUnitID)),'z') WHEN 'z' THEN 'z' WHEN '' THEN 'z' ELSE FAdminOrgUnitID END AS FAdminOrgUnitID, ").append(RT);
        buffer.append(" billentry.FPayAccountID as faccountid, ").append(RT);
        buffer.append(" accountview.fcompanyid as faccountcompanyid, ").append(RT);
        buffer.append(" accountview.FControlUnitID as FControlUnitID, ").append(RT);
        buffer.append(" accountview.FAccountTableID as FAccountTableID, ").append(RT);
        buffer.append(" 0 AS fdebitamount, ").append(RT);
        buffer.append(" 0 AS fdebitamountlocal, ").append(RT);
        buffer.append(" FPayableAmt AS fcreditamount, ").append(RT);
        buffer.append(" FPayableAmtLocal AS fcreditdebitamountlocal ").append(RT);
        buffer.append(" FROM   T_ARP_ProxyBill bill ").append(RT);
        buffer.append(" INNER JOIN T_ARP_ProxyBillEntry billentry ").append(RT);
        buffer.append(" ON bill.fid = billentry.FParentID ").append(RT);
        buffer.append(" INNER JOIN v_ar_accountviewunion accountview  ").append(RT);
        buffer.append(" ON billentry.FPayAccountID = accountview.faccountid ").append(RT);
        buffer.append(" WHERE  bill.FCheckedStatus = ").append(2).append(" AND bill.FFivouchered = 0 ").append(RT);
        buffer.append(" and  accountview.FSystem = 2 ").append(RT);
        buffer.append(" and accountview.fperiodyear = ").append(period.getPeriodYear()).append(RT);
        buffer.append(" and accountview.fperiodNumber = ").append(period.getPeriodNumber()).append(RT);
        return buffer.toString();
    }

    public static String builderCheckAccountSQL(Context ctx, String tempTable, String companyID, CompanyOrgUnitInfo company, ArApParams params, String currentAcctTableID, PeriodInfo period, String beginDate, String endDate, boolean fAR, boolean isRecPayBill, String dataView) throws BOSException, EASBizException {
        StringBuffer buffer = new StringBuffer("");
        buffer.append("insert into ").append(tempTable);
        buffer.append(" select ");
        buffer.append("  FCompanyID ");
        buffer.append(" ,FAsstActTypeID ");
        buffer.append(" ,FAsstActID");
        buffer.append(" ,FCurrencyID");
        buffer.append(" ,FPersonID");
        buffer.append(" ,FAdminOrgUnitID");
        buffer.append(" ,FAccountID");
        if (isRecPayBill) {
            buffer.append(" ,sum(FDirection*FDebitAmount) FTotalDebitAmount ");
            buffer.append(" ,sum(FDirection*FCreditAmount) FTotalCreditAmount ");
            buffer.append(" ,sum(FDirection*Fdebitamountlocal) FTotalDebitAmountLoc ");
            buffer.append(" ,sum(FDirection*Fcreditdebitamountlocal) FTotalCreditAmountLoc ");
        } else {
            buffer.append(" ,sum(FDebitAmount) FTotalDebitAmount ");
            buffer.append(" ,sum(FCreditAmount) FTotalCreditAmount ");
            buffer.append(" ,sum(fdebitamountlocal) FTotalDebitAmountLoc ");
            buffer.append(" ,sum(fcreditdebitamountlocal) FTotalCreditAmountLoc ");
        }
        buffer.append(" from (select FCompanyID,FAsstActTypeID,FAsstActID,FCurrencyID,");
        buffer.append(" FAccountCompanyID,FControlUnitID,FAccountTableID,FBillDate,FVoucherDate");
        buffer.append(" ,CASE ISNULL(RTRIM(LTRIM(FPersonID)),'z') WHEN 'z' THEN 'z' WHEN '' THEN 'z' ELSE FPersonID END AS FPersonID ");
        buffer.append(" ,CASE ISNULL(RTRIM(LTRIM(FAdminOrgUnitID)),'z') WHEN 'z' THEN 'z' WHEN '' THEN 'z' ELSE FAdminOrgUnitID END AS FAdminOrgUnitID, ");
        buffer.append(" FAccountID,FDirection,FDebitAmount,FCreditAmount,Fdebitamountlocal,Fcreditdebitamountlocal ");
        buffer.append(" from ").append(dataView).append(" where 1=1 ");
        Boolean isDAPCheckAccount = params.getBooleanObject("isDAPCheckAccount");
        if (isDAPCheckAccount.booleanValue()) {
            buffer.append(" and voucherBizStatus != ").append(0).append(RT);
            buffer.append(" and voucherBizStatus != ").append(2).append(RT);
        }
        buffer.append(" and fperiodyear = ").append(period.getPeriodYear()).append(RT);
        buffer.append(" and fperiodnumber = ").append(period.getPeriodNumber()).append(RT);
        buffer.append(" and ");
        buffer.append(" FCompanyID='").append(companyID).append("'");
        buffer.append(" AND FVoucherCompanyID='").append(companyID).append("'");
        buffer.append(" and (FAccountCompanyID='").append(companyID).append("'");
        buffer.append(" or FAccountCompanyID='111')");
        buffer.append(" and FControlUnitID='").append(company.getCU().getId().toString()).append("'");
        if (currentAcctTableID != null && !"".equals(currentAcctTableID)) {
            buffer.append(" and FAccountTableID='").append(currentAcctTableID).append("'");
        }
        if (isDAPCheckAccount.booleanValue()) {
            buffer.append(" and FVoucherDate>={").append(beginDate).append("}");
            buffer.append(" and FVoucherDate<{").append(endDate).append("}");
        } else {
            buffer.append(" and FBillDate>={").append(beginDate).append("}");
            buffer.append(" and FBillDate<{").append(endDate).append("}");
        }
        buffer.append(" ) as bill ");
        buffer.append(" group by FCompanyID,FAsstActTypeID,FAsstActID,FCurrencyID,FPersonID,FAdminOrgUnitID,FAccountID ");
        return buffer.toString();
    }

    private static String computeRecBill(Context ctx, Connection connection, String companyID, ArApParams params, PeriodInfo period, String beginDate, String endDate, boolean fAR) throws BOSException, EASBizException {
        String[][] tempTableDefine = ArApSQLHelper.getSysTempTableDefine();
        PreparedStatement pstmt = null;
        PreparedStatement pstmt1 = null;
        PreparedStatement updatePstmt = null;
        PreparedStatement updatePstmt1 = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        String tempTable = null;
        StringBuffer buffer = new StringBuffer("");
        StringBuffer sql = new StringBuffer("");
        try {
            tempTable = params.getString(fAR ? "CommonServerUtils.computeAcctBalance.computeRecBill.tempTable" : "CommonServerUtils.computeAcctBalance.computePayBill.tempTable");
            if (tempTable == null) {
                SysTempTableHelper sysTemp = new SysTempTableHelper(ctx, connection);
                tempTable = sysTemp.createTempTable(ctx, tempTableDefine);
            }
            Boolean isDAPCheckAccount = params.getBooleanObject("isDAPCheckAccount");
            buffer.append(" INSERT INTO ").append(tempTable).append(RT);
            if (fAR) {
                buffer.append(ArApSQLHelper.getAppointVoucherReceivingBillSQL(companyID, period, beginDate, endDate, isDAPCheckAccount));
            } else {
                buffer.append(ArApSQLHelper.getAppoingVoucherPaymentBillSQL(companyID, period, beginDate, endDate, isDAPCheckAccount));
            }
            pstmt = connection.prepareStatement(buffer.toString());
            pstmt.execute();
            pstmt.close();
            sql.append("select bill.fid, bill.faccountid, sum(bill.fdamount) as fdamount, ").append(RT);
            sql.append(" sum(bill.fdamountlocal) as fdamountlocal, sum(bill.fcamount) as fcamount,").append(RT);
            sql.append(" sum(bill.fcamountlocal) as fcamountlocal from ").append(tempTable).append(" bill ").append(RT);
            sql.append(" WHERE EXISTS (SELECT 1 FROM V_AR_AccountViewUnion accountUnion").append(RT);
            sql.append(" WHERE bill.FAccountID = accountUnion.FAccountID AND bill.FCompanyID = accountUnion.FCompanyID").append(RT);
            sql.append(" AND accountUnion.FSystem = ").append(fAR ? 1 : 2);
            sql.append(" AND accountUnion.FPeriodYear = ").append(period.getPeriodYear()).append(RT);
            sql.append(" AND accountUnion.FPeriodNumber = ").append(period.getPeriodNumber()).append(")").append(RT);
            sql.append(" group by bill.fid, bill.faccountid HAVING COUNT(*) > 1");
            pstmt = connection.prepareStatement(sql.toString());
            rs = pstmt.executeQuery();
            boolean fBatch = false;
            StringBuffer sql1 = new StringBuffer("select * from ").append(tempTable);
            sql1.append(" where fid = ? and faccountID = ?");
            pstmt1 = connection.prepareStatement(sql1.toString());
            StringBuffer updateSQL = new StringBuffer("update ").append(tempTable);
            updateSQL.append(" set fdamount = ?,fdamountlocal = ?,fcamount = ?,fcamountlocal = ? ");
            updateSQL.append(" where fentryID = ?");
            updatePstmt = connection.prepareStatement(updateSQL.toString());
            StringBuffer updateSQL1 = new StringBuffer("update ").append(tempTable);
            updateSQL1.append(" set fdamount = 0,fdamountlocal =0,fcamount = 0,fcamountlocal = 0 ");
            updateSQL1.append(" where fentryID <> ?");
            updateSQL1.append(" and fid = ?");
            updateSQL1.append(" and faccountid = ?");
            updatePstmt1 = connection.prepareStatement(updateSQL1.toString());
            while (rs.next()) {
                BigDecimal dAmount = rs.getBigDecimal("fdamount");
                if (dAmount == null) continue;
                String id = rs.getString("fid");
                String accountid = rs.getString("faccountid");
                BigDecimal dAmountLocal = rs.getBigDecimal("fdamountlocal");
                BigDecimal cAmount = rs.getBigDecimal("fcamount");
                BigDecimal cAmountLocal = rs.getBigDecimal("fcamountlocal");
                pstmt1.setString(1, id);
                pstmt1.setString(2, accountid);
                rs1 = pstmt1.executeQuery();
                if (!rs1.next()) continue;
                String entryID = rs1.getString("fentryid");
                updatePstmt.setBigDecimal(1, dAmount);
                updatePstmt.setBigDecimal(2, dAmountLocal);
                updatePstmt.setBigDecimal(3, cAmount);
                updatePstmt.setBigDecimal(4, cAmountLocal);
                updatePstmt.setString(5, entryID);
                updatePstmt.addBatch();
                updatePstmt1.setString(1, entryID);
                updatePstmt1.setString(2, id);
                updatePstmt1.setString(3, accountid);
                updatePstmt1.addBatch();
                fBatch = true;
            }
            if (fBatch) {
                updatePstmt.executeBatch();
                updatePstmt1.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(updatePstmt);
                SQLUtils.cleanup(updatePstmt1);
                SQLUtils.cleanup(rs, pstmt);
                SQLUtils.cleanup(rs1, pstmt1);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)updatePstmt);
        SQLUtils.cleanup((Statement)updatePstmt1);
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
        SQLUtils.cleanup(rs1, (Statement)pstmt1);
        return tempTable;
    }

    private static String computeReceivingBillEntry(Context ctx, Connection connection, String companyID, String beginDate, String endDate, ArApParams params) throws BOSException, EASBizException {
        String[][] tempTableDefine = ArApSQLHelper.getRecBillSysTempTableDefine();
        PreparedStatement pstmt = null;
        PreparedStatement pstmt1 = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        PreparedStatement updatePstmt = null;
        PreparedStatement updatePstmt1 = null;
        String tempTable = null;
        StringBuffer buffer = new StringBuffer("");
        StringBuffer sql = new StringBuffer("");
        try {
            tempTable = params.getString("CommonServerUtils.computeAcctBalance.computeReceivingBillEntry.tempTable");
            if (tempTable == null) {
                SysTempTableHelper sysTemp = new SysTempTableHelper(ctx, connection);
                tempTable = sysTemp.createTempTable(ctx, tempTableDefine);
            }
            buffer.append(" INSERT INTO ").append(tempTable).append(RT);
            buffer.append(ArApSQLHelper.getReceivingBillEntrySQL(companyID, beginDate, endDate));
            pstmt = connection.prepareStatement(buffer.toString());
            pstmt.execute();
            pstmt.close();
            sql.append("select freceivingbillid,FAccountID,sum(famount) as famount, ").append(RT);
            sql.append(" sum(flocalamount) as flocalamount from ").append(tempTable).append(RT);
            sql.append(" group by freceivingbillid,FAccountID HAVING COUNT(*) > 1");
            pstmt = connection.prepareStatement(sql.toString());
            rs = pstmt.executeQuery();
            boolean fBatch = false;
            StringBuffer sql1 = new StringBuffer("select * from ").append(tempTable);
            sql1.append(" where freceivingbillid = ? and faccountID = ?");
            pstmt1 = connection.prepareStatement(sql1.toString());
            StringBuffer updateSQL = new StringBuffer("update ").append(tempTable);
            updateSQL.append(" set famount = ?,flocalamount = ? ");
            updateSQL.append(" where FID = ?");
            updatePstmt = connection.prepareStatement(updateSQL.toString());
            StringBuffer updateSQL1 = new StringBuffer("update ").append(tempTable);
            updateSQL1.append(" set famount = 0,flocalamount =0 ");
            updateSQL1.append(" where fid <> ?");
            updateSQL1.append(" and freceivingbillid = ?");
            updateSQL1.append(" and faccountid = ?");
            updatePstmt1 = connection.prepareStatement(updateSQL1.toString());
            while (rs.next()) {
                BigDecimal amount = rs.getBigDecimal("famount");
                if (amount == null) continue;
                String receivingbillid = rs.getString("freceivingbillid");
                String accountid = rs.getString("faccountid");
                BigDecimal amountLocal = rs.getBigDecimal("flocalamount");
                pstmt1.setString(1, receivingbillid);
                pstmt1.setString(2, accountid);
                rs1 = pstmt1.executeQuery();
                if (!rs1.next()) continue;
                String id = rs1.getString("fid");
                updatePstmt.setBigDecimal(1, amount);
                updatePstmt.setBigDecimal(2, amountLocal);
                updatePstmt.setString(3, id);
                updatePstmt.addBatch();
                updatePstmt1.setString(1, id);
                updatePstmt1.setString(2, receivingbillid);
                updatePstmt1.setString(3, accountid);
                updatePstmt1.addBatch();
                fBatch = true;
            }
            if (fBatch) {
                updatePstmt.executeBatch();
                updatePstmt1.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(updatePstmt);
                SQLUtils.cleanup(updatePstmt1);
                SQLUtils.cleanup(rs, pstmt);
                SQLUtils.cleanup(rs1, pstmt1);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)updatePstmt);
        SQLUtils.cleanup((Statement)updatePstmt1);
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
        SQLUtils.cleanup(rs1, (Statement)pstmt1);
        return tempTable;
    }

    public static void computeBillBalance(Context ctx, boolean fAR, PeriodInfo period, CompanyOrgUnitInfo company, String tableName, String resultTableName, ContrastGLQueryParam param) throws BOSException, EASBizException {
        if (period == null) {
            throw new IllegalArgumentException();
        }
        if (company == null) {
            throw new IllegalArgumentException();
        }
        String companyID = company.getId().toString();
        String tempTableDefine = CommonServerUtils.arapTempTableDefine(ACCOUNT_NORMAL);
        String beginDate = CommonServerUtils.convertDateToString(period.getBeginDate());
        String endDate = CommonServerUtils.convertDateToString(BaseDataUtil.upTimestamp(period.getEndDate()));
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        TempTablePool tmpTblPool = TempTablePool.getInstance((Context)ctx);
        try {
            connection = CommonServerUtils.getConnection(ctx);
            String tempTable = CommonServerUtils.createTempTable(ctx, connection, "accountBalance", tempTableDefine);
            String resultTempTable = CommonServerUtils.createTempTable(ctx, connection, "arAccountBalance", tempTableDefine);
            try {
                tmpTblPool.createIndex(tempTable, "FCompanyID,FCurrencyID,FAsstActTypeID,FAsstActID,FAccountID,FAdminOrgUnitID,FPersonID", false, false);
            }
            catch (Exception e2) {
                e2.printStackTrace(System.out);
            }
            try {
                tmpTblPool.createIndex(resultTempTable, "FCompanyID,FCurrencyID,FAsstActTypeID,FAsstActID,FAccountID,FAdminOrgUnitID,FPersonID", false, false);
            }
            catch (Exception e2) {
                e2.printStackTrace(System.out);
            }
            if (fAR || param.isQueryAll()) {
                pstmt = connection.prepareStatement(CommonServerUtils.insertARBillDataSQL(ctx, tempTable, beginDate, endDate, companyID, param));
                pstmt.execute();
                pstmt.close();
            }
            if (!fAR || param.isQueryAll()) {
                pstmt = connection.prepareStatement(CommonServerUtils.insertAPBillDataSQL(ctx, tempTable, beginDate, endDate, companyID, param));
                pstmt.execute();
                pstmt.close();
            }
            pstmt = connection.prepareStatement(CommonServerUtils.builderBillDataSQL(ctx, resultTempTable, tempTable, fAR));
            pstmt.execute();
            pstmt.close();
            try {
                tmpTblPool.analyzeTable(connection, resultTempTable);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            StringBuffer insertBuffer = new StringBuffer("");
            insertBuffer.append(CommonServerUtils.insertBillSQL(3, resultTempTable, tableName));
            pstmt = connection.prepareStatement(insertBuffer.toString());
            pstmt.execute();
            pstmt.close();
            try {
                tmpTblPool.analyzeTable(connection, tableName);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            StringBuffer updateBuffer = new StringBuffer(CommonServerUtils.updateBillSQL(3, tableName, resultTableName));
            pstmt = connection.prepareStatement(updateBuffer.toString());
            pstmt.executeUpdate();
            pstmt.close();
            try {
                tmpTblPool.analyzeTable(connection, resultTableName);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            TempTableUtil.releasTempTable(ctx, tableName);
            TempTableUtil.releasTempTable(ctx, resultTempTable);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)connection);
    }

    private static String insertAPBillDataSQL(Context ctx, String tempTable, String beginDate, String endDate, String companyID, ContrastGLQueryParam param) throws BOSException, EASBizException {
        StringBuffer buffer;
        block15: {
            block14: {
                buffer = new StringBuffer("");
                buffer.append(SQL_INSERT).append(tempTable);
                buffer.append("(FCompanyID, FASSTACTTYPEID, FASSTACTID, FCURRENCYID, FPersonID, FAdminOrgUnitID, FACCOUNTID,");
                buffer.append("FRECEIVING, FRECEIVINGLOCAL, FACTUAL, FACTUALLOCAL)");
                buffer.append(" SELECT bill.FCompanyID, bill.fasstacttypeid FASSTACTTYPEID,");
                buffer.append(" bill.fasstactid FASSTACTID, bill.fcurrencyid FCURRENCYID, bill.FPersonID FPERSONID, bill.FAdminOrgUnitID FADMINORGUNITID,");
                buffer.append(" billentry.FAccountID FACCOUNTID,");
                buffer.append(" 0 FDAMOUNT, 0 FDAMOUNTLOCAL,");
                buffer.append(" billentry.FRecievePayAmount FCAMOUNT, billentry.FRecievePayAmountLocal FCAMOUNTLOCAL");
                buffer.append(" FROM t_ap_otherbill BILL");
                buffer.append(" INNER JOIN t_ap_otherbillentry BILLENTRY ON bill.fid = billentry.fparentid");
                buffer.append(" WHERE bill.FBillStatus = 3");
                if (!param.isIncludeBizBill()) {
                    buffer.append(" AND bill.FIsBizBill = 0");
                }
                if (!param.isCash()) {
                    buffer.append(" and bill.FPaymentTypeID='").append("2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5").append("'").append(RT);
                }
                buffer.append(" and bill.fbilldate>={").append(beginDate).append("}");
                buffer.append(" and bill.fbilldate<{").append(endDate).append("}");
                buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
                buffer.append(" UNION ALL");
                buffer.append(" SELECT bill.FCompanyID, bill.FAsstActTypeID_SourceBill FASSTACTTYPEID,");
                buffer.append(" bill.FAsstActID_SourceBill FASSTACTID, bill.fcurrencyid FCURRENCYID, bill.FPersonID_SourceBill FPERSONID, bill.FAdminOrgUnitId_SourceBill FADMINORGUNITID,");
                buffer.append(" billentry.FAccountID FACCOUNTID,");
                buffer.append(" billentry.FRecievePayAmount FDAMOUNT, billentry.FRecievePayAmountLocal FDAMOUNTLOCAL,");
                buffer.append(" 0 FCAMOUNT, 0 FCAMOUNTLOCAL");
                buffer.append(" FROM t_ap_otherbill BILL");
                buffer.append(" INNER JOIN t_ap_otherbillentry BILLENTRY ON bill.fid = billentry.fparentid");
                buffer.append(" WHERE bill.fistransbill = 1 and bill.FBillStatus = 3");
                buffer.append(" and bill.fIsTransOtherBill <> 1");
                buffer.append(" and bill.fbilldate>={").append(beginDate).append("}");
                buffer.append(" and bill.fbilldate<{").append(endDate).append("}");
                buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
                buffer.append(" UNION ALL");
                if (!param.isRedRecNegative()) break block14;
                buffer.append(" SELECT bill.FCompanyID, bill.fpayeetypeid FASSTACTTYPEID,");
                buffer.append(" bill.fpayeeid FASSTACTID, bill.fcurrencyid FCURRENCYID, bill.FPersonID FPERSONID, bill.FAdminOrgUnitID FADMINORGUNITID,");
                buffer.append(" bill.FOppAccountID FACCOUNTID,");
                buffer.append(" bill.FAmount FDAMOUNT, bill.FLocalAmount FDAMOUNTLOCAL,");
                buffer.append(" 0 FCAMOUNT, 0 FCAMOUNTLOCAL");
                buffer.append(" FROM T_CAS_PAYMENTBILL BILL");
                buffer.append(" WHERE bill.fsourcetype = 101 and bill.FBillStatus = 15");
                if (!param.isCash()) {
                    buffer.append(" and bill.FPaymentTypeID='").append("2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5").append("'").append(RT);
                }
                buffer.append(" and bill.fbizdate>={").append(beginDate).append("}");
                buffer.append(" and bill.fbizdate<{").append(endDate).append("}");
                buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
                buffer.append(" UNION ALL");
                buffer.append(" SELECT bill.FCompanyID, bill.FAsstActTypeID_SourceBill FASSTACTTYPEID,");
                buffer.append(" bill.FAsstActID_SourceBill FASSTACTID, bill.fcurrencyid FCURRENCYID, bill.FPersonID_SourceBill FPERSONID, bill.FAdminOrgUnitId_SourceBill FADMINORGUNITID,");
                buffer.append(" bill.FOppAccountID FACCOUNTID,");
                buffer.append(" 0 FDAMOUNT, 0 FDAMOUNTLOCAL,");
                buffer.append(" bill.FAmount FCAMOUNT, bill.FLocalAmount FCAMOUNTLOCAL");
                buffer.append(" FROM T_CAS_PAYMENTBILL BILL");
                buffer.append(" WHERE bill.fsourcetype = 101 AND bill.fistransbill = 1");
                buffer.append(" AND bill.FIsTransOtherBill = 0 and bill.FBillStatus = 15");
                buffer.append(" and bill.fbizdate>={").append(beginDate).append("}");
                buffer.append(" and bill.fbizdate<{").append(endDate).append("}");
                buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
                buffer.append(" UNION ALL");
                buffer.append(" SELECT bill.FCompanyID, billentry.facctcusstypeid FASSTACTTYPEID,");
                buffer.append(" billentry.facctcussid FASSTACTID, billentry.fcurrencyid FCURRENCYID, billentry.fpersonid FPERSONID, billentry.fadminorgunitid FADMINORGUNITID,");
                buffer.append(" billentry.FAccountID FACCOUNTID,");
                buffer.append(" 0 FDAMOUNT, 0 FDAMOUNTLOCAL,");
                buffer.append(" billentry.fthisverificateamt FCAMOUNT, billentry.fthisverificateamtloc FCAMOUNTLOCAL");
                buffer.append(" FROM t_ap_verificationbill BILL");
                buffer.append(" INNER JOIN t_ap_verificationbillentry BILLENTRY ON bill.fid = billentry.fparentid");
                buffer.append(" WHERE (bill.fverificationtype IN (211, 204, 212, 210, 207)");
                buffer.append(" OR (bill.fverificationtype = 201 AND bill.FIsSameCurrency = 0))");
                buffer.append(" AND bill.Fiscashsalepur != 1");
                buffer.append(" AND billentry.fbilltype = 4");
                buffer.append(" and bill.fbizdate>={").append(beginDate).append("}");
                buffer.append(" and bill.fbizdate<{").append(endDate).append("}");
                buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
                buffer.append(" UNION ALL");
                buffer.append(" SELECT bill.FCompanyID, billentry.facctcusstypeid FASSTACTTYPEID,");
                buffer.append(" billentry.facctcussid FASSTACTID, billentry.fcurrencyid FCURRENCYID, billentry.fpersonid FPERSONID, billentry.fadminorgunitid FADMINORGUNITID,");
                buffer.append(" billentry.FAccountID FACCOUNTID,");
                buffer.append(" 0 FDAMOUNT, 0 FDAMOUNTLOCAL,");
                buffer.append(" billentry.fthisverificateamt FCAMOUNT, billentry.fthisverificateamtloc FCAMOUNTLOCAL");
                buffer.append(" FROM t_ar_verificationbill BILL");
                buffer.append(" INNER JOIN t_ar_verificationbillentry BILLENTRY ON bill.fid = billentry.fparentid");
                buffer.append(" WHERE bill.fverificationtype IN (113, 104, 114, 110)");
                buffer.append(" AND bill.Fiscashsalepur != 1");
                buffer.append(" AND billentry.fbilltype = 4");
                buffer.append(" and bill.fbizdate>={").append(beginDate).append("}");
                buffer.append(" and bill.fbizdate<{").append(endDate).append("}");
                buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
                buffer.append(" UNION ALL");
                break block15;
            }
            String recpayTempTable = TempTableUtil.createTempTable(ctx, CommonServerUtils.recpayTempTableDefine());
            StringBuffer paySql = new StringBuffer("");
            paySql.append(SQL_INSERT).append(recpayTempTable);
            paySql.append(" SELECT bill.FID, CASE WHEN presetbilltype.FNumber IS NULL THEN billtype.FNumber ELSE presetbilltype.FNumber END AS FRecPayBillTypeNumber,");
            paySql.append(" bill.FCompanyID, bill.fpayeetypeid FASSTACTTYPEID, bill.fpayeeid FASSTACTID,");
            paySql.append(" bill.fcurrencyid FCURRENCYID, bill.FPersonID FPERSONID, bill.FAdminOrgUnitID FADMINORGUNITID,");
            paySql.append(" 0, billentry.FAmount, billentry.FLocalAmount");
            paySql.append(" FROM T_CAS_PAYMENTBILL bill");
            paySql.append(" INNER JOIN T_CAS_PAYMENTBILLENTRY BILLENTRY ON bill.fid = billentry.fpaymentbillid");
            paySql.append(" INNER JOIN T_CAS_PAYMENTBILLTYPE billtype ON bill.FPayBillTypeID = billtype.FID");
            paySql.append(" LEFT JOIN T_CAS_PAYMENTBILLTYPE presetbilltype ON billtype.FPreSetBillTypeID = presetbilltype.FID");
            paySql.append(" WHERE bill.fsourcetype = 101 and bill.FBillStatus = 15");
            if (!param.isCash()) {
                paySql.append(" and bill.FPaymentTypeID='").append("2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5").append("'").append(RT);
            }
            paySql.append(" and bill.fbizdate>={").append(beginDate).append("}");
            paySql.append(" and bill.fbizdate<{").append(endDate).append("}");
            paySql.append(" and bill.FCompanyID='").append(companyID).append("'");
            paySql.append(" UNION ALL");
            paySql.append(" SELECT bill.FID, CASE WHEN presetbilltype.FNumber IS NULL THEN billtype.FNumber ELSE presetbilltype.FNumber END AS FRecPayBillTypeNumber,");
            paySql.append(" bill.FCompanyID, bill.FAsstActTypeID_SourceBill FASSTACTTYPEID, bill.FAsstActID_SourceBill FASSTACTID,");
            paySql.append(" bill.fcurrencyid FCURRENCYID, bill.FPersonID_SourceBill FPERSONID, bill.FAdminOrgUnitId_SourceBill FADMINORGUNITID,");
            paySql.append(" 1, billentry.FAmount, billentry.FLocalAmount");
            paySql.append(" FROM T_CAS_PAYMENTBILL bill");
            paySql.append(" INNER JOIN T_CAS_PAYMENTBILLENTRY BILLENTRY ON bill.fid = billentry.fpaymentbillid");
            paySql.append(" INNER JOIN T_CAS_PAYMENTBILLTYPE billtype ON bill.FPayBillTypeID = billtype.FID");
            paySql.append(" LEFT JOIN T_CAS_PAYMENTBILLTYPE presetbilltype ON billtype.FPreSetBillTypeID = presetbilltype.FID");
            paySql.append(" WHERE bill.fsourcetype = 101 AND bill.fistransbill = 1");
            paySql.append(" AND bill.FIsTransOtherBill = 0 and bill.FBillStatus = 15");
            if (!param.isCash()) {
                paySql.append(" and bill.FPaymentTypeID='").append("2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5").append("'").append(RT);
            }
            paySql.append(" and bill.fbizdate>={").append(beginDate).append("}");
            paySql.append(" and bill.fbizdate<{").append(endDate).append("}");
            paySql.append(" and bill.FCompanyID='").append(companyID).append("'");
            paySql.append(" UNION ALL");
            paySql.append(" SELECT billentry.FBillID, CASE WHEN presetbilltype.FNumber IS NULL THEN billtype.FNumber ELSE presetbilltype.FNumber END AS FRecPayBillTypeNumber,");
            paySql.append(" bill.FCompanyID, billentry.facctcusstypeid FASSTACTTYPEID,");
            paySql.append(" billentry.facctcussid FASSTACTID, billentry.fcurrencyid FCURRENCYID, billentry.fpersonid FPERSONID, billentry.fadminorgunitid FADMINORGUNITID,");
            paySql.append(" 2, billentry.fthisverificateamt FAMOUNT, billentry.fthisverificateamtloc FAMOUNTLOCAL");
            paySql.append(" FROM t_ap_verificationbill BILL");
            paySql.append(" INNER JOIN t_ap_verificationbillentry BILLENTRY ON bill.fid = billentry.fparentid");
            paySql.append(" INNER JOIN T_CAS_PAYMENTBILLTYPE billtype ON billentry.FVeriRecPayTypeID = billtype.FID");
            paySql.append(" LEFT JOIN T_CAS_PAYMENTBILLTYPE presetbilltype ON billtype.FPreSetBillTypeID = presetbilltype.FID");
            paySql.append(" WHERE (bill.fverificationtype IN (211, 204, 212, 210, 207)");
            paySql.append(" OR (bill.fverificationtype = 201 AND bill.FIsSameCurrency = 0))");
            paySql.append(" AND billentry.fbilltype = 4");
            paySql.append(" AND bill.Fiscashsalepur != 1");
            paySql.append(" and bill.fbizdate>={").append(beginDate).append("}");
            paySql.append(" and bill.fbizdate<{").append(endDate).append("}");
            paySql.append(" and bill.FCompanyID='").append(companyID).append("'");
            paySql.append(" UNION ALL");
            paySql.append(" SELECT billentry.FBillID, CASE WHEN presetbilltype.FNumber IS NULL THEN billtype.FNumber ELSE presetbilltype.FNumber END AS FRecPayBillTypeNumber,");
            paySql.append(" bill.FCompanyID, billentry.facctcusstypeid FASSTACTTYPEID,");
            paySql.append(" billentry.facctcussid FASSTACTID, billentry.fcurrencyid FCURRENCYID, billentry.fpersonid FPERSONID, billentry.fadminorgunitid FADMINORGUNITID,");
            paySql.append(" 3, billentry.fthisverificateamt FAMOUNT, billentry.fthisverificateamtloc FAMOUNTLOCAL");
            paySql.append(" FROM t_ar_verificationbill BILL");
            paySql.append(" INNER JOIN t_ar_verificationbillentry BILLENTRY ON bill.fid = billentry.fparentid");
            paySql.append(" INNER JOIN T_CAS_PAYMENTBILLTYPE billtype ON billentry.FVeriRecPayTypeID = billtype.FID");
            paySql.append(" LEFT JOIN T_CAS_PAYMENTBILLTYPE presetbilltype ON billtype.FPreSetBillTypeID = presetbilltype.FID");
            paySql.append(" WHERE bill.fverificationtype IN (113, 104, 114, 110)");
            paySql.append(" AND billentry.fbilltype = 4");
            paySql.append(" AND bill.Fiscashsalepur != 1");
            paySql.append(" and bill.fbizdate>={").append(beginDate).append("}");
            paySql.append(" and bill.fbizdate<{").append(endDate).append("}");
            paySql.append(" and bill.FCompanyID='").append(companyID).append("'");
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = CommonServerUtils.getConnection(ctx);
                TempTablePool tmpTblPool = TempTablePool.getInstance((Context)ctx);
                try {
                    tmpTblPool.createIndex(recpayTempTable, "FBillID, FAsstActID, FAdminOrgUnitID, FPersonID", false, false);
                    tmpTblPool.analyzeTable(conn, recpayTempTable);
                }
                catch (Exception e2) {
                    e2.printStackTrace(System.out);
                }
                pstmt = conn.prepareStatement(paySql.toString());
                pstmt.execute();
                pstmt.close();
                pstmt = conn.prepareStatement("UPDATE " + recpayTempTable + " SET FRecPayBillTypeNumber = ? WHERE FRecPayBillTypeNumber = ?");
                pstmt.setString(1, "201");
                pstmt.setString(2, "203");
                pstmt.addBatch();
                pstmt.setString(1, "202");
                pstmt.setString(2, "204");
                pstmt.addBatch();
                pstmt.setString(1, "205");
                pstmt.setString(2, "206");
                pstmt.addBatch();
                pstmt.executeBatch();
                pstmt.close();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            buffer.append(" SELECT FCompanyID, FASSTACTTYPEID,");
            buffer.append(" FASSTACTID, FCURRENCYID, FPERSONID, FADMINORGUNITID, NULL,");
            buffer.append(" CASE WHEN SUM(FAmount) < 0 THEN 0 ELSE SUM(FAmount) END FDAMOUNT,");
            buffer.append(" CASE WHEN SUM(FAmount) < 0 THEN 0 ELSE SUM(FAmountLocal) END FDAMOUNTLOCAL,");
            buffer.append(" CASE WHEN SUM(FAmount) < 0 THEN -1*SUM(FAmount) ELSE 0 END FCAMOUNT,");
            buffer.append(" CASE WHEN SUM(FAmount) < 0 THEN -1*SUM(FAmountLocal) ELSE 0 END FCAMOUNTLOCAL");
            buffer.append(" FROM ").append(recpayTempTable);
            buffer.append(" WHERE FBillType = 0");
            buffer.append(" GROUP BY FBillID, FRecPayBillTypeNumber, FCompanyID, FASSTACTTYPEID, FASSTACTID, FCURRENCYID, FPERSONID, FADMINORGUNITID");
            buffer.append(" UNION ALL");
            buffer.append(" SELECT FCompanyID, FASSTACTTYPEID,");
            buffer.append(" FASSTACTID, FCURRENCYID, FPERSONID, FADMINORGUNITID, NULL,");
            buffer.append(" CASE WHEN SUM(FAmount) < 0 THEN -1*SUM(FAmount) ELSE 0 END FDAMOUNT,");
            buffer.append(" CASE WHEN SUM(FAmount) < 0 THEN -1*SUM(FAmountLocal) ELSE 0 END FDAMOUNTLOCAL,");
            buffer.append(" CASE WHEN SUM(FAmount) < 0 THEN 0 ELSE SUM(FAmount) END FCAMOUNT,");
            buffer.append(" CASE WHEN SUM(FAmount) < 0 THEN 0 ELSE SUM(FAmountLocal) END FCAMOUNTLOCAL");
            buffer.append(" FROM ").append(recpayTempTable);
            buffer.append(" WHERE FBillType IN (1, 2, 3)");
            buffer.append(" GROUP BY FBillID, FRecPayBillTypeNumber, FCompanyID, FASSTACTTYPEID, FASSTACTID, FCURRENCYID, FPERSONID, FADMINORGUNITID");
            buffer.append(" UNION ALL");
        }
        if (ApServerUtils.isPrePayAcct(ctx, companyID)) {
            buffer.append(" SELECT bill.FCompanyID, billentry.facctcusstypeid FASSTACTTYPEID,");
            buffer.append(" billentry.facctcussid FASSTACTID, billentry.fcurrencyid FCURRENCYID, billentry.fpersonid FPERSONID, billentry.fadminorgunitid FADMINORGUNITID,");
            buffer.append(" billentry.FAccountID FACCOUNTID,");
            buffer.append(" billentry.fthisverificateamt FDAMOUNT,");
            buffer.append(" billentry.fthisverificateamtloc FDAMOUNTLOCAL,");
            buffer.append(" billentry.fthisverificateamt FCAMOUNT,");
            buffer.append(" billentry.fthisverificateamtloc FCAMOUNTLOCAL");
            buffer.append(" FROM t_ap_verificationbill BILL");
            buffer.append(" INNER JOIN t_ap_verificationbillentry BILLENTRY ON bill.fid = billentry.fparentid");
            buffer.append(" WHERE bill.fverificationtype = 201");
            buffer.append(" AND billentry.fbillsubtype IN (202, 204) ");
            buffer.append(" AND bill.Fiscashsalepur != 1");
            buffer.append(" and bill.fbizdate>={").append(beginDate).append("}");
            buffer.append(" and bill.fbizdate<{").append(endDate).append("}");
            buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
            buffer.append(" UNION ALL");
        }
        buffer.append(" SELECT bill.FCompanyID, billentry.facctcusstypeid FASSTACTTYPEID,");
        buffer.append(" billentry.facctcussid FASSTACTID, billentry.fcurrencyid FCURRENCYID, billentry.fpersonid FPERSONID, billentry.fadminorgunitid FADMINORGUNITID,");
        buffer.append(" billentry.FAccountID FACCOUNTID,");
        buffer.append(" billentry.fthisverificateamt FDAMOUNT,");
        buffer.append(" billentry.fthisverificateamtloc FDAMOUNTLOCAL,");
        buffer.append(" 0 FCAMOUNT,");
        buffer.append(" 0 FCAMOUNTLOCAL");
        buffer.append(" FROM t_ap_verificationbill BILL");
        buffer.append(" INNER JOIN t_ap_verificationbillentry BILLENTRY ON bill.fid = billentry.fparentid");
        buffer.append(" WHERE (bill.fverificationtype IN (203, 207, 209)");
        buffer.append(" OR (bill.fverificationtype = 201 AND bill.FIsSameCurrency = 0))");
        buffer.append(" AND billentry.fbilltype = 9");
        buffer.append(" AND bill.Fiscashsalepur != 1");
        buffer.append(" and bill.fbizdate>={").append(beginDate).append("}");
        buffer.append(" and bill.fbizdate<{").append(endDate).append("}");
        buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
        buffer.append(" UNION ALL");
        buffer.append(" SELECT bill.FCompanyID, billentry.facctcusstypeid FASSTACTTYPEID,");
        buffer.append(" billentry.facctcussid FASSTACTID, billentry.fcurrencyid FCURRENCYID, billentry.fpersonid FPERSONID, billentry.fadminorgunitid FADMINORGUNITID,");
        buffer.append(" billentry.FAccountID FACCOUNTID,");
        buffer.append(" billentry.fthisverificateamt FDAMOUNT,");
        buffer.append(" billentry.fthisverificateamtloc FDAMOUNTLOCAL,");
        buffer.append(" 0 FCAMOUNT,");
        buffer.append(" 0 FCAMOUNTLOCAL");
        buffer.append(" FROM t_ar_verificationbill BILL");
        buffer.append(" INNER JOIN t_ar_verificationbillentry BILLENTRY ON bill.fid = billentry.fparentid");
        buffer.append(" WHERE bill.fverificationtype IN (103, 109)");
        buffer.append(" AND billentry.fbilltype = 9");
        buffer.append(" and bill.fbizdate>={").append(beginDate).append("}");
        buffer.append(" and bill.fbizdate<{").append(endDate).append("}");
        buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
        buffer.append(" UNION ALL");
        buffer.append(" SELECT bill.FCompanyID, bill.fasstacttypeid FASSTACTTYPEID,");
        buffer.append(" bill.fasstactid FASSTACTID, bill.fcurrencyid FCURRENCYID, bill.FPersonID FPERSONID, bill.FAdminOrgUnitID FADMINORGUNITID,");
        buffer.append(" billentry.FAccountID FACCOUNTID,");
        buffer.append(" ReceivingBillEntry.FAmount FDAMOUNT, ReceivingBillEntry.FLocalAmount FDAMOUNTLOCAL,");
        buffer.append(" 0 FCAMOUNT, 0 FCAMOUNTLOCAL");
        buffer.append(" FROM T_AP_OTHERBILL BILL");
        buffer.append(" INNER JOIN T_AP_OTHERBILLENTRY BILLENTRY ON bill.fid = billentry.fparentid");
        buffer.append(" INNER JOIN T_CAS_RECEIVINGBILLENTRY ReceivingBillEntry ON billentry.fid = ReceivingBillEntry.FSourceBillEntryID");
        buffer.append(" INNER JOIN T_CAS_RECEIVINGBILL ReceivingBill ON ReceivingBillEntry.FReceivingBillID = ReceivingBill.fid");
        buffer.append(" WHERE ReceivingBill.fsourcetype = 100 and ReceivingBill.FBillStatus = 14");
        buffer.append(" AND ReceivingBill.fistransbill = 1 AND ReceivingBill.FIsTransOtherBill = 1");
        buffer.append(" and ReceivingBill.fbizdate>={").append(beginDate).append("}");
        buffer.append(" and ReceivingBill.fbizdate<{").append(endDate).append("}");
        buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
        buffer.append(" UNION ALL");
        buffer.append(" SELECT bill.FCompanyID, bill.FPayeeTypeID FASSTACTTYPEID,");
        buffer.append(" bill.FPayeeID FASSTACTID, bill.fcurrencyid FCURRENCYID, bill.FPersonID FPERSONID, bill.FAdminOrgUnitID FADMINORGUNITID,");
        buffer.append(" bill.FOppAccountID FACCOUNTID,");
        buffer.append(" 0 FDAMOUNT, 0 FDAMOUNTLOCAL,");
        buffer.append(" sourceEntry.FRecievePayAmount FCAMOUNT, sourceEntry.FRecievePayAmountLocal FCAMOUNTLOCAL");
        buffer.append(" FROM T_CAS_PaymentBillEntry billEntry ");
        buffer.append(" INNER JOIN T_CAS_PaymentBill bill on bill.FID = billEntry.FPaymentBillID ");
        buffer.append(" INNER JOIN t_ar_otherbillentry sourceEntry on sourceEntry.FSourceBillEntryID = billEntry.FID ");
        buffer.append(" INNER JOIN T_Ar_OtherBill sourceBill on sourceBill.FID = sourceEntry.FParentID ");
        buffer.append(" WHERE sourceBill.FBillStatus = 3 and sourceBill.FIsTransOtherBill = 1 ");
        if (!param.isIncludeBizBill()) {
            buffer.append(" AND sourceBill.FIsBizBill = 0");
        }
        if (!param.isCash()) {
            buffer.append(" and sourceBill.FPaymentTypeID='").append("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5").append("'").append(RT);
        }
        buffer.append(" and sourceBill.fbilldate>={").append(beginDate).append("}");
        buffer.append(" and sourceBill.fbilldate<{").append(endDate).append("}");
        buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
        return buffer.toString();
    }

    private static String builderBillDataSQL(Context ctx, String resultTempTable, String tempTable, boolean fAR) throws BOSException, EASBizException {
        StringBuffer buffer = new StringBuffer("");
        buffer.append("insert into ").append(resultTempTable);
        buffer.append(" select ");
        buffer.append(" FCompanyID");
        buffer.append(" ,FAsstActTypeID");
        buffer.append(" ,FAsstActID");
        buffer.append(" ,FCurrencyID");
        buffer.append(" ,FPersonID");
        buffer.append(" ,FAdminOrgUnitID");
        buffer.append(" ,FAccountID");
        buffer.append(" ,sum(FRECEIVING) FTotalDebitAmount ");
        buffer.append(" ,sum(FACTUAL) FTotalCreditAmount ");
        buffer.append(" ,sum(FRECEIVINGLOCAL) FTotalDebitAmountLoc ");
        buffer.append(" ,sum(FACTUALLOCAL) FTotalCreditAmountLoc ");
        buffer.append(" from (select FCompanyID,FAsstActTypeID,FAsstActID,FCurrencyID");
        buffer.append(" ,CASE ISNULL(RTRIM(LTRIM(FPersonID)),'z') WHEN 'z' THEN 'z' WHEN '' THEN 'z' ELSE FPersonID END AS FPersonID ");
        buffer.append(" ,CASE ISNULL(RTRIM(LTRIM(FAdminOrgUnitID)),'z') WHEN 'z' THEN 'z' WHEN '' THEN 'z' ELSE FAdminOrgUnitID END AS FAdminOrgUnitID, ");
        buffer.append(" FAccountID,FRECEIVING,FACTUAL,FRECEIVINGLOCAL,FACTUALLOCAL ");
        buffer.append(" from ").append(tempTable);
        buffer.append(") AS TEMP group by FCompanyID,FAsstActTypeID,FAsstActID,FCurrencyID,FPersonID,FAdminOrgUnitID,FAccountID");
        return buffer.toString();
    }

    private static String updateBillSQL(int balType, String tableName, String resultTableName) {
        StringBuffer insertTable = new StringBuffer("");
        insertTable.append("insert into ").append(resultTableName);
        insertTable.append(" (FBalType, FCompanyID, FAsstActTypeID, FAsstActID,");
        insertTable.append(" FCurrencyID, FPersonID, FAdminOrgUnitID, FAccount,");
        insertTable.append(" FBeginBalanceFor,FDebitFor,FCreditFor,FYearDebitFor, FYearCreditFor,");
        insertTable.append(" FEndBalanceFor,FBeginBalanceLocal,FDebitLocal,FCreditLocal,FYearDebitLocal,FYearCreditLocal,FEndBalanceLocal");
        insertTable.append(" ) \r\n");
        insertTable.append(" select ").append(" FBalType").append(", FCompanyID").append(", FAsstActTypeID").append(", FAsstActID").append(", FCurrencyID").append(", FPersonID").append(", FAdminOrgUnitID").append(", FAccount,").append(" SUM(FBeginBalanceFor), SUM(FDebitFor), SUM(FCreditFor), SUM(FYearDebitFor), SUM(FYearCreditFor),").append(" SUM(FEndBalanceFor), SUM(FBeginBalanceLocal), SUM(FDebitLocal), SUM(FCreditLocal), SUM(FYearDebitLocal), SUM(FYearCreditLocal), SUM(FEndBalanceLocal)");
        insertTable.append(" from ").append(tableName);
        insertTable.append(" WHERE FBalType = ").append(balType);
        insertTable.append(" GROUP BY FBalType, FCompanyID, FAsstActTypeID, FAsstActID, FCurrencyID, FPersonID, FAdminOrgUnitID, FAccount");
        return insertTable.toString();
    }

    private static String insertBillSQL(int balType, String tempTable, String tableName) {
        StringBuffer insertTable = new StringBuffer("");
        insertTable.append("insert into ").append(tableName);
        insertTable.append(" (FBalType, FCompanyID, FAsstActTypeID,");
        insertTable.append(" FAsstActID, FCurrencyID, FPersonID, FAdminOrgUnitID, FAccount,");
        insertTable.append(" FBeginBalanceFor,FDebitFor,FCreditFor,FYearDebitFor, FYearCreditFor,");
        insertTable.append(" FEndBalanceFor,FBeginBalanceLocal,FDebitLocal,FCreditLocal,FYearDebitLocal,FYearCreditLocal,FEndBalanceLocal");
        insertTable.append(" ) \r\n");
        insertTable.append(" select ").append(balType).append(" as FBalType").append(",tmpBalance.FCompanyID as FCompanyID ").append(",tmpBalance.FAsstActTypeID as FAsstActTypeID ").append(",tmpBalance.FAsstActID as FAsstActID ").append(",tmpBalance.FCurrencyID as FCurrencyID").append(",tmpBalance.FPersonID as FPersonID,").append(" tmpBalance.FAdminOrgUnitID as FAdminOrgUnitID,").append(" tmpBalance.FAccountID as FAccountID,").append(" 0.0, tmpBalance.FRECEIVING, tmpBalance.FACTUAL, tmpBalance.FRECEIVING, tmpBalance.FACTUAL,").append(" 0.0, 0.0, tmpBalance.FRECEIVINGLOCAL, tmpBalance.FACTUALLOCAL, tmpBalance.FRECEIVINGLOCAL, tmpBalance.FACTUALLOCAL, 0.0");
        insertTable.append(" from ").append(tempTable).append(" tmpBalance ");
        return insertTable.toString();
    }

    private static String recpayTempTableDefine() {
        StringBuffer sb = new StringBuffer("");
        sb.append("(FBillID VARCHAR(44), FRecPayBillTypeNumber NVARCHAR(80), FCompanyID VARCHAR(44), FAsstActTypeID VARCHAR(44),");
        sb.append(" FAsstActID VARCHAR(44), FCurrencyID VARCHAR(44), FPersonID VARCHAR(44), FAdminOrgUnitID VARCHAR(44),");
        sb.append(" FBillType INT, FAmount DECIMAL(28, 10) DEFAULT 0.0, FAmountLocal DECIMAL(28, 10) DEFAULT 0.0)");
        return sb.toString();
    }

    private static String insertARBillDataSQL(Context ctx, String tempTable, String beginDate, String endDate, String companyID, ContrastGLQueryParam param) throws BOSException, EASBizException {
        StringBuffer buffer;
        block15: {
            block14: {
                buffer = new StringBuffer("");
                buffer.append(SQL_INSERT).append(tempTable);
                buffer.append("(FCompanyID, FASSTACTTYPEID, FASSTACTID, FCURRENCYID, FPersonID, FAdminOrgUnitID, FACCOUNTID,");
                buffer.append("FRECEIVING, FRECEIVINGLOCAL, FACTUAL, FACTUALLOCAL)");
                buffer.append(" SELECT bill.FCompanyID, bill.fasstacttypeid FASSTACTTYPEID,");
                buffer.append(" bill.fasstactid FASSTACTID, bill.fcurrencyid FCURRENCYID, bill.FPersonID FPERSONID, bill.FAdminOrgUnitID FADMINORGUNITID,");
                buffer.append(" billentry.FAccountID FACCOUNTID,");
                buffer.append(" billentry.FRecievePayAmount FDAMOUNT, billentry.FRecievePayAmountLocal FDAMOUNTLOCAL,");
                buffer.append(" 0 FCAMOUNT, 0 FCAMOUNTLOCAL");
                buffer.append(" FROM t_ar_otherbill BILL");
                buffer.append(" INNER JOIN t_ar_otherbillentry BILLENTRY ON bill.fid = billentry.fparentid");
                buffer.append(" WHERE bill.FBillStatus = 3");
                if (!param.isIncludeBizBill()) {
                    buffer.append(" AND bill.FIsBizBill = 0");
                }
                if (!param.isCash()) {
                    buffer.append(" and bill.FPaymentTypeID='").append("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5").append("'").append(RT);
                }
                buffer.append(" and bill.fbilldate>={").append(beginDate).append("}");
                buffer.append(" and bill.fbilldate<{").append(endDate).append("}");
                buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
                buffer.append(" UNION ALL");
                buffer.append(" SELECT bill.FCompanyID, bill.FAsstActTypeID_SourceBill FASSTACTTYPEID,");
                buffer.append(" bill.FAsstActID_SourceBill FASSTACTID, bill.fcurrencyid FCURRENCYID, bill.FPersonID_SourceBill FPERSONID, bill.FAdminOrgUnitId_SourceBill FADMINORGUNITID,");
                buffer.append(" billentry.FAccountID FACCOUNTID,");
                buffer.append(" 0 FDAMOUNT, 0 FDAMOUNTLOCAL,");
                buffer.append(" billentry.FRecievePayAmount FCAMOUNT, billentry.FRecievePayAmountLocal FCAMOUNTLOCAL");
                buffer.append(" FROM t_ar_otherbill BILL");
                buffer.append(" INNER JOIN t_ar_otherbillentry BILLENTRY ON bill.fid = billentry.fparentid");
                buffer.append(" WHERE bill.fistransbill = 1 and bill.FBillStatus = 3");
                buffer.append(" and bill.fIsTransOtherBill <> 1");
                buffer.append(" and bill.fbilldate>={").append(beginDate).append("}");
                buffer.append(" and bill.fbilldate<{").append(endDate).append("}");
                buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
                buffer.append(" UNION ALL");
                if (!param.isRedRecNegative()) break block14;
                buffer.append(" SELECT bill.FCompanyID, bill.fpayertypeid FASSTACTTYPEID,");
                buffer.append(" bill.fpayerid FASSTACTID, bill.fcurrencyid FCURRENCYID, bill.FPersonID FPERSONID, bill.FAdminOrgUnitID FADMINORGUNITID,");
                buffer.append(" billentry.FOppAccountID FACCOUNTID,");
                buffer.append(" 0 FDAMOUNT, 0 FDAMOUNTLOCAL,");
                buffer.append(" billentry.FAmount FCAMOUNT, billentry.FLocalAmount FCAMOUNTLOCAL");
                buffer.append(" FROM T_CAS_RECEIVINGBILL BILL");
                buffer.append(" INNER JOIN T_CAS_RECEIVINGBILLENTRY BILLENTRY ON bill.fid = billentry.freceivingbillid");
                buffer.append(" WHERE bill.fsourcetype = 100 and bill.FBillStatus = 14");
                if (!param.isCash()) {
                    buffer.append(" and bill.FPaymentTypeID='").append("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5").append("'").append(RT);
                }
                buffer.append(" and bill.fbizdate>={").append(beginDate).append("}");
                buffer.append(" and bill.fbizdate<{").append(endDate).append("}");
                buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
                buffer.append(" UNION ALL");
                buffer.append(" SELECT bill.FCompanyID, bill.FAsstActTypeID_SourceBill FASSTACTTYPEID,");
                buffer.append(" bill.FAsstActID_SourceBill FASSTACTID, bill.fcurrencyid FCURRENCYID, bill.FPersonID_SourceBill FPERSONID, bill.FAdminOrgUnitId_SourceBill FADMINORGUNITID,");
                buffer.append(" billentry.FOppAccountID FACCOUNTID,");
                buffer.append(" billentry.FAmount FDAMOUNT, billentry.FLocalAmount FDAMOUNTLOCAL,");
                buffer.append(" 0 FCAMOUNT, 0 FCAMOUNTLOCAL");
                buffer.append(" FROM T_CAS_RECEIVINGBILL BILL");
                buffer.append(" INNER JOIN T_CAS_RECEIVINGBILLENTRY BILLENTRY ON bill.fid = billentry.freceivingbillid");
                buffer.append(" WHERE bill.fsourcetype = 100 AND bill.fistransbill = 1");
                buffer.append(" AND bill.FIsTransOtherBill = 0 and bill.FBillStatus = 14");
                buffer.append(" and bill.fbizdate>={").append(beginDate).append("}");
                buffer.append(" and bill.fbizdate<{").append(endDate).append("}");
                buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
                buffer.append(" UNION ALL");
                buffer.append(" SELECT bill.FCompanyID, billentry.facctcusstypeid FASSTACTTYPEID,");
                buffer.append(" billentry.facctcussid FASSTACTID, billentry.fcurrencyid FCURRENCYID, billentry.fpersonid FPERSONID, billentry.fadminorgunitid FADMINORGUNITID,");
                buffer.append(" billentry.FAccountID FACCOUNTID,");
                buffer.append(" billentry.fthisverificateamt FDAMOUNT, billentry.fthisverificateamtloc FDAMOUNTLOCAL,");
                buffer.append(" 0 FCAMOUNT, 0 FCAMOUNTLOCAL");
                buffer.append(" FROM t_ar_verificationbill BILL");
                buffer.append(" INNER JOIN t_ar_verificationbillentry BILLENTRY ON bill.fid = billentry.fparentid");
                buffer.append(" WHERE (bill.fverificationtype IN (113, 104, 114, 110, 107)");
                buffer.append(" OR (bill.fverificationtype = 101 AND bill.FIsSameCurrency = 0))");
                buffer.append(" AND billentry.fbilltype = 6");
                buffer.append(" and bill.Fiscashsalepur !=1").append(RT);
                buffer.append(" and bill.fbizdate>={").append(beginDate).append("}");
                buffer.append(" and bill.fbizdate<{").append(endDate).append("}");
                buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
                buffer.append(" UNION ALL");
                buffer.append(" SELECT bill.FCompanyID, billentry.facctcusstypeid FASSTACTTYPEID,");
                buffer.append(" billentry.facctcussid FASSTACTID, billentry.fcurrencyid FCURRENCYID, billentry.fpersonid FPERSONID, billentry.fadminorgunitid FADMINORGUNITID,");
                buffer.append(" billentry.FAccountID FACCOUNTID,");
                buffer.append(" billentry.fthisverificateamt FDAMOUNT, billentry.fthisverificateamtloc FDAMOUNTLOCAL,");
                buffer.append(" 0 FCAMOUNT, 0 FCAMOUNTLOCAL");
                buffer.append(" FROM t_ap_verificationbill BILL");
                buffer.append(" INNER JOIN t_ap_verificationbillentry BILLENTRY ON bill.fid = billentry.fparentid");
                buffer.append(" WHERE bill.fverificationtype IN (211, 204, 212, 210)");
                buffer.append(" AND billentry.fbilltype = 6");
                buffer.append(" and bill.fbizdate>={").append(beginDate).append("}");
                buffer.append(" and bill.fbizdate<{").append(endDate).append("}");
                buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
                buffer.append(" UNION ALL");
                break block15;
            }
            String recpayTempTable = TempTableUtil.createTempTable(ctx, CommonServerUtils.recpayTempTableDefine());
            StringBuffer recSql = new StringBuffer("");
            recSql.append(SQL_INSERT).append(recpayTempTable);
            recSql.append(" SELECT bill.FID, CASE WHEN presetbilltype.FNumber IS NULL THEN billtype.FNumber ELSE presetbilltype.FNumber END AS FRecPayBillTypeNumber,");
            recSql.append(" bill.FCompanyID, bill.fpayertypeid FASSTACTTYPEID, bill.fpayerid FASSTACTID,");
            recSql.append(" bill.fcurrencyid FCURRENCYID, bill.FPersonID FPERSONID, bill.FAdminOrgUnitID FADMINORGUNITID,");
            recSql.append(" 0, billentry.FAmount, billentry.FLocalAmount");
            recSql.append(" FROM T_CAS_RECEIVINGBILL bill");
            recSql.append(" INNER JOIN T_CAS_RECEIVINGBILLENTRY billentry ON bill.fid = billentry.freceivingbillid");
            recSql.append(" INNER JOIN T_CAS_RECEIVINGBILLTYPE billtype ON billentry.FRecBillTypeID = billtype.FID");
            recSql.append(" LEFT JOIN T_CAS_RECEIVINGBILLTYPE presetbilltype ON billtype.FPreSetBillTypeID = presetbilltype.FID");
            recSql.append(" WHERE bill.fsourcetype = 100 and bill.FBillStatus = 14");
            if (!param.isCash()) {
                recSql.append(" and bill.FPaymentTypeID='").append("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5").append("'").append(RT);
            }
            recSql.append(" and bill.fbizdate>={").append(beginDate).append("}");
            recSql.append(" and bill.fbizdate<{").append(endDate).append("}");
            recSql.append(" and bill.FCompanyID='").append(companyID).append("'");
            recSql.append(" UNION ALL");
            recSql.append(" SELECT bill.FID, CASE WHEN presetbilltype.FNumber IS NULL THEN billtype.FNumber ELSE presetbilltype.FNumber END AS FRecPayBillTypeNumber,");
            recSql.append(" bill.FCompanyID, bill.FAsstActTypeID_SourceBill FASSTACTTYPEID, bill.FAsstActID_SourceBill FASSTACTID,");
            recSql.append(" bill.fcurrencyid FCURRENCYID, bill.FPersonID_SourceBill FPERSONID, bill.FAdminOrgUnitId_SourceBill FADMINORGUNITID,");
            recSql.append(" 1, billentry.FAmount, billentry.FLocalAmount");
            recSql.append(" FROM T_CAS_RECEIVINGBILL bill");
            recSql.append(" INNER JOIN T_CAS_RECEIVINGBILLENTRY billentry ON bill.fid = billentry.freceivingbillid");
            recSql.append(" INNER JOIN T_CAS_RECEIVINGBILLTYPE billtype ON billentry.FRecBillTypeID = billtype.FID");
            recSql.append(" LEFT JOIN T_CAS_RECEIVINGBILLTYPE presetbilltype ON billtype.FPreSetBillTypeID = presetbilltype.FID");
            recSql.append(" WHERE bill.fsourcetype = 100 AND bill.fistransbill = 1");
            if (!param.isCash()) {
                recSql.append(" and bill.FPaymentTypeID='").append("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5").append("'").append(RT);
            }
            recSql.append(" AND bill.FIsTransOtherBill = 0 and bill.FBillStatus = 14");
            recSql.append(" and bill.fbizdate>={").append(beginDate).append("}");
            recSql.append(" and bill.fbizdate<{").append(endDate).append("}");
            recSql.append(" and bill.FCompanyID='").append(companyID).append("'");
            recSql.append(" UNION ALL");
            recSql.append(" SELECT billentry.FBillID, CASE WHEN presetbilltype.FNumber IS NULL THEN billtype.FNumber ELSE presetbilltype.FNumber END AS FRecPayBillTypeNumber,");
            recSql.append(" bill.FCompanyID, billentry.facctcusstypeid FASSTACTTYPEID,");
            recSql.append(" billentry.facctcussid FASSTACTID, billentry.fcurrencyid FCURRENCYID, billentry.fpersonid FPERSONID, billentry.fadminorgunitid FADMINORGUNITID,");
            recSql.append(" 2, billentry.fthisverificateamt FAMOUNT, billentry.fthisverificateamtloc FAMOUNTLOCAL");
            recSql.append(" FROM t_ar_verificationbill BILL");
            recSql.append(" INNER JOIN t_ar_verificationbillentry BILLENTRY ON bill.fid = billentry.fparentid");
            recSql.append(" INNER JOIN T_CAS_RECEIVINGBILLTYPE billtype ON billentry.FVeriRecPayTypeID = billtype.FID");
            recSql.append(" LEFT JOIN T_CAS_RECEIVINGBILLTYPE presetbilltype ON billtype.FPreSetBillTypeID = presetbilltype.FID");
            recSql.append(" WHERE (bill.fverificationtype IN (113, 104, 114, 110, 107)");
            recSql.append(" OR (bill.fverificationtype = 101 AND bill.FIsSameCurrency = 0))");
            recSql.append(" AND billentry.fbilltype = 6");
            recSql.append(" and bill.Fiscashsalepur !=1").append(RT);
            recSql.append(" and bill.fbizdate>={").append(beginDate).append("}");
            recSql.append(" and bill.fbizdate<{").append(endDate).append("}");
            recSql.append(" and bill.FCompanyID='").append(companyID).append("'");
            recSql.append(" UNION ALL");
            recSql.append(" SELECT billentry.FBillID, CASE WHEN presetbilltype.FNumber IS NULL THEN billtype.FNumber ELSE presetbilltype.FNumber END AS FRecPayBillTypeNumber,");
            recSql.append(" bill.FCompanyID, billentry.facctcusstypeid FASSTACTTYPEID,");
            recSql.append(" billentry.facctcussid FASSTACTID, billentry.fcurrencyid FCURRENCYID, billentry.fpersonid FPERSONID, billentry.fadminorgunitid FADMINORGUNITID,");
            recSql.append(" 3, billentry.fthisverificateamt FAMOUNT, billentry.fthisverificateamtloc FAMOUNTLOCAL");
            recSql.append(" FROM t_ap_verificationbill BILL");
            recSql.append(" INNER JOIN t_ap_verificationbillentry BILLENTRY ON bill.fid = billentry.fparentid");
            recSql.append(" INNER JOIN T_CAS_RECEIVINGBILLTYPE billtype ON billentry.FVeriRecPayTypeID = billtype.FID");
            recSql.append(" LEFT JOIN T_CAS_RECEIVINGBILLTYPE presetbilltype ON billtype.FPreSetBillTypeID = presetbilltype.FID");
            recSql.append(" WHERE bill.fverificationtype IN (211, 204, 212, 210)");
            recSql.append(" AND billentry.fbilltype = 6");
            recSql.append(" and bill.fbizdate>={").append(beginDate).append("}");
            recSql.append(" and bill.fbizdate<{").append(endDate).append("}");
            recSql.append(" and bill.FCompanyID='").append(companyID).append("'");
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = CommonServerUtils.getConnection(ctx);
                TempTablePool tmpTblPool = TempTablePool.getInstance((Context)ctx);
                try {
                    tmpTblPool.createIndex(recpayTempTable, "FBillID, FAsstActID, FAdminOrgUnitID, FPersonID", false, false);
                    tmpTblPool.analyzeTable(conn, recpayTempTable);
                }
                catch (Exception e2) {
                    e2.printStackTrace(System.out);
                }
                pstmt = conn.prepareStatement(recSql.toString());
                pstmt.execute();
                pstmt.close();
                pstmt = conn.prepareStatement("UPDATE " + recpayTempTable + " SET FRecPayBillTypeNumber = ? WHERE FRecPayBillTypeNumber = ?");
                pstmt.setString(1, "100");
                pstmt.setString(2, "102");
                pstmt.addBatch();
                pstmt.setString(1, "101");
                pstmt.setString(2, "103");
                pstmt.addBatch();
                pstmt.setString(1, "104");
                pstmt.setString(2, "105");
                pstmt.addBatch();
                pstmt.executeBatch();
                pstmt.close();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            buffer.append(" SELECT FCompanyID, FASSTACTTYPEID,");
            buffer.append(" FASSTACTID, FCURRENCYID, FPERSONID, FADMINORGUNITID, NULL,");
            buffer.append(" CASE WHEN SUM(FAmount) < 0 THEN -1*SUM(FAmount) ELSE 0 END FDAMOUNT,");
            buffer.append(" CASE WHEN SUM(FAmount) < 0 THEN -1*SUM(FAmountLocal) ELSE 0 END FDAMOUNTLOCAL,");
            buffer.append(" CASE WHEN SUM(FAmount) < 0 THEN 0 ELSE SUM(FAmount) END FCAMOUNT,");
            buffer.append(" CASE WHEN SUM(FAmount) < 0 THEN 0 ELSE SUM(FAmountLocal) END FCAMOUNTLOCAL");
            buffer.append(" FROM ").append(recpayTempTable);
            buffer.append(" WHERE FBillType = 0");
            buffer.append(" GROUP BY FBillID, FRecPayBillTypeNumber, FCompanyID, FASSTACTTYPEID, FASSTACTID, FCURRENCYID, FPERSONID, FADMINORGUNITID");
            buffer.append(" UNION ALL");
            buffer.append(" SELECT FCompanyID, FASSTACTTYPEID,");
            buffer.append(" FASSTACTID, FCURRENCYID, FPERSONID, FADMINORGUNITID, NULL,");
            buffer.append(" CASE WHEN SUM(FAmount) < 0 THEN 0 ELSE SUM(FAmount) END FDAMOUNT,");
            buffer.append(" CASE WHEN SUM(FAmount) < 0 THEN 0 ELSE SUM(FAmountLocal) END FDAMOUNTLOCAL,");
            buffer.append(" CASE WHEN SUM(FAmount) < 0 THEN -1*SUM(FAmount) ELSE 0 END FCAMOUNT,");
            buffer.append(" CASE WHEN SUM(FAmount) < 0 THEN -1*SUM(FAmountLocal) ELSE 0 END FCAMOUNTLOCAL");
            buffer.append(" FROM ").append(recpayTempTable);
            buffer.append(" WHERE FBillType IN (1, 2, 3)");
            buffer.append(" GROUP BY FBillID, FRecPayBillTypeNumber, FCompanyID, FASSTACTTYPEID, FASSTACTID, FCURRENCYID, FPERSONID, FADMINORGUNITID");
            buffer.append(" UNION ALL");
        }
        if (ArServerUtils.isPreRecAcct(ctx, companyID)) {
            buffer.append(" SELECT bill.FCompanyID, billentry.facctcusstypeid FASSTACTTYPEID,");
            buffer.append(" billentry.facctcussid FASSTACTID, billentry.fcurrencyid FCURRENCYID, billentry.fpersonid FPERSONID, billentry.fadminorgunitid FADMINORGUNITID,");
            buffer.append(" billentry.FAccountID FACCOUNTID,");
            buffer.append(" billentry.fthisverificateamt FDAMOUNT,");
            buffer.append(" billentry.fthisverificateamtloc FDAMOUNTLOCAL,");
            buffer.append(" billentry.fthisverificateamt FCAMOUNT,");
            buffer.append(" billentry.fthisverificateamtloc FCAMOUNTLOCAL");
            buffer.append(" FROM t_ar_verificationbill BILL");
            buffer.append(" INNER JOIN t_ar_verificationbillentry BILLENTRY ON bill.fid = billentry.fparentid");
            buffer.append(" WHERE bill.fverificationtype = 101");
            buffer.append(" and bill.Fiscashsalepur !=1");
            buffer.append(" AND billentry.fbillsubtype IN (101, 103) ");
            buffer.append(" and bill.fbizdate>={").append(beginDate).append("}");
            buffer.append(" and bill.fbizdate<{").append(endDate).append("}");
            buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
            buffer.append(" UNION ALL");
        }
        buffer.append(" SELECT bill.FCompanyID, billentry.facctcusstypeid FASSTACTTYPEID,");
        buffer.append(" billentry.facctcussid FASSTACTID, billentry.fcurrencyid FCURRENCYID, billentry.fpersonid FPERSONID, billentry.fadminorgunitid FADMINORGUNITID,");
        buffer.append(" billentry.FAccountID FACCOUNTID,");
        buffer.append(" 0 FDAMOUNT,");
        buffer.append(" 0 FDAMOUNTLOCAL,");
        buffer.append(" billentry.fthisverificateamt FCAMOUNT,");
        buffer.append(" billentry.fthisverificateamtloc FCAMOUNTLOCAL");
        buffer.append(" FROM t_ar_verificationbill BILL");
        buffer.append(" INNER JOIN t_ar_verificationbillentry BILLENTRY ON bill.fid = billentry.fparentid");
        buffer.append(" WHERE (bill.fverificationtype IN (103, 107, 109)");
        buffer.append(" OR (bill.fverificationtype = 101 AND bill.FIsSameCurrency = 0))");
        buffer.append(" AND billentry.fbilltype = 8");
        buffer.append(" and bill.Fiscashsalepur !=1");
        buffer.append(" and bill.fbizdate>={").append(beginDate).append("}");
        buffer.append(" and bill.fbizdate<{").append(endDate).append("}");
        buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
        buffer.append(" UNION ALL");
        buffer.append(" SELECT bill.FCompanyID, billentry.facctcusstypeid FASSTACTTYPEID,");
        buffer.append(" billentry.facctcussid FASSTACTID, billentry.fcurrencyid FCURRENCYID, billentry.fpersonid FPERSONID, billentry.fadminorgunitid FADMINORGUNITID,");
        buffer.append(" billentry.FAccountID FACCOUNTID,");
        buffer.append(" 0 FDAMOUNT,");
        buffer.append(" 0 FDAMOUNTLOCAL,");
        buffer.append(" billentry.fthisverificateamt FCAMOUNT,");
        buffer.append(" billentry.fthisverificateamtloc FCAMOUNTLOCAL");
        buffer.append(" FROM t_ap_verificationbill BILL");
        buffer.append(" INNER JOIN t_ap_verificationbillentry BILLENTRY ON bill.fid = billentry.fparentid");
        buffer.append(" WHERE bill.fverificationtype IN (203, 209)");
        buffer.append(" AND billentry.fbilltype = 8");
        buffer.append(" and bill.fbizdate>={").append(beginDate).append("}");
        buffer.append(" and bill.fbizdate<{").append(endDate).append("}");
        buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
        buffer.append(" UNION ALL");
        buffer.append(" SELECT bill.FCompanyID, bill.fasstacttypeid FASSTACTTYPEID,");
        buffer.append(" bill.fasstactid FASSTACTID, bill.fcurrencyid FCURRENCYID, bill.FPersonID FPERSONID, bill.FAdminOrgUnitID FADMINORGUNITID,");
        buffer.append(" billentry.FAccountID FACCOUNTID,");
        buffer.append(" 0 FDAMOUNT, 0 FDAMOUNTLOCAL,");
        buffer.append(" PaymentBillEntry.FAmount FCAMOUNT, PaymentBillEntry.FLocalAmount FCAMOUNTLOCAL");
        buffer.append(" FROM T_AR_OTHERBILL BILL");
        buffer.append(" INNER JOIN T_AR_OTHERBILLENTRY BILLENTRY ON bill.fid = billentry.fparentid");
        buffer.append(" INNER JOIN T_CAS_PAYMENTBILLENTRY PaymentBillEntry ON billentry.fid = PaymentBillEntry.FSourceBillEntryID");
        buffer.append(" INNER JOIN T_CAS_PAYMENTBILL PaymentBill ON PaymentBillEntry.FPaymentBillID = PaymentBill.fid");
        buffer.append(" WHERE PaymentBill.fsourcetype = 101 and PaymentBill.FBillStatus = 15");
        buffer.append(" AND PaymentBill.fistransbill = 1 AND PaymentBill.FIsTransOtherBill = 1");
        buffer.append(" and PaymentBill.fbizdate>={").append(beginDate).append("}");
        buffer.append(" and PaymentBill.fbizdate<{").append(endDate).append("}");
        buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
        buffer.append(" UNION ALL");
        buffer.append(" SELECT bill.FCompanyID, bill.FPayerTypeID FASSTACTTYPEID,");
        buffer.append(" bill.FPayerID FASSTACTID, bill.fcurrencyid FCURRENCYID, bill.FPersonID FPERSONID, bill.FAdminOrgUnitID FADMINORGUNITID,");
        buffer.append(" billentry.FOppAccountID FACCOUNTID,");
        buffer.append(" sourceEntry.FRecievePayAmount FDAMOUNT, sourceEntry.FRecievePayAmountLocal FDAMOUNTLOCAL,");
        buffer.append(" 0 FCAMOUNT, 0 FCAMOUNTLOCAL");
        buffer.append(" FROM T_CAS_ReceivingBillEntry billEntry ");
        buffer.append(" INNER JOIN T_CAS_ReceivingBill bill on bill.FID = billEntry.FReceivingBillID ");
        buffer.append(" INNER JOIN t_ap_otherbillentry sourceEntry on sourceEntry.FSourceBillEntryID = billEntry.FID ");
        buffer.append(" INNER JOIN T_AP_OtherBill sourceBill on sourceBill.FID = sourceEntry.FParentID ");
        buffer.append(" WHERE sourceBill.FBillStatus = 3 and sourceBill.FIsTransOtherBill = 1 ");
        if (!param.isIncludeBizBill()) {
            buffer.append(" AND sourceBill.FIsBizBill = 0");
        }
        if (!param.isCash()) {
            buffer.append(" and sourceBill.FPaymentTypeID='").append("2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5").append("'").append(RT);
        }
        buffer.append(" and sourceBill.fbilldate>={").append(beginDate).append("}");
        buffer.append(" and sourceBill.fbilldate<{").append(endDate).append("}");
        buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
        buffer.append(" UNION ALL");
        buffer.append(" SELECT bill.FCompanyID, bill.fcussenttypeid FASSTACTTYPEID,");
        buffer.append(" bill.facctcussentid FASSTACTID, bill.fcurrencyid FCURRENCYID, bill.fpersonid FPERSONID, bill.fadminorgunitid FADMINORGUNITID,");
        buffer.append(" bill.FAccountID FACCOUNTID,");
        buffer.append(" 0 FDAMOUNT, 0 FDAMOUNTLOCAL,");
        buffer.append(" bill.fbadamounts FCAMOUNT, bill.fbadamountslocal FCAMOUNTLOCAL");
        buffer.append(" FROM t_ar_badacct BILL");
        buffer.append(" WHERE bill.FAuditorID is not null");
        buffer.append(" AND bill.fbadacctdate>={").append(beginDate).append("}");
        buffer.append(" and bill.fbadacctdate<{").append(endDate).append("}");
        buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
        buffer.append(" UNION ALL");
        buffer.append(" SELECT bill.FCompanyID, billentry.facctcusstypeid FASSTACTTYPEID,");
        buffer.append(" billentry.facctcussid FASSTACTID, billentry.fcurrencyid FCURRENCYID, billentry.fpersonid FPERSONID, billentry.fadminorgunitid FADMINORGUNITID,");
        buffer.append(" billentry.FAccountID FACCOUNTID,");
        buffer.append(" billentry.fthisverificateamt FDAMOUNT, billentry.fthisverificateamtloc FDAMOUNTLOCAL,");
        buffer.append(" 0 FCAMOUNT, 0 FCAMOUNTLOCAL");
        buffer.append(" FROM t_ar_verificationbill BILL");
        buffer.append(" INNER JOIN t_ar_verificationbillentry BILLENTRY ON bill.fid = billentry.fparentid");
        buffer.append(" WHERE bill.fverificationtype = 111");
        buffer.append(" AND billentry.fbilltype = 15");
        buffer.append(" and bill.fbizdate>={").append(beginDate).append("}");
        buffer.append(" and bill.fbizdate<{").append(endDate).append("}");
        buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
        return buffer.toString();
    }

    public static void computeAcctBalance(Context ctx, boolean fAR, PeriodInfo period, CompanyOrgUnitInfo company, ArApParams params, String tableName) throws BOSException, EASBizException {
        if (period == null) {
            throw new IllegalArgumentException();
        }
        if (company == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        String system = null;
        system = fAR ? SYSTEM_AR : SYSTEM_AP;
        String type = ACCOUNT_NORMAL;
        String[][] tempTableDefine = CommonServerUtils.getarapTempTableDefine(type);
        String companyID = company.getId().toString();
        String periodID = period.getId().toString();
        String beginDate = CommonServerUtils.convertDateToString(period.getBeginDate());
        String endDate = CommonServerUtils.convertDateToString(BaseDataUtil.upTimestamp(period.getEndDate()));
        String currentAcctTableID = CommonServerUtils.getCurrentAcctTable(ctx, company, period);
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        TempTablePool temp = TempTablePool.getInstance((Context)ctx);
        try {
            String resultTempTable;
            String tempTable3;
            String tempTable2;
            String tempTable1;
            connection = CommonServerUtils.getConnection(ctx);
            SysTempTableHelper sysTemp = new SysTempTableHelper(ctx, connection);
            String tempTable = params.getString("CommonServerUtils.computeAcctBalance.tempTable");
            if (tempTable == null) {
                tempTable = sysTemp.createTempTable(ctx, tempTableDefine);
                sysTemp.createTempTableIndex(tempTable, "FCompanyID,FCurrencyID,FAsstActTypeID,FAsstActID,FAccountID,FAdminOrgUnitID,FPersonID", false, false);
            }
            if ((tempTable1 = params.getString("CommonServerUtils.computeAcctBalance.tempTable1")) == null) {
                tempTable1 = sysTemp.createTempTable(ctx, tempTableDefine);
                sysTemp.createTempTableIndex(tempTable1, "FCompanyID,FCurrencyID,FAsstActTypeID,FAsstActID,FAccountID,FAdminOrgUnitID,FPersonID", false, false);
            }
            if ((tempTable2 = params.getString("CommonServerUtils.computeAcctBalance.tempTable2")) == null) {
                tempTable2 = sysTemp.createTempTable(ctx, tempTableDefine);
                sysTemp.createTempTableIndex(tempTable2, "FCompanyID,FCurrencyID,FAsstActTypeID,FAsstActID,FAccountID,FAdminOrgUnitID,FPersonID", false, false);
            }
            if ((tempTable3 = params.getString("CommonServerUtils.computeAcctBalance.tempTable3")) == null) {
                tempTable3 = sysTemp.createTempTable(ctx, tempTableDefine);
                sysTemp.createTempTableIndex(tempTable3, "FCompanyID,FCurrencyID,FAsstActTypeID,FAsstActID,FAccountID,FAdminOrgUnitID,FPersonID", false, false);
            }
            if ((resultTempTable = params.getString("CommonServerUtils.computeAcctBalance.resultTempTable")) == null) {
                resultTempTable = sysTemp.createTempTable(ctx, tempTableDefine);
                sysTemp.createTempTableIndex(resultTempTable, "FCompanyID,FCurrencyID,FAsstActTypeID,FAsstActID,FAccountID,FAdminOrgUnitID,FPersonID", false, false);
            }
            String recPayBillTable = null;
            String recEntryTempTable = null;
            boolean isRecBill = false;
            boolean isPayBill = false;
            boolean isPreRecAcct = false;
            boolean isPrePayAcct = false;
            HashMap<String, String> hashKey = new HashMap<String, String>();
            hashKey.put("AR_RECVOUCHER_BILLTYPE", companyID);
            hashKey.put("AP_PAYVOUCHER_BILLTYPE", companyID);
            hashKey.put("AR_IS_PRE_REC_ACCT", companyID);
            hashKey.put("AP_IS_PRE_PAY_ACCT", companyID);
            HashMap apPaymentBankMap = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hashKey);
            isPreRecAcct = Boolean.valueOf((String)apPaymentBankMap.get("AR_IS_PRE_REC_ACCT"));
            isPrePayAcct = Boolean.valueOf((String)apPaymentBankMap.get("AP_IS_PRE_PAY_ACCT"));
            isRecBill = TRUE_VAL.equals((String)apPaymentBankMap.get("AR_RECVOUCHER_BILLTYPE"));
            isPayBill = TRUE_VAL.equals((String)apPaymentBankMap.get("AP_PAYVOUCHER_BILLTYPE"));
            Boolean isDAPCheckAccount = params.getBooleanObject("isDAPCheckAccount");
            if (isDAPCheckAccount == null) {
                isDAPCheckAccount = new Boolean(ArApParamHelper.isDAPCheckAccount(ctx));
                params.setBoolean("isDAPCheckAccount", isDAPCheckAccount.booleanValue());
            }
            String sql = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isRecBill, "v_ar_checkaccount");
            sqlList.add(sql);
            String sql1 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isRecBill, "v_ar_checkaccount1");
            sqlList.add(sql1);
            recPayBillTable = CommonServerUtils.computeRecBill(ctx, connection, companyID, params, period, beginDate, endDate, true);
            String sql13 = ArApSQLHelper.builderRecPayBillCheckAccountSQL(ctx, recPayBillTable, tempTable, companyID, company, params, currentAcctTableID, beginDate, endDate, period, true, isRecBill);
            sqlList.add(sql13);
            String sql2 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isRecBill, "v_ar_checkaccount2");
            sqlList.add(sql2);
            String arVeriCheckAccountView = null;
            arVeriCheckAccountView = isRecBill ? (isPreRecAcct ? "v_ar_checkaccount27" : "v_ar_checkaccount12") : "v_ar_checkaccount3";
            String sql3 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isRecBill, arVeriCheckAccountView);
            sqlList.add(sql3);
            String sql4 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isRecBill, "v_ar_checkaccount4");
            sqlList.add(sql4);
            String sql5 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isRecBill, "v_ar_checkaccount5");
            sqlList.add(sql5);
            String sql6 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isRecBill, "v_ar_checkaccount6");
            sqlList.add(sql6);
            String sql7 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isRecBill, "v_ar_checkaccount7");
            sqlList.add(sql7);
            String sql8 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isRecBill, "v_ar_checkaccount8");
            sqlList.add(sql8);
            String sql9 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isRecBill, "v_ar_checkaccount9");
            sqlList.add(sql9);
            String sql10 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isRecBill, "v_ar_checkaccount10");
            sqlList.add(sql10);
            String sql11 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable2, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isRecBill, "v_ar_checkaccount11");
            sqlList.add(sql11);
            String sql14 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isRecBill, "v_ar_checkaccount13");
            sqlList.add(sql14);
            String sql12 = CommonServerUtils.builderCheckBadAcctSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate);
            sqlList.add(sql12);
            sql = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isPayBill, "v_ap_checkaccount");
            sqlList.add(sql);
            sql1 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isPayBill, "v_ap_checkaccount1");
            sqlList.add(sql1);
            recPayBillTable = CommonServerUtils.computeRecBill(ctx, connection, companyID, params, period, beginDate, endDate, false);
            sql12 = ArApSQLHelper.builderRecPayBillCheckAccountSQL(ctx, recPayBillTable, tempTable, companyID, company, params, currentAcctTableID, beginDate, endDate, period, false, isPayBill);
            sqlList.add(sql12);
            String apVeriCheckAccountView = null;
            apVeriCheckAccountView = isPayBill ? (isPrePayAcct ? "v_ap_checkaccount27" : "v_ap_checkaccount12") : "v_ap_checkaccount2";
            sql2 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isPayBill, apVeriCheckAccountView);
            sqlList.add(sql2);
            sql3 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isPayBill, "v_ap_checkaccount3");
            sqlList.add(sql3);
            sql4 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isPayBill, "v_ap_checkaccount4");
            sqlList.add(sql4);
            sql5 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isPayBill, "v_ap_checkaccount5");
            sqlList.add(sql5);
            sql6 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isPayBill, "v_ap_checkaccount6");
            sqlList.add(sql6);
            sql7 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isPayBill, "v_ap_checkaccount7");
            sqlList.add(sql7);
            sql8 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isPayBill, "v_ap_checkaccount8");
            sqlList.add(sql8);
            sql9 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isPayBill, "v_ap_checkaccount9");
            sqlList.add(sql9);
            sql10 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isPayBill, "v_ap_checkaccount10");
            sqlList.add(sql10);
            sql11 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable2, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isPayBill, "v_ap_checkaccount11");
            sqlList.add(sql11);
            sql14 = CommonServerUtils.builderCheckAccountSQL(ctx, tempTable, companyID, company, params, currentAcctTableID, period, beginDate, endDate, fAR, isPayBill, "v_ap_checkaccount13");
            sqlList.add(sql14);
            DBUtil.execBatchSql((Connection)connection, sqlList, (boolean)true);
            sqlList.clear();
            try {
                temp.analyzeTable(connection, tempTable);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            StringBuffer buffer = new StringBuffer("");
            buffer.append(" INSERT INTO ").append(resultTempTable).append(RT);
            buffer.append(" SELECT FCompanyID, FAsstActTypeID, FAsstActID, FCurrencyID, FPersonID, FAdminOrgUnitID,").append(RT);
            buffer.append(" FAccountID, sum(FReceiving) FTOTALDEBITAMOUNT, sum(FActual) FTOTALCREDITAMOUNT,").append(RT);
            buffer.append(" sum(FReceivingLocal) FTOTALDEBITAMOUNTLOC, sum(FActualLocal) FTOTALCREDITAMOUNTLOC  FROM ").append(tempTable).append(RT);
            buffer.append(" group by FCompanyID,FAsstActTypeID,FAsstActID,FCurrencyID,FPersonID,FAdminOrgUnitID,FAccountID ");
            sqlList.add(buffer.toString());
            DBUtil.execBatchSql((Connection)connection, sqlList, (boolean)true);
            sqlList.clear();
            try {
                temp.analyzeTable(connection, resultTempTable);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            StringBuffer insertBuffer = new StringBuffer("");
            insertBuffer.append(CommonServerUtils.insertTable(type, tableName)).append(CommonServerUtils.insertTableSQL(system, type, 3, periodID, resultTempTable, tableName));
            sqlList.add(insertBuffer.toString());
            DBUtil.execBatchSql((Connection)connection, sqlList, (boolean)true);
            try {
                temp.analyzeTable(connection, resultTempTable);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            if (!tableName.equals(CommonUtils.getARAPBalanceTable(system, type))) {
                try {
                    temp.analyzeTable(connection, tableName);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
            String tempDefine = CommonServerUtils.tempTableDefine();
            String tempTal = TempTableUtil.createTempTable(ctx, tempDefine);
            try {
                temp.createIndex(tempTal, "fid", true, false);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            StringBuffer insertTempBuffer = new StringBuffer(CommonServerUtils.insertTempSQL(type, tempTal, resultTempTable, tableName, periodID, companyID));
            insertTempBuffer.append(" and (t3.FBalType = ").append(3).append(") \r\n");
            pstmt = connection.prepareStatement(insertTempBuffer.toString());
            pstmt.execute();
            pstmt.close();
            try {
                temp.analyzeTable(connection, tempTal);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            StringBuffer updateBuffer = new StringBuffer(CommonServerUtils.updateTableSQL(type, tempTal, tableName, periodID, companyID));
            pstmt = connection.prepareStatement(updateBuffer.toString());
            pstmt.execute();
            pstmt.close();
            TempTableUtil.releasTempTable(ctx, tempTal);
            insertBuffer.setLength(0);
            insertBuffer.append(CommonServerUtils.insertTable(type, tableName)).append(CommonServerUtils.insertTableSQL(system, type, 5, periodID, tempTable2, tableName));
            pstmt = connection.prepareStatement(insertBuffer.toString());
            pstmt.execute();
            pstmt.close();
            try {
                temp.analyzeTable(connection, tempTable2);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            if (!tableName.equals(CommonUtils.getARAPBalanceTable(system, type))) {
                try {
                    temp.analyzeTable(connection, tableName);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
            String tempTal2 = TempTableUtil.createTempTable(ctx, tempDefine);
            try {
                temp.createIndex(tempTal2, "fid", true, false);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            StringBuffer insertTempBuffer2 = new StringBuffer(CommonServerUtils.insertTempSQL(type, tempTal2, tempTable2, tableName, periodID, companyID));
            insertTempBuffer2.append(" and (t3.FBalType = ").append(5).append(") \r\n");
            pstmt = connection.prepareStatement(insertTempBuffer2.toString());
            pstmt.execute();
            pstmt.close();
            try {
                temp.analyzeTable(connection, tempTal2);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            updateBuffer.setLength(0);
            updateBuffer.append(CommonServerUtils.updateTableSQL(type, tempTal2, tableName, periodID, companyID));
            pstmt = connection.prepareStatement(updateBuffer.toString());
            pstmt.execute();
            pstmt.close();
            TempTableUtil.releasTempTable(ctx, tempTal2);
            if (!isDAPCheckAccount.booleanValue()) {
                ContrastGLQueryParam queryParam;
                StringBuffer buffer1 = new StringBuffer("");
                buffer1.append("insert into ").append(tempTable1);
                buffer1.append(" select FCompanyID,FAsstActTypeID,FAsstActID,FCurrencyID,FPersonID,FAdminOrgUnitID,FAccountID ").append(RT);
                buffer1.append(" ,sum(fdebitamount) FTotalDebitAmount ").append(RT);
                buffer1.append(" ,sum(fcreditamount) FTotalCreditAmount ").append(RT);
                buffer1.append(" ,sum(fdebitamountlocal) FTotalDebitAmountLoc ").append(RT);
                buffer1.append(" ,sum(fcreditdebitamountlocal) FTotalCreditAmountLoc ").append(RT);
                boolean cashflag = false;
                if (null != params && params instanceof ContrastGLQueryParam && (queryParam = (ContrastGLQueryParam)params).isCash()) {
                    cashflag = true;
                }
                StringBuffer sbAr = new StringBuffer(buffer1);
                recEntryTempTable = CommonServerUtils.computeReceivingBillEntry(ctx, connection, companyID, beginDate, endDate, params);
                sbAr.append(" from (").append(CommonServerUtils.getArBalanceNoVoucherSQL(ctx, recEntryTempTable, companyID, period, isRecBill, cashflag)).append(") as bill ").append(RT);
                StringBuffer sbAp = new StringBuffer(buffer1);
                sbAp.append(" from (").append(CommonServerUtils.getApBalanceNoVoucherSQL(ctx, companyID, period, isPayBill, cashflag)).append(") as bill ").append(RT);
                StringBuffer sbWhere = new StringBuffer();
                sbWhere.append(" where FCompanyID='").append(companyID).append("'").append(RT);
                sbWhere.append(" and (FAccountCompanyID='").append(companyID).append("'").append(RT);
                sbWhere.append(" or FAccountCompanyID='111')");
                sbWhere.append(" and FControlUnitID='").append(company.getCU().getId().toString()).append("'").append(RT);
                if (currentAcctTableID != null && !"".equals(currentAcctTableID)) {
                    sbWhere.append(" and FAccountTableID='").append(currentAcctTableID).append("'").append(RT);
                }
                sbWhere.append(" and fbilldate>={").append(beginDate).append("}").append(RT);
                sbWhere.append(" and fbilldate<{").append(endDate).append("}").append(RT);
                sbWhere.append(" group by FCompanyID,FAsstActTypeID,FAsstActID,FCurrencyID,FPersonID,FAdminOrgUnitID,FAccountID ").append(RT);
                pstmt = connection.prepareStatement(sbAr.append(sbWhere).toString());
                pstmt.execute();
                pstmt.close();
                pstmt = connection.prepareStatement(sbAp.append(sbWhere).toString());
                pstmt.execute();
                pstmt.close();
                StringBuffer insertBuffer1 = new StringBuffer("");
                insertBuffer1.append(CommonServerUtils.insertTable(type, tableName)).append(CommonServerUtils.insertTableSQL(system, type, 2, periodID, tempTable1, tableName));
                pstmt = connection.prepareStatement(insertBuffer1.toString());
                pstmt.execute();
                pstmt.close();
                try {
                    temp.analyzeTable(connection, tempTable1);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
                if (!tableName.equals(CommonUtils.getARAPBalanceTable(system, type))) {
                    try {
                        temp.analyzeTable(connection, tableName);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                }
                String tempTal1 = TempTableUtil.createTempTable(ctx, tempDefine);
                try {
                    temp.createIndex(tempTal1, "fid", true, false);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
                StringBuffer insertTempBuffer1 = new StringBuffer(CommonServerUtils.insertTempSQL(type, tempTal1, tempTable1, tableName, periodID, companyID));
                insertTempBuffer1.append(" and (t3.FBalType = ").append(2).append(")").append(RT);
                pstmt = connection.prepareStatement(insertTempBuffer1.toString());
                pstmt.execute();
                pstmt.close();
                try {
                    temp.analyzeTable(connection, tempTal1);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
                StringBuffer updateBuffer1 = new StringBuffer(CommonServerUtils.updateTableSQL(type, tempTal1, tableName, periodID, companyID));
                pstmt = connection.prepareStatement(updateBuffer1.toString());
                pstmt.execute();
                pstmt.close();
                TempTableUtil.releasTempTable(ctx, tempTal1);
                buffer1.setLength(0);
                buffer1.append("insert into ").append(tempTable3);
                buffer1.append(" select FCompanyID,FAsstActTypeID,FAsstActID,FCurrencyID,FPersonID,FAdminOrgUnitID,FAccountID ").append(RT);
                buffer1.append(" ,sum(fdebitamount) FTotalDebitAmount ").append(RT);
                buffer1.append(" ,sum(fcreditamount) FTotalCreditAmount ").append(RT);
                buffer1.append(" ,sum(fdebitamountlocal) FTotalDebitAmountLoc ").append(RT);
                buffer1.append(" ,sum(fcreditdebitamountlocal) FTotalCreditAmountLoc ").append(RT);
                buffer1.append(" FROM (").append(CommonServerUtils.getBizBillBalanceNoVoucherSQL(ctx, companyID, period, true)).append(") AS bill");
                buffer1.append(" where FCompanyID='").append(companyID).append("'").append(RT);
                buffer1.append(" and (FAccountCompanyID='").append(companyID).append("'").append(RT);
                buffer1.append(" or FAccountCompanyID='111')");
                buffer1.append(" and FControlUnitID='").append(company.getCU().getId().toString()).append("'").append(RT);
                if (currentAcctTableID != null && !"".equals(currentAcctTableID)) {
                    buffer1.append(" and FAccountTableID='").append(currentAcctTableID).append("'").append(RT);
                }
                buffer1.append(" and fbilldate>={").append(beginDate).append("}").append(RT);
                buffer1.append(" and fbilldate<{").append(endDate).append("}").append(RT);
                buffer1.append(" group by FCompanyID,FAsstActTypeID,FAsstActID,FCurrencyID,FPersonID,FAdminOrgUnitID,FAccountID ").append(RT);
                pstmt = connection.prepareStatement(buffer1.toString());
                pstmt.execute();
                pstmt.close();
                insertBuffer1.setLength(0);
                insertBuffer1.append(CommonServerUtils.insertTable(type, tableName)).append(CommonServerUtils.insertTableSQL(system, type, 4, periodID, tempTable3, tableName));
                pstmt = connection.prepareStatement(insertBuffer1.toString());
                pstmt.execute();
                pstmt.close();
                buffer1.setLength(0);
                buffer1.append("insert into ").append(tempTable3);
                buffer1.append(" select FCompanyID,FAsstActTypeID,FAsstActID,FCurrencyID,FPersonID,FAdminOrgUnitID,FAccountID ").append(RT);
                buffer1.append(" ,sum(fdebitamount) FTotalDebitAmount ").append(RT);
                buffer1.append(" ,sum(fcreditamount) FTotalCreditAmount ").append(RT);
                buffer1.append(" ,sum(fdebitamountlocal) FTotalDebitAmountLoc ").append(RT);
                buffer1.append(" ,sum(fcreditdebitamountlocal) FTotalCreditAmountLoc ").append(RT);
                buffer1.append(" FROM (").append(CommonServerUtils.getBizBillBalanceNoVoucherSQL(ctx, companyID, period, false)).append(") AS bill");
                buffer1.append(" where FCompanyID='").append(companyID).append("'").append(RT);
                buffer1.append(" and (FAccountCompanyID='").append(companyID).append("'").append(RT);
                buffer1.append(" or FAccountCompanyID='111')");
                buffer1.append(" and FControlUnitID='").append(company.getCU().getId().toString()).append("'").append(RT);
                if (currentAcctTableID != null && !"".equals(currentAcctTableID)) {
                    buffer1.append(" and FAccountTableID='").append(currentAcctTableID).append("'").append(RT);
                }
                buffer1.append(" and fbilldate>={").append(beginDate).append("}").append(RT);
                buffer1.append(" and fbilldate<{").append(endDate).append("}").append(RT);
                buffer1.append(" group by FCompanyID,FAsstActTypeID,FAsstActID,FCurrencyID,FPersonID,FAdminOrgUnitID,FAccountID ").append(RT);
                pstmt = connection.prepareStatement(buffer1.toString());
                pstmt.execute();
                pstmt.close();
                insertBuffer1.setLength(0);
                insertBuffer1.append(CommonServerUtils.insertTable(type, tableName)).append(CommonServerUtils.insertTableSQL(system, type, 4, periodID, tempTable3, tableName));
                pstmt = connection.prepareStatement(insertBuffer1.toString());
                pstmt.execute();
                pstmt.close();
                try {
                    temp.analyzeTable(connection, tempTable3);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
                if (!tableName.equals(CommonUtils.getARAPBalanceTable(system, type))) {
                    try {
                        temp.analyzeTable(connection, tableName);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                }
                String tempTal3 = TempTableUtil.createTempTable(ctx, tempDefine);
                try {
                    temp.createIndex(tempTal3, "fid", true, false);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
                StringBuffer insertTempBuffer3 = new StringBuffer(CommonServerUtils.insertTempSQL(type, tempTal3, tempTable3, tableName, periodID, companyID));
                insertTempBuffer3.append(" and (t3.FBalType = ").append(4).append(")").append(RT);
                pstmt = connection.prepareStatement(insertTempBuffer3.toString());
                pstmt.execute();
                pstmt.close();
                try {
                    temp.analyzeTable(connection, tempTal3);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
                updateBuffer1.setLength(0);
                updateBuffer1.append(CommonServerUtils.updateTableSQL(type, tempTal3, tableName, periodID, companyID));
                pstmt = connection.prepareStatement(updateBuffer1.toString());
                pstmt.execute();
                pstmt.close();
                TempTableUtil.releasTempTable(ctx, tempTal3);
            }
            temp.releaseTable(tempTable);
            temp.releaseTable(tempTable1);
            temp.releaseTable(tempTable2);
            temp.releaseTable(tempTable3);
            temp.releaseTable(resultTempTable);
            temp.releaseTable(recPayBillTable);
            if (recEntryTempTable != null) {
                temp.releaseTable(recEntryTempTable);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)connection);
    }

    private static String builderCheckBadAcctSQL(Context ctx, String tempTable, String companyID, CompanyOrgUnitInfo company, ArApParams params, String currentAcctTableID, PeriodInfo period, String beginDate, String endDate) throws BOSException, EASBizException {
        StringBuffer buffer = new StringBuffer("");
        buffer.append("insert into ").append(tempTable);
        buffer.append(" select ");
        buffer.append("  FCompanyID ");
        buffer.append(" ,FAsstActTypeID ");
        buffer.append(" ,FAsstActID");
        buffer.append(" ,FCurrencyID");
        buffer.append(" ,FPersonID");
        buffer.append(" ,FAdminOrgUnitID");
        buffer.append(" ,FAccountID");
        buffer.append(" ,sum(FDebitAmount) FTotalDebitAmount ");
        buffer.append(" ,sum(FCreditAmount) FTotalCreditAmount ");
        buffer.append(" ,sum(fdebitamountlocal) FTotalDebitAmountLoc ");
        buffer.append(" ,sum(fcreditdebitamountlocal) FTotalCreditAmountLoc ");
        buffer.append(" from (select bill.FCompanyID,bill.FCussentTypeID AS FAsstActTypeID,bill.FAcctCussentID AS FAsstActID,bill.FCurrencyID");
        buffer.append(" ,CASE ISNULL(RTRIM(LTRIM(bill.FPersonID)),'z') WHEN 'z' THEN 'z' WHEN '' THEN 'z' ELSE bill.FPersonID END AS FPersonID ");
        buffer.append(" ,CASE ISNULL(RTRIM(LTRIM(bill.FAdminOrgUnitID)),'z') WHEN 'z' THEN 'z' WHEN '' THEN 'z' ELSE bill.FAdminOrgUnitID END AS FAdminOrgUnitID, ");
        buffer.append(" voucherEntry.FAccountID,voucherEntry.FEntryDC * bill.FBadAmounts AS FDebitAmount,(1 - voucherEntry.FEntryDC) * bill.FBadAmounts AS FCreditAmount,");
        buffer.append(" voucherEntry.FEntryDC * bill.FBadAmountsLocal AS Fdebitamountlocal,(1 - voucherEntry.FEntryDC) * bill.FBadAmountsLocal AS Fcreditdebitamountlocal ");
        buffer.append(" from T_BOT_RELATION relation");
        buffer.append(" INNER JOIN T_AR_BADACCT bill ON relation.FSrcObjectID = bill.FID");
        buffer.append(" INNER JOIN T_GL_VOUCHER voucher ON relation.FDestObjectID = voucher.FID");
        buffer.append(" INNER JOIN T_GL_VOUCHERENTRY voucherEntry ON voucher.FID = voucherEntry.FBillID");
        buffer.append(" INNER JOIN V_AR_ACCOUNTVIEWUNION accountUnion ON voucherEntry.FAccountID = accountUnion.FAccountID WHERE 1=1");
        buffer.append(" AND relation.FDestEntityID = '2652E01E' AND relation.FSrcEntityID = '9E1B9DB7'");
        Boolean isDAPCheckAccount = params.getBooleanObject("isDAPCheckAccount");
        if (isDAPCheckAccount.booleanValue()) {
            buffer.append(" and voucher.FBizStatus != ").append(0).append(RT);
            buffer.append(" and voucher.FBizStatus != ").append(2).append(RT);
        }
        buffer.append(" and accountUnion.fperiodyear = ").append(period.getPeriodYear()).append(RT);
        buffer.append(" and accountUnion.fperiodnumber = ").append(period.getPeriodNumber()).append(RT);
        buffer.append(" and bill.FCompanyID='").append(companyID).append("'");
        buffer.append(" AND voucher.FCompanyID='").append(companyID).append("'");
        buffer.append(" and (accountUnion.FCompanyID='").append(companyID).append("'");
        buffer.append(" or accountUnion.FCompanyID='111')");
        buffer.append(" and accountUnion.FControlUnitID='").append(company.getCU().getId().toString()).append("'");
        if (currentAcctTableID != null && !"".equals(currentAcctTableID)) {
            buffer.append(" and accountUnion.FAccountTableID='").append(currentAcctTableID).append("'");
        }
        if (isDAPCheckAccount.booleanValue()) {
            buffer.append(" and voucher.FBookedDate>={").append(beginDate).append("}");
            buffer.append(" and voucher.FBookedDate<{").append(endDate).append("}");
        } else {
            buffer.append(" and bill.FBadAcctDate>={").append(beginDate).append("}");
            buffer.append(" and bill.FBadAcctDate<{").append(endDate).append("}");
        }
        buffer.append(" AND accountUnion.FSystem = 1");
        buffer.append(" ) as bill ");
        buffer.append(" group by FCompanyID,FAsstActTypeID,FAsstActID,FCurrencyID,FPersonID,FAdminOrgUnitID,FAccountID ");
        return buffer.toString();
    }

    public static void reComputeApAccountBalance(Context ctx, PeriodInfo period) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CommonServerUtils.getCurrentCompany(ctx);
        String tableName = CommonUtils.getARAPBalanceTable(SYSTEM_AP, ACCOUNT_NORMAL);
        ArApParams params = new ArApParams();
        Boolean isDAPCheckAccount = params.getBooleanObject("isDAPCheckAccount");
        if (isDAPCheckAccount == null) {
            params.setObject("isDAPCheckAccount", (Object)new Boolean(ArApParamHelper.isDAPCheckAccount(ctx)));
        }
        CommonServerUtils.computeAcctBalance(ctx, false, period, company, params, tableName);
    }

    public static String getCurrentAcctTable(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period) throws BOSException, EASBizException {
        if (company.getAccountTable() == null) {
            return null;
        }
        String companyID = company.getId().toString();
        String accountTableID = company.getAccountTable().getId().toString();
        int periodYear = period.getPeriodYear();
        int periodNumber = period.getPeriodNumber();
        return AccountTools.getCurrentAcctTable((Context)ctx, (String)companyID, (String)accountTableID, (int)periodYear, (int)periodNumber);
    }

    public static boolean transferBalance(Context ctx, String system, String type, PeriodInfo currentPeriod, PeriodInfo nextPeriod, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        String tableName = CommonUtils.getARAPBalanceTable(system, type);
        String companyID = company.getId().toString();
        CommonServerUtils.deleteBalanceData(ctx, tableName, companyID, nextPeriod);
        return CommonServerUtils.transferBalance(ctx, system, type, tableName, companyID, currentPeriod, nextPeriod);
    }

    public static boolean transferBalance(Context ctx, String system, String type, String tableName, String companyID, PeriodInfo currentPeriod, PeriodInfo nextPeriod) throws BOSException, EASBizException {
        if (nextPeriod == null || nextPeriod.getId() == null) {
            throw new ArApCommonException(new NumericExceptionSubItem("010", "NEXTPERIOD_NULL_010"));
        }
        if (StringUtils.isEmpty((String)tableName)) {
            throw new IllegalArgumentException("CommonServerUtils.transferBalance.parameter.tableName is [" + tableName + "]!");
        }
        if (StringUtils.isEmpty((String)companyID)) {
            throw new IllegalArgumentException("CommonServerUtils.transferBalance.parameter.companyID is [" + companyID + "]!");
        }
        if (!(DAILY_NORMAL.equals(type) || DAILY_INITIAL.equals(type) || ACCOUNT_INITIAL.equals(type) || ACCOUNT_NORMAL.equals(type) || BILL_ACCOUNT.equals(type))) {
            throw new IllegalArgumentException("CommonServerUtils.transferBalance.parameter.type is [" + type + "]!");
        }
        if (!SYSTEM_AP.equals(system) && !SYSTEM_AR.equals(system)) {
            throw new IllegalArgumentException("CommonServerUtils.transferBalance.parameter.system is [" + system + "]!");
        }
        StringBuilder buffer = new StringBuilder(100);
        buffer.append("transferBalance ( ").append(system).append(",").append(type).append(",");
        if (currentPeriod != null) {
            buffer.append(currentPeriod.getId());
        } else {
            buffer.append("NULL");
        }
        buffer.append(",").append(nextPeriod.getId()).append(")");
        logger.debug((Object)buffer.toString());
        int periodYearDifference = currentPeriod != null ? nextPeriod.getPeriodYear() - currentPeriod.getPeriodYear() : 0;
        int sameYear = periodYearDifference == 0 ? 1 : 0;
        StringBuilder insertBuffer = new StringBuilder(200);
        insertBuffer.append(" insert into ").append(tableName).append(LOGIC_LEFT_BRACKET).append("FID, ").append(RT).append("FPeriodID, ").append(RT).append("FBalType, FCompanyID, FAsstActTypeID, ").append(RT).append("FAsstActID, FCurrencyID, FPersonID, FAdminOrgUnitID,  ").append(RT).append("FBeginBalanceFor, FDebitFor, FCreditFor, ").append(RT).append("FYearDebitFor, FYearCreditFor, FEndBalanceFor, ").append(RT).append("FBeginBalanceLocal, FDebitLocal, FCreditLocal, ").append(RT).append("FYearDebitLocal, FYearCreditLocal, FEndBalanceLocal ").append(RT);
        if (!DAILY_NORMAL.equals(type)) {
            insertBuffer.append(",FAccount ");
        }
        insertBuffer.append(")").append(RT).append(" select ").append(CommonUtils.getARAPBalanceID(system, type)).append(" AS FID ,").append(RT).append("'").append(nextPeriod.getId().toString()).append("' AS FPeriodID, ").append(RT).append(" currBalance.FBalType, currBalance.FCompanyID, currBalance.FAsstActTypeID, ").append(RT).append(" currBalance.FAsstActID, currBalance.FCurrencyID, currBalance.FPersonID, currBalance.FAdminOrgUnitID, ").append(RT).append(" currBalance.FEndBalanceFor, 0.0, 0.0, ").append(RT).append(sameYear).append("*currBalance.FYearDebitFor, ").append(sameYear).append("*currBalance.FYearCreditFor, 0.0, ").append(RT).append(" currBalance.FEndBalanceLocal, 0.0, 0.0, ").append(RT).append(sameYear).append("*currBalance.FYearDebitLocal, ").append(sameYear).append("*currBalance.FYearCreditLocal, 0.0 ").append(RT);
        if (!DAILY_NORMAL.equals(type)) {
            insertBuffer.append(",currBalance.FAccount ").append(RT);
        }
        insertBuffer.append(" from ").append(tableName).append(" currBalance ").append(RT).append(" where currBalance.FCompanyID = '").append(companyID).append("'").append(RT).append(" and currBalance.FPeriodID = '").append(currentPeriod.getId().toString()).append("'");
        DbUtil.execute((Context)ctx, (String)insertBuffer.toString());
        return true;
    }

    public static void transferContrastAccountView(Context ctx, int system, CompanyOrgUnitInfo currentCompany, PeriodInfo currentPeriod, PeriodInfo nextPeriod) throws BOSException, EASBizException {
        StringBuilder insertBuffer = new StringBuilder(300);
        String currAccounID = BaseDataUtil.getCurrentAccountTableID(ctx, currentPeriod, currentCompany);
        String nextAccounID = BaseDataUtil.getCurrentAccountTableID(ctx, nextPeriod, currentCompany);
        insertBuffer.append(" insert into T_AR_ContrastAccountView( FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FName_L1 ,").append(RT);
        insertBuffer.append(" FName_L2,FName_L3,FNumber,FDescription_L1,FDescription_L2 ,FDescription_L3,FSimpleName,").append(RT);
        insertBuffer.append(" FCompanyID,FAccountID, FAccountTableID,FDataDirection,FAsstActTypeID,FSystem,FPeriodYear,FPeriodNumber, FisContrast) ").append(RT);
        insertBuffer.append(" select newbosid('").append("61F4DECC").append("')").append(RT);
        if (currAccounID.equalsIgnoreCase(nextAccounID)) {
            insertBuffer.append(",FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FName_L1 ,").append(RT);
            insertBuffer.append("FName_L2,FName_L3,FNumber,FDescription_L1,FDescription_L2 ,FDescription_L3,FSimpleName,").append(RT);
            insertBuffer.append("FCompanyID,FAccountID, FAccountTableID,FDataDirection,FAsstActTypeID,").append(RT);
            insertBuffer.append(system).append(",").append(RT);
            insertBuffer.append(nextPeriod.getPeriodYear()).append(",").append(nextPeriod.getPeriodNumber());
            insertBuffer.append(" ,FisContrast").append(" ").append(RT);
            insertBuffer.append(" from t_ar_contrastaccountview where fcompanyID='").append(currentCompany.getId().toString()).append("'").append(RT);
            insertBuffer.append(" and fperiodYear = ").append(currentPeriod.getPeriodYear()).append(RT);
            insertBuffer.append(" and fperiodNumber = ").append(currentPeriod.getPeriodNumber()).append(RT);
            insertBuffer.append(" and fsystem = ").append(system).append(RT);
            insertBuffer.append(" and FAccountID not in ").append(RT);
        } else {
            String refID = CommonServerUtils.getRefID(ctx, currentCompany.getId().toString(), nextAccounID, currAccounID);
            insertBuffer.append(",contrastAccountView.FCreatorID,contrastAccountView.FCreateTime,");
            insertBuffer.append("contrastAccountView.FLastUpdateUserID,contrastAccountView.FLastUpdateTime,");
            insertBuffer.append("contrastAccountView.FControlUnitID,accountView.FName_L1,accountView.FName_L2,accountView.FName_L3,").append(RT);
            insertBuffer.append("accountView.FNumber,accountView.FDescription_L1,accountView.FDescription_L2,").append(RT);
            insertBuffer.append("accountView.FDescription_L3,accountView.FSimpleName,contrastAccountView.FCompanyID,").append(RT);
            insertBuffer.append("refContrastEntry.fnewacctid, '").append(nextAccounID).append("',");
            insertBuffer.append("contrastAccountView.FDataDirection,contrastAccountView.FAsstActTypeID,").append(RT);
            insertBuffer.append(system).append(",").append(RT);
            insertBuffer.append(nextPeriod.getPeriodYear()).append(",").append(nextPeriod.getPeriodNumber());
            insertBuffer.append(" ,contrastAccountView.FisContrast").append(" ").append(RT);
            insertBuffer.append(" from t_ar_contrastaccountview contrastAccountView");
            insertBuffer.append(" inner join T_BD_AcctRefContrastentry refContrastEntry ").append(RT);
            insertBuffer.append(" on contrastAccountView.faccountid = refContrastEntry.foldacctid ").append(RT);
            insertBuffer.append(" inner join T_BD_AccountView accountView ON refContrastEntry.fnewacctid = accountview.fid ").append(RT);
            insertBuffer.append(" where contrastAccountView.fcompanyID='").append(currentCompany.getId().toString()).append("'").append(RT);
            insertBuffer.append(" AND refContrastEntry.facctrefcontrastid = '").append(refID).append("'").append(RT);
            insertBuffer.append(" and contrastAccountView.fperiodYear = ").append(currentPeriod.getPeriodYear()).append(RT);
            insertBuffer.append(" and contrastAccountView.fperiodNumber = ").append(currentPeriod.getPeriodNumber()).append(RT);
            insertBuffer.append(" and contrastAccountView.fsystem = ").append(system).append(RT);
            insertBuffer.append(" and refContrastEntry.fnewacctid not in ").append(RT);
        }
        insertBuffer.append(" (select faccountid from t_ar_contrastaccountview where fcompanyID = '").append(currentCompany.getId().toString()).append("'").append(RT).append(" and fperiodYear = ").append(nextPeriod.getPeriodYear()).append(RT).append(" and fperiodNumber = ").append(nextPeriod.getPeriodNumber()).append(RT).append(" and fsystem = ").append(system).append(") ");
        DbUtil.execute((Context)ctx, (String)insertBuffer.toString());
    }

    public static String getRefID(Context ctx, String companyID, String newAcctTableID, String oldAcctTableID) throws BOSException, EASBizException {
        String refID = "";
        StringBuffer sql = new StringBuffer("");
        sql.append(" select fid from T_BD_AcctRefContrast where fcompanyid='").append(companyID).append("'").append(RT);
        sql.append(" and FEnabledAcctTableID='").append(newAcctTableID).append("'").append(RT);
        sql.append(" and FDisabledAcctTableID='").append(oldAcctTableID).append("'").append(RT);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                refID = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return refID;
    }

    public static boolean copySubmitBalance(Context ctx, String system, String type, String companyID, String periodID) throws BOSException {
        boolean bl;
        String tableName = CommonUtils.getARAPBalanceTable(system, type);
        PreparedStatement prprdStmntInsert = null;
        PreparedStatement prprdStmntSelect = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = CommonServerUtils.getConnection(ctx);
            StringBuffer buffer0 = new StringBuffer();
            buffer0.append("select");
            buffer0.append("*");
            buffer0.append(" from");
            buffer0.append(" " + tableName);
            buffer0.append(" where");
            buffer0.append(" (FCompanyID=?)");
            buffer0.append(" and (FPeriodID=?)");
            prprdStmntSelect = connection.prepareStatement(buffer0.toString());
            prprdStmntSelect.setString(1, companyID);
            prprdStmntSelect.setString(2, periodID);
            resultSet = prprdStmntSelect.executeQuery();
            StringBuffer buffer1 = new StringBuffer();
            buffer1.append("insert into");
            buffer1.append(" " + tableName);
            buffer1.append(" (");
            buffer1.append(" FID");
            buffer1.append(",FBalType");
            buffer1.append(",FCompanyID");
            buffer1.append(",FPeriodID");
            buffer1.append(",FCurrencyID");
            buffer1.append(",FAsstActTypeID");
            buffer1.append(",FAsstActID");
            buffer1.append(",FBeginBalanceFor");
            buffer1.append(",FDebitFor");
            buffer1.append(",FCreditFor");
            buffer1.append(",FYearDebitFor");
            buffer1.append(",FYearCreditFor");
            buffer1.append(",FEndBalanceFor");
            buffer1.append(",FBeginBalanceLocal");
            buffer1.append(",FDebitLocal");
            buffer1.append(",FCreditLocal");
            buffer1.append(",FYearDebitLocal");
            buffer1.append(",FYearCreditLocal");
            buffer1.append(",FEndBalanceLocal");
            buffer1.append(" )");
            buffer1.append("values (");
            buffer1.append(" ?");
            buffer1.append(",?");
            buffer1.append(",?");
            buffer1.append(",?");
            buffer1.append(",?");
            buffer1.append(",?");
            buffer1.append(",?");
            buffer1.append(",?");
            buffer1.append(",?");
            buffer1.append(",?");
            buffer1.append(",?");
            buffer1.append(",?");
            buffer1.append(",?");
            buffer1.append(",?");
            buffer1.append(",?");
            buffer1.append(",?");
            buffer1.append(",?");
            buffer1.append(",?");
            buffer1.append(",?");
            buffer1.append(" )");
            prprdStmntInsert = connection.prepareStatement(buffer1.toString());
            while (resultSet.next()) {
                String newID = CommonUtils.getARAPBalanceID(system, type);
                prprdStmntInsert.setString(1, newID);
                prprdStmntInsert.setInt(2, resultSet.getInt("FBalType"));
                prprdStmntInsert.setString(3, resultSet.getString("FCompanyID"));
                prprdStmntInsert.setString(4, resultSet.getString("FPeriodID"));
                prprdStmntInsert.setString(5, resultSet.getString("FCurrencyID"));
                prprdStmntInsert.setString(6, resultSet.getString("FAsstActTypeID"));
                prprdStmntInsert.setString(7, resultSet.getString("FAsstActID"));
                prprdStmntInsert.setBigDecimal(8, resultSet.getBigDecimal("FBeginBalanceFor"));
                prprdStmntInsert.setBigDecimal(9, resultSet.getBigDecimal("FDebitFor"));
                prprdStmntInsert.setBigDecimal(10, resultSet.getBigDecimal("FCreditFor"));
                prprdStmntInsert.setBigDecimal(11, resultSet.getBigDecimal("FYearDebitFor"));
                prprdStmntInsert.setBigDecimal(12, resultSet.getBigDecimal("FYearCreditFor"));
                prprdStmntInsert.setBigDecimal(13, resultSet.getBigDecimal("FEndBalanceFor"));
                prprdStmntInsert.setBigDecimal(14, resultSet.getBigDecimal("FBeginBalanceLocal"));
                prprdStmntInsert.setBigDecimal(15, resultSet.getBigDecimal("FDebitLocal"));
                prprdStmntInsert.setBigDecimal(16, resultSet.getBigDecimal("FCreditLocal"));
                prprdStmntInsert.setBigDecimal(17, resultSet.getBigDecimal("FYearDebitLocal"));
                prprdStmntInsert.setBigDecimal(18, resultSet.getBigDecimal("FYearCreditLocal"));
                prprdStmntInsert.setBigDecimal(19, resultSet.getBigDecimal("FEndBalanceLocal"));
                prprdStmntInsert.addBatch();
            }
            prprdStmntInsert.executeBatch();
            bl = true;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(prprdStmntSelect);
                SQLUtils.cleanup(resultSet, prprdStmntInsert, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)prprdStmntSelect);
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)prprdStmntInsert, (Connection)connection);
        return bl;
    }

    public static void deleteARAPBalance(Context ctx, String system, String type, String companyID, String periodID) throws BOSException {
        String tableName = CommonUtils.getARAPBalanceTable(system, type);
        Connection connection = CommonServerUtils.getConnection(ctx);
        PreparedStatement prprdStmnt = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("delete");
            buffer.append(" " + tableName);
            buffer.append(" where");
            buffer.append(" (FCompanyID=?)");
            buffer.append(" and (FPeriodID=?)");
            String sql = buffer.toString();
            prprdStmnt = connection.prepareStatement(sql);
            prprdStmnt.setString(1, companyID);
            prprdStmnt.setString(2, periodID);
            prprdStmnt.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(prprdStmnt, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)prprdStmnt, (Connection)connection);
    }

    public static void addARAPBalance(Context ctx, String system, String type, String direction, int balType, String accountID, String companyID, String asstActTypeID, String asstActID, String currencyID, String periodID, BigDecimal amount) throws BOSException {
        boolean exist = CommonServerUtils.existARAPBalance(ctx, system, type, balType, accountID, companyID, asstActTypeID, asstActID, currencyID, periodID);
        if (!exist) {
            CommonServerUtils.insertARAPBalanceBlank(ctx, system, type, balType, direction, accountID, companyID, asstActTypeID, asstActID, currencyID, periodID);
        }
        CommonServerUtils.updateARAPBalance(ctx, system, type, balType, direction, accountID, companyID, asstActTypeID, asstActID, currencyID, periodID, amount);
    }

    private static void insertARAPBalanceBlank(Context ctx, String system, String type, int balType, String direction, String accountID, String companyID, String asstActTypeID, String asstActID, String currencyID, String periodID) throws BOSException {
        String newID = CommonUtils.getARAPBalanceID(system, type);
        String tableName = CommonUtils.getARAPBalanceTable(system, type);
        Connection connection = CommonServerUtils.getConnection(ctx);
        PreparedStatement statement = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("insert into");
            buffer.append(" " + tableName);
            buffer.append(" (");
            buffer.append(" FID");
            buffer.append(",FCompanyID");
            buffer.append(",FPeriodID");
            buffer.append(",FCurrencyID");
            buffer.append(",FAsstActTypeID");
            buffer.append(",FAsstActID");
            buffer.append(",FBeginBalanceFor");
            buffer.append(",FDebitFor");
            buffer.append(",FCreditFor");
            buffer.append(",FYearDebitFor");
            buffer.append(",FYearCreditFor");
            buffer.append(",FEndBalanceFor");
            buffer.append(",FBeginBalanceLocal");
            buffer.append(",FDebitLocal");
            buffer.append(",FCreditLocal");
            buffer.append(",FYearDebitLocal");
            buffer.append(",FYearCreditLocal");
            buffer.append(",FEndBalanceLocal");
            if (accountID != null && !accountID.equalsIgnoreCase("")) {
                buffer.append(",FAccount");
            }
            buffer.append(",FBalType");
            buffer.append(" )");
            buffer.append("values (");
            buffer.append(" ?");
            buffer.append(",?");
            buffer.append(",?");
            buffer.append(",?");
            buffer.append(",?");
            buffer.append(",?");
            buffer.append(",?");
            buffer.append(",?");
            buffer.append(",?");
            buffer.append(",?");
            buffer.append(",?");
            buffer.append(",?");
            buffer.append(",?");
            buffer.append(",?");
            buffer.append(",?");
            buffer.append(",?");
            buffer.append(",?");
            buffer.append(",?");
            if (accountID != null && !accountID.equalsIgnoreCase("")) {
                buffer.append(",?");
            }
            buffer.append(",?");
            buffer.append(" )");
            String sql = buffer.toString();
            statement = connection.prepareStatement(sql);
            statement.setString(1, newID);
            statement.setString(2, companyID);
            statement.setString(3, periodID);
            statement.setString(4, currencyID);
            statement.setString(5, asstActTypeID);
            statement.setString(6, asstActID);
            statement.setBigDecimal(7, new BigDecimal("0.0"));
            statement.setBigDecimal(8, new BigDecimal("0.0"));
            statement.setBigDecimal(9, new BigDecimal("0.0"));
            statement.setBigDecimal(10, new BigDecimal("0.0"));
            statement.setBigDecimal(11, new BigDecimal("0.0"));
            statement.setBigDecimal(12, new BigDecimal("0.0"));
            statement.setBigDecimal(13, new BigDecimal("0.0"));
            statement.setBigDecimal(14, new BigDecimal("0.0"));
            statement.setBigDecimal(15, new BigDecimal("0.0"));
            statement.setBigDecimal(16, new BigDecimal("0.0"));
            statement.setBigDecimal(17, new BigDecimal("0.0"));
            statement.setBigDecimal(18, new BigDecimal("0.0"));
            if (accountID != null && !accountID.equalsIgnoreCase("")) {
                statement.setString(19, accountID);
                statement.setInt(20, balType);
            } else {
                statement.setInt(19, balType);
            }
            statement.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)connection);
    }

    private static void updateARAPBalance(Context ctx, String system, String type, int balType, String direction, String accountID, String companyID, String asstActTypeID, String asstActID, String currencyID, String periodID, BigDecimal amounts) throws BOSException {
        String tableName = CommonUtils.getARAPBalanceTable(system, type);
        Connection connection = CommonServerUtils.getConnection(ctx);
        PreparedStatement statement = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("update");
            buffer.append(" " + tableName);
            buffer.append(" set");
            if (DEBIT.equals(direction)) {
                buffer.append(" FDebitFor=FDebitFor+?");
                buffer.append(",fyeardebitfor=fyeardebitfor+?");
            } else if (CREDIT.equals(direction)) {
                buffer.append(" FCreditFor=FCreditFor+?");
                buffer.append(",fyearcreditfor=fyearcreditfor+?");
            } else {
                throw new IllegalArgumentException("Parameter \"direction\" is error\uff01");
            }
            buffer.append(",fendbalancefor = fbeginbalancefor + fdebitfor - fcreditfor");
            buffer.append(" where");
            buffer.append(" (FCompanyID=?)");
            buffer.append(" and (FAsstActTypeID=?)");
            buffer.append(" and (FAsstActID=?)");
            buffer.append(" and (FCurrencyID=?)");
            buffer.append(" and (FPeriodID=?)");
            buffer.append(" and (FBalType=?)");
            if (accountID != null && !accountID.trim().equalsIgnoreCase("")) {
                buffer.append(" and (FAccount=?)");
            }
            String sql = buffer.toString();
            statement = connection.prepareStatement(sql);
            statement.setBigDecimal(1, amounts);
            statement.setBigDecimal(2, amounts);
            statement.setString(3, companyID);
            statement.setString(4, asstActTypeID);
            statement.setString(5, asstActID);
            statement.setString(6, currencyID);
            statement.setString(7, periodID);
            statement.setInt(8, balType);
            if (accountID != null && !accountID.trim().equalsIgnoreCase("")) {
                statement.setString(9, accountID);
            }
            statement.execute();
            statement.close();
            statement = null;
            buffer = new StringBuffer();
            buffer.append("update");
            buffer.append(" " + tableName);
            buffer.append(" set");
            buffer.append(" fendbalancefor = fbeginbalancefor + fdebitfor - fcreditfor");
            buffer.append(" where");
            buffer.append(" (FCompanyID=?)");
            buffer.append(" and (FAsstActTypeID=?)");
            buffer.append(" and (FAsstActID=?)");
            buffer.append(" and (FCurrencyID=?)");
            buffer.append(" and (FPeriodID=?)");
            buffer.append(" and (FBalType=?)");
            sql = buffer.toString();
            statement = connection.prepareStatement(sql);
            statement.setString(1, companyID);
            statement.setString(2, asstActTypeID);
            statement.setString(3, asstActID);
            statement.setString(4, currencyID);
            statement.setString(5, periodID);
            statement.setInt(6, balType);
            statement.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)connection);
    }

    /*
     * Unable to fully structure code
     */
    private static boolean existARAPBalance(Context ctx, String system, String type, int balType, String accountID, String companyID, String asstActTypeID, String asstActID, String currencyID, String periodID) throws BOSException {
        block7: {
            tableName = CommonUtils.getARAPBalanceTable(system, type);
            connection = CommonServerUtils.getConnection(ctx);
            statement = null;
            resultSet = null;
            buffer = new StringBuffer();
            buffer.append("select");
            buffer.append(" FID");
            buffer.append(" from");
            buffer.append(" " + tableName);
            buffer.append(" where ");
            buffer.append(" (FCompanyID=?)");
            buffer.append(" and (FAsstActTypeID=?)");
            buffer.append(" and (FAsstActID=?)");
            buffer.append(" and (FCurrencyID=?)");
            buffer.append(" and (FPeriodID=?)");
            buffer.append(" and (FBalType=?)");
            if (accountID != null && !accountID.trim().equalsIgnoreCase("")) {
                buffer.append(" and (FAccount=?)");
            }
            sql = buffer.toString();
            statement = connection.prepareStatement(sql);
            statement.setString(1, companyID);
            statement.setString(2, asstActTypeID);
            statement.setString(3, asstActID);
            statement.setString(4, currencyID);
            statement.setString(5, periodID);
            statement.setInt(6, balType);
            if (accountID != null && !accountID.trim().equalsIgnoreCase("")) {
                statement.setString(7, accountID);
            }
            if (!(resultSet = statement.executeQuery()).next()) ** GOTO lbl50
            if (resultSet.next()) break block7;
            var16_17 = true;
            SQLUtils.cleanup((ResultSet)resultSet, (Statement)statement, (Connection)connection);
            return var16_17;
        }
        try {
            throw new IllegalArgumentException("Data is error!");
lbl50:
            // 1 sources

            var16_18 = false;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable var17_19) {
                SQLUtils.cleanup(resultSet, statement, (Connection)connection);
                throw var17_19;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)statement, (Connection)connection);
        return var16_18;
    }

    public static boolean isARBySaleInvouce(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyID = company.getId().toString();
        return CommonServerUtils.isARBySaleInvouce(ctx, companyID);
    }

    public static boolean isARBySaleInvouce(Context ctx, String companyID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        ARParamEnum aRParamEnum = ARParamEnum.AR_BY_INV_001;
        String value = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)pk, aRParamEnum.getValue());
        if (value == null) {
            return CommonServerUtils.getDefaulParam(ctx, aRParamEnum.getValue(), SUB_SYSTEM_AR);
        }
        return value.equalsIgnoreCase("true") || value.equals(TRUE_VAL);
    }

    public static boolean isAPByPurchaseInvoice(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyID = company.getId().toString();
        return CommonServerUtils.isAPByPurchaseInvoice(ctx, companyID);
    }

    public static boolean isAPByPurchaseInvoice(Context ctx, String companyID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        APParamEnum aPParamEnum = APParamEnum.AP_BY_INV_001;
        String value = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)pk, aPParamEnum.getValue());
        if (value == null) {
            return CommonServerUtils.getDefaulParam(ctx, aPParamEnum.getValue(), SUB_SYSTEM_AP);
        }
        return value.equalsIgnoreCase("true") || value.equals(TRUE_VAL);
    }

    private static boolean getDefaulParam(Context ctx, String number, String system) throws BOSException, EASBizException {
        IParam iParam = ParamFactory.getLocalInstance((Context)ctx);
        StringBuffer oql = new StringBuffer("");
        oql.append(" select * where number ='").append(number).append("'");
        oql.append(" and subSysID ='").append(system).append("'");
        ParamCollection paramCollection = iParam.getParamCollection(oql.toString());
        ParamInfo paramInfo = null;
        if (paramCollection != null) {
            paramInfo = paramCollection.get(0);
            if (paramInfo != null) {
                return "true".equalsIgnoreCase(paramInfo.getDefaultValue()) || TRUE_VAL.equals(paramInfo.getDefaultValue());
            }
            return true;
        }
        return true;
    }

    public static boolean isARRelationSCM(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyID = company.getId().toString();
        return CommonServerUtils.isARRelationSCM(ctx, companyID);
    }

    public static boolean isARRelationSCM(Context ctx, String companyID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        ARParamEnum aRParamEnum = ARParamEnum.AR_SCM_001;
        String value = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)pk, aRParamEnum.getValue());
        if (value == null) {
            return CommonServerUtils.getDefaulParam(ctx, aRParamEnum.getValue(), SUB_SYSTEM_AR);
        }
        return value.equalsIgnoreCase("true") || value.equals(TRUE_VAL);
    }

    public static boolean isAPRelationSCM(Context ctx, String companyID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        APParamEnum aPParamEnum = APParamEnum.AP_SCM_001;
        String value = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)pk, aPParamEnum.getValue());
        if (value == null) {
            return CommonServerUtils.getDefaulParam(ctx, aPParamEnum.getValue(), SUB_SYSTEM_AP);
        }
        return value.equalsIgnoreCase("true") || value.equals(TRUE_VAL);
    }

    public static boolean isARCheckVoucher(Context ctx, String companyID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        ARParamEnum aRParamEnum = ARParamEnum.AR_CHECK_VOUCHER_001;
        String value = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)pk, aRParamEnum.getValue());
        if (value == null) {
            return CommonServerUtils.getDefaulParam(ctx, aRParamEnum.getValue(), SUB_SYSTEM_AR);
        }
        return value.equalsIgnoreCase("true") || value.equals(TRUE_VAL);
    }

    public static boolean isAPCheckVoucher(Context ctx, String companyID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        APParamEnum aPParamEnum = APParamEnum.AP_CHECK_VOUCHER_001;
        String value = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)pk, aPParamEnum.getValue());
        if (value == null) {
            return CommonServerUtils.getDefaulParam(ctx, aPParamEnum.getValue(), SUB_SYSTEM_AP);
        }
        return value.equalsIgnoreCase("true") || value.equals(TRUE_VAL);
    }

    public static boolean isDisplayLocalCurrency(Context ctx) throws BOSException, EASBizException {
        String value = ParamManager.getSpecialParamValue((Context)ctx, (String)"DISPLAY_LOCAL_CURRENCY");
        if (value != null) {
            value = value.trim();
        }
        return "true".equalsIgnoreCase(value);
    }

    public static void updateArApContrastAccount(Context ctx, String companyID, String accountTableID, String accountID) throws BOSException, EASBizException {
        if (accountTableID == null || accountID == null) {
            return;
        }
        AsstActTypeInfo asstActType = CommonServerUtils.getAsstActTypeByAccountView(ctx, accountID, companyID);
        StringBuffer buffer = new StringBuffer("");
        if (asstActType == null) {
            buffer.append(" update t_ar_contrastaccountview set FAsstActTypeID = null ").append(RT);
            buffer.append(" where faccounttableid='").append(accountTableID).append("'").append(RT);
            buffer.append(" and FCompanyID='").append(companyID).append("'").append(RT);
            buffer.append(" and faccountid='").append(accountID).append("'").append(RT);
        } else {
            buffer.append(" update t_ar_contrastaccountview set FAsstActTypeID = '").append(asstActType.getId().toString()).append("'").append(RT);
            buffer.append(" where faccounttableid='").append(accountTableID).append("'").append(RT);
            buffer.append(" and FCompanyID='").append(companyID).append("'").append(RT);
            buffer.append(" and faccountid='").append(accountID).append("'").append(RT);
        }
        DbUtil.execute((Context)ctx, (String)buffer.toString());
    }

    public static void isARAPAccount(Context ctx, String companyID, String accountTableID, String accountID, int system) throws BOSException, EASBizException {
        int periodNumber;
        if (system != 1 && system != 2) {
            return;
        }
        AccountViewInfo acctViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)accountID)));
        AccountTableInfo acctTableInfo = new AccountTableInfo();
        acctTableInfo.setId(BOSUuid.read((String)accountTableID));
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyID));
        IContrastAccountView iContrastAcctView = ContrastAccountViewFactory.getLocalInstance((Context)ctx);
        PeriodInfo currPeriod = null;
        currPeriod = system == 1 ? SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)company) : SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)company);
        if (currPeriod == null) {
            return;
        }
        int year = currPeriod.getPeriodYear();
        if (!CommonServerUtils.existContrastAccount(ctx, companyID, accountTableID, accountID, system, year, periodNumber = currPeriod.getPeriodNumber())) {
            ContrastAccountViewInfo info = new ContrastAccountViewInfo();
            info.setAccount(acctViewInfo);
            info.setAccountTableID(acctTableInfo);
            info.setName(acctViewInfo.getName());
            info.setSystem(system);
            info.setCompany(company);
            info.setPeriodYear(year);
            info.setPeriodNumber(periodNumber);
            info.setDefaultAsstActType(CommonServerUtils.getAsstActTypeByAccountView(ctx, acctViewInfo.getId().toString(), companyID));
            iContrastAcctView.submit((CoreBaseInfo)info);
        }
    }

    private static boolean existContrastAccount(Context ctx, String companyID, String accountTableID, String accountID, int system, int year, int periodNumber) throws BOSException, EASBizException {
        boolean exist = false;
        StringBuffer sb = new StringBuffer("");
        sb.append("select fid from T_AR_ContrastAccountView where \r\t");
        sb.append(" FAccountTableID='").append(accountTableID).append("' \r\t");
        sb.append(" and FCompanyID='").append(companyID).append("' \r\t");
        sb.append(" and FAccountID='").append(accountID).append("' \r\t");
        sb.append(" and FSystem = ").append(system).append(" \r\t");
        sb.append(" and FPeriodYear ='").append(year).append("' \r\t");
        sb.append(" and FPeriodNumber ='").append(periodNumber).append("'");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs.next()) {
                exist = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return exist;
    }

    private static AsstActTypeInfo getAsstActTypeByAccountView(Context ctx, String accountId, String companyID) throws BOSException, EASBizException {
        AsstActTypeCollection asstCol = ContrastAccountViewFactory.getLocalInstance((Context)ctx).getAsstActType(accountId, companyID);
        if (asstCol.size() == 0) {
            return null;
        }
        AsstActTypeInfo info = asstCol.get(0);
        for (int i = 1; i < asstCol.size(); ++i) {
            AsstActTypeInfo nextInfo = asstCol.get(i);
            String nextHgType = nextInfo.getAsstHGAttribute();
            String infoHgType = info.getAsstHGAttribute();
            if (infoHgType.equals("customer")) break;
            if (infoHgType.equals("provider") && nextHgType.equals("customer")) {
                info = nextInfo;
                continue;
            }
            if (infoHgType.equals("adminOrg") && (nextHgType.equals("provider") || nextHgType.equals("customer"))) {
                info = nextInfo;
                continue;
            }
            if (infoHgType.equals("person") && (nextHgType.equals("provider") || nextHgType.equals("customer") || nextHgType.equals("adminOrg"))) {
                info = nextInfo;
                continue;
            }
            if (!nextHgType.equals("provider") && !nextHgType.equals("customer") && !nextHgType.equals("adminOrg") && !nextHgType.equals("person")) continue;
            info = nextInfo;
        }
        return info;
    }

    public static void deleteBalanceData(Context ctx, String tableName, String companyId, PeriodInfo period) throws BOSException {
        StringBuilder deleteSQL = new StringBuilder(100);
        deleteSQL.append("Delete from ").append(tableName).append(" where FCompanyID = '").append(companyId).append("' and FPeriodID = '").append(period.getIdentity().toString()).append("'");
        DbUtil.execute((Context)ctx, (String)deleteSQL.toString());
    }

    public static CoreBaseCollection getGainAndLossVeriBill(Context ctx, boolean fAR, boolean fRecPay2Vou, boolean fPreAcctVou, String companyId, Set veriBillSet) throws BOSException, EASBizException {
        IVerificationBillBase iVeriBill = null;
        iVeriBill = fAR ? VerificationBillFactory.getLocalInstance(ctx) : com.kingdee.eas.fi.ap.VerificationBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("entrys.billSubType"));
        view.getSelector().add(new SelectorItemInfo("entrys.billType"));
        view.getSelector().add(new SelectorItemInfo("entrys.veriType"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isSameCurrency", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("gainAndLoss", (Object)0, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)veriBillSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("verificationType", (Object)(fAR ? 101 : 201), CompareType.EQUALS));
        view.setFilter(filter);
        CoreBaseCollection coll = iVeriBill.getCollection(view);
        if (!fRecPay2Vou || fPreAcctVou) {
            VerificationBillBaseInfo baseInfo = null;
            VerificationBillBaseEntryInfo entryInfo = null;
            IObjectCollection entryColl = null;
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                baseInfo = (VerificationBillBaseInfo)it.next();
                entryColl = (IObjectCollection)baseInfo.get("entrys");
                if (entryColl == null) continue;
                boolean isPreBill = false;
                boolean isSalePurBill = false;
                int size = entryColl.size();
                for (int i = 0; i < size; ++i) {
                    entryInfo = (VerificationBillBaseEntryInfo)entryColl.getObject(i);
                    isPreBill = isPreBill || VerificateBillTypeEnum.REC_AR_PRE_REC.equals((Object)entryInfo.getBillSubType()) || VerificateBillTypeEnum.REC_AR_REFUNDMENT_PRE_REC.equals((Object)entryInfo.getBillSubType()) || VerificateBillTypeEnum.PAY_AP_PRE_PAYMENT.equals((Object)entryInfo.getBillSubType()) || VerificateBillTypeEnum.PAY_AP_REFUNDMENT_PRE_PAYMENT.equals((Object)entryInfo.getBillSubType());
                    isSalePurBill = isSalePurBill || VerificateBillTypeEnum.REC_AR_SELL_REC.equals((Object)entryInfo.getBillSubType()) || VerificateBillTypeEnum.REC_AR_REFUNDMENT_SELL_REC.equals((Object)entryInfo.getBillSubType()) || VerificateBillTypeEnum.PAY_AP_STOCK_PAYMENT.equals((Object)entryInfo.getBillSubType()) || VerificateBillTypeEnum.PAY_AP_REFUNDMENT_STOCK_PAYMENT.equals((Object)entryInfo.getBillSubType());
                }
                if (fPreAcctVou && isPreBill) {
                    it.remove();
                    continue;
                }
                if (entryInfo == null || fRecPay2Vou || (entryInfo.isVeriType() || !isSalePurBill) && (!entryInfo.isVeriType() || !VerificateBillTypeEnum.ReceiveBill.equals((Object)entryInfo.getBillType()) && !VerificateBillTypeEnum.PaymentBill.equals((Object)entryInfo.getBillType()))) continue;
                it.remove();
            }
        }
        CoreBaseCollection result = new CoreBaseCollection();
        result.addCollection(coll);
        return result;
    }

    public static String getSpecialNotVoucherApBillSql(String companyId, String beginDateStr, String endDateStr) throws BOSException, EASBizException {
        StringBuilder sqlBuilder = new StringBuilder(100);
        sqlBuilder.append("select bill.fid as FID from T_ap_otherbill bill");
        sqlBuilder.append(" INNER JOIN T_SCM_BizType type");
        sqlBuilder.append(" ON BILL.FBIZTYPEID = TYPE.FID");
        sqlBuilder.append(" where bill.FCompanyID='" + companyId + "'");
        sqlBuilder.append(" and bill.FBILLTYPE = 202");
        sqlBuilder.append(" and bill.FSOURCEBILLTYPE = 12");
        if (!StringUtils.isEmpty((String)beginDateStr)) {
            sqlBuilder.append(" and bill.FBillDate>={" + beginDateStr + "}");
        }
        if (!StringUtils.isEmpty((String)endDateStr)) {
            sqlBuilder.append(" and bill.FBillDate<{" + endDateStr + "}");
        }
        sqlBuilder.append(" and type.FNUMBER not in ('130', '131', '140', '141')");
        return sqlBuilder.toString();
    }

    public static String getSpecialNotVoucherApBillWidthNotDateSql(String companyId) throws BOSException, EASBizException {
        return CommonServerUtils.getSpecialNotVoucherApBillSql(companyId, null, null);
    }

    public static Set<String> getSpecialNotVoucherApBill(Context ctx, String companyId, String beginDateStr, String endDateStr) throws BOSException, EASBizException {
        HashSet<String> billIdSet = new HashSet<String>();
        String sql = CommonServerUtils.getSpecialNotVoucherApBillSql(companyId, beginDateStr, endDateStr);
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (result.next()) {
                billIdSet.add(result.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return billIdSet;
    }

    public static boolean isFromSmartAccount() {
        if (BOSObjectFactory.getContextFromThread() != null) {
            Boolean isSmartAccounting = BOSObjectFactory.getContextFromThread().get((Object)"isSmartAccounting") == null ? false : Boolean.parseBoolean(BOSObjectFactory.getContextFromThread().get((Object)"isSmartAccounting").toString());
            Boolean isBack = BOSObjectFactory.getContextFromThread().get((Object)"isBack") == null ? false : Boolean.parseBoolean(BOSObjectFactory.getContextFromThread().get((Object)"isBack").toString());
            if (isSmartAccounting.booleanValue() && isBack.booleanValue()) {
                return true;
            }
        }
        return false;
    }

    public static boolean isFromSCMRobotAuto(Context ctx) {
        Boolean isBack = (Boolean)ctx.get((Object)"isBack");
        return isBack != null && isBack != false;
    }

    public static boolean getOptionConfig4User(Context ctx, String className, String configTypeValue) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        FilterItemInfo billClassNameFilter = new FilterItemInfo("billClassName", (Object)className, CompareType.EQUALS);
        FilterItemInfo userIDFilter = new FilterItemInfo("userID", (Object)userId, CompareType.EQUALS);
        FilterItemInfo configTypeFilter = new FilterItemInfo("configType", (Object)configTypeValue, CompareType.EQUALS);
        filter.getFilterItems().add(billClassNameFilter);
        filter.getFilterItems().add(userIDFilter);
        filter.getFilterItems().add(configTypeFilter);
        filter.setMaskString("#0 AND #1 AND #2");
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        ev.setSelector(SCMSelectorFactory.getSMSDBillConfigSelector());
        SMSDBillConfigCollection cfgCol = SMSDBillConfigFactory.getLocalInstance((Context)ctx).getSMSDBillConfigCollection(ev);
        if (null != cfgCol && cfgCol.size() > 0) {
            return TRUE_VAL.equals(cfgCol.get(0).getConfigValue());
        }
        return false;
    }

    public static StringBuilder getBillAccountBalanceInsertSQL(String tableName) {
        StringBuilder buf = new StringBuilder(500).append(SQL_INSERT).append(tableName).append(LOGIC_LEFT_BRACKET).append(RT).append(BALANCE_TABLE_COLUMNS).append(LOGIC_RIGHT_BRACKET).append(RT);
        return buf;
    }

    public static void copyBillAccountBalanceData(Context ctx, String fromTable, String toTable, String companyID, String periodID) throws BOSException {
        StringBuilder buf = CommonServerUtils.getBillAccountBalanceInsertSQL(toTable);
        buf.append(SQL_SELECT).append(BALANCE_TABLE_COLUMNS).append(RT).append(SQL_FROM).append(fromTable).append(RT).append(SQL_WHERE).append(" FCOMPANYID = '").append(companyID).append("'").append(RT).append(SQL_AND).append(" FPERIODID = '").append(periodID).append("' ").append(RT).append(SQL_AND).append(" FISDELETED = 0 ");
        KsqlUtil.execute((Context)ctx, (String)buf.toString());
    }

    public static void copyBillAccountBalanceDataForContrast(Context ctx, String fromTable, String toTable, String companyID, String periodID) throws BOSException {
        StringBuilder buf = CommonServerUtils.getBillAccountBalanceInsertSQL(toTable);
        buf.append(SQL_SELECT).append("FID, FBALTYPE, FCOMPANYID, FPERIODID, FCURRENCYID, FBEGINBALANCEFOR,  \r\n 0, 0, FYEARDEBITFOR, FYEARCREDITFOR,  \r\n 0, FBEGINBALANCELOCAL, 0,  \r\n 0, FYEARDEBITLOCAL, FYEARCREDITLOCAL,  \r\n 0, FASSTACTTYPEID, FASSTACTID,  \r\n FACCOUNT, FADMINORGUNITID, FPERSONID ").append(RT).append(SQL_FROM).append(fromTable).append(RT).append(SQL_WHERE).append(" FCOMPANYID = '").append(companyID).append("'").append(RT).append(SQL_AND).append(" FPERIODID = '").append(periodID).append("' ").append(RT).append(SQL_AND).append(" FISDELETED = 0 ");
        KsqlUtil.execute((Context)ctx, (String)buf.toString());
    }

    public static String computeBillAccountBalance(Context ctx, PeriodInfo period, CompanyOrgUnitInfo companyInfo, ContrastGLQueryParam param, boolean fAR) throws BOSException, EASBizException {
        param.setByBillSum(false);
        param.setBySum(false);
        param.setCalculateOpposite(false);
        ArApBillAccountBalanceCalculator caculator = ArApBalanceCalculatorFactory.getArApBillAccountBalanceCalculator(ctx, fAR, param);
        caculator.calculate(companyInfo.getId().toString(), period, OperationTypeEnum.Positive, true);
        if (param.isQueryAll()) {
            param.setCalculateOpposite(true);
            ArApBillAccountBalanceCalculator otherCaculator = ArApBalanceCalculatorFactory.getArApBillAccountBalanceCalculator(ctx, !fAR, param);
            otherCaculator.calculate(companyInfo.getId().toString(), period, OperationTypeEnum.Positive, true);
        }
        return param.getFinalAcctBalTable();
    }

    public static String defineContrastTempTbl(boolean isGUI) {
        StringBuilder buf = new StringBuilder(200);
        buf.append("(FAccount nvarchar(100), FAccountID varchar(44), ").append(RT);
        buf.append(" FCurrencyID nvarchar(44), ").append(RT);
        buf.append(" FCurrency nvarchar(100), FCussTypeID nvarchar(100), ").append(RT).append(" FCussType nvarchar(400), FCussAcct nvarchar(100), ").append(RT).append(" FCussNum nvarchar(100), FCussName nvarchar(400), ").append(RT).append(" FArStartAmt decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FGLStartAmt decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FStartDiffAmt decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FArDebitAmt decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FGLDebitAmt decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FDebitDiffAmt decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FArCreditAmt decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FGLCreditAmt decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FCreditDiffAmt decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FArBalanceAmt decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FGLBalanceAmt decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FBalanceDiffAmt decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT);
        if (isGUI) {
            buf.append(" FCurrencyLocal nvarchar(100),  ").append(" FArStartAmtLocal decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FGLStartAmtLocal decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FStartDiffAmtLocal decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FArDebitAmtLocal decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FGLDebitAmtLocal decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FDebitDiffAmtLocal decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FArCreditAmtLocal decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FGLCreditAmtLocal decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FCreditDiffAmtLocal decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FArBalanceAmtLocal decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FGLBalanceAmtLocal decimal(28, 10) NOT NULL DEFAULT 0, ").append(RT).append(" FBalanceDiffAmtLocal decimal(28, 10) NOT NULL DEFAULT 0,").append(RT);
        }
        buf.append(" FIsSum int DEFAULT 0 ");
        if (!isGUI) {
            buf.append(", Fisdiff int default 0");
        }
        buf.append(")").append(RT);
        return buf.toString();
    }

    public static ContrastGLQueryParam getContrastParam(Context ctx, String companyId, boolean fAR, PeriodInfo currentPeriod, boolean isCloseAccount) throws BOSException, EASBizException {
        int system;
        String accountTableID = null;
        IContrastAccountView iContrastAccountView = ContrastAccountViewFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        int n = system = fAR ? 1 : 2;
        if (companyInfo.getAccountTable() != null) {
            accountTableID = AccountTools.getCurrentAcctTable((Context)ctx, (String)companyId, (String)companyInfo.getAccountTable().getId().toString(), (int)currentPeriod.getPeriodYear(), (int)currentPeriod.getPeriodNumber());
        }
        AccountViewCollection accountViewColl = (AccountViewCollection)iContrastAccountView.getContrastAccount(system, companyInfo, accountTableID, currentPeriod.getPeriodYear(), currentPeriod.getPeriodNumber(), isCloseAccount);
        ArrayList<BOSUuid> idFormula = new ArrayList<BOSUuid>();
        ArrayList<String> nameFormula = new ArrayList<String>();
        for (int i = 0; i < accountViewColl.size(); ++i) {
            AccountViewInfo accountInfo = accountViewColl.get(i);
            if (accountInfo == null || idFormula.contains(accountInfo.getId())) continue;
            idFormula.add(accountInfo.getId());
            String nameStr = accountInfo.getName() + ";" + accountInfo.getNumber();
            if (accountInfo.getCAA() != null) {
                nameStr = nameStr + ";" + accountInfo.getCAA().getString("id");
            }
            nameFormula.add(nameStr);
        }
        ContrastGLQueryParam param = new ContrastGLQueryParam();
        param.setCompanyId(companyInfo.getId().toString());
        param.setCuId(companyInfo.getCU().getString("id"));
        param.setBySum(false);
        param.setByBillSum(false);
        param.setContrastByBillAccount(true);
        param.setAcctFormula(idFormula);
        param.setAcctNameFormula(nameFormula);
        param.setCurrencyId("all");
        Set oppositeAccountIdSet = ContrastGLFacadeFactory.getLocalInstance(ctx).getOppositeAccountIdSet(new HashSet(idFormula), currentPeriod.getPeriodYear(), currentPeriod.getPeriodNumber(), fAR);
        boolean isEmpty = null == oppositeAccountIdSet || oppositeAccountIdSet.size() == 0;
        param.setQueryAll(!isEmpty);
        param.setOppositeAccountIdSet(oppositeAccountIdSet);
        param.setHasItem(true);
        param.setHasUnRegVoucher(true);
        param.setPeriodNum(currentPeriod.getNumber());
        param.setCloseAccount(isCloseAccount);
        return param;
    }

    static {
        mainMap.put(String.valueOf(101), String.valueOf(8));
        secondMap.put(String.valueOf(101), String.valueOf(6));
        mainMap.put(String.valueOf(107), String.valueOf(8));
        secondMap.put(String.valueOf(107), String.valueOf(6));
        mainMap.put(String.valueOf(103), String.valueOf(8));
        secondMap.put(String.valueOf(103), String.valueOf(9));
        mainMap.put(String.valueOf(109), String.valueOf(8));
        secondMap.put(String.valueOf(109), String.valueOf(9));
        mainMap.put(String.valueOf(104), String.valueOf(6));
        secondMap.put(String.valueOf(104), String.valueOf(4));
        mainMap.put(String.valueOf(110), String.valueOf(6));
        secondMap.put(String.valueOf(110), String.valueOf(4));
        mainMap.put(String.valueOf(111), String.valueOf(15));
        secondMap.put(String.valueOf(111), String.valueOf(6));
        mainMap.put(String.valueOf(112), String.valueOf(15));
        secondMap.put(String.valueOf(112), String.valueOf(6));
        mainMap.put(String.valueOf(113), String.valueOf(6));
        secondMap.put(String.valueOf(113), String.valueOf(4));
        mainMap.put(String.valueOf(114), String.valueOf(6));
        secondMap.put(String.valueOf(114), String.valueOf(4));
        mainMap.put(String.valueOf(201), String.valueOf(9));
        secondMap.put(String.valueOf(201), String.valueOf(4));
        mainMap.put(String.valueOf(207), String.valueOf(9));
        secondMap.put(String.valueOf(207), String.valueOf(4));
        mainMap.put(String.valueOf(203), String.valueOf(9));
        secondMap.put(String.valueOf(203), String.valueOf(8));
        mainMap.put(String.valueOf(209), String.valueOf(9));
        secondMap.put(String.valueOf(209), String.valueOf(8));
        mainMap.put(String.valueOf(204), String.valueOf(4));
        secondMap.put(String.valueOf(204), String.valueOf(6));
        mainMap.put(String.valueOf(210), String.valueOf(4));
        secondMap.put(String.valueOf(210), String.valueOf(6));
        mainMap.put(String.valueOf(211), String.valueOf(4));
        secondMap.put(String.valueOf(211), String.valueOf(6));
        mainMap.put(String.valueOf(212), String.valueOf(4));
        secondMap.put(String.valueOf(212), String.valueOf(6));
    }
}

