/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.IPayCondition;
import com.kingdee.eas.basedata.assistant.PayConditionFactory;
import com.kingdee.eas.basedata.assistant.PayConditionInfo;
import com.kingdee.eas.basedata.master.account.AccountControlAttribute;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSalerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerSaleInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.sd.sale.ForbidStatusEnum;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceParam;
import com.kingdee.eas.basedata.scm.sd.sale.ISalePerson;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamInfo;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupInfo;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonCollection;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ContrastAccountViewFactory;
import com.kingdee.eas.fi.ar.IContrastAccountView;
import com.kingdee.eas.fi.ar.IOtherBill;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.ar.app.web.ArApBillService;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.web.BaseService;
import com.kingdee.eas.fi.arap.app.web.CodeRuleHelper;
import com.kingdee.eas.fi.arap.util.PlanHelper;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurServiceFacadeFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ARBillService
extends ArApBillService {
    public static final String STATUS_ADDNEW = "ADDNEW";
    public static final String STATUS_EDIT = "EDIT";
    public static final String STATUS_VIEW = "VIEW";
    public static final String STATUS_FINDVIEW = "FINDVIEW";
    private Context ctx;

    public ARBillService(Context ctx) {
        ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
        this.ctx = ctx;
    }

    @Override
    public Context getContext() {
        return this.ctx;
    }

    public Map<String, Object> getCostCenterUnit(String adminOrgUnitId, String companyOrgUnitId) throws EASBizException, BOSException {
        OrgUnitCollection costCenterCollectionByOrg;
        IOrgUnitRelation iUtilRel = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
        OrgUnitCollection costCenterCollection = iUtilRel.getToUnit(adminOrgUnitId, 0, 5);
        if (costCenterCollection.size() > 0 && (costCenterCollectionByOrg = iUtilRel.getFromUnit(companyOrgUnitId, 1, 5)).contains(costCenterCollection.get(0))) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("costCenterUnit", costCenterCollection.get(0));
            return result;
        }
        return null;
    }

    @Override
    public Map<String, Object> getUIcache(String companyid, String status, Map otherInformation) throws EASBizException, BOSException {
        HashMap map = (HashMap)super.getUIcache(companyid, status, otherInformation);
        return map;
    }

    @Override
    protected String getProjectFilter(String companyid) throws EASBizException, BOSException {
        BaseService f7Service = new BaseService(this.getContext());
        return f7Service.getProjectF7Filer(companyid);
    }

    @Override
    protected String getTracknumberFilter(String companyid) throws EASBizException, BOSException {
        BaseService f7Service = new BaseService(this.getContext());
        return f7Service.getTrackNumberF7Filer(companyid, null);
    }

    @Override
    protected String getPermissionItemByStatus(String status) {
        if (STATUS_ADDNEW.equals(status)) {
            return "fi_ar_ArOtherBill_Add";
        }
        if (STATUS_EDIT.equals(status)) {
            return "fi_ar_ArOtherBill_Update";
        }
        if (STATUS_VIEW.equals(status) || STATUS_FINDVIEW.equals(status)) {
            return "fi_ar_ArOtherBill_View";
        }
        return "fi_ar_ArOtherBill_Add";
    }

    public Map getParamValueMap(String[] prams, String orgId) throws EASBizException, BOSException {
        return ParamControlFactory.getLocalInstance((Context)this.ctx).getParamHashMap(prams, orgId);
    }

    private Map getAdminOrgUnitByPerson(String personId, String saleOrgId, String companyid) throws BOSException, EASBizException {
        IOrgUnitRelation iUtilRel;
        OrgUnitCollection adminOrgCollection;
        boolean isbilldepart;
        OrgUnitInfo info = null;
        Map map = this.getParamValueMap(new String[]{"AR_BILL_DEPART", "AR_BILL_DEPART"}, companyid);
        boolean bl = isbilldepart = map.containsKey("AR_BILL_DEPART") ? Boolean.valueOf((String)map.get("AR_BILL_DEPART")) : true;
        if (isbilldepart && personId != null) {
            EntityViewInfo viewIn = new EntityViewInfo();
            FilterInfo filterIn = new FilterInfo();
            filterIn.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
            filterIn.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)Boolean.TRUE));
            viewIn.setFilter(filterIn);
            SelectorItemCollection selectorAdmin = new SelectorItemCollection();
            selectorAdmin.add(new SelectorItemInfo("position.adminOrgUnit.id"));
            selectorAdmin.add(new SelectorItemInfo("position.adminOrgUnit.number"));
            selectorAdmin.add(new SelectorItemInfo("position.adminOrgUnit.name"));
            viewIn.setSelector(selectorAdmin);
            IPositionMember iPositionMember = PositionMemberFactory.getLocalInstance((Context)this.ctx);
            PositionMemberCollection positionColl = iPositionMember.getPositionMemberCollection(viewIn);
            if (positionColl.size() > 0) {
                info = positionColl.get(0).getPosition().getAdminOrgUnit();
            }
        } else if (saleOrgId != null && (adminOrgCollection = (iUtilRel = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx)).getToUnit(saleOrgId, 2, 0)).size() > 0) {
            info = adminOrgCollection.get(0);
        }
        HashMap<String, OrgUnitInfo> result = new HashMap<String, OrgUnitInfo>();
        result.put("adminOrgUnitInfo", info);
        return result;
    }

    public Map<String, Object> getAdminOrgUnitBySaleOrgUnit(String saleOrgUnitId) throws EASBizException, BOSException {
        IOrgUnitRelation iUtilRel;
        OrgUnitCollection toUnit;
        AdminOrgUnitInfo info = null;
        if (!StringUtils.isEmpty((String)saleOrgUnitId) && (toUnit = (iUtilRel = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx)).getToUnit(saleOrgUnitId, 2, 0)).size() > 0) {
            info = (AdminOrgUnitInfo)toUnit.get(0);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("adminOrgUnitInfo", info);
        return result;
    }

    public Map<String, Object> fetchSalePrice(Map config) throws EASBizException, BOSException {
        IPriceParam iPriceParam = PriceParamFactory.getLocalInstance((Context)this.ctx);
        PriceParamInfo priceParamInfo = iPriceParam.getParameter(config.get("").toString());
        HashMap<String, Object> result = new HashMap<String, Object>();
        return result;
    }

    public Map<String, Object> fetchPrice(Object config) throws EASBizException, BOSException {
        PurPriceParamCollection paramCol = this.getParamCol((Map)config);
        PurPriceInfoCollection priceInfoCol = PurServiceFacadeFactory.getLocalInstance((Context)this.ctx).fetchPrice(paramCol);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("priceInfoCol", priceInfoCol);
        return result;
    }

    private PurPriceParamCollection getParamCol(Map config) throws EASBizException, BOSException {
        PurPriceParamCollection paramCol = new PurPriceParamCollection();
        String billTypeId = "510b6503-0105-1000-e000-010fc0a812fd463ED552";
        paramCol.setBillTypeId(billTypeId);
        paramCol.setMerge(((Boolean)config.get("isMerge")).booleanValue());
        paramCol.setSource((String)config.get("source"));
        String bizTypeId = (String)config.get("bizTypeId");
        if (!StringUtils.isEmpty((String)bizTypeId)) {
            paramCol.setBizTypeId(bizTypeId);
        }
        ArrayList paramArr = (ArrayList)config.get("paramArr");
        int len = paramArr.size();
        for (int i = 0; i < len; ++i) {
            PurPriceParam param = this.getParamInfo((Map)paramArr.get(i), billTypeId, bizTypeId);
            paramCol.addPurPriceParam(param);
        }
        return paramCol;
    }

    private PurPriceParam getParamInfo(Map config, String billTypeId, String bizTypeId) throws EASBizException, BOSException {
        PurPriceParam param = new PurPriceParam();
        try {
            ObjectUuidPK pk = null;
            if (!StringUtils.isEmpty((String)bizTypeId)) {
                String bizCategoryId;
                pk = new ObjectUuidPK(bizTypeId);
                BizTypeInfo bizType = BizTypeFactory.getLocalInstance((Context)this.ctx).getBizTypeInfo((IObjectPK)pk);
                if (bizType.getBizCategory() != null && ((bizCategoryId = bizType.getBizCategory().getId().toString()).equals("+f4mYqj4xUGaNf69/HWRdqk4kCA=") || bizCategoryId.equals("6LFeB81CJ0mD3wyAekUV7Kk4kCA="))) {
                    param.setMaterialPurchaseType(1);
                }
            }
            param.setBillTypeId(billTypeId);
            if (config.get("seq") != null) {
                param.setSeq(((Double)config.get("seq")).intValue());
            }
            param.setInTax(((Boolean)config.get("isInTax")).booleanValue());
            String purOrgUnitId = (String)config.get("purOrgUnitId");
            String currencyId = (String)config.get("currencyId");
            param.setPurOrgUnitId(StringUtils.isEmpty((String)purOrgUnitId) ? null : purOrgUnitId);
            param.setCurrencyId(StringUtils.isEmpty((String)currencyId) ? null : currencyId);
            param.setSupplierId((String)config.get("asstActId"));
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            param.setBizDate(df.parse((String)config.get("bizDate")));
            String materialId = (String)config.get("materialId");
            String unitId = (String)config.get("unitId");
            String receiveOrgUnitId = (String)config.get("recOrgUnitId");
            String asstAttrId = (String)config.get("assistPropertyId");
            param.setMaterialId(StringUtils.isEmpty((String)materialId) ? null : materialId);
            param.setUnitId(StringUtils.isEmpty((String)unitId) ? null : unitId);
            pk = new ObjectUuidPK(materialId);
            MaterialInfo material = MaterialFactory.getLocalInstance((Context)this.ctx).getMaterialInfo((IObjectPK)pk);
            param.setBaseUnitId(material.getBaseUnit().getId().toString());
            param.setRecOrgUnitId(StringUtils.isEmpty((String)receiveOrgUnitId) ? null : receiveOrgUnitId);
            param.setAssistPropertyId(StringUtils.isEmpty((String)asstAttrId) ? null : asstAttrId);
            if (!StringUtils.isEmpty((String)bizTypeId)) {
                param.setBizTypeId(bizTypeId);
            }
            if (config.containsKey("qty")) {
                if (config.get("qty") != null) {
                    param.setQty(new BigDecimal(config.get("qty").toString()).abs());
                } else {
                    param.setQty(null);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return param;
    }

    public Map<String, Object> generatePlan(String apBillId, String payConditionId, Object otherInfo) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)payConditionId)) {
            return null;
        }
        OtherBillInfo info = null;
        ObjectUuidPK payConditionPk = new ObjectUuidPK(payConditionId);
        if (!StringUtils.isEmpty((String)apBillId)) {
            IOtherBill iAP = OtherBillFactory.getLocalInstance(this.ctx);
            ObjectUuidPK apBillPk = new ObjectUuidPK(apBillId);
            info = iAP.getOtherBillInfo((IObjectPK)apBillPk);
        }
        Map otherInfoMap = (Map)otherInfo;
        if (info == null) {
            info = new OtherBillInfo();
            Object companyid = otherInfoMap.get("companyid");
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            if (companyid != null) {
                company.setId(BOSUuid.read((String)companyid.toString()));
                info.setCompany(company);
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            info.setBillDate(df.parse((String)otherInfoMap.get("billDate")));
            info.setBizDate(df.parse((String)otherInfoMap.get("bizDate")));
            BigDecimal amount = new BigDecimal(String.valueOf(otherInfoMap.get("amount")));
            info.setAmount(amount);
            BigDecimal amountLocal = new BigDecimal(String.valueOf(otherInfoMap.get("amountLocal").toString()));
            info.setAmountLocal(amountLocal);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        IPayCondition ipc = PayConditionFactory.getLocalInstance((Context)this.ctx);
        PayConditionInfo payConditionInfo = ipc.getPayConditionInfo((IObjectPK)payConditionPk);
        AbstractObjectCollection planCollection = PlanHelper.generatePlanCollection(this.ctx, info, payConditionInfo);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("planCollection", planCollection);
        return result;
    }

    @Override
    protected String getOrgFilterByCompany(String companyid, int orgType) throws EASBizException, BOSException {
        OrgUnitInfo info = null;
        FilterInfo filter = new FilterInfo();
        if (!StringUtils.isEmpty((String)companyid)) {
            IOrgUnitRelation iUtilRel = OrgUnitRelationFactory.getLocalInstance((Context)this.getContext());
            OrgUnitCollection toUnit = iUtilRel.getFromUnit(companyid, 1, orgType);
            HashSet<String> set = new HashSet<String>();
            int size = toUnit.size();
            for (int i = 0; i < size; ++i) {
                info = toUnit.get(i);
                set.add(info.getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        }
        return filter.toString();
    }

    public Map<String, Object> asstActChangeHandler(String realtionDataObject, String asstActId, String saleOrgId, boolean isBillDepart, String companyId, String billtype) throws EASBizException, BOSException {
        PayConditionInfo payConditionInfo;
        HashMap<String, Object> result = new HashMap<String, Object>();
        PersonInfo person = null;
        if ("T_BD_Supplier".equals(realtionDataObject)) {
            SupplierInfo supplier = SupplierFactory.getLocalInstance((Context)this.ctx).getSupplierInfo("SELECT taxRate WHERE id = '" + asstActId + "'");
            result.put("taxRate", supplier.getTaxRate());
        } else if ("T_BD_Customer".equals(realtionDataObject)) {
            CustomerInfo customer = CustomerFactory.getLocalInstance((Context)this.ctx).getCustomerInfo("SELECT taxRate WHERE id = '" + asstActId + "'");
            result.put("taxRate", customer.getTaxRate());
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("customer", (Object)asstActId));
            filter.getFilterItems().add(new FilterItemInfo("saleOrgUnit", (Object)saleOrgId));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("customerSaler.person.name"));
            selector.add(new SelectorItemInfo("customerSaler.person.number"));
            view.setSelector(selector);
            ICustomerSaleInfo iCustomerSaleInfo = CustomerSaleInfoFactory.getLocalInstance((Context)this.ctx);
            CustomerSaleInfoCollection collection = iCustomerSaleInfo.getCustomerSaleInfoCollection(view);
            if (collection.size() > 0 && collection.get(0) != null && collection.get(0).getCustomerSaler() != null) {
                if (collection.get(0).getCustomerSaler().size() > 0) {
                    CustomerSalerInfo cSalerInfo = collection.get(0).getCustomerSaler().get(0);
                    person = cSalerInfo.getPerson();
                }
                result.put("person", person);
            }
        }
        if (person != null) {
            Map map = null;
            map = isBillDepart ? this.getAdminOrgUnitByPerson(person.getId().toString(), saleOrgId, companyId) : this.getAdminOrgUnitBySaleOrgUnit(saleOrgId);
            result.putAll(map);
        }
        if ((payConditionInfo = PlanHelper.getPayCondition(this.ctx, asstActId, companyId)) != null && DeletedStatusEnum.DELETED.equals((Object)payConditionInfo.getDeletedStatus())) {
            payConditionInfo = null;
        }
        result.put("payCondition", payConditionInfo);
        if (companyId != null && asstActId != null) {
            try {
                boolean isContrast;
                boolean isArBill = false;
                if ("101".equals(billtype)) {
                    isArBill = true;
                }
                AccountViewInfo accountViewInfo = ArApServerUtils.getKAClassAccount(this.ctx, companyId, asstActId, isArBill, true, 0);
                IContrastAccountView iContrastAcct = ContrastAccountViewFactory.getLocalInstance((Context)this.ctx);
                if (accountViewInfo != null && !(isContrast = iContrastAcct.isContrastAccount(ContextUtil.getCurrentCtrlUnit((Context)this.ctx).getId().toString(), companyId, accountViewInfo.getId().toString(), AccountControlAttribute.AR))) {
                    accountViewInfo = null;
                }
                result.put("accountViewInfo", accountViewInfo);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return result;
    }

    public IObjectValue debitTransfer(String billId) throws EASBizException, BOSException {
        String logItem = "ap_otherbill_DebitTrans";
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        OtherBillInfo info = OtherBillFactory.getLocalInstance(this.ctx).getOtherBillInfo((IObjectPK)pk, sic);
        IObjectPK logPK = LogUtil.beginLog((Context)this.ctx, (String)(EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"2_OtherBillListUI", (Locale)this.ctx.getOriginLocale()) + EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"debitTransferlog", (Locale)this.ctx.getOriginLocale())), (BOSObjectType)BOSObjectType.create((String)"48DA3A71"), (IObjectPK)pk, (String)info.getNumber(), (String)logItem);
        LinkedHashMap<String, Object> paramMap = new LinkedHashMap<String, Object>();
        paramMap.put("createToFlag", 1);
        paramMap.put("bizType", BOSObjectType.create((String)"48DA3A71"));
        paramMap.put("transSelectors", BaseService.getBillSelectors());
        paramMap.put("selectId", billId);
        paramMap.put("currentUser", ContextUtil.getCurrentUserInfo((Context)this.ctx));
        HashMap hm = OtherBillFactory.getLocalInstance(this.ctx).processArap2Arap(paramMap);
        if (hm == null) {
            throw new BOTPException(BOTPException.MAPPINGNUMZERO);
        }
        ArApBillBaseInfo destBillInfo = (ArApBillBaseInfo)((BTPTransformResult)hm.get("btpResult")).getBills().getObject(0);
        if (destBillInfo.isIsInitializeBill()) {
            destBillInfo.setIsInitializeBill(false);
            Date date = new Date();
            destBillInfo.setBillDate(date);
            destBillInfo.setBizDate(date);
        }
        CodeRuleHelper codeHelper = new CodeRuleHelper();
        codeHelper.genNewBillNumber(this.getContext(), (IObjectValue)destBillInfo, (OrgUnitInfo)destBillInfo.getCompany());
        if (logPK != null) {
            LogUtil.afterLog((Context)this.ctx, (IObjectPK)logPK);
        }
        return destBillInfo;
    }

    @Override
    protected String getCostCenterFilter(String companyId) throws EASBizException, BOSException {
        IOrgUnitRelation iOrgUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
        HashSet<String> costCenterSet = new HashSet<String>();
        OrgUnitCollection orgIds = iOrgUnitRel.getFromUnit(companyId, 1, 5);
        for (int i = 0; orgIds != null && i < orgIds.size(); ++i) {
            costCenterSet.add(orgIds.get(i).getId().toString());
        }
        FilterInfo filterInfo = new FilterInfo();
        if (costCenterSet.size() > 0) {
            FilterItemInfo filterItemInfo = new FilterItemInfo("id", costCenterSet, CompareType.INCLUDE);
            filterInfo.getFilterItems().add(filterItemInfo);
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"null"));
        }
        return filterInfo.toString();
    }

    private void checkFunctionPermission(IObjectPK orgPK, String permItemName) throws BOSException, EASBizException {
        IPermission perm = PermissionFactory.getLocalInstance((Context)this.ctx);
        perm.checkFunctionPermission(this.ctx.getCaller(), orgPK, permItemName);
    }

    public Map getAPCreateToBOTPOption(List billIds) throws BOSException, EASBizException {
        long beginTime = System.currentTimeMillis();
        HashSet<String> idSet = new HashSet<String>();
        idSet.addAll(billIds);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        CoreBillBaseCollection billCol = OtherBillFactory.getLocalInstance(this.ctx).getCoreBillBaseCollection(evi);
        IBOTMapping ibot = BOTMappingFactory.getLocalInstance((Context)this.ctx);
        BOTMappingCollection botpCol = ibot.getMappingCollectionForSelect(billCol, "40284E81", DefineSysEnum.BTP);
        botpCol.addCollection(ibot.getMappingCollectionForSelect(billCol, "D001019A", DefineSysEnum.BTP));
        idSet = new HashSet();
        int size = botpCol.size();
        for (int i = 0; i < size; ++i) {
            idSet.add(botpCol.get(i).getId().toString());
        }
        evi = new EntityViewInfo();
        fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("alias");
        sic.add("description");
        sic.add("destEntityName");
        sic.add("destEntityAlias");
        evi.setSelector(sic);
        botpCol = BOTMappingFactory.getLocalInstance((Context)this.ctx).getBOTMappingCollection(evi);
        System.out.println("operation costed " + (System.currentTimeMillis() - beginTime) + "ms");
        HashMap<String, BOTMappingCollection> map = new HashMap<String, BOTMappingCollection>();
        map.put("botpCol", botpCol);
        return map;
    }

    public boolean isOpenCodingRule(String orgId) throws BOSException, EASBizException {
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)this.ctx);
        return codingRuleManager.getRuleStatus((IObjectValue)new OtherBillInfo(), orgId).isExist();
    }

    public Map<String, Object> handlePersonChange(String personId, String saleOrgUnitId, String companyId, boolean isBillDepart) throws BOSException, EASBizException {
        Map map = null;
        map = isBillDepart ? this.getAdminOrgUnitByPerson(personId, saleOrgUnitId, companyId) : this.getAdminOrgUnitBySaleOrgUnit(saleOrgUnitId);
        StringBuffer sql = new StringBuffer();
        sql.append("select id,person.id,saleGroup.*, saleGroup.saleOrg.id where saleGroup.saleOrg.id='");
        sql.append(saleOrgUnitId).append("'").append(" and person.id='").append(personId).append("'");
        sql.append(" and deletedStatus = ").append(1);
        ISalePerson is = SalePersonFactory.getLocalInstance((Context)this.ctx);
        SalePersonCollection SalePersonCollection2 = is.getSalePersonCollection(sql.toString());
        SaleGroupInfo aSaleGroupInfo = null;
        if (SalePersonCollection2.size() > 0) {
            aSaleGroupInfo = SalePersonCollection2.get(0).getSaleGroup();
        }
        if (aSaleGroupInfo == null || !ForbidStatusEnum.UNFORBID.equals((Object)aSaleGroupInfo.getDeletedStatus())) {
            aSaleGroupInfo = null;
        }
        map.put("saleGroupInfo", aSaleGroupInfo);
        return map;
    }

    @Override
    protected boolean isArBill(ArApBillBaseInfo info) {
        return OtherBillTypeEnum.OtherReceivable.equals((Object)((OtherBillInfo)info).getBillType());
    }

    @Override
    protected boolean isAr() {
        return true;
    }

    @Override
    protected SystemEnum getSysEnum() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }
}

