/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;

public class CommonUtils {
    public static final String ID_LIST = "ID_LIST";
    public static final String BILLID = "BILLID";
    public static final String POSITIVE = "POSITIVE ";
    public static final String NEGATIVE = "NEGATIVE";
    public static final String AR_BALANCE_TABLE = "T_AR_ArBalance";
    public static final String AP_BALANCE_TABLE = "T_AP_ApBalance";
    public static final String AR_BALANCE_COLLATE_TABLE = "T_AR_ArBalanceCollate";
    public static final String AP_BALANCE_COLLATE_TABLE = "T_AP_ApBalanceCollate";
    public static final String AR_BILL_ACCOUNT_BALANCE_TABLE = "T_AR_ArBillAccountBalance";
    public static final String AP_BILL_ACCOUNT_BALANCE_TABLE = "T_AP_ApBillAccountBalance";

    public static BigDecimal convertBigDecimal(BigDecimal value) {
        if (value == null) {
            return new BigDecimal(0);
        }
        return value;
    }

    public static String getARAPBalanceTable(String system, String type) {
        if ("SYSTEM_AR".equals(system)) {
            if ("DAILY_NORMAL".equalsIgnoreCase(type)) {
                return AR_BALANCE_TABLE;
            }
            if ("DAILY_INITIAL".equalsIgnoreCase(type)) {
                return "T_AR_ArBalanceInit";
            }
            if ("ACCOUNT_NORMAL".equalsIgnoreCase(type)) {
                return AR_BALANCE_COLLATE_TABLE;
            }
            if ("ACCOUNT_INITIAL".equalsIgnoreCase(type)) {
                return AR_BALANCE_COLLATE_TABLE;
            }
            if ("BILL_ACCOUNT".equalsIgnoreCase(type)) {
                return AR_BILL_ACCOUNT_BALANCE_TABLE;
            }
        } else if ("SYSTEM_AP".equals(system)) {
            if ("DAILY_NORMAL".equalsIgnoreCase(type)) {
                return AP_BALANCE_TABLE;
            }
            if ("DAILY_INITIAL".equalsIgnoreCase(type)) {
                return "T_AP_ApBalanceInit";
            }
            if ("ACCOUNT_NORMAL".equalsIgnoreCase(type)) {
                return AP_BALANCE_COLLATE_TABLE;
            }
            if ("ACCOUNT_INITIAL".equalsIgnoreCase(type)) {
                return AP_BALANCE_COLLATE_TABLE;
            }
            if ("BILL_ACCOUNT".equalsIgnoreCase(type)) {
                return AP_BILL_ACCOUNT_BALANCE_TABLE;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static String getARAPBalanceID(String system, String type) {
        if ("SYSTEM_AR".equals(system)) {
            if ("DAILY_NORMAL".equalsIgnoreCase(type)) {
                return "newbosid('2FCA1127')";
            }
            if ("DAILY_INITIAL".equalsIgnoreCase(type)) {
                return "newbosid('2CA1FED7')";
            }
            if ("ACCOUNT_NORMAL".equalsIgnoreCase(type)) {
                return "newbosid('8AFE7C4F')";
            }
            if ("ACCOUNT_INITIAL".equalsIgnoreCase(type)) {
                return "newbosid('8AFE7C3D')";
            }
            if ("BILL_ACCOUNT".equalsIgnoreCase(type)) {
                return "newbosid('CF8988AB')";
            }
        } else if ("SYSTEM_AP".equals(system)) {
            if ("DAILY_NORMAL".equalsIgnoreCase(type)) {
                return "newbosid('AC50E2E7')";
            }
            if ("DAILY_INITIAL".equalsIgnoreCase(type)) {
                return "newbosid('81E9F097')";
            }
            if ("ACCOUNT_NORMAL".equalsIgnoreCase(type)) {
                return "newbosid('FB4C473F')";
            }
            if ("ACCOUNT_INITIAL".equalsIgnoreCase(type)) {
                return "newbosid('616B68EF')";
            }
            if ("BILL_ACCOUNT".equalsIgnoreCase(type)) {
                return "newbosid('30821EEB')";
            }
        }
        throw new UnsupportedOperationException();
    }

    public static ObjectUuidPK getPK(String id) {
        BOSUuid uuid = BOSUuid.read((String)id);
        ObjectUuidPK pk = new ObjectUuidPK(uuid);
        return pk;
    }

    public static BigDecimal setScale(BigDecimal value) {
        if (value != null) {
            return value.setScale(2, 0);
        }
        return value;
    }

    public static CompanyOrgUnitInfo getCompanyInfo(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo defalutOrgInfo = null;
        ObjectUuidPK compk = CommonUtils.getCompanyPK();
        ICompanyOrgUnit comorg = null;
        comorg = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("accountTable"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("baseCurrency"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("baseExchangeTable"));
        sic.add(new SelectorItemInfo("CU.*"));
        sic.add(new SelectorItemInfo("invalidDate"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        defalutOrgInfo = comorg.getCompanyOrgUnitInfo((IObjectPK)compk, sic);
        return defalutOrgInfo;
    }

    public static ObjectUuidPK getCompanyPK() throws BOSException {
        CompanyOrgUnitInfo comobj = SysContext.getSysContext().getCurrentFIUnit();
        ObjectUuidPK compk = null;
        if (comobj == null) {
            throw new BOSException(CommonUtils.getStrResource("nullCompany"));
        }
        if (comobj.isIsOnlyUnion()) {
            throw new BOSException(CommonUtils.getStrResource("lab_company_isempty"));
        }
        compk = new ObjectUuidPK(BOSUuid.read((String)comobj.get("id").toString()));
        return compk;
    }

    public static String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey);
    }

    public static ExchangeRateInfo getCurrentExchangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCur, Date date) throws EASBizException, BOSException {
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK destCurrpk = null;
        if (sourceCur == null) {
            MsgBox.showInfo((String)"SourceCurrency is null");
            return null;
        }
        if (companyOrgUnitInfo == null) {
            companyOrgUnitInfo = CommonUtils.getCompanyInfo(ctx);
        }
        if (companyOrgUnitInfo.getBaseExchangeTable() == null) {
            MsgBox.showInfo((String)CommonUtils.getStrResource("BaseExchangeTable_not_exist"));
            return null;
        }
        excTablepk = new ObjectUuidPK(companyOrgUnitInfo.getBaseExchangeTable().getId());
        CurrencyInfo baseCur = companyOrgUnitInfo.getBaseCurrency();
        if (baseCur != null) {
            if (baseCur.getId().equals((Object)sourceCur.getId())) {
                return null;
            }
        } else {
            MsgBox.showInfo((String)"BaseCurrency is null");
            return null;
        }
        destCurrpk = new ObjectUuidPK(baseCur.getId());
        iexchangRate = ctx != null ? ExchangeRateFactory.getLocalInstance((Context)ctx) : ExchangeRateFactory.getRemoteInstance();
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(sourceCur.getId());
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        return erInfo;
    }

    public static Locale getLocale() {
        try {
            return SysContext.getSysContext().getOriginLocale();
        }
        catch (Exception e) {
            return LocaleUtils.locale_zh_CN;
        }
    }

    public static String getResources(String path, String key, Locale locale) {
        return CommonUtils.getResources(path, key, locale, 0, new Object[0]);
    }

    public static String getResources(String path, String key, Locale locale, int type, Object ... arguments) {
        if (null == locale) {
            locale = CommonUtils.getLocale();
        }
        String value = ResourceBase.getString((String)path, (String)key, (Locale)locale);
        if (null != arguments && arguments.length != 0) {
            value = type == 1 ? MessageFormat.format(value, arguments) : String.format(value, arguments);
        }
        return value;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return null == collection || collection.size() == 0;
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CommonUtils.isEmpty(collection);
    }
}

