/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.IAccountTable;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActUtils;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.auxacct.IAsstActTypeDefault;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.APParamEnum;
import com.kingdee.eas.fi.ar.BadAccountFacadeFactory;
import com.kingdee.eas.fi.ar.IBadAccountFacade;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArApParamCache {
    private Logger logger = Logger.getLogger(ArApParamCache.class);
    protected CompanyOrgUnitInfo cachedCompany = null;
    protected SystemStatusCtrolInfo cachedSysStatus = null;
    protected SystemStatusCtrolInfo invStatus = null;
    private Boolean isExistCodingRule = null;
    private boolean isAddViewCodingRule = false;
    protected SystemEnum defaultSysEnum = null;
    private AsstActTypeDefaultCollection asstActTypeColl;
    private AsstActTypeDefaultCollection apAsstActTypeColl;
    private AsstActTypeDefaultCollection arAsstActTypeColl;
    private CodingRuleInfo codeRuleInfo;
    protected SettlementTypeInfo settlementTypeInfo;
    private PaymentTypeInfo paymentTypeCreditInfo;
    private PaymentTypeInfo paymentTypeCurrencyInfo;
    protected boolean isSCMBill = false;
    protected boolean isInitBill = false;
    protected boolean isFromWorkflow = false;
    private HashMap paramValueMap;
    private AsstActTypeInfo defaulteAsstActType;
    private AsstActTypeDefaultInfo asstActTypeDefaultInfo;
    private AsstActTypeDefaultInfo apAsstActTypeDefaultInfo;
    private AsstActTypeDefaultInfo arAsstActTypeDefaultInfo;
    private Context ctx = null;
    private IObjectValue billInfo;
    private IPaymentType ipaymentType;
    private ICodingRuleManager iCodingRuleManager;
    private IAsstActTypeDefault iAsstActTypeDefault;
    private IParamControl iParamControl;
    private ICSSPGroupStandard cSSPGroupStandard;
    private IAccountTable iAccountTable;
    private IBadAccountFacade iBadAccountFacade;
    private String customerGroupStandardId;
    private String supplierGroupStandardId;
    private String currentAccountTableID;
    private AccountTableInfo accountTableInfo;
    private String permissionItem = null;
    private boolean isRelationGL;
    private boolean isGLStart;
    private boolean isBadAcctLoss = false;
    private boolean isDAPCheckAccount = false;
    private boolean isSetAccurralParam = false;
    private Map badAccountFacadeParams = new HashMap();
    private boolean isDerectorTransferCancelMethod = false;
    private String badAccountFacadeAccuralParam = null;
    private SystemStatusCtrolInfo otherSysStatus;
    private String billId = null;
    public static final String BILL_ID = "billId";
    private IAsstActType iAsstActType = null;

    public String getCurrentAccountTableID() {
        return this.currentAccountTableID;
    }

    public String getCustomerGroupStandardId() {
        return this.customerGroupStandardId;
    }

    public String getSupplierGroupStandardId() {
        return this.supplierGroupStandardId;
    }

    public ArApParamCache(Context ctx, HashMap others) {
        SystemEnum sysEnum = (SystemEnum)others.get("sysEnum");
        if (!SystemEnum.ACCOUNTSPAYABLE.equals((Object)sysEnum) && !SystemEnum.ACCOUNTSRECEIVABLE.equals((Object)sysEnum)) {
            throw new IllegalArgumentException();
        }
        this.ctx = ctx;
        this.defaultSysEnum = sysEnum;
        this.billInfo = (IObjectValue)others.get("billInfo");
        Boolean isSCM = (Boolean)others.get("isSCM");
        this.isSCMBill = isSCM == null ? false : isSCM;
        Boolean isInit = (Boolean)others.get("isInit");
        this.isInitBill = isInit == null ? false : isInit;
        this.permissionItem = (String)others.get("permissionItem");
        Boolean isBadAcctLoss = (Boolean)others.get("isBadAcctLoss");
        this.isBadAcctLoss = isBadAcctLoss == null ? false : isBadAcctLoss;
        this.isFromWorkflow = null == others.get("isFromWorkflow") ? false : Boolean.valueOf(others.get("isFromWorkflow").toString());
        this.billId = null == others.get(BILL_ID) ? null : others.get(BILL_ID).toString();
    }

    public ArApSysParamInfo create(CompanyOrgUnitInfo newCompany) throws EASBizException, BOSException {
        ArApSysParamInfo sysParam = new ArApSysParamInfo();
        this.cacheCompany(newCompany, this.isSCMBill);
        this.init();
        this.cacheAsstActType();
        this.cacheParam();
        this.cacheSysStatus();
        this.cacheAccountTable();
        if (this.billInfo != null) {
            this.cacheCodingRule();
            sysParam.setExistCodingRule(this.isExistCodingRule());
            sysParam.setIsAddViewCodingRule(this.isAddViewCodingRule);
        }
        sysParam.setCodeRuleInfo(this.getCodeRuleInfo());
        sysParam.setCompany(this.getCompany());
        sysParam.setDefaultAsstActType(this.getDefaultAsstActType());
        sysParam.setAsstActTypeColl(this.getAsstActTypeInfos());
        sysParam.setPaymentTypeCredit(this.getPaymentTypeCredit());
        sysParam.setPaymentTypeCurrency(this.getPaymentTypeCurrency());
        sysParam.setSettlementType(this.getSettlementType());
        sysParam.setSCM(this.isSCMBill);
        sysParam.setParamValueMap(this.paramValueMap);
        sysParam.setRelationSCM(this.isRelationSCM());
        sysParam.setAuditNow(this.isAuditNow());
        sysParam.setImportBillModifiable(this.isImportBillModifiable());
        sysParam.setSysEnum(this.defaultSysEnum);
        sysParam.setSysStatus(this.getSysStatus(this.defaultSysEnum), this.defaultSysEnum);
        sysParam.setSysStatus(this.getSysStatus(this.defaultSysEnum == SystemEnum.ACCOUNTSPAYABLE ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE), this.defaultSysEnum == SystemEnum.ACCOUNTSPAYABLE ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE);
        sysParam.setSysStatus(this.getSysStatus(SystemEnum.INVENTORYMANAGEMENT), SystemEnum.INVENTORYMANAGEMENT);
        sysParam.setQtyCanGreat(this.isQtyCanGreat());
        sysParam.setCustomerGroupStandardId(this.getCustomerGroupStandardId());
        sysParam.setSupplierGroupStandardId(this.getSupplierGroupStandardId());
        sysParam.setCurrentAccountTableID(this.getCurrentAccountTableID());
        sysParam.setAccountTableInfo(this.getAccountTableInfo());
        sysParam.setRelationGL(this.isRelationGL());
        sysParam.setGLStart(this.isGLStart());
        sysParam.setApAsstActTypeColl(this.getApAsstActTypeInfos());
        sysParam.setArAsstActTypeColl(this.getArAsstActTypeInfos());
        sysParam.setDAPCheckAccount(this.isDAPCheckAccount);
        sysParam.setIsDisplayLocalCurrency(CommonServerUtils.isDisplayLocalCurrency(this.ctx));
        boolean isPrePayAmoutCanOverOrder = true;
        boolean isPrePayAmoutCanOverPurContract = true;
        if (this.paramValueMap != null) {
            if (this.paramValueMap.containsKey(APParamEnum.ORDERPAYMENT.getValue()) && !"true".equals(this.paramValueMap.get(APParamEnum.ORDERPAYMENT.getValue()))) {
                isPrePayAmoutCanOverOrder = false;
            }
            if (this.paramValueMap.containsKey(APParamEnum.PurContractPrePay.getValue()) && !"true".equals(this.paramValueMap.get(APParamEnum.PurContractPrePay.getValue()))) {
                isPrePayAmoutCanOverPurContract = false;
            }
        }
        sysParam.setPrePayAmoutCanOverOrderPrepayAmt(isPrePayAmoutCanOverOrder);
        sysParam.setPrePayAmoutCanOverPurContractPrepayAmt(isPrePayAmoutCanOverPurContract);
        if (this.isBadAcctLoss) {
            sysParam.setBadAccountFacadeAccuralParam(this.badAccountFacadeAccuralParam);
            sysParam.setBadAccountFacadeParams(this.badAccountFacadeParams);
            sysParam.setSetAccurralParam(this.isSetAccurralParam);
            sysParam.setDerectorTransferCancelMethod(this.isDerectorTransferCancelMethod);
        }
        boolean isAr = SystemEnum.ACCOUNTSRECEIVABLE.equals((Object)this.defaultSysEnum);
        boolean isContrastByBillAccount = ArApParamHelper.isContrastByBillAccount(this.ctx, this.getCompany().getId().toString(), this.cachedSysStatus.getCurrentPeriod().getNumber(), isAr);
        sysParam.setContrastByBillAccount(isContrastByBillAccount);
        return sysParam;
    }

    public void cacheCompany(CompanyOrgUnitInfo newCompany, boolean isSCM) throws EASBizException, BOSException {
        if (newCompany == null) {
            if (this.isSCMBill) {
                newCompany = ArApBillHelper.getDefaultCompany(this.ctx, ContextUtil.getCurrentUserInfo((Context)this.ctx), SystemEnum.INVENTORYMANAGEMENT, this.permissionItem);
            } else if (this.isFromWorkflow) {
                CompanyOrgUnitInfo companyOrgUnitInfo = newCompany = null != this.billInfo && null != this.billInfo.get("company") ? (CompanyOrgUnitInfo)this.billInfo.get("company") : null;
                if (null == newCompany && !StringUtils.isEmpty((String)this.billId)) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add("id");
                    sic.add("company.*");
                    IObjectValue bill = DynamicObjectFactory.getLocalInstance((Context)this.ctx).getValue(BOSUuid.read((String)this.billId).getType(), (IObjectPK)new ObjectUuidPK(this.billId), sic);
                    newCompany = null != bill.get("company") ? (CompanyOrgUnitInfo)bill.get("company") : null;
                }
            } else {
                newCompany = ArApBillHelper.getDefaultCompany(this.ctx, ContextUtil.getCurrentUserInfo((Context)this.ctx), this.defaultSysEnum, this.permissionItem);
            }
        }
        if (!(newCompany == null || this.cachedCompany != null && this.cachedCompany.getId() != null && this.cachedCompany.getId().equals((Object)newCompany.getId()))) {
            this.cachedCompany = StringUtils.isEmpty((String)newCompany.getNumber()) || newCompany.get("isOnlyUnion") == null || newCompany.getBaseCurrency() == null || newCompany.getBaseCurrency().getPrecision() == 0 ? ArApBillHelper.getCompanyOrgUnitInfo(this.ctx, newCompany.getId(), newCompany) : newCompany;
            if (this.cachedCompany.isIsOnlyUnion()) {
                throw new OtherBillBizException(OtherBillBizException.COMPANYISONLYUNION);
            }
            if (this.cachedCompany.getBaseCurrency() == null) {
                throw new OtherBillBizException(OtherBillBizException.BASECURRENCYISNULL);
            }
            this.isSCMBill = isSCM;
        }
    }

    public void cacheSysStatus() throws OtherBillBizException {
        try {
            this.invStatus = ArApBillHelper.getSysStatusCtrolInfo(this.ctx, this.cachedCompany, SystemEnum.INVENTORYMANAGEMENT);
            this.cachedSysStatus = ArApBillHelper.getSysStatusCtrolInfo(this.ctx, this.cachedCompany, this.defaultSysEnum);
            SystemEnum otherSys = this.defaultSysEnum == SystemEnum.ACCOUNTSPAYABLE ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
            this.otherSysStatus = ArApBillHelper.getSysStatusCtrolInfo(this.ctx, this.cachedCompany, otherSys);
            if (this.cachedSysStatus == null || this.cachedSysStatus.getStartPeriod() == null || this.cachedSysStatus.getCurrentPeriod() == null) {
                throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.cachedCompany.getName() + " " + this.defaultSysEnum.getAlias()});
            }
            if (this.isSCMBill && (this.invStatus == null || this.invStatus.getStartPeriod() == null || this.invStatus.getCurrentPeriod() == null)) {
                throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{SystemEnum.INVENTORYMANAGEMENT.getAlias()});
            }
        }
        catch (BOSException e) {
            this.logger.info((Object)e);
            throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.defaultSysEnum.getAlias()});
        }
    }

    protected void init() throws EASBizException, BOSException {
        String paymentTypeCreditId = null;
        String paymentTypeCurrencyId = null;
        if (SystemEnum.ACCOUNTSPAYABLE.equals((Object)this.defaultSysEnum)) {
            paymentTypeCreditId = "2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5";
            paymentTypeCurrencyId = "40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5";
        } else if (SystemEnum.ACCOUNTSRECEIVABLE.equals((Object)this.defaultSysEnum)) {
            paymentTypeCreditId = "91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5";
            paymentTypeCurrencyId = "cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5";
        }
        if (this.ctx == null) {
            this.iParamControl = ParamControlFactory.getRemoteInstance();
            this.ipaymentType = PaymentTypeFactory.getRemoteInstance();
            this.iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            this.iAsstActTypeDefault = AsstActTypeDefaultFactory.getRemoteInstance();
            this.cSSPGroupStandard = CSSPGroupStandardFactory.getRemoteInstance();
            this.iAccountTable = AccountTableFactory.getRemoteInstance();
            this.iBadAccountFacade = BadAccountFacadeFactory.getRemoteInstance();
            this.iAsstActType = AsstActTypeFactory.getRemoteInstance();
        } else {
            this.iParamControl = ParamControlFactory.getLocalInstance((Context)this.ctx);
            this.ipaymentType = PaymentTypeFactory.getLocalInstance((Context)this.ctx);
            this.iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)this.ctx);
            this.iAsstActTypeDefault = AsstActTypeDefaultFactory.getLocalInstance((Context)this.ctx);
            this.cSSPGroupStandard = CSSPGroupStandardFactory.getLocalInstance((Context)this.ctx);
            this.iAccountTable = AccountTableFactory.getLocalInstance((Context)this.ctx);
            this.iBadAccountFacade = BadAccountFacadeFactory.getLocalInstance(this.ctx);
            this.iAsstActType = AsstActTypeFactory.getLocalInstance((Context)this.ctx);
        }
        this.paymentTypeCreditInfo = this.ipaymentType.getPaymentTypeInfo((IObjectPK)new ObjectUuidPK(paymentTypeCreditId));
        this.paymentTypeCurrencyInfo = this.ipaymentType.getPaymentTypeInfo((IObjectPK)new ObjectUuidPK(paymentTypeCurrencyId));
        this.customerGroupStandardId = this.cSSPGroupStandard.getBasicStandardId("1");
        this.supplierGroupStandardId = this.cSSPGroupStandard.getBasicStandardId("2");
        this.isRelationGL = SystemStatusCtrolUtils.isRelAccount((Context)this.ctx, (SystemEnum)this.defaultSysEnum, (CompanyOrgUnitInfo)this.cachedCompany);
        this.isGLStart = SystemStatusCtrolUtils.isStart((Context)this.ctx, (SystemEnum)this.defaultSysEnum, (CompanyOrgUnitInfo)this.cachedCompany);
        if (this.cachedCompany == null || this.cachedCompany.getCU() != null) {
            // empty if block
        }
        if (this.isBadAcctLoss) {
            this.isDerectorTransferCancelMethod = this.iBadAccountFacade.isDerectorTransferCancelMethod(this.cachedCompany);
            this.isSetAccurralParam = this.iBadAccountFacade.isSetAccurralParam(this.cachedCompany);
            this.badAccountFacadeParams = this.iBadAccountFacade.getParams(this.cachedCompany);
            this.badAccountFacadeAccuralParam = this.iBadAccountFacade.getAccuralParam(this.cachedCompany);
        }
        this.isDAPCheckAccount = ArApParamHelper.isDAPCheckAccount(this.ctx);
    }

    public void clear() {
        this.settlementTypeInfo = null;
        this.paymentTypeCreditInfo = null;
        this.paymentTypeCurrencyInfo = null;
        this.asstActTypeColl = null;
        this.isExistCodingRule = null;
        this.paramValueMap = null;
    }

    public void cacheAsstActType() throws BOSException, EASBizException {
        if (this.cachedCompany == null) {
            throw new IllegalAccessError();
        }
        AsstActTypeDefaultInfo value = null;
        AsstActTypeDefaultCollection asstActTypeDefColl = this.getAsstActTypeDefaultCollection();
        this.asstActTypeColl = new AsstActTypeDefaultCollection();
        this.apAsstActTypeColl = new AsstActTypeDefaultCollection();
        this.arAsstActTypeColl = new AsstActTypeDefaultCollection();
        int size = asstActTypeDefColl.size();
        for (int i = 0; i < size; ++i) {
            value = asstActTypeDefColl.get(i);
            if (!value.isIsAccountCussent()) continue;
            this.asstActTypeColl.add(value);
            this.apAsstActTypeColl.add(value);
            this.arAsstActTypeColl.add(value);
            if (SystemEnum.ACCOUNTSPAYABLE.equals((Object)this.defaultSysEnum) && value.isIsDefaultAccountPayable()) {
                this.defaulteAsstActType = value.getAsstActType();
                this.asstActTypeDefaultInfo = value;
            } else if (SystemEnum.ACCOUNTSRECEIVABLE.equals((Object)this.defaultSysEnum) && value.isIsDefaultAccountReceivable()) {
                this.defaulteAsstActType = value.getAsstActType();
                this.asstActTypeDefaultInfo = value;
            }
            if (value.isIsDefaultAccountPayable()) {
                this.apAsstActTypeDefaultInfo = value;
                continue;
            }
            if (!value.isIsDefaultAccountReceivable()) continue;
            this.arAsstActTypeDefaultInfo = value;
        }
        if (this.defaulteAsstActType == null) {
            this.defaulteAsstActType = this.asstActTypeColl.get(0).getAsstActType();
        }
        asstActTypeDefColl = null;
        this.asstActTypeColl.swap((IObjectValue)this.asstActTypeDefaultInfo, (IObjectValue)this.asstActTypeColl.get(0));
        this.apAsstActTypeColl.swap((IObjectValue)this.apAsstActTypeDefaultInfo, (IObjectValue)this.apAsstActTypeColl.get(0));
        this.arAsstActTypeColl.swap((IObjectValue)this.arAsstActTypeDefaultInfo, (IObjectValue)this.arAsstActTypeColl.get(0));
    }

    private void cacheAccountTable() throws EASBizException, BOSException {
        PeriodInfo period = this.getCurrentPeriod(null);
        if (period == null) {
            period = this.getStartPeriod(null);
        }
        if (this.cachedCompany.getAccountTable() == null) {
            throw new AccountException(AccountException.CURRENTCOMPANYHASNOSTARTACCOUNTTABLE);
        }
        if (period != null) {
            this.currentAccountTableID = AccountTools.getCurrentAcctTable((Context)this.ctx, (String)this.getCompanyId(), (String)this.cachedCompany.getAccountTable().getId().toString(), (int)period.getPeriodYear(), (int)period.getPeriodNumber());
        } else if (period == null) {
            this.currentAccountTableID = this.cachedCompany.getAccountTable().getId().toString();
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.currentAccountTableID);
        this.accountTableInfo = this.iAccountTable.getAccountTableInfo((IObjectPK)pk);
    }

    private HashMap cacheParam() throws EASBizException, BOSException {
        if (this.cachedCompany == null) {
            throw new IllegalAccessError();
        }
        if (this.paramValueMap != null) {
            return this.paramValueMap;
        }
        HashMap<String, ObjectUuidPK> keyMap = new HashMap<String, ObjectUuidPK>();
        ObjectUuidPK companyPK = new ObjectUuidPK(this.getCompany().getId());
        ObjectUuidPK cuPK = new ObjectUuidPK(this.getCompany().getCU().getId());
        if (SystemEnum.ACCOUNTSPAYABLE.equals((Object)this.defaultSysEnum)) {
            keyMap.put("AP_SCM_001", companyPK);
            keyMap.put("APBILL_AUDIT_NOW", companyPK);
            keyMap.put("PURSUP006", companyPK);
            keyMap.put("AP_PAYBILL_BANK", companyPK);
            keyMap.put("AP_BILL_VATINV", companyPK);
            keyMap.put("PAYBILL_IS_PAYMENT", companyPK);
            keyMap.put("AP_CONTRAST_ESTIMATE_GL", companyPK);
            keyMap.put("AP_BIZ_HANDLE", companyPK);
            keyMap.put("PAYBILL_AUDIT_NOW", companyPK);
            keyMap.put("AP_PAYVOUCHER_BILLTYPE", companyPK);
            keyMap.put("AP_PAYVOUCHER_BILLTYPE_CASH", companyPK);
            keyMap.put("AP_BILL_DEPART", companyPK);
            keyMap.put("CS027", companyPK);
            keyMap.put("NT011", companyPK);
            keyMap.put("CS038", companyPK);
            keyMap.put("CS031", companyPK);
            keyMap.put("CS031_01", companyPK);
            keyMap.put("CS122", companyPK);
            keyMap.put("AP_PAY_SCHEDUAL", companyPK);
            keyMap.put("AP_034", companyPK);
            keyMap.put("AP_035", companyPK);
            keyMap.put("AP_036", companyPK);
            keyMap.put("AP_INTEGRATE_PWY", companyPK);
        } else if (SystemEnum.ACCOUNTSRECEIVABLE.equals((Object)this.defaultSysEnum)) {
            keyMap.put("AR_SCM_001", companyPK);
            keyMap.put("ARBILL_AUDIT_NOW", companyPK);
            keyMap.put("AR_PAYBILL_BANK", companyPK);
            keyMap.put("AR_BILL_VATINV", companyPK);
            keyMap.put("Rec_Vou_001", companyPK);
            keyMap.put("AR_IS_BIZ_VOUCHER", companyPK);
            keyMap.put("AR_BIZ_HANDLE", companyPK);
            keyMap.put("RECBILL_AUDIT_NOW", companyPK);
            keyMap.put("AR_RECVOUCHER_BILLTYPE", companyPK);
            keyMap.put("AR_RECVOUCHER_BILLTYPE_CASH", companyPK);
            keyMap.put("AR_BILL_DEPART", companyPK);
            keyMap.put("AR_040", companyPK);
            keyMap.put("AR_IMPORT", companyPK);
        }
        keyMap.put("CS131", companyPK);
        keyMap.put("DISCOUNTRATEPRECISION", null);
        keyMap.put("F7DISPLAYMODE", cuPK);
        keyMap.put("OnlySupportQueryViaMaterialNumber", null);
        keyMap.put("G003", null);
        keyMap.put(APParamEnum.ORDERPAYMENT.getValue(), companyPK);
        keyMap.put(APParamEnum.PurContractPrePay.getValue(), companyPK);
        keyMap.put("BE021", companyPK);
        keyMap.put("BE022", companyPK);
        keyMap.put("AR_039", companyPK);
        keyMap.put("BOTP_ALLENTRIES_SELECTED", companyPK);
        this.paramValueMap = this.iParamControl.getParamHashMap(keyMap);
        return this.paramValueMap;
    }

    public CompanyOrgUnitInfo getCompany() {
        if (this.cachedCompany == null) {
            throw new IllegalAccessError();
        }
        return this.cachedCompany;
    }

    public String getCompanyId() {
        if (this.cachedCompany == null) {
            throw new IllegalAccessError();
        }
        return this.cachedCompany.getId().toString();
    }

    public String getCUId() {
        if (this.cachedCompany == null) {
            throw new IllegalAccessError();
        }
        return this.cachedCompany.getCU().getId().toString();
    }

    public SystemStatusCtrolInfo getSysStatus(SystemEnum sysEnum) {
        SystemEnum tempSysEnum = null;
        if (this.cachedCompany == null) {
            throw new IllegalAccessError();
        }
        tempSysEnum = sysEnum == null ? (!this.isRelationSCM() && this.isSCMBill ? SystemEnum.INVENTORYMANAGEMENT : this.defaultSysEnum) : sysEnum;
        if (tempSysEnum.equals((Object)SystemEnum.INVENTORYMANAGEMENT)) {
            return this.invStatus;
        }
        if (tempSysEnum == this.defaultSysEnum) {
            return this.cachedSysStatus;
        }
        return this.otherSysStatus;
    }

    public boolean isRelationSCM() {
        String key = null;
        key = SystemEnum.ACCOUNTSPAYABLE.equals((Object)this.defaultSysEnum) ? "AP_SCM_001" : "AR_SCM_001";
        return this.getBooleanParamValue(key);
    }

    public boolean isAuditNow() {
        String key = null;
        key = SystemEnum.ACCOUNTSPAYABLE.equals((Object)this.defaultSysEnum) ? "APBILL_AUDIT_NOW" : "ARBILL_AUDIT_NOW";
        return this.getBooleanParamValue(key);
    }

    public int getF7DisplayMode() {
        String value = (String)this.paramValueMap.get("F7DISPLAYMODE");
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public boolean isImportBillModifiable() {
        String value = (String)this.paramValueMap.get("G003");
        if (value == null) {
            return true;
        }
        return "false".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value);
    }

    public boolean isQtyCanGreat() {
        String subSysId = "com.kingdee.eas.fi.ap.ap";
        String value = (String)this.paramValueMap.get("PURSUP006");
        if (value == null) {
            try {
                return ArApParamHelper.getDefaultParam(this.ctx, subSysId, "PURSUP006");
            }
            catch (BOSException e) {
                this.logger.info((Object)e);
            }
        }
        return "true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
    }

    private boolean getBooleanParamValue(String key) {
        String subSysId = null;
        if (SystemEnum.ACCOUNTSPAYABLE.equals((Object)this.defaultSysEnum)) {
            subSysId = "com.kingdee.eas.fi.ap.ap";
        } else if (SystemEnum.ACCOUNTSRECEIVABLE.equals((Object)this.defaultSysEnum)) {
            subSysId = "com.kingdee.eas.fi.ar.ar";
        }
        String value = (String)this.paramValueMap.get(key);
        if (value == null) {
            try {
                return ArApParamHelper.getDefaultParam(this.ctx, subSysId, key);
            }
            catch (BOSException e) {
                this.logger.info((Object)e);
            }
        }
        return "true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
    }

    public AsstActTypeInfo getDefaultAsstActType() {
        return this.defaulteAsstActType;
    }

    public int getRatePrecision() {
        if (this.cachedCompany == null) {
            return 4;
        }
        String value = (String)this.paramValueMap.get("DISCOUNTRATEPRECISION");
        if (value == null) {
            return 4;
        }
        return Integer.parseInt(value);
    }

    public CurrencyInfo getBaseCurrency() {
        if (this.cachedCompany == null) {
            throw new IllegalAccessError();
        }
        return this.cachedCompany.getBaseCurrency();
    }

    public PeriodInfo getStartPeriod(SystemEnum sysEnum) {
        SystemStatusCtrolInfo systemStatusCtrolInfo = this.getSysStatus(sysEnum);
        if (systemStatusCtrolInfo != null) {
            return systemStatusCtrolInfo.getStartPeriod();
        }
        return null;
    }

    public PeriodInfo getCurrentPeriod(SystemEnum sysEnum) {
        SystemStatusCtrolInfo systemStatusCtrolInfo = this.getSysStatus(sysEnum);
        if (systemStatusCtrolInfo != null) {
            return systemStatusCtrolInfo.getCurrentPeriod();
        }
        return null;
    }

    public boolean isStart(SystemEnum sysEnum) {
        SystemStatusCtrolInfo systemStatusCtrolInfo = this.getSysStatus(sysEnum);
        if (systemStatusCtrolInfo != null) {
            return systemStatusCtrolInfo.isIsStart();
        }
        return false;
    }

    public CodingRuleInfo getCodeRuleInfo() {
        return this.codeRuleInfo;
    }

    public boolean isExistCodingRule() {
        return this.isExistCodingRule;
    }

    public PaymentTypeInfo getPaymentTypeCredit() {
        return this.paymentTypeCreditInfo;
    }

    public PaymentTypeInfo getPaymentTypeCurrency() {
        return this.paymentTypeCurrencyInfo;
    }

    private void cacheCodingRule() throws EASBizException, BOSException {
        this.codeRuleInfo = this.iCodingRuleManager.getCodingRule(this.billInfo, this.getCompanyId());
        this.isExistCodingRule = this.codeRuleInfo != null;
        if (this.isExistCodingRule.booleanValue()) {
            this.isAddViewCodingRule = this.iCodingRuleManager.isAddView(this.billInfo, this.getCompanyId());
        }
    }

    public AsstActTypeCollection getAsstActTypeInfos() {
        AsstActTypeCollection coll = new AsstActTypeCollection();
        for (int i = 0; i < this.asstActTypeColl.size(); ++i) {
            coll.add(this.asstActTypeColl.get(i).getAsstActType());
        }
        return coll;
    }

    public AsstActTypeCollection getApAsstActTypeInfos() {
        AsstActTypeCollection coll = new AsstActTypeCollection();
        for (int i = 0; i < this.apAsstActTypeColl.size(); ++i) {
            coll.add(this.apAsstActTypeColl.get(i).getAsstActType());
        }
        return coll;
    }

    public AsstActTypeCollection getArAsstActTypeInfos() {
        AsstActTypeCollection coll = new AsstActTypeCollection();
        for (int i = 0; i < this.arAsstActTypeColl.size(); ++i) {
            coll.add(this.arAsstActTypeColl.get(i).getAsstActType());
        }
        return coll;
    }

    public SettlementTypeInfo getSettlementType() {
        return this.settlementTypeInfo;
    }

    public AccountTableInfo getAccountTableInfo() {
        return this.accountTableInfo;
    }

    public boolean isRelationGL() {
        return this.isRelationGL;
    }

    public boolean isGLStart() {
        return this.isGLStart;
    }

    public boolean isDAPCheckAccount() {
        return this.isDAPCheckAccount;
    }

    public ArApParamCache(Context ctx, String companyId, SystemEnum defaultSysEnum) throws BOSException {
        this.ctx = ctx;
        this.cachedCompany = new CompanyOrgUnitInfo();
        this.cachedCompany.setId(BOSUuid.read((String)companyId));
        this.defaultSysEnum = defaultSysEnum;
        if (ctx == null) {
            this.iAsstActTypeDefault = AsstActTypeDefaultFactory.getRemoteInstance();
            this.iAsstActType = AsstActTypeFactory.getRemoteInstance();
        } else {
            this.iAsstActTypeDefault = AsstActTypeDefaultFactory.getLocalInstance((Context)ctx);
            this.iAsstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
        }
    }

    public AsstActTypeDefaultCollection getAsstActTypeDefaultCollection() throws BOSException, EASBizException {
        if (this.cachedCompany == null) {
            throw new IllegalAccessError();
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSorter().add(new SorterItemInfo("number"));
        String companyid = this.cachedCompany.getId().toString();
        view.setFilter(AsstActUtils.getDefaultFilterForQuery((Context)this.ctx));
        AsstActTypeCollection asstcol = this.iAsstActType.getAsstActTypeCollection(view);
        AsstActTypeDefaultCollection defCol = new AsstActTypeDefaultCollection();
        int count = asstcol.size();
        AsstActTypeDefaultInfo defalInfo = new AsstActTypeDefaultInfo();
        for (int i = 0; i < count; ++i) {
            AsstActTypeInfo typeInfo = asstcol.get(i);
            defalInfo = (AsstActTypeDefaultInfo)this.iAsstActTypeDefault.getDefaultAcctItem(companyid, (IObjectValue)typeInfo);
            defalInfo.setAsstActType(typeInfo);
            defCol.add(defalInfo);
        }
        return defCol;
    }
}

