/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApQueryParam;
import com.kingdee.eas.fi.ar.IReportHead;
import com.kingdee.eas.fi.ar.ReportHead;
import com.kingdee.eas.fi.ar.ReportHeadCell;
import com.kingdee.eas.fi.arap.AmountDirectionEnum;
import com.kingdee.eas.fi.arap.ContrastGLDiffTypeEnum;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ContrastGLRptDetailQueryParam
extends ArApQueryParam {
    private static final long serialVersionUID = -8431959207995867496L;
    private static Logger logger = Logger.getLogger((String)ContrastGLRptDetailQueryParam.class.getName());
    public static final String COLUMN_FID = "FID";
    public static final String COLUMN_BILL_TYPE = "FBillType";
    public static final String COLUMN_SCENE_NUMBER = "FsceneNumber";
    public static final String COLUMN_BILL_ID = "FBillID";
    public static final String COLUMN_BILL_BOSTYPE = "FBillBostype";
    public static final String COLUMN_BILL_NUMBER = "FBillNumber";
    public static final String COLUMN_VOUCHER = "FVoucher";
    public static final String COLUMN_BILL_DATE = "FBillDate";
    public static final String COLUMN_AMOUNT = "FBillAmount";
    public static final String COLUMN_VOUCHER_ID = "FVoucherID";
    public static final String COLUMN_GL_VOUCHER_PERIOD = "FVoucherPeriod";
    public static final String COLUMN_GL_VOUCHER = "FVoucherNumber";
    public static final String COLUMN_GL_AMOUNT = "FVoucherAmount";
    public static final String COLUMN_DIFF_AMOUNT = "FDiffAmount";
    public static final String COLUMN_DIFF_TYPE = "FDiffType";
    public static final String COLUMN_IS_SUM = "FIsSum";
    private AmountDirectionEnum amtDirection = null;
    private String accountId = null;
    private String sortItems = null;
    private boolean hasUnRegVoucher = false;
    private String periodId = null;
    private int periodYear = -1;
    private int periodNum = -1;
    private ContrastGLDiffTypeEnum diffType = ContrastGLDiffTypeEnum.ALL;
    private boolean isGUI = true;

    public AmountDirectionEnum getAmtDirection() {
        return this.amtDirection;
    }

    public void setAmtDirection(AmountDirectionEnum amtDirection) {
        this.amtDirection = amtDirection;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getSortItems() {
        return this.sortItems;
    }

    public void setSortItems(String sortItems) {
        this.sortItems = sortItems;
    }

    public boolean isHasUnRegVoucher() {
        return this.hasUnRegVoucher;
    }

    public void setHasUnRegVoucher(boolean hasUnRegVoucher) {
        this.hasUnRegVoucher = hasUnRegVoucher;
    }

    public String getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(String periodId) {
        this.periodId = periodId;
    }

    public int getPeriodYear() {
        return this.periodYear;
    }

    public void setPeriodYear(int periodYear) {
        this.periodYear = periodYear;
    }

    public int getPeriodNum() {
        return this.periodNum;
    }

    public void setPeriodNum(int periodNum) {
        this.periodNum = periodNum;
    }

    public ContrastGLDiffTypeEnum getDiffType() {
        return this.diffType;
    }

    public void setDiffType(ContrastGLDiffTypeEnum diffType) {
        this.diffType = diffType;
    }

    public boolean isGUI() {
        return this.isGUI;
    }

    public void setGUI(boolean isGUI) {
        this.isGUI = isGUI;
    }

    public void initCurrencyInfo() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("precision");
        try {
            CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.getCurrencyId()), sic);
            this.setCurrencyInfo(currency);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
    }

    protected boolean isGLColumn(String field) {
        return COLUMN_GL_VOUCHER_PERIOD.equals(field) || COLUMN_GL_VOUCHER.equals(field) || COLUMN_GL_AMOUNT.equals(field);
    }

    protected boolean isDiffColumn(String field) {
        return COLUMN_DIFF_AMOUNT.equals(field) || COLUMN_DIFF_TYPE.equals(field) || COLUMN_IS_SUM.equals(field);
    }

    protected boolean isArApColumn(String field) {
        return !this.isGLColumn(field) && !this.isDiffColumn(field);
    }

    public IReportHead getReportHead() {
        if (this.getCurrencyInfo() == null) {
            this.initCurrencyInfo();
        }
        String amtFmt = this.getNumberFormat();
        List<String> fldsList = this.getReportFields();
        String field = null;
        ReportHead rptHead = new ReportHead();
        boolean addArApTitle = true;
        boolean addGLTitle = true;
        String system = this.isArRpt() ? "AR" : "AP";
        int n = fldsList.size();
        for (int i = 0; i < n; ++i) {
            ReportHeadCell headCell;
            field = fldsList.get(i).toString();
            if (addArApTitle && this.isArApColumn(field)) {
                headCell = new ReportHeadCell(system, 0, i, 9);
                rptHead.add(headCell);
                addArApTitle = false;
            }
            if (addGLTitle && this.isGLColumn(field)) {
                headCell = new ReportHeadCell("GL", 0, i, 3);
                rptHead.add(headCell);
                addGLTitle = false;
            }
            headCell = null;
            headCell = this.isDiffColumn(field) ? new ReportHeadCell(field, 0, i, 1) : new ReportHeadCell(field, 1, i, 0);
            if (COLUMN_FID.equals(field) || COLUMN_BILL_ID.equals(field) || COLUMN_VOUCHER_ID.equals(field) || COLUMN_IS_SUM.equals(field)) {
                headCell.setIsHide(true);
            } else if (COLUMN_AMOUNT.equals(field) || COLUMN_GL_AMOUNT.equals(field) || COLUMN_DIFF_AMOUNT.equals(field)) {
                headCell.setWidth(120);
                headCell.setDisplayFormat(amtFmt);
                headCell.setHAlign(Styles.HorizontalAlignment.RIGHT);
            }
            if (this.isMergeable(field)) {
                headCell.setIsMergeable(true);
            }
            if (field.equals(COLUMN_DIFF_TYPE)) {
                headCell.setWidth(370);
            }
            rptHead.add(headCell);
        }
        return rptHead;
    }

    private boolean isMergeable(String field) {
        boolean fMerge = false;
        fMerge = field.equals(COLUMN_BILL_TYPE) || field.equals(COLUMN_VOUCHER) || field.equals(COLUMN_GL_VOUCHER_PERIOD) || field.equals(COLUMN_GL_VOUCHER) || field.equals(COLUMN_GL_AMOUNT) || field.equals(COLUMN_DIFF_AMOUNT) || field.equals(COLUMN_DIFF_TYPE);
        return fMerge;
    }

    public List<String> getReportFields() {
        ArrayList<String> lstFlds = new ArrayList<String>(16);
        lstFlds.add(COLUMN_FID);
        lstFlds.add(COLUMN_BILL_TYPE);
        lstFlds.add(COLUMN_SCENE_NUMBER);
        lstFlds.add(COLUMN_BILL_ID);
        lstFlds.add(COLUMN_BILL_NUMBER);
        lstFlds.add(COLUMN_VOUCHER);
        lstFlds.add(COLUMN_BILL_DATE);
        lstFlds.add(COLUMN_AMOUNT);
        lstFlds.add(COLUMN_VOUCHER_ID);
        lstFlds.add(COLUMN_GL_VOUCHER_PERIOD);
        lstFlds.add(COLUMN_GL_VOUCHER);
        lstFlds.add(COLUMN_GL_AMOUNT);
        lstFlds.add(COLUMN_DIFF_AMOUNT);
        lstFlds.add(COLUMN_DIFF_TYPE);
        lstFlds.add(COLUMN_IS_SUM);
        return lstFlds;
    }

    public String getRptPreferenceSchemaKey() {
        return "com.kingdee.eas.fi.arap.client.ContrastGLRptDetailUI";
    }
}

