/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.WFInstanceV;
import com.kingdee.eas.fi.arap.app.AbstractARAPBillOfWFMessageControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ARAPBillOfWFMessageControllerBean
extends AbstractARAPBillOfWFMessageControllerBean {
    private static final long serialVersionUID = 9197683662808096550L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.ARAPBillOfWFMessageControllerBean");

    @Override
    protected Map _getWFCurrentNoteMessage(Context ctx, Set billIds) throws BOSException, EASBizException {
        Map messageMap;
        try {
            messageMap = this.findProcInstList(ctx, billIds);
        }
        catch (SQLException e) {
            messageMap = null;
            e.printStackTrace();
        }
        return messageMap;
    }

    protected Map findProcInstList(Context ctx, Set billId) throws BOSException, SQLException {
        if (billId == null || billId.size() <= 0) {
            return null;
        }
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)this.getQuerySql(billId));
        if (result == null) {
            return null;
        }
        HashMap messageMap = new HashMap();
        LinkedHashMap<String, WFInstanceV> voLinkedMap = null;
        String voKey = "";
        while (result.next()) {
            WFInstanceV vo;
            String bizId = ARAPBillOfWFMessageControllerBean.formatString(result.getString("FBIZOBJID"));
            String noteName = ARAPBillOfWFMessageControllerBean.formatString(result.getString("FACTDEFNAME"));
            String handler = ARAPBillOfWFMessageControllerBean.formatString(result.getString("FPERSONEMPNAME"));
            voLinkedMap = (LinkedHashMap<String, WFInstanceV>)messageMap.get(bizId);
            if (voLinkedMap == null) {
                voLinkedMap = new LinkedHashMap<String, WFInstanceV>();
                messageMap.put(bizId, voLinkedMap);
            }
            if (voLinkedMap.get(voKey = bizId + noteName) == null) {
                vo = new WFInstanceV();
                vo.setBillId(bizId);
                vo.setActdefname(noteName);
                ArrayList<String> handlerList = new ArrayList<String>();
                handlerList.add(handler);
                vo.setHandlerName(handlerList);
                voLinkedMap.put(voKey, vo);
                continue;
            }
            vo = (WFInstanceV)voLinkedMap.get(voKey);
            vo.getHandlerName().add(handler);
        }
        return this.formatMessage(messageMap);
    }

    protected Map formatMessage(Map messageMap) {
        if (messageMap == null) {
            return null;
        }
        for (LinkedHashMap voLinkedMap : messageMap.values()) {
            ArrayList<WFInstanceV> voList = new ArrayList<WFInstanceV>();
            for (Map.Entry entry : voLinkedMap.entrySet()) {
                voList.add((WFInstanceV)entry.getValue());
            }
            messageMap.put(((WFInstanceV)voList.get(0)).getBillId(), this.formatHandlerString(voList));
        }
        return messageMap;
    }

    protected String formatHandlerString(List<WFInstanceV> voList) {
        StringBuffer tempMessage = new StringBuffer();
        for (int i = 0; i < voList.size(); ++i) {
            Object obj;
            WFInstanceV vo = voList.get(i);
            tempMessage.append("[");
            tempMessage.append(vo.getActdefname() == null ? "" : vo.getActdefname());
            tempMessage.append("/");
            List handlerList = vo.getHandlerName();
            Iterator ite = handlerList.iterator();
            if (ite.hasNext() && (obj = ite.next()) != null) {
                tempMessage.append(obj.toString());
            }
            while (ite.hasNext()) {
                obj = ite.next();
                if (obj == null) continue;
                tempMessage.append(",");
                tempMessage.append(obj.toString());
            }
            tempMessage.append("]");
            if (i == voList.size() - 1) continue;
            tempMessage.append(" , ");
        }
        return tempMessage.toString();
    }

    protected String getQuerySql(Set<String> billId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT distinct ");
        sql.append(" ASSIGN.FACTDEFNAME_L2 AS FACTDEFNAME ,");
        sql.append(" ASSIGN.FPERSONEMPNAME_L2 AS FPERSONEMPNAME ,");
        sql.append(" ASSIGN.FBIZOBJID AS FBIZOBJID ,");
        sql.append(" CASE WHEN ASSIGN.FBIZPACKAGE = 'com.kingdee.eas.base.multiapprove.client' THEN 0 ELSE 1 END AS FLAG");
        sql.append(" FROM T_WFR_ProcInst AS PROCINST ");
        sql.append(" INNER JOIN T_WFR_Assign AS ASSIGN ON ASSIGN.FPROCINSTID=PROCINST.FPROCINSTID ");
        sql.append(" WHERE (PROCINST.FPROCDEFTYPE = 'NORMAL' OR PROCINST.FPROCDEFTYPE = 'MICRO') ");
        sql.append(" AND PROCINST.FSTATE LIKE 'open%' ");
        sql.append(" AND ASSIGN.FBIZOBJID in (").append(this.createFilter(billId)).append(")");
        sql.append(" ORDER BY FLAG,FACTDEFNAME,FPERSONEMPNAME");
        return sql.toString();
    }

    protected String createFilter(Set<String> billId) {
        StringBuffer filter = new StringBuffer();
        Iterator<String> ite = billId.iterator();
        if (ite.hasNext()) {
            filter.append("'").append((Object)ite.next()).append("'");
        }
        while (ite.hasNext()) {
            filter.append(",").append("'").append((Object)ite.next()).append("'");
        }
        return filter.toString();
    }

    protected static String formatString(Object string) {
        return string == null ? "" : string.toString();
    }
}

