/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CashDiscountCollection;
import com.kingdee.eas.basedata.assistant.CashDiscountFactory;
import com.kingdee.eas.basedata.assistant.CashDiscountInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICashDiscount;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeCollection;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.material.AsstAttrValueCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IAsstAttrValue;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeCollection;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupCollection;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupCollection;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupFactory;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.ExpenseTypeCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.IExpenseType;
import com.kingdee.eas.fi.ap.OtherBillPlanCollection;
import com.kingdee.eas.fi.ap.OtherBillPlanInfo;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseCollection;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.IncomeConfimBillInfo;
import com.kingdee.eas.fi.ar.IncomeConfimBillTypeEnum;
import com.kingdee.eas.fi.ar.IncomeConfimEntryCollection;
import com.kingdee.eas.fi.ar.IncomeConfimEntryInfo;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.ar.OtherBillentryCollection;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.fi.arap.check.ICalculateCheck;
import com.kingdee.eas.fi.arap.check.impl.ArApBackwardCalculateChecker;
import com.kingdee.eas.fi.arap.check.impl.ArApCalculateSimpleCheck;
import com.kingdee.eas.fi.arap.check.impl.ArApForwardCalculateChecker;
import com.kingdee.eas.fi.arap.check.impl.CalculateCheckComposer;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.cas.FundFlowItemCollection;
import com.kingdee.eas.fi.cas.FundFlowItemFactory;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeCollection;
import com.kingdee.eas.fi.cas.PaymentBillTypeFactory;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeCollection;
import com.kingdee.eas.fi.cas.ReceivingBillTypeFactory;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fm.pp.SetFundPropertyCollection;
import com.kingdee.eas.fm.pp.SetFundPropertyFactory;
import com.kingdee.eas.fm.pp.SetFundPropertyInfo;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryFactory;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryInfo;
import com.kingdee.eas.tools.datatask.IDIETemplateFieldEntry;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.sql.RowSet;

public class ARAPImportHelper {
    public static final String TEMPLATE_FIELD_MAP = "templateFieldMap";
    public static final String FCOREBILLSEQ = "FCoreBillSeq";
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final BigDecimal ONE = new BigDecimal("1.00");
    private static final ICalculateCheck<ArApBillBaseInfo> AR_AP_CALCULATE_SIMPLE_CHECK = new ArApCalculateSimpleCheck();

    public static AdminOrgUnitInfo getAdminOrgUnitInfo(Context ctx, Hashtable hsData, String field) throws BOSException, TaskExternalException {
        return ARAPImportHelper.getAdminOrgUnitInfo(ctx, hsData, field, null);
    }

    public static AdminOrgUnitInfo getAdminOrgUnitInfo(Context ctx, Hashtable hsData, String field, String cuId) throws BOSException, TaskExternalException {
        cuId = cuId == null ? "" : cuId;
        AdminOrgUnitInfo adminOrgUnit = null;
        String number = ARAPImportHelper.getDataString(hsData, field);
        if (number != null) {
            EntityViewInfo ev = ARAPImportHelper.getEntityViewByNum(number);
            ev.getSelector().add(new SelectorItemInfo("cu"));
            IAdminOrgUnit iAdminOrg = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            AdminOrgUnitCollection collection = iAdminOrg.getAdminOrgUnitCollection(ev);
            if (collection != null && collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    adminOrgUnit = collection.get(i);
                    if (adminOrgUnit.getCU() == null || !cuId.equals(adminOrgUnit.getCU().getId().toString())) continue;
                    return adminOrgUnit;
                }
                adminOrgUnit = collection.get(0);
            } else {
                throw new TaskExternalException(ARAPImportHelper.getString("AdminOrg_Is_Error", ctx));
            }
        }
        return adminOrgUnit;
    }

    public static PersonInfo getPersonInfo(Context ctx, Hashtable hsData, String field) throws BOSException, TaskExternalException {
        return ARAPImportHelper.getPersonInfo(ctx, hsData, field, null);
    }

    public static PersonInfo getPersonInfo(Context ctx, Hashtable hsData, String field, String cuId) throws BOSException, TaskExternalException {
        PersonInfo person = null;
        cuId = cuId == null ? "" : cuId;
        String number = ARAPImportHelper.getDataString(hsData, field);
        if (number != null) {
            EntityViewInfo ev = ARAPImportHelper.getEntityViewByNum(number);
            ev.getSelector().add(new SelectorItemInfo("cu"));
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            PersonCollection collection = iPerson.getPersonCollection(ev);
            if (collection != null && collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    person = collection.get(i);
                    if (person.getCU() == null || !cuId.equals(person.getCU().getId().toString())) continue;
                    return person;
                }
                person = collection.get(0);
            } else {
                ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, field);
            }
        }
        return person;
    }

    public static SaleOrgUnitInfo getSaleOrgUnitInfo(Context ctx, Hashtable hsData, String field) throws BOSException, TaskExternalException {
        return ARAPImportHelper.getSaleOrgUnitInfo(ctx, hsData, field, null);
    }

    public static SaleOrgUnitInfo getSaleOrgUnitInfo(Context ctx, Hashtable hsData, String field, String cuId) throws BOSException, TaskExternalException {
        cuId = cuId == null ? "" : cuId;
        SaleOrgUnitInfo saleOrgUnit = null;
        String number = ARAPImportHelper.getDataString(hsData, field);
        if (number != null) {
            EntityViewInfo ev = ARAPImportHelper.getEntityViewByNum(number);
            ev.getSelector().add(new SelectorItemInfo("cu"));
            ISaleOrgUnit iSaleOrg = SaleOrgUnitFactory.getLocalInstance((Context)ctx);
            SaleOrgUnitCollection collection = iSaleOrg.getSaleOrgUnitCollection(ev);
            if (collection != null && collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    saleOrgUnit = collection.get(i);
                    if (saleOrgUnit.getCU() == null || !cuId.equals(saleOrgUnit.getCU().getId().toString())) continue;
                    return saleOrgUnit;
                }
                saleOrgUnit = collection.get(0);
            } else {
                throw new TaskExternalException(ARAPImportHelper.getString("SaleOrg_Is_Error", ctx));
            }
        }
        return saleOrgUnit;
    }

    public static PurchaseOrgUnitInfo getPurchaseOrg(Context ctx, Hashtable hsData, String field) throws BOSException, TaskExternalException {
        return ARAPImportHelper.getPurchaseOrg(ctx, hsData, field, null);
    }

    public static PurchaseOrgUnitInfo getPurchaseOrg(Context ctx, Hashtable hsData, String field, String cuId) throws BOSException, TaskExternalException {
        cuId = cuId == null ? "" : cuId;
        PurchaseOrgUnitInfo info = null;
        String number = ARAPImportHelper.getDataString(hsData, field);
        if (number != null) {
            EntityViewInfo ev = ARAPImportHelper.getEntityViewByNum(number);
            ev.getSelector().add(new SelectorItemInfo("cu"));
            IPurchaseOrgUnit iPurOrg = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
            PurchaseOrgUnitCollection collection = iPurOrg.getPurchaseOrgUnitCollection(ev);
            if (collection != null && collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    info = collection.get(i);
                    if (info.getCU() == null || !cuId.equals(info.getCU().getId().toString())) continue;
                    return info;
                }
                info = collection.get(0);
            } else {
                throw new TaskExternalException(ARAPImportHelper.getString("PurOrg_Is_Error", ctx));
            }
        }
        return info;
    }

    public static AsstActTypeInfo getAsstActTypeInfo(Context ctx, Hashtable hsData, String field) throws BOSException, TaskExternalException {
        String number = ARAPImportHelper.getDataString(hsData, field);
        if (number == null) {
            throw new TaskExternalException(ARAPImportHelper.getString("AsstActTypeID_Null", ctx));
        }
        AsstActTypeInfo asstActTypeInfo = null;
        if (number != null) {
            IAsstActType iAsstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = ARAPImportHelper.getEntityViewByNum(number);
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
            AsstActTypeCollection collection = iAsstActType.getAsstActTypeCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                asstActTypeInfo = collection.get(0);
            }
        }
        if (asstActTypeInfo == null) {
            throw new TaskExternalException(ARAPImportHelper.getString("AsstActTypeID_Wrong", ctx));
        }
        return asstActTypeInfo;
    }

    public static CashDiscountInfo getCashDiscountInfo(Context ctx, Hashtable hsData, String field) throws BOSException, TaskExternalException {
        String number = ARAPImportHelper.getDataString(hsData, field);
        if (number != null) {
            ICashDiscount iCashDiscount = CashDiscountFactory.getLocalInstance((Context)ctx);
            CashDiscountCollection collection = iCashDiscount.getCashDiscountCollection(ARAPImportHelper.getEntityViewByNum(number));
            if (collection != null && collection.size() > 0) {
                return collection.get(0);
            }
            throw new TaskExternalException(ARAPImportHelper.getString("CashDiscount_Is_Error", ctx));
        }
        return null;
    }

    public static SettlementTypeInfo getSettlementTypeInfo(Context ctx, Hashtable hsData, String field) throws BOSException, TaskExternalException {
        String number = ARAPImportHelper.getDataString(hsData, field);
        if (number != null) {
            ISettlementType isettlement = SettlementTypeFactory.getLocalInstance((Context)ctx);
            SettlementTypeCollection collection = isettlement.getSettlementTypeCollection(ARAPImportHelper.getEntityViewByNum(number));
            if (collection != null && collection.size() > 0) {
                return collection.get(0);
            }
            throw new TaskExternalException(ARAPImportHelper.getString("SettleType_Is_Error", ctx));
        }
        return null;
    }

    public static CurrencyInfo getCurrencyInfo(Context ctx, Hashtable hsData, String field) throws BOSException, TaskExternalException {
        ICurrency icurreny;
        CurrencyCollection collection;
        CurrencyInfo currency = null;
        String number = ARAPImportHelper.getDataString(hsData, field);
        if (number == null) {
            throw new TaskExternalException(ARAPImportHelper.getString("FCurrencyID_IsNull", ctx));
        }
        if (number != null && (collection = (icurreny = CurrencyFactory.getLocalInstance((Context)ctx)).getCurrencyCollection(ARAPImportHelper.getEntityViewByNum(number))) != null && collection.size() > 0) {
            currency = collection.get(0);
        }
        if (currency == null) {
            throw new TaskExternalException(ARAPImportHelper.getString("CURRENCY_ERROR", ctx));
        }
        return currency;
    }

    public static CompanyOrgUnitInfo getCompany(Context ctx, Hashtable hsData, String field) throws BOSException, TaskExternalException {
        String selectorCols;
        ICompanyOrgUnit iCompanyOrgUnit;
        CompanyOrgUnitCollection collection;
        CompanyOrgUnitInfo companyInfo = null;
        String number = ARAPImportHelper.getDataString(hsData, field);
        if (number == null) {
            throw new TaskExternalException(ARAPImportHelper.getString("FCompanyID_IsNull", ctx));
        }
        if (number != null && (collection = (iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx)).getCompanyOrgUnitCollection(ARAPImportHelper.getEntityViewByNum(selectorCols = "id,number,name,baseExchangeTable.id,baseCurrency.id,baseCurrency.number,baseCurrency.name,baseCurrency.precision,CU.id,isBizUnit", number))) != null && collection.size() > 0) {
            companyInfo = collection.get(0);
        }
        if (companyInfo == null) {
            String msg = ARAPImportHelper.getString("COMPANY_NUMBER_ERROR", ctx);
            msg = MessageFormat.format(msg, field);
            throw new TaskExternalException(msg);
        }
        return companyInfo;
    }

    public static RowSet getAsstActInfo(Context ctx, String number, AsstActTypeInfo asstActTypeInfo) throws BOSException, TaskExternalException {
        String tableName = asstActTypeInfo.getRealtionDataObject();
        String groupID = asstActTypeInfo.getGlAsstActTypeGrp() == null ? null : asstActTypeInfo.getGlAsstActTypeGrp().getId().toString();
        String lang = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 FId as fid, Fnumber as fnumber,");
        sql.append("FName_").append(lang).append(" as fname ");
        sql.append("from " + tableName);
        if ("T_BD_GeneralAsstActType".equals(tableName) && groupID != null) {
            if (number != null) {
                number = number.replaceAll("\\.", "\\!");
            }
            sql.append(" where FLongNumber = '" + number + "'");
            sql.append(" and fgroupId = '" + groupID + "'");
        } else {
            sql.append(" where FNumber = '" + number + "'");
        }
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return result;
    }

    public static PaymentTypeInfo getPaymentTypeInfo(Context ctx, Hashtable hsData, String field) throws BOSException, TaskExternalException {
        PaymentTypeCollection payColl;
        PaymentTypeInfo payType = null;
        String number = ARAPImportHelper.getDataString(hsData, field);
        if (number == null) {
            throw new TaskExternalException(ARAPImportHelper.getString("PaymentType_Is_Null", ctx));
        }
        if (number != null && (payColl = PaymentTypeFactory.getLocalInstance((Context)ctx).getPaymentTypeCollection(ARAPImportHelper.getEntityViewByNum(number))) != null && payColl.size() > 0) {
            payType = payColl.get(0);
        }
        if (payType == null) {
            throw new TaskExternalException(ARAPImportHelper.getString("PaymentType_Is_Error", ctx));
        }
        return payType;
    }

    private static EntityViewInfo getEntityViewByNum(String number) {
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.getSelector().add(new SelectorItemInfo("id"));
        entityView.getSelector().add(new SelectorItemInfo("number"));
        entityView.getSelector().add(new SelectorItemInfo("name"));
        entityView.getSelector().add(new SelectorItemInfo("precision"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        entityView.setFilter(filter);
        return entityView;
    }

    private static EntityViewInfo getEntityViewByNumAndCu(String number, String cuId) {
        EntityViewInfo ev = ARAPImportHelper.getEntityViewByNum(number);
        ev.getFilter().getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        return ev;
    }

    public static EntityViewInfo getEntityViewByNum(String selectorColumns, String number) {
        String[] selectorArr;
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        SelectorItemInfo info = null;
        for (String name : selectorArr = selectorColumns.split(",")) {
            info = new SelectorItemInfo(name);
            selectorCol.add(info);
        }
        viewInfo.setSelector(selectorCol);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    public static SaleGroupInfo getSaleGroupInfo(Context ctx, Hashtable hsData, String field) throws BOSException, TaskExternalException {
        return ARAPImportHelper.getSaleGroupInfo(ctx, hsData, field, null);
    }

    public static SaleGroupInfo getSaleGroupInfo(Context ctx, Hashtable hsData, String field, String cuId) throws BOSException, TaskExternalException {
        cuId = cuId == null ? "" : cuId;
        String number = ARAPImportHelper.getDataString(hsData, field);
        SaleGroupInfo saleGroup = null;
        if (number != null) {
            EntityViewInfo ev = ARAPImportHelper.getEntityViewByNum(number);
            ev.getSelector().add(new SelectorItemInfo("cu"));
            SaleGroupCollection saleColl = SaleGroupFactory.getLocalInstance((Context)ctx).getSaleGroupCollection(ev);
            if (saleColl != null && saleColl.size() > 0) {
                for (int i = 0; i < saleColl.size(); ++i) {
                    saleGroup = saleColl.get(i);
                    if (saleGroup.getCU() == null || !cuId.equals(saleGroup.getCU().getId().toString())) continue;
                    return saleGroup;
                }
                saleGroup = saleColl.get(0);
            } else {
                throw new TaskExternalException(ARAPImportHelper.getString("SaleGroup_Is_Error", ctx));
            }
        }
        return saleGroup;
    }

    public static PurchaseGroupInfo getPurchaseGroupInfo(Context ctx, Hashtable hsData, String field) throws BOSException, TaskExternalException {
        return ARAPImportHelper.getPurchaseGroupInfo(ctx, hsData, field, null);
    }

    public static PurchaseGroupInfo getPurchaseGroupInfo(Context ctx, Hashtable hsData, String field, String cuId) throws BOSException, TaskExternalException {
        cuId = cuId == null ? "" : cuId;
        String number = ARAPImportHelper.getDataString(hsData, field);
        PurchaseGroupInfo purGroup = null;
        if (number != null) {
            EntityViewInfo ev = ARAPImportHelper.getEntityViewByNum(number);
            ev.getSelector().add(new SelectorItemInfo("cu"));
            PurchaseGroupCollection purGroupColl = PurchaseGroupFactory.getLocalInstance((Context)ctx).getPurchaseGroupCollection(ev);
            if (purGroupColl != null && purGroupColl.size() > 0) {
                for (int i = 0; i < purGroupColl.size(); ++i) {
                    purGroup = purGroupColl.get(i);
                    if (purGroup.getCU() == null || !cuId.equals(purGroup.getCU().getId().toString())) continue;
                    return purGroup;
                }
                purGroup = purGroupColl.get(0);
            } else {
                throw new TaskExternalException(ARAPImportHelper.getString("PurGroup_Is_Error", ctx));
            }
        }
        return purGroup;
    }

    public static MaterialInfo getMaterialInfo(Context ctx, Hashtable hsData, String field) throws TaskExternalException, BOSException {
        MaterialInfo info = null;
        String number = ARAPImportHelper.getDataString(hsData, field);
        if (number != null) {
            IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = ARAPImportHelper.getEntityViewByNum(number);
            view.getSelector().add(new SelectorItemInfo("baseUnit"));
            view.getSelector().add(new SelectorItemInfo("assistAttr"));
            view.getSelector().add(new SelectorItemInfo("assistUnit"));
            view.getSelector().add(new SelectorItemInfo("model"));
            view.getSelector().add(new SelectorItemInfo("pricePrecision"));
            MaterialCollection collection = iMaterial.getMaterialCollection(view);
            if (collection != null && collection.size() > 0) {
                info = collection.get(0);
            } else {
                ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, field);
            }
        }
        return info;
    }

    public static MeasureUnitInfo getMeasureUnitInfo(Context ctx, Hashtable hsData, String field) throws TaskExternalException, BOSException {
        String number = ARAPImportHelper.getDataString(hsData, field);
        MeasureUnitInfo info = null;
        if (number != null) {
            IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
            MeasureUnitCollection collection = iMeasureUnit.getMeasureUnitCollection(ARAPImportHelper.getEntityViewByNum(number));
            if (collection != null && collection.size() > 0) {
                info = collection.get(0);
            } else {
                ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, field);
            }
        }
        return info;
    }

    public static AsstAttrValueInfo getAsstAttrValueInfo(Context ctx, Hashtable hsData, String field) throws TaskExternalException, BOSException {
        String number = ARAPImportHelper.getDataString(hsData, field);
        AsstAttrValueInfo info = null;
        if (number != null) {
            IAsstAttrValue iAsstAttrValue = AsstAttrValueFactory.getLocalInstance((Context)ctx);
            AsstAttrValueCollection collection = iAsstAttrValue.getAsstAttrValueCollection(ARAPImportHelper.getEntityViewByNum(number));
            if (collection != null && collection.size() > 0) {
                info = collection.get(0);
            } else {
                ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, field);
            }
        }
        return info;
    }

    public static AccountViewInfo getAccountViewInfo(Context ctx, Hashtable hsData, String field, String companyID) throws TaskExternalException, BOSException {
        String number = ARAPImportHelper.getDataString(hsData, field);
        AccountViewInfo info = null;
        if (number != null) {
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add("accountTableID.id");
            selectorItemCollection.add("isLeaf");
            IAccountView iAccount = AccountViewFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            if (companyID == null) {
                company = ContextUtil.getCurrentFIUnit((Context)ctx);
                companyID = company.getId().toString();
            } else {
                try {
                    company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
            }
            EntityViewInfo viewInfo = ARAPImportHelper.getEntityViewByNum(number);
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyID));
            viewInfo.setSelector(selectorItemCollection);
            AccountViewCollection collection = iAccount.getAccountViewCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                for (int i = 0; !(i >= collection.size() || (info = collection.get(i)).getAccountTableID() != null && company.getAccountTable() != null && info.getAccountTableID().getId().toString().equals(company.getAccountTable().getId().toString())); ++i) {
                    if (i != collection.size() - 1) continue;
                    ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, field);
                }
            } else {
                ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, field);
            }
        }
        return info;
    }

    public static ExpenseTypeInfo getExpenseItemInfo(Context ctx, Hashtable hsData, String field) throws TaskExternalException, BOSException {
        ExpenseTypeInfo info = null;
        String number = ARAPImportHelper.getDataString(hsData, field);
        if (number != null) {
            IExpenseType iExpenseItem = ExpenseTypeFactory.getLocalInstance((Context)ctx);
            ExpenseTypeCollection collection = iExpenseItem.getExpenseTypeCollection(ARAPImportHelper.getEntityViewByNum(number));
            if (collection != null && collection.size() > 0) {
                info = collection.get(0);
            } else {
                ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, field);
            }
        }
        return info;
    }

    public static DiscountModeEnum getDiscountTypeInfo(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        String str = ARAPImportHelper.getDataString(hsData, field);
        DiscountModeEnum retValue = DiscountModeEnum.NULL;
        if (str != null && str.length() > 0) {
            int value = 0;
            try {
                value = Integer.parseInt(str);
            }
            catch (Exception e) {
                throw new TaskExternalException(ARAPImportHelper.getString("DiscountType_Error", ctx));
            }
            switch (value) {
                case -1: {
                    break;
                }
                case 0: {
                    retValue = DiscountModeEnum.PERCENT;
                    break;
                }
                case 1: {
                    retValue = DiscountModeEnum.PERUNIT;
                    break;
                }
                default: {
                    throw new TaskExternalException(ARAPImportHelper.getString("DiscountType_Error", ctx));
                }
            }
        }
        return retValue;
    }

    public static boolean getDataboolean(Hashtable hsData, String field) {
        String str = ARAPImportHelper.getDataString(hsData, field);
        if (str == null) {
            return false;
        }
        return str.equalsIgnoreCase("Y") || str.equals("1") || str.equalsIgnoreCase("true") || str.equalsIgnoreCase("\u662f") || str.equalsIgnoreCase("YES");
    }

    public static BigDecimal getBaseUnitQty(Context ctx, MeasureUnitInfo mui, MaterialInfo mi, BigDecimal qty) throws BaseException {
        BigDecimal coefficient;
        BigDecimal baseQty = new BigDecimal("0.00000");
        if (qty != null) {
            baseQty = qty;
        } else {
            qty = baseQty;
        }
        MultiMeasureUnitInfo mulUnit = ARAPImportHelper.getMulUnit(ctx, mui, mi);
        if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
            baseQty = qty.multiply(coefficient);
            MeasureUnitInfo baseUnit = mi.getBaseUnit();
            if (baseUnit == null) {
                IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
                baseUnit = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(mi.getId())).getBaseUnit();
            }
            mulUnit = ARAPImportHelper.getMulUnit(ctx, baseUnit, mi);
            int precision = mulUnit.getQtyPrecision();
            baseQty = baseQty.setScale(precision, 4);
        }
        return baseQty;
    }

    public static MultiMeasureUnitInfo getMulUnit(Context ctx, MeasureUnitInfo mui, MaterialInfo mi) throws BaseException {
        MultiMeasureUnitInfo mulUnit = null;
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        if (mui != null && mi != null) {
            mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
        }
        return mulUnit;
    }

    private static ObjectUuidPK getCompanyPK(Context ctx) throws TaskExternalException {
        CompanyOrgUnitInfo comobj = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (comobj == null || comobj.isIsOnlyUnion()) {
            throw new TaskExternalException(ARAPImportHelper.getString("changBizCom", ctx));
        }
        return new ObjectUuidPK(BOSUuid.read((String)comobj.get("id").toString()));
    }

    public static ExchangeRateInfo getExchangeRateInfo(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo currencyInfo) throws Exception {
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK destCurrpk = null;
        if (companyOrgUnitInfo == null) {
            companyOrgUnitInfo = ARAPImportHelper.getCompanyInfo(ctx);
        }
        if (companyOrgUnitInfo.getBaseExchangeTable() == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(companyOrgUnitInfo.getBaseExchangeTable().getId());
        CurrencyInfo baseCur = companyOrgUnitInfo.getBaseCurrency();
        if (baseCur != null) {
            if (baseCur.getId().equals((Object)currencyInfo.getId())) {
                return null;
            }
        } else {
            return null;
        }
        destCurrpk = new ObjectUuidPK(baseCur.getId());
        iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(currencyInfo.getId());
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, Calendar.getInstance().getTime());
        return erInfo;
    }

    private static CompanyOrgUnitInfo getCompanyInfo(Context ctx) throws Exception {
        CompanyOrgUnitInfo defalutOrgInfo = null;
        ObjectUuidPK compk = ARAPImportHelper.getCompanyPK(ctx);
        ICompanyOrgUnit comorg = null;
        comorg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("baseCurrency"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("baseExchangeTable"));
        sic.add(new SelectorItemInfo("CU.*"));
        sic.add(new SelectorItemInfo("invalidDate"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        defalutOrgInfo = comorg.getCompanyOrgUnitInfo((IObjectPK)compk, sic);
        return defalutOrgInfo;
    }

    public static OtherBillTypeEnum getARBillType(Hashtable hsData, String field) throws TaskExternalException {
        OtherBillTypeEnum billTypeEnum = null;
        int tempType = ARAPImportHelper.getDataInt(hsData, field);
        if (tempType == 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"147_ARAPImportHelper", (Locale)SysContext.getSysContext().getLocale()));
        }
        switch (ARAPImportHelper.getDataInt(hsData, field)) {
            case 101: {
                billTypeEnum = OtherBillTypeEnum.OtherReceivable;
                break;
            }
            case 102: {
                billTypeEnum = OtherBillTypeEnum.InvoiceBill;
                break;
            }
            case 103: {
                billTypeEnum = OtherBillTypeEnum.ExpenseInvoice;
                break;
            }
            case 104: {
                billTypeEnum = OtherBillTypeEnum.DebitAdjust;
            }
        }
        if (billTypeEnum == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"148_ARAPImportHelper", (Locale)SysContext.getSysContext().getLocale()));
        }
        return billTypeEnum;
    }

    public static OtherBillType getAPBillType(Hashtable hsData, String field) throws TaskExternalException {
        OtherBillType billTypeEnum = null;
        int billType = ARAPImportHelper.getDataInt(hsData, field);
        if (billType == 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"147_ARAPImportHelper", (Locale)SysContext.getSysContext().getLocale()));
        }
        switch (billType) {
            case 201: {
                billTypeEnum = OtherBillType.OtherPay;
                break;
            }
            case 202: {
                billTypeEnum = OtherBillType.InvoiceBill;
                break;
            }
            case 203: {
                billTypeEnum = OtherBillType.ExpenseInvoice;
                break;
            }
            case 204: {
                billTypeEnum = OtherBillType.DebitAdjust;
            }
        }
        if (billTypeEnum == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"148_ARAPImportHelper", (Locale)SysContext.getSysContext().getLocale()));
        }
        return billTypeEnum;
    }

    public static IncomeConfimBillTypeEnum getIncomeConfirmBillType(Hashtable hsData, String field) throws TaskExternalException {
        IncomeConfimBillTypeEnum billTypeEnum = null;
        int billType = ARAPImportHelper.getDataInt(hsData, field);
        if (billType == 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"147_ARAPImportHelper", (Locale)SysContext.getSysContext().getLocale()));
        }
        switch (billType) {
            case 301: {
                billTypeEnum = IncomeConfimBillTypeEnum.SALE_INCOME;
                break;
            }
            case 302: {
                billTypeEnum = IncomeConfimBillTypeEnum.SALE_EXPENSE_INCOME;
                break;
            }
            case 303: {
                billTypeEnum = IncomeConfimBillTypeEnum.OTHER_INCOME;
            }
        }
        if (billTypeEnum == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"148_ARAPImportHelper", (Locale)SysContext.getSysContext().getLocale()));
        }
        return billTypeEnum;
    }

    protected static void setAPBillAmtFromEntry(com.kingdee.eas.fi.ap.OtherBillInfo otherBillInfo, com.kingdee.eas.fi.ap.OtherBillentryInfo otherBillentryInfo, boolean isUpdateEntry) {
        com.kingdee.eas.fi.ap.OtherBillentryCollection c = otherBillInfo.getEntry();
        BigDecimal temp = new BigDecimal(0);
        BigDecimal tempVeriy = new BigDecimal(0);
        BigDecimal tempUnVeriy = new BigDecimal(0);
        BigDecimal tempAmountLocal = new BigDecimal(0);
        BigDecimal tempVerifyAmountLocal = new BigDecimal(0);
        BigDecimal tempUnVeriyAmountLocal = new BigDecimal(0);
        BigDecimal exchangeRate = otherBillInfo.getExchangeRate();
        boolean isRedBill = otherBillentryInfo.isRed();
        ArApBillHelper.handleRedBill((IObjectValue)otherBillentryInfo, isRedBill);
        if (c.size() == 0) {
            temp = temp.add(otherBillentryInfo.getRecievePayAmount());
            tempUnVeriy = tempUnVeriy.add(otherBillentryInfo.getUnVerifyAmount());
            tempVeriy = tempVeriy.add(otherBillentryInfo.getVerifyAmount());
            tempAmountLocal = tempAmountLocal.add(otherBillentryInfo.getRecievePayAmountLocal());
            tempVerifyAmountLocal = tempVerifyAmountLocal.add(otherBillentryInfo.getVerifyAmountLocal());
            tempUnVeriyAmountLocal = tempUnVeriyAmountLocal.add(otherBillentryInfo.getUnVerifyAmountLocal());
        } else {
            Iterator itrEntry = c.iterator();
            if (!isUpdateEntry) {
                while (itrEntry.hasNext()) {
                    com.kingdee.eas.fi.ap.OtherBillentryInfo entryTmp = (com.kingdee.eas.fi.ap.OtherBillentryInfo)itrEntry.next();
                    temp = temp.add(entryTmp.getRecievePayAmount());
                    tempUnVeriy = tempUnVeriy.add(entryTmp.getUnVerifyAmount());
                    tempVeriy = tempVeriy.add(entryTmp.getVerifyAmount());
                    tempAmountLocal = tempAmountLocal.add(entryTmp.getRecievePayAmountLocal());
                    tempVerifyAmountLocal = tempVerifyAmountLocal.add(entryTmp.getVerifyAmountLocal());
                    tempUnVeriyAmountLocal = tempUnVeriyAmountLocal.add(entryTmp.getUnVerifyAmountLocal());
                }
                temp = temp.add(otherBillentryInfo.getRecievePayAmount());
                tempUnVeriy = tempUnVeriy.add(otherBillentryInfo.getUnVerifyAmount());
                tempVeriy = tempVeriy.add(otherBillentryInfo.getVerifyAmount());
                tempAmountLocal = tempAmountLocal.add(otherBillentryInfo.getRecievePayAmountLocal());
                tempVerifyAmountLocal = tempVerifyAmountLocal.add(otherBillentryInfo.getVerifyAmountLocal());
                tempUnVeriyAmountLocal = tempUnVeriyAmountLocal.add(otherBillentryInfo.getUnVerifyAmountLocal());
            } else {
                while (itrEntry.hasNext()) {
                    com.kingdee.eas.fi.ap.OtherBillentryInfo entryTmp = (com.kingdee.eas.fi.ap.OtherBillentryInfo)itrEntry.next();
                    if (entryTmp.getSeq() == otherBillentryInfo.getSeq()) {
                        temp = temp.add(otherBillentryInfo.getRecievePayAmount());
                        tempUnVeriy = tempUnVeriy.add(otherBillentryInfo.getUnVerifyAmount());
                        tempVeriy = tempVeriy.add(otherBillentryInfo.getVerifyAmount());
                        tempAmountLocal = tempAmountLocal.add(otherBillentryInfo.getRecievePayAmountLocal());
                        tempVerifyAmountLocal = tempVerifyAmountLocal.add(otherBillentryInfo.getVerifyAmountLocal());
                        tempUnVeriyAmountLocal = tempUnVeriyAmountLocal.add(otherBillentryInfo.getUnVerifyAmountLocal());
                        continue;
                    }
                    temp = temp.add(entryTmp.getRecievePayAmount());
                    tempUnVeriy = tempUnVeriy.add(entryTmp.getUnVerifyAmount());
                    tempVeriy = tempVeriy.add(entryTmp.getVerifyAmount());
                    tempAmountLocal = tempAmountLocal.add(entryTmp.getRecievePayAmountLocal());
                    tempVerifyAmountLocal = tempVerifyAmountLocal.add(entryTmp.getVerifyAmountLocal());
                    tempUnVeriyAmountLocal = tempUnVeriyAmountLocal.add(entryTmp.getUnVerifyAmountLocal());
                }
            }
        }
        otherBillInfo.setAmount(temp);
        otherBillInfo.setUnVerifyAmount(tempUnVeriy);
        otherBillInfo.setVerifyAmount(tempVeriy);
        otherBillInfo.setAmountLocal(tempAmountLocal);
        otherBillInfo.setVerifyAmountLocal(tempVerifyAmountLocal);
        otherBillInfo.setUnVerifyAmountLocal(tempUnVeriyAmountLocal);
        exchangeRate = exchangeRate.compareTo(ZERO) == 0 ? ONE : exchangeRate;
        otherBillInfo.setExchangeRate(exchangeRate);
    }

    public static void setARBillAmtFromEntry(OtherBillInfo otherBillInfo, OtherBillentryInfo otherBillentryInfo, boolean isUpdateEntry) {
        OtherBillentryCollection c = otherBillInfo.getEntry();
        BigDecimal temp = new BigDecimal(0);
        BigDecimal tempAmountLocal = new BigDecimal(0);
        BigDecimal tempVeriy = new BigDecimal(0);
        BigDecimal tempUnVeriy = new BigDecimal(0);
        BigDecimal tempVerifyAmountLocal = new BigDecimal(0);
        BigDecimal tempUnVeriyAmountLocal = new BigDecimal(0);
        BigDecimal exchangeRate = otherBillInfo.getExchangeRate();
        boolean isRedBill = otherBillentryInfo.isRed();
        ArApBillHelper.handleRedBill((IObjectValue)otherBillentryInfo, isRedBill);
        if (c.size() == 0) {
            temp = temp.add(otherBillentryInfo.getRecievePayAmount());
            tempAmountLocal = tempAmountLocal.add(otherBillentryInfo.getRecievePayAmountLocal());
            tempUnVeriy = tempUnVeriy.add(otherBillentryInfo.getUnVerifyAmount());
            tempVeriy = tempVeriy.add(otherBillentryInfo.getVerifyAmount());
            tempVerifyAmountLocal = tempVerifyAmountLocal.add(otherBillentryInfo.getVerifyAmountLocal());
            tempUnVeriyAmountLocal = tempUnVeriyAmountLocal.add(otherBillentryInfo.getUnVerifyAmountLocal());
        } else {
            Iterator itrEntry = c.iterator();
            if (!isUpdateEntry) {
                while (itrEntry.hasNext()) {
                    OtherBillentryInfo entryTmp = (OtherBillentryInfo)itrEntry.next();
                    temp = temp.add(entryTmp.getRecievePayAmount());
                    tempAmountLocal = tempAmountLocal.add(entryTmp.getRecievePayAmountLocal());
                    tempUnVeriy = tempUnVeriy.add(entryTmp.getUnVerifyAmount());
                    tempVeriy = tempVeriy.add(entryTmp.getVerifyAmount());
                    tempVerifyAmountLocal = tempVerifyAmountLocal.add(entryTmp.getVerifyAmountLocal());
                    tempUnVeriyAmountLocal = tempUnVeriyAmountLocal.add(entryTmp.getUnVerifyAmountLocal());
                }
                temp = temp.add(otherBillentryInfo.getRecievePayAmount());
                tempAmountLocal = tempAmountLocal.add(otherBillentryInfo.getRecievePayAmountLocal());
                tempUnVeriy = tempUnVeriy.add(otherBillentryInfo.getUnVerifyAmount());
                tempVeriy = tempVeriy.add(otherBillentryInfo.getVerifyAmount());
                tempVerifyAmountLocal = tempVerifyAmountLocal.add(otherBillentryInfo.getVerifyAmountLocal());
                tempUnVeriyAmountLocal = tempUnVeriyAmountLocal.add(otherBillentryInfo.getUnVerifyAmountLocal());
            } else {
                while (itrEntry.hasNext()) {
                    OtherBillentryInfo entryTmp = (OtherBillentryInfo)itrEntry.next();
                    if (entryTmp.getSeq() == otherBillentryInfo.getSeq()) {
                        temp = temp.add(otherBillentryInfo.getRecievePayAmount());
                        tempAmountLocal = tempAmountLocal.add(otherBillentryInfo.getRecievePayAmountLocal());
                        tempUnVeriy = tempUnVeriy.add(otherBillentryInfo.getUnVerifyAmount());
                        tempVeriy = tempVeriy.add(otherBillentryInfo.getVerifyAmount());
                        tempVerifyAmountLocal = tempVerifyAmountLocal.add(otherBillentryInfo.getVerifyAmountLocal());
                        tempUnVeriyAmountLocal = tempUnVeriyAmountLocal.add(otherBillentryInfo.getUnVerifyAmountLocal());
                        continue;
                    }
                    temp = temp.add(entryTmp.getRecievePayAmount());
                    tempAmountLocal = tempAmountLocal.add(entryTmp.getRecievePayAmountLocal());
                    tempUnVeriy = tempUnVeriy.add(entryTmp.getUnVerifyAmount());
                    tempVeriy = tempVeriy.add(entryTmp.getVerifyAmount());
                    tempVerifyAmountLocal = tempVerifyAmountLocal.add(entryTmp.getVerifyAmountLocal());
                    tempUnVeriyAmountLocal = tempUnVeriyAmountLocal.add(entryTmp.getUnVerifyAmountLocal());
                }
            }
        }
        otherBillInfo.setAmount(temp);
        otherBillInfo.setAmountLocal(tempAmountLocal);
        otherBillInfo.setUnVerifyAmount(tempUnVeriy);
        otherBillInfo.setVerifyAmount(tempVeriy);
        otherBillInfo.setVerifyAmountLocal(tempVerifyAmountLocal);
        otherBillInfo.setUnVerifyAmountLocal(tempUnVeriyAmountLocal);
        exchangeRate = exchangeRate.compareTo(ZERO) == 0 ? ONE : exchangeRate;
        otherBillInfo.setExchangeRate(exchangeRate);
    }

    public static void setIncomeConfirmBillAmtFromEntry(IncomeConfimBillInfo billInfo, IncomeConfimEntryInfo otherBillentryInfo, boolean isUpdateEntry) {
        IncomeConfimEntryCollection c = billInfo.getEntry();
        BigDecimal temp = new BigDecimal(0);
        BigDecimal tempAmountLocal = new BigDecimal(0);
        BigDecimal exchangeRate = billInfo.getExchangeRate();
        boolean isRedBill = otherBillentryInfo.isRed();
        ArApBillHelper.handleRedBill((IObjectValue)otherBillentryInfo, isRedBill);
        if (c.size() == 0) {
            temp = temp.add(otherBillentryInfo.getRecievePayAmount());
            tempAmountLocal = tempAmountLocal.add(otherBillentryInfo.getRecievePayAmountLocal());
        } else {
            Iterator itrEntry = c.iterator();
            if (!isUpdateEntry) {
                while (itrEntry.hasNext()) {
                    OtherBillentryInfo entryTmp = (OtherBillentryInfo)itrEntry.next();
                    temp = temp.add(entryTmp.getRecievePayAmount());
                    tempAmountLocal = tempAmountLocal.add(entryTmp.getRecievePayAmountLocal());
                }
                temp = temp.add(otherBillentryInfo.getRecievePayAmount());
                tempAmountLocal = tempAmountLocal.add(otherBillentryInfo.getRecievePayAmountLocal());
            } else {
                while (itrEntry.hasNext()) {
                    OtherBillentryInfo entryTmp = (OtherBillentryInfo)itrEntry.next();
                    if (entryTmp.getSeq() == otherBillentryInfo.getSeq()) {
                        temp = temp.add(otherBillentryInfo.getRecievePayAmount());
                        tempAmountLocal = tempAmountLocal.add(otherBillentryInfo.getRecievePayAmountLocal());
                        continue;
                    }
                    temp = temp.add(entryTmp.getRecievePayAmount());
                    tempAmountLocal = tempAmountLocal.add(entryTmp.getRecievePayAmountLocal());
                }
            }
        }
        billInfo.setAmount(temp);
        billInfo.setAmountLocal(tempAmountLocal);
        exchangeRate = exchangeRate.compareTo(ZERO) == 0 ? ONE : exchangeRate;
        billInfo.setExchangeRate(exchangeRate);
    }

    protected static boolean checkAPAmtIsOver(com.kingdee.eas.fi.ap.OtherBillInfo otherBillInfo, OtherBillPlanInfo planInfo, boolean isUpdatePlan) {
        boolean flag = false;
        OtherBillPlanCollection collection = otherBillInfo.getPayPlan();
        BigDecimal temp = new BigDecimal("0.00");
        BigDecimal amount = otherBillInfo.getAmount();
        Iterator iter = collection.iterator();
        if (!isUpdatePlan) {
            while (iter.hasNext()) {
                OtherBillPlanInfo tempPlanInfo = (OtherBillPlanInfo)iter.next();
                temp = temp.add(tempPlanInfo.getRecievePayAmount());
            }
            temp = temp.add(planInfo.getRecievePayAmount());
        } else {
            while (iter.hasNext()) {
                OtherBillPlanInfo tempPlanInfo = (OtherBillPlanInfo)iter.next();
                if (tempPlanInfo.getSeq() == planInfo.getSeq()) {
                    temp = temp.add(planInfo.getRecievePayAmount());
                    continue;
                }
                temp = temp.add(tempPlanInfo.getRecievePayAmount());
            }
        }
        if (temp.compareTo(amount) > 0) {
            flag = true;
        }
        return flag;
    }

    public static String getString(String resName, Context ctx) {
        return ARAPImportHelper.getString("AR", resName, ctx);
    }

    public static String getString(String SysType, String resName, Context ctx) {
        String AR_RESOURCE_PATH = "com.kingdee.eas.fi.ar.ARImportData";
        String AP_RESOURCE_PATH = "com.kingdee.eas.fi.ap.APImportData";
        if (SysType.equalsIgnoreCase("AR")) {
            return ResourceBase.getString((String)AR_RESOURCE_PATH, (String)resName, (Locale)ctx.getLocale());
        }
        if (SysType.equalsIgnoreCase("AP")) {
            return ResourceBase.getString((String)AP_RESOURCE_PATH, (String)resName, (Locale)ctx.getLocale());
        }
        return null;
    }

    public static String getDataString(Hashtable hsData, String field) {
        DataToken dt;
        String reStr = null;
        if (hsData != null && field != null && field.trim().length() > 0 && (dt = (DataToken)hsData.get(field)) != null && dt.data != null && dt.data.toString().trim().length() > 0) {
            reStr = dt.data.toString().trim();
        }
        return reStr;
    }

    public static Date getDataDate(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        String reStr = ARAPImportHelper.getDataString(hsData, field);
        if (reStr == null) {
            return null;
        }
        return ExcelUtil.formatNationalDate((Context)ctx, (String)reStr);
    }

    public static BigDecimal getDataDeciaml(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        BigDecimal reVal = ZERO;
        String reStr = ARAPImportHelper.getDataString(hsData, field);
        if (reStr != null) {
            try {
                reVal = new BigDecimal(reStr);
            }
            catch (Exception nex) {
                String msg = ARAPImportHelper.getString("NumberField_Wrong", ctx);
                msg = MessageFormat.format(msg, field);
                throw new TaskExternalException(msg);
            }
        }
        return reVal;
    }

    public static int getDataInt(Hashtable hsData, String field) throws TaskExternalException {
        int reInt = 0;
        String reStr = ARAPImportHelper.getDataString(hsData, field);
        if (reStr != null) {
            try {
                reInt = Integer.parseInt(reStr);
            }
            catch (Exception e) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"149_ARAPImportHelper", (Locale)SysContext.getSysContext().getLocale()));
            }
        }
        return reInt;
    }

    public static BillTypeInfo getBillType(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        BillTypeInfo billType = null;
        String number = ARAPImportHelper.getDataString(hsData, field);
        try {
            if (number != null) {
                BillTypeCollection billTypes = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeCollection(ARAPImportHelper.getEntityViewByNum(number));
                if (billTypes == null || billTypes.size() == 0) {
                    throw new TaskExternalException(ARAPImportHelper.getString("CoreBillTypeError", ctx));
                }
                billType = billTypes.get(0);
            }
        }
        catch (BOSException ex) {
            throw new TaskExternalException(ARAPImportHelper.getString("CoreBillTypeError", ctx), (Throwable)ex);
        }
        return billType;
    }

    public static int getCoreBillSeq(Context ctx, Hashtable hsData) throws TaskExternalException {
        return ARAPImportHelper.getCoreBillSeq(ctx, hsData, FCOREBILLSEQ);
    }

    public static int getCoreBillSeq(Context ctx, Hashtable hsData, String filedName) throws TaskExternalException {
        int seq = 0;
        try {
            seq = ARAPImportHelper.getDataInt(hsData, filedName);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ARAPImportHelper.getString("CoreBillSeqError", ctx), (Throwable)ex);
        }
        return seq;
    }

    public static PaymentBillTypeInfo getPaymentBillType(Context ctx, Hashtable hsData, String filedName) throws TaskExternalException {
        PaymentBillTypeInfo payTypeInfo = null;
        String number = ARAPImportHelper.getDataString(hsData, filedName);
        if (number != null) {
            try {
                PaymentBillTypeCollection colls = PaymentBillTypeFactory.getLocalInstance((Context)ctx).getPaymentBillTypeCollection(ARAPImportHelper.getEntityViewByNum(number));
                if (colls != null && colls.size() > 0) {
                    payTypeInfo = colls.get(0);
                }
            }
            catch (BOSException e) {
                throw new TaskExternalException(ARAPImportHelper.getString("PayBillType_Is_Null", ctx), (Throwable)e);
            }
        }
        if (payTypeInfo == null) {
            throw new TaskExternalException(ARAPImportHelper.getString("PayBillType_Is_Null", ctx));
        }
        return payTypeInfo;
    }

    public static ReceivingBillTypeInfo getReceivingBillType(Context ctx, Hashtable hsData, String filedName) throws TaskExternalException {
        ReceivingBillTypeInfo recTypeInfo = null;
        String number = ARAPImportHelper.getDataString(hsData, filedName);
        if (number != null) {
            try {
                ReceivingBillTypeCollection colls = ReceivingBillTypeFactory.getLocalInstance((Context)ctx).getReceivingBillTypeCollection(ARAPImportHelper.getEntityViewByNum(number));
                if (colls != null && colls.size() > 0) {
                    recTypeInfo = colls.get(0);
                }
            }
            catch (BOSException e) {
                throw new TaskExternalException(ARAPImportHelper.getString("RecBillType_Is_Null", ctx), (Throwable)e);
            }
        }
        if (recTypeInfo == null) {
            throw new TaskExternalException(ARAPImportHelper.getString("RecBillType_Is_Null", ctx));
        }
        return recTypeInfo;
    }

    public static int checkIsIntStr(String str) {
        int reInt = -1;
        if (str != null && str.trim().length() > 0) {
            try {
                reInt = Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return reInt;
    }

    public static boolean isExistAsstActByCompany(Context ctx, CompanyOrgUnitInfo comOrgInfo, AsstActTypeInfo assactTypeInfo, String asstActId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        String relationDataObject = ARAPImportHelper.getRelationDataObject(ctx, assactTypeInfo);
        boolean fCust = relationDataObject.equalsIgnoreCase("T_BD_Customer");
        boolean fSupp = relationDataObject.equalsIgnoreCase("T_BD_Supplier");
        boolean isexists = false;
        if (fCust) {
            sql.append(" SELECT CUSTOMER.FID FROM T_BD_Customer AS CUSTOMER ");
            sql.append(" INNER JOIN T_BD_CustomerCompanyInfo AS CUSTOMERCOMPANYINFO ");
            sql.append(" ON CUSTOMER.FID = CUSTOMERCOMPANYINFO.FCustomerID ");
            sql.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANYORGUNIT ");
            sql.append(" ON CUSTOMERCOMPANYINFO.FComOrgID = COMPANYORGUNIT.FID ");
            sql.append(" where COMPANYORGUNIT.FID = ?  and CUSTOMER.fid= ? ");
        } else if (fSupp) {
            sql.append(" SELECT SUPPLIER.FID FROM T_BD_Supplier AS SUPPLIER ");
            sql.append(" INNER JOIN T_BD_SupplierCompanyInfo AS SUPPLIERCOMPANY ");
            sql.append(" ON SUPPLIER.FID = SUPPLIERCOMPANY.FSupplierID ");
            sql.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANYORGUNIT ");
            sql.append(" ON SUPPLIERCOMPANY.FComOrgID = COMPANYORGUNIT.FID ");
            sql.append(" where COMPANYORGUNIT.FID = ?  and SUPPLIER.fid= ? ");
        } else {
            return true;
        }
        Object[] param = new Object[]{comOrgInfo.getId().toString(), asstActId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        if (rowSet.size() > 0) {
            isexists = true;
        }
        return isexists;
    }

    public static String getRelationDataObject(Context ctx, AsstActTypeInfo assactTypeInfo) throws BOSException, EASBizException {
        String relationDataObject = assactTypeInfo.getRealtionDataObject();
        if (relationDataObject == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("realtionDataObject"));
            assactTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(assactTypeInfo.getId()), selector);
            relationDataObject = assactTypeInfo.getRealtionDataObject();
        }
        return relationDataObject;
    }

    public static CostCenterOrgUnitInfo getDataCostCenter(Context ctx, Hashtable hsData, String field, String CUId) throws TaskExternalException {
        CUId = CUId == null ? "" : CUId;
        CostCenterOrgUnitInfo costCenter = null;
        String number = ARAPImportHelper.getDataString(hsData, field);
        try {
            if (number != null) {
                EntityViewInfo ev = new EntityViewInfo();
                ev = ARAPImportHelper.getEntityViewByNum(number);
                ev.getSelector().add(new SelectorItemInfo("cu"));
                CostCenterOrgUnitCollection costCenters = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitCollection(ev);
                if (costCenters == null || costCenters.size() == 0) {
                    throw new TaskExternalException(ARAPImportHelper.getString("COSTCENTER_NUMBER_ERROR", ctx));
                }
                for (int i = 0; i < costCenters.size(); ++i) {
                    costCenter = costCenters.get(i);
                    if (costCenter.getCU() == null || !CUId.equals(costCenter.getCU().getId().toString())) continue;
                    return costCenter;
                }
                costCenter = costCenters.get(0);
            }
        }
        catch (BOSException ex) {
            throw new TaskExternalException(ex.getMessage());
        }
        return costCenter;
    }

    public static Map getDataVisualItem(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        HashMap<String, String> visualItem;
        block3: {
            visualItem = new HashMap<String, String>();
            IRowSet rs = null;
            String number = ARAPImportHelper.getDataString(hsData, field);
            try {
                if (number == null) break block3;
                StringBuilder sql = new StringBuilder(50);
                sql.append("select fid,fNumber,fName_").append(ctx.getLocale()).append(" as fName from T_BG_BgItem where fNumber = '").append(number).append("'");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rs.next()) {
                    visualItem.put("fid", rs.getString("fid"));
                    visualItem.put("fNumber", rs.getString("fNumber"));
                    visualItem.put("fName", rs.getString("fName"));
                    break block3;
                }
                throw new TaskExternalException(ARAPImportHelper.getString("BGITEM_NUMBER_ERROR", ctx));
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage());
            }
        }
        return visualItem;
    }

    public static AccountBankInfo getDataAccountBank(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        AccountBankInfo accountBank = null;
        String number = ARAPImportHelper.getDataString(hsData, field);
        try {
            if (number != null) {
                AccountBankCollection AccountBanks = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(ARAPImportHelper.getEntityViewByNum(number));
                if ((AccountBanks == null || AccountBanks.size() == 0) && "FEntrys$payBank_number".equals(field)) {
                    ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, field);
                } else {
                    accountBank = AccountBanks.get(0);
                }
            }
        }
        catch (BOSException ex) {
            throw new TaskExternalException(ex.getMessage());
        }
        return accountBank;
    }

    public static FundFlowItemInfo getDataFundFlowItem(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        FundFlowItemInfo fundFlowItem = null;
        String number = ARAPImportHelper.getDataString(hsData, field);
        try {
            if (number != null) {
                FundFlowItemCollection fundFlowItems = FundFlowItemFactory.getLocalInstance((Context)ctx).getFundFlowItemCollection(ARAPImportHelper.getEntityViewByNum(number));
                if (fundFlowItems == null || fundFlowItems.size() == 0) {
                    throw new TaskExternalException(ARAPImportHelper.getString("FUNDFLOWITEM_NUMBER_ERROR", ctx));
                }
                fundFlowItem = fundFlowItems.get(0);
            }
        }
        catch (BOSException ex) {
            throw new TaskExternalException(ex.getMessage());
        }
        return fundFlowItem;
    }

    public static SetFundPropertyInfo getDataFundProperty(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        SetFundPropertyInfo fundProperty = null;
        String number = ARAPImportHelper.getDataString(hsData, field);
        try {
            if (number != null) {
                SetFundPropertyCollection fundProperties = SetFundPropertyFactory.getLocalInstance((Context)ctx).getSetFundPropertyCollection(ARAPImportHelper.getEntityViewByNum(number));
                if (fundProperties == null || fundProperties.size() == 0) {
                    ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, field);
                } else {
                    fundProperty = fundProperties.get(0);
                }
            }
        }
        catch (BOSException ex) {
            throw new TaskExternalException(ex.getMessage());
        }
        return fundProperty;
    }

    public static boolean getImportParam(Context ctx) {
        boolean isByRule = false;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("Value"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.subSysID", (Object)"0000", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)"importDataByRule", CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        try {
            IParamItem iParamItem = ParamItemFactory.getLocalInstance((Context)ctx);
            ParamItemCollection collection = iParamItem.getParamItemCollection(entityViewInfo);
            if (collection == null || collection.size() == 0) {
                return isByRule;
            }
            ParamItemInfo info = collection.get(0);
            String value = info.getValue();
            if (value != null && value.equals("true")) {
                isByRule = true;
            }
        }
        catch (Exception e) {
            isByRule = false;
        }
        return isByRule;
    }

    public static AsstActTypeInfo getAsstActTypeWithNull(Context ctx, Hashtable hsData, String field) throws BOSException, TaskExternalException {
        AsstActTypeInfo asstActTypeInfo = null;
        String number = ARAPImportHelper.getDataString(hsData, field);
        if (number == null) {
            return asstActTypeInfo;
        }
        if (number != null) {
            IAsstActType iAsstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = ARAPImportHelper.getEntityViewByNum(number);
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
            AsstActTypeCollection collection = iAsstActType.getAsstActTypeCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                asstActTypeInfo = collection.get(0);
            }
        }
        if (asstActTypeInfo == null) {
            throw new TaskExternalException(ARAPImportHelper.getString("AsstActTypeID_Wrong", ctx));
        }
        return asstActTypeInfo;
    }

    public static Map getTempleFieldNameMap(Context ctx, String templeNumber) throws TaskExternalException {
        try {
            HashMap<String, String> columnNameResourceMap = new HashMap<String, String>(60);
            IDIETemplateFieldEntry iTemplateField = DIETemplateFieldEntryFactory.getLocalInstance((Context)ctx);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.number", (Object)templeNumber));
            ev.setFilter(filter);
            DIETemplateFieldEntryCollection coll = iTemplateField.getDIETemplateFieldEntryCollection(ev);
            for (int i = 0; i < coll.size(); ++i) {
                DIETemplateFieldEntryInfo info = coll.get(i);
                columnNameResourceMap.put(info.getNumber(), info.getName());
            }
            return columnNameResourceMap;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public static String getTempleFieldName(Hashtable hsData, String field) {
        Map resourceMap;
        String fielsCNName;
        if (hsData.get(TEMPLATE_FIELD_MAP) != null && hsData.get(TEMPLATE_FIELD_MAP) instanceof Map && !StringUtils.isEmpty((String)(fielsCNName = (resourceMap = (Map)hsData.get(TEMPLATE_FIELD_MAP)).get(field).toString()))) {
            return fielsCNName;
        }
        return field;
    }

    public static void throwFieldErrorMsg(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        String msg = ARAPImportHelper.getString("FieldId_Wrong", ctx);
        msg = MessageFormat.format(msg, ARAPImportHelper.getTempleFieldName(hsData, field));
        throw new TaskExternalException(msg);
    }

    public static void throwFieldNullMsg(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        String msg = ARAPImportHelper.getString("FieldEmpty_Wrong", ctx);
        msg = MessageFormat.format(msg, ARAPImportHelper.getTempleFieldName(hsData, field));
        throw new TaskExternalException(msg);
    }

    public static void beforeTransmit(Map hsData) throws TaskExternalException {
        int blockSize = hsData.size();
        for (int i = 0; i < blockSize; ++i) {
            Map entry = (Map)hsData.get(new Integer(i));
            Object object = entry.get("FSeq");
            if (object == null || !(object instanceof DataToken)) continue;
            DataToken dataToken = (DataToken)object;
            if (dataToken.data == null || "".equals(dataToken.data.toString().trim())) continue;
            dataToken.data = Integer.valueOf(dataToken.data.toString());
        }
    }

    public static void checkCalculate(Context ctx, ArApBillBaseInfo otherBillInfo, String billNumber) throws TaskExternalException, BOSException, EASBizException {
        boolean isAR = OtherBillInfo.getBosType().equals(otherBillInfo.getBOSType().toString());
        ICalculateCheck<ArApBillBaseInfo> composer = ARAPImportHelper.generateArApCalculateChecker(ctx, isAR);
        if (!composer.check(otherBillInfo)) {
            String SysType = isAR ? "AR" : "AP";
            String messageFormat = ARAPImportHelper.getString(SysType, SysType + "_CalculateAmount_Fail", ctx);
            throw new TaskExternalException(composer.prepareMessage(messageFormat, Collections.singletonMap("billNumber", billNumber)).getMsg());
        }
    }

    public static ICalculateCheck<ArApBillBaseInfo> generateArApCalculateChecker(Context ctx, boolean isAR) throws BOSException, EASBizException {
        String paramKey = isAR ? "AR_IMPORT_01" : "AP_IMPORT_01";
        boolean isCheckCal = Boolean.parseBoolean(ParamManager.getParamValue((Context)ctx, null, (String)paramKey));
        if (isCheckCal) {
            ArApForwardCalculateChecker forwardChecker = new ArApForwardCalculateChecker(ctx);
            ArApBackwardCalculateChecker backwardChecker = new ArApBackwardCalculateChecker(ctx);
            return new CalculateCheckComposer<ArApBillBaseInfo>(Arrays.asList(forwardChecker, backwardChecker));
        }
        return AR_AP_CALCULATE_SIMPLE_CHECK;
    }

    @Deprecated
    public static String checkCalculateSimple(Context ctx, ArApBillBaseInfo otherBillInfo) {
        StringBuilder calcUnPassSeq = new StringBuilder(50);
        boolean isAR = OtherBillInfo.getBosType().toString().equals(otherBillInfo.getBOSType().toString());
        ArApBillEntryBaseCollection entryColl = new ArApBillEntryBaseCollection();
        if (isAR) {
            entryColl.addObjectCollection((IObjectCollection)((OtherBillentryCollection)((Object)otherBillInfo.get("entry"))));
        } else {
            entryColl.addObjectCollection((IObjectCollection)((com.kingdee.eas.fi.ap.OtherBillentryCollection)((Object)otherBillInfo.get("entry"))));
        }
        for (int i = 0; i < entryColl.size(); ++i) {
            ArApBillEntryBaseInfo entryInfo = entryColl.get(i);
            if (entryInfo.getAmount().add(entryInfo.getTaxAmount()).compareTo(entryInfo.getRecievePayAmount()) == 0 && entryInfo.getAmountLocal().add(entryInfo.getTaxAmountLocal()).compareTo(entryInfo.getRecievePayAmountLocal()) == 0) continue;
            calcUnPassSeq.append(entryInfo.getSeq()).append(",");
        }
        if (calcUnPassSeq.length() > 0) {
            calcUnPassSeq.substring(0, calcUnPassSeq.length() - 1);
        }
        return calcUnPassSeq.toString();
    }

    @Deprecated
    public static String checkCalculateComplex(Context ctx, ArApBillBaseInfo otherBillInfo) throws TaskExternalException {
        try {
            boolean isAR = OtherBillInfo.getBosType().toString().equals(otherBillInfo.getBOSType().toString());
            StringBuilder calcUnPassSeq = new StringBuilder(50);
            ArApBillEntryBaseCollection entryColl = new ArApBillEntryBaseCollection();
            if (isAR) {
                entryColl.addObjectCollection((IObjectCollection)((OtherBillentryCollection)((Object)otherBillInfo.get("entry"))));
            } else {
                entryColl.addObjectCollection((IObjectCollection)((com.kingdee.eas.fi.ap.OtherBillentryCollection)((Object)otherBillInfo.get("entry"))));
            }
            ArApBillBaseInfo cloneInfo = (ArApBillBaseInfo)otherBillInfo.clone();
            cloneInfo.setAmountLocal(SysConstant.BIGZERO);
            cloneInfo.setReqCalculate4Srv(true);
            ArApBillHelper.calculate(ctx, cloneInfo, null);
            ArApBillEntryBaseCollection cloneInfoEntryCol = new ArApBillEntryBaseCollection();
            if (isAR) {
                cloneInfoEntryCol.addObjectCollection((IObjectCollection)((OtherBillentryCollection)((Object)cloneInfo.get("entry"))));
            } else {
                cloneInfoEntryCol.addObjectCollection((IObjectCollection)((com.kingdee.eas.fi.ap.OtherBillentryCollection)((Object)cloneInfo.get("entry"))));
            }
            ArApBillBaseInfo cloneInfoForPrice = (ArApBillBaseInfo)otherBillInfo.clone();
            cloneInfoForPrice.setAmountLocal(SysConstant.BIGZERO);
            cloneInfoForPrice.setReqCalculate4Srv(true);
            ArApBillEntryBaseInfo cloneEntryInfoForPrice = null;
            ArApBillEntryBaseCollection cloneInfoForPriceEntryCol = new ArApBillEntryBaseCollection();
            if (isAR) {
                cloneInfoForPriceEntryCol.addObjectCollection((IObjectCollection)((OtherBillentryCollection)((Object)cloneInfoForPrice.get("entry"))));
            } else {
                cloneInfoForPriceEntryCol.addObjectCollection((IObjectCollection)((com.kingdee.eas.fi.ap.OtherBillentryCollection)((Object)cloneInfoForPrice.get("entry"))));
            }
            int j = cloneInfoForPriceEntryCol.size();
            for (int i = 0; i < j; ++i) {
                cloneEntryInfoForPrice = cloneInfoForPriceEntryCol.get(i);
                cloneEntryInfoForPrice.setPrice(null);
                cloneEntryInfoForPrice.setTaxPrice(null);
            }
            ArApBillHelper.calculate(ctx, cloneInfoForPrice, null);
            if (isAR) {
                cloneInfoForPriceEntryCol.addObjectCollection((IObjectCollection)((OtherBillentryCollection)((Object)cloneInfoForPrice.get("entry"))));
            } else {
                cloneInfoForPriceEntryCol.addObjectCollection((IObjectCollection)((com.kingdee.eas.fi.ap.OtherBillentryCollection)((Object)cloneInfoForPrice.get("entry"))));
            }
            for (int i = 0; i < entryColl.size(); ++i) {
                ArApBillEntryBaseInfo cloneEntryInfo = cloneInfoEntryCol.get(i);
                ArApBillEntryBaseInfo cloneEntryForPrice = cloneInfoForPriceEntryCol.get(i);
                ArApBillEntryBaseInfo entryInfo = entryColl.get(i);
                if (cloneEntryInfo.getAmount().compareTo(entryInfo.getAmount()) == 0 && cloneEntryInfo.getAmountLocal().compareTo(entryInfo.getAmountLocal()) == 0 && cloneEntryInfo.getDiscountAmount().compareTo(entryInfo.getDiscountAmount()) == 0 && cloneEntryInfo.getDiscountAmountLocal().compareTo(entryInfo.getDiscountAmountLocal()) == 0 && cloneEntryInfo.getRecievePayAmount().compareTo(entryInfo.getRecievePayAmount()) == 0 && cloneEntryInfo.getRecievePayAmountLocal().compareTo(entryInfo.getRecievePayAmountLocal()) == 0 || cloneEntryForPrice.getQuantity().compareTo(entryInfo.getQuantity()) == 0 && cloneEntryForPrice.getTaxPrice().compareTo(entryInfo.getTaxPrice()) == 0 && cloneEntryForPrice.getAmount().compareTo(entryInfo.getAmount()) == 0 && cloneEntryForPrice.getAmountLocal().compareTo(entryInfo.getAmountLocal()) == 0 && cloneEntryForPrice.getDiscountAmount().compareTo(entryInfo.getDiscountAmount()) == 0 && cloneEntryForPrice.getDiscountAmountLocal().compareTo(entryInfo.getDiscountAmountLocal()) == 0 && cloneEntryForPrice.getRecievePayAmount().compareTo(entryInfo.getRecievePayAmount()) == 0 && cloneEntryForPrice.getRecievePayAmountLocal().compareTo(entryInfo.getRecievePayAmountLocal()) == 0) continue;
                calcUnPassSeq.append(entryInfo.getSeq()).append(",");
            }
            if (calcUnPassSeq.length() > 0) {
                calcUnPassSeq.substring(0, calcUnPassSeq.length() - 1);
            }
            return calcUnPassSeq.toString();
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public static Hashtable reverseTableValue(Hashtable hsData) {
        if (hsData == null) {
            return null;
        }
        int size = hsData.keySet().size();
        ArrayList originalKeys = new ArrayList(size);
        ArrayList reverseKeys = new ArrayList(size);
        Enumeration e = hsData.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            originalKeys.add(key);
            reverseKeys.add(key);
        }
        Collections.sort(reverseKeys, new Comparator<Object>(){

            @Override
            public int compare(Object c1, Object c2) {
                if (c1 instanceof Integer && c2 instanceof Integer) {
                    int b;
                    int a = (Integer)c1;
                    if (a > (b = ((Integer)c2).intValue())) {
                        return 1;
                    }
                    if (a < b) {
                        return -1;
                    }
                    return 0;
                }
                return 0;
            }
        });
        Hashtable data = new Hashtable(size);
        for (int i = 0; i < originalKeys.size(); ++i) {
            data.put(originalKeys.get(i), hsData.get(reverseKeys.get(i)));
        }
        return data;
    }
}

