/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.arap.app.ARAPUnVoucheredFilterSQLUtil;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.util.TypeConversionUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class ARAPUnVoucheredCountFilter {
    public String getUnVoucheredCountFilter(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, boolean fAR, String billTypeDes) throws BOSException, EASBizException {
        boolean isFromSmartAccountOrSCMRobotAuto;
        String companyId = company.getId().toString();
        HashMap paramKeyMap = new HashMap();
        if (fAR) {
            paramKeyMap.put("AR_RECVOUCHER_BILLTYPE", companyId);
            paramKeyMap.put("AR_IS_PRE_REC_ACCT", companyId);
            paramKeyMap.put("AR_IS_BIZ_VOUCHER", companyId);
            paramKeyMap.put("AR_RECVOUCHER_BILLTYPE_CASH", companyId);
            paramKeyMap.put("Rec_Vou_001", companyId);
        } else {
            paramKeyMap.put("AP_PAYVOUCHER_BILLTYPE", companyId);
            paramKeyMap.put("AP_IS_PRE_PAY_ACCT", companyId);
            paramKeyMap.put("AP_CONTRAST_ESTIMATE_GL", companyId);
            paramKeyMap.put("AP_PAYVOUCHER_BILLTYPE_CASH", companyId);
            paramKeyMap.put("Pay_Vou_001", companyId);
        }
        paramKeyMap = ArApParamHelper.getParamHashMap(ctx, paramKeyMap);
        boolean fRecPay2Vou = TypeConversionUtils.objToBoolean(paramKeyMap.get(fAR ? "AR_RECVOUCHER_BILLTYPE" : "AP_PAYVOUCHER_BILLTYPE"));
        boolean fPreAcctVou = TypeConversionUtils.objToBoolean(paramKeyMap.get(fAR ? "AR_IS_PRE_REC_ACCT" : "AP_IS_PRE_PAY_ACCT"));
        boolean isBizBillVoucher = TypeConversionUtils.objToBoolean(paramKeyMap.get(fAR ? "AR_IS_BIZ_VOUCHER" : "AP_CONTRAST_ESTIMATE_GL"));
        boolean isCashVoucher = TypeConversionUtils.objToBoolean(paramKeyMap.get(fAR ? "AR_RECVOUCHER_BILLTYPE_CASH" : "AP_PAYVOUCHER_BILLTYPE_CASH"));
        boolean isPayVoucher = "true".equals(paramKeyMap.get(fAR ? "Rec_Vou_001" : "Pay_Vou_001"));
        java.sql.Date beginDate = new java.sql.Date(new Date().getTime());
        java.sql.Date endDate = new java.sql.Date(new Date().getTime());
        if (period != null && period.getBeginDate() != null && period.getEndDate() != null) {
            beginDate = new java.sql.Date(period.getBeginDate().getTime());
            endDate = new java.sql.Date(period.getEndDate().getTime());
            endDate.setTime(endDate.getTime() + 86400000L);
        }
        StringBuilder sql = new StringBuilder(1200);
        sql.append("select fid from (\r\n");
        StringBuilder whereSql = new StringBuilder(300);
        whereSql.append("\r\n where FCompanyID='").append(companyId);
        whereSql.append("'\r\n and FISCASH=0");
        whereSql.append("\r\n and FBillTypeDes='").append(billTypeDes).append("'");
        boolean bl = isFromSmartAccountOrSCMRobotAuto = CommonServerUtils.isFromSmartAccount() || CommonServerUtils.isFromSCMRobotAuto(ctx);
        if (period != null && !isFromSmartAccountOrSCMRobotAuto) {
            whereSql.append("\r\n and (FBillDate >= {").append(beginDate);
            whereSql.append("} and FBillDate < {").append(endDate).append("})");
        }
        whereSql.append("\r\n and (FFiVouchered= 0  ");
        if (!isPayVoucher && (billTypeDes.equals("receivingbill") || billTypeDes.equals("paymentBill"))) {
            whereSql.append("and (FIsAudited = 1 or FIsAudited=2) ");
        } else {
            whereSql.append("and FIsAudited = 1 ");
        }
        if (!isBizBillVoucher) {
            whereSql.append(" AND FIsBizBill = 0 ");
        }
        whereSql.append(")").append(this.recVouTypeWhere(ctx, companyId, fAR, fRecPay2Vou, fPreAcctVou));
        if (!fAR && CalculateUtil.getDischargeType((Context)ctx, (String)companyId) != 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String beginDateStr = sdf.format(beginDate);
            String endDateStr = sdf.format(endDate);
            whereSql.append(" AND FID not in (");
            if (isFromSmartAccountOrSCMRobotAuto) {
                whereSql.append(CommonServerUtils.getSpecialNotVoucherApBillWidthNotDateSql(companyId));
            } else {
                whereSql.append(CommonServerUtils.getSpecialNotVoucherApBillSql(companyId, beginDateStr, endDateStr));
            }
            whereSql.append(")");
        }
        sql.append(" select distinct fid from ");
        sql.append("(").append(ARAPUnVoucheredFilterSQLUtil.getFilterSQL(fAR, billTypeDes)).append(") as billTab");
        sql.append((CharSequence)whereSql);
        if (isCashVoucher && (billTypeDes.equals("receivingbill") || billTypeDes.equals("paymentBill") || billTypeDes.equals("otherbill")) || !isCashVoucher && billTypeDes.equals("verifyBill")) {
            StringBuffer cashVouSql = null;
            cashVouSql = isFromSmartAccountOrSCMRobotAuto ? this.checkCashVou(fAR, companyId, isCashVoucher, isPayVoucher, billTypeDes) : this.checkCashVou(fAR, companyId, beginDate, endDate, isCashVoucher, isPayVoucher, billTypeDes);
            sql.append("\r\n union all \r\n").append(cashVouSql);
        }
        sql.append("\r\n) t_arap_chkRpt ");
        return sql.toString();
    }

    private StringBuffer checkCashVou(boolean far, String companyId, java.sql.Date beginDate, java.sql.Date endDate, boolean isCashVoucher, boolean isPayVoucher, String billTypeDes) {
        StringBuffer cashvouSql = new StringBuffer();
        cashvouSql.append(" select distinct fid from ");
        ArrayList<String> billTypes = new ArrayList<String>();
        billTypes.add(billTypeDes);
        cashvouSql.append("(").append(ARAPUnVoucheredFilterSQLUtil.getFilterSQL(far, billTypes)).append(") as billTab");
        cashvouSql.append("\r\n where FCompanyID='").append(companyId);
        cashvouSql.append("'\r\n and FISCASH=1");
        if (beginDate != null && endDate != null) {
            cashvouSql.append("\r\n and (FBillDate >= {").append(beginDate);
            cashvouSql.append("} and FBillDate < {").append(endDate).append("})");
        }
        StringBuffer billType = new StringBuffer("");
        cashvouSql.append("\r\n and (FFiVouchered= 0 ");
        if (isCashVoucher && !isPayVoucher && (billTypeDes.equals("receivingbill") || billTypeDes.equals("paymentBill"))) {
            cashvouSql.append("\tand (FIsAudited = 1 or FIsAudited=2) ");
        } else {
            cashvouSql.append("\tand FIsAudited = 1 ");
        }
        cashvouSql.append(billType).append(") ");
        return cashvouSql;
    }

    private StringBuffer checkCashVou(boolean far, String companyId, boolean isCashVoucher, boolean isPayVoucher, String billTypeDes) {
        return this.checkCashVou(far, companyId, null, null, isCashVoucher, isPayVoucher, billTypeDes);
    }

    private StringBuffer recVouTypeWhere(Context ctx, String companyId, boolean fAR, boolean fRecPay2Vou, boolean fPreAcctVou) throws BOSException, EASBizException {
        StringBuffer whereSql = new StringBuffer();
        if (fRecPay2Vou && !fPreAcctVou) {
            whereSql.append("\r\n and (FVeriType != -100");
            whereSql.append(" and FVeriType != -200 )");
        } else if (fRecPay2Vou && fPreAcctVou) {
            whereSql.append("\r\n and ((FBillType = -1 and FVeriType = -1)");
            whereSql.append(" or FVeriType = 1 ");
            whereSql.append(" or FVeriType = -200)");
        } else if (!fRecPay2Vou && !fPreAcctVou) {
            whereSql.append("\r\n and ((FBillType = -1 and FVeriType = -1)");
            whereSql.append(" or (FVeriType = 1 and (FBillType != ");
            whereSql.append(fAR ? 100 : 201);
            whereSql.append(" and FBillType != ");
            whereSql.append(fAR ? 102 : 203);
            whereSql.append(")) or FVeriType = -100)");
        } else if (!fRecPay2Vou && fPreAcctVou) {
            whereSql.append("\r\n and ((FBillType = -1 and FVeriType = -1)");
            whereSql.append(" or (FVeriType = 1 and (FBillType != ");
            whereSql.append(fAR ? 100 : 201);
            whereSql.append(" AND FBillType != ");
            whereSql.append(fAR ? 102 : 203);
            whereSql.append(")) or (FVeriType = -100 or FVeriType = -200))");
        }
        return whereSql;
    }
}

