/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import java.util.List;

public class ARAPUnVoucheredFilterSQLUtil {
    public static final String CR = "\r\n";

    public static String getFilterSQL(boolean isAR, String billType) {
        String sql = null;
        if (isAR) {
            if ("otherbill".equals(billType)) {
                sql = ARAPUnVoucheredFilterSQLUtil.getARBillSQL();
            } else if ("receivingbill".equals(billType)) {
                sql = ARAPUnVoucheredFilterSQLUtil.getreceivingbillSQL();
            } else if ("badacct".equals(billType)) {
                sql = ARAPUnVoucheredFilterSQLUtil.getbadacctSQL();
            } else if ("badacctaccurral".equals(billType)) {
                sql = ARAPUnVoucheredFilterSQLUtil.getbadacctaccurralSQL();
            } else if ("verifyBill".equals(billType)) {
                sql = ARAPUnVoucheredFilterSQLUtil.getverifyBillSQL();
            } else if ("proxybill".equals(billType)) {
                sql = ARAPUnVoucheredFilterSQLUtil.getproxybillSQL();
            } else if ("exgRateBill".equals(billType)) {
                sql = ARAPUnVoucheredFilterSQLUtil.getexgRateBillSQL();
            } else if ("incomeConfirmBill".equals(billType)) {
                sql = ARAPUnVoucheredFilterSQLUtil.getIncomeConfirmBillSQL();
            }
        } else if ("otherbill".equals(billType)) {
            sql = ARAPUnVoucheredFilterSQLUtil.getAPBillSQL();
        } else if ("paymentBill".equals(billType)) {
            sql = ARAPUnVoucheredFilterSQLUtil.getpaymentBillSQL();
        } else if ("verifyBill".equals(billType)) {
            sql = ARAPUnVoucheredFilterSQLUtil.getAPverifyBillSQL();
        } else if ("proxybill".equals(billType)) {
            sql = ARAPUnVoucheredFilterSQLUtil.getAPproxybillSQL();
        } else if ("exgRateBill".equals(billType)) {
            sql = ARAPUnVoucheredFilterSQLUtil.getAPexgRateBillSQL();
        }
        return sql;
    }

    public static String getFilterSQL(boolean isAR, List billTypes) {
        StringBuffer buf = new StringBuffer();
        int size = billTypes.size();
        for (int i = 0; i < size; ++i) {
            String billType = (String)billTypes.get(i);
            if (i > 0) {
                buf.append(CR).append("UNION ALL ").append(CR);
            }
            buf.append(ARAPUnVoucheredFilterSQLUtil.getFilterSQL(isAR, billType));
        }
        return buf.toString();
    }

    private static String getARBillSQL() {
        StringBuffer buf = new StringBuffer();
        buf.append(" SELECT").append(CR);
        buf.append("     fid, 'otherbill' fbilltypedes, -1 AS fbilltype, -1 AS fveriType, fnumber, fcompanyid,").append(CR);
        buf.append("     fbilldate, fcreatorid, fcreatetime, flastupdateuserid, flastupdatetime, fcontrolunitid,").append(CR);
        buf.append("     CASE fbillstatus WHEN 3 THEN 1 ELSE 0 END fisaudited,").append(CR);
        buf.append("     CASE fpaymenttypeid").append(CR);
        buf.append("         WHEN 'cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5' THEN 1").append(CR);
        buf.append("         WHEN '40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5' THEN 1").append(CR);
        buf.append("         ELSE 0 END FIsCash,").append(CR);
        buf.append("     CASE FunVerifyAmount WHEN 0 THEN 0 ELSE 1 END FIsUnver,").append(CR);
        buf.append("     CASE FIsNeedVoucher WHEN 1 THEN ISNULL(FFiVouchered,0) ELSE 1 END AS ffivouchered, ").append(CR);
        buf.append("     FIsBizBill").append(CR);
        buf.append(" FROM").append(CR);
        buf.append("     t_ar_otherbill").append(CR);
        buf.append("     where ISNULL(fsourcebilltype,0) <> 17 ").append(CR);
        return buf.toString();
    }

    private static String getIncomeConfirmBillSQL() {
        StringBuffer buf = new StringBuffer();
        buf.append(" SELECT").append(CR);
        buf.append("     fid, 'incomeConfirmBill' fbilltypedes, -1 AS fbilltype, -1 AS fveriType, fnumber, fcompanyid,").append(CR);
        buf.append("     fbilldate, fcreatorid, fcreatetime, flastupdateuserid, flastupdatetime, fcontrolunitid,").append(CR);
        buf.append("     CASE fbillstatus WHEN 3 THEN 1 ELSE 0 END fisaudited,").append(CR);
        buf.append("     CASE fpaymenttypeid").append(CR);
        buf.append("         WHEN 'cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5' THEN 1").append(CR);
        buf.append("         WHEN '40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5' THEN 1").append(CR);
        buf.append("         ELSE 0 END FIsCash,").append(CR);
        buf.append("     CASE FunVerifyAmount WHEN 0 THEN 0 ELSE 1 END FIsUnver,").append(CR);
        buf.append("     CASE FIsNeedVoucher WHEN 1 THEN ISNULL(FFiVouchered,0) ELSE 1 END AS ffivouchered, ").append(CR);
        buf.append("     FIsBizBill").append(CR);
        buf.append(" FROM").append(CR);
        buf.append("     t_ar_incomeconfimbill").append(CR);
        buf.append("     where ISNULL(fsourcebilltype,0) <> 17 ").append(CR);
        return buf.toString();
    }

    private static String getreceivingbillSQL() {
        StringBuffer buf = new StringBuffer();
        buf.append(" SELECT DISTINCT").append(CR);
        buf.append("     bill.fid AS fid, 'receivingbill' fbilltypedes,").append(CR);
        buf.append("     CASE ltrim(rtrim(").append(CR);
        buf.append("                 CASE").append(CR);
        buf.append("                     WHEN t11.fnumber IS NULL").append(CR);
        buf.append("                     THEN billType.fnumber").append(CR);
        buf.append("                     ELSE t11.fnumber").append(CR);
        buf.append("                 END))").append(CR);
        buf.append("         WHEN '100' THEN 100 WHEN '101' THEN 101 WHEN '102' THEN 102 ").append(CR);
        buf.append(" \t\tWHEN '103' THEN 103 WHEN '104' THEN 104 WHEN '105' THEN 105 ").append(CR);
        buf.append(" \t\tWHEN '121' THEN 121 WHEN '999' THEN 999 ELSE 100 END fbilltype,").append(CR);
        buf.append("     1 AS fveriType,").append(CR);
        buf.append("     bill.fnumber AS fnumber,").append(CR);
        buf.append("     bill.fcompanyid AS fcompanyid,").append(CR);
        buf.append("     bill.fbizdate AS fbilldate,").append(CR);
        buf.append("     bill.fcreatorid AS fcreatorid,").append(CR);
        buf.append("     bill.fcreatetime AS fcreatetime,").append(CR);
        buf.append("     bill.flastupdateuserid AS flastupdateuserid,").append(CR);
        buf.append("     bill.flastupdatetime AS flastupdatetime,").append(CR);
        buf.append("     bill.fcontrolunitid AS fcontrolunitid,").append(CR);
        buf.append("     CASE").append(CR);
        buf.append(" \t\tCASE").append(CR);
        buf.append(" \t\t\tWHEN").append(CR);
        buf.append(" \t\t\t\t(").append(CR);
        buf.append(" \t\t\t\t\tbill.FPayerTypeID IS NULL OR ltrim(rtrim(bill.FPayerTypeID)) = '' OR ").append(CR);
        buf.append(" \t\t\t\t\tbill.FPayerID IS NULL OR ltrim(rtrim(bill.FPayerID)) = ''").append(CR);
        buf.append(" \t\t\t\t)").append(CR);
        buf.append(" \t\t\tTHEN 10").append(CR);
        buf.append(" \t\t\tELSE bill.fbillstatus").append(CR);
        buf.append(" \t\tEND").append(CR);
        buf.append("         WHEN 10 THEN 0 WHEN 11 THEN 0 WHEN 12 THEN 2 ELSE 1 END fisaudited,").append(CR);
        buf.append("     CASE fpaymenttypeid").append(CR);
        buf.append("         WHEN 'cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5' THEN 1").append(CR);
        buf.append("         WHEN '40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5' THEN 1").append(CR);
        buf.append("         ELSE 0 END FIsCash,").append(CR);
        buf.append("     CASE FunVerifiedAmt WHEN 0 THEN 0 ELSE 1 END FIsUnver,").append(CR);
        buf.append("     CASE bill.FIsNeedVoucher").append(CR);
        buf.append("         WHEN 1 THEN ISNULL(bill.FFiVouchered,0)").append(CR);
        buf.append("         ELSE 1 END AS ffivouchered,").append(CR);
        buf.append("     0   AS FIsBizBill").append(CR);
        buf.append(" FROM").append(CR);
        buf.append("     t_cas_receivingbill bill").append(CR);
        buf.append(" INNER JOIN t_cas_receivingbillEntry billEntry").append(CR);
        buf.append(" ON").append(CR);
        buf.append("     bill.fid = billEntry.freceivingbillid").append(CR);
        buf.append(" INNER JOIN T_CAS_ReceivingBillType billType").append(CR);
        buf.append(" ON").append(CR);
        buf.append("     billEntry.FRecBillTypeID = billType.FID").append(CR);
        buf.append(" LEFT JOIN t_cas_receivingbilltype AS t11").append(CR);
        buf.append(" ON").append(CR);
        buf.append("     billType.FPreSetBillTypeID = t11.FID").append(CR);
        buf.append(" WHERE").append(CR);
        buf.append("     bill.fsourcetype = 100").append(CR);
        return buf.toString();
    }

    private static String getbadacctSQL() {
        StringBuffer buf = new StringBuffer();
        buf.append(" SELECT").append(CR);
        buf.append("     fid,").append(CR);
        buf.append("     'badacct' fbilltypedes,").append(CR);
        buf.append("     -1 AS fbilltype,").append(CR);
        buf.append("     -1 AS fveriType,").append(CR);
        buf.append("     fnumber,").append(CR);
        buf.append("     fcompanyid,").append(CR);
        buf.append("     fbadacctdate fbilldate,").append(CR);
        buf.append("     fcreatorid,").append(CR);
        buf.append("     fcreatetime,").append(CR);
        buf.append("     flastupdateuserid,").append(CR);
        buf.append("     flastupdatetime,").append(CR);
        buf.append("     fcontrolunitid,").append(CR);
        buf.append("     CASE Isnull(YEAR(fauditdate),0)").append(CR);
        buf.append("         WHEN 0").append(CR);
        buf.append("         THEN 0").append(CR);
        buf.append("         ELSE 1").append(CR);
        buf.append("     END fisaudited,").append(CR);
        buf.append("     0 AS FIsCash,").append(CR);
        buf.append("     0 AS FIsUnver,").append(CR);
        buf.append("     CASE Isnull(ffivouchered,0)").append(CR);
        buf.append("         WHEN 1").append(CR);
        buf.append("         THEN 1").append(CR);
        buf.append("         ELSE 0").append(CR);
        buf.append("     END ffivouchered,").append(CR);
        buf.append("     0 AS FIsBizBill").append(CR);
        buf.append(" FROM").append(CR);
        buf.append("     t_ar_badacct").append(CR);
        return buf.toString();
    }

    private static String getbadacctaccurralSQL() {
        StringBuffer buf = new StringBuffer();
        buf.append(" SELECT").append(CR);
        buf.append("     fid,").append(CR);
        buf.append("     'badacctaccurral' fbilltypedes,").append(CR);
        buf.append("     -1 AS fbilltype,").append(CR);
        buf.append("     -1 AS fveriType,").append(CR);
        buf.append("     fnumber,").append(CR);
        buf.append("     fcompanyid,").append(CR);
        buf.append("     faccountdate fbilldate,").append(CR);
        buf.append("     fcreatorid,").append(CR);
        buf.append("     fcreatetime,").append(CR);
        buf.append("     flastupdateuserid,").append(CR);
        buf.append("     flastupdatetime,").append(CR);
        buf.append("     fcontrolunitid,").append(CR);
        buf.append("     CASE Isnull(YEAR(fauditdate),0)").append(CR);
        buf.append("         WHEN 0").append(CR);
        buf.append("         THEN 0").append(CR);
        buf.append("         ELSE 1").append(CR);
        buf.append("     END fisaudited,").append(CR);
        buf.append("     0 AS FIsCash,").append(CR);
        buf.append("     0 AS FIsUnver,").append(CR);
        buf.append("     CASE Isnull(ffivouchered,0)").append(CR);
        buf.append("         WHEN 1").append(CR);
        buf.append("         THEN 1").append(CR);
        buf.append("         ELSE 0").append(CR);
        buf.append("     END ffivouchered,").append(CR);
        buf.append("     0 AS FIsBizBill").append(CR);
        buf.append(" FROM").append(CR);
        buf.append("     t_ar_accountbaddebt").append(CR);
        return buf.toString();
    }

    private static String getverifyBillSQL() {
        StringBuffer buf = new StringBuffer();
        buf.append(" SELECT").append(CR);
        buf.append("     bill.fid AS fid,").append(CR);
        buf.append("     'verifyBill' fbilltypedes,").append(CR);
        buf.append("     -1                     AS fbilltype,").append(CR);
        buf.append("     -1                     AS fveriType,").append(CR);
        buf.append("     bill.fnumber           AS fnumber,").append(CR);
        buf.append("     bill.fcompanyid        AS fcompanyid,").append(CR);
        buf.append("     bill.fbizdate          AS fbilldate,").append(CR);
        buf.append("     bill.fcreatorid        AS fcreatorid,").append(CR);
        buf.append("     bill.fcreatetime       AS fcreatetime,").append(CR);
        buf.append("     bill.flastupdateuserid AS flastupdateuserid,").append(CR);
        buf.append("     bill.flastupdatetime   AS flastupdatetime,").append(CR);
        buf.append("     bill.fcontrolunitid    AS fcontrolunitid,").append(CR);
        buf.append("     1 fisaudited,").append(CR);
        buf.append("     FISCASHSALEPUR AS FisCash,").append(CR);
        buf.append("     0              AS FIsUnver,").append(CR);
        buf.append("     CASE Isnull(bill.ffivouchered,0)").append(CR);
        buf.append("         WHEN 1").append(CR);
        buf.append("         THEN 1").append(CR);
        buf.append("         ELSE 0").append(CR);
        buf.append("     END ffivouchered,").append(CR);
        buf.append("     0 AS FIsBizBill").append(CR);
        buf.append(" FROM").append(CR);
        buf.append("     t_ar_verificationbill bill").append(CR);
        buf.append(" INNER JOIN t_ar_verificationbillentry billEntry").append(CR);
        buf.append(" ON").append(CR);
        buf.append("     bill.FID = billEntry.FParentID").append(CR);
        buf.append(" WHERE").append(CR);
        buf.append("     bill.FVerificationType != 101 AND bill.FBillType_Main != bill.FBillType_second AND billEntry.FVeriType != 1").append(CR);
        buf.append(" UNION ALL").append(CR);
        buf.append("   SELECT bill.fid as fid,").append(CR);
        buf.append("          'verifyBill' fbilltypedes,").append(CR);
        buf.append("          -1 as fbilltype,").append(CR);
        buf.append("          -1 as fveriType,").append(CR);
        buf.append("          bill.fnumber as fnumber,").append(CR);
        buf.append("          bill.fcompanyid as fcompanyid,").append(CR);
        buf.append("          bill.fbizdate as fbilldate,").append(CR);
        buf.append("          bill.fcreatorid as fcreatorid,").append(CR);
        buf.append("          bill.fcreatetime as fcreatetime,").append(CR);
        buf.append("          bill.flastupdateuserid as flastupdateuserid,").append(CR);
        buf.append("          bill.flastupdatetime as flastupdatetime,").append(CR);
        buf.append("          bill.fcontrolunitid as fcontrolunitid,").append(CR);
        buf.append("          1 fisaudited,").append(CR);
        buf.append(" \t FISCASHSALEPUR AS FisCash,").append(CR);
        buf.append(" \t 0              AS FIsUnver,").append(CR);
        buf.append("          CASE Isnull(bill.ffivouchered,0)").append(CR);
        buf.append("            WHEN 1 THEN 1").append(CR);
        buf.append("            ELSE 0").append(CR);
        buf.append("          END ffivouchered,").append(CR);
        buf.append("          0 AS FIsBizBill").append(CR);
        buf.append("   FROM   t_ar_verificationbill bill").append(CR);
        buf.append("   INNER JOIN t_ar_verificationbillentry billEntry").append(CR);
        buf.append("   ON bill.FID = billEntry.FParentID").append(CR);
        buf.append("   where bill.fIsSameCurrency = 0 or Isnull(billEntry.FGainAndLoss,0) <> 0").append(CR);
        buf.append(" UNION ALL").append(CR);
        buf.append(" SELECT").append(CR);
        buf.append("     bill.fid AS fid,").append(CR);
        buf.append("     'verifyBill' fbilltypedes,").append(CR);
        buf.append("     -1                     AS fbilltype,").append(CR);
        buf.append("     -100                   AS fveriType,").append(CR);
        buf.append("     bill.fnumber           AS fnumber,").append(CR);
        buf.append("     bill.fcompanyid        AS fcompanyid,").append(CR);
        buf.append("     bill.fbizdate          AS fbilldate,").append(CR);
        buf.append("     bill.fcreatorid        AS fcreatorid,").append(CR);
        buf.append("     bill.fcreatetime       AS fcreatetime,").append(CR);
        buf.append("     bill.flastupdateuserid AS flastupdateuserid,").append(CR);
        buf.append("     bill.flastupdatetime   AS flastupdatetime,").append(CR);
        buf.append("     bill.fcontrolunitid    AS fcontrolunitid,").append(CR);
        buf.append("     1 fisaudited,").append(CR);
        buf.append("     FISCASHSALEPUR AS FisCash,").append(CR);
        buf.append("     0              AS FIsUnver,").append(CR);
        buf.append("     CASE Isnull(bill.ffivouchered,0)").append(CR);
        buf.append("         WHEN 1").append(CR);
        buf.append("         THEN 1").append(CR);
        buf.append("         ELSE 0").append(CR);
        buf.append("     END ffivouchered,").append(CR);
        buf.append("     0 AS FIsBizBill").append(CR);
        buf.append(" FROM").append(CR);
        buf.append("     t_ar_verificationbill bill").append(CR);
        buf.append(" INNER JOIN t_ar_verificationbillentry billEntry").append(CR);
        buf.append(" ON").append(CR);
        buf.append("     bill.FID = billEntry.FParentID").append(CR);
        buf.append(" WHERE").append(CR);
        buf.append("     bill.FVerificationType = 101 AND").append(CR);
        buf.append("     (").append(CR);
        buf.append("         billEntry.fbillsubtype = 100 OR billEntry.fbillsubtype = 102").append(CR);
        buf.append("     )").append(CR);
        buf.append(" UNION ALL").append(CR);
        buf.append(" SELECT").append(CR);
        buf.append("     bill.fid AS fid,").append(CR);
        buf.append("     'verifyBill' fbilltypedes,").append(CR);
        buf.append("     -1                     AS fbilltype,").append(CR);
        buf.append("     -200                   AS fveriType,").append(CR);
        buf.append("     bill.fnumber           AS fnumber,").append(CR);
        buf.append("     bill.fcompanyid        AS fcompanyid,").append(CR);
        buf.append("     bill.fbizdate          AS fbilldate,").append(CR);
        buf.append("     bill.fcreatorid        AS fcreatorid,").append(CR);
        buf.append("     bill.fcreatetime       AS fcreatetime,").append(CR);
        buf.append("     bill.flastupdateuserid AS flastupdateuserid,").append(CR);
        buf.append("     bill.flastupdatetime   AS flastupdatetime,").append(CR);
        buf.append("     bill.fcontrolunitid    AS fcontrolunitid,").append(CR);
        buf.append("     1 fisaudited,").append(CR);
        buf.append("     FISCASHSALEPUR AS FisCash,").append(CR);
        buf.append("     0              AS FIsUnver,").append(CR);
        buf.append("     1 ffivouchered,").append(CR);
        buf.append("     ").append(CR);
        buf.append("     0 AS FIsBizBill").append(CR);
        buf.append(" FROM").append(CR);
        buf.append("     t_ar_verificationbill bill").append(CR);
        buf.append(" INNER JOIN t_ar_verificationbillentry billEntry").append(CR);
        buf.append(" ON").append(CR);
        buf.append("     bill.FID = billEntry.FParentID").append(CR);
        buf.append(" WHERE").append(CR);
        buf.append("     bill.FVerificationType = 101 AND bill.FBillType_Main = 6 AND bill.FBillType_second = 6 AND").append(CR);
        buf.append("     (").append(CR);
        buf.append("         billEntry.fbillsubtype = 101 OR billEntry.fbillsubtype = 103").append(CR);
        buf.append("     )").append(CR);
        buf.append(" UNION ALL").append(CR);
        buf.append(" SELECT").append(CR);
        buf.append("     bill.fid AS fid,").append(CR);
        buf.append("     'verifyBill' fbilltypedes,").append(CR);
        buf.append("     -1                     AS fbilltype,").append(CR);
        buf.append("     -200                   AS fveriType,").append(CR);
        buf.append("     bill.fnumber           AS fnumber,").append(CR);
        buf.append("     bill.fcompanyid        AS fcompanyid,").append(CR);
        buf.append("     bill.fbizdate          AS fbilldate,").append(CR);
        buf.append("     bill.fcreatorid        AS fcreatorid,").append(CR);
        buf.append("     bill.fcreatetime       AS fcreatetime,").append(CR);
        buf.append("     bill.flastupdateuserid AS flastupdateuserid,").append(CR);
        buf.append("     bill.flastupdatetime   AS flastupdatetime,").append(CR);
        buf.append("     bill.fcontrolunitid    AS fcontrolunitid,").append(CR);
        buf.append("     1 fisaudited,").append(CR);
        buf.append("     FISCASHSALEPUR AS FisCash,").append(CR);
        buf.append("     0              AS FIsUnver,").append(CR);
        buf.append("     CASE Isnull(bill.ffivouchered,0)").append(CR);
        buf.append("         WHEN 1").append(CR);
        buf.append("         THEN 1").append(CR);
        buf.append("         ELSE 0").append(CR);
        buf.append("     END ffivouchered,").append(CR);
        buf.append("     0 AS FIsBizBill").append(CR);
        buf.append(" FROM").append(CR);
        buf.append("     t_ar_verificationbill bill").append(CR);
        buf.append(" INNER JOIN t_ar_verificationbillentry billEntry").append(CR);
        buf.append(" ON").append(CR);
        buf.append("     bill.FID = billEntry.FParentID").append(CR);
        buf.append(" WHERE").append(CR);
        buf.append("     bill.FVerificationType = 101 AND bill.FBillType_Main != bill.FBillType_second AND").append(CR);
        buf.append("     (").append(CR);
        buf.append("         billEntry.fbillsubtype = 101 OR billEntry.fbillsubtype = 103").append(CR);
        buf.append("     )").append(CR);
        buf.append(" AND billEntry.FVeriType != 1").append(CR);
        return buf.toString();
    }

    private static String getproxybillSQL() {
        StringBuffer buf = new StringBuffer();
        buf.append(" SELECT").append(CR);
        buf.append("     fid,").append(CR);
        buf.append("     'proxybill' fbilltypedes,").append(CR);
        buf.append("     -1 AS fbilltype,").append(CR);
        buf.append("     -1 AS fveriType,").append(CR);
        buf.append("     fnumber,").append(CR);
        buf.append("     fcompanyorgunitid fcompanyid,").append(CR);
        buf.append("     fbilldate fbilldate,").append(CR);
        buf.append("     fcreatorid,").append(CR);
        buf.append("     fcreatetime,").append(CR);
        buf.append("     flastupdateuserid,").append(CR);
        buf.append("     flastupdatetime,").append(CR);
        buf.append("     fcontrolunitid,").append(CR);
        buf.append("     CASE fcheckedstatus").append(CR);
        buf.append("         WHEN 1").append(CR);
        buf.append("         THEN 0").append(CR);
        buf.append("         ELSE 1").append(CR);
        buf.append("     END fisaudited,").append(CR);
        buf.append("     0 AS FisCash,").append(CR);
        buf.append("     0 AS FIsUnver,").append(CR);
        buf.append("     CASE FIsNeedVoucher").append(CR);
        buf.append("         WHEN 1").append(CR);
        buf.append("         THEN ISNULL(FFiVouchered,0)").append(CR);
        buf.append("         ELSE 1").append(CR);
        buf.append("     END AS ffivouchered,").append(CR);
        buf.append("     0   AS FIsBizBill").append(CR);
        buf.append(" FROM").append(CR);
        buf.append("     t_arp_proxybill bill").append(CR);
        return buf.toString();
    }

    private static String getexgRateBillSQL() {
        StringBuffer buf = new StringBuffer();
        buf.append(" SELECT").append(CR);
        buf.append("     fid,").append(CR);
        buf.append("     'exgRateBill' fbilltypedes,").append(CR);
        buf.append("     -1 AS fbilltype,").append(CR);
        buf.append("     -1 AS fveriType,").append(CR);
        buf.append("     fnumber,").append(CR);
        buf.append("     fcompanyid,").append(CR);
        buf.append("     FExgRateDate fbilldate,").append(CR);
        buf.append("     fcreatorid,").append(CR);
        buf.append("     fcreatetime,").append(CR);
        buf.append("     flastupdateuserid,").append(CR);
        buf.append("     flastupdatetime,").append(CR);
        buf.append("     fcontrolunitid,").append(CR);
        buf.append("     CASE fbillstatus").append(CR);
        buf.append("         WHEN 3").append(CR);
        buf.append("         THEN 1").append(CR);
        buf.append("         ELSE 0").append(CR);
        buf.append("     END fisaudited,").append(CR);
        buf.append("     0 AS FisCash,").append(CR);
        buf.append("     0 AS FIsUnver,").append(CR);
        buf.append("     CASE Isnull(ffivouchered,0)").append(CR);
        buf.append("         WHEN 1").append(CR);
        buf.append("         THEN 1").append(CR);
        buf.append("         ELSE 0").append(CR);
        buf.append("     END ffivouchered,").append(CR);
        buf.append("     0 AS FIsBizBill").append(CR);
        buf.append(" FROM").append(CR);
        buf.append("     T_AR_ArExgRateBill ;").append(CR);
        return buf.toString();
    }

    private static String getAPBillSQL() {
        StringBuffer buf = new StringBuffer();
        buf.append(" SELECT").append(CR);
        buf.append("     fid, 'otherbill' fbilltypedes, -1 AS fbilltype, -1 AS fveriType, fnumber, fcompanyid, ").append(CR);
        buf.append(" \tfbilldate, fcreatorid, fcreatetime, flastupdateuserid, flastupdatetime, fcontrolunitid,").append(CR);
        buf.append("     CASE fbillstatus").append(CR);
        buf.append("         WHEN 3").append(CR);
        buf.append("         THEN 1").append(CR);
        buf.append("         ELSE 0").append(CR);
        buf.append("     END fisaudited,").append(CR);
        buf.append("     CASE fpaymenttypeid").append(CR);
        buf.append("         WHEN 'cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5'").append(CR);
        buf.append("         THEN 1").append(CR);
        buf.append("         WHEN '40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5'").append(CR);
        buf.append("         THEN 1").append(CR);
        buf.append("         ELSE 0").append(CR);
        buf.append("     END FIsCash,").append(CR);
        buf.append("     CASE FunVerifyAmount").append(CR);
        buf.append("         WHEN 0").append(CR);
        buf.append("         THEN 0").append(CR);
        buf.append("         ELSE 1").append(CR);
        buf.append("     END FIsUnver,").append(CR);
        buf.append("     CASE FIsNeedVoucher").append(CR);
        buf.append("         WHEN 1").append(CR);
        buf.append("         THEN ISNULL(FFiVouchered,0)").append(CR);
        buf.append("         ELSE 1").append(CR);
        buf.append("     END AS ffivouchered,").append(CR);
        buf.append("     FIsBizBill").append(CR);
        buf.append(" FROM").append(CR);
        buf.append("     t_ap_otherbill").append(CR);
        buf.append("     where ISNULL(fsourcebilltype, 0) <> 14").append(CR);
        return buf.toString();
    }

    private static String getpaymentBillSQL() {
        StringBuffer buf = new StringBuffer();
        buf.append(" SELECT").append(CR);
        buf.append("     bill.fid AS fid,").append(CR);
        buf.append("     'paymentBill' fbilltypedes,").append(CR);
        buf.append("     CASE ltrim(rtrim(").append(CR);
        buf.append("                 CASE").append(CR);
        buf.append("                     WHEN t11.fnumber IS NULL").append(CR);
        buf.append("                     THEN billType.fnumber").append(CR);
        buf.append("                     ELSE t11.fnumber").append(CR);
        buf.append("                 END))").append(CR);
        buf.append("         WHEN '201' THEN 201 WHEN '202' THEN 202 WHEN '203' THEN 203 WHEN '204' THEN 204 ").append(CR);
        buf.append(" \t\tWHEN '205' THEN 205 WHEN '206' THEN 206 WHEN '210' THEN 210 WHEN '211' THEN 211 ").append(CR);
        buf.append(" \t\tWHEN '221' THEN 221 WHEN '999' THEN 999 ELSE 201 END fbilltype,").append(CR);
        buf.append("     1                      AS fveriType,").append(CR);
        buf.append("     bill.fnumber           AS fnumber,").append(CR);
        buf.append("     bill.fcompanyid        AS fcompanyid,").append(CR);
        buf.append("     bill.fbizdate          AS fbilldate,").append(CR);
        buf.append("     bill.fcreatorid        AS fcreatorid,").append(CR);
        buf.append("     bill.fcreatetime       AS fcreatetime,").append(CR);
        buf.append("     bill.flastupdateuserid AS flastupdateuserid,").append(CR);
        buf.append("     bill.flastupdatetime   AS flastupdatetime,").append(CR);
        buf.append("     bill.fcontrolunitid    AS fcontrolunitid,").append(CR);
        buf.append(" \tCASE bill.fbillstatus WHEN 10 THEN 0 WHEN 11 THEN 0 WHEN 12 THEN 2 ELSE 1 END fisaudited,").append(CR);
        buf.append("     CASE fpaymenttypeid").append(CR);
        buf.append("         WHEN 'cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5'").append(CR);
        buf.append("         THEN 1").append(CR);
        buf.append("         WHEN '40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5'").append(CR);
        buf.append("         THEN 1").append(CR);
        buf.append("         ELSE 0").append(CR);
        buf.append("     END FIsCash,").append(CR);
        buf.append("     CASE FunVerifiedAmt").append(CR);
        buf.append("         WHEN 0").append(CR);
        buf.append("         THEN 0").append(CR);
        buf.append("         ELSE 1").append(CR);
        buf.append("     END FIsUnver,").append(CR);
        buf.append("     CASE bill.FIsNeedVoucher").append(CR);
        buf.append("         WHEN 1").append(CR);
        buf.append("         THEN ISNULL(bill.FFiVouchered,0)").append(CR);
        buf.append("         ELSE 1").append(CR);
        buf.append("     END AS ffivouchered,").append(CR);
        buf.append("     0   AS FIsBizBill").append(CR);
        buf.append(" FROM").append(CR);
        buf.append("     t_cas_paymentbill bill").append(CR);
        buf.append(" INNER JOIN T_CAS_PaymentBillType billType").append(CR);
        buf.append(" ON bill.FPayBillTypeID = billType.FID").append(CR);
        buf.append(" LEFT JOIN t_cas_paymentbilltype AS t11").append(CR);
        buf.append(" ON billType.FPreSetBillTypeID = t11.FID").append(CR);
        buf.append(" WHERE fsourcetype = 101").append(CR);
        return buf.toString();
    }

    private static String getAPverifyBillSQL() {
        StringBuffer buf = new StringBuffer();
        buf.append(" SELECT").append(CR);
        buf.append("     bill.fid AS fid,").append(CR);
        buf.append("     'verifyBill' fbilltypedes,").append(CR);
        buf.append("     -1                     AS fbilltype,").append(CR);
        buf.append("     -1                     AS fveriType,").append(CR);
        buf.append("     bill.fnumber           AS fnumber,").append(CR);
        buf.append("     bill.fcompanyid        AS fcompanyid,").append(CR);
        buf.append("     bill.fbizdate          AS fbilldate,").append(CR);
        buf.append("     bill.fcreatorid        AS fcreatorid,").append(CR);
        buf.append("     bill.fcreatetime       AS fcreatetime,").append(CR);
        buf.append("     bill.flastupdateuserid AS flastupdateuserid,").append(CR);
        buf.append("     bill.flastupdatetime   AS flastupdatetime,").append(CR);
        buf.append("     bill.fcontrolunitid    AS fcontrolunitid,").append(CR);
        buf.append("     1 fisaudited,").append(CR);
        buf.append("     FISCASHSALEPUR AS FisCash,").append(CR);
        buf.append("     0              AS FIsUnver,").append(CR);
        buf.append("     CASE Isnull(bill.ffivouchered,0)").append(CR);
        buf.append("         WHEN 1").append(CR);
        buf.append("         THEN 1").append(CR);
        buf.append("         ELSE 0").append(CR);
        buf.append("     END ffivouchered,").append(CR);
        buf.append("     0 AS FIsBizBill").append(CR);
        buf.append(" FROM").append(CR);
        buf.append("     t_ap_verificationbill bill").append(CR);
        buf.append(" INNER JOIN t_ap_verificationbillentry billEntry").append(CR);
        buf.append(" ON").append(CR);
        buf.append("     bill.FID = billEntry.FParentID").append(CR);
        buf.append(" WHERE").append(CR);
        buf.append("     bill.FVerificationType != 201 AND bill.FBillType_Main != bill.FBillType_second AND billEntry.FVeriType != 1").append(CR);
        buf.append(" UNION ALL").append(CR);
        buf.append("   SELECT bill.fid as fid,").append(CR);
        buf.append("          'verifyBill' fbilltypedes,").append(CR);
        buf.append("          -1 as fbilltype,").append(CR);
        buf.append("          -1 as fveriType,").append(CR);
        buf.append("          bill.fnumber as fnumber,").append(CR);
        buf.append("          bill.fcompanyid as fcompanyid,").append(CR);
        buf.append("          bill.fbizdate as fbilldate,").append(CR);
        buf.append("          bill.fcreatorid as fcreatorid,").append(CR);
        buf.append("          bill.fcreatetime as fcreatetime,").append(CR);
        buf.append("          bill.flastupdateuserid as flastupdateuserid,").append(CR);
        buf.append("          bill.flastupdatetime as flastupdatetime,").append(CR);
        buf.append("          bill.fcontrolunitid as fcontrolunitid,").append(CR);
        buf.append("          1 fisaudited,").append(CR);
        buf.append(" \t FISCASHSALEPUR AS FisCash,").append(CR);
        buf.append(" \t 0              AS FIsUnver,").append(CR);
        buf.append("          CASE Isnull(bill.ffivouchered,0)").append(CR);
        buf.append("            WHEN 1 THEN 1").append(CR);
        buf.append("            ELSE 0").append(CR);
        buf.append("          END ffivouchered,").append(CR);
        buf.append("          0 AS FIsBizBill").append(CR);
        buf.append("   FROM   t_ap_verificationbill bill").append(CR);
        buf.append("   INNER JOIN t_ap_verificationbillentry billEntry").append(CR);
        buf.append("   ON bill.FID = billEntry.FParentID").append(CR);
        buf.append("   where bill.fIsSameCurrency = 0 or Isnull(billEntry.FGainAndLoss,0) <> 0 ").append(CR);
        buf.append(" UNION ALL").append(CR);
        buf.append(" SELECT").append(CR);
        buf.append("     bill.fid AS fid,").append(CR);
        buf.append("     'verifyBill' fbilltypedes,").append(CR);
        buf.append("     -1                     AS fbilltype,").append(CR);
        buf.append("     -100                   AS fveriType,").append(CR);
        buf.append("     bill.fnumber           AS fnumber,").append(CR);
        buf.append("     bill.fcompanyid        AS fcompanyid,").append(CR);
        buf.append("     bill.fbizdate          AS fbilldate,").append(CR);
        buf.append("     bill.fcreatorid        AS fcreatorid,").append(CR);
        buf.append("     bill.fcreatetime       AS fcreatetime,").append(CR);
        buf.append("     bill.flastupdateuserid AS flastupdateuserid,").append(CR);
        buf.append("     bill.flastupdatetime   AS flastupdatetime,").append(CR);
        buf.append("     bill.fcontrolunitid    AS fcontrolunitid,").append(CR);
        buf.append("     1 fisaudited,").append(CR);
        buf.append("     FISCASHSALEPUR AS FisCash,").append(CR);
        buf.append("     0              AS FIsUnver,").append(CR);
        buf.append("     CASE Isnull(bill.ffivouchered,0)").append(CR);
        buf.append("         WHEN 1").append(CR);
        buf.append("         THEN 1").append(CR);
        buf.append("         ELSE 0").append(CR);
        buf.append("     END ffivouchered,").append(CR);
        buf.append("     ").append(CR);
        buf.append("     0 AS FIsBizBill").append(CR);
        buf.append(" FROM").append(CR);
        buf.append("     t_ap_verificationbill bill").append(CR);
        buf.append(" INNER JOIN t_ap_verificationbillentry billEntry").append(CR);
        buf.append(" ON").append(CR);
        buf.append("     bill.FID = billEntry.FParentID").append(CR);
        buf.append(" WHERE").append(CR);
        buf.append("     bill.FVerificationType = 201 AND").append(CR);
        buf.append("     (").append(CR);
        buf.append("         billEntry.fbillsubtype = 201 OR billEntry.fbillsubtype = 203").append(CR);
        buf.append("     )").append(CR);
        buf.append(" UNION ALL").append(CR);
        buf.append(" SELECT").append(CR);
        buf.append("     bill.fid AS fid,").append(CR);
        buf.append("     'verifyBill' fbilltypedes,").append(CR);
        buf.append("     -1                     AS fbilltype,").append(CR);
        buf.append("     -200                   AS fveriType,").append(CR);
        buf.append("     bill.fnumber           AS fnumber,").append(CR);
        buf.append("     bill.fcompanyid        AS fcompanyid,").append(CR);
        buf.append("     bill.fbizdate          AS fbilldate,").append(CR);
        buf.append("     bill.fcreatorid        AS fcreatorid,").append(CR);
        buf.append("     bill.fcreatetime       AS fcreatetime,").append(CR);
        buf.append("     bill.flastupdateuserid AS flastupdateuserid,").append(CR);
        buf.append("     bill.flastupdatetime   AS flastupdatetime,").append(CR);
        buf.append("     bill.fcontrolunitid    AS fcontrolunitid,").append(CR);
        buf.append("     1 fisaudited,").append(CR);
        buf.append("     FISCASHSALEPUR AS FisCash,").append(CR);
        buf.append("     0              AS FIsUnver,").append(CR);
        buf.append("     1 ffivouchered,").append(CR);
        buf.append("     0 AS FIsBizBill").append(CR);
        buf.append(" FROM").append(CR);
        buf.append("     t_ap_verificationbill bill").append(CR);
        buf.append(" INNER JOIN t_ap_verificationbillentry billEntry").append(CR);
        buf.append(" ON").append(CR);
        buf.append("     bill.FID = billEntry.FParentID").append(CR);
        buf.append(" WHERE").append(CR);
        buf.append("     bill.FVerificationType = 201 AND bill.FBillType_Main = 4 AND bill.FBillType_second = 4 AND").append(CR);
        buf.append("     (").append(CR);
        buf.append("         billEntry.fbillsubtype = 202 OR billEntry.fbillsubtype = 204").append(CR);
        buf.append("     )").append(CR);
        buf.append(" UNION ALL").append(CR);
        buf.append(" SELECT").append(CR);
        buf.append("     bill.fid AS fid,").append(CR);
        buf.append("     'verifyBill' fbilltypedes,").append(CR);
        buf.append("     -1                     AS fbilltype,").append(CR);
        buf.append("     -200                   AS fveriType,").append(CR);
        buf.append("     bill.fnumber           AS fnumber,").append(CR);
        buf.append("     bill.fcompanyid        AS fcompanyid,").append(CR);
        buf.append("     bill.fbizdate          AS fbilldate,").append(CR);
        buf.append("     bill.fcreatorid        AS fcreatorid,").append(CR);
        buf.append("     bill.fcreatetime       AS fcreatetime,").append(CR);
        buf.append("     bill.flastupdateuserid AS flastupdateuserid,").append(CR);
        buf.append("     bill.flastupdatetime   AS flastupdatetime,").append(CR);
        buf.append("     bill.fcontrolunitid    AS fcontrolunitid,").append(CR);
        buf.append("     1 fisaudited,").append(CR);
        buf.append("     FISCASHSALEPUR AS FisCash,").append(CR);
        buf.append("     0              AS FIsUnver,").append(CR);
        buf.append("     CASE Isnull(bill.ffivouchered,0)").append(CR);
        buf.append("         WHEN 1").append(CR);
        buf.append("         THEN 1").append(CR);
        buf.append("         ELSE 0").append(CR);
        buf.append("     END ffivouchered,").append(CR);
        buf.append("     0 AS FIsBizBill").append(CR);
        buf.append(" FROM").append(CR);
        buf.append("     t_ap_verificationbill bill").append(CR);
        buf.append(" INNER JOIN t_ap_verificationbillentry billEntry").append(CR);
        buf.append(" ON").append(CR);
        buf.append("     bill.FID = billEntry.FParentID").append(CR);
        buf.append(" WHERE").append(CR);
        buf.append("     bill.FVerificationType = 201 AND bill.FBillType_Main != bill.FBillType_second AND").append(CR);
        buf.append("     (").append(CR);
        buf.append("         billEntry.fbillsubtype = 202 OR billEntry.fbillsubtype = 204").append(CR);
        buf.append("     )").append(CR);
        buf.append(" AND billEntry.FVeriType != 1").append(CR);
        return buf.toString();
    }

    private static String getAPproxybillSQL() {
        StringBuffer buf = new StringBuffer();
        buf.append(" SELECT").append(CR);
        buf.append("     fid, 'proxybill' fbilltypedes, -1 AS fbilltype, -1 AS fveriType, fnumber, ").append(CR);
        buf.append(" \tfcompanyorgunitid fcompanyid, fbilldate fbilldate, fcreatorid, fcreatetime, ").append(CR);
        buf.append(" \tflastupdateuserid, flastupdatetime, fcontrolunitid,").append(CR);
        buf.append("     CASE fcheckedstatus WHEN 1 THEN 0 ELSE 1 END fisaudited,").append(CR);
        buf.append("     0 AS FisCash, 0 AS FIsUnver,").append(CR);
        buf.append("     CASE FIsNeedVoucher WHEN 1 THEN ISNULL(FFiVouchered,0)").append(CR);
        buf.append("         ELSE 1 END AS ffivouchered,").append(CR);
        buf.append("     0   AS FIsBizBill").append(CR);
        buf.append(" FROM t_arp_proxybill bill").append(CR);
        return buf.toString();
    }

    private static String getAPexgRateBillSQL() {
        StringBuffer buf = new StringBuffer();
        buf.append(" SELECT").append(CR);
        buf.append("     fid, 'exgRateBill' fbilltypedes, -1 AS fbilltype, -1 AS fveriType, fnumber, fcompanyid, ").append(CR);
        buf.append(" \tFExgRateDate fbilldate, fcreatorid, fcreatetime, flastupdateuserid, flastupdatetime, ").append(CR);
        buf.append(" \tfcontrolunitid,").append(CR);
        buf.append("     CASE fbillstatus WHEN 3 THEN 1 ELSE 0 END fisaudited,").append(CR);
        buf.append("     0 AS FisCash, 0 AS FIsUnver,").append(CR);
        buf.append("     CASE Isnull(ffivouchered,0) WHEN 1 THEN 1 ELSE 0 END ffivouchered,").append(CR);
        buf.append("     0 AS FIsBizBill").append(CR);
        buf.append(" FROM T_AP_ApExgRateBill;").append(CR);
        return buf.toString();
    }
}

