/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.util.UserInfoUtils;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgCollection;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgFactory;
import com.kingdee.eas.basedata.common.perf.app.PerfSepServerUtils;
import com.kingdee.eas.basedata.common.perf.app.util.MessageInfo;
import com.kingdee.eas.basedata.common.perf.app.util.MessageUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.ar.IManageAccount;
import com.kingdee.eas.fi.ar.ManageAccountFactory;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.LocaleUtils;
import java.util.Locale;

public class ArApCloseAccountJobHandler
implements IJobHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Job job) throws Exception {
        try {
            Context ctx = job.getContext();
            Object params = job.getParameters();
            CompanyOrgUnitInfo company = null;
            Boolean isAr = Boolean.FALSE;
            Locale locale = null;
            UserInfo userInfo = null;
            if (params != null && params instanceof Object[]) {
                Object[] parObjs = (Object[])params;
                company = (CompanyOrgUnitInfo)parObjs[0];
                isAr = (Boolean)parObjs[1];
                locale = (Locale)parObjs[2];
                userInfo = (UserInfo)parObjs[3];
                if (userInfo != null && userInfo.getNumber() != null) {
                    userInfo = UserInfoUtils.getUserInfo4LoinModule((Context)ctx, (String)userInfo.getNumber().toString());
                }
                ctx.put((Object)"UserInfo", (Object)userInfo);
            } else {
                locale = LocaleUtils.locale_L2;
            }
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String flag = null;
            MessageInfo msgInfo = new MessageInfo();
            String tranDefNumber = "SCM_FI_AP_001";
            if (isAr.booleanValue()) {
                flag = EASCommonResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"ArCloseAccount", (Locale)locale);
                tranDefNumber = "SCM_FI_AR_001";
            } else {
                flag = EASCommonResource.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"ApCloseAccount", (Locale)locale);
            }
            PeriodInfo currentPeriod = null;
            SystemEnum systemEnum = isAr != false ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
            SystemStatusCtrolInfo ctrlStatus = CommonServerUtils.getSysStatusCtrolInfo(ctx, company, systemEnum);
            currentPeriod = ctrlStatus.getCurrentPeriod();
            flag = currentPeriod.toString() + flag;
            this.setMsgInfo(msgInfo, userId, company, flag, true, locale);
            try {
                IManageAccount ida = ManageAccountFactory.getLocalInstance(job.getContext());
                if (isAr.booleanValue()) {
                    ida.closerArAccountForJobHandler(company);
                } else {
                    ida.closerApAccountForJobHandler(company);
                }
                JobLog log = new JobLog(JobLog.Type.Info, flag + this.getStrResource("Success"));
                job.saveMessage(log);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)tranDefNumber, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("isStart", (Object)1, CompareType.EQUALS));
                view.setFilter(filter);
                PerfSepCfgCollection col = PerfSepCfgFactory.getLocalInstance((Context)ctx).getPerfSepCfgCollection(view);
                if (col != null && col.size() > 0) {
                    msgInfo.setSendMsg(col.get(0).isIsSendMsg());
                }
                MessageUtil.sendMsg((Context)ctx, (MessageInfo)msgInfo);
            }
            catch (Exception e) {
                msgInfo.setSuccessed(false);
                msgInfo.setExecption(e.getMessage());
                MessageUtil.sendMsg((Context)ctx, (MessageInfo)msgInfo);
                throw e;
            }
        }
        finally {
            PerfSepServerUtils.updateTaskState((Job)job);
        }
        return new Boolean(true);
    }

    private void setMsgInfo(MessageInfo msgInfo, String userId, CompanyOrgUnitInfo company, String flag, boolean issuccessed, Locale locale) throws Exception {
        msgInfo.setbizAction(flag);
        msgInfo.setOrgNumber(company.getName(locale) + "  (" + company.getNumber() + ")");
        msgInfo.setUserID(userId);
        msgInfo.setExecption("");
        msgInfo.setSuccessed(issuccessed);
    }

    private String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey);
    }
}

