/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.util.ListUtil;
import com.kingdee.eas.fi.arap.app.AbstractArApCombTransferFacadeControllerBean;
import com.kingdee.eas.fi.arap.app.combTrans.CombTransferFacatory;
import com.kingdee.eas.fi.arap.app.combTrans.ICombTransfer;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.IFMIsqlFacade;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ArApCombTransferFacadeControllerBean
extends AbstractArApCombTransferFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.ArApCombTransferFacadeControllerBean");
    public static final String RESOURCE_NAME = "com.kingdee.eas.fi.arap.CombTransResource";
    public static final String COMBIN_RULE_BOSTYPE = "D4C58B67";
    public static final String COMBIN_RULE_FIELDS = "combinFields";
    public static final String COMBIN_RULE_FIELDS_NAME = "combinFieldsName";
    public static final String SPLIT_SIGN = "_";
    public static final String RT = "\n";
    private ICombTransfer iCombTransfer;
    private String bosType;

    @Override
    protected Map _checkData(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList.size() == 0) {
            return Collections.emptyMap();
        }
        this.bosType = BOSUuid.read((String)idList.get(0).toString()).getType().toString();
        ICombTransfer iCombTransfer = CombTransferFacatory.getInstance().getCombTrans(ctx, this.bosType);
        Map<String, String> result = iCombTransfer.checkData(idList);
        return result;
    }

    @Override
    protected Map _checkDiff(Context ctx, List idList, List entryIdList, String combinRuleId) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)combinRuleId) || idList == null || idList.isEmpty()) {
            return result;
        }
        this.bosType = BOSUuid.read((String)idList.get(0).toString()).getType().toString();
        this.iCombTransfer = CombTransferFacatory.getInstance().getCombTrans(ctx, this.bosType);
        Map<String, String> combinRuleInfo = this.getCombinRuleInfo(ctx, combinRuleId);
        String combinFields = combinRuleInfo.get(COMBIN_RULE_FIELDS);
        if (StringUtils.isEmpty((String)combinFields)) {
            return result;
        }
        String combinFieldsName = combinRuleInfo.get(COMBIN_RULE_FIELDS_NAME);
        String[] combinFieldsArr = combinFields.split(SPLIT_SIGN);
        List<String> combinFieldsList = Arrays.asList(combinFieldsArr);
        CoreBillBaseCollection coll = this.getBillColl(ctx, idList, combinFieldsList);
        this.iCombTransfer.checkPermissionItem(coll);
        Map<String, ICombTransfer> combTransferMap = this.getCombtransferMap(ctx, this.bosType, combinFieldsList, entryIdList, coll);
        StringBuilder msgBuilder = new StringBuilder(100);
        for (Map.Entry<String, ICombTransfer> entry : combTransferMap.entrySet()) {
            ICombTransfer combTransfer = entry.getValue();
            String key = combTransfer.getKey();
            combTransfer.calDiff();
            BigDecimal diff = combTransfer.getDiff();
            if (diff.compareTo(BigDecimal.ZERO) == 0) continue;
            msgBuilder.append(this.getResourceStr(ctx, "GROUP_HAS_DIFF", new Object[]{combTransfer.getKeyDesc(), diff})).append(RT);
        }
        if (msgBuilder.length() > 0) {
            StringBuilder msg = new StringBuilder(20).append(this.getResourceStr(ctx, "GROUP_CHECK_RESULT", new Object[]{combinFieldsName})).append(RT);
            result.put("detailMsg", msg + msgBuilder.toString());
            result.put("msg", this.getResourceStr(ctx, "CHECK_HAS_DIFF_CONFIRM"));
        }
        return result;
    }

    @Override
    protected Map _combTransfer(Context ctx, List idList, List entryIdList, String combinRuleId) throws BOSException, EASBizException {
        this.bosType = BOSUuid.read((String)idList.get(0).toString()).getType().toString();
        this.iCombTransfer = CombTransferFacatory.getInstance().getCombTrans(ctx, this.bosType);
        this.addSQLLock(ctx, idList);
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, String> combinRuleInfo = this.getCombinRuleInfo(ctx, combinRuleId);
        String combinFields = combinRuleInfo.get(COMBIN_RULE_FIELDS);
        if (StringUtils.isEmpty((String)combinFields)) {
            return result;
        }
        String[] combinFieldsArr = combinFields.split(SPLIT_SIGN);
        List<String> combinFieldsList = Arrays.asList(combinFieldsArr);
        CoreBillBaseCollection coll = this.getBillColl(ctx, idList, combinFieldsList);
        if (coll.size() == 0) {
            return result;
        }
        this.iCombTransfer.checkBeforeCombTransfer(coll);
        Map<String, ICombTransfer> combTransferMap = this.getCombtransferMap(ctx, this.bosType, combinFieldsList, entryIdList, coll);
        HashSet<String> modifyEntryIdSet = new HashSet<String>();
        StringBuilder errMsg = new StringBuilder(100);
        for (Map.Entry<String, ICombTransfer> entry : combTransferMap.entrySet()) {
            ICombTransfer combTransfer = entry.getValue();
            String key = combTransfer.getKey();
            combTransfer.calDiff();
            Map resultData = combTransfer.combTransfer();
            if (resultData != null && resultData.size() > 0) {
                errMsg.append(key + ":" + resultData.get("errorMsg")).append(RT);
            }
            modifyEntryIdSet.addAll(combTransfer.getEntryIdSet());
        }
        if (errMsg.length() > 0) {
            result.put("msg", this.getResourceStr(ctx, "COMBTRANS_ERROR"));
            result.put("detailMsg", errMsg.substring(0, errMsg.length() - RT.length()));
            return result;
        }
        this.updateData(ctx, modifyEntryIdSet, (IObjectCollection)coll);
        return result;
    }

    @Override
    protected Map _combTransfer4BillInfo(Context ctx, CoreBillBaseCollection billColl, String combinRuleId) throws BOSException, EASBizException {
        this.bosType = billColl.getObject(0).getBOSType().toString();
        this.iCombTransfer = CombTransferFacatory.getInstance().getCombTrans(ctx, this.bosType);
        HashMap<String, String> result = new HashMap<String, String>();
        String[] combinFieldsArr = null;
        List<String> combinFieldsList = null;
        if (StringUtils.isEmpty((String)combinRuleId)) {
            combinFieldsList = new ArrayList<String>();
        } else {
            Map<String, String> combinRuleInfo = this.getCombinRuleInfo(ctx, combinRuleId);
            String combinFields = combinRuleInfo.get(COMBIN_RULE_FIELDS);
            if (StringUtils.isEmpty((String)combinFields)) {
                return result;
            }
            combinFieldsArr = combinFields.split(SPLIT_SIGN);
            combinFieldsList = Arrays.asList(combinFieldsArr);
        }
        if (billColl.size() == 0) {
            return result;
        }
        this.iCombTransfer.checkBeforeCombTransfer(billColl);
        Map<String, ICombTransfer> combTransferMap = this.getCombtransferMap(ctx, this.bosType, combinFieldsList, null, billColl);
        HashSet modifyEntryIdSet = new HashSet();
        StringBuilder errMsg = new StringBuilder(100);
        if (combTransferMap.size() == 0) {
            errMsg.append(this.getResourceStr(ctx, "NO_DIFF")).append(RT);
        } else {
            for (Map.Entry<String, ICombTransfer> entry : combTransferMap.entrySet()) {
                ICombTransfer combTransfer = entry.getValue();
                String key = combTransfer.getKey();
                combTransfer.calDiff();
                BigDecimal diff = combTransfer.getDiff();
                if (diff.compareTo(BigDecimal.ZERO) == 0) {
                    errMsg.append(this.getResourceStr(ctx, "NO_DIFF")).append(RT);
                    continue;
                }
                Map resultData = combTransfer.combTransfer();
                if (resultData != null && resultData.size() > 0) {
                    errMsg.append(key + ":" + resultData.get("errorMsg")).append(RT);
                }
                modifyEntryIdSet.addAll(combTransfer.getEntryIdSet());
            }
        }
        if (errMsg.length() > 0) {
            result.put("msg", this.getResourceStr(ctx, "COMBTRANS_ERROR"));
            result.put("detailMsg", errMsg.substring(0, errMsg.length() - RT.length()));
            return result;
        }
        this.iCombTransfer.doSumEntry(billColl);
        result.put("result", (String)billColl);
        return result;
    }

    public void updateData(Context ctx, Set<String> modifyEntryIdSet, IObjectCollection coll) throws EASBizException, BOSException {
        if (modifyEntryIdSet.size() == 0) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CoreBillBaseCollection modifyBillColl = new CoreBillBaseCollection();
        StringBuffer modifyNumbers = new StringBuffer(100);
        String numberField = this.iCombTransfer.getNumberField();
        block0: for (int i = 0; i < coll.size(); ++i) {
            IObjectValue billInfo = coll.getObject(i);
            IObjectCollection entryColl = (IObjectCollection)billInfo.get(this.iCombTransfer.getEntryField());
            for (int j = 0; j < entryColl.size(); ++j) {
                String entryId = entryColl.getObject(j).get("id").toString();
                if (!modifyEntryIdSet.contains(entryId)) continue;
                modifyBillColl.add((CoreBillBaseInfo)billInfo);
                modifyNumbers.append(billInfo.get(numberField)).append(",");
                continue block0;
            }
        }
        if (modifyBillColl.size() > 0) {
            this.iCombTransfer.doSumEntry(modifyBillColl);
            IObjectPK logPK = null;
            BOSObjectType bosType = BOSObjectType.create((String)this.bosType);
            String logItem = this.iCombTransfer.getLogItem();
            String numbers = modifyNumbers.substring(0, modifyNumbers.length() - 1);
            if (!StringUtils.isEmpty((String)logItem)) {
                logPK = LogUtil.beginLog((Context)ctx, (String)this.getResourceStr(ctx, "COMBTRANS"), (BOSObjectType)bosType, null, (String)numbers, (String)logItem);
            }
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            iDynamicObject.invoke(bosType, "updatePartialBatchData", new Object[]{modifyBillColl, this.iCombTransfer.getUpdateSelect()});
            if (logPK != null) {
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            }
        }
        logger.info((Object)("updateData:" + (System.currentTimeMillis() - startTime) + "ms"));
    }

    public Map<String, String> getCombinRuleInfo(Context ctx, String combinRuleId) throws BOSException {
        HashMap<String, String> combinRuleInfo = new HashMap<String, String>();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)combinRuleId, CompareType.EQUALS));
        ev.setFilter(filter);
        IDynamicObject IdynObj = DynamicObjectFactory.getLocalInstance((Context)ctx);
        BOSObjectType combinRuleType = BOSObjectType.create((String)COMBIN_RULE_BOSTYPE);
        IObjectCollection combinRuleColl = IdynObj.getCollection(combinRuleType, ev);
        if (combinRuleColl.size() == 0) {
            return combinRuleInfo;
        }
        combinRuleInfo.put(COMBIN_RULE_FIELDS, (String)combinRuleColl.getObject(0).get(COMBIN_RULE_FIELDS));
        combinRuleInfo.put(COMBIN_RULE_FIELDS_NAME, (String)combinRuleColl.getObject(0).get(COMBIN_RULE_FIELDS_NAME));
        return combinRuleInfo;
    }

    private Map<String, ICombTransfer> getCombtransferMap(Context ctx, String bosType, List<String> combinFieldsList, List entryIdList, CoreBillBaseCollection coll) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        HashMap<String, ICombTransfer> combTransferMap = new HashMap<String, ICombTransfer>();
        ArrayList<String> headFields = new ArrayList<String>();
        ArrayList<String> entryFields = new ArrayList<String>();
        String entryField = this.iCombTransfer.getEntryField() + ".";
        for (String field : combinFieldsList) {
            if (field.indexOf(entryField) >= 0) {
                entryFields.add(field.substring(entryField.length(), field.length()));
                continue;
            }
            headFields.add(field);
        }
        Map initData = null;
        for (int i = 0; i < coll.size(); ++i) {
            IObjectValue bill = coll.getObject(i);
            StringBuilder headKey = this.getInfoKey(bill, headFields);
            List<String> headDescArray = this.getInfoKeyDescArray(bill, headFields);
            IObjectCollection entryColl = (IObjectCollection)bill.get(this.iCombTransfer.getEntryField());
            for (int j = 0; j < entryColl.size(); ++j) {
                ICombTransfer combTransfer;
                StringBuilder entryKey;
                IObjectValue entry = entryColl.getObject(j);
                if (entryIdList != null && entryIdList.size() != 0 && !entryIdList.contains(entry.get("id").toString()) || !this.iCombTransfer.checkEntryForCombTransfer((CoreBillEntryBaseInfo)entry)) continue;
                String groupKey = "";
                if (headKey != null && headKey.length() > 0) {
                    groupKey = headKey.toString();
                }
                if ((entryKey = this.getInfoKey(entry, entryFields)) != null && entryKey.length() > 0) {
                    groupKey = groupKey + entryKey.toString();
                }
                if (!StringUtils.isEmpty((String)groupKey)) {
                    groupKey = groupKey.substring(0, groupKey.length() - SPLIT_SIGN.length());
                }
                if (combTransferMap.get(groupKey) != null) {
                    combTransfer = (ICombTransfer)combTransferMap.get(groupKey);
                } else {
                    combTransfer = CombTransferFacatory.getInstance().getCombTrans(ctx, bosType);
                    combTransfer.setKey(groupKey);
                    combTransferMap.put(groupKey, combTransfer);
                    ArrayList<String> groupKeyDesc = new ArrayList<String>(headDescArray);
                    groupKeyDesc.addAll(this.getInfoKeyDescArray(entry, entryFields));
                    List<String> descList = this.convertDesc(ctx, groupKeyDesc, "name");
                    String desc = descList.isEmpty() ? "" : descList.toString();
                    combTransfer.setKeyDesc(desc);
                }
                combTransfer.getEntryList().add((CoreBillEntryBaseInfo)entry);
                combTransfer.getBillMap().put(entry.get("id").toString(), (CoreBillBaseInfo)bill);
                if (initData == null) {
                    initData = combTransfer.initData();
                    continue;
                }
                combTransfer.getInitData().putAll(initData);
            }
        }
        logger.info((Object)("getGroupMap:" + (System.currentTimeMillis() - startTime) + "ms"));
        return combTransferMap;
    }

    public StringBuilder getInfoKey(IObjectValue bill, List<String> fields) throws BOSException {
        StringBuilder key = new StringBuilder(100);
        List<String> descArray = this.getInfoKeyDescArray(bill, fields);
        for (String desc : descArray) {
            key.append(desc).append(SPLIT_SIGN);
        }
        return new StringBuilder(String.join((CharSequence)SPLIT_SIGN, descArray));
    }

    public List<String> getInfoKeyDescArray(IObjectValue bill, List<String> fileds) throws BOSException {
        ArrayList<String> descArray = new ArrayList<String>();
        StringBuilder key = new StringBuilder(100);
        for (String field : fileds) {
            Object obj = bill.get(field);
            if (null == obj) {
                descArray.add("null");
                continue;
            }
            if (obj instanceof CoreBaseInfo) {
                CoreBaseInfo info = (CoreBaseInfo)obj;
                descArray.add(String.valueOf(info.get("id")));
                continue;
            }
            descArray.add(obj.toString());
        }
        return descArray;
    }

    public List<String> convertDesc(Context ctx, List<String> keyDesc, String propertyName) throws BOSException {
        ArrayList<String> desc = new ArrayList<String>();
        IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        for (String key : keyDesc) {
            if (BOSUuid.isValid((String)key, (boolean)true)) {
                BOSUuid uuid = BOSUuid.read((String)key);
                IObjectValue value = dynamicObject.getValue(uuid.getType(), (IObjectPK)new ObjectUuidPK(uuid));
                desc.add(value.getString(propertyName));
                continue;
            }
            desc.add(key);
        }
        return desc;
    }

    public CoreBillBaseCollection getBillColl(Context ctx, List idList, List combinFieldsList) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        ev.setFilter(filter);
        SelectorItemCollection sic = this.iCombTransfer.getSelect();
        if (sic == null) {
            sic = new SelectorItemCollection();
        }
        if (combinFieldsList != null) {
            for (int i = 0; i < combinFieldsList.size(); ++i) {
                sic.add(combinFieldsList.get(i).toString());
            }
        }
        ev.setSelector(sic);
        IDynamicObject IdynObj = DynamicObjectFactory.getLocalInstance((Context)ctx);
        BOSObjectType billType = BOSObjectType.create((String)this.bosType);
        IObjectCollection coll = IdynObj.getCollection(billType, ev);
        CoreBillBaseCollection billColl = new CoreBillBaseCollection();
        billColl.addObjectCollection(coll);
        return billColl;
    }

    public void addSQLLock(Context ctx, List<String> idList) throws BOSException, EASBizException {
        String tableName = this.getBillTable(ctx, idList.get(0));
        StringBuilder lockSQL = new StringBuilder(50);
        lockSQL.append(" UPDATE ").append(tableName).append(" SET FID = FID  WHERE FID in ").append(ListUtil.transList2String(new HashSet<String>(idList)));
        DBUtil.execute((Context)ctx, (String)lockSQL.toString());
    }

    public String getBillTable(Context ctx, String id) throws BOSException {
        if (!StringUtils.isEmpty((String)id)) {
            BOSObjectType bosType = BOSUuid.read((String)id).getType();
            IFMIsqlFacade iFMIsqlFacade = null;
            iFMIsqlFacade = FMIsqlFacadeFactory.getLocalInstance((Context)ctx);
            String tableName = iFMIsqlFacade.getTableNameByBosType(bosType);
            return tableName;
        }
        return null;
    }

    public String getResourceStr(Context ctx, String key) {
        return ResourceBase.getString((String)RESOURCE_NAME, (String)key, (Locale)ctx.getLocale());
    }

    public String getResourceStr(Context ctx, String key, Object[] param) {
        return ResourceBase.getString((String)RESOURCE_NAME, (String)key, (Locale)ctx.getLocale(), (Object[])param);
    }
}

