/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.PropertyUnitDele;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.QueryDeleUtil;
import com.kingdee.bos.metadata.query.util.QuerySqlAccess;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.VerificationEnum;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillPlanBaseInfo;
import com.kingdee.eas.fi.ar.IArApBillBase;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillPlanCollection;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.arap.ArApCommonParams;
import com.kingdee.eas.fi.arap.app.AbstractArApVerifyCommonFacadeControllerBean;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryFactory;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonInfo;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ArApVerifyCommonFacadeControllerBean
extends AbstractArApVerifyCommonFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.ArApVerifyCommonFacadeControllerBean");

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        boolean isArAp;
        int queryType = params.getInt("WRITEOFF_QUERY_TYPE");
        SorterItemCollection orderColl = null;
        if (queryType == 2) {
            orderColl = (SorterItemCollection)params.getObject("upOrder");
        } else if (queryType == 3) {
            orderColl = (SorterItemCollection)params.getObject("downOrder");
        }
        String bosType = params.getString("BOSType");
        boolean bl = isArAp = "FC910EF3;48DA3A71".indexOf(bosType) != -1;
        if (orderColl == null) {
            orderColl = new SorterItemCollection();
        }
        if (orderColl.size() == 0) {
            orderColl.add(new SorterItemInfo(isArAp ? "billDate" : "bizDate"));
            if (queryType == 2) {
                params.setObject("upOrder", (Object)orderColl);
            } else if (queryType == 3) {
                params.setObject("downOrder", (Object)orderColl);
            }
        }
        return super._query(ctx, params, from, len);
    }

    protected String getExecutorSql(String sql, RptParams params) {
        boolean isHeadView = params.getBoolean("isHeadView");
        Pattern pattern = Pattern.compile("FROM[^\"]+\"[^\"]+\"");
        Matcher matcher = pattern.matcher(sql);
        if (isHeadView && matcher.find()) {
            String entryFieldName;
            String bosType = params.getString("BOSType");
            boolean isArAp = "FC910EF3;48DA3A71".indexOf(bosType) != -1;
            String tableName = matcher.group().substring(matcher.group().indexOf("\""));
            String selectSql = sql.substring(0, sql.indexOf("FROM"));
            selectSql = selectSql + ", TEMP.THISVERIFICATEAMT, TEMP.THISVERIFICATEAMTLOC ";
            String joinSql = sql.substring(sql.indexOf("FROM"), sql.indexOf("WHERE"));
            Pattern join = Pattern.compile("(LEFT|INNER|RIGHT).+JOIN[^\"]+\"[^\"]+\"", 2);
            Pattern on = Pattern.compile("ON\\s\"[^\"]+\"\\..+[^(LEFT|INNER|RIGHT|WHERE)]", 2);
            Matcher joinMatcher = join.matcher(joinSql);
            Matcher onMatcher = on.matcher(joinSql);
            ArrayList<String> joinList = new ArrayList<String>();
            while (joinMatcher.find()) {
                joinList.add(joinMatcher.group());
            }
            ArrayList<String> onList = new ArrayList<String>();
            while (onMatcher.find()) {
                onList.add(onMatcher.group());
            }
            StringBuffer sb = new StringBuffer(1024);
            String entryTable = null;
            String entryJoin = null;
            boolean isBillDate = params.getBoolean("isBillDate");
            String string = entryFieldName = isArAp ? "ENTRY" : "ENTRIES";
            if (!isBillDate && isArAp) {
                String entryIdField = (String)params.getObject("EntryIdField");
                entryFieldName = entryIdField.substring(0, entryIdField.indexOf(".")).toUpperCase();
            }
            if (joinList.size() == onList.size()) {
                int i;
                int size = joinList.size();
                for (i = 0; i < size; ++i) {
                    if (((String)joinList.get(i)).indexOf(entryFieldName.toUpperCase()) == -1) continue;
                    entryTable = (String)joinList.get(i);
                    entryJoin = (String)onList.get(i);
                    joinList.remove(i);
                    onList.remove(i);
                    break;
                }
                sb.append(matcher.group()).append("\n");
                sb.append(entryTable).append("\n");
                sb.append(entryJoin);
                size = joinList.size();
                for (i = 0; i < size; ++i) {
                    sb.append((String)joinList.get(i)).append("\n").append((String)onList.get(i));
                }
                joinSql = sb.toString();
            }
            String whereSql = sql.substring(sql.indexOf("WHERE"), sql.indexOf("ORDER BY"));
            String orderSql = sql.substring(sql.indexOf("ORDER BY"));
            sb.setLength(0);
            sb.append(" INNER JOIN (SELECT MIN(");
            sb.append(entryFieldName + ".FSeq");
            sb.append(") AS FSEQ,");
            sb.append(" SUM(");
            if (isBillDate) {
                sb.append(isArAp ? "\"ENTRY\".FLockUnVerifyAmt" : "\"ENTRIES\".FUnLockAmt");
            } else {
                sb.append("\"").append(entryFieldName).append(isArAp ? "\".FUNLockAmount" : "\".FUnLockAmt");
            }
            sb.append(") AS THISVERIFICATEAMT,");
            sb.append(" SUM(");
            if (isBillDate) {
                sb.append(isArAp ? "\"ENTRY\".FLockUnVerifyAmtLocal" : "\"ENTRIES\".FUnLockLocAmt");
            } else {
                sb.append("\"").append(entryFieldName).append(isArAp ? "\".FUNLockAmountLoc" : "\".FUnLockLocAmt");
            }
            sb.append(") AS THISVERIFICATEAMTLOC,");
            sb.append(" ").append(tableName).append(".FID");
            sb.append(" \n").append(joinSql).append(whereSql);
            sb.append(" GROUP BY ").append(tableName).append(".FID)");
            sb.append(" TEMP ON ").append(tableName);
            sb.append(".FID = TEMP.FID AND ");
            if (isBillDate) {
                sb.append(isArAp ? "\"ENTRY\".FSeq" : "\"ENTRIES\".FSeq").append(" = TEMP.FSEQ");
            } else {
                sb.append("\"").append(entryFieldName).append("\".FSeq").append(" = TEMP.FSEQ");
            }
            if (joinList.size() == onList.size()) {
                String tempSql = sb.toString();
                sb.setLength(0);
                sb.append(matcher.group()).append("\n");
                sb.append(entryTable).append("\n");
                sb.append(entryJoin);
                sb.append(tempSql).append("\n");
                int size = joinList.size();
                for (int i = 0; i < size; ++i) {
                    sb.append((String)joinList.get(i)).append("\n").append((String)onList.get(i));
                }
                joinSql = sb.toString();
            }
            whereSql = isBillDate ? whereSql.replaceAll(isArAp ? "\"ENTRY\"\\.FLockUnVerifyAmt" : "\"ENTRIES\"\\.FUnLockAmt", "TEMP.THISVERIFICATEAMT") : whereSql.replaceAll(entryFieldName + ".FUNLockAmount", "TEMP.THISVERIFICATEAMT");
            sql = selectSql + " \n" + joinSql + "\r\n " + whereSql + " " + orderSql;
        }
        return sql;
    }

    protected List _writeOff(Context ctx, WriteOffCommonParams params) throws BOSException, EASBizException {
        StringBuilder msgBuilder;
        boolean isHeadView = params.get((Object)"isHeadView") instanceof Boolean && (Boolean)params.get((Object)"isHeadView") != false;
        ArrayList<String> result = new ArrayList<String>();
        List list = null;
        if (params.get((Object)"isBillDate") != null && !((Boolean)params.get((Object)"isBillDate")).booleanValue() && (VerificationEnum.AP_AR.equals((Object)((VerificationEnum)params.get((Object)"veriType"))) || VerificationEnum.AP_Pay.equals((Object)((VerificationEnum)params.get((Object)"veriType"))) || VerificationEnum.AR_AP.equals((Object)((VerificationEnum)params.get((Object)"veriType"))) || VerificationEnum.AR_Rec.equals((Object)((VerificationEnum)params.get((Object)"veriType"))))) {
            this.changePlanToEntry(ctx, params, true);
        }
        if (isHeadView) {
            params.put((Object)"isBillInnerVerify", (Object)Boolean.TRUE);
            list = super._writeOff(ctx, params);
            if (list != null) {
                result.addAll(list);
            }
        }
        params.put((Object)"isBillInnerVerify", (Object)Boolean.FALSE);
        if (VerificationEnum.Rec_Pay.equals((Object)((VerificationEnum)params.get((Object)"veriType")))) {
            this.explainParam(ctx, params, true);
        } else if (VerificationEnum.Pay_Rec.equals((Object)((VerificationEnum)params.get((Object)"veriType")))) {
            this.explainParam(ctx, params, false);
        }
        list = VerificationEnum.AP_Pay.equals((Object)((VerificationEnum)params.get((Object)"veriType"))) || VerificationEnum.AR_Rec.equals((Object)((VerificationEnum)params.get((Object)"veriType"))) ? this.splitWriteOff(ctx, params) : super._writeOff(ctx, params);
        if (list != null) {
            result.addAll(list);
        }
        if (params.get((Object)"upQueryFilterCopy") != null && params.get((Object)"downQueryFilterCopy") != null) {
            params.put((Object)"upQueryFilter", params.get((Object)"upQueryFilterCopy"));
            params.put((Object)"downQueryFilter", params.get((Object)"downQueryFilterCopy"));
            list = super._writeOff(ctx, params);
            if (list != null) {
                result.addAll(list);
            }
        }
        if (result.size() == 0 && params.get((Object)"msgBuilder") != null && (msgBuilder = (StringBuilder)params.get((Object)"msgBuilder")).length() > 0) {
            result.add(msgBuilder.toString());
        }
        return result;
    }

    protected List splitWriteOff(Context ctx, WriteOffCommonParams params) throws EASBizException, BOSException {
        FilterInfo secAsstFilter;
        FilterInfo mainAsstFilter;
        ArrayList result = new ArrayList();
        Integer limit = 0;
        String mainKeyField = "";
        String secKeyField = "";
        Boolean isAr = (Boolean)params.get((Object)"isAR");
        StringBuffer getParamSql = new StringBuffer("select fnumber,fvalue from t_arap_commonparam where fnumber in(");
        getParamSql.append("'" + ArApCommonParams.VERIFY_COUNT_LIMIT + "',");
        if (isAr.booleanValue()) {
            getParamSql.append("'" + ArApCommonParams.AR_VERIFY_MAIN_FIELD + "',");
            getParamSql.append("'" + ArApCommonParams.AR_VERIFY_SEC_FIELD + "')");
        } else {
            getParamSql.append("'" + ArApCommonParams.AP_VERIFY_MAIN_FIELD + "',");
            getParamSql.append("'" + ArApCommonParams.AP_VERIFY_SEC_FIELD + "')");
        }
        IRowSet paramRs = DbUtil.executeQuery((Context)ctx, (String)getParamSql.toString());
        try {
            while (paramRs.next()) {
                if (ArApCommonParams.VERIFY_COUNT_LIMIT.equals(paramRs.getString(1))) {
                    limit = Integer.parseInt(paramRs.getString(2));
                    continue;
                }
                if (ArApCommonParams.AR_VERIFY_MAIN_FIELD.equals(paramRs.getString(1)) || ArApCommonParams.AP_VERIFY_MAIN_FIELD.equals(paramRs.getString(1))) {
                    mainKeyField = paramRs.getString(2);
                    continue;
                }
                if (!ArApCommonParams.AR_VERIFY_SEC_FIELD.equals(paramRs.getString(1)) && !ArApCommonParams.AP_VERIFY_SEC_FIELD.equals(paramRs.getString(1))) continue;
                secKeyField = paramRs.getString(2);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (StringUtils.isEmpty((String)mainKeyField) || StringUtils.isEmpty((String)secKeyField)) {
            return super._writeOff(ctx, params);
        }
        FilterInfo mainFilter = (FilterInfo)((FilterInfo)params.get((Object)"upQueryFilter")).clone();
        FilterInfo secFilter = (FilterInfo)((FilterInfo)params.get((Object)"downQueryFilter")).clone();
        HashMap<String, Integer> mainMap = new HashMap<String, Integer>();
        HashMap<String, Integer> secMap = new HashMap<String, Integer>();
        IRowSet mainRs = this.getBillNumGroupByField(ctx, mainKeyField, params.getMainQueryName(), mainFilter);
        IRowSet secRs = this.getBillNumGroupByField(ctx, secKeyField, params.getSecQueryName(), secFilter);
        try {
            BigDecimal count;
            while (mainRs.next()) {
                count = mainRs.getBigDecimal(2);
                mainMap.put(mainRs.getString(1), count.intValue());
            }
            while (secRs.next()) {
                count = secRs.getBigDecimal(2);
                secMap.put(secRs.getString(1), count.intValue());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashSet asstSet = new HashSet();
        Integer mainCount = 0;
        Integer secCount = 0;
        for (Object key : mainMap.keySet()) {
            if (secMap.get(key) == null) continue;
            secCount = secCount + (Integer)secMap.get(key);
            if ((mainCount = Integer.valueOf(mainCount + (Integer)mainMap.get(key))) > limit || secCount > limit) {
                if (asstSet.size() == 0) {
                    asstSet.add(key);
                    mainCount = 0;
                    secCount = 0;
                }
                mainAsstFilter = new FilterInfo();
                secAsstFilter = new FilterInfo();
                FilterItemInfo mainFilterItem = new FilterItemInfo(mainKeyField, asstSet, CompareType.INCLUDE);
                FilterItemInfo secFilterItem = new FilterItemInfo(secKeyField, asstSet, CompareType.INCLUDE);
                mainAsstFilter.getFilterItems().add(mainFilterItem);
                secAsstFilter.getFilterItems().add(secFilterItem);
                ((FilterInfo)params.get((Object)"upQueryFilter")).mergeFilter(mainAsstFilter, "and");
                ((FilterInfo)params.get((Object)"downQueryFilter")).mergeFilter(secAsstFilter, "and");
                result.addAll(super._writeOff(ctx, params));
                params.put((Object)"upQueryFilter", (Object)mainFilter);
                params.put((Object)"downQueryFilter", (Object)secFilter);
                asstSet.clear();
                if (mainCount == 0) continue;
                asstSet.add(key);
                mainCount = (Integer)mainMap.get(key);
                secCount = (Integer)secMap.get(key);
                continue;
            }
            asstSet.add(key);
        }
        if (asstSet.size() > 0) {
            mainAsstFilter = new FilterInfo();
            secAsstFilter = new FilterInfo();
            mainAsstFilter.getFilterItems().add(new FilterItemInfo(mainKeyField, asstSet, CompareType.INCLUDE));
            secAsstFilter.getFilterItems().add(new FilterItemInfo(secKeyField, asstSet, CompareType.INCLUDE));
            mainFilter.mergeFilter(mainAsstFilter, "and");
            secFilter.mergeFilter(secAsstFilter, "and");
            result.addAll(super._writeOff(ctx, params));
        }
        return result;
    }

    protected IRowSet getBillNumGroupByField(Context ctx, String keyField, String queryName, FilterInfo filterInfo) throws EASBizException, BOSException {
        IRowSet rs = null;
        MetaDataPK queryPK = MetaDataPK.create((String)queryName);
        EntityViewInfo entityView = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(keyField);
        if (filterInfo != null) {
            entityView.setFilter(filterInfo);
        }
        entityView.setSelector(sic);
        QueryInfo query = MetaDataLoader.getQuery((Context)ctx, (IMetaDataPK)queryPK);
        QuerySqlAccess qsa = new QuerySqlAccess(ctx, query);
        ArrayList selectFields = qsa.select.getSelector();
        String keyFieldSql = "";
        for (int i = 0; i < selectFields.size(); ++i) {
            PropertyUnitDele field = (PropertyUnitDele)selectFields.get(i);
            if (!keyField.equalsIgnoreCase(field.getName())) continue;
            keyFieldSql = QueryDeleUtil.getUnitString((PropertyUnitDele)field).replaceAll("&", "||");
            break;
        }
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.option().isIgnorePermissionCheck = true;
        exec.setObjectView(entityView);
        String sql = exec.getSQL();
        StringBuffer execSql = new StringBuffer(sql.substring(0, sql.indexOf("ORDER")));
        execSql.insert(execSql.indexOf("FROM"), ", count(" + keyFieldSql + ") fcount ");
        execSql.append(" group by  " + keyFieldSql + "");
        execSql.append(" order by  fcount desc");
        rs = DbUtil.executeQuery((Context)ctx, (String)execSql.toString());
        return rs;
    }

    protected List _manualWriteOff(Context ctx, WriteOffCommonParams params) throws BOSException, EASBizException {
        StringBuilder msgBuilder;
        boolean isHeadView = params.get((Object)"isHeadView") instanceof Boolean && (Boolean)params.get((Object)"isHeadView") != false;
        ArrayList<String> result = new ArrayList<String>();
        List list = null;
        if (isHeadView) {
            params.put((Object)"isBillInnerVerify", (Object)Boolean.TRUE);
            list = super._manualWriteOff(ctx, params);
            if (list != null) {
                result.addAll(list);
            }
        }
        if (params.get((Object)"isBillDate") != null && !((Boolean)params.get((Object)"isBillDate")).booleanValue() && (VerificationEnum.AP_AR.equals((Object)((VerificationEnum)params.get((Object)"veriType"))) || VerificationEnum.AP_Pay.equals((Object)((VerificationEnum)params.get((Object)"veriType"))) || VerificationEnum.AR_AP.equals((Object)((VerificationEnum)params.get((Object)"veriType"))) || VerificationEnum.AR_Rec.equals((Object)((VerificationEnum)params.get((Object)"veriType"))))) {
            this.changePlanToEntry(ctx, params, false);
        }
        params.put((Object)"isBillInnerVerify", (Object)Boolean.FALSE);
        if (VerificationEnum.Rec_Pay.equals((Object)((VerificationEnum)params.get((Object)"veriType")))) {
            this.explainParam(ctx, params, true);
        } else if (VerificationEnum.Pay_Rec.equals((Object)((VerificationEnum)params.get((Object)"veriType")))) {
            this.explainParam(ctx, params, false);
        }
        List mainList = params.getMainList();
        List secList = params.getSecList();
        if ((mainList != null && mainList.size() > 0 || secList != null && secList.size() > 0) && (params.get((Object)"msgBuilder") == null || "".equals(params.get((Object)"msgBuilder").toString()))) {
            list = super._manualWriteOff(ctx, params);
        }
        if (list != null) {
            result.addAll(list);
            list = null;
        }
        if (params.get((Object)"upQueryFilterCopy") != null && params.get((Object)"downQueryFilterCopy") != null) {
            params.put((Object)"upQueryFilter", params.get((Object)"upQueryFilterCopy"));
            params.put((Object)"downQueryFilter", params.get((Object)"downQueryFilterCopy"));
            List mainListCopy = (List)params.get((Object)"mainListCopy");
            List secListCopy = (List)params.get((Object)"secListCopy");
            if (mainListCopy.size() > 0 || secListCopy.size() > 0) {
                if (mainListCopy.size() > 1 && secListCopy.size() == 0 && "vNlEHhHWRUaOyJQoEp2WWZVAboA=".equals(params.get((Object)"KEY_MAPPINGENTRYID"))) {
                    params.setSameSideFirst(true);
                }
                params.setMainList(mainListCopy);
                params.setSecList(secListCopy);
                list = super._manualWriteOff(ctx, params);
            }
            if (list != null) {
                result.addAll(list);
            }
        }
        if (result.size() == 0 && params.get((Object)"msgBuilder") != null && (msgBuilder = (StringBuilder)params.get((Object)"msgBuilder")).length() > 0) {
            result.add(msgBuilder.toString());
        }
        return result;
    }

    protected FilterInfo getFilter(FilterInfo filter, List list, String entryIdField, boolean isHeadView) throws BOSException {
        if ("payPlan.id".equals(entryIdField) || "recievePlan.id".equals(entryIdField)) {
            return filter;
        }
        return super.getFilter(filter, list, entryIdField, isHeadView);
    }

    private String changePlanToEntry(Context ctx, WriteOffCommonParams params, boolean isAutoWriteOff) throws BOSException, EASBizException {
        String retMsg = "";
        FilterInfo upFilter = (FilterInfo)params.get((Object)"upQueryFilter");
        FilterInfo downFilter = (FilterInfo)params.get((Object)"downQueryFilter");
        VerificationEnum veriType = (VerificationEnum)params.get((Object)"veriType");
        String[] veriTypeArr = veriType.getName().split("_");
        ArrayList<WriteOffCommonInfo> mainList = new ArrayList<WriteOffCommonInfo>();
        Set<String> mainSet = null;
        if (("AP".equalsIgnoreCase(veriTypeArr[0]) || "AR".equalsIgnoreCase(veriTypeArr[0])) && (isAutoWriteOff || params.getMainList().size() > 0)) {
            mainSet = this.changePlanToEntry(ctx, mainList, upFilter, "AR".equalsIgnoreCase(veriTypeArr[0]), params, isAutoWriteOff, true);
            params.setMainList(mainList);
        }
        ArrayList<WriteOffCommonInfo> secList = new ArrayList<WriteOffCommonInfo>();
        Set<String> secSet = null;
        if (("AP".equalsIgnoreCase(veriTypeArr[1]) || "AR".equalsIgnoreCase(veriTypeArr[1])) && (isAutoWriteOff || params.getSecList().size() > 0)) {
            secSet = this.changePlanToEntry(ctx, secList, downFilter, "AR".equalsIgnoreCase(veriTypeArr[1]), params, isAutoWriteOff, false);
            params.setSecList(secList);
        }
        FilterInfo mainFilter = new FilterInfo();
        if (mainSet != null && mainSet.size() > 0) {
            mainFilter.getFilterItems().add(new FilterItemInfo("entry.id", mainSet, CompareType.INCLUDE));
        } else if ("AP".equalsIgnoreCase(veriTypeArr[0]) || "AR".equalsIgnoreCase(veriTypeArr[0])) {
            mainFilter.getFilterItems().add(new FilterItemInfo("entry.id", (Object)CompareType.IS));
        }
        if (mainFilter.getFilterItems().size() > 0) {
            params.put((Object)"upQueryFilter", (Object)mainFilter);
            params.setMainEntryIdField("entry.id");
        }
        FilterInfo secFilter = new FilterInfo();
        if (secSet != null && secSet.size() > 0) {
            secFilter.getFilterItems().add(new FilterItemInfo("entry.id", secSet, CompareType.INCLUDE));
        } else if ("AP".equalsIgnoreCase(veriTypeArr[1]) || "AR".equalsIgnoreCase(veriTypeArr[1])) {
            secFilter.getFilterItems().add(new FilterItemInfo("entry.id", (Object)CompareType.IS));
        }
        if (secFilter.getFilterItems().size() > 0) {
            params.put((Object)"downQueryFilter", (Object)secFilter);
            params.setSecEntryIdField("entry.id");
        }
        return retMsg;
    }

    private Set<String> changePlanToEntry(Context ctx, List<WriteOffCommonInfo> mainList, FilterInfo filterInfo, boolean isAR, WriteOffCommonParams params, boolean isAutoWriteOff, boolean isMain) throws BOSException, EASBizException {
        List tempList;
        IArApBillBase iOtherBill;
        HashSet<String> entryIDSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        if (!isAutoWriteOff) {
            String planIDField = isAR ? "recievePlan.id" : "payPlan.id";
            FilterInfo manualFilterInfo = this.buildManualFilterInfo(params, planIDField, isMain);
            view.setFilter(manualFilterInfo);
        }
        String queryPK = isAR ? "com.kingdee.eas.fi.ar.app.OtherBillPlanQuery" : "com.kingdee.eas.fi.ap.app.OtherBillPlanQuery";
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)queryPK));
        exec.setObjectView(view);
        IRowSet rs = exec.executeQuery();
        HashSet<String> planIDSet = new HashSet<String>();
        HashSet<String> idSet = new HashSet<String>();
        try {
            while (rs.next()) {
                String payPlanID = isAR ? rs.getString("recievePlan.id") : rs.getString("payPlan.id");
                String billID = rs.getString("id");
                planIDSet.add(payPlanID);
                idSet.add(billID);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        FilterInfo filter = new FilterInfo();
        String planStr = isAR ? "recievePlan.unLockAmount" : "payPlan.unLockAmount";
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view = this.buildEntityViewInfo(filter, isAR);
        AbstractObjectCollection otherCol = null;
        if (!isAR) {
            iOtherBill = com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx);
            otherCol = iOtherBill.getOtherBillCollection(view);
            this.removeUnSelect(ctx, isAR, planIDSet, otherCol, "payPlan", params);
        } else {
            iOtherBill = OtherBillFactory.getLocalInstance(ctx);
            otherCol = iOtherBill.getOtherBillCollection(view);
            this.removeUnSelect(ctx, isAR, planIDSet, otherCol, "recievePlan", params);
        }
        HashMap<String, BigDecimal> planIdToAmount = new HashMap<String, BigDecimal>();
        List list = tempList = isMain ? params.getMainList() : params.getSecList();
        if (tempList != null) {
            for (int i = 0; i < tempList.size(); ++i) {
                WriteOffCommonInfo writeOffCommonInfo = (WriteOffCommonInfo)tempList.get(i);
                planIdToAmount.put(writeOffCommonInfo.getEntryId(), writeOffCommonInfo.getAmount());
            }
        }
        this.allocateLockEntry(ctx, otherCol, mainList, entryIDSet, isAutoWriteOff, planIdToAmount);
        return entryIDSet;
    }

    private void allocateLockEntry(Context ctx, AbstractObjectCollection otherCol, List<WriteOffCommonInfo> mainList, Set<String> entryIDSet, boolean isAutoWriteOff, Map<String, BigDecimal> planIdToAmount) throws BOSException, EASBizException {
        BigDecimal unLockAmt = BigDecimal.ZERO;
        HashMap<String, BigDecimal> unLockMap = new HashMap<String, BigDecimal>();
        ArApBillBaseInfo headInfo = null;
        ArApBillPlanBaseInfo planInfo = null;
        AbstractObjectCollection planCol = null;
        int size = otherCol.size();
        for (int i = 0; i < size; ++i) {
            headInfo = (ArApBillBaseInfo)otherCol.getObject(i);
            String headID = headInfo.getId().toString();
            planCol = headInfo instanceof OtherBillInfo ? (com.kingdee.eas.fi.ap.OtherBillPlanCollection)((Object)headInfo.get("payPlan")) : (OtherBillPlanCollection)((Object)headInfo.get("recievePlan"));
            unLockAmt = unLockMap.containsKey(headID) ? (BigDecimal)unLockMap.get(headID) : BigDecimal.ZERO;
            for (int j = 0; j < planCol.size(); ++j) {
                planInfo = (ArApBillPlanBaseInfo)planCol.getObject(j);
                if (!isAutoWriteOff) {
                    if (planIdToAmount.get(planInfo.getId().toString()) == null) continue;
                    unLockAmt = unLockAmt.add(planIdToAmount.get(planInfo.getId().toString()));
                    continue;
                }
                unLockAmt = unLockAmt.add(planInfo.getUnLockAmount());
            }
            unLockMap.put(headID, unLockAmt);
        }
        WriteOffCommonInfo commonInfo = null;
        String headID = null;
        String entryID = null;
        int size2 = otherCol.size();
        block2: for (int i = 0; i < size2; ++i) {
            headInfo = (ArApBillBaseInfo)otherCol.getObject(i);
            headID = headInfo.getId().toString();
            AbstractObjectCollection entryCol = (AbstractObjectCollection)headInfo.get("entry");
            BigDecimal headUnLockAmt = (BigDecimal)unLockMap.get(headID);
            int precision = headInfo.getCompany().getBaseCurrency().getPrecision();
            if (precision == 0) {
                precision = 2;
            }
            ExchangeRateInfo rateInfo = BaseDataUtil.getExchangeRate(ctx, headInfo.getCompany(), headInfo.getCurrency(), new Date());
            BigDecimal converRate = new BigDecimal("1.0");
            boolean isDirectExchangeRate = true;
            if (rateInfo != null && headInfo.getExchangeRate() != null) {
                converRate = headInfo.getExchangeRate().setScale(rateInfo.getPrecision(), 4);
                isDirectExchangeRate = BaseDataUtil.isDirectExchangeRate(rateInfo);
            }
            boolean isPositive = headUnLockAmt.compareTo(BigDecimal.ZERO) > 0;
            for (int j = 0; j < entryCol.size(); ++j) {
                ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)entryCol.getObject(j);
                entryID = entryInfo.getId().toString();
                commonInfo = new WriteOffCommonInfo();
                if (entryInfo.getLockUnVerifyAmt().compareTo(BigDecimal.ZERO) == 0) continue;
                mainList.add(commonInfo);
                entryIDSet.add(entryID);
                commonInfo.setBillId(headID);
                commonInfo.setEntryId(entryID);
                commonInfo.setBillNumber(headInfo.getNumber());
                commonInfo.setQty(entryInfo.getQuantity());
                commonInfo.setBaseQty(entryInfo.getBaseQty());
                commonInfo.setLastUpdateTime((Date)headInfo.getLastUpdateTime());
                if (isPositive ? headUnLockAmt.compareTo(entryInfo.getLockUnVerifyAmt()) > 0 : headUnLockAmt.compareTo(entryInfo.getLockUnVerifyAmt()) < 0) {
                    commonInfo.setAmount(entryInfo.getLockUnVerifyAmt());
                    commonInfo.setLocalAmount(entryInfo.getLockUnVerifyAmtLocal());
                    headUnLockAmt = headUnLockAmt.subtract(entryInfo.getLockUnVerifyAmt());
                    continue;
                }
                commonInfo.setAmount(headUnLockAmt);
                BigDecimal localAmount = BaseDataUtil.caculateLocalAmount(headUnLockAmt, converRate, isDirectExchangeRate, precision);
                commonInfo.setLocalAmount(localAmount);
                headUnLockAmt = BigDecimal.ZERO;
                continue block2;
            }
        }
    }

    private EntityViewInfo buildEntityViewInfo(FilterInfo filter, boolean isAR) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("*"));
        selectorCol.add(new SelectorItemInfo("entry.*"));
        selectorCol.add(new SelectorItemInfo("company.baseExchangeTable.id"));
        selectorCol.add(new SelectorItemInfo("company.baseCurrency.id"));
        selectorCol.add(new SelectorItemInfo("company.baseCurrency.precision"));
        if (isAR) {
            selectorCol.add(new SelectorItemInfo("recievePlan.*"));
        } else {
            selectorCol.add(new SelectorItemInfo("payPlan.*"));
        }
        viewInfo.setSelector(selectorCol);
        SorterItemCollection sorterCol = new SorterItemCollection();
        SorterItemInfo sorter = new SorterItemInfo("billDate");
        sorter.setSortType(SortType.ASCEND);
        sorterCol.add(sorter);
        sorter = new SorterItemInfo("number");
        sorter.setSortType(SortType.ASCEND);
        sorterCol.add(sorter);
        sorter = new SorterItemInfo("ENTRY.SEQ");
        sorter.setSortType(SortType.ASCEND);
        sorterCol.add(sorter);
        viewInfo.setSorter(sorterCol);
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private void removeUnSelect(Context ctx, boolean isAR, Set entriesKey, AbstractObjectCollection otherCol, String entryName, WriteOffCommonParams params) {
        StringBuilder msgBuilder = (StringBuilder)params.get((Object)"msgBuilder");
        if (msgBuilder == null) {
            msgBuilder = new StringBuilder();
            params.put((Object)"msgBuilder", (Object)msgBuilder);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyy-MM-dd");
        block0: for (int i = otherCol.size() - 1; i >= 0; --i) {
            IObjectValue bill = otherCol.getObject(i);
            IObjectCollection entries = (IObjectCollection)bill.get(entryName);
            if (entries == null) {
                return;
            }
            boolean flag = false;
            entries.sort("recievePayDate");
            for (int j = entries.size() - 1; j >= 0; --j) {
                ArApBillPlanBaseInfo planInfo = (ArApBillPlanBaseInfo)entries.getObject(j);
                if (!entriesKey.contains(planInfo.getId().toString()) && planInfo.getUnLockAmount().compareTo(BigDecimal.ZERO) != 0) {
                    if (flag) {
                        String arapMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)(isAR ? "AR" : "AP"), (Locale)ctx.getLocale());
                        String msg = arapMsg + ResourceBase.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"VerifyPlanMustSelectFirst", (Locale)ctx.getLocale(), (Object[])new Object[]{bill.get("number"), arapMsg, sdf.format(planInfo.getRecievePayDate())});
                        msgBuilder.append(msg).append("\n");
                        otherCol.removeObject(i);
                        continue block0;
                    }
                    entries.removeObject(j);
                    continue;
                }
                flag = true;
            }
        }
    }

    private FilterInfo buildManualFilterInfo(WriteOffCommonParams params, String planIDField, boolean isMain) {
        List tempList = isMain ? params.getMainList() : params.getSecList();
        FilterInfo manualFilterInfo = new FilterInfo();
        HashSet<String> planIDSet = new HashSet<String>();
        int size = tempList.size();
        for (int i = 0; i < size; ++i) {
            WriteOffCommonInfo commonInfo = (WriteOffCommonInfo)tempList.get(i);
            planIDSet.add(commonInfo.getEntryId());
        }
        manualFilterInfo.getFilterItems().add(new FilterItemInfo(planIDField, planIDSet, CompareType.INCLUDE));
        return manualFilterInfo;
    }

    private void explainParam(Context ctx, WriteOffCommonParams params, boolean isAR) throws BOSException, EASBizException {
        int j;
        String mask;
        FilterItemInfo itemInfo;
        int i;
        int size;
        FilterInfo upQueryFilter = null;
        FilterInfo downQueryFilter = null;
        if (isAR) {
            upQueryFilter = (FilterInfo)params.get((Object)"upQueryFilter");
            downQueryFilter = (FilterInfo)params.get((Object)"downQueryFilter");
        } else {
            downQueryFilter = (FilterInfo)params.get((Object)"upQueryFilter");
            upQueryFilter = (FilterInfo)params.get((Object)"downQueryFilter");
        }
        FilterInfo upQueryFilterCopy = (FilterInfo)upQueryFilter.clone();
        FilterInfo downQueryFilterCopy = (FilterInfo)downQueryFilter.clone();
        if (upQueryFilter != null && upQueryFilter.getFilterItems() != null && upQueryFilter.getFilterItems().size() > 0) {
            size = upQueryFilter.getFilterItems().size();
            for (i = 0; i < upQueryFilter.getFilterItems().size(); ++i) {
                itemInfo = upQueryFilter.getFilterItems().get(i);
                if (!"entryRecBillType.isProxyRec".equals(itemInfo.getPropertyName())) continue;
                upQueryFilter.getFilterItems().remove(itemInfo);
                mask = upQueryFilter.getMaskString().replaceAll("#" + i + "\\sor", " ");
                for (j = i; j < size - 1; ++j) {
                    mask = mask.replaceAll("#" + (j + 1), "#" + j);
                }
                upQueryFilter.setMaskString(mask);
            }
            for (i = 0; i < upQueryFilterCopy.getFilterItems().size(); ++i) {
                itemInfo = upQueryFilterCopy.getFilterItems().get(i);
                if (!"entryRecBillType.isSaleRec".equals(itemInfo.getPropertyName())) continue;
                upQueryFilterCopy.getFilterItems().remove(itemInfo);
                mask = upQueryFilterCopy.getMaskString().replaceAll("or\\s#" + i, " ");
                for (j = i; j < size - 1; ++j) {
                    mask = mask.replaceAll("#" + (j + 1), "#" + j);
                }
                upQueryFilterCopy.setMaskString(mask);
            }
        }
        if (downQueryFilter != null && downQueryFilter.getFilterItems() != null && downQueryFilter.getFilterItems().size() > 0) {
            size = downQueryFilter.getFilterItems().size();
            for (i = 0; i < downQueryFilter.getFilterItems().size(); ++i) {
                itemInfo = downQueryFilter.getFilterItems().get(i);
                if (!"payBillType.isProxyPay".equals(itemInfo.getPropertyName())) continue;
                downQueryFilter.getFilterItems().remove(itemInfo);
                mask = downQueryFilter.getMaskString().replaceAll("#" + i + "\\sor", " ");
                for (j = i; j < size - 1; ++j) {
                    mask = mask.replaceAll("#" + (j + 1), "#" + j);
                }
                downQueryFilter.setMaskString(mask);
            }
            for (i = 0; i < downQueryFilterCopy.getFilterItems().size(); ++i) {
                itemInfo = downQueryFilterCopy.getFilterItems().get(i);
                if (!"payBillType.isPurPay".equals(itemInfo.getPropertyName())) continue;
                downQueryFilterCopy.getFilterItems().remove(itemInfo);
                mask = downQueryFilterCopy.getMaskString().replaceAll("or\\s#" + i, " ");
                for (j = i; j < size - 1; ++j) {
                    mask = mask.replaceAll("#" + (j + 1), "#" + j);
                }
                downQueryFilterCopy.setMaskString(mask);
            }
        }
        params.put((Object)"upQueryFilterCopy", (Object)(isAR ? upQueryFilterCopy : downQueryFilterCopy));
        params.put((Object)"downQueryFilterCopy", (Object)(isAR ? downQueryFilterCopy : upQueryFilterCopy));
        List mainList = isAR ? params.getMainList() : params.getSecList();
        List<Object> mainListCopy = new ArrayList();
        if (mainList != null) {
            List secList = isAR ? params.getSecList() : params.getMainList();
            List<Object> secListCopy = new ArrayList();
            mainListCopy = this.separateList(ctx, params, mainList, true);
            secListCopy = this.separateList(ctx, params, secList, false);
            params.put((Object)"mainListCopy", isAR ? mainListCopy : secListCopy);
            params.put((Object)"secListCopy", isAR ? secListCopy : mainListCopy);
        }
    }

    private List<WriteOffCommonInfo> separateList(Context ctx, WriteOffCommonParams params, List<WriteOffCommonInfo> list, boolean isRec) throws BOSException, EASBizException {
        int i;
        ArrayList<WriteOffCommonInfo> listCopy = new ArrayList<WriteOffCommonInfo>();
        boolean isHeadView = (Boolean)params.get((Object)"isHeadView");
        HashSet<String> idSet = new HashSet<String>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            WriteOffCommonInfo writeInfo = list.get(i2);
            if (isRec && !isHeadView) {
                idSet.add(writeInfo.getEntryId());
                continue;
            }
            idSet.add(writeInfo.getBillId());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection selCol = new SelectorItemCollection();
        if (isRec) {
            selCol.add(new SelectorItemInfo("recBillType.isProxyRec"));
        } else {
            selCol.add(new SelectorItemInfo("payBillType.isProxyPay"));
        }
        viewInfo.setSelector(selCol);
        HashMap<String, ReceivingBillEntryInfo> recBillEntryMap = new HashMap<String, ReceivingBillEntryInfo>();
        HashMap<String, ReceivingBillInfo> recMap = new HashMap<String, ReceivingBillInfo>();
        HashMap<String, PaymentBillInfo> payBillMap = new HashMap<String, PaymentBillInfo>();
        if (isRec) {
            if (isHeadView) {
                ReceivingBillCollection recBillCol = ReceivingBillFactory.getLocalInstance((Context)ctx).getReceivingBillCollection(viewInfo);
                for (i = 0; i < recBillCol.size(); ++i) {
                    ReceivingBillInfo recBillInfo = recBillCol.get(i);
                    recMap.put(recBillInfo.getId().toString(), recBillInfo);
                }
            } else {
                ReceivingBillEntryCollection recBillEntryCol = ReceivingBillEntryFactory.getLocalInstance((Context)ctx).getReceivingBillEntryCollection(viewInfo);
                for (i = 0; i < recBillEntryCol.size(); ++i) {
                    ReceivingBillEntryInfo recBillEntryInfo = recBillEntryCol.get(i);
                    recBillEntryMap.put(recBillEntryInfo.getId().toString(), recBillEntryInfo);
                }
            }
        } else {
            PaymentBillCollection payBillCol = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(viewInfo);
            for (i = 0; i < payBillCol.size(); ++i) {
                PaymentBillInfo payBillInfo = payBillCol.get(i);
                payBillMap.put(payBillInfo.getId().toString(), payBillInfo);
            }
        }
        for (WriteOffCommonInfo writeInfo : list) {
            PaymentBillInfo billInfo;
            if (isRec) {
                if (isHeadView) {
                    billInfo = (ReceivingBillInfo)recMap.get(writeInfo.getBillId());
                    if (!billInfo.getRecBillType().isIsProxyRec()) continue;
                    listCopy.add(writeInfo);
                    continue;
                }
                ReceivingBillEntryInfo entryInfo = (ReceivingBillEntryInfo)recBillEntryMap.get(writeInfo.getEntryId());
                if (!entryInfo.getRecBillType().isIsProxyRec()) continue;
                listCopy.add(writeInfo);
                continue;
            }
            billInfo = (PaymentBillInfo)payBillMap.get(writeInfo.getBillId());
            if (!billInfo.getPayBillType().isIsProxyPay()) continue;
            listCopy.add(writeInfo);
        }
        list.removeAll(listCopy);
        return listCopy;
    }
}

