/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.AccountAgeQueryParam;
import com.kingdee.eas.fi.ar.app.ArApReportHelper;
import com.kingdee.eas.fi.arap.app.AbstractAtTermRptFacadeControllerBean;
import com.kingdee.eas.fi.arap.app.util.TempTableUtil;
import com.kingdee.eas.framework.report.app.CreateTempTableResult;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AtTermRptFacadeControllerBean
extends AbstractAtTermRptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.AtTermRptFacadeControllerBean");

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTable(params.getString("tempTable"), ctx);
        String tempTable = "atTermTbl";
        String sql = this.getInsertToTempTabSql(tempTable, params, ctx);
        CreateTempTableResult createRlst = this.executeCreateTableAsSelectInto(sql, null, ctx);
        tempTable = createRlst.getTempTable();
        sql = this.getSumSql(tempTable, params, ctx);
        this.executeSQL(ctx, sql);
        sql = this.getTotalSql(tempTable, params, ctx);
        this.executeSQL(ctx, sql);
        this.updateNegativeToZeroSql(ctx, tempTable);
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        return result;
    }

    protected String getTableName() {
        return "AtTermRpt";
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            logger.debug((Object)("atTermRpt sql\r\n" + sql));
            this.executeUpdate(sql, null, ctx);
        }
    }

    private String getInsertToTempTabSql(String tempTable, RptParams params, Context ctx) throws BOSException, EASBizException {
        int iAhead;
        Timestamp calDate = Timestamp.valueOf(params.getObject("calDate").toString());
        String billTab = "t_ar_otherbill";
        String planTab = "t_ar_otherbillplan";
        if (!params.getBoolean("isAR")) {
            billTab = "t_ap_otherbill";
            planTab = "t_ap_otherbillplan";
        }
        String loc = this.getLoc(ctx);
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
        String cussAcctIdTbl = this.putAsstIntoTempTable(ctx, params);
        StringBuffer sb = new StringBuffer(1500);
        sb.append("select ");
        sb.append("company.fid as companyID,");
        sb.append("company.fname_").append(loc).append(" as companyName,");
        sb.append("currency.fid as currencyID,");
        sb.append("' ' asstActNumber,");
        sb.append("currency.fnumber as currencyNum,");
        sb.append("currency.fname_").append(loc).append(" as currencyName,");
        sb.append("asstType.fname_").append(loc).append(" as asstTypeName,");
        sb.append("\r\n bill.fasstactname_").append(loc).append(" as asstName,");
        sb.append("bill.fnumber as billNum, bill.fbilldate as billdate,");
        sb.append("\r\n admin1.fname_").append(loc).append(" as adminName,");
        sb.append("person.fname_").append(loc).append(" as personName,");
        sb.append("bill.fabstractName as billDesc,");
        sb.append("\r\n billPlan.frecievepayamount as recPayAmount,");
        sb.append("billPlan.frecievepayamount-billPlan.fverifyamount as leftAmount,");
        sb.append("\r\n billPlan.frecievepaydate as recpayDate,");
        sb.append("datediff(dd, billPlan.frecievepaydate,");
        sb.append("{").append(dtFormat.format(calDate));
        sb.append("}) as overDays, datediff(dd, {");
        sb.append(dtFormat.format(calDate));
        sb.append("},\r\n billPlan.frecievepaydate)as unOverDays,");
        sb.append("bill.fid as billID,bill.fasstactnumber as billAsstNum ");
        sb.append(", bill.FAsstActId FAsstActId, 0 FIsSumTotal");
        sb.append("\r\n into ").append(tempTable);
        sb.append("\r\n from ").append(planTab).append(" billPlan ");
        sb.append("\r\n inner join ").append(billTab).append(" bill on bill.fid = billPlan.fparentid ");
        sb.append("\r\n inner join T_ORG_Company company on bill.fcompanyid=company.fid ");
        sb.append("\r\n inner join t_bd_currency currency on bill.fcurrencyid=currency.fid ");
        sb.append("\r\n inner join T_BD_AsstActType asstType on bill.fasstacttypeid=asstType.fid ");
        sb.append("\r\n left outer join t_org_admin admin1 on bill.fadminorgunitid =  admin1.fid ");
        sb.append("\r\n left outer join t_bd_person person on bill.fpersonid = person.fid ");
        if (!StringUtils.isEmpty((String)cussAcctIdTbl)) {
            sb.append("\r\n inner join ").append(cussAcctIdTbl);
            sb.append(" asstActTbl on bill.FAsstActid = asstActTbl.FId");
        }
        sb.append("\r\n where 1=1 ");
        if (!params.getBoolean("isIncludeBizBill")) {
            sb.append(" AND bill.FIsBizBill = 0");
        }
        if (params.getString("includeNowPay") != null) {
            if ("no".equals(params.getString("includeNowPay"))) {
                sb.append(" And bill.FPaymentTypeID = '" + (params.getBoolean("isAR") ? "91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5" : "2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5") + "' ");
            } else if ("only".equals(params.getString("includeNowPay"))) {
                sb.append("And bill.FPaymentTypeID = '" + (params.getBoolean("isAR") ? "cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5" : "40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5") + "' ");
            }
        }
        if (params.getObject("billDateFrom") != null) {
            Timestamp dateFrom = Timestamp.valueOf(params.getObject("billDateFrom").toString());
            sb.append("\r\n and bill.fbillDate >= {");
            sb.append(dtFormat.format(dateFrom)).append("} ");
        }
        if (params.getObject("billDateTo") != null) {
            Timestamp dateTo = Timestamp.valueOf(params.getObject("billDateTo").toString());
            Date dateToNxt = new Date(dateTo.getTime() + 86400000L);
            sb.append(" and bill.fbillDate < {");
            sb.append(dtFormat.format(dateToNxt)).append("} ");
        }
        sb.append("\r\n and billPlan.frecievepayamount-billPlan.fverifyamount ");
        sb.append(params.getBoolean("isIncludeNegtive") ? " <> 0" : " > 0");
        if (params.getString("companyIds") != null) {
            sb.append("\r\n and bill.fcompanyid in (");
            sb.append(params.getString("companyIds")).append(")");
        } else if (params.getString("company") != null) {
            sb.append("\r\n and bill.fcompanyid = '");
            sb.append(params.getString("company")).append("'");
        }
        if (params.getString("deptFrom") != null) {
            sb.append("\r\n and admin1.fnumber >= '");
            sb.append(params.getString("deptFrom")).append("'");
        }
        if (params.getString("deptTo") != null) {
            sb.append(" and admin1.fnumber <= '");
            sb.append(params.getString("deptTo")).append("'");
        }
        if (params.getString("personFrom") != null) {
            sb.append("\r\n and person.fnumber >= '");
            sb.append(params.getString("personFrom")).append("'");
        }
        if (params.getString("personTo") != null) {
            sb.append(" and person.fnumber <= '");
            sb.append(params.getString("personTo")).append("'");
        }
        if (params.getString("billNumFrom") != null) {
            sb.append("\r\n and bill.fnumber >= '");
            sb.append(params.getString("billNumFrom")).append("'");
        }
        if (params.getString("billNumTo") != null) {
            sb.append(" and bill.fnumber <= '");
            sb.append(params.getString("billNumTo")).append("'");
        }
        if (params.getString("asstTypeId") != null) {
            sb.append("\r\n and bill.fasstacttypeid = '");
            sb.append(params.getString("asstTypeId")).append("'");
        }
        if (params.getString("currency") != null) {
            sb.append(" and bill.fcurrencyid = '");
            sb.append(params.getString("currency")).append("'");
        }
        int n = iAhead = params.getObject("aheadDays") != null ? params.getInt("aheadDays") : 0;
        if (params.getBoolean("isIncludeUndue") && iAhead > 0) {
            Date aheadNxtDate = new Date(calDate.getTime() + (long)(iAhead + 1) * 86400000L);
            sb.append("\r\n and billPlan.frecievepaydate < {");
            sb.append(dtFormat.format(aheadNxtDate)).append("}");
        } else {
            Date calNxtDate = new Date(calDate.getTime() + 86400000L);
            sb.append("\r\n and billPlan.frecievepaydate < {");
            sb.append(dtFormat.format(calNxtDate)).append("}");
        }
        sb.append("\r\n and bill.fbillStatus = ");
        sb.append(3);
        logger.debug((Object)("atTerm billSql:\r\n" + sb));
        return sb.toString();
    }

    private String putAsstIntoTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        AsstActTypeInfo asstActTypeInfo = null;
        if (params.getObject("asstType") instanceof AsstActTypeInfo) {
            asstActTypeInfo = (AsstActTypeInfo)params.getObject("asstType");
        } else if ((String)params.getObject("asstType") != null) {
            asstActTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK((String)params.getObject("asstType")));
        }
        if (asstActTypeInfo == null || asstActTypeInfo.getRealtionDataObject() == null) {
            return null;
        }
        AccountAgeQueryParam qryParam = new AccountAgeQueryParam();
        qryParam.setCussAcctTypeInfo(asstActTypeInfo);
        qryParam.setCussAcctFromNum(params.getString("asstFromNumber"));
        qryParam.setCussAcctToNum(params.getString("asstToNumber"));
        qryParam.setCompanyId(params.getString("company"));
        qryParam.setCuId(params.getString("cu"));
        qryParam.setCsspGrpId(params.getString("csspGrpId"));
        Object temp = params.getObject("asstFromIds");
        if (temp != null && temp instanceof List) {
            qryParam.setCussAcctFromIds((List)temp);
        }
        qryParam.setCussTable(asstActTypeInfo.getRealtionDataObject());
        String sql = ArApReportHelper.getCussObjsSql(ctx, qryParam);
        String tblDefine = "(FId varchar(44), FName nvarchar(400), FNumber nvarchar(80) )";
        String tmpIdsTbl = TempTableUtil.createTempTable(ctx, tblDefine);
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.createStatement();
            String insSql = "insert into " + tmpIdsTbl + " (FId, FName, FNumber)\r\n " + sql.toString();
            logger.debug((Object)(" the tmpCussAcctIds: \r\n" + insSql));
            stmt.execute(insSql);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"exception while get CussAcctIds", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
        return tmpIdsTbl;
    }

    protected String getMainTableName() {
        return "";
    }

    protected String getPlanTableName() {
        return "";
    }

    private String getTotalSql(String tempTable, RptParams params, Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer(300);
        sql.append("insert into ").append(tempTable).append("\r\n");
        sql.append("select companyId, companyName, currencyID, 'zzz' asstActNumber, currencyNum, currencyName,'");
        sql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"Lbl_Total", (Locale)ctx.getLocale())).append("',");
        sql.append("null,null,null,null,null,null,");
        sql.append("sum(recpayamount),sum(leftamount),null,0,0,null,null ");
        sql.append(", null, 2 FIsSumTotal\r\n");
        sql.append(" from ").append(tempTable).append(" \r\n");
        sql.append(" where billID is null ");
        sql.append("group by companyId,companyName,currencyID, currencyNum, currencyName");
        return sql.toString();
    }

    private String getSumSql(String tempTable, RptParams params, Context ctx) {
        StringBuffer sql = new StringBuffer(300);
        sql.append("insert into ").append(tempTable).append("\r\n");
        sql.append("select companyID,companyName,currencyID,' ' asstActNumber, currencyNum, currencyName,asstTypeName,asstName,'");
        sql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"Lbl_Sum", (Locale)ctx.getLocale())).append("',");
        sql.append("null,null,null,null,");
        sql.append("sum(recpayamount),sum(leftamount),null,0,0,null,billAsstNum ");
        sql.append(", FAsstActId, 1 FIsSumTotal\r\n");
        sql.append(" from ").append(tempTable);
        sql.append("\r\n group by companyID,companyName, currencyID, currencyNum, currencyName,");
        sql.append("billAsstNum, FAsstActId,asstTypeName,asstName");
        return sql.toString();
    }

    private void updateNegativeToZeroSql(Context ctx, String tempTable) throws BOSException {
        StringBuffer sql = new StringBuffer(90);
        sql.append("update ").append(tempTable).append(" ");
        sql.append("set unOverDays = 0 ");
        sql.append("where unOverDays <0");
        this.executeSQL(ctx, sql.toString());
        sql = new StringBuffer(90);
        sql.append("update ").append(tempTable).append(" ");
        sql.append("set overDays = 0 ");
        sql.append("where overDays <0");
        this.executeSQL(ctx, sql.toString());
    }

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return params;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        RptRowSet rs;
        String tmpTable = params.getString("tempTable");
        if (StringUtils.isEmpty((String)tmpTable)) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select companyName,currencyName, asstTypeName, billAsstNum, asstName, billNum,");
        sql.append("\r\n billdate, adminName, personName, billDesc, ");
        sql.append("\r\n recPayAmount, leftAmount, recpayDate, ");
        sql.append("\r\n overDays, unOverDays, billID ");
        sql.append("\r\n from ").append(tmpTable).append(" ");
        if (params.getString("asstActId") != null) {
            sql.append(" where FAsstActId = '");
            sql.append(params.getString("asstActId"));
            sql.append("' and currencyid = '");
            sql.append(params.getString("currency"));
            sql.append("' ");
        }
        sql.append("\r\n order by companyName,currencyNum,asstActNumber,assttypename,asstName, billAsstNum, FIsSumTotal, billDate, billNum");
        logger.debug((Object)("atTermRpt qrySql:\r\n" + sql));
        RptParams pp = new RptParams();
        if (sql != null && sql.length() > 0) {
            rs = this.executeQuery(sql.toString(), null, from, len, ctx);
            pp.setObject("rowset", (Object)rs);
        }
        if (params.getBoolean("firstLoadData")) {
            rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT COUNT(0) " + sql.substring(sql.indexOf("from"), sql.indexOf("order by"))));
            try {
                if (rs.next()) {
                    pp.setInt("totalRowCount", rs.getInt(1));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return pp;
    }

    @Override
    protected RptRowSet _getPrintGroups(Context ctx, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select asstName,FAsstActId, currencyName,currencyID,asstTypeName ");
        sql.append("from ").append(params.getString("tempTable")).append(" ");
        sql.append("where billNum is not null ");
        sql.append("group by currencyName,currencyID,FAsstActId,asstName,asstTypeName");
        logger.debug((Object)("atTermRpt asstGrpSql:\r\n" + sql));
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        return rs;
    }

    protected String getTempTableName(String desc, Context ctx) throws BOSException {
        String tbl = null;
        StringBuffer struct = new StringBuffer(300);
        struct.append("(currencyID varchar(44), ");
        struct.append(" currencyNum nvarchar(100), ");
        struct.append(" currencyName nvarchar(200), ");
        struct.append(" asstTypeName nvarchar(200), ");
        struct.append(" asstName nvarchar(400), ");
        struct.append(" billNum nvarchar(100), ");
        struct.append(" billdate dateTime, ");
        struct.append(" adminName nvarchar(200), ");
        struct.append(" personName nvarchar(200), ");
        struct.append(" billDesc nvarchar(200), ");
        struct.append(" recPayAmount decimal(28, 10) NOT NULL DEFAULT 0, ");
        struct.append(" leftAmount decimal(28, 10) NOT NULL DEFAULT 0, ");
        struct.append(" recpayDate dateTime, ");
        struct.append(" overDays int, ");
        struct.append(" unOverDays int, ");
        struct.append(" billID varchar(44), ");
        struct.append(" billAsstNum nvarchar(200))");
        tbl = TempTableUtil.createTempTable(ctx, struct.toString());
        return tbl;
    }

    protected void dropTable(String tableName, Context ctx) throws BOSException {
        try {
            TempTableUtil.releasTempTable(ctx, tableName);
        }
        catch (Exception e) {
            logger.error((Object)"can not release TmpTbl", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }
}

