/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.app.BOTRuleFilterTools;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.app.BOTAppTools;
import com.kingdee.eas.base.core.fm.EJBAccessFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.IPayRequestBill;
import com.kingdee.eas.fi.ap.PayRequestBillCollection;
import com.kingdee.eas.fi.ap.PayRequestBillFactory;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.ap.app.util.PayReqCommmonServerUtil;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.arap.app.AbstractBaseServiceFacadeControllerBean;
import com.kingdee.eas.fi.arap.app.web.BaseService;
import com.kingdee.eas.fi.arap.billValidator.app.BillValidator;
import com.kingdee.eas.fi.arap.util.ArApBillReverseHelper;
import com.kingdee.eas.fi.arap.util.ArApSelectorFactory;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BaseServiceFacadeControllerBean
extends AbstractBaseServiceFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    protected static final String DELIMIT_FH = ";";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.BaseServiceFacadeControllerBean");
    private static BOSObjectType AR_BILL_BOSTYPE = BOSObjectType.create((String)"FC910EF3");
    private static BOSObjectType AP_BILL_BOSTYPE = BOSObjectType.create((String)"48DA3A71");
    private static BOSObjectType PAY_REQ_BILL_BOSTYPE = BOSObjectType.create((String)"D001019A");
    private static BOSObjectType REC_BILL_BOSTYPE = BOSObjectType.create((String)"FA44FD5B");
    private static BOSObjectType PAY_BILL_BOSTYPE = BOSObjectType.create((String)"40284E81");

    @Override
    protected OrgUnitInfo[] _getAuthorizedBizOrgUnits(Context ctx, int orgType, String permissionItem) throws BOSException, EASBizException {
        BaseService bs = new BaseService(ctx);
        return bs.getAuthorizedBizOrgUnits(orgType, permissionItem);
    }

    @Override
    protected OrgUnitInfo[] _getOrgUnitInfosByType(Context ctx, Set keys, int orgTypeValue) throws BOSException, EASBizException {
        BaseService bs = new BaseService(ctx);
        return bs.getOrgUnitInfosByType(keys, orgTypeValue);
    }

    @Override
    protected Map<String, Object> _getContrastAccountF7(Context ctx, String companyid, int systemInt, String currencyID, String currentAccountTableID, String baseCurrencyid, String accountTableID) throws BOSException, EASBizException {
        BaseService bs = new BaseService(ctx);
        return bs.getContrastAccountF7(companyid, systemInt, currencyID, currentAccountTableID, baseCurrencyid, accountTableID);
    }

    @Override
    protected String _batchGetContrastAccountFilter(Context ctx, String[] companyids, int systemInt, String currencyID, String currentAccountTableID, String baseCurrencyid, String accountTableID) throws BOSException, EASBizException {
        BaseService bs = new BaseService(ctx);
        return bs.batchGetContrastAccountFilter(companyids, systemInt, currencyID, currentAccountTableID, baseCurrencyid, accountTableID);
    }

    @Override
    protected Map<String, Object> _getCostCenterUnit(Context ctx, String adminOrgUnitId, String companyOrgUnitId) throws BOSException, EASBizException {
        BaseService bs = new BaseService(ctx);
        return bs.getCostCenterUnit(adminOrgUnitId, companyOrgUnitId);
    }

    @Override
    protected Map<String, Object> _getMultiUnitData(Context ctx, List ids) throws BOSException, EASBizException {
        BaseService bs = new BaseService(ctx);
        return bs.getMultiUnitData(ids);
    }

    @Override
    protected String _getProjectF7Filer(Context ctx, String orgid) throws BOSException, EASBizException {
        BaseService bs = new BaseService(ctx);
        return bs.getProjectF7Filer(orgid);
    }

    @Override
    protected String _getTrackNumberF7Filer(Context ctx, String orgid, String projectid) throws BOSException, EASBizException {
        BaseService bs = new BaseService(ctx);
        return bs.getTrackNumberF7Filer(orgid, projectid);
    }

    @Override
    protected PeriodInfo _getStartPeriod(Context ctx, int system, String companyid) throws BOSException, EASBizException {
        BaseService bs = new BaseService(ctx);
        return bs.getStartPeriod(system, companyid);
    }

    @Override
    protected PeriodInfo _getEarliestStartPeriod(Context ctx, int system, String[] companyids) throws BOSException, EASBizException {
        BaseService bs = new BaseService(ctx);
        return bs.getEarliestStartPeriod(system, companyids);
    }

    @Override
    protected void _checkMappingInfoByRuleFilter(Context ctx, CoreBillBaseCollection col, BOTMappingInfo rule) throws BOSException, EASBizException {
        BOTRuleFilterTools.checkMappingInfoByRuleFilter((Context)ctx, (IObjectCollection)col, (BOTMappingInfo)rule);
    }

    @Override
    protected void _execDataFilterMultiEntry(Context ctx, CoreBillBaseCollection col, BOTMappingInfo rule) throws BOSException {
        BOTAppTools.execDataFilterMultiEntry((Context)ctx, (CoreBillBaseCollection)col, (BOTMappingInfo)rule);
    }

    @Override
    protected OrgUnitInfo[] _getAuthorizedOrgUnits(Context ctx, int orgType, String permissionItem) throws BOSException, EASBizException {
        BaseService bs = new BaseService(ctx);
        return bs.getAuthorizedOrgUnits(orgType, permissionItem);
    }

    @Override
    protected String _reCalculatePlanLockAmt(Context ctx, String beginDate, String endDate, String billNumbers, String systemEnum) throws BOSException, EASBizException {
        boolean isAr = false;
        if (null != systemEnum) {
            isAr = "0".equalsIgnoreCase(systemEnum);
        }
        String[] numArr = billNumbers.split(",");
        HashSet<String> numSet = new HashSet<String>();
        for (String num : numArr) {
            if (StringUtils.isEmpty((String)num)) continue;
            numSet.add(num);
        }
        StringBuilder selectBuilder = new StringBuilder();
        selectBuilder.append("SELECT FID");
        selectBuilder.append(" FROM T_AP_OTHERBILL");
        selectBuilder.append(" INNER JOIN (");
        selectBuilder.append(" \t\tSELECT FPARENTID");
        selectBuilder.append(" \t\t\t,sum(FLOCKAMOUNT) FLOCKAMOUNT");
        selectBuilder.append("\t\tFROM T_AP_OTHERBILLPLAN");
        selectBuilder.append("\t\tGROUP BY FPARENTID");
        selectBuilder.append("\t\t) planResult ON planResult.FPARENTID = T_AP_OTHERBILL.FID");
        selectBuilder.append(" INNER JOIN (");
        selectBuilder.append("\t\tSELECT FPARENTID");
        selectBuilder.append("\t\t\t,sum(FLOCKVERIFYAMT) FLOCKVERIFYAMT");
        selectBuilder.append("\t\tFROM T_AP_OTHERBILLENTRY");
        selectBuilder.append("\t\tGROUP BY FPARENTID");
        selectBuilder.append("\t\t) entryResult ON entryResult.FPARENTID = T_AP_OTHERBILL.FID");
        selectBuilder.append(" WHERE planResult.FLOCKAMOUNT <> entryResult.FLOCKVERIFYAMT");
        if (!StringUtils.isEmpty((String)beginDate)) {
            selectBuilder.append(" AND FBILLDATE >= TO_DATE('" + beginDate + "')");
        }
        if (!StringUtils.isEmpty((String)endDate)) {
            selectBuilder.append(" AND FBILLDATE < TO_DATE('" + endDate + "')");
        }
        if (numSet.size() > 0) {
            StringBuilder numsBuilder = new StringBuilder();
            for (String num : numSet) {
                numsBuilder.append("'").append(num).append("'").append(",");
            }
            String numStr = numsBuilder.toString().substring(0, numsBuilder.length() - 1);
            selectBuilder.append(" AND FNUMBER in (" + numStr + ")");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectBuilder.toString());
        HashSet<String> idSet = new HashSet<String>();
        try {
            String fid = null;
            while (rowSet.next()) {
                fid = rowSet.getString("FID");
                if (StringUtils.isEmpty((String)fid)) continue;
                idSet.add(fid);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ArApBillReverseHelper.reversePlanAmount(ctx, isAr, idSet);
        return "true";
    }

    @Override
    protected String _addSumEntry4Bill(Context ctx, String beginDate, String endDate, String billNumbers) throws BOSException, EASBizException {
        String[] numArr = billNumbers.split(",");
        HashSet<String> numSet = new HashSet<String>();
        for (String num : numArr) {
            if (StringUtils.isEmpty((String)num)) continue;
            numSet.add(num);
        }
        IPayRequestBill iPayRequestBill = PayRequestBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fiterInfo = new FilterInfo();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (numSet.size() > 0) {
            FilterItemInfo idFilter = new FilterItemInfo("number", numSet, CompareType.INCLUDE);
            fiterInfo.getFilterItems().add(idFilter);
        }
        try {
            if (!StringUtils.isEmpty((String)beginDate)) {
                FilterItemInfo beginDateFilter = new FilterItemInfo("bizDate", (Object)sdf.parse(beginDate), CompareType.GREATER_EQUALS);
                fiterInfo.getFilterItems().add(beginDateFilter);
            }
            if (!StringUtils.isEmpty((String)endDate)) {
                FilterItemInfo endDateFilter = new FilterItemInfo("bizDate", (Object)sdf.parse(endDate), CompareType.LESS);
                fiterInfo.getFilterItems().add(endDateFilter);
            }
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        view.setFilter(fiterInfo);
        view.setSelector(this.getPayReqSelector());
        PayRequestBillCollection PayReqCollection = iPayRequestBill.getPayRequestBillCollection(view);
        Iterator iterator = PayReqCollection.iterator();
        PayRequestBillInfo payReqInfo = null;
        while (iterator.hasNext()) {
            payReqInfo = (PayRequestBillInfo)iterator.next();
            this.handleSumEntrys(ctx, payReqInfo);
        }
        return "true";
    }

    protected SelectorItemCollection getPayReqSelector() {
        SelectorItemCollection selCol = new SelectorItemCollection();
        selCol.addObjectCollection((IObjectCollection)ArApSelectorFactory.getPayRequestBillSelector(false));
        selCol.addObjectCollection((IObjectCollection)ArApSelectorFactory.getPayRequestBillEntrySelector("entrys"));
        return selCol;
    }

    protected void handleSumEntrys(Context ctx, PayRequestBillInfo payReqInfo) throws EASBizException, BOSException {
        PayReqCommmonServerUtil.handleSumEntrys(payReqInfo);
        IPayRequestBill iPayRequestBill = PayRequestBillFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(payReqInfo.getId());
        iPayRequestBill.update((IObjectPK)pk, (CoreBaseInfo)payReqInfo);
        PayReqCommmonServerUtil.writeBackBillEntrySumID(ctx, (IObjectPK)new ObjectUuidPK(payReqInfo.getId()), iPayRequestBill);
    }

    @Override
    protected String _getCommonParamValue(Context ctx, String key) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("select FValue from T_ARAP_CommonParam ");
        sql.append(" where fnumber='").append(key).append("'");
        IRowSet rs = null;
        String val = "";
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                val = rs.getString("fvalue");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return val;
    }

    @Override
    protected Set _getSpecialNotVoucherApBill(Context ctx, String companyId, String beginDateStr, String endDateStr) throws BOSException, EASBizException {
        return CommonServerUtils.getSpecialNotVoucherApBill(ctx, companyId, beginDateStr, endDateStr);
    }

    @Override
    protected void _auditBillWithUser(Context ctx, IObjectPK billId, IObjectPK auditorId) throws BOSException, EASBizException {
        IDynamicObject iObjectInstance = DynamicObjectFactory.getLocalInstance((Context)ctx);
        if (null == billId) {
            return;
        }
        BOSObjectType type = BOSUuid.read((String)billId.toString()).getType();
        iObjectInstance.invoke(type, "audit", new Object[]{billId});
        if (null == auditorId) {
            return;
        }
        EntityObjectInfo eoi = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(type);
        String tableName = eoi.getTable().getName();
        StringBuilder updateSql = new StringBuilder(100);
        updateSql.append("update ").append(tableName);
        updateSql.append("set FAuditorID = '").append(auditorId).append("'");
        updateSql.append("where FID = '").append(billId).append("'");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    @Override
    protected IObjectPK _workflowSubmit(Context ctx, String billId) throws BOSException, EASBizException {
        if (null == billId) {
            return null;
        }
        IDynamicObject iObjectInstance = DynamicObjectFactory.getLocalInstance((Context)ctx);
        BOSObjectType type = BOSUuid.read((String)billId).getType();
        ObjectUuidPK billPK = new ObjectUuidPK(billId);
        SelectorItemCollection selector = new SelectorItemCollection();
        if (type.equals((Object)AR_BILL_BOSTYPE)) {
            selector = ArApSelectorFactory.getArOtherbillSelector(true);
        } else if (type.equals((Object)AP_BILL_BOSTYPE)) {
            selector = ArApSelectorFactory.getApOtherbillSelector(true);
        } else if (type.equals((Object)PAY_REQ_BILL_BOSTYPE)) {
            selector = ArApSelectorFactory.getPayRequestBillSelector(true);
        } else if (type.equals((Object)PAY_BILL_BOSTYPE)) {
            selector = ArApSelectorFactory.getPaymentBillFullSelector(true);
        } else if (type.equals((Object)REC_BILL_BOSTYPE)) {
            selector = ArApSelectorFactory.getReceivingBillFullSelector(true);
        } else {
            selector.add(new SelectorItemInfo("*"));
        }
        IObjectValue billInfo = iObjectInstance.getValue(type, (IObjectPK)billPK, selector);
        Object pk = iObjectInstance.invoke(type, "submit", new Object[]{billInfo});
        return (IObjectPK)pk;
    }

    @Override
    protected Date _getServerDate(Context ctx) throws BOSException {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(new Date());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    @Override
    protected Timestamp _getServerTimestamp(Context ctx) throws BOSException {
        return new Timestamp(new Date().getTime());
    }

    @Override
    protected void _workflowIgnore(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
        if (billId == null) {
            return;
        }
        String bosType = BOSUuid.read((String)billId.toString()).getType().toString();
        if ("48DA3A71".equals(bosType)) {
            com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx).ignore(billId);
        } else if ("FC910EF3".equals(bosType)) {
            OtherBillFactory.getLocalInstance(ctx).ignore(billId);
        }
    }

    protected void validateBill(Context ctx, IObjectPK billId, IObjectValue billInfo) throws BOSException, EASBizException {
        if (billId == null) {
            return;
        }
        String bosType = BOSUuid.read((String)billId.toString()).getType().toString();
        if ("48DA3A71".equals(bosType)) {
            com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx).ignore(billId);
        } else if ("FC910EF3".equals(bosType)) {
            OtherBillFactory.getLocalInstance(ctx).ignore(billId);
        }
    }

    @Override
    protected Object[] _getPreRecPayF7Value(Context ctx, String companyId, String preBillNumbers, boolean isAR) throws BOSException, EASBizException {
        Object[] objArr = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet numberSet = Sets.newHashSet((Object[])preBillNumbers.split(DELIMIT_FH));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)numberSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("bizDate");
        sic.add("amount");
        if (isAR) {
            sic.add("payerNumber");
            sic.add("payerName");
            sic.add("payerID");
        } else {
            sic.add("payeeNumber");
            sic.add("payeeName");
            sic.add("payeeID");
        }
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("entries.id");
        sic.add("entries.seq");
        sic.add("entries.lockAmt");
        sic.add("entries.lockLocAmt");
        sic.add("entries.unLockAmt");
        sic.add("entries.unLockLocAmt");
        viewInfo.setSelector(sic);
        SorterItemInfo si = new SorterItemInfo("number");
        si.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(si);
        CoreBaseCollection col = null;
        col = isAR ? ReceivingBillFactory.getLocalInstance((Context)ctx).getCollection(viewInfo) : PaymentBillFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        if (col.size() > 0) {
            objArr = new Object[col.size()];
            for (int i = 0; i < col.size(); ++i) {
                objArr[i] = col.get(i);
            }
        }
        return objArr;
    }

    @Override
    protected List _validateBillByConfig(Context ctx, IObjectValue billInfo, String orgField, String action) throws BOSException, EASBizException {
        BillValidator validator = new BillValidator(ctx, billInfo, null, orgField, action);
        validator.validateBill();
        Object res = validator.getValidateRes();
        return (List)res;
    }

    @Override
    protected Map _validateBillByConfig4List(Context ctx, Set billIdSet, String orgField, String action) throws BOSException, EASBizException {
        HashMap res = new HashMap();
        for (Object billId : billIdSet) {
            BillValidator validator = new BillValidator(ctx, null, billId.toString(), orgField, action);
            validator.validateBill();
            res.put(billId, validator.getValidateRes());
        }
        return res;
    }
}

