/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.SDSMBillBaseInfo;
import com.kingdee.eas.scm.common.SDSMBillEntryBaseInfo;
import com.kingdee.eas.scm.sd.sale.ISaleOrder;
import com.kingdee.eas.scm.sd.sale.ISaleOrderEntry;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sm.pur.IPurOrder;
import com.kingdee.eas.scm.sm.pur.IPurOrderEntry;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.sc.ISubContractOrder;
import com.kingdee.eas.scm.sm.sc.ISubContractOrderEntry;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryFactory;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryInfo;
import com.kingdee.eas.scm.sm.sc.SubContractOrderFactory;
import com.kingdee.eas.scm.sm.sc.SubContractOrderInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class InvoiceReverseHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.InvoiceReverseHelper");
    private static final BOSObjectType PURORDERENTRY_TYPE = new PurOrderEntryInfo().getBOSType();
    private static final BOSObjectType SALEORDERENTRY_TYPE = new SaleOrderEntryInfo().getBOSType();
    private static final BOSObjectType SUBORDERENTRY_TYPE = new SubContractOrderEntryInfo().getBOSType();

    private InvoiceReverseHelper() {
    }

    public static void reverseCoreBillInvoicedAmt(Context ctx, String companyId, ArApBillEntryBaseInfo srcEntryInfo, BigDecimal invoicedAmt, BillStatusEnum billStatus) throws BOSException, EASBizException {
        String coreBillEntryId = srcEntryInfo.getCoreBillEntryId();
        if (StringUtils.isEmpty((String)coreBillEntryId)) {
            return;
        }
        BOSObjectType destInvType = (BOSObjectType)srcEntryInfo.get("destInvType");
        ObjectUuidPK coreBillEntryPK = new ObjectUuidPK(coreBillEntryId);
        BOSObjectType coreEntryType = coreBillEntryPK.getObjectType();
        if (ArApConstants.APINVOICE_TYPE.equals((Object)destInvType) && PURORDERENTRY_TYPE.equals((Object)coreEntryType)) {
            InvoiceReverseHelper.reversePurOrderInvoicedAmt(ctx, companyId, (IObjectPK)coreBillEntryPK, invoicedAmt, billStatus);
        } else if (ArApConstants.APINVOICE_TYPE.equals((Object)destInvType) && SUBORDERENTRY_TYPE.equals((Object)coreEntryType)) {
            InvoiceReverseHelper.reverseSubOrderInvoicedAmt(ctx, companyId, (IObjectPK)coreBillEntryPK, invoicedAmt, billStatus);
        } else if (ArApConstants.ARINVOICE_TYPE.equals((Object)destInvType) && SALEORDERENTRY_TYPE.equals((Object)coreEntryType)) {
            InvoiceReverseHelper.reverseSaleOrderInvoicedAmt(ctx, companyId, (IObjectPK)coreBillEntryPK, invoicedAmt, billStatus);
        } else {
            String oql;
            IDynamicObject iBiz = DynamicObjectFactory.getLocalInstance((Context)ctx);
            if (!iBiz.exists(coreEntryType, oql = "select * where id = '" + coreBillEntryPK + "' ")) {
                return;
            }
            IObjectValue coreBillEntryInfo = iBiz.getValue(coreEntryType, oql);
            if (coreBillEntryInfo == null) {
                return;
            }
            if (SALEORDERENTRY_TYPE.equals((Object)coreBillEntryInfo.getBOSType()) && ArApConstants.APINVOICE_TYPE.equals((Object)destInvType) || PURORDERENTRY_TYPE.equals((Object)coreBillEntryInfo.getBOSType()) && ArApConstants.ARINVOICE_TYPE.equals((Object)destInvType)) {
                return;
            }
            String invoicedAmtFld = "totalInvoicedAmt";
            if (!coreBillEntryInfo.containsKey(invoicedAmtFld)) {
                logger.warn((Object)("the core billEntry doesnot have the " + invoicedAmtFld + " field. the writeback can not finish."));
                return;
            }
            boolean DebitadjustFlag = false;
            if (srcEntryInfo.get("fid") != null) {
                String fid = (String)srcEntryInfo.get("fid");
                StringBuffer sql = new StringBuffer();
                sql.append("select FBillType");
                if (ArApConstants.APINVOICE_TYPE.equals((Object)destInvType)) {
                    sql.append(" from t_ap_otherbill  ");
                } else {
                    sql.append(" from t_ar_otherbill ");
                }
                sql.append(" where FId = ? ");
                Connection con = null;
                Statement pstmt = null;
                IRowSet rs = null;
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{fid.toString()});
                    while (rs.next()) {
                        int FBillType = rs.getInt(1);
                        if (FBillType != 204 && FBillType != 104) continue;
                        DebitadjustFlag = true;
                    }
                }
                catch (SQLException ex) {
                    try {
                        logger.error((Object)"", (Throwable)ex);
                        throw new BOSException((Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, pstmt, con);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs, pstmt, con);
            }
            BigDecimal coreEntryInvdAmt = InvoiceReverseHelper.getCoreBillInvoicedAmt(billStatus, coreBillEntryInfo, invoicedAmt, invoicedAmtFld, DebitadjustFlag);
            coreBillEntryInfo.setBigDecimal(invoicedAmtFld, coreEntryInvdAmt.abs());
            iBiz.update(coreEntryType, (IObjectPK)coreBillEntryPK, coreBillEntryInfo);
        }
    }

    private static BigDecimal getCoreBillInvoicedAmt(BillStatusEnum billStatus, IObjectValue coreBillEntryInfo, BigDecimal invoicedAmt, String invoicedAmtFld, boolean DebitadjustFlag) {
        BigDecimal coreEntryInvdAmt = coreBillEntryInfo.getBigDecimal(invoicedAmtFld);
        BigDecimal bigDecimal = coreEntryInvdAmt = coreEntryInvdAmt == null ? SysConstant.BIGZERO : coreEntryInvdAmt;
        if (BillStatusEnum.SUBMITED.equals((Object)billStatus)) {
            coreEntryInvdAmt = !DebitadjustFlag ? coreEntryInvdAmt.abs().add(invoicedAmt.abs()) : (invoicedAmt.compareTo(SysConstant.BIGZERO) == -1 ? coreEntryInvdAmt.add(invoicedAmt) : coreEntryInvdAmt.add(SysConstant.BIGZERO.subtract(invoicedAmt)));
        } else if (BillStatusEnum.DELETED.equals((Object)billStatus)) {
            coreEntryInvdAmt = coreEntryInvdAmt.abs().subtract(invoicedAmt.abs());
        }
        return coreEntryInvdAmt;
    }

    private static void reversePurOrderInvoicedAmt(Context ctx, String companyId, IObjectPK coreBillEntryPK, BigDecimal invoicedAmt, BillStatusEnum billStatus) throws BOSException, EASBizException {
        boolean fNoCentralSameEntryComp;
        String entryOql;
        IPurOrderEntry iEntry = PurOrderEntryFactory.getLocalInstance((Context)ctx);
        if (!iEntry.exists(entryOql = "select *, parent.id, companyOrgUnit.id where id = '" + coreBillEntryPK + "' ")) {
            return;
        }
        PurOrderEntryInfo coreBillEntryInfo = iEntry.getPurOrderEntryInfo(entryOql);
        PurOrderInfo coreBillInfo = coreBillEntryInfo.getParent();
        BOSUuid billId = coreBillInfo.getId();
        String oql = "select *, companyOrgUnit.id where id = '" + billId + "' ";
        IPurOrder iBiz = PurOrderFactory.getLocalInstance((Context)ctx);
        if (!iBiz.exists(oql)) {
            return;
        }
        coreBillInfo = iBiz.getPurOrderInfo(oql);
        boolean fCentralBalSameComp = coreBillInfo.isIsCentralBalance() && coreBillInfo.getCompanyOrgUnit() != null && companyId.equals(coreBillInfo.getCompanyOrgUnit().getId().toString());
        boolean bl = fNoCentralSameEntryComp = !coreBillInfo.isIsCentralBalance() && coreBillEntryInfo.getCompanyOrgUnit() != null && companyId.equals(coreBillEntryInfo.getCompanyOrgUnit().getId().toString());
        if (!fCentralBalSameComp && !fNoCentralSameEntryComp) {
            return;
        }
        BigDecimal coreEntryInvdAmt = coreBillEntryInfo.getTotalInvoicedAmt();
        BigDecimal bigDecimal = coreEntryInvdAmt = coreEntryInvdAmt == null ? SysConstant.BIGZERO : coreEntryInvdAmt;
        if (BillStatusEnum.SUBMITED.equals((Object)billStatus)) {
            coreEntryInvdAmt = coreEntryInvdAmt.add(invoicedAmt);
        } else if (BillStatusEnum.DELETED.equals((Object)billStatus)) {
            coreEntryInvdAmt = coreEntryInvdAmt.subtract(invoicedAmt);
        }
        coreBillEntryInfo.setTotalInvoicedAmt(coreEntryInvdAmt);
        iEntry.update(coreBillEntryPK, (CoreBaseInfo)coreBillEntryInfo);
        BigDecimal billInvdAmt = coreBillInfo.getInvoicedAmount();
        BigDecimal bigDecimal2 = billInvdAmt = billInvdAmt == null ? SysConstant.BIGZERO : billInvdAmt;
        if (BillStatusEnum.SUBMITED.equals((Object)billStatus)) {
            billInvdAmt = billInvdAmt.add(invoicedAmt);
        } else if (BillStatusEnum.DELETED.equals((Object)billStatus)) {
            billInvdAmt = billInvdAmt.subtract(invoicedAmt);
        }
        coreBillInfo.setInvoicedAmount(billInvdAmt);
        coreBillInfo.getEntries().add(coreBillEntryInfo);
        iBiz.update((IObjectPK)new ObjectUuidPK(billId), (CoreBaseInfo)coreBillInfo);
    }

    private static void reverseSubOrderInvoicedAmt(Context ctx, String companyId, IObjectPK coreBillEntryPK, BigDecimal invoicedAmt, BillStatusEnum billStatus) throws BOSException, EASBizException {
        String entryOql;
        ISubContractOrderEntry iEntry = SubContractOrderEntryFactory.getLocalInstance((Context)ctx);
        if (!iEntry.exists(entryOql = "select *, parent.id, requestCompanyOrgUnit.id where id = '" + coreBillEntryPK + "' ")) {
            return;
        }
        SubContractOrderEntryInfo coreBillEntryInfo = iEntry.getSubContractOrderEntryInfo(entryOql);
        SubContractOrderInfo coreBillInfo = coreBillEntryInfo.getParent();
        String billId = coreBillInfo.getId().toString();
        String oql = "select *, companyOrgUnit.id where id = '" + billId + "' ";
        ISubContractOrder iBiz = SubContractOrderFactory.getLocalInstance((Context)ctx);
        if (!iBiz.exists(oql)) {
            return;
        }
        coreBillInfo = iBiz.getSubContractOrderInfo(oql);
        BigDecimal coreEntryInvdAmt = coreBillEntryInfo.getTotalInvoicedAmount();
        BigDecimal bigDecimal = coreEntryInvdAmt = coreEntryInvdAmt == null ? SysConstant.BIGZERO : coreEntryInvdAmt;
        if (BillStatusEnum.SUBMITED.equals((Object)billStatus)) {
            coreEntryInvdAmt = coreEntryInvdAmt.add(invoicedAmt);
        } else if (BillStatusEnum.DELETED.equals((Object)billStatus)) {
            coreEntryInvdAmt = coreEntryInvdAmt.subtract(invoicedAmt);
        }
        coreBillEntryInfo.setTotalInvoicedAmount(coreEntryInvdAmt);
        iEntry.update(coreBillEntryPK, (SDSMBillEntryBaseInfo)coreBillEntryInfo);
        BigDecimal billInvdAmt = coreBillInfo.getTotalInvoicedAmount();
        BigDecimal bigDecimal2 = billInvdAmt = billInvdAmt == null ? SysConstant.BIGZERO : billInvdAmt;
        if (BillStatusEnum.SUBMITED.equals((Object)billStatus)) {
            billInvdAmt = billInvdAmt.add(invoicedAmt);
        } else if (BillStatusEnum.DELETED.equals((Object)billStatus)) {
            billInvdAmt = billInvdAmt.subtract(invoicedAmt);
        }
        coreBillInfo.setTotalInvoicedAmount(billInvdAmt);
        iBiz.update((IObjectPK)new ObjectUuidPK(billId), (SDSMBillBaseInfo)coreBillInfo);
    }

    private static void reverseSaleOrderInvoicedAmt(Context ctx, String companyId, IObjectPK coreBillEntryPK, BigDecimal invoicedAmt, BillStatusEnum billStatus) throws BOSException, EASBizException {
        boolean fNoCentralSameEntryComp;
        String entryOql = "select *, parent.id, companyOrgUnit.id where id = '" + coreBillEntryPK + "' ";
        ISaleOrderEntry iEntry = SaleOrderEntryFactory.getLocalInstance((Context)ctx);
        if (!iEntry.exists(entryOql)) {
            return;
        }
        SaleOrderEntryInfo coreBillEntryInfo = iEntry.getSaleOrderEntryInfo(entryOql);
        SaleOrderInfo coreBillInfo = coreBillEntryInfo.getParent();
        BOSUuid billId = coreBillInfo.getId();
        String oql = "select *, companyOrgUnit.id where id = '" + billId + "' ";
        ISaleOrder iBiz = SaleOrderFactory.getLocalInstance((Context)ctx);
        if (!iBiz.exists(oql)) {
            return;
        }
        coreBillInfo = iBiz.getSaleOrderInfo(oql);
        if (coreBillInfo == null) {
            return;
        }
        boolean fCentralBalSameComp = coreBillInfo.isIsCentralBalance() && companyId.equals(coreBillInfo.getCompanyOrgUnit().getId().toString());
        boolean bl = fNoCentralSameEntryComp = !coreBillInfo.isIsCentralBalance() && companyId.equals(coreBillEntryInfo.getCompanyOrgUnit().getId().toString());
        if (!fCentralBalSameComp && !fNoCentralSameEntryComp) {
            return;
        }
        BigDecimal coreEntryInvdAmt = coreBillEntryInfo.getTotalInvoicedAmt();
        BigDecimal bigDecimal = coreEntryInvdAmt = coreEntryInvdAmt == null ? SysConstant.BIGZERO : coreEntryInvdAmt;
        if (BillStatusEnum.SUBMITED.equals((Object)billStatus)) {
            coreEntryInvdAmt = coreEntryInvdAmt.add(invoicedAmt);
        } else if (BillStatusEnum.DELETED.equals((Object)billStatus)) {
            coreEntryInvdAmt = coreEntryInvdAmt.subtract(invoicedAmt);
        }
        coreBillEntryInfo.setTotalInvoicedAmt(coreEntryInvdAmt);
        iEntry.update(coreBillEntryPK, (CoreBaseInfo)coreBillEntryInfo);
    }
}

