/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.IInvoice;
import com.kingdee.eas.fi.arap.InvoiceException;
import com.kingdee.eas.fi.arap.InvoiceInfo;
import com.kingdee.eas.fi.arap.app.InvoiceReverseHelper;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.fi.arap.util.CollectionUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class InvoiceReverser {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.InvoiceReverser");

    protected abstract String getSrcTable();

    protected abstract String getSrcEntryTable();

    protected abstract String getTable();

    protected abstract String getEntryTable();

    protected abstract IInvoice getBizInterface(Context var1) throws BOSException;

    private boolean hasVoucheredSrcBills(Context ctx, String idsCondition) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.FFivouchered from ").append(this.getSrcTable());
        sql.append(" t1\r\n inner join ").append(this.getSrcEntryTable());
        sql.append(" t2 on t1.Fid = t2.FParentid\r\n where t2.FId in (");
        sql.append("select FSourceBillEntryId from ").append(this.getEntryTable());
        sql.append(" where FParentId in (").append(idsCondition).append(") )");
        sql.append("\r\n and t1.FFiVouchered = 1");
        logger.debug((Object)("hasVoucheredSrc \r\n: " + sql));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            rs.beforeFirst();
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"has exceptions ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public void reverseBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.reverseSrcBillEntry(ctx, pk);
        this.reverseCoreBillEntry(ctx, pk);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reverseSrcBillEntry(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        block12: {
            block11: {
                sql = new StringBuffer();
                sql.append("SELECT T2.FID AS FID, T2.FACTUALAMOUNT AS FACTUALAMOUNT");
                sql.append(", T2.FQUANTITY*MU.FBASECONVSRATE AS FBASEQTY");
                sql.append(", T1.FNUMBER AS FNUMBER\r\n from ");
                sql.append(this.getEntryTable()).append(" t2 ");
                sql.append(" LEFT JOIN T_BD_MULTIMEASUREUNIT MU ON MU.FMATERIALID=T2.FMATERIALID AND MU.FMEASUREUNITID=T2.FMEASUREUNITID ");
                sql.append(" inner join ");
                sql.append(this.getTable()).append(" t1 on t1.FId = t2.FParentId");
                sql.append("\r\n where t2.FParentId = ?");
                uSql = new StringBuffer();
                uSql.append("update ").append(this.getSrcEntryTable());
                uSql.append(" set FInvoicedAmt = FInvoicedAmt + ?,");
                uSql.append(" FIsInvoiced = (case when FrecievePayAmountLocal = ");
                uSql.append("(FInvoicedAmt + ?) then 1 else 0 end)");
                uSql.append(", FInvoiceNumber = (CASE WHEN FInvoiceNumber IS NULL OR FInvoiceNumber = '' THEN ?");
                uSql.append(" ELSE ");
                uSql.append(" CASE WHEN LENGTH(FInvoiceNumber || ';' || ?) > 255 ");
                uSql.append(" THEN TO_CHAR(SUBSTRING(FInvoiceNumber || ';' || ?, 1, 255)) ELSE TO_CHAR(FInvoiceNumber || ';' || ?) END");
                uSql.append(" END)");
                uSql.append(" ,FInvoicedBaseQty=FInvoicedBaseQty+?");
                uSql.append(" where FId = ?");
                con = null;
                pstmt = null;
                pstmtQry = null;
                rs = null;
                try {
                    con = EJBFactory.getConnection((Context)ctx);
                    pstmt = con.prepareStatement(uSql.toString());
                    pstmtQry = con.prepareStatement(sql.toString());
                    pstmtQry.setString(1, pk.toString());
                    rs = pstmtQry.executeQuery();
                    fHasBill = false;
                    destEntryID = null;
                    amt = null;
                    FrecievePayAmount = null;
                    FinvoicedAmt = null;
                    canInvAmt = null;
                    iArApBillFacade = ArApBillFacadeFactory.getLocalInstance((Context)ctx);
                    while (rs.next()) {
                        destEntryID = rs.getString(1).toString();
                        amt = rs.getBigDecimal("FACTUALAMOUNT");
                        result = iArApBillFacade.getSrcEntryID(BOSUuid.read((String)destEntryID));
lbl62:
                        // 2 sources

                        while (result.next()) {
                            FrecievePayAmount = result.getBigDecimal("FRecievePayAmountLocal");
                            FinvoicedAmt = result.getBigDecimal("FinvoicedAmt");
                            canInvAmt = FrecievePayAmount.subtract(FinvoicedAmt);
                            if (amt.abs().compareTo(canInvAmt.abs()) == -1) {
                                pstmt.setBigDecimal(1, amt);
                                pstmt.setBigDecimal(2, amt);
                                pstmt.setString(3, rs.getString("FNUMBER"));
                                pstmt.setString(4, rs.getString("FNUMBER"));
                                pstmt.setString(5, rs.getString("FNUMBER"));
                                pstmt.setString(6, rs.getString("FNUMBER"));
                                pstmt.setBigDecimal(7, rs.getBigDecimal("FBASEQTY"));
                                pstmt.setString(8, result.getString("Fsrcentryid"));
                                pstmt.addBatch();
                                fHasBill = true;
                            } else if (amt.abs().compareTo(canInvAmt.abs()) == 0 || amt.abs().compareTo(canInvAmt.abs()) == 1) {
                                pstmt.setBigDecimal(1, canInvAmt);
                                pstmt.setBigDecimal(2, canInvAmt);
                                pstmt.setString(3, rs.getString("FNUMBER"));
                                pstmt.setString(4, rs.getString("FNUMBER"));
                                pstmt.setString(5, rs.getString("FNUMBER"));
                                pstmt.setString(6, rs.getString("FNUMBER"));
                                pstmt.setBigDecimal(7, rs.getBigDecimal("FBASEQTY"));
                                pstmt.setString(8, result.getString("Fsrcentryid"));
                                pstmt.addBatch();
                                fHasBill = true;
                                amt = amt.subtract(canInvAmt);
                            }
                            if (!fHasBill) {
                                break block11;
                            }
                            ** GOTO lbl-1000
                        }
                    }
                    break block12;
                }
                catch (SQLException e) {
                    try {
                        InvoiceReverser.logger.error((Object)("exception while arInvoice reverseSave, id: " + pk), (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable var17_18) {
                        SQLUtils.cleanup(pstmt);
                        SQLUtils.cleanup(rs, pstmtQry, (Connection)con);
                        throw var17_18;
                    }
                }
            }
            SQLUtils.cleanup((Statement)pstmt);
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmtQry, (Connection)con);
            return;
lbl-1000:
            // 1 sources

            {
                pstmt.executeBatch();
                ** GOTO lbl62
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmtQry, (Connection)con);
    }

    private void reverseCoreBillEntry(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t4.FId, t3.FCoreBillEntryId, t2.FActualAmount");
        sql.append(", t1.FCompanyId, t1.FId  \r\n from ");
        sql.append(this.getTable()).append(" t1 inner join ");
        sql.append(this.getEntryTable()).append(" t2 on t1.FId = t2.FParentId ");
        sql.append("inner join ").append(this.getSrcEntryTable()).append(" t3 on t2.FSourceBillEntryId = t3.FId ");
        sql.append("INNER JOIN ").append(this.getSrcTable()).append(" t4 ON t3.FParentID = t4.FID ");
        sql.append("where t1.FId = ? AND t4.FIsCoopBuild = 0");
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String coreBillEntryId = null;
        BOSObjectType destInvType = this.getBizInterface(ctx).getType();
        String companyId = null;
        BigDecimal amt = null;
        String fid = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            pstmt = con.prepareStatement(sql.toString());
            pstmt.setString(1, pk.toString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                coreBillEntryId = rs.getString(2);
                if (StringUtils.isEmpty((String)coreBillEntryId)) continue;
                fid = rs.getString(1);
                amt = rs.getBigDecimal(3);
                companyId = rs.getString(4);
                ArApBillEntryBaseInfo srcEntryInfo = new ArApBillEntryBaseInfo();
                srcEntryInfo.setCoreBillEntryId(coreBillEntryId);
                srcEntryInfo.put("destInvType", destInvType);
                srcEntryInfo.put("fid", fid);
                InvoiceReverseHelper.reverseCoreBillInvoicedAmt(ctx, companyId, srcEntryInfo, amt, BillStatusEnum.SUBMITED);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
    }

    public void blankout(Context ctx, List pkList, boolean fRecycleNum, boolean isAR) throws BOSException, EASBizException {
        if (pkList == null || pkList.size() == 0) {
            return;
        }
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        boolean isInvoiceToVoid = ArApParamHelper.isInvoiceToVoid(ctx, companyId, isAR);
        String idsCondition = CollectionUtil.ids2SqlString(pkList);
        if (this.hasVoucheredSrcBills(ctx, idsCondition) && !isInvoiceToVoid) {
            throw new InvoiceException(InvoiceException.SRCBILL_VOUCHERED);
        }
        int j = pkList.size();
        for (int i = 0; i < j; ++i) {
            String id = pkList.get(i).toString();
            this.blankoutSrcBillEntry(ctx, id);
            this.blankoutCoreBillEntry(ctx, id);
            this.removeMapping(ctx, id);
            this.updateInvoiceBlankoutFlds(ctx, id, fRecycleNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void blankoutSrcBillEntry(Context ctx, String idsCondition) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T2.FID AS FID, T2.FACTUALAMOUNT AS FACTUALAMOUNT");
        sql.append(", T1.FNUMBER AS FNUMBER, T2.FQUANTITY*MU.FBASECONVSRATE AS FBASEQTY");
        sql.append("\r\n from ");
        sql.append(this.getEntryTable()).append(" t2 ");
        sql.append(" LEFT JOIN T_BD_MULTIMEASUREUNIT MU ON MU.FMATERIALID=T2.FMATERIALID AND MU.FMEASUREUNITID=T2.FMEASUREUNITID ");
        sql.append(" inner join ");
        sql.append(this.getTable()).append(" t1 on t1.FId = t2.FParentId");
        sql.append("\r\n where t2.FParentId = '" + idsCondition + "'");
        sql.append(" and t1.FBillStatus = ");
        sql.append(2);
        StringBuffer uSql = new StringBuffer();
        uSql.append("update ").append(this.getSrcEntryTable());
        uSql.append(" set FInvoicedAmt = FInvoicedAmt - ?,");
        uSql.append(" FIsInvoiced = (case when FRecievepayamount = ");
        uSql.append("(FInvoicedAmt - ?) then 1 else 0 end)");
        uSql.append(", FInvoiceNumber = ?");
        uSql.append(" ,FInvoicedBaseQty=FInvoicedBaseQty-?");
        uSql.append(" where FId = ?");
        Connection con = null;
        Statement stmt = null;
        Statement stmt1 = null;
        Statement pstmt = null;
        IRowSet rs = null;
        IRowSet rs1 = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            logger.debug((Object)("blankoutSrcBillEntry sql\r\n" + sql));
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            logger.debug((Object)("blankoutSrcBillEntry update sql\r\n" + uSql));
            boolean fHasBill = false;
            String destEntryID = null;
            BigDecimal amt = null;
            BigDecimal qty = null;
            BigDecimal FinvoicedAmt = null;
            IArApBillFacade iArApBillFacade = ArApBillFacadeFactory.getLocalInstance((Context)ctx);
            while (true) {
                Object[] params;
                ArrayList<Object[]> paramsList;
                IRowSet result;
                StringBuffer oldInvoiceNumber;
                StringBuffer botpSql;
                if (rs.next()) {
                    destEntryID = rs.getString(1);
                    amt = rs.getBigDecimal(2);
                    qty = rs.getBigDecimal(4);
                    botpSql = new StringBuffer("");
                    oldInvoiceNumber = new StringBuffer("");
                    result = iArApBillFacade.getSrcEntryID(BOSUuid.read((String)destEntryID));
                    paramsList = new ArrayList<Object[]>();
                    params = null;
                } else {
                    if (!fHasBill) {
                        SQLUtils.cleanup(pstmt);
                        SQLUtils.cleanup((ResultSet)rs, stmt);
                        SQLUtils.cleanup(rs1, stmt1, (Connection)con);
                        return;
                    }
                    SQLUtils.cleanup(pstmt);
                    SQLUtils.cleanup((ResultSet)rs, stmt);
                    SQLUtils.cleanup(rs1, stmt1, (Connection)con);
                    return;
                }
                while (result.next()) {
                    String srcentryid = result.getString("Fsrcentryid");
                    botpSql.setLength(0);
                    oldInvoiceNumber.setLength(0);
                    botpSql.append("select invoice.fnumber fnumber from ");
                    botpSql.append(this.getTable()).append(" invoice \r\n inner join ");
                    botpSql.append(this.getEntryTable()).append(" entry ");
                    botpSql.append(" on invoice.FId = entry.FParentId\r\n inner join ");
                    botpSql.append(this.getSrcEntryTable()).append(" other on entry.fsourcebillentryid = other.fid \r\n ");
                    botpSql.append("where other.fid = '").append(srcentryid).append("'");
                    botpSql.append(" and entry.FID != '").append(destEntryID).append("'");
                    botpSql.append(" and invoice.FBillStatus != 4 and invoice.FBillStatus != 1");
                    botpSql.append(" order by invoice.FBillDate");
                    rs1 = DbUtil.executeQuery((Context)ctx, (String)botpSql.toString());
                    while (rs1.next()) {
                        oldInvoiceNumber = oldInvoiceNumber.append(rs1.getString("fnumber")).append(";");
                    }
                    if (oldInvoiceNumber.length() > 0) {
                        oldInvoiceNumber.deleteCharAt(oldInvoiceNumber.length() - 1);
                    }
                    if ((FinvoicedAmt = result.getBigDecimal("FinvoicedAmt")).abs().compareTo(amt.abs()) == -1) {
                        params = new Object[]{FinvoicedAmt, FinvoicedAmt, oldInvoiceNumber.toString(), qty, result.getString("Fsrcentryid")};
                        paramsList.add(params);
                        fHasBill = true;
                        amt = amt.subtract(FinvoicedAmt);
                        continue;
                    }
                    params = new Object[]{amt, amt, oldInvoiceNumber.toString(), qty, result.getString("Fsrcentryid")};
                    paramsList.add(params);
                    fHasBill = true;
                }
                DbUtil.executeBatch((Context)ctx, (String)uSql.toString(), paramsList);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("exception while arInvoice blankout, ids: " + idsCondition), (Throwable)e);
            throw new BOSException((Throwable)e);
            catch (EASBizException e2) {
                logger.error((Object)e2);
                return;
            }
            catch (UuidException e3) {
                logger.error((Object)e3);
                return;
            }
        }
        finally {
            SQLUtils.cleanup(pstmt);
            SQLUtils.cleanup(rs, stmt);
            SQLUtils.cleanup(rs1, stmt1, (Connection)con);
        }
    }

    private void blankoutCoreBillEntry(Context ctx, String idsCondition) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t3.FId, t3.FCoreBillEntryId, t2.FActualAmount");
        sql.append(", t1.FCompanyId, t1.FId ");
        sql.append("\r\n from ").append(this.getTable()).append(" t1 inner join ");
        sql.append(this.getEntryTable()).append(" t2 on t1.FId = t2.FParentId ");
        sql.append("inner join ").append(this.getSrcEntryTable()).append(" t3 on t2.FSourceBillEntryId = t3.FId ");
        sql.append("INNER JOIN ").append(this.getSrcTable()).append(" t4 ON t3.FParentID = t4.FID ");
        sql.append("where t1.FId ='").append(idsCondition).append("' and t1.FBillStatus = ");
        sql.append(2).append(" AND t4.FIsCoopBuild = 0");
        Connection con = null;
        Statement pstmt = null;
        IRowSet rs = null;
        String companyId = null;
        String coreBillEntryId = null;
        BOSObjectType destInvType = this.getBizInterface(ctx).getType();
        try {
            BigDecimal amt = null;
            logger.debug((Object)("blankout coreBillEntry sql:\r\n" + sql));
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                coreBillEntryId = rs.getString(2);
                if (StringUtils.isEmpty((String)coreBillEntryId)) continue;
                amt = rs.getBigDecimal(3);
                companyId = rs.getString(4);
                ArApBillEntryBaseInfo srcEntryInfo = new ArApBillEntryBaseInfo();
                srcEntryInfo.setCoreBillEntryId(coreBillEntryId);
                srcEntryInfo.put("destInvType", destInvType);
                InvoiceReverseHelper.reverseCoreBillInvoicedAmt(ctx, companyId, srcEntryInfo, amt, BillStatusEnum.DELETED);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"Exception: update the invoicedamt of the corebillEntry", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, pstmt, con);
    }

    private void removeMapping(Context ctx, String idsCondition) throws BOSException {
        String delSql = "delete t_bot_relationEntry where FDestObjectId ='" + idsCondition + "'";
        DbUtil.execute((Context)ctx, (String)delSql);
        delSql = "delete t_bot_relation where FDestObjectId ='" + idsCondition + "'";
        DbUtil.execute((Context)ctx, (String)delSql);
    }

    private void updateInvoiceBlankoutFlds(Context ctx, String idsCondition, boolean fRecycleNum) throws BOSException, EASBizException {
        this.recycleNumberUpdateStatus(ctx, idsCondition, fRecycleNum);
    }

    private void recycleNumberUpdateStatus(Context ctx, String idsCondition, boolean fRecycleNum) throws BOSException, EASBizException {
        IInvoice iInv = this.getBizInterface(ctx);
        CoreBaseCollection invs = iInv.getCollection("select * where id ='" + idsCondition + "' and billStatus = " + 2);
        ICodingRuleManager iCodingRuleMgr = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        for (InvoiceInfo billInfo : invs) {
            if (fRecycleNum) {
                String companyId = billInfo.getCompany().getId().toString();
                if (iCodingRuleMgr.isExist((IObjectValue)billInfo, companyId, "type")) {
                    iCodingRuleMgr.recycleNumber((IObjectValue)billInfo, companyId, "type", null, billInfo.getNumber());
                }
                String sign = this.getBlankoutSign(ctx, billInfo);
                billInfo.setNumber(billInfo.getNumber() + sign);
            }
            billInfo.setBillStatus(BillStatusEnum.DELETED);
        }
        iInv.update(invs);
    }

    private String getBlankoutSign(Context ctx, InvoiceInfo billInfo) throws BOSException {
        StringBuffer sign = new StringBuffer();
        sign.append("-").append("*");
        StringBuffer sql = new StringBuffer();
        sql.append("select FNumber from ").append(this.getTable());
        sql.append(" where FNumber like ? and FBillStatus = ");
        sql.append(-1);
        sql.append(" and FControlunitId = ?");
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            pstmt = con.prepareStatement(sql.toString());
            pstmt.setString(1, billInfo.getNumber() + "-%" + "*");
            pstmt.setString(2, billInfo.getCU().getId().toString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                sign.append("*");
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"query exception ....", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return sign.toString();
    }
}

