/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ap.ApInvoiceFactory;
import com.kingdee.eas.fi.ap.IApInvoice;
import com.kingdee.eas.fi.ar.ArInvoiceFactory;
import com.kingdee.eas.fi.ar.ArInvoiceInfo;
import com.kingdee.eas.fi.ar.IArInvoice;
import com.kingdee.eas.fi.arap.InvoiceEntryInfo;
import com.kingdee.eas.fi.arap.InvoiceException;
import com.kingdee.eas.fi.arap.InvoiceInfo;
import com.kingdee.eas.fi.arap.InvoiceTypeEnum;
import com.kingdee.eas.fi.arap.SrcBillAutoInvHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Locale;

public class InvoiceValidator {
    private InvoiceValidator() {
    }

    public static void checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean fAddViewBreak;
        if (model == null) {
            throw new InvoiceException(InvoiceException.INFO_NULL);
        }
        InvoiceInfo invInfo = (InvoiceInfo)model;
        boolean fNullNumber = StringUtils.isEmpty((String)invInfo.getNumber());
        String companyId = invInfo.getCompany().getId().toString();
        ICodingRuleManager iCodingMgr = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo codingRuleInfo = iCodingMgr.getCodingRule((IObjectValue)invInfo, companyId, "type");
        boolean fAutoNumber = codingRuleInfo != null;
        boolean bl = fAddViewBreak = fAutoNumber && codingRuleInfo.isIsaddnewbreak();
        if (!fNullNumber && !fAddViewBreak) {
            if (InvoiceValidator.hasSameNumber(ctx, invInfo, invInfo.getNumber())) {
                throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{invInfo.getNumber(), ""});
            }
            return;
        }
        if (!fAutoNumber && fNullNumber) {
            String infoId = invInfo.getId() != null ? invInfo.getId().toString() : BOSUuid.create((BOSObjectType)invInfo.getBOSType()).toString();
            invInfo.setNumber("AutoNumberFromBTP_" + infoId);
            return;
        }
        if (!fAutoNumber && fNullNumber) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"number"});
        }
        if (fAutoNumber && fNullNumber || fAddViewBreak) {
            String number = iCodingMgr.getNumber((IObjectValue)invInfo, codingRuleInfo);
            while (InvoiceValidator.hasSameNumber(ctx, invInfo, number)) {
                number = iCodingMgr.getNumber((IObjectValue)invInfo, codingRuleInfo);
            }
            invInfo.setNumber(number);
        }
    }

    private static boolean hasSameNumber(Context ctx, InvoiceInfo model, String number) throws BOSException, EASBizException {
        String cuId = model.getCU() != null ? model.getCU().getId().toString() : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String oql = "select id where number = '" + number + "' and CU.id = '" + cuId + "' and type = " + model.getType().getValue();
        if (model.getId() != null) {
            oql = oql + " and id != '" + model.getId() + "'";
        }
        if (model instanceof ArInvoiceInfo) {
            IArInvoice iArInv = ArInvoiceFactory.getLocalInstance(ctx);
            return iArInv.exists(oql);
        }
        IApInvoice iApInv = ApInvoiceFactory.getLocalInstance(ctx);
        return iApInv.exists(oql);
    }

    public static void checkValid(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BigDecimal taxRate;
        if (model == null) {
            throw new InvoiceException(InvoiceException.INFO_NULL);
        }
        IObjectCollection entries = (IObjectCollection)model.get("entries");
        if (entries == null || entries.size() == 0) {
            throw new InvoiceException(InvoiceException.ENTRY_NULL);
        }
        InvoiceInfo invInfo = (InvoiceInfo)model;
        boolean isNotCreatedByElev = true;
        if (model instanceof InvoiceInfo) {
            boolean bl = isNotCreatedByElev = !((InvoiceInfo)model).isIsCreatedByElev();
        }
        if (isNotCreatedByElev && StringUtils.isEmpty((String)invInfo.getAsstActID())) {
            throw new InvoiceException(InvoiceException.ASSTACT_NULL);
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entityInfo = loader.getEntity(model.getBOSType());
        InvoiceValidator.checkFldNull(ctx, model, entityInfo, "type");
        if (!InvoiceTypeEnum.GENERAL.equals((Object)invInfo.getType()) && !InvoiceTypeEnum.VAT.equals((Object)invInfo.getType())) {
            throw new InvoiceException(InvoiceException.TYPE_WRONG);
        }
        SrcBillAutoInvHelper.setInvoiceInfoFields(ctx, invInfo);
        String[] billFlds = null;
        String[] entryFlds = null;
        if (InvoiceTypeEnum.GENERAL.equals((Object)invInfo.getType())) {
            billFlds = new String[]{"company", "billDate", "currency", "asstActType", "drawer", "auditPerson", "totalAmount"};
            entryFlds = new String[]{"material,expenseItem", "measureUnit", "quantity", "unitPrice", "amount", "actualAmount"};
        } else {
            billFlds = new String[]{"company", "billDate", "currency", "asstActType", "taxRegisterNo", "drawer", "auditPerson", "totalAmount"};
            entryFlds = new String[]{"material,expenseItem", "measureUnit", "quantity", "unitPrice", "amount", "taxRate", "taxAmount", "actualAmount"};
        }
        int n = billFlds.length;
        for (int i = 0; i < n; ++i) {
            InvoiceValidator.checkFldNull(ctx, model, entityInfo, billFlds[i]);
        }
        InvoiceEntryInfo invEntry = null;
        entityInfo = null;
        int m = entryFlds.length;
        BigDecimal preTaxRate = taxRate = SysConstant.BIGZERO;
        int n2 = entries.size();
        for (int i = 0; i < n2; ++i) {
            invEntry = (InvoiceEntryInfo)entries.getObject(i);
            taxRate = invEntry.getTaxRate();
            BigDecimal bigDecimal = taxRate = taxRate == null ? SysConstant.BIGZERO : taxRate;
            if (i > 0 && preTaxRate.compareTo(taxRate) != 0) {
                throw new InvoiceException(InvoiceException.TAXRATE_DIFF);
            }
            if (entityInfo == null) {
                entityInfo = loader.getEntity(invEntry.getBOSType());
            }
            for (int j = 0; j < m; ++j) {
                InvoiceValidator.checkFldNull(ctx, (IObjectValue)invEntry, entityInfo, entryFlds[j]);
            }
            if (invEntry.getMaterial() != null && invEntry.getExpenseItem() != null) {
                throw new InvoiceException(InvoiceException.MATERIALEXPENSEITEMNOTEXIST);
            }
            preTaxRate = invEntry.getTaxRate();
            preTaxRate = preTaxRate == null ? SysConstant.BIGZERO : preTaxRate;
        }
    }

    private static void checkFldNull(Context ctx, IObjectValue model, EntityObjectInfo entityInfo, String fld) throws BOSException, EASBizException {
        Locale locale = ctx.getLocale();
        String materialStr = "material";
        String expenseItemStr = "expenseItem";
        String measureUnitStr = "measureUnit";
        boolean isCreatedByElev = false;
        if (model instanceof InvoiceInfo) {
            isCreatedByElev = ((InvoiceInfo)model).isIsCreatedByElev();
        }
        if (fld.indexOf(",") > 0) {
            String[] fldArr = fld.split(",");
            StringBuffer aliasStr = new StringBuffer();
            boolean fNull = true;
            for (int i = 0; i < fldArr.length; ++i) {
                fNull = fNull && model.get(fldArr[i]) == null;
                aliasStr.append(i > 0 ? ", " : "");
                aliasStr.append(entityInfo.getPropertyByName(fldArr[i]).getAlias(locale));
            }
            if (fNull) {
                return;
            }
        } else if (model.get(fld) == null) {
            if (measureUnitStr.equals(fld) && model.get(materialStr) == null && model.get(expenseItemStr) != null) {
                return;
            }
            PropertyInfo propInfo = entityInfo.getPropertyByName(fld);
            return;
        }
    }
}

